use utf8;

package SemanticWeb::Schema::Corporation;

# ABSTRACT: Organization: A business corporation.

use v5.14;
use Moo;

extends qw/ SemanticWeb::Schema::Organization /;


use MooX::JSON_LD 'Corporation';
use Ref::Util qw/ is_plain_hashref /;
# RECOMMEND PREREQ: Ref::Util::XS

use namespace::autoclean;

our $VERSION = 'v22.0.0';


has ticker_symbol => (
    is        => 'rw',
    predicate => '_has_ticker_symbol',
    json_ld   => 'tickerSymbol',
);





1;

__END__

=pod

=encoding UTF-8

=head1 NAME

SemanticWeb::Schema::Corporation - Organization: A business corporation.

=head1 VERSION

version v22.0.0

=head1 DESCRIPTION

Organization: A business corporation.

=head1 ATTRIBUTES

=head2 C<ticker_symbol>

C<tickerSymbol>

The exchange traded instrument associated with a Corporation object. The
tickerSymbol is expressed as an exchange and an instrument name separated
by a space character. For the exchange component of the tickerSymbol
attribute, we recommend using the controlled vocabulary of Market
Identifier Codes (MIC) specified in ISO 15022.

A ticker_symbol should be one of the following types:

=over

=item C<Str>

=back

=head2 C<_has_ticker_symbol>

A predicate for the L</ticker_symbol> attribute.

=head1 SEE ALSO

L<SemanticWeb::Schema::Organization>

=head1 SOURCE

The development version is on github at L<https://github.com/robrwo/SemanticWeb-Schema>
and may be cloned from L<git://github.com/robrwo/SemanticWeb-Schema.git>

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website
L<https://github.com/robrwo/SemanticWeb-Schema/issues>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

Robert Rothenberg <rrwo@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2018-2023 by Robert Rothenberg.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
