use utf8;

package SemanticWeb::Schema::ChemicalSubstance;

# ABSTRACT: A chemical substance is 'a portion of matter of constant composition

use v5.14;
use Moo;

extends qw/ SemanticWeb::Schema::BioChemEntity /;


use MooX::JSON_LD 'ChemicalSubstance';
use Ref::Util qw/ is_plain_hashref /;
# RECOMMEND PREREQ: Ref::Util::XS

use namespace::autoclean;

our $VERSION = 'v21.0.0';


has chemical_composition => (
    is        => 'rw',
    predicate => '_has_chemical_composition',
    json_ld   => 'chemicalComposition',
);



has chemical_role => (
    is        => 'rw',
    predicate => '_has_chemical_role',
    json_ld   => 'chemicalRole',
);



has potential_use => (
    is        => 'rw',
    predicate => '_has_potential_use',
    json_ld   => 'potentialUse',
);





1;

__END__

=pod

=encoding UTF-8

=head1 NAME

SemanticWeb::Schema::ChemicalSubstance - A chemical substance is 'a portion of matter of constant composition

=head1 VERSION

version v21.0.0

=head1 DESCRIPTION

A chemical substance is 'a portion of matter of constant composition,
composed of molecular entities of the same type or of different types'
(source:
[ChEBI:59999](https://www.ebi.ac.uk/chebi/searchId.do?chebiId=59999)).

=head1 ATTRIBUTES

=head2 C<chemical_composition>

C<chemicalComposition>

The chemical composition describes the identity and relative ratio of the
chemical elements that make up the substance.

A chemical_composition should be one of the following types:

=over

=item C<Str>

=back

=head2 C<_has_chemical_composition>

A predicate for the L</chemical_composition> attribute.

=head2 C<chemical_role>

C<chemicalRole>

A role played by the BioChemEntity within a chemical context.

A chemical_role should be one of the following types:

=over

=item C<InstanceOf['SemanticWeb::Schema::DefinedTerm']>

=back

=head2 C<_has_chemical_role>

A predicate for the L</chemical_role> attribute.

=head2 C<potential_use>

C<potentialUse>

Intended use of the BioChemEntity by humans.

A potential_use should be one of the following types:

=over

=item C<InstanceOf['SemanticWeb::Schema::DefinedTerm']>

=back

=head2 C<_has_potential_use>

A predicate for the L</potential_use> attribute.

=head1 SEE ALSO

L<SemanticWeb::Schema::BioChemEntity>

=head1 SOURCE

The development version is on github at L<https://github.com/robrwo/SemanticWeb-Schema>
and may be cloned from L<git://github.com/robrwo/SemanticWeb-Schema.git>

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website
L<https://github.com/robrwo/SemanticWeb-Schema/issues>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

Robert Rothenberg <rrwo@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2018-2022 by Robert Rothenberg.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
