use utf8;

package SemanticWeb::Schema::DeliveryMethod;

# ABSTRACT: A delivery method is a standardized procedure for transferring the product or service to the destination of fulfillment chosen by the customer

use Moo;

extends qw/ SemanticWeb::Schema::Enumeration /;


use MooX::JSON_LD 'DeliveryMethod';
use Ref::Util qw/ is_plain_hashref /;
# RECOMMEND PREREQ: Ref::Util::XS

use namespace::autoclean;

our $VERSION = 'v11.0.0';




1;

__END__

=pod

=encoding UTF-8

=head1 NAME

SemanticWeb::Schema::DeliveryMethod - A delivery method is a standardized procedure for transferring the product or service to the destination of fulfillment chosen by the customer

=head1 VERSION

version v11.0.0

=head1 DESCRIPTION

A delivery method is a standardized procedure for transferring the product
or service to the destination of fulfillment chosen by the customer.
Delivery methods are characterized by the means of transportation used, and
by the organization or group that is the contracting party for the sending
organization or person.\n\nCommonly used values:\n\n*
http://purl.org/goodrelations/v1#DeliveryModeDirectDownload\n*
http://purl.org/goodrelations/v1#DeliveryModeFreight\n*
http://purl.org/goodrelations/v1#DeliveryModeMail\n*
http://purl.org/goodrelations/v1#DeliveryModeOwnFleet\n*
http://purl.org/goodrelations/v1#DeliveryModePickUp\n*
http://purl.org/goodrelations/v1#DHL\n*
http://purl.org/goodrelations/v1#FederalExpress\n*
http://purl.org/goodrelations/v1#UPS 

=head1 SEE ALSO

L<SemanticWeb::Schema::Enumeration>

=head1 SOURCE

The development version is on github at L<https://github.com/robrwo/SemanticWeb-Schema>
and may be cloned from L<git://github.com/robrwo/SemanticWeb-Schema.git>

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website
L<https://github.com/robrwo/SemanticWeb-Schema/issues>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

Robert Rothenberg <rrwo@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2018-2020 by Robert Rothenberg.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
