#!/usr/bin/perl

use strict;
use warnings;
no warnings 'syntax';

use lib ".";

use Regex::Common;
use Test::More;
use t::zip::Zip;

my $r = eval "require Test::Regexp; 1";

unless ($r) {
    print "1..0 # SKIP Test::Regexp not found\n";
    exit;
}

test_zips
  country => "France",
  name    => "French zip codes",
  prefix  => {
    iso     => "FR",
    cept    => "F",
    invalid => "ES",
  },
  prefix_test_set => [ 19000, 57480 ],
  ;

done_testing;

sub valid_zip_codes {
    map { sprintf "%05d" => $_ }

      1000 .. 1020, 1059 .. 1061, 1069, 1090, 1100 .. 1112,
      1115 .. 1117, 1120 .. 1130, 1140, 1150 .. 1155,
      1158, 1160, 1170 .. 1174, 1190, 1200 .. 1204,
      1206, 1208, 1210 .. 1213, 1216 .. 1217, 1220, 1230,
      1240, 1250, 1260, 1270, 1280, 1290, 1300 .. 1303,
      1306, 1310, 1320, 1330, 1340, 1350, 1360,
      1365 .. 1366, 1369 .. 1370, 1380, 1390, 1400, 1410,
      1420, 1430, 1440 .. 1443, 1450, 1460, 1470, 1480,
      1500 .. 1506, 1508, 1510, 1540, 1550, 1560, 1570,
      1580, 1590, 1600 .. 1604, 1606, 1630, 1632 .. 1633,
      1637 .. 1638, 1640, 1660, 1680, 1700 .. 1708,
      1710, 1750, 1800, 1851, 1921, 1960, 1990,
      2000 .. 2020, 2025, 2100 .. 2110, 2120, 2130,
      2140, 2150 .. 2151, 2160, 2170, 2190,
      2200 .. 2210, 2220, 2230, 2240, 2250, 2260, 2270,
      2290, 2300 .. 2303, 2309 .. 2310, 2314 .. 2315,
      2320 .. 2327, 2329 .. 2331, 2340, 2350, 2360, 2370,
      2380, 2390, 2400 .. 2407, 2409 .. 2410, 2420, 2430,
      2440, 2450, 2460, 2470, 2480, 2490, 2500, 2510,
      2520, 2540, 2550, 2570, 2580, 2590, 2600 .. 2604,
      2609 .. 2610, 2620, 2630, 2640, 2650, 2670, 2680,
      2690, 2700, 2720, 2760, 2790, 2800, 2810, 2820,
      2830, 2840, 2850, 2860, 2870, 2880, 2930, 2939,
      3000, 3003 .. 3008, 3010 .. 3019, 3021,
      3100 .. 3110, 3120, 3130, 3140, 3150, 3160, 3170,
      3190, 3200 .. 3210, 3220, 3230, 3240, 3250,
      3260, 3270, 3290, 3300 .. 3307, 3309 .. 3311,
      3314 .. 3315, 3319 .. 3321, 3329 .. 3330, 3340, 3350,
      3360, 3370, 3380, 3390, 3400 .. 3403, 3405 .. 3406,
      3409 .. 3410, 3420, 3430, 3440, 3450, 3452, 3460,
      3470, 3500, 3510, 3600, 3630, 3700, 3800,
      4000 .. 4006, 4009 .. 4019, 4029, 4100 .. 4107,
      4110, 4119 .. 4120, 4130, 4140, 4150, 4160,
      4170, 4180, 4190, 4200 .. 4203, 4209 .. 4210,
      4220, 4230, 4240, 4250, 4260, 4270, 4280, 4290,
      4300 .. 4301, 4310, 4320, 4330, 4340, 4350, 4360,
      4370, 4380, 4400, 4410, 4420, 4500, 4510, 4530,
      4600, 4660, 4700, 4800, 4850, 4860, 4870, 4990,
      4995, 5000 .. 5008, 5010 .. 5012, 5014 .. 5016,
      5019, 5100 .. 5105, 5107, 5110, 5120, 5130,
      5140, 5150, 5160, 5170, 5190, 5200 .. 5202,
      5208 .. 5209, 5220, 5230, 5240, 5250, 5260, 5290,
      5300, 5310, 5320, 5330, 5340, 5350, 5380, 5400,
      5460, 5470, 5480, 5500, 5560, 5600, 5700, 5800,
      6000 .. 6013, 6016, 6032 .. 6036, 6044 .. 6050,
      6053, 6071, 6073, 6078 .. 6079, 6082 .. 6085,
      6099 .. 6103, 6105 .. 6110, 6113 .. 6117, 6119, 6121,
      6125 .. 6126, 6130 .. 6133, 6135 .. 6137, 6139 .. 6143,
      6150 .. 6157, 6160 .. 6162, 6164, 6167, 6170 .. 6173,
      6175, 6177, 6180 .. 6187, 6189 .. 6190, 6200 .. 6206,
      6209 .. 6212, 6220 .. 6242, 6250 .. 6255, 6257,
      6259 .. 6260, 6270 .. 6272, 6281 .. 6284, 6286 .. 6290,
      6292 .. 6295, 6299 .. 6306, 6309 .. 6310, 6320, 6330,
      6340 .. 6345, 6348 .. 6349, 6352 .. 6354, 6357 .. 6360,
      6364, 6369 .. 6373, 6376, 6379 .. 6380,
      6390 .. 6392, 6400 .. 6408, 6410, 6414, 6420, 6430,
      6440, 6450, 6460, 6470, 6480, 6500 .. 6508,
      6510 .. 6511, 6513 .. 6518, 6520, 6530 .. 6532,
      6534 .. 6535, 6540, 6550, 6560, 6570, 6580, 6590,
      6600 .. 6607, 6609 .. 6610, 6620, 6631 .. 6634,
      6640, 6650, 6660, 6666, 6670, 6690, 6700 .. 6706,
      6708 .. 6710, 6721, 6723, 6730, 6740, 6750, 6790,
      6800 .. 6806, 6808, 6810, 6825 .. 6826, 6829 .. 6831,
      6833, 6850, 6891, 6901 .. 6906, 6909 .. 6910,
      6912 .. 6915, 6921 .. 6922, 6925, 6928 .. 6929,
      6950, 6999 .. 7007, 7100 .. 7110, 7120,
      7130 .. 7140, 7150, 7160, 7170, 7190, 7200 .. 7210,
      7220, 7230, 7240, 7250, 7260, 7270, 7290,
      7300 .. 7310, 7320, 7330, 7340, 7350, 7360, 7370,
      7380, 7400 .. 7410, 7430, 7440, 7450, 7460,
      7470, 7500 .. 7510, 7520, 7530, 7560, 7570,
      7580, 7590, 7600, 7610, 7630, 7660, 7690, 7700,
      7790, 7800, 8000 .. 8006, 8010 .. 8011, 8013 .. 8014,
      8090, 8098 .. 8099, 8101 .. 8107, 8109 .. 8110,
      8120, 8130, 8140, 8150, 8160, 8170, 8190,
      8200 .. 8210, 8220, 8230, 8240, 8250, 8260, 8270,
      8290, 8300, 8302 .. 8305, 8310, 8320, 8330, 8350,
      8360, 8370, 8380, 8390, 8400, 8410, 8430, 8440,
      8450, 8460, 8500, 8600, 8700, 8800, 9000 .. 9004,
      9007 .. 9009, 9014 .. 9017, 9100 .. 9105, 9109 .. 9110,
      9120, 9130, 9140, 9160, 9190, 9200 .. 9201,
      9209 .. 9210, 9220, 9230, 9240, 9250, 9270, 9290,
      9300 .. 9301, 9310, 9320, 9330, 9340, 9350, 9390,
      9400 .. 9401, 9420, 9460, 9500, 9600, 9700, 9800,

      10000 .. 10015, 10018, 10025 .. 10026, 10030 .. 10032,
      10042, 10080 .. 10081, 10088 .. 10089, 10091 .. 10092,
      10096, 10100 .. 10105, 10110, 10120 .. 10122,
      10128, 10130, 10140, 10150 .. 10154, 10160, 10170,
      10180, 10190, 10200 .. 10202, 10208, 10210, 10220, 10230,
      10240, 10250, 10260, 10270, 10280, 10290, 10300, 10310,
      10320, 10330, 10340, 10350 .. 10353, 10355, 10360,
      10370 .. 10371, 10380, 10390, 10400 .. 10404, 10410, 10420,
      10430 .. 10433, 10440, 10450, 10500, 10510, 10600 .. 10603,
      10605 .. 10606, 10700, 10800, 10901 .. 10902, 10910,
      11000 .. 11005, 11007, 11009 .. 11012, 11015 .. 11017,
      11020 .. 11022, 11029, 11100 .. 11110, 11120, 11130,
      11140, 11150, 11160, 11170, 11190, 11200 .. 11205,
      11208 .. 11210, 11220, 11230, 11240, 11250, 11260, 11270,
      11290, 11300 .. 11301, 11303 .. 11304, 11310, 11320,
      11330, 11340, 11350, 11360, 11370, 11380, 11390,
      11400 .. 11402, 11409 .. 11410, 11420, 11430, 11440,
      11451 .. 11453, 11480, 11490 .. 11494, 11500, 11510,
      11540, 11560, 11570, 11580, 11590, 11600, 11610, 11620,
      11700, 11781 .. 11782, 11784 .. 11785, 11789 .. 11790,
      11800, 11802 .. 11803, 11805 .. 11808, 11810, 11816,
      11823, 11833, 11835 .. 11836, 11838, 11848, 11850, 11855,
      11860, 11870, 11875 .. 11878, 11880, 11885, 11890, 11898,
      12000 .. 12003, 12005, 12007 .. 12009, 12019 .. 12035,
      12039 .. 12040, 12100 .. 12104, 12106, 12108 .. 12110,
      12120, 12130, 12140, 12150, 12160, 12170, 12190,
      12200 .. 12204, 12210, 12220, 12230, 12240, 12250, 12260,
      12270, 12290, 12300, 12310, 12320, 12330, 12340, 12350,
      12360, 12370, 12380, 12390, 12400 .. 12402, 12410, 12420,
      12430, 12440, 12450, 12460, 12470, 12480, 12490, 12500,
      12510, 12520, 12540, 12550, 12560, 12580, 12600, 12620,
      12630, 12640, 12700, 12720, 12740, 12780, 12800, 12850,
      13000 .. 13016, 13020, 13066 .. 13067, 13080, 13085,
      13088 .. 13124, 13126 .. 13133, 13138 .. 13142, 13148 .. 13153,
      13155 .. 13161, 13163 .. 13165, 13168 .. 13170, 13177 .. 13178,
      13180 .. 13182, 13190 .. 13192, 13196, 13200 .. 13203,
      13205, 13207, 13209 .. 13211, 13213 .. 13228, 13230 .. 13236,
      13239 .. 13245, 13248 .. 13282, 13284 .. 13304, 13306 .. 13328,
      13330 .. 13335, 13338 .. 13340, 13342 .. 13348, 13350 .. 13352,
      13354 .. 13357, 13359 .. 13364, 13366 .. 13372, 13374 .. 13397,
      13399 .. 13404, 13406, 13410 .. 13417, 13420 .. 13421,
      13424 .. 13426, 13428, 13430 .. 13432, 13434 .. 13435,
      13440 .. 13448, 13450 .. 13458, 13460, 13462 .. 13464,
      13467, 13470 .. 13474, 13478, 13480 .. 13484,
      13489 .. 13490, 13493, 13500 .. 13503, 13510 .. 13514,
      13516, 13518 .. 13525, 13528 .. 13533, 13538 .. 13543,
      13545 .. 13552, 13558 .. 13560, 13566 .. 13568, 13570, 13572,
      13580 .. 13581, 13583, 13590 .. 13594, 13599 .. 13612,
      13614 .. 13617, 13619 .. 13621, 13625 .. 13633, 13635, 13637,
      13640 .. 13643, 13646, 13649 .. 13656, 13658 .. 13678,
      13680 .. 13681, 13683 .. 13685, 13687 .. 13705, 13708 .. 13710,
      13712 .. 13733, 13740 .. 13747, 13749 .. 13752, 13755,
      13757 .. 13760, 13764, 13766, 13770 .. 13785, 13789 .. 13810,
      13812 .. 13815, 13820 .. 13825, 13828 .. 13836, 13838 .. 13842,
      13844 .. 13847, 13850 .. 13864, 13867 .. 13868, 13870,
      13880 .. 13881, 13883, 13887, 13889 .. 13890, 13895, 13900,
      13902, 13904 .. 13908, 13910 .. 13911, 13920 .. 13924,
      13930 .. 13933, 13937, 13940 .. 13942, 13950, 13960,
      13980, 13990, 14000, 14005 .. 14020, 14023 .. 14040,
      14045 .. 14048, 14050 .. 14054, 14058 .. 14059, 14061 .. 14067,
      14070, 14074 .. 14079, 14081 .. 14086, 14089 .. 14114,
      14117, 14120 .. 14121, 14123, 14125 .. 14128,
      14130, 14140, 14150, 14160 .. 14162, 14165, 14168,
      14170, 14190, 14200 .. 14205, 14207 .. 14210, 14220, 14230,
      14240, 14250, 14260, 14270, 14280, 14290, 14310, 14320,
      14330, 14340, 14350, 14360, 14370, 14380, 14390,
      14400 .. 14410, 14420, 14430, 14440, 14450, 14460 .. 14462,
      14469 .. 14470, 14480, 14490, 14500 .. 14505, 14508 .. 14510,
      14520, 14530, 14540, 14550, 14570, 14590, 14600 .. 14603,
      14610, 14620, 14630, 14640, 14650 .. 14654, 14659, 14670,
      14680, 14690, 14700, 14710, 14730, 14740, 14750, 14760,
      14770, 14780, 14790 .. 14791, 14800 .. 14810, 14830, 14840,
      14850, 14860, 14880, 14901 .. 14916, 14919 .. 14926,
      14930 .. 14934, 14940, 14949 .. 14950, 14960, 14970,
      14980, 14990, 15000 .. 15008, 15010 .. 15015, 15017 .. 15019,
      15100 .. 15107, 15109 .. 15110, 15120, 15130, 15140, 15150,
      15160, 15170, 15190, 15200, 15210, 15220, 15229 .. 15230,
      15240, 15250, 15260, 15270, 15290, 15300, 15310, 15320,
      15340, 15350, 15380, 15400, 15430, 15500, 15590, 15600,
      15700, 15800, 16000 .. 16008, 16010 .. 16026, 16100 .. 16113,
      16120 .. 16121, 16130, 16140, 16150, 16160, 16170, 16190,
      16200, 16210, 16220, 16230, 16240, 16250, 16260, 16270,
      16290, 16300, 16310, 16320, 16330, 16340, 16350, 16360,
      16370, 16380, 16390, 16400, 16410, 16420, 16430, 16440,
      16450, 16460, 16470, 16480, 16490, 16500, 16510, 16560,
      16570, 16590, 16600, 16620, 16700, 16710, 16720, 16730,
      16800, 16901 .. 16920, 16929, 16950 .. 16955,
      16959, 16999 .. 17045, 17051 .. 17056, 17071 .. 17076,
      17078 .. 17079, 17086 .. 17089, 17100 .. 17121, 17123, 17130,
      17132 .. 17133, 17136 .. 17140, 17150, 17160, 17170,
      17180 .. 17190, 17200 .. 17211, 17214 .. 17215, 17220, 17230,
      17240, 17250, 17260, 17270, 17281, 17284 .. 17285,
      17289 .. 17290, 17300 .. 17314, 17320, 17330, 17340, 17350,
      17360, 17370, 17380, 17390, 17400, 17410 .. 17416,
      17419 .. 17420, 17430, 17440 .. 17446, 17449 .. 17450,
      17460, 17470, 17480, 17490, 17500 .. 17504, 17509 .. 17510,
      17520, 17530, 17540, 17550, 17560, 17570, 17580, 17590,
      17600, 17610, 17620, 17630, 17640, 17650, 17670, 17690,
      17700, 17730, 17740, 17750, 17770, 17780, 17800, 17810,
      17840, 17870, 17880, 17890, 17920, 17940, 18000 .. 18007,
      18012 .. 18016, 18019 .. 18037, 18039, 18100 .. 18110,
      18120, 18130, 18140, 18150, 18160, 18170, 18190,
      18200 .. 18207, 18210, 18220, 18230, 18240, 18250, 18260,
      18270, 18290, 18300, 18310, 18320, 18330, 18340, 18350,
      18360, 18370, 18380, 18390, 18400, 18410, 18500, 18510,
      18520, 18570, 18600, 18700, 18800, 18910 .. 18911,
      18920, 18922 .. 18924, 18934 .. 18935, 18939 .. 18941,
      18945, 18998, 19000 .. 19007, 19009, 19011 .. 19012,
      19015, 19017 .. 19019, 19033, 19100 .. 19111,
      19113 .. 19114, 19116 .. 19120, 19130, 19140, 19150, 19160,
      19170, 19190, 19200 .. 19204, 19208 .. 19210, 19220,
      19230 .. 19232, 19240, 19250, 19260, 19270, 19290, 19300,
      19310 .. 19320, 19330, 19340, 19350, 19360 .. 19361,
      19370, 19380, 19390, 19400, 19410, 19430, 19450, 19460,
      19470, 19490, 19500, 19510, 19520, 19550, 19560, 19600,
      19700, 19800,

      20000, 20090, 20100, 20110 .. 20119, 20121 .. 20148,
      20150 .. 20153, 20157, 20160, 20162 .. 20195, 20197 .. 20200,
      20212 .. 20215, 20217 .. 20240, 20242 .. 20248, 20250 .. 20253,
      20256, 20259 .. 20260, 20270, 20272, 20275 .. 20276,
      20279, 20287 .. 20299, 20302 .. 20306, 20309, 20311,
      20401 .. 20403, 20405 .. 20414, 20416 .. 20419, 20501 .. 20504,
      20537 .. 20538, 20600 .. 20601, 20604, 20611, 20620,
      20700 .. 20703, 20900, 21000 .. 21019, 21021 .. 21049,
      21051 .. 21063, 21065 .. 21081, 21083 .. 21086, 21088 .. 21089,
      21092 .. 21093, 21097 .. 21098, 21110, 21120 .. 21121,
      21130, 21140, 21150, 21160, 21170, 21190, 21200 .. 21210,
      21219 .. 21220, 21230, 21240, 21250, 21260 .. 21262,
      21270, 21290, 21300 .. 21305, 21309 .. 21310, 21320, 21330,
      21340, 21350, 21360, 21370, 21380, 21390, 21400 .. 21403,
      21409 .. 21410, 21420, 21430, 21440, 21450, 21460, 21470,
      21490, 21500 .. 21502, 21506, 21509 .. 21510,
      21520, 21530, 21540, 21550, 21560, 21570, 21580, 21590,
      21600 .. 21604, 21609 .. 21610, 21630, 21640, 21690,
      21700 .. 21705, 21709, 21719, 21760, 21800 .. 21803,
      21806, 21809, 21820, 21850, 21900, 21910, 21998,
      22000 .. 22005, 22014 .. 22017, 22021 .. 22027, 22029,
      22031 .. 22035, 22041 .. 22046, 22049, 22070, 22079 .. 22080,
      22089, 22091 .. 22093, 22095 .. 22096, 22098 .. 22111,
      22120, 22130, 22140, 22150, 22160, 22170, 22190 .. 22196,
      22199 .. 22206, 22209 .. 22210, 22220, 22230, 22240, 22250,
      22260, 22270, 22290, 22300 .. 22310, 22320, 22330,
      22340, 22350, 22360, 22370, 22380, 22390, 22400,
      22402 .. 22405, 22409 .. 22410, 22420, 22430, 22440, 22450,
      22460, 22470, 22480, 22490, 22500 .. 22505, 22509 .. 22510,
      22520, 22530, 22540, 22550, 22560, 22570, 22580, 22590,
      22600, 22602 .. 22607, 22609 .. 22610, 22620, 22630,
      22640, 22650, 22660, 22680, 22690, 22700, 22710, 22720,
      22730, 22740, 22750, 22770, 22780, 22800, 22810, 22820,
      22830, 22860, 22870, 22930, 22940, 22950, 22960, 22970,
      22980, 23000 .. 23009, 23011, 23013 .. 23016,
      23020, 23100, 23110, 23120, 23130, 23140, 23150, 23160,
      23170, 23190, 23200, 23210, 23220, 23230, 23240, 23250,
      23260, 23270, 23290, 23300, 23320, 23340, 23350, 23360,
      23380, 23400, 23420, 23430, 23450, 23460, 23480, 23500,
      23600, 23700, 23800, 24000 .. 24005, 24007,
      24009 .. 24017, 24019 .. 24020, 24022, 24024, 24029,
      24050 .. 24053, 24055, 24059 .. 24060, 24100 .. 24102,
      24104 .. 24114, 24120 .. 24122, 24130, 24140, 24150, 24160,
      24170, 24190, 24200 .. 24206, 24208 .. 24210, 24212, 24220,
      24230, 24240, 24250, 24260, 24270, 24290, 24300, 24310,
      24320, 24330, 24340, 24350, 24360, 24370, 24380, 24390,
      24400, 24410, 24420, 24430, 24440, 24450, 24460, 24470,
      24480, 24490, 24500, 24510, 24520, 24530, 24540, 24550,
      24560, 24570, 24580, 24590, 24600, 24610, 24620, 24630,
      24640, 24650, 24660, 24680, 24700, 24750 .. 24752,
      24755, 24758 .. 24759, 24800, 24910, 24912 .. 24913,
      24915, 24926, 25000 .. 25027, 25029 .. 25052, 25054,
      25056 .. 25063, 25068 .. 25073, 25075, 25079 .. 25080,
      25082 .. 25087, 25089 .. 25090, 25098 .. 25099, 25110 .. 25120,
      25130, 25140, 25150, 25160, 25170, 25190, 25200 .. 25220,
      25230, 25240, 25250, 25260, 25270, 25290, 25300 .. 25304,
      25309 .. 25310, 25320, 25330, 25340, 25350, 25360, 25370,
      25380, 25390, 25400 .. 25406, 25409 .. 25410, 25420, 25430,
      25440, 25450, 25460 .. 25462, 25469 .. 25470, 25479 .. 25480,
      25490, 25500 .. 25504, 25508 .. 25510, 25520, 25530,
      25550, 25560, 25570, 25580, 25600 .. 25610, 25620, 25630,
      25640, 25650, 25660, 25680, 25690, 25700 .. 25702,
      25706 .. 25709, 25720, 25750, 25770, 25790, 25800, 25820,
      25840, 25870, 25909, 25920, 25930 .. 25933, 25960,
      26000 .. 26015, 26021 .. 26032, 26100 .. 26111, 26119 .. 26120,
      26130 .. 26131, 26140, 26150, 26160, 26170, 26190,
      26199 .. 26210, 26215 .. 26216, 26220, 26230, 26240 .. 26244,
      26249 .. 26250, 26260, 26270, 26290, 26300 .. 26304,
      26309 .. 26310, 26320, 26330, 26340, 26350, 26380, 26390,
      26400 .. 26402, 26409 .. 26410, 26420, 26450, 26460, 26470,
      26500 .. 26504, 26509 .. 26510, 26530, 26540, 26560, 26570,
      26600 .. 26603, 26609, 26620, 26700 .. 26702, 26709, 26730,
      26740, 26750, 26760 .. 26761, 26770, 26780, 26790,
      26800 .. 26802, 26809, 26901 .. 26907, 26909,
      26950 .. 26956, 26958, 27000 .. 27010, 27012 .. 27013,
      27015 .. 27019, 27021 .. 27023, 27025 .. 27026, 27030 .. 27040,
      27090 .. 27110, 27120 .. 27122, 27127, 27130 .. 27138,
      27140, 27150, 27160, 27170, 27180, 27190, 27200 .. 27210,
      27220, 27230, 27240, 27250, 27260, 27270, 27290,
      27300 .. 27310, 27320, 27330, 27340, 27350, 27360, 27370,
      27380, 27390, 27400 .. 27407, 27409 .. 27410, 27420, 27430,
      27440, 27450, 27460, 27470, 27480, 27490, 27500 .. 27510,
      27520, 27530, 27540, 27550, 27560, 27570, 27580, 27590,
      27600, 27607, 27610, 27620, 27630, 27640, 27650, 27660,
      27670, 27680, 27690, 27700 .. 27703, 27705, 27710,
      27720, 27730, 27740, 27750, 27760, 27770, 27780, 27790,
      27800, 27810, 27820, 27830, 27850, 27860, 27870, 27890,
      27909 .. 27911, 27914, 27920, 27924, 27928 .. 27933,
      27936, 27939 .. 27940, 27949 .. 27950, 28000 .. 28009,
      28011, 28018 .. 28019, 28023 .. 28026, 28029,
      28033 .. 28040, 28044, 28080, 28088, 28100 .. 28106,
      28108 .. 28114, 28119 .. 28120, 28130 .. 28133, 28140, 28150,
      28160, 28170, 28190, 28200 .. 28203, 28205, 28207,
      28209 .. 28211, 28220, 28230 .. 28232, 28234, 28240,
      28250, 28260, 28270, 28290, 28300 .. 28305, 28309 .. 28310,
      28320, 28330, 28340, 28350, 28360, 28380, 28400 .. 28404,
      28409 .. 28410, 28480 .. 28481, 28489, 28500 .. 28501,
      28600, 28630 .. 28633, 28636 .. 28637, 28639,
      28700 .. 28703, 28707, 28709, 28800, 28901, 28910, 28920,
      28930 .. 28933, 28935, 28944, 28950, 29000, 29018, 29080,
      29100 .. 29109, 29120 .. 29125, 29129, 29140, 29150, 29160,
      29170 .. 29174, 29176 .. 29177, 29179 .. 29187, 29189 .. 29193,
      29196, 29199 .. 29200, 29206 .. 29213, 29217 .. 29225,
      29227 .. 29229, 29231, 29233, 29238, 29240 .. 29242,
      29246, 29250, 29252 .. 29253, 29259 .. 29260, 29270, 29280,
      29282, 29289 .. 29290, 29299 .. 29300, 29310,
      29320 .. 29328, 29330 .. 29337, 29340, 29350, 29360, 29370,
      29380, 29390 .. 29404, 29406 .. 29407, 29409 .. 29414,
      29419 .. 29420, 29430, 29440, 29450, 29455, 29460, 29470,
      29480, 29490, 29500, 29510, 29520, 29530, 29540,
      29550 .. 29561, 29563, 29570, 29590, 29600, 29602, 29606,
      29609 .. 29610, 29620, 29630, 29640, 29650, 29660,
      29670 .. 29674, 29678 .. 29682, 29684, 29688 .. 29690,
      29700, 29710, 29720, 29730, 29740, 29750, 29760, 29770,
      29780, 29790, 29800 .. 29804, 29806 .. 29810, 29820,
      29824 .. 29825, 29827, 29830, 29833 .. 29837, 29839 .. 29840,
      29850, 29860, 29870, 29880, 29890, 29900, 29910, 29920,
      29930, 29940, 29950, 29970, 29980, 29990,

      30000 .. 30003, 30006 .. 30025, 30028 .. 30029, 30031 .. 30036,
      30039 .. 30040, 30044 .. 30045, 30048 .. 30051, 30055,
      30100 .. 30107, 30109 .. 30112, 30114 .. 30115, 30119 .. 30134,
      30139 .. 30140, 30150, 30160, 30170, 30190, 30200 .. 30207,
      30209 .. 30210, 30220, 30230, 30240, 30250 .. 30253,
      30255, 30260, 30270, 30290, 30300 .. 30302, 30310 .. 30311,
      30313, 30318 .. 30320, 30330, 30340, 30350, 30360,
      30380, 30390, 30400 .. 30406, 30409 .. 30410, 30420, 30430,
      30440, 30450, 30460, 30470, 30480, 30490, 30500, 30510,
      30520, 30530, 30540, 30560, 30570, 30580, 30600, 30610,
      30620, 30630, 30640, 30650, 30660, 30670, 30700 .. 30703,
      30720, 30730, 30740, 30750, 30760, 30770, 30800, 30820,
      30840, 30870, 30900 .. 30901, 30903 .. 30908, 30910 .. 30914,
      30918, 30920 .. 30925, 30929, 30931 .. 30932,
      30934 .. 30937, 30939 .. 30943, 30947, 30960, 30969,
      30971 .. 30972, 30975, 30980, 31000 .. 31082, 31084 .. 31086,
      31088 .. 31104, 31106 .. 31107, 31109 .. 31110, 31112,
      31120 .. 31142, 31149 .. 31152, 31155, 31159 .. 31160,
      31170, 31180, 31189 .. 31190, 31200 .. 31201, 31203 .. 31205,
      31210, 31220, 31230, 31240 .. 31245, 31249 .. 31250,
      31260, 31270, 31280, 31289 .. 31290, 31300, 31310,
      31312 .. 31315, 31317, 31319 .. 31322, 31325 .. 31326,
      31329 .. 31330, 31340, 31350, 31360, 31370, 31380,
      31389 .. 31390, 31400 .. 31406, 31410, 31420, 31430, 31432,
      31440, 31450, 31460, 31470, 31480, 31489 .. 31490,
      31500, 31503 .. 31507, 31510, 31512, 31520 .. 31522,
      31524, 31529 .. 31530, 31540, 31550, 31560, 31570,
      31580, 31589 .. 31590, 31600 .. 31606, 31608 .. 31609,
      31620 .. 31621, 31629, 31650, 31660, 31670 .. 31679,
      31681 .. 31683, 31685, 31689, 31692, 31700 .. 31709,
      31711 .. 31712, 31715 .. 31716, 31750, 31770 .. 31774,
      31776 .. 31777, 31779 .. 31780, 31790, 31800 .. 31807,
      31809 .. 31810, 31820, 31830 .. 31832, 31839 .. 31840,
      31850, 31860, 31870, 31880, 31900 .. 31903, 31931, 31945,
      31947, 31950, 31957 .. 31958, 31960, 31962, 31998 .. 32005,
      32007 .. 32014, 32016 .. 32022, 32100, 32110, 32120,
      32129 .. 32130, 32140, 32150, 32160, 32170, 32190,
      32200 .. 32201, 32209, 32220, 32230, 32240, 32250, 32260,
      32270, 32290, 32300, 32310, 32320, 32330, 32340, 32350,
      32360, 32370, 32380, 32390, 32400, 32410, 32420, 32430,
      32440, 32450, 32460, 32480, 32490, 32500 .. 32502,
      32505, 32509, 32550, 32600, 32700, 32720, 32730, 32800,
      32810, 33000 .. 33002, 33004 .. 33012, 33015,
      33019 .. 33021, 33023 .. 33038, 33040 .. 33043, 33047 .. 33100,
      33110, 33112 .. 33116, 33120 .. 33121, 33123 .. 33127,
      33130, 33133, 33138, 33140 .. 33141, 33148,
      33150 .. 33153, 33155, 33160, 33164 .. 33167, 33169 .. 33175,
      33180, 33185 .. 33187, 33190 .. 33193, 33200,
      33210 .. 33214, 33219 .. 33220, 33230, 33240, 33250, 33260,
      33270 .. 33274, 33278 .. 33279, 33290 .. 33295, 33300,
      33305 .. 33306, 33309 .. 33314, 33319 .. 33324, 33326 .. 33327,
      33329 .. 33330, 33335, 33340 .. 33341, 33350, 33360,
      33370, 33380, 33390 .. 33395, 33400 .. 33405, 33409 .. 33410,
      33420, 33430, 33440, 33450 .. 33452, 33460 .. 33461,
      33469 .. 33470, 33480, 33490 .. 33492, 33495,
      33500 .. 33507, 33509 .. 33510, 33515, 33520 .. 33527,
      33529 .. 33530, 33540, 33550, 33560 .. 33565, 33570, 33580,
      33590, 33600 .. 33615, 33620 .. 33621, 33625 .. 33627,
      33629, 33640, 33650, 33652, 33660, 33670, 33680,
      33688 .. 33710, 33720, 33730 .. 33741, 33747, 33750,
      33760, 33770, 33780, 33790, 33800 .. 33801, 33810, 33820,
      33830, 33840, 33850, 33860, 33870, 33880 .. 33887,
      33890, 33900 .. 33907, 33909 .. 33915, 33918 .. 33920,
      33930, 33950, 33970, 33980, 33990, 33998, 34000 .. 34004,
      34006 .. 34012, 34023 .. 34028, 34030, 34032 .. 34035,
      34037 .. 34043, 34045 .. 34046, 34048 .. 34049, 34051,
      34053 .. 34056, 34058, 34060 .. 34068, 34070 .. 34080,
      34082 .. 34083, 34085 .. 34087, 34089 .. 34099, 34110 .. 34120,
      34130 .. 34132, 34137 .. 34140, 34150, 34160, 34170 .. 34174,
      34178 .. 34179, 34181, 34183 .. 34184, 34186 .. 34187,
      34190 .. 34204, 34207, 34209 .. 34210, 34220, 34230,
      34240, 34250, 34260 .. 34267, 34270, 34274, 34280, 34290,
      34293 .. 34305, 34307, 34309 .. 34310, 34320, 34330,
      34340, 34350, 34360, 34370, 34380, 34390 .. 34394,
      34396 .. 34404, 34409 .. 34410, 34420, 34430 .. 34431,
      34433 .. 34435, 34438 .. 34440, 34450, 34460, 34470, 34473,
      34477, 34480, 34490, 34500 .. 34508, 34510,
      34513 .. 34518, 34520 .. 34526, 34529 .. 34530, 34534 .. 34537,
      34539 .. 34540, 34543 .. 34545, 34550, 34560, 34564, 34570,
      34590, 34600, 34610, 34620, 34630, 34650, 34660,
      34670 .. 34671, 34680, 34690, 34700 .. 34702, 34710, 34720,
      34725, 34730, 34740 .. 34742, 34747 .. 34751, 34753, 34760,
      34770, 34790, 34800, 34810, 34820, 34830, 34850,
      34871 .. 34875, 34880, 34900, 34920, 34923, 34925 .. 34926,
      34932 .. 34935, 34937 .. 34940, 34942 .. 34944, 34948 .. 34949,
      34954 .. 34962, 34964 .. 34965, 34967, 34970, 34972 .. 34975,
      34977, 34980 .. 34987, 34989 .. 34990, 35000 .. 35012,
      35014 .. 35016, 35018, 35020 .. 35024, 35026 .. 35035,
      35039 .. 35040, 35042 .. 35047, 35049 .. 35055, 35057 .. 35059,
      35063 .. 35067, 35069 .. 35071, 35073, 35076, 35078 .. 35094,
      35099, 35101 .. 35106, 35108 .. 35109, 35111,
      35113 .. 35114, 35120, 35130 .. 35137, 35140, 35150,
      35160 .. 35164, 35166, 35169 .. 35172, 35174 .. 35177,
      35190, 35200 .. 35205, 35207 .. 35210, 35220 .. 35221,
      35230, 35235 .. 35236, 35240, 35250, 35260, 35270,
      35290, 35300 .. 35306, 35309 .. 35310, 35320, 35330,
      35340 .. 35342, 35345, 35349 .. 35350, 35360, 35370,
      35380, 35390, 35400 .. 35420, 35430 .. 35433, 35435,
      35439 .. 35440, 35450, 35460, 35470, 35480, 35490,
      35500 .. 35507, 35509 .. 35521, 35530 .. 35533, 35538 .. 35540,
      35550, 35560, 35571 .. 35574, 35576 .. 35580, 35590,
      35600 .. 35603, 35605 .. 35606, 35610, 35620, 35630, 35640,
      35650 .. 35653, 35659 .. 35660, 35680, 35690, 35700 .. 35709,
      35711, 35720, 35730, 35740 .. 35744, 35746, 35750,
      35760 .. 35772, 35780, 35800 .. 35803, 35830 .. 35833,
      35850, 35870, 35890, 35900 .. 35909, 35911 .. 35921,
      35960, 35998, 36000 .. 36029, 36032 .. 36033, 36100 .. 36105,
      36107, 36109 .. 36110, 36120, 36130 .. 36131,
      36140, 36150, 36160, 36170, 36180, 36190, 36200, 36210,
      36220, 36230, 36240, 36250, 36255, 36260, 36270, 36290,
      36300 .. 36301, 36310, 36320, 36330, 36340, 36350, 36360,
      36370, 36400, 36500 .. 36501, 36505, 36600, 36700, 36800,
      36910, 36915, 37000, 37008 .. 37020, 37025 .. 37029,
      37032 .. 37035, 37038 .. 37045, 37047 .. 37049, 37058 .. 37061,
      37071 .. 37082, 37089, 37095 .. 37100, 37110, 37120,
      37130, 37140, 37150, 37152, 37160, 37170 .. 37175,
      37179, 37190, 37200, 37204 .. 37206, 37209 .. 37210,
      37220, 37230, 37240, 37250, 37260, 37270, 37290,
      37300 .. 37306, 37309 .. 37310, 37320 .. 37321, 37330, 37340,
      37350, 37360, 37370, 37380, 37390, 37400 .. 37404,
      37409, 37420, 37460, 37500 .. 37502, 37509 .. 37510,
      37520 .. 37521, 37530, 37540 .. 37542, 37549 .. 37556,
      37600 .. 37602, 37609, 37700 .. 37703, 37705, 37709,
      37800, 37910 .. 37913, 37915, 37917, 37921 .. 37922,
      37924 .. 37929, 37931 .. 37932, 37941 .. 37942, 38000 .. 38019,
      38021 .. 38037, 38039 .. 38054, 38056, 38058 .. 38059,
      38061, 38063, 38065 .. 38067, 38069 .. 38070, 38074, 38077,
      38080 .. 38081, 38089 .. 38093, 38096 .. 38100, 38110,
      38112 .. 38114, 38118 .. 38122, 38130, 38134, 38138, 38140,
      38142, 38144, 38146 .. 38148, 38150, 38152 .. 38154,
      38159 .. 38165, 38169 .. 38174, 38176, 38179 .. 38180,
      38190 .. 38191, 38196 .. 38197, 38200 .. 38211, 38216 .. 38220,
      38230 .. 38232, 38236, 38240 .. 38244, 38246,
      38249 .. 38250, 38256, 38260 .. 38261, 38269 .. 38270,
      38280, 38290 .. 38293, 38295 .. 38297, 38299 .. 38305,
      38307, 38309, 38311 .. 38315, 38317, 38319 .. 38322,
      38326 .. 38327, 38329 .. 38334, 38340 .. 38343, 38345 .. 38347,
      38349 .. 38354, 38356 .. 38361, 38370, 38380, 38390,
      38400 .. 38410, 38420, 38430 .. 38437, 38439 .. 38440,
      38450, 38460, 38470, 38480, 38490, 38500 .. 38511,
      38516, 38519 .. 38524, 38526, 38529 .. 38530,
      38540, 38550 .. 38557, 38559 .. 38560, 38570, 38580,
      38590 .. 38591, 38600 .. 38603, 38609 .. 38610, 38620, 38630,
      38640, 38650, 38660, 38670, 38680, 38690, 38700 .. 38702,
      38706 .. 38710, 38730 .. 38731, 38740, 38750, 38760 .. 38761,
      38763, 38767, 38769 .. 38770, 38780 .. 38782, 38784,
      38789 .. 38790, 38800 .. 38803, 38816 .. 38817, 38821, 38830,
      38840, 38850, 38860, 38870, 38880, 38890, 38900, 38913,
      38920 .. 38921, 38926 .. 38927, 38930, 38940 .. 38941,
      38943 .. 38944, 38950, 38960, 38970, 38980, 39000 .. 39010,
      39015 .. 39016, 39021, 39029 .. 39039, 39100 .. 39110,
      39120, 39130, 39140, 39150, 39160, 39170 .. 39171,
      39180 .. 39181, 39189 .. 39190, 39200 .. 39211, 39219 .. 39220,
      39230, 39240, 39250, 39260 .. 39261, 39270, 39290,
      39300 .. 39310, 39320, 39330, 39350, 39360, 39370, 39380,
      39400 .. 39410, 39460, 39500 .. 39502, 39520, 39570,
      39600 .. 39603, 39605, 39609, 39700, 39800 .. 39809,

      40000 .. 40006, 40011 .. 40013, 40015 .. 40019, 40021 .. 40027,
      40090, 40100 .. 40108, 40110, 40115, 40118, 40120,
      40130, 40140 .. 40141, 40150, 40160 .. 40161,
      40170, 40180, 40190, 40200 .. 40202, 40210, 40220,
      40230 .. 40232, 40235, 40239 .. 40240, 40250, 40260,
      40270, 40280 .. 40282, 40286, 40290, 40300 .. 40301,
      40305, 40309 .. 40310, 40320, 40330, 40350, 40360,
      40370, 40380, 40390, 40400, 40410, 40420, 40430, 40440,
      40460, 40465, 40480, 40500 .. 40502, 40510, 40530,
      40550, 40560, 40600 .. 40602, 40630, 40660, 40700 .. 40701,
      40705, 40800 .. 40801, 40805, 40990 .. 40994,
      41000 .. 41013, 41015 .. 41016, 41018 .. 41020, 41022 .. 41023,
      41025 .. 41026, 41028 .. 41029, 41033 .. 41035, 41042 .. 41043,
      41100 .. 41103, 41105 .. 41106, 41109 .. 41110, 41120 .. 41122,
      41130, 41140, 41150 .. 41151, 41160, 41170, 41190,
      41200 .. 41207, 41210, 41220, 41230, 41240, 41250,
      41260 .. 41261, 41270, 41290, 41300, 41310, 41320, 41330,
      41350, 41353 .. 41355, 41357, 41360, 41370,
      41400 .. 41402, 41406, 41500, 41600, 41700, 41800, 41901,
      41903 .. 41906, 41908 .. 41910, 41913 .. 41915, 41918 .. 41919,
      41921, 41924 .. 41925, 41930 .. 41933, 41936,
      41941 .. 41943, 41945, 41948 .. 41951, 41958, 41960,
      41963 .. 41968, 41970 .. 41976, 42000 .. 42018, 42021 .. 42031,
      42033, 42041 .. 42043, 42045, 42047 .. 42050,
      42055, 42058 .. 42059, 42100, 42110 .. 42111,
      42114, 42120, 42122 .. 42127, 42129 .. 42131, 42140, 42150,
      42152 .. 42153, 42155, 42160 .. 42170, 42173 .. 42174,
      42176, 42179, 42190, 42210, 42220, 42230, 42240, 42260,
      42270 .. 42273, 42275 .. 42277, 42279, 42290, 42300 .. 42304,
      42308, 42310 .. 42315, 42318, 42320 .. 42323,
      42328, 42330, 42332 .. 42335, 42339 .. 42340, 42350 .. 42351,
      42353 .. 42356, 42359 .. 42360, 42370, 42380, 42390,
      42400 .. 42412, 42420, 42430, 42440, 42450, 42460, 42470,
      42480, 42484, 42486, 42489 .. 42490, 42500 .. 42503,
      42505, 42509 .. 42510, 42520, 42530, 42540, 42550,
      42560, 42570, 42580, 42590, 42600 .. 42610, 42620, 42630,
      42640, 42650 .. 42651, 42653, 42660, 42670, 42680,
      42700 .. 42705, 42707, 42709, 42720, 42740, 42750, 42780,
      42800 .. 42810, 42820, 42830, 42840, 42890, 42920, 42940,
      42950 .. 42955, 42958 .. 42959, 42961 .. 42969, 42990,
      43000 .. 43006, 43008 .. 43014, 43017, 43019, 43100 .. 43103,
      43110, 43120, 43130, 43140, 43150, 43160, 43170, 43190,
      43200 .. 43203, 43210, 43220, 43230, 43240, 43250, 43260,
      43270, 43290, 43300, 43320, 43330, 43340, 43350, 43360,
      43370, 43380, 43390, 43400, 43410, 43420, 43430, 43440,
      43450, 43490, 43500, 43510, 43520, 43530, 43550, 43580,
      43590, 43600, 43620, 43700, 43750, 43770, 43800, 43810,
      44000 .. 44024, 44032 .. 44036, 44038, 44040 .. 44042,
      44046 .. 44047, 44090, 44092 .. 44095, 44097,
      44099 .. 44107, 44109 .. 44110, 44115 .. 44124, 44126,
      44129 .. 44130, 44140 .. 44146, 44149 .. 44160, 44170, 44176,
      44179, 44184 .. 44188, 44190 .. 44196, 44198 .. 44205,
      44209 .. 44217, 44219 .. 44220, 44230 .. 44236, 44239 .. 44245,
      44249 .. 44250, 44260 .. 44263, 44265, 44268, 44270,
      44272 .. 44277, 44290, 44300 .. 44346, 44349 .. 44353,
      44356 .. 44360, 44370 .. 44373, 44379 .. 44380, 44390,
      44400 .. 44410, 44412, 44420, 44430, 44440, 44450, 44460,
      44470 .. 44484, 44490, 44500 .. 44506, 44509 .. 44510,
      44520 .. 44522, 44530, 44540, 44550, 44560, 44570, 44580,
      44590, 44600 .. 44606, 44609 .. 44618, 44620, 44630,
      44640, 44650, 44660, 44670, 44680, 44690, 44700 .. 44703,
      44706 .. 44710, 44720, 44730, 44740, 44750, 44760, 44770,
      44780, 44800 .. 44819, 44821 .. 44824, 44829 .. 44830,
      44840, 44850, 44860, 44880, 44900, 44911 .. 44919,
      44921 .. 44929, 44931 .. 44939, 44941 .. 44942, 44944 .. 44945,
      44947, 44949, 44951 .. 44959, 44963 .. 44969, 44971 .. 44978,
      44980 .. 44986, 44989, 45000 .. 45012, 45015 .. 45017,
      45019, 45021, 45023, 45025, 45028 .. 45035, 45038,
      45040 .. 45046, 45052 .. 45053, 45056 .. 45058, 45060 .. 45065,
      45067 .. 45069, 45071 .. 45075, 45077 .. 45079, 45081 .. 45082,
      45087 .. 45088, 45100, 45110, 45120 .. 45122, 45125,
      45129 .. 45130, 45140 .. 45147, 45149 .. 45150, 45160 .. 45166,
      45168 .. 45170, 45190, 45200 .. 45214, 45220, 45230,
      45240, 45250, 45260, 45270, 45290, 45300, 45302 .. 45308,
      45310, 45312, 45320, 45330 .. 45331, 45340, 45360,
      45370, 45380, 45390, 45400 .. 45404, 45406,
      45409 .. 45410, 45420, 45430 .. 45433, 45450, 45460,
      45470, 45480, 45490, 45500 .. 45504, 45510, 45520,
      45530, 45550, 45560, 45570, 45590, 45600, 45620, 45630,
      45640, 45650 .. 45651, 45655 .. 45656, 45680,
      45700 .. 45702, 45709, 45720, 45730, 45740, 45750, 45760,
      45770 .. 45771, 45774 .. 45775, 45777, 45800 .. 45809,
      45811, 45900, 45910 .. 45913, 45915 .. 45927, 45929 .. 45938,
      45943 .. 45957, 45960 .. 45980, 46000 .. 46005, 46008 .. 46010,
      46014 .. 46023, 46090 .. 46091, 46100 .. 46103, 46106, 46110,
      46120, 46130, 46140, 46150, 46160, 46170, 46190, 46200,
      46210, 46220, 46230, 46240, 46250, 46260, 46270, 46300,
      46310, 46320, 46330, 46340, 46350, 46360, 46400, 46500,
      46600, 46700, 46800, 47000, 47002 .. 47008, 47013, 47020,
      47023, 47030 .. 47032, 47039, 47110, 47120, 47130,
      47140, 47150, 47160, 47170, 47180, 47190, 47200 .. 47205,
      47207 .. 47211, 47213, 47220, 47230, 47240, 47250, 47260,
      47270, 47290, 47300 .. 47305, 47307 .. 47310, 47320, 47330,
      47340, 47350, 47360, 47370, 47380, 47390, 47400, 47410,
      47420, 47430, 47440, 47450, 47470, 47480, 47500 .. 47502,
      47510, 47520, 47550 .. 47553, 47555, 47559, 47600, 47700,
      47800, 47901, 47909 .. 47918, 47920 .. 47925, 47929, 47931,
      48000 .. 48003, 48005 .. 48009, 48100, 48110, 48120, 48130,
      48140, 48150, 48160, 48170, 48190, 48200, 48210, 48220,
      48230, 48240, 48250, 48260, 48270, 48300, 48310, 48320,
      48330, 48340, 48370, 48400, 48500, 48600, 48700, 48800,
      49000 .. 49004, 49006 .. 49011, 49014 .. 49018, 49020 .. 49024,
      49026, 49028, 49032 .. 49033, 49035 .. 49036, 49041,
      49043 .. 49047, 49049, 49051 .. 49053, 49055, 49059,
      49066, 49070 .. 49072, 49079 .. 49080, 49100 .. 49107,
      49109 .. 49112, 49115 .. 49117, 49119 .. 49120, 49122 .. 49125,
      49130, 49135 .. 49137, 49139 .. 49140, 49150, 49160,
      49170, 49180 .. 49184, 49190, 49220, 49230,
      49240 .. 49245, 49249 .. 49250, 49260, 49270, 49280, 49290,
      49300 .. 49312, 49314, 49319 .. 49321, 49325,
      49327 .. 49330, 49340, 49350, 49360, 49370, 49380, 49390,
      49400 .. 49406, 49408 .. 49415, 49417 .. 49418, 49420 .. 49421,
      49425 .. 49428, 49430, 49440, 49450, 49456, 49458, 49460,
      49480 .. 49481, 49484, 49486, 49490, 49500 .. 49505,
      49509 .. 49510, 49520, 49530, 49540, 49560, 49570, 49590,
      49600 .. 49602, 49609 .. 49610, 49620, 49630, 49640, 49650,
      49660, 49670, 49680, 49690, 49700, 49710, 49730, 49740,
      49750, 49770, 49800 .. 49805, 49809, 49905 .. 49906,
      49911 .. 49913, 49919, 49925, 49927, 49933 .. 49934,
      49937 .. 49939, 49941, 49949,

      50000 .. 50016, 50050, 50100 .. 50110, 50113 .. 50115,
      50120, 50130 .. 50131, 50140, 50150, 50160, 50170,
      50180, 50190, 50200 .. 50211, 50220, 50230, 50240, 50250,
      50260, 50270, 50290, 50300 .. 50310, 50320, 50330,
      50340, 50350, 50360, 50370, 50380, 50390, 50400 .. 50407,
      50409 .. 50410, 50420, 50430, 50440 .. 50442, 50444 .. 50450,
      50460, 50470, 50480, 50490, 50500, 50510, 50520, 50530,
      50540, 50550, 50560, 50570, 50580, 50590, 50600, 50610,
      50620, 50630, 50640, 50651 .. 50652, 50660, 50670,
      50680, 50690, 50700, 50710, 50720, 50730, 50740, 50750,
      50760, 50770, 50800, 50810, 50840, 50850, 50860, 50870,
      50880, 50890, 50950 .. 50951, 50958, 51000 .. 51001,
      51005 .. 51013, 51016 .. 51017, 51021 .. 51022, 51035 .. 51039,
      51041 .. 51043, 51051 .. 51077, 51079 .. 51084, 51086 .. 51090,
      51092, 51095 .. 51097, 51099 .. 51100, 51110,
      51120 .. 51122, 51130, 51140, 51150, 51160, 51170, 51190,
      51200 .. 51210, 51220, 51230, 51240, 51250, 51260, 51270,
      51290, 51300 .. 51306, 51308 .. 51310, 51318 .. 51320,
      51330 .. 51334, 51340, 51349 .. 51350, 51360 .. 51361,
      51370, 51380, 51390, 51400 .. 51401, 51420,
      51430 .. 51435, 51450, 51460, 51470, 51480, 51490, 51500,
      51510, 51520, 51530, 51571 .. 51573, 51600 .. 51601,
      51662 .. 51664, 51673, 51675, 51677 .. 51679, 51682 .. 51689,
      51700, 51713, 51715, 51721 .. 51723, 51726,
      51800 .. 51801, 51871, 51873, 51884, 51886, 51900, 51902,
      51904, 52000 .. 52008, 52011 .. 52012, 52014, 52016,
      52100 .. 52113, 52115, 52120, 52130, 52140, 52150, 52160,
      52170, 52190, 52200 .. 52210, 52220, 52230, 52240, 52250,
      52260, 52270, 52290, 52300 .. 52301, 52310, 52320,
      52330, 52340, 52360, 52370, 52400, 52410, 52500 .. 52502,
      52600, 52700, 52800, 52901 .. 52906, 52915, 52917,
      52919 .. 52920, 53000 .. 53010, 53012 .. 53016, 53019 .. 53022,
      53030 .. 53032, 53060 .. 53063, 53069, 53073, 53080 .. 53091,
      53093 .. 53095, 53098 .. 53105, 53109 .. 53110, 53120, 53140,
      53150, 53160, 53170, 53190, 53200 .. 53205, 53210, 53220,
      53230, 53240, 53250, 53260, 53270, 53290, 53300, 53320,
      53340, 53350, 53360, 53370, 53380, 53390, 53400, 53410,
      53420, 53440, 53470, 53480, 53500, 53540, 53600 .. 53602,
      53640, 53700, 53800, 53810 .. 53811, 53940 .. 53942,
      53950 .. 53951, 53960, 53970 .. 53971, 54000 .. 54017,
      54020 .. 54023, 54029, 54031 .. 54032, 54035 .. 54039,
      54041 .. 54043, 54045 .. 54049, 54052 .. 54054, 54056,
      54062 .. 54064, 54071 .. 54074, 54076, 54082, 54096 .. 54098,
      54100, 54110 .. 54116, 54118 .. 54123, 54129 .. 54136,
      54138 .. 54140, 54150 .. 54154, 54159 .. 54160, 54170,
      54180 .. 54186, 54189 .. 54190, 54200 .. 54206, 54209 .. 54211,
      54220, 54230, 54240, 54250, 54260 .. 54263, 54270 .. 54273,
      54279 .. 54280, 54290, 54300 .. 54305, 54309 .. 54312,
      54319 .. 54320, 54330, 54340, 54350, 54360, 54370, 54380,
      54385, 54390, 54400 .. 54406, 54409 .. 54414, 54420, 54425,
      54430, 54440, 54450, 54460, 54470, 54480, 54490,
      54500 .. 54507, 54509 .. 54517, 54519 .. 54530, 54540, 54550,
      54560, 54570, 54580, 54590, 54600 .. 54603, 54608 .. 54610,
      54620, 54630, 54640, 54650, 54660, 54670, 54680, 54690,
      54700 .. 54706, 54708 .. 54716, 54719 .. 54720, 54730, 54740,
      54750, 54760, 54770, 54780, 54790, 54800 .. 54803,
      54810, 54820, 54830, 54840, 54850, 54860, 54870, 54880,
      54890, 54900, 54910, 54920, 54930 .. 54931, 54933 .. 54934,
      54939 .. 54941, 54950, 54960, 54970, 54980, 54990,
      55000 .. 55003, 55005 .. 55008, 55012 .. 55015, 55020 .. 55021,
      55100 .. 55110, 55112 .. 55113, 55119 .. 55120, 55130, 55140,
      55150, 55160, 55170, 55190, 55200 .. 55203, 55205, 55210,
      55220 .. 55221, 55230, 55240, 55250, 55260, 55270 .. 55271,
      55290, 55300, 55310, 55320, 55400, 55430, 55500, 55600,
      55700, 55800, 55840, 56000 .. 56010, 56016 .. 56020,
      56029, 56034, 56036 .. 56039, 56100 .. 56110, 56120, 56130,
      56140, 56150, 56160, 56170 .. 56175, 56178 .. 56179,
      56190, 56200 .. 56201, 56204, 56207, 56209,
      56219 .. 56220, 56230 .. 56231, 56239 .. 56240, 56250, 56260,
      56270 .. 56277, 56279, 56290, 56300 .. 56312, 56317,
      56319 .. 56330, 56340 .. 56343, 56349 .. 56350, 56360, 56370,
      56380 .. 56383, 56390, 56400 .. 56407, 56409 .. 56411,
      56413, 56419 .. 56420, 56430, 56440, 56450, 56460,
      56470, 56480, 56490, 56500 .. 56504, 56506,
      56509 .. 56510, 56520, 56530 .. 56532, 56535 .. 56536,
      56539 .. 56540, 56550, 56560, 56570, 56580, 56590,
      56600 .. 56603, 56607, 56609 .. 56610, 56620, 56630,
      56640, 56650, 56660, 56670, 56680, 56690, 56700 .. 56705,
      56709, 56730, 56740, 56750, 56760, 56770, 56780,
      56800 .. 56805, 56809, 56840, 56850, 56854 .. 56855,
      56860, 56870, 56880, 56890 .. 56893, 56896,
      56899 .. 56903, 56909 .. 56910, 56920, 56930, 56950 .. 56951,
      56954, 56956 .. 56957, 56959, 56970, 56973, 56977,
      56979, 56998, 57000, 57003 .. 57021, 57023, 57028,
      57030 .. 57038, 57040 .. 57041, 57044 .. 57046, 57049 .. 57054,
      57056 .. 57057, 57059, 57061 .. 57063, 57070 .. 57079,
      57081 .. 57084, 57100 .. 57106, 57108 .. 57109, 57119 .. 57120,
      57125 .. 57133, 57140 .. 57141, 57144, 57146 .. 57155,
      57157, 57159 .. 57164, 57169 .. 57170, 57175,
      57180 .. 57181, 57185, 57190 .. 57193, 57199 .. 57209,
      57211 .. 57212, 57214 .. 57220, 57230 .. 57234, 57240, 57245,
      57250, 57255, 57260, 57270, 57280 .. 57283, 57289 .. 57292,
      57299 .. 57304, 57309 .. 57310, 57320, 57330, 57340,
      57350 .. 57352, 57354, 57359 .. 57363, 57365,
      57369 .. 57373, 57379 .. 57383, 57385, 57390, 57400 .. 57405,
      57409 .. 57410, 57412, 57415, 57420, 57430, 57440, 57445,
      57450, 57455, 57460, 57470, 57480, 57490, 57500 .. 57510,
      57515, 57520, 57525, 57530, 57535, 57540, 57550, 57560,
      57565, 57570, 57580, 57590, 57600 .. 57610, 57619 .. 57620,
      57630, 57635, 57640, 57645, 57650, 57655, 57660, 57670,
      57680, 57685, 57690, 57700 .. 57705, 57709 .. 57710,
      57720, 57730 .. 57731, 57739 .. 57740, 57747 .. 57748,
      57751, 57756 .. 57757, 57770, 57772, 57774,
      57777 .. 57778, 57780, 57790, 57800 .. 57801, 57803 .. 57805,
      57809 .. 57810, 57815, 57820, 57830, 57840, 57850, 57855,
      57860, 57865, 57870, 57880, 57890, 57905, 57910 .. 57913,
      57915 .. 57916, 57919 .. 57920, 57925, 57930, 57935, 57940,
      57950 .. 57955, 57957 .. 57960, 57970 .. 57974, 57978 .. 57980,
      57990, 58000 .. 58009, 58013 .. 58020, 58022 .. 58029,
      58033 .. 58034, 58036, 58039, 58110, 58120, 58130, 58140,
      58150, 58160, 58170, 58180, 58190, 58200 .. 58210,
      58220, 58230, 58240, 58250, 58260, 58270, 58290,
      58300 .. 58302, 58310, 58320, 58330, 58340, 58350, 58360,
      58370, 58380, 58390, 58400 .. 58405, 58410, 58420,
      58430, 58440, 58450, 58460, 58470, 58490, 58500 .. 58503,
      58508, 58530, 58600, 58640 .. 58643, 58649, 58660,
      58700, 58800, 59000 .. 59049, 59051 .. 59063, 59065 .. 59066,
      59069 .. 59074, 59078 .. 59084, 59086 .. 59088, 59091 .. 59092,
      59097, 59100, 59108, 59110 .. 59182, 59184 .. 59195,
      59198 .. 59200, 59202 .. 59203, 59207 .. 59227, 59229 .. 59247,
      59249 .. 59255, 59258 .. 59275, 59277 .. 59288, 59290,
      59292 .. 59297, 59299 .. 59322, 59326, 59328 .. 59339,
      59341, 59345 .. 59346, 59349 .. 59351, 59358 .. 59365,
      59370, 59373 .. 59383, 59385 .. 59386, 59389 .. 59393,
      59399 .. 59413, 59416, 59419 .. 59422, 59424 .. 59433,
      59435 .. 59437, 59440 .. 59453, 59455 .. 59458, 59460 .. 59468,
      59470 .. 59476, 59478 .. 59483, 59485 .. 59487, 59490 .. 59497,
      59500 .. 59510, 59520, 59522 .. 59524, 59529 .. 59532,
      59535 .. 59537, 59540 .. 59544, 59550 .. 59555, 59557 .. 59564,
      59567 .. 59573, 59580 .. 59584, 59586 .. 59590, 59600 .. 59608,
      59610 .. 59613, 59618, 59620, 59630, 59635, 59637,
      59639 .. 59640, 59650 .. 59667, 59669 .. 59673, 59677,
      59680 .. 59683, 59685 .. 59687, 59689 .. 59690, 59700 .. 59723,
      59726 .. 59727, 59730 .. 59735, 59740, 59750, 59760, 59770,
      59777, 59779 .. 59785, 59787 .. 59792, 59800,
      59810 .. 59818, 59820, 59830 .. 59832, 59838 .. 59840,
      59845, 59847 .. 59853, 59859 .. 59878, 59880 .. 59885,
      59887, 59889 .. 59900, 59910, 59920, 59930 .. 59933,
      59940 .. 59944, 59948, 59950 .. 59952, 59960 .. 59965,
      59967, 59970 .. 59972, 59975 .. 59976, 59979 .. 59981,
      59984, 59990, 59998,

      60000, 60002, 60004 .. 60019, 60021 .. 60029, 60031, 60035,
      60100 .. 60123, 60126 .. 60132, 60134, 60138, 60140 .. 60141,
      60149 .. 60150, 60153, 60155, 60157, 60160, 60162, 60170,
      60173, 60175, 60180 .. 60181, 60183 .. 60185, 60190,
      60200 .. 60210, 60220, 60230, 60240, 60250 .. 60252,
      60260, 60270 .. 60271, 60280 .. 60281, 60290 .. 60293,
      60299 .. 60321, 60323, 60329 .. 60330, 60332, 60340,
      60350, 60360, 60370, 60380, 60390, 60400 .. 60403,
      60406, 60409 .. 60410, 60420, 60430 .. 60437,
      60440, 60451, 60460, 60476 .. 60477, 60480, 60490,
      60500 .. 60501, 60503 .. 60504, 60506, 60508 .. 60510,
      60520, 60530, 60540 .. 60544, 60550 .. 60552, 60560, 60570,
      60580, 60590, 60600, 60602 .. 60603, 60607 .. 60612,
      60617 .. 60620, 60631 .. 60635, 60637 .. 60640, 60643,
      60646 .. 60650, 60660, 60671 .. 60672, 60674, 60677,
      60680, 60690, 60700, 60710 .. 60711, 60721 .. 60723,
      60729 .. 60732, 60734, 60740 .. 60745, 60749 .. 60751,
      60761 .. 60762, 60765, 60771 .. 60772, 60776 .. 60777,
      60779, 60790, 60800 .. 60805, 60810, 60820, 60831 .. 60833,
      60840, 60850, 60860, 60870 .. 60872, 60880, 60890,
      60902 .. 60903, 60908 .. 60909, 60911 .. 60912, 60921 .. 60924,
      60930 .. 60932, 60940, 60950, 60960, 60981, 61000 .. 61009,
      61011 .. 61019, 61021 .. 61024, 61041 .. 61042, 61051,
      61100 .. 61107, 61109 .. 61110, 61120, 61130, 61140, 61150,
      61160, 61170, 61190, 61200 .. 61206, 61208 .. 61210,
      61220, 61230, 61240, 61250, 61260, 61270, 61290,
      61300 .. 61306, 61310, 61320, 61330, 61340, 61350, 61360,
      61370, 61380, 61390, 61400, 61410, 61420, 61430, 61438,
      61440, 61448, 61450, 61458, 61470, 61490, 61500, 61550,
      61560, 61570, 61600, 61700, 61790, 61800, 61891, 61961,
      61984, 61992, 61994, 62000 .. 62005, 62007 .. 62034,
      62036, 62051 .. 62055, 62059 .. 62067, 62069 .. 62072,
      62079 .. 62081, 62089 .. 62092, 62100 .. 62114, 62116 .. 62124,
      62126 .. 62132, 62134, 62136 .. 62145, 62147,
      62149 .. 62153, 62155 .. 62162, 62164 .. 62166, 62169 .. 62170,
      62172 .. 62173, 62175 .. 62176, 62179 .. 62180, 62182, 62185,
      62187, 62189 .. 62194, 62196, 62199 .. 62207,
      62209 .. 62213, 62215, 62217 .. 62226, 62228,
      62230 .. 62232, 62240, 62242, 62245 .. 62260, 62270, 62280,
      62290, 62300 .. 62311, 62320 .. 62322, 62325, 62327,
      62330 .. 62336, 62340, 62350, 62360 .. 62361, 62370, 62380,
      62390, 62400 .. 62408, 62410 .. 62412, 62418 .. 62420,
      62430, 62440, 62450 .. 62453, 62459 .. 62460, 62470, 62480,
      62490, 62500 .. 62510, 62520, 62530, 62540, 62550,
      62560, 62570, 62575, 62580, 62590, 62600 .. 62604,
      62606, 62608 .. 62610, 62620, 62630, 62640, 62650,
      62660, 62670, 62680, 62690, 62700 .. 62702, 62709 .. 62710,
      62720, 62730, 62740, 62750, 62760, 62770, 62780, 62790,
      62800 .. 62806, 62809 .. 62810, 62820, 62830, 62840, 62850,
      62860, 62870, 62880 .. 62882, 62889 .. 62890, 62901 .. 62910,
      62920 .. 62923, 62929 .. 62930, 62940, 62950 .. 62955,
      62960, 62965 .. 62978, 62980, 62990, 63000 .. 63024,
      63028 .. 63040, 63042 .. 63046, 63049 .. 63051, 63054 .. 63058,
      63063 .. 63064, 63100, 63110 .. 63120, 63122, 63130,
      63140, 63150, 63160, 63170 .. 63175, 63177 .. 63178,
      63190, 63200 .. 63206, 63210, 63220, 63230, 63240,
      63250, 63260, 63270, 63290, 63300 .. 63308, 63310, 63320,
      63330, 63340, 63350, 63360, 63370, 63380, 63390,
      63400 .. 63410, 63420, 63430, 63440, 63450, 63460, 63470,
      63480, 63490, 63500 .. 63506, 63510, 63520, 63530, 63540,
      63550, 63560, 63570, 63580, 63590, 63600, 63610, 63620,
      63630, 63640, 63650, 63660, 63670, 63680, 63690, 63700,
      63710, 63720, 63730, 63740, 63750, 63760, 63770, 63780,
      63790, 63800 .. 63804, 63808, 63810, 63820, 63830,
      63840, 63850, 63870, 63880, 63890, 63900, 63910, 63920,
      63930, 63940, 63950, 63959 .. 63970, 63972, 63980,
      63990, 64000 .. 64004, 64006 .. 64008, 64010 .. 64013,
      64015 .. 64024, 64027 .. 64044, 64046, 64050 .. 64062,
      64064, 64071, 64075, 64078 .. 64082, 64086 .. 64087,
      64089 .. 64090, 64100 .. 64113, 64115 .. 64116, 64120 .. 64122,
      64130, 64140 .. 64143, 64145 .. 64148, 64150, 64160,
      64170, 64181 .. 64185, 64187, 64190, 64200 .. 64206,
      64208, 64210, 64220, 64230 .. 64238, 64240, 64250,
      64260, 64270, 64290, 64300 .. 64304, 64307, 64310,
      64320, 64330, 64340, 64350, 64360, 64370, 64390,
      64400 .. 64404, 64410, 64420, 64430, 64440, 64450, 64460,
      64470, 64480, 64490, 64500 .. 64506, 64510 .. 64511,
      64520, 64530, 64560, 64570, 64600 .. 64605, 64640, 64660,
      64680, 64700 .. 64705, 64780, 64800, 64811, 64870,
      64990, 65000 .. 65010, 65013 .. 65018, 65020 .. 65025,
      65100 .. 65108, 65110 .. 65112, 65116 .. 65117, 65120, 65130,
      65140, 65150, 65170 .. 65171, 65190, 65200 .. 65204,
      65220, 65230, 65240, 65250, 65260, 65270, 65290,
      65300 .. 65303, 65307 .. 65312, 65320 .. 65321, 65330, 65350,
      65360, 65370, 65380, 65390, 65400 .. 65402, 65410,
      65420 .. 65421, 65429 .. 65430, 65440, 65460, 65490,
      65500 .. 65503, 65510, 65560, 65590, 65600 .. 65601,
      65660, 65670, 65690, 65700 .. 65701, 65706, 65710,
      65800 .. 65801, 65901 .. 65905, 65907, 65911 .. 65912,
      65914 .. 65915, 65917 .. 65918, 65920 .. 65921, 65930,
      65950 .. 65951, 66000 .. 66006, 66011 .. 66015, 66017 .. 66021,
      66025 .. 66034, 66039, 66046, 66050, 66070, 66100 .. 66103,
      66110 .. 66113, 66120 .. 66123, 66130, 66140 .. 66141,
      66144 .. 66145, 66150, 66160 .. 66162, 66165, 66170,
      66180, 66190, 66200 .. 66202, 66210, 66220, 66230, 66240,
      66250, 66260, 66270, 66280, 66290, 66300 .. 66302,
      66310, 66320, 66330 .. 66331, 66334 .. 66335, 66339 .. 66340,
      66350, 66360, 66370, 66380, 66390, 66400 .. 66403,
      66410, 66420 .. 66423, 66430, 66440, 66450, 66460,
      66470, 66480, 66490, 66500 .. 66502, 66509 .. 66510,
      66530, 66540, 66550, 66560, 66570, 66600 .. 66602,
      66604 .. 66606, 66609 .. 66610, 66620, 66650 .. 66652,
      66659 .. 66660, 66664, 66670, 66680, 66690, 66700 .. 66704,
      66720, 66730, 66740, 66750 .. 66751, 66755, 66760,
      66800, 66820, 66830 .. 66832, 66836, 66845, 66850,
      66853 .. 66854, 66856, 66860, 66863, 66866, 66870, 66906,
      66921, 66931, 66933, 66940 .. 66941, 66945,
      66950 .. 66951, 66959 .. 66968, 66987, 67000 .. 67039,
      67043 .. 67046, 67059 .. 67061, 67064 .. 67065, 67067 .. 67071,
      67073 .. 67077, 67080 .. 67093, 67096, 67098 .. 67100,
      67102, 67109 .. 67110, 67112 .. 67118, 67120 .. 67126,
      67129 .. 67133, 67137 .. 67138, 67140 .. 67146, 67150 .. 67152,
      67155, 67158, 67160 .. 67163, 67165 .. 67167, 67169 .. 67173,
      67190, 67200 .. 67207, 67209 .. 67220, 67230 .. 67232,
      67234 .. 67235, 67239 .. 67243, 67249 .. 67250, 67260 .. 67262,
      67269 .. 67270, 67280, 67290, 67300 .. 67308, 67310 .. 67312,
      67318 .. 67320, 67330, 67340, 67350, 67360, 67370,
      67380 .. 67382, 67390, 67400 .. 67405, 67407 .. 67412,
      67420, 67430, 67440 .. 67441, 67450 .. 67460, 67470, 67480,
      67490, 67500 .. 67507, 67509 .. 67510, 67520 .. 67521,
      67530, 67540 .. 67542, 67550, 67560, 67570, 67580,
      67590, 67600 .. 67610, 67620, 67630, 67640, 67650,
      67660, 67670, 67680, 67690, 67700 .. 67710, 67720 .. 67728,
      67730, 67750, 67760, 67770, 67790, 67800 .. 67804,
      67807, 67809 .. 67810, 67820, 67831 .. 67834,
      67836, 67838 .. 67843, 67850, 67860, 67870, 67880,
      67891 .. 67892, 67900, 67905 .. 67907, 67909, 67911,
      67913, 67920 .. 67923, 67925 .. 67928, 67930 .. 67933,
      67942 .. 67944, 67948 .. 67949, 67952 .. 67953, 67955,
      67957 .. 67967, 67969 .. 67970, 67972, 67974 .. 67986,
      67990, 67999 .. 68010, 68012 .. 68027, 68029, 68040,
      68050 .. 68074, 68076 .. 68077, 68082 .. 68086, 68090 .. 68093,
      68097, 68099 .. 68100, 68110, 68116, 68118,
      68120 .. 68121, 68124 .. 68128, 68130 .. 68134, 68139 .. 68140,
      68150 .. 68153, 68159 .. 68160, 68170 .. 68173, 68180, 68190,
      68200, 68210, 68220 .. 68221, 68230, 68240, 68250,
      68260 .. 68265, 68270 .. 68274, 68280, 68290, 68300 .. 68317,
      68320, 68330 .. 68333, 68340, 68350, 68360, 68370,
      68380, 68390 .. 68393, 68399 .. 68400, 68410, 68420,
      68440, 68460, 68470, 68480, 68490, 68500 .. 68504,
      68509 .. 68510, 68520, 68530, 68540, 68550, 68560, 68570,
      68580, 68590, 68600, 68610, 68620, 68630, 68640, 68650,
      68660, 68680, 68690, 68700 .. 68705, 68720, 68730,
      68740, 68750, 68760, 68770, 68780, 68790, 68800 .. 68802,
      68804, 68806, 68809, 68820, 68830, 68840, 68850, 68870,
      68890, 68910, 68920 .. 68921, 68923, 68925, 68927, 68929,
      68941, 68943 .. 68945, 68947 .. 68950, 68960, 68968,
      68970, 68980, 68990, 69001 .. 69009, 69061 .. 69062,
      69064, 69100, 69110, 69115, 69120, 69124 .. 69126,
      69129 .. 69132, 69134, 69136, 69139 .. 69145, 69147 .. 69148,
      69150 .. 69154, 69159 .. 69161, 69170 .. 69173, 69190 .. 69192,
      69195, 69199 .. 69220, 69225 .. 69230, 69232, 69237,
      69239 .. 69247, 69250 .. 69253, 69255 .. 69272, 69275 .. 69276,
      69279 .. 69294, 69300 .. 69303, 69307, 69309 .. 69310,
      69316 .. 69317, 69319 .. 69322, 69326 .. 69330, 69336 .. 69367,
      69369 .. 69373, 69376 .. 69377, 69379 .. 69380, 69384 .. 69385,
      69389 .. 69406, 69408 .. 69461, 69463 .. 69470, 69472,
      69474 .. 69493, 69495, 69500 .. 69503, 69505,
      69509 .. 69520, 69530 .. 69531, 69540 .. 69544, 69550 .. 69553,
      69560 .. 69561, 69563 .. 69565, 69569 .. 69574, 69576,
      69578 .. 69583, 69590 .. 69595, 69600 .. 69613, 69615 .. 69616,
      69619 .. 69661, 69664 .. 69665, 69667, 69669 .. 69677,
      69679 .. 69680, 69682, 69684 .. 69687, 69689 .. 69694,
      69696, 69700 .. 69702, 69709, 69714, 69720,
      69726 .. 69727, 69729 .. 69732, 69735, 69740 .. 69747,
      69749, 69751, 69755, 69760, 69770 .. 69771, 69780,
      69790 .. 69795, 69800 .. 69806, 69808 .. 69809, 69811 .. 69814,
      69816 .. 69817, 69819 .. 69820, 69822 .. 69824, 69829 .. 69833,
      69836, 69840 .. 69841, 69850, 69860, 69870,
      69881 .. 69883, 69889 .. 69891, 69900 .. 69908, 69910,
      69921 .. 69926, 69930 .. 69939, 69942, 69945 .. 69949,
      69951 .. 69955, 69957, 69960 .. 69964, 69968 .. 69970,
      69998,

      70000 .. 70007, 70013 .. 70014, 70019 .. 70022, 70030,
      70100 .. 70104, 70110, 70120, 70130, 70140, 70150, 70160,
      70170, 70180, 70190, 70200 .. 70204, 70210, 70220,
      70230, 70240, 70250, 70270, 70280, 70290, 70300 .. 70304,
      70306, 70310, 70320, 70360, 70400, 70440, 70500, 70600,
      70700, 70800, 70807, 71000 .. 71012, 71017 .. 71029,
      71031, 71040, 71049, 71100 .. 71110, 71118, 71120,
      71130, 71140, 71150, 71160, 71170, 71190, 71200 .. 71206,
      71209 .. 71210, 71220, 71230, 71240, 71250, 71260, 71270,
      71290, 71300 .. 71310, 71320 .. 71328, 71330 .. 71337,
      71339 .. 71340, 71350, 71360, 71370, 71380, 71390,
      71400 .. 71405, 71407 .. 71410, 71420, 71430, 71440, 71450,
      71460, 71470, 71480, 71490, 71500 .. 71503, 71509 .. 71510,
      71520, 71530, 71540, 71550, 71570, 71580, 71590,
      71600 .. 71604, 71609, 71620, 71640, 71670, 71680, 71700,
      71710, 71740, 71760, 71800, 71850, 71870, 71880, 71960,
      71990, 72000 .. 72011, 72013 .. 72016, 72018 .. 72019,
      72021, 72024 .. 72030, 72032 .. 72045, 72047 .. 72049,
      72051 .. 72052, 72055, 72058 .. 72059, 72070 .. 72073,
      72075, 72079 .. 72089, 72091 .. 72093, 72095 .. 72096,
      72100, 72109 .. 72110, 72120, 72130, 72140, 72150,
      72160, 72170, 72190, 72200 .. 72203, 72205 .. 72206,
      72208, 72210, 72220, 72230 .. 72234, 72236 .. 72237,
      72239 .. 72240, 72250, 72260, 72270, 72290, 72300 .. 72305,
      72308 .. 72310, 72320, 72330, 72340, 72350, 72360, 72370,
      72380, 72390, 72400 .. 72407, 72409, 72430, 72440, 72450,
      72460, 72470, 72500, 72510, 72530, 72540, 72550, 72560,
      72600, 72610, 72650, 72700, 72702 .. 72705, 72800, 72902,
      72908, 73000 .. 73011, 73014 .. 73022, 73024 .. 73026,
      73031, 73065, 73073, 73079, 73089, 73091, 73094,
      73100 .. 73110, 73120 .. 73124, 73127, 73129 .. 73130,
      73140, 73150 .. 73155, 73157, 73159 .. 73160,
      73170, 73190 .. 73193, 73199 .. 73212, 73214, 73216,
      73219 .. 73221, 73223 .. 73225, 73229 .. 73232, 73235,
      73239 .. 73240, 73250, 73260 .. 73261, 73264 .. 73265,
      73269 .. 73270, 73276 .. 73277, 73290 .. 73292, 73294 .. 73295,
      73299 .. 73303, 73309 .. 73310, 73320 .. 73322, 73329 .. 73330,
      73340, 73350, 73360, 73370 .. 73379, 73381 .. 73382,
      73390, 73400 .. 73403, 73409 .. 73410, 73420, 73440,
      73450, 73460, 73470, 73480, 73490 .. 73494, 73499 .. 73500,
      73520, 73530, 73540, 73550, 73570 .. 73573, 73579, 73590,
      73600 .. 73604, 73609 .. 73610, 73620, 73630, 73640, 73660,
      73670, 73700 .. 73705, 73708 .. 73710, 73720, 73730,
      73790, 73800 .. 73802, 73804 .. 73809, 73870,
      74000 .. 74016, 74020 .. 74021, 74024 .. 74025, 74034, 74036,
      74040 .. 74041, 74054 .. 74055, 74059, 74100 .. 74113,
      74120, 74130 .. 74137, 74139 .. 74140, 74150 .. 74166,
      74169 .. 74170, 74190, 74200 .. 74210, 74220, 74230,
      74240, 74250, 74260, 74270, 74290, 74300 .. 74305,
      74307 .. 74311, 74314, 74320, 74330 .. 74334, 74337 .. 74340,
      74350, 74360, 74370 .. 74374, 74380, 74390, 74400 .. 74405,
      74409 .. 74410, 74420, 74430, 74440, 74450, 74460, 74470,
      74480, 74490, 74500 .. 74503, 74509, 74520, 74540, 74550,
      74560, 74570, 74580, 74600 .. 74607, 74609, 74650,
      74660, 74700 .. 74704, 74706, 74709, 74740,
      74800 .. 74809, 74890, 74910, 74920, 74930, 74940 .. 74946,
      74949 .. 74954, 74960 .. 74964, 74966, 74969 .. 74970,
      74981 .. 74982, 74984 .. 74991, 74993 .. 75021, 75023 .. 75024,
      75026, 75028 .. 75036, 75038 .. 75049, 75051 .. 75056,
      75058 .. 75069, 75072 .. 75090, 75092 .. 75097, 75100 .. 75116,
      75118 .. 75120, 75122 .. 75131, 75134, 75138 .. 75142,
      75144, 75150 .. 75159, 75161 .. 75172, 75174,
      75176 .. 75177, 75179 .. 75182, 75184, 75186, 75188 .. 75189,
      75191 .. 75192, 75194 .. 75198, 75201 .. 75224, 75226 .. 75241,
      75243 .. 75244, 75248, 75250, 75252 .. 75253, 75256,
      75260 .. 75266, 75269 .. 75270, 75272, 75275, 75278 .. 75284,
      75288, 75290 .. 75292, 75294 .. 75295, 75298 .. 75299,
      75302 .. 75315, 75317 .. 75330, 75333, 75335, 75337 .. 75345,
      75348 .. 75350, 75352 .. 75353, 75355 .. 75367, 75370 .. 75376,
      75378 .. 75392, 75394 .. 75403, 75405 .. 75408, 75410 .. 75413,
      75415 .. 75432, 75434 .. 75447, 75449 .. 75460, 75462 .. 75468,
      75470 .. 75488, 75490 .. 75493, 75495 .. 75499, 75502 .. 75512,
      75521 .. 75528, 75533 .. 75538, 75540 .. 75548, 75550 .. 75558,
      75560 .. 75589, 75591 .. 75614, 75616 .. 75644, 75646 .. 75665,
      75667 .. 75671, 75673 .. 75675, 75677 .. 75683, 75685,
      75687 .. 75694, 75696 .. 75703, 75705 .. 75710, 75712 .. 75727,
      75729 .. 75732, 75734, 75737 .. 75743, 75745,
      75747 .. 75750, 75753 .. 75757, 75759, 75761 .. 75773,
      75775, 75778, 75780 .. 75786, 75789 .. 75790, 75794, 75796,
      75798 .. 75800, 75802 .. 75809, 75812 .. 75813, 75815,
      75817 .. 75841, 75843 .. 75855, 75857 .. 75858, 75860 .. 75872,
      75874 .. 75887, 75889 .. 75895, 75897 .. 75905, 75907 .. 75909,
      75911, 75913 .. 75962, 75965 .. 75967, 75969 .. 75981,
      75983 .. 75991, 75993 .. 75998, 76000 .. 76008, 76011 .. 76012,
      76017 .. 76022, 76024 .. 76026, 76028 .. 76033, 76035 .. 76047,
      76049 .. 76072, 76074, 76079 .. 76080, 76083 .. 76087,
      76092 .. 76101, 76107 .. 76111, 76113, 76116 .. 76117,
      76119 .. 76125, 76127, 76129 .. 76144, 76150 .. 76153,
      76155, 76159 .. 76161, 76164, 76170 .. 76179,
      76181, 76183, 76185 .. 76197, 76200 .. 76210, 76220,
      76230 .. 76233, 76235 .. 76240, 76250, 76260, 76270, 76280,
      76290, 76300 .. 76306, 76308, 76310, 76320, 76330,
      76340, 76350, 76360, 76370, 76379 .. 76380, 76390,
      76400 .. 76405, 76409 .. 76410, 76418 .. 76420, 76430, 76440,
      76450, 76460, 76470, 76480, 76490, 76500 .. 76504,
      76509 .. 76510, 76520, 76530, 76540, 76550, 76560, 76570,
      76580, 76590, 76600, 76610, 76620, 76630, 76640, 76650,
      76660, 76680, 76690, 76700, 76710, 76720 .. 76721,
      76723, 76730, 76740, 76750, 76760, 76770, 76780, 76790,
      76800 .. 76810, 76821, 76823 .. 76825, 76840, 76850,
      76860, 76870, 76880 .. 76885, 76887, 76890, 76900, 76902,
      76910, 76914 .. 76915, 76917, 76920, 76925 .. 76927,
      76929 .. 76930, 76934 .. 76935, 76940, 76945, 76950, 76960,
      76970, 76980, 77000 .. 77021, 77023 .. 77028, 77039 .. 77043,
      77050 .. 77052, 77090, 77100 .. 77115, 77118, 77120,
      77122 .. 77124, 77126 .. 77127, 77130 .. 77131, 77133 .. 77135,
      77138 .. 77141, 77144 .. 77145, 77148, 77150 .. 77151,
      77154, 77157, 77160, 77163 .. 77167, 77169 .. 77171,
      77173 .. 77174, 77176 .. 77178, 77181, 77183 .. 77187,
      77190 .. 77225, 77229 .. 77232, 77234, 77239 .. 77243,
      77246 .. 77255, 77257, 77259 .. 77264, 77266,
      77270 .. 77272, 77280 .. 77282, 77290 .. 77305, 77307 .. 77316,
      77318 .. 77320, 77327, 77330 .. 77335, 77337,
      77340 .. 77344, 77346 .. 77353, 77360, 77370, 77380 .. 77382,
      77384 .. 77385, 77388 .. 77390, 77400 .. 77405, 77407,
      77409 .. 77417, 77419 .. 77427, 77429 .. 77437, 77439 .. 77448,
      77450 .. 77455, 77458, 77460, 77462 .. 77465, 77467 .. 77470,
      77480 .. 77484, 77486 .. 77489, 77500 .. 77510, 77515,
      77520 .. 77529, 77540 .. 77570, 77580 .. 77583, 77585, 77590,
      77600 .. 77612, 77614 .. 77617, 77620, 77630, 77640 .. 77641,
      77645 .. 77646, 77649 .. 77650, 77660, 77670, 77680, 77690,
      77700 .. 77706, 77708 .. 77711, 77714 .. 77717, 77720 .. 77723,
      77730, 77750, 77760, 77771 .. 77772, 77776 .. 77780,
      77791 .. 77796, 77798 .. 77799, 77810 .. 77811, 77813 .. 77820,
      77830 .. 77835, 77837 .. 77840, 77850, 77860, 77870 .. 77873,
      77875 .. 77876, 77879 .. 77880, 77890, 77910, 77920, 77923,
      77930 .. 77933, 77939 .. 77940, 77950 .. 77951, 77961, 77970,
      77981 .. 77983, 77986, 77989 .. 77990, 78000 .. 78015,
      78017 .. 78022, 78024, 78026 .. 78030, 78032 .. 78035,
      78041 .. 78049, 78051 .. 78057, 78059 .. 78062, 78064 .. 78067,
      78071, 78078 .. 78079, 78081 .. 78089, 78091 .. 78096,
      78099 .. 78102, 78104 .. 78106, 78108 .. 78122, 78124 .. 78126,
      78129 .. 78135, 78139 .. 78143, 78145 .. 78155, 78157 .. 78160,
      78162 .. 78167, 78169 .. 78174, 78177, 78179 .. 78186,
      78188 .. 78210, 78212, 78214, 78219 .. 78223, 78229 .. 78234,
      78239 .. 78244, 78249 .. 78250, 78260, 78270, 78280 .. 78294,
      78299 .. 78304, 78306 .. 78317, 78319 .. 78322, 78330 .. 78331,
      78339 .. 78342, 78344 .. 78346, 78349 .. 78356, 78359 .. 78364,
      78368, 78370 .. 78380, 78390 .. 78391, 78395,
      78400 .. 78404, 78409 .. 78413, 78415 .. 78417, 78419 .. 78424,
      78429 .. 78431, 78439 .. 78440, 78450 .. 78451, 78457 .. 78458,
      78460, 78470 .. 78472, 78479 .. 78480, 78490,
      78500 .. 78507, 78509 .. 78515, 78519 .. 78520, 78530 .. 78536,
      78539 .. 78540, 78550, 78560, 78570, 78580, 78590 .. 78592,
      78599 .. 78606, 78609 .. 78610, 78612, 78619 .. 78620,
      78630, 78640, 78650, 78660, 78670, 78680, 78690,
      78700 .. 78703, 78705, 78709 .. 78715, 78718, 78720,
      78730, 78740, 78750, 78760, 78770 .. 78771, 78778 .. 78780,
      78790, 78800 .. 78806, 78809 .. 78810, 78820, 78830,
      78840, 78850 .. 78852, 78854, 78859 .. 78860,
      78870, 78881 .. 78886, 78890, 78897, 78910, 78915,
      78920 .. 78931, 78940 .. 78946, 78948 .. 78950, 78955, 78960,
      78970, 78980, 78990, 78995 .. 78997, 79000 .. 79018,
      79021 .. 79039, 79041 .. 79046, 79049 .. 79056, 79059 .. 79061,
      79068 .. 79077, 79079 .. 79088, 79091 .. 79093, 79098 .. 79106,
      79109 .. 79110, 79120, 79130, 79140 .. 79145, 79150, 79160,
      79170, 79180 .. 79182, 79184 .. 79185, 79189 .. 79190,
      79200 .. 79206, 79208 .. 79210, 79220, 79230 .. 79234,
      79240, 79250, 79260, 79270, 79290, 79300 .. 79310,
      79320, 79330, 79340, 79350, 79360, 79370, 79380, 79390,
      79400 .. 79404, 79409 .. 79410, 79420, 79430, 79440, 79450,
      79460, 79500, 79510, 79600, 79700, 79800, 79939, 79950,
      79953,

      80000 .. 80017, 80019 .. 80023, 80025 .. 80034, 80036 .. 80044,
      80046 .. 80051, 80054 .. 80057, 80060 .. 80064, 80068 .. 80069,
      80075, 80080 .. 80097, 80099 .. 80110, 80115, 80118,
      80120, 80122, 80130 .. 80132, 80134 .. 80136, 80140,
      80142 .. 80146, 80150, 80160, 80170, 80190, 80200 .. 80206,
      80208 .. 80210, 80220, 80230, 80240, 80250, 80260, 80270,
      80290, 80300 .. 80303, 80309 .. 80310, 80320,
      80330 .. 80336, 80339 .. 80340, 80350, 80360, 80370, 80390,
      80400, 80410, 80420, 80430, 80440, 80450, 80460, 80470,
      80480, 80490, 80500, 80510, 80520, 80531 .. 80535,
      80539 .. 80540, 80550, 80560, 80570, 80580, 80600, 80610,
      80620, 80630, 80640, 80650, 80670, 80680, 80690, 80700,
      80710, 80740, 80750, 80770, 80780, 80800, 80820, 80830,
      80850, 80860, 80870, 80880, 80890 .. 80891, 80910, 80919,
      80960, 80970, 80980, 81000 .. 81007, 81011 .. 81023,
      81025 .. 81028, 81030 .. 81031, 81034 .. 81039, 81090,
      81100 .. 81110, 81115 .. 81116, 81120, 81130, 81140, 81150,
      81160, 81170, 81190, 81200 .. 81210, 81215, 81220,
      81230, 81240, 81250, 81260, 81270, 81290, 81300 .. 81305,
      81310, 81320, 81330, 81340, 81350, 81360, 81370, 81380,
      81390, 81400, 81430, 81440, 81450, 81470, 81490,
      81500 .. 81503, 81506, 81509, 81530, 81540, 81570, 81580,
      81600 .. 81605, 81609, 81630, 81640, 81660, 81700, 81710,
      81800, 81990, 82000 .. 82006, 82008 .. 82009, 82013 .. 82015,
      82017, 82019, 82024, 82027, 82030, 82032 .. 82033,
      82037, 82040, 82047 .. 82048, 82053 .. 82054, 82057, 82060,
      82065, 82067, 82070, 82077, 82080, 82087, 82100 .. 82104,
      82109 .. 82110, 82120, 82130, 82140, 82150, 82160, 82170,
      82190, 82200 .. 82202, 82208, 82210, 82220, 82230,
      82240, 82250, 82270, 82290, 82300 .. 82303, 82330, 82340,
      82350, 82360, 82370, 82390, 82400 .. 82403, 82410, 82440,
      82500, 82600, 82700, 82710, 82800, 83000 .. 83008,
      83012 .. 83016, 83019, 83030, 83036, 83038, 83040 .. 83042,
      83048 .. 83065, 83069 .. 83071, 83076 .. 83095, 83097 .. 83100,
      83107 .. 83108, 83110 .. 83111, 83119 .. 83120, 83130 .. 83131,
      83136, 83140, 83143, 83149 .. 83150, 83160 .. 83164,
      83166 .. 83167, 83170 .. 83177, 83179 .. 83181, 83183 .. 83185,
      83187 .. 83192, 83196, 83199 .. 83200, 83210, 83220,
      83230 .. 83231, 83236 .. 83238, 83240, 83250, 83260, 83270,
      83300, 83310 .. 83317, 83320, 83330, 83340, 83350,
      83370 .. 83372, 83379 .. 83380, 83390, 83400 .. 83409,
      83411 .. 83412, 83418, 83420, 83430, 83440, 83460, 83470,
      83480 .. 83490, 83500 .. 83504, 83507, 83509 .. 83512,
      83514, 83518, 83520, 83530, 83550, 83560, 83570, 83580,
      83590, 83600 .. 83604, 83606, 83608 .. 83610,
      83613 .. 83616, 83618, 83630, 83640, 83660, 83670, 83680,
      83690, 83700 .. 83705, 83707, 83720, 83740, 83780,
      83790, 83800, 83820, 83830, 83840, 83860, 83870, 83890,
      83910, 83920, 83951 .. 83954, 83957, 83980, 83990 .. 83998,
      84000, 84004 .. 84011, 84013 .. 84016, 84018 .. 84019,
      84021 .. 84025, 84027, 84029, 84031 .. 84036, 84041 .. 84051,
      84054, 84056, 84058 .. 84059, 84071 .. 84072, 84077 .. 84078,
      84081 .. 84085, 84090 .. 84110, 84120 .. 84124, 84130 .. 84135,
      84139 .. 84144, 84147, 84149 .. 84150, 84160, 84170,
      84190, 84200 .. 84210, 84220, 84230 .. 84232,
      84240, 84250, 84260, 84270 .. 84279, 84290,
      84300 .. 84310, 84320, 84330, 84340, 84350, 84360, 84370,
      84380, 84390, 84400 .. 84405, 84410, 84420, 84430, 84440,
      84450, 84460, 84470, 84480, 84490, 84500 .. 84505,
      84507, 84510, 84530, 84550, 84560, 84570, 84580,
      84600 .. 84603, 84609, 84660, 84700 .. 84706, 84740, 84750,
      84760, 84800 .. 84805, 84808, 84810, 84820, 84830,
      84840, 84850, 84860, 84870 .. 84874, 84878,
      84901 .. 84902, 84905, 84909, 84911 .. 84919, 84951 .. 84954,
      84956, 84961, 84963 .. 84965, 84967 .. 84969, 84971 .. 84973,
      84976 .. 84977, 85000 .. 85010, 85012 .. 85013, 85015 .. 85021,
      85023 .. 85024, 85026, 85033, 85035 .. 85036, 85100 .. 85111,
      85113 .. 85114, 85118 .. 85120, 85130 .. 85133, 85139 .. 85140,
      85150, 85160 .. 85165, 85167, 85169 .. 85170,
      85180, 85190, 85200 .. 85206, 85208 .. 85210, 85220, 85230,
      85240, 85250, 85260, 85270, 85280, 85290 .. 85292,
      85299 .. 85307, 85309 .. 85310, 85320, 85330, 85340 .. 85342,
      85350, 85360, 85370, 85390, 85400 .. 85404, 85406 .. 85407,
      85409 .. 85410, 85420, 85430, 85440, 85450, 85460, 85470,
      85480, 85490, 85500 .. 85506, 85509 .. 85510, 85520, 85530,
      85540, 85550, 85560, 85570, 85580, 85590, 85600 .. 85604,
      85607, 85609 .. 85610, 85612 .. 85616, 85620, 85630,
      85640, 85660, 85670, 85680, 85690, 85700, 85702 .. 85703,
      85707 .. 85710, 85740, 85750, 85770, 85800, 85803 .. 85806,
      85809, 85919, 85921 .. 85928, 85930 .. 85934, 86000 .. 86013,
      86020 .. 86023, 86029 .. 86030, 86034 .. 86036, 86038,
      86042 .. 86047, 86050 .. 86056, 86060 .. 86063, 86065 .. 86069,
      86071 .. 86074, 86076, 86080 .. 86098, 86100 .. 86110,
      86117, 86120, 86130 .. 86135, 86137 .. 86140, 86150, 86160,
      86170, 86180, 86190, 86200 .. 86202, 86204, 86206,
      86209 .. 86210, 86220, 86230, 86240, 86250, 86260, 86270,
      86280 .. 86282, 86289 .. 86290, 86300, 86310, 86320, 86330,
      86340, 86350, 86360 .. 86362, 86369 .. 86370, 86380, 86390,
      86400, 86410, 86420, 86430, 86440, 86450, 86460, 86470,
      86480, 86490, 86500 .. 86502, 86508 .. 86510, 86530, 86540,
      86550, 86580, 86600, 86610, 86700, 86800, 86905, 86910,
      86960 .. 86964, 86969, 86980 .. 86984, 87000 .. 87013,
      87015 .. 87018, 87020 .. 87023, 87025 .. 87026, 87030 .. 87034,
      87036 .. 87055, 87058 .. 87061, 87065 .. 87071, 87073 .. 87085,
      87089 .. 87090, 87100, 87110, 87120, 87130, 87140, 87150,
      87160, 87170, 87190, 87200 .. 87203, 87205 .. 87206,
      87210, 87220 .. 87223, 87230, 87240, 87250, 87260,
      87270, 87280, 87290, 87300, 87310, 87320, 87330, 87340,
      87350, 87360, 87370, 87380, 87400, 87410, 87420, 87430,
      87440, 87460, 87470, 87480, 87500, 87510, 87520, 87570,
      87590, 87600, 87620, 87640, 87700, 87720, 87800, 87890,
      87900, 87919 .. 87920, 87930, 87950, 88000 .. 88018,
      88020 .. 88021, 88025 .. 88027, 88029, 88033, 88050 .. 88051,
      88060, 88084 .. 88086, 88088 .. 88089, 88099 .. 88110,
      88120 .. 88123, 88125, 88127, 88129 .. 88133, 88139 .. 88143,
      88149 .. 88156, 88160 .. 88162, 88165, 88169 .. 88170,
      88187, 88190 .. 88195, 88198 .. 88207, 88209 .. 88214,
      88220, 88230, 88240, 88250, 88260, 88270, 88290,
      88300 .. 88307, 88310, 88320, 88330, 88340, 88350, 88360,
      88370, 88380, 88390, 88400 .. 88403, 88405 .. 88410,
      88420, 88430, 88440, 88450, 88460, 88470, 88480, 88490,
      88500 .. 88504, 88507, 88509 .. 88510, 88520, 88530,
      88540, 88550, 88560, 88580, 88600, 88630, 88640, 88650,
      88700, 88800 .. 88805, 88809, 89000 .. 89007,
      89009 .. 89012, 89015 .. 89016, 89019 .. 89030, 89089 .. 89095,
      89099 .. 89110, 89113, 89116, 89120, 89130, 89140, 89144,
      89150, 89160, 89170, 89190, 89200 .. 89207, 89209 .. 89210,
      89220, 89230, 89240, 89250, 89260, 89270, 89290,
      89300 .. 89307, 89309 .. 89310, 89320, 89330 .. 89331,
      89340, 89350, 89360, 89380, 89390, 89400, 89410, 89420,
      89430, 89440, 89450, 89460, 89470, 89480, 89500, 89510,
      89515, 89520, 89525, 89530, 89550, 89560, 89570, 89580,
      89600, 89630, 89660, 89690, 89700, 89710, 89740,
      89770 .. 89772, 89800,

      90000 .. 90016, 90018 .. 90023, 90025, 90040, 90100 .. 90101,
      90110, 90120, 90130, 90140, 90150, 90160, 90170, 90200,
      90300, 90330, 90340, 90350, 90360, 90370, 90380, 90400,
      90500, 90600, 90700, 90800, 90850, 91000 .. 91059,
      91070 .. 91072, 91074, 91077 .. 91080, 91090, 91097,
      91100 .. 91109, 91120 .. 91133, 91135 .. 91137, 91140 .. 91142,
      91146, 91149 .. 91154, 91156 .. 91174, 91177 .. 91180,
      91190 .. 91201, 91204 .. 91205, 91207, 91209 .. 91211,
      91213 .. 91214, 91220 .. 91230, 91240 .. 91241, 91250,
      91260 .. 91263, 91265 .. 91270, 91280, 91290 .. 91292,
      91294 .. 91312, 91314 .. 91315, 91320 .. 91325, 91328 .. 91335,
      91339 .. 91351, 91353 .. 91355, 91359 .. 91360, 91370 .. 91371,
      91374, 91380 .. 91390, 91400 .. 91407, 91409 .. 91410,
      91412, 91414 .. 91418, 91420 .. 91430, 91440, 91450,
      91460 .. 91463, 91470, 91480, 91490, 91510, 91520, 91530,
      91540 .. 91542, 91549 .. 91551, 91560, 91570 .. 91574,
      91578 .. 91580, 91590, 91600 .. 91603, 91605,
      91609 .. 91610, 91612 .. 91613, 91619 .. 91620, 91625, 91630,
      91640, 91650, 91660, 91670, 91680, 91690 .. 91713,
      91720, 91730, 91740 .. 91750, 91760 .. 91764, 91767, 91770,
      91780 .. 91781, 91783, 91790 .. 91792, 91800 .. 91807,
      91809 .. 91815, 91820 .. 91821, 91830, 91840 .. 91841,
      91849 .. 91852, 91855, 91860 .. 91861, 91870 .. 91887,
      91889 .. 91896, 91898 .. 91899, 91910 .. 91917, 91919,
      91921 .. 91924, 91930, 91940 .. 91949, 91951 .. 91959,
      91961 .. 91969, 91971 .. 91979, 91981 .. 91986, 91988,
      92000 .. 92029, 92033 .. 92061, 92063 .. 92079, 92081 .. 92089,
      92092 .. 92093, 92095 .. 92106, 92108 .. 92179, 92181 .. 92186,
      92188 .. 92191, 92193 .. 92196, 92199 .. 92206, 92208 .. 92216,
      92219 .. 92235, 92237 .. 92247, 92249 .. 92254, 92256 .. 92263,
      92266, 92269 .. 92275, 92279 .. 92282, 92284,
      92286 .. 92288, 92290 .. 92293, 92295 .. 92298, 92300 .. 92314,
      92316 .. 92333, 92337, 92339 .. 92342, 92350 .. 92357,
      92359 .. 92366, 92369 .. 92370, 92372, 92379 .. 92380,
      92388, 92390 .. 92420, 92423, 92430, 92438,
      92441 .. 92445, 92447 .. 92448, 92454, 92499 .. 92509,
      92511, 92513 .. 92514, 92516 .. 92519, 92521 .. 92525,
      92527 .. 92529, 92531 .. 92538, 92541 .. 92546, 92552 .. 92553,
      92555, 92561 .. 92567, 92569, 92571, 92573 .. 92578,
      92581 .. 92588, 92591 .. 92607, 92609, 92611, 92613 .. 92616,
      92622, 92624, 92631 .. 92638, 92641 .. 92643, 92645,
      92649 .. 92651, 92653 .. 92656, 92658 .. 92660, 92665,
      92671 .. 92672, 92675, 92677, 92679, 92682 .. 92686,
      92688 .. 92689, 92691, 92693, 92695, 92698, 92700 .. 92709,
      92711 .. 92715, 92721 .. 92722, 92725 .. 92730, 92735 .. 92739,
      92741 .. 92745, 92747 .. 92748, 92751 .. 92752, 92755 .. 92756,
      92758, 92761 .. 92764, 92766 .. 92768, 92772 .. 92774,
      92776, 92779, 92781 .. 92789, 92791 .. 92809, 92811, 92813,
      92815 .. 92824, 92842 .. 92848, 92851 .. 92856, 92859,
      92861 .. 92867, 92881 .. 92887, 92889, 92891 .. 92898,
      92901 .. 92904, 92906 .. 92909, 92911 .. 92939, 92959,
      92970 .. 92975, 92977 .. 92981, 92983 .. 92989, 92999 .. 93003,
      93005 .. 93009, 93011 .. 93014, 93016 .. 93018, 93021 .. 93022,
      93024, 93100 .. 93108, 93110 .. 93112, 93114 .. 93118,
      93120 .. 93123, 93126 .. 93127, 93130 .. 93131, 93133 .. 93136,
      93140 .. 93158, 93160 .. 93172, 93174 .. 93177, 93181 .. 93184,
      93186 .. 93197, 93199 .. 93214, 93216 .. 93222, 93230 .. 93231,
      93233, 93235, 93240 .. 93241, 93245, 93250, 93260 .. 93261,
      93270 .. 93271, 93274 .. 93275, 93282 .. 93286, 93290, 93294,
      93297, 93300 .. 93308, 93310 .. 93311, 93315,
      93320 .. 93325, 93330 .. 93332, 93334 .. 93337, 93340 .. 93346,
      93348 .. 93352, 93360 .. 93366, 93370, 93380 .. 93382,
      93390, 93400 .. 93408, 93410 .. 93412, 93420 .. 93424,
      93430 .. 93431, 93436 .. 93437, 93440 .. 93441, 93450 .. 93451,
      93453 .. 93458, 93460 .. 93465, 93470, 93472 .. 93473,
      93479, 93481 .. 93487, 93489, 93493, 93500 .. 93508,
      93511 .. 93517, 93521 .. 93524, 93526 .. 93528, 93531 .. 93539,
      93541, 93544 .. 93545, 93547, 93554 .. 93556,
      93558, 93561 .. 93564, 93571, 93574 .. 93578,
      93581 .. 93589, 93591, 93593, 93600 .. 93606, 93608 .. 93609,
      93611 .. 93619, 93621 .. 93623, 93627, 93631, 93691 .. 93701,
      93705, 93711 .. 93712, 93719, 93731, 93733 .. 93734,
      93736 .. 93738, 93761, 93800 .. 93802, 93806 .. 93807,
      93812 .. 93816, 93881, 93883 .. 93885, 93887, 93891,
      93899, 93901, 93907 .. 93909, 94000 .. 94049, 94051 .. 94055,
      94094, 94100 .. 94166, 94169 .. 94175, 94190 .. 94197,
      94199 .. 94211, 94214, 94219 .. 94244, 94246 .. 94247,
      94249 .. 94279, 94281, 94290, 94300 .. 94312, 94319 .. 94322,
      94324, 94327, 94340 .. 94345, 94349 .. 94351, 94353 .. 94357,
      94359 .. 94366, 94368 .. 94396, 94398 .. 94415, 94417,
      94419 .. 94420, 94430 .. 94440, 94450 .. 94457, 94459 .. 94460,
      94470 .. 94480, 94490, 94500 .. 94528, 94531 .. 94539,
      94541 .. 94544, 94546 .. 94553, 94561 .. 94569, 94571 .. 94579,
      94581 .. 94589, 94591 .. 94604, 94606 .. 94607, 94609,
      94611 .. 94614, 94616 .. 94619, 94621 .. 94623, 94626 .. 94628,
      94631 .. 94639, 94641 .. 94645, 94647 .. 94648, 94651,
      94653 .. 94654, 94656 .. 94659, 94661, 94663 .. 94664,
      94667, 94669, 94671 .. 94679, 94681 .. 94688, 94700 .. 94704,
      94706 .. 94707, 94709 .. 94715, 94719, 94721 .. 94729,
      94731 .. 94739, 94741 .. 94745, 94748 .. 94749, 94761 .. 94768,
      94781 .. 94785, 94789, 94800 .. 94809, 94811 .. 94819,
      94831 .. 94833, 94839, 94851 .. 94859, 94861 .. 94867,
      94869, 94880, 94891 .. 94894, 94941 .. 94942, 94945 .. 94949,
      94951 .. 94956, 94958 .. 94959, 94961 .. 94966, 94968,
      94971 .. 94978, 95000 .. 95008, 95010 .. 95025, 95027 .. 95038,
      95040 .. 95042, 95046, 95050 .. 95056, 95059 .. 95067,
      95069 .. 95079, 95090 .. 95098, 95100 .. 95112, 95117 .. 95127,
      95129 .. 95135, 95137, 95139 .. 95146, 95150 .. 95155,
      95157 .. 95162, 95165, 95169 .. 95170, 95180,
      95190 .. 95207, 95209 .. 95224, 95226, 95228 .. 95234,
      95239 .. 95240, 95250 .. 95252, 95259 .. 95260, 95270, 95280,
      95290, 95300 .. 95304, 95306, 95309 .. 95316,
      95318 .. 95324, 95328 .. 95335, 95340, 95350 .. 95351,
      95355, 95360, 95370, 95379 .. 95380, 95390, 95400,
      95410 .. 95412, 95419 .. 95420, 95430, 95440 .. 95441,
      95445, 95450, 95460 .. 95461, 95470 .. 95480, 95490,
      95500 .. 95510, 95520 .. 95530, 95540, 95550 .. 95551,
      95559 .. 95560, 95570 .. 95571, 95573, 95580, 95590,
      95600 .. 95605, 95609 .. 95620, 95630, 95640, 95650 .. 95652,
      95659 .. 95660, 95670, 95680, 95690 .. 95693, 95696 .. 95697,
      95700 .. 95713, 95715 .. 95716, 95719 .. 95727, 95731 .. 95734,
      95740 .. 95742, 95747, 95750, 95760 .. 95761, 95769 .. 95770,
      95780, 95800 .. 95816, 95820, 95830, 95840,
      95842 .. 95844, 95850, 95861 .. 95866, 95868,
      95870 .. 95877, 95879 .. 95880, 95891 .. 95892, 95897,
      95901 .. 95902, 95905, 95907 .. 95908, 95911 .. 95913,
      95915 .. 95916, 95919 .. 95928, 95930 .. 95934, 95940 .. 95954,
      95956 .. 95959, 95970 .. 95978, 98799,;

}

__END__
