#use DBI 1.03;
#use DBI::DBD;
use ExtUtils::MakeMaker;

# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.
WriteMakefile(
    'NAME'	=> 'DBD::LDAP',
    'VERSION_FROM' => 'lib/DBD/LDAP.pm', # finds $VERSION
    'INC'	=> '',
    'dist'	=> {
        'SUFFIX' => '.gz',
        'COMPRESS' => 'gzip -9f'
    },
    'realclean'	=> {FILES => '*.xsi'},
    'PREREQ_PM' => {
        'DBI' => 1.03,
        'Net::LDAP' => 0.01
    },
    'CONFIGURE'    => sub {
        eval {require DBI;};
        if ($@) {
            warn $@;
            exit 0;
        }
        eval {require DBI::DBD;};
        if ($@) {
            warn $@;
            exit 0;
        }
        my $dbi_arch_dir = DBI::DBD::dbd_dbi_arch_dir();
        if (exists($opts{INC})) {
            return {INC => "$opts{INC} -I$dbi_arch_dir"};
        } else {
            return {INC => "-I$dbi_arch_dir"};
        }
    }
);

package MY;

sub postamble { return DBI::DBD::dbd_postamble(@_); }
sub libscan {
	my ($self, $path) = @_;
	($path =~ /\~$/) ? undef : $path;
}

