# ABSTRACT: MongoDB v2 driver in Mojolicious
use strict;
use warnings;
package Mojolicious::Plugin::Mongodbv2;
$Mojolicious::Plugin::Mongodbv2::VERSION = '0.01';
use Mojo::Base 'Mojolicious::Plugin';
use MongoDB;

sub register {
    my ($self, $app, $conf) = @_;
    $conf = $conf || {};

    $conf->{helper} ||= 'db';

    $app->attr('mongodb_connection' => sub {
        my $m = Mojolicious::Plugin::Mongodbv2::Client->new(conf => $conf);
        $m->init();
        return $m->_client;
    });

    $app->helper($conf->{helper} => sub {
        my $s = shift;
        my $m = $s->app->mongodb_connection;
        return $m->db($m->db_name);
    });
}

package Mojolicious::Plugin::Mongodbv2::Client;
$Mojolicious::Plugin::Mongodbv2::Client::VERSION = '0.01';
use Mojo::Base -base;

has 'conf' => sub { {host => 'mongodb://localhost:27017/mongodbv2' } };
has '_client';

sub init {
    my $s = shift;
    $s->_client(MongoDB::MongoClient->new($s->conf));
}

1;

=pod

=encoding UTF-8

=head1 NAME

Mojolicious::Plugin::Mongodbv2 - MongoDB v2 driver in Mojolicious

=head1 VERSION

version 0.01

=head1 AUTHOR

Emiliano Bruni <info@ebruni.it>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2021 by Emiliano Bruni.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

__END__

1;
