package Bio::Palantir::Parser::Gene;
# ABSTRACT: BiosynML DTD-derived internal class
$Bio::Palantir::Parser::Gene::VERSION = '0.192560';
use Moose;
use namespace::autoclean;

# AUTOGENERATED CODE! DO NOT MODIFY THIS FILE!

use XML::Bare qw(forcearray);
use Data::UUID;

use aliased 'Bio::Palantir::Parser::Domain';
use aliased 'Bio::Palantir::Parser::Motif';
use aliased 'Bio::Palantir::Parser::Qualifier';
use aliased 'Bio::Palantir::Parser::Location';


# private attributes
has '_root' => (
    is       => 'ro',
    isa      => 'HashRef',
    required => 1,
);


has 'uui' => (
    is       => 'ro',
    isa      => 'Str',
    init_arg => undef,
    default  => sub {
        my $self = shift;
        my $ug = Data::UUID->new;
        my $uui = $ug->create_str();    
        return $uui;
    }
);

has 'rank' => (
    is      => 'ro',
    isa     => 'Num',
	default => -1,
	writer  => '_set_rank',
);


# public array(s) of composed objects


has 'domains' => (
    traits   => ['Array'],
    is       => 'ro',
    isa      => 'ArrayRef[Bio::Palantir::Parser::Domain]',
    handles  => {
         count_domains => 'count',
           all_domains => 'elements',
           get_domain  => 'get',
          next_domain  => 'shift',        
    },
);


## no critic (ProhibitUnusedPrivateSubroutines)


## use critic



has 'orphan_motifs' => (
    traits   => ['Array'],
    is       => 'ro',
    isa      => 'ArrayRef[Bio::Palantir::Parser::Motif]',
    handles  => {
         count_orphan_motifs => 'count',
           all_orphan_motifs => 'elements',
           get_orphan_motif  => 'get',
          next_orphan_motif  => 'shift',        
    },
);


## no critic (ProhibitUnusedPrivateSubroutines)


## use critic



has 'qualifiers' => (
    traits   => ['Array'],
    is       => 'ro',
    isa      => 'ArrayRef[Bio::Palantir::Parser::Qualifier]',
    init_arg => undef,
    lazy     => 1,
    builder  => '_build_qualifiers',
    handles  => {
         count_qualifiers => 'count',
           all_qualifiers => 'elements',
           get_qualifier  => 'get',
          next_qualifier  => 'shift',        
        filter_qualifiers => 'grep',
    },
);


## no critic (ProhibitUnusedPrivateSubroutines)
sub _build_qualifiers {
    my $self = shift;
    return [ map { Qualifier->new( _root => $_ ) } @{
    forcearray $self->_root->{gene_qualifiers}->{qualifier}
    } ];
}


## use critic



# public composed object(s)


has 'locations' => (
    is       => 'ro',
    isa      => 'Bio::Palantir::Parser::Location',
    init_arg => undef,
    lazy     => 1,
    builder  => '_build_locations',
	handles  => {
		      genomic_dna_begin => 'dna_begin',
		        genomic_dna_end => 'dna_end',
		       genomic_dna_size => 'dna_size',
        genomic_dna_coordinates => 'dna_coordinates',
         genomic_prot_begin => 'prot_begin',
           genomic_prot_end => 'prot_end',
          genomic_prot_size => 'prot_size',
       genomic_prot_coordinates => 'prot_coordinates',
	},
);

## no critic (ProhibitUnusedPrivateSubroutines)

sub _build_locations {
    my $self = shift;
    return Location->new(
        _root => $self->_root->{gene_location}
    );
}

# use critic


# public deep methods


# public methods


sub name {
    return shift->_root->{'gene_name'}->{'value'} // 'NA'
}


sub sequence {
    return shift->_root->{'sequence'}->{'value'} // 'NA'
}


sub operon {
    return shift->_root->{'operon'}->{'value'} // 'NA'
}



# public aliases


sub transcript_id {
	my $transcript_id;

	for my $qualifier(shift->_get_filtered_qualifiers('note')) {
		($transcript_id) = $qualifier =~ m/ transcript_id \= (.*) /xms;
        last if $transcript_id;
	}
	
	return $transcript_id;
} 

 
sub protein_sequence {
	return shift->_get_filtered_qualifiers('translation')
} 

 
sub gene_id {
	return shift->_get_filtered_qualifiers('gene')
} 

 
sub protein_id {
	return shift->_get_filtered_qualifiers('protein_id')
} 

 
sub product_id {
	return shift->_get_filtered_qualifiers('product')
} 

 
sub locus_tag {
	return shift->_get_filtered_qualifiers('locus_tag')
} 


sub smcog {
	my $smcog;

	for my $qualifier(shift->_get_filtered_qualifiers('smCOG')) {
		($smcog) = $qualifier =~ m/ SMCOG \d+ : \s (.*) /xms;
        last if $smcog;
	}
	
	return $smcog;
} 


sub uniprot_id {
	my $uniprot_id;

	for my $qualifier(shift->_get_filtered_qualifiers('db_xref')) {
		($uniprot_id) = $qualifier =~ m/ Uniprot\/SPTREMBL: (.*) /xms;
        last if $uniprot_id;
	}
	
	return $uniprot_id;
} 


sub go_ids {
	my @go_ids;

	for my $qualifier (shift->_get_filtered_qualifiers('db_xref')) {
		my ($go_id) = $qualifier =~ m/ GO: (.*) /xms;
    	push @go_ids, $go_id 
            if $go_id; 
	}

	return @go_ids;
} 


sub uniparc_id {
	my $uniparc_id;

	for my $qualifier(shift->_get_filtered_qualifiers('db_xref')) {
		($uniparc_id) = $qualifier =~ m/ UniParc: (.*) /xms;
        last if $uniparc_id;
	}
	
	return $uniparc_id;
} 


sub type {
	my $type;

	for my $qualifier(shift->_get_filtered_qualifiers('sec_met')) {
		($type) = $qualifier =~ m/ Type: \s (.*) /xms;
        last if $type;
	}
	
	return $type;
} 


sub domains_detail {
	my $domains_detail;

	for my $qualifier(shift->_get_filtered_qualifiers('sec_met')) {
		($domains_detail) = $qualifier =~ m/ Domains \s detected: \s (.*) /xms;
        last if $domains_detail;
	}
	
	return $domains_detail;
} 


sub kind {
	my $kind;

	for my $qualifier(shift->_get_filtered_qualifiers('sec_met')) {
		($kind) = $qualifier =~ m/ Kind: \s (.)* /xms;
        last if $kind;
	}
	
	return $kind;
} 


sub subtype {
	my $subtype;

	for my $qualifier(shift->_get_filtered_qualifiers('sec_met')) {
		($subtype) = $qualifier =~ m/ NRPS\/PKS \s subtype: \s (.*) /xms;
        last if $subtype;
	}
	
	return $subtype;
} 


sub bgc_domains {
	my @bgc_domains;

	for my $qualifier (shift->_get_filtered_qualifiers('sec_met')) {
		my ($bgc_domain) = $qualifier =~ m/ NRPS\/PKS \s Domain: \s (.*) /xms;
    	push @bgc_domains, $bgc_domain 
            if $bgc_domain; 
	}

	return @bgc_domains;
} 


sub monomers {
	my @monomers;

	for my $qualifier (shift->_get_filtered_qualifiers('sec_met')) {
		my ($monomer) = $qualifier =~ m/ Substrate \s specificity
                        \s predictions: .*? , \s ( [\w,]* ) 
                        \s \(consensus\) /xms;
    	push @monomers, $monomer 
            if $monomer; 
	}

	return @monomers;
} 


sub nrpspredictor_monomers {
	my @nrpspredictor_monomers;

	for my $qualifier (shift->_get_filtered_qualifiers('sec_met')) {
		my ($nrpspredictor_monomer) = $qualifier =~ m/ Substrate \s specificity 
                        \s predictions: \s ( [\w,]* ) 
                        \s \(NRPSPredictor2 \s SVM\) /xms;
    	push @nrpspredictor_monomers, $nrpspredictor_monomer 
            if $nrpspredictor_monomer; 
	}

	return @nrpspredictor_monomers;
} 


sub stachelhaus_monomers {
	my @stachelhaus_monomers;

	for my $qualifier (shift->_get_filtered_qualifiers('sec_met')) {
		my ($stachelhaus_monomer) = $qualifier =~ m/ Substrate \s specificity
                        \s predictions: .*? , \s ( [\w,]* )
                        \s \(Stachelhaus \s code\) /xms;
    	push @stachelhaus_monomers, $stachelhaus_monomer 
            if $stachelhaus_monomer; 
	}

	return @stachelhaus_monomers;
} 


sub minowa_monomers {
	my @minowa_monomers;

	for my $qualifier (shift->_get_filtered_qualifiers('sec_met')) {
		my ($minowa_monomer) = $qualifier =~ m/ Substrate \s specificity
                        \s predictions: .*? , \s ( [\w,]* )
                        \s \(Minowa\) /xms;
    	push @minowa_monomers, $minowa_monomer 
            if $minowa_monomer; 
	}

	return @minowa_monomers;
} 

sub _get_filtered_qualifiers {
    my $self = shift;
    my $pattern = shift;

    my (@filtered_qualifiers)
        = $self->filter_qualifiers( sub { $_->name eq $pattern} );
    return map { $_->value } @filtered_qualifiers; 
}


__PACKAGE__->meta->make_immutable;
1;

__END__

=pod

=head1 NAME

Bio::Palantir::Parser::Gene - BiosynML DTD-derived internal class

=head1 VERSION

version 0.192560

=head1 SYNOPSIS

    # TODO

=head1 DESCRIPTION

    # TODO

=head1 ATTRIBUTES

=head2 domains

ArrayRef of L<Bio::Palantir::Parser::Domain>

=head2 orphan_motifs

ArrayRef of L<Bio::Palantir::Parser::Motif>

=head2 qualifiers

ArrayRef of L<Bio::Palantir::Parser::Qualifier>

=head2 locations

L<Bio::Palantir::Parser::Location> composed object

=head1 METHODS

=head2 count_domains

Returns the number of Domains of the Gene.

    # $gene is a Bio::Palantir::Parser::Gene
    my $count = $gene->count_domains;

This method does not accept any arguments.

=head2 all_domains

Returns all the Domains of the Gene (not an array reference).

    # $gene is a Bio::Palantir::Parser::Gene
    my @domains = $gene->all_domains;

This method does not accept any arguments.

=head2 get_domain

Returns one Domain of the Gene by its index. You can also use
negative index numbers, just as with Perl's core array handling. If the
specified Domain does not exist, this method will return C<undef>.

    # $gene is a Bio::Palantir::Parser::Gene
    my $domain = $gene->get_domain($index);
    croak "Domain $index not found!" unless defined $domain;

This method accepts just one argument (and not an array slice).

=head2 next_domain

Shifts the first Domain of the array off and returns it, shortening the
array by 1 and moving everything down. If there are no more Domains in
the array, returns C<undef>.

    # $gene is a Bio::Palantir::Parser::Gene
    while (my $domain = $gene->next_domain) {
        # process $domain
        # ...
    }

This method does not accept any arguments.

=head2 count_orphan_motifs

Returns the number of Motifs of the Gene.

    # $gene is a Bio::Palantir::Parser::Gene
    my $count = $gene->count_orphan_motifs;

This method does not accept any arguments.

=head2 all_orphan_motifs

Returns all the Motifs of the Gene (not an array reference).

    # $gene is a Bio::Palantir::Parser::Gene
    my @orphan_motifs = $gene->all_orphan_motifs;

This method does not accept any arguments.

=head2 get_orphan_motif

Returns one Motif of the Gene by its index. You can also use
negative index numbers, just as with Perl's core array handling. If the
specified Motif does not exist, this method will return C<undef>.

    # $gene is a Bio::Palantir::Parser::Gene
    my $orphan_motif = $gene->get_orphan_motif($index);
    croak "Motif $index not found!" unless defined $orphan_motif;

This method accepts just one argument (and not an array slice).

=head2 next_orphan_motif

Shifts the first Motif of the array off and returns it, shortening the
array by 1 and moving everything down. If there are no more Motifs in
the array, returns C<undef>.

    # $gene is a Bio::Palantir::Parser::Gene
    while (my $orphan_motif = $gene->next_orphan_motif) {
        # process $orphan_motif
        # ...
    }

This method does not accept any arguments.

=head2 count_qualifiers

Returns the number of Qualifiers of the Gene.

    # $gene is a Bio::Palantir::Parser::Gene
    my $count = $gene->count_qualifiers;

This method does not accept any arguments.

=head2 all_qualifiers

Returns all the Qualifiers of the Gene (not an array reference).

    # $gene is a Bio::Palantir::Parser::Gene
    my @qualifiers = $gene->all_qualifiers;

This method does not accept any arguments.

=head2 get_qualifier

Returns one Qualifier of the Gene by its index. You can also use
negative index numbers, just as with Perl's core array handling. If the
specified Qualifier does not exist, this method will return C<undef>.

    # $gene is a Bio::Palantir::Parser::Gene
    my $qualifier = $gene->get_qualifier($index);
    croak "Qualifier $index not found!" unless defined $qualifier;

This method accepts just one argument (and not an array slice).

=head2 next_qualifier

Shifts the first Qualifier of the array off and returns it, shortening the
array by 1 and moving everything down. If there are no more Qualifiers in
the array, returns C<undef>.

    # $gene is a Bio::Palantir::Parser::Gene
    while (my $qualifier = $gene->next_qualifier) {
        # process $qualifier
        # ...
    }

This method does not accept any arguments.

=head2 name

Returns the value of the element C<<gene_name>>.

    # $gene is a Bio::Palantir::Parser::Gene
    my $name = $gene->name;

This method does not accept any arguments.

=head2 sequence

Returns the value of the element C<<sequence>>.

    # $gene is a Bio::Palantir::Parser::Gene
    my $sequence = $gene->sequence;

This method does not accept any arguments.

=head2 operon

Returns the value of the element C<<operon>>.

    # $gene is a Bio::Palantir::Parser::Gene
    my $operon = $gene->operon;

This method does not accept any arguments.

=head2 transcript_id

Returns the value of the element C<<transcript_id>>.

    # $gene is a Bio::FastParsers::Biosynml::Gene
    my $transcript_id = $gene->transcript_id;

This method does not accept any arguments.

=head2 protein_sequence

Returns the value of the element C<<protein_sequence>>.

    # $gene is a Bio::FastParsers::Biosynml::Gene
    my $protein_sequence = $gene->protein_sequence;

This method does not accept any arguments.

=head2 gene_id

Returns the value of the element C<<gene_id>>.

    # $gene is a Bio::FastParsers::Biosynml::Gene
    my $gene_id = $gene->gene_id;

This method does not accept any arguments.

=head2 protein_id

Returns the value of the element C<<protein_id>>.

    # $gene is a Bio::FastParsers::Biosynml::Gene
    my $protein_id = $gene->protein_id;

This method does not accept any arguments.

=head2 product_id

Returns the value of the element C<<product_id>>.

    # $gene is a Bio::FastParsers::Biosynml::Gene
    my $product_id = $gene->product_id;

This method does not accept any arguments.

=head2 locus_tag

Returns the value of the element C<<locus_tag>>.

    # $gene is a Bio::FastParsers::Biosynml::Gene
    my $locus_tag = $gene->locus_tag;

This method does not accept any arguments.

=head2 smcog

Returns the value of the element C<<smcog>>.

    # $gene is a Bio::FastParsers::Biosynml::Gene
    my $smcog = $gene->smcog;

This method does not accept any arguments.

=head2 uniprot_id

Returns the value of the element C<<uniprot_id>>.

    # $gene is a Bio::FastParsers::Biosynml::Gene
    my $uniprot_id = $gene->uniprot_id;

This method does not accept any arguments.

=head2 go_ids

Returns the values of the elements C<<go_ids>>.

    # $gene is a Bio::FastParsers::Biosynml::Gene
	my @go_ids = $gene->go_ids;

This method does not accept any arguments.

=head2 uniparc_id

Returns the value of the element C<<uniparc_id>>.

    # $gene is a Bio::FastParsers::Biosynml::Gene
    my $uniparc_id = $gene->uniparc_id;

This method does not accept any arguments.

=head2 type

Returns the value of the element C<<type>>.

    # $gene is a Bio::FastParsers::Biosynml::Gene
    my $type = $gene->type;

This method does not accept any arguments.

=head2 domains_detail

Returns the value of the element C<<domains_detail>>.

    # $gene is a Bio::FastParsers::Biosynml::Gene
    my $domains_detail = $gene->domains_detail;

This method does not accept any arguments.

=head2 kind

Returns the value of the element C<<kind>>.

    # $gene is a Bio::FastParsers::Biosynml::Gene
    my $kind = $gene->kind;

This method does not accept any arguments.

=head2 subtype

Returns the value of the element C<<subtype>>.

    # $gene is a Bio::FastParsers::Biosynml::Gene
    my $subtype = $gene->subtype;

This method does not accept any arguments.

=head2 bgc_domains

Returns the values of the elements C<<bgc_domains>>.

    # $gene is a Bio::FastParsers::Biosynml::Gene
	my @bgc_domains = $gene->bgc_domains;

This method does not accept any arguments.

=head2 monomers

Returns the values of the elements C<<monomers>>.

    # $gene is a Bio::FastParsers::Biosynml::Gene
	my @monomers = $gene->monomers;

This method does not accept any arguments.

=head2 nrpspredictor_monomers

Returns the values of the elements C<<nrpspredictor_monomers>>.

    # $gene is a Bio::FastParsers::Biosynml::Gene
	my @nrpspredictor_monomers = $gene->nrpspredictor_monomers;

This method does not accept any arguments.

=head2 stachelhaus_monomers

Returns the values of the elements C<<stachelhaus_monomers>>.

    # $gene is a Bio::FastParsers::Biosynml::Gene
	my @stachelhaus_monomers = $gene->stachelhaus_monomers;

This method does not accept any arguments.

=head2 minowa_monomers

Returns the values of the elements C<<minowa_monomers>>.

    # $gene is a Bio::FastParsers::Biosynml::Gene
	my @minowa_monomers = $gene->minowa_monomers;

This method does not accept any arguments.

=head1 AUTHOR

Loic MEUNIER <lmeunier@uliege.be>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2019 by University of Liege / Unit of Eukaryotic Phylogenomics / Loic MEUNIER and Denis BAURAIN.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
