package Astro::Coord::ECI::VSOP87D::Uranus;

use 5.008;

use strict;
use warnings;

use base qw{ Astro::Coord::ECI::VSOP87D::_Superior };

our $VERSION = '0.003';

sub __model_definition {
    my ( undef, $key ) = @_;
    return {
      body => "Uranus",
      default_model_cutoff => {
        Meeus => {
                   B0   => 28,
                   B1   => 20,
                   B2   => 11,
                   B3   => 4,
                   B4   => 1,
                   L0   => 91,
                   L1   => 57,
                   L2   => 35,
                   L3   => 18,
                   L4   => 4,
                   name => "Meeus",
                   R0   => 59,
                   R1   => 35,
                   R2   => 18,
                   R3   => 10,
                   R4   => 2,
                 },
        none  => {
                   B0   => 283,
                   B1   => 154,
                   B2   => 60,
                   B3   => 16,
                   B4   => 2,
                   L0   => 947,
                   L1   => 426,
                   L2   => 151,
                   L3   => 46,
                   L4   => 7,
                   L5   => 1,
                   name => "none",
                   R0   => 1124,
                   R1   => 514,
                   R2   => 192,
                   R3   => 55,
                   R4   => 11,
                 },
      },
      diameter => 50724,
      model => [
        [
          {
            series => "L0",
            terms  => [
                        [5.48129294299, 0, 0],
                        [0.09260408252, 0.8910642153, 74.7815985673],
                        [0.01504247826, 3.62719262195, 1.4844727083],
                        [0.00365981718, 1.89962189068, 73.297125859],
                        [0.00272328132, 3.35823710524, 149.5631971346],
                        [0.00070328499, 5.39254431993, 63.7358983034],
                        [0.00068892609, 6.09292489045, 76.2660712756],
                        [0.00061998592, 2.26952040469, 2.9689454166],
                        [0.00061950714, 2.85098907565, 11.0457002639],
                        [0.00026468869, 3.14152087888, 71.8126531507],
                        [0.00025710505, 6.11379842935, 454.9093665273],
                        [0.00021078897, 4.36059465144, 148.0787244263],
                        [0.00017818665, 1.74436982544, 36.6485629295],
                        [0.00014613471, 4.73732047977, 3.9321532631],
                        [0.00011162535, 5.82681993692, 224.3447957019],
                        [0.00010997934, 0.48865493179, 138.5174968707],
                        [9.527487e-05, 2.95516893093, 35.1640902212],
                        [7.545543e-05, 5.23626440666, 109.9456887885],
                        [4.22017e-05, 3.23328535514, 70.8494453042],
                        [4.05185e-05, 2.27754158724, 151.0476698429],
                        [3.354607e-05, 1.06549008887, 4.4534181249],
                        [2.926671e-05, 4.62903695486, 9.5612275556],
                        [3.490352e-05, 5.48305567292, 146.594251718],
                        [3.144093e-05, 4.75199307603, 77.7505439839],
                        [2.92241e-05, 5.3523674338, 85.8272988312],
                        [2.27279e-05, 4.36600802756, 70.3281804424],
                        [2.051209e-05, 1.51773563459, 0.1118745846],
                        [2.148599e-05, 0.60745800902, 38.1330356378],
                        [1.991726e-05, 4.92437290826, 277.0349937414],
                        [1.376208e-05, 2.04281409054, 65.2203710117],
                        [1.66691e-05, 3.62744580852, 380.12776796],
                        [1.284183e-05, 3.11346336879, 202.2533951741],
                        [1.150416e-05, 0.93344454002, 3.1813937377],
                        [1.533223e-05, 2.58593414266, 52.6901980395],
                        [1.281641e-05, 0.54269869505, 222.8603229936],
                        [1.3721e-05, 4.19641615561, 111.4301614968],
                        [1.220998e-05, 0.19901396193, 108.4612160802],
                        [9.46195e-06, 1.19249463066, 127.4717966068],
                        [1.150993e-05, 4.17898207045, 33.6796175129],
                        [1.244342e-05, 0.91612680579, 2.4476805548],
                        [1.072008e-05, 0.23564502877, 62.2514255951],
                        [1.090461e-05, 1.77501638912, 12.5301729722],
                        [7.07875e-06, 5.18285226584, 213.299095438],
                        [6.53401e-06, 0.96586909116, 78.7137518304],
                        [6.27562e-06, 0.18210181975, 984.6003316219],
                        [5.24495e-06, 2.01276706996, 299.1263942692],
                        [5.5937e-06, 3.35776737704, 0.5212648618],
                        [6.06827e-06, 5.43209728952, 529.6909650946],
                        [4.04891e-06, 5.98689011389, 8.0767548473],
                        [4.67211e-06, 0.41484068933, 145.1097790097],
                        [4.71288e-06, 1.40664336447, 184.7272873558],
                        [4.83219e-06, 2.10553990154, 0.9632078465],
                        [3.95614e-06, 5.87039580949, 351.8165923087],
                        [4.33532e-06, 5.52142978255, 183.2428146475],
                        [3.09885e-06, 5.83301304674, 145.6310438715],
                        [3.78609e-06, 2.34975805006, 56.6223513026],
                        [3.98996e-06, 0.33810765436, 415.5524906121],
                        [3.00379e-06, 5.64353974146, 22.0914005278],
                        [2.49229e-06, 4.74617120584, 225.8292684102],
                        [2.39334e-06, 2.35045874708, 137.0330241624],
                        [2.94172e-06, 5.83916826225, 39.6175083461],
                        [2.1648e-06, 4.77847481363, 340.7708920448],
                        [2.51792e-06, 1.63696775578, 221.3758502853],
                        [2.19621e-06, 1.92212987979, 67.6680515665],
                        [2.01963e-06, 1.29693040865, 0.0481841098],
                        [2.24097e-06, 0.51574863468, 84.3428261229],
                        [2.16549e-06, 6.14211862702, 5.9378908332],
                        [2.22588e-06, 2.84309380331, 0.2606324309],
                        [2.07828e-06, 5.5802057004, 68.8437077341],
                        [1.87474e-06, 1.31924326253, 0.1600586944],
                        [1.58028e-06, 0.73811997211, 54.1746707478],
                        [1.99146e-06, 0.9563415501, 152.5321425512],
                        [1.68648e-06, 5.87874000882, 18.1592472647],
                        [1.703e-06, 3.67717520688, 5.4166259714],
                        [1.93652e-06, 1.88800122606, 456.3938392356],
                        [1.92998e-06, 0.91616058506, 453.424893819],
                        [1.81934e-06, 3.53624029238, 79.2350166922],
                        [1.73145e-06, 1.53860728054, 160.6088973985],
                        [1.64588e-06, 1.42379714838, 106.9767433719],
                        [1.71968e-06, 5.67952685533, 219.891377577],
                        [1.62792e-06, 3.05029377666, 112.9146342051],
                        [1.46653e-06, 1.26300172265, 59.8037450403],
                        [1.39453e-06, 5.385977234, 32.1951448046],
                        [1.38585e-06, 4.25994786673, 909.8187330546],
                        [1.43058e-06, 1.29995487555, 35.4247226521],
                        [1.2384e-06, 1.37359990336, 7.1135470008],
                        [1.04414e-06, 5.02820888813, 0.7507595254],
                        [1.03277e-06, 0.68095301267, 14.977853527],
                        [9.4741e-07, 0.90674090409, 74.6697239827],
                        [8.2978e-07, 2.92828718445, 265.9892934775],
                        [1.10163e-06, 2.02685778976, 554.0699874828],
                        [9.4226e-07, 3.9426632826, 74.8934731519],
                        [7.9858e-07, 1.0144682918, 6.592282139],
                        [1.09376e-06, 5.70581833286, 77.962992305],
                        [8.5876e-07, 1.70649435603, 82.8583534146],
                        [1.03562e-06, 1.45770270246, 24.3790223882],
                        [7.4667e-07, 4.63177552576, 69.3649725959],
                        [7.9919e-07, 3.00974084247, 297.6419215609],
                        [8.4502e-07, 0.36887189574, 186.2117600641],
                        [8.881e-07, 0.52481330563, 181.7583419392],
                        [7.0303e-07, 1.18986880009, 66.70484372],
                        [6.9965e-07, 0.87476081875, 305.3461693927],
                        [6.9927e-07, 3.76102749315, 131.4039498699],
                        [8.4604e-07, 5.88725183325, 256.5399405065],
                        [7.4341e-07, 6.24271323846, 447.7958195265],
                        [6.231e-07, 0.16901376623, 479.2883889155],
                        [7.2726e-07, 2.84892775693, 462.0229135281],
                        [6.906e-07, 4.43934854374, 39.3568759152],
                        [7.6568e-07, 4.5872111034, 6.2197751235],
                        [7.3387e-07, 4.27603448634, 87.3117715395],
                        [5.5307e-07, 1.49636544147, 71.6002048296],
                        [5.7291e-07, 1.63015165542, 143.6253063014],
                        [6.1661e-07, 3.18604743524, 77.2292791221],
                        [5.7634e-07, 3.67180685401, 51.2057253312],
                        [5.0289e-07, 1.12279384633, 20.6069278195],
                        [5.3744e-07, 5.51890986247, 128.9562693151],
                        [5.7894e-07, 2.66877593418, 381.6122406683],
                        [5.8112e-07, 1.58629352171, 60.7669528868],
                        [4.5382e-07, 0.48053933052, 14.0146456805],
                        [3.7581e-07, 6.06822931932, 211.8146227297],
                        [3.864e-07, 3.43597050177, 153.4953503977],
                        [4.6087e-07, 4.36201639577, 75.7448064138],
                        [4.0088e-07, 4.57333927519, 46.2097904851],
                        [3.4229e-07, 2.93967782207, 140.001969579],
                        [3.8669e-07, 5.58941074168, 99.1606209555],
                        [3.4827e-07, 1.02792863024, 203.7378678824],
                        [4.0024e-07, 0.69889667397, 218.4069048687],
                        [3.2538e-07, 4.21625657443, 200.7689224658],
                        [3.1865e-07, 5.50961503408, 72.3339180125],
                        [4.1695e-07, 3.82438031124, 81.0013736908],
                        [3.4795e-07, 0.39363490236, 1.3725981237],
                        [3.9775e-07, 6.05600836903, 293.188503436],
                        [2.7577e-07, 2.18261286374, 125.9873238985],
                        [3.6279e-07, 1.66586085405, 258.0244132148],
                        [3.5442e-07, 1.96652806541, 835.0371344873],
                        [3.5361e-07, 3.7225869003, 692.5874843535],
                        [2.7323e-07, 2.10164372072, 209.3669421749],
                        [2.653e-07, 4.48265986115, 373.9079928365],
                        [3.4472e-07, 1.07907945481, 191.2076949102],
                        [2.9915e-07, 3.87358632506, 259.5088859231],
                        [2.6233e-07, 3.63172504384, 490.3340891794],
                        [2.5848e-07, 0.54461409359, 41.6444977756],
                        [2.6989e-07, 6.27711247734, 28.5718080822],
                        [2.6391e-07, 5.81110061049, 75.3028634291],
                        [3.4227e-07, 6.05617272657, 275.5505210331],
                        [2.4279e-07, 3.18776564878, 81.3738807063],
                        [2.9937e-07, 1.88789751816, 269.9214467406],
                        [2.6235e-07, 6.20105251336, 134.5853436076],
                        [2.2754e-07, 0.92919725789, 288.0806940053],
                        [2.518e-07, 5.42547381962, 116.4260963429],
                        [2.2715e-07, 0.53098783687, 1514.2912967165],
                        [2.6485e-07, 4.77176167929, 284.1485407422],
                        [2.7008e-07, 4.75281624832, 41.1019810544],
                        [2.1972e-07, 4.58613057386, 404.5067903482],
                        [2.2012e-07, 1.84389287183, 617.8058857862],
                        [2.4694e-07, 4.7087519549, 378.6432952517],
                        [2.8949e-07, 0.17127584792, 528.2064923863],
                        [2.0492e-07, 0.10285646641, 195.1398481733],
                        [2.0696e-07, 5.62143477633, 55.6591434561],
                        [2.5843e-07, 0.74627159338, 278.5194664497],
                        [2.299e-07, 3.58378694661, 1.5963472929],
                        [2.1843e-07, 0.05733533568, 173.9422195228],
                        [1.905e-07, 2.30351091243, 5.1078094307],
                        [2.0675e-07, 2.64113858585, 105.4922706636],
                        [2.1856e-07, 5.87352402691, 45.5766510387],
                        [2.112e-07, 1.98081790016, 114.3991069134],
                        [1.9279e-07, 2.84304025179, 159.1244246902],
                        [1.9061e-07, 0.50598371738, 67.3592350258],
                        [2.0434e-07, 3.77601951414, 135.5485514541],
                        [1.7326e-07, 4.47793157645, 120.358249606],
                        [2.0547e-07, 0.88695598555, 255.0554677982],
                        [1.932e-07, 1.48569290504, 0.8937718773],
                        [2.1331e-07, 2.7447002306, 28.3111756513],
                        [1.7582e-07, 4.091396367, 296.1574488526],
                        [1.5918e-07, 3.94525074972, 17.5261078183],
                        [1.5562e-07, 0.92748407689, 300.6108669775],
                        [1.6439e-07, 0.30868798605, 30.7106720963],
                        [1.5237e-07, 4.93048601827, 7.4223635415],
                        [1.9284e-07, 6.21950083268, 329.8370663655],
                        [1.386e-07, 0.56255266406, 144.1465711632],
                        [1.6206e-07, 2.30292598693, 344.7030453079],
                        [1.6041e-07, 0.19723295436, 103.0927742186],
                        [1.4414e-07, 2.57606243208, 230.5645708254],
                        [1.6789e-07, 4.93540052916, 565.1156877467],
                        [1.7052e-07, 1.81844925116, 294.6729761443],
                        [1.6766e-07, 0.2754218633, 73.8183907208],
                        [1.5428e-07, 1.91577056305, 96.8729990951],
                        [1.5718e-07, 3.87095025861, 98.8999885246],
                        [1.1923e-07, 6.17545505441, 44.7253177768],
                        [1.2407e-07, 6.22419970167, 80.1982245387],
                        [1.304e-07, 1.99652993223, 27.0873353739],
                        [1.3229e-07, 3.43782440072, 227.3137411185],
                        [1.1669e-07, 4.31526860843, 426.598190876],
                        [1.4378e-07, 5.78353646474, 1059.3819301892],
                        [1.5879e-07, 0.98454960055, 6208.2942514241],
                        [1.1158e-07, 1.7441743069, 220.4126424388],
                        [1.1989e-07, 5.8438865795, 13.3333221243],
                        [1.1386e-07, 2.55925734515, 19.1224551112],
                        [1.3281e-07, 5.39472153462, 391.1734682239],
                        [1.2295e-07, 4.57340278496, 23.5758732361],
                        [1.2827e-07, 1.7741026907, 180.2738692309],
                        [1.1651e-07, 4.29138607818, 142.4496501338],
                        [1.2248e-07, 2.44241346243, 100.3844612329],
                        [1.2421e-07, 2.32591770919, 80.7194894005],
                        [9.774e-08, 0.39898140151, 7.8643065262],
                        [1.3172e-07, 2.74099358938, 177.8743727859],
                        [1.2262e-07, 5.42795591646, 831.1049812242],
                        [1.0272e-07, 5.90194483926, 74.5209661364],
                        [9.317e-08, 3.75869700774, 74.8297826771],
                        [1.0701e-07, 4.00709797731, 235.3904959658],
                        [9.243e-08, 5.38492199672, 20.4468691251],
                        [9.461e-08, 2.60126707172, 92.3077063856],
                        [1.2066e-07, 5.5216310022, 74.2603337055],
                        [1.0836e-07, 1.88393779293, 241.6102710893],
                        [9.317e-08, 1.1648365831, 74.7334144575],
                        [1.0718e-07, 5.50310449842, 187.6962327724],
                        [1.2057e-07, 6.0212005039, 154.0166152595],
                        [9.124e-08, 1.15458738606, 0.6331394464],
                        [1.1526e-07, 6.26425302826, 155.7829722581],
                        [1.22e-07, 5.79400179483, 1364.7280995819],
                        [1.0979e-07, 5.76614513865, 628.8515860501],
                        [8.532e-08, 5.1801645615, 1.6445314027],
                        [8.66e-08, 3.78133822411, 74.9416572617],
                        [1.1227e-07, 1.30788626675, 604.4725636619],
                        [1.0531e-07, 1.05867421534, 291.7040307277],
                        [8.446e-08, 3.52020067595, 756.3233826569],
                        [1.0291e-07, 5.30493908317, 75.0422309982],
                        [8.015e-08, 6.24347048958, 543.0242872189],
                        [7.796e-08, 5.23497582886, 58.1068240109],
                        [9.31e-08, 1.65210713729, 24.1183899573],
                        [8.642e-08, 1.14285691458, 74.6215398729],
                        [7.797e-08, 4.00208030502, 31.492569389],
                        [8.915e-08, 3.63129389881, 408.4389436113],
                        [7.191e-08, 4.24536221306, 110.2063212194],
                        [9.764e-08, 0.10205649809, 366.485629295],
                        [8.71e-08, 2.2591075948, 451.9404211107],
                        [9.43e-08, 2.00492467431, 331.3215390738],
                        [9.008e-08, 1.63146330622, 443.8636662634],
                        [7.247e-08, 4.35313018726, 88.1149206916],
                        [7.659e-08, 0.61918159043, 50.4025761791],
                        [6.836e-08, 5.12190844483, 0.8031491521],
                        [9.367e-08, 1.42664537007, 414.0680179038],
                        [8.136e-08, 0.45279998999, 25.6028626656],
                        [9.199e-08, 2.41000352664, 10138.5039476437],
                        [6.896e-08, 5.85017813531, 339.2864193365],
                        [6.487e-08, 6.03397141885, 1.2238402774],
                        [7.186e-08, 4.00480285222, 157.6399519819],
                        [8.13e-08, 0.21907525983, 422.6660376129],
                        [8.022e-08, 2.09953974305, 92.940845832],
                        [6.371e-08, 4.47820781123, 79.889407998],
                        [7.957e-08, 5.86499639179, 760.25553592],
                        [8.383e-08, 2.33782809093, 417.0369633204],
                        [7.931e-08, 3.41952210669, 7.7042478318],
                        [6.613e-08, 1.39197711439, 16.6747745564],
                        [7.142e-08, 5.57864813931, 4.7353024152],
                        [7.441e-08, 0.48121969777, 68.1893164283],
                        [7.187e-08, 0.50441238918, 457.8783119439],
                        [6.613e-08, 2.84628770892, 142.1408335931],
                        [6.399e-08, 3.88681409308, 74.0308390419],
                        [6.14e-08, 1.6577690922, 350.3321196004],
                        [7.053e-08, 0.13890020306, 306.830642101],
                        [6.01e-08, 5.4643400464, 48.7580447764],
                        [6.81e-08, 6.15448079403, 67.8804998876],
                        [5.982e-08, 2.36098472874, 2.0057375701],
                        [5.709e-08, 1.49928444044, 206.1855484372],
                        [6.843e-08, 1.08172913275, 465.9550667912],
                        [6.408e-08, 5.07331258075, 4.665866446],
                        [7.805e-08, 3.98866710061, 3.6233367224],
                        [5.527e-08, 5.57881556653, 2.9207613068],
                        [5.521e-08, 3.3822598704, 149.45132255],
                        [6.107e-08, 1.95504762856, 216.9224321604],
                        [5.692e-08, 2.83076925167, 260.9933586314],
                        [6.586e-08, 2.71085048651, 329.7251917809],
                        [5.826e-08, 3.98800970226, 347.8844390456],
                        [5.745e-08, 0.49160564101, 0.3725070155],
                        [5.473e-08, 5.69158856279, 1.6969210294],
                        [4.982e-08, 2.40870746521, 342.2553647531],
                        [6.04e-08, 4.78944090986, 558.0021407459],
                        [5.317e-08, 2.78403764459, 13.4933808187],
                        [5.09e-08, 5.47747622578, 372.4235201282],
                        [4.894e-08, 1.77082918618, 333.657345044],
                        [5.389e-08, 2.94076732149, 9.4011688612],
                        [4.757e-08, 5.37129102802, 61.2882177486],
                        [5e-08, 3.43988321744, 518.6452648307],
                        [5.664e-08, 3.30309284254, 0.6543913058],
                        [5.53e-08, 0.45092393824, 162.0933701068],
                        [5.746e-08, 3.45964923866, 55.1378785943],
                        [5.666e-08, 1.23578675332, 328.3525936572],
                        [5.071e-08, 5.42033080481, 977.4867846211],
                        [5.719e-08, 0.66718965817, 92.0470739547],
                        [4.994e-08, 1.29267872727, 983.1158589136],
                        [5.57e-08, 2.36255927193, 6.9010986797],
                        [5.189e-08, 2.40682220291, 58.319272332],
                        [5.502e-08, 0.13301359232, 149.6750717192],
                        [4.706e-08, 1.85473330365, 119.5069163441],
                        [4.305e-08, 4.18171934306, 90.8232336773],
                        [5.953e-08, 1.73036741041, 152.7445908723],
                        [5.607e-08, 5.53187692339, 1087.6931058405],
                        [5.591e-08, 5.75072223569, 358.9301393095],
                        [4.441e-08, 0.97726075887, 4.192785694],
                        [4.608e-08, 3.31800103668, 89.7594520943],
                        [4.677e-08, 5.01422713233, 43.1289704839],
                        [4.034e-08, 1.08242564328, 75.5323580927],
                        [5.626e-08, 1.10270225604, 66.9172920411],
                        [4.058e-08, 1.9401213605, 17.2654753874],
                        [4.77e-08, 2.24207019076, 986.0848043302],
                        [5.207e-08, 1.3660042891, 767.3690829208],
                        [4.94e-08, 0.13733547633, 0.8513332619],
                        [4.339e-08, 5.33814728291, 152.0108776894],
                        [3.917e-08, 3.85320550575, 2.2876218604],
                        [3.903e-08, 5.87573410158, 16.4623262353],
                        [4.655e-08, 0.93665017107, 267.4737661858],
                        [4.638e-08, 5.42566923517, 16.04163511],
                        [5.177e-08, 3.40845690805, 1289.9465010146],
                        [3.825e-08, 0.5988810573, 210.3301500214],
                        [5.048e-08, 2.16732539242, 367.9701020033],
                        [3.819e-08, 1.70901925915, 5.6290742925],
                        [5.004e-08, 0.26759264038, 403.1341922245],
                        [4.202e-08, 5.12029089394, 19.0105805266],
                        [4.472e-08, 2.88978371811, 59.2824801785],
                        [4.7e-08, 4.17709035394, 130.4407420234],
                        [4.487e-08, 0.85521839581, 969.6224780949],
                        [3.802e-08, 4.59721371468, 25.8634950965],
                        [4.024e-08, 4.98868930941, 30.0562807905],
                        [4.722e-08, 6.16359211847, 173.6815870919],
                        [4.732e-08, 3.76697693308, 373.0142209592],
                        [3.542e-08, 0.76768843819, 114.1384744825],
                        [3.37e-08, 2.00021522907, 286.596221297],
                        [3.626e-08, 3.20240733896, 991.7138786227],
                        [4.028e-08, 0.46802022168, 387.2413149608],
                        [3.442e-08, 5.2095973335, 894.8408795276],
                        [3.273e-08, 5.46374958434, 192.6921676185],
                        [3.291e-08, 3.97847646998, 264.5048207692],
                        [3.291e-08, 1.62538722379, 681.5417840896],
                        [3.198e-08, 3.965808048, 146.3818033969],
                        [4.016e-08, 1.4065746484, 383.0967133766],
                        [3.844e-08, 3.60271287642, 0.590700831],
                        [3.123e-08, 4.50215520755, 1439.5096981492],
                        [3.434e-08, 5.18704419009, 97.4155158163],
                        [3.123e-08, 4.14198630214, 76.4785195967],
                        [3.259e-08, 1.65410614252, 214.7835681463],
                        [3.557e-08, 4.15769848885, 68.5618234438],
                        [2.934e-08, 2.95575531139, 120.9913890524],
                        [2.914e-08, 3.69930995976, 874.3940104025],
                        [3.301e-08, 2.14570582133, 253.5709950899],
                        [3.362e-08, 4.82277888708, 19.643719973],
                        [3.218e-08, 2.56428709831, 60.5545045657],
                        [3.059e-08, 3.57539890234, 117.9105690512],
                        [3.073e-08, 3.54739757836, 95.3885263868],
                        [2.789e-08, 0.65190913388, 42.5382696529],
                        [3.235e-08, 5.31608088666, 546.956440482],
                        [3.657e-08, 5.89905956226, 16.1535096946],
                        [3.549e-08, 2.76314903735, 82.4858463991],
                        [3.627e-08, 4.68663059919, 593.426863398],
                        [3.306e-08, 1.57486085317, 312.4597163935],
                        [3.602e-08, 2.51921910142, 22.8945496799],
                        [3.431e-08, 4.95532928836, 49.7212526229],
                        [2.675e-08, 2.41314606353, 29.2049475286],
                        [3.101e-08, 1.42849885249, 17.6379824029],
                        [3.399e-08, 3.02815712113, 88.7962442478],
                        [3.379e-08, 2.65894323745, 771.3012361839],
                        [2.547e-08, 6.10642153361, 455.8725743738],
                        [2.967e-08, 0.31461418738, 150.5264049811],
                        [2.681e-08, 1.16839594153, 477.8039162072],
                        [3.343e-08, 3.09880618811, 552.5855147745],
                        [2.678e-08, 1.42841144096, 1.1119656928],
                        [2.54e-08, 1.94053883528, 6.4804075544],
                        [2.491e-08, 2.97226347939, 453.9461586808],
                        [2.744e-08, 1.93313970916, 73.1852512744],
                        [2.935e-08, 4.5939410628, 167.0893049529],
                        [3.007e-08, 1.38745560615, 365.0011565867],
                        [3.053e-08, 1.91792962252, 561.1835344836],
                        [2.496e-08, 5.45540866674, 66.1835788582],
                        [2.622e-08, 1.46324659292, 33.1371007917],
                        [3.203e-08, 4.01683757076, 555.5544601911],
                        [2.317e-08, 1.13727677715, 43.2408450685],
                        [2.341e-08, 5.87635018071, 228.276948965],
                        [2.841e-08, 3.60234459541, 42.5864537627],
                        [2.858e-08, 1.53714262537, 353.301065017],
                        [2.484e-08, 3.85791009894, 104.0077979553],
                        [2.903e-08, 5.21967656512, 73.4090004436],
                        [2.76e-08, 1.21343315367, 32.2433289144],
                        [2.269e-08, 3.31411391807, 4.1446015842],
                        [2.241e-08, 2.65636547591, 70.1157321213],
                        [2.246e-08, 4.08175081363, 123.5396433437],
                        [2.583e-08, 2.38305971478, 100.6450936638],
                        [2.761e-08, 5.71758409791, 43.2890291783],
                        [2.827e-08, 6.16734582851, 101.8689339412],
                        [2.838e-08, 0.5488849549, 20.4950532349],
                        [2.145e-08, 4.04195315408, 47.061123747],
                        [2.81e-08, 1.90169260186, 273.1028404783],
                        [2.922e-08, 2.79808700183, 418.2608035978],
                        [2.07e-08, 5.5040271829, 47.6942631934],
                        [2.071e-08, 2.0197357306, 316.3918696566],
                        [2.52e-08, 3.12740527423, 905.8865797915],
                        [2.17e-08, 4.4619656005, 2.7083129857],
                        [2.399e-08, 3.78849518316, 75.5847477194],
                        [2.746e-08, 4.82558024832, 6.8529145699],
                        [2.717e-08, 2.33108458294, 404.6186649328],
                        [2.416e-08, 4.11932546205, 332.8060117821],
                        [1.974e-08, 5.79881978458, 11.1575748485],
                        [1.967e-08, 5.43918682709, 199.2844497575],
                        [2.282e-08, 2.79530897096, 22.633917249],
                        [1.91e-08, 0.27727117649, 69.1525242748],
                        [2.471e-08, 3.51033894778, 8.5980197091],
                        [1.904e-08, 3.45282024423, 472.1748419147],
                        [2.606e-08, 0.43601023323, 439.782755154],
                        [2.663e-08, 5.43112910549, 3265.8308281325],
                        [2.058e-08, 1.69362390174, 65.8747623175],
                        [2.258e-08, 5.32927779367, 908.3342603463],
                        [1.873e-08, 5.5539980591, 175.1660598002],
                        [2.222e-08, 0.96973865202, 39.0962434843],
                        [2.121e-08, 2.00302088316, 106.0135355254],
                        [2.01e-08, 1.49945418027, 29.226199388],
                        [2.222e-08, 4.36573603431, 468.2426886516],
                        [2.055e-08, 0.05798973044, 205.2223405907],
                        [2.086e-08, 0.44287700052, 10.2949407385],
                        [1.77e-08, 4.3204880583, 0.457574387],
                        [2.112e-08, 5.78682409103, 486.4019359163],
                        [1.909e-08, 0.82888506421, 254.9435932136],
                        [1.973e-08, 6.05826379648, 78.4049352897],
                        [1.908e-08, 5.55892482384, 15.4991183888],
                        [1.888e-08, 6.20874408008, 198.321241911],
                        [2.092e-08, 2.55561831566, 49.5088043018],
                        [1.775e-08, 6.17741514589, 258.8757464767],
                        [2.146e-08, 1.4050811881, 526.722019678],
                        [1.8e-08, 0.04238718337, 334.2904844904],
                        [1.738e-08, 1.99152421966, 77.0692204277],
                        [1.641e-08, 3.36410541913, 118.0224436358],
                        [2.084e-08, 5.21275540105, 134.0640787458],
                        [1.861e-08, 2.97480744198, 178.7893965226],
                        [1.75e-08, 2.01731567093, 142.6620984549],
                        [1.6e-08, 1.60963172329, 40.1600250673],
                        [1.668e-08, 1.53361997245, 0.8300814025],
                        [1.769e-08, 4.72689497119, 32.7164096664],
                        [1.782e-08, 2.60469159465, 166.828672522],
                        [1.765e-08, 5.57583636983, 522.5774180938],
                        [1.877e-08, 1.09044005603, 274.0660483248],
                        [1.544e-08, 1.9179841914, 303.8616966844],
                        [1.532e-08, 3.44973397383, 124.5028511902],
                        [1.658e-08, 5.23946791059, 233.9060232575],
                        [1.743e-08, 2.32369273283, 290.2195580194],
                        [1.528e-08, 0.62020771152, 1033.3583763983],
                        [1.522e-08, 6.11272567668, 165.6048322446],
                        [1.496e-08, 2.02190170195, 150.0844619964],
                        [1.49e-08, 3.30997217921, 820.0592809603],
                        [1.398e-08, 3.41567259878, 4.9959348461],
                        [1.886e-08, 6.25585539882, 162.8965192589],
                        [1.388e-08, 0.62745508416, 448.6895914038],
                        [1.918e-08, 0.91483173263, 1819.6374661092],
                        [1.682e-08, 2.11545135265, 189.7232222019],
                        [1.711e-08, 2.55731536599, 1108.1399749656],
                        [1.598e-08, 0.89607036108, 115.8835796217],
                        [1.477e-08, 0.22838214106, 370.9390474199],
                        [1.727e-08, 1.54005322759, 401.6497195162],
                        [1.432e-08, 3.73381952953, 8.9068362498],
                        [1.338e-08, 0.19338311739, 81.8951455681],
                        [1.618e-08, 6.02595306259, 31.2319369581],
                        [1.452e-08, 0.11827434627, 72.7758609972],
                        [1.626e-08, 4.26332651029, 369.4545747116],
                        [1.284e-08, 3.18389639039, 362.8622925726],
                        [1.755e-08, 5.57436830525, 344.9636777388],
                        [1.451e-08, 4.4261538175, 189.1807054807],
                        [1.294e-08, 2.77775613125, 63.6240237188],
                        [1.712e-08, 2.16785817753, 536.8045120954],
                        [1.266e-08, 2.78408709208, 55.7710180407],
                        [1.7e-08, 2.49908604932, 441.2672278623],
                        [1.645e-08, 2.41257585783, 10.0824924174],
                        [1.666e-08, 5.00664377609, 79.5169009825],
                        [1.674e-08, 0.00394784675, 491.5579294568],
                        [1.334e-08, 5.62972572008, 129.9194771616],
                        [1.328e-08, 0.2560613584, 114.9416236346],
                        [1.176e-08, 1.63208422172, 84.1827674285],
                        [1.177e-08, 4.10449248614, 103.3534066495],
                        [1.384e-08, 5.7300452987, 89.338760969],
                        [1.287e-08, 0.99537181009, 14.6690369863],
                        [1.171e-08, 5.98078310685, 57.1436161644],
                        [1.126e-08, 3.39586759408, 375.3924655448],
                        [1.406e-08, 5.18477940039, 113.8778420516],
                        [1.397e-08, 1.49751443233, 14.2270940016],
                        [1.206e-08, 3.60301196272, 480.7728616238],
                        [1.113e-08, 4.80418427391, 9.449352971],
                        [1.434e-08, 1.57158177893, 419.7452763061],
                        [1.473e-08, 1.03881736383, 1215.1649024473],
                        [1.311e-08, 2.99704179684, 458.8415197904],
                        [1.453e-08, 6.10676427884, 64.6991061499],
                        [1.07e-08, 3.16542344402, 54.3347294422],
                        [1.389e-08, 2.78512263875, 26.0235537909],
                        [1.203e-08, 0.20627563214, 0.5694489716],
                        [1.343e-08, 5.58004577468, 95.2284676924],
                        [1.062e-08, 2.40616687148, 154.979823106],
                        [1.399e-08, 1.66776602336, 240.3864308119],
                        [1.036e-08, 5.53891715915, 403.0223176399],
                        [1.269e-08, 2.3768452729, 37.8724032069],
                        [1.197e-08, 4.87553746725, 1044.4040766622],
                        [1.009e-08, 2.7461946296, 80.4106728598],
                        [1.33e-08, 0.99603813295, 483.2205421786],
                        [1.348e-08, 0.58829539202, 476.4313180835],
                        [9.89e-09, 3.31666847329, 18.9100067901],
                        [1.054e-08, 2.85972567059, 616.3214130779],
                        [1.276e-08, 4.72938141859, 691.1030116452],
                        [1.219e-08, 3.6290968922, 106.2741679563],
                        [1.269e-08, 1.53301050628, 280.9671470045],
                        [9.68e-09, 2.73688433893, 218.9281697305],
                        [1.33e-08, 5.69234088687, 694.0719570618],
                        [1.121e-08, 2.8054243979, 148.5999892881],
                        [9.8e-09, 6.04026702553, 5.4690155981],
                        [1.235e-08, 0.61136787453, 237.6781178262],
                        [1.161e-08, 5.3220902482, 369.0820676961],
                        [9.44e-09, 1.14261861393, 384.0599212231],
                        [1.017e-08, 2.49896409345, 147.1155165798],
                        [1.082e-08, 2.46236323548, 326.8681209489],
                        [1.037e-08, 5.92126063748, 4.8259251404],
                        [1.232e-08, 5.83725190224, 63.847772888],
                        [9.14e-09, 0.36627060914, 10.9338256793],
                        [1.165e-08, 5.32140830393, 308.3151148093],
                        [9.52e-09, 4.78982033367, 93.9040536785],
                        [9.93e-09, 3.39918521663, 10.785067833],
                        [1.206e-08, 3.6453050053, 699.7010313543],
                        [8.93e-09, 2.97140509591, 248.4631856592],
                        [8.83e-09, 2.85605198817, 15.1903018481],
                        [8.75e-09, 3.4392570928, 3.0808200012],
                        [1.103e-08, 4.80576195766, 6133.5126528568],
                        [1.178e-08, 6.01576659565, 377.1588225434],
                        [9.74e-09, 2.51206761828, 121.8427223143],
                        [8.65e-09, 5.68958102479, 141.6988906084],
                        [9.74e-09, 3.15729174941, 215.4379594521],
                        [8.47e-09, 0.84854843713, 2043.9822618111],
                        [9.61e-09, 0.22181374419, 0.9150237367],
                        [1.167e-08, 2.37544946421, 33.9402499438],
                        [1.013e-08, 3.43778868786, 36.9091953604],
                        [8.38e-09, 1.63355479706, 2.3358059702],
                        [1.113e-08, 2.5098969497, 405.9912630565],
                        [9.87e-09, 1.14030030863, 82.2039621088],
                        [1.06e-08, 1.70915765427, 438.2982824457],
                        [8.29e-09, 2.97491446672, 62.7726904569],
                        [9.91e-09, 4.44869793177, 406.1031376411],
                        [9.52e-09, 6.13897716036, 184.9879197867],
                        [1.033e-08, 4.19932839584, 141.4864422873],
                        [1.029e-08, 5.13205530996, 157.2674449664],
                        [8.05e-09, 3.11000318272, 93.7921790939],
                        [8.65e-09, 4.44578048207, 295.1942410061],
                        [9.21e-09, 4.88190545687, 12.0089081104],
                        [9.49e-09, 5.99910796869, 606.7601855223],
                        [9.91e-09, 1.68012021428, 40.5807161926],
                        [8.54e-09, 0.37823682862, 217.2312487011],
                        [8.83e-09, 2.3622438514, 3.7720945687],
                        [1.016e-08, 3.90745585959, 194.2885149114],
                        [8.07e-09, 5.93051451738, 302.0953396858],
                        [8.79e-09, 0.52695940866, 1057.8974574809],
                        [1.009e-08, 1.19621149495, 490.0734567485],
                        [8.01e-09, 4.96724351781, 661.0949149645],
                        [8.43e-09, 0.97496000705, 73.88782669],
                        [1.028e-08, 2.65189503651, 477.9157907918],
                        [8.46e-09, 3.3634373396, 40.8413486235],
                        [7.72e-09, 4.93551925711, 425.1137181677],
                        [7.81e-09, 0.59382881638, 97.6761482472],
                        [7.7e-09, 4.25621058806, 488.8496164711],
                        [9.35e-09, 1.24971148781, 624.919432787],
                        [9.84e-09, 4.44298060183, 171.6545976624],
                        [8.06e-09, 0.09410536829, 440.6822725257],
                        [7.69e-09, 4.09296452529, 140.6563608848],
                        [8.02e-09, 0.78515729603, 11.848849416],
                        [1.007e-08, 4.06909438635, 76.154196691],
                        [9.35e-09, 0.03808890956, 156.1554792736],
                        [7.12e-09, 5.35549696452, 610.6923387854],
                        [9.11e-09, 4.70177653335, 81.682697247],
                        [9.26e-09, 3.09765550633, 833.552661779],
                        [8.12e-09, 3.54377377085, 149.4031384402],
                        [8.01e-09, 5.48034970408, 21.9795259432],
                        [9e-09, 4.2173934702, 778.4147831847],
                        [6.89e-09, 2.56862945159, 109.3125493421],
                        [6.85e-09, 3.1996582898, 31.6526280834],
                        [9.52e-09, 4.8257997882, 1744.8558675419],
                        [7.24e-09, 2.16878848875, 1171.875873269],
                        [8.97e-09, 3.94746491183, 75.6753704446],
                        [7.39e-09, 5.45802693622, 252.6559713532],
                        [8.21e-09, 4.26046087515, 1246.6574718363],
                        [6.63e-09, 5.83767831921, 86.6304479833],
                        [6.64e-09, 1.72432848951, 216.4804891757],
                        [7.21e-09, 3.98089320988, 902.7051860538],
                        [6.63e-09, 4.98388191647, 958.576777831],
                        [7.5e-09, 2.66119349235, 363.5166838784],
                        [8.28e-09, 3.62849315181, 14.8177948326],
                        [6.63e-09, 3.23521229496, 207.8824694666],
                        [6.81e-09, 3.29667467046, 25.0603459444],
                        [8.87e-09, 4.81199147907, 155.5010879678],
                        [6.46e-09, 2.65129054432, 685.4739373527],
                        [8.08e-09, 5.68764955594, 280.003939158],
                        [6.19e-09, 1.32296886424, 193.655375465],
                        [6.21e-09, 2.57837200005, 703.6331846174],
                        [8.54e-09, 3.63173686962, 411.620337349],
                        [7.28e-09, 1.05845783695, 916.9322800554],
                        [7.33e-09, 0.75817076935, 44.0921783304],
                        [6.29e-09, 1.52747752455, 397.3932433474],
                        [5.99e-09, 5.30671888409, 180.1619946463],
                        [6.15e-09, 5.68908944293, 25.2727942655],
                        [7.09e-09, 0.64922689354, 14.5571624017],
                        [7.29e-09, 4.79389069212, 479.4002635001],
                        [6.67e-09, 1.98320895029, 37.611770776],
                        [5.86e-09, 1.51157853976, 668.2084619653],
                        [6.39e-09, 1.69085181319, 262.4778313397],
                        [6.16e-09, 4.62035066985, 12.2695405413],
                        [6.87e-09, 2.24368916079, 228.7982138268],
                        [5.99e-09, 2.08317681783, 149.3025647037],
                        [5.97e-09, 3.14660293947, 137.5542890242],
                        [5.81e-09, 2.69049614736, 823.9914342234],
                        [7.09e-09, 4.38514100216, 184.0941479094],
                        [6.71e-09, 3.46925958949, 105.380396079],
                        [6.19e-09, 2.91325544152, 236.8749686741],
                        [5.58e-09, 2.9617719488, 34.2008823747],
                        [6.48e-09, 5.56457931302, 140.9651774255],
                        [5.81e-09, 0.55427680962, 331.2096644892],
                        [5.85e-09, 0.15548306049, 232.4215505492],
                        [5.48e-09, 3.57525860446, 497.4476361802],
                        [5.74e-09, 5.60908001848, 118.8737768977],
                        [7.02e-09, 1.74156189506, 149.0419322728],
                        [5.43e-09, 0.49890445043, 133.1008708993],
                        [7.16e-09, 3.04149734724, 131.9252147317],
                        [5.44e-09, 6.22369103738, 149.6113812444],
                        [5.39e-09, 0.74276113752, 911.3032057629],
                        [6.14e-09, 5.83710659138, 181.0557665236],
                        [6.01e-09, 0.30768922616, 407.5876103494],
                        [6.35e-09, 4.03476459045, 136.0698163159],
                        [5.26e-09, 5.42874995984, 450.9772132642],
                        [5.47e-09, 3.07676037032, 204.7010757289],
                        [6.22e-09, 3.08666523105, 268.4369740323],
                        [5.37e-09, 4.25467814241, 217.4436970222],
                        [5.66e-09, 4.84686444604, 842.1506814881],
                        [6.36e-09, 2.57425168783, 621.7380390493],
                        [6.23e-09, 5.84341335807, 52.8020726241],
                        [5.44e-09, 3.629830065, 149.5150130248],
                        [5.78e-09, 0.34796271917, 139.4807047172],
                        [5.37e-09, 5.99181083831, 246.9787129509],
                        [6.74e-09, 2.57972741298, 602.9880909536],
                        [5.39e-09, 6.1966296161, 696.5196376166],
                        [5.16e-09, 2.19916575703, 458.090760265],
                        [6.32e-09, 5.2665855364, 67.0773507355],
                        [5.81e-09, 0.05320320337, 95.931043108],
                        [5.04e-09, 6.24600928623, 149.723255829],
                        [6.38e-09, 6.23121553223, 10063.7223490764],
                        [5.28e-09, 0.20662780149, 310.1720945331],
                        [5.37e-09, 2.96207822442, 73.1370671646],
                        [5.08e-09, 5.29969144068, 335.7749571987],
                        [4.87e-09, 2.83772541949, 143.9341228421],
                        [5.37e-09, 3.36808372143, 252.0865223816],
                        [6.32e-09, 5.88494938125, 920.8644333185],
                        [5.23e-09, 6.13183488285, 1589.0728952838],
                        [5.79e-09, 0.04597861846, 563.6312150384],
                        [6.13e-09, 0.34938781762, 343.4792050305],
                        [4.95e-09, 2.8921249981, 61.448276443],
                        [6.23e-09, 0.71740350315, 513.079881013],
                        [4.98e-09, 2.53375871592, 41.7563723602],
                        [5.64e-09, 2.01612524784, 449.2802922348],
                        [4.8e-09, 0.10535023009, 69.6737891366],
                        [4.94e-09, 3.25187012728, 428.0826635843],
                        [5.36e-09, 5.81149025999, 282.6640680339],
                        [4.68e-09, 0.89483830828, 541.5398145106],
                        [5.33e-09, 2.44239677121, 393.4610900843],
                        [5.89e-09, 6.24067076234, 29.7956483596],
                        [4.65e-09, 0.2500674371, 57.255490749],
                        [6.22e-09, 3.89339038121, 416.7763308895],
                        [5.19e-09, 2.72375973888, 469.1364605289],
                        [4.98e-09, 1.76422801185, 380.3884003909],
                        [5.96e-09, 0.83642843095, 98.3574718034],
                        [4.59e-09, 0.39052216206, 197.7999770492],
                        [5.74e-09, 2.86366933069, 170.7608257851],
                        [5.18e-09, 3.38058345605, 535.9107402181],
                        [5.64e-09, 1.20395155832, 832.5894539325],
                        [5.56e-09, 4.39974034374, 196.6243208816],
                        [5.37e-09, 3.9363706494, 460.5384408198],
                        [4.82e-09, 2.4156214883, 827.9235874865],
                        [5.78e-09, 2.39644032176, 1670.0742689746],
                        [4.75e-09, 4.19223519775, 271.4059194489],
                        [4.52e-09, 3.9914625148, 135.336103133],
                        [5.14e-09, 6.11377193423, 1894.4190646765],
                        [5.31e-09, 3.45607724228, 450.4559484024],
                        [4.92e-09, 5.87591888758, 170.1701249541],
                        [5.88e-09, 2.66953705406, 310.9752436852],
                        [5.64e-09, 1.0449111737, 446.3113468182],
                        [4.4e-09, 5.85084571537, 224.2329211173],
                        [4.41e-09, 2.19799439287, 119.3950417595],
                        [5.49e-09, 6.05651523611, 76.3779458602],
                        [5.73e-09, 2.2989852675, 122.4758617607],
                        [4.73e-09, 4.61187869812, 291.262087743],
                        [5.53e-09, 4.90464199013, 463.5073862364],
                        [5.99e-09, 1.48666209087, 149.8238295655],
                        [4.99e-09, 3.72896978991, 853.196381752],
                        [4.4e-09, 5.05024690419, 79.4474650133],
                        [5.58e-09, 0.42332722744, 283.6272758804],
                        [4.58e-09, 4.49655973916, 754.8389099486],
                        [4.49e-09, 1.32861330901, 308.6876218248],
                        [5.65e-09, 0.45628024105, 241.8709035202],
                        [5.1e-09, 3.70202346104, 452.4616859725],
                        [4.04e-09, 0.1233582124, 1097.0942747017],
                        [4.09e-09, 4.02092464698, 735.8765135318],
                        [4.64e-09, 3.82915608692, 1094.5460204104],
                        [4.39e-09, 2.72266354653, 376.1956146969],
                        [4.78e-09, 0.23380952322, 1182.9215735329],
                        [4.12e-09, 1.21971515436, 419.4846438752],
                        [5.46e-09, 0.22296640745, 829.6205085159],
                        [5.1e-09, 2.69499052512, 412.5835451955],
                        [4.09e-09, 2.51935747849, 409.0720830577],
                        [4.51e-09, 0.56137272347, 758.7710632117],
                        [3.99e-09, 0.8603731533, 337.8019466282],
                        [3.93e-09, 0.402024632, 107.4980082337],
                        [4.94e-09, 5.02745190154, 619.2903584945],
                        [4.04e-09, 0.08539758465, 18.9623964168],
                        [5.04e-09, 4.18251931021, 449.4927405559],
                        [4.06e-09, 3.80082989682, 34.5309507748],
                        [5.45e-09, 2.80919248176, 514.5643537213],
                        [3.9e-09, 1.65941826256, 447.2051186955],
                        [4.48e-09, 2.81540452771, 400.1652468079],
                        [4.05e-09, 4.86073222353, 1404.0849754971],
                        [4.76e-09, 1.61050626902, 54.2865453324],
                        [4.06e-09, 1.29798079034, 226.7924762567],
                        [5.26e-09, 5.35780726572, 838.218528225],
                        [4.03e-09, 2.75405589772, 285.1117485887],
                        [3.81e-09, 4.97702366598, 309.2783226558],
                        [4.48e-09, 1.37926537411, 745.277682393],
                        [4.19e-09, 0.90546724862, 451.7279727896],
                        [4.5e-09, 1.92391706975, 474.9468453752],
                        [4.74e-09, 5.54351717465, 494.2662424425],
                        [4.6e-09, 5.09575399931, 289.5651667136],
                        [4.55e-09, 3.1475508733, 168.5737776612],
                        [3.72e-09, 4.87645271422, 116.5379709275],
                        [4.79e-09, 1.08512503555, 154.2984995498],
                        [3.74e-09, 0.16389070181, 1190.7858800591],
                        [4.22e-09, 3.51871257208, 706.8145783551],
                        [3.54e-09, 4.06405413226, 124.2904028691],
                        [4.94e-09, 4.57924296149, 167.7224443993],
                        [3.57e-09, 5.78050145791, 1265.5674786264],
                        [4.02e-09, 2.6765270326, 464.4705940829],
                        [3.7e-09, 2.21677703856, 232.0490435337],
                        [4.62e-09, 4.1042430527, 27.7204748203],
                        [3.64e-09, 3.0751873248, 442.639825986],
                        [4.03e-09, 1.69214233165, 90.2807169561],
                        [3.48e-09, 1.16647947937, 357.4456666012],
                        [4.43e-09, 1.32306861852, 298.2326223919],
                        [3.86e-09, 4.34980428548, 227.5261894396],
                        [3.37e-09, 5.92030047826, 445.3481389717],
                        [3.56e-09, 2.3882420066, 511.5954083047],
                        [3.57e-09, 3.19265737844, 21.1976286505],
                        [4.06e-09, 3.72223708907, 3116.2676309979],
                        [3.41e-09, 3.05116722794, 15.7810026791],
                        [3.79e-09, 4.72472516443, 30.5987975117],
                        [4e-09, 0.71868453904, 836.5216071956],
                        [3.7e-09, 0.17259001853, 6531.661656265],
                        [4.56e-09, 0.83408547295, 674.8007441043],
                        [3.76e-09, 5.91068811321, 1617.3840709351],
                        [3.92e-09, 1.90856045571, 25863.5583458723],
                        [3.33e-09, 4.77074940789, 76.7873361374],
                        [3.32e-09, 0.8569940272, 749.2098356561],
                        [3.21e-09, 3.88221470645, 38.6061163898],
                        [3.21e-09, 2.59404134515, 1300.9922012785],
                        [4.38e-09, 2.60178805278, 224.4566702865],
                        [3.71e-09, 3.73501205989, 328.2407190726],
                        [3.57e-09, 0.03656571669, 148.8124376092],
                        [3.89e-09, 3.06990362181, 1012.9115072732],
                        [3.92e-09, 3.14428599675, 125.1841747464],
                        [3.26e-09, 2.23565995627, 89.5993933999],
                        [3.14e-09, 4.56810921721, 1681.1199692385],
                        [3.33e-09, 4.37613329736, 147.9668498417],
                        [3.26e-09, 4.15448016748, 21.1494445407],
                        [3.71e-09, 4.09066371754, 239.1625905345],
                        [3.72e-09, 1.12230345314, 321.7603115182],
                        [3.05e-09, 6.12924444546, 19.9737883731],
                        [4.07e-09, 3.65906570714, 679.2541622292],
                        [4.06e-09, 3.58469900333, 26013.1215430069],
                        [3.1e-09, 3.92339533494, 229.0800981171],
                        [3.21e-09, 1.35118535306, 172.4577468145],
                        [3.32e-09, 3.54513021513, 288.7350853111],
                        [3.12e-09, 2.87878773413, 806.725958836],
                        [3.72e-09, 1.99953045718, 192.8040422031],
                        [3.02e-09, 0.01867543539, 501.3797894433],
                        [2.99e-09, 3.9646896095, 20277.0078952874],
                        [3.08e-09, 2.66235795286, 248.7238180901],
                        [2.98e-09, 3.52867456736, 21.4582610814],
                        [3.7e-09, 3.51061046963, 91.4563731237],
                        [2.97e-09, 0.79872983355, 742.9900605326],
                        [4.14e-09, 4.81163687199, 589.4947101349],
                        [3.02e-09, 5.2607933805, 27.5604161259],
                        [3.14e-09, 3.14643487607, 361.3778198643],
                        [3.56e-09, 4.63707521448, 442.7517005706],
                        [3.57e-09, 3.44793069844, 44.6134431922],
                        [3.7e-09, 4.25032151516, 304.2342036999],
                        [3.66e-09, 5.43115395433, 625.9945152181],
                        [3.65e-09, 0.3045449841, 6283.0758499914],
                        [3.22e-09, 2.32892248876, 229.4526051326],
                        [3.69e-09, 3.28573365074, 104.5290628171],
                        [3.27e-09, 2.98588869318, 348.8476468921],
                        [3.15e-09, 3.66842071994, 230.9370778409],
                        [3.56e-09, 0.90433599977, 29.7474642498],
                        [3.84e-09, 0.91820739126, 549.7284439425],
                        [3.17e-09, 3.86462587284, 639.897286314],
                        [3.33e-09, 4.95319798125, 881.5075574033],
                        [2.85e-09, 4.09883967296, 904.1896587621],
                        [3.38e-09, 5.65177488491, 195.7729876197],
                        [3.65e-09, 0.57418860616, 285.6330134505],
                        [3.63e-09, 0.98999016221, 839.7030009333],
                        [3.3e-09, 2.26308969695, 49.1787359017],
                        [3.35e-09, 2.25619157817, 272.5815756165],
                        [3.76e-09, 5.87496858487, 268.9582388941],
                        [3.62e-09, 4.94491380965, 572.2292347475],
                        [3.2e-09, 5.58342880588, 459.3627846522],
                        [2.99e-09, 2.86286938521, 883.7951792637],
                        [2.86e-09, 2.49409963193, 156.043604689],
                        [2.72e-09, 3.62976505444, 754.0357607965],
                        [3.49e-09, 2.34615857088, 6069.7767545534],
                        [2.79e-09, 4.04872155075, 180.7951340927],
                        [3.28e-09, 1.21350330743, 148.1905990109],
                        [3.15e-09, 0.74270298817, 320.2758388099],
                        [3.24e-09, 5.54296698387, 1507.1777497157],
                        [2.66e-09, 4.36134021576, 1310.3933701397],
                        [2.62e-09, 5.84934968714, 450.1740641121],
                        [2.8e-09, 5.05848320657, 102.523325247],
                        [3.47e-09, 4.7006863962, 282.1428031721],
                        [3.42e-09, 5.47365149093, 163.5778428151],
                        [3.64e-09, 3.29301824378, 378.9039276826],
                        [3.3e-09, 4.63426494882, 341.9947323222],
                        [2.59e-09, 2.43682741156, 170.0100662597],
                        [3.36e-09, 3.79029047358, 9999.986450773],
                        [2.84e-09, 2.52583672467, 266.1011680621],
                        [2.81e-09, 3.93593342516, 194.1766403268],
                        [2.97e-09, 0.18595848541, 491.8185618877],
                        [2.9e-09, 4.49575150721, 151.850818995],
                        [2.84e-09, 1.59495665161, 336.8387387817],
                        [2.55e-09, 5.85817353877, 229.340730548],
                        [2.6e-09, 5.92834225312, 455.0694252217],
                        [2.74e-09, 0.53977064975, 380.2396425446],
                        [2.59e-09, 3.15728797958, 454.7493078329],
                        [3.03e-09, 0.17851964142, 384.5811860849],
                        [2.85e-09, 1.29732672572, 25.1297819136],
                        [2.73e-09, 4.18776699292, 177.3049238143],
                        [3.26e-09, 1.68159391466, 161.7208630913],
                        [3.21e-09, 2.36931686576, 2274.5468326365],
                        [2.41e-09, 3.57660492473, 150.31395666],
                        [2.73e-09, 3.787800994, 380.0158933754],
                        [2.65e-09, 3.02540120552, 454.7974919427],
                        [2.65e-09, 6.06087280189, 455.0212411119],
                        [2.79e-09, 3.82392760479, 31.5407534988],
                        [2.73e-09, 2.64820862667, 838.0060799039],
                        [2.38e-09, 5.17487170793, 263.0203480609],
                        [2.99e-09, 3.94906046599, 531.978586955],
                        [3.17e-09, 2.28289083599, 44.070926471],
                        [2.5e-09, 1.35950829789, 304.1223291153],
                        [3.12e-09, 2.73327875294, 442.3791935551],
                        [3.14e-09, 3.86400459047, 734.4557312983],
                        [2.51e-09, 0.15148137746, 221.1634019642],
                        [2.72e-09, 5.71864670101, 164.5410506616],
                        [3.05e-09, 4.96642198943, 1140.38330388],
                        [2.82e-09, 5.46073788901, 550.1378342197],
                        [2.73e-09, 5.68721459468, 92.4195809702],
                        [2.56e-09, 0.8878797087, 418.5214360287],
                        [2.29e-09, 5.02021405557, 144.8973306886],
                        [2.31e-09, 5.7023675287, 132.8884225782],
                        [2.18e-09, 2.0562373618, 303.0585475323],
                        [3e-09, 1.76109447754, 371.5297482509],
                        [2.16e-09, 2.97122807313, 176.6505325085],
                        [2.24e-09, 3.12798198868, 188.9200730498],
                        [2.12e-09, 1.30757526083, 74.1484591209],
                        [2.38e-09, 4.65119406609, 385.7568422525],
                        [2.16e-09, 0.0708691012, 893.3564068193],
                        [2.62e-09, 5.78959872639, 635.9651330509],
                        [2.5e-09, 4.47327859711, 551.1010420662],
                        [2.22e-09, 1.64692618955, 76.42612997],
                        [2.54e-09, 2.61838408005, 525.2375469697],
                        [2.84e-09, 4.13290731223, 544.5087599272],
                        [2.62e-09, 2.82476092056, 971.1069508032],
                        [2.66e-09, 4.1246725861, 375.6743498351],
                        [2.12e-09, 3.61675003296, 75.4147380137],
                        [2.53e-09, 3.14224867483, 270.1820791715],
                        [2.5e-09, 4.32883971376, 346.4481504471],
                        [2.73e-09, 1.95676918609, 402.2191684878],
                        [2.59e-09, 1.96371242284, 968.1380053866],
                        [2.38e-09, 1.29663338057, 421.1815649046],
                        [2.43e-09, 5.94961177434, 117.36805233],
                        [2.41e-09, 4.70849619029, 406.954470903],
                        [2.16e-09, 3.31232425021, 190.665178189],
                        [2.01e-09, 1.23733749784, 799.6124118352],
                        [2.23e-09, 0.98087204684, 627.3671133418],
                        [2.26e-09, 1.66139333004, 1366.2125722902],
                        [2.05e-09, 0.3383968395, 143.3434220111],
                        [2.4e-09, 0.71559872262, 525.7588118315],
                        [2.23e-09, 2.57722930616, 981.6313862053],
                        [1.93e-09, 4.48974066435, 172.1971143836],
                        [2.21e-09, 2.88670838151, 238.9019581036],
                        [1.77e-09, 3.87122035013, 389.6889955156],
                        [1.75e-09, 5.85737374379, 170.7126416753],
                        [2.33e-09, 0.63169996424, 980.6681783588],
                        [2.25e-09, 4.81504648561, 88.274979386],
                        [2.1e-09, 2.49819501106, 128.4350044533],
                        [1.72e-09, 0.91255921858, 210.8514148832],
                        [1.76e-09, 3.85133296117, 605.9570363702],
                        [2.11e-09, 1.72999855867, 10213.285546211],
                        [1.7e-09, 1.614053401, 1512.8068240082],
                        [2.16e-09, 1.54874566441, 1060.8664028975],
                        [1.94e-09, 6.07381783144, 520.129737539],
                        [1.7e-09, 2.58526747515, 1515.7757694248],
                        [1.72e-09, 1.45073604378, 995.6460318858],
                        [1.6e-09, 4.20015913513, 433.7117378768],
                        [2.19e-09, 1.63985385568, 630.3360587584],
                        [2.19e-09, 1.96273394194, 313.6835566709],
                        [1.59e-09, 3.62343846627, 73.9784494152],
                        [2.06e-09, 0.83764718449, 104.8378793578],
                        [2.03e-09, 0.68701289007, 1363.2436268736],
                        [1.58e-09, 0.81666479221, 987.5692770385],
                        [1.72e-09, 2.97938676702, 327.4375699205],
                        [1.47e-09, 2.15517092627, 73.2489417492],
                        [1.56e-09, 1.296434692, 216.2680408546],
                        [1.53e-09, 3.77492020946, 768.8535556291],
                        [1.47e-09, 4.74903152642, 73.3453099688],
                        [1.98e-09, 2.80749830888, 225.3080035484],
                        [1.79e-09, 0.35410767087, 421.2297490144],
                        [2.04e-09, 3.47423038287, 564.8550553158],
                        [1.72e-09, 2.8842064282, 233.533516242],
                        [1.95e-09, 3.09114364733, 294.3004691288],
                        [1.81e-09, 4.75684139861, 71.1582618449],
                        [1.6e-09, 3.16134209902, 70.0462961521],
                        [1.55e-09, 2.07144269719, 91.2439248026],
                        [1.54e-09, 3.37462128317, 138.4056222861],
                        [1.92e-09, 6.19629054455, 312.1990839626],
                        [1.62e-09, 0.60896273267, 73.0364934281],
                        [1.72e-09, 2.01712700688, 973.554631358],
                        [1.45e-09, 1.72582731815, 302.3772239761],
                        [1.7e-09, 2.97437423989, 3191.0492295652],
                        [1.53e-09, 0.11158566352, 138.6293714553],
                        [1.64e-09, 5.37129563471, 457.3570470821],
                        [1.32e-09, 3.15466226029, 523.4711899711],
                        [1.37e-09, 2.88313323946, 765.8846102125],
                        [1.28e-09, 1.75773421717, 77.7023598741],
                        [1.73e-09, 5.03552846066, 415.2918581812],
                        [1.37e-09, 4.77137510538, 73.4571845534],
                        [1.63e-09, 0.99316178485, 94.4253185403],
                        [1.38e-09, 4.68330115148, 517.1607921224],
                        [1.33e-09, 2.95376828791, 75.1541055828],
                        [1.34e-09, 1.35779558361, 249.9476583675],
                        [1.68e-09, 4.7316454297, 108.7218485111],
                        [1.19e-09, 1.48229220689, 237.4174853953],
                        [1.34e-09, 1.5227717792, 154.6710065653],
                        [1.17e-09, 5.4864227361, 437.6438911399],
                        [1.31e-09, 5.76525548944, 75.4359898731],
                        [1.27e-09, 2.3830922723, 208.8456773131],
                        [1.15e-09, 4.38951350436, 343.2185725996],
                        [1.14e-09, 4.48142283161, 224.8660605637],
                        [1.17e-09, 5.37802827323, 293.7097682978],
                        [1.36e-09, 2.80772094137, 374.4986936675],
                      ],
          },
          {
            series => "L1",
            terms  => [
                        [75.02543121646, 0, 0],
                        [0.00154458244, 5.24201658072, 74.7815985673],
                        [0.00024456413, 1.71255705309, 1.4844727083],
                        [9.257828e-05, 0.42844639064, 11.0457002639],
                        [8.265977e-05, 1.5022003511, 63.7358983034],
                        [7.841715e-05, 1.31983607251, 149.5631971346],
                        [3.899105e-05, 0.46483574024, 3.9321532631],
                        [2.283777e-05, 4.17367533997, 76.2660712756],
                        [1.9266e-05, 0.53013080152, 2.9689454166],
                        [1.232727e-05, 1.58634458237, 70.8494453042],
                        [7.91206e-06, 5.43641224143, 3.1813937377],
                        [7.66954e-06, 1.99555409575, 73.297125859],
                        [4.81671e-06, 2.98401996914, 85.8272988312],
                        [4.49798e-06, 4.13826237508, 138.5174968707],
                        [4.456e-06, 3.72300400331, 224.3447957019],
                        [4.26554e-06, 4.73126059388, 71.8126531507],
                        [3.47735e-06, 2.45372261286, 9.5612275556],
                        [3.53752e-06, 2.58324496886, 148.0787244263],
                        [3.17084e-06, 5.57855232072, 52.6901980395],
                        [1.7992e-06, 5.68367730922, 12.5301729722],
                        [1.71084e-06, 3.00060075287, 78.7137518304],
                        [2.05585e-06, 2.36263144251, 2.4476805548],
                        [1.58029e-06, 2.90931969498, 0.9632078465],
                        [1.89068e-06, 4.20242881378, 56.6223513026],
                        [1.5467e-06, 5.59083925605, 4.4534181249],
                        [1.83762e-06, 0.28371004654, 151.0476698429],
                        [1.43464e-06, 2.59049246726, 62.2514255951],
                        [1.51984e-06, 2.9421732689, 77.7505439839],
                        [1.53515e-06, 4.65186885939, 35.1640902212],
                        [1.21452e-06, 4.1483920492, 127.4717966068],
                        [1.15546e-06, 3.73224603791, 65.2203710117],
                        [1.02022e-06, 4.18754517993, 145.6310438715],
                        [1.01718e-06, 6.03385875009, 0.1118745846],
                        [8.8202e-07, 3.99035787994, 18.1592472647],
                        [8.7549e-07, 6.15520787584, 202.2533951741],
                        [8.053e-07, 2.64124743934, 22.0914005278],
                        [7.2047e-07, 6.04545933578, 70.3281804424],
                        [6.857e-07, 4.05071895264, 77.962992305],
                        [5.9173e-07, 3.70413919082, 67.6680515665],
                        [4.7267e-07, 3.54312460519, 351.8165923087],
                        [4.2534e-07, 5.72357370899, 5.4166259714],
                        [4.4339e-07, 5.90865821911, 7.1135470008],
                        [3.5605e-07, 3.29197259183, 8.0767548473],
                        [3.5524e-07, 3.32784616138, 71.6002048296],
                        [3.6116e-07, 5.89964278801, 33.6796175129],
                        [3.0608e-07, 5.46414592601, 160.6088973985],
                        [3.1454e-07, 5.62015632303, 984.6003316219],
                        [3.8544e-07, 4.91519003848, 222.8603229936],
                        [3.4996e-07, 5.08034112149, 38.1330356378],
                        [3.0811e-07, 5.49591403863, 59.8037450403],
                        [2.8947e-07, 4.51867390414, 84.3428261229],
                        [2.6627e-07, 5.54127301037, 131.4039498699],
                        [2.9866e-07, 1.65980844667, 447.7958195265],
                        [2.9206e-07, 1.14722640419, 462.0229135281],
                        [2.5753e-07, 4.99362028417, 137.0330241624],
                        [2.5373e-07, 5.73584678604, 380.12776796],
                        [2.1672e-07, 2.80556379586, 69.3649725959],
                        [2.6605e-07, 6.14640604128, 299.1263942692],
                        [2.2995e-07, 2.24925345862, 111.4301614968],
                        [1.9246e-07, 3.55645739672, 54.1746707478],
                        [2.178e-07, 0.93285892393, 213.299095438],
                        [1.9338e-07, 1.86249384092, 108.4612160802],
                        [1.6153e-07, 3.10208165842, 14.977853527],
                        [1.3126e-07, 1.95385539499, 87.3117715395],
                        [1.3907e-07, 1.541490458, 340.7708920448],
                        [1.3549e-07, 4.3845512672, 5.9378908332],
                        [1.3102e-07, 5.88301410143, 6.2197751235],
                        [1.181e-07, 0.32615567587, 35.4247226521],
                        [1.098e-07, 1.69230280951, 45.5766510387],
                        [1.2351e-07, 0.32823896833, 51.2057253312],
                        [1.0906e-07, 5.9706844479, 265.9892934775],
                        [1.1446e-07, 3.37831545858, 72.3339180125],
                        [1.2013e-07, 3.60395709253, 269.9214467406],
                        [1.1662e-07, 1.74504271366, 79.2350166922],
                        [1.3777e-07, 2.69028726334, 225.8292684102],
                        [1.2006e-07, 5.34430562395, 152.5321425512],
                        [9.866e-08, 5.50316093605, 153.4953503977],
                        [1.0436e-07, 4.16875643286, 24.3790223882],
                        [1.0632e-07, 3.06875158069, 284.1485407422],
                        [9.613e-08, 0.49590148788, 209.3669421749],
                        [9.283e-08, 3.54479191952, 41.6444977756],
                        [9.536e-08, 5.60054956443, 82.8583534146],
                        [9.74e-08, 1.01087744586, 68.8437077341],
                        [9.187e-08, 4.49472579228, 20.6069278195],
                        [1.0159e-07, 3.51765739489, 529.6909650946],
                        [8.612e-08, 3.88869873588, 60.7669528868],
                        [1.003e-07, 4.6479020458, 77.2292791221],
                        [8.689e-08, 1.96813580258, 195.1398481733],
                        [8.37e-08, 4.40914764204, 134.5853436076],
                        [9.273e-08, 3.932912279, 39.6175083461],
                        [7.784e-08, 5.35626068469, 75.7448064138],
                        [7.724e-08, 5.77176047568, 73.8183907208],
                        [7.683e-08, 4.44252070929, 14.0146456805],
                        [8.355e-08, 2.4442591043, 146.594251718],
                        [7.954e-08, 5.73093878181, 184.7272873558],
                        [7.465e-08, 2.18972405572, 145.1097790097],
                        [6.43e-08, 0.84582374839, 32.1951448046],
                        [6.257e-08, 2.17085130003, 74.8934731519],
                        [7.911e-08, 0.17275924476, 120.358249606],
                        [7.036e-08, 4.12047266896, 191.2076949102],
                        [6.86e-08, 2.13462553365, 116.4260963429],
                        [5.191e-08, 3.11155355454, 106.9767433719],
                        [4.798e-08, 2.25093144226, 46.2097904851],
                        [4.566e-08, 3.45427648666, 0.7507595254],
                        [4.401e-08, 3.94058045671, 6.592282139],
                        [4.214e-08, 5.17805765625, 144.1465711632],
                        [4.409e-08, 0.24427052932, 92.940845832],
                        [4.866e-08, 1.15344187054, 112.9146342051],
                        [4.744e-08, 5.18229292013, 81.0013736908],
                        [4.332e-08, 2.52429167546, 99.1606209555],
                        [3.876e-08, 2.78430217652, 565.1156877467],
                        [3.801e-08, 0.75133837939, 58.1068240109],
                        [4.146e-08, 5.84943984597, 221.3758502853],
                        [3.885e-08, 4.95626104286, 125.9873238985],
                        [3.815e-08, 3.2300440193, 479.2883889155],
                        [3.679e-08, 5.28098232097, 66.9172920411],
                        [3.479e-08, 2.95514470947, 74.6697239827],
                        [3.514e-08, 4.90090391308, 28.3111756513],
                        [4.515e-08, 4.15474629145, 344.7030453079],
                        [4.036e-08, 2.28903172191, 109.9456887885],
                        [4.266e-08, 2.68534591099, 7.8643065262],
                        [3.428e-08, 0.02846652682, 140.001969579],
                        [3.644e-08, 5.3200209381, 408.4389436113],
                        [3.252e-08, 1.44975192429, 128.9562693151],
                        [4.143e-08, 1.89070487241, 277.0349937414],
                        [3.177e-08, 0.04197149544, 220.4126424388],
                        [3.901e-08, 6.25926496244, 0.8937718773],
                        [3.787e-08, 0.02516903921, 152.7445908723],
                        [3.2e-08, 0.52009458683, 2.2876218604],
                        [2.995e-08, 1.94615440691, 80.1982245387],
                        [4.029e-08, 5.24603808726, 96.8729990951],
                        [3.302e-08, 4.8103355106, 422.6660376129],
                        [3.189e-08, 6.261566034, 456.3938392356],
                        [2.804e-08, 1.35626949052, 404.5067903482],
                        [2.97e-08, 0.54327361056, 159.1244246902],
                        [3.465e-08, 5.88337990735, 16.6747745564],
                        [3.518e-08, 4.9964940413, 36.6485629295],
                        [3.081e-08, 2.82772472086, 453.424893819],
                        [3.32e-08, 1.56223495893, 23.5758732361],
                        [2.573e-08, 6.19617997586, 135.5485514541],
                        [2.547e-08, 5.19937103778, 173.9422195228],
                        [2.534e-08, 1.85452635674, 490.3340891794],
                        [3.106e-08, 6.07067928601, 142.4496501338],
                        [3.302e-08, 1.02846689671, 297.6419215609],
                        [2.429e-08, 1.33640100979, 211.8146227297],
                        [2.792e-08, 3.89897022917, 358.9301393095],
                        [2.947e-08, 5.31528985588, 55.1378785943],
                        [2.449e-08, 3.44007536754, 206.1855484372],
                        [2.407e-08, 4.38551271701, 60.5545045657],
                        [2.425e-08, 2.22643225523, 66.70484372],
                        [2.295e-08, 2.31690029267, 31.492569389],
                        [2.225e-08, 0.41365126245, 81.3738807063],
                        [2.196e-08, 0.76281798713, 17.5261078183],
                        [2.301e-08, 3.60815987923, 288.0806940053],
                        [2.557e-08, 0.73679737974, 200.7689224658],
                        [2.158e-08, 2.61924330277, 13.3333221243],
                        [2.048e-08, 6.27204714771, 98.8999885246],
                        [2.054e-08, 3.61072687338, 333.657345044],
                        [2.19e-08, 2.496967297, 76.4785195967],
                        [2.092e-08, 1.66496421654, 235.3904959658],
                        [2.206e-08, 2.35938756479, 347.8844390456],
                        [2.469e-08, 4.70656858928, 186.2117600641],
                        [2.226e-08, 5.9732773815, 1514.2912967165],
                        [1.851e-08, 2.19455296942, 203.7378678824],
                        [1.865e-08, 4.9820720428, 5.1078094307],
                        [2.171e-08, 5.49034081907, 373.0142209592],
                        [1.999e-08, 5.80509154216, 146.3818033969],
                        [1.903e-08, 4.32950489567, 49.5088043018],
                        [1.732e-08, 3.94794012202, 24.1183899573],
                        [1.747e-08, 2.46883637489, 55.6591434561],
                        [1.833e-08, 3.3511004846, 143.6253063014],
                        [1.686e-08, 1.28621563322, 103.0927742186],
                        [1.72e-08, 2.35857527806, 1.6445314027],
                        [1.641e-08, 2.99507314472, 391.1734682239],
                        [1.61e-08, 0.97420709262, 977.4867846211],
                        [1.696e-08, 4.98332661473, 387.2413149608],
                        [1.527e-08, 3.15107379811, 7.4223635415],
                        [1.57e-08, 1.61119571428, 991.7138786227],
                        [1.497e-08, 2.89637638984, 19.643719973],
                        [1.507e-08, 3.32822127349, 909.8187330546],
                        [1.375e-08, 5.75263837916, 19.1224551112],
                        [1.407e-08, 2.20244941425, 67.3592350258],
                        [1.364e-08, 4.40006421418, 27.0873353739],
                        [1.357e-08, 4.33780029649, 70.1157321213],
                        [1.311e-08, 4.62202930578, 81.8951455681],
                        [1.307e-08, 2.79964247834, 25.6028626656],
                        [1.312e-08, 3.7362325266, 628.8515860501],
                        [1.286e-08, 3.96557527092, 61.2882177486],
                        [1.723e-08, 4.56068809303, 305.3461693927],
                        [1.313e-08, 4.90611014973, 617.8058857862],
                        [1.508e-08, 6.25017976193, 604.4725636619],
                        [1.235e-08, 5.93779486368, 415.5524906121],
                        [1.278e-08, 3.21119872139, 92.0470739547],
                        [1.357e-08, 0.72647086107, 546.956440482],
                        [1.552e-08, 5.05296247763, 10.2949407385],
                        [1.23e-08, 1.52077038294, 157.6399519819],
                        [1.21e-08, 2.63049415027, 426.598190876],
                        [1.206e-08, 4.83219370572, 100.3844612329],
                        [1.234e-08, 4.46203104116, 162.0933701068],
                        [1.174e-08, 5.3235619109, 17.2654753874],
                        [1.431e-08, 6.18138614295, 14.2270940016],
                        [1.244e-08, 0.16929250603, 29.2049475286],
                        [1.18e-08, 4.09719023908, 443.8636662634],
                        [1.18e-08, 3.31438239649, 44.7253177768],
                        [1.259e-08, 1.88793196065, 0.6543913058],
                        [1.263e-08, 3.49967730885, 230.5645708254],
                        [1.168e-08, 2.04071854201, 30.7106720963],
                        [1.523e-08, 2.28101186489, 373.9079928365],
                        [1.429e-08, 2.05075136274, 181.7583419392],
                        [1.065e-08, 2.95960854361, 241.6102710893],
                        [1.253e-08, 0.23639539817, 561.1835344836],
                        [1.255e-08, 1.2581992576, 155.7829722581],
                        [1.044e-08, 2.89293032709, 543.0242872189],
                        [1.062e-08, 3.26314901318, 28.5718080822],
                        [1.124e-08, 1.06535506684, 88.1149206916],
                        [1.186e-08, 5.73445278027, 329.7251917809],
                        [1.19e-08, 2.82438170535, 41.1019810544],
                        [1.067e-08, 0.2710180619, 58.319272332],
                        [1.017e-08, 4.30527610005, 67.8804998876],
                        [9.59e-09, 5.20504598622, 42.5382696529],
                        [9.84e-09, 4.90934403664, 465.9550667912],
                        [9.44e-09, 0.66925769374, 88.7962442478],
                        [1.017e-08, 4.37095088461, 13.4933808187],
                        [1.222e-08, 5.13450955699, 300.6108669775],
                        [9.89e-09, 0.539379093, 80.7194894005],
                        [8.9e-09, 3.09802121989, 110.2063212194],
                        [1.095e-08, 1.7063757674, 43.1289704839],
                        [9.92e-09, 4.17968869928, 154.0166152595],
                        [9.5e-09, 0.09841899432, 273.1028404783],
                        [8.7e-09, 4.77500238443, 33.1371007917],
                        [8.67e-09, 4.22078052532, 20.4468691251],
                        [8.3e-09, 5.23785245773, 472.1748419147],
                        [8.84e-09, 4.34377463442, 105.4922706636],
                        [8.12e-09, 3.53258780148, 39.3568759152],
                        [1.055e-08, 1.52219418153, 227.3137411185],
                        [9.63e-09, 1.87806076896, 259.5088859231],
                        [8.59e-09, 0.57844232244, 152.0108776894],
                        [8.61e-09, 4.69213709412, 1059.3819301892],
                        [1.084e-08, 2.79612346618, 48.7580447764],
                        [9.94e-09, 2.87052008214, 454.9093665273],
                        [8.31e-09, 1.62068330602, 554.0699874828],
                        [8.91e-09, 2.8502603686, 32.2433289144],
                        [8.76e-09, 0.83921717739, 4.7353024152],
                        [7.07e-09, 6.16918394997, 3.6233367224],
                        [7.87e-09, 1.95585343912, 16.4623262353],
                        [7.02e-09, 5.4955704624, 558.0021407459],
                        [8.17e-09, 0.38724470336, 378.6432952517],
                        [8.04e-09, 2.25693582099, 16.04163511],
                        [8.66e-09, 1.80814575866, 258.8757464767],
                        [6.51e-09, 3.72120167607, 286.596221297],
                        [6.72e-09, 1.00052727778, 522.5774180938],
                        [6.31e-09, 4.14839739363, 141.6988906084],
                        [7.48e-09, 4.19441869839, 486.4019359163],
                        [6.68e-09, 0.77754011576, 120.9913890524],
                        [6.19e-09, 4.31040053492, 455.8725743738],
                        [6.19e-09, 4.77556598202, 453.9461586808],
                        [6.47e-09, 5.74952736928, 119.5069163441],
                        [6.09e-09, 0.24149609998, 117.9105690512],
                        [6.3e-09, 1.79018649942, 440.6822725257],
                        [6.01e-09, 1.41196883461, 218.9281697305],
                        [7.19e-09, 4.27398947015, 50.4025761791],
                        [5.94e-09, 3.92150462249, 25.2727942655],
                        [7.1e-09, 0.45768559438, 536.8045120954],
                        [7.06e-09, 6.15599144951, 258.0244132148],
                        [6.17e-09, 2.80636989892, 68.5618234438],
                        [5.87e-09, 5.47247350993, 767.3690829208],
                        [6.9e-09, 3.48978614301, 835.0371344873],
                        [5.37e-09, 4.06668446648, 450.9772132642],
                        [5.11e-09, 0.60155300709, 264.5048207692],
                        [6.94e-09, 1.18127476921, 129.9194771616],
                        [5.84e-09, 1.94104733057, 106.2741679563],
                        [5.22e-09, 5.9518061751, 518.6452648307],
                        [5.07e-09, 4.39658523394, 121.8427223143],
                        [6.27e-09, 2.24582628581, 218.4069048687],
                        [4.85e-09, 0.02058107411, 106.0135355254],
                        [5.92e-09, 2.06072766194, 296.1574488526],
                        [5.87e-09, 0.1855747086, 458.090760265],
                        [4.83e-09, 1.50333774574, 150.5264049811],
                        [4.74e-09, 4.99848521665, 458.8415197904],
                        [5.66e-09, 1.9443518903, 699.7010313543],
                        [4.72e-09, 1.865197202, 180.1619946463],
                        [4.72e-09, 0.07145793467, 216.4804891757],
                        [5.71e-09, 6.01195273302, 47.061123747],
                        [4.6e-09, 3.76890954025, 342.2553647531],
                        [4.89e-09, 2.96084966272, 385.7568422525],
                        [4.58e-09, 1.99730631732, 275.5505210331],
                        [4.6e-09, 5.75982407113, 89.7594520943],
                        [5.49e-09, 1.43219978325, 171.6545976624],
                        [5.44e-09, 0.04821904056, 114.3991069134],
                        [4.5e-09, 1.94933296558, 148.5999892881],
                        [4.44e-09, 2.94093732205, 692.5874843535],
                        [4.42e-09, 2.15938034999, 173.6815870919],
                        [5.43e-09, 2.61197342701, 451.7279727896],
                        [4.65e-09, 0.31777753866, 756.3233826569],
                        [4.41e-09, 2.82271922049, 32.7164096664],
                        [5.38e-09, 2.39420182072, 339.2864193365],
                        [5.69e-09, 0.84686482736, 260.9933586314],
                        [5.72e-09, 5.40379754526, 278.5194664497],
                        [4.22e-09, 4.61520857062, 40.1600250673],
                        [4.51e-09, 4.5091120102, 142.1408335931],
                        [5.01e-09, 0.18290112601, 331.3215390738],
                        [4.68e-09, 0.97688759019, 760.25553592],
                        [4.43e-09, 4.58896013561, 149.6750717192],
                        [4.28e-09, 1.02564850231, 469.1364605289],
                        [5e-09, 4.34235307579, 166.828672522],
                        [4.12e-09, 5.69502940499, 92.3077063856],
                        [4.04e-09, 5.18855270166, 22.633917249],
                        [3.96e-09, 3.98515136901, 31.2319369581],
                        [4.21e-09, 5.47567810199, 104.0077979553],
                        [4.25e-09, 3.50702044406, 180.2738692309],
                        [4.15e-09, 1.5229107152, 497.4476361802],
                        [4.3e-09, 2.39159932023, 39.0962434843],
                        [4.01e-09, 0.55271143649, 95.3885263868],
                        [3.84e-09, 2.48712922138, 210.3301500214],
                        [4.22e-09, 1.02056886848, 468.2426886516],
                        [4.65e-09, 5.72323435231, 183.2428146475],
                        [3.83e-09, 2.63486938783, 685.4739373527],
                        [3.67e-09, 5.39331524988, 874.3940104025],
                        [4.61e-09, 3.5796125479, 187.6962327724],
                        [4.09e-09, 4.21780704807, 181.0557665236],
                        [4.4e-09, 0.36380766054, 367.9701020033],
                        [3.92e-09, 5.44355925956, 26.0235537909],
                        [4.31e-09, 3.83885208954, 254.9435932136],
                        [3.66e-09, 2.92275490656, 291.262087743],
                        [4.16e-09, 2.54190330826, 255.0554677982],
                        [3.48e-09, 0.35176743482, 46.470422916],
                        [4.13e-09, 2.41518097006, 483.2205421786],
                        [3.86e-09, 4.76483292968, 268.4369740323],
                        [3.44e-09, 0.20350283971, 184.0941479094],
                        [3.5e-09, 1.24205287122, 97.4155158163],
                        [3.61e-09, 5.683933914, 353.301065017],
                        [3.59e-09, 2.62171903648, 162.8965192589],
                        [3.81e-09, 3.38777292581, 114.9416236346],
                        [3.52e-09, 2.76374792259, 295.1942410061],
                        [3.4e-09, 1.3466636056, 34.2008823747],
                        [4.33e-09, 1.90504858871, 123.5396433437],
                        [3.89e-09, 2.41268196916, 381.6122406683],
                        [3.83e-09, 3.20416581825, 79.4474650133],
                        [3.69e-09, 2.1518588972, 555.5544601911],
                        [3.7e-09, 2.19402183275, 562.6680071919],
                        [3.27e-09, 3.40081544565, 309.2783226558],
                        [3.78e-09, 5.75737470182, 916.9322800554],
                        [3.18e-09, 4.53066393124, 350.3321196004],
                        [3.76e-09, 1.74845257914, 545.4719677737],
                        [3.46e-09, 4.15815107375, 282.6640680339],
                        [3.19e-09, 4.38123849114, 154.979823106],
                        [3.2e-09, 0.81846631878, 610.6923387854],
                        [3.27e-09, 5.07873875355, 189.7232222019],
                        [3.06e-09, 1.71903179875, 394.3548619616],
                        [3.29e-09, 1.82999432252, 706.8145783551],
                        [3.35e-09, 4.78622577105, 109.3125493421],
                        [3.1e-09, 5.08120849869, 376.1956146969],
                        [3.27e-09, 1.87637598331, 207.8824694666],
                        [3.23e-09, 1.888454518, 192.6921676185],
                        [2.84e-09, 2.88222063053, 384.0599212231],
                        [2.83e-09, 4.63187254084, 332.1728723357],
                        [2.94e-09, 2.84554743359, 267.4737661858],
                        [2.85e-09, 0.97965330777, 113.8778420516],
                        [3.19e-09, 5.09582764612, 285.6330134505],
                        [2.8e-09, 0.67871105907, 312.4597163935],
                        [3e-09, 5.93285242876, 124.2904028691],
                        [3.2e-09, 4.86151247369, 448.6895914038],
                        [3.1e-09, 3.75000484412, 253.5709950899],
                        [3.11e-09, 5.5968659072, 271.4059194489],
                        [3.16e-09, 1.89686876211, 228.276948965],
                        [2.69e-09, 0.14585942744, 142.6620984549],
                        [2.7e-09, 2.12904548682, 778.4147831847],
                        [2.67e-09, 0.96560769114, 90.8232336773],
                        [3.08e-09, 1.38454900684, 375.3924655448],
                        [2.98e-09, 3.99595366039, 451.9404211107],
                        [2.78e-09, 3.38339026214, 346.3999663373],
                        [2.87e-09, 1.01918432834, 905.8865797915],
                        [2.63e-09, 0.16921968622, 124.5028511902],
                        [2.83e-09, 5.95865378023, 362.8622925726],
                        [2.66e-09, 3.07331582044, 193.655375465],
                        [2.64e-09, 5.47114459575, 133.1008708993],
                        [2.88e-09, 2.78232740152, 1812.5239191084],
                        [3.61e-09, 4.30140629884, 198.321241911],
                        [2.57e-09, 1.60206491208, 369.0820676961],
                        [2.74e-09, 2.88347680082, 233.9060232575],
                        [2.67e-09, 4.90554019072, 681.5417840896],
                        [3.05e-09, 1.55983861329, 49.7212526229],
                        [2.53e-09, 0.50457429429, 316.3918696566],
                        [2.58e-09, 5.81453094409, 630.3360587584],
                        [2.8e-09, 1.15452517706, 986.0848043302],
                        [2.65e-09, 4.93584097286, 831.1049812242],
                        [2.46e-09, 1.2518623362, 134.0640787458],
                        [2.98e-09, 5.75927878031, 902.7051860538],
                        [2.4e-09, 2.84888261768, 44.0921783304],
                        [2.61e-09, 2.20643594285, 73.0846775379],
                        [3.21e-09, 3.4686482782, 372.4235201282],
                        [2.34e-09, 6.06783988023, 147.1155165798],
                        [2.62e-09, 2.69623862046, 167.7224443993],
                        [2.67e-09, 4.05985113852, 75.3028634291],
                        [2.4e-09, 0.48471871511, 172.1971143836],
                        [2.61e-09, 4.64354183979, 535.3200393871],
                        [2.44e-09, 5.85987959874, 507.5995645668],
                        [2.37e-09, 4.79666486485, 377.1588225434],
                        [2.24e-09, 1.94589447357, 593.426863398],
                        [2.26e-09, 3.71637531808, 449.2802922348],
                        [2.33e-09, 5.98739382153, 219.891377577],
                        [2.4e-09, 2.71609791875, 227.5261894396],
                        [2.21e-09, 2.23218400256, 460.5384408198],
                        [2.26e-09, 2.74516124394, 446.3113468182],
                        [2.21e-09, 3.2033980767, 463.5073862364],
                        [2.03e-09, 5.04975483055, 457.8783119439],
                        [1.91e-09, 4.24841510229, 4.665866446],
                        [1.69e-09, 0.59358171769, 983.1158589136],
                        [1.79e-09, 4.12060524413, 310.1720945331],
                        [1.87e-09, 6.22165475247, 294.6729761443],
                        [1.62e-09, 1.30776665222, 248.7238180901],
                        [2.19e-09, 4.17413407057, 303.8616966844],
                        [1.93e-09, 1.64715944768, 91.4563731237],
                        [1.7e-09, 2.18067759964, 66.1835788582],
                        [1.56e-09, 4.92094728667, 68.1893164283],
                        [1.45e-09, 5.51404722738, 280.9671470045],
                        [1.44e-09, 5.81835834612, 75.5323580927],
                        [1.53e-09, 0.48549989656, 144.8973306886],
                        [1.68e-09, 5.81402201452, 149.45132255],
                        [1.5e-09, 4.66632209585, 306.830642101],
                        [1.31e-09, 1.01359934164, 175.1660598002],
                        [1.74e-09, 3.03279013213, 298.2326223919],
                        [1.63e-09, 1.97665571311, 221.1634019642],
                        [1.44e-09, 2.5905808501, 217.2312487011],
                        [1.67e-09, 2.7460416758, 69.1525242748],
                        [1.29e-09, 2.87574897902, 156.1554792736],
                      ],
          },
          {
            series => "L2",
            terms  => [
                        [0.00053033277, 0, 0],
                        [2.357636e-05, 2.26014661705, 74.7815985673],
                        [7.69129e-06, 4.52561041823, 11.0457002639],
                        [5.51533e-06, 3.25814281023, 63.7358983034],
                        [5.41532e-06, 2.27573907424, 3.9321532631],
                        [5.29473e-06, 4.92348433826, 1.4844727083],
                        [2.57521e-06, 3.69059216858, 3.1813937377],
                        [2.38835e-06, 5.85806638405, 149.5631971346],
                        [1.81904e-06, 6.21763603405, 70.8494453042],
                        [4.9401e-07, 6.03101301723, 56.6223513026],
                        [5.3504e-07, 1.44225240953, 76.2660712756],
                        [3.8222e-07, 1.78467827781, 52.6901980395],
                        [4.4753e-07, 3.90904910523, 2.4476805548],
                        [4.453e-07, 0.81152639478, 85.8272988312],
                        [3.7403e-07, 4.46228598032, 2.9689454166],
                        [3.3029e-07, 0.86388149962, 9.5612275556],
                        [2.4292e-07, 2.10702559049, 18.1592472647],
                        [2.9423e-07, 5.09818697708, 73.297125859],
                        [2.2135e-07, 4.81730808582, 78.7137518304],
                        [2.2491e-07, 5.99320728691, 138.5174968707],
                        [1.7226e-07, 2.53537183199, 145.6310438715],
                        [2.1392e-07, 2.39880709309, 77.962992305],
                        [2.0578e-07, 2.16918786539, 224.3447957019],
                        [1.6777e-07, 3.46631344086, 12.5301729722],
                        [1.2012e-07, 0.01941361902, 22.0914005278],
                        [1.0466e-07, 4.45556032593, 62.2514255951],
                        [1.101e-07, 0.0849627437, 127.4717966068],
                        [8.668e-08, 4.25550086984, 7.1135470008],
                        [1.0476e-07, 5.16453084068, 71.6002048296],
                        [7.16e-08, 1.24903906391, 5.4166259714],
                        [8.387e-08, 5.50115930045, 67.6680515665],
                        [6.087e-08, 5.44611674384, 65.2203710117],
                        [6.013e-08, 4.51836836347, 151.0476698429],
                        [5.718e-08, 1.8293391534, 202.2533951741],
                        [6.109e-08, 3.36320161279, 447.7958195265],
                        [6.003e-08, 5.72500086735, 462.0229135281],
                        [5.111e-08, 3.52374555791, 59.8037450403],
                        [5.155e-08, 1.05810305746, 131.4039498699],
                        [5.969e-08, 5.61147374852, 148.0787244263],
                        [5.065e-08, 3.36477113418, 4.4534181249],
                        [4.845e-08, 1.20298837109, 71.8126531507],
                        [3.979e-08, 0.67629577193, 77.7505439839],
                        [3.673e-08, 1.76315074166, 351.8165923087],
                        [3.149e-08, 3.83590892865, 45.5766510387],
                        [3.036e-08, 3.32062892682, 160.6088973985],
                        [3.033e-08, 6.14532331482, 77.2292791221],
                        [3.596e-08, 4.57256025582, 454.9093665273],
                        [2.664e-08, 5.36121614612, 269.9214467406],
                        [2.498e-08, 1.04819496324, 69.3649725959],
                        [2.307e-08, 2.69282373897, 84.3428261229],
                        [2.249e-08, 5.07693376112, 14.977853527],
                        [2.228e-08, 1.38937510191, 284.1485407422],
                        [2.064e-08, 4.34647674542, 984.6003316219],
                        [2.105e-08, 2.32047802326, 120.358249606],
                        [1.864e-08, 5.70354779393, 54.1746707478],
                        [2.005e-08, 3.87177765185, 195.1398481733],
                        [1.622e-08, 5.07964536529, 209.3669421749],
                        [1.597e-08, 0.48807990368, 137.0330241624],
                        [1.583e-08, 2.90536212187, 51.2057253312],
                        [1.725e-08, 6.25703202673, 41.6444977756],
                        [2.073e-08, 1.24032244487, 35.1640902212],
                        [1.543e-08, 2.15414338268, 70.3281804424],
                        [1.671e-08, 6.28283232471, 277.0349937414],
                        [1.494e-08, 6.04572758571, 87.3117715395],
                        [1.418e-08, 1.15843502159, 213.299095438],
                        [1.239e-08, 4.63223076077, 92.940845832],
                        [1.238e-08, 2.65969680342, 134.5853436076],
                        [1.273e-08, 5.87964059822, 60.5545045657],
                        [1.16e-08, 1.03320781667, 153.4953503977],
                        [1.43e-08, 4.68022239016, 299.1263942692],
                        [1.117e-08, 2.62506108047, 72.3339180125],
                        [1.142e-08, 4.64615099782, 152.7445908723],
                        [9.74e-09, 2.85233132493, 222.8603229936],
                        [1.046e-08, 4.81299135934, 116.4260963429],
                        [8.72e-09, 3.49659835508, 340.7708920448],
                        [9.52e-09, 2.1083748084, 20.6069278195],
                        [9.64e-09, 2.46471453524, 380.12776796],
                        [8.43e-09, 6.12869288891, 49.5088043018],
                        [8.21e-09, 0.27134156683, 191.2076949102],
                        [8.13e-09, 4.08930465981, 14.2270940016],
                        [7.96e-09, 6.170668463, 344.7030453079],
                        [9.24e-09, 2.11096444289, 14.0146456805],
                        [7.91e-09, 2.38927423348, 58.1068240109],
                        [7.81e-09, 0.7422311595, 408.4389436113],
                        [7.59e-09, 3.77564054479, 80.1982245387],
                        [8.84e-09, 1.99930014838, 265.9892934775],
                        [7.22e-09, 3.10001033669, 422.6660376129],
                        [7.5e-09, 2.33167721991, 358.9301393095],
                        [6.87e-09, 2.0286634204, 33.6796175129],
                        [6.03e-09, 1.10391172652, 55.1378785943],
                        [6.55e-09, 3.85415269764, 16.6747745564],
                        [6.06e-09, 0.15052747979, 28.3111756513],
                        [6.39e-09, 5.16714934188, 23.5758732361],
                        [6.58e-09, 0.75636229109, 76.4785195967],
                        [5.9e-09, 1.73778850095, 8.0767548473],
                        [5.65e-09, 4.92645232089, 35.4247226521],
                        [6.56e-09, 2.34273264083, 38.1330356378],
                        [5.42e-09, 5.97968975563, 146.594251718],
                        [5.18e-09, 3.19086220901, 152.5321425512],
                        [5.36e-09, 4.52808465499, 220.4126424388],
                        [4.89e-09, 4.80633294199, 159.1244246902],
                        [4.91e-09, 0.85765309118, 565.1156877467],
                        [4.83e-09, 3.52583593251, 144.1465711632],
                        [5.21e-09, 5.21561656321, 206.1855484372],
                        [4.77e-09, 4.25420753202, 365.9006739584],
                        [4.66e-09, 5.13219663072, 297.6419215609],
                        [5.57e-09, 0.98387565952, 225.8292684102],
                        [5.31e-09, 4.2253465745, 29.2049475286],
                        [5e-09, 3.49663062387, 128.9562693151],
                        [4.45e-09, 2.60797570173, 96.8729990951],
                        [4.66e-09, 6.05585106742, 70.1157321213],
                        [4.25e-09, 1.04692398351, 19.643719973],
                        [4.91e-09, 2.2612339868, 152.0108776894],
                        [4.55e-09, 5.45520675, 333.657345044],
                        [4.58e-09, 0.91654899383, 373.0142209592],
                        [5.2e-09, 5.72828536642, 111.4301614968],
                        [4.32e-09, 1.04604024916, 125.9873238985],
                        [3.87e-09, 2.82547341355, 200.7689224658],
                        [3.83e-09, 1.91679738697, 5.6290742925],
                        [5.04e-09, 1.95816731769, 415.5524906121],
                        [3.7e-09, 3.21958844151, 387.2413149608],
                        [3.79e-09, 2.75940848661, 81.8951455681],
                        [3.45e-09, 2.98021540638, 429.7795846137],
                        [3.68e-09, 6.20331898497, 456.3938392356],
                        [3.35e-09, 5.29062985955, 13.3333221243],
                        [3.2e-09, 0.74685222907, 347.8844390456],
                        [3.07e-09, 1.65925943351, 99.1606209555],
                        [2.84e-09, 2.0943747648, 129.9194771616],
                        [2.75e-09, 0.62680026669, 31.492569389],
                        [3.39e-09, 1.65968150805, 142.4496501338],
                        [2.7e-09, 2.7937834555, 977.4867846211],
                        [2.84e-09, 2.42261530322, 546.956440482],
                        [2.71e-09, 0.59225635449, 1894.4190646765],
                        [2.63e-09, 3.49309481771, 440.6822725257],
                        [2.95e-09, 0.43376026627, 373.9079928365],
                        [2.71e-09, 4.82853730065, 561.1835344836],
                        [2.48e-09, 5.72379940676, 79.2350166922],
                        [2.52e-09, 5.76728095309, 235.3904959658],
                        [2.61e-09, 0.09830739366, 991.7138786227],
                        [2.38e-09, 1.14634663242, 288.0806940053],
                        [2.2e-09, 5.12386263728, 479.2883889155],
                        [2.63e-09, 1.52366362053, 146.3818033969],
                        [2.3e-09, 0.35983101967, 109.9456887885],
                        [2.14e-09, 2.9438876558, 184.7272873558],
                        [1.98e-09, 5.72107161521, 453.424893819],
                        [1.85e-09, 4.7160017678, 108.4612160802],
                        [1.39e-09, 2.99832472431, 211.8146227297],
                        [1.67e-09, 1.1964352228, 39.6175083461],
                        [1.8e-09, 0.80198096578, 183.2428146475],
                        [1.31e-09, 2.73236351123, 522.5774180938],
                        [1.42e-09, 5.03489222377, 536.8045120954],
                      ],
          },
          {
            series => "L3",
            terms  => [
                        [1.20936e-06, 0.02418789918, 74.7815985673],
                        [6.8064e-07, 4.12084267733, 3.9321532631],
                        [5.2828e-07, 2.3896406126, 11.0457002639],
                        [4.3754e-07, 2.95965039734, 1.4844727083],
                        [4.53e-07, 2.0442379841, 3.1813937377],
                        [4.5806e-07, 0, 0],
                        [2.4969e-07, 4.88741307918, 63.7358983034],
                        [2.1061e-07, 4.54511486862, 70.8494453042],
                        [1.9897e-07, 2.31320314136, 149.5631971346],
                        [8.901e-08, 1.57548871761, 56.6223513026],
                        [4.271e-08, 0.22777319552, 18.1592472647],
                        [3.613e-08, 5.39244611308, 76.2660712756],
                        [3.488e-08, 4.97622811775, 85.8272988312],
                        [3.479e-08, 4.12969359977, 52.6901980395],
                        [3.572e-08, 0.95052448578, 77.962992305],
                        [2.328e-08, 0.85770961794, 145.6310438715],
                        [2.696e-08, 0.37287796344, 78.7137518304],
                        [1.946e-08, 2.67997393431, 7.1135470008],
                        [2.156e-08, 5.65647821519, 9.5612275556],
                        [1.363e-08, 4.86983744746, 224.3447957019],
                        [1.333e-08, 1.25032115614, 12.5301729722],
                        [1.613e-08, 0.48764377311, 71.6002048296],
                        [1.475e-08, 5.19957293069, 73.297125859],
                        [1.225e-08, 3.93406822032, 22.0914005278],
                        [9.11e-09, 2.18921999026, 127.4717966068],
                        [8.11e-09, 3.98323855938, 462.0229135281],
                        [8.08e-09, 5.06374463008, 447.7958195265],
                        [7.18e-09, 0.34600103024, 5.6290742925],
                        [7.22e-09, 1.05856935832, 138.5174968707],
                        [6.87e-09, 2.93752748595, 131.4039498699],
                        [4.63e-09, 1.58927254512, 151.0476698429],
                        [4.14e-09, 4.3290428762, 120.358249606],
                        [3.72e-09, 0.73596518002, 269.9214467406],
                        [3.45e-09, 3.05968942771, 561.1835344836],
                        [3.38e-09, 5.94221536204, 284.1485407422],
                        [3.43e-09, 4.01891371998, 546.956440482],
                        [3.82e-09, 5.93515231196, 45.5766510387],
                        [2.76e-09, 3.44212110991, 202.2533951741],
                        [3e-09, 1.13119175675, 160.6088973985],
                        [2.68e-09, 3.24615387968, 536.8045120954],
                        [3.58e-09, 1.10916640253, 333.657345044],
                        [2.36e-09, 4.65292396535, 387.2413149608],
                        [2.04e-09, 5.81663798296, 373.0142209592],
                        [1.45e-09, 2.75632381347, 92.940845832],
                        [1.49e-09, 0.13764106563, 71.8126531507],
                        [1.56e-09, 2.90936922804, 153.4953503977],
                      ],
          },
          {
            series => "L4",
            terms  => [
                        [1.13855e-06, 3.14159265359, 0],
                        [5.599e-08, 4.57882424417, 74.7815985673],
                        [3.203e-08, 0.34623003207, 11.0457002639],
                        [1.217e-08, 3.42199121826, 56.6223513026],
                        [6.34e-09, 4.65759668097, 18.1592472647],
                        [1.71e-09, 3.80393539303, 149.5631971346],
                        [1.33e-09, 4.35519131657, 63.7358983034],
                      ],
          },
          { series => "L5", terms => [[8.73e-09, 3.14159265359, 0]] },
        ],
        [
          {
            series => "B0",
            terms  => [
                        [0.01346277639, 2.61877810545, 74.7815985673],
                        [0.00062341405, 5.08111175856, 149.5631971346],
                        [0.00061601203, 3.14159265359, 0],
                        [9.963744e-05, 1.61603876357, 76.2660712756],
                        [9.926151e-05, 0.57630387917, 73.297125859],
                        [3.259455e-05, 1.2611938596, 224.3447957019],
                        [2.972318e-05, 2.24367035538, 1.4844727083],
                        [2.010257e-05, 6.05550401088, 148.0787244263],
                        [1.522172e-05, 0.27960386377, 63.7358983034],
                        [9.24055e-06, 4.03822927853, 151.0476698429],
                        [7.60624e-06, 6.14000431923, 71.8126531507],
                        [4.20265e-06, 5.21279984788, 11.0457002639],
                        [4.30668e-06, 3.55445034854, 213.299095438],
                        [4.36843e-06, 3.38082524317, 529.6909650946],
                        [5.22309e-06, 3.3208519477, 138.5174968707],
                        [4.34625e-06, 0.34065281858, 77.7505439839],
                        [4.6263e-06, 0.74256727574, 85.8272988312],
                        [2.32649e-06, 2.25716421383, 222.8603229936],
                        [2.15838e-06, 1.5912170494, 38.1330356378],
                        [2.44698e-06, 0.78795150326, 2.9689454166],
                        [1.79935e-06, 3.72487952673, 299.1263942692],
                        [1.74895e-06, 1.23550262213, 146.594251718],
                        [1.73667e-06, 1.93654269131, 380.12776796],
                        [1.60368e-06, 5.33635436463, 111.4301614968],
                        [1.44064e-06, 5.96239326415, 35.1640902212],
                        [1.02049e-06, 2.61876256513, 78.7137518304],
                        [1.16363e-06, 5.73877190007, 70.8494453042],
                        [1.06441e-06, 0.94103112994, 70.3281804424],
                        [8.6163e-07, 0.70262506622, 39.6175083461],
                        [7.2617e-07, 0.20564696113, 225.8292684102],
                        [7.1172e-07, 0.83343269975, 109.9456887885],
                        [5.7502e-07, 2.67039425415, 108.4612160802],
                        [5.4255e-07, 3.35166579613, 184.7272873558],
                        [4.447e-07, 2.74408231138, 152.5321425512],
                        [3.8591e-07, 5.17394663303, 202.2533951741],
                        [3.9157e-07, 2.17108251341, 351.8165923087],
                        [4.1346e-07, 3.22134319551, 160.6088973985],
                        [3.514e-07, 4.00111634363, 112.9146342051],
                        [3.3073e-07, 3.61378095742, 221.3758502853],
                        [3.1315e-07, 2.71969470781, 145.1097790097],
                        [3.7336e-07, 4.02053241202, 52.6901980395],
                        [3.2028e-07, 1.29160071142, 145.6310438715],
                        [2.7574e-07, 3.7006426696, 36.6485629295],
                        [2.4277e-07, 2.84989187496, 127.4717966068],
                        [2.4635e-07, 1.11645461259, 3.9321532631],
                        [2.4315e-07, 5.48987913644, 79.2350166922],
                        [2.1418e-07, 0.63722900407, 277.0349937414],
                        [1.9826e-07, 2.5933418223, 84.3428261229],
                        [2.2373e-07, 5.73687615457, 4.4534181249],
                        [1.9137e-07, 1.30214105578, 62.2514255951],
                        [1.9789e-07, 4.72260849557, 297.6419215609],
                        [2.0299e-07, 1.06070151806, 454.9093665273],
                        [1.9768e-07, 5.77906142568, 305.3461693927],
                        [2.1348e-07, 1.01350946382, 33.6796175129],
                        [1.5142e-07, 2.91786832554, 426.598190876],
                        [1.6e-07, 1.95535748902, 186.2117600641],
                        [1.3819e-07, 2.67163927171, 74.6697239827],
                        [1.1463e-07, 5.73391138419, 41.1019810544],
                        [1.0741e-07, 3.73401569675, 1059.3819301892],
                        [1.145e-07, 3.98177764866, 106.9767433719],
                        [1.036e-07, 4.75567608732, 183.2428146475],
                        [1.0232e-07, 6.18772866993, 373.9079928365],
                        [1.3803e-07, 5.70712120608, 74.8934731519],
                        [1.0553e-07, 3.78602881738, 490.3340891794],
                        [1.1838e-07, 5.96756415681, 87.3117715395],
                        [1.003e-07, 1.74828757238, 22.0914005278],
                        [1.0107e-07, 0.92911975959, 65.2203710117],
                        [9.127e-08, 5.11093790809, 153.4953503977],
                        [1.2093e-07, 2.53736362742, 9.5612275556],
                        [8.646e-08, 4.18351923569, 12.5301729722],
                        [9.978e-08, 5.83600622359, 604.4725636619],
                        [1.1352e-07, 2.12645777694, 68.8437077341],
                        [8.472e-08, 3.36885457285, 72.3339180125],
                        [7.797e-08, 5.11771906359, 77.962992305],
                        [8.302e-08, 5.19247905162, 77.2292791221],
                        [7.696e-08, 3.25189037096, 71.6002048296],
                        [7.513e-08, 2.982659701, 114.3991069134],
                        [6.947e-08, 3.31871016057, 56.6223513026],
                        [6.49e-08, 0.88434578474, 288.0806940053],
                        [6.394e-08, 3.51142812432, 220.4126424388],
                        [6.211e-08, 0.58222518453, 340.7708920448],
                        [6.772e-08, 4.09374798222, 137.0330241624],
                        [5.595e-08, 5.68643434536, 259.5088859231],
                        [5.309e-08, 2.65421183211, 300.6108669775],
                        [4.95e-08, 4.99672086239, 219.891377577],
                        [6.419e-08, 0.44895727879, 140.001969579],
                        [4.975e-08, 4.06722486039, 143.6253063014],
                        [5.692e-08, 3.7656346318, 67.6680515665],
                        [4.853e-08, 2.03383592524, 415.5524906121],
                        [3.796e-08, 1.26231186682, 75.3028634291],
                        [3.807e-08, 2.24787582155, 909.8187330546],
                        [3.812e-08, 3.10475682509, 181.7583419392],
                        [3.764e-08, 5.2005209056, 227.3137411185],
                        [3.445e-08, 5.91769433069, 296.1574488526],
                        [3.517e-08, 5.44397685665, 628.8515860501],
                        [3.943e-08, 4.95136058926, 265.9892934775],
                        [3.472e-08, 0.3473799838, 131.4039498699],
                        [3.39e-08, 0.53497504164, 206.1855484372],
                        [3.038e-08, 4.68314286209, 159.1244246902],
                        [3.19e-08, 5.68929316349, 235.3904959658],
                        [3.303e-08, 2.09359507373, 73.8183907208],
                        [3.069e-08, 4.49065085092, 66.70484372],
                        [3.285e-08, 0.00780313833, 75.7448064138],
                        [2.917e-08, 4.21615078632, 258.0244132148],
                        [3.747e-08, 0.82999983666, 74.2603337055],
                        [2.814e-08, 3.96708337625, 82.8583534146],
                        [2.474e-08, 3.81319259323, 7.1135470008],
                        [2.394e-08, 2.21483198491, 54.1746707478],
                        [2.555e-08, 2.97023907145, 378.6432952517],
                        [2.631e-08, 1.55153254691, 154.0166152595],
                        [2.633e-08, 2.28385552693, 32.1951448046],
                        [2.643e-08, 3.9683272968, 381.6122406683],
                        [2.206e-08, 3.06995275892, 59.8037450403],
                        [2.635e-08, 0.53987945692, 211.8146227297],
                        [2.071e-08, 1.97429082033, 18.1592472647],
                        [2.485e-08, 3.5543384699, 96.8729990951],
                        [2.061e-08, 4.50102695788, 5.9378908332],
                        [1.916e-08, 1.60538526374, 80.1982245387],
                        [2.48e-08, 0.63321072542, 187.6962327724],
                        [2.039e-08, 2.97351088965, 191.2076949102],
                        [1.833e-08, 1.95824865568, 81.8951455681],
                        [1.719e-08, 2.22526635038, 479.2883889155],
                        [1.745e-08, 3.22821992592, 218.4069048687],
                        [1.857e-08, 1.66304484985, 984.6003316219],
                        [1.766e-08, 5.24239122261, 105.4922706636],
                        [1.524e-08, 6.05374020264, 99.1606209555],
                        [1.519e-08, 0.94716867229, 372.4235201282],
                        [1.614e-08, 3.39986066169, 230.5645708254],
                        [1.711e-08, 3.44237080993, 522.5774180938],
                        [1.504e-08, 1.34653259405, 74.5209661364],
                        [1.577e-08, 4.3802093672, 80.7194894005],
                        [1.36e-08, 5.4869124027, 74.8297826771],
                        [1.364e-08, 4.56045715617, 42.5864537627],
                        [1.398e-08, 0.33827838973, 142.4496501338],
                        [1.709e-08, 3.63188407264, 554.0699874828],
                        [1.36e-08, 2.89305157919, 74.7334144575],
                        [1.26e-08, 5.50922979275, 74.9416572617],
                        [1.374e-08, 4.398979932, 260.9933586314],
                        [1.366e-08, 2.15288773765, 162.0933701068],
                        [1.244e-08, 4.97789913094, 149.45132255],
                        [1.269e-08, 0.84167691738, 767.3690829208],
                        [1.278e-08, 4.53585702916, 294.6729761443],
                        [1.342e-08, 5.11117141196, 51.2057253312],
                        [1.18e-08, 0.79882196802, 116.4260963429],
                        [1.495e-08, 0.74986873597, 75.0422309982],
                        [1.207e-08, 3.67288675913, 20.6069278195],
                        [1.181e-08, 4.39598416757, 180.2738692309],
                        [1.248e-08, 3.13312504066, 67.3592350258],
                        [1.263e-08, 2.87116663203, 74.6215398729],
                        [1.38e-08, 3.76141611602, 92.940845832],
                        [1.113e-08, 3.87133607367, 39.3568759152],
                        [1.018e-08, 6.20393099094, 835.0371344873],
                        [9.62e-09, 3.30343472839, 255.0554677982],
                        [1.238e-08, 1.73023505315, 149.6750717192],
                        [9.7e-09, 1.71236273285, 115.8835796217],
                        [1.001e-08, 5.49914631698, 256.5399405065],
                        [9.21e-09, 3.07729879788, 8.0767548473],
                        [9.14e-09, 0.00764291274, 536.8045120954],
                        [9.11e-09, 6.23753038018, 200.7689224658],
                        [9.56e-09, 5.76811833839, 128.9562693151],
                        [9.99e-09, 0.33400530567, 404.5067903482],
                        [9.52e-09, 3.00456073496, 14.977853527],
                        [7.65e-09, 3.4545453366, 214.7835681463],
                        [8e-09, 3.2091293209, 28.3111756513],
                        [7.99e-09, 4.11425365829, 125.9873238985],
                        [1.021e-08, 1.79905869707, 3.1813937377],
                        [7.06e-09, 5.80210566917, 157.6399519819],
                        [7.15e-09, 5.56313177065, 146.3818033969],
                        [6.89e-09, 1.84748347121, 41.6444977756],
                        [6.82e-09, 5.16479782395, 74.0308390419],
                        [6.73e-09, 2.65544175682, 75.5323580927],
                        [7.23e-09, 4.75905991606, 331.3215390738],
                        [7.3e-09, 2.25510749124, 453.424893819],
                        [6.91e-09, 3.58561635364, 362.8622925726],
                        [6.41e-09, 5.77408891198, 110.2063212194],
                        [6.71e-09, 5.96862039131, 135.5485514541],
                        [6.31e-09, 1.97807297205, 639.897286314],
                        [7.74e-09, 0.42035450706, 565.1156877467],
                        [7.05e-09, 2.94649553712, 60.7669528868],
                        [6.63e-09, 5.32574112049, 142.1408335931],
                        [6.12e-09, 2.01741578932, 195.1398481733],
                        [7.49e-09, 5.56828487823, 2.4476805548],
                        [7.98e-09, 0.90969731665, 152.0108776894],
                        [7.47e-09, 5.07639466593, 89.7594520943],
                        [6.5e-09, 4.56215718085, 216.9224321604],
                        [6.51e-09, 2.80626026285, 50.4025761791],
                        [5.93e-09, 1.89556258897, 203.7378678824],
                        [5.5e-09, 2.90625551534, 68.1893164283],
                        [5.48e-09, 3.75628845322, 617.8058857862],
                        [5.54e-09, 2.78135114877, 14.0146456805],
                        [5.3e-09, 3.51385025328, 291.7040307277],
                        [5.06e-09, 4.94619342366, 81.3738807063],
                        [6.49e-09, 5.74895589744, 141.4864422873],
                        [5.93e-09, 5.40734033998, 692.5874843535],
                        [5.44e-09, 2.9991051278, 152.7445908723],
                        [4.85e-09, 2.36317665443, 448.6895914038],
                        [4.81e-09, 5.81647231299, 134.5853436076],
                        [5.17e-09, 4.97759795528, 387.2413149608],
                        [5.73e-09, 2.46311368783, 81.0013736908],
                        [4.7e-09, 1.30184316812, 228.276948965],
                        [4.75e-09, 0.53480492526, 303.8616966844],
                        [4.85e-09, 6.21247575899, 5.4166259714],
                        [4.68e-09, 0.55881267334, 23.5758732361],
                        [5.85e-09, 4.67924542643, 88.7962442478],
                        [5.12e-09, 5.86200059955, 293.188503436],
                        [4.45e-09, 2.50076311432, 905.8865797915],
                        [5.01e-09, 4.79997295899, 306.830642101],
                        [4.18e-09, 5.21379084769, 35.4247226521],
                        [4.08e-09, 5.69107313998, 284.1485407422],
                        [4.74e-09, 3.03149617428, 286.596221297],
                        [4.32e-09, 4.20907682097, 278.5194664497],
                        [5.06e-09, 2.05348204197, 373.0142209592],
                        [4.1e-09, 5.30637634877, 95.3885263868],
                        [4.78e-09, 2.41106642594, 358.9301393095],
                        [5.36e-09, 1.8261477226, 114.1384744825],
                        [3.83e-09, 5.54541241459, 419.4846438752],
                        [4.13e-09, 0.03813081773, 103.0927742186],
                        [3.68e-09, 4.08526832792, 1589.0728952838],
                        [3.69e-09, 1.82533858431, 334.2904844904],
                        [4.91e-09, 5.58913582973, 68.5618234438],
                        [3.87e-09, 0.5661931048, 602.9880909536],
                        [4.27e-09, 5.08349119654, 367.9701020033],
                        [4.75e-09, 0.17507881032, 120.358249606],
                        [3.42e-09, 5.27187859255, 28.5718080822],
                        [4.07e-09, 2.00853504718, 679.2541622292],
                        [3.81e-09, 4.61366060949, 329.7251917809],
                        [3.88e-09, 0.88856038803, 483.2205421786],
                        [3.76e-09, 1.28856348513, 155.7829722581],
                        [3.26e-09, 6.09140263554, 456.3938392356],
                        [3.18e-09, 0.09996195379, 69.3649725959],
                        [2.92e-09, 5.11578046796, 375.3924655448],
                        [2.99e-09, 6.04121646505, 332.8060117821],
                        [3.28e-09, 3.47252263966, 73.4090004436],
                        [2.83e-09, 1.81773059325, 647.0108333148],
                        [3.08e-09, 3.50154864071, 30.7106720963],
                        [2.83e-09, 1.88910019831, 24.3790223882],
                        [2.78e-09, 3.85507901929, 760.25553592],
                        [2.73e-09, 4.22941219477, 391.1734682239],
                        [2.93e-09, 5.44464406156, 477.9157907918],
                        [2.89e-09, 3.85492516765, 209.3669421749],
                        [3.09e-09, 1.97045147502, 543.0242872189],
                        [3.24e-09, 5.57191515554, 501.3797894433],
                        [2.48e-09, 2.17741598681, 611.5861106627],
                        [2.45e-09, 1.04008534095, 1332.4847706675],
                        [2.48e-09, 6.19516038159, 1134.1635287565],
                        [2.42e-09, 1.37720813333, 121.2520214833],
                        [2.33e-09, 0.50933224249, 462.0229135281],
                        [3.19e-09, 4.2421988104, 328.3525936572],
                        [2.44e-09, 6.0064485364, 295.1942410061],
                        [2.28e-09, 0.72608678727, 233.9060232575],
                        [2.23e-09, 5.35785607671, 983.1158589136],
                        [3.04e-09, 5.68101077712, 189.1807054807],
                        [2.23e-09, 2.04168197187, 370.9390474199],
                        [2.45e-09, 4.69742022955, 316.3918696566],
                        [2.17e-09, 4.33845164683, 269.9214467406],
                        [2.67e-09, 0.15744446718, 10213.285546211],
                        [2.1e-09, 5.84975171904, 147.1155165798],
                        [2.24e-09, 3.04829549918, 1439.5096981492],
                        [2.26e-09, 0.72248476212, 45.5766510387],
                        [2.02e-09, 1.37341689387, 302.0953396858],
                        [2.07e-09, 6.13936312021, 344.7030453079],
                        [2.28e-09, 2.33602531859, 150.5264049811],
                        [2.03e-09, 2.38070591912, 275.5505210331],
                        [1.94e-09, 5.11344829813, 1215.1649024473],
                        [2.59e-09, 2.78974616768, 144.1465711632],
                        [1.99e-09, 3.21010368905, 7.4223635415],
                        [2.46e-09, 6.15106498377, 6.2197751235],
                        [1.8e-09, 4.7037703687, 518.6452648307],
                        [1.86e-09, 3.85070006482, 46.2097904851],
                        [1.75e-09, 3.72163733058, 150.0844619964],
                        [1.65e-09, 1.87245210311, 310.1720945331],
                        [1.66e-09, 3.24028819042, 173.9422195228],
                        [1.81e-09, 0.39521867351, 0.9632078465],
                        [1.44e-09, 1.78180338482, 531.1754378029],
                        [1.37e-09, 6.20635855175, 369.4545747116],
                        [1.36e-09, 4.00164375048, 526.722019678],
                        [1.41e-09, 4.02238453909, 350.3321196004],
                        [1.25e-09, 5.28865037145, 329.8370663655],
                        [1.34e-09, 3.97421067761, 228.7982138268],
                        [1.32e-09, 4.52023845365, 148.5999892881],
                        [1.25e-09, 4.24724390191, 248.7238180901],
                        [1.2e-09, 4.08565783859, 154.979823106],
                        [1.33e-09, 3.16576403244, 262.4778313397],
                      ],
          },
          {
            series => "B1",
            terms  => [
                        [0.00206366162, 4.12394311407, 74.7815985673],
                        [8.56323e-05, 0.33819986165, 149.5631971346],
                        [1.725703e-05, 2.12193159895, 73.297125859],
                        [1.36886e-05, 3.06861722047, 76.2660712756],
                        [1.374449e-05, 0, 0],
                        [3.99847e-06, 2.84767037795, 224.3447957019],
                        [4.50639e-06, 3.77656180977, 1.4844727083],
                        [3.07214e-06, 1.25456766737, 148.0787244263],
                        [1.54336e-06, 3.78575467747, 63.7358983034],
                        [1.10888e-06, 5.32888676461, 138.5174968707],
                        [1.12432e-06, 5.57299891505, 151.0476698429],
                        [8.3493e-07, 3.59152795558, 71.8126531507],
                        [5.5573e-07, 3.40135416354, 85.8272988312],
                        [4.1377e-07, 4.45476669141, 78.7137518304],
                        [5.369e-07, 1.70455769943, 77.7505439839],
                        [4.1912e-07, 1.21476607434, 11.0457002639],
                        [3.1959e-07, 3.77446207748, 222.8603229936],
                        [3.0297e-07, 2.56371683644, 2.9689454166],
                        [2.6977e-07, 5.33695500294, 213.299095438],
                        [2.6222e-07, 0.41620628369, 380.12776796],
                        [2.0094e-07, 5.9308563351, 529.6909650946],
                        [2.2992e-07, 2.48887389394, 146.594251718],
                        [1.959e-07, 5.37213500014, 299.1263942692],
                        [2.0408e-07, 3.70179681605, 70.8494453042],
                        [1.9102e-07, 1.09213276596, 111.4301614968],
                        [1.9411e-07, 3.83015453768, 38.1330356378],
                        [1.0847e-07, 2.66326308043, 3.9321532631],
                        [1.0249e-07, 2.3127880772, 109.9456887885],
                        [9.405e-08, 2.76950513184, 39.6175083461],
                        [7.66e-08, 1.8110846285, 225.8292684102],
                        [8.082e-08, 4.69064168719, 184.7272873558],
                        [6.584e-08, 5.50417589189, 35.1640902212],
                        [7.41e-08, 1.17879753422, 65.2203710117],
                        [6.451e-08, 4.98294064391, 71.6002048296],
                        [6.089e-08, 1.31830108565, 52.6901980395],
                        [4.768e-08, 5.90574941745, 145.6310438715],
                        [4.84e-08, 4.86390682412, 221.3758502853],
                        [4.192e-08, 3.29643787103, 77.962992305],
                        [4.711e-08, 4.24289069791, 152.5321425512],
                        [4.894e-08, 6.01164167429, 160.6088973985],
                        [3.738e-08, 4.75287390209, 70.3281804424],
                        [3.481e-08, 0.64108927026, 153.4953503977],
                        [3.758e-08, 3.94715595219, 351.8165923087],
                        [3.114e-08, 0.10537144899, 112.9146342051],
                        [2.788e-08, 4.24118032837, 74.6697239827],
                        [2.505e-08, 0.04576283378, 297.6419215609],
                        [2.563e-08, 4.15665405963, 305.3461693927],
                        [2.544e-08, 5.25903565788, 56.6223513026],
                        [2.247e-08, 4.24726481845, 36.6485629295],
                        [2.541e-08, 0.40106060407, 77.2292791221],
                        [2.212e-08, 2.88960413468, 277.0349937414],
                        [2.299e-08, 3.57748029365, 186.2117600641],
                        [2.661e-08, 0.53230319176, 79.2350166922],
                        [2.157e-08, 2.10150995852, 127.4717966068],
                        [2.265e-08, 1.41055702214, 4.4534181249],
                        [2.103e-08, 4.27438518414, 22.0914005278],
                        [1.861e-08, 3.75619999278, 145.1097790097],
                        [1.759e-08, 2.10240976488, 131.4039498699],
                        [1.661e-08, 4.84483054269, 62.2514255951],
                        [1.496e-08, 1.72084298116, 220.4126424388],
                        [1.659e-08, 5.86539712478, 454.9093665273],
                        [1.428e-08, 0.31508367934, 137.0330241624],
                        [1.522e-08, 1.00801468633, 75.7448064138],
                        [1.459e-08, 6.17427145114, 426.598190876],
                        [1.463e-08, 5.14953143442, 84.3428261229],
                        [1.453e-08, 2.22988903923, 206.1855484372],
                        [1.358e-08, 5.85111427068, 183.2428146475],
                        [1.405e-08, 2.43582184515, 87.3117715395],
                        [1.495e-08, 5.55621838458, 67.6680515665],
                        [1.317e-08, 1.91178535183, 140.001969579],
                        [1.068e-08, 1.51430678116, 373.9079928365],
                        [1.439e-08, 0.99170994448, 74.8934731519],
                        [1.065e-08, 4.15616015505, 288.0806940053],
                        [1.096e-08, 1.63909426062, 41.1019810544],
                        [1.189e-08, 0.90595784409, 33.6796175129],
                        [9.61e-09, 5.48175535705, 490.3340891794],
                        [8.51e-09, 0.95029849401, 909.8187330546],
                        [8.2e-09, 0.78610123063, 259.5088859231],
                        [8.81e-09, 4.31294603221, 9.5612275556],
                        [7.08e-09, 7.309836e-05, 81.8951455681],
                        [7.09e-09, 3.18853632737, 80.1982245387],
                        [7.86e-09, 5.18884635415, 114.3991069134],
                        [8.22e-09, 0.01949759759, 18.1592472647],
                        [6.56e-09, 6.16899483115, 96.8729990951],
                        [8.79e-09, 1.82006610038, 73.8183907208],
                        [8.72e-09, 0.30134022304, 12.5301729722],
                        [8.6e-09, 0.21225398802, 3.1813937377],
                        [6.37e-09, 2.64378420008, 75.3028634291],
                        [7.27e-09, 0.02846968582, 66.70484372],
                        [6e-09, 4.42462853209, 415.5524906121],
                        [5.9e-09, 4.17885957237, 300.6108669775],
                        [6.1e-09, 6.07202921132, 219.891377577],
                        [6.11e-09, 0.97629869063, 296.1574488526],
                        [6.35e-09, 2.21125075603, 74.2603337055],
                        [5.29e-09, 2.35940463062, 7.1135470008],
                        [6.22e-09, 2.2180194485, 211.8146227297],
                        [5.19e-09, 2.01872911223, 142.4496501338],
                        [4.89e-09, 1.83419944488, 92.940845832],
                        [4.45e-09, 2.51784247184, 604.4725636619],
                        [4.13e-09, 5.36482818305, 82.8583534146],
                        [4.45e-09, 0.33164113115, 227.3137411185],
                        [4.56e-09, 2.44190834824, 381.6122406683],
                        [3.78e-09, 1.91873737843, 202.2533951741],
                        [5.09e-09, 5.83556856314, 191.2076949102],
                        [4.55e-09, 5.15414537021, 522.5774180938],
                        [4.19e-09, 2.80644155875, 72.3339180125],
                        [3.33e-09, 0.3201483795, 2.4476805548],
                        [3.6e-09, 1.47248643716, 378.6432952517],
                        [3.06e-09, 0.15517399606, 159.1244246902],
                        [3.01e-09, 4.46417652272, 536.8045120954],
                        [3.53e-09, 0.48749845867, 128.9562693151],
                        [3.51e-09, 6.24769322491, 5.9378908332],
                        [2.98e-09, 1.71815652029, 235.3904959658],
                        [3.15e-09, 2.44922921309, 187.6962327724],
                        [3.18e-09, 0.7017635951, 181.7583419392],
                        [3.14e-09, 4.68400251693, 14.977853527],
                        [2.82e-09, 3.70093718573, 108.4612160802],
                        [2.72e-09, 3.91340553608, 617.8058857862],
                        [2.73e-09, 3.29483889428, 387.2413149608],
                        [3.23e-09, 4.90410549341, 258.0244132148],
                        [2.88e-09, 4.42249612833, 195.1398481733],
                        [2.5e-09, 1.23231297183, 703.6331846174],
                        [3.38e-09, 2.8464576889, 154.0166152595],
                        [2.97e-09, 1.16538119842, 146.3818033969],
                        [2.48e-09, 4.90614051989, 41.6444977756],
                        [2.75e-09, 5.35665949805, 80.7194894005],
                        [2.57e-09, 1.82441994046, 230.5645708254],
                        [2.34e-09, 0.27679874465, 33.1371007917],
                        [2.8e-09, 1.73679618032, 265.9892934775],
                        [2.29e-09, 0.49529839431, 74.8297826771],
                        [2.29e-09, 4.18462288684, 74.7334144575],
                        [2.53e-09, 2.63817804331, 74.5209661364],
                        [2.52e-09, 2.04143912495, 75.0422309982],
                        [2.13e-09, 4.16218259902, 74.6215398729],
                        [2.12e-09, 0.51761494342, 74.9416572617],
                        [2.01e-09, 4.54140547837, 20.6069278195],
                        [1.94e-09, 4.17282454759, 116.4260963429],
                        [2.13e-09, 2.29528235429, 32.1951448046],
                        [1.74e-09, 3.15418942153, 228.276948965],
                        [1.94e-09, 0.06960211137, 42.5864537627],
                        [1.73e-09, 5.59700344643, 68.8437077341],
                        [1.59e-09, 4.91721631097, 143.6253063014],
                        [1.5e-09, 0.92771324396, 404.5067903482],
                        [1.36e-09, 2.51083022906, 372.4235201282],
                        [1.34e-09, 3.22507836958, 479.2883889155],
                        [1.24e-09, 0.42063711585, 149.45132255],
                        [1.22e-09, 1.20639876458, 5.4166259714],
                        [1.19e-09, 0.45375065997, 74.0308390419],
                        [1.46e-09, 5.0820733036, 294.6729761443],
                        [1.18e-09, 4.2264078889, 75.5323580927],
                        [1.18e-09, 1.50613822829, 344.7030453079],
                        [1.21e-09, 2.13544759505, 209.3669421749],
                        [1.21e-09, 6.0823907637, 260.9933586314],
                        [1.54e-09, 4.18369977366, 39.3568759152],
                      ],
          },
          {
            series => "B2",
            terms  => [
                        [9.211656e-05, 5.80044305785, 74.7815985673],
                        [5.56926e-06, 0, 0],
                        [2.86265e-06, 2.17729776353, 149.5631971346],
                        [9.4969e-07, 3.84237569809, 73.297125859],
                        [4.5419e-07, 4.87822046064, 76.2660712756],
                        [2.0107e-07, 5.46264485369, 1.4844727083],
                        [1.4793e-07, 0.87983715652, 138.5174968707],
                        [1.3963e-07, 5.07234043994, 63.7358983034],
                        [1.4261e-07, 2.84517742687, 148.0787244263],
                        [1.0122e-07, 5.00290894862, 224.3447957019],
                        [8.299e-08, 6.26655615197, 78.7137518304],
                        [4.729e-08, 5.16274174929, 71.8126531507],
                        [3.816e-08, 6.28224514574, 85.8272988312],
                        [3.488e-08, 3.53472172445, 11.0457002639],
                        [2.555e-08, 1.44444215715, 151.0476698429],
                        [2.353e-08, 4.23069776466, 3.9321532631],
                        [2.585e-08, 0.41383633246, 71.6002048296],
                        [1.394e-08, 4.13126838571, 146.594251718],
                        [1.183e-08, 3.68471361409, 77.7505439839],
                        [1.103e-08, 5.54212014132, 222.8603229936],
                        [1.205e-08, 5.05109252937, 380.12776796],
                        [1.146e-08, 1.95280464754, 529.6909650946],
                        [9.77e-09, 1.52652616357, 77.962992305],
                        [1.025e-08, 4.33698643491, 2.9689454166],
                        [8.58e-09, 2.78728745263, 111.4301614968],
                        [8.68e-09, 5.55175791193, 38.1330356378],
                        [6.33e-09, 0.41074353315, 213.299095438],
                        [5.96e-09, 5.39265533517, 127.4717966068],
                        [5.86e-09, 4.00404667232, 109.9456887885],
                        [5.43e-09, 2.40369406419, 153.4953503977],
                        [4.86e-09, 2.05237757516, 299.1263942692],
                        [5.57e-09, 3.13408880388, 65.2203710117],
                        [4.57e-09, 3.96543219832, 454.9093665273],
                        [4.81e-09, 2.81511187371, 160.6088973985],
                        [4.21e-09, 2.16819778071, 56.6223513026],
                        [3.26e-09, 4.5292001243, 39.6175083461],
                        [3.08e-09, 6.26508780547, 70.3281804424],
                        [3.38e-09, 5.14594268587, 3.1813937377],
                        [2.88e-09, 0.47061435406, 22.0914005278],
                        [3.36e-09, 4.23512034174, 35.1640902212],
                        [3.16e-09, 3.93430525759, 52.6901980395],
                        [3.06e-09, 1.10359318443, 70.8494453042],
                        [2.5e-09, 3.58780257084, 202.2533951741],
                        [2.39e-09, 4.7767930608, 87.3117715395],
                        [2.27e-09, 2.74138067839, 12.5301729722],
                        [2.63e-09, 1.59203582407, 84.3428261229],
                        [2.15e-09, 3.88195737361, 131.4039498699],
                        [2.16e-09, 5.80700510713, 74.6697239827],
                        [2.64e-09, 1.82574036051, 77.2292791221],
                        [2.22e-09, 0.0411188355, 184.7272873558],
                        [1.97e-09, 1.56602555362, 9.5612275556],
                        [1.93e-09, 2.2641693816, 75.7448064138],
                        [1.79e-09, 2.69065316892, 145.6310438715],
                        [1.7e-09, 2.75844544119, 73.8183907208],
                        [1.55e-09, 3.5539324911, 18.1592472647],
                        [1.74e-09, 4.76111441901, 277.0349937414],
                        [1.4e-09, 0.2871476287, 221.3758502853],
                        [1.34e-09, 1.29065526326, 206.1855484372],
                        [1.27e-09, 6.17908901556, 62.2514255951],
                        [1.16e-09, 6.26646620658, 220.4126424388],
                      ],
          },
          {
            series => "B3",
            terms  => [
                        [2.67832e-06, 1.25097888291, 74.7815985673],
                        [1.1048e-07, 3.14159265359, 0],
                        [6.154e-08, 4.00663614486, 149.5631971346],
                        [3.361e-08, 5.77804694935, 73.297125859],
                        [1.602e-08, 1.05657834344, 63.7358983034],
                        [1.265e-08, 1.66795295537, 78.7137518304],
                        [1.183e-08, 2.58856450374, 138.5174968707],
                        [1.087e-08, 0.28687213135, 76.2660712756],
                        [6.4e-09, 1.87238784591, 71.6002048296],
                        [5.9e-09, 0.80206040001, 1.4844727083],
                        [4.67e-09, 4.42872012006, 148.0787244263],
                        [2.72e-09, 4.00684090176, 85.8272988312],
                        [2.03e-09, 0.60406901282, 71.8126531507],
                        [1.8e-09, 5.55657564049, 3.9321532631],
                        [1.68e-09, 4.67745630044, 70.8494453042],
                        [1.7e-09, 2.93672195979, 11.0457002639],
                      ],
          },
          {
            series => "B4",
            terms  => [
                        [5.719e-08, 2.85499529315, 74.7815985673],
                        [3e-09, 3.14159265359, 0],
                      ],
          },
        ],
        [
          {
            series => "R0",
            terms  => [
                        [19.21264847881, 0, 0],
                        [0.88784984055, 5.60377526994, 74.7815985673],
                        [0.03440835545, 0.32836098991, 73.297125859],
                        [0.02055653495, 1.78295170028, 149.5631971346],
                        [0.00649321851, 4.52247298119, 76.2660712756],
                        [0.00602248144, 3.86003820462, 63.7358983034],
                        [0.00496404171, 1.40139934716, 454.9093665273],
                        [0.00338525522, 1.58002682946, 138.5174968707],
                        [0.00243508222, 1.57086595074, 71.8126531507],
                        [0.00190521915, 1.99809364502, 1.4844727083],
                        [0.00161858251, 2.79137863469, 148.0787244263],
                        [0.00143705902, 1.38368574483, 11.0457002639],
                        [0.00093192359, 0.17437193645, 36.6485629295],
                        [0.00071424265, 4.24509327405, 224.3447957019],
                        [0.00089805842, 3.66105366329, 109.9456887885],
                        [0.00039009624, 1.66971128869, 70.8494453042],
                        [0.00046677322, 1.39976563936, 35.1640902212],
                        [0.00039025681, 3.36234710692, 277.0349937414],
                        [0.0003675516, 3.88648934736, 146.594251718],
                        [0.00030348875, 0.70100446346, 151.0476698429],
                        [0.00029156264, 3.18056174556, 77.7505439839],
                        [0.00020471584, 1.555889615, 202.2533951741],
                        [0.0002562036, 5.25656292802, 380.12776796],
                        [0.00025785805, 3.78537741503, 85.8272988312],
                        [0.00022637152, 0.72519137745, 529.6909650946],
                        [0.00020473163, 2.79639811626, 70.3281804424],
                        [0.00017900561, 0.55455488605, 2.9689454166],
                        [0.00012328151, 5.96039150918, 127.4717966068],
                        [0.00014701566, 4.90434406648, 108.4612160802],
                        [0.00011494701, 0.43774027872, 65.2203710117],
                        [0.00015502809, 5.35405037603, 38.1330356378],
                        [0.00010792699, 1.42104858472, 213.299095438],
                        [0.00011696085, 3.29825599114, 3.9321532631],
                        [0.00011959355, 1.75044072173, 984.6003316219],
                        [0.00012896507, 2.62154018241, 111.4301614968],
                        [0.00011852996, 0.99342814582, 52.6901980395],
                        [9.111446e-05, 4.99638600045, 62.2514255951],
                        [8.42055e-05, 5.25350716616, 222.8603229936],
                        [7.449125e-05, 0.79491905956, 351.8165923087],
                        [8.402147e-05, 5.03877516489, 415.5524906121],
                        [6.04637e-05, 5.67960948357, 78.7137518304],
                        [5.524133e-05, 3.11499484161, 9.5612275556],
                        [7.329454e-05, 3.9727752784, 183.2428146475],
                        [5.444878e-05, 5.10575635361, 145.1097790097],
                        [5.238103e-05, 2.62960141797, 33.6796175129],
                        [4.079167e-05, 3.22064788674, 340.7708920448],
                        [3.801606e-05, 6.10985558505, 184.7272873558],
                        [3.919476e-05, 4.25015288873, 39.6175083461],
                        [2.940492e-05, 2.14637460319, 137.0330241624],
                        [3.781219e-05, 3.45840272873, 456.3938392356],
                        [2.942239e-05, 0.42393808854, 299.1263942692],
                        [3.686787e-05, 2.48718116535, 453.424893819],
                        [3.101743e-05, 4.14031063896, 219.891377577],
                        [2.962641e-05, 0.82977991995, 56.6223513026],
                        [2.937799e-05, 3.6765745093, 140.001969579],
                        [2.865128e-05, 0.30996903761, 12.5301729722],
                        [2.538032e-05, 4.85457831993, 131.4039498699],
                        [1.96251e-05, 5.24342224065, 84.3428261229],
                        [2.36355e-05, 0.44253328372, 554.0699874828],
                        [1.979394e-05, 6.12836181686, 106.9767433719],
                        [2.182572e-05, 2.94040431638, 305.3461693927],
                        [1.962974e-05, 0.0411473912, 221.3758502853],
                        [1.82956e-05, 4.01105771632, 68.8437077341],
                        [1.64292e-05, 0.35564102554, 67.6680515665],
                        [1.58485e-05, 3.16267171762, 225.8292684102],
                        [1.848655e-05, 2.91111759376, 909.8187330546],
                        [1.63243e-05, 4.23061792837, 22.0914005278],
                        [1.40139e-05, 1.39084023521, 265.9892934775],
                        [1.403717e-05, 5.63563637532, 4.4534181249],
                        [1.655866e-05, 1.96431297431, 79.2350166922],
                        [1.248978e-05, 5.44027380866, 54.1746707478],
                        [1.563447e-05, 1.47917835549, 112.9146342051],
                        [1.248054e-05, 4.88984353601, 479.2883889155],
                        [1.197439e-05, 2.52185744943, 145.6310438715],
                        [1.506952e-05, 5.24186185583, 181.7583419392],
                        [1.481746e-05, 5.66203046912, 152.5321425512],
                        [1.438838e-05, 1.53046287618, 447.7958195265],
                        [1.408514e-05, 4.41921749601, 462.0229135281],
                        [1.477112e-05, 4.32214690647, 256.5399405065],
                        [1.228314e-05, 5.9770333104, 59.8037450403],
                        [1.249958e-05, 6.24484546141, 160.6088973985],
                        [9.06468e-06, 5.62025869483, 74.6697239827],
                        [1.090681e-05, 4.15393813845, 77.962992305],
                        [8.44931e-06, 0.12943398585, 82.8583534146],
                        [9.00363e-06, 2.37315925843, 74.8934731519],
                        [1.071957e-05, 1.74286714339, 528.2064923863],
                        [6.89708e-06, 3.08097059985, 69.3649725959],
                        [5.93798e-06, 4.50074517056, 8.0767548473],
                        [7.18559e-06, 4.00047509264, 128.9562693151],
                        [6.99574e-06, 0.03987168068, 143.6253063014],
                        [5.75656e-06, 5.89552672641, 66.70484372],
                        [7.59004e-06, 2.13700057433, 692.5874843535],
                        [7.10449e-06, 5.41605755095, 218.4069048687],
                        [5.48672e-06, 5.6281149697, 3.1813937377],
                        [6.51632e-06, 4.42340061551, 18.1592472647],
                        [5.39825e-06, 6.20788667166, 71.6002048296],
                        [5.44539e-06, 5.69375108253, 203.7378678824],
                        [7.10276e-06, 4.21967260022, 381.6122406683],
                        [5.93819e-06, 3.83805798523, 32.1951448046],
                        [7.10134e-06, 4.48972171999, 293.188503436],
                        [7.05482e-06, 0.45521177725, 835.0371344873],
                        [5.88e-06, 5.08252923316, 186.2117600641],
                        [5.98231e-06, 0.35815291076, 269.9214467406],
                        [6.41914e-06, 2.71127457036, 87.3117715395],
                        [4.95621e-06, 2.65094755989, 200.7689224658],
                        [6.30252e-06, 4.46146214548, 275.5505210331],
                        [5.75195e-06, 5.57862480486, 2.4476805548],
                        [5.6987e-06, 1.6393093274, 77.2292791221],
                        [5.56672e-06, 1.07231961344, 1059.3819301892],
                        [4.49439e-06, 0.27981733949, 617.8058857862],
                        [4.63608e-06, 1.43448297993, 297.6419215609],
                        [4.36547e-06, 0.52802035072, 209.3669421749],
                        [4.63938e-06, 2.35443114417, 211.8146227297],
                        [4.35943e-06, 2.10077211065, 1514.2912967165],
                        [5.15534e-06, 3.23274579379, 284.1485407422],
                        [4.54879e-06, 4.08364210459, 99.1606209555],
                        [4.7743e-06, 2.89397217998, 39.3568759152],
                        [5.42331e-06, 5.39481705077, 278.5194664497],
                        [4.10087e-06, 3.04968860441, 404.5067903482],
                        [3.67848e-06, 0.71159607058, 125.9873238985],
                        [5.03096e-06, 5.83931251717, 191.2076949102],
                        [4.87532e-06, 0.06402454583, 60.7669528868],
                        [4.55043e-06, 2.59321186669, 490.3340891794],
                        [4.36291e-06, 2.08183813746, 51.2057253312],
                        [4.35803e-06, 2.79445203085, 75.7448064138],
                        [3.23546e-06, 4.82899980859, 195.1398481733],
                        [3.59363e-06, 0.00868012078, 35.4247226521],
                        [4.29314e-06, 3.08031550488, 41.1019810544],
                        [3.20021e-06, 5.48625497747, 14.977853527],
                        [4.14331e-06, 0.09012800478, 258.0244132148],
                        [3.79715e-06, 0.05832815311, 378.6432952517],
                        [4.20062e-06, 2.25393983318, 81.0013736908],
                        [3.57721e-06, 4.71414305625, 173.9422195228],
                        [3.58922e-06, 0.35213227553, 426.598190876],
                        [4.0541e-06, 6.12263257999, 24.3790223882],
                        [3.65158e-06, 5.59483211224, 255.0554677982],
                        [3.08102e-06, 3.92355394354, 116.4260963429],
                        [3.2566e-06, 4.71996698332, 134.5853436076],
                        [2.92781e-06, 3.9952119483, 72.3339180125],
                        [3.86543e-06, 0.68619006966, 230.5645708254],
                        [3.05686e-06, 3.76108783519, 344.7030453079],
                        [2.86972e-06, 1.8499033531, 153.4953503977],
                        [3.5364e-06, 4.65717995107, 329.8370663655],
                        [3.02051e-06, 0.13190003806, 565.1156877467],
                        [2.41128e-06, 1.60454142389, 81.3738807063],
                        [2.49829e-06, 4.24205256241, 75.3028634291],
                        [2.45063e-06, 5.94905404273, 20.6069278195],
                        [2.48277e-06, 1.06282887181, 105.4922706636],
                        [3.05353e-06, 2.55534744586, 6208.2942514241],
                        [2.96328e-06, 4.21100245276, 1364.7280995819],
                        [2.19938e-06, 2.96119055727, 120.358249606],
                        [2.33564e-06, 2.97074409938, 46.2097904851],
                        [2.62422e-06, 3.83652250971, 831.1049812242],
                        [2.33546e-06, 4.4811700614, 628.8515860501],
                        [1.87432e-06, 3.03529190348, 135.5485514541],
                        [2.16776e-06, 3.42907414802, 241.6102710893],
                        [2.5576e-06, 1.1670789346, 177.8743727859],
                        [2.20458e-06, 0.1963349229, 180.2738692309],
                        [2.24519e-06, 0.40677777819, 114.3991069134],
                        [2.05398e-06, 2.30380942634, 259.5088859231],
                        [2.11106e-06, 4.93079982424, 103.0927742186],
                        [1.75758e-06, 5.50822822216, 7.1135470008],
                        [1.88512e-06, 2.23588941288, 5.4166259714],
                        [1.71718e-06, 5.21730232334, 41.6444977756],
                        [1.76136e-06, 1.95958319897, 756.3233826569],
                        [1.70447e-06, 4.94978757413, 206.1855484372],
                        [1.69454e-06, 4.04319823722, 55.6591434561],
                        [2.19015e-06, 0.24790282027, 294.6729761443],
                        [1.87768e-06, 2.04538775456, 408.4389436113],
                        [1.82258e-06, 0.70728384467, 391.1734682239],
                        [1.92095e-06, 5.76718231319, 291.7040307277],
                        [1.53684e-06, 4.70659406659, 543.0242872189],
                        [1.70043e-06, 4.50995820508, 288.0806940053],
                        [1.64097e-06, 5.22527540372, 67.3592350258],
                        [1.94341e-06, 6.1169036471, 414.0680179038],
                        [1.68027e-06, 5.25810639105, 518.6452648307],
                        [1.56641e-06, 0.66304836778, 220.4126424388],
                        [1.8233e-06, 0.78383856974, 417.0369633204],
                        [1.67462e-06, 4.92241597775, 422.6660376129],
                        [1.7077e-06, 2.30927162659, 98.8999885246],
                        [1.61678e-06, 3.27259601116, 443.8636662634],
                        [1.32763e-06, 2.88875442023, 373.9079928365],
                        [1.6114e-06, 3.82341391177, 451.9404211107],
                        [1.79292e-06, 4.82405681293, 366.485629295],
                        [1.78153e-06, 3.98026039043, 10138.5039476437],
                        [1.41929e-06, 1.26972581554, 159.1244246902],
                        [1.5375e-06, 4.27847681414, 45.5766510387],
                        [1.61513e-06, 4.99545008738, 73.8183907208],
                        [1.46315e-06, 2.65664902119, 465.9550667912],
                        [1.24875e-06, 4.30470898895, 339.2864193365],
                        [1.5462e-06, 4.3204622812, 760.25553592],
                        [1.42894e-06, 2.07773752143, 457.8783119439],
                        [1.52408e-06, 4.64742446768, 155.7829722581],
                        [1.16389e-06, 4.43513730944, 5.9378908332],
                        [1.13444e-06, 4.65351596266, 80.1982245387],
                        [1.07611e-06, 3.77290419929, 142.4496501338],
                        [1.3374e-06, 5.30894739047, 14.0146456805],
                        [1.16104e-06, 2.5118272567, 296.1574488526],
                        [1.29106e-06, 0.36277717661, 96.8729990951],
                        [1.22766e-06, 2.38341351026, 141.4864422873],
                        [1.01368e-06, 1.05739625315, 92.3077063856],
                        [1.14669e-06, 6.24863527978, 767.3690829208],
                        [1.13283e-06, 0.83051319425, 100.3844612329],
                        [1.07199e-06, 2.39365512354, 347.8844390456],
                        [9.5443e-07, 0.80094579583, 342.2553647531],
                        [1.10789e-06, 0.38651051525, 216.9224321604],
                        [1.26978e-06, 0.4235935825, 331.3215390738],
                        [1.12635e-06, 0.08107814739, 558.0021407459],
                        [1.03166e-06, 0.69792283389, 358.9301393095],
                        [1.11474e-06, 0.75023459027, 80.7194894005],
                        [9.0902e-07, 5.16530481614, 144.1465711632],
                        [9.0677e-07, 0.22036476597, 333.657345044],
                        [9.8568e-07, 4.33164222339, 74.5209661364],
                        [8.9306e-07, 2.18851161761, 74.8297826771],
                        [1.17216e-06, 3.94965784596, 74.2603337055],
                        [8.9088e-07, 5.87783179087, 74.7334144575],
                        [9.7316e-07, 0.6942969502, 977.4867846211],
                        [1.16587e-06, 1.83677031994, 1289.9465010146],
                        [8.5449e-07, 5.80255966149, 6.592282139],
                        [8.6823e-07, 5.61973473261, 300.6108669775],
                        [1.05226e-06, 5.94513614941, 328.3525936572],
                        [1.12117e-06, 1.21168089807, 329.7251917809],
                        [8.2982e-07, 2.20797412496, 74.9416572617],
                        [9.4345e-07, 4.53937998713, 28.5718080822],
                        [1.06847e-06, 1.82071328579, 306.830642101],
                        [1.03572e-06, 2.99368274596, 6.2197751235],
                        [1.06357e-06, 0.8158387475, 1087.6931058405],
                        [7.7728e-07, 2.73390123734, 110.2063212194],
                        [9.8405e-07, 3.73478182667, 75.0422309982],
                        [8.6231e-07, 2.83316881064, 983.1158589136],
                        [8.9023e-07, 4.7375445896, 604.4725636619],
                        [8.3013e-07, 1.88273535999, 387.2413149608],
                        [9.0227e-07, 3.80367274711, 986.0848043302],
                        [8.4598e-07, 1.25774132938, 142.1408335931],
                        [7.469e-07, 1.35097482767, 350.3321196004],
                        [9.577e-07, 5.54845504768, 969.6224780949],
                        [9.0277e-07, 0.36773710508, 0.9632078465],
                        [8.2748e-07, 5.85590525764, 74.6215398729],
                        [7.5828e-07, 2.78019216029, 88.1149206916],
                        [8.385e-07, 1.84386358668, 227.3137411185],
                        [7.0705e-07, 4.65567024014, 44.7253177768],
                        [7.1322e-07, 3.64963906751, 894.8408795276],
                        [9.4141e-07, 4.98819201726, 403.1341922245],
                        [8.8966e-07, 4.43895583278, 154.0166152595],
                        [7.9436e-07, 5.66662613679, 267.4737661858],
                        [7.5615e-07, 5.40971072536, 50.4025761791],
                        [6.8583e-07, 4.76679841388, 991.7138786227],
                        [6.5256e-07, 0.69286370395, 152.7445908723],
                        [6.3031e-07, 2.89946567712, 79.889407998],
                        [6.3878e-07, 0.09820555288, 681.5417840896],
                        [8.0101e-07, 2.97520561915, 526.722019678],
                        [6.9693e-07, 3.95281159807, 187.6962327724],
                        [5.9492e-07, 3.59642351692, 58.1068240109],
                        [5.9273e-07, 0.50930692071, 28.3111756513],
                        [6.859e-07, 2.4188031153, 235.3904959658],
                        [6.6007e-07, 5.04558399435, 30.7106720963],
                        [7.0223e-07, 3.73647415486, 546.956440482],
                        [6.6836e-07, 0.85506033017, 522.5774180938],
                        [6.3027e-07, 0.29269109052, 119.5069163441],
                        [6.2023e-07, 2.31557510311, 74.0308390419],
                        [7.1379e-07, 3.16967571102, 23.5758732361],
                        [7.4827e-07, 5.36812537961, 373.0142209592],
                        [6.4204e-07, 2.3681714946, 157.6399519819],
                        [7.0712e-07, 0.55830476304, 92.940845832],
                        [5.5762e-07, 5.27011035858, 874.3940104025],
                        [7.5638e-07, 4.66344127677, 101.8689339412],
                        [7.3727e-07, 6.20581665991, 312.4597163935],
                        [7.294e-07, 0.58406607757, 367.9701020033],
                        [5.323e-07, 2.24728742995, 17.5261078183],
                        [6.3139e-07, 4.59563922296, 67.8804998876],
                        [6.055e-07, 0.57591315857, 253.5709950899],
                        [5.2946e-07, 2.45947017614, 264.5048207692],
                        [7.0236e-07, 1.51860943454, 552.5855147745],
                        [6.8624e-07, 2.44507780453, 555.5544601911],
                        [6.2796e-07, 0.33786296181, 561.1835344836],
                        [4.9009e-07, 1.09233728279, 19.1224551112],
                        [6.4636e-07, 5.274699709, 68.1893164283],
                        [6.2957e-07, 5.35891188483, 92.0470739547],
                        [4.7664e-07, 3.90924952181, 192.6921676185],
                        [6.5279e-07, 4.23629510074, 771.3012361839],
                        [6.519e-07, 3.73942854797, 536.8045120954],
                        [5.9452e-07, 6.10554259948, 365.0011565867],
                        [5.2153e-07, 1.71734604937, 905.8865797915],
                        [4.6035e-07, 3.87093684776, 210.3301500214],
                        [4.6429e-07, 5.97423131576, 477.8039162072],
                        [6.2115e-07, 2.67544358037, 130.4407420234],
                        [4.6038e-07, 3.89378239085, 48.7580447764],
                        [4.2663e-07, 3.81519760715, 61.2882177486],
                        [5.3909e-07, 2.86457147106, 353.301065017],
                        [4.6936e-07, 1.00011046774, 166.828672522],
                        [4.2217e-07, 2.61748790314, 90.8232336773],
                        [4.3324e-07, 4.15777895713, 173.6815870919],
                        [4.1296e-07, 1.79930408254, 149.45132255],
                        [4.496e-07, 1.76623306927, 0.5212648618],
                        [5.1904e-07, 2.97773319756, 383.0967133766],
                        [4.2931e-07, 1.57416456203, 120.9913890524],
                        [4.9611e-07, 4.0342792047, 303.8616966844],
                        [4.5263e-07, 3.58382163089, 97.4155158163],
                        [3.8695e-07, 2.39404211169, 31.492569389],
                        [3.8072e-07, 5.7947367035, 75.5323580927],
                        [5.0126e-07, 4.76412907201, 911.3032057629],
                        [5.0884e-07, 5.15513957132, 439.782755154],
                        [4.3148e-07, 0.84999004804, 58.319272332],
                        [4.2732e-07, 5.17318058934, 162.0933701068],
                        [5.0298e-07, 5.81603435915, 66.9172920411],
                        [3.5639e-07, 1.87447823723, 472.1748419147],
                        [4.9963e-07, 1.8894349079, 42.5864537627],
                        [3.9974e-07, 1.74262050679, 89.7594520943],
                        [4.5252e-07, 1.92511912328, 55.1378785943],
                        [4.4896e-07, 1.4835590189, 450.9772132642],
                        [3.4297e-07, 5.20257496546, 316.3918696566],
                        [4.6355e-07, 0.33942039181, 273.1028404783],
                        [3.7152e-07, 2.03757941865, 117.9105690512],
                        [4.6106e-07, 5.62315633955, 1819.6374661092],
                        [3.9368e-07, 4.19402806344, 486.4019359163],
                        [4.1039e-07, 4.82994471947, 149.6750717192],
                        [4.4959e-07, 0.72694662195, 3265.8308281325],
                        [4.3617e-07, 0.75332422672, 404.6186649328],
                        [3.1823e-07, 3.84768075667, 20.4468691251],
                        [4.4196e-07, 4.36769721266, 418.2608035978],
                        [3.79e-07, 3.02928044053, 167.0893049529],
                        [4.3684e-07, 1.57328182739, 491.5579294568],
                        [3.4004e-07, 1.26257052908, 260.9933586314],
                        [3.1276e-07, 4.16123711648, 13.3333221243],
                        [3.9984e-07, 2.8662612562, 468.2426886516],
                        [3.649e-07, 2.58804294589, 68.5618234438],
                        [3.2364e-07, 3.11577354875, 103.3534066495],
                        [3.3857e-07, 0.15592410716, 24.1183899573],
                        [3.5933e-07, 1.36784550071, 59.2824801785],
                        [3.3633e-07, 0.755011774, 290.2195580194],
                        [2.9751e-07, 5.33178627038, 1033.3583763983],
                        [3.2036e-07, 4.67549858, 205.2223405907],
                        [3.0991e-07, 4.62823866461, 258.8757464767],
                        [3.5268e-07, 1.00718464327, 1108.1399749656],
                        [3.3366e-07, 3.40738625377, 43.1289704839],
                        [3.2638e-07, 5.25485850258, 114.1384744825],
                        [2.9825e-07, 5.64157476876, 254.9435932136],
                        [3.1613e-07, 3.7823139311, 152.0108776894],
                        [3.098e-07, 2.26660677937, 104.0077979553],
                        [3.4591e-07, 5.17326577255, 25.6028626656],
                        [2.8398e-07, 1.76872790446, 820.0592809603],
                        [2.7991e-07, 3.92486885309, 199.2844497575],
                        [2.8986e-07, 2.58171811759, 76.4785195967],
                        [3.3772e-07, 5.79359878723, 274.0660483248],
                        [2.9401e-07, 5.93638676504, 280.9671470045],
                        [3.1094e-07, 1.39352495971, 178.7893965226],
                        [3.0118e-07, 0.44367887423, 27.0873353739],
                        [3.382e-07, 6.26168443513, 401.6497195162],
                        [2.7513e-07, 2.15194454461, 480.7728616238],
                        [2.688e-07, 2.5130027278, 123.5396433437],
                        [2.6139e-07, 0.21985367371, 286.596221297],
                        [2.6455e-07, 3.88229792258, 372.4235201282],
                        [3.3974e-07, 1.44637843871, 88.7962442478],
                        [3.0107e-07, 0.82723915882, 100.6450936638],
                        [2.7715e-07, 4.64827434185, 198.321241911],
                        [3.3687e-07, 1.14348201049, 82.4858463991],
                        [2.6493e-07, 1.97889544238, 95.3885263868],
                        [2.4355e-07, 2.3783917615, 146.3818033969],
                        [2.659e-07, 0.39881920389, 106.0135355254],
                        [2.7006e-07, 2.10206230691, 1057.8974574809],
                        [2.3976e-07, 6.21233637686, 16.6747745564],
                        [3.097e-07, 5.34005431547, 476.4313180835],
                        [2.4073e-07, 3.42953641968, 1044.4040766622],
                        [2.7023e-07, 0.71284764471, 248.7238180901],
                        [2.9098e-07, 3.99184722502, 908.3342603463],
                        [2.2862e-07, 2.26978781393, 175.1660598002],
                        [2.4026e-07, 0.36584131268, 73.1852512744],
                        [2.8024e-07, 3.46485782266, 1439.5096981492],
                        [2.2034e-07, 0.051638073, 33.1371007917],
                        [2.2185e-07, 5.32252126255, 483.2205421786],
                        [2.1027e-07, 0.37224660652, 214.7835681463],
                        [2.0548e-07, 1.80004483299, 118.0224436358],
                        [2.7835e-07, 4.1241255353, 694.0719570618],
                        [2.55e-07, 5.49632191634, 115.8835796217],
                        [2.1377e-07, 3.89179204956, 66.1835788582],
                        [2.7201e-07, 5.761487979, 1215.1649024473],
                        [2.4984e-07, 0.65339418015, 132.8884225782],
                        [2.3976e-07, 4.56161326826, 458.8415197904],
                        [2.1116e-07, 1.1361070625, 60.5545045657],
                        [2.6263e-07, 2.77532723118, 490.0734567485],
                        [2.6369e-07, 3.371200393, 49.7212526229],
                        [2.287e-07, 4.5313563762, 78.4049352897],
                        [2.6872e-07, 3.26037129303, 691.1030116452],
                        [2.5004e-07, 3.65018677651, 73.4090004436],
                        [2.0874e-07, 3.92589972978, 134.0640787458],
                        [2.0915e-07, 5.53955400138, 129.9194771616],
                        [2.3067e-07, 2.56806856688, 332.8060117821],
                        [2.263e-07, 5.02721554401, 150.5264049811],
                        [1.9123e-07, 1.92386327535, 124.5028511902],
                        [2.0678e-07, 0.98302410602, 29.2049475286],
                        [1.8755e-07, 1.07911898422, 70.1157321213],
                        [1.9458e-07, 1.33847349577, 616.3214130779],
                        [2.3071e-07, 3.93152899657, 43.2890291783],
                        [2.3313e-07, 0.61185525008, 189.7232222019],
                        [1.966e-07, 1.40884902649, 1589.0728952838],
                        [2.499e-07, 0.91842956919, 441.2672278623],
                        [2.3555e-07, 0.02127675886, 593.426863398],
                        [1.8288e-07, 4.55111843462, 165.6048322446],
                        [2.098e-07, 0.88504201898, 326.8681209489],
                        [2.494e-07, 4.63470443286, 162.8965192589],
                        [1.8941e-07, 5.10763304564, 81.8951455681],
                        [1.8911e-07, 1.23351635328, 13.4933808187],
                        [1.7358e-07, 4.05768226252, 403.0223176399],
                        [1.7362e-07, 5.2860722764, 7.8643065262],
                        [2.2513e-07, 3.15059891398, 419.7452763061],
                        [2.1237e-07, 2.14856256664, 75.5847477194],
                        [1.7845e-07, 2.54349200329, 47.061123747],
                        [1.6995e-07, 2.48647736969, 2043.9822618111],
                        [2.3676e-07, 5.80355919955, 232.0490435337],
                        [2.2639e-07, 2.07623129509, 699.7010313543],
                        [1.9261e-07, 1.56494156016, 425.1137181677],
                        [2.1067e-07, 5.30844438236, 237.6781178262],
                        [2.2733e-07, 0.2830312644, 0.1118745846],
                        [1.6372e-07, 3.45984005656, 0.7507595254],
                        [2.1213e-07, 0.95828006612, 405.9912630565],
                        [1.8033e-07, 1.60723214246, 215.4379594521],
                        [1.6267e-07, 4.8900201636, 69.1525242748],
                        [2.1738e-07, 3.24738839789, 1744.8558675419],
                        [1.6149e-07, 0.35803995032, 77.0692204277],
                        [2.171e-07, 0.88800040769, 344.9636777388],
                        [1.7204e-07, 6.04366142241, 32.2433289144],
                        [1.7883e-07, 4.01076173641, 280.003939158],
                        [1.5918e-07, 2.96623390816, 25.8634950965],
                        [1.4769e-07, 3.73887340623, 610.6923387854],
                        [1.5033e-07, 4.24825484707, 228.276948965],
                        [1.5586e-07, 5.0798708274, 114.9416236346],
                        [1.5392e-07, 0.22971106129, 17.2654753874],
                        [1.5354e-07, 0.25482391126, 661.0949149645],
                        [1.4617e-07, 1.13349626273, 823.9914342234],
                        [1.6232e-07, 3.4349974381, 147.1155165798],
                        [1.4654e-07, 1.68288566884, 207.8824694666],
                        [1.7682e-07, 5.94376629143, 624.919432787],
                        [1.8837e-07, 1.3833540807, 377.1588225434],
                        [1.5425e-07, 1.66489033237, 440.6822725257],
                        [1.4764e-07, 4.41710614445, 16.4623262353],
                        [1.4402e-07, 0.41359448817, 142.6620984549],
                        [1.6992e-07, 0.16042368544, 438.2982824457],
                        [1.3268e-07, 3.04634728126, 668.2084619653],
                        [1.646e-07, 0.92068542861, 369.0820676961],
                        [1.7239e-07, 4.51659246818, 606.7601855223],
                        [1.3238e-07, 0.13650358961, 216.4804891757],
                        [1.5832e-07, 4.94315562971, 124.2904028691],
                        [1.4374e-07, 2.93700606008, 419.4846438752],
                        [1.2927e-07, 1.65950183061, 54.3347294422],
                        [1.4224e-07, 4.42286781619, 47.6942631934],
                        [1.2753e-07, 0.03020931725, 217.2312487011],
                        [1.4792e-07, 1.08447500622, 49.5088043018],
                        [1.4031e-07, 3.68785757687, 16.04163511],
                        [1.3709e-07, 4.78890618802, 72.7758609972],
                        [1.3073e-07, 1.54064778942, 218.9281697305],
                        [1.7474e-07, 5.05621281434, 564.8550553158],
                        [1.2686e-07, 3.4464088888, 958.576777831],
                        [1.3035e-07, 0.56445754615, 1171.875873269],
                        [1.2458e-07, 3.29187197133, 902.7051860538],
                        [1.1893e-07, 1.41294011193, 55.7710180407],
                        [1.5018e-07, 3.43209569509, 19.0105805266],
                        [1.647e-07, 2.04067754807, 411.620337349],
                        [1.5619e-07, 1.53464600544, 833.552661779],
                        [1.5678e-07, 5.92839374034, 778.4147831847],
                        [1.2039e-07, 5.17748353434, 135.336103133],
                        [1.5523e-07, 3.54656631824, 113.8778420516],
                        [1.4364e-07, 4.19825110964, 89.338760969],
                        [1.5424e-07, 2.12697366269, 106.2741679563],
                        [1.1957e-07, 1.43314130608, 455.8725743738],
                        [1.5938e-07, 5.49575810978, 513.079881013],
                        [1.3532e-07, 4.11463529983, 95.2284676924],
                        [1.5105e-07, 1.86350524526, 7.7042478318],
                        [1.5832e-07, 3.42498484109, 79.5169009825],
                        [1.1492e-07, 4.6518745562, 149.6113812444],
                        [1.1406e-07, 1.31085455047, 63.6240237188],
                        [1.4469e-07, 3.35284802718, 19.643719973],
                        [1.1953e-07, 0.20979051344, 65.8747623175],
                        [1.2039e-07, 0.0142323841, 397.3932433474],
                        [1.4157e-07, 1.87440535404, 6283.0758499914],
                        [1.1357e-07, 0.19079103112, 5.6290742925],
                        [1.4109e-07, 0.09348109701, 6133.5126528568],
                        [1.5322e-07, 3.54468546172, 252.6559713532],
                        [1.1681e-07, 0.85100356112, 5.1078094307],
                        [1.4134e-07, 5.66340426198, 639.897286314],
                        [1.1052e-07, 0.47607339302, 150.0844619964],
                        [1.1507e-07, 5.19480309409, 1182.9215735329],
                        [1.1492e-07, 2.05801478181, 149.5150130248],
                        [1.1571e-07, 4.7821072497, 334.2904844904],
                        [1.0671e-07, 4.67373109923, 149.723255829],
                        [1.1651e-07, 3.13272450186, 93.9040536785],
                        [1.4316e-07, 0.08421279341, 240.3864308119],
                        [1.0855e-07, 4.52379396618, 453.9461586808],
                        [1.19e-07, 1.41784572428, 26.0235537909],
                        [1.0851e-07, 4.40625021974, 57.1436161644],
                        [1.3385e-07, 0.76174742916, 37.8724032069],
                        [1.0664e-07, 5.81644528276, 193.655375465],
                        [1.07e-07, 5.3459550607, 331.2096644892],
                        [1.0465e-07, 3.82648204886, 180.1619946463],
                        [1.335e-07, 0.86920479636, 22.8945496799],
                        [1.0324e-07, 2.99969783109, 525.7588118315],
                        [1.4293e-07, 1.06904465002, 477.9157907918],
                        [1.2341e-07, 4.62813430535, 1894.4190646765],
                        [1.2539e-07, 3.70404881494, 67.0773507355],
                        [1.1771e-07, 1.07971321862, 363.5166838784],
                        [1.1466e-07, 0.9352838604, 121.8427223143],
                        [1.2839e-07, 0.31988787839, 474.9468453752],
                        [1.0194e-07, 6.23976471898, 84.1827674285],
                        [1.23e-07, 2.85238700423, 184.0941479094],
                        [1.3861e-07, 3.4836768877, 157.2674449664],
                        [1.1395e-07, 4.2553344068, 181.0557665236],
                        [1.0146e-07, 6.01371693363, 43.2408450685],
                        [9.889e-08, 0.01753733887, 40.1600250673],
                        [1.0798e-07, 2.4636424394, 140.6563608848],
                        [9.893e-08, 2.72219544398, 384.0599212231],
                        [1.1012e-07, 3.77284307154, 494.2662424425],
                        [1.0226e-07, 1.49169427598, 80.4106728598],
                        [1.1981e-07, 2.69741212203, 369.4545747116],
                        [1.0658e-07, 1.7870288097, 252.0865223816],
                        [1.2506e-07, 4.66852994807, 64.6991061499],
                        [1.164e-07, 5.70405852396, 39.0962434843],
                        [1.2305e-07, 1.73322306013, 229.0800981171],
                        [9.954e-08, 3.72074935511, 233.9060232575],
                        [1.1004e-07, 3.58723041577, 449.2802922348],
                        [1.0581e-07, 2.79550711884, 1246.6574718363],
                        [1.0411e-07, 2.8672714553, 189.1807054807],
                        [9.259e-08, 5.1983482312, 749.2098356561],
                        [1.2468e-07, 0.76477162698, 122.4758617607],
                        [1.0099e-07, 6.06894682979, 156.1554792736],
                        [1.2671e-07, 6.19797171716, 149.8238295655],
                        [9.053e-08, 0.99447742265, 109.3125493421],
                        [9.595e-08, 1.00827882958, 393.4610900843],
                        [1.0455e-07, 1.23531019351, 148.5999892881],
                        [1.0645e-07, 5.50399216121, 460.5384408198],
                        [1.2433e-07, 5.298436616, 20.4950532349],
                        [9.002e-08, 5.5121689284, 133.1008708993],
                        [9.882e-08, 5.68987366321, 42.5382696529],
                        [1.211e-07, 3.14577799081, 30.0562807905],
                        [1.038e-07, 3.54528360301, 619.2903584945],
                        [1.0139e-07, 1.90528799801, 25.0603459444],
                        [1.1206e-07, 5.8782323899, 832.5894539325],
                        [9.283e-08, 3.00514787072, 754.8389099486],
                        [1.0994e-07, 0.05721003392, 54.2865453324],
                        [8.981e-08, 5.82462023723, 248.4631856592],
                        [8.634e-08, 5.49123270314, 448.6895914038],
                        [9.39e-08, 1.32674472283, 9.4011688612],
                        [9.621e-08, 5.6909029939, 73.88782669],
                        [1.0843e-07, 1.4281264822, 268.4369740323],
                        [1.0874e-07, 2.6136174199, 446.3113468182],
                        [9.681e-08, 4.27051176079, 282.6640680339],
                        [1.077e-07, 0.19304986906, 463.5073862364],
                        [8.223e-08, 3.30114329151, 172.1971143836],
                        [1.0216e-07, 5.04428111805, 241.8709035202],
                        [8.89e-08, 2.53320903906, 271.4059194489],
                        [1.0621e-07, 4.39013117792, 63.847772888],
                        [9.085e-08, 0.99085954236, 6.9010986797],
                        [1.0414e-07, 4.96367476854, 97.6761482472],
                        [8.382e-08, 5.03764591595, 370.9390474199],
                        [8.791e-08, 3.05426995163, 291.262087743],
                        [8.629e-08, 0.1467493805, 262.4778313397],
                        [9.673e-08, 4.2559733057, 602.9880909536],
                        [7.939e-08, 5.71230451368, 541.5398145106],
                        [7.981e-08, 2.35900017752, 196.6243208816],
                        [7.941e-08, 0.88239951788, 154.979823106],
                        [8.212e-08, 0.00845991197, 76.42612997],
                        [1.0135e-07, 1.90258069764, 91.4563731237],
                        [8.948e-08, 4.31891786278, 469.1364605289],
                        [9.906e-08, 0.61122653279, 308.3151148093],
                        [8.257e-08, 4.61012292958, 69.6737891366],
                        [1.0291e-07, 3.58217488981, 842.1506814881],
                        [1.0672e-07, 2.28920805112, 194.2885149114],
                        [9.024e-08, 0.70282370018, 685.4739373527],
                        [7.552e-08, 4.86800510978, 1097.0942747017],
                        [9.496e-08, 1.0666235072, 93.7921790939],
                        [8.413e-08, 3.15290837718, 32.7164096664],
                        [8.914e-08, 5.03579282562, 450.4559484024],
                        [8.008e-08, 4.33420849497, 302.0953396858],
                        [1.0397e-07, 4.90564475822, 829.6205085159],
                        [7.401e-08, 5.67595616187, 337.8019466282],
                        [7.419e-08, 3.0467243912, 7.4223635415],
                        [7.936e-08, 4.37116642726, 464.4705940829],
                        [9.731e-08, 5.703933034, 98.3574718034],
                        [9.287e-08, 4.16913084905, 15.4991183888],
                        [1.0072e-07, 1.18963356664, 621.7380390493],
                        [9.867e-08, 1.34469368253, 142.9709149956],
                        [8.913e-08, 1.33679256423, 0.2606324309],
                        [8.734e-08, 2.03651443558, 149.4031384402],
                        [7.745e-08, 0.14834225031, 1404.0849754971],
                        [9.037e-08, 3.53203542312, 636.6677084665],
                        [7.707e-08, 1.87083579542, 31.6526280834],
                        [8.566e-08, 2.4828035791, 497.4476361802],
                        [1.0074e-07, 2.59066128203, 711.4493070338],
                        [8.726e-08, 5.88905195509, 82.2039621088],
                        [9.218e-08, 1.10861658464, 412.5835451955],
                        [9.483e-08, 6.02304095716, 916.9322800554],
                        [7.012e-08, 6.27635752748, 376.1956146969],
                        [9.867e-08, 1.9314020472, 62.7726904569],
                        [7.121e-08, 1.54192963162, 679.2541622292],
                        [8.44e-08, 5.06400284478, 1.3725981237],
                        [8.915e-08, 2.39052372377, 76.154196691],
                        [9.637e-08, 3.78128664809, 838.218528225],
                        [7.059e-08, 5.91499106809, 74.1484591209],
                        [9.57e-08, 1.97721363991, 703.6331846174],
                        [7.516e-08, 4.87738017916, 310.1720945331],
                        [7.059e-08, 1.94098053303, 75.4147380137],
                        [8.552e-08, 6.14581140636, 17.6379824029],
                        [6.859e-08, 5.11679089849, 107.4980082337],
                        [7.148e-08, 1.73466140387, 1190.7858800591],
                        [9.112e-08, 0.8836866329, 362.8622925726],
                        [9.3e-08, 1.44257902224, 763.4369296577],
                        [9.073e-08, 4.31998777457, 16.1535096946],
                        [9.126e-08, 3.74417347717, 4.665866446],
                        [7.869e-08, 4.65596954763, 232.4215505492],
                        [9.168e-08, 3.25096522859, 155.5010879678],
                        [7.624e-08, 0.88232424215, 459.3627846522],
                        [8.2e-08, 1.51866334747, 10063.7223490764],
                        [8.579e-08, 2.377262345, 75.6753704446],
                        [7.595e-08, 2.63499505823, 657.1627617014],
                        [8.131e-08, 6.15861249482, 745.277682393],
                        [6.398e-08, 0.61376490225, 73.2489417492],
                        [7.71e-08, 4.02552779925, 4.7353024152],
                        [6.38e-08, 3.20688120531, 73.3453099688],
                        [7.505e-08, 0.67397826037, 228.7982138268],
                        [7.129e-08, 1.33525552417, 236.8749686741],
                        [7.444e-08, 3.05581518163, 171.6545976624],
                        [6.361e-08, 6.05108999867, 95.9792272178],
                        [7.086e-08, 4.88497877319, 6531.661656265],
                        [6.527e-08, 4.0138014903, 118.8737768977],
                        [7.984e-08, 1.70695215254, 104.5290628171],
                        [6.239e-08, 1.08160874504, 143.9341228421],
                        [7.2e-08, 1.19830150903, 1617.3840709351],
                        [6.39e-08, 4.83649966441, 1072.7152523135],
                        [7.857e-08, 3.06062400692, 341.9947323222],
                        [6.158e-08, 0.04340975323, 627.3671133418],
                        [8.664e-08, 5.60425824325, 2810.9214616052],
                        [6.147e-08, 4.16482048084, 1300.9922012785],
                        [8.148e-08, 3.1170064191, 10213.285546211],
                        [8.603e-08, 3.80404544682, 25558.2121764796],
                        [7.586e-08, 2.86885781812, 406.1031376411],
                        [7.925e-08, 3.11650504, 81.682697247],
                        [7.063e-08, 5.35078594952, 73.0364934281],
                        [6.265e-08, 3.27996815317, 116.5379709275],
                        [7.345e-08, 0.45699353973, 192.8040422031],
                        [6.878e-08, 1.29690429239, 22.633917249],
                        [6.102e-08, 2.06174377751, 73.9784494152],
                        [7.867e-08, 1.45455437627, 131.9252147317],
                        [6.837e-08, 0.07237438837, 90.2807169561],
                        [7.74e-08, 2.87078307084, 79.4474650133],
                        [6.744e-08, 0.01897075429, 572.2292347475],
                        [6.034e-08, 0.96635268225, 476.3194434989],
                        [8.276e-08, 2.40596529645, 674.8007441043],
                        [6.002e-08, 3.24986200464, 76.7873361374],
                        [6.863e-08, 1.24850658686, 400.1652468079],
                        [6.375e-08, 1.37050567525, 75.1541055828],
                        [7.445e-08, 5.47946546419, 50.66320861],
                        [5.889e-08, 5.83364715391, 164.1203595363],
                        [7.19e-08, 3.21396813566, 71.1582618449],
                        [6.305e-08, 1.65443603478, 70.0462961521],
                        [6.628e-08, 1.990437442, 1.5963472929],
                        [6.081e-08, 1.2659989053, 61.448276443],
                        [7.795e-08, 0.70956881527, 44.070926471],
                        [7.784e-08, 5.47416712189, 416.7763308895],
                        [5.727e-08, 2.39389303582, 20277.0078952874],
                        [6.363e-08, 1.96472326808, 288.7350853111],
                        [5.724e-08, 4.3053278397, 86.6304479833],
                        [7.348e-08, 5.28008775997, 285.6330134505],
                        [5.693e-08, 1.13590287643, 445.3481389717],
                        [5.799e-08, 2.43420435064, 180.7951340927],
                        [6.927e-08, 4.19297070447, 525.2375469697],
                        [6.143e-08, 2.23902465258, 1310.3933701397],
                        [6.68e-08, 5.36285833774, 452.4616859725],
                        [5.709e-08, 3.65303501856, 442.3791935551],
                        [6.238e-08, 4.60538870228, 137.5542890242],
                        [5.932e-08, 3.22993254909, 73.4571845534],
                        [7.734e-08, 5.72805659987, 154.2984995498],
                        [5.782e-08, 2.17577477697, 2.2876218604],
                        [6.016e-08, 3.4658554659, 346.3999663373],
                        [7.517e-08, 5.63641104589, 549.7284439425],
                        [6.685e-08, 4.84971092735, 148.8124376092],
                        [5.797e-08, 0.51568102762, 149.3025647037],
                        [7.739e-08, 3.23104533276, 589.4947101349],
                        [7.59e-08, 2.49504939023, 321.7603115182],
                        [6.706e-08, 5.23367324742, 769.8167634756],
                        [7.21e-08, 2.56243122515, 375.6743498351],
                        [5.491e-08, 1.84139760824, 375.3924655448],
                        [6.592e-08, 3.39703193659, 389.6889955156],
                        [6.414e-08, 3.56513278405, 488.8496164711],
                        [6.376e-08, 0.24081237769, 881.5075574033],
                        [5.785e-08, 3.49508162978, 102.523325247],
                        [6.079e-08, 0.84517404881, 89.5993933999],
                        [5.799e-08, 2.19388408812, 8.9068362498],
                        [5.305e-08, 1.977856112, 150.31395666],
                        [5.422e-08, 1.21990761182, 332.1728723357],
                        [7.235e-08, 2.78896876234, 748.0978699633],
                        [6.36e-08, 0.36304095923, 74.4090915518],
                        [5.285e-08, 4.41108441808, 12.0089081104],
                        [6.602e-08, 3.01699401726, 442.7517005706],
                        [6.509e-08, 0.49819168917, 1147.4968508808],
                        [5.585e-08, 6.04761249158, 172.4577468145],
                        [6.673e-08, 0.77536194908, 6069.7767545534],
                        [7.125e-08, 0.34356180793, 511.5954083047],
                        [5.288e-08, 4.27462942653, 11.1575748485],
                        [6.767e-08, 2.00969662613, 105.380396079],
                        [5.611e-08, 2.40776057824, 1286.0143477515],
                        [6.456e-08, 4.48699081452, 31.2319369581],
                        [5.898e-08, 5.26174074234, 757.8078553652],
                        [5.153e-08, 2.41386832919, 742.9900605326],
                        [5.087e-08, 6.03592089039, 980.6681783588],
                        [6.198e-08, 0.83056505252, 1507.1777497157],
                        [5.425e-08, 1.93107713343, 40.8413486235],
                        [6.091e-08, 5.18564204379, 487.1045113319],
                        [5.715e-08, 1.96802719384, 394.3548619616],
                        [5.509e-08, 1.3127509208, 883.7951792637],
                        [5.32e-08, 4.22718652038, 65.3804297061],
                        [5.357e-08, 1.80483136985, 139.4807047172],
                        [5.204e-08, 3.39869589191, 1400.152822234],
                        [6.537e-08, 2.31923989568, 328.2407190726],
                        [5.041e-08, 2.9467334644, 361.3778198643],
                        [4.969e-08, 6.27367198215, 0.1600586944],
                        [5.334e-08, 2.78985718428, 217.4436970222],
                        [5.654e-08, 0.51056760715, 285.1117485887],
                        [6.432e-08, 2.21948959433, 9999.986450773],
                        [5.768e-08, 5.10735836078, 216.2680408546],
                        [4.977e-08, 2.62435916254, 194.1766403268],
                        [6.932e-08, 1.71722863424, 378.9039276826],
                        [5.187e-08, 3.04429850681, 1083.7609525774],
                        [5.791e-08, 3.9406147625, 550.1378342197],
                        [5.816e-08, 2.24843661305, 230.9370778409],
                        [5.319e-08, 0.0699882535, 336.8387387817],
                        [5.427e-08, 0.30577275388, 40.5807161926],
                        [6.469e-08, 3.02579309025, 298.2326223919],
                        [4.974e-08, 1.21594265105, 455.0694252217],
                        [4.96e-08, 4.7280621023, 454.7493078329],
                        [5.619e-08, 2.27500303004, 227.5261894396],
                        [6.328e-08, 0.97544932086, 249.9476583675],
                        [5.319e-08, 4.59867974067, 454.7974919427],
                        [4.791e-08, 4.40360629153, 853.196381752],
                        [6.519e-08, 3.03043401282, 167.7224443993],
                        [5.45e-08, 6.00971547441, 25.1297819136],
                        [5.094e-08, 3.96693309189, 1066.49547719],
                        [5.779e-08, 0.65954416303, 272.5815756165],
                        [6.491e-08, 4.6852965154, 312.1990839626],
                        [5.234e-08, 4.34712255335, 233.533516242],
                        [5.396e-08, 5.62885554221, 418.5214360287],
                        [5.048e-08, 2.46802064424, 987.5692770385],
                        [6.152e-08, 0.79853332272, 2274.5468326365],
                        [6.506e-08, 1.7291557512, 125.1841747464],
                        [4.993e-08, 3.75975860404, 57.255490749],
                        [6.295e-08, 0.84778953014, 10.0824924174],
                        [6.251e-08, 4.78782138567, 270.1820791715],
                        [5.785e-08, 4.31237764709, 374.4986936675],
                        [5.406e-08, 5.49902863401, 632.7837393132],
                        [6.224e-08, 0.12733845417, 149.0419322728],
                        [4.921e-08, 1.43037646364, 73.1370671646],
                        [5.076e-08, 1.34845106372, 455.0212411119],
                        [5.73e-08, 3.30386575867, 88.274979386],
                        [4.618e-08, 0.64720625124, 119.3950417595],
                        [6.213e-08, 2.58827934841, 544.5087599272],
                        [4.825e-08, 6.08615765986, 304.1223291153],
                        [4.825e-08, 6.00483903794, 226.7924762567],
                        [5.528e-08, 5.69752791882, 548.4409131903],
                        [5.108e-08, 2.74489127167, 423.6292454594],
                        [5.426e-08, 2.44835106987, 531.978586955],
                        [4.573e-08, 1.61098293427, 357.4456666012],
                        [4.487e-08, 6.09067660554, 204.7010757289],
                        [5.866e-08, 6.20513223441, 772.7857088922],
                        [5.334e-08, 2.49860553733, 1131.1945833399],
                        [5.656e-08, 4.75744184558, 491.8185618877],
                        [4.441e-08, 0.23590452375, 35.685355083],
                        [4.37e-08, 3.8113649083, 1329.3033769298],
                        [4.406e-08, 3.42865095493, 144.8973306886],
                        [5.251e-08, 4.72114047741, 535.3200393871],
                        [5.174e-08, 1.37807596858, 520.129737539],
                        [4.331e-08, 2.64717426456, 1517.2602421331],
                        [4.802e-08, 2.6056946352, 177.3049238143],
                        [4.368e-08, 3.36272561974, 1503.2455964526],
                        [4.335e-08, 2.73379207096, 289.5651667136],
                        [5.198e-08, 0.97116582962, 128.4350044533],
                        [4.437e-08, 0.56678131875, 253.4591205053],
                        [5.386e-08, 5.84886051674, 268.6976064632],
                        [5.376e-08, 1.30096148962, 436.8138097374],
                        [5.797e-08, 4.33049740199, 208.8456773131],
                        [4.353e-08, 1.66111524192, 1261.6353253633],
                        [4.812e-08, 4.95769337401, 545.4719677737],
                        [5.897e-08, 2.0420120518, 8.5980197091],
                        [5.032e-08, 2.8055075977, 360.4146120178],
                        [4.921e-08, 2.55658380096, 260.360219185],
                        [4.413e-08, 3.23825819993, 973.554631358],
                        [4.506e-08, 0.17509624151, 380.3884003909],
                        [4.947e-08, 5.50324549675, 365.9006739584],
                        [4.174e-08, 2.99974290843, 136.0698163159],
                        [4.553e-08, 2.77416673233, 147.9668498417],
                        [5.344e-08, 1.81213470593, 521.0929453855],
                        [5.155e-08, 0.78324341489, 1670.0742689746],
                        [5.133e-08, 1.37435234967, 271.61836777],
                        [5.708e-08, 2.52872222038, 501.3797894433],
                        [4.933e-08, 1.36454104948, 238.9019581036],
                        [4.973e-08, 1.92960964594, 535.9107402181],
                        [4.935e-08, 5.04375067678, 697.8071683688],
                        [4.129e-08, 1.50064332826, 71.8608372605],
                        [5.207e-08, 4.0187736734, 92.4195809702],
                        [4.587e-08, 4.78553156868, 95.931043108],
                        [5.05e-08, 5.41251268131, 758.7710632117],
                        [5.012e-08, 4.50266403888, 635.9651330509],
                        [4.248e-08, 0.65406962267, 920.8644333185],
                        [5.15e-08, 1.13490701556, 310.9752436852],
                        [4.146e-08, 5.54040372231, 1048.3362299253],
                        [4.256e-08, 4.20942901957, 25.2727942655],
                        [4.569e-08, 5.19758291396, 10.2949407385],
                        [4.259e-08, 5.53202386861, 184.9879197867],
                        [4.315e-08, 2.80569687202, 213.9534867438],
                        [4.604e-08, 2.51643176466, 962.5089310941],
                        [5.105e-08, 1.26007002216, 971.1069508032],
                        [4.5e-08, 6.15796742231, 1052.2683831884],
                        [4.095e-08, 0.63467124507, 1321.4390704036],
                        [3.968e-08, 0.07377679014, 77.7023598741],
                        [4.617e-08, 2.77367751889, 406.954470903],
                        [4.899e-08, 4.65767840428, 305.6068018236],
                        [3.9e-08, 1.66467970991, 945.2434557067],
                        [4.133e-08, 3.76396043787, 263.0203480609],
                        [3.899e-08, 4.28677450975, 224.2329211173],
                        [5.03e-08, 6.24112139981, 1162.4747044078],
                        [5.024e-08, 0.39738855487, 968.1380053866],
                        [4.894e-08, 2.50422546622, 355.7487455718],
                        [4.283e-08, 3.15267059582, 846.0828347512],
                        [3.941e-08, 0.04342429962, 1235.6117715724],
                        [4.077e-08, 5.6885446997, 695.5564297701],
                        [3.842e-08, 0.37429373422, 774.4826299216],
                        [4.674e-08, 0.08112657673, 1366.2125722902],
                        [4.671e-08, 4.38923533828, 117.36805233],
                        [5.313e-08, 4.38472090135, 689.6185389369],
                        [3.787e-08, 1.41443617212, 48.9181034708],
                        [4.236e-08, 1.60316940746, 367.5975949878],
                        [4.569e-08, 2.88138923862, 551.1010420662],
                        [4.636e-08, 5.93442268083, 148.1905990109],
                        [5.128e-08, 0.17600225009, 433.7117378768],
                        [4.264e-08, 2.08657038625, 325.3836482406],
                        [3.885e-08, 5.85359840623, 450.7165808333],
                        [4.753e-08, 2.58442943928, 358.4088744477],
                        [4.226e-08, 6.24596640453, 448.9714756941],
                        [3.776e-08, 1.78756451192, 71.7007785661],
                        [4.912e-08, 4.45665056284, 51.8870488874],
                        [3.854e-08, 2.72138633161, 151.850818995],
                        [4.561e-08, 0.07201979569, 2349.3284312038],
                        [4.291e-08, 5.39929339966, 523.7530742614],
                        [4.143e-08, 0.1715886627, 735.8765135318],
                        [3.806e-08, 1.44358694049, 138.6293714553],
                        [3.654e-08, 2.41520715554, 348.8476468921],
                        [3.728e-08, 1.69745141654, 984.7122062065],
                        [4.176e-08, 4.01139155515, 195.7729876197],
                        [4.986e-08, 1.0356290592, 224.4566702865],
                        [4.031e-08, 0.92145122185, 76.0054388447],
                        [4.098e-08, 3.51214223942, 72.4939767069],
                        [3.812e-08, 4.41246815759, 1511.3223512999],
                        [4.098e-08, 2.39702785276, 239.1625905345],
                        [4.894e-08, 5.26621064696, 601.5036182453],
                        [4.459e-08, 5.76440378473, 836.5216071956],
                        [4.373e-08, 4.08948598951, 75.4359898731],
                        [4.363e-08, 6.01127167247, 421.1815649046],
                        [4.414e-08, 0.358306616, 168.3131452303],
                        [3.7e-08, 2.04103813925, 63.2146334416],
                        [4.648e-08, 2.07482117651, 1106.6555022573],
                        [4.304e-08, 3.03122452327, 1109.6244476739],
                        [3.618e-08, 4.84400847177, 893.3564068193],
                        [4.023e-08, 0.59685650686, 91.2439248026],
                        [4.937e-08, 5.49417275871, 976.7360250957],
                        [4.373e-08, 3.76648561161, 74.1272072615],
                        [4.31e-08, 3.72983787822, 673.316271396],
                        [4.68e-08, 3.8963125415, 163.5778428151],
                        [4.172e-08, 0.75349427039, 1500.0642027149],
                        [4.492e-08, 1.87283145714, 141.1776257466],
                        [4.174e-08, 5.82910805335, 346.4481504471],
                        [3.775e-08, 0.83052387256, 827.9235874865],
                        [3.481e-08, 2.70828672792, 818.574808252],
                        [4.853e-08, 0.95917381603, 58.1705144857],
                        [4.021e-08, 3.11274455034, 377.4194549743],
                        [4.409e-08, 0.16607520728, 630.3360587584],
                        [3.597e-08, 1.02560564654, 515.463871093],
                        [3.444e-08, 1.38488805947, 117.3198682202],
                        [4.021e-08, 5.68447974866, 3.4902102784],
                        [4.244e-08, 3.75845344717, 733.428832977],
                        [3.933e-08, 4.55157642432, 240.125798381],
                        [4.421e-08, 1.51263319894, 1610.2705239343],
                        [3.39e-08, 4.00215380112, 74.9940468884],
                        [4.556e-08, 3.41531360529, 1140.38330388],
                        [4.171e-08, 0.76417016678, 623.4349600787],
                        [3.441e-08, 2.56450835637, 14.8177948326],
                        [3.587e-08, 4.10186965494, 343.2185725996],
                        [3.997e-08, 5.74857613262, 6212.2264046872],
                        [4.215e-08, 0.84469743228, 176.6505325085],
                        [4.098e-08, 1.41920746453, 559.6990617753],
                        [4.553e-08, 1.09016692751, 561.8861098992],
                        [3.493e-08, 0.11837510368, 1031.87390369],
                        [3.596e-08, 5.33968666729, 394.9455627926],
                        [3.501e-08, 5.53309359866, 594.9113361063],
                        [3.564e-08, 1.57868308864, 354.9979860464],
                        [4.279e-08, 2.35436288262, 562.6680071919],
                        [3.398e-08, 1.6208634854, 941.3113024436],
                        [3.803e-08, 1.78948693511, 251.1714986449],
                        [3.299e-08, 5.13631478768, 477.0007670551],
                        [3.422e-08, 3.55674695079, 256.4280659219],
                        [3.802e-08, 4.09287840097, 268.9582388941],
                        [3.818e-08, 4.64162443046, 71.9245277353],
                        [4.623e-08, 2.72836206211, 6244.9428143536],
                        [3.466e-08, 1.91387688001, 58.7399634573],
                        [3.435e-08, 2.96178782926, 995.6460318858],
                        [3.626e-08, 5.35614681493, 57.5161231799],
                        [4.512e-08, 1.18350543284, 170.7608257851],
                        [4.378e-08, 0.273460377, 469.7271613599],
                        [3.323e-08, 4.51516827363, 454.8611824175],
                        [3.32e-08, 1.42938752044, 454.9575506371],
                        [4.578e-08, 4.7498051473, 731.9443602687],
                        [3.249e-08, 0.67719975914, 74.0478853844],
                        [4.145e-08, 5.58064267022, 57.7980074702],
                        [3.512e-08, 6.09122971288, 70.5888128733],
                        [3.814e-08, 2.49565462974, 6204.362098161],
                        [3.828e-08, 4.39751907192, 586.3133163972],
                        [3.639e-08, 4.85097208169, 138.4056222861],
                        [3.518e-08, 0.52105043625, 262.8078997398],
                        [3.671e-08, 1.99667387765, 511.5317178299],
                        [3.215e-08, 0.64628330219, 887.7273325268],
                        [3.718e-08, 3.27473813045, 454.6487340964],
                        [3.638e-08, 2.63250736806, 455.1699989582],
                        [3.772e-08, 0.88810300052, 10142.4361009068],
                        [3.19e-08, 4.87960158471, 455.6601260527],
                        [3.669e-08, 4.11456655271, 409.9234163196],
                        [3.166e-08, 1.24948126394, 82.6459050935],
                        [3.53e-08, 4.02075420346, 388.2045228073],
                        [3.163e-08, 1.65294183878, 765.8846102125],
                        [3.568e-08, 5.95965909592, 460.8472573605],
                        [3.45e-08, 0.08821515281, 49.1787359017],
                        [3.27e-08, 1.81146731641, 34.2008823747],
                        [3.188e-08, 1.74587038709, 18.9100067901],
                        [3.305e-08, 5.77382040863, 10.5244354021],
                        [3.345e-08, 4.15802505352, 1515.7757694248],
                        [3.16e-08, 1.06549289762, 454.1586070019],
                        [3.525e-08, 2.56091667232, 78114.146227588],
                        [4.124e-08, 1.06751791085, 388.4651552382],
                        [4.016e-08, 2.48751669586, 531.1754378029],
                        [3.147e-08, 5.05814757549, 1521.4048437173],
                        [4.18e-08, 1.16833674781, 514.5643537213],
                        [3.212e-08, 3.18682610058, 1512.8068240082],
                        [3.486e-08, 0.22630227172, 36.5366883449],
                        [4.211e-08, 3.21876950029, 761.7400086283],
                        [3.485e-08, 3.26177495276, 36.7604375141],
                        [3.506e-08, 6.26633354904, 545.2750258176],
                        [3.733e-08, 2.55776517455, 279.4826742962],
                        [4.227e-08, 1.41381723926, 41.7563723602],
                        [3.187e-08, 1.62296832026, 138.4693127609],
                        [3.934e-08, 2.86731965547, 832.0681890707],
                        [3.684e-08, 3.941740603, 179.3106613844],
                        [3.115e-08, 5.67364420834, 73.5577582899],
                        [3.663e-08, 1.80556740809, 31.5407534988],
                        [3.171e-08, 4.85529878165, 138.5656809805],
                        [3.777e-08, 5.94890597104, 873.1701701251],
                        [4.357e-08, 4.15105623366, 10175.1525105732],
                        [3.951e-08, 1.60185888278, 576.1613880106],
                        [3.525e-08, 4.8031643597, 429.7795846137],
                        [3.33e-08, 5.62171319933, 1116.0042814918],
                        [3.943e-08, 4.6264154302, 898.7730327907],
                        [3.382e-08, 1.45717307307, 5983.9494557222],
                        [3.215e-08, 3.73878297941, 335.7749571987],
                        [3.423e-08, 5.07987216951, 143.3434220111],
                        [4.161e-08, 5.39091883238, 1363.2436268736],
                        [3.457e-08, 3.94796907904, 444.8268741099],
                        [3.593e-08, 3.91831549069, 10134.5717943806],
                        [3.666e-08, 4.2262033899, 36.1754821775],
                        [3.58e-08, 3.43130119859, 912.7876784712],
                        [3.7e-08, 0.67445695843, 73.9302653054],
                        [3.679e-08, 1.10949079061, 686.958410061],
                        [3.547e-08, 5.63096398237, 440.8947208468],
                        [3.622e-08, 1.10742531477, 2250.1678102483],
                        [3.562e-08, 3.80604468765, 1525.3369969804],
                        [3.33e-08, 1.76480149289, 78.9743842613],
                        [3.738e-08, 1.7675491018, 384.5811860849],
                        [3.986e-08, 1.0684287447, 743.7932096847],
                        [3.032e-08, 5.77852412826, 612.1768114937],
                        [3.008e-08, 0.64086342534, 210.8514148832],
                        [3.334e-08, 4.81681647959, 597.3590166611],
                        [3.141e-08, 3.11768616608, 6607.9277275406],
                        [3.022e-08, 2.08709314702, 34.5309507748],
                        [3.226e-08, 3.19780030434, 377.6800874052],
                        [4.065e-08, 3.53637930424, 402.2191684878],
                        [4.138e-08, 0.28927701421, 517.1607921224],
                        [3.697e-08, 0.89932694516, 75.6329318292],
                        [3.918e-08, 5.73859894835, 94.4253185403],
                        [3.374e-08, 0.4097440558, 677.7696895209],
                        [3.194e-08, 4.56998602897, 1385.174968707],
                        [3.18e-08, 1.03370427552, 885.4397106664],
                        [3.235e-08, 5.09681747179, 464.9918589447],
                        [3.798e-08, 5.76464888795, 586.377006872],
                        [3.173e-08, 5.68964342749, 4.192785694],
                        [3.181e-08, 2.87968862974, 9914.1591519418],
                        [3.355e-08, 5.45857968674, 73.0846775379],
                        [2.899e-08, 5.12928266291, 448.3170843883],
                        [3.706e-08, 2.47342147635, 64.2571631652],
                        [3.796e-08, 4.29502458131, 164.5410506616],
                        [3.534e-08, 4.42464754991, 46.470422916],
                        [3.488e-08, 5.62713714766, 3189.5647568569],
                        [2.94e-08, 4.33606107945, 78263.7094247226],
                        [3.309e-08, 3.10770680369, 519.6084726772],
                        [4.03e-08, 4.41794838679, 772.5887669361],
                        [2.867e-08, 5.17129632099, 346.1875180162],
                        [3.842e-08, 1.87994191354, 299.7170951002],
                        [3.846e-08, 5.38315286213, 980.146913497],
                        [3.724e-08, 4.94511644698, 984.4884570373],
                        [2.814e-08, 2.17260061398, 191.3195694948],
                        [3.392e-08, 3.0855211609, 245.4942402426],
                        [2.923e-08, 0.37358823115, 6.4804075544],
                        [3.025e-08, 1.19297242418, 104.8378793578],
                        [3.47e-08, 1.89084704021, 44.6134431922],
                        [2.931e-08, 0.78809830626, 540.0553418023],
                        [3.707e-08, 4.14868763219, 6136.4815982734],
                        [3.931e-08, 5.52289695589, 6171.6456884946],
                        [3.056e-08, 2.97000936733, 250.6020496733],
                        [3.117e-08, 0.76332399369, 229.4526051326],
                        [3.091e-08, 4.9194127978, 221.1634019642],
                        [3.378e-08, 3.82658652472, 25936.8554717313],
                        [3.041e-08, 2.14503983522, 6604.958782124],
                        [2.865e-08, 0.53734608663, 273.8536000037],
                        [2.845e-08, 0.34922064899, 85.9391734158],
                        [3.657e-08, 6.02755271763, 340.8827666294],
                        [2.818e-08, 4.44508352472, 369.342700127],
                        [2.861e-08, 2.19284349075, 295.1942410061],
                        [2.865e-08, 3.21935127992, 3.8202786785],
                        [2.797e-08, 5.97725967979, 2014.0265547571],
                        [3.28e-08, 0.74832416123, 422.7142217227],
                        [3.509e-08, 1.92501559437, 343.4792050305],
                        [2.962e-08, 2.29867992492, 661.1586054393],
                        [3.485e-08, 4.5320530238, 676.2852168126],
                        [2.836e-08, 1.2077968366, 1119.1856752295],
                        [3.603e-08, 2.72183511139, 508.6264628881],
                        [3.62e-08, 5.57691156197, 10066.691294493],
                        [2.731e-08, 0.9666341177, 582.3811631341],
                        [3.306e-08, 6.20620840278, 11.5669651257],
                        [3.279e-08, 6.13563821647, 276.0717858949],
                        [2.747e-08, 4.5747626302, 226.6324175623],
                        [2.825e-08, 1.24120423378, 989.0537497468],
                        [2.707e-08, 0.46257342768, 1458.472094566],
                        [2.755e-08, 5.43548338507, 246.9787129509],
                        [3.338e-08, 3.98641322371, 488.5889840402],
                        [2.96e-08, 5.31788128818, 1467.0701142751],
                        [3.062e-08, 1.93542241882, 987.7817253596],
                        [3.504e-08, 4.10521239427, 6280.1069045748],
                        [3.584e-08, 3.12196206517, 108.7218485111],
                        [2.975e-08, 0.13746189123, 9987.4562778008],
                        [2.634e-08, 5.61201014857, 412.3710968744],
                        [3.702e-08, 0.66231252049, 10101.8553847142],
                        [3.261e-08, 4.39228048501, 75.3722993983],
                        [2.939e-08, 3.2631997985, 130.552616608],
                        [2.742e-08, 6.24317126103, 447.2051186955],
                        [3.008e-08, 4.24451493185, 170.1701249541],
                        [3.001e-08, 2.45489658954, 230.8252032563],
                        [2.722e-08, 4.98348297926, 754.0357607965],
                        [2.928e-08, 5.73784691627, 14.6690369863],
                        [2.699e-08, 2.98043546816, 27.7204748203],
                        [3.678e-08, 3.46436124301, 26468.0309095342],
                        [3.5e-08, 4.41810854452, 322.6116447801],
                        [2.943e-08, 3.58544468129, 12489.8856287072],
                        [2.894e-08, 2.2699912084, 1615.8995982268],
                        [2.679e-08, 1.32002304425, 236.1936451179],
                        [2.711e-08, 1.25250599577, 52250.5878817157],
                        [2.573e-08, 4.41371056719, 262.0571402144],
                        [3.483e-08, 1.97113718781, 655.938921424],
                        [2.6e-08, 3.8010722697, 70.6369969831],
                        [3.28e-08, 1.75059058234, 683.9894646444],
                        [3.26e-08, 3.46047977615, 74.1908977363],
                        [3.097e-08, 5.47452034532, 302.3772239761],
                        [2.565e-08, 3.47443238116, 2042.4977891028],
                        [3.158e-08, 4.58160924364, 12492.8545741238],
                        [3.373e-08, 5.52806001629, 10210.3166007944],
                        [2.619e-08, 4.43681016753, 949.1756089698],
                        [3.29e-08, 1.35055242247, 515.6763194141],
                        [3.18e-08, 4.49938964982, 694.8382229522],
                        [2.558e-08, 5.07921716363, 197.7999770492],
                        [2.902e-08, 2.61388996483, 115.3623147599],
                        [2.586e-08, 4.09771865336, 1448.9108670104],
                        [3.16e-08, 4.82168102018, 714.6788848813],
                        [3.016e-08, 3.16691101108, 385.7568422525],
                        [3.001e-08, 3.24181300229, 1618.8685436434],
                        [3.319e-08, 5.98200177347, 533.8355666788],
                        [3.307e-08, 3.31452419197, 732.97125859],
                        [2.53e-08, 0.13809025963, 591.9423906897],
                        [2.975e-08, 5.72770980032, 1011.4270345649],
                        [2.857e-08, 4.11031053901, 2267.4332856357],
                        [3.091e-08, 4.87979664891, 582.641795565],
                        [3.422e-08, 6.18592254593, 281.4884118663],
                        [2.501e-08, 0.50645055144, 29.226199388],
                        [3.502e-08, 0.17203520151, 371.5297482509],
                        [2.607e-08, 3.51828908958, 112.3933693433],
                        [2.547e-08, 4.45612695304, 901.2207133455],
                        [2.778e-08, 4.97805873371, 132.5796060375],
                        [2.476e-08, 1.55163657371, 1234.1272988641],
                        [2.929e-08, 2.34725672182, 273.1510245881],
                        [2.724e-08, 5.73177362443, 688.6553310904],
                        [2.667e-08, 6.13733078138, 161.4120465506],
                        [2.877e-08, 5.47506403197, 1436.5407527326],
                        [2.779e-08, 1.54196175338, 680.0573113813],
                        [2.427e-08, 4.6491343131, 392.6579409322],
                        [3.223e-08, 2.57976952494, 267.5856407704],
                        [2.75e-08, 1.29662662582, 108.982480942],
                        [3.22e-08, 1.0629018794, 388.7257876691],
                        [3.236e-08, 3.47802643973, 283.6272758804],
                        [3.027e-08, 5.38233284458, 44.0921783304],
                        [2.83e-08, 5.70274947128, 327.4375699205],
                        [2.768e-08, 5.4225616879, 482.2573343321],
                        [3.23e-08, 5.65661970187, 134.3728952865],
                        [2.685e-08, 5.03687735302, 763.2244813366],
                        [2.441e-08, 5.19830386978, 380.2396425446],
                        [2.608e-08, 3.11386505876, 578.449009871],
                        [2.465e-08, 1.4924267283, 141.6988906084],
                        [2.332e-08, 3.19371804203, 683.0262567979],
                        [2.307e-08, 4.07685834192, 78.9262001515],
                        [2.28e-08, 2.52476606956, 156.6767441354],
                        [2.26e-08, 6.23958645351, 400.5746370851],
                        [2.301e-08, 2.47762267951, 107.918699359],
                        [3.089e-08, 5.69639540598, 537.3952129264],
                        [3.074e-08, 1.16740737548, 58.6280888727],
                        [2.846e-08, 0.02430566936, 563.3705826075],
                        [2.423e-08, 4.24559706691, 27.7417266797],
                        [2.67e-08, 3.48404619442, 123.0183784819],
                        [2.228e-08, 3.33159258912, 1257.7031721002],
                        [2.445e-08, 2.29979337782, 280.2163874791],
                        [2.26e-08, 3.85026258012, 753.1419889192],
                        [2.195e-08, 4.94038065567, 1222.2784494481],
                        [2.579e-08, 1.76841912074, 710.7467316182],
                        [2.402e-08, 4.47942458428, 569.0478410098],
                        [2.181e-08, 5.39048760967, 318.679491517],
                        [2.317e-08, 6.27946729049, 493.0424021651],
                        [2.42e-08, 3.66436222896, 3.6233367224],
                      ],
          },
          {
            series => "R1",
            terms  => [
                        [0.0147989637, 3.67205705317, 74.7815985673],
                        [0.00071212085, 6.22601006675, 63.7358983034],
                        [0.00068626972, 6.13411265052, 149.5631971346],
                        [0.00020857262, 5.24625494219, 11.0457002639],
                        [0.00021468152, 2.6017670427, 76.2660712756],
                        [0.00024059649, 3.14159265359, 0],
                        [0.00011405346, 0.01848461561, 70.8494453042],
                        [7.496775e-05, 0.42360033283, 73.297125859],
                        [4.2438e-05, 1.41692350371, 85.8272988312],
                        [3.505936e-05, 2.58354048851, 138.5174968707],
                        [3.228835e-05, 5.25499602896, 3.9321532631],
                        [3.926694e-05, 3.15513991323, 71.8126531507],
                        [3.06001e-05, 0.15321893225, 1.4844727083],
                        [3.578446e-05, 2.31160668309, 224.3447957019],
                        [2.564251e-05, 0.98076846352, 148.0787244263],
                        [2.429445e-05, 3.99440122468, 52.6901980395],
                        [1.644719e-05, 2.65349313124, 127.4717966068],
                        [1.583766e-05, 1.43045619196, 78.7137518304],
                        [1.413112e-05, 4.57461892062, 202.2533951741],
                        [1.489525e-05, 2.67559167316, 56.6223513026],
                        [1.403237e-05, 1.36985349744, 77.7505439839],
                        [1.22822e-05, 1.04703640149, 62.2514255951],
                        [1.508028e-05, 5.05996325425, 151.0476698429],
                        [9.92085e-06, 2.17168865909, 65.2203710117],
                        [1.032731e-05, 0.26459059027, 131.4039498699],
                        [8.61867e-06, 5.05530802218, 351.8165923087],
                        [7.44445e-06, 3.07640148939, 35.1640902212],
                        [6.04362e-06, 0.90717667985, 984.6003316219],
                        [6.46851e-06, 4.4729042291, 70.3281804424],
                        [5.7471e-06, 3.23070708457, 447.7958195265],
                        [6.8747e-06, 2.49912565674, 77.962992305],
                        [6.23602e-06, 0.8625307382, 9.5612275556],
                        [5.27794e-06, 5.15136007084, 2.9689454166],
                        [5.61839e-06, 2.7177815898, 462.0229135281],
                        [5.30364e-06, 5.91655309045, 213.299095438],
                        [4.6008e-06, 4.22302465979, 12.5301729722],
                        [4.9428e-06, 0.46291078127, 145.6310438715],
                        [4.87336e-06, 0.70614146398, 380.12776796],
                        [3.80908e-06, 3.85089591694, 3.1813937377],
                        [4.44352e-06, 2.15558291251, 67.6680515665],
                        [3.388e-06, 2.53820897704, 18.1592472647],
                        [3.72947e-06, 5.05141251694, 529.6909650946],
                        [3.48345e-06, 1.74874852104, 71.6002048296],
                        [4.05881e-06, 1.229617276, 22.0914005278],
                        [2.68913e-06, 6.24069521597, 340.7708920448],
                        [2.55585e-06, 2.95695013627, 84.3428261229],
                        [2.59465e-06, 3.92053708924, 59.8037450403],
                        [2.24731e-06, 3.90961468562, 160.6088973985],
                        [2.2171e-06, 3.64727173951, 137.0330241624],
                        [2.54591e-06, 3.50411592815, 38.1330356378],
                        [2.3829e-06, 2.04879982674, 269.9214467406],
                        [2.72355e-06, 3.38363105223, 222.8603229936],
                        [2.00648e-06, 1.24861003313, 69.3649725959],
                        [2.34153e-06, 0.27825220612, 108.4612160802],
                        [1.88515e-06, 4.41307507326, 265.9892934775],
                        [2.11691e-06, 0.68027381802, 111.4301614968],
                        [2.05946e-06, 1.53379817229, 284.1485407422],
                        [1.96179e-06, 4.77152996605, 299.1263942692],
                        [1.53102e-06, 5.21761881347, 209.3669421749],
                        [1.62563e-06, 4.3405435361, 33.6796175129],
                        [1.50563e-06, 1.98966326297, 54.1746707478],
                        [1.37012e-06, 0.40323866041, 195.1398481733],
                        [1.17171e-06, 0.39649791652, 87.3117715395],
                        [1.27913e-06, 2.40333045173, 39.6175083461],
                        [1.04218e-06, 2.92152185788, 134.5853436076],
                        [1.03862e-06, 1.81622936156, 72.3339180125],
                        [1.05741e-06, 0.17067407327, 79.2350166922],
                        [1.06419e-06, 0.69799543514, 2.4476805548],
                        [9.5326e-07, 4.02880266738, 82.8583534146],
                        [1.04772e-06, 4.43616414428, 305.3461693927],
                        [9.3825e-07, 5.01823592717, 51.2057253312],
                        [1.03739e-06, 2.57553519741, 191.2076949102],
                        [1.06679e-06, 1.22996874093, 225.8292684102],
                        [9.3452e-07, 3.09274255916, 77.2292791221],
                        [9.7398e-07, 3.81380841075, 152.5321425512],
                        [8.4583e-07, 5.72473747348, 68.8437077341],
                        [7.7395e-07, 0.08281157747, 45.5766510387],
                        [7.6207e-07, 4.20384370842, 73.8183907208],
                        [8.6249e-07, 0.53131085736, 145.1097790097],
                        [7.5795e-07, 3.78559826812, 75.7448064138],
                        [7.7592e-07, 1.63628139623, 479.2883889155],
                        [8.4612e-07, 0.6166245601, 116.4260963429],
                        [1.00209e-06, 4.94084867643, 120.358249606],
                        [7.2142e-07, 4.30505812564, 565.1156877467],
                        [7.0733e-07, 2.38450718488, 60.7669528868],
                        [7.1585e-07, 3.93906647867, 153.4953503977],
                        [8.4566e-07, 5.56037336584, 344.7030453079],
                        [6.3556e-07, 1.93742986679, 41.6444977756],
                        [7.1619e-07, 3.71213491656, 408.4389436113],
                        [6.1594e-07, 3.90006698249, 4.4534181249],
                        [6.4973e-07, 1.55845503407, 106.9767433719],
                        [5.9913e-07, 0.60110866128, 74.8934731519],
                        [6.2e-07, 4.39369268007, 453.424893819],
                        [6.3361e-07, 4.19159979468, 184.7272873558],
                        [6.2301e-07, 3.23773103318, 422.6660376129],
                        [5.4427e-07, 3.72545550857, 7.1135470008],
                        [5.2474e-07, 6.08562717749, 404.5067903482],
                        [5.9073e-07, 1.55568469603, 456.3938392356],
                        [5.2597e-07, 3.5049223397, 125.9873238985],
                        [5.2835e-07, 5.20100035142, 358.9301393095],
                        [5.8123e-07, 5.33480562448, 220.4126424388],
                        [5.2909e-07, 4.44819701196, 426.598190876],
                        [5.0934e-07, 0.526385342, 490.3340891794],
                        [5.4968e-07, 1.60146090981, 14.977853527],
                        [4.9491e-07, 4.25534603275, 5.4166259714],
                        [5.1303e-07, 0.36772379136, 206.1855484372],
                        [5.1821e-07, 1.75832999538, 8.0767548473],
                        [5.6964e-07, 0.84114552694, 146.594251718],
                        [4.9109e-07, 0.94061875871, 99.1606209555],
                        [4.6361e-07, 5.35115472594, 152.7445908723],
                        [4.8023e-07, 1.97249712347, 288.0806940053],
                        [4.3772e-07, 3.03713403879, 20.6069278195],
                        [4.9493e-07, 5.84619560979, 112.9146342051],
                        [4.1987e-07, 0.04620500196, 128.9562693151],
                        [4.8628e-07, 3.62817742782, 81.0013736908],
                        [4.1472e-07, 2.33730376429, 277.0349937414],
                        [3.9983e-07, 5.09525356576, 35.4247226521],
                        [4.1948e-07, 2.51050760642, 24.3790223882],
                        [3.8325e-07, 3.61946898382, 173.9422195228],
                        [3.8385e-07, 2.0600322013, 333.657345044],
                        [4.2597e-07, 1.260887373, 1514.2912967165],
                        [3.8855e-07, 0.74239364306, 347.8844390456],
                        [3.8535e-07, 4.95064283065, 92.940845832],
                        [3.3234e-07, 1.38358507432, 74.6697239827],
                        [3.3788e-07, 3.68407945156, 66.9172920411],
                        [3.8953e-07, 5.49236040328, 200.7689224658],
                        [3.185e-07, 0.53990592534, 203.7378678824],
                        [3.332e-07, 6.26012644668, 1059.3819301892],
                        [3.0806e-07, 2.53797566903, 977.4867846211],
                        [2.9198e-07, 5.43116906, 58.1068240109],
                        [3.0059e-07, 0.19481555617, 387.2413149608],
                        [2.8997e-07, 3.10546504714, 991.7138786227],
                        [3.564e-07, 3.72863820177, 96.8729990951],
                        [2.7607e-07, 0.37142052647, 80.1982245387],
                        [3.2492e-07, 4.38403518987, 221.3758502853],
                        [2.7029e-07, 1.35552416596, 0.9632078465],
                        [3.1276e-07, 0.79566430555, 373.0142209592],
                        [3.1122e-07, 2.05381353845, 230.5645708254],
                        [2.5883e-07, 3.46808071409, 144.1465711632],
                        [3.0201e-07, 0.71392007232, 109.9456887885],
                        [2.4688e-07, 3.04162764358, 14.0146456805],
                        [2.7882e-07, 4.76559523368, 415.5524906121],
                        [2.511e-07, 5.12405829717, 81.3738807063],
                        [2.5582e-07, 2.56904073164, 522.5774180938],
                        [2.4351e-07, 2.2028905975, 628.8515860501],
                        [2.5479e-07, 1.795218773, 143.6253063014],
                        [2.4182e-07, 5.67160913092, 443.8636662634],
                        [2.5679e-07, 5.43185950751, 546.956440482],
                        [2.4177e-07, 5.59982039849, 32.1951448046],
                        [2.4428e-07, 3.30271734903, 617.8058857862],
                        [2.3535e-07, 0.65842590604, 46.2097904851],
                        [2.2371e-07, 4.82094751058, 135.5485514541],
                        [2.7179e-07, 2.02720001624, 536.8045120954],
                        [2.2213e-07, 4.6166462422, 391.1734682239],
                        [2.1973e-07, 4.59216260632, 241.6102710893],
                        [2.0813e-07, 0.24392941148, 465.9550667912],
                        [2.7264e-07, 2.15210992383, 140.001969579],
                        [2.1356e-07, 5.27168432406, 159.1244246902],
                        [2.3632e-07, 4.94972840898, 561.1835344836],
                        [2.4921e-07, 0.54550733267, 181.7583419392],
                        [2.3027e-07, 3.80632203913, 55.1378785943],
                        [1.9799e-07, 1.30259938601, 518.6452648307],
                        [1.9252e-07, 1.31448491434, 543.0242872189],
                        [1.9704e-07, 4.90869636976, 909.8187330546],
                        [2.0801e-07, 0.91178207093, 76.4785195967],
                        [1.9876e-07, 0.66494008343, 66.70484372],
                        [1.8957e-07, 4.67998817036, 98.8999885246],
                        [2.5913e-07, 4.52903186569, 454.9093665273],
                        [2.1888e-07, 1.2337293174, 41.1019810544],
                        [1.8703e-07, 6.09640927844, 103.0927742186],
                        [1.8207e-07, 0.97283864525, 55.6591434561],
                        [2.1247e-07, 4.19373732137, 329.7251917809],
                        [1.9408e-07, 4.314682308, 6.2197751235],
                        [1.8497e-07, 5.78624335074, 142.4496501338],
                        [2.2588e-07, 5.84591645052, 297.6419215609],
                        [1.677e-07, 6.09084656811, 211.8146227297],
                        [1.6432e-07, 2.5000846902, 61.2882177486],
                        [2.0361e-07, 3.16137245375, 186.2117600641],
                        [1.5955e-07, 2.98317221345, 81.8951455681],
                        [1.8953e-07, 6.01226591746, 155.7829722581],
                        [1.7686e-07, 4.82613965176, 273.1028404783],
                        [1.5141e-07, 3.65588411561, 472.1748419147],
                        [1.844e-07, 3.47582817224, 36.6485629295],
                        [1.6303e-07, 0.13086415177, 554.0699874828],
                        [1.8633e-07, 0.23932740251, 23.5758732361],
                        [1.4352e-07, 2.69389896537, 70.1157321213],
                        [1.519e-07, 2.43789398875, 486.4019359163],
                        [1.4002e-07, 5.12389205028, 29.2049475286],
                        [1.5758e-07, 4.24947053051, 146.3818033969],
                        [1.4125e-07, 1.55719788547, 110.2063212194],
                        [1.7477e-07, 1.94549668506, 835.0371344873],
                        [1.3691e-07, 1.63831110442, 92.0470739547],
                        [1.3801e-07, 0.13721153975, 235.3904959658],
                        [1.3573e-07, 2.85427895075, 49.5088043018],
                        [1.2563e-07, 3.20921738646, 100.3844612329],
                        [1.239e-07, 2.88595800082, 60.5545045657],
                        [1.4986e-07, 0.32593957273, 259.5088859231],
                        [1.2922e-07, 2.77565630582, 105.4922706636],
                        [1.2323e-07, 3.36427641421, 440.6822725257],
                        [1.5233e-07, 0.2558984518, 258.8757464767],
                        [1.2106e-07, 0.10857558014, 157.6399519819],
                        [1.2883e-07, 0.30655541587, 124.2904028691],
                        [1.09e-07, 3.42905554547, 33.1371007917],
                        [1.1206e-07, 4.98840478043, 604.4725636619],
                        [1.0812e-07, 3.86253020441, 767.3690829208],
                        [1.1561e-07, 2.60450144944, 166.828672522],
                        [1.02e-07, 5.27810824796, 264.5048207692],
                        [1.0926e-07, 0.64149188846, 558.0021407459],
                        [1.2315e-07, 4.33998516461, 16.6747745564],
                        [9.946e-08, 0.67298666287, 31.492569389],
                        [1.2641e-07, 4.83194943583, 114.3991069134],
                        [1.0479e-07, 0.20404797652, 275.5505210331],
                        [1.1291e-07, 0.96120625051, 373.9079928365],
                        [1.2144e-07, 1.91712815063, 378.6432952517],
                        [1.2229e-07, 0.7046545467, 218.4069048687],
                        [1.0753e-07, 5.74480767273, 88.1149206916],
                        [9.481e-08, 0.65566927406, 353.301065017],
                        [1.1006e-07, 2.62953946665, 154.0166152595],
                        [9.113e-08, 2.99457723478, 681.5417840896],
                        [1.0429e-07, 2.33056994007, 132.8884225782],
                        [9.169e-08, 4.79284571455, 216.4804891757],
                        [9.341e-08, 0.75923548315, 129.9194771616],
                        [8.917e-08, 0.78008399009, 67.3592350258],
                        [8.757e-08, 6.12717748848, 150.5264049811],
                        [9.637e-08, 2.88664912193, 67.8804998876],
                        [1.0465e-07, 0.36943456465, 699.7010313543],
                        [9.301e-08, 1.49620591593, 19.643719973],
                        [9.367e-08, 5.26481516822, 80.7194894005],
                        [1.0076e-07, 3.56540311122, 278.5194664497],
                        [9.455e-08, 3.06088968751, 149.6750717192],
                        [9.168e-08, 3.02528121597, 162.0933701068],
                        [8.395e-08, 2.1845500165, 342.2553647531],
                        [9.233e-08, 5.32613442062, 152.0108776894],
                        [9.786e-08, 2.43713607191, 75.3028634291],
                        [1.0029e-07, 0.81917102953, 339.2864193365],
                        [9.429e-08, 1.93671715384, 147.1155165798],
                        [7.861e-08, 4.71717822837, 106.0135355254],
                        [8.813e-08, 0.01616162513, 42.5864537627],
                        [7.808e-08, 0.61104170424, 135.336103133],
                        [8.193e-08, 2.59644466423, 469.1364605289],
                        [1.0084e-07, 2.58619215129, 50.4025761791],
                        [8.574e-08, 5.69115937472, 760.25553592],
                        [7.525e-08, 2.64764195045, 5.9378908332],
                        [8.699e-08, 0.54050826161, 66.1835788582],
                        [8.027e-08, 1.94079002321, 180.2738692309],
                        [7.547e-08, 5.94593031762, 97.4155158163],
                        [7.597e-08, 5.80197738402, 450.9772132642],
                        [8.666e-08, 3.69933873164, 300.6108669775],
                        [7.685e-08, 1.47377256329, 32.2433289144],
                        [8.195e-08, 2.30769657654, 254.9435932136],
                        [8.473e-08, 1.27680705911, 39.3568759152],
                        [7.026e-08, 0.68091865104, 874.3940104025],
                        [8.898e-08, 0.16273040357, 43.1289704839],
                        [7.205e-08, 4.9817753104, 117.9105690512],
                        [7.389e-08, 4.09295183164, 92.3077063856],
                        [7.314e-08, 5.04313738379, 756.3233826569],
                        [8.454e-08, 1.22026161161, 79.4474650133],
                        [6.925e-08, 6.04100189247, 350.3321196004],
                        [8.793e-08, 1.33398658801, 48.7580447764],
                        [7.27e-08, 3.32609286227, 68.1893164283],
                        [6.825e-08, 4.77832275072, 142.6620984549],
                        [6.816e-08, 3.90452052962, 480.7728616238],
                        [7.062e-08, 1.27536949417, 68.5618234438],
                        [7.947e-08, 4.29940380231, 624.919432787],
                        [6.741e-08, 5.43264472273, 610.6923387854],
                        [6.529e-08, 5.43599941795, 88.7962442478],
                        [7.635e-08, 4.81180007736, 312.4597163935],
                        [7.235e-08, 3.18370421558, 268.4369740323],
                        [8.133e-08, 1.98936178361, 692.5874843535],
                        [6.477e-08, 1.05238958778, 685.4739373527],
                        [6.63e-08, 1.37656948077, 291.262087743],
                        [6.878e-08, 2.59188446778, 282.6640680339],
                        [7.123e-08, 5.79744758808, 468.2426886516],
                        [6.32e-08, 2.58497126634, 458.090760265],
                        [6.222e-08, 5.68982546821, 113.8778420516],
                        [7.635e-08, 0.49482302003, 296.1574488526],
                        [8.521e-08, 0.00576688485, 227.3137411185],
                        [6.52e-08, 3.99093726386, 42.5382696529],
                        [6.435e-08, 1.03721543102, 365.9006739584],
                        [6.107e-08, 0.35071886662, 148.5999892881],
                        [8.199e-08, 1.13448902886, 69.1525242748],
                        [6.102e-08, 0.94101111641, 13.3333221243],
                        [5.989e-08, 4.98445156102, 184.0941479094],
                        [6.355e-08, 0.16346166674, 228.276948965],
                        [7.955e-08, 4.03567630186, 183.2428146475],
                        [5.884e-08, 4.40842406038, 19.1224551112],
                        [5.938e-08, 5.40863870407, 17.5261078183],
                        [5.869e-08, 5.39494525133, 95.3885263868],
                        [5.775e-08, 2.81250784939, 121.8427223143],
                        [6.07e-08, 4.23605170027, 119.5069163441],
                        [6.349e-08, 3.52304701692, 285.6330134505],
                        [5.78e-08, 0.17831551537, 458.8415197904],
                        [5.674e-08, 4.16711163603, 89.7594520943],
                        [5.534e-08, 4.24741728108, 75.5323580927],
                        [5.648e-08, 2.81224199321, 154.979823106],
                        [6.939e-08, 3.31979953743, 306.830642101],
                        [5.682e-08, 4.79764449768, 248.7238180901],
                        [6.087e-08, 4.04640130992, 271.4059194489],
                        [6.869e-08, 1.34392408836, 7.8643065262],
                        [5.611e-08, 5.32955957046, 920.8644333185],
                        [6.495e-08, 0.45735814276, 106.2741679563],
                        [5.353e-08, 2.49825965802, 24.1183899573],
                        [6.612e-08, 5.24626646696, 58.319272332],
                        [5.552e-08, 0.24515487696, 173.6815870919],
                        [5.209e-08, 6.07866998675, 134.0640787458],
                        [5.176e-08, 3.69984512887, 778.4147831847],
                        [5.949e-08, 3.63204266272, 189.7232222019],
                        [6.36e-08, 0.35370738262, 411.620337349],
                        [5.147e-08, 1.55440402971, 193.655375465],
                        [6.436e-08, 5.18759014405, 120.9913890524],
                        [6.994e-08, 4.85978914075, 419.4846438752],
                        [5.323e-08, 0.50787742639, 16.4623262353],
                        [5.085e-08, 1.28917723765, 267.4737661858],
                        [5.993e-08, 4.70505267412, 298.2326223919],
                        [5.507e-08, 2.72405080404, 986.0848043302],
                        [6.163e-08, 1.87793216012, 397.3932433474],
                        [4.846e-08, 5.6671411571, 90.8232336773],
                        [4.875e-08, 1.24385851949, 25.6028626656],
                        [5.374e-08, 0.31175745933, 192.6921676185],
                        [5.262e-08, 1.85699096844, 114.9416236346],
                        [5.373e-08, 6.22242588334, 91.4563731237],
                        [5.05e-08, 3.39322756907, 831.1049812242],
                        [4.637e-08, 0.84958882655, 403.0223176399],
                        [6.382e-08, 2.77560901069, 198.321241911],
                        [4.685e-08, 4.94029403928, 902.7051860538],
                        [5.005e-08, 1.40309022449, 6.1503391543],
                        [5.014e-08, 5.57665259095, 451.9404211107],
                        [4.58e-08, 2.47734499363, 31.2319369581],
                        [5.129e-08, 3.2352870415, 109.3125493421],
                        [4.459e-08, 6.22635092697, 207.8824694666],
                        [5.734e-08, 0.96616252776, 483.2205421786],
                        [4.425e-08, 2.74721673213, 823.9914342234],
                        [4.575e-08, 1.87994871749, 44.7253177768],
                        [4.748e-08, 0.34902594832, 457.8783119439],
                        [4.268e-08, 4.89983575247, 124.5028511902],
                        [4.709e-08, 5.28612293112, 449.2802922348],
                        [5.761e-08, 2.09247769051, 187.6962327724],
                        [4.284e-08, 0.66132439268, 210.3301500214],
                        [4.318e-08, 1.68857333749, 309.2783226558],
                        [4.332e-08, 1.41872733238, 25.1297819136],
                        [4.305e-08, 1.05990546337, 606.7601855223],
                        [4.519e-08, 5.84384426255, 905.8865797915],
                        [3.934e-08, 0.417688973, 180.1619946463],
                        [3.973e-08, 3.22666150606, 639.897286314],
                        [4.871e-08, 4.61331971606, 258.0244132148],
                        [4.604e-08, 4.77631056831, 463.5073862364],
                        [3.943e-08, 3.31312639875, 107.4980082337],
                        [4.217e-08, 0.73383451512, 497.4476361802],
                        [4.057e-08, 1.67333716577, 7.4223635415],
                        [3.854e-08, 6.13547145503, 34.2008823747],
                        [4.617e-08, 5.89829880253, 303.8616966844],
                        [5.086e-08, 2.8523551874, 28.3111756513],
                        [5.337e-08, 2.36556705745, 477.8039162072],
                        [4.456e-08, 1.74674336635, 95.9792272178],
                        [4.138e-08, 3.80344455465, 460.5384408198],
                        [3.812e-08, 2.48508006441, 25.2727942655],
                        [4.732e-08, 0.87519409311, 255.0554677982],
                        [3.843e-08, 4.02615028031, 104.0077979553],
                        [3.776e-08, 2.89171052095, 27.0873353739],
                        [4.932e-08, 0.36238909407, 123.5396433437],
                        [4.371e-08, 3.74322467592, 376.1956146969],
                        [3.747e-08, 3.04126115463, 142.1408335931],
                        [4.232e-08, 4.31629167726, 446.3113468182],
                        [3.685e-08, 3.26448469664, 170.7608257851],
                        [3.575e-08, 4.31199276037, 572.2292347475],
                        [3.567e-08, 4.08542270507, 433.7117378768],
                        [4.496e-08, 2.10358455875, 838.218528225],
                        [3.505e-08, 3.5390238439, 520.129737539],
                        [3.524e-08, 3.75716903766, 473.068613792],
                        [3.962e-08, 5.33706246667, 43.2890291783],
                        [3.597e-08, 3.65066955203, 976.0023119128],
                        [3.487e-08, 2.12239114397, 316.3918696566],
                        [3.475e-08, 4.44351326599, 384.0599212231],
                        [3.628e-08, 2.11511417759, 73.1852512744],
                        [3.702e-08, 3.86923731076, 981.6313862053],
                        [3.687e-08, 5.18698183343, 993.198351331],
                        [3.599e-08, 2.07986409347, 47.6942631934],
                        [3.807e-08, 4.21821126511, 196.6243208816],
                        [4.707e-08, 4.56309173897, 47.061123747],
                        [4.312e-08, 0.38740046308, 988.532484885],
                        [3.867e-08, 2.08559458308, 457.3570470821],
                        [4.723e-08, 4.16947683948, 219.891377577],
                        [3.527e-08, 0.2037157647, 394.3548619616],
                        [3.644e-08, 5.82023483708, 586.3133163972],
                        [3.328e-08, 2.93840719007, 535.9107402181],
                        [3.321e-08, 4.19289134366, 114.1384744825],
                        [4.128e-08, 3.06165703109, 377.1588225434],
                        [3.545e-08, 4.41886084391, 1293.8786542777],
                        [3.295e-08, 2.97049569593, 15.1903018481],
                        [3.337e-08, 6.23473900765, 9947.0556815321],
                        [3.253e-08, 5.22412177835, 425.1137181677],
                        [3.677e-08, 5.31389484415, 141.6988906084],
                        [3.242e-08, 4.68868636498, 978.9712573294],
                        [3.266e-08, 3.57072306171, 17.2654753874],
                        [3.435e-08, 0.52794358986, 141.4864422873],
                        [3.242e-08, 2.62760698007, 6.592282139],
                        [3.613e-08, 1.94737668557, 661.0949149645],
                        [3.182e-08, 0.3660331511, 449.4927405559],
                        [3.311e-08, 1.25616383318, 233.9060232575],
                        [3.403e-08, 6.0379258317, 199.2844497575],
                        [4.196e-08, 4.26442082589, 381.6122406683],
                        [3.961e-08, 4.53281422377, 916.9322800554],
                        [3.846e-08, 3.76849990033, 8.5980197091],
                        [3.35e-08, 5.63661413371, 444.8268741099],
                        [3.78e-08, 5.35722293289, 328.2407190726],
                        [3.166e-08, 2.16351748263, 983.1158589136],
                        [3.538e-08, 1.89746744103, 280.9671470045],
                        [3.93e-08, 2.09444900058, 653.9813679637],
                        [3.282e-08, 1.91872815218, 2349.3284312038],
                        [3.269e-08, 0.52855777633, 450.4559484024],
                        [3.582e-08, 1.60170266832, 1587.5884225755],
                        [3.522e-08, 2.5178203618, 237.6781178262],
                        [3.024e-08, 3.54567524563, 94.4253185403],
                        [3.528e-08, 4.79818282081, 406.954470903],
                        [2.996e-08, 2.5915529362, 6133.5126528568],
                        [3.146e-08, 2.18094827839, 216.9224321604],
                        [3.61e-08, 6.15486273902, 171.6545976624],
                        [2.977e-08, 0.6947862817, 294.3004691288],
                        [3.377e-08, 1.21382647091, 162.8965192589],
                        [3.347e-08, 4.14981703949, 214.7835681463],
                        [2.953e-08, 2.18721777019, 597.3590166611],
                        [4.049e-08, 3.15153850922, 833.552661779],
                        [3.725e-08, 5.84743216544, 6058.7310542895],
                        [3.39e-08, 1.18412112871, 167.7224443993],
                        [3.142e-08, 2.26934209337, 517.1607921224],
                        [4.077e-08, 0.07273073033, 1190.0351205337],
                        [3.02e-08, 2.64998251178, 20.4468691251],
                        [3.926e-08, 1.41612569694, 346.1875180162],
                        [3.11e-08, 1.11431255827, 1044.4040766622],
                        [2.836e-08, 0.62522723719, 749.2098356561],
                        [2.831e-08, 4.78996738581, 820.0592809603],
                        [2.824e-08, 0.87232289414, 30.7106720963],
                        [3.114e-08, 1.79734939525, 414.0680179038],
                        [2.801e-08, 3.99301180541, 10063.7223490764],
                        [3.489e-08, 1.86982946081, 371.5297482509],
                        [3.725e-08, 1.68366366742, 683.9894646444],
                        [3.763e-08, 3.28247771799, 432.8179659995],
                        [3.493e-08, 0.98765698465, 9988.9407505091],
                        [3.523e-08, 5.12512607932, 105.380396079],
                        [2.839e-08, 4.22662576295, 990.2294059144],
                        [3.432e-08, 2.8048316223, 764.1876891831],
                        [2.733e-08, 0.42373696972, 354.9979860464],
                        [3.146e-08, 5.19208910201, 417.0369633204],
                        [3.041e-08, 5.75641149588, 409.9234163196],
                        [3.379e-08, 5.47448876584, 1396.2206689709],
                        [3.102e-08, 0.4168444478, 521.0929453855],
                        [2.863e-08, 0.41519700992, 894.8408795276],
                        [2.707e-08, 3.60084311477, 621.7380390493],
                        [3.128e-08, 5.23384180625, 424.1505103212],
                        [3.107e-08, 2.44919355737, 4.665866446],
                        [2.683e-08, 3.88682711832, 133.1008708993],
                        [2.66e-08, 4.78670985324, 362.8622925726],
                        [3.2e-08, 1.88004939357, 331.2096644892],
                        [2.73e-08, 4.12217979791, 600.5404103988],
                        [3.414e-08, 4.93712749827, 1140.38330388],
                        [2.653e-08, 5.10283251074, 118.0224436358],
                        [3.222e-08, 4.76521772319, 294.6729761443],
                        [3.289e-08, 4.26401031509, 544.5087599272],
                        [3.1e-08, 5.4792852793, 701.1855040626],
                        [2.785e-08, 5.19343849039, 144.8973306886],
                        [2.607e-08, 4.72531286187, 122.4758617607],
                        [2.581e-08, 6.27329466695, 908.3342603463],
                        [3.285e-08, 1.9597262267, 372.4235201282],
                        [2.897e-08, 0.3737809018, 582.3811631341],
                        [2.615e-08, 2.25516923974, 74.9940468884],
                        [3.582e-08, 1.27992264402, 987.5692770385],
                        [3.115e-08, 5.10929689813, 459.0539681115],
                        [2.857e-08, 5.90256930211, 525.2375469697],
                        [2.589e-08, 1.83177157032, 657.1627617014],
                        [2.539e-08, 4.14968938109, 74.7334144575],
                        [2.797e-08, 2.82242772664, 2036.8687148103],
                        [2.688e-08, 2.16500211397, 262.8078997398],
                        [2.744e-08, 1.54445470732, 28.5718080822],
                        [2.539e-08, 0.46036497385, 74.8297826771],
                        [3.322e-08, 3.50108539407, 82.6459050935],
                        [2.81e-08, 6.06709915335, 374.4986936675],
                        [2.504e-08, 3.523948017, 1183.6723330583],
                        [2.565e-08, 1.64023845161, 73.4090004436],
                        [2.531e-08, 3.50486296784, 293.188503436],
                        [2.663e-08, 4.23321349902, 421.1815649046],
                        [2.793e-08, 2.00644423849, 75.0422309982],
                        [2.43e-08, 1.56119387576, 136.0698163159],
                        [2.553e-08, 1.25909246207, 670.4960838257],
                        [2.604e-08, 3.87350462519, 74.0308390419],
                        [2.51e-08, 3.35948960782, 464.9918589447],
                        [3.005e-08, 0.81031349171, 73.88782669],
                        [3.11e-08, 6.14956891318, 118.8737768977],
                        [3.234e-08, 2.45751141361, 98.3574718034],
                        [2.774e-08, 6.26134027482, 1022.3126761344],
                        [2.402e-08, 4.38353347008, 1303.2798231389],
                        [3.296e-08, 3.84350963765, 511.5317178299],
                        [2.8e-08, 2.60339313269, 74.5209661364],
                        [3.005e-08, 0.76247280223, 75.6753704446],
                        [2.434e-08, 4.9478467943, 969.6224780949],
                        [2.632e-08, 0.635571102, 227.5261894396],
                        [2.669e-08, 0.7334022821, 73.0846775379],
                        [2.465e-08, 1.3064877338, 77.0692204277],
                        [3.237e-08, 3.19110274211, 1887.3055176757],
                        [2.395e-08, 2.76580569447, 768.8535556291],
                        [3.23e-08, 0.01981320255, 881.5075574033],
                        [2.747e-08, 5.59085990261, 388.7257876691],
                        [3.008e-08, 5.6595546366, 1969.2006632438],
                        [3.008e-08, 0.91409756228, 2118.7638603784],
                        [2.465e-08, 0.26629856014, 72.4939767069],
                        [2.629e-08, 4.00618677646, 26.0235537909],
                        [2.272e-08, 2.77069357315, 515.463871093],
                        [2.36e-08, 4.12736987374, 74.6215398729],
                        [2.255e-08, 3.3657444395, 286.596221297],
                        [2.211e-08, 5.18239546182, 59.2824801785],
                        [2.994e-08, 2.83179016989, 184.9879197867],
                        [2.492e-08, 1.19872353228, 383.0967133766],
                        [2.355e-08, 0.48259604722, 74.9416572617],
                        [2.185e-08, 6.0799711998, 63.6240237188],
                        [2.228e-08, 1.4245214891, 6219.339951688],
                      ],
          },
          {
            series => "R2",
            terms  => [
                        [0.00022439904, 0.6995311876, 74.7815985673],
                        [4.727037e-05, 1.69901641488, 63.7358983034],
                        [1.681903e-05, 4.64833551727, 70.8494453042],
                        [1.433755e-05, 3.52119917947, 149.5631971346],
                        [1.649559e-05, 3.0966007898, 11.0457002639],
                        [7.70188e-06, 0, 0],
                        [4.61009e-06, 0.76676632849, 3.9321532631],
                        [5.00429e-06, 6.17229032223, 76.2660712756],
                        [3.90371e-06, 4.49605283502, 56.6223513026],
                        [3.89945e-06, 5.52673426377, 85.8272988312],
                        [2.92097e-06, 0.20389012095, 52.6901980395],
                        [2.72898e-06, 3.84707823651, 138.5174968707],
                        [2.86579e-06, 3.5335768327, 73.297125859],
                        [2.05449e-06, 3.24758017121, 78.7137518304],
                        [2.19674e-06, 1.96418942891, 131.4039498699],
                        [2.15788e-06, 0.84812474187, 77.962992305],
                        [1.28834e-06, 2.08146849515, 3.1813937377],
                        [1.48554e-06, 4.89840863841, 127.4717966068],
                        [1.17452e-06, 4.93414907433, 447.7958195265],
                        [1.1269e-06, 1.01361852218, 462.0229135281],
                        [9.8875e-07, 6.15817742611, 224.3447957019],
                        [9.1379e-07, 0.67973399531, 18.1592472647],
                        [8.9217e-07, 0.23425778826, 202.2533951741],
                        [8.8206e-07, 2.93094837724, 62.2514255951],
                        [1.14066e-06, 4.7874187396, 145.6310438715],
                        [1.03858e-06, 3.58561789629, 71.6002048296],
                        [6.1819e-07, 3.29964272893, 351.8165923087],
                        [5.7782e-07, 4.90737420887, 22.0914005278],
                        [6.4369e-07, 3.39006689398, 1.4844727083],
                        [7.111e-07, 6.10490061068, 454.9093665273],
                        [5.099e-07, 3.86691997779, 65.2203710117],
                        [6.3537e-07, 3.96202309168, 67.6680515665],
                        [5.8957e-07, 5.55530463687, 9.5612275556],
                        [4.87e-07, 3.74709235789, 269.9214467406],
                        [4.3584e-07, 1.92568752002, 59.8037450403],
                        [4.217e-07, 2.61650997054, 151.0476698429],
                        [4.242e-07, 6.13634453301, 284.1485407422],
                        [4.434e-07, 5.89997845114, 71.8126531507],
                        [3.7328e-07, 5.91300114911, 984.6003316219],
                        [3.6201e-07, 5.40315761474, 77.7505439839],
                        [4.1989e-07, 2.09071623849, 12.5301729722],
                        [3.1411e-07, 4.59200004835, 148.0787244263],
                        [3.1289e-07, 2.26696307388, 195.1398481733],
                        [2.715e-07, 3.53242984046, 209.3669421749],
                        [2.8152e-07, 4.57845964163, 77.2292791221],
                        [2.6097e-07, 0.65978256272, 120.358249606],
                        [2.4372e-07, 5.86680440531, 69.3649725959],
                        [2.3037e-07, 1.03776963677, 84.3428261229],
                        [2.2679e-07, 1.7143424397, 160.6088973985],
                        [2.765e-07, 4.91488946525, 277.0349937414],
                        [2.0816e-07, 2.19643268155, 45.5766510387],
                        [1.9961e-07, 2.3207735618, 2.4476805548],
                        [1.6584e-07, 4.77529536873, 213.299095438],
                        [1.6578e-07, 1.85615182154, 340.7708920448],
                        [1.7196e-07, 4.36852462522, 54.1746707478],
                        [1.6053e-07, 3.64619586667, 152.7445908723],
                        [1.4806e-07, 5.43824503068, 408.4389436113],
                        [1.3872e-07, 3.38531100784, 358.9301393095],
                        [1.3328e-07, 5.25179190495, 137.0330241624],
                        [1.3286e-07, 1.26285812368, 134.5853436076],
                        [1.289e-07, 3.03270380745, 92.940845832],
                        [1.2467e-07, 1.33213558369, 51.2057253312],
                        [1.345e-07, 1.53176996919, 422.6660376129],
                        [1.6442e-07, 0.40190549188, 265.9892934775],
                        [1.1996e-07, 5.10426418352, 191.2076949102],
                        [1.2898e-07, 4.43242192513, 87.3117715395],
                        [1.1449e-07, 2.02645622099, 7.1135470008],
                        [1.1826e-07, 4.65645290272, 41.6444977756],
                        [1.2045e-07, 3.23910807852, 116.4260963429],
                        [1.168e-07, 3.73278249629, 220.4126424388],
                        [1.1573e-07, 4.16500659139, 60.5545045657],
                        [1.0175e-07, 0.32936886913, 70.3281804424],
                        [1.1332e-07, 1.07613885149, 72.3339180125],
                        [9.655e-08, 3.05950236129, 2.9689454166],
                        [9.279e-08, 2.43997351068, 565.1156877467],
                        [8.986e-08, 5.18839740735, 225.8292684102],
                        [1.0284e-07, 1.1860258206, 344.7030453079],
                        [8.844e-08, 6.00894470528, 5.4166259714],
                        [8.508e-08, 5.24741470216, 347.8844390456],
                        [8.319e-08, 3.71723808749, 14.977853527],
                        [8.276e-08, 2.27408171672, 299.1263942692],
                        [8.064e-08, 5.71681525179, 55.1378785943],
                        [7.83e-08, 0.90313686798, 222.8603229936],
                        [8.335e-08, 4.48600419464, 70.1157321213],
                        [8.763e-08, 5.8151944012, 153.4953503977],
                        [8.472e-08, 3.91387041805, 333.657345044],
                        [9.874e-08, 5.9652614366, 35.1640902212],
                        [9.647e-08, 0.38872626737, 415.5524906121],
                        [7.106e-08, 1.5059848847, 991.7138786227],
                        [6.596e-08, 1.18068235818, 96.8729990951],
                        [8.065e-08, 2.25930653257, 206.1855484372],
                        [6.479e-08, 2.99461362786, 380.12776796],
                        [9.012e-08, 6.0534362253, 146.3818033969],
                        [6.131e-08, 0.05596259493, 99.1606209555],
                        [5.799e-08, 0.82465326137, 142.4496501338],
                        [5.816e-08, 4.63029217647, 49.5088043018],
                        [5.608e-08, 0.66268449799, 58.1068240109],
                        [5.966e-08, 2.48916255408, 373.0142209592],
                        [5.71e-08, 2.23566160404, 80.1982245387],
                        [5.272e-08, 5.06746739956, 440.6822725257],
                        [5.162e-08, 4.36457872885, 977.4867846211],
                        [5.428e-08, 0.85181859845, 546.956440482],
                        [5.766e-08, 0.34229025692, 536.8045120954],
                        [5.924e-08, 5.48443563529, 76.4785195967],
                        [5.34e-08, 3.730731164, 23.5758732361],
                        [5.174e-08, 4.13873402677, 132.8884225782],
                        [5.31e-08, 6.14059082194, 39.6175083461],
                        [5.79e-08, 3.39593613152, 458.090760265],
                        [5.007e-08, 4.25821412289, 522.5774180938],
                        [4.967e-08, 4.79184817938, 387.2413149608],
                        [5.183e-08, 3.25775152471, 561.1835344836],
                        [4.602e-08, 1.69262282455, 152.5321425512],
                        [5.302e-08, 1.83522660093, 124.2904028691],
                        [5.005e-08, 0.3663056595, 60.7669528868],
                        [4.454e-08, 2.30288945184, 312.4597163935],
                        [4.457e-08, 0.45775730382, 33.1371007917],
                        [5.722e-08, 0.89523844278, 81.8951455681],
                        [5.842e-08, 0.92039543147, 20.6069278195],
                        [5.743e-08, 0.66226484448, 38.1330356378],
                        [4.255e-08, 3.55373860346, 479.2883889155],
                        [4.19e-08, 4.37674804409, 79.2350166922],
                        [4.194e-08, 1.6498626717, 128.9562693151],
                        [5.125e-08, 1.40553011416, 144.1465711632],
                        [4.045e-08, 6.07362424798, 19.643719973],
                        [3.984e-08, 5.7717840641, 288.0806940053],
                        [5.017e-08, 2.99521887648, 29.2049475286],
                        [3.842e-08, 2.60024827897, 426.598190876],
                        [3.861e-08, 3.19886211335, 159.1244246902],
                        [3.87e-08, 4.43713601497, 141.6988906084],
                        [5.316e-08, 4.07970979457, 111.4301614968],
                        [4.553e-08, 0.01384318412, 298.2326223919],
                        [3.737e-08, 5.28319518103, 353.301065017],
                        [3.939e-08, 5.27301148162, 521.0929453855],
                        [3.71e-08, 5.15385470848, 490.3340891794],
                        [4.039e-08, 0.60924359087, 152.0108776894],
                        [3.861e-08, 1.343943837, 535.3200393871],
                        [4.385e-08, 0.620576801, 827.1728279611],
                        [3.567e-08, 4.71986443303, 6.9010986797],
                        [3.576e-08, 3.24526237368, 230.5645708254],
                        [3.469e-08, 0.79054323335, 983.1158589136],
                        [4.524e-08, 2.86819565712, 129.9194771616],
                        [3.648e-08, 5.59395544992, 774.4826299216],
                        [3.513e-08, 4.49630054276, 376.1956146969],
                        [3.432e-08, 2.55614913808, 258.8757464767],
                        [4.352e-08, 2.09804374929, 404.5067903482],
                        [3.336e-08, 0.89628904042, 469.1364605289],
                        [3.274e-08, 3.86236880159, 42.5382696529],
                        [3.201e-08, 2.76459652868, 248.7238180901],
                        [3.184e-08, 0.07709843451, 1514.2912967165],
                        [3.783e-08, 5.29835962126, 369.0820676961],
                        [3.266e-08, 2.24754480216, 73.8183907208],
                        [3.055e-08, 2.60120354415, 433.7117378768],
                        [3.051e-08, 4.54953369151, 980.6681783588],
                        [3.062e-08, 1.27089879603, 200.7689224658],
                        [3.055e-08, 1.70878161343, 639.897286314],
                        [3.11e-08, 3.63187411723, 16.6747745564],
                        [3.472e-08, 4.93521260607, 411.620337349],
                        [3.531e-08, 4.49372794858, 881.5075574033],
                        [3.284e-08, 5.59170577331, 472.1748419147],
                        [3.015e-08, 6.02967446446, 291.262087743],
                        [3.467e-08, 2.17484439267, 554.0699874828],
                        [3.138e-08, 0.52367930477, 1094.8066528413],
                        [3.257e-08, 2.49339546514, 451.7279727896],
                        [2.881e-08, 0.50481204892, 305.3461693927],
                        [3.082e-08, 4.20145474081, 146.594251718],
                        [2.883e-08, 2.44983947531, 135.336103133],
                        [2.965e-08, 0.3929499553, 25.2727942655],
                        [2.831e-08, 2.52728803131, 867.2804634017],
                        [2.728e-08, 5.29491477549, 125.9873238985],
                        [2.857e-08, 4.71106805785, 218.9281697305],
                        [2.763e-08, 4.27510031656, 350.3321196004],
                        [2.73e-08, 1.98552777251, 82.8583534146],
                        [2.857e-08, 3.08706426922, 216.4804891757],
                        [3.365e-08, 3.67691210011, 661.0949149645],
                        [2.925e-08, 1.43646759644, 381.6122406683],
                        [2.753e-08, 0.39468041761, 33.6796175129],
                        [2.756e-08, 4.6267249884, 1357.6145525811],
                        [3.45e-08, 2.12911756067, 685.4739373527],
                        [2.571e-08, 5.92862393284, 89.7594520943],
                        [2.677e-08, 0.76342313946, 486.4019359163],
                        [2.689e-08, 4.16436463826, 235.3904959658],
                        [2.646e-08, 3.81808560938, 550.8885937451],
                        [3.369e-08, 3.17071565345, 108.4612160802],
                        [2.613e-08, 5.68333838067, 24.3790223882],
                        [2.736e-08, 1.87107584495, 529.6909650946],
                        [2.606e-08, 4.36605237304, 1080.5795588397],
                        [2.407e-08, 3.07343136742, 391.1734682239],
                        [2.446e-08, 5.7384638154, 535.9107402181],
                        [2.334e-08, 5.18878243102, 1059.3819301892],
                        [2.568e-08, 1.09886876369, 913.0001267923],
                        [2.236e-08, 6.10115874045, 140.001969579],
                        [3.053e-08, 5.35047433775, 681.5417840896],
                      ],
          },
          {
            series => "R3",
            terms  => [
                        [1.164382e-05, 4.73453291602, 74.7815985673],
                        [2.12367e-06, 3.34255734999, 63.7358983034],
                        [1.96408e-06, 2.98004616318, 70.8494453042],
                        [1.04527e-06, 0.95807937648, 11.0457002639],
                        [7.1681e-07, 0.02528455665, 56.6223513026],
                        [7.254e-07, 0.99701907912, 149.5631971346],
                        [5.4875e-07, 2.59436811267, 3.9321532631],
                        [3.4029e-07, 3.81553325635, 76.2660712756],
                        [3.2081e-07, 3.5982517784, 131.4039498699],
                        [2.9641e-07, 3.44111535957, 85.8272988312],
                        [3.6377e-07, 5.65035573017, 77.962992305],
                        [2.7663e-07, 0.4283600147, 3.1813937377],
                        [2.7464e-07, 2.55126467481, 52.6901980395],
                        [2.4569e-07, 5.14034173566, 78.7137518304],
                        [1.939e-07, 5.13477648625, 18.1592472647],
                        [1.5767e-07, 0.37116951743, 447.7958195265],
                        [1.5441e-07, 5.57271837433, 462.0229135281],
                        [1.5232e-07, 3.85998573509, 73.297125859],
                        [1.5475e-07, 2.97496547327, 145.6310438715],
                        [1.7951e-07, 0, 0],
                        [1.5958e-07, 5.19915553904, 71.6002048296],
                        [1.1056e-07, 6.03152659562, 138.5174968707],
                        [1.0529e-07, 3.58261852497, 224.3447957019],
                        [7.606e-08, 1.44542030704, 1.4844727083],
                        [8.121e-08, 2.61579604319, 22.0914005278],
                        [7.107e-08, 5.43946774526, 269.9214467406],
                        [6.459e-08, 4.37142319461, 284.1485407422],
                        [6.818e-08, 0.01396812984, 151.0476698429],
                        [8.101e-08, 0.29563819537, 127.4717966068],
                        [5.768e-08, 4.22672716593, 373.0142209592],
                        [5.022e-08, 1.84154937974, 202.2533951741],
                        [4.692e-08, 2.7840457544, 120.358249606],
                        [5.087e-08, 0.77745294804, 62.2514255951],
                        [4.16e-08, 1.83820502779, 72.3339180125],
                        [3.922e-08, 1.88900691473, 209.3669421749],
                        [5.201e-08, 4.15791319343, 195.1398481733],
                        [3.636e-08, 1.99709010456, 65.2203710117],
                        [3.582e-08, 3.92592140377, 124.2904028691],
                        [3.808e-08, 1.04818660873, 92.940845832],
                        [4.241e-08, 3.95755998904, 9.5612275556],
                        [3.497e-08, 1.54139696251, 148.0787244263],
                        [3.195e-08, 2.98608971329, 387.2413149608],
                        [3.95e-08, 1.85721204932, 152.7445908723],
                        [3.277e-08, 1.40881404192, 351.8165923087],
                        [3.605e-08, 1.17366167402, 153.4953503977],
                        [2.94e-08, 6.03594958459, 12.5301729722],
                        [2.744e-08, 5.64674283515, 134.5853436076],
                        [2.8e-08, 0.79480255927, 572.2292347475],
                        [3.054e-08, 5.84310939105, 160.6088973985],
                        [2.662e-08, 1.98593312104, 450.9772132642],
                        [2.7e-08, 2.77036653988, 213.299095438],
                        [2.323e-08, 1.67918985468, 358.9301393095],
                        [2.254e-08, 5.77129530133, 84.3428261229],
                        [2.291e-08, 4.814246016, 536.8045120954],
                        [2.213e-08, 2.20360299816, 465.9550667912],
                      ],
          },
          {
            series => "R4",
            terms  => [
                        [5.2996e-07, 3.00838033088, 74.7815985673],
                        [9.887e-08, 1.91399083603, 56.6223513026],
                        [7.008e-08, 5.08677527404, 11.0457002639],
                        [6.728e-08, 5.42924958121, 149.5631971346],
                        [3.703e-08, 5.22728581851, 131.4039498699],
                        [3.361e-08, 1.29695290266, 85.8272988312],
                        [2.664e-08, 0.44064577837, 63.7358983034],
                        [2.309e-08, 0.92380720934, 145.6310438715],
                        [2.383e-08, 6.21390585593, 358.9301393095],
                        [2.288e-08, 2.23425399117, 440.6822725257],
                        [3.093e-08, 3.14159265359, 0],
                      ],
          },
        ],
      ],
      name => "VSOP87D",
      order => 7,
      sidereal_period => 2651483951.679,
      tropical_period => 2642867164.306,
    }->{$key};
}

1;

__END__

=head1 NAME

Astro::Coord::ECI::VSOP87D::Uranus - VSOP87D model of the position of Uranus

=head1 SYNOPSIS

 use Astro::Coord::ECI::VSOP87D::Uranus;
 use Astro::Coord::ECI::Utils qw{ deg2rad };
 use POSIX qw{ strftime };
 use Time::Local qw{ localtime };
 
 my $station = Astro::Coord::ECI->new(
     name => 'White House',
 )->geodetic(
     deg2rad( 38.899 ),  # radians
     deg2rad( -77.038 ), # radians
     16.68/1000,         # Kilometers
 );
 my $venus = Astro::Coord::ECI::VSOP87D::Uranus->new(
     station => $station,
 );
 my $today = timelocal( 0, 0, 0, ( localtime )[ 3 .. 5 ] );
 foreach my $item ( $venus->almanac( $today, $today + 86400 ) ) {
     local $\ = "\n";
     print strftime( '%d-%b-%Y %H:%M:%S', localtime $item->[0] ),
         $item->[3];
 }

=head1 DESCRIPTION

This Perl class computes the position of Uranus using the VSOP87D
model. It is a subclass of
L<Astro::Coord::ECI::VSOP87D::_Superior|Astro::Coord::ECI::VSOP87D::_Superior>.

=head1 METHODS

This class supports no additional public methods.

=head2 ATTRIBUTES

This class has no additional attributes.

=head1 SEE ALSO

L<Astro::Coord::ECI|Astro::Coord::ECI>

L<Astro::Coord::ECI::VSOP87D|Astro::Coord::ECI::VSOP87D>

=head1 SUPPORT

Support is by the author. Please file bug reports at
L<http://rt.cpan.org>, or in electronic mail to the author.

=head1 AUTHOR

Thomas R. Wyant, III F<wyant at cpan dot org>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2018-2020 by Thomas R. Wyant, III

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl 5.10.0. For more details, see the full text
of the licenses in the directory LICENSES.

This program is distributed in the hope that it will be useful, but
without any warranty; without even the implied warranty of
merchantability or fitness for a particular purpose.

=cut

# ex: set filetype=perl textwidth=72 :
