# This file was autogenerated.
use 5.008008;
use strict;
use warnings;

use Test::More 0.96;
use Test::Fatal;

use Hydrogen::Topic::Bool;

isa_ok( 'Hydrogen::Topic::Bool', 'Exporter::Tiny' );

my %EXPORTS = map +( $_ => 1 ), @Hydrogen::Topic::Bool::EXPORT_OK;

subtest 'not' => sub {
    ok exists(&Hydrogen::Topic::Bool::not), 'function exists';
    ok $EXPORTS{'not'}, 'function is importable';
    my $e = exception {
        local $_;
        $_ = 1;
        ok( !(Hydrogen::Topic::Bool::not()), q{Hydrogen::Topic::Bool::not() is false} );
    };
    is $e, undef, 'no exception thrown running not example';
};

subtest 'reset' => sub {
    ok exists(&Hydrogen::Topic::Bool::reset), 'function exists';
    ok $EXPORTS{'reset'}, 'function is importable';
};

subtest 'set' => sub {
    ok exists(&Hydrogen::Topic::Bool::set), 'function exists';
    ok $EXPORTS{'set'}, 'function is importable';
    my $e = exception {
        local $_;
        $_ = !!0;
        Hydrogen::Topic::Bool::set();
        ok( $_, q{$_ is true} );
    };
    is $e, undef, 'no exception thrown running set example';
};

subtest 'toggle' => sub {
    ok exists(&Hydrogen::Topic::Bool::toggle), 'function exists';
    ok $EXPORTS{'toggle'}, 'function is importable';
    my $e = exception {
        local $_;
        $_ = !!0;
        Hydrogen::Topic::Bool::toggle();
        ok( $_, q{$_ is true} );
        Hydrogen::Topic::Bool::toggle();
        ok( !($_), q{$_ is false} );
    };
    is $e, undef, 'no exception thrown running toggle example';
};

subtest 'unset' => sub {
    ok exists(&Hydrogen::Topic::Bool::unset), 'function exists';
    ok $EXPORTS{'unset'}, 'function is importable';
    my $e = exception {
        local $_;
        $_ = !!0;
        Hydrogen::Topic::Bool::unset();
        ok( !($_), q{$_ is false} );
    };
    is $e, undef, 'no exception thrown running unset example';
};

# :)
done_testing;
