#!/usr/bin/perl
use 5.012;
use lib 'blib/lib', 'blib/arch';
use Benchmark qw/timethis timethese/;
use Encode::Base2N qw/encode_base64 encode_base64url encode_base32 encode_base16 decode_base64 decode_base32 decode_base16/;
use Devel::Peek;
use MIME::Base64();
use Storable qw/freeze/;
use MIME::Base32(); 

say "START";

say encode_base16('suka');
say decode_base16(encode_base16('suka'));

my $str = join('', map {chr($_)} 0..255);
my $enc = encode_base16($str);
say $enc;

if (0) {
    my $a = "abcdefghijklmnopqrstuvwxyz234567";
    my $b = "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567";

    my @p;
    $#p = 255;

    foreach my $s ($a, $b) {
        my @arr = split //, $s;
        for (my $i = 0; $i < @arr; $i++) {
            $p[ord($arr[$i])] = $i;
        }
    }
    
    for (my $i = 0; $i < @p; $i++) {
        print defined($p[$i]) ? $p[$i] : 'XX';
        print ",";
        print " " unless ($i+1) % 4;
        print "\n" unless ($i+1) % 16;
    } 
}

my $tiny = 'hello';
my $short = 'hello world hello world hello world hello world hello world';
my $long = 'hello ' x 1000;

my $bin = join('', map {chr($_)} 0..255);

my $TINY = encode_base32($tiny);
my $SHORT = encode_base32($short);
my $LONG = encode_base32($long);
timethese(-1, {
    e_panda32_tiny   => sub { encode_base32($tiny) },
    e_panda32_short  => sub { encode_base32($short) },
    e_panda32_long   => sub { encode_base32($long) },
    d_panda32_tiny   => sub { decode_base32($TINY) },
    d_panda32_short  => sub { decode_base32($SHORT) },
    d_panda32_long   => sub { decode_base32($LONG) },
#    e_base32_tiny    => sub { MIME::Base32::encode($tiny) },
#    e_base32_short   => sub { MIME::Base32::encode($short) },
#    e_base32_long    => sub { MIME::Base32::encode($long) },
#    d_base32_tiny    => sub { MIME::Base32::decode($TINY) },
#    d_base32_short   => sub { MIME::Base32::decode($SHORT) },
#    d_base32_long    => sub { MIME::Base32::decode($LONG) },
});

$TINY = encode_base64($tiny);
$SHORT = encode_base64($short);
$LONG = encode_base64($long);
timethese(-1, {
    e_panda64_tiny   => sub { encode_base64($tiny) },
    e_panda64_short  => sub { encode_base64($short) },
    e_panda64_long   => sub { encode_base64($long) },
    d_panda64_tiny   => sub { decode_base64($TINY) },
    d_panda64_short  => sub { decode_base64($SHORT) },
    d_panda64_long   => sub { decode_base64($LONG) },
#    e_base64_tiny    => sub { MIME::Base64::encode_base64($tiny) },
#    e_base64_short   => sub { MIME::Base64::encode_base64($short) },
#    e_base64_long    => sub { MIME::Base64::encode_base64($long) },
#    d_base64_tiny    => sub { MIME::Base64::decode_base64($TINY) },
#    d_base64_short   => sub { MIME::Base64::decode_base64($SHORT) },
#    d_base64_long    => sub { MIME::Base64::decode_base64($LONG) },
});

$TINY = encode_base64url($tiny);
$SHORT = encode_base64url($short);
$LONG = encode_base64url($long);
timethese(-1, {
    e_panda64u_tiny   => sub { encode_base64url($tiny) },
    e_panda64u_short  => sub { encode_base64url($short) },
    e_panda64u_long   => sub { encode_base64url($long) },
    d_panda64u_tiny   => sub { decode_base64($TINY) },
    d_panda64u_short  => sub { decode_base64($SHORT) },
    d_panda64u_long   => sub { decode_base64($LONG) },
#    e_base64u_tiny    => sub { MIME::Base64::encode_base64url($tiny) },
#    e_base64u_short   => sub { MIME::Base64::encode_base64url($short) },
#    e_base64u_long    => sub { MIME::Base64::encode_base64url($long) },
#    d_base64u_tiny    => sub { MIME::Base64::decode_base64url($TINY) },
#    d_base64u_short   => sub { MIME::Base64::decode_base64url($SHORT) },
#    d_base64u_long    => sub { MIME::Base64::decode_base64url($LONG) },
});


$TINY = encode_base16($tiny);
$SHORT = encode_base16($short);
$LONG = encode_base16($long);
timethese(-1, {
    e_panda16_tiny   => sub { encode_base16($tiny) },
    e_panda16_short  => sub { encode_base16($short) },
    e_panda16_long   => sub { encode_base16($long) },
    d_panda16_tiny   => sub { decode_base16($TINY) },
    d_panda16_short  => sub { decode_base16($SHORT) },
    d_panda16_long   => sub { decode_base16($LONG) },
});
