#!/usr/bin/perl

use v5.14;
use warnings;

use Future::AsyncAwait;

use Test::More;
use Test::Future::IO;

use Electronics::PSU::DPSxxxx;

my $test_fio = Test::Future::IO->controller;

my $psu = Electronics::PSU::DPSxxxx->new( fh => "FH" );

# Read model/version
{
   $test_fio->expect_syswrite( "\x01\x03\x00\x0B\x00\x01\xF5\xC8" );
   $test_fio->expect_sysread( 7 )
      ->returns( "\x01\x03\x02\x0B\xBD\x7F\x05" );

   is( await $psu->read_model, 3005, '$psu->read_model yields model' );

   $test_fio->check_and_clear( '->read_model' );

   $test_fio->expect_syswrite( "\x01\x03\x00\x0C\x00\x01\x44\x09" );
   $test_fio->expect_sysread( 7 )
      ->returns( "\x01\x03\x02\x00\x0E\x39\x80" );

   is( await $psu->read_version, 14, '$psu->read_version yields version' );

   $test_fio->check_and_clear( '->read_version' );
}

# Read UIN
{
   $test_fio->expect_syswrite( "\x01\x03\x00\x05\x00\x01\x94\x0B" );
   $test_fio->expect_sysread( 7 )
      ->returns( "\x01\x03\x02\x09\x93\xFE\x79" );

   is( await $psu->measure_input_voltage, 24.51, '$psu->measure_input_voltage yields voltage' );

   $test_fio->check_and_clear( '->measure_input_voltage' );
}

# Set output settings
{
   $test_fio->expect_syswrite( "\x01\x06\x00\x00\x03\xFF\xC9\x7A" );
   $test_fio->expect_sysread( 8 )
      ->returns( "\x01\x06\x00\x01\x01\xC8\xD8\x0C" );
   $test_fio->expect_syswrite( "\x01\x06\x00\x01\x01\xC8\xD8\x0C" );
   $test_fio->expect_sysread( 8 )
      ->returns( "\x01\x06\x00\x01\x01\xC8\xD8\x0C" );

   await $psu->set_voltage( 10.23 );
   await $psu->set_current( 0.456 );

   $test_fio->check_and_clear( '->set_voltage / ->set_current' );

   $test_fio->expect_syswrite( "\x01\x06\x00\x09\x00\x01\x98\x08" );
   $test_fio->expect_sysread( 8 )
      ->returns( "\x01\x06\x00\x09\x00\x01\x98\x08" );

   await $psu->set_output_state( 1 );

   $test_fio->check_and_clear( '->set_output_state' );
}

# Measure output
{
   $test_fio->expect_syswrite( "\x01\x03\x00\x02\x00\x01\x25\xCA" );
   $test_fio->expect_sysread( 7 )
      ->returns( "\x01\x03\x02\x03\xFE\x39\x34" );
   $test_fio->expect_syswrite( "\x01\x03\x00\x03\x00\x01\x74\x0A" );
   $test_fio->expect_sysread( 7 )
      ->returns( "\x01\x03\x02\x00\x18\xB8\x4E" );

   is( await $psu->measure_output_voltage, 10.22, '->measure_output_voltage yields voltage' );
   is( await $psu->measure_output_current, 0.024, '->measure_output_current yields current' );

   $test_fio->check_and_clear( '->measure_output_voltage / ->measure_output_current' );
}

done_testing;
