#########################################################################################
# Package        HiPi::Interface::MonoOLED::Font::SansExtended23
# Description  : Monochrome OLED Font
# License      : This is free software; you can redistribute it and/or modify it under
#                the same terms as the Perl 5 programming language system itself.
#########################################################################################

package HiPi::Interface::MonoOLED::Font::SansExtended23;

#########################################################################################

use utf8;
use strict;
use warnings;
use parent qw( HiPi::Interface::MonoOLED::Font);

our $VERSION ='0.70';

my $gap_width = 0;
my $char_height = 23;
my $line_spacing = 0;
my $name = 'Sans 23';
my $space_width = 6;
 
my $symbols = {
    '33' => {    # '!'
        'width'    => 2, 
        'xoffset'  => 3, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0x00, ##    
            0x00, ##    
            0x00, ##    
            0x00, ##    
            0xC0, ##  00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '34' => {    # '"'
        'width'    => 6, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xCC, ##  00  00
            0xCC, ##  00  00
            0xCC, ##  00  00
            0xCC, ##  00  00
            0xCC, ##  00  00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '35' => {    # '#'
        'width'    => 14, 
        'xoffset'  => 2, 
        'xadvance' => 18, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x02, 0x30, ##        0   00  
            0x06, 0x30, ##       00   00  
            0x06, 0x20, ##       00   0   
            0x04, 0x60, ##       0   00   
            0x7F, 0xFC, ##   0000000000000
            0x0C, 0x40, ##      00   0    
            0x0C, 0x40, ##      00   0    
            0x08, 0xC0, ##      0   00    
            0x08, 0xC0, ##      0   00    
            0xFF, 0xF8, ##  0000000000000 
            0x18, 0x80, ##     00   0     
            0x11, 0x80, ##     0   00     
            0x31, 0x80, ##    00   00     
            0x31, 0x00, ##    00   0      
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '36' => {    # '$'
        'width'    => 9, 
        'xoffset'  => 2, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x08, 0x00, ##      0    
            0x08, 0x00, ##      0    
            0x08, 0x00, ##      0    
            0x3F, 0x00, ##    000000 
            0xE9, 0x00, ##  000 0  0 
            0xC8, 0x00, ##  00  0    
            0xC8, 0x00, ##  00  0    
            0xE8, 0x00, ##  000 0    
            0x7C, 0x00, ##   00000   
            0x0F, 0x00, ##      0000 
            0x0B, 0x80, ##      0 000
            0x09, 0x80, ##      0  00
            0x09, 0x80, ##      0  00
            0x8B, 0x00, ##  0   0 00 
            0x7E, 0x00, ##   000000  
            0x08, 0x00, ##      0    
            0x08, 0x00, ##      0    
            0x08, 0x00, ##      0    
            0x00, 0x00, ##  
        ], 
    }, 
    '37' => {    # '%'
        'width'    => 17, 
        'xoffset'  => 1, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x38, 0x08, 0x00, ##    000       0    
            0xEC, 0x18, 0x00, ##  000 00     00    
            0xC6, 0x10, 0x00, ##  00   00    0     
            0xC6, 0x20, 0x00, ##  00   00   0      
            0xC6, 0x60, 0x00, ##  00   00  00      
            0xCE, 0x40, 0x00, ##  00  000  0       
            0x78, 0xCE, 0x00, ##   0000   00  000  
            0x00, 0x9B, 0x00, ##          0  00 00 
            0x01, 0x31, 0x80, ##         0  00   00
            0x03, 0x31, 0x80, ##        00  00   00
            0x02, 0x31, 0x80, ##        0   00   00
            0x04, 0x31, 0x80, ##       0    00   00
            0x0C, 0x1B, 0x00, ##      00     00 00 
            0x08, 0x0E, 0x00, ##      0       000  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '38' => {    # '&'
        'width'    => 14, 
        'xoffset'  => 1, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0F, 0x80, ##      00000     
            0x18, 0x80, ##     00   0     
            0x30, 0x00, ##    00          
            0x30, 0x00, ##    00          
            0x38, 0x00, ##    000         
            0x18, 0x00, ##     00         
            0x3C, 0x00, ##    0000        
            0x66, 0x18, ##   00  00    00 
            0xC3, 0x18, ##  00    00   00 
            0xC1, 0xB0, ##  00     00 00  
            0xC0, 0xF0, ##  00      0000  
            0xC0, 0x60, ##  00       00   
            0x70, 0xF0, ##   000    0000  
            0x1F, 0x18, ##     00000   00 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '39' => {    # '''
        'width'    => 2, 
        'xoffset'  => 2, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '40' => {    # '('
        'width'    => 5, 
        'xoffset'  => 2, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x10, ##     0 
            0x30, ##    00 
            0x20, ##    0  
            0x60, ##   00  
            0x60, ##   00  
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0x40, ##   0   
            0x60, ##   00  
            0x60, ##   00  
            0x30, ##    00 
            0x30, ##    00 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '41' => {    # ')'
        'width'    => 5, 
        'xoffset'  => 1, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x40, ##   0   
            0x60, ##   00  
            0x20, ##    0  
            0x30, ##    00 
            0x30, ##    00 
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x10, ##     0 
            0x30, ##    00 
            0x30, ##    00 
            0x60, ##   00  
            0x60, ##   00  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '42' => {    # '*'
        'width'    => 9, 
        'xoffset'  => 0, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x08, 0x00, ##      0    
            0x08, 0x00, ##      0    
            0xC9, 0x80, ##  00  0  00
            0x3E, 0x00, ##    00000  
            0x08, 0x00, ##      0    
            0x3E, 0x00, ##    00000  
            0xC9, 0x80, ##  00  0  00
            0x08, 0x00, ##      0    
            0x08, 0x00, ##      0    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '43' => {    # '+'
        'width'    => 13, 
        'xoffset'  => 2, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x06, 0x00, ##       00      
            0x06, 0x00, ##       00      
            0x06, 0x00, ##       00      
            0x06, 0x00, ##       00      
            0x06, 0x00, ##       00      
            0xFF, 0xF8, ##  0000000000000
            0x06, 0x00, ##       00      
            0x06, 0x00, ##       00      
            0x06, 0x00, ##       00      
            0x06, 0x00, ##       00      
            0x06, 0x00, ##       00      
            0x06, 0x00, ##       00      
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '44' => {    # ','
        'width'    => 3, 
        'xoffset'  => 1, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x60, ##   00
            0x60, ##   00
            0x40, ##   0 
            0xC0, ##  00 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '45' => {    # '-'
        'width'    => 5, 
        'xoffset'  => 1, 
        'xadvance' => 7, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF8, ##  00000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '46' => {    # '.'
        'width'    => 2, 
        'xoffset'  => 2, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xC0, ##  00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '47' => {    # '/'
        'width'    => 7, 
        'xoffset'  => 0, 
        'xadvance' => 7, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x06, ##       00
            0x04, ##       0 
            0x0C, ##      00 
            0x0C, ##      00 
            0x08, ##      0  
            0x18, ##     00  
            0x18, ##     00  
            0x10, ##     0   
            0x30, ##    00   
            0x30, ##    00   
            0x20, ##    0    
            0x60, ##   00    
            0x60, ##   00    
            0x40, ##   0     
            0xC0, ##  00     
            0xC0, ##  00     
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '48' => {    # '0'
        'width'    => 10, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1E, 0x00, ##     0000   
            0x33, 0x00, ##    00  00  
            0x61, 0x80, ##   00    00 
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0x61, 0x80, ##   00    00 
            0x33, 0x00, ##    00  00  
            0x1E, 0x00, ##     0000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '49' => {    # '1'
        'width'    => 8, 
        'xoffset'  => 3, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF8, ##  00000   
            0xF8, ##  00000   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0xFF, ##  00000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '50' => {    # '2'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFE, 0x00, ##  0000000  
            0xC3, 0x00, ##  00    00 
            0x01, 0x80, ##         00
            0x01, 0x80, ##         00
            0x01, 0x80, ##         00
            0x03, 0x80, ##        000
            0x03, 0x00, ##        00 
            0x07, 0x00, ##       000 
            0x0E, 0x00, ##      000  
            0x1C, 0x00, ##     000   
            0x38, 0x00, ##    000    
            0x70, 0x00, ##   000     
            0xE0, 0x00, ##  000      
            0xFF, 0x80, ##  000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '51' => {    # '3'
        'width'    => 9, 
        'xoffset'  => 2, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFE, 0x00, ##  0000000  
            0x83, 0x00, ##  0     00 
            0x01, 0x80, ##         00
            0x01, 0x80, ##         00
            0x01, 0x80, ##         00
            0x03, 0x00, ##        00 
            0x3C, 0x00, ##    0000   
            0x03, 0x00, ##        00 
            0x01, 0x80, ##         00
            0x01, 0x80, ##         00
            0x01, 0x80, ##         00
            0x01, 0x80, ##         00
            0x03, 0x00, ##        00 
            0xFC, 0x00, ##  000000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '52' => {    # '4'
        'width'    => 10, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x07, 0x00, ##       000  
            0x0F, 0x00, ##      0000  
            0x0B, 0x00, ##      0 00  
            0x1B, 0x00, ##     00 00  
            0x33, 0x00, ##    00  00  
            0x23, 0x00, ##    0   00  
            0x63, 0x00, ##   00   00  
            0xC3, 0x00, ##  00    00  
            0x83, 0x00, ##  0     00  
            0xFF, 0xC0, ##  0000000000
            0x03, 0x00, ##        00  
            0x03, 0x00, ##        00  
            0x03, 0x00, ##        00  
            0x03, 0x00, ##        00  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '53' => {    # '5'
        'width'    => 9, 
        'xoffset'  => 2, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0x00, ##  00000000 
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xFC, 0x00, ##  000000   
            0x87, 0x00, ##  0    000 
            0x03, 0x80, ##        000
            0x01, 0x80, ##         00
            0x01, 0x80, ##         00
            0x01, 0x80, ##         00
            0x03, 0x80, ##        000
            0x07, 0x00, ##       000 
            0xFC, 0x00, ##  000000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '54' => {    # '6'
        'width'    => 10, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1F, 0x80, ##     000000 
            0x30, 0x80, ##    00    0 
            0x60, 0x00, ##   00       
            0x40, 0x00, ##   0        
            0xC0, 0x00, ##  00        
            0xDF, 0x00, ##  00 00000  
            0xF1, 0x80, ##  0000   00 
            0xE0, 0xC0, ##  000     00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0x60, 0xC0, ##   00     00
            0x21, 0x80, ##    0    00 
            0x1F, 0x00, ##     00000  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '55' => {    # '7'
        'width'    => 9, 
        'xoffset'  => 2, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0x80, ##  000000000
            0x01, 0x80, ##         00
            0x03, 0x00, ##        00 
            0x03, 0x00, ##        00 
            0x07, 0x00, ##       000 
            0x06, 0x00, ##       00  
            0x06, 0x00, ##       00  
            0x0C, 0x00, ##      00   
            0x0C, 0x00, ##      00   
            0x0C, 0x00, ##      00   
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x38, 0x00, ##    000    
            0x30, 0x00, ##    00     
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '56' => {    # '8'
        'width'    => 10, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x3F, 0x00, ##    000000  
            0x61, 0x80, ##   00    00 
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0x61, 0x80, ##   00    00 
            0x1E, 0x00, ##     0000   
            0x61, 0x80, ##   00    00 
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0x61, 0x80, ##   00    00 
            0x3F, 0x00, ##    000000  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '57' => {    # '9'
        'width'    => 10, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x3E, 0x00, ##    00000   
            0x63, 0x00, ##   00   00  
            0xC1, 0x80, ##  00     00 
            0xC0, 0x80, ##  00      0 
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC1, 0xC0, ##  00     000
            0x63, 0xC0, ##   00   0000
            0x3E, 0xC0, ##    00000 00
            0x00, 0xC0, ##          00
            0x00, 0x80, ##          0 
            0x01, 0x80, ##         00 
            0x43, 0x00, ##   0    00  
            0x7E, 0x00, ##   000000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '58' => {    # ':'
        'width'    => 2, 
        'xoffset'  => 2, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xC0, ##  00
            0x00, ##    
            0x00, ##    
            0x00, ##    
            0x00, ##    
            0x00, ##    
            0x00, ##    
            0x00, ##    
            0xC0, ##  00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '59' => {    # ';'
        'width'    => 3, 
        'xoffset'  => 1, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x60, ##   00
            0x00, ##     
            0x00, ##     
            0x00, ##     
            0x00, ##     
            0x00, ##     
            0x00, ##     
            0x00, ##     
            0x60, ##   00
            0x60, ##   00
            0x40, ##   0 
            0xC0, ##  00 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '60' => {    # '<'
        'width'    => 13, 
        'xoffset'  => 2, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x38, ##            000
            0x01, 0xF0, ##         00000 
            0x0F, 0x80, ##      00000    
            0x3C, 0x00, ##    0000       
            0xE0, 0x00, ##  000          
            0xF0, 0x00, ##  0000         
            0x3E, 0x00, ##    00000      
            0x07, 0xC0, ##       00000   
            0x00, 0xF8, ##          00000
            0x00, 0x18, ##             00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '61' => {    # '='
        'width'    => 13, 
        'xoffset'  => 2, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xF8, ##  0000000000000
            0x00, 0x00, ##               
            0x00, 0x00, ##               
            0x00, 0x00, ##               
            0xFF, 0xF8, ##  0000000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '62' => {    # '>'
        'width'    => 13, 
        'xoffset'  => 2, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xE0, 0x00, ##  000          
            0xF8, 0x00, ##  00000        
            0x1F, 0x00, ##     00000     
            0x03, 0xE0, ##        00000  
            0x00, 0x78, ##           0000
            0x00, 0xF8, ##          00000
            0x07, 0xC0, ##       00000   
            0x3E, 0x00, ##    00000      
            0xF0, 0x00, ##  0000         
            0xC0, 0x00, ##  00           
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '63' => {    # '?'
        'width'    => 7, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF8, ##  00000  
            0x8C, ##  0   00 
            0x06, ##       00
            0x06, ##       00
            0x06, ##       00
            0x0C, ##      00 
            0x1C, ##     000 
            0x38, ##    000  
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x00, ##         
            0x00, ##         
            0x30, ##    00   
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '64' => {    # '@'
        'width'    => 18, 
        'xoffset'  => 1, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x03, 0xF0, 0x00, ##        000000      
            0x0E, 0x0E, 0x00, ##      000     000   
            0x18, 0x03, 0x00, ##     00         00  
            0x30, 0x01, 0x80, ##    00           00 
            0x63, 0xD9, 0x80, ##   00   0000 00  00 
            0x66, 0x38, 0xC0, ##   00  00   000   00
            0xCC, 0x18, 0xC0, ##  00  00     00   00
            0xCC, 0x18, 0xC0, ##  00  00     00   00
            0xCC, 0x18, 0xC0, ##  00  00     00   00
            0xCC, 0x18, 0xC0, ##  00  00     00   00
            0xCC, 0x19, 0x80, ##  00  00     00  00 
            0x66, 0x3B, 0x00, ##   00  00   000 00  
            0x63, 0xDC, 0x00, ##   00   0000 000    
            0x30, 0x00, 0x00, ##    00              
            0x18, 0x04, 0x00, ##     00        0    
            0x0C, 0x0C, 0x00, ##      00      00    
            0x03, 0xF0, 0x00, ##        000000      
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '65' => {    # 'A'
        'width'    => 14, 
        'xoffset'  => 0, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x03, 0x00, ##        00      
            0x07, 0x80, ##       0000     
            0x07, 0x80, ##       0000     
            0x0D, 0x80, ##      00 00     
            0x0C, 0xC0, ##      00  00    
            0x08, 0xC0, ##      0   00    
            0x18, 0x60, ##     00    00   
            0x18, 0x60, ##     00    00   
            0x30, 0x60, ##    00     00   
            0x3F, 0xF0, ##    0000000000  
            0x20, 0x30, ##    0       00  
            0x60, 0x18, ##   00        00 
            0x60, 0x18, ##   00        00 
            0xC0, 0x18, ##  00         00 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '66' => {    # 'B'
        'width'    => 10, 
        'xoffset'  => 2, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0x00, ##  00000000  
            0xC1, 0x80, ##  00     00 
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC1, 0x80, ##  00     00 
            0xFF, 0x00, ##  00000000  
            0xC1, 0x80, ##  00     00 
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC1, 0x80, ##  00     00 
            0xFF, 0x00, ##  00000000  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '67' => {    # 'C'
        'width'    => 12, 
        'xoffset'  => 1, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0F, 0xE0, ##      0000000 
            0x38, 0x30, ##    000     00
            0x60, 0x00, ##   00         
            0x60, 0x00, ##   00         
            0xC0, 0x00, ##  00          
            0xC0, 0x00, ##  00          
            0xC0, 0x00, ##  00          
            0xC0, 0x00, ##  00          
            0xC0, 0x00, ##  00          
            0xC0, 0x00, ##  00          
            0x60, 0x00, ##   00         
            0x60, 0x00, ##   00         
            0x38, 0x30, ##    000     00
            0x0F, 0xE0, ##      0000000 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '68' => {    # 'D'
        'width'    => 12, 
        'xoffset'  => 2, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0x00, ##  00000000    
            0xC1, 0xC0, ##  00     000  
            0xC0, 0x60, ##  00       00 
            0xC0, 0x60, ##  00       00 
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xC0, 0x60, ##  00       00 
            0xC0, 0x60, ##  00       00 
            0xC1, 0xC0, ##  00     000  
            0xFF, 0x00, ##  00000000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '69' => {    # 'E'
        'width'    => 9, 
        'xoffset'  => 2, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0x80, ##  000000000
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xFF, 0x80, ##  000000000
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xFF, 0x80, ##  000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '70' => {    # 'F'
        'width'    => 9, 
        'xoffset'  => 2, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0x80, ##  000000000
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xFF, 0x00, ##  00000000 
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '71' => {    # 'G'
        'width'    => 13, 
        'xoffset'  => 1, 
        'xadvance' => 16, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0F, 0xE0, ##      0000000  
            0x38, 0x38, ##    000     000
            0x60, 0x08, ##   00         0
            0x60, 0x00, ##   00          
            0xC0, 0x00, ##  00           
            0xC0, 0x00, ##  00           
            0xC0, 0x00, ##  00           
            0xC0, 0xF8, ##  00      00000
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0x60, 0x18, ##   00        00
            0x60, 0x18, ##   00        00
            0x38, 0x38, ##    000     000
            0x0F, 0xE0, ##      0000000  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '72' => {    # 'H'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xFF, 0xE0, ##  00000000000
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '73' => {    # 'I'
        'width'    => 2, 
        'xoffset'  => 2, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '74' => {    # 'J'
        'width'    => 5, 
        'xoffset'  => -1, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x30, ##    00 
            0xE0, ##  000  
        ], 
    }, 
    '75' => {    # 'K'
        'width'    => 12, 
        'xoffset'  => 2, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xC0, 0xE0, ##  00      000 
            0xC1, 0x80, ##  00     00   
            0xC3, 0x00, ##  00    00    
            0xC6, 0x00, ##  00   00     
            0xCC, 0x00, ##  00  00      
            0xF8, 0x00, ##  00000       
            0xF0, 0x00, ##  0000        
            0xF8, 0x00, ##  00000       
            0xDC, 0x00, ##  00 000      
            0xCE, 0x00, ##  00  000     
            0xC7, 0x00, ##  00   000    
            0xC3, 0x80, ##  00    000   
            0xC1, 0xC0, ##  00     000  
            0xC0, 0xE0, ##  00      000 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '76' => {    # 'L'
        'width'    => 9, 
        'xoffset'  => 2, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xFF, 0x80, ##  000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '77' => {    # 'M'
        'width'    => 13, 
        'xoffset'  => 2, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xE0, 0x38, ##  000       000
            0xF0, 0x78, ##  0000     0000
            0xF0, 0x78, ##  0000     0000
            0xD0, 0x58, ##  00 0     0 00
            0xD8, 0xD8, ##  00 00   00 00
            0xD8, 0xD8, ##  00 00   00 00
            0xC8, 0x98, ##  00  0   0  00
            0xCD, 0x98, ##  00  00 00  00
            0xC5, 0x18, ##  00   0 0   00
            0xC5, 0x18, ##  00   0 0   00
            0xC7, 0x18, ##  00   000   00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '78' => {    # 'N'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xE0, 0x60, ##  000      00
            0xF0, 0x60, ##  0000     00
            0xF0, 0x60, ##  0000     00
            0xD8, 0x60, ##  00 00    00
            0xD8, 0x60, ##  00 00    00
            0xCC, 0x60, ##  00  00   00
            0xCC, 0x60, ##  00  00   00
            0xC6, 0x60, ##  00   00  00
            0xC6, 0x60, ##  00   00  00
            0xC3, 0x60, ##  00    00 00
            0xC3, 0x60, ##  00    00 00
            0xC1, 0xE0, ##  00     0000
            0xC1, 0xE0, ##  00     0000
            0xC0, 0xE0, ##  00      000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '79' => {    # 'O'
        'width'    => 13, 
        'xoffset'  => 1, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0F, 0x80, ##      00000    
            0x30, 0xE0, ##    00    000  
            0x60, 0x30, ##   00       00 
            0x60, 0x30, ##   00       00 
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0x60, 0x30, ##   00       00 
            0x60, 0x30, ##   00       00 
            0x30, 0x60, ##    00     00  
            0x0F, 0x80, ##      00000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '80' => {    # 'P'
        'width'    => 9, 
        'xoffset'  => 2, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFE, 0x00, ##  0000000  
            0xC3, 0x00, ##  00    00 
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC3, 0x00, ##  00    00 
            0xFE, 0x00, ##  0000000  
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '81' => {    # 'Q'
        'width'    => 13, 
        'xoffset'  => 1, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0F, 0x80, ##      00000    
            0x30, 0xE0, ##    00    000  
            0x60, 0x30, ##   00       00 
            0x60, 0x30, ##   00       00 
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0x60, 0x30, ##   00       00 
            0x60, 0x30, ##   00       00 
            0x30, 0x60, ##    00     00  
            0x0F, 0xC0, ##      000000   
            0x00, 0xC0, ##          00   
            0x00, 0x60, ##           00  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '82' => {    # 'R'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFE, 0x00, ##  0000000    
            0xC3, 0x00, ##  00    00   
            0xC1, 0x80, ##  00     00  
            0xC1, 0x80, ##  00     00  
            0xC1, 0x80, ##  00     00  
            0xC1, 0x80, ##  00     00  
            0xC3, 0x00, ##  00    00   
            0xFE, 0x00, ##  0000000    
            0xC3, 0x00, ##  00    00   
            0xC1, 0x80, ##  00     00  
            0xC1, 0x80, ##  00     00  
            0xC0, 0xC0, ##  00      00 
            0xC0, 0xC0, ##  00      00 
            0xC0, 0x60, ##  00       00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '83' => {    # 'S'
        'width'    => 10, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x3F, 0x80, ##    0000000 
            0x60, 0x80, ##   00     0 
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xF8, 0x00, ##  00000     
            0x7F, 0x00, ##   0000000  
            0x1F, 0x80, ##     000000 
            0x01, 0xC0, ##         000
            0x00, 0xC0, ##          00
            0x00, 0xC0, ##          00
            0x00, 0xC0, ##          00
            0xC1, 0x80, ##  00     00 
            0xFF, 0x00, ##  00000000  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '84' => {    # 'T'
        'width'    => 12, 
        'xoffset'  => 0, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xF0, ##  000000000000
            0x06, 0x00, ##       00     
            0x06, 0x00, ##       00     
            0x06, 0x00, ##       00     
            0x06, 0x00, ##       00     
            0x06, 0x00, ##       00     
            0x06, 0x00, ##       00     
            0x06, 0x00, ##       00     
            0x06, 0x00, ##       00     
            0x06, 0x00, ##       00     
            0x06, 0x00, ##       00     
            0x06, 0x00, ##       00     
            0x06, 0x00, ##       00     
            0x06, 0x00, ##       00     
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '85' => {    # 'U'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0x40, 0xC0, ##   0      00 
            0x60, 0xC0, ##   00     00 
            0x1F, 0x00, ##     00000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '86' => {    # 'V'
        'width'    => 14, 
        'xoffset'  => 0, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xC0, 0x18, ##  00         00 
            0x60, 0x18, ##   00        00 
            0x60, 0x38, ##   00       000 
            0x30, 0x30, ##    00      00  
            0x30, 0x30, ##    00      00  
            0x30, 0x60, ##    00     00   
            0x18, 0x60, ##     00    00   
            0x18, 0x60, ##     00    00   
            0x0C, 0xC0, ##      00  00    
            0x0C, 0xC0, ##      00  00    
            0x0D, 0x80, ##      00 00     
            0x07, 0x80, ##       0000     
            0x07, 0x80, ##       0000     
            0x03, 0x00, ##        00      
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '87' => {    # 'W'
        'width'    => 18, 
        'xoffset'  => 1, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xC0, 0xC0, 0xC0, ##  00      00      00
            0xC1, 0xC0, 0xC0, ##  00     000      00
            0xC1, 0xE1, 0x80, ##  00     0000    00 
            0x61, 0x61, 0x80, ##   00    0 00    00 
            0x61, 0x21, 0x80, ##   00    0  0    00 
            0x63, 0x21, 0x80, ##   00   00  0    00 
            0x63, 0x33, 0x00, ##   00   00  00  00  
            0x32, 0x33, 0x00, ##    00  0   00  00  
            0x32, 0x13, 0x00, ##    00  0    0  00  
            0x36, 0x13, 0x00, ##    00 00    0  00  
            0x36, 0x1E, 0x00, ##    00 00    0000   
            0x1C, 0x1E, 0x00, ##     000     0000   
            0x1C, 0x0E, 0x00, ##     000      000   
            0x1C, 0x0E, 0x00, ##     000      000   
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '88' => {    # 'X'
        'width'    => 12, 
        'xoffset'  => 1, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x60, 0x60, ##   00      00 
            0x60, 0x60, ##   00      00 
            0x30, 0xC0, ##    00    00  
            0x19, 0x80, ##     00  00   
            0x1F, 0x80, ##     000000   
            0x0F, 0x00, ##      0000    
            0x06, 0x00, ##       00     
            0x0F, 0x00, ##      0000    
            0x1F, 0x00, ##     00000    
            0x19, 0x80, ##     00  00   
            0x30, 0xC0, ##    00    00  
            0x60, 0xC0, ##   00     00  
            0x60, 0x60, ##   00      00 
            0xC0, 0x30, ##  00        00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '89' => {    # 'Y'
        'width'    => 12, 
        'xoffset'  => 0, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xC0, 0x30, ##  00        00
            0x60, 0x60, ##   00      00 
            0x30, 0xC0, ##    00    00  
            0x30, 0xC0, ##    00    00  
            0x19, 0x80, ##     00  00   
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x06, 0x00, ##       00     
            0x06, 0x00, ##       00     
            0x06, 0x00, ##       00     
            0x06, 0x00, ##       00     
            0x06, 0x00, ##       00     
            0x06, 0x00, ##       00     
            0x06, 0x00, ##       00     
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '90' => {    # 'Z'
        'width'    => 12, 
        'xoffset'  => 1, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xF0, ##  000000000000
            0x00, 0x70, ##           000
            0x00, 0xE0, ##          000 
            0x01, 0xC0, ##         000  
            0x01, 0x80, ##         00   
            0x03, 0x00, ##        00    
            0x07, 0x00, ##       000    
            0x0E, 0x00, ##      000     
            0x0C, 0x00, ##      00      
            0x18, 0x00, ##     00       
            0x38, 0x00, ##    000       
            0x70, 0x00, ##   000        
            0xE0, 0x00, ##  000         
            0xFF, 0xF0, ##  000000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '91' => {    # '['
        'width'    => 4, 
        'xoffset'  => 2, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF0, ##  0000
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0xF0, ##  0000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '92' => {    # '\'
        'width'    => 7, 
        'xoffset'  => 0, 
        'xadvance' => 7, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xC0, ##  00     
            0xC0, ##  00     
            0x40, ##   0     
            0x60, ##   00    
            0x60, ##   00    
            0x20, ##    0    
            0x30, ##    00   
            0x30, ##    00   
            0x10, ##     0   
            0x18, ##     00  
            0x18, ##     00  
            0x08, ##      0  
            0x0C, ##      00 
            0x0C, ##      00 
            0x04, ##       0 
            0x06, ##       00
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '93' => {    # ']'
        'width'    => 4, 
        'xoffset'  => 2, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF0, ##  0000
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0xF0, ##  0000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '94' => {    # '^'
        'width'    => 13, 
        'xoffset'  => 2, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x06, 0x00, ##       00      
            0x0F, 0x00, ##      0000     
            0x1D, 0x80, ##     000 00    
            0x18, 0xC0, ##     00   00   
            0x30, 0x60, ##    00     00  
            0x60, 0x30, ##   00       00 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '95' => {    # '_'
        'width'    => 10, 
        'xoffset'  => 0, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xC0, ##  0000000000
        ], 
    }, 
    '96' => {    # '`'
        'width'    => 4, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xC0, ##  00  
            0x40, ##   0  
            0x60, ##   00 
            0x30, ##    00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '97' => {    # 'a'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x7E, 0x00, ##   000000  
            0x43, 0x00, ##   0    00 
            0x01, 0x80, ##         00
            0x01, 0x80, ##         00
            0x3F, 0x80, ##    0000000
            0x61, 0x80, ##   00    00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC3, 0x80, ##  00    000
            0xE3, 0x80, ##  000   000
            0x7D, 0x80, ##   00000 00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '98' => {    # 'b'
        'width'    => 10, 
        'xoffset'  => 2, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xDE, 0x00, ##  00 0000   
            0xE3, 0x80, ##  000   000 
            0xE1, 0x80, ##  000    00 
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xE1, 0x80, ##  000    00 
            0xE1, 0x80, ##  000    00 
            0xDF, 0x00, ##  00 00000  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '99' => {    # 'c'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1F, 0x80, ##     000000
            0x70, 0x80, ##   000    0
            0x60, 0x00, ##   00      
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0x60, 0x00, ##   00      
            0x70, 0x80, ##   000    0
            0x1F, 0x80, ##     000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '100' => {    # 'd'
        'width'    => 10, 
        'xoffset'  => 1, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0xC0, ##          00
            0x00, 0xC0, ##          00
            0x00, 0xC0, ##          00
            0x00, 0xC0, ##          00
            0x3E, 0xC0, ##    00000 00
            0x73, 0xC0, ##   000  0000
            0x61, 0xC0, ##   00    000
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0x61, 0xC0, ##   00    000
            0x61, 0xC0, ##   00    000
            0x3E, 0xC0, ##    00000 00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '101' => {    # 'e'
        'width'    => 10, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1E, 0x00, ##     0000   
            0x71, 0x80, ##   000   00 
            0x61, 0x80, ##   00    00 
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xFF, 0xC0, ##  0000000000
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0x60, 0x00, ##   00       
            0x70, 0xC0, ##   000    00
            0x1F, 0x80, ##     000000 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '102' => {    # 'f'
        'width'    => 7, 
        'xoffset'  => 1, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x1E, ##     0000
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0xFC, ##  000000 
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x30, ##    00   
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '103' => {    # 'g'
        'width'    => 10, 
        'xoffset'  => 1, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x3E, 0xC0, ##    00000 00
            0x61, 0xC0, ##   00    000
            0x61, 0xC0, ##   00    000
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0x61, 0xC0, ##   00    000
            0x61, 0xC0, ##   00    000
            0x3E, 0xC0, ##    00000 00
            0x00, 0xC0, ##          00
            0x00, 0x80, ##          0 
            0x41, 0x80, ##   0     00 
            0x7F, 0x00, ##   0000000  
        ], 
    }, 
    '104' => {    # 'h'
        'width'    => 9, 
        'xoffset'  => 2, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xDE, 0x00, ##  00 0000  
            0xE3, 0x00, ##  000   00 
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '105' => {    # 'i'
        'width'    => 2, 
        'xoffset'  => 2, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xC0, ##  00
            0x00, ##    
            0x00, ##    
            0x00, ##    
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '106' => {    # 'j'
        'width'    => 4, 
        'xoffset'  => 0, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x30, ##    00
            0x00, ##      
            0x00, ##      
            0x00, ##      
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0xE0, ##  000 
        ], 
    }, 
    '107' => {    # 'k'
        'width'    => 10, 
        'xoffset'  => 2, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xC1, 0x80, ##  00     00 
            0xC3, 0x00, ##  00    00  
            0xC6, 0x00, ##  00   00   
            0xDC, 0x00, ##  00 000    
            0xF8, 0x00, ##  00000     
            0xF0, 0x00, ##  0000      
            0xD8, 0x00, ##  00 00     
            0xCC, 0x00, ##  00  00    
            0xC6, 0x00, ##  00   00   
            0xC3, 0x00, ##  00    00  
            0xC1, 0x80, ##  00     00 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '108' => {    # 'l'
        'width'    => 2, 
        'xoffset'  => 2, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '109' => {    # 'm'
        'width'    => 16, 
        'xoffset'  => 2, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xDE, 0x3C, ##  00 0000   0000  
            0xE3, 0x46, ##  000   00 0   00 
            0xC1, 0x83, ##  00     00     00
            0xC1, 0x83, ##  00     00     00
            0xC1, 0x83, ##  00     00     00
            0xC1, 0x83, ##  00     00     00
            0xC1, 0x83, ##  00     00     00
            0xC1, 0x83, ##  00     00     00
            0xC1, 0x83, ##  00     00     00
            0xC1, 0x83, ##  00     00     00
            0xC1, 0x83, ##  00     00     00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '110' => {    # 'n'
        'width'    => 9, 
        'xoffset'  => 2, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xDE, 0x00, ##  00 0000  
            0xE3, 0x00, ##  000   00 
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '111' => {    # 'o'
        'width'    => 10, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1E, 0x00, ##     0000   
            0x73, 0x80, ##   000  000 
            0x61, 0x80, ##   00    00 
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0x61, 0x80, ##   00    00 
            0x61, 0x80, ##   00    00 
            0x1E, 0x00, ##     0000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '112' => {    # 'p'
        'width'    => 10, 
        'xoffset'  => 2, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xDE, 0x00, ##  00 0000   
            0xE3, 0x80, ##  000   000 
            0xE1, 0x80, ##  000    00 
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xE1, 0x80, ##  000    00 
            0xE1, 0x80, ##  000    00 
            0xDF, 0x00, ##  00 00000  
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
        ], 
    }, 
    '113' => {    # 'q'
        'width'    => 10, 
        'xoffset'  => 1, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x3E, 0xC0, ##    00000 00
            0x73, 0xC0, ##   000  0000
            0x61, 0xC0, ##   00    000
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0x61, 0xC0, ##   00    000
            0x61, 0xC0, ##   00    000
            0x3E, 0xC0, ##    00000 00
            0x00, 0xC0, ##          00
            0x00, 0xC0, ##          00
            0x00, 0xC0, ##          00
            0x00, 0xC0, ##          00
        ], 
    }, 
    '114' => {    # 'r'
        'width'    => 7, 
        'xoffset'  => 2, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xDE, ##  00 0000
            0xE0, ##  000    
            0xE0, ##  000    
            0xC0, ##  00     
            0xC0, ##  00     
            0xC0, ##  00     
            0xC0, ##  00     
            0xC0, ##  00     
            0xC0, ##  00     
            0xC0, ##  00     
            0xC0, ##  00     
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '115' => {    # 's'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x3E, ##    00000 
            0xE0, ##  000     
            0xC0, ##  00      
            0xC0, ##  00      
            0xF8, ##  00000   
            0x7E, ##   000000 
            0x0F, ##      0000
            0x03, ##        00
            0x03, ##        00
            0x86, ##  0    00 
            0xFC, ##  000000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '116' => {    # 't'
        'width'    => 7, 
        'xoffset'  => 1, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x60, ##   00    
            0x60, ##   00    
            0x60, ##   00    
            0xFE, ##  0000000
            0x60, ##   00    
            0x60, ##   00    
            0x60, ##   00    
            0x60, ##   00    
            0x60, ##   00    
            0x60, ##   00    
            0x60, ##   00    
            0x60, ##   00    
            0x60, ##   00    
            0x3E, ##    00000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '117' => {    # 'u'
        'width'    => 9, 
        'xoffset'  => 2, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0x63, 0x80, ##   00   000
            0x3D, 0x80, ##    0000 00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '118' => {    # 'v'
        'width'    => 10, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0x41, 0x80, ##   0     00 
            0x61, 0x80, ##   00    00 
            0x61, 0x80, ##   00    00 
            0x33, 0x00, ##    00  00  
            0x33, 0x00, ##    00  00  
            0x32, 0x00, ##    00  0   
            0x1E, 0x00, ##     0000   
            0x1E, 0x00, ##     0000   
            0x0C, 0x00, ##      00    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '119' => {    # 'w'
        'width'    => 15, 
        'xoffset'  => 1, 
        'xadvance' => 16, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xC3, 0x04, ##  00    00     0 
            0xC3, 0x8C, ##  00    000   00 
            0xC7, 0x8C, ##  00   0000   00 
            0x66, 0x8C, ##   00  00 0   00 
            0x66, 0x88, ##   00  00 0   0  
            0x64, 0xD8, ##   00  0  00 00  
            0x2C, 0xD8, ##    0 00  00 00  
            0x3C, 0x58, ##    0000   0 00  
            0x38, 0x70, ##    000    000   
            0x38, 0x70, ##    000    000   
            0x18, 0x70, ##     00    000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '120' => {    # 'x'
        'width'    => 10, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xC1, 0xC0, ##  00     000
            0x61, 0x80, ##   00    00 
            0x33, 0x00, ##    00  00  
            0x1E, 0x00, ##     0000   
            0x1E, 0x00, ##     0000   
            0x0C, 0x00, ##      00    
            0x1E, 0x00, ##     0000   
            0x37, 0x00, ##    00 000  
            0x73, 0x00, ##   000  00  
            0x61, 0x80, ##   00    00 
            0xC0, 0xC0, ##  00      00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '121' => {    # 'y'
        'width'    => 11, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xC0, 0x40, ##  00       0 
            0x40, 0xC0, ##   0      00 
            0x60, 0xC0, ##   00     00 
            0x61, 0x80, ##   00    00  
            0x31, 0x80, ##    00   00  
            0x31, 0x00, ##    00   0   
            0x13, 0x00, ##     0  00   
            0x1B, 0x00, ##     00 00   
            0x1E, 0x00, ##     0000    
            0x0E, 0x00, ##      000    
            0x0C, 0x00, ##      00     
            0x0C, 0x00, ##      00     
            0x0C, 0x00, ##      00     
            0x18, 0x00, ##     00      
            0x70, 0x00, ##   000       
        ], 
    }, 
    '122' => {    # 'z'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0x80, ##  000000000
            0x01, 0x80, ##         00
            0x03, 0x00, ##        00 
            0x06, 0x00, ##       00  
            0x0C, 0x00, ##      00   
            0x1C, 0x00, ##     000   
            0x18, 0x00, ##     00    
            0x30, 0x00, ##    00     
            0x60, 0x00, ##   00      
            0xC0, 0x00, ##  00       
            0xFF, 0x80, ##  000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '123' => {    # '{'
        'width'    => 8, 
        'xoffset'  => 2, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x0F, ##      0000
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x38, ##    000   
            0xE0, ##  000     
            0x30, ##    00    
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x0F, ##      0000
            0x00, ##  
        ], 
    }, 
    '124' => {    # '|'
        'width'    => 2, 
        'xoffset'  => 3, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
        ], 
    }, 
    '125' => {    # '}'
        'width'    => 8, 
        'xoffset'  => 2, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF0, ##  0000    
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x1C, ##     000  
            0x07, ##       000
            0x0C, ##      00  
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0xF0, ##  0000    
            0x00, ##  
        ], 
    }, 
    '126' => {    # '~'
        'width'    => 13, 
        'xoffset'  => 2, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x7C, 0x18, ##   00000     00
            0xC7, 0xF0, ##  00   0000000 
            0x81, 0xE0, ##  0      0000  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '160' => {    # ' '
        'width'    => 0, 
        'xoffset'  => 0, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
        ], 
    }, 
    '161' => {    # '¡'
        'width'    => 2, 
        'xoffset'  => 3, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xC0, ##  00
            0x00, ##    
            0x00, ##    
            0x00, ##    
            0x00, ##    
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '162' => {    # '¢'
        'width'    => 9, 
        'xoffset'  => 2, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x04, 0x00, ##       0   
            0x04, 0x00, ##       0   
            0x04, 0x00, ##       0   
            0x04, 0x00, ##       0   
            0x1F, 0x80, ##     000000
            0x74, 0x80, ##   000 0  0
            0x64, 0x00, ##   00  0   
            0xC4, 0x00, ##  00   0   
            0xC4, 0x00, ##  00   0   
            0xC4, 0x00, ##  00   0   
            0xC4, 0x00, ##  00   0   
            0xC4, 0x00, ##  00   0   
            0x64, 0x80, ##   00  0  0
            0x3F, 0x80, ##    0000000
            0x0E, 0x00, ##      000  
            0x04, 0x00, ##       0   
            0x04, 0x00, ##       0   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '163' => {    # '£'
        'width'    => 10, 
        'xoffset'  => 1, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0F, 0xC0, ##      000000
            0x18, 0x40, ##     00    0
            0x30, 0x00, ##    00      
            0x30, 0x00, ##    00      
            0x30, 0x00, ##    00      
            0x30, 0x00, ##    00      
            0x30, 0x00, ##    00      
            0xFF, 0x00, ##  00000000  
            0x30, 0x00, ##    00      
            0x30, 0x00, ##    00      
            0x30, 0x00, ##    00      
            0x30, 0x00, ##    00      
            0x30, 0x00, ##    00      
            0xFF, 0xC0, ##  0000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '164' => {    # '¤'
        'width'    => 11, 
        'xoffset'  => 1, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xC0, 0x60, ##  00       00
            0x7F, 0xC0, ##   000000000 
            0x31, 0x80, ##    00   00  
            0x60, 0xC0, ##   00     00 
            0x60, 0xC0, ##   00     00 
            0x60, 0xC0, ##   00     00 
            0x60, 0xC0, ##   00     00 
            0x31, 0x80, ##    00   00  
            0x7F, 0xC0, ##   000000000 
            0xC0, 0x60, ##  00       00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '165' => {    # '¥'
        'width'    => 12, 
        'xoffset'  => 0, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x60, 0x60, ##   00      00 
            0x60, 0x60, ##   00      00 
            0x30, 0xC0, ##    00    00  
            0x11, 0x80, ##     0   00   
            0x19, 0x80, ##     00  00   
            0x7F, 0xE0, ##   0000000000 
            0x0F, 0x00, ##      0000    
            0x06, 0x00, ##       00     
            0x06, 0x00, ##       00     
            0x7F, 0xE0, ##   0000000000 
            0x06, 0x00, ##       00     
            0x06, 0x00, ##       00     
            0x06, 0x00, ##       00     
            0x06, 0x00, ##       00     
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '166' => {    # '¦'
        'width'    => 2, 
        'xoffset'  => 3, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0x00, ##    
            0x00, ##    
            0x00, ##    
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0x00, ##  
        ], 
    }, 
    '167' => {    # '§'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x3E, ##    00000 
            0x60, ##   00     
            0x60, ##   00     
            0x70, ##   000    
            0x38, ##    000   
            0x7C, ##   00000  
            0xCE, ##  00  000 
            0xC3, ##  00    00
            0xE3, ##  000   00
            0x73, ##   000  00
            0x3E, ##    00000 
            0x0E, ##      000 
            0x03, ##        00
            0x03, ##        00
            0x43, ##   0    00
            0x7E, ##   000000 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '168' => {    # '¨'
        'width'    => 6, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xCC, ##  00  00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '169' => {    # '©'
        'width'    => 14, 
        'xoffset'  => 3, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0F, 0xC0, ##      000000    
            0x18, 0x60, ##     00    00   
            0x20, 0x10, ##    0        0  
            0x47, 0xC8, ##   0   00000  0 
            0xCC, 0x0C, ##  00  00      00
            0x98, 0x04, ##  0  00        0
            0x98, 0x04, ##  0  00        0
            0x98, 0x04, ##  0  00        0
            0x98, 0x04, ##  0  00        0
            0xCC, 0x0C, ##  00  00      00
            0x47, 0xC8, ##   0   00000  0 
            0x20, 0x10, ##    0        0  
            0x18, 0x60, ##     00    00   
            0x0F, 0xC0, ##      000000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '170' => {    # 'ª'
        'width'    => 7, 
        'xoffset'  => 1, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF8, ##  00000  
            0x8C, ##  0   00 
            0x06, ##       00
            0x7E, ##   000000
            0xC6, ##  00   00
            0x86, ##  0    00
            0xCE, ##  00  000
            0x76, ##   000 00
            0x00, ##         
            0xFE, ##  0000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '171' => {    # '«'
        'width'    => 9, 
        'xoffset'  => 2, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x08, 0x80, ##      0   0
            0x19, 0x80, ##     00  00
            0x33, 0x00, ##    00  00 
            0xCE, 0x00, ##  00  000  
            0xCC, 0x00, ##  00  00   
            0x66, 0x00, ##   00  00  
            0x33, 0x80, ##    00  000
            0x18, 0x80, ##     00   0
            0x08, 0x00, ##      0    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '172' => {    # '¬'
        'width'    => 13, 
        'xoffset'  => 2, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xF8, ##  0000000000000
            0x00, 0x18, ##             00
            0x00, 0x18, ##             00
            0x00, 0x18, ##             00
            0x00, 0x18, ##             00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '173' => {    # '­'
        'width'    => 5, 
        'xoffset'  => 1, 
        'xadvance' => 7, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF8, ##  00000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '174' => {    # '®'
        'width'    => 14, 
        'xoffset'  => 3, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0F, 0xC0, ##      000000    
            0x18, 0x60, ##     00    00   
            0x20, 0x10, ##    0        0  
            0x4F, 0xC8, ##   0  000000  0 
            0xCC, 0x6C, ##  00  00   00 00
            0x8C, 0x64, ##  0   00   00  0
            0x8F, 0xC4, ##  0   000000   0
            0x8C, 0x84, ##  0   00  0    0
            0x8C, 0x44, ##  0   00   0   0
            0xCC, 0x6C, ##  00  00   00 00
            0x4C, 0x28, ##   0  00    0 0 
            0x20, 0x10, ##    0        0  
            0x18, 0x60, ##     00    00   
            0x0F, 0xC0, ##      000000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '175' => {    # '¯'
        'width'    => 6, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xFC, ##  000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '176' => {    # '°'
        'width'    => 6, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x78, ##   0000 
            0xCC, ##  00  00
            0x84, ##  0    0
            0x84, ##  0    0
            0xCC, ##  00  00
            0x78, ##   0000 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '177' => {    # '±'
        'width'    => 13, 
        'xoffset'  => 2, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x06, 0x00, ##       00      
            0x06, 0x00, ##       00      
            0x06, 0x00, ##       00      
            0x06, 0x00, ##       00      
            0xFF, 0xF8, ##  0000000000000
            0x06, 0x00, ##       00      
            0x06, 0x00, ##       00      
            0x06, 0x00, ##       00      
            0x06, 0x00, ##       00      
            0x00, 0x00, ##               
            0x00, 0x00, ##               
            0xFF, 0xF8, ##  0000000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '178' => {    # '²'
        'width'    => 6, 
        'xoffset'  => 1, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF8, ##  00000 
            0x8C, ##  0   00
            0x0C, ##      00
            0x08, ##      0 
            0x18, ##     00 
            0x20, ##    0   
            0xC0, ##  00    
            0xFC, ##  000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '179' => {    # '³'
        'width'    => 6, 
        'xoffset'  => 1, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF8, ##  00000 
            0x0C, ##      00
            0x04, ##       0
            0x38, ##    000 
            0x0C, ##      00
            0x04, ##       0
            0x0C, ##      00
            0xF8, ##  00000 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '180' => {    # '´'
        'width'    => 4, 
        'xoffset'  => 4, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x30, ##    00
            0x20, ##    0 
            0x40, ##   0  
            0xC0, ##  00  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '181' => {    # 'µ'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xC1, 0x80, ##  00     00  
            0xC1, 0x80, ##  00     00  
            0xC1, 0x80, ##  00     00  
            0xC1, 0x80, ##  00     00  
            0xC1, 0x80, ##  00     00  
            0xC1, 0x80, ##  00     00  
            0xC1, 0x80, ##  00     00  
            0xC1, 0x80, ##  00     00  
            0xC1, 0x80, ##  00     00  
            0xE3, 0x80, ##  000   000  
            0xFF, 0xE0, ##  00000000000
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
        ], 
    }, 
    '182' => {    # '¶'
        'width'    => 9, 
        'xoffset'  => 2, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x3F, 0x80, ##    0000000
            0xFD, 0x80, ##  000000 00
            0xFD, 0x80, ##  000000 00
            0xFD, 0x80, ##  000000 00
            0xFD, 0x80, ##  000000 00
            0xFD, 0x80, ##  000000 00
            0xFD, 0x80, ##  000000 00
            0x3D, 0x80, ##    0000 00
            0x0D, 0x80, ##      00 00
            0x0D, 0x80, ##      00 00
            0x0D, 0x80, ##      00 00
            0x0D, 0x80, ##      00 00
            0x0D, 0x80, ##      00 00
            0x0D, 0x80, ##      00 00
            0x0D, 0x80, ##      00 00
            0x0D, 0x80, ##      00 00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '183' => {    # '·'
        'width'    => 2, 
        'xoffset'  => 2, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xC0, ##  00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '184' => {    # '¸'
        'width'    => 5, 
        'xoffset'  => 3, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x30, ##    00 
            0x18, ##     00
            0x18, ##     00
            0xF0, ##  0000 
        ], 
    }, 
    '185' => {    # '¹'
        'width'    => 5, 
        'xoffset'  => 2, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xE0, ##  000  
            0x20, ##    0  
            0x20, ##    0  
            0x20, ##    0  
            0x20, ##    0  
            0x20, ##    0  
            0x20, ##    0  
            0xF8, ##  00000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '186' => {    # 'º'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x3C, ##    0000  
            0x66, ##   00  00 
            0xC2, ##  00    0 
            0xC2, ##  00    0 
            0xC3, ##  00    00
            0xC2, ##  00    0 
            0x66, ##   00  00 
            0x3C, ##    0000  
            0x00, ##          
            0xFE, ##  0000000 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '187' => {    # '»'
        'width'    => 9, 
        'xoffset'  => 2, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x88, 0x00, ##  0   0    
            0xCC, 0x00, ##  00  00   
            0x66, 0x00, ##   00  00  
            0x33, 0x80, ##    00  000
            0x39, 0x80, ##    000  00
            0x73, 0x00, ##   000  00 
            0xCE, 0x00, ##  00  000  
            0x88, 0x00, ##  0   0    
            0x00, 0x00, ##           
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '188' => {    # '¼'
        'width'    => 17, 
        'xoffset'  => 2, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x30, 0x18, 0x00, ##    00       00    
            0xF0, 0x10, 0x00, ##  0000       0     
            0x30, 0x30, 0x00, ##    00      00     
            0x30, 0x20, 0x00, ##    00      0      
            0x30, 0x60, 0x00, ##    00     00      
            0x30, 0x40, 0x00, ##    00     0       
            0x30, 0xC0, 0x00, ##    00    00       
            0xF9, 0x87, 0x00, ##  00000  00    000 
            0x01, 0x0B, 0x00, ##         0    0 00 
            0x03, 0x0B, 0x00, ##        00    0 00 
            0x02, 0x13, 0x00, ##        0    0  00 
            0x06, 0x23, 0x00, ##       00   0   00 
            0x04, 0x3F, 0x80, ##       0    0000000
            0x08, 0x03, 0x00, ##      0         00 
            0x18, 0x03, 0x00, ##     00         00 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '189' => {    # '½'
        'width'    => 17, 
        'xoffset'  => 2, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x30, 0x0C, 0x00, ##    00        00   
            0xF0, 0x18, 0x00, ##  0000       00    
            0x30, 0x10, 0x00, ##    00       0     
            0x30, 0x30, 0x00, ##    00      00     
            0x30, 0x20, 0x00, ##    00      0      
            0x30, 0x60, 0x00, ##    00     00      
            0x30, 0x40, 0x00, ##    00     0       
            0x30, 0x8F, 0x00, ##    00    0   0000 
            0xF9, 0x91, 0x80, ##  00000  00  0   00
            0x01, 0x01, 0x80, ##         0       00
            0x03, 0x03, 0x80, ##        00      000
            0x02, 0x03, 0x00, ##        0       00 
            0x04, 0x06, 0x00, ##       0       00  
            0x0C, 0x08, 0x00, ##      00      0    
            0x08, 0x1F, 0x80, ##      0      000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '190' => {    # '¾'
        'width'    => 18, 
        'xoffset'  => 1, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x7C, 0x0C, 0x00, ##   00000      00    
            0x06, 0x08, 0x00, ##       00     0     
            0x06, 0x18, 0x00, ##       00    00     
            0x04, 0x10, 0x00, ##       0     0      
            0x3E, 0x30, 0x00, ##    00000   00      
            0x06, 0x60, 0x00, ##       00  00       
            0x06, 0x40, 0x00, ##       00  0        
            0xFC, 0xC3, 0x80, ##  000000  00    000 
            0x00, 0x85, 0x80, ##          0    0 00 
            0x01, 0x85, 0x80, ##         00    0 00 
            0x03, 0x09, 0x80, ##        00    0  00 
            0x03, 0x09, 0x80, ##        00    0  00 
            0x06, 0x1F, 0xC0, ##       00    0000000
            0x04, 0x01, 0x80, ##       0         00 
            0x0C, 0x01, 0x80, ##      00         00 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '191' => {    # '¿'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x18, ##     00   
            0x00, ##          
            0x00, ##          
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x38, ##    000   
            0x70, ##   000    
            0x60, ##   00     
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0x63, ##   00   00
            0x3E, ##    00000 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '192' => {    # 'À'
        'width'    => 14, 
        'xoffset'  => 0, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x06, 0x00, ##       00       
            0x02, 0x00, ##        0       
            0x01, 0x00, ##         0      
            0x00, 0x00, ##                
            0x03, 0x00, ##        00      
            0x07, 0x80, ##       0000     
            0x07, 0x80, ##       0000     
            0x0D, 0x80, ##      00 00     
            0x0C, 0xC0, ##      00  00    
            0x08, 0xC0, ##      0   00    
            0x18, 0x60, ##     00    00   
            0x18, 0x60, ##     00    00   
            0x30, 0x60, ##    00     00   
            0x3F, 0xF0, ##    0000000000  
            0x20, 0x30, ##    0       00  
            0x60, 0x18, ##   00        00 
            0x60, 0x18, ##   00        00 
            0xC0, 0x18, ##  00         00 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '193' => {    # 'Á'
        'width'    => 14, 
        'xoffset'  => 0, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x01, 0x80, ##         00     
            0x03, 0x00, ##        00      
            0x06, 0x00, ##       00       
            0x00, 0x00, ##                
            0x03, 0x00, ##        00      
            0x07, 0x80, ##       0000     
            0x07, 0x80, ##       0000     
            0x0D, 0x80, ##      00 00     
            0x0C, 0xC0, ##      00  00    
            0x08, 0xC0, ##      0   00    
            0x18, 0x60, ##     00    00   
            0x18, 0x60, ##     00    00   
            0x30, 0x60, ##    00     00   
            0x3F, 0xF0, ##    0000000000  
            0x20, 0x30, ##    0       00  
            0x60, 0x18, ##   00        00 
            0x60, 0x18, ##   00        00 
            0xC0, 0x18, ##  00         00 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '194' => {    # 'Â'
        'width'    => 14, 
        'xoffset'  => 0, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x07, 0x00, ##       000      
            0x05, 0x80, ##       0 00     
            0x08, 0xC0, ##      0   00    
            0x00, 0x00, ##                
            0x03, 0x00, ##        00      
            0x07, 0x80, ##       0000     
            0x07, 0x80, ##       0000     
            0x0D, 0x80, ##      00 00     
            0x0C, 0xC0, ##      00  00    
            0x08, 0xC0, ##      0   00    
            0x18, 0x60, ##     00    00   
            0x18, 0x60, ##     00    00   
            0x30, 0x60, ##    00     00   
            0x3F, 0xF0, ##    0000000000  
            0x20, 0x30, ##    0       00  
            0x60, 0x18, ##   00        00 
            0x60, 0x18, ##   00        00 
            0xC0, 0x18, ##  00         00 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '195' => {    # 'Ã'
        'width'    => 13, 
        'xoffset'  => 1, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x0C, 0x80, ##      00  0    
            0x13, 0x80, ##     0  000    
            0x00, 0x00, ##               
            0x00, 0x00, ##               
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x0D, 0x00, ##      00 0     
            0x0D, 0x80, ##      00 00    
            0x19, 0x80, ##     00  00    
            0x18, 0xC0, ##     00   00   
            0x18, 0xC0, ##     00   00   
            0x30, 0xC0, ##    00    00   
            0x30, 0x60, ##    00     00  
            0x7F, 0xE0, ##   0000000000  
            0x60, 0x30, ##   00       00 
            0x40, 0x30, ##   0        00 
            0xC0, 0x30, ##  00        00 
            0xC0, 0x18, ##  00         00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '196' => {    # 'Ä'
        'width'    => 14, 
        'xoffset'  => 0, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0C, 0xC0, ##      00  00    
            0x00, 0x00, ##                
            0x00, 0x00, ##                
            0x03, 0x00, ##        00      
            0x07, 0x80, ##       0000     
            0x07, 0x80, ##       0000     
            0x0C, 0xC0, ##      00  00    
            0x0C, 0xC0, ##      00  00    
            0x0C, 0xC0, ##      00  00    
            0x18, 0x60, ##     00    00   
            0x18, 0x60, ##     00    00   
            0x30, 0x30, ##    00      00  
            0x3F, 0xF0, ##    0000000000  
            0x20, 0x10, ##    0        0  
            0x60, 0x18, ##   00        00 
            0x60, 0x18, ##   00        00 
            0xC0, 0x0C, ##  00          00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '197' => {    # 'Å'
        'width'    => 13, 
        'xoffset'  => 0, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x07, 0x00, ##       000     
            0x08, 0x80, ##      0   0    
            0x08, 0x80, ##      0   0    
            0x08, 0x80, ##      0   0    
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x05, 0x00, ##       0 0     
            0x0D, 0x80, ##      00 00    
            0x0D, 0x80, ##      00 00    
            0x18, 0xC0, ##     00   00   
            0x18, 0xC0, ##     00   00   
            0x18, 0xC0, ##     00   00   
            0x30, 0x60, ##    00     00  
            0x3F, 0xE0, ##    000000000  
            0x60, 0x30, ##   00       00 
            0x60, 0x30, ##   00       00 
            0x60, 0x30, ##   00       00 
            0xC0, 0x18, ##  00         00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '198' => {    # 'Æ'
        'width'    => 18, 
        'xoffset'  => 0, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x03, 0xFF, 0xC0, ##        000000000000
            0x03, 0x60, 0x00, ##        00 00       
            0x06, 0x60, 0x00, ##       00  00       
            0x06, 0x60, 0x00, ##       00  00       
            0x0C, 0x60, 0x00, ##      00   00       
            0x0C, 0x60, 0x00, ##      00   00       
            0x0C, 0x7F, 0xC0, ##      00   000000000
            0x18, 0x60, 0x00, ##     00    00       
            0x18, 0x60, 0x00, ##     00    00       
            0x3F, 0xE0, 0x00, ##    000000000       
            0x30, 0x60, 0x00, ##    00     00       
            0x60, 0x60, 0x00, ##   00      00       
            0x60, 0x60, 0x00, ##   00      00       
            0xC0, 0x7F, 0xC0, ##  00       000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '199' => {    # 'Ç'
        'width'    => 12, 
        'xoffset'  => 1, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0F, 0xE0, ##      0000000 
            0x38, 0x30, ##    000     00
            0x60, 0x00, ##   00         
            0x60, 0x00, ##   00         
            0xC0, 0x00, ##  00          
            0xC0, 0x00, ##  00          
            0xC0, 0x00, ##  00          
            0xC0, 0x00, ##  00          
            0xC0, 0x00, ##  00          
            0xC0, 0x00, ##  00          
            0x60, 0x00, ##   00         
            0x60, 0x00, ##   00         
            0x38, 0x30, ##    000     00
            0x0F, 0xE0, ##      0000000 
            0x01, 0x00, ##         0    
            0x01, 0x80, ##         00   
            0x01, 0x80, ##         00   
            0x0F, 0x00, ##      0000    
        ], 
    }, 
    '200' => {    # 'È'
        'width'    => 9, 
        'xoffset'  => 2, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x10, 0x00, ##     0     
            0x08, 0x00, ##      0    
            0x0C, 0x00, ##      00   
            0x00, 0x00, ##           
            0xFF, 0x80, ##  000000000
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xFF, 0x80, ##  000000000
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xFF, 0x80, ##  000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '201' => {    # 'É'
        'width'    => 9, 
        'xoffset'  => 2, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x06, 0x00, ##       00  
            0x0C, 0x00, ##      00   
            0x18, 0x00, ##     00    
            0x00, 0x00, ##           
            0xFF, 0x80, ##  000000000
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xFF, 0x80, ##  000000000
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xFF, 0x80, ##  000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '202' => {    # 'Ê'
        'width'    => 9, 
        'xoffset'  => 2, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x1C, 0x00, ##     000   
            0x36, 0x00, ##    00 00  
            0x23, 0x00, ##    0   00 
            0x00, 0x00, ##           
            0xFF, 0x80, ##  000000000
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xFF, 0x80, ##  000000000
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xFF, 0x80, ##  000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '203' => {    # 'Ë'
        'width'    => 9, 
        'xoffset'  => 2, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x36, 0x00, ##    00 00  
            0x00, 0x00, ##           
            0x00, 0x00, ##           
            0xFF, 0x80, ##  000000000
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xFF, 0x80, ##  000000000
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xFF, 0x80, ##  000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '204' => {    # 'Ì'
        'width'    => 3, 
        'xoffset'  => 1, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0xC0, ##  00 
            0x60, ##   00
            0x20, ##    0
            0x00, ##     
            0x60, ##   00
            0x60, ##   00
            0x60, ##   00
            0x60, ##   00
            0x60, ##   00
            0x60, ##   00
            0x60, ##   00
            0x60, ##   00
            0x60, ##   00
            0x60, ##   00
            0x60, ##   00
            0x60, ##   00
            0x60, ##   00
            0x60, ##   00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '205' => {    # 'Í'
        'width'    => 3, 
        'xoffset'  => 2, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0x60, ##   00
            0xC0, ##  00 
            0x80, ##  0  
            0x00, ##     
            0xC0, ##  00 
            0xC0, ##  00 
            0xC0, ##  00 
            0xC0, ##  00 
            0xC0, ##  00 
            0xC0, ##  00 
            0xC0, ##  00 
            0xC0, ##  00 
            0xC0, ##  00 
            0xC0, ##  00 
            0xC0, ##  00 
            0xC0, ##  00 
            0xC0, ##  00 
            0xC0, ##  00 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '206' => {    # 'Î'
        'width'    => 6, 
        'xoffset'  => 0, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0x30, ##    00  
            0x48, ##   0  0 
            0x84, ##  0    0
            0x00, ##        
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '207' => {    # 'Ï'
        'width'    => 6, 
        'xoffset'  => 1, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xCC, ##  00  00
            0x00, ##        
            0x00, ##        
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '208' => {    # 'Ð'
        'width'    => 14, 
        'xoffset'  => 1, 
        'xadvance' => 16, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x3F, 0xC0, ##    00000000    
            0x30, 0x70, ##    00     000  
            0x30, 0x18, ##    00       00 
            0x30, 0x18, ##    00       00 
            0x30, 0x0C, ##    00        00
            0x30, 0x0C, ##    00        00
            0xFE, 0x0C, ##  0000000     00
            0x30, 0x0C, ##    00        00
            0x30, 0x0C, ##    00        00
            0x30, 0x0C, ##    00        00
            0x30, 0x18, ##    00       00 
            0x30, 0x18, ##    00       00 
            0x30, 0x70, ##    00     000  
            0x3F, 0xC0, ##    00000000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '209' => {    # 'Ñ'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x1D, 0x80, ##     000 00  
            0x37, 0x00, ##    00 000   
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0xE0, 0x60, ##  000      00
            0xF0, 0x60, ##  0000     00
            0xF0, 0x60, ##  0000     00
            0xD8, 0x60, ##  00 00    00
            0xD8, 0x60, ##  00 00    00
            0xCC, 0x60, ##  00  00   00
            0xCC, 0x60, ##  00  00   00
            0xC6, 0x60, ##  00   00  00
            0xC6, 0x60, ##  00   00  00
            0xC3, 0x60, ##  00    00 00
            0xC3, 0x60, ##  00    00 00
            0xC1, 0xE0, ##  00     0000
            0xC1, 0xE0, ##  00     0000
            0xC0, 0xE0, ##  00      000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '210' => {    # 'Ò'
        'width'    => 13, 
        'xoffset'  => 1, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x0C, 0x00, ##      00       
            0x06, 0x00, ##       00      
            0x02, 0x00, ##        0      
            0x00, 0x00, ##               
            0x00, 0x00, ##               
            0x0F, 0x80, ##      00000    
            0x30, 0xE0, ##    00    000  
            0x60, 0x30, ##   00       00 
            0x60, 0x30, ##   00       00 
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0x60, 0x30, ##   00       00 
            0x60, 0x30, ##   00       00 
            0x30, 0x60, ##    00     00  
            0x0F, 0x80, ##      00000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '211' => {    # 'Ó'
        'width'    => 13, 
        'xoffset'  => 1, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x01, 0x80, ##         00    
            0x03, 0x00, ##        00     
            0x02, 0x00, ##        0      
            0x00, 0x00, ##               
            0x00, 0x00, ##               
            0x0F, 0x80, ##      00000    
            0x30, 0xE0, ##    00    000  
            0x60, 0x30, ##   00       00 
            0x60, 0x30, ##   00       00 
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0x60, 0x30, ##   00       00 
            0x60, 0x30, ##   00       00 
            0x30, 0x60, ##    00     00  
            0x0F, 0x80, ##      00000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '212' => {    # 'Ô'
        'width'    => 13, 
        'xoffset'  => 1, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x02, 0x00, ##        0      
            0x05, 0x00, ##       0 0     
            0x08, 0x80, ##      0   0    
            0x00, 0x00, ##               
            0x00, 0x00, ##               
            0x0F, 0x80, ##      00000    
            0x30, 0xE0, ##    00    000  
            0x60, 0x30, ##   00       00 
            0x60, 0x30, ##   00       00 
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0x60, 0x30, ##   00       00 
            0x60, 0x30, ##   00       00 
            0x30, 0x60, ##    00     00  
            0x0F, 0x80, ##      00000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '213' => {    # 'Õ'
        'width'    => 13, 
        'xoffset'  => 1, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x0E, 0xC0, ##      000 00   
            0x1B, 0x80, ##     00 000    
            0x00, 0x00, ##               
            0x00, 0x00, ##               
            0x0F, 0x80, ##      00000    
            0x30, 0xE0, ##    00    000  
            0x60, 0x30, ##   00       00 
            0x60, 0x30, ##   00       00 
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0x60, 0x30, ##   00       00 
            0x60, 0x30, ##   00       00 
            0x30, 0x60, ##    00     00  
            0x0F, 0x80, ##      00000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '214' => {    # 'Ö'
        'width'    => 13, 
        'xoffset'  => 1, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x0C, 0xC0, ##      00  00   
            0x00, 0x00, ##               
            0x00, 0x00, ##               
            0x00, 0x00, ##               
            0x0F, 0x80, ##      00000    
            0x30, 0xE0, ##    00    000  
            0x60, 0x30, ##   00       00 
            0x60, 0x30, ##   00       00 
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0x60, 0x30, ##   00       00 
            0x60, 0x30, ##   00       00 
            0x30, 0x60, ##    00     00  
            0x0F, 0x80, ##      00000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '215' => {    # '×'
        'width'    => 11, 
        'xoffset'  => 3, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##             
            0xC0, 0x60, ##  00       00
            0x60, 0xC0, ##   00     00 
            0x31, 0x80, ##    00   00  
            0x1B, 0x00, ##     00 00   
            0x0E, 0x00, ##      000    
            0x0E, 0x00, ##      000    
            0x1B, 0x00, ##     00 00   
            0x31, 0x80, ##    00   00  
            0xE0, 0xC0, ##  000     00 
            0xC0, 0x60, ##  00       00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '216' => {    # 'Ø'
        'width'    => 13, 
        'xoffset'  => 1, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0F, 0xD8, ##      000000 00
            0x38, 0x70, ##    000    000 
            0x60, 0x30, ##   00       00 
            0x60, 0x70, ##   00      000 
            0xC0, 0xD8, ##  00      00 00
            0xC1, 0x98, ##  00     00  00
            0xC3, 0x18, ##  00    00   00
            0xC6, 0x18, ##  00   00    00
            0xC4, 0x18, ##  00   0     00
            0xC8, 0x18, ##  00  0      00
            0x78, 0x30, ##   0000     00 
            0x70, 0x30, ##   000      00 
            0x78, 0x60, ##   0000    00  
            0xDF, 0x80, ##  00 000000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '217' => {    # 'Ù'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x18, 0x00, ##     00      
            0x0C, 0x00, ##      00     
            0x04, 0x00, ##       0     
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0x40, 0xC0, ##   0      00 
            0x60, 0xC0, ##   00     00 
            0x1F, 0x00, ##     00000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '218' => {    # 'Ú'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x03, 0x00, ##        00   
            0x06, 0x00, ##       00    
            0x04, 0x00, ##       0     
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0x40, 0xC0, ##   0      00 
            0x60, 0xC0, ##   00     00 
            0x1F, 0x00, ##     00000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '219' => {    # 'Û'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x04, 0x00, ##       0     
            0x0A, 0x00, ##      0 0    
            0x11, 0x00, ##     0   0   
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0x40, 0xC0, ##   0      00 
            0x60, 0xC0, ##   00     00 
            0x1F, 0x00, ##     00000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '220' => {    # 'Ü'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x1B, 0x00, ##     00 00   
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0x40, 0xC0, ##   0      00 
            0x60, 0xC0, ##   00     00 
            0x1F, 0x00, ##     00000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '221' => {    # 'Ý'
        'width'    => 12, 
        'xoffset'  => 0, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x03, 0x00, ##        00    
            0x06, 0x00, ##       00     
            0x04, 0x00, ##       0      
            0x00, 0x00, ##              
            0xC0, 0x30, ##  00        00
            0x60, 0x60, ##   00      00 
            0x30, 0xC0, ##    00    00  
            0x30, 0xC0, ##    00    00  
            0x19, 0x80, ##     00  00   
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x06, 0x00, ##       00     
            0x06, 0x00, ##       00     
            0x06, 0x00, ##       00     
            0x06, 0x00, ##       00     
            0x06, 0x00, ##       00     
            0x06, 0x00, ##       00     
            0x06, 0x00, ##       00     
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '222' => {    # 'Þ'
        'width'    => 9, 
        'xoffset'  => 2, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xFE, 0x00, ##  0000000  
            0xC3, 0x00, ##  00    00 
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC3, 0x00, ##  00    00 
            0xFE, 0x00, ##  0000000  
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '223' => {    # 'ß'
        'width'    => 10, 
        'xoffset'  => 2, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x3E, 0x00, ##    00000   
            0x63, 0x00, ##   00   00  
            0xC1, 0x00, ##  00     0  
            0xC3, 0x80, ##  00    000 
            0xC6, 0x00, ##  00   00   
            0xCC, 0x00, ##  00  00    
            0xCC, 0x00, ##  00  00    
            0xCE, 0x00, ##  00  000   
            0xC7, 0x00, ##  00   000  
            0xC3, 0x80, ##  00    000 
            0xC1, 0xC0, ##  00     000
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC1, 0x80, ##  00     00 
            0xDF, 0x00, ##  00 00000  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '224' => {    # 'à'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x30, 0x00, ##    00     
            0x10, 0x00, ##     0     
            0x08, 0x00, ##      0    
            0x0C, 0x00, ##      00   
            0x00, 0x00, ##           
            0x7E, 0x00, ##   000000  
            0x43, 0x00, ##   0    00 
            0x01, 0x80, ##         00
            0x01, 0x80, ##         00
            0x3F, 0x80, ##    0000000
            0x61, 0x80, ##   00    00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC3, 0x80, ##  00    000
            0xE3, 0x80, ##  000   000
            0x7D, 0x80, ##   00000 00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '225' => {    # 'á'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x06, 0x00, ##       00  
            0x04, 0x00, ##       0   
            0x08, 0x00, ##      0    
            0x18, 0x00, ##     00    
            0x00, 0x00, ##           
            0x7E, 0x00, ##   000000  
            0x43, 0x00, ##   0    00 
            0x01, 0x80, ##         00
            0x01, 0x80, ##         00
            0x3F, 0x80, ##    0000000
            0x61, 0x80, ##   00    00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC3, 0x80, ##  00    000
            0xE3, 0x80, ##  000   000
            0x7D, 0x80, ##   00000 00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '226' => {    # 'â'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x08, 0x00, ##      0    
            0x14, 0x00, ##     0 0   
            0x36, 0x00, ##    00 00  
            0x22, 0x00, ##    0   0  
            0x00, 0x00, ##           
            0x7E, 0x00, ##   000000  
            0x43, 0x00, ##   0    00 
            0x01, 0x80, ##         00
            0x01, 0x80, ##         00
            0x3F, 0x80, ##    0000000
            0x61, 0x80, ##   00    00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC3, 0x80, ##  00    000
            0xE3, 0x80, ##  000   000
            0x7D, 0x80, ##   00000 00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '227' => {    # 'ã'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x19, 0x00, ##     00  0 
            0x27, 0x00, ##    0  000 
            0x00, 0x00, ##           
            0x00, 0x00, ##           
            0x7E, 0x00, ##   000000  
            0x43, 0x00, ##   0    00 
            0x01, 0x80, ##         00
            0x01, 0x80, ##         00
            0x3F, 0x80, ##    0000000
            0x61, 0x80, ##   00    00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC3, 0x80, ##  00    000
            0xE3, 0x80, ##  000   000
            0x7D, 0x80, ##   00000 00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '228' => {    # 'ä'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x33, 0x00, ##    00  00 
            0x00, 0x00, ##           
            0x00, 0x00, ##           
            0x00, 0x00, ##           
            0x7E, 0x00, ##   000000  
            0x43, 0x00, ##   0    00 
            0x01, 0x80, ##         00
            0x01, 0x80, ##         00
            0x3F, 0x80, ##    0000000
            0x61, 0x80, ##   00    00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC3, 0x80, ##  00    000
            0xE3, 0x80, ##  000   000
            0x7D, 0x80, ##   00000 00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '229' => {    # 'å'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1C, 0x00, ##     000   
            0x22, 0x00, ##    0   0  
            0x22, 0x00, ##    0   0  
            0x22, 0x00, ##    0   0  
            0x1C, 0x00, ##     000   
            0x00, 0x00, ##           
            0x7E, 0x00, ##   000000  
            0x43, 0x00, ##   0    00 
            0x01, 0x80, ##         00
            0x01, 0x80, ##         00
            0x3F, 0x80, ##    0000000
            0x61, 0x80, ##   00    00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC3, 0x80, ##  00    000
            0xE3, 0x80, ##  000   000
            0x7D, 0x80, ##   00000 00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '230' => {    # 'æ'
        'width'    => 17, 
        'xoffset'  => 1, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x7E, 0x3E, 0x00, ##   000000   00000  
            0x43, 0x63, 0x00, ##   0    00 00   00 
            0x01, 0xC3, 0x00, ##         000    00 
            0x01, 0x81, 0x80, ##         00      00
            0x3F, 0x81, 0x80, ##    0000000      00
            0x61, 0xFF, 0x80, ##   00    0000000000
            0xC1, 0x80, 0x00, ##  00     00        
            0xC1, 0x80, 0x00, ##  00     00        
            0xC3, 0xC0, 0x00, ##  00    0000       
            0xE2, 0xE1, 0x80, ##  000   0 000    00
            0x3C, 0x3F, 0x00, ##    0000    000000 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '231' => {    # 'ç'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1F, 0x80, ##     000000
            0x70, 0x80, ##   000    0
            0x60, 0x00, ##   00      
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0xC0, 0x00, ##  00       
            0x60, 0x00, ##   00      
            0x70, 0x80, ##   000    0
            0x1F, 0x80, ##     000000
            0x04, 0x00, ##       0   
            0x06, 0x00, ##       00  
            0x06, 0x00, ##       00  
            0x1C, 0x00, ##     000   
        ], 
    }, 
    '232' => {    # 'è'
        'width'    => 10, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x30, 0x00, ##    00      
            0x18, 0x00, ##     00     
            0x0C, 0x00, ##      00    
            0x04, 0x00, ##       0    
            0x00, 0x00, ##            
            0x1E, 0x00, ##     0000   
            0x71, 0x80, ##   000   00 
            0x61, 0x80, ##   00    00 
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xFF, 0xC0, ##  0000000000
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0x60, 0x00, ##   00       
            0x70, 0xC0, ##   000    00
            0x1F, 0x80, ##     000000 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '233' => {    # 'é'
        'width'    => 10, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x03, 0x00, ##        00  
            0x06, 0x00, ##       00   
            0x04, 0x00, ##       0    
            0x08, 0x00, ##      0     
            0x00, 0x00, ##            
            0x1E, 0x00, ##     0000   
            0x71, 0x80, ##   000   00 
            0x61, 0x80, ##   00    00 
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xFF, 0xC0, ##  0000000000
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0x60, 0x00, ##   00       
            0x70, 0xC0, ##   000    00
            0x1F, 0x80, ##     000000 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '234' => {    # 'ê'
        'width'    => 10, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0C, 0x00, ##      00    
            0x1E, 0x00, ##     0000   
            0x12, 0x00, ##     0  0   
            0x21, 0x00, ##    0    0  
            0x00, 0x00, ##            
            0x1E, 0x00, ##     0000   
            0x71, 0x80, ##   000   00 
            0x61, 0x80, ##   00    00 
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xFF, 0xC0, ##  0000000000
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0x60, 0x00, ##   00       
            0x70, 0xC0, ##   000    00
            0x1F, 0x80, ##     000000 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '235' => {    # 'ë'
        'width'    => 10, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x33, 0x00, ##    00  00  
            0x00, 0x00, ##            
            0x00, 0x00, ##            
            0x00, 0x00, ##            
            0x1E, 0x00, ##     0000   
            0x71, 0x80, ##   000   00 
            0x61, 0x80, ##   00    00 
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xFF, 0xC0, ##  0000000000
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0x60, 0x00, ##   00       
            0x70, 0xC0, ##   000    00
            0x1F, 0x80, ##     000000 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '236' => {    # 'ì'
        'width'    => 4, 
        'xoffset'  => 0, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x80, ##  0   
            0xC0, ##  00  
            0x60, ##   00 
            0x30, ##    00
            0x00, ##      
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '237' => {    # 'í'
        'width'    => 4, 
        'xoffset'  => 2, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x30, ##    00
            0x20, ##    0 
            0x60, ##   00 
            0xC0, ##  00  
            0x00, ##      
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0xC0, ##  00  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '238' => {    # 'î'
        'width'    => 6, 
        'xoffset'  => 0, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x30, ##    00  
            0x70, ##   000  
            0x48, ##   0  0 
            0xCC, ##  00  00
            0x00, ##        
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '239' => {    # 'ï'
        'width'    => 6, 
        'xoffset'  => 0, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xCC, ##  00  00
            0x00, ##        
            0x00, ##        
            0x00, ##        
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x30, ##    00  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '240' => {    # 'ð'
        'width'    => 10, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x38, 0x80, ##    000   0 
            0x1F, 0x00, ##     00000  
            0x7C, 0x00, ##   00000    
            0x06, 0x00, ##       00   
            0x1F, 0x00, ##     00000  
            0x71, 0x80, ##   000   00 
            0x60, 0x80, ##   00     0 
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0x61, 0x80, ##   00    00 
            0x61, 0x80, ##   00    00 
            0x1E, 0x00, ##     0000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '241' => {    # 'ñ'
        'width'    => 9, 
        'xoffset'  => 2, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x19, 0x00, ##     00  0 
            0x27, 0x00, ##    0  000 
            0x00, 0x00, ##           
            0x00, 0x00, ##           
            0xDE, 0x00, ##  00 0000  
            0xE3, 0x00, ##  000   00 
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '242' => {    # 'ò'
        'width'    => 10, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x30, 0x00, ##    00      
            0x18, 0x00, ##     00     
            0x0C, 0x00, ##      00    
            0x04, 0x00, ##       0    
            0x00, 0x00, ##            
            0x1E, 0x00, ##     0000   
            0x73, 0x80, ##   000  000 
            0x61, 0x80, ##   00    00 
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0x61, 0x80, ##   00    00 
            0x61, 0x80, ##   00    00 
            0x1E, 0x00, ##     0000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '243' => {    # 'ó'
        'width'    => 10, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x03, 0x00, ##        00  
            0x06, 0x00, ##       00   
            0x0C, 0x00, ##      00    
            0x08, 0x00, ##      0     
            0x00, 0x00, ##            
            0x1E, 0x00, ##     0000   
            0x73, 0x80, ##   000  000 
            0x61, 0x80, ##   00    00 
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0x61, 0x80, ##   00    00 
            0x61, 0x80, ##   00    00 
            0x1E, 0x00, ##     0000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '244' => {    # 'ô'
        'width'    => 10, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0C, 0x00, ##      00    
            0x1E, 0x00, ##     0000   
            0x12, 0x00, ##     0  0   
            0x21, 0x00, ##    0    0  
            0x00, 0x00, ##            
            0x1E, 0x00, ##     0000   
            0x73, 0x80, ##   000  000 
            0x61, 0x80, ##   00    00 
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0x61, 0x80, ##   00    00 
            0x61, 0x80, ##   00    00 
            0x1E, 0x00, ##     0000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '245' => {    # 'õ'
        'width'    => 10, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x19, 0x00, ##     00  0  
            0x27, 0x00, ##    0  000  
            0x00, 0x00, ##            
            0x00, 0x00, ##            
            0x1E, 0x00, ##     0000   
            0x73, 0x80, ##   000  000 
            0x61, 0x80, ##   00    00 
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0x61, 0x80, ##   00    00 
            0x61, 0x80, ##   00    00 
            0x1E, 0x00, ##     0000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '246' => {    # 'ö'
        'width'    => 10, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x33, 0x00, ##    00  00  
            0x00, 0x00, ##            
            0x00, 0x00, ##            
            0x00, 0x00, ##            
            0x1E, 0x00, ##     0000   
            0x73, 0x80, ##   000  000 
            0x61, 0x80, ##   00    00 
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0x61, 0x80, ##   00    00 
            0x61, 0x80, ##   00    00 
            0x1E, 0x00, ##     0000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '247' => {    # '÷'
        'width'    => 13, 
        'xoffset'  => 2, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x06, 0x00, ##       00      
            0x00, 0x00, ##               
            0x00, 0x00, ##               
            0xFF, 0xF8, ##  0000000000000
            0x00, 0x00, ##               
            0x00, 0x00, ##               
            0x06, 0x00, ##       00      
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '248' => {    # 'ø'
        'width'    => 10, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x40, ##           0
            0x1F, 0xC0, ##     0000000
            0x71, 0x80, ##   000   00 
            0x61, 0x80, ##   00    00 
            0xC3, 0xC0, ##  00    0000
            0xC6, 0xC0, ##  00   00 00
            0xCC, 0xC0, ##  00  00  00
            0xC8, 0xC0, ##  00  0   00
            0xD0, 0xC0, ##  00 0    00
            0x71, 0x80, ##   000   00 
            0x61, 0x80, ##   00    00 
            0xFE, 0x00, ##  0000000   
            0x80, 0x00, ##  0         
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '249' => {    # 'ù'
        'width'    => 9, 
        'xoffset'  => 2, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x30, 0x00, ##    00     
            0x10, 0x00, ##     0     
            0x18, 0x00, ##     00    
            0x0C, 0x00, ##      00   
            0x00, 0x00, ##           
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0x63, 0x80, ##   00   000
            0x3D, 0x80, ##    0000 00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '250' => {    # 'ú'
        'width'    => 9, 
        'xoffset'  => 2, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x06, 0x00, ##       00  
            0x04, 0x00, ##       0   
            0x08, 0x00, ##      0    
            0x18, 0x00, ##     00    
            0x00, 0x00, ##           
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0x63, 0x80, ##   00   000
            0x3D, 0x80, ##    0000 00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '251' => {    # 'û'
        'width'    => 9, 
        'xoffset'  => 2, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x18, 0x00, ##     00    
            0x14, 0x00, ##     0 0   
            0x36, 0x00, ##    00 00  
            0x22, 0x00, ##    0   0  
            0x00, 0x00, ##           
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0x63, 0x80, ##   00   000
            0x3D, 0x80, ##    0000 00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '252' => {    # 'ü'
        'width'    => 9, 
        'xoffset'  => 2, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x36, 0x00, ##    00 00  
            0x00, 0x00, ##           
            0x00, 0x00, ##           
            0x00, 0x00, ##           
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0xC1, 0x80, ##  00     00
            0x63, 0x80, ##   00   000
            0x3D, 0x80, ##    0000 00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '253' => {    # 'ý'
        'width'    => 11, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x03, 0x00, ##        00   
            0x02, 0x00, ##        0    
            0x06, 0x00, ##       00    
            0x0C, 0x00, ##      00     
            0x00, 0x00, ##             
            0xC0, 0x40, ##  00       0 
            0x40, 0xC0, ##   0      00 
            0x60, 0xC0, ##   00     00 
            0x61, 0x80, ##   00    00  
            0x31, 0x80, ##    00   00  
            0x31, 0x00, ##    00   0   
            0x13, 0x00, ##     0  00   
            0x1B, 0x00, ##     00 00   
            0x1E, 0x00, ##     0000    
            0x0E, 0x00, ##      000    
            0x0C, 0x00, ##      00     
            0x0C, 0x00, ##      00     
            0x0C, 0x00, ##      00     
            0x18, 0x00, ##     00      
            0x70, 0x00, ##   000       
        ], 
    }, 
    '254' => {    # 'þ'
        'width'    => 10, 
        'xoffset'  => 2, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xDE, 0x00, ##  00 0000   
            0xE3, 0x80, ##  000   000 
            0xE1, 0x80, ##  000    00 
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xE1, 0x80, ##  000    00 
            0xE1, 0x80, ##  000    00 
            0xDF, 0x00, ##  00 00000  
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
        ], 
    }, 
    '255' => {    # 'ÿ'
        'width'    => 10, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x33, 0x00, ##    00  00  
            0x00, 0x00, ##            
            0x00, 0x00, ##            
            0x00, 0x00, ##            
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0x40, 0x80, ##   0      0 
            0x61, 0x80, ##   00    00 
            0x61, 0x80, ##   00    00 
            0x33, 0x00, ##    00  00  
            0x33, 0x00, ##    00  00  
            0x12, 0x00, ##     0  0   
            0x1E, 0x00, ##     0000   
            0x1E, 0x00, ##     0000   
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x18, 0x00, ##     00     
            0x18, 0x00, ##     00     
            0xF0, 0x00, ##  0000      
        ], 
    }, 
};
 
my $kerning = {
    '33' => { },  # !
    '34' => { },  # "
    '35' => { },  # #
    '36' => { },  # $
    '37' => { },  # %
    '38' => { },  # &
    '39' => { },  # '
    '40' => { },  # (
    '41' => { },  # )
    '42' => { },  # *
    '43' => { },  # +
    '44' => { },  # ,
    '45' => { '66' => -1, '71' => 1, '74' => 1, '81' => 1, '84' => -1, '86' => -1, '87' => -1, '88' => -1, '89' => -2, '221' => -2, },  # -
    '46' => { },  # .
    '47' => { },  # /
    '48' => { },  # 0
    '49' => { },  # 1
    '50' => { },  # 2
    '51' => { },  # 3
    '52' => { },  # 4
    '53' => { },  # 5
    '54' => { },  # 6
    '55' => { },  # 7
    '56' => { },  # 8
    '57' => { },  # 9
    '58' => { },  # :
    '59' => { },  # ;
    '60' => { },  # <
    '61' => { },  # =
    '62' => { },  # >
    '63' => { },  # ?
    '64' => { },  # @
    '65' => { '84' => -1, '86' => -1, '87' => -1, '89' => -1, '102' => -1, '118' => -1, '119' => -1, '121' => -1, '171' => -1, '221' => -1, '253' => -1, '255' => -1, },  # A
    '66' => { '87' => -1, '89' => -1, '221' => -1, },  # B
    '67' => { },  # C
    '68' => { '89' => -1, '221' => -1, },  # D
    '69' => { },  # E
    '70' => { '46' => -3, '58' => -1, '65' => -1, '97' => -1, '101' => -1, '105' => -1, '111' => -1, '114' => -1, '117' => -1, '121' => -1, '192' => -1, '193' => -1, '194' => -1, '195' => -1, '196' => -1, '224' => -1, '225' => -1, '226' => -1, '227' => -1, '228' => -1, '229' => -1, '232' => -1, '233' => -1, '234' => -1, '235' => -1, '242' => -1, '243' => -1, '244' => -1, '245' => -1, '246' => -1, '249' => -1, '250' => -1, '251' => -1, '252' => -1, '253' => -1, '255' => -1, },  # F
    '71' => { '84' => -1, '89' => -1, '221' => -1, },  # G
    '72' => { },  # H
    '73' => { },  # I
    '74' => { '45' => -1, },  # J
    '75' => { '45' => -2, '67' => -1, '79' => -1, '84' => -1, '87' => -1, '89' => -1, '101' => -1, '111' => -1, '117' => -1, '121' => -1, '171' => -1, '199' => -1, '210' => -1, '211' => -1, '212' => -1, '213' => -1, '214' => -1, '221' => -1, '232' => -1, '233' => -1, '234' => -1, '235' => -1, '242' => -1, '243' => -1, '244' => -1, '245' => -1, '246' => -1, '249' => -1, '250' => -1, '251' => -1, '252' => -1, '253' => -1, '255' => -1, },  # K
    '76' => { '79' => -1, '84' => -2, '85' => -1, '86' => -2, '87' => -1, '89' => -2, '121' => -1, '210' => -1, '211' => -1, '212' => -1, '213' => -1, '214' => -1, '217' => -1, '218' => -1, '219' => -1, '220' => -1, '221' => -2, '253' => -1, '255' => -1, },  # L
    '77' => { },  # M
    '78' => { },  # N
    '79' => { '46' => -1, '88' => -1, '89' => -1, '221' => -1, },  # O
    '80' => { '46' => -2, '65' => -1, '97' => -1, '101' => -1, '111' => -1, '192' => -1, '193' => -1, '194' => -1, '195' => -1, '196' => -1, '224' => -1, '225' => -1, '226' => -1, '227' => -1, '228' => -1, '229' => -1, '232' => -1, '233' => -1, '234' => -1, '235' => -1, '242' => -1, '243' => -1, '244' => -1, '245' => -1, '246' => -1, },  # P
    '81' => { },  # Q
    '82' => { '45' => -1, '46' => -1, '65' => -1, '67' => -1, '84' => -1, '86' => -1, '87' => -1, '89' => -1, '101' => -1, '111' => -1, '117' => -1, '121' => -1, '171' => -1, '192' => -1, '193' => -1, '194' => -1, '195' => -1, '196' => -1, '199' => -1, '221' => -1, '232' => -1, '233' => -1, '234' => -1, '235' => -1, '242' => -1, '243' => -1, '244' => -1, '245' => -1, '246' => -1, '249' => -1, '250' => -1, '251' => -1, '252' => -1, '253' => -1, '255' => -1, },  # R
    '83' => { },  # S
    '84' => { '45' => -1, '46' => -2, '58' => -2, '65' => -1, '67' => -1, '97' => -3, '99' => -3, '101' => -3, '111' => -3, '114' => -2, '115' => -3, '117' => -2, '119' => -3, '121' => -2, '171' => -1, '187' => -1, '192' => -1, '193' => -1, '194' => -1, '195' => -1, '196' => -1, '199' => -1, '224' => -3, '225' => -3, '226' => -3, '227' => -3, '228' => -3, '229' => -3, '231' => -3, '232' => -3, '233' => -3, '234' => -3, '235' => -3, '242' => -3, '243' => -3, '244' => -3, '245' => -3, '246' => -3, '249' => -2, '250' => -2, '251' => -2, '252' => -2, '253' => -2, '255' => -2, },  # T
    '85' => { },  # U
    '86' => { '45' => -1, '46' => -2, '58' => -1, '65' => -1, '97' => -1, '101' => -1, '111' => -1, '117' => -1, '171' => -1, '187' => -1, '192' => -1, '193' => -1, '194' => -1, '195' => -1, '196' => -1, '224' => -1, '225' => -1, '226' => -1, '227' => -1, '228' => -1, '229' => -1, '232' => -1, '233' => -1, '234' => -1, '235' => -1, '242' => -1, '243' => -1, '244' => -1, '245' => -1, '246' => -1, '249' => -1, '250' => -1, '251' => -1, '252' => -1, },  # V
    '87' => { '45' => -1, '46' => -2, '58' => -1, '65' => -1, '97' => -1, '101' => -1, '111' => -1, '114' => -1, '117' => -1, '171' => -1, '192' => -1, '193' => -1, '194' => -1, '195' => -1, '196' => -1, '224' => -1, '225' => -1, '226' => -1, '227' => -1, '228' => -1, '229' => -1, '232' => -1, '233' => -1, '234' => -1, '235' => -1, '242' => -1, '243' => -1, '244' => -1, '245' => -1, '246' => -1, '249' => -1, '250' => -1, '251' => -1, '252' => -1, },  # W
    '88' => { '45' => -1, '67' => -1, '79' => -1, '101' => -1, '171' => -1, '199' => -1, '210' => -1, '211' => -1, '212' => -1, '213' => -1, '214' => -1, '232' => -1, '233' => -1, '234' => -1, '235' => -1, },  # X
    '89' => { '45' => -2, '46' => -3, '58' => -2, '65' => -1, '67' => -1, '79' => -1, '97' => -2, '101' => -2, '105' => -1, '111' => -2, '117' => -2, '171' => -2, '187' => -1, '192' => -1, '193' => -1, '194' => -1, '195' => -1, '196' => -1, '199' => -1, '210' => -1, '211' => -1, '212' => -1, '213' => -1, '214' => -1, '224' => -2, '225' => -2, '226' => -2, '227' => -2, '228' => -2, '229' => -2, '232' => -2, '233' => -2, '234' => -2, '235' => -2, '242' => -2, '243' => -2, '244' => -2, '245' => -2, '246' => -2, '249' => -2, '250' => -2, '251' => -2, '252' => -2, },  # Y
    '90' => { },  # Z
    '91' => { },  # [
    '92' => { },  # \
    '93' => { },  # ]
    '94' => { },  # ^
    '95' => { },  # _
    '96' => { },  # `
    '97' => { },  # a
    '98' => { },  # b
    '99' => { },  # c
    '100' => { },  # d
    '101' => { },  # e
    '102' => { '45' => -1, '46' => -1, '58' => -1, '171' => -1, },  # f
    '103' => { },  # g
    '104' => { },  # h
    '105' => { },  # i
    '106' => { },  # j
    '107' => { '101' => -1, '111' => -1, '121' => -1, '232' => -1, '233' => -1, '234' => -1, '235' => -1, '242' => -1, '243' => -1, '244' => -1, '245' => -1, '246' => -1, '253' => -1, '255' => -1, },  # k
    '108' => { },  # l
    '109' => { },  # m
    '110' => { },  # n
    '111' => { },  # o
    '112' => { },  # p
    '113' => { },  # q
    '114' => { '45' => -1, '46' => -1, '171' => -1, },  # r
    '115' => { },  # s
    '116' => { },  # t
    '117' => { },  # u
    '118' => { '46' => -1, '58' => -1, },  # v
    '119' => { '46' => -1, '58' => -1, },  # w
    '120' => { },  # x
    '121' => { '46' => -2, '58' => -1, },  # y
    '122' => { },  # z
    '123' => { },  # {
    '124' => { },  # |
    '125' => { },  # }
    '126' => { },  # ~
    '160' => { },  #  
    '161' => { },  # ¡
    '162' => { },  # ¢
    '163' => { },  # £
    '164' => { },  # ¤
    '165' => { },  # ¥
    '166' => { },  # ¦
    '167' => { },  # §
    '168' => { },  # ¨
    '169' => { },  # ©
    '170' => { },  # ª
    '171' => { '84' => -1, '86' => -1, '89' => -1, '198' => 1, '221' => -1, },  # «
    '172' => { },  # ¬
    '173' => { },  # ­
    '174' => { },  # ®
    '175' => { },  # ¯
    '176' => { },  # °
    '177' => { },  # ±
    '178' => { },  # ²
    '179' => { },  # ³
    '180' => { },  # ´
    '181' => { },  # µ
    '182' => { },  # ¶
    '183' => { },  # ·
    '184' => { },  # ¸
    '185' => { },  # ¹
    '186' => { },  # º
    '187' => { '65' => -1, '66' => -1, '84' => -1, '86' => -1, '87' => -1, '88' => -1, '89' => -2, '192' => -1, '193' => -1, '194' => -1, '195' => -1, '196' => -1, '221' => -2, },  # »
    '188' => { },  # ¼
    '189' => { },  # ½
    '190' => { },  # ¾
    '191' => { },  # ¿
    '192' => { '84' => -1, '86' => -1, '87' => -1, '89' => -1, '102' => -1, '118' => -1, '119' => -1, '121' => -1, '171' => -1, '221' => -1, '253' => -1, '255' => -1, },  # À
    '193' => { '84' => -1, '86' => -1, '87' => -1, '89' => -1, '102' => -1, '118' => -1, '119' => -1, '121' => -1, '171' => -1, '221' => -1, '253' => -1, '255' => -1, },  # Á
    '194' => { '84' => -1, '86' => -1, '87' => -1, '89' => -1, '102' => -1, '118' => -1, '119' => -1, '121' => -1, '171' => -1, '221' => -1, '253' => -1, '255' => -1, },  # Â
    '195' => { '84' => -1, '86' => -1, '87' => -1, '89' => -1, '102' => -1, '118' => -1, '119' => -1, '121' => -1, '171' => -1, '221' => -1, '253' => -1, '255' => -1, },  # Ã
    '196' => { '84' => -1, '86' => -1, '87' => -1, '89' => -1, '102' => -1, '118' => -1, '119' => -1, '121' => -1, '171' => -1, '221' => -1, '253' => -1, '255' => -1, },  # Ä
    '197' => { },  # Å
    '198' => { },  # Æ
    '199' => { },  # Ç
    '200' => { },  # È
    '201' => { },  # É
    '202' => { },  # Ê
    '203' => { },  # Ë
    '204' => { },  # Ì
    '205' => { },  # Í
    '206' => { },  # Î
    '207' => { },  # Ï
    '208' => { },  # Ð
    '209' => { },  # Ñ
    '210' => { '46' => -1, '88' => -1, '89' => -1, '221' => -1, },  # Ò
    '211' => { '46' => -1, '88' => -1, '89' => -1, '221' => -1, },  # Ó
    '212' => { '46' => -1, '88' => -1, '89' => -1, '221' => -1, },  # Ô
    '213' => { '46' => -1, '88' => -1, '89' => -1, '221' => -1, },  # Õ
    '214' => { '46' => -1, '88' => -1, '89' => -1, '221' => -1, },  # Ö
    '215' => { },  # ×
    '216' => { },  # Ø
    '217' => { },  # Ù
    '218' => { },  # Ú
    '219' => { },  # Û
    '220' => { },  # Ü
    '221' => { '45' => -2, '46' => -3, '58' => -2, '65' => -1, '67' => -1, '79' => -1, '97' => -2, '101' => -2, '105' => -1, '111' => -2, '117' => -2, '171' => -2, '187' => -1, '192' => -1, '193' => -1, '194' => -1, '195' => -1, '196' => -1, '199' => -1, '210' => -1, '211' => -1, '212' => -1, '213' => -1, '214' => -1, '224' => -2, '225' => -2, '226' => -2, '227' => -2, '228' => -2, '229' => -2, '232' => -2, '233' => -2, '234' => -2, '235' => -2, '242' => -2, '243' => -2, '244' => -2, '245' => -2, '246' => -2, '249' => -2, '250' => -2, '251' => -2, '252' => -2, },  # Ý
    '222' => { '46' => -1, '58' => -1, },  # Þ
    '223' => { },  # ß
    '224' => { },  # à
    '225' => { },  # á
    '226' => { },  # â
    '227' => { },  # ã
    '228' => { },  # ä
    '229' => { },  # å
    '230' => { },  # æ
    '231' => { },  # ç
    '232' => { },  # è
    '233' => { },  # é
    '234' => { },  # ê
    '235' => { },  # ë
    '236' => { },  # ì
    '237' => { },  # í
    '238' => { },  # î
    '239' => { },  # ï
    '240' => { },  # ð
    '241' => { },  # ñ
    '242' => { },  # ò
    '243' => { },  # ó
    '244' => { },  # ô
    '245' => { },  # õ
    '246' => { },  # ö
    '247' => { },  # ÷
    '248' => { },  # ø
    '249' => { },  # ù
    '250' => { },  # ú
    '251' => { },  # û
    '252' => { },  # ü
    '253' => { '46' => -2, '58' => -1, },  # ý
    '254' => { },  # þ
    '255' => { '46' => -2, '58' => -1, },  # ÿ
};


sub new {
    my($class) = @_;
    
    my $self = $class->SUPER::new(
        name        => $name,
        char_height => $char_height,
        space_width => $space_width,
        gap_width   => $gap_width,
        symbols     => $symbols,
        kerning     => $kerning,
        line_spacing => $line_spacing,
        class       => 'hipi_2',
    );
    
    return $self;
}

1;

__END__
