#########################################################################################
# Package        HiPi::Interface::MonoOLED::Font::Sans26
# Description  : Monochrome OLED Font
# License      : This is free software; you can redistribute it and/or modify it under
#                the same terms as the Perl 5 programming language system itself.
#########################################################################################

package HiPi::Interface::MonoOLED::Font::Sans26;

#########################################################################################

use utf8;
use strict;
use warnings;
use parent qw( HiPi::Interface::MonoOLED::Font);

our $VERSION ='0.70';

my $gap_width = 0;
my $char_height = 26;
my $line_spacing = 2;
my $name = 'Sans 26';
my $space_width = 8;
 
my $symbols = {
    '33' => {    # '!'
        'width'    => 2, 
        'xoffset'  => 4, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0x00, ##    
            0x00, ##    
            0x00, ##    
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '34' => {    # '"'
        'width'    => 6, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xCC, ##  00  00
            0xCC, ##  00  00
            0xCC, ##  00  00
            0xCC, ##  00  00
            0xCC, ##  00  00
            0xCC, ##  00  00
            0xCC, ##  00  00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '35' => {    # '#'
        'width'    => 16, 
        'xoffset'  => 2, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x03, 0x0C, ##        00    00  
            0x03, 0x0C, ##        00    00  
            0x03, 0x18, ##        00   00   
            0x03, 0x18, ##        00   00   
            0x06, 0x18, ##       00    00   
            0x7F, 0xFF, ##   000000000000000
            0x7F, 0xFF, ##   000000000000000
            0x06, 0x30, ##       00   00    
            0x0C, 0x30, ##      00    00    
            0x0C, 0x30, ##      00    00    
            0x0C, 0x60, ##      00   00     
            0xFF, 0xFE, ##  000000000000000 
            0xFF, 0xFE, ##  000000000000000 
            0x18, 0x60, ##     00    00     
            0x18, 0xC0, ##     00   00      
            0x18, 0xC0, ##     00   00      
            0x10, 0xC0, ##     0    00      
            0x30, 0xC0, ##    00    00      
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '36' => {    # '$'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x04, 0x00, ##       0     
            0x04, 0x00, ##       0     
            0x04, 0x00, ##       0     
            0x3F, 0x80, ##    0000000  
            0x7F, 0xC0, ##   000000000 
            0xE4, 0x40, ##  000  0   0 
            0xC4, 0x00, ##  00   0     
            0xC4, 0x00, ##  00   0     
            0xC4, 0x00, ##  00   0     
            0x74, 0x00, ##   000 0     
            0x3F, 0x00, ##    000000   
            0x0F, 0xC0, ##      000000 
            0x04, 0xE0, ##       0  000
            0x04, 0x60, ##       0   00
            0x04, 0x60, ##       0   00
            0x04, 0x60, ##       0   00
            0xC4, 0xE0, ##  00   0  000
            0xFF, 0xC0, ##  0000000000 
            0x3F, 0x80, ##    0000000  
            0x04, 0x00, ##       0     
            0x04, 0x00, ##       0     
            0x04, 0x00, ##       0     
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '37' => {    # '%'
        'width'    => 20, 
        'xoffset'  => 1, 
        'xadvance' => 22, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x3C, 0x03, 0x00, ##    0000        00    
            0x7E, 0x02, 0x00, ##   000000       0     
            0xE7, 0x06, 0x00, ##  000  000     00     
            0xC3, 0x0C, 0x00, ##  00    00    00      
            0xC3, 0x0C, 0x00, ##  00    00    00      
            0xC3, 0x18, 0x00, ##  00    00   00       
            0xE7, 0x10, 0x00, ##  000  000   0        
            0x7E, 0x30, 0x00, ##   000000   00        
            0x3C, 0x63, 0xC0, ##    0000   00   0000  
            0x00, 0x67, 0xE0, ##           00  000000 
            0x00, 0xCE, 0x70, ##          00  000  000
            0x00, 0x8C, 0x30, ##          0   00    00
            0x01, 0x8C, 0x30, ##         00   00    00
            0x03, 0x0C, 0x30, ##        00    00    00
            0x03, 0x0C, 0x30, ##        00    00    00
            0x06, 0x0E, 0x70, ##       00     000  000
            0x04, 0x07, 0xE0, ##       0       000000 
            0x0C, 0x03, 0xC0, ##      00        0000  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '38' => {    # '&'
        'width'    => 17, 
        'xoffset'  => 2, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x0F, 0xC0, 0x00, ##      000000       
            0x1F, 0xE0, 0x00, ##     00000000      
            0x38, 0x60, 0x00, ##    000    00      
            0x30, 0x00, 0x00, ##    00             
            0x30, 0x00, 0x00, ##    00             
            0x30, 0x00, 0x00, ##    00             
            0x18, 0x00, 0x00, ##     00            
            0x3C, 0x00, 0x00, ##    0000           
            0x66, 0x07, 0x00, ##   00  00      000 
            0x63, 0x06, 0x00, ##   00   00     00  
            0xC1, 0x86, 0x00, ##  00     00    00  
            0xC0, 0xC6, 0x00, ##  00      00   00  
            0xC0, 0xEC, 0x00, ##  00      000 00   
            0xC0, 0x7C, 0x00, ##  00       00000   
            0xE0, 0x3C, 0x00, ##  000       0000   
            0x70, 0x7C, 0x00, ##   000     00000   
            0x3F, 0xEE, 0x00, ##    000000000 000  
            0x0F, 0x87, 0x00, ##      00000    000 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '39' => {    # '''
        'width'    => 2, 
        'xoffset'  => 2, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '40' => {    # '('
        'width'    => 5, 
        'xoffset'  => 2, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x18, ##     00
            0x30, ##    00 
            0x30, ##    00 
            0x20, ##    0  
            0x60, ##   00  
            0x60, ##   00  
            0x60, ##   00  
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0x60, ##   00  
            0x60, ##   00  
            0x60, ##   00  
            0x30, ##    00 
            0x30, ##    00 
            0x18, ##     00
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '41' => {    # ')'
        'width'    => 5, 
        'xoffset'  => 2, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0xC0, ##  00   
            0x60, ##   00  
            0x60, ##   00  
            0x20, ##    0  
            0x30, ##    00 
            0x30, ##    00 
            0x30, ##    00 
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x30, ##    00 
            0x30, ##    00 
            0x30, ##    00 
            0x60, ##   00  
            0x60, ##   00  
            0xC0, ##  00   
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '42' => {    # '*'
        'width'    => 12, 
        'xoffset'  => 0, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x06, 0x00, ##       00     
            0x06, 0x00, ##       00     
            0x46, 0x20, ##   0   00   0 
            0x66, 0x60, ##   00  00  00 
            0x1F, 0x80, ##     000000   
            0x06, 0x00, ##       00     
            0x1F, 0x80, ##     000000   
            0x66, 0x60, ##   00  00  00 
            0x46, 0x20, ##   0   00   0 
            0x06, 0x00, ##       00     
            0x06, 0x00, ##       00     
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '43' => {    # '+'
        'width'    => 15, 
        'xoffset'  => 3, 
        'xadvance' => 21, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x01, 0x80, ##         00      
            0x01, 0x80, ##         00      
            0x01, 0x80, ##         00      
            0x01, 0x80, ##         00      
            0x01, 0x80, ##         00      
            0x01, 0x80, ##         00      
            0xFF, 0xFE, ##  000000000000000
            0xFF, 0xFE, ##  000000000000000
            0x01, 0x80, ##         00      
            0x01, 0x80, ##         00      
            0x01, 0x80, ##         00      
            0x01, 0x80, ##         00      
            0x01, 0x80, ##         00      
            0x01, 0x80, ##         00      
            0x01, 0x80, ##         00      
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '44' => {    # ','
        'width'    => 3, 
        'xoffset'  => 2, 
        'xadvance' => 7, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x60, ##   00
            0x60, ##   00
            0x60, ##   00
            0x40, ##   0 
            0xC0, ##  00 
            0xC0, ##  00 
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '45' => {    # '-'
        'width'    => 6, 
        'xoffset'  => 1, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xFC, ##  000000
            0xFC, ##  000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '46' => {    # '.'
        'width'    => 2, 
        'xoffset'  => 3, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '47' => {    # '/'
        'width'    => 8, 
        'xoffset'  => 0, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x03, ##        00
            0x03, ##        00
            0x06, ##       00 
            0x06, ##       00 
            0x06, ##       00 
            0x0C, ##      00  
            0x0C, ##      00  
            0x0C, ##      00  
            0x0C, ##      00  
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x30, ##    00    
            0x30, ##    00    
            0x30, ##    00    
            0x60, ##   00     
            0x60, ##   00     
            0x60, ##   00     
            0x60, ##   00     
            0xC0, ##  00      
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '48' => {    # '0'
        'width'    => 12, 
        'xoffset'  => 2, 
        'xadvance' => 16, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0F, 0x00, ##      0000    
            0x3F, 0xC0, ##    00000000  
            0x70, 0xE0, ##   000    000 
            0x60, 0x60, ##   00      00 
            0x60, 0x60, ##   00      00 
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0x60, 0x60, ##   00      00 
            0x60, 0x60, ##   00      00 
            0x70, 0xE0, ##   000    000 
            0x3F, 0xC0, ##    00000000  
            0x0F, 0x00, ##      0000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '49' => {    # '1'
        'width'    => 10, 
        'xoffset'  => 3, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x7C, 0x00, ##   00000    
            0xFC, 0x00, ##  000000    
            0xEC, 0x00, ##  000 00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0x0C, 0x00, ##      00    
            0xFF, 0xC0, ##  0000000000
            0xFF, 0xC0, ##  0000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '50' => {    # '2'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x3F, 0x00, ##    000000   
            0xFF, 0x80, ##  000000000  
            0xC1, 0xC0, ##  00     000 
            0x00, 0xE0, ##          000
            0x00, 0x60, ##           00
            0x00, 0x60, ##           00
            0x00, 0x60, ##           00
            0x00, 0xC0, ##          00 
            0x01, 0xC0, ##         000 
            0x01, 0x80, ##         00  
            0x03, 0x00, ##        00   
            0x06, 0x00, ##       00    
            0x0C, 0x00, ##      00     
            0x18, 0x00, ##     00      
            0x30, 0x00, ##    00       
            0x60, 0x00, ##   00        
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '51' => {    # '3'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x7E, 0x00, ##   000000    
            0xFF, 0x80, ##  000000000  
            0x81, 0xC0, ##  0      000 
            0x00, 0xC0, ##          00 
            0x00, 0xC0, ##          00 
            0x00, 0xC0, ##          00 
            0x01, 0x80, ##         00  
            0x3F, 0x80, ##    0000000  
            0x3E, 0x00, ##    00000    
            0x01, 0x80, ##         00  
            0x00, 0xC0, ##          00 
            0x00, 0x60, ##           00
            0x00, 0x60, ##           00
            0x00, 0x60, ##           00
            0x00, 0xE0, ##          000
            0x81, 0xC0, ##  0      000 
            0xFF, 0x80, ##  000000000  
            0x7E, 0x00, ##   000000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '52' => {    # '4'
        'width'    => 13, 
        'xoffset'  => 1, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x01, 0xC0, ##         000   
            0x03, 0xC0, ##        0000   
            0x03, 0xC0, ##        0000   
            0x06, 0xC0, ##       00 00   
            0x06, 0xC0, ##       00 00   
            0x0C, 0xC0, ##      00  00   
            0x18, 0xC0, ##     00   00   
            0x18, 0xC0, ##     00   00   
            0x30, 0xC0, ##    00    00   
            0x70, 0xC0, ##   000    00   
            0x60, 0xC0, ##   00     00   
            0xC0, 0xC0, ##  00      00   
            0xFF, 0xF8, ##  0000000000000
            0xFF, 0xF8, ##  0000000000000
            0x00, 0xC0, ##          00   
            0x00, 0xC0, ##          00   
            0x00, 0xC0, ##          00   
            0x00, 0xC0, ##          00   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '53' => {    # '5'
        'width'    => 10, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0x80, ##  000000000 
            0xFF, 0x80, ##  000000000 
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xFE, 0x00, ##  0000000   
            0xFF, 0x00, ##  00000000  
            0x83, 0x80, ##  0     000 
            0x01, 0xC0, ##         000
            0x00, 0xC0, ##          00
            0x00, 0xC0, ##          00
            0x00, 0xC0, ##          00
            0x00, 0xC0, ##          00
            0x01, 0xC0, ##         000
            0x83, 0x80, ##  0     000 
            0xFF, 0x00, ##  00000000  
            0xFE, 0x00, ##  0000000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '54' => {    # '6'
        'width'    => 12, 
        'xoffset'  => 2, 
        'xadvance' => 16, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x07, 0xC0, ##       00000  
            0x1F, 0xE0, ##     00000000 
            0x38, 0x20, ##    000     0 
            0x60, 0x00, ##   00         
            0x60, 0x00, ##   00         
            0xC0, 0x00, ##  00          
            0xCF, 0x80, ##  00  00000   
            0xDF, 0xC0, ##  00 0000000  
            0xF0, 0xE0, ##  0000    000 
            0xE0, 0x70, ##  000      000
            0xE0, 0x30, ##  000       00
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0x60, 0x30, ##   00       00
            0x60, 0x70, ##   00      000
            0x70, 0xE0, ##   000    000 
            0x3F, 0xC0, ##    00000000  
            0x0F, 0x80, ##      00000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '55' => {    # '7'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0x00, 0xC0, ##          00 
            0x00, 0xC0, ##          00 
            0x01, 0xC0, ##         000 
            0x01, 0x80, ##         00  
            0x01, 0x80, ##         00  
            0x03, 0x80, ##        000  
            0x03, 0x00, ##        00   
            0x07, 0x00, ##       000   
            0x07, 0x00, ##       000   
            0x06, 0x00, ##       00    
            0x0E, 0x00, ##      000    
            0x0C, 0x00, ##      00     
            0x0C, 0x00, ##      00     
            0x1C, 0x00, ##     000     
            0x18, 0x00, ##     00      
            0x18, 0x00, ##     00      
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '56' => {    # '8'
        'width'    => 12, 
        'xoffset'  => 2, 
        'xadvance' => 16, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1F, 0x80, ##     000000   
            0x3F, 0xC0, ##    00000000  
            0x70, 0xE0, ##   000    000 
            0x60, 0x60, ##   00      00 
            0x60, 0x60, ##   00      00 
            0x60, 0x60, ##   00      00 
            0x70, 0xC0, ##   000    00  
            0x3F, 0x80, ##    0000000   
            0x0F, 0xC0, ##      000000  
            0x30, 0xE0, ##    00    000 
            0x60, 0x70, ##   00      000
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xE0, 0x70, ##  000      000
            0x70, 0xE0, ##   000    000 
            0x7F, 0xE0, ##   0000000000 
            0x1F, 0x80, ##     000000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '57' => {    # '9'
        'width'    => 12, 
        'xoffset'  => 2, 
        'xadvance' => 16, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1F, 0x00, ##     00000    
            0x3F, 0xC0, ##    00000000  
            0x70, 0xE0, ##   000    000 
            0xE0, 0x60, ##  000      00 
            0xC0, 0x60, ##  00       00 
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xC0, 0x70, ##  00       000
            0xE0, 0x70, ##  000      000
            0x70, 0xF0, ##   000    0000
            0x3F, 0xB0, ##    0000000 00
            0x1F, 0x30, ##     00000  00
            0x00, 0x30, ##            00
            0x00, 0x60, ##           00 
            0x00, 0x60, ##           00 
            0x41, 0xC0, ##   0     000  
            0x7F, 0x80, ##   00000000   
            0x3E, 0x00, ##    00000     
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '58' => {    # ':'
        'width'    => 2, 
        'xoffset'  => 3, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0x00, ##    
            0x00, ##    
            0x00, ##    
            0x00, ##    
            0x00, ##    
            0x00, ##    
            0x00, ##    
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '59' => {    # ';'
        'width'    => 3, 
        'xoffset'  => 2, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x60, ##   00
            0x60, ##   00
            0x60, ##   00
            0x00, ##     
            0x00, ##     
            0x00, ##     
            0x00, ##     
            0x00, ##     
            0x00, ##     
            0x00, ##     
            0x60, ##   00
            0x60, ##   00
            0x60, ##   00
            0x40, ##   0 
            0xC0, ##  00 
            0xC0, ##  00 
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '60' => {    # '<'
        'width'    => 15, 
        'xoffset'  => 3, 
        'xadvance' => 21, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##                 
            0x00, 0x0E, ##              000
            0x00, 0x3E, ##            00000
            0x01, 0xF8, ##         000000  
            0x0F, 0xC0, ##      000000     
            0x3E, 0x00, ##    00000        
            0xF8, 0x00, ##  00000          
            0xF0, 0x00, ##  0000           
            0x7E, 0x00, ##   000000        
            0x1F, 0x80, ##     000000      
            0x03, 0xF0, ##        000000   
            0x00, 0x7E, ##           000000
            0x00, 0x1E, ##             0000
            0x00, 0x02, ##                0
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '61' => {    # '='
        'width'    => 15, 
        'xoffset'  => 3, 
        'xadvance' => 21, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xFE, ##  000000000000000
            0xFF, 0xFE, ##  000000000000000
            0x00, 0x00, ##                 
            0x00, 0x00, ##                 
            0x00, 0x00, ##                 
            0xFF, 0xFE, ##  000000000000000
            0xFF, 0xFE, ##  000000000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '62' => {    # '>'
        'width'    => 15, 
        'xoffset'  => 3, 
        'xadvance' => 21, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##                 
            0xE0, 0x00, ##  000            
            0xF8, 0x00, ##  00000          
            0x3F, 0x00, ##    000000       
            0x07, 0xE0, ##       000000    
            0x00, 0xF8, ##          00000  
            0x00, 0x3E, ##            00000
            0x00, 0x1E, ##             0000
            0x00, 0xFC, ##          000000 
            0x03, 0xF0, ##        000000   
            0x1F, 0x80, ##     000000      
            0xFC, 0x00, ##  000000         
            0xF0, 0x00, ##  0000           
            0x80, 0x00, ##  0              
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '63' => {    # '?'
        'width'    => 9, 
        'xoffset'  => 2, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x3E, 0x00, ##    00000  
            0xFF, 0x00, ##  00000000 
            0xC3, 0x80, ##  00    000
            0x01, 0x80, ##         00
            0x01, 0x80, ##         00
            0x01, 0x80, ##         00
            0x03, 0x00, ##        00 
            0x06, 0x00, ##       00  
            0x0C, 0x00, ##      00   
            0x1C, 0x00, ##     000   
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x00, 0x00, ##           
            0x00, 0x00, ##           
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '64' => {    # '@'
        'width'    => 21, 
        'xoffset'  => 2, 
        'xadvance' => 25, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0xFC, 0x00, ##          000000       
            0x07, 0xFF, 0x00, ##       00000000000     
            0x0F, 0x03, 0xC0, ##      0000      0000   
            0x1C, 0x00, 0xE0, ##     000          000  
            0x38, 0x00, 0x60, ##    000            00  
            0x70, 0x00, 0x30, ##   000              00 
            0x61, 0xE0, 0x30, ##   00    0000       00 
            0x63, 0xFE, 0x18, ##   00   000000000    00
            0xC3, 0x0E, 0x18, ##  00    00    000    00
            0xC6, 0x06, 0x18, ##  00   00      00    00
            0xC6, 0x06, 0x18, ##  00   00      00    00
            0xC6, 0x06, 0x18, ##  00   00      00    00
            0xC6, 0x06, 0x38, ##  00   00      00   000
            0xC6, 0x06, 0x30, ##  00   00      00   00 
            0xE3, 0x0E, 0x60, ##  000   00    000  00  
            0x63, 0xFF, 0xC0, ##   00   000000000000   
            0x71, 0xE7, 0x00, ##   000   0000  000     
            0x38, 0x00, 0x00, ##    000                
            0x1C, 0x00, 0x00, ##     000               
            0x0F, 0x03, 0x80, ##      0000      000    
            0x07, 0xFF, 0x00, ##       00000000000     
            0x01, 0xF8, 0x00, ##         000000        
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '65' => {    # 'A'
        'width'    => 16, 
        'xoffset'  => 0, 
        'xadvance' => 16, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x01, 0xC0, ##         000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0x60, ##        00 00     
            0x06, 0x60, ##       00  00     
            0x06, 0x70, ##       00  000    
            0x0E, 0x30, ##      000   00    
            0x0C, 0x30, ##      00    00    
            0x0C, 0x18, ##      00     00   
            0x1C, 0x18, ##     000     00   
            0x18, 0x18, ##     00      00   
            0x1F, 0xFC, ##     00000000000  
            0x3F, 0xFC, ##    000000000000  
            0x30, 0x0E, ##    00        000 
            0x70, 0x06, ##   000         00 
            0x70, 0x06, ##   000         00 
            0x60, 0x07, ##   00          000
            0xE0, 0x03, ##  000           00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '66' => {    # 'B'
        'width'    => 12, 
        'xoffset'  => 2, 
        'xadvance' => 16, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0x00, ##  00000000    
            0xFF, 0xC0, ##  0000000000  
            0xC0, 0xE0, ##  00      000 
            0xC0, 0x60, ##  00       00 
            0xC0, 0x60, ##  00       00 
            0xC0, 0x60, ##  00       00 
            0xC0, 0xC0, ##  00      00  
            0xFF, 0xC0, ##  0000000000  
            0xFF, 0xC0, ##  0000000000  
            0xC0, 0xE0, ##  00      000 
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xC0, 0xE0, ##  00      000 
            0xFF, 0xE0, ##  00000000000 
            0xFF, 0x80, ##  000000000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '67' => {    # 'C'
        'width'    => 14, 
        'xoffset'  => 1, 
        'xadvance' => 16, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x07, 0xF0, ##       0000000  
            0x1F, 0xFC, ##     00000000000
            0x3C, 0x1C, ##    0000     000
            0x70, 0x04, ##   000         0
            0x60, 0x00, ##   00           
            0xE0, 0x00, ##  000           
            0xC0, 0x00, ##  00            
            0xC0, 0x00, ##  00            
            0xC0, 0x00, ##  00            
            0xC0, 0x00, ##  00            
            0xC0, 0x00, ##  00            
            0xC0, 0x00, ##  00            
            0xE0, 0x00, ##  000           
            0x60, 0x00, ##   00           
            0x70, 0x04, ##   000         0
            0x3C, 0x1C, ##    0000     000
            0x1F, 0xFC, ##     00000000000
            0x07, 0xF0, ##       0000000  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '68' => {    # 'D'
        'width'    => 14, 
        'xoffset'  => 2, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0x80, ##  000000000     
            0xFF, 0xE0, ##  00000000000   
            0xC0, 0xF0, ##  00      0000  
            0xC0, 0x38, ##  00        000 
            0xC0, 0x18, ##  00         00 
            0xC0, 0x1C, ##  00         000
            0xC0, 0x0C, ##  00          00
            0xC0, 0x0C, ##  00          00
            0xC0, 0x0C, ##  00          00
            0xC0, 0x0C, ##  00          00
            0xC0, 0x0C, ##  00          00
            0xC0, 0x0C, ##  00          00
            0xC0, 0x1C, ##  00         000
            0xC0, 0x18, ##  00         00 
            0xC0, 0x38, ##  00        000 
            0xC0, 0xF0, ##  00      0000  
            0xFF, 0xE0, ##  00000000000   
            0xFF, 0x80, ##  000000000     
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '69' => {    # 'E'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '70' => {    # 'F'
        'width'    => 10, 
        'xoffset'  => 2, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xC0, ##  0000000000
            0xFF, 0xC0, ##  0000000000
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xFF, 0xC0, ##  0000000000
            0xFF, 0xC0, ##  0000000000
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '71' => {    # 'G'
        'width'    => 15, 
        'xoffset'  => 1, 
        'xadvance' => 18, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x07, 0xF0, ##       0000000   
            0x1F, 0xFC, ##     00000000000 
            0x3C, 0x0E, ##    0000      000
            0x70, 0x02, ##   000          0
            0x60, 0x00, ##   00            
            0xE0, 0x00, ##  000            
            0xC0, 0x00, ##  00             
            0xC0, 0x00, ##  00             
            0xC0, 0x7E, ##  00       000000
            0xC0, 0x7E, ##  00       000000
            0xC0, 0x06, ##  00           00
            0xC0, 0x06, ##  00           00
            0xE0, 0x06, ##  000          00
            0x60, 0x06, ##   00          00
            0x70, 0x06, ##   000         00
            0x3C, 0x0E, ##    0000      000
            0x1F, 0xFC, ##     00000000000 
            0x07, 0xF0, ##       0000000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '72' => {    # 'H'
        'width'    => 13, 
        'xoffset'  => 2, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xFF, 0xF8, ##  0000000000000
            0xFF, 0xF8, ##  0000000000000
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '73' => {    # 'I'
        'width'    => 2, 
        'xoffset'  => 2, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '74' => {    # 'J'
        'width'    => 5, 
        'xoffset'  => -1, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x30, ##    00 
            0xF0, ##  0000 
            0xE0, ##  000  
            0x00, ##  
        ], 
    }, 
    '75' => {    # 'K'
        'width'    => 14, 
        'xoffset'  => 2, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xC0, 0x70, ##  00       000  
            0xC0, 0xE0, ##  00      000   
            0xC1, 0xC0, ##  00     000    
            0xC3, 0x80, ##  00    000     
            0xC7, 0x00, ##  00   000      
            0xCE, 0x00, ##  00  000       
            0xDC, 0x00, ##  00 000        
            0xF8, 0x00, ##  00000         
            0xF0, 0x00, ##  0000          
            0xF8, 0x00, ##  00000         
            0xDC, 0x00, ##  00 000        
            0xCE, 0x00, ##  00  000       
            0xC7, 0x00, ##  00   000      
            0xC3, 0x80, ##  00    000     
            0xC1, 0xC0, ##  00     000    
            0xC0, 0xE0, ##  00      000   
            0xC0, 0x70, ##  00       000  
            0xC0, 0x38, ##  00        000 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '76' => {    # 'L'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '77' => {    # 'M'
        'width'    => 16, 
        'xoffset'  => 2, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xE0, 0x07, ##  000          000
            0xF0, 0x0F, ##  0000        0000
            0xF0, 0x0F, ##  0000        0000
            0xD8, 0x1F, ##  00 00      00000
            0xD8, 0x1B, ##  00 00      00 00
            0xD8, 0x1B, ##  00 00      00 00
            0xCC, 0x33, ##  00  00    00  00
            0xCC, 0x33, ##  00  00    00  00
            0xCE, 0x73, ##  00  000  000  00
            0xC6, 0x63, ##  00   00  00   00
            0xC6, 0x63, ##  00   00  00   00
            0xC3, 0xC3, ##  00    0000    00
            0xC3, 0xC3, ##  00    0000    00
            0xC3, 0xC3, ##  00    0000    00
            0xC1, 0x83, ##  00     00     00
            0xC0, 0x03, ##  00            00
            0xC0, 0x03, ##  00            00
            0xC0, 0x03, ##  00            00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '78' => {    # 'N'
        'width'    => 13, 
        'xoffset'  => 2, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xE0, 0x18, ##  000        00
            0xF0, 0x18, ##  0000       00
            0xF0, 0x18, ##  0000       00
            0xF8, 0x18, ##  00000      00
            0xD8, 0x18, ##  00 00      00
            0xDC, 0x18, ##  00 000     00
            0xCC, 0x18, ##  00  00     00
            0xCE, 0x18, ##  00  000    00
            0xC6, 0x18, ##  00   00    00
            0xC3, 0x18, ##  00    00   00
            0xC3, 0x98, ##  00    000  00
            0xC1, 0x98, ##  00     00  00
            0xC1, 0xD8, ##  00     000 00
            0xC0, 0xD8, ##  00      00 00
            0xC0, 0xF8, ##  00      00000
            0xC0, 0x78, ##  00       0000
            0xC0, 0x78, ##  00       0000
            0xC0, 0x38, ##  00        000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '79' => {    # 'O'
        'width'    => 16, 
        'xoffset'  => 1, 
        'xadvance' => 18, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x07, 0xE0, ##       000000     
            0x1F, 0xF8, ##     0000000000   
            0x3C, 0x3C, ##    0000    0000  
            0x70, 0x0E, ##   000        000 
            0x60, 0x06, ##   00          00 
            0xE0, 0x07, ##  000          000
            0xC0, 0x03, ##  00            00
            0xC0, 0x03, ##  00            00
            0xC0, 0x03, ##  00            00
            0xC0, 0x03, ##  00            00
            0xC0, 0x03, ##  00            00
            0xC0, 0x03, ##  00            00
            0xE0, 0x07, ##  000          000
            0x60, 0x06, ##   00          00 
            0x70, 0x0E, ##   000        000 
            0x38, 0x1C, ##    000      000  
            0x1F, 0xF8, ##     0000000000   
            0x07, 0xE0, ##       000000     
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '80' => {    # 'P'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0x00, ##  00000000   
            0xFF, 0xC0, ##  0000000000 
            0xC1, 0xC0, ##  00     000 
            0xC0, 0xE0, ##  00      000
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0xE0, ##  00      000
            0xC1, 0xC0, ##  00     000 
            0xFF, 0xC0, ##  0000000000 
            0xFF, 0x00, ##  00000000   
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '81' => {    # 'Q'
        'width'    => 16, 
        'xoffset'  => 1, 
        'xadvance' => 18, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x07, 0xE0, ##       000000     
            0x1F, 0xF8, ##     0000000000   
            0x3C, 0x3C, ##    0000    0000  
            0x70, 0x0E, ##   000        000 
            0x60, 0x06, ##   00          00 
            0xE0, 0x06, ##  000          00 
            0xC0, 0x03, ##  00            00
            0xC0, 0x03, ##  00            00
            0xC0, 0x03, ##  00            00
            0xC0, 0x03, ##  00            00
            0xC0, 0x03, ##  00            00
            0xC0, 0x03, ##  00            00
            0xE0, 0x07, ##  000          000
            0x60, 0x06, ##   00          00 
            0x70, 0x0E, ##   000        000 
            0x38, 0x1C, ##    000      000  
            0x1F, 0xF8, ##     0000000000   
            0x07, 0xF0, ##       0000000    
            0x00, 0x30, ##            00    
            0x00, 0x38, ##            000   
            0x00, 0x1C, ##             000  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '82' => {    # 'R'
        'width'    => 13, 
        'xoffset'  => 2, 
        'xadvance' => 16, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0x00, ##  00000000     
            0xFF, 0xC0, ##  0000000000   
            0xC0, 0xC0, ##  00      00   
            0xC0, 0x60, ##  00       00  
            0xC0, 0x60, ##  00       00  
            0xC0, 0x60, ##  00       00  
            0xC0, 0x60, ##  00       00  
            0xC0, 0xE0, ##  00      000  
            0xFF, 0xC0, ##  0000000000   
            0xFF, 0x00, ##  00000000     
            0xC1, 0x80, ##  00     00    
            0xC0, 0xC0, ##  00      00   
            0xC0, 0xE0, ##  00      000  
            0xC0, 0x60, ##  00       00  
            0xC0, 0x70, ##  00       000 
            0xC0, 0x30, ##  00        00 
            0xC0, 0x38, ##  00        000
            0xC0, 0x18, ##  00         00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '83' => {    # 'S'
        'width'    => 12, 
        'xoffset'  => 2, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1F, 0xC0, ##     0000000  
            0x7F, 0xE0, ##   0000000000 
            0x70, 0x60, ##   000     00 
            0xC0, 0x00, ##  00          
            0xC0, 0x00, ##  00          
            0xC0, 0x00, ##  00          
            0xE0, 0x00, ##  000         
            0x78, 0x00, ##   0000       
            0x3F, 0x80, ##    0000000   
            0x07, 0xE0, ##       000000 
            0x00, 0xE0, ##          000 
            0x00, 0x30, ##            00
            0x00, 0x30, ##            00
            0x00, 0x30, ##            00
            0x00, 0x30, ##            00
            0xE0, 0xE0, ##  000     000 
            0xFF, 0xE0, ##  00000000000 
            0x3F, 0x80, ##    0000000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '84' => {    # 'T'
        'width'    => 15, 
        'xoffset'  => 0, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xFE, ##  000000000000000
            0xFF, 0xFE, ##  000000000000000
            0x03, 0x00, ##        00       
            0x03, 0x00, ##        00       
            0x03, 0x00, ##        00       
            0x03, 0x00, ##        00       
            0x03, 0x00, ##        00       
            0x03, 0x00, ##        00       
            0x03, 0x00, ##        00       
            0x03, 0x00, ##        00       
            0x03, 0x00, ##        00       
            0x03, 0x00, ##        00       
            0x03, 0x00, ##        00       
            0x03, 0x00, ##        00       
            0x03, 0x00, ##        00       
            0x03, 0x00, ##        00       
            0x03, 0x00, ##        00       
            0x03, 0x00, ##        00       
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '85' => {    # 'U'
        'width'    => 13, 
        'xoffset'  => 2, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0xC0, 0x18, ##  00         00
            0x60, 0x30, ##   00       00 
            0x70, 0x70, ##   000     000 
            0x3F, 0xE0, ##    000000000  
            0x0F, 0x80, ##      00000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '86' => {    # 'V'
        'width'    => 16, 
        'xoffset'  => 0, 
        'xadvance' => 16, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xE0, 0x03, ##  000           00
            0x60, 0x07, ##   00          000
            0x70, 0x06, ##   000         00 
            0x70, 0x0E, ##   000        000 
            0x30, 0x0E, ##    00        000 
            0x38, 0x0C, ##    000       00  
            0x18, 0x1C, ##     00      000  
            0x18, 0x18, ##     00      00   
            0x1C, 0x18, ##     000     00   
            0x0C, 0x38, ##      00    000   
            0x0E, 0x30, ##      000   00    
            0x0E, 0x30, ##      000   00    
            0x06, 0x70, ##       00  000    
            0x07, 0x60, ##       000 00     
            0x03, 0xE0, ##        00000     
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x01, 0xC0, ##         000      
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '87' => {    # 'W'
        'width'    => 22, 
        'xoffset'  => 1, 
        'xadvance' => 24, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xC0, 0x70, 0x1C, ##  00       000       000
            0xE0, 0x78, 0x1C, ##  000      0000      000
            0xE0, 0x78, 0x18, ##  000      0000      00 
            0x60, 0x78, 0x18, ##   00      0000      00 
            0x60, 0xD8, 0x38, ##   00     00 00     000 
            0x70, 0xCC, 0x38, ##   000    00  00    000 
            0x70, 0xCC, 0x30, ##   000    00  00    00  
            0x30, 0xCC, 0x30, ##    00    00  00    00  
            0x31, 0x8C, 0x70, ##    00   00   00   000  
            0x31, 0x84, 0x70, ##    00   00    0   000  
            0x39, 0x86, 0x60, ##    000  00    00  00   
            0x19, 0x86, 0x60, ##     00  00    00  00   
            0x19, 0x06, 0x60, ##     00  0     00  00   
            0x1B, 0x02, 0xE0, ##     00 00      0 000   
            0x1F, 0x03, 0xC0, ##     00000      0000    
            0x0F, 0x03, 0xC0, ##      0000      0000    
            0x0F, 0x03, 0xC0, ##      0000      0000    
            0x0E, 0x03, 0xC0, ##      000       0000    
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '88' => {    # 'X'
        'width'    => 15, 
        'xoffset'  => 1, 
        'xadvance' => 16, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x60, 0x1C, ##   00        000 
            0x70, 0x18, ##   000       00  
            0x38, 0x38, ##    000     000  
            0x18, 0x70, ##     00    000   
            0x1C, 0x60, ##     000   00    
            0x0E, 0xE0, ##      000 000    
            0x06, 0xC0, ##       00 00     
            0x07, 0x80, ##       0000      
            0x03, 0x80, ##        000      
            0x07, 0x80, ##       0000      
            0x07, 0xC0, ##       00000     
            0x0E, 0xE0, ##      000 000    
            0x1C, 0x60, ##     000   00    
            0x18, 0x70, ##     00    000   
            0x38, 0x30, ##    000     00   
            0x70, 0x18, ##   000       00  
            0x60, 0x1C, ##   00        000 
            0xE0, 0x0C, ##  000         00 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '89' => {    # 'Y'
        'width'    => 14, 
        'xoffset'  => 0, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xE0, 0x1C, ##  000        000
            0x60, 0x18, ##   00        00 
            0x70, 0x38, ##   000      000 
            0x38, 0x70, ##    000    000  
            0x18, 0x60, ##     00    00   
            0x1C, 0xE0, ##     000  000   
            0x0C, 0xC0, ##      00  00    
            0x07, 0x80, ##       0000     
            0x07, 0x80, ##       0000     
            0x03, 0x00, ##        00      
            0x03, 0x00, ##        00      
            0x03, 0x00, ##        00      
            0x03, 0x00, ##        00      
            0x03, 0x00, ##        00      
            0x03, 0x00, ##        00      
            0x03, 0x00, ##        00      
            0x03, 0x00, ##        00      
            0x03, 0x00, ##        00      
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '90' => {    # 'Z'
        'width'    => 14, 
        'xoffset'  => 1, 
        'xadvance' => 16, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xFC, ##  00000000000000
            0xFF, 0xFC, ##  00000000000000
            0x00, 0x18, ##             00 
            0x00, 0x38, ##            000 
            0x00, 0x70, ##           000  
            0x00, 0xE0, ##          000   
            0x01, 0xC0, ##         000    
            0x01, 0x80, ##         00     
            0x03, 0x80, ##        000     
            0x07, 0x00, ##       000      
            0x0E, 0x00, ##      000       
            0x0C, 0x00, ##      00        
            0x1C, 0x00, ##     000        
            0x38, 0x00, ##    000         
            0x70, 0x00, ##   000          
            0x60, 0x00, ##   00           
            0xFF, 0xFC, ##  00000000000000
            0xFF, 0xFC, ##  00000000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '91' => {    # '['
        'width'    => 5, 
        'xoffset'  => 2, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0xF8, ##  00000
            0xF8, ##  00000
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xC0, ##  00   
            0xF8, ##  00000
            0xF8, ##  00000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '92' => {    # '\'
        'width'    => 8, 
        'xoffset'  => 0, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xC0, ##  00      
            0xC0, ##  00      
            0x60, ##   00     
            0x60, ##   00     
            0x60, ##   00     
            0x30, ##    00    
            0x30, ##    00    
            0x30, ##    00    
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x18, ##     00   
            0x0C, ##      00  
            0x0C, ##      00  
            0x0C, ##      00  
            0x06, ##       00 
            0x06, ##       00 
            0x06, ##       00 
            0x07, ##       000
            0x03, ##        00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '93' => {    # ']'
        'width'    => 5, 
        'xoffset'  => 2, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0xF8, ##  00000
            0xF8, ##  00000
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0x18, ##     00
            0xF8, ##  00000
            0xF8, ##  00000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '94' => {    # '^'
        'width'    => 15, 
        'xoffset'  => 3, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x07, 0x80, ##       0000      
            0x07, 0xC0, ##       00000     
            0x0E, 0xC0, ##      000 00     
            0x1C, 0x60, ##     000   00    
            0x38, 0x30, ##    000     00   
            0x60, 0x18, ##   00        00  
            0xC0, 0x0C, ##  00          00 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '95' => {    # '_'
        'width'    => 12, 
        'xoffset'  => 0, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xF0, ##  000000000000
            0xFF, 0xF0, ##  000000000000
        ], 
    }, 
    '96' => {    # '`'
        'width'    => 6, 
        'xoffset'  => 2, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0xC0, ##  00    
            0x60, ##   00   
            0x30, ##    00  
            0x18, ##     00 
            0x18, ##     00 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '97' => {    # 'a'
        'width'    => 11, 
        'xoffset'  => 1, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x3F, 0x00, ##    000000   
            0x7F, 0xC0, ##   000000000 
            0x40, 0xC0, ##   0      00 
            0x00, 0x60, ##           00
            0x00, 0x60, ##           00
            0x1F, 0xE0, ##     00000000
            0x7F, 0xE0, ##   0000000000
            0xE0, 0x60, ##  000      00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0xE0, ##  00      000
            0xE1, 0xE0, ##  000    0000
            0x7F, 0x60, ##   0000000 00
            0x3E, 0x60, ##    00000  00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '98' => {    # 'b'
        'width'    => 12, 
        'xoffset'  => 2, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0xC0, 0x00, ##  00          
            0xC0, 0x00, ##  00          
            0xC0, 0x00, ##  00          
            0xC0, 0x00, ##  00          
            0xC0, 0x00, ##  00          
            0xCF, 0x80, ##  00  00000   
            0xDF, 0xC0, ##  00 0000000  
            0xF0, 0xE0, ##  0000    000 
            0xE0, 0x60, ##  000      00 
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xE0, 0x60, ##  000      00 
            0xF0, 0xE0, ##  0000    000 
            0xDF, 0xC0, ##  00 0000000  
            0xCF, 0x80, ##  00  00000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '99' => {    # 'c'
        'width'    => 11, 
        'xoffset'  => 1, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0F, 0xC0, ##      000000 
            0x3F, 0xE0, ##    000000000
            0x70, 0x60, ##   000     00
            0x60, 0x00, ##   00        
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0x60, 0x00, ##   00        
            0x70, 0x60, ##   000     00
            0x3F, 0xE0, ##    000000000
            0x0F, 0xC0, ##      000000 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '100' => {    # 'd'
        'width'    => 12, 
        'xoffset'  => 1, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x30, ##            00
            0x00, 0x30, ##            00
            0x00, 0x30, ##            00
            0x00, 0x30, ##            00
            0x00, 0x30, ##            00
            0x1F, 0x30, ##     00000  00
            0x3F, 0xB0, ##    0000000 00
            0x70, 0xF0, ##   000    0000
            0x60, 0x70, ##   00      000
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0x60, 0x70, ##   00      000
            0x70, 0xF0, ##   000    0000
            0x3F, 0xB0, ##    0000000 00
            0x1F, 0x30, ##     00000  00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '101' => {    # 'e'
        'width'    => 12, 
        'xoffset'  => 1, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0F, 0x80, ##      00000   
            0x3F, 0xC0, ##    00000000  
            0x70, 0xE0, ##   000    000 
            0x60, 0x30, ##   00       00
            0xC0, 0x30, ##  00        00
            0xFF, 0xF0, ##  000000000000
            0xFF, 0xF0, ##  000000000000
            0xC0, 0x00, ##  00          
            0xC0, 0x00, ##  00          
            0xC0, 0x00, ##  00          
            0x60, 0x00, ##   00         
            0x70, 0x30, ##   000      00
            0x3F, 0xF0, ##    0000000000
            0x0F, 0xC0, ##      000000  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '102' => {    # 'f'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x0F, 0x80, ##      00000
            0x1F, 0x80, ##     000000
            0x30, 0x00, ##    00     
            0x30, 0x00, ##    00     
            0x30, 0x00, ##    00     
            0xFF, 0x00, ##  00000000 
            0xFF, 0x00, ##  00000000 
            0x30, 0x00, ##    00     
            0x30, 0x00, ##    00     
            0x30, 0x00, ##    00     
            0x30, 0x00, ##    00     
            0x30, 0x00, ##    00     
            0x30, 0x00, ##    00     
            0x30, 0x00, ##    00     
            0x30, 0x00, ##    00     
            0x30, 0x00, ##    00     
            0x30, 0x00, ##    00     
            0x30, 0x00, ##    00     
            0x30, 0x00, ##    00     
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '103' => {    # 'g'
        'width'    => 12, 
        'xoffset'  => 1, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1F, 0x30, ##     00000  00
            0x3F, 0xB0, ##    0000000 00
            0x70, 0xF0, ##   000    0000
            0x60, 0x70, ##   00      000
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0x60, 0x70, ##   00      000
            0x70, 0xF0, ##   000    0000
            0x3F, 0xB0, ##    0000000 00
            0x1F, 0x30, ##     00000  00
            0x00, 0x30, ##            00
            0x00, 0x60, ##           00 
            0x40, 0xE0, ##   0      000 
            0x7F, 0xC0, ##   000000000  
            0x3F, 0x80, ##    0000000   
            0x00, 0x00, ##  
        ], 
    }, 
    '104' => {    # 'h'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xCF, 0x80, ##  00  00000  
            0xDF, 0xC0, ##  00 0000000 
            0xF0, 0xC0, ##  0000    00 
            0xE0, 0x60, ##  000      00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '105' => {    # 'i'
        'width'    => 2, 
        'xoffset'  => 2, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0x00, ##    
            0x00, ##    
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '106' => {    # 'j'
        'width'    => 4, 
        'xoffset'  => 0, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x00, ##      
            0x00, ##      
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x30, ##    00
            0x70, ##   000
            0xE0, ##  000 
            0xC0, ##  00  
            0x00, ##  
        ], 
    }, 
    '107' => {    # 'k'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0x00, ##  00         
            0xC0, 0xE0, ##  00      000
            0xC1, 0xC0, ##  00     000 
            0xC3, 0x80, ##  00    000  
            0xC6, 0x00, ##  00   00    
            0xCC, 0x00, ##  00  00     
            0xD8, 0x00, ##  00 00      
            0xF0, 0x00, ##  0000       
            0xF8, 0x00, ##  00000      
            0xDC, 0x00, ##  00 000     
            0xCE, 0x00, ##  00  000    
            0xC7, 0x00, ##  00   000   
            0xC3, 0x80, ##  00    000  
            0xC1, 0xC0, ##  00     000 
            0xC0, 0xE0, ##  00      000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '108' => {    # 'l'
        'width'    => 2, 
        'xoffset'  => 2, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '109' => {    # 'm'
        'width'    => 20, 
        'xoffset'  => 2, 
        'xadvance' => 24, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xCF, 0x87, 0xC0, ##  00  00000    00000  
            0xDF, 0xCF, 0xE0, ##  00 0000000  0000000 
            0xF0, 0xD8, 0x60, ##  0000    00 00    00 
            0xE0, 0x70, 0x30, ##  000      000      00
            0xC0, 0x60, 0x30, ##  00       00       00
            0xC0, 0x60, 0x30, ##  00       00       00
            0xC0, 0x60, 0x30, ##  00       00       00
            0xC0, 0x60, 0x30, ##  00       00       00
            0xC0, 0x60, 0x30, ##  00       00       00
            0xC0, 0x60, 0x30, ##  00       00       00
            0xC0, 0x60, 0x30, ##  00       00       00
            0xC0, 0x60, 0x30, ##  00       00       00
            0xC0, 0x60, 0x30, ##  00       00       00
            0xC0, 0x60, 0x30, ##  00       00       00
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '110' => {    # 'n'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xCF, 0x80, ##  00  00000  
            0xDF, 0xC0, ##  00 0000000 
            0xF0, 0xC0, ##  0000    00 
            0xE0, 0x60, ##  000      00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '111' => {    # 'o'
        'width'    => 12, 
        'xoffset'  => 1, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1F, 0x80, ##     000000   
            0x3F, 0xC0, ##    00000000  
            0x70, 0xE0, ##   000    000 
            0x60, 0x60, ##   00      00 
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0x60, 0x60, ##   00      00 
            0x70, 0xE0, ##   000    000 
            0x3F, 0xC0, ##    00000000  
            0x1F, 0x80, ##     000000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '112' => {    # 'p'
        'width'    => 12, 
        'xoffset'  => 2, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xCF, 0x80, ##  00  00000   
            0xDF, 0xC0, ##  00 0000000  
            0xF0, 0xE0, ##  0000    000 
            0xE0, 0x60, ##  000      00 
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xE0, 0x60, ##  000      00 
            0xF0, 0xE0, ##  0000    000 
            0xDF, 0xC0, ##  00 0000000  
            0xCF, 0x80, ##  00  00000   
            0xC0, 0x00, ##  00          
            0xC0, 0x00, ##  00          
            0xC0, 0x00, ##  00          
            0xC0, 0x00, ##  00          
            0xC0, 0x00, ##  00          
            0x00, 0x00, ##  
        ], 
    }, 
    '113' => {    # 'q'
        'width'    => 12, 
        'xoffset'  => 1, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1F, 0x30, ##     00000  00
            0x3F, 0xB0, ##    0000000 00
            0x70, 0xF0, ##   000    0000
            0x60, 0x70, ##   00      000
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0xC0, 0x30, ##  00        00
            0x60, 0x70, ##   00      000
            0x70, 0xF0, ##   000    0000
            0x3F, 0xB0, ##    0000000 00
            0x1F, 0x30, ##     00000  00
            0x00, 0x30, ##            00
            0x00, 0x30, ##            00
            0x00, 0x30, ##            00
            0x00, 0x30, ##            00
            0x00, 0x30, ##            00
            0x00, 0x00, ##  
        ], 
    }, 
    '114' => {    # 'r'
        'width'    => 8, 
        'xoffset'  => 2, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xCF, ##  00  0000
            0xDF, ##  00 00000
            0xF0, ##  0000    
            0xE0, ##  000     
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0xC0, ##  00      
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '115' => {    # 's'
        'width'    => 10, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x3F, 0x80, ##    0000000 
            0x7F, 0x80, ##   00000000 
            0xE0, 0x80, ##  000     0 
            0xC0, 0x00, ##  00        
            0xC0, 0x00, ##  00        
            0xE0, 0x00, ##  000       
            0x7E, 0x00, ##   000000   
            0x0F, 0x80, ##      00000 
            0x01, 0xC0, ##         000
            0x00, 0xC0, ##          00
            0x00, 0xC0, ##          00
            0xC1, 0xC0, ##  00     000
            0xFF, 0x80, ##  000000000 
            0x7F, 0x00, ##   0000000  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '116' => {    # 't'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x30, ##    00    
            0x30, ##    00    
            0x30, ##    00    
            0x30, ##    00    
            0xFF, ##  00000000
            0xFF, ##  00000000
            0x30, ##    00    
            0x30, ##    00    
            0x30, ##    00    
            0x30, ##    00    
            0x30, ##    00    
            0x30, ##    00    
            0x30, ##    00    
            0x30, ##    00    
            0x30, ##    00    
            0x30, ##    00    
            0x3F, ##    000000
            0x1F, ##     00000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '117' => {    # 'u'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0x60, ##  00       00
            0xC0, 0xE0, ##  00      000
            0x61, 0xE0, ##   00    0000
            0x7F, 0x60, ##   0000000 00
            0x3E, 0x60, ##    00000  00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '118' => {    # 'v'
        'width'    => 12, 
        'xoffset'  => 1, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xC0, 0x30, ##  00        00
            0xE0, 0x30, ##  000       00
            0x60, 0x70, ##   00      000
            0x60, 0x60, ##   00      00 
            0x70, 0x60, ##   000     00 
            0x30, 0xE0, ##    00    000 
            0x30, 0xC0, ##    00    00  
            0x38, 0xC0, ##    000   00  
            0x19, 0xC0, ##     00  000  
            0x19, 0x80, ##     00  00   
            0x1D, 0x80, ##     000 00   
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '119' => {    # 'w'
        'width'    => 18, 
        'xoffset'  => 1, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xC1, 0xC1, 0xC0, ##  00     000     000
            0xE1, 0xC1, 0x80, ##  000    000     00 
            0x61, 0xE1, 0x80, ##   00    0000    00 
            0x61, 0xE1, 0x80, ##   00    0000    00 
            0x63, 0x63, 0x80, ##   00   00 00   000 
            0x73, 0x23, 0x00, ##   000  00  0   00  
            0x33, 0x33, 0x00, ##    00  00  00  00  
            0x33, 0x33, 0x00, ##    00  00  00  00  
            0x36, 0x37, 0x00, ##    00 00   00 000  
            0x3E, 0x16, 0x00, ##    00000    0 00   
            0x1E, 0x1E, 0x00, ##     0000    0000   
            0x1E, 0x1E, 0x00, ##     0000    0000   
            0x1C, 0x1E, 0x00, ##     000     0000   
            0x1C, 0x0C, 0x00, ##     000      00    
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '120' => {    # 'x'
        'width'    => 12, 
        'xoffset'  => 1, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xE0, 0x70, ##  000      000
            0x70, 0x60, ##   000     00 
            0x30, 0xC0, ##    00    00  
            0x19, 0xC0, ##     00  000  
            0x1F, 0x80, ##     000000   
            0x0F, 0x00, ##      0000    
            0x07, 0x00, ##       000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x80, ##      00000   
            0x19, 0x80, ##     00  00   
            0x39, 0xC0, ##    000  000  
            0x70, 0xE0, ##   000    000 
            0x60, 0x60, ##   00      00 
            0xE0, 0x30, ##  000       00
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '121' => {    # 'y'
        'width'    => 13, 
        'xoffset'  => 1, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xC0, 0x30, ##  00        00 
            0xE0, 0x30, ##  000       00 
            0x60, 0x70, ##   00      000 
            0x60, 0x60, ##   00      00  
            0x30, 0x60, ##    00     00  
            0x30, 0xC0, ##    00    00   
            0x38, 0xC0, ##    000   00   
            0x19, 0xC0, ##     00  000   
            0x19, 0x80, ##     00  00    
            0x0D, 0x80, ##      00 00    
            0x0F, 0x80, ##      00000    
            0x0F, 0x00, ##      0000     
            0x07, 0x00, ##       000     
            0x06, 0x00, ##       00      
            0x06, 0x00, ##       00      
            0x0E, 0x00, ##      000      
            0x0C, 0x00, ##      00       
            0x7C, 0x00, ##   00000       
            0x78, 0x00, ##   0000        
            0x00, 0x00, ##  
        ], 
    }, 
    '122' => {    # 'z'
        'width'    => 10, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xC0, ##  0000000000
            0xFF, 0xC0, ##  0000000000
            0x01, 0xC0, ##         000
            0x03, 0x80, ##        000 
            0x03, 0x00, ##        00  
            0x06, 0x00, ##       00   
            0x0E, 0x00, ##      000   
            0x1C, 0x00, ##     000    
            0x18, 0x00, ##     00     
            0x30, 0x00, ##    00      
            0x60, 0x00, ##   00       
            0xC0, 0x00, ##  00        
            0xFF, 0xC0, ##  0000000000
            0xFF, 0xC0, ##  0000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '123' => {    # '{'
        'width'    => 9, 
        'xoffset'  => 3, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x07, 0x80, ##       0000
            0x0F, 0x80, ##      00000
            0x1C, 0x00, ##     000   
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x38, 0x00, ##    000    
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0x38, 0x00, ##    000    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x1C, 0x00, ##     000   
            0x1F, 0x80, ##     000000
            0x07, 0x80, ##       0000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '124' => {    # '|'
        'width'    => 2, 
        'xoffset'  => 3, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
            0xC0, ##  00
        ], 
    }, 
    '125' => {    # '}'
        'width'    => 9, 
        'xoffset'  => 3, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0xE0, 0x00, ##  000      
            0xF0, 0x00, ##  0000     
            0x38, 0x00, ##    000    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x1C, 0x00, ##     000   
            0x0F, 0x80, ##      00000
            0x0F, 0x80, ##      00000
            0x1C, 0x00, ##     000   
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x18, 0x00, ##     00    
            0x38, 0x00, ##    000    
            0xF8, 0x00, ##  00000    
            0xE0, 0x00, ##  000      
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '126' => {    # '~'
        'width'    => 15, 
        'xoffset'  => 3, 
        'xadvance' => 21, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x3E, 0x02, ##    00000       0
            0x7F, 0x86, ##   00000000    00
            0xC3, 0xFC, ##  00    00000000 
            0x80, 0xF8, ##  0       00000  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '176' => {    # '°'
        'width'    => 8, 
        'xoffset'  => 2, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, ##  
            0x3C, ##    0000  
            0x7E, ##   000000 
            0xE7, ##  000  000
            0xC3, ##  00    00
            0xC3, ##  00    00
            0xE7, ##  000  000
            0x7E, ##   000000 
            0x3C, ##    0000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
};
 
my $kerning = {
    '33' => { },  # !
    '34' => { },  # "
    '35' => { },  # #
    '36' => { },  # $
    '37' => { },  # %
    '38' => { },  # &
    '39' => { },  # '
    '40' => { },  # (
    '41' => { },  # )
    '42' => { },  # *
    '43' => { },  # +
    '44' => { },  # ,
    '45' => { '65' => -1, '66' => -1, '71' => 1, '74' => 1, '79' => 1, '81' => 1, '84' => -2, '86' => -1, '87' => -1, '88' => -1, '89' => -3, '118' => -1, },  # -
    '46' => { },  # .
    '47' => { },  # /
    '48' => { },  # 0
    '49' => { },  # 1
    '50' => { },  # 2
    '51' => { },  # 3
    '52' => { },  # 4
    '53' => { },  # 5
    '54' => { },  # 6
    '55' => { },  # 7
    '56' => { },  # 8
    '57' => { },  # 9
    '58' => { },  # :
    '59' => { },  # ;
    '60' => { },  # <
    '61' => { },  # =
    '62' => { },  # >
    '63' => { },  # ?
    '64' => { },  # @
    '65' => { '45' => -1, '84' => -2, '86' => -1, '87' => -1, '89' => -2, '102' => -1, '118' => -1, '119' => -1, '121' => -2, },  # A
    '66' => { '86' => -1, '87' => -1, '89' => -1, },  # B
    '67' => { },  # C
    '68' => { '89' => -1, },  # D
    '69' => { },  # E
    '70' => { '46' => -4, '58' => -2, '65' => -2, '97' => -2, '101' => -1, '105' => -2, '111' => -1, '114' => -2, '117' => -1, '121' => -2, },  # F
    '71' => { '84' => -1, '89' => -1, },  # G
    '72' => { },  # H
    '73' => { },  # I
    '74' => { '45' => -1, },  # J
    '75' => { '45' => -2, '67' => -1, '79' => -1, '84' => -2, '85' => -1, '87' => -1, '89' => -1, '101' => -1, '111' => -1, '117' => -1, '121' => -2, },  # K
    '76' => { '65' => 1, '79' => -1, '84' => -3, '85' => -1, '86' => -3, '87' => -2, '89' => -3, '121' => -2, },  # L
    '77' => { },  # M
    '78' => { },  # N
    '79' => { '45' => 1, '46' => -1, '88' => -1, '89' => -1, },  # O
    '80' => { '45' => -1, '46' => -4, '65' => -1, '89' => -1, '97' => -1, '101' => -1, '105' => -1, '111' => -1, },  # P
    '81' => { '45' => 1, },  # Q
    '82' => { '45' => -1, '46' => -1, '58' => -1, '65' => -1, '67' => -1, '84' => -2, '86' => -1, '87' => -1, '89' => -1, '97' => -1, '101' => -1, '111' => -1, '117' => -1, '121' => -1, },  # R
    '83' => { },  # S
    '84' => { '45' => -2, '46' => -3, '58' => -3, '65' => -2, '67' => -1, '97' => -4, '99' => -4, '101' => -4, '105' => -1, '111' => -4, '114' => -3, '115' => -4, '117' => -3, '119' => -4, '121' => -4, },  # T
    '85' => { },  # U
    '86' => { '45' => -1, '46' => -3, '58' => -2, '65' => -1, '97' => -2, '101' => -2, '105' => -1, '111' => -2, '117' => -2, '121' => -1, },  # V
    '87' => { '45' => -1, '46' => -3, '58' => -1, '65' => -1, '97' => -1, '101' => -1, '105' => -1, '111' => -1, '114' => -1, '117' => -1, },  # W
    '88' => { '45' => -1, '67' => -2, '79' => -1, '101' => -1, },  # X
    '89' => { '45' => -3, '46' => -5, '58' => -3, '65' => -2, '67' => -1, '79' => -1, '97' => -3, '101' => -3, '105' => -1, '111' => -3, '117' => -3, },  # Y
    '90' => { },  # Z
    '91' => { },  # [
    '92' => { },  # \
    '93' => { },  # ]
    '94' => { },  # ^
    '95' => { },  # _
    '96' => { },  # `
    '97' => { },  # a
    '98' => { },  # b
    '99' => { },  # c
    '100' => { },  # d
    '101' => { },  # e
    '102' => { '45' => -1, '46' => -2, '58' => -1, },  # f
    '103' => { },  # g
    '104' => { },  # h
    '105' => { },  # i
    '106' => { },  # j
    '107' => { '101' => -1, '111' => -1, '117' => -1, '121' => -1, },  # k
    '108' => { },  # l
    '109' => { },  # m
    '110' => { },  # n
    '111' => { '120' => -1, },  # o
    '112' => { },  # p
    '113' => { },  # q
    '114' => { '45' => -1, '46' => -2, '99' => -1, '101' => -1, '111' => -1, '120' => -1, },  # r
    '115' => { },  # s
    '116' => { },  # t
    '117' => { },  # u
    '118' => { '45' => -1, '46' => -2, '58' => -1, },  # v
    '119' => { '46' => -2, '58' => -1, },  # w
    '120' => { '101' => -1, '111' => -1, },  # x
    '121' => { '46' => -3, '58' => -2, },  # y
    '122' => { },  # z
    '123' => { },  # {
    '124' => { },  # |
    '125' => { },  # }
    '126' => { },  # ~
    '176' => { },  # °
};


sub new {
    my($class) = @_;
    
    my $self = $class->SUPER::new(
        name        => $name,
        char_height => $char_height,
        space_width => $space_width,
        gap_width   => $gap_width,
        symbols     => $symbols,
        kerning     => $kerning,
        line_spacing => $line_spacing,
        class       => 'hipi_2',
    );
    
    return $self;
}

1;

__END__
