use strict;
use warnings;
package MyApp {
	use Types::Standard -types;
	use MooX::Press
		prefix => 'MyApp::OO',
		toolkit => 'Moose',
		role => [
			'Bray' => [
				can => [
					bray => sub { "moo" },
				],
			],
		],
		class => [
			'Farmyard' => [
				has => [qw( @animals ), 'leader' => {isa => 'Primate::Human'}],
			],
			'Animal' => {
				has => [
					'name' => Str,
					'status' => { enum => ['alive', 'dead'], default => 'alive' },
				],
				constant => [
					FOO => 1,
					BAR => 2,
				],
				subclass => [
					'Cow' => [
						with => 'Bray',
						can => [
							'give_milk' => sub { print "giving milk\n" },
						]
					],
					'Cute::Kitty',
					'Kitten',
					'Puppy',
					'Primate' => {
						subclass => [
							qw/Primate::Monkey Primate::Chimp/,
							'Primate::Human' => {
								coerce => [
									Str, 'from_string', sub { $_[0]->new(name => $_[1]) },
								],
							},
						],
					},
				],
			},
		];
}

MyApp->new_cute_kitty;

use Data::Dumper; 
my $d = MyApp->new_cow(name => 'Daisy');
$d->give_milk;
print $d->name, "\n";
print MyApp::OO::Animal::BAR, "\n";
my $m = MyApp->new_kitten(name => 'Maddie', status => 'dead');
my $p = MyApp->new_puppy(name => 'Livvy');
my $f = MyApp->new_farmyard(animals => [$d, $m, $p]);
print $f->animals->[0]->bray, "\n";
$f->leader('Bob');
print join('|', MyApp::OO::Types->type_names), "\n";
print Dumper(MyApp::OO::Types::Bray);
print Dumper($f);


package MyApp2;
use Types::Standard qw(Str Num);
use MooX::Press (
 role => [
   'MyModifiers' => {
	  after => [
		'from_name' => sub { warn "after1" },
		'from_name' => sub { warn "after2" },
		],
	  before => [
		'from_name' => sub { warn "before1" },
		'from_name' => sub { warn "before2" },
		],
	 },
 ],
 class => [
	'Person' => {
	  has    => [ 'name!' => Str ],
	  coerce => [
		 Num, 'from_number' => sub {
			my ($class, $num) = @_;
			 $class->new(name => "Person $num");
		 },
		 Str, 'from_name' => sub {
			my ($class, $name) = @_;
			return $class->new(name => $name);
		 },
	  ],
	  with => 'MyModifiers',
	},
	'Company' => {
	  has    => [ 'name!' => Str, 'owner!' => { isa => 'Person' } ],
	},
 ],
);

my $acme = MyApp2->new_company(name => "Acme Inc", owner => "Bob");
print $acme->owner->name, "\n";

use B::Deparse;
print B::Deparse->new->coderef2text(\&MyApp2::Company::new);