package App::Tac_n;
$App::Tac_n::VERSION = '0.0.2';
use strict;
use warnings;
use 5.014;
use autodie;

sub run
{
    my @l = <ARGV>;
    my $p = 1 + @l;

    foreach my $v (@l)
    {
        printf "%10d  %s", ( --$p ), $v;
    }
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

App::Tac_n - tac with line numbers

=head1 VERSION

version 0.0.2

=head1 SYNOPSIS

    ~/progs/perl/cpan/App/Tac_n/App-Tac_n/ seq 1 5 | perl -Ilib bin/tac-n
             5  1
             4  2
             3  3
             2  4
             1  5

=head1 DESCRIPTION

Same as C<< tac | cat -n | tac >>.

=head1 METHODS

=head2 run()

Runs the CLI app.

=head1 THANKS

Some of the code and data for tests are based on earlier ones written by
me for L<PerlPowerTools|https://metacpan.org/dist/PerlPowerTools> .

=for :stopwords cpan testmatrix url bugtracker rt cpants kwalitee diff irc mailto metadata placeholders metacpan

=head1 SUPPORT

=head2 Websites

The following websites have more information about this module, and may be of help to you. As always,
in addition to those websites please use your favorite search engine to discover more resources.

=over 4

=item *

MetaCPAN

A modern, open-source CPAN search engine, useful to view POD in HTML format.

L<https://metacpan.org/release/App-Tac_n>

=item *

RT: CPAN's Bug Tracker

The RT ( Request Tracker ) website is the default bug/issue tracking system for CPAN.

L<https://rt.cpan.org/Public/Dist/Display.html?Name=App-Tac_n>

=item *

CPANTS

The CPANTS is a website that analyzes the Kwalitee ( code metrics ) of a distribution.

L<http://cpants.cpanauthors.org/dist/App-Tac_n>

=item *

CPAN Testers

The CPAN Testers is a network of smoke testers who run automated tests on uploaded CPAN distributions.

L<http://www.cpantesters.org/distro/A/App-Tac_n>

=item *

CPAN Testers Matrix

The CPAN Testers Matrix is a website that provides a visual overview of the test results for a distribution on various Perls/platforms.

L<http://matrix.cpantesters.org/?dist=App-Tac_n>

=item *

CPAN Testers Dependencies

The CPAN Testers Dependencies is a website that shows a chart of the test results of all dependencies for a distribution.

L<http://deps.cpantesters.org/?module=App::Tac_n>

=back

=head2 Bugs / Feature Requests

Please report any bugs or feature requests by email to C<bug-app-tac_n at rt.cpan.org>, or through
the web interface at L<https://rt.cpan.org/Public/Bug/Report.html?Queue=App-Tac_n>. You will be automatically notified of any
progress on the request by the system.

=head2 Source Code

The code is open to the world, and available for you to hack on. Please feel free to browse it and play
with it, or whatever. If you want to contribute patches, please send me a diff or prod me to pull
from your repository :)

L<https://github.com/shlomif/perl-App-Tac_n>

  git clone https://github.com/shlomif/perl-App-Tac_n.git

=head1 AUTHOR

Shlomi Fish <shlomif@cpan.org>

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website
L<https://github.com/shlomif/app-tac_n/issues>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2021 by Shlomi Fish.

This is free software, licensed under:

  The MIT (X11) License

=cut
