use ExtUtils::MakeMaker;

WriteMakefile(
  ABSTRACT => "VMware vCloud API",
  AUTHOR   => 'Phil Pollard <bennie@cpan.org>',
  LICENSE  => 'artistic_2',
  NAME     => 'VMware::vCloud',
  VERSION  => '2.404',

  PREREQ_PM => {
          'Cache::Bounded' => '1.05',
          'LWP' => 5,
          'Test' => 0,
          'Data::Dumper' => 0,
          'Test::More' => 0,
          'File::Slurp' => 0,
          'XML::Simple' => 2,
          'Getopt::Long' => 0,
          'Term::Prompt' => 0
        },

  ( $ExtUtils::MakeMaker::VERSION < 6.46
        ? ()
        : ( META_MERGE => {
                'meta-spec' => { version => 2 },
                no_index => {directory => [qw/t/]},
                provides => 

	{
          'VMware::vCloud::vApp' => {
                                      'version' => '2.404',
                                      'file' => 'lib/VMware/vCloud/vApp.pm'
                                    },
          'VMware::vCloud' => {
                                'file' => 'lib/VMware/vCloud.pm',
                                'version' => '2.404'
                              },
          'VMware::API::vCloud' => {
                                     'file' => 'lib/VMware/API/vCloud.pm',
                                     'version' => '2.404'
                                   }
        },

                release_status => 'stable',
                resources => {
                    repository => {
                        type => 'git',
                        url  => 'git://github.com/bennie/perl-VMware-vCloud.git',
                        web  => 'http://github.com/bennie/perl-VMware-vCloud',
                    },
                    bugtracker => {
                        web => 'https://rt.cpan.org/Dist/Display.html?Name=VMware-vCloud',
                    },

                },
            },
        )
    ),

  ( $ExtUtils::MakeMaker::VERSION < 6.48
        ? ()
        : ( MIN_PERL_VERSION => '5.006' )
  )

);