BEGIN {
  use strict; use warnings;
  my %missing = map {
    eval qq{ require $_ };
    $@ ? ($_=>1) : ()
  } qw( File::Spec FindBin base strict warnings );
  if(%missing)
  {
    print "Your Perl is missing core modules: @{[ sort keys %missing ]}\n";
    print "Ideally if you are using the system Perl you can install the appropriate\n";
    print "package which includes the core Perl modules.  On at least some versions\n";
    print "of Fedora, CentOS and RHEL, this is the `perl-core` package.\n";
    print "\n";
    print " % dnf install perl-core\n";
    print "   ~ or ~\n";
    print " % yum install perl-core\n";
    print "\n";
    print "If you really want to install dual-life modules from CPAN, then you can\n";
    print "use cpanm:\n";
    print "\n";
    print " % cpanm @{[ sort keys %missing ]}\n";
    print "\n";
    print "Note that some core modules are not available from CPAN.\n";
    exit;
  }
}
BEGIN {
  use strict; use warnings;
  if($^O eq 'midnightbsd')
  {
    print "Sorry, MidnightBSD is not supported.\n";
    print "See:\n";
    print "https://github.com/Perl5-Alien/Alien-Base-Extras/issues/4\n";
    print "pull requests to fix this are welcome.\n";
    print "OS Unsupported\n";
    exit;
  }
  unless(eval q{ use 5.006; 1}) {
    print "Perl 5.006 or better required\n";
    exit;
  }
}

# This file was automatically generated by Dist::Zilla::Plugin::Alien v0.023.
use strict;
use warnings;

use Module::Build 0.28;
use lib qw{inc}; use Alien::Base::ModuleBuild;

my %module_build_args = (
  "alien_inline_auto_include" => [
    "libdontpanic.h"
  ],
  "alien_isolate_dynamic" => 1,
  "alien_name" => "dontpanic",
  "alien_repository" => {
    "host" => "alienfile.org",
    "location" => "/dontpanic/",
    "pattern" => "^.*/([\\d\\.]+)\\.tar\\.gz\$",
    "protocol" => "https"
  },
  "configure_requires" => {
    "Alien::Base::ModuleBuild" => "1.12",
    "Alien::Build" => "2.00",
    "File::ShareDir" => "1.03",
    "perl" => "5.006"
  },
  "dist_abstract" => "Test Module for Alien::Base::ModuleBuild",
  "dist_author" => [
    "Graham Ollis <plicease\@cpan.org>",
    "Joel A Berger <joel.a.berger\@gmail.com>"
  ],
  "dist_name" => "Acme-Alien-DontPanic",
  "dist_version" => "2.0000",
  "license" => "perl",
  "module_name" => "Acme::Alien::DontPanic",
  "recursive_test_files" => 1,
  "requires" => {
    "Alien::Base" => "2.00",
    "File::ShareDir" => "1.03",
    "perl" => "5.006"
  },
  "test_requires" => {
    "Test2::V0" => "0.000060",
    "Test::Alien" => "0.05",
    "Test::Alien::Diag" => 0,
    "perl" => "5.006"
  }
);


my %fallback_build_requires = (
  "Test2::V0" => "0.000060",
  "Test::Alien" => "0.05",
  "Test::Alien::Diag" => 0,
  "perl" => "5.006"
);


unless ( eval { Module::Build->VERSION(0.4004) } ) {
  delete $module_build_args{test_requires};
  $module_build_args{build_requires} = \%fallback_build_requires;
}

my $build = Alien::Base::ModuleBuild->new(%module_build_args);


$build->create_build_script;
