BEGIN {
  use strict; use warnings;
  unless(eval q{ use 5.006; 1}) {
    print "Perl 5.006 or better required\n";
    exit;
  }
}
# This file was automatically generated by Dist::Zilla::Plugin::Author::Plicease::MakeMaker v2.32.
use strict;
use warnings;
use 5.006;
use ExtUtils::MakeMaker;

my %WriteMakefileArgs = (
  "ABSTRACT"       => "Perl Foreign Function interface based on libffi",
  "AUTHOR"         => "Graham Ollis <plicease\@cpan.org>",
  "BUILD_REQUIRES" => {
    "FFI::Build" => "0.80"
  },
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => "7.24",
    "FFI::Build"          => "0.80"
  },
  "DISTNAME"         => "Alt-FFI-libffi",
  "LICENSE"          => "perl",
  "MIN_PERL_VERSION" => "5.006",
  "NAME"             => "Alt::FFI::libffi",
  "PM"               => {
    "lib/Alt/FFI/libffi.pm" => "\$(INST_LIB)/Alt/FFI/libffi.pm",
    "lib/FFI.pm"            => "\$(INST_LIB)/FFI.pm",
    "lib/FFI/Library.pm"    => "\$(INST_LIB)/FFI/Library.pm"
  },
  "PREREQ_PM" => {
    "FFI::Platypus" => "0.80"
  },
  "TEST_REQUIRES" => {
    "FFI::Build"    => "0.80",
    "FFI::CheckLib" => "0.06",
    "Test::More"    => "0.98"
  },
  "VERSION" => "0.08",
  "test"    => {
    "TESTS" => "t/*.t"
  }
);

my %FallbackPrereqs = (
  "FFI::Build"    => "0.80",
  "FFI::CheckLib" => "0.06",
  "FFI::Platypus" => "0.80",
  "Test::More"    => "0.98"
);

# BEGIN code inserted by Dist::Zilla::Plugin::FFI::Build
use FFI::Build::MM;
my $fbmm = FFI::Build::MM->new;
%WriteMakefileArgs = $fbmm->mm_args(%WriteMakefileArgs);

# END code inserted by Dist::Zilla::Plugin::FFI::Build

unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

# begin inserted by Dist::Zilla::Plugin::Alt 0.07
my $alt = $ENV{PERL_ALT_INSTALL} || '';
$WriteMakefileArgs{DESTDIR} =
  $alt ? $alt eq 'OVERWRITE' ? '' : $alt : 'no-install-alt';
if ( $^O eq 'MSWin32' && $WriteMakefileArgs{DESTDIR} ) {

  # Windows is a precious snowflake that can't handle DESTDIR
  # Caveat: this probably ignores any PREFIX specified by the user
  require Config;
  require File::Spec;
  my @prefix = split /:/, $Config::Config{prefix};
  $WriteMakefileArgs{PREFIX} = File::Spec->catdir( $WriteMakefileArgs{DESTDIR}, @prefix );
  delete $WriteMakefileArgs{DESTDIR};

  # DO NOT DO THIS SORT OF THING
  # THIS IS PRETTY UGLY AND PROBABLY BAD
  # DO AS I SAY AND NOT AS I DO
  package ExtUtils::MM_Any;
  my $orig = \&init_INSTALL;
  *init_INSTALL = sub {
    my ( $self, @args ) = @_;
    delete $self->{ARGS}{INSTALL_BASE} if $self->{ARGS}{PREFIX};
    $self->$orig(@args);
  }
}

# end inserted by Dist::Zilla::Plugin::Alt 0.07
WriteMakefile(%WriteMakefileArgs);

# BEGIN code inserted by Dist::Zilla::Plugin::FFI::Build
BEGIN {
  # append to any existing postamble.
  if ( my $old = MY->can('postamble') )
  {
    no warnings 'redefine';
    *MY::postamble = sub {
      $old->(@_) .
        "\n" .
        $fbmm->mm_postamble;
    };
  }
  else
  {
    *MY::postamble = sub {
      $fbmm->mm_postamble;
    };
  }
}

# END code inserted by Dist::Zilla::Plugin::FFI::Build