package Chart::Plotly::Trace::Pie::Title;
use Moose;
use MooseX::ExtraArgs;
use Moose::Util::TypeConstraints qw(enum union);
if ( !defined Moose::Util::TypeConstraints::find_type_constraint('PDL') ) {
    Moose::Util::TypeConstraints::type('PDL');
}

use Chart::Plotly::Trace::Pie::Title::Font;

our $VERSION = '0.032';    # VERSION

# ABSTRACT: This attribute is one of the possible options for the trace pie.

sub TO_JSON {
    my $self       = shift;
    my $extra_args = $self->extra_args // {};
    my $meta       = $self->meta;
    my %hash       = %$self;
    for my $name ( sort keys %hash ) {
        my $attr = $meta->get_attribute($name);
        if ( defined $attr ) {
            my $value = $hash{$name};
            my $type  = $attr->type_constraint;
            if ( $type && $type->equals('Bool') ) {
                $hash{$name} = $value ? \1 : \0;
            }
        }
    }
    %hash = ( %hash, %$extra_args );
    delete $hash{'extra_args'};
    if ( $self->can('type') && ( !defined $hash{'type'} ) ) {
        $hash{type} = $self->type();
    }
    return \%hash;
}

has font => ( is  => "rw",
              isa => "Maybe[HashRef]|Chart::Plotly::Trace::Pie::Title::Font", );

has position => (
    is  => "rw",
    isa => enum(
              [ "top left", "top center", "top right", "middle center", "bottom left", "bottom center", "bottom right" ]
    ),
    documentation =>
      "Specifies the location of the `title`. Note that the title's position used to be set by the now deprecated `titleposition` attribute.",
);

has text => (
    is  => "rw",
    isa => "Str",
    documentation =>
      "Sets the title of the chart. If it is empty, no title is displayed. Note that before the existence of `title.text`, the title's contents used to be defined as the `title` attribute itself. This behavior has been deprecated.",
);

__PACKAGE__->meta->make_immutable();
1;

__END__

=pod

=encoding utf-8

=head1 NAME

Chart::Plotly::Trace::Pie::Title - This attribute is one of the possible options for the trace pie.

=head1 VERSION

version 0.032

=head1 SYNOPSIS

 use HTML::Show;
 use Chart::Plotly;
 use Chart::Plotly::Trace::Pie;
 my @labels = ( "ants", "bees", "crickets", "dragonflies", "earwigs" );
 my $pie = Chart::Plotly::Trace::Pie->new( labels => \@labels, values => [ map { int( rand() * 10 ) } @labels ] );
 
 HTML::Show::show( Chart::Plotly::render_full_html( data => [$pie] ) );

=head1 DESCRIPTION

This attribute is part of the possible options for the trace pie.

This file has been autogenerated from the official plotly.js source.

If you like Plotly, please support them: L<https://plot.ly/> 
Open source announcement: L<https://plot.ly/javascript/open-source-announcement/>

Full reference: L<https://plot.ly/javascript/reference/#pie>

=head1 DISCLAIMER

This is an unofficial Plotly Perl module. Currently I'm not affiliated in any way with Plotly. 
But I think plotly.js is a great library and I want to use it with perl.

=head1 METHODS

=head2 TO_JSON

Serialize the trace to JSON. This method should be called only by L<JSON> serializer.

=head1 ATTRIBUTES

=over

=item * font

=item * position

Specifies the location of the `title`. Note that the title's position used to be set by the now deprecated `titleposition` attribute.

=item * text

Sets the title of the chart. If it is empty, no title is displayed. Note that before the existence of `title.text`, the title's contents used to be defined as the `title` attribute itself. This behavior has been deprecated.

=back

=head1 AUTHOR

Pablo Rodríguez González <pablo.rodriguez.gonzalez@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2019 by Pablo Rodríguez González.

This is free software, licensed under:

  The MIT (X11) License

=cut
