# Generated by default/object.tt
package Paws::CodeGuruReviewer::CommitDiffSourceCodeType;
  use Moose;
  has DestinationCommit => (is => 'ro', isa => 'Str');
  has MergeBaseCommit => (is => 'ro', isa => 'Str');
  has SourceCommit => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CodeGuruReviewer::CommitDiffSourceCodeType

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CodeGuruReviewer::CommitDiffSourceCodeType object:

  $service_obj->Method(Att1 => { DestinationCommit => $value, ..., SourceCommit => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CodeGuruReviewer::CommitDiffSourceCodeType object:

  $result = $service_obj->Method(...);
  $result->Att1->DestinationCommit

=head1 DESCRIPTION

A type of C<SourceCodeType>
(https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType)
that specifies the commit diff for a pull request on an associated
repository. The C<SourceCommit> and C<DestinationCommit> fields are
required to do a pull request code review.

=head1 ATTRIBUTES


=head2 DestinationCommit => Str

The SHA of the destination commit used to generate a commit diff. This
field is required for a pull request code review.


=head2 MergeBaseCommit => Str

The SHA of the merge base of a commit.


=head2 SourceCommit => Str

The SHA of the source commit used to generate a commit diff. This field
is required for a pull request code review.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CodeGuruReviewer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

