package Paws::SageMaker::DataCaptureConfigSummary;
  use Moose;
  has CaptureStatus => (is => 'ro', isa => 'Str', required => 1);
  has CurrentSamplingPercentage => (is => 'ro', isa => 'Int', required => 1);
  has DestinationS3Uri => (is => 'ro', isa => 'Str', required => 1);
  has EnableCapture => (is => 'ro', isa => 'Bool', required => 1);
  has KmsKeyId => (is => 'ro', isa => 'Str', required => 1);
1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::DataCaptureConfigSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::DataCaptureConfigSummary object:

  $service_obj->Method(Att1 => { CaptureStatus => $value, ..., KmsKeyId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::DataCaptureConfigSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->CaptureStatus

=head1 DESCRIPTION

This class has no description

=head1 ATTRIBUTES


=head2 B<REQUIRED> CaptureStatus => Str

  


=head2 B<REQUIRED> CurrentSamplingPercentage => Int

  


=head2 B<REQUIRED> DestinationS3Uri => Str

  


=head2 B<REQUIRED> EnableCapture => Bool

  


=head2 B<REQUIRED> KmsKeyId => Str

  



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

