=encoding utf8

=head1 Name

SPVM - SPVM Documents

=head1 Description

This document contains all documents for SPVM.

=head1 Documents

=over 2

=item * L<Language Specification|SPVM::Document::Language>

=over 2

=item * L<Lexical Tokenization|SPVM::Document::Language::Tokenization>

=item * L<Syntax Parsing|SPVM::Document::Language::SyntaxParsing>

=item * L<Class Definition|SPVM::Document::Language::Class>

=item * L<Types|SPVM::Document::Language::Types>

=item * L<Statements|SPVM::Document::Language::Statements>

=item * L<Operators|SPVM::Document::Language::Operators>

=item * L<Exception Handling|SPVM::Document::Language::ExceptionHandling>

=item * L<Garbage Collection|SPVM::Document::Language::GarbageCollection>

=item * L<System Setting|SPVM::Document::Language::System>

=back

=item * L<Exchange APIs|SPVM::ExchangeAPI>

=item * L<Native Classes|SPVM::Document::NativeClass>

=item * L<Native Class Configurations|SPVM::Builder::Config>

=item * L<Native APIs|SPVM::Document::NativeAPI>

=over 2

=item * L<Runtime Native APIs|SPVM::Document::NativeAPI::Runtime>

=item * L<Basic Type Native APIs|SPVM::Document::NativeAPI::BasicType>

=item * L<Class Variable Native APIs|SPVM::Document::NativeAPI::ClassVariable>

=item * L<Field Native APIs|SPVM::Document::NativeAPI::Field>

=item * L<Method Native APIs|SPVM::Document::NativeAPI::Method>

=item * L<Argument Native APIs|SPVM::Document::NativeAPI::Argument>

=item * L<Type Native APIs|SPVM::Document::NativeAPI::Type>

=item * L<Compiler Native APIs|SPVM::Document::NativeAPI::Compiler>

=item * L<Class File Native APIs|SPVM::Document::NativeAPI::ClassFile>

=item * L<String Buffer Native APIs|SPVM::Document::NativeAPI::StringBuffer>

=item * L<Allocatord Native APIs|SPVM::Document::NativeAPI::Allocator>

=item * L<Mutex Native APIs|SPVM::Document::NativeAPI::Mutex>

=item * L<Internal Native APIs|SPVM::Document::NativeAPI::Internal>

=back

=item * L<Resources|SPVM::Document::Resource>

=item * L<Environment Variables|SPVM::Document::EnvironmentVariables>

=back

=head1 See Also

=head2 SPVM

=over 2

=item * L<SPVM>

=back

=head2 Tutorial

=over 2

=item * L<SPVM Tutorial|https://github.com/yuki-kimoto/SPVM/wiki/Tutorial>

=back

=head2 Commands

=over 2

=item * L<spvm - Executing SPVM Programs|spvm>

=item * L<spvmcc - Generating Executable Files|spvmcc>

=item * L<spvmdist - Distributing SPVM Modules|spvmdist>

=back

=head2 Modules

=over 2

=item * L<Standard Modules|SPVM::Document::Modules>

=item * L<CPAN Modules|https://github.com/yuki-kimoto/SPVM/wiki/CPAN-Modules>

=back

=head2 Examples

=over 2

=item * L<SPVM Test Cases|https://github.com/yuki-kimoto/SPVM/tree/doc/t/02_vm/lib/SPVM/TestCase>

=item * L<Binding C/C++ Libraries|https://github.com/yuki-kimoto/SPVM/tree/doc/examples/native>

=back

=head2 Wiki

=over 2

=item * L<Wiki|https://github.com/yuki-kimoto/SPVM/wiki>

=back

=head1 Copyright & License

Copyright (c) 2023 Yuki Kimoto

MIT License

=cut
