#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
// Sub id declarations
// Basic type id declarations
static int32_t BASIC_TYPE_ID_int = -1;
// Function Declarations
// [SIG]int()
int32_t SPPRECOMPILE__TestCase__While__basic(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__While__condition_my(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__While__condition_my_var_mem_id(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__While__last(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__While__next(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__While__basic(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L3: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L4: // GOTO
  goto L9;
L5: // ADD_INT
  int_vars[3] = int_vars[3] + int_vars[4];
L6: // MOVE_INT
  int_vars[5] = int_vars[4];
L7: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L8: // ADD_INT
  int_vars[4] = int_vars[5] + int_vars[6];
L9: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L10: // LE_INT
  int_vars[0] = (int_vars[4] <= int_vars[5]);
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_NE_ZERO
  if (int_vars[0]) { goto L5; }
L13: // MOVE_CONSTANT_INT
  int_vars[6] = 6;
L14: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[6]);
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L19; }
L17: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L18: // GOTO
  goto L19;
L19: // BOOL_INT
  int_vars[0] = int_vars[1];
L20: // IF_NE_ZERO
  if (int_vars[0]) { goto L24; }
L21: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L28;
L23: // GOTO
  goto L24;
L24: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L28;
L26: // INIT_INT
  int_vars[7] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L28;
L28: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__While__condition_my(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[12];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 5;
L2: // GOTO
  goto L12;
L3: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L4: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L5: // BOOL_INT
  int_vars[0] = int_vars[0];
L6: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L10; }
L7: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L19;
L9: // GOTO
  goto L12;
L10: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L19;
L12: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L13: // BOOL_INT
  int_vars[0] = int_vars[3];
L14: // IF_NE_ZERO
  if (int_vars[0]) { goto L3; }
L15: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L19;
L17: // INIT_INT
  int_vars[10] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[10];
  goto L19;
L19: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__While__condition_my_var_mem_id(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // GOTO
  goto L12;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 10;
L3: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L4: // MOVE_CONSTANT_INT
  int_vars[5] = 5;
L5: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[5]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_NE_ZERO
  if (int_vars[0]) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L45;
L10: // GOTO
  goto L11;
L11: // GOTO
  goto L15;
L12: // MOVE_CONSTANT_INT
  int_vars[1] = 5;
L13: // BOOL_INT
  int_vars[0] = int_vars[1];
L14: // IF_NE_ZERO
  if (int_vars[0]) { goto L2; }
L15: // GOTO
  goto L37;
L16: // MOVE_CONSTANT_INT
  int_vars[3] = 10;
L17: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L18: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L19: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::While";
    const char* sub_name = "condition_my_var_mem_id";
    const char* file = "TestCase/While.spvm";
    int32_t line = 19;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L45;
  }
L21: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L22: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L23: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[5];
      } 
    } 
  } 
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::While";
    const char* sub_name = "condition_my_var_mem_id";
    const char* file = "TestCase/While.spvm";
    int32_t line = 19;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L45;
  }
L25: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L26: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L27: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L28: // MOVE_CONSTANT_INT
  int_vars[4] = 5;
L29: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[4]);
L30: // BOOL_INT
  int_vars[0] = int_vars[0];
L31: // IF_NE_ZERO
  if (int_vars[0]) { goto L35; }
L32: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L45;
L34: // GOTO
  goto L35;
L35: // GOTO
  goto L40;
L36: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L37: // MOVE_CONSTANT_INT
  int_vars[1] = 5;
L38: // BOOL_INT
  int_vars[0] = int_vars[1];
L39: // IF_NE_ZERO
  if (int_vars[0]) { goto L16; }
L40: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L41: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L42: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[1];
  goto L45;
L43: // INIT_INT
  int_vars[6] = 0;
L44: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L45;
L45: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L46: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__While__last(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[10];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L3: // GOTO
  goto L14;
L4: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L5: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[4]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L10; }
L8: // GOTO
  goto L18;
L9: // GOTO
  goto L10;
L10: // ADD_INT
  int_vars[3] = int_vars[3] + int_vars[1];
L11: // MOVE_INT
  int_vars[4] = int_vars[1];
L12: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L13: // ADD_INT
  int_vars[1] = int_vars[4] + int_vars[5];
L14: // MOVE_CONSTANT_INT
  int_vars[4] = 5;
L15: // LT_INT
  int_vars[0] = (int_vars[1] < int_vars[4]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_NE_ZERO
  if (int_vars[0]) { goto L4; }
L18: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L19: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[5]);
L20: // BOOL_INT
  int_vars[0] = int_vars[0];
L21: // IF_NE_ZERO
  if (int_vars[0]) { goto L25; }
L22: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L29;
L24: // GOTO
  goto L25;
L25: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L26: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L29;
L27: // INIT_INT
  int_vars[8] = 0;
L28: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[8];
  goto L29;
L29: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__While__next(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[10];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L3: // GOTO
  goto L17;
L4: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L5: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[4]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L8: // MOVE_INT
  int_vars[4] = int_vars[1];
L9: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L10: // ADD_INT
  int_vars[1] = int_vars[4] + int_vars[5];
L11: // GOTO
  goto L17;
L12: // GOTO
  goto L13;
L13: // ADD_INT
  int_vars[3] = int_vars[3] + int_vars[1];
L14: // MOVE_INT
  int_vars[4] = int_vars[1];
L15: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L16: // ADD_INT
  int_vars[1] = int_vars[4] + int_vars[5];
L17: // MOVE_CONSTANT_INT
  int_vars[4] = 5;
L18: // LT_INT
  int_vars[0] = (int_vars[1] < int_vars[4]);
L19: // BOOL_INT
  int_vars[0] = int_vars[0];
L20: // IF_NE_ZERO
  if (int_vars[0]) { goto L4; }
L21: // MOVE_CONSTANT_INT
  int_vars[5] = 7;
L22: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[5]);
L23: // BOOL_INT
  int_vars[0] = int_vars[0];
L24: // IF_NE_ZERO
  if (int_vars[0]) { goto L28; }
L25: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L26: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L32;
L27: // GOTO
  goto L28;
L28: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L29: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L32;
L30: // INIT_INT
  int_vars[8] = 0;
L31: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[8];
  goto L32;
L32: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


