#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
// Sub id declarations
static int32_t SUB_ID_TestCase__Pointer__new = - 1;
static int32_t SUB_ID_TestCase__Pointer__get_x = - 1;
// Basic type id declarations
// Function Declarations
// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Pointer__struct_test(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__Pointer__struct_test(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[1];
L4: // CALL_SUB_OBJECT
  // TestCase::Pointer->new
  {
    if (SUB_ID_TestCase__Pointer__new < 0) {
      SUB_ID_TestCase__Pointer__new = env->get_sub_id(env, "TestCase::Pointer", "new", "TestCase::Pointer(int)");
      if (SUB_ID_TestCase__Pointer__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Pointer new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Pointer__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Pointer";
    const char* sub_name = "struct_test";
    const char* file = "TestCase/Pointer.spvm";
    int32_t line = 9;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L20;
  }
L6: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L7: // CALL_SUB_INT
  // TestCase::Pointer->get_x
  {
    if (SUB_ID_TestCase__Pointer__get_x < 0) {
      SUB_ID_TestCase__Pointer__get_x = env->get_sub_id(env, "TestCase::Pointer", "get_x", "int(self)");
      if (SUB_ID_TestCase__Pointer__get_x < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Pointer get_x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Pointer__get_x;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Pointer";
    const char* sub_name = "struct_test";
    const char* file = "TestCase/Pointer.spvm";
    int32_t line = 10;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L20;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L10: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L16; }
L13: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L20;
L15: // GOTO
  goto L16;
L16: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L20;
L18: // INIT_INT
  int_vars[7] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L20;
L20: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L21: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


