#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
// Sub id declarations
// Basic type id declarations
// Function Declarations
// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_char(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]double()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_double_0(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]double()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_double_0_5(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]double()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_double_1(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]double()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_double_exponent_E_minus(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]double()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_double_exponent_E_plus(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]double()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_double_exponent_e_minus(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]double()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_double_exponent_e_plus(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]float()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_float_0(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]float()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_float_0_5(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]float()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_float_1(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]float()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_float_exponent_E_minus(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]float()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_float_exponent_E_plus(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]float()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_float_exponent_e_minus(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]float()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_float_exponent_e_plus(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_int_0(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_int_1(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_int_127(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_int_128(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_int_2(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_int_3(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_int_32767(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_int_32768(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_int_4(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_int_5(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_int_6(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_int_m1(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_int_m128(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_int_m129(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_int_m2(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_int_m32768(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_int_m32769(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_int_max(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_int_min(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]long()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_long_0(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]long()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_long_1(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]long()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_long_127(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]long()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_long_128(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]long()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_long_2(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]long()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_long_3(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]long()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_long_32767(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]long()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_long_32768(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]long()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_long_4(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]long()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_long_5(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]long()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_long_6(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]long()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_long_m1(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]long()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_long_m128(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]long()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_long_m129(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]long()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_long_m2(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]long()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_long_m32768(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]long()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_long_m32769(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]long()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_long_max(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]long()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_long_middle(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]long()
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_long_min(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]long()
int32_t SPPRECOMPILE__TestCase__Constant__multiply_long_overflow(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__Constant__load_constant_char(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x61';
L2: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L3: // MOVE_CONSTANT_INT
  int_vars[3] = 97;
L4: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L5: // BOOL_INT
  int_vars[0] = int_vars[0];
L6: // IF_NE_ZERO
  if (int_vars[0]) { goto L10; }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L14;
L9: // GOTO
  goto L10;
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L14;
L12: // INIT_INT
  int_vars[6] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L14;
L14: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__load_constant_double_0(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.0;
L2: // RETURN_DOUBLE
  *(double*)&stack[0] = double_vars[0];
  goto L5;
L3: // INIT_DOUBLE
  double_vars[1] = 0;
L4: // RETURN_DOUBLE
  *(double*)&stack[0] = double_vars[1];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__load_constant_double_0_5(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.5;
L2: // RETURN_DOUBLE
  *(double*)&stack[0] = double_vars[0];
  goto L5;
L3: // INIT_DOUBLE
  double_vars[1] = 0;
L4: // RETURN_DOUBLE
  *(double*)&stack[0] = double_vars[1];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__load_constant_double_1(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0;
L2: // RETURN_DOUBLE
  *(double*)&stack[0] = double_vars[0];
  goto L5;
L3: // INIT_DOUBLE
  double_vars[1] = 0;
L4: // RETURN_DOUBLE
  *(double*)&stack[0] = double_vars[1];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__load_constant_double_exponent_E_minus(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.0625;
L2: // RETURN_DOUBLE
  *(double*)&stack[0] = double_vars[0];
  goto L5;
L3: // INIT_DOUBLE
  double_vars[1] = 0;
L4: // RETURN_DOUBLE
  *(double*)&stack[0] = double_vars[1];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__load_constant_double_exponent_E_plus(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 500.0;
L2: // RETURN_DOUBLE
  *(double*)&stack[0] = double_vars[0];
  goto L5;
L3: // INIT_DOUBLE
  double_vars[1] = 0;
L4: // RETURN_DOUBLE
  *(double*)&stack[0] = double_vars[1];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__load_constant_double_exponent_e_minus(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.0625;
L2: // RETURN_DOUBLE
  *(double*)&stack[0] = double_vars[0];
  goto L5;
L3: // INIT_DOUBLE
  double_vars[1] = 0;
L4: // RETURN_DOUBLE
  *(double*)&stack[0] = double_vars[1];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__load_constant_double_exponent_e_plus(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 500.0;
L2: // RETURN_DOUBLE
  *(double*)&stack[0] = double_vars[0];
  goto L5;
L3: // INIT_DOUBLE
  double_vars[1] = 0;
L4: // RETURN_DOUBLE
  *(double*)&stack[0] = double_vars[1];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__load_constant_float_0(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[2];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.0;
L2: // RETURN_FLOAT
  *(float*)&stack[0] = float_vars[0];
  goto L5;
L3: // INIT_FLOAT
  float_vars[1] = 0;
L4: // RETURN_FLOAT
  *(float*)&stack[0] = float_vars[1];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__load_constant_float_0_5(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[2];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L2: // RETURN_FLOAT
  *(float*)&stack[0] = float_vars[0];
  goto L5;
L3: // INIT_FLOAT
  float_vars[1] = 0;
L4: // RETURN_FLOAT
  *(float*)&stack[0] = float_vars[1];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__load_constant_float_1(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[2];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 1.0;
L2: // RETURN_FLOAT
  *(float*)&stack[0] = float_vars[0];
  goto L5;
L3: // INIT_FLOAT
  float_vars[1] = 0;
L4: // RETURN_FLOAT
  *(float*)&stack[0] = float_vars[1];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__load_constant_float_exponent_E_minus(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[2];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.0625;
L2: // RETURN_FLOAT
  *(float*)&stack[0] = float_vars[0];
  goto L5;
L3: // INIT_FLOAT
  float_vars[1] = 0;
L4: // RETURN_FLOAT
  *(float*)&stack[0] = float_vars[1];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__load_constant_float_exponent_E_plus(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[2];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 500.0;
L2: // RETURN_FLOAT
  *(float*)&stack[0] = float_vars[0];
  goto L5;
L3: // INIT_FLOAT
  float_vars[1] = 0;
L4: // RETURN_FLOAT
  *(float*)&stack[0] = float_vars[1];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__load_constant_float_exponent_e_minus(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[2];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.0625;
L2: // RETURN_FLOAT
  *(float*)&stack[0] = float_vars[0];
  goto L5;
L3: // INIT_FLOAT
  float_vars[1] = 0;
L4: // RETURN_FLOAT
  *(float*)&stack[0] = float_vars[1];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__load_constant_float_exponent_e_plus(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[2];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 500.0;
L2: // RETURN_FLOAT
  *(float*)&stack[0] = float_vars[0];
  goto L5;
L3: // INIT_FLOAT
  float_vars[1] = 0;
L4: // RETURN_FLOAT
  *(float*)&stack[0] = float_vars[1];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__load_constant_int_0(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[5];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L2: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[1];
  goto L5;
L3: // INIT_INT
  int_vars[3] = 0;
L4: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__load_constant_int_1(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[5];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[1];
  goto L5;
L3: // INIT_INT
  int_vars[3] = 0;
L4: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__load_constant_int_127(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[5];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 127;
L2: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[1];
  goto L5;
L3: // INIT_INT
  int_vars[3] = 0;
L4: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__load_constant_int_128(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[5];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 128;
L2: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[1];
  goto L5;
L3: // INIT_INT
  int_vars[3] = 0;
L4: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__load_constant_int_2(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[5];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 2;
L2: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[1];
  goto L5;
L3: // INIT_INT
  int_vars[3] = 0;
L4: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__load_constant_int_3(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[5];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[1];
  goto L5;
L3: // INIT_INT
  int_vars[3] = 0;
L4: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__load_constant_int_32767(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[5];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 32767;
L2: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[1];
  goto L5;
L3: // INIT_INT
  int_vars[3] = 0;
L4: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__load_constant_int_32768(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[5];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 32768;
L2: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[1];
  goto L5;
L3: // INIT_INT
  int_vars[3] = 0;
L4: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__load_constant_int_4(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[5];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 4;
L2: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[1];
  goto L5;
L3: // INIT_INT
  int_vars[3] = 0;
L4: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__load_constant_int_5(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[5];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 5;
L2: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[1];
  goto L5;
L3: // INIT_INT
  int_vars[3] = 0;
L4: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__load_constant_int_6(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[5];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 6;
L2: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[1];
  goto L5;
L3: // INIT_INT
  int_vars[3] = 0;
L4: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__load_constant_int_m1(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[5];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = -1;
L2: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[1];
  goto L5;
L3: // INIT_INT
  int_vars[3] = 0;
L4: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__load_constant_int_m128(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[5];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = -128;
L2: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[1];
  goto L5;
L3: // INIT_INT
  int_vars[3] = 0;
L4: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__load_constant_int_m129(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[5];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = -129;
L2: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[1];
  goto L5;
L3: // INIT_INT
  int_vars[3] = 0;
L4: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__load_constant_int_m2(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[5];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = -2;
L2: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[1];
  goto L5;
L3: // INIT_INT
  int_vars[3] = 0;
L4: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__load_constant_int_m32768(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[5];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = -32768;
L2: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[1];
  goto L5;
L3: // INIT_INT
  int_vars[3] = 0;
L4: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__load_constant_int_m32769(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[5];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = -32769;
L2: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[1];
  goto L5;
L3: // INIT_INT
  int_vars[3] = 0;
L4: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__load_constant_int_max(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[5];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 2147483647;
L2: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[1];
  goto L5;
L3: // INIT_INT
  int_vars[3] = 0;
L4: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__load_constant_int_min(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[5];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = INT32_MIN;
L2: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[1];
  goto L5;
L3: // INIT_INT
  int_vars[3] = 0;
L4: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__load_constant_long_0(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_LONG
  long_vars[0] = 0LL;
L2: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[0];
  goto L5;
L3: // INIT_LONG
  long_vars[1] = 0;
L4: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[1];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__load_constant_long_1(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_LONG
  long_vars[0] = 1LL;
L2: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[0];
  goto L5;
L3: // INIT_LONG
  long_vars[1] = 0;
L4: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[1];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__load_constant_long_127(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_LONG
  long_vars[0] = 127LL;
L2: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[0];
  goto L5;
L3: // INIT_LONG
  long_vars[1] = 0;
L4: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[1];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__load_constant_long_128(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_LONG
  long_vars[0] = 128LL;
L2: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[0];
  goto L5;
L3: // INIT_LONG
  long_vars[1] = 0;
L4: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[1];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__load_constant_long_2(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_LONG
  long_vars[0] = 2LL;
L2: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[0];
  goto L5;
L3: // INIT_LONG
  long_vars[1] = 0;
L4: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[1];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__load_constant_long_3(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_LONG
  long_vars[0] = 3LL;
L2: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[0];
  goto L5;
L3: // INIT_LONG
  long_vars[1] = 0;
L4: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[1];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__load_constant_long_32767(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_LONG
  long_vars[0] = 32767LL;
L2: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[0];
  goto L5;
L3: // INIT_LONG
  long_vars[1] = 0;
L4: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[1];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__load_constant_long_32768(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_LONG
  long_vars[0] = 32768LL;
L2: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[0];
  goto L5;
L3: // INIT_LONG
  long_vars[1] = 0;
L4: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[1];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__load_constant_long_4(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_LONG
  long_vars[0] = 4LL;
L2: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[0];
  goto L5;
L3: // INIT_LONG
  long_vars[1] = 0;
L4: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[1];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__load_constant_long_5(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_LONG
  long_vars[0] = 5LL;
L2: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[0];
  goto L5;
L3: // INIT_LONG
  long_vars[1] = 0;
L4: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[1];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__load_constant_long_6(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_LONG
  long_vars[0] = 6LL;
L2: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[0];
  goto L5;
L3: // INIT_LONG
  long_vars[1] = 0;
L4: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[1];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__load_constant_long_m1(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_LONG
  long_vars[0] = -1LL;
L2: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[0];
  goto L5;
L3: // INIT_LONG
  long_vars[1] = 0;
L4: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[1];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__load_constant_long_m128(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_LONG
  long_vars[0] = -128LL;
L2: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[0];
  goto L5;
L3: // INIT_LONG
  long_vars[1] = 0;
L4: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[1];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__load_constant_long_m129(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_LONG
  long_vars[0] = -129LL;
L2: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[0];
  goto L5;
L3: // INIT_LONG
  long_vars[1] = 0;
L4: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[1];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__load_constant_long_m2(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_LONG
  long_vars[0] = -2LL;
L2: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[0];
  goto L5;
L3: // INIT_LONG
  long_vars[1] = 0;
L4: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[1];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__load_constant_long_m32768(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_LONG
  long_vars[0] = -32768LL;
L2: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[0];
  goto L5;
L3: // INIT_LONG
  long_vars[1] = 0;
L4: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[1];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__load_constant_long_m32769(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_LONG
  long_vars[0] = -32769LL;
L2: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[0];
  goto L5;
L3: // INIT_LONG
  long_vars[1] = 0;
L4: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[1];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__load_constant_long_max(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_LONG
  long_vars[0] = 9223372036854775807LL;
L2: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[0];
  goto L5;
L3: // INIT_LONG
  long_vars[1] = 0;
L4: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[1];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__load_constant_long_middle(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_LONG
  long_vars[0] = 4611686018427387904LL;
L2: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[0];
  goto L5;
L3: // INIT_LONG
  long_vars[1] = 0;
L4: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[1];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__load_constant_long_min(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_LONG
  long_vars[0] = INT64_MIN;
L2: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[0];
  goto L5;
L3: // INIT_LONG
  long_vars[1] = 0;
L4: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[1];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Constant__multiply_long_overflow(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_LONG
  long_vars[0] = 4611686018427387904LL;
L2: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[0];
  goto L5;
L3: // INIT_LONG
  long_vars[1] = 0;
L4: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[1];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


