use 5.006;
use strict;
use warnings;
use ExtUtils::MakeMaker;

WriteMakefile(
#   INSTALL_BASE     => "$ENV{HOME}/usr",
    NAME	     => 'Statistics::Covid',
    AUTHOR	     => q{Andreas Hadjiprocopis <bliako@cpan.org>},
    VERSION_FROM     => 'lib/Statistics/Covid.pm',
    ABSTRACT_FROM    => 'lib/Statistics/Covid.pm',
    LICENSE	     => 'artistic_2',
    EXE_FILES        => [qw| script/statistics-covid-fetch-data-and-store.pl |],
    PL_FILES	     => {},
    MIN_PERL_VERSION => '5.006',
    CONFIGURE_REQUIRES => {
	'ExtUtils::MakeMaker' => '0',
    },
    BUILD_REQUIRES => {
	'Test::More' => '0',
	'Test::Harness' => '0',
    },
    PREREQ_PM => {
	'DateTime' => '0',
	'DateTime::Format::Strptime' => '0',
	'File::Basename' => '0',
	'Getopt::Long' => '0',
	'File::Copy' => '0',
	'File::Path' => '0',
	'File::Spec' => '0',
	'HTTP::CookieJar::LWP' => '0',
	'LWP::UserAgent' => '0',
	'JSON::Parse' => '0',
	'Storable' => '0',
	'Data::Dump' => '0',
	'Try::Tiny' => '0',
    },

    dist  => { COMPRESS => 'gzip -9f', SUFFIX => 'gz', },
    clean => { FILES => 'Statistics-Covid-UK-*' },
    postamble => { BENCHMARK_FILES => 'xt/benchmarks/*.b' }
);

sub MY::postamble {
    my (undef,%h) = @_;
    require Data::Dumper;
    #print STDERR Data::Dumper->Dump([\%h], [qw(mm_args{postamble})]);
    return "BENCHMARK_FILES=$h{BENCHMARK_FILES}\n"
	. <<'POSTAMBLE';
TEST_D = $(ABSPERLRUN) -MExtUtils::Command -e test_d --

bench :: $(BENCHMARK_FILES)
	prove --blib $(INST_LIB) --blib $(INST_ARCHLIB) --verbose $^

bench2 :: $(BENCHMARK_FILES)
	$(TEST_D) xt && $(MAKE) test TEST_FILES='$(BENCHMARK_FILES)'
POSTAMBLE
}
