package Dist::Zilla::Plugin::perlmv;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2020-08-04'; # DATE
our $DIST = 'Dist-Zilla-Plugin-perlmv'; # DIST
our $VERSION = '0.001'; # VERSION

use 5.010001;
use strict;
use warnings;

use Moose;
#with 'Dist::Zilla::Role::AfterBuild';
#with 'Dist::Zilla::Role::FileGatherer';
#with 'Dist::Zilla::Role::PrereqSource';
use namespace::autoclean;

__PACKAGE__->meta->make_immutable;
1;
# ABSTRACT: Plugin to use when building App::perlmv and App::perlmv::scriptlet::* distribution

__END__

=pod

=encoding UTF-8

=head1 NAME

Dist::Zilla::Plugin::perlmv - Plugin to use when building App::perlmv and App::perlmv::scriptlet::* distribution

=head1 VERSION

This document describes version 0.001 of Dist::Zilla::Plugin::perlmv (from Perl distribution Dist-Zilla-Plugin-perlmv), released on 2020-08-04.

=head1 SYNOPSIS

In F<dist.ini>:

 [perlmv]

=head1 DESCRIPTION

This plugin is to be used when building L<App::perlmv> and
C<App::perlmv::scriptlet::*> distributions. It currently does nothing.

=for Pod::Coverage .+

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Dist-Zilla-Plugin-perlmv>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Dist-Zilla-Plugin-perlmv>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Dist-Zilla-Plugin-perlmv>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

L<Pod::Weaver::Plugin::perlmv>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
