use utf8;

package SemanticWeb::Schema::Claim;

# ABSTRACT: A [[Claim]] in Schema

use Moo;

extends qw/ SemanticWeb::Schema::CreativeWork /;


use MooX::JSON_LD 'Claim';
use Ref::Util qw/ is_plain_hashref /;
# RECOMMEND PREREQ: Ref::Util::XS

use namespace::autoclean;

our $VERSION = 'v11.0.0';


has appearance => (
    is        => 'rw',
    predicate => '_has_appearance',
    json_ld   => 'appearance',
);



has first_appearance => (
    is        => 'rw',
    predicate => '_has_first_appearance',
    json_ld   => 'firstAppearance',
);





1;

__END__

=pod

=encoding UTF-8

=head1 NAME

SemanticWeb::Schema::Claim - A [[Claim]] in Schema

=head1 VERSION

version v11.0.0

=head1 DESCRIPTION

A [[Claim]] in Schema.org represents a specific, factually-oriented claim
that could be the [[itemReviewed]] in a [[ClaimReview]]. The content of a
claim can be summarized with the [[text]] property. Variations on well
known claims can have their common identity indicated via [[sameAs]] links,
and summarized with a [[name]]. Ideally, a [[Claim]] description includes
enough contextual information to minimize the risk of ambiguity or
inclarity. In practice, many claims are better understood in the context in
which they appear or the interpretations provided by claim reviews. Beyond
[[ClaimReview]], the Claim type can be associated with related creative
works - for example a [[ScholaryArticle]] or [[Question]] might be
[[about]] some [[Claim]]. At this time, Schema.org does not define any
types of relationship between claims. This is a natural area for future
exploration. 

=head1 ATTRIBUTES

=head2 C<appearance>

Indicates an occurence of a [[Claim]] in some [[CreativeWork]].

A appearance should be one of the following types:

=over

=item C<InstanceOf['SemanticWeb::Schema::CreativeWork']>

=back

=head2 C<_has_appearance>

A predicate for the L</appearance> attribute.

=head2 C<first_appearance>

C<firstAppearance>

Indicates the first known occurence of a [[Claim]] in some
[[CreativeWork]].

A first_appearance should be one of the following types:

=over

=item C<InstanceOf['SemanticWeb::Schema::CreativeWork']>

=back

=head2 C<_has_first_appearance>

A predicate for the L</first_appearance> attribute.

=head1 SEE ALSO

L<SemanticWeb::Schema::CreativeWork>

=head1 SOURCE

The development version is on github at L<https://github.com/robrwo/SemanticWeb-Schema>
and may be cloned from L<git://github.com/robrwo/SemanticWeb-Schema.git>

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website
L<https://github.com/robrwo/SemanticWeb-Schema/issues>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

Robert Rothenberg <rrwo@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2018-2020 by Robert Rothenberg.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
