#!/usr/bin/perl

use strict;
use warnings;

use Test::More;

use Future;

use Future::AsyncAwait;

my $orig_cxstack_ix = Future::AsyncAwait::__cxstack_ix;

my $f;
my $failure;

async sub inner
{
   my $ret = await $f;
   die $failure if defined $failure;
   return $ret;
}

async sub outer
{
   await inner();
}

# await through two nested async sub calls
# See also RT123062
{
   $f = Future->new;

   my $fret = outer();
   $f->done( "value" );

   is( scalar $fret->get, "value", '$fret->get through two nested async subs' );
}

# die after double await
# See also RT126037
{
   $f = Future->new;

   my $fret = outer();
   $failure = "Oopsie\n";

   $f->done( "result" );

   is( scalar $fret->failure, "Oopsie\n", '$fret->failure through two nested async subs' );
}

# await through two nested async method calls
{
   my $f = Future->new;

   package TestObj {
      async sub inner {
         await $f;
      }

      async sub outer {
         my $mth = "inner";
         await shift->$mth;
      }
   }

   my $fret = TestObj->outer();
   $f->done( "value" );

   is( scalar $fret->get, "value", '$fret->get through two nested async methods' );
}

is( Future::AsyncAwait::__cxstack_ix, $orig_cxstack_ix,
   'cxstack_ix did not grow during the test' );

done_testing;
