package Foo::Testmysqlorm::Sport::ResultClass;

use Modern::Perl;
use Moose;
use namespace::autoclean;
use Method::Signatures;
use Data::Printer alias => 'pdump';

has sport_id => (
## type:    int(11)
## key:     PRI
## autoinc: yes
## null:    no
## default:
    is      => 'rw',
    isa     => 'Num|HashRef',
    trigger => sub {
        my $self = shift;
        $self->_touched->{sport_id}++;
    },
);

has sport_name => (
## type:    varchar(50)
## key:     UNI
## autoinc: no
## null:    no
## default:
    is      => 'rw',
    isa     => 'Str|HashRef',
    trigger => sub {
        my $self = shift;
        $self->_touched->{sport_name}++;
    },
);

has _touched => (
    is      => 'rw',
    isa     => 'HashRef',
    default => sub { {} },
);

method get_touched_attributes (
) {
    my @attr = keys %{ $self->_touched };

    return @attr;
}

1;
