#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
static int32_t FIELD_ID_TestCase__Simple__object_value = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Simple__object_value = -1;
// Sub id declarations
static int32_t SUB_ID_TestCase__Refcnt__func = - 1;
// Basic type id declarations
static int32_t BASIC_TYPE_ID_TestCase__Minimal = -1;
static int32_t BASIC_TYPE_ID_int = -1;
static int32_t BASIC_TYPE_ID_TestCase__Simple = -1;
// Function Declarations
// [SIG]void(TestCase::Minimal)
int32_t SPPRECOMPILE__TestCase__Refcnt__func(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Refcnt__refcnt_test(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__Refcnt__func(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // RETURN_VOID
  goto L4;
L3: // RETURN_VOID
  goto L4;
L4: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Refcnt__refcnt_test(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[11];
  int32_t exception_flag = 0;
  int32_t mortal_stack[16];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
      BASIC_TYPE_ID_TestCase__Minimal = env->get_basic_type_id(env, "TestCase::Minimal");
      if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Minimal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Minimal;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L3: // REFCNT
  {
    void* object = object_vars[0];
    if (object == NULL) {
      int_vars[2]       = 0;
    }
    else {
      int_vars[2]    = env->get_ref_count(env, object);
    }
  }
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L5: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_NE_ZERO
  if (int_vars[0]) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L145;
L10: // GOTO
  goto L11;
L11: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L12: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L13: // REFCNT
  {
    void* object = object_vars[0];
    if (object == NULL) {
      int_vars[2]       = 0;
    }
    else {
      int_vars[2]    = env->get_ref_count(env, object);
    }
  }
L14: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L15: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_NE_ZERO
  if (int_vars[0]) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L145;
L20: // GOTO
  goto L21;
L21: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L22: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L23: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
      BASIC_TYPE_ID_TestCase__Minimal = env->get_basic_type_id(env, "TestCase::Minimal");
      if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Minimal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Minimal;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L24: // REFCNT
  {
    void* object = object_vars[0];
    if (object == NULL) {
      int_vars[2]       = 0;
    }
    else {
      int_vars[2]    = env->get_ref_count(env, object);
    }
  }
L25: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L26: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L27: // BOOL_INT
  int_vars[0] = int_vars[0];
L28: // IF_NE_ZERO
  if (int_vars[0]) { goto L32; }
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L30: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L145;
L31: // GOTO
  goto L32;
L32: // REFCNT
  {
    void* object = object_vars[0];
    if (object == NULL) {
      int_vars[4]       = 0;
    }
    else {
      int_vars[4]    = env->get_ref_count(env, object);
    }
  }
L33: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L34: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L35: // BOOL_INT
  int_vars[0] = int_vars[0];
L36: // IF_NE_ZERO
  if (int_vars[0]) { goto L40; }
L37: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L38: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L145;
L39: // GOTO
  goto L40;
L40: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L41: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L42: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L43: // REFCNT
  {
    void* object = object_vars[0];
    if (object == NULL) {
      int_vars[2]       = 0;
    }
    else {
      int_vars[2]    = env->get_ref_count(env, object);
    }
  }
L44: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L45: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L46: // BOOL_INT
  int_vars[0] = int_vars[0];
L47: // IF_NE_ZERO
  if (int_vars[0]) { goto L51; }
L48: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L49: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L145;
L50: // GOTO
  goto L51;
L51: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L52: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L53: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L54: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L55: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Refcnt";
    const char* sub_name = "refcnt_test";
    const char* file = "TestCase/Refcnt.spvm";
    int32_t line = 44;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L145;
  }
L56: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L57: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L58: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[5];
      } 
    } 
  } 
L59: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Refcnt";
    const char* sub_name = "refcnt_test";
    const char* file = "TestCase/Refcnt.spvm";
    int32_t line = 44;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L145;
  }
L60: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L61: // MOVE_CONSTANT_INT
  int_vars[8] = 1;
L62: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[7];
      } 
    } 
  } 
L63: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Refcnt";
    const char* sub_name = "refcnt_test";
    const char* file = "TestCase/Refcnt.spvm";
    int32_t line = 44;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L145;
  }
L64: // MOVE_CONSTANT_INT
  int_vars[9] = 3;
L65: // MOVE_CONSTANT_INT
  int_vars[10] = 2;
L66: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[10];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[9];
      } 
    } 
  } 
L67: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Refcnt";
    const char* sub_name = "refcnt_test";
    const char* file = "TestCase/Refcnt.spvm";
    int32_t line = 44;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L145;
  }
L68: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L69: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L70: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L71: // REFCNT
  {
    void* object = object_vars[1];
    if (object == NULL) {
      int_vars[2]       = 0;
    }
    else {
      int_vars[2]    = env->get_ref_count(env, object);
    }
  }
L72: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L73: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L74: // BOOL_INT
  int_vars[0] = int_vars[0];
L75: // IF_NE_ZERO
  if (int_vars[0]) { goto L79; }
L76: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L77: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L145;
L78: // GOTO
  goto L79;
L79: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L80: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L81: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_TestCase__Simple < 0) {
      BASIC_TYPE_ID_TestCase__Simple = env->get_basic_type_id(env, "TestCase::Simple");
      if (BASIC_TYPE_ID_TestCase__Simple < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Simple");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Simple;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L82: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L83: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
      BASIC_TYPE_ID_TestCase__Minimal = env->get_basic_type_id(env, "TestCase::Minimal");
      if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Minimal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Minimal;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object);
  }
L84: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__object_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__object_value = env->get_field_id(env, "TestCase::Simple", "object_value", "TestCase::Minimal");
      if (FIELD_ID_TestCase__Simple__object_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple object_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__object_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__object_value);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__object_value);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L85: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Refcnt";
    const char* sub_name = "refcnt_test";
    const char* file = "TestCase/Refcnt.spvm";
    int32_t line = 55;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L145;
  }
L86: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L87: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L88: // GET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__object_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__object_value = env->get_field_id(env, "TestCase::Simple", "object_value", "TestCase::Minimal");
      if (FIELD_ID_TestCase__Simple__object_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple object_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__object_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__object_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object = *(void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__object_value);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], get_field_object);    }
  }
L89: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Refcnt";
    const char* sub_name = "refcnt_test";
    const char* file = "TestCase/Refcnt.spvm";
    int32_t line = 57;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L145;
  }
L90: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L91: // CALL_SUB_VOID
  // TestCase::Refcnt->func
  {
    if (SUB_ID_TestCase__Refcnt__func < 0) {
      SUB_ID_TestCase__Refcnt__func = env->get_sub_id(env, "TestCase::Refcnt", "func", "void(TestCase::Minimal)");
      if (SUB_ID_TestCase__Refcnt__func < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Refcnt func");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Refcnt__func;
    exception_flag = SPPRECOMPILE__TestCase__Refcnt__func(env, stack);
    if (!exception_flag) {
    }
  }
L92: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Refcnt";
    const char* sub_name = "refcnt_test";
    const char* file = "TestCase/Refcnt.spvm";
    int32_t line = 57;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L145;
  }
L93: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L94: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L95: // GET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__object_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__object_value = env->get_field_id(env, "TestCase::Simple", "object_value", "TestCase::Minimal");
      if (FIELD_ID_TestCase__Simple__object_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple object_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__object_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__object_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object = *(void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__object_value);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], get_field_object);    }
  }
L96: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Refcnt";
    const char* sub_name = "refcnt_test";
    const char* file = "TestCase/Refcnt.spvm";
    int32_t line = 58;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L145;
  }
L97: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L98: // CALL_SUB_VOID
  // TestCase::Refcnt->func
  {
    if (SUB_ID_TestCase__Refcnt__func < 0) {
      SUB_ID_TestCase__Refcnt__func = env->get_sub_id(env, "TestCase::Refcnt", "func", "void(TestCase::Minimal)");
      if (SUB_ID_TestCase__Refcnt__func < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Refcnt func");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Refcnt__func;
    exception_flag = SPPRECOMPILE__TestCase__Refcnt__func(env, stack);
    if (!exception_flag) {
    }
  }
L99: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Refcnt";
    const char* sub_name = "refcnt_test";
    const char* file = "TestCase/Refcnt.spvm";
    int32_t line = 58;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L145;
  }
L100: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L101: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L102: // GET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__object_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__object_value = env->get_field_id(env, "TestCase::Simple", "object_value", "TestCase::Minimal");
      if (FIELD_ID_TestCase__Simple__object_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple object_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__object_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__object_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object = *(void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__object_value);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], get_field_object);    }
  }
L103: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Refcnt";
    const char* sub_name = "refcnt_test";
    const char* file = "TestCase/Refcnt.spvm";
    int32_t line = 60;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L145;
  }
L104: // REFCNT
  {
    void* object = object_vars[1];
    if (object == NULL) {
      int_vars[2]       = 0;
    }
    else {
      int_vars[2]    = env->get_ref_count(env, object);
    }
  }
L105: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L106: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L107: // BOOL_INT
  int_vars[0] = int_vars[0];
L108: // IF_NE_ZERO
  if (int_vars[0]) { goto L112; }
L109: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L110: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L145;
L111: // GOTO
  goto L112;
L112: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L113: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L114: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_TestCase__Simple < 0) {
      BASIC_TYPE_ID_TestCase__Simple = env->get_basic_type_id(env, "TestCase::Simple");
      if (BASIC_TYPE_ID_TestCase__Simple < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Simple");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Simple;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L115: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L116: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
      BASIC_TYPE_ID_TestCase__Minimal = env->get_basic_type_id(env, "TestCase::Minimal");
      if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Minimal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Minimal;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object);
  }
L117: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__object_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__object_value = env->get_field_id(env, "TestCase::Simple", "object_value", "TestCase::Minimal");
      if (FIELD_ID_TestCase__Simple__object_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple object_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__object_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__object_value);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__object_value);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L118: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Refcnt";
    const char* sub_name = "refcnt_test";
    const char* file = "TestCase/Refcnt.spvm";
    int32_t line = 71;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L145;
  }
L119: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L120: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L121: // GET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__object_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__object_value = env->get_field_id(env, "TestCase::Simple", "object_value", "TestCase::Minimal");
      if (FIELD_ID_TestCase__Simple__object_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple object_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__object_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__object_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object = *(void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__object_value);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], get_field_object);    }
  }
L122: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Refcnt";
    const char* sub_name = "refcnt_test";
    const char* file = "TestCase/Refcnt.spvm";
    int32_t line = 73;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L145;
  }
L123: // BOOL_OBJECT
  int_vars[0] = !!object_vars[1];
L124: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L138; }
L125: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L126: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L127: // GET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__object_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__object_value = env->get_field_id(env, "TestCase::Simple", "object_value", "TestCase::Minimal");
      if (FIELD_ID_TestCase__Simple__object_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple object_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__object_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__object_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object = *(void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__object_value);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], get_field_object);    }
  }
L128: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Refcnt";
    const char* sub_name = "refcnt_test";
    const char* file = "TestCase/Refcnt.spvm";
    int32_t line = 74;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L145;
  }
L129: // REFCNT
  {
    void* object = object_vars[1];
    if (object == NULL) {
      int_vars[2]       = 0;
    }
    else {
      int_vars[2]    = env->get_ref_count(env, object);
    }
  }
L130: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L131: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L132: // BOOL_INT
  int_vars[0] = int_vars[0];
L133: // IF_NE_ZERO
  if (int_vars[0]) { goto L137; }
L134: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L135: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L145;
L136: // GOTO
  goto L137;
L137: // GOTO
  goto L139;
L138: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L139: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L140: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L141: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L142: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L145;
L143: // INIT_INT
  int_vars[6] = 0;
L144: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L145;
L145: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L146: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


