#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
static int32_t FIELD_ID_SPVM__NDArray__Byte__base = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__Byte__base = -1;
static int32_t FIELD_ID_SPVM__NDArray__Byte__offset = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__Byte__offset = -1;
static int32_t FIELD_ID_SPVM__NDArray__Byte__length = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__Byte__length = -1;
static int32_t FIELD_ID_SPVM__NDArray__Byte__T = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__Byte__T = -1;
static int32_t FIELD_ID_SPVM__NDArray__Byte__shape = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__Byte__shape = -1;
static int32_t FIELD_ID_SPVM__NDArray__Byte__na_flags = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__Byte__na_flags = -1;
static int32_t FIELD_ID_SPVM__NDArray__ComplexByte__base = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexByte__base = -1;
static int32_t FIELD_ID_SPVM__NDArray__ComplexByte__offset = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexByte__offset = -1;
static int32_t FIELD_ID_SPVM__NDArray__ComplexByte__length = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexByte__length = -1;
static int32_t FIELD_ID_SPVM__NDArray__ComplexByte__T = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexByte__T = -1;
static int32_t FIELD_ID_SPVM__NDArray__ComplexByte__shape = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexByte__shape = -1;
static int32_t FIELD_ID_SPVM__NDArray__ComplexByte__na_flags = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexByte__na_flags = -1;
static int32_t FIELD_ID_SPVM__NDArray__QuatByte__base = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__QuatByte__base = -1;
static int32_t FIELD_ID_SPVM__NDArray__QuatByte__offset = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__QuatByte__offset = -1;
static int32_t FIELD_ID_SPVM__NDArray__QuatByte__length = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__QuatByte__length = -1;
static int32_t FIELD_ID_SPVM__NDArray__QuatByte__T = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__QuatByte__T = -1;
static int32_t FIELD_ID_SPVM__NDArray__QuatByte__shape = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__QuatByte__shape = -1;
static int32_t FIELD_ID_SPVM__NDArray__QuatByte__na_flags = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__QuatByte__na_flags = -1;
static int32_t FIELD_ID_SPVM__NDArray__Double__base = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__Double__base = -1;
static int32_t FIELD_ID_SPVM__NDArray__Double__offset = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__Double__offset = -1;
static int32_t FIELD_ID_SPVM__NDArray__Double__length = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__Double__length = -1;
static int32_t FIELD_ID_SPVM__NDArray__Double__T = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__Double__T = -1;
static int32_t FIELD_ID_SPVM__NDArray__Double__shape = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__Double__shape = -1;
static int32_t FIELD_ID_SPVM__NDArray__Double__na_flags = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__Double__na_flags = -1;
static int32_t FIELD_ID_SPVM__NDArray__ComplexDouble__base = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexDouble__base = -1;
static int32_t FIELD_ID_SPVM__NDArray__ComplexDouble__offset = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexDouble__offset = -1;
static int32_t FIELD_ID_SPVM__NDArray__ComplexDouble__length = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexDouble__length = -1;
static int32_t FIELD_ID_SPVM__NDArray__ComplexDouble__T = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexDouble__T = -1;
static int32_t FIELD_ID_SPVM__NDArray__ComplexDouble__shape = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexDouble__shape = -1;
static int32_t FIELD_ID_SPVM__NDArray__ComplexDouble__na_flags = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexDouble__na_flags = -1;
static int32_t FIELD_ID_SPVM__NDArray__QuatDouble__base = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__QuatDouble__base = -1;
static int32_t FIELD_ID_SPVM__NDArray__QuatDouble__offset = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__QuatDouble__offset = -1;
static int32_t FIELD_ID_SPVM__NDArray__QuatDouble__length = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__QuatDouble__length = -1;
static int32_t FIELD_ID_SPVM__NDArray__QuatDouble__T = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__QuatDouble__T = -1;
static int32_t FIELD_ID_SPVM__NDArray__QuatDouble__shape = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__QuatDouble__shape = -1;
static int32_t FIELD_ID_SPVM__NDArray__QuatDouble__na_flags = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__QuatDouble__na_flags = -1;
static int32_t FIELD_ID_SPVM__NDArray__Float__base = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__Float__base = -1;
static int32_t FIELD_ID_SPVM__NDArray__Float__offset = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__Float__offset = -1;
static int32_t FIELD_ID_SPVM__NDArray__Float__length = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__Float__length = -1;
static int32_t FIELD_ID_SPVM__NDArray__Float__T = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__Float__T = -1;
static int32_t FIELD_ID_SPVM__NDArray__Float__shape = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__Float__shape = -1;
static int32_t FIELD_ID_SPVM__NDArray__Float__na_flags = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__Float__na_flags = -1;
static int32_t FIELD_ID_SPVM__NDArray__ComplexFloat__base = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexFloat__base = -1;
static int32_t FIELD_ID_SPVM__NDArray__ComplexFloat__offset = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexFloat__offset = -1;
static int32_t FIELD_ID_SPVM__NDArray__ComplexFloat__length = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexFloat__length = -1;
static int32_t FIELD_ID_SPVM__NDArray__ComplexFloat__T = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexFloat__T = -1;
static int32_t FIELD_ID_SPVM__NDArray__ComplexFloat__shape = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexFloat__shape = -1;
static int32_t FIELD_ID_SPVM__NDArray__ComplexFloat__na_flags = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexFloat__na_flags = -1;
static int32_t FIELD_ID_SPVM__NDArray__QuatFloat__base = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__QuatFloat__base = -1;
static int32_t FIELD_ID_SPVM__NDArray__QuatFloat__offset = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__QuatFloat__offset = -1;
static int32_t FIELD_ID_SPVM__NDArray__QuatFloat__length = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__QuatFloat__length = -1;
static int32_t FIELD_ID_SPVM__NDArray__QuatFloat__T = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__QuatFloat__T = -1;
static int32_t FIELD_ID_SPVM__NDArray__QuatFloat__shape = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__QuatFloat__shape = -1;
static int32_t FIELD_ID_SPVM__NDArray__QuatFloat__na_flags = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__QuatFloat__na_flags = -1;
static int32_t FIELD_ID_SPVM__NDArray__Int__base = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__Int__base = -1;
static int32_t FIELD_ID_SPVM__NDArray__Int__offset = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__Int__offset = -1;
static int32_t FIELD_ID_SPVM__NDArray__Int__length = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__Int__length = -1;
static int32_t FIELD_ID_SPVM__NDArray__Int__T = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__Int__T = -1;
static int32_t FIELD_ID_SPVM__NDArray__Int__shape = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__Int__shape = -1;
static int32_t FIELD_ID_SPVM__NDArray__Int__na_flags = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__Int__na_flags = -1;
static int32_t FIELD_ID_SPVM__NDArray__ComplexInt__base = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexInt__base = -1;
static int32_t FIELD_ID_SPVM__NDArray__ComplexInt__offset = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexInt__offset = -1;
static int32_t FIELD_ID_SPVM__NDArray__ComplexInt__length = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexInt__length = -1;
static int32_t FIELD_ID_SPVM__NDArray__ComplexInt__T = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexInt__T = -1;
static int32_t FIELD_ID_SPVM__NDArray__ComplexInt__shape = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexInt__shape = -1;
static int32_t FIELD_ID_SPVM__NDArray__ComplexInt__na_flags = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexInt__na_flags = -1;
static int32_t FIELD_ID_SPVM__NDArray__QuatInt__base = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__QuatInt__base = -1;
static int32_t FIELD_ID_SPVM__NDArray__QuatInt__offset = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__QuatInt__offset = -1;
static int32_t FIELD_ID_SPVM__NDArray__QuatInt__length = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__QuatInt__length = -1;
static int32_t FIELD_ID_SPVM__NDArray__QuatInt__T = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__QuatInt__T = -1;
static int32_t FIELD_ID_SPVM__NDArray__QuatInt__shape = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__QuatInt__shape = -1;
static int32_t FIELD_ID_SPVM__NDArray__QuatInt__na_flags = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__QuatInt__na_flags = -1;
static int32_t FIELD_ID_SPVM__NDArray__Long__base = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__Long__base = -1;
static int32_t FIELD_ID_SPVM__NDArray__Long__offset = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__Long__offset = -1;
static int32_t FIELD_ID_SPVM__NDArray__Long__length = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__Long__length = -1;
static int32_t FIELD_ID_SPVM__NDArray__Long__T = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__Long__T = -1;
static int32_t FIELD_ID_SPVM__NDArray__Long__shape = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__Long__shape = -1;
static int32_t FIELD_ID_SPVM__NDArray__Long__na_flags = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__Long__na_flags = -1;
static int32_t FIELD_ID_SPVM__NDArray__ComplexLong__base = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexLong__base = -1;
static int32_t FIELD_ID_SPVM__NDArray__ComplexLong__offset = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexLong__offset = -1;
static int32_t FIELD_ID_SPVM__NDArray__ComplexLong__length = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexLong__length = -1;
static int32_t FIELD_ID_SPVM__NDArray__ComplexLong__T = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexLong__T = -1;
static int32_t FIELD_ID_SPVM__NDArray__ComplexLong__shape = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexLong__shape = -1;
static int32_t FIELD_ID_SPVM__NDArray__ComplexLong__na_flags = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexLong__na_flags = -1;
static int32_t FIELD_ID_SPVM__NDArray__QuatLong__base = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__QuatLong__base = -1;
static int32_t FIELD_ID_SPVM__NDArray__QuatLong__offset = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__QuatLong__offset = -1;
static int32_t FIELD_ID_SPVM__NDArray__QuatLong__length = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__QuatLong__length = -1;
static int32_t FIELD_ID_SPVM__NDArray__QuatLong__T = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__QuatLong__T = -1;
static int32_t FIELD_ID_SPVM__NDArray__QuatLong__shape = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__QuatLong__shape = -1;
static int32_t FIELD_ID_SPVM__NDArray__QuatLong__na_flags = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__QuatLong__na_flags = -1;
static int32_t FIELD_ID_SPVM__NDArray__Short__base = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__Short__base = -1;
static int32_t FIELD_ID_SPVM__NDArray__Short__offset = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__Short__offset = -1;
static int32_t FIELD_ID_SPVM__NDArray__Short__length = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__Short__length = -1;
static int32_t FIELD_ID_SPVM__NDArray__Short__T = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__Short__T = -1;
static int32_t FIELD_ID_SPVM__NDArray__Short__shape = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__Short__shape = -1;
static int32_t FIELD_ID_SPVM__NDArray__Short__na_flags = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__Short__na_flags = -1;
static int32_t FIELD_ID_SPVM__NDArray__ComplexShort__base = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexShort__base = -1;
static int32_t FIELD_ID_SPVM__NDArray__ComplexShort__offset = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexShort__offset = -1;
static int32_t FIELD_ID_SPVM__NDArray__ComplexShort__length = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexShort__length = -1;
static int32_t FIELD_ID_SPVM__NDArray__ComplexShort__T = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexShort__T = -1;
static int32_t FIELD_ID_SPVM__NDArray__ComplexShort__shape = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexShort__shape = -1;
static int32_t FIELD_ID_SPVM__NDArray__ComplexShort__na_flags = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexShort__na_flags = -1;
static int32_t FIELD_ID_SPVM__NDArray__QuatShort__base = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__QuatShort__base = -1;
static int32_t FIELD_ID_SPVM__NDArray__QuatShort__offset = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__QuatShort__offset = -1;
static int32_t FIELD_ID_SPVM__NDArray__QuatShort__length = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__QuatShort__length = -1;
static int32_t FIELD_ID_SPVM__NDArray__QuatShort__T = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__QuatShort__T = -1;
static int32_t FIELD_ID_SPVM__NDArray__QuatShort__shape = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__QuatShort__shape = -1;
static int32_t FIELD_ID_SPVM__NDArray__QuatShort__na_flags = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__QuatShort__na_flags = -1;
static int32_t FIELD_ID_SPVM__NDArray__String__base = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__String__base = -1;
static int32_t FIELD_ID_SPVM__NDArray__String__offset = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__String__offset = -1;
static int32_t FIELD_ID_SPVM__NDArray__String__length = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__String__length = -1;
static int32_t FIELD_ID_SPVM__NDArray__String__T = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__String__T = -1;
static int32_t FIELD_ID_SPVM__NDArray__String__shape = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__String__shape = -1;
static int32_t FIELD_ID_SPVM__NDArray__String__na_flags = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__NDArray__String__na_flags = -1;
// Sub id declarations
// Basic type id declarations
static int32_t BASIC_TYPE_ID_SPVM__NDArray__Byte = -1;
static int32_t BASIC_TYPE_ID_byte = -1;
static int32_t BASIC_TYPE_ID_int = -1;
static int32_t BASIC_TYPE_ID_SPVM__NDArray__ComplexByte = -1;
static int32_t BASIC_TYPE_ID_SPVM__Complex_2b = -1;
static int32_t BASIC_TYPE_ID_SPVM__NDArray__QuatByte = -1;
static int32_t BASIC_TYPE_ID_SPVM__Quat_4b = -1;
static int32_t BASIC_TYPE_ID_SPVM__NDArray__Double = -1;
static int32_t BASIC_TYPE_ID_double = -1;
static int32_t BASIC_TYPE_ID_SPVM__NDArray__ComplexDouble = -1;
static int32_t BASIC_TYPE_ID_SPVM__Complex_2d = -1;
static int32_t BASIC_TYPE_ID_SPVM__NDArray__QuatDouble = -1;
static int32_t BASIC_TYPE_ID_SPVM__Quat_4d = -1;
static int32_t BASIC_TYPE_ID_SPVM__NDArray__Float = -1;
static int32_t BASIC_TYPE_ID_float = -1;
static int32_t BASIC_TYPE_ID_SPVM__NDArray__ComplexFloat = -1;
static int32_t BASIC_TYPE_ID_SPVM__Complex_2f = -1;
static int32_t BASIC_TYPE_ID_SPVM__NDArray__QuatFloat = -1;
static int32_t BASIC_TYPE_ID_SPVM__Quat_4f = -1;
static int32_t BASIC_TYPE_ID_SPVM__NDArray__Int = -1;
static int32_t BASIC_TYPE_ID_SPVM__NDArray__ComplexInt = -1;
static int32_t BASIC_TYPE_ID_SPVM__Complex_2i = -1;
static int32_t BASIC_TYPE_ID_SPVM__NDArray__QuatInt = -1;
static int32_t BASIC_TYPE_ID_SPVM__Quat_4i = -1;
static int32_t BASIC_TYPE_ID_SPVM__NDArray__Long = -1;
static int32_t BASIC_TYPE_ID_long = -1;
static int32_t BASIC_TYPE_ID_SPVM__NDArray__ComplexLong = -1;
static int32_t BASIC_TYPE_ID_SPVM__Complex_2l = -1;
static int32_t BASIC_TYPE_ID_SPVM__NDArray__QuatLong = -1;
static int32_t BASIC_TYPE_ID_SPVM__Quat_4l = -1;
static int32_t BASIC_TYPE_ID_SPVM__NDArray__Short = -1;
static int32_t BASIC_TYPE_ID_short = -1;
static int32_t BASIC_TYPE_ID_SPVM__NDArray__ComplexShort = -1;
static int32_t BASIC_TYPE_ID_SPVM__Complex_2s = -1;
static int32_t BASIC_TYPE_ID_SPVM__NDArray__QuatShort = -1;
static int32_t BASIC_TYPE_ID_SPVM__Quat_4s = -1;
static int32_t BASIC_TYPE_ID_SPVM__NDArray__String = -1;
// Function Declarations
// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__NDArray__ndarray_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__NDArray__ndarray_byte_complex(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__NDArray__ndarray_byte_quat(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__NDArray__ndarray_double(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__NDArray__ndarray_double_complex(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__NDArray__ndarray_double_quat(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__NDArray__ndarray_float(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__NDArray__ndarray_float_complex(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__NDArray__ndarray_float_quat(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__NDArray__ndarray_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__NDArray__ndarray_int_complex(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__NDArray__ndarray_int_quat(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__NDArray__ndarray_long(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__NDArray__ndarray_long_complex(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__NDArray__ndarray_long_quat(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__NDArray__ndarray_short(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__NDArray__ndarray_short_complex(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__NDArray__ndarray_short_quat(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__NDArray__ndarray_string(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__NDArray__ndarray_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[7];
  int32_t exception_flag = 0;
  int32_t mortal_stack[5];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_SPVM__NDArray__Byte < 0) {
      BASIC_TYPE_ID_SPVM__NDArray__Byte = env->get_basic_type_id(env, "SPVM::NDArray::Byte");
      if (BASIC_TYPE_ID_SPVM__NDArray__Byte < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::NDArray::Byte");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_SPVM__NDArray__Byte;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 6;
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L5: // NEW_BYTE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_byte_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_byte";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 26;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L7: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__Byte__base < 0, 0)) {
      FIELD_ID_SPVM__NDArray__Byte__base = env->get_field_id(env, "SPVM::NDArray::Byte", "base", "byte[]");
      if (FIELD_ID_SPVM__NDArray__Byte__base < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::Byte base");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__Byte__base = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__Byte__base);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__Byte__base);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_byte";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 26;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L9: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__Byte__offset < 0, 0)) {
      FIELD_ID_SPVM__NDArray__Byte__offset = env->get_field_id(env, "SPVM::NDArray::Byte", "offset", "int");
      if (FIELD_ID_SPVM__NDArray__Byte__offset < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::Byte offset");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__Byte__offset = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__Byte__offset);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__Byte__offset) = int_vars[2];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_byte";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 27;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L14: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__Byte__length < 0, 0)) {
      FIELD_ID_SPVM__NDArray__Byte__length = env->get_field_id(env, "SPVM::NDArray::Byte", "length", "int");
      if (FIELD_ID_SPVM__NDArray__Byte__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::Byte length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__Byte__length = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__Byte__length);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__Byte__length) = int_vars[2];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_byte";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 28;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L17: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L18: // SET_FIELD_BYTE
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__Byte__T < 0, 0)) {
      FIELD_ID_SPVM__NDArray__Byte__T = env->get_field_id(env, "SPVM::NDArray::Byte", "T", "byte");
      if (FIELD_ID_SPVM__NDArray__Byte__T < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::Byte T");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__Byte__T = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__Byte__T);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int8_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__Byte__T) = byte_vars[0];
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_byte";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 29;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L21: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L22: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_byte";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 30;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L24: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L25: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L26: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[3];
      } 
    } 
  } 
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_byte";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 30;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L28: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L29: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L30: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[5];
      } 
    } 
  } 
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_byte";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 30;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L32: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__Byte__shape < 0, 0)) {
      FIELD_ID_SPVM__NDArray__Byte__shape = env->get_field_id(env, "SPVM::NDArray::Byte", "shape", "int[]");
      if (FIELD_ID_SPVM__NDArray__Byte__shape < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::Byte shape");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__Byte__shape = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__Byte__shape);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__Byte__shape);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_byte";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 30;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L34: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L36: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L37: // NEW_BYTE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_byte_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_byte";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 31;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L39: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L40: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[3];
L41: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L42: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[0];
      } 
    } 
  } 
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_byte";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 31;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L44: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L45: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[5];
L46: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L47: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_byte";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 31;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L49: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__Byte__na_flags < 0, 0)) {
      FIELD_ID_SPVM__NDArray__Byte__na_flags = env->get_field_id(env, "SPVM::NDArray::Byte", "na_flags", "byte[]");
      if (FIELD_ID_SPVM__NDArray__Byte__na_flags < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::Byte na_flags");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__Byte__na_flags = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__Byte__na_flags);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__Byte__na_flags);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_byte";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 31;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L51: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L52: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L53: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L56;
L54: // INIT_INT
  int_vars[4] = 0;
L55: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L56;
L56: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L57: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__NDArray__ndarray_byte_complex(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[7];
  int32_t exception_flag = 0;
  int32_t mortal_stack[5];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_SPVM__NDArray__ComplexByte < 0) {
      BASIC_TYPE_ID_SPVM__NDArray__ComplexByte = env->get_basic_type_id(env, "SPVM::NDArray::ComplexByte");
      if (BASIC_TYPE_ID_SPVM__NDArray__ComplexByte < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::NDArray::ComplexByte");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_SPVM__NDArray__ComplexByte;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 6;
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L5: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_SPVM__Complex_2b < 0) {
      BASIC_TYPE_ID_SPVM__Complex_2b = env->get_basic_type_id(env, "SPVM::Complex_2b");
      if (BASIC_TYPE_ID_SPVM__Complex_2b < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Complex_2b");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_SPVM__Complex_2b;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_byte_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 109;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L7: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__ComplexByte__base < 0, 0)) {
      FIELD_ID_SPVM__NDArray__ComplexByte__base = env->get_field_id(env, "SPVM::NDArray::ComplexByte", "base", "SPVM::Complex_2b[]");
      if (FIELD_ID_SPVM__NDArray__ComplexByte__base < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::ComplexByte base");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexByte__base = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__ComplexByte__base);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexByte__base);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_byte_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 109;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L9: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__ComplexByte__offset < 0, 0)) {
      FIELD_ID_SPVM__NDArray__ComplexByte__offset = env->get_field_id(env, "SPVM::NDArray::ComplexByte", "offset", "int");
      if (FIELD_ID_SPVM__NDArray__ComplexByte__offset < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::ComplexByte offset");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexByte__offset = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__ComplexByte__offset);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexByte__offset) = int_vars[2];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_byte_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 110;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L14: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__ComplexByte__length < 0, 0)) {
      FIELD_ID_SPVM__NDArray__ComplexByte__length = env->get_field_id(env, "SPVM::NDArray::ComplexByte", "length", "int");
      if (FIELD_ID_SPVM__NDArray__ComplexByte__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::ComplexByte length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexByte__length = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__ComplexByte__length);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexByte__length) = int_vars[2];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_byte_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 111;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L17: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L18: // SET_FIELD_BYTE
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__ComplexByte__T < 0, 0)) {
      FIELD_ID_SPVM__NDArray__ComplexByte__T = env->get_field_id(env, "SPVM::NDArray::ComplexByte", "T", "byte");
      if (FIELD_ID_SPVM__NDArray__ComplexByte__T < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::ComplexByte T");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexByte__T = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__ComplexByte__T);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int8_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexByte__T) = byte_vars[0];
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_byte_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 112;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L21: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L22: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_byte_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 113;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L24: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L25: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L26: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[3];
      } 
    } 
  } 
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_byte_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 113;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L28: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L29: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L30: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[5];
      } 
    } 
  } 
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_byte_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 113;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L32: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__ComplexByte__shape < 0, 0)) {
      FIELD_ID_SPVM__NDArray__ComplexByte__shape = env->get_field_id(env, "SPVM::NDArray::ComplexByte", "shape", "int[]");
      if (FIELD_ID_SPVM__NDArray__ComplexByte__shape < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::ComplexByte shape");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexByte__shape = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__ComplexByte__shape);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexByte__shape);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_byte_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 113;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L34: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L36: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L37: // NEW_BYTE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_byte_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_byte_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 114;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L39: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L40: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[3];
L41: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L42: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[0];
      } 
    } 
  } 
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_byte_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 114;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L44: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L45: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[5];
L46: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L47: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_byte_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 114;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L49: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__ComplexByte__na_flags < 0, 0)) {
      FIELD_ID_SPVM__NDArray__ComplexByte__na_flags = env->get_field_id(env, "SPVM::NDArray::ComplexByte", "na_flags", "byte[]");
      if (FIELD_ID_SPVM__NDArray__ComplexByte__na_flags < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::ComplexByte na_flags");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexByte__na_flags = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__ComplexByte__na_flags);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexByte__na_flags);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_byte_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 114;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L51: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L52: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L53: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L56;
L54: // INIT_INT
  int_vars[4] = 0;
L55: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L56;
L56: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L57: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__NDArray__ndarray_byte_quat(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[7];
  int32_t exception_flag = 0;
  int32_t mortal_stack[5];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_SPVM__NDArray__QuatByte < 0) {
      BASIC_TYPE_ID_SPVM__NDArray__QuatByte = env->get_basic_type_id(env, "SPVM::NDArray::QuatByte");
      if (BASIC_TYPE_ID_SPVM__NDArray__QuatByte < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::NDArray::QuatByte");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_SPVM__NDArray__QuatByte;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 6;
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L5: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_SPVM__Quat_4b < 0) {
      BASIC_TYPE_ID_SPVM__Quat_4b = env->get_basic_type_id(env, "SPVM::Quat_4b");
      if (BASIC_TYPE_ID_SPVM__Quat_4b < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Quat_4b");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_SPVM__Quat_4b;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_byte_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 181;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L7: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__QuatByte__base < 0, 0)) {
      FIELD_ID_SPVM__NDArray__QuatByte__base = env->get_field_id(env, "SPVM::NDArray::QuatByte", "base", "SPVM::Quat_4b[]");
      if (FIELD_ID_SPVM__NDArray__QuatByte__base < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::QuatByte base");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__QuatByte__base = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__QuatByte__base);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__QuatByte__base);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_byte_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 181;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L9: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__QuatByte__offset < 0, 0)) {
      FIELD_ID_SPVM__NDArray__QuatByte__offset = env->get_field_id(env, "SPVM::NDArray::QuatByte", "offset", "int");
      if (FIELD_ID_SPVM__NDArray__QuatByte__offset < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::QuatByte offset");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__QuatByte__offset = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__QuatByte__offset);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__QuatByte__offset) = int_vars[2];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_byte_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 182;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L14: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__QuatByte__length < 0, 0)) {
      FIELD_ID_SPVM__NDArray__QuatByte__length = env->get_field_id(env, "SPVM::NDArray::QuatByte", "length", "int");
      if (FIELD_ID_SPVM__NDArray__QuatByte__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::QuatByte length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__QuatByte__length = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__QuatByte__length);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__QuatByte__length) = int_vars[2];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_byte_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 183;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L17: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L18: // SET_FIELD_BYTE
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__QuatByte__T < 0, 0)) {
      FIELD_ID_SPVM__NDArray__QuatByte__T = env->get_field_id(env, "SPVM::NDArray::QuatByte", "T", "byte");
      if (FIELD_ID_SPVM__NDArray__QuatByte__T < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::QuatByte T");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__QuatByte__T = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__QuatByte__T);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int8_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__QuatByte__T) = byte_vars[0];
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_byte_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 184;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L21: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L22: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_byte_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 185;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L24: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L25: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L26: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[3];
      } 
    } 
  } 
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_byte_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 185;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L28: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L29: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L30: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[5];
      } 
    } 
  } 
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_byte_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 185;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L32: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__QuatByte__shape < 0, 0)) {
      FIELD_ID_SPVM__NDArray__QuatByte__shape = env->get_field_id(env, "SPVM::NDArray::QuatByte", "shape", "int[]");
      if (FIELD_ID_SPVM__NDArray__QuatByte__shape < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::QuatByte shape");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__QuatByte__shape = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__QuatByte__shape);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__QuatByte__shape);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_byte_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 185;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L34: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L36: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L37: // NEW_BYTE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_byte_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_byte_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 186;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L39: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L40: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[3];
L41: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L42: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[0];
      } 
    } 
  } 
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_byte_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 186;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L44: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L45: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[5];
L46: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L47: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_byte_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 186;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L49: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__QuatByte__na_flags < 0, 0)) {
      FIELD_ID_SPVM__NDArray__QuatByte__na_flags = env->get_field_id(env, "SPVM::NDArray::QuatByte", "na_flags", "byte[]");
      if (FIELD_ID_SPVM__NDArray__QuatByte__na_flags < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::QuatByte na_flags");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__QuatByte__na_flags = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__QuatByte__na_flags);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__QuatByte__na_flags);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_byte_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 186;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L51: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L52: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L53: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L56;
L54: // INIT_INT
  int_vars[4] = 0;
L55: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L56;
L56: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L57: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__NDArray__ndarray_double(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[7];
  int32_t exception_flag = 0;
  int32_t mortal_stack[5];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_SPVM__NDArray__Double < 0) {
      BASIC_TYPE_ID_SPVM__NDArray__Double = env->get_basic_type_id(env, "SPVM::NDArray::Double");
      if (BASIC_TYPE_ID_SPVM__NDArray__Double < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::NDArray::Double");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_SPVM__NDArray__Double;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 6;
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L5: // NEW_DOUBLE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_double_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_double";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 85;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L7: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__Double__base < 0, 0)) {
      FIELD_ID_SPVM__NDArray__Double__base = env->get_field_id(env, "SPVM::NDArray::Double", "base", "double[]");
      if (FIELD_ID_SPVM__NDArray__Double__base < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::Double base");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__Double__base = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__Double__base);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__Double__base);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_double";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 85;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L9: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__Double__offset < 0, 0)) {
      FIELD_ID_SPVM__NDArray__Double__offset = env->get_field_id(env, "SPVM::NDArray::Double", "offset", "int");
      if (FIELD_ID_SPVM__NDArray__Double__offset < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::Double offset");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__Double__offset = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__Double__offset);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__Double__offset) = int_vars[2];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_double";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 86;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L14: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__Double__length < 0, 0)) {
      FIELD_ID_SPVM__NDArray__Double__length = env->get_field_id(env, "SPVM::NDArray::Double", "length", "int");
      if (FIELD_ID_SPVM__NDArray__Double__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::Double length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__Double__length = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__Double__length);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__Double__length) = int_vars[2];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_double";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 87;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L17: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L18: // SET_FIELD_BYTE
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__Double__T < 0, 0)) {
      FIELD_ID_SPVM__NDArray__Double__T = env->get_field_id(env, "SPVM::NDArray::Double", "T", "byte");
      if (FIELD_ID_SPVM__NDArray__Double__T < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::Double T");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__Double__T = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__Double__T);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int8_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__Double__T) = byte_vars[0];
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_double";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 88;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L21: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L22: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_double";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 89;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L24: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L25: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L26: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[3];
      } 
    } 
  } 
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_double";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 89;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L28: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L29: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L30: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[5];
      } 
    } 
  } 
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_double";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 89;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L32: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__Double__shape < 0, 0)) {
      FIELD_ID_SPVM__NDArray__Double__shape = env->get_field_id(env, "SPVM::NDArray::Double", "shape", "int[]");
      if (FIELD_ID_SPVM__NDArray__Double__shape < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::Double shape");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__Double__shape = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__Double__shape);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__Double__shape);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_double";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 89;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L34: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L36: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L37: // NEW_BYTE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_byte_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_double";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 90;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L39: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L40: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[3];
L41: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L42: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[0];
      } 
    } 
  } 
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_double";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 90;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L44: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L45: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[5];
L46: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L47: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_double";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 90;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L49: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__Double__na_flags < 0, 0)) {
      FIELD_ID_SPVM__NDArray__Double__na_flags = env->get_field_id(env, "SPVM::NDArray::Double", "na_flags", "byte[]");
      if (FIELD_ID_SPVM__NDArray__Double__na_flags < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::Double na_flags");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__Double__na_flags = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__Double__na_flags);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__Double__na_flags);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_double";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 90;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L51: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L52: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L53: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L56;
L54: // INIT_INT
  int_vars[4] = 0;
L55: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L56;
L56: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L57: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__NDArray__ndarray_double_complex(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[7];
  int32_t exception_flag = 0;
  int32_t mortal_stack[5];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_SPVM__NDArray__ComplexDouble < 0) {
      BASIC_TYPE_ID_SPVM__NDArray__ComplexDouble = env->get_basic_type_id(env, "SPVM::NDArray::ComplexDouble");
      if (BASIC_TYPE_ID_SPVM__NDArray__ComplexDouble < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::NDArray::ComplexDouble");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_SPVM__NDArray__ComplexDouble;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 6;
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L5: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_SPVM__Complex_2d < 0) {
      BASIC_TYPE_ID_SPVM__Complex_2d = env->get_basic_type_id(env, "SPVM::Complex_2d");
      if (BASIC_TYPE_ID_SPVM__Complex_2d < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Complex_2d");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_SPVM__Complex_2d;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_double_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 169;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L7: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__ComplexDouble__base < 0, 0)) {
      FIELD_ID_SPVM__NDArray__ComplexDouble__base = env->get_field_id(env, "SPVM::NDArray::ComplexDouble", "base", "SPVM::Complex_2d[]");
      if (FIELD_ID_SPVM__NDArray__ComplexDouble__base < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::ComplexDouble base");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexDouble__base = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__ComplexDouble__base);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexDouble__base);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_double_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 169;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L9: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__ComplexDouble__offset < 0, 0)) {
      FIELD_ID_SPVM__NDArray__ComplexDouble__offset = env->get_field_id(env, "SPVM::NDArray::ComplexDouble", "offset", "int");
      if (FIELD_ID_SPVM__NDArray__ComplexDouble__offset < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::ComplexDouble offset");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexDouble__offset = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__ComplexDouble__offset);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexDouble__offset) = int_vars[2];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_double_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 170;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L14: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__ComplexDouble__length < 0, 0)) {
      FIELD_ID_SPVM__NDArray__ComplexDouble__length = env->get_field_id(env, "SPVM::NDArray::ComplexDouble", "length", "int");
      if (FIELD_ID_SPVM__NDArray__ComplexDouble__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::ComplexDouble length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexDouble__length = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__ComplexDouble__length);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexDouble__length) = int_vars[2];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_double_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 171;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L17: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L18: // SET_FIELD_BYTE
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__ComplexDouble__T < 0, 0)) {
      FIELD_ID_SPVM__NDArray__ComplexDouble__T = env->get_field_id(env, "SPVM::NDArray::ComplexDouble", "T", "byte");
      if (FIELD_ID_SPVM__NDArray__ComplexDouble__T < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::ComplexDouble T");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexDouble__T = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__ComplexDouble__T);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int8_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexDouble__T) = byte_vars[0];
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_double_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 172;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L21: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L22: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_double_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 173;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L24: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L25: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L26: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[3];
      } 
    } 
  } 
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_double_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 173;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L28: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L29: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L30: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[5];
      } 
    } 
  } 
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_double_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 173;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L32: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__ComplexDouble__shape < 0, 0)) {
      FIELD_ID_SPVM__NDArray__ComplexDouble__shape = env->get_field_id(env, "SPVM::NDArray::ComplexDouble", "shape", "int[]");
      if (FIELD_ID_SPVM__NDArray__ComplexDouble__shape < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::ComplexDouble shape");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexDouble__shape = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__ComplexDouble__shape);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexDouble__shape);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_double_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 173;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L34: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L36: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L37: // NEW_BYTE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_byte_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_double_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 174;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L39: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L40: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[3];
L41: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L42: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[0];
      } 
    } 
  } 
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_double_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 174;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L44: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L45: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[5];
L46: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L47: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_double_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 174;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L49: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__ComplexDouble__na_flags < 0, 0)) {
      FIELD_ID_SPVM__NDArray__ComplexDouble__na_flags = env->get_field_id(env, "SPVM::NDArray::ComplexDouble", "na_flags", "byte[]");
      if (FIELD_ID_SPVM__NDArray__ComplexDouble__na_flags < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::ComplexDouble na_flags");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexDouble__na_flags = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__ComplexDouble__na_flags);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexDouble__na_flags);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_double_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 174;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L51: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L52: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L53: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L56;
L54: // INIT_INT
  int_vars[4] = 0;
L55: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L56;
L56: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L57: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__NDArray__ndarray_double_quat(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[7];
  int32_t exception_flag = 0;
  int32_t mortal_stack[5];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_SPVM__NDArray__QuatDouble < 0) {
      BASIC_TYPE_ID_SPVM__NDArray__QuatDouble = env->get_basic_type_id(env, "SPVM::NDArray::QuatDouble");
      if (BASIC_TYPE_ID_SPVM__NDArray__QuatDouble < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::NDArray::QuatDouble");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_SPVM__NDArray__QuatDouble;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 6;
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L5: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_SPVM__Quat_4d < 0) {
      BASIC_TYPE_ID_SPVM__Quat_4d = env->get_basic_type_id(env, "SPVM::Quat_4d");
      if (BASIC_TYPE_ID_SPVM__Quat_4d < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Quat_4d");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_SPVM__Quat_4d;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_double_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 241;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L7: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__QuatDouble__base < 0, 0)) {
      FIELD_ID_SPVM__NDArray__QuatDouble__base = env->get_field_id(env, "SPVM::NDArray::QuatDouble", "base", "SPVM::Quat_4d[]");
      if (FIELD_ID_SPVM__NDArray__QuatDouble__base < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::QuatDouble base");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__QuatDouble__base = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__QuatDouble__base);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__QuatDouble__base);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_double_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 241;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L9: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__QuatDouble__offset < 0, 0)) {
      FIELD_ID_SPVM__NDArray__QuatDouble__offset = env->get_field_id(env, "SPVM::NDArray::QuatDouble", "offset", "int");
      if (FIELD_ID_SPVM__NDArray__QuatDouble__offset < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::QuatDouble offset");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__QuatDouble__offset = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__QuatDouble__offset);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__QuatDouble__offset) = int_vars[2];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_double_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 242;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L14: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__QuatDouble__length < 0, 0)) {
      FIELD_ID_SPVM__NDArray__QuatDouble__length = env->get_field_id(env, "SPVM::NDArray::QuatDouble", "length", "int");
      if (FIELD_ID_SPVM__NDArray__QuatDouble__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::QuatDouble length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__QuatDouble__length = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__QuatDouble__length);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__QuatDouble__length) = int_vars[2];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_double_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 243;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L17: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L18: // SET_FIELD_BYTE
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__QuatDouble__T < 0, 0)) {
      FIELD_ID_SPVM__NDArray__QuatDouble__T = env->get_field_id(env, "SPVM::NDArray::QuatDouble", "T", "byte");
      if (FIELD_ID_SPVM__NDArray__QuatDouble__T < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::QuatDouble T");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__QuatDouble__T = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__QuatDouble__T);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int8_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__QuatDouble__T) = byte_vars[0];
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_double_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 244;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L21: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L22: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_double_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 245;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L24: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L25: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L26: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[3];
      } 
    } 
  } 
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_double_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 245;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L28: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L29: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L30: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[5];
      } 
    } 
  } 
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_double_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 245;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L32: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__QuatDouble__shape < 0, 0)) {
      FIELD_ID_SPVM__NDArray__QuatDouble__shape = env->get_field_id(env, "SPVM::NDArray::QuatDouble", "shape", "int[]");
      if (FIELD_ID_SPVM__NDArray__QuatDouble__shape < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::QuatDouble shape");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__QuatDouble__shape = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__QuatDouble__shape);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__QuatDouble__shape);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_double_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 245;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L34: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L36: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L37: // NEW_BYTE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_byte_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_double_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 246;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L39: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L40: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[3];
L41: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L42: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[0];
      } 
    } 
  } 
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_double_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 246;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L44: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L45: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[5];
L46: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L47: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_double_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 246;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L49: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__QuatDouble__na_flags < 0, 0)) {
      FIELD_ID_SPVM__NDArray__QuatDouble__na_flags = env->get_field_id(env, "SPVM::NDArray::QuatDouble", "na_flags", "byte[]");
      if (FIELD_ID_SPVM__NDArray__QuatDouble__na_flags < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::QuatDouble na_flags");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__QuatDouble__na_flags = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__QuatDouble__na_flags);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__QuatDouble__na_flags);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_double_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 246;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L51: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L52: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L53: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L56;
L54: // INIT_INT
  int_vars[4] = 0;
L55: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L56;
L56: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L57: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__NDArray__ndarray_float(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[7];
  int32_t exception_flag = 0;
  int32_t mortal_stack[5];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_SPVM__NDArray__Float < 0) {
      BASIC_TYPE_ID_SPVM__NDArray__Float = env->get_basic_type_id(env, "SPVM::NDArray::Float");
      if (BASIC_TYPE_ID_SPVM__NDArray__Float < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::NDArray::Float");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_SPVM__NDArray__Float;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 6;
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L5: // NEW_FLOAT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_float_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_float";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 73;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L7: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__Float__base < 0, 0)) {
      FIELD_ID_SPVM__NDArray__Float__base = env->get_field_id(env, "SPVM::NDArray::Float", "base", "float[]");
      if (FIELD_ID_SPVM__NDArray__Float__base < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::Float base");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__Float__base = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__Float__base);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__Float__base);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_float";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 73;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L9: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__Float__offset < 0, 0)) {
      FIELD_ID_SPVM__NDArray__Float__offset = env->get_field_id(env, "SPVM::NDArray::Float", "offset", "int");
      if (FIELD_ID_SPVM__NDArray__Float__offset < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::Float offset");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__Float__offset = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__Float__offset);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__Float__offset) = int_vars[2];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_float";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 74;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L14: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__Float__length < 0, 0)) {
      FIELD_ID_SPVM__NDArray__Float__length = env->get_field_id(env, "SPVM::NDArray::Float", "length", "int");
      if (FIELD_ID_SPVM__NDArray__Float__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::Float length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__Float__length = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__Float__length);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__Float__length) = int_vars[2];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_float";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 75;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L17: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L18: // SET_FIELD_BYTE
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__Float__T < 0, 0)) {
      FIELD_ID_SPVM__NDArray__Float__T = env->get_field_id(env, "SPVM::NDArray::Float", "T", "byte");
      if (FIELD_ID_SPVM__NDArray__Float__T < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::Float T");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__Float__T = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__Float__T);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int8_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__Float__T) = byte_vars[0];
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_float";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 76;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L21: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L22: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_float";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 77;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L24: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L25: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L26: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[3];
      } 
    } 
  } 
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_float";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 77;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L28: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L29: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L30: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[5];
      } 
    } 
  } 
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_float";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 77;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L32: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__Float__shape < 0, 0)) {
      FIELD_ID_SPVM__NDArray__Float__shape = env->get_field_id(env, "SPVM::NDArray::Float", "shape", "int[]");
      if (FIELD_ID_SPVM__NDArray__Float__shape < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::Float shape");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__Float__shape = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__Float__shape);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__Float__shape);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_float";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 77;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L34: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L36: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L37: // NEW_BYTE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_byte_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_float";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 78;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L39: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L40: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[3];
L41: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L42: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[0];
      } 
    } 
  } 
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_float";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 78;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L44: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L45: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[5];
L46: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L47: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_float";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 78;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L49: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__Float__na_flags < 0, 0)) {
      FIELD_ID_SPVM__NDArray__Float__na_flags = env->get_field_id(env, "SPVM::NDArray::Float", "na_flags", "byte[]");
      if (FIELD_ID_SPVM__NDArray__Float__na_flags < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::Float na_flags");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__Float__na_flags = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__Float__na_flags);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__Float__na_flags);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_float";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 78;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L51: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L52: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L53: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L56;
L54: // INIT_INT
  int_vars[4] = 0;
L55: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L56;
L56: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L57: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__NDArray__ndarray_float_complex(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[7];
  int32_t exception_flag = 0;
  int32_t mortal_stack[5];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_SPVM__NDArray__ComplexFloat < 0) {
      BASIC_TYPE_ID_SPVM__NDArray__ComplexFloat = env->get_basic_type_id(env, "SPVM::NDArray::ComplexFloat");
      if (BASIC_TYPE_ID_SPVM__NDArray__ComplexFloat < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::NDArray::ComplexFloat");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_SPVM__NDArray__ComplexFloat;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 6;
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L5: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_SPVM__Complex_2f < 0) {
      BASIC_TYPE_ID_SPVM__Complex_2f = env->get_basic_type_id(env, "SPVM::Complex_2f");
      if (BASIC_TYPE_ID_SPVM__Complex_2f < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Complex_2f");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_SPVM__Complex_2f;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_float_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 157;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L7: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__ComplexFloat__base < 0, 0)) {
      FIELD_ID_SPVM__NDArray__ComplexFloat__base = env->get_field_id(env, "SPVM::NDArray::ComplexFloat", "base", "SPVM::Complex_2f[]");
      if (FIELD_ID_SPVM__NDArray__ComplexFloat__base < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::ComplexFloat base");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexFloat__base = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__ComplexFloat__base);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexFloat__base);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_float_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 157;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L9: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__ComplexFloat__offset < 0, 0)) {
      FIELD_ID_SPVM__NDArray__ComplexFloat__offset = env->get_field_id(env, "SPVM::NDArray::ComplexFloat", "offset", "int");
      if (FIELD_ID_SPVM__NDArray__ComplexFloat__offset < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::ComplexFloat offset");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexFloat__offset = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__ComplexFloat__offset);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexFloat__offset) = int_vars[2];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_float_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 158;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L14: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__ComplexFloat__length < 0, 0)) {
      FIELD_ID_SPVM__NDArray__ComplexFloat__length = env->get_field_id(env, "SPVM::NDArray::ComplexFloat", "length", "int");
      if (FIELD_ID_SPVM__NDArray__ComplexFloat__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::ComplexFloat length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexFloat__length = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__ComplexFloat__length);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexFloat__length) = int_vars[2];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_float_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 159;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L17: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L18: // SET_FIELD_BYTE
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__ComplexFloat__T < 0, 0)) {
      FIELD_ID_SPVM__NDArray__ComplexFloat__T = env->get_field_id(env, "SPVM::NDArray::ComplexFloat", "T", "byte");
      if (FIELD_ID_SPVM__NDArray__ComplexFloat__T < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::ComplexFloat T");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexFloat__T = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__ComplexFloat__T);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int8_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexFloat__T) = byte_vars[0];
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_float_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 160;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L21: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L22: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_float_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 161;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L24: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L25: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L26: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[3];
      } 
    } 
  } 
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_float_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 161;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L28: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L29: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L30: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[5];
      } 
    } 
  } 
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_float_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 161;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L32: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__ComplexFloat__shape < 0, 0)) {
      FIELD_ID_SPVM__NDArray__ComplexFloat__shape = env->get_field_id(env, "SPVM::NDArray::ComplexFloat", "shape", "int[]");
      if (FIELD_ID_SPVM__NDArray__ComplexFloat__shape < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::ComplexFloat shape");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexFloat__shape = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__ComplexFloat__shape);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexFloat__shape);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_float_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 161;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L34: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L36: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L37: // NEW_BYTE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_byte_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_float_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 162;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L39: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L40: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[3];
L41: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L42: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[0];
      } 
    } 
  } 
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_float_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 162;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L44: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L45: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[5];
L46: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L47: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_float_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 162;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L49: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__ComplexFloat__na_flags < 0, 0)) {
      FIELD_ID_SPVM__NDArray__ComplexFloat__na_flags = env->get_field_id(env, "SPVM::NDArray::ComplexFloat", "na_flags", "byte[]");
      if (FIELD_ID_SPVM__NDArray__ComplexFloat__na_flags < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::ComplexFloat na_flags");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexFloat__na_flags = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__ComplexFloat__na_flags);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexFloat__na_flags);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_float_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 162;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L51: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L52: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L53: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L56;
L54: // INIT_INT
  int_vars[4] = 0;
L55: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L56;
L56: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L57: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__NDArray__ndarray_float_quat(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[7];
  int32_t exception_flag = 0;
  int32_t mortal_stack[5];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_SPVM__NDArray__QuatFloat < 0) {
      BASIC_TYPE_ID_SPVM__NDArray__QuatFloat = env->get_basic_type_id(env, "SPVM::NDArray::QuatFloat");
      if (BASIC_TYPE_ID_SPVM__NDArray__QuatFloat < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::NDArray::QuatFloat");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_SPVM__NDArray__QuatFloat;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 6;
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L5: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_SPVM__Quat_4f < 0) {
      BASIC_TYPE_ID_SPVM__Quat_4f = env->get_basic_type_id(env, "SPVM::Quat_4f");
      if (BASIC_TYPE_ID_SPVM__Quat_4f < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Quat_4f");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_SPVM__Quat_4f;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_float_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 229;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L7: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__QuatFloat__base < 0, 0)) {
      FIELD_ID_SPVM__NDArray__QuatFloat__base = env->get_field_id(env, "SPVM::NDArray::QuatFloat", "base", "SPVM::Quat_4f[]");
      if (FIELD_ID_SPVM__NDArray__QuatFloat__base < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::QuatFloat base");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__QuatFloat__base = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__QuatFloat__base);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__QuatFloat__base);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_float_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 229;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L9: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__QuatFloat__offset < 0, 0)) {
      FIELD_ID_SPVM__NDArray__QuatFloat__offset = env->get_field_id(env, "SPVM::NDArray::QuatFloat", "offset", "int");
      if (FIELD_ID_SPVM__NDArray__QuatFloat__offset < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::QuatFloat offset");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__QuatFloat__offset = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__QuatFloat__offset);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__QuatFloat__offset) = int_vars[2];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_float_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 230;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L14: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__QuatFloat__length < 0, 0)) {
      FIELD_ID_SPVM__NDArray__QuatFloat__length = env->get_field_id(env, "SPVM::NDArray::QuatFloat", "length", "int");
      if (FIELD_ID_SPVM__NDArray__QuatFloat__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::QuatFloat length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__QuatFloat__length = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__QuatFloat__length);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__QuatFloat__length) = int_vars[2];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_float_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 231;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L17: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L18: // SET_FIELD_BYTE
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__QuatFloat__T < 0, 0)) {
      FIELD_ID_SPVM__NDArray__QuatFloat__T = env->get_field_id(env, "SPVM::NDArray::QuatFloat", "T", "byte");
      if (FIELD_ID_SPVM__NDArray__QuatFloat__T < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::QuatFloat T");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__QuatFloat__T = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__QuatFloat__T);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int8_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__QuatFloat__T) = byte_vars[0];
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_float_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 232;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L21: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L22: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_float_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 233;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L24: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L25: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L26: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[3];
      } 
    } 
  } 
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_float_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 233;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L28: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L29: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L30: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[5];
      } 
    } 
  } 
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_float_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 233;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L32: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__QuatFloat__shape < 0, 0)) {
      FIELD_ID_SPVM__NDArray__QuatFloat__shape = env->get_field_id(env, "SPVM::NDArray::QuatFloat", "shape", "int[]");
      if (FIELD_ID_SPVM__NDArray__QuatFloat__shape < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::QuatFloat shape");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__QuatFloat__shape = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__QuatFloat__shape);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__QuatFloat__shape);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_float_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 233;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L34: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L36: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L37: // NEW_BYTE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_byte_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_float_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 234;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L39: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L40: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[3];
L41: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L42: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[0];
      } 
    } 
  } 
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_float_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 234;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L44: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L45: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[5];
L46: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L47: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_float_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 234;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L49: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__QuatFloat__na_flags < 0, 0)) {
      FIELD_ID_SPVM__NDArray__QuatFloat__na_flags = env->get_field_id(env, "SPVM::NDArray::QuatFloat", "na_flags", "byte[]");
      if (FIELD_ID_SPVM__NDArray__QuatFloat__na_flags < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::QuatFloat na_flags");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__QuatFloat__na_flags = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__QuatFloat__na_flags);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__QuatFloat__na_flags);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_float_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 234;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L51: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L52: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L53: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L56;
L54: // INIT_INT
  int_vars[4] = 0;
L55: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L56;
L56: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L57: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__NDArray__ndarray_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[7];
  int32_t exception_flag = 0;
  int32_t mortal_stack[5];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_SPVM__NDArray__Int < 0) {
      BASIC_TYPE_ID_SPVM__NDArray__Int = env->get_basic_type_id(env, "SPVM::NDArray::Int");
      if (BASIC_TYPE_ID_SPVM__NDArray__Int < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::NDArray::Int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_SPVM__NDArray__Int;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 6;
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L5: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_int";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 50;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L7: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__Int__base < 0, 0)) {
      FIELD_ID_SPVM__NDArray__Int__base = env->get_field_id(env, "SPVM::NDArray::Int", "base", "int[]");
      if (FIELD_ID_SPVM__NDArray__Int__base < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::Int base");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__Int__base = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__Int__base);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__Int__base);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_int";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 50;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L9: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__Int__offset < 0, 0)) {
      FIELD_ID_SPVM__NDArray__Int__offset = env->get_field_id(env, "SPVM::NDArray::Int", "offset", "int");
      if (FIELD_ID_SPVM__NDArray__Int__offset < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::Int offset");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__Int__offset = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__Int__offset);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__Int__offset) = int_vars[2];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_int";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 51;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L14: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__Int__length < 0, 0)) {
      FIELD_ID_SPVM__NDArray__Int__length = env->get_field_id(env, "SPVM::NDArray::Int", "length", "int");
      if (FIELD_ID_SPVM__NDArray__Int__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::Int length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__Int__length = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__Int__length);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__Int__length) = int_vars[2];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_int";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 52;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L17: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L18: // SET_FIELD_BYTE
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__Int__T < 0, 0)) {
      FIELD_ID_SPVM__NDArray__Int__T = env->get_field_id(env, "SPVM::NDArray::Int", "T", "byte");
      if (FIELD_ID_SPVM__NDArray__Int__T < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::Int T");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__Int__T = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__Int__T);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int8_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__Int__T) = byte_vars[0];
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_int";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 53;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L21: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L22: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_int";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 54;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L24: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L25: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L26: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[3];
      } 
    } 
  } 
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_int";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 54;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L28: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L29: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L30: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[5];
      } 
    } 
  } 
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_int";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 54;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L32: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__Int__shape < 0, 0)) {
      FIELD_ID_SPVM__NDArray__Int__shape = env->get_field_id(env, "SPVM::NDArray::Int", "shape", "int[]");
      if (FIELD_ID_SPVM__NDArray__Int__shape < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::Int shape");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__Int__shape = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__Int__shape);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__Int__shape);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_int";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 54;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L34: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L36: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L37: // NEW_BYTE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_byte_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_int";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 55;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L39: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L40: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[3];
L41: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L42: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[0];
      } 
    } 
  } 
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_int";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 55;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L44: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L45: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[5];
L46: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L47: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_int";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 55;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L49: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__Int__na_flags < 0, 0)) {
      FIELD_ID_SPVM__NDArray__Int__na_flags = env->get_field_id(env, "SPVM::NDArray::Int", "na_flags", "byte[]");
      if (FIELD_ID_SPVM__NDArray__Int__na_flags < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::Int na_flags");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__Int__na_flags = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__Int__na_flags);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__Int__na_flags);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_int";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 55;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L51: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L52: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L53: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L56;
L54: // INIT_INT
  int_vars[4] = 0;
L55: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L56;
L56: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L57: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__NDArray__ndarray_int_complex(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[7];
  int32_t exception_flag = 0;
  int32_t mortal_stack[5];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_SPVM__NDArray__ComplexInt < 0) {
      BASIC_TYPE_ID_SPVM__NDArray__ComplexInt = env->get_basic_type_id(env, "SPVM::NDArray::ComplexInt");
      if (BASIC_TYPE_ID_SPVM__NDArray__ComplexInt < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::NDArray::ComplexInt");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_SPVM__NDArray__ComplexInt;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 6;
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L5: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_SPVM__Complex_2i < 0) {
      BASIC_TYPE_ID_SPVM__Complex_2i = env->get_basic_type_id(env, "SPVM::Complex_2i");
      if (BASIC_TYPE_ID_SPVM__Complex_2i < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Complex_2i");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_SPVM__Complex_2i;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_int_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 133;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L7: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__ComplexInt__base < 0, 0)) {
      FIELD_ID_SPVM__NDArray__ComplexInt__base = env->get_field_id(env, "SPVM::NDArray::ComplexInt", "base", "SPVM::Complex_2i[]");
      if (FIELD_ID_SPVM__NDArray__ComplexInt__base < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::ComplexInt base");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexInt__base = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__ComplexInt__base);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexInt__base);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_int_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 133;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L9: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__ComplexInt__offset < 0, 0)) {
      FIELD_ID_SPVM__NDArray__ComplexInt__offset = env->get_field_id(env, "SPVM::NDArray::ComplexInt", "offset", "int");
      if (FIELD_ID_SPVM__NDArray__ComplexInt__offset < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::ComplexInt offset");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexInt__offset = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__ComplexInt__offset);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexInt__offset) = int_vars[2];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_int_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 134;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L14: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__ComplexInt__length < 0, 0)) {
      FIELD_ID_SPVM__NDArray__ComplexInt__length = env->get_field_id(env, "SPVM::NDArray::ComplexInt", "length", "int");
      if (FIELD_ID_SPVM__NDArray__ComplexInt__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::ComplexInt length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexInt__length = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__ComplexInt__length);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexInt__length) = int_vars[2];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_int_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 135;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L17: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L18: // SET_FIELD_BYTE
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__ComplexInt__T < 0, 0)) {
      FIELD_ID_SPVM__NDArray__ComplexInt__T = env->get_field_id(env, "SPVM::NDArray::ComplexInt", "T", "byte");
      if (FIELD_ID_SPVM__NDArray__ComplexInt__T < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::ComplexInt T");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexInt__T = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__ComplexInt__T);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int8_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexInt__T) = byte_vars[0];
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_int_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 136;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L21: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L22: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_int_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 137;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L24: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L25: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L26: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[3];
      } 
    } 
  } 
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_int_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 137;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L28: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L29: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L30: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[5];
      } 
    } 
  } 
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_int_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 137;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L32: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__ComplexInt__shape < 0, 0)) {
      FIELD_ID_SPVM__NDArray__ComplexInt__shape = env->get_field_id(env, "SPVM::NDArray::ComplexInt", "shape", "int[]");
      if (FIELD_ID_SPVM__NDArray__ComplexInt__shape < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::ComplexInt shape");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexInt__shape = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__ComplexInt__shape);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexInt__shape);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_int_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 137;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L34: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L36: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L37: // NEW_BYTE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_byte_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_int_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 138;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L39: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L40: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[3];
L41: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L42: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[0];
      } 
    } 
  } 
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_int_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 138;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L44: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L45: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[5];
L46: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L47: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_int_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 138;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L49: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__ComplexInt__na_flags < 0, 0)) {
      FIELD_ID_SPVM__NDArray__ComplexInt__na_flags = env->get_field_id(env, "SPVM::NDArray::ComplexInt", "na_flags", "byte[]");
      if (FIELD_ID_SPVM__NDArray__ComplexInt__na_flags < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::ComplexInt na_flags");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexInt__na_flags = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__ComplexInt__na_flags);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexInt__na_flags);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_int_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 138;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L51: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L52: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L53: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L56;
L54: // INIT_INT
  int_vars[4] = 0;
L55: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L56;
L56: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L57: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__NDArray__ndarray_int_quat(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[7];
  int32_t exception_flag = 0;
  int32_t mortal_stack[5];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_SPVM__NDArray__QuatInt < 0) {
      BASIC_TYPE_ID_SPVM__NDArray__QuatInt = env->get_basic_type_id(env, "SPVM::NDArray::QuatInt");
      if (BASIC_TYPE_ID_SPVM__NDArray__QuatInt < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::NDArray::QuatInt");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_SPVM__NDArray__QuatInt;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 6;
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L5: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_SPVM__Quat_4i < 0) {
      BASIC_TYPE_ID_SPVM__Quat_4i = env->get_basic_type_id(env, "SPVM::Quat_4i");
      if (BASIC_TYPE_ID_SPVM__Quat_4i < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Quat_4i");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_SPVM__Quat_4i;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_int_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 205;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L7: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__QuatInt__base < 0, 0)) {
      FIELD_ID_SPVM__NDArray__QuatInt__base = env->get_field_id(env, "SPVM::NDArray::QuatInt", "base", "SPVM::Quat_4i[]");
      if (FIELD_ID_SPVM__NDArray__QuatInt__base < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::QuatInt base");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__QuatInt__base = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__QuatInt__base);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__QuatInt__base);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_int_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 205;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L9: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__QuatInt__offset < 0, 0)) {
      FIELD_ID_SPVM__NDArray__QuatInt__offset = env->get_field_id(env, "SPVM::NDArray::QuatInt", "offset", "int");
      if (FIELD_ID_SPVM__NDArray__QuatInt__offset < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::QuatInt offset");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__QuatInt__offset = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__QuatInt__offset);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__QuatInt__offset) = int_vars[2];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_int_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 206;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L14: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__QuatInt__length < 0, 0)) {
      FIELD_ID_SPVM__NDArray__QuatInt__length = env->get_field_id(env, "SPVM::NDArray::QuatInt", "length", "int");
      if (FIELD_ID_SPVM__NDArray__QuatInt__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::QuatInt length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__QuatInt__length = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__QuatInt__length);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__QuatInt__length) = int_vars[2];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_int_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 207;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L17: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L18: // SET_FIELD_BYTE
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__QuatInt__T < 0, 0)) {
      FIELD_ID_SPVM__NDArray__QuatInt__T = env->get_field_id(env, "SPVM::NDArray::QuatInt", "T", "byte");
      if (FIELD_ID_SPVM__NDArray__QuatInt__T < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::QuatInt T");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__QuatInt__T = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__QuatInt__T);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int8_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__QuatInt__T) = byte_vars[0];
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_int_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 208;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L21: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L22: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_int_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 209;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L24: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L25: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L26: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[3];
      } 
    } 
  } 
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_int_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 209;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L28: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L29: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L30: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[5];
      } 
    } 
  } 
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_int_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 209;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L32: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__QuatInt__shape < 0, 0)) {
      FIELD_ID_SPVM__NDArray__QuatInt__shape = env->get_field_id(env, "SPVM::NDArray::QuatInt", "shape", "int[]");
      if (FIELD_ID_SPVM__NDArray__QuatInt__shape < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::QuatInt shape");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__QuatInt__shape = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__QuatInt__shape);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__QuatInt__shape);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_int_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 209;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L34: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L36: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L37: // NEW_BYTE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_byte_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_int_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 210;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L39: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L40: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[3];
L41: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L42: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[0];
      } 
    } 
  } 
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_int_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 210;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L44: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L45: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[5];
L46: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L47: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_int_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 210;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L49: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__QuatInt__na_flags < 0, 0)) {
      FIELD_ID_SPVM__NDArray__QuatInt__na_flags = env->get_field_id(env, "SPVM::NDArray::QuatInt", "na_flags", "byte[]");
      if (FIELD_ID_SPVM__NDArray__QuatInt__na_flags < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::QuatInt na_flags");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__QuatInt__na_flags = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__QuatInt__na_flags);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__QuatInt__na_flags);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_int_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 210;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L51: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L52: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L53: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L56;
L54: // INIT_INT
  int_vars[4] = 0;
L55: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L56;
L56: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L57: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__NDArray__ndarray_long(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[7];
  int32_t exception_flag = 0;
  int32_t mortal_stack[5];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_SPVM__NDArray__Long < 0) {
      BASIC_TYPE_ID_SPVM__NDArray__Long = env->get_basic_type_id(env, "SPVM::NDArray::Long");
      if (BASIC_TYPE_ID_SPVM__NDArray__Long < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::NDArray::Long");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_SPVM__NDArray__Long;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 6;
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L5: // NEW_LONG_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_long_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_long";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 61;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L7: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__Long__base < 0, 0)) {
      FIELD_ID_SPVM__NDArray__Long__base = env->get_field_id(env, "SPVM::NDArray::Long", "base", "long[]");
      if (FIELD_ID_SPVM__NDArray__Long__base < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::Long base");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__Long__base = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__Long__base);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__Long__base);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_long";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 61;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L9: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__Long__offset < 0, 0)) {
      FIELD_ID_SPVM__NDArray__Long__offset = env->get_field_id(env, "SPVM::NDArray::Long", "offset", "int");
      if (FIELD_ID_SPVM__NDArray__Long__offset < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::Long offset");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__Long__offset = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__Long__offset);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__Long__offset) = int_vars[2];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_long";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 62;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L14: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__Long__length < 0, 0)) {
      FIELD_ID_SPVM__NDArray__Long__length = env->get_field_id(env, "SPVM::NDArray::Long", "length", "int");
      if (FIELD_ID_SPVM__NDArray__Long__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::Long length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__Long__length = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__Long__length);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__Long__length) = int_vars[2];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_long";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 63;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L17: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L18: // SET_FIELD_BYTE
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__Long__T < 0, 0)) {
      FIELD_ID_SPVM__NDArray__Long__T = env->get_field_id(env, "SPVM::NDArray::Long", "T", "byte");
      if (FIELD_ID_SPVM__NDArray__Long__T < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::Long T");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__Long__T = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__Long__T);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int8_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__Long__T) = byte_vars[0];
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_long";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 64;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L21: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L22: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_long";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 65;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L24: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L25: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L26: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[3];
      } 
    } 
  } 
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_long";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 65;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L28: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L29: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L30: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[5];
      } 
    } 
  } 
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_long";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 65;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L32: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__Long__shape < 0, 0)) {
      FIELD_ID_SPVM__NDArray__Long__shape = env->get_field_id(env, "SPVM::NDArray::Long", "shape", "int[]");
      if (FIELD_ID_SPVM__NDArray__Long__shape < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::Long shape");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__Long__shape = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__Long__shape);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__Long__shape);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_long";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 65;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L34: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L36: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L37: // NEW_BYTE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_byte_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_long";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 66;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L39: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L40: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[3];
L41: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L42: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[0];
      } 
    } 
  } 
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_long";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 66;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L44: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L45: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[5];
L46: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L47: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_long";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 66;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L49: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__Long__na_flags < 0, 0)) {
      FIELD_ID_SPVM__NDArray__Long__na_flags = env->get_field_id(env, "SPVM::NDArray::Long", "na_flags", "byte[]");
      if (FIELD_ID_SPVM__NDArray__Long__na_flags < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::Long na_flags");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__Long__na_flags = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__Long__na_flags);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__Long__na_flags);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_long";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 66;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L51: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L52: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L53: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L56;
L54: // INIT_INT
  int_vars[4] = 0;
L55: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L56;
L56: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L57: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__NDArray__ndarray_long_complex(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[7];
  int32_t exception_flag = 0;
  int32_t mortal_stack[5];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_SPVM__NDArray__ComplexLong < 0) {
      BASIC_TYPE_ID_SPVM__NDArray__ComplexLong = env->get_basic_type_id(env, "SPVM::NDArray::ComplexLong");
      if (BASIC_TYPE_ID_SPVM__NDArray__ComplexLong < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::NDArray::ComplexLong");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_SPVM__NDArray__ComplexLong;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 6;
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L5: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_SPVM__Complex_2l < 0) {
      BASIC_TYPE_ID_SPVM__Complex_2l = env->get_basic_type_id(env, "SPVM::Complex_2l");
      if (BASIC_TYPE_ID_SPVM__Complex_2l < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Complex_2l");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_SPVM__Complex_2l;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_long_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 145;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L7: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__ComplexLong__base < 0, 0)) {
      FIELD_ID_SPVM__NDArray__ComplexLong__base = env->get_field_id(env, "SPVM::NDArray::ComplexLong", "base", "SPVM::Complex_2l[]");
      if (FIELD_ID_SPVM__NDArray__ComplexLong__base < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::ComplexLong base");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexLong__base = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__ComplexLong__base);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexLong__base);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_long_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 145;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L9: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__ComplexLong__offset < 0, 0)) {
      FIELD_ID_SPVM__NDArray__ComplexLong__offset = env->get_field_id(env, "SPVM::NDArray::ComplexLong", "offset", "int");
      if (FIELD_ID_SPVM__NDArray__ComplexLong__offset < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::ComplexLong offset");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexLong__offset = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__ComplexLong__offset);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexLong__offset) = int_vars[2];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_long_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 146;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L14: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__ComplexLong__length < 0, 0)) {
      FIELD_ID_SPVM__NDArray__ComplexLong__length = env->get_field_id(env, "SPVM::NDArray::ComplexLong", "length", "int");
      if (FIELD_ID_SPVM__NDArray__ComplexLong__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::ComplexLong length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexLong__length = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__ComplexLong__length);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexLong__length) = int_vars[2];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_long_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 147;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L17: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L18: // SET_FIELD_BYTE
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__ComplexLong__T < 0, 0)) {
      FIELD_ID_SPVM__NDArray__ComplexLong__T = env->get_field_id(env, "SPVM::NDArray::ComplexLong", "T", "byte");
      if (FIELD_ID_SPVM__NDArray__ComplexLong__T < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::ComplexLong T");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexLong__T = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__ComplexLong__T);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int8_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexLong__T) = byte_vars[0];
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_long_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 148;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L21: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L22: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_long_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 149;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L24: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L25: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L26: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[3];
      } 
    } 
  } 
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_long_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 149;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L28: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L29: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L30: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[5];
      } 
    } 
  } 
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_long_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 149;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L32: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__ComplexLong__shape < 0, 0)) {
      FIELD_ID_SPVM__NDArray__ComplexLong__shape = env->get_field_id(env, "SPVM::NDArray::ComplexLong", "shape", "int[]");
      if (FIELD_ID_SPVM__NDArray__ComplexLong__shape < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::ComplexLong shape");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexLong__shape = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__ComplexLong__shape);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexLong__shape);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_long_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 149;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L34: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L36: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L37: // NEW_BYTE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_byte_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_long_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 150;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L39: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L40: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[3];
L41: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L42: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[0];
      } 
    } 
  } 
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_long_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 150;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L44: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L45: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[5];
L46: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L47: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_long_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 150;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L49: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__ComplexLong__na_flags < 0, 0)) {
      FIELD_ID_SPVM__NDArray__ComplexLong__na_flags = env->get_field_id(env, "SPVM::NDArray::ComplexLong", "na_flags", "byte[]");
      if (FIELD_ID_SPVM__NDArray__ComplexLong__na_flags < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::ComplexLong na_flags");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexLong__na_flags = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__ComplexLong__na_flags);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexLong__na_flags);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_long_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 150;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L51: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L52: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L53: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L56;
L54: // INIT_INT
  int_vars[4] = 0;
L55: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L56;
L56: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L57: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__NDArray__ndarray_long_quat(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[7];
  int32_t exception_flag = 0;
  int32_t mortal_stack[5];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_SPVM__NDArray__QuatLong < 0) {
      BASIC_TYPE_ID_SPVM__NDArray__QuatLong = env->get_basic_type_id(env, "SPVM::NDArray::QuatLong");
      if (BASIC_TYPE_ID_SPVM__NDArray__QuatLong < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::NDArray::QuatLong");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_SPVM__NDArray__QuatLong;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 6;
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L5: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_SPVM__Quat_4l < 0) {
      BASIC_TYPE_ID_SPVM__Quat_4l = env->get_basic_type_id(env, "SPVM::Quat_4l");
      if (BASIC_TYPE_ID_SPVM__Quat_4l < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Quat_4l");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_SPVM__Quat_4l;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_long_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 217;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L7: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__QuatLong__base < 0, 0)) {
      FIELD_ID_SPVM__NDArray__QuatLong__base = env->get_field_id(env, "SPVM::NDArray::QuatLong", "base", "SPVM::Quat_4l[]");
      if (FIELD_ID_SPVM__NDArray__QuatLong__base < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::QuatLong base");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__QuatLong__base = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__QuatLong__base);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__QuatLong__base);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_long_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 217;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L9: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__QuatLong__offset < 0, 0)) {
      FIELD_ID_SPVM__NDArray__QuatLong__offset = env->get_field_id(env, "SPVM::NDArray::QuatLong", "offset", "int");
      if (FIELD_ID_SPVM__NDArray__QuatLong__offset < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::QuatLong offset");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__QuatLong__offset = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__QuatLong__offset);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__QuatLong__offset) = int_vars[2];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_long_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 218;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L14: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__QuatLong__length < 0, 0)) {
      FIELD_ID_SPVM__NDArray__QuatLong__length = env->get_field_id(env, "SPVM::NDArray::QuatLong", "length", "int");
      if (FIELD_ID_SPVM__NDArray__QuatLong__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::QuatLong length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__QuatLong__length = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__QuatLong__length);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__QuatLong__length) = int_vars[2];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_long_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 219;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L17: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L18: // SET_FIELD_BYTE
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__QuatLong__T < 0, 0)) {
      FIELD_ID_SPVM__NDArray__QuatLong__T = env->get_field_id(env, "SPVM::NDArray::QuatLong", "T", "byte");
      if (FIELD_ID_SPVM__NDArray__QuatLong__T < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::QuatLong T");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__QuatLong__T = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__QuatLong__T);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int8_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__QuatLong__T) = byte_vars[0];
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_long_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 220;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L21: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L22: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_long_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 221;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L24: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L25: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L26: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[3];
      } 
    } 
  } 
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_long_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 221;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L28: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L29: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L30: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[5];
      } 
    } 
  } 
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_long_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 221;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L32: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__QuatLong__shape < 0, 0)) {
      FIELD_ID_SPVM__NDArray__QuatLong__shape = env->get_field_id(env, "SPVM::NDArray::QuatLong", "shape", "int[]");
      if (FIELD_ID_SPVM__NDArray__QuatLong__shape < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::QuatLong shape");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__QuatLong__shape = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__QuatLong__shape);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__QuatLong__shape);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_long_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 221;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L34: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L36: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L37: // NEW_BYTE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_byte_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_long_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 222;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L39: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L40: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[3];
L41: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L42: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[0];
      } 
    } 
  } 
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_long_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 222;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L44: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L45: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[5];
L46: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L47: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_long_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 222;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L49: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__QuatLong__na_flags < 0, 0)) {
      FIELD_ID_SPVM__NDArray__QuatLong__na_flags = env->get_field_id(env, "SPVM::NDArray::QuatLong", "na_flags", "byte[]");
      if (FIELD_ID_SPVM__NDArray__QuatLong__na_flags < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::QuatLong na_flags");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__QuatLong__na_flags = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__QuatLong__na_flags);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__QuatLong__na_flags);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_long_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 222;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L51: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L52: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L53: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L56;
L54: // INIT_INT
  int_vars[4] = 0;
L55: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L56;
L56: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L57: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__NDArray__ndarray_short(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[7];
  int32_t exception_flag = 0;
  int32_t mortal_stack[5];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_SPVM__NDArray__Short < 0) {
      BASIC_TYPE_ID_SPVM__NDArray__Short = env->get_basic_type_id(env, "SPVM::NDArray::Short");
      if (BASIC_TYPE_ID_SPVM__NDArray__Short < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::NDArray::Short");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_SPVM__NDArray__Short;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 6;
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L5: // NEW_SHORT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_short_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_short";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 38;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L7: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__Short__base < 0, 0)) {
      FIELD_ID_SPVM__NDArray__Short__base = env->get_field_id(env, "SPVM::NDArray::Short", "base", "short[]");
      if (FIELD_ID_SPVM__NDArray__Short__base < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::Short base");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__Short__base = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__Short__base);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__Short__base);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_short";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 38;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L9: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__Short__offset < 0, 0)) {
      FIELD_ID_SPVM__NDArray__Short__offset = env->get_field_id(env, "SPVM::NDArray::Short", "offset", "int");
      if (FIELD_ID_SPVM__NDArray__Short__offset < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::Short offset");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__Short__offset = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__Short__offset);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__Short__offset) = int_vars[2];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_short";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 39;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L14: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__Short__length < 0, 0)) {
      FIELD_ID_SPVM__NDArray__Short__length = env->get_field_id(env, "SPVM::NDArray::Short", "length", "int");
      if (FIELD_ID_SPVM__NDArray__Short__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::Short length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__Short__length = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__Short__length);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__Short__length) = int_vars[2];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_short";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 40;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L17: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L18: // SET_FIELD_BYTE
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__Short__T < 0, 0)) {
      FIELD_ID_SPVM__NDArray__Short__T = env->get_field_id(env, "SPVM::NDArray::Short", "T", "byte");
      if (FIELD_ID_SPVM__NDArray__Short__T < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::Short T");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__Short__T = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__Short__T);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int8_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__Short__T) = byte_vars[0];
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_short";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 41;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L21: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L22: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_short";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 42;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L24: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L25: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L26: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[3];
      } 
    } 
  } 
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_short";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 42;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L28: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L29: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L30: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[5];
      } 
    } 
  } 
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_short";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 42;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L32: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__Short__shape < 0, 0)) {
      FIELD_ID_SPVM__NDArray__Short__shape = env->get_field_id(env, "SPVM::NDArray::Short", "shape", "int[]");
      if (FIELD_ID_SPVM__NDArray__Short__shape < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::Short shape");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__Short__shape = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__Short__shape);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__Short__shape);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_short";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 42;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L34: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L36: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L37: // NEW_BYTE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_byte_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_short";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 43;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L39: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L40: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[3];
L41: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L42: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[0];
      } 
    } 
  } 
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_short";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 43;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L44: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L45: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[5];
L46: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L47: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_short";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 43;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L49: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__Short__na_flags < 0, 0)) {
      FIELD_ID_SPVM__NDArray__Short__na_flags = env->get_field_id(env, "SPVM::NDArray::Short", "na_flags", "byte[]");
      if (FIELD_ID_SPVM__NDArray__Short__na_flags < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::Short na_flags");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__Short__na_flags = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__Short__na_flags);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__Short__na_flags);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_short";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 43;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L51: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L52: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L53: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L56;
L54: // INIT_INT
  int_vars[4] = 0;
L55: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L56;
L56: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L57: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__NDArray__ndarray_short_complex(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[7];
  int32_t exception_flag = 0;
  int32_t mortal_stack[5];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_SPVM__NDArray__ComplexShort < 0) {
      BASIC_TYPE_ID_SPVM__NDArray__ComplexShort = env->get_basic_type_id(env, "SPVM::NDArray::ComplexShort");
      if (BASIC_TYPE_ID_SPVM__NDArray__ComplexShort < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::NDArray::ComplexShort");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_SPVM__NDArray__ComplexShort;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 6;
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L5: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_SPVM__Complex_2s < 0) {
      BASIC_TYPE_ID_SPVM__Complex_2s = env->get_basic_type_id(env, "SPVM::Complex_2s");
      if (BASIC_TYPE_ID_SPVM__Complex_2s < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Complex_2s");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_SPVM__Complex_2s;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_short_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 121;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L7: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__ComplexShort__base < 0, 0)) {
      FIELD_ID_SPVM__NDArray__ComplexShort__base = env->get_field_id(env, "SPVM::NDArray::ComplexShort", "base", "SPVM::Complex_2s[]");
      if (FIELD_ID_SPVM__NDArray__ComplexShort__base < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::ComplexShort base");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexShort__base = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__ComplexShort__base);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexShort__base);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_short_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 121;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L9: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__ComplexShort__offset < 0, 0)) {
      FIELD_ID_SPVM__NDArray__ComplexShort__offset = env->get_field_id(env, "SPVM::NDArray::ComplexShort", "offset", "int");
      if (FIELD_ID_SPVM__NDArray__ComplexShort__offset < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::ComplexShort offset");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexShort__offset = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__ComplexShort__offset);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexShort__offset) = int_vars[2];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_short_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 122;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L14: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__ComplexShort__length < 0, 0)) {
      FIELD_ID_SPVM__NDArray__ComplexShort__length = env->get_field_id(env, "SPVM::NDArray::ComplexShort", "length", "int");
      if (FIELD_ID_SPVM__NDArray__ComplexShort__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::ComplexShort length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexShort__length = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__ComplexShort__length);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexShort__length) = int_vars[2];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_short_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 123;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L17: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L18: // SET_FIELD_BYTE
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__ComplexShort__T < 0, 0)) {
      FIELD_ID_SPVM__NDArray__ComplexShort__T = env->get_field_id(env, "SPVM::NDArray::ComplexShort", "T", "byte");
      if (FIELD_ID_SPVM__NDArray__ComplexShort__T < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::ComplexShort T");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexShort__T = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__ComplexShort__T);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int8_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexShort__T) = byte_vars[0];
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_short_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 124;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L21: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L22: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_short_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 125;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L24: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L25: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L26: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[3];
      } 
    } 
  } 
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_short_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 125;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L28: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L29: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L30: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[5];
      } 
    } 
  } 
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_short_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 125;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L32: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__ComplexShort__shape < 0, 0)) {
      FIELD_ID_SPVM__NDArray__ComplexShort__shape = env->get_field_id(env, "SPVM::NDArray::ComplexShort", "shape", "int[]");
      if (FIELD_ID_SPVM__NDArray__ComplexShort__shape < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::ComplexShort shape");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexShort__shape = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__ComplexShort__shape);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexShort__shape);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_short_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 125;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L34: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L36: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L37: // NEW_BYTE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_byte_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_short_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 126;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L39: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L40: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[3];
L41: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L42: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[0];
      } 
    } 
  } 
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_short_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 126;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L44: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L45: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[5];
L46: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L47: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_short_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 126;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L49: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__ComplexShort__na_flags < 0, 0)) {
      FIELD_ID_SPVM__NDArray__ComplexShort__na_flags = env->get_field_id(env, "SPVM::NDArray::ComplexShort", "na_flags", "byte[]");
      if (FIELD_ID_SPVM__NDArray__ComplexShort__na_flags < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::ComplexShort na_flags");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexShort__na_flags = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__ComplexShort__na_flags);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__ComplexShort__na_flags);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_short_complex";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 126;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L51: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L52: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L53: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L56;
L54: // INIT_INT
  int_vars[4] = 0;
L55: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L56;
L56: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L57: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__NDArray__ndarray_short_quat(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[7];
  int32_t exception_flag = 0;
  int32_t mortal_stack[5];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_SPVM__NDArray__QuatShort < 0) {
      BASIC_TYPE_ID_SPVM__NDArray__QuatShort = env->get_basic_type_id(env, "SPVM::NDArray::QuatShort");
      if (BASIC_TYPE_ID_SPVM__NDArray__QuatShort < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::NDArray::QuatShort");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_SPVM__NDArray__QuatShort;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 6;
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L5: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_SPVM__Quat_4s < 0) {
      BASIC_TYPE_ID_SPVM__Quat_4s = env->get_basic_type_id(env, "SPVM::Quat_4s");
      if (BASIC_TYPE_ID_SPVM__Quat_4s < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Quat_4s");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_SPVM__Quat_4s;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_short_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 193;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L7: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__QuatShort__base < 0, 0)) {
      FIELD_ID_SPVM__NDArray__QuatShort__base = env->get_field_id(env, "SPVM::NDArray::QuatShort", "base", "SPVM::Quat_4s[]");
      if (FIELD_ID_SPVM__NDArray__QuatShort__base < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::QuatShort base");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__QuatShort__base = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__QuatShort__base);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__QuatShort__base);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_short_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 193;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L9: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__QuatShort__offset < 0, 0)) {
      FIELD_ID_SPVM__NDArray__QuatShort__offset = env->get_field_id(env, "SPVM::NDArray::QuatShort", "offset", "int");
      if (FIELD_ID_SPVM__NDArray__QuatShort__offset < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::QuatShort offset");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__QuatShort__offset = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__QuatShort__offset);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__QuatShort__offset) = int_vars[2];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_short_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 194;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L14: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__QuatShort__length < 0, 0)) {
      FIELD_ID_SPVM__NDArray__QuatShort__length = env->get_field_id(env, "SPVM::NDArray::QuatShort", "length", "int");
      if (FIELD_ID_SPVM__NDArray__QuatShort__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::QuatShort length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__QuatShort__length = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__QuatShort__length);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__QuatShort__length) = int_vars[2];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_short_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 195;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L17: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L18: // SET_FIELD_BYTE
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__QuatShort__T < 0, 0)) {
      FIELD_ID_SPVM__NDArray__QuatShort__T = env->get_field_id(env, "SPVM::NDArray::QuatShort", "T", "byte");
      if (FIELD_ID_SPVM__NDArray__QuatShort__T < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::QuatShort T");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__QuatShort__T = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__QuatShort__T);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int8_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__QuatShort__T) = byte_vars[0];
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_short_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 196;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L21: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L22: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_short_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 197;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L24: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L25: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L26: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[3];
      } 
    } 
  } 
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_short_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 197;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L28: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L29: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L30: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[5];
      } 
    } 
  } 
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_short_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 197;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L32: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__QuatShort__shape < 0, 0)) {
      FIELD_ID_SPVM__NDArray__QuatShort__shape = env->get_field_id(env, "SPVM::NDArray::QuatShort", "shape", "int[]");
      if (FIELD_ID_SPVM__NDArray__QuatShort__shape < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::QuatShort shape");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__QuatShort__shape = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__QuatShort__shape);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__QuatShort__shape);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_short_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 197;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L34: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L36: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L37: // NEW_BYTE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_byte_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_short_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 198;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L39: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L40: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[3];
L41: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L42: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[0];
      } 
    } 
  } 
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_short_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 198;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L44: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L45: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[5];
L46: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L47: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_short_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 198;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L49: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__QuatShort__na_flags < 0, 0)) {
      FIELD_ID_SPVM__NDArray__QuatShort__na_flags = env->get_field_id(env, "SPVM::NDArray::QuatShort", "na_flags", "byte[]");
      if (FIELD_ID_SPVM__NDArray__QuatShort__na_flags < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::QuatShort na_flags");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__QuatShort__na_flags = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__QuatShort__na_flags);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__QuatShort__na_flags);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_short_quat";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 198;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L51: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L52: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L53: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L56;
L54: // INIT_INT
  int_vars[4] = 0;
L55: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L56;
L56: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L57: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__NDArray__ndarray_string(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[7];
  int32_t exception_flag = 0;
  int32_t mortal_stack[5];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_SPVM__NDArray__String < 0) {
      BASIC_TYPE_ID_SPVM__NDArray__String = env->get_basic_type_id(env, "SPVM::NDArray::String");
      if (BASIC_TYPE_ID_SPVM__NDArray__String < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::NDArray::String");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_SPVM__NDArray__String;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 6;
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L5: // NEW_MULTI_ARRAY
  {
    if (BASIC_TYPE_ID_byte < 0) {
      BASIC_TYPE_ID_byte = env->get_basic_type_id(env, "byte");
      if (BASIC_TYPE_ID_byte < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found byte");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_byte;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_muldim_array_raw(env, basic_type_id, 1, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_string";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 97;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L7: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__String__base < 0, 0)) {
      FIELD_ID_SPVM__NDArray__String__base = env->get_field_id(env, "SPVM::NDArray::String", "base", "string[]");
      if (FIELD_ID_SPVM__NDArray__String__base < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::String base");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__String__base = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__String__base);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__String__base);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_string";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 97;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L9: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__String__offset < 0, 0)) {
      FIELD_ID_SPVM__NDArray__String__offset = env->get_field_id(env, "SPVM::NDArray::String", "offset", "int");
      if (FIELD_ID_SPVM__NDArray__String__offset < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::String offset");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__String__offset = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__String__offset);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__String__offset) = int_vars[2];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_string";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 98;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L14: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__String__length < 0, 0)) {
      FIELD_ID_SPVM__NDArray__String__length = env->get_field_id(env, "SPVM::NDArray::String", "length", "int");
      if (FIELD_ID_SPVM__NDArray__String__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::String length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__String__length = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__String__length);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__String__length) = int_vars[2];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_string";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 99;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L17: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L18: // SET_FIELD_BYTE
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__String__T < 0, 0)) {
      FIELD_ID_SPVM__NDArray__String__T = env->get_field_id(env, "SPVM::NDArray::String", "T", "byte");
      if (FIELD_ID_SPVM__NDArray__String__T < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::String T");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__String__T = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__String__T);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int8_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__String__T) = byte_vars[0];
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_string";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 100;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L21: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L22: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_string";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 101;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L24: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L25: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L26: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[3];
      } 
    } 
  } 
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_string";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 101;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L28: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L29: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L30: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[5];
      } 
    } 
  } 
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_string";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 101;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L32: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__String__shape < 0, 0)) {
      FIELD_ID_SPVM__NDArray__String__shape = env->get_field_id(env, "SPVM::NDArray::String", "shape", "int[]");
      if (FIELD_ID_SPVM__NDArray__String__shape < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::String shape");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__String__shape = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__String__shape);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__String__shape);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_string";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 101;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L34: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L36: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L37: // NEW_BYTE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_byte_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_string";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 102;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L39: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L40: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[3];
L41: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L42: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[0];
      } 
    } 
  } 
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_string";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 102;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L44: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L45: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[5];
L46: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L47: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_string";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 102;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L49: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__NDArray__String__na_flags < 0, 0)) {
      FIELD_ID_SPVM__NDArray__String__na_flags = env->get_field_id(env, "SPVM::NDArray::String", "na_flags", "byte[]");
      if (FIELD_ID_SPVM__NDArray__String__na_flags < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::NDArray::String na_flags");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__NDArray__String__na_flags = env->get_field_offset(env, FIELD_ID_SPVM__NDArray__String__na_flags);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__NDArray__String__na_flags);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::NDArray";
    const char* sub_name = "ndarray_string";
    const char* file = "TestCase/Lib/SPVM/NDArray.spvm";
    int32_t line = 102;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L51: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L52: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L53: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L56;
L54: // INIT_INT
  int_vars[4] = 0;
L55: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L56;
L56: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L57: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


