#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
// Sub id declarations
static int32_t SUB_ID_SPVM__Util__INT8_MAX = - 1;
static int32_t SUB_ID_TestCase__Minimal__new = - 1;
// Basic type id declarations
static int32_t BASIC_TYPE_ID_int = -1;
static int32_t BASIC_TYPE_ID_byte = -1;
static int32_t BASIC_TYPE_ID_short = -1;
static int32_t BASIC_TYPE_ID_long = -1;
static int32_t BASIC_TYPE_ID_float = -1;
static int32_t BASIC_TYPE_ID_double = -1;
static int32_t BASIC_TYPE_ID_TestCase__Minimal = -1;
static int32_t BASIC_TYPE_ID_object = -1;
// Function Declarations
// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Array__array(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Array__array_culcurate_sum_by_for(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Array__array_default_zero_memory_pool(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Array__array_default_zero_not_memory_pool(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Array__array_init_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Array__array_init_double(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Array__array_init_empty(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Array__array_init_fatcamma(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Array__array_init_float(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Array__array_init_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Array__array_init_long(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Array__array_init_object(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Array__array_init_short(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Array__array_length_atmark(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Array__array_length_atmark_brace(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Array__array_length_scalar_atmark(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Array__array_length_scalar_atmark_brace(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Array__array_length_undef(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Array__array_set_and_get_array_element_first(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Array__array_set_and_get_array_element_last(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Array__array_store_undef(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__Array__array(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[7];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_MULTI_ARRAY
  {
    if (BASIC_TYPE_ID_int < 0) {
      BASIC_TYPE_ID_int = env->get_basic_type_id(env, "int");
      if (BASIC_TYPE_ID_int < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_int;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_muldim_array_raw(env, basic_type_id, 1, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 118;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L30;
  }
L5: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L7: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L8: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L9: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L10: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[3];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 121;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L30;
  }
L12: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L13: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L14: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[2];
      } 
    } 
  } 
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 122;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L30;
  }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L17: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L18: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L19: // ARRAY_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 123;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L30;
  }
L21: // MOVE_CONSTANT_INT
  int_vars[5] = 4;
L22: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L23: // BOOL_INT
  int_vars[0] = int_vars[0];
L24: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L28; }
L25: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L26: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L30;
L27: // GOTO
  goto L28;
L28: // INIT_INT
  int_vars[4] = 0;
L29: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L30;
L30: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L31: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Array__array_culcurate_sum_by_for(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[7];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_culcurate_sum_by_for";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 145;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L34;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L7: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[2];
      } 
    } 
  } 
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_culcurate_sum_by_for";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 146;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L34;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L10: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L11: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[2];
      } 
    } 
  } 
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_culcurate_sum_by_for";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 147;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L34;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L14: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L15: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[2];
      } 
    } 
  } 
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_culcurate_sum_by_for";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 148;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L34;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L18: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L19: // GOTO
  goto L26;
L20: // ARRAY_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_culcurate_sum_by_for";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 152;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L34;
  }
L22: // ADD_INT
  int_vars[2] = int_vars[2] + int_vars[4];
L23: // MOVE_INT
  int_vars[4] = int_vars[3];
L24: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L25: // ADD_INT
  int_vars[3] = int_vars[4] + int_vars[5];
L26: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[4] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_culcurate_sum_by_for";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 151;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L34;
  }
L28: // LT_INT
  int_vars[0] = (int_vars[3] < int_vars[4]);
L29: // BOOL_INT
  int_vars[0] = int_vars[0];
L30: // IF_NE_ZERO
  if (int_vars[0]) { goto L20; }
L31: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L34;
L32: // INIT_INT
  int_vars[5] = 0;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L34;
L34: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L35: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Array__array_default_zero_memory_pool(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[7] = {0};
  double double_vars[2];
  float float_vars[2];
  int64_t long_vars[2];
  int32_t int_vars[10];
  int32_t exception_flag = 0;
  int32_t mortal_stack[8];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[1];
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 10;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_BYTE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_byte_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_default_zero_memory_pool";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 284;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 10;
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L7: // NEW_SHORT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_short_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_default_zero_memory_pool";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 285;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 10;
L10: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L11: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[2], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_default_zero_memory_pool";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 286;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 10;
L14: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L15: // NEW_LONG_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_long_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[3], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_default_zero_memory_pool";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 287;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 10;
L18: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L19: // NEW_FLOAT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_float_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[4], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_default_zero_memory_pool";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 288;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L21: // MOVE_CONSTANT_INT
  int_vars[2] = 10;
L22: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L23: // NEW_DOUBLE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_double_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[5], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_default_zero_memory_pool";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 289;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L25: // MOVE_CONSTANT_INT
  int_vars[2] = 10;
L26: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L27: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
      BASIC_TYPE_ID_TestCase__Minimal = env->get_basic_type_id(env, "TestCase::Minimal");
      if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Minimal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Minimal;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[6], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_default_zero_memory_pool";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 290;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L30: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_default_zero_memory_pool";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 291;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L32: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L33: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L34: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L35: // BOOL_INT
  int_vars[0] = int_vars[0];
L36: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L133; }
L37: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L38: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L39: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_default_zero_memory_pool";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 292;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L40: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L41: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L42: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L43: // BOOL_INT
  int_vars[0] = int_vars[0];
L44: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L132; }
L45: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L46: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L47: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_default_zero_memory_pool";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 293;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L48: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L49: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L50: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L51: // BOOL_INT
  int_vars[0] = int_vars[0];
L52: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L129; }
L53: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L54: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L55: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_default_zero_memory_pool";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 294;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L56: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L57: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L58: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L59: // BOOL_INT
  int_vars[0] = int_vars[0];
L60: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L128; }
L61: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L62: // ARRAY_FETCH_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[3] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L63: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_default_zero_memory_pool";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 295;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L64: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L65: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L66: // BOOL_INT
  int_vars[0] = int_vars[0];
L67: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L127; }
L68: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L69: // ARRAY_FETCH_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[3] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L70: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_default_zero_memory_pool";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 296;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L71: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L72: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L73: // BOOL_INT
  int_vars[0] = int_vars[0];
L74: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L126; }
L75: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L76: // ARRAY_FETCH_LONG
  {
    void* array = object_vars[3];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] = ((int64_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L77: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_default_zero_memory_pool";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 297;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L78: // MOVE_CONSTANT_LONG
  long_vars[1] = 0LL;
L79: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L80: // BOOL_INT
  int_vars[0] = int_vars[0];
L81: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L125; }
L82: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L83: // ARRAY_FETCH_LONG
  {
    void* array = object_vars[3];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] = ((int64_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L84: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_default_zero_memory_pool";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 298;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L85: // MOVE_CONSTANT_LONG
  long_vars[1] = 0LL;
L86: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L87: // BOOL_INT
  int_vars[0] = int_vars[0];
L88: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L124; }
L89: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L90: // ARRAY_FETCH_FLOAT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] = ((float*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L91: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_default_zero_memory_pool";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 299;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L92: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.0;
L93: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L94: // BOOL_INT
  int_vars[0] = int_vars[0];
L95: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L123; }
L96: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L97: // ARRAY_FETCH_FLOAT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] = ((float*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L98: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_default_zero_memory_pool";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 300;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L99: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.0;
L100: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L101: // BOOL_INT
  int_vars[0] = int_vars[0];
L102: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L122; }
L103: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L104: // ARRAY_FETCH_DOUBLE
  {
    void* array = object_vars[5];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] = ((double*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L105: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_default_zero_memory_pool";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 301;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L106: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.0;
L107: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L108: // BOOL_INT
  int_vars[0] = int_vars[0];
L109: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L121; }
L110: // MOVE_CONSTANT_INT
  int_vars[2] = 9;
L111: // ARRAY_FETCH_DOUBLE
  {
    void* array = object_vars[5];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] = ((double*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L112: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_default_zero_memory_pool";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 302;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L113: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.0;
L114: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L115: // BOOL_INT
  int_vars[0] = int_vars[0];
L116: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L120; }
L117: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L118: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L137;
L119: // GOTO
  goto L120;
L120: // GOTO
  goto L121;
L121: // GOTO
  goto L122;
L122: // GOTO
  goto L123;
L123: // GOTO
  goto L124;
L124: // GOTO
  goto L125;
L125: // GOTO
  goto L126;
L126: // GOTO
  goto L127;
L127: // GOTO
  goto L128;
L128: // GOTO
  goto L129;
L129: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L130: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L137;
L131: // GOTO
  goto L132;
L132: // GOTO
  goto L133;
L133: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L134: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L137;
L135: // INIT_INT
  int_vars[8] = 0;
L136: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[8];
  goto L137;
L137: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L138: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Array__array_default_zero_not_memory_pool(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[7] = {0};
  double double_vars[2];
  float float_vars[2];
  int64_t long_vars[2];
  int32_t int_vars[10];
  int32_t exception_flag = 0;
  int32_t mortal_stack[8];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[1];
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1000000;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_BYTE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_byte_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_default_zero_not_memory_pool";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 247;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1000000;
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L7: // NEW_SHORT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_short_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_default_zero_not_memory_pool";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 248;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 1000000;
L10: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L11: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[2], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_default_zero_not_memory_pool";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 249;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 1000000;
L14: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L15: // NEW_LONG_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_long_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[3], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_default_zero_not_memory_pool";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 250;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 1000000;
L18: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L19: // NEW_FLOAT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_float_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[4], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_default_zero_not_memory_pool";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 251;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L21: // MOVE_CONSTANT_INT
  int_vars[2] = 1000000;
L22: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L23: // NEW_DOUBLE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_double_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[5], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_default_zero_not_memory_pool";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 252;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L25: // MOVE_CONSTANT_INT
  int_vars[2] = 1000000;
L26: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L27: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
      BASIC_TYPE_ID_TestCase__Minimal = env->get_basic_type_id(env, "TestCase::Minimal");
      if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Minimal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Minimal;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[6], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_default_zero_not_memory_pool";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 253;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L30: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_default_zero_not_memory_pool";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 254;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L32: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L33: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L34: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L35: // BOOL_INT
  int_vars[0] = int_vars[0];
L36: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L133; }
L37: // MOVE_CONSTANT_INT
  int_vars[2] = 999999;
L38: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L39: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_default_zero_not_memory_pool";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 255;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L40: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L41: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L42: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L43: // BOOL_INT
  int_vars[0] = int_vars[0];
L44: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L132; }
L45: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L46: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L47: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_default_zero_not_memory_pool";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 256;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L48: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L49: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L50: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L51: // BOOL_INT
  int_vars[0] = int_vars[0];
L52: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L129; }
L53: // MOVE_CONSTANT_INT
  int_vars[2] = 999999;
L54: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L55: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_default_zero_not_memory_pool";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 257;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L56: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L57: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L58: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L59: // BOOL_INT
  int_vars[0] = int_vars[0];
L60: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L128; }
L61: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L62: // ARRAY_FETCH_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[3] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L63: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_default_zero_not_memory_pool";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 258;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L64: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L65: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L66: // BOOL_INT
  int_vars[0] = int_vars[0];
L67: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L127; }
L68: // MOVE_CONSTANT_INT
  int_vars[2] = 999999;
L69: // ARRAY_FETCH_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[3] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L70: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_default_zero_not_memory_pool";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 259;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L71: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L72: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L73: // BOOL_INT
  int_vars[0] = int_vars[0];
L74: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L126; }
L75: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L76: // ARRAY_FETCH_LONG
  {
    void* array = object_vars[3];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] = ((int64_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L77: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_default_zero_not_memory_pool";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 260;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L78: // MOVE_CONSTANT_LONG
  long_vars[1] = 0LL;
L79: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L80: // BOOL_INT
  int_vars[0] = int_vars[0];
L81: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L125; }
L82: // MOVE_CONSTANT_INT
  int_vars[2] = 999999;
L83: // ARRAY_FETCH_LONG
  {
    void* array = object_vars[3];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] = ((int64_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L84: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_default_zero_not_memory_pool";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 261;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L85: // MOVE_CONSTANT_LONG
  long_vars[1] = 0LL;
L86: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L87: // BOOL_INT
  int_vars[0] = int_vars[0];
L88: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L124; }
L89: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L90: // ARRAY_FETCH_FLOAT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] = ((float*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L91: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_default_zero_not_memory_pool";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 262;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L92: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.0;
L93: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L94: // BOOL_INT
  int_vars[0] = int_vars[0];
L95: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L123; }
L96: // MOVE_CONSTANT_INT
  int_vars[2] = 999999;
L97: // ARRAY_FETCH_FLOAT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] = ((float*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L98: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_default_zero_not_memory_pool";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 263;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L99: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.0;
L100: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L101: // BOOL_INT
  int_vars[0] = int_vars[0];
L102: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L122; }
L103: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L104: // ARRAY_FETCH_DOUBLE
  {
    void* array = object_vars[5];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] = ((double*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L105: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_default_zero_not_memory_pool";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 264;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L106: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.0;
L107: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L108: // BOOL_INT
  int_vars[0] = int_vars[0];
L109: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L121; }
L110: // MOVE_CONSTANT_INT
  int_vars[2] = 999999;
L111: // ARRAY_FETCH_DOUBLE
  {
    void* array = object_vars[5];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] = ((double*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L112: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_default_zero_not_memory_pool";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 265;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L113: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.0;
L114: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L115: // BOOL_INT
  int_vars[0] = int_vars[0];
L116: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L120; }
L117: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L118: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L137;
L119: // GOTO
  goto L120;
L120: // GOTO
  goto L121;
L121: // GOTO
  goto L122;
L122: // GOTO
  goto L123;
L123: // GOTO
  goto L124;
L124: // GOTO
  goto L125;
L125: // GOTO
  goto L126;
L126: // GOTO
  goto L127;
L127: // GOTO
  goto L128;
L128: // GOTO
  goto L129;
L129: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L130: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L137;
L131: // GOTO
  goto L132;
L132: // GOTO
  goto L133;
L133: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L134: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L137;
L135: // INIT_INT
  int_vars[8] = 0;
L136: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[8];
  goto L137;
L137: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L138: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Array__array_init_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[3];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_BYTE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_byte_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_byte";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 159;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L58;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L8: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[0];
      } 
    } 
  } 
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_byte";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 159;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L58;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L11: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[4];
L12: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L13: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_byte";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 159;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L58;
  }
L15: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MAX
  {
    if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
      SUB_ID_SPVM__Util__INT8_MAX = env->get_sub_id(env, "SPVM::Util", "INT8_MAX", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[2] = *(int8_t*)&stack[0];
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_byte";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 159;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L58;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L18: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[2];
      } 
    } 
  } 
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_byte";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 159;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L58;
  }
L20: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L21: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L22: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L23: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L24: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L25: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_byte";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 161;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L58;
  }
L26: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L27: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L28: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L29: // BOOL_INT
  int_vars[0] = int_vars[0];
L30: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L54; }
L31: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L32: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_byte";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 162;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L58;
  }
L34: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L35: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L36: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L37: // BOOL_INT
  int_vars[0] = int_vars[0];
L38: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L53; }
L39: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L40: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L41: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_byte";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 163;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L58;
  }
L42: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L43: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MAX
  {
    if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
      SUB_ID_SPVM__Util__INT8_MAX = env->get_sub_id(env, "SPVM::Util", "INT8_MAX", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[1] = *(int8_t*)&stack[0];
    }
  }
L44: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_byte";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 163;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L58;
  }
L45: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[1];
L46: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L47: // BOOL_INT
  int_vars[0] = int_vars[0];
L48: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L52; }
L49: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L50: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L58;
L51: // GOTO
  goto L52;
L52: // GOTO
  goto L53;
L53: // GOTO
  goto L54;
L54: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L55: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L58;
L56: // INIT_INT
  int_vars[6] = 0;
L57: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L58;
L58: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L59: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Array__array_init_double(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  double double_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_DOUBLE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_double_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_double";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 235;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L50;
  }
L5: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0;
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L7: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[0];
      } 
    } 
  } 
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_double";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 235;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L50;
  }
L9: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 2.0;
L10: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L11: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[1];
      } 
    } 
  } 
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_double";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 235;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L50;
  }
L13: // MOVE_CONSTANT_DOUBLE
  double_vars[2] = 3.0;
L14: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L15: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[2];
      } 
    } 
  } 
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_double";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 235;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L50;
  }
L17: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L18: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L19: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L21: // ARRAY_FETCH_DOUBLE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] = ((double*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L22: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_double";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 237;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L50;
  }
L23: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 1.0;
L24: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L46; }
L27: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L28: // ARRAY_FETCH_DOUBLE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] = ((double*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_double";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 238;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L50;
  }
L30: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 2.0;
L31: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L32: // BOOL_INT
  int_vars[0] = int_vars[0];
L33: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L45; }
L34: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L35: // ARRAY_FETCH_DOUBLE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] = ((double*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_double";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 239;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L50;
  }
L37: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 3.0;
L38: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L39: // BOOL_INT
  int_vars[0] = int_vars[0];
L40: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L44; }
L41: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L42: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L50;
L43: // GOTO
  goto L44;
L44: // GOTO
  goto L45;
L45: // GOTO
  goto L46;
L46: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L47: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L50;
L48: // INIT_INT
  int_vars[6] = 0;
L49: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L50;
L50: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L51: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Array__array_init_empty(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_empty";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 7;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L27;
  }
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L6: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L7: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L8: // ARRAY_LENGTH
  if (object_vars[1] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[2] = *(int32_t*)((intptr_t)object_vars[1] + (intptr_t)env->object_length_offset);
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_empty";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 8;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L27;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L11: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L12: // BOOL_INT
  int_vars[0] = int_vars[0];
L13: // IF_NE_ZERO
  if (int_vars[0]) { goto L17; }
L14: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L27;
L16: // GOTO
  goto L17;
L17: // IS_TYPE
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_object;
    int32_t check_type_dimension = 1;
    void* object = object_vars[1];
    if (object) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
int_vars[0]      = env->is_type(env, object, check_basic_type_id, check_type_dimension);
    }
    else {
int_vars[0]      = 0;
    }
  }
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_NE_ZERO
  if (int_vars[0]) { goto L23; }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L27;
L22: // GOTO
  goto L23;
L23: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L27;
L25: // INIT_INT
  int_vars[6] = 0;
L26: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L27;
L27: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L28: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Array__array_init_fatcamma(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[7] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[16];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 4;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_fatcamma";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 20;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L111;
  }
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L6: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x78", 1));
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L8: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L10: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_fatcamma";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 20;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L111;
  }
L12: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L13: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L14: // CONVERT_INT_TO_INT_OBJECT
  {
    int32_t value = int_vars[3];
    int32_t basic_type_id = (intptr_t)(void*)env->int_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(int32_t*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object);
  }
L15: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L16: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_fatcamma";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 20;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L111;
  }
L18: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L19: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "\x79", 1));
L20: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L21: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[4]
        );
      }
    }
  }
L22: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_fatcamma";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 20;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L111;
  }
L23: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L24: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L25: // CONVERT_INT_TO_INT_OBJECT
  {
    int32_t value = int_vars[6];
    int32_t basic_type_id = (intptr_t)(void*)env->int_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(int32_t*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], object);
  }
L26: // MOVE_CONSTANT_INT
  int_vars[7] = 3;
L27: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[5]
        );
      }
    }
  }
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_fatcamma";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 20;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L111;
  }
L29: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L30: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], object_vars[0]);
L31: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L32: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L33: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L34: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L35: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L36: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L37: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L38: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L39: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[6];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object); 
      } 
    } 
  } 
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_fatcamma";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 22;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L111;
  }
L41: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L42: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_byte < 0) {
      BASIC_TYPE_ID_byte = env->get_basic_type_id(env, "byte");
      if (BASIC_TYPE_ID_byte < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found byte");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_byte;
    int32_t check_type_dimension = 1;
    void* object = object_vars[0];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_fatcamma";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 22;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L111;
  }
L44: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L45: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x78", 1));
L46: // STRING_EQ
  {
    void* object1 = object_vars[1];
    void* object2 = object_vars[2];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L47: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_fatcamma";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 22;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L111;
  }
L48: // BOOL_INT
  int_vars[0] = int_vars[0];
L49: // IF_NE_ZERO
  if (int_vars[0]) { goto L56; }
L50: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L51: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L52: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L53: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L54: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L111;
L55: // GOTO
  goto L56;
L56: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 7;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L57: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L58: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L59: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[6];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object); 
      } 
    } 
  } 
L60: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_fatcamma";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 26;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L111;
  }
L61: // CONVERT_INT_OBJECT_TO_INT
  {
    void* object = object_vars[0];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Can't convert undef value.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == (intptr_t)(void*)env->int_object_basic_type_id && object_type_dimension_id == 0) {
        SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
        
int_vars[5] = *(int32_t*)&fields[0];
      }
      else {
        void* exception = env->new_string_raw(env, "Can't convert imcompatible object type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L62: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_fatcamma";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 26;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L111;
  }
L63: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L64: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L65: // BOOL_INT
  int_vars[0] = int_vars[0];
L66: // IF_NE_ZERO
  if (int_vars[0]) { goto L71; }
L67: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L68: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L69: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L111;
L70: // GOTO
  goto L71;
L71: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 7;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L72: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L73: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L74: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[6];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object); 
      } 
    } 
  } 
L75: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_fatcamma";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 30;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L111;
  }
L76: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L77: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_byte < 0) {
      BASIC_TYPE_ID_byte = env->get_basic_type_id(env, "byte");
      if (BASIC_TYPE_ID_byte < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found byte");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_byte;
    int32_t check_type_dimension = 1;
    void* object = object_vars[0];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L78: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_fatcamma";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 30;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L111;
  }
L79: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L80: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x79", 1));
L81: // STRING_EQ
  {
    void* object1 = object_vars[1];
    void* object2 = object_vars[2];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L82: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_fatcamma";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 30;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L111;
  }
L83: // BOOL_INT
  int_vars[0] = int_vars[0];
L84: // IF_NE_ZERO
  if (int_vars[0]) { goto L91; }
L85: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L86: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L87: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L88: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L89: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L111;
L90: // GOTO
  goto L91;
L91: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 7;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L92: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L93: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L94: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[6];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object); 
      } 
    } 
  } 
L95: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_fatcamma";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 34;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L111;
  }
L96: // CONVERT_INT_OBJECT_TO_INT
  {
    void* object = object_vars[0];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Can't convert undef value.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == (intptr_t)(void*)env->int_object_basic_type_id && object_type_dimension_id == 0) {
        SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
        
int_vars[5] = *(int32_t*)&fields[0];
      }
      else {
        void* exception = env->new_string_raw(env, "Can't convert imcompatible object type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L97: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_fatcamma";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 34;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L111;
  }
L98: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L99: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L100: // BOOL_INT
  int_vars[0] = int_vars[0];
L101: // IF_NE_ZERO
  if (int_vars[0]) { goto L106; }
L102: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L103: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L104: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L111;
L105: // GOTO
  goto L106;
L106: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 7;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L107: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L108: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L111;
L109: // INIT_INT
  int_vars[6] = 0;
L110: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L111;
L111: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L112: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Array__array_init_float(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  float float_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_FLOAT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_float_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_float";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 223;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L50;
  }
L5: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 1.0;
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L7: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[0];
      } 
    } 
  } 
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_float";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 223;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L50;
  }
L9: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 2.0;
L10: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L11: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[1];
      } 
    } 
  } 
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_float";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 223;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L50;
  }
L13: // MOVE_CONSTANT_FLOAT
  float_vars[2] = 3.0;
L14: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L15: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[2];
      } 
    } 
  } 
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_float";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 223;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L50;
  }
L17: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L18: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L19: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L21: // ARRAY_FETCH_FLOAT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] = ((float*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L22: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_float";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 225;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L50;
  }
L23: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 1.0;
L24: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L46; }
L27: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L28: // ARRAY_FETCH_FLOAT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] = ((float*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_float";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 226;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L50;
  }
L30: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 2.0;
L31: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L32: // BOOL_INT
  int_vars[0] = int_vars[0];
L33: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L45; }
L34: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L35: // ARRAY_FETCH_FLOAT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] = ((float*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_float";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 227;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L50;
  }
L37: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 3.0;
L38: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L39: // BOOL_INT
  int_vars[0] = int_vars[0];
L40: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L44; }
L41: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L42: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L50;
L43: // GOTO
  goto L44;
L44: // GOTO
  goto L45;
L45: // GOTO
  goto L46;
L46: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L47: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L50;
L48: // INIT_INT
  int_vars[6] = 0;
L49: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L50;
L50: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L51: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Array__array_init_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[6] = {0};
  int32_t int_vars[19];
  int32_t exception_flag = 0;
  int32_t mortal_stack[9];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_int";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 183;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L141;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L7: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[2];
      } 
    } 
  } 
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_int";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 183;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L141;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L10: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L11: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[4];
      } 
    } 
  } 
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_int";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 183;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L141;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L14: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L15: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[6];
      } 
    } 
  } 
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_int";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 183;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L141;
  }
L17: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L18: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L19: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L20: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L21: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L22: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L23: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L24: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[2], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L25: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_int";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 185;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L141;
  }
L26: // MOVE_CONSTANT_INT
  int_vars[3] = 4;
L27: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L28: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[3];
      } 
    } 
  } 
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_int";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 185;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L141;
  }
L30: // MOVE_CONSTANT_INT
  int_vars[5] = 5;
L31: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L32: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[5];
      } 
    } 
  } 
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_int";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 185;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L141;
  }
L34: // MOVE_CONSTANT_INT
  int_vars[7] = 6;
L35: // MOVE_CONSTANT_INT
  int_vars[8] = 2;
L36: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[7];
      } 
    } 
  } 
L37: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_int";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 185;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L141;
  }
L38: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object_vars[2]);
L39: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L40: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L41: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L42: // NEW_MULTI_ARRAY
  {
    if (BASIC_TYPE_ID_int < 0) {
      BASIC_TYPE_ID_int = env->get_basic_type_id(env, "int");
      if (BASIC_TYPE_ID_int < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_int;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_muldim_array_raw(env, basic_type_id, 1, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[2], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_int";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 188;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L141;
  }
L44: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L45: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L46: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[3];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[3], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L47: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_int";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 188;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L141;
  }
L48: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L49: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L50: // ARRAY_STORE_INT
  {
    void* array = object_vars[3];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[4];
      } 
    } 
  } 
L51: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_int";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 188;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L141;
  }
L52: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L53: // MOVE_CONSTANT_INT
  int_vars[7] = 1;
L54: // ARRAY_STORE_INT
  {
    void* array = object_vars[3];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[6];
      } 
    } 
  } 
L55: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_int";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 188;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L141;
  }
L56: // MOVE_CONSTANT_INT
  int_vars[8] = 3;
L57: // MOVE_CONSTANT_INT
  int_vars[9] = 2;
L58: // ARRAY_STORE_INT
  {
    void* array = object_vars[3];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[8];
      } 
    } 
  } 
L59: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_int";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 188;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L141;
  }
L60: // MOVE_CONSTANT_INT
  int_vars[10] = 0;
L61: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[10];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L62: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_int";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 188;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L141;
  }
L63: // MOVE_CONSTANT_INT
  int_vars[11] = 3;
L64: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L65: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[11];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[4], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L66: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_int";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 189;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L141;
  }
L67: // MOVE_CONSTANT_INT
  int_vars[12] = 4;
L68: // MOVE_CONSTANT_INT
  int_vars[13] = 0;
L69: // ARRAY_STORE_INT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[13];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[12];
      } 
    } 
  } 
L70: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_int";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 189;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L141;
  }
L71: // MOVE_CONSTANT_INT
  int_vars[14] = 5;
L72: // MOVE_CONSTANT_INT
  int_vars[15] = 1;
L73: // ARRAY_STORE_INT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[15];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[14];
      } 
    } 
  } 
L74: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_int";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 189;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L141;
  }
L75: // MOVE_CONSTANT_INT
  int_vars[16] = 6;
L76: // MOVE_CONSTANT_INT
  int_vars[17] = 2;
L77: // ARRAY_STORE_INT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[17];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[16];
      } 
    } 
  } 
L78: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_int";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 189;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L141;
  }
L79: // MOVE_CONSTANT_INT
  int_vars[18] = 1;
L80: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[18];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[4]
        );
      }
    }
  }
L81: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_int";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 188;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L141;
  }
L82: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L83: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], object_vars[2]);
L84: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L85: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L86: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L87: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L88: // ARRAY_FETCH_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[3] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L89: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_int";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 192;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L141;
  }
L90: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L91: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L92: // BOOL_INT
  int_vars[0] = int_vars[0];
L93: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L137; }
L94: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L95: // ARRAY_FETCH_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[3] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L96: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_int";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 193;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L141;
  }
L97: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L98: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L99: // BOOL_INT
  int_vars[0] = int_vars[0];
L100: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L136; }
L101: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L102: // ARRAY_FETCH_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[3] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L103: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_int";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 194;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L141;
  }
L104: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L105: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L106: // BOOL_INT
  int_vars[0] = int_vars[0];
L107: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L135; }
L108: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L109: // ARRAY_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[3] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L110: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_int";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 195;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L141;
  }
L111: // MOVE_CONSTANT_INT
  int_vars[4] = 4;
L112: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L113: // BOOL_INT
  int_vars[0] = int_vars[0];
L114: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L134; }
L115: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L116: // ARRAY_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[3] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L117: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_int";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 196;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L141;
  }
L118: // MOVE_CONSTANT_INT
  int_vars[4] = 5;
L119: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L120: // BOOL_INT
  int_vars[0] = int_vars[0];
L121: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L133; }
L122: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L123: // ARRAY_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[3] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L124: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_int";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 197;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L141;
  }
L125: // MOVE_CONSTANT_INT
  int_vars[4] = 6;
L126: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L127: // BOOL_INT
  int_vars[0] = int_vars[0];
L128: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L132; }
L129: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L130: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L141;
L131: // GOTO
  goto L132;
L132: // GOTO
  goto L133;
L133: // GOTO
  goto L134;
L134: // GOTO
  goto L135;
L135: // GOTO
  goto L136;
L136: // GOTO
  goto L137;
L137: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L138: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L141;
L139: // INIT_INT
  int_vars[6] = 0;
L140: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L141;
L141: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L142: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Array__array_init_long(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int64_t long_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_LONG_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_long_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_long";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 211;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L50;
  }
L5: // MOVE_CONSTANT_LONG
  long_vars[0] = 1LL;
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L7: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[0];
      } 
    } 
  } 
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_long";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 211;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L50;
  }
L9: // MOVE_CONSTANT_LONG
  long_vars[1] = 2LL;
L10: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L11: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[1];
      } 
    } 
  } 
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_long";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 211;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L50;
  }
L13: // MOVE_CONSTANT_LONG
  long_vars[2] = 3LL;
L14: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L15: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[2];
      } 
    } 
  } 
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_long";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 211;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L50;
  }
L17: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L18: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L19: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L21: // ARRAY_FETCH_LONG
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] = ((int64_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L22: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_long";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 213;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L50;
  }
L23: // MOVE_CONSTANT_LONG
  long_vars[1] = 1LL;
L24: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L46; }
L27: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L28: // ARRAY_FETCH_LONG
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] = ((int64_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_long";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 214;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L50;
  }
L30: // MOVE_CONSTANT_LONG
  long_vars[1] = 2LL;
L31: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L32: // BOOL_INT
  int_vars[0] = int_vars[0];
L33: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L45; }
L34: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L35: // ARRAY_FETCH_LONG
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] = ((int64_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_long";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 215;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L50;
  }
L37: // MOVE_CONSTANT_LONG
  long_vars[1] = 3LL;
L38: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L39: // BOOL_INT
  int_vars[0] = int_vars[0];
L40: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L44; }
L41: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L42: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L50;
L43: // GOTO
  goto L44;
L44: // GOTO
  goto L45;
L45: // GOTO
  goto L46;
L46: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L47: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L50;
L48: // INIT_INT
  int_vars[6] = 0;
L49: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L50;
L50: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L51: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Array__array_init_object(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[5] = {0};
  int32_t int_vars[10];
  int32_t exception_flag = 0;
  int32_t mortal_stack[6];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 2;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_object";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 322;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L38;
  }
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L6: // CALL_SUB_OBJECT
  // TestCase::Minimal->new
  {
    if (SUB_ID_TestCase__Minimal__new < 0) {
      SUB_ID_TestCase__Minimal__new = env->get_sub_id(env, "TestCase::Minimal", "new", "TestCase::Minimal()");
      if (SUB_ID_TestCase__Minimal__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_object";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 322;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L38;
  }
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L9: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_object";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 322;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L38;
  }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L12: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_object";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 322;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L38;
  }
L14: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L15: // CALL_SUB_OBJECT
  // TestCase::Minimal->new
  {
    if (SUB_ID_TestCase__Minimal__new < 0) {
      SUB_ID_TestCase__Minimal__new = env->get_sub_id(env, "TestCase::Minimal", "new", "TestCase::Minimal()");
      if (SUB_ID_TestCase__Minimal__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], stack[0].oval);
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_object";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 322;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L38;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L18: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_object";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 322;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L38;
  }
L20: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L21: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], object_vars[0]);
L22: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L23: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L24: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L25: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L26: // IS_TYPE
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_object;
    int32_t check_type_dimension = 1;
    void* object = object_vars[4];
    if (object) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
int_vars[0]      = env->is_type(env, object, check_basic_type_id, check_type_dimension);
    }
    else {
int_vars[0]      = 0;
    }
  }
L27: // BOOL_INT
  int_vars[0] = int_vars[0];
L28: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L32; }
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L30: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L38;
L31: // GOTO
  goto L34;
L32: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L38;
L34: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L35: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L38;
L36: // INIT_INT
  int_vars[8] = 0;
L37: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[8];
  goto L38;
L38: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L39: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Array__array_init_short(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[3];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_SHORT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_short_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_short";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 171;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L62;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[2];
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L8: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[0];
      } 
    } 
  } 
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_short";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 171;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L62;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L11: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[4];
L12: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L13: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[1];
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_short";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 171;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L62;
  }
L15: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L16: // CONVERT_INT_TO_SHORT
  short_vars[2] = (int16_t)int_vars[6];
L17: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L18: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[2];
      } 
    } 
  } 
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_short";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 171;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L62;
  }
L20: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L21: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L22: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L23: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L24: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L25: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_short";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 173;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L62;
  }
L26: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L27: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L28: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[4];
L29: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[1];
L30: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[5]);
L31: // BOOL_INT
  int_vars[0] = int_vars[0];
L32: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L58; }
L33: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L34: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_short";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 174;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L62;
  }
L36: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L37: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L38: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[4];
L39: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[1];
L40: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[5]);
L41: // BOOL_INT
  int_vars[0] = int_vars[0];
L42: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L57; }
L43: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L44: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L45: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_init_short";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 175;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L62;
  }
L46: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L47: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L48: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[4];
L49: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[1];
L50: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[5]);
L51: // BOOL_INT
  int_vars[0] = int_vars[0];
L52: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L56; }
L53: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L54: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L62;
L55: // GOTO
  goto L56;
L56: // GOTO
  goto L57;
L57: // GOTO
  goto L58;
L58: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L59: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L62;
L60: // INIT_INT
  int_vars[6] = 0;
L61: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L62;
L62: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L63: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Array__array_length_atmark(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_length_atmark";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 55;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L18;
  }
L5: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[2] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_length_atmark";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 56;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L18;
  }
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L8: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L14; }
L11: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L18;
L13: // GOTO
  goto L14;
L14: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L18;
L16: // INIT_INT
  int_vars[7] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L18;
L18: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L19: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Array__array_length_atmark_brace(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_length_atmark_brace";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 67;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L18;
  }
L5: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[2] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_length_atmark_brace";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 68;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L18;
  }
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L8: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L14; }
L11: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L18;
L13: // GOTO
  goto L14;
L14: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L18;
L16: // INIT_INT
  int_vars[7] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L18;
L18: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L19: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Array__array_length_scalar_atmark(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_length_scalar_atmark";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 79;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L18;
  }
L5: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[2] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_length_scalar_atmark";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 80;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L18;
  }
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L8: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L14; }
L11: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L18;
L13: // GOTO
  goto L14;
L14: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L18;
L16: // INIT_INT
  int_vars[7] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L18;
L18: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L19: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Array__array_length_scalar_atmark_brace(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_length_scalar_atmark_brace";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 91;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L18;
  }
L5: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[2] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_length_scalar_atmark_brace";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 92;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L18;
  }
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L8: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L14; }
L11: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L18;
L13: // GOTO
  goto L14;
L14: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L18;
L16: // INIT_INT
  int_vars[7] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L18;
L18: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L19: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Array__array_length_undef(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L3: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L4: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[2] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L5: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_length_undef";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 105;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L6;
  }
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L7: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->get_exception(env));
L8: // BOOL_OBJECT
  int_vars[0] = !!object_vars[1];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L14; }
L10: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L19;
L13: // GOTO
  goto L14;
L14: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L15: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L19;
L17: // INIT_INT
  int_vars[6] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L19;
L19: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L20: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Array__array_set_and_get_array_element_first(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[7];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_set_and_get_array_element_first";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 129;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L15;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 345;
L6: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L7: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[2];
      } 
    } 
  } 
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_set_and_get_array_element_first";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 130;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L15;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L10: // ARRAY_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[3] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_set_and_get_array_element_first";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 132;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L15;
  }
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L15;
L13: // INIT_INT
  int_vars[5] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L15;
L15: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L16: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Array__array_set_and_get_array_element_last(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[7];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_set_and_get_array_element_last";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 137;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L15;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 298;
L6: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L7: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[2];
      } 
    } 
  } 
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_set_and_get_array_element_last";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 138;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L15;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L10: // ARRAY_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[3] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_set_and_get_array_element_last";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 140;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L15;
  }
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L15;
L13: // INIT_INT
  int_vars[5] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L15;
L15: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L16: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Array__array_store_undef(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[4];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
      BASIC_TYPE_ID_TestCase__Minimal = env->get_basic_type_id(env, "TestCase::Minimal");
      if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Minimal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Minimal;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_store_undef";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 42;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L31;
  }
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L6: // CALL_SUB_OBJECT
  // TestCase::Minimal->new
  {
    if (SUB_ID_TestCase__Minimal__new < 0) {
      SUB_ID_TestCase__Minimal__new = env->get_sub_id(env, "TestCase::Minimal", "new", "TestCase::Minimal()");
      if (SUB_ID_TestCase__Minimal__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_store_undef";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 43;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L31;
  }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L9: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_store_undef";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 43;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L31;
  }
L11: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L12: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L13: // ARRAY_STORE_UNDEF
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(object_vars[0] == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(int_vars[2] < 0 || int_vars[2]  >= *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else {
        void* object_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          object_address,
          NULL        );
      }
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_store_undef";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 44;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L31;
  }
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L16: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L17: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Array";
    const char* sub_name = "array_store_undef";
    const char* file = "TestCase/Array.spvm";
    int32_t line = 46;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L31;
  }
L19: // IS_UNDEF
  int_vars[0] = object_vars[1] == NULL;
L20: // BOOL_INT
  int_vars[0] = int_vars[0];
L21: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L26; }
L22: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L23: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L31;
L25: // GOTO
  goto L26;
L26: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L27: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L28: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L31;
L29: // INIT_INT
  int_vars[6] = 0;
L30: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L31;
L31: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L32: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


