# This file was autogenerated.
use 5.008008;
use strict;
use warnings;
no warnings qw( void once );
use Hydrogen ();

package Hydrogen::Counter;

our $AUTHORITY = 'cpan:TOBYINK';
our $VERSION   = '0.007';

=head1 NAME

Hydrogen::Counter - a standard library for integer counters

=head1 VERSION

This documentation is for Hydrogen::Counter 0.007.

=cut

=head1 FUNCTIONS

Each function expects an integer as its first argument.

=cut

use Exporter::Shiny qw(
    dec
    inc
    reset
    set
);

=head2 C<< dec( $counter, $amount? ) >>

Additional arguments: B<< Optional[Int] >>.

Decrements the counter by C<< $amount >>, or by 1 if no value is given.

=cut

{
    my $__signature;

    sub dec {
        my $__REF__ = \$_[0];

        package Hydrogen::Counter::__SANDBOX__;
        $__signature ||= sub {
            my ( %tmp, $tmp );

            @_ >= 1 && @_ <= 2
              or Hydrogen::croak(
                "Wrong number of parameters in signature for %s: got %d, %s",
                "dec", scalar(@_), "expected exactly 1 parameters" );

            # Parameter $_[0] (type: Int)
            (
                do {
                    my $tmp = $_[0];
                    defined($tmp) and !ref($tmp) and $tmp =~ /\A-?[0-9]+\z/;
                }
              )
              or Hydrogen::croak(
                "Type check failed in signature for dec: %s should be %s",
                "\$_[0]", "Int" );

            # Parameter $_[1] (type: Optional[Int])
            $#_ >= 1
              or return (@_);
            (
                do {
                    my $tmp = $_[1];
                    defined($tmp) and !ref($tmp) and $tmp =~ /\A-?[0-9]+\z/;
                }
              )
              or Hydrogen::croak(
                "Type check failed in signature for dec: %s should be %s",
                "\$_[1]", "Optional[Int]" );

            (@_);
        };
        @_ = &$__signature;
        (
            ${$__REF__} = do {
                my $shv_final_unchecked =
                  $$__REF__ - ( ( @_ - 1 ) ? $_[1] : 1 );
                do {
                    (
                        do {
                            my $tmp = $shv_final_unchecked;
                            defined($tmp)
                              and !ref($tmp)
                              and $tmp =~ /\A-?[0-9]+\z/;
                        }
                      )
                      or Hydrogen::croak(
                        "Type check failed for dec: expected %s, got value %s",
                        "Int", $shv_final_unchecked
                      );
                    $shv_final_unchecked;
                };
            }
        );
    }
}

=head2 C<< inc( $counter, $amount? ) >>

Additional arguments: B<< Optional[Int] >>.

Increments the counter by C<< $amount >>, or by 1 if no value is given.

=cut

{
    my $__signature;

    sub inc {
        my $__REF__ = \$_[0];

        package Hydrogen::Counter::__SANDBOX__;
        $__signature ||= sub {
            my ( %tmp, $tmp );

            @_ >= 1 && @_ <= 2
              or Hydrogen::croak(
                "Wrong number of parameters in signature for %s: got %d, %s",
                "inc", scalar(@_), "expected exactly 1 parameters" );

            # Parameter $_[0] (type: Int)
            (
                do {
                    my $tmp = $_[0];
                    defined($tmp) and !ref($tmp) and $tmp =~ /\A-?[0-9]+\z/;
                }
              )
              or Hydrogen::croak(
                "Type check failed in signature for inc: %s should be %s",
                "\$_[0]", "Int" );

            # Parameter $_[1] (type: Optional[Int])
            $#_ >= 1
              or return (@_);
            (
                do {
                    my $tmp = $_[1];
                    defined($tmp) and !ref($tmp) and $tmp =~ /\A-?[0-9]+\z/;
                }
              )
              or Hydrogen::croak(
                "Type check failed in signature for inc: %s should be %s",
                "\$_[1]", "Optional[Int]" );

            (@_);
        };
        @_ = &$__signature;
        (
            ${$__REF__} = do {
                my $shv_final_unchecked =
                  $$__REF__ + ( ( @_ - 1 ) ? $_[1] : 1 );
                do {
                    (
                        do {
                            my $tmp = $shv_final_unchecked;
                            defined($tmp)
                              and !ref($tmp)
                              and $tmp =~ /\A-?[0-9]+\z/;
                        }
                      )
                      or Hydrogen::croak(
                        "Type check failed for inc: expected %s, got value %s",
                        "Int", $shv_final_unchecked
                      );
                    $shv_final_unchecked;
                };
            }
        );
    }
}

=head2 C<< reset( $counter ) >>

Sets the counter to its default value, or 0 if it has no default.

=cut

sub reset {
    my $__REF__ = \$_[0];

    package Hydrogen::Counter::__SANDBOX__;
    @_ == 1
      or Hydrogen::croak( "Wrong number of parameters for reset; usage: "
          . "Hydrogen::Counter::reset( \$counter )" );
    (
        ${$__REF__} = do {
            my $shv_final_unchecked = 0;
            do {
                (
                    do {
                        my $tmp = $shv_final_unchecked;
                        defined($tmp) and !ref($tmp) and $tmp =~ /\A-?[0-9]+\z/;
                    }
                  )
                  or Hydrogen::croak(
                    "Type check failed for reset: expected %s, got value %s",
                    "Int", $shv_final_unchecked );
                $shv_final_unchecked;
            };
        }
    );
}

=head2 C<< set( $counter, $value ) >>

Additional arguments: B<< Int >>.

Sets the counter to the given value.

=cut

sub set {
    my $__REF__ = \$_[0];

    package Hydrogen::Counter::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 2
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "set", scalar(@_), "expected exactly 2 parameters" );

        # Parameter $_[0] (type: Int)
        (
            do {
                my $tmp = $_[0];
                defined($tmp) and !ref($tmp) and $tmp =~ /\A-?[0-9]+\z/;
            }
          )
          or Hydrogen::croak(
            "Type check failed in signature for set: %s should be %s",
            "\$_[0]", "Int" );

        # Parameter $_[1] (type: Int)
        (
            do {
                my $tmp = $_[1];
                defined($tmp) and !ref($tmp) and $tmp =~ /\A-?[0-9]+\z/;
            }
          )
          or Hydrogen::croak(
            "Type check failed in signature for set: %s should be %s",
            "\$_[1]", "Int" );

        (@_);
    };
    (
        ${$__REF__} = do {
            my $shv_final_unchecked = $_[1];
            do {
                (
                    do {
                        my $tmp = $shv_final_unchecked;
                        defined($tmp) and !ref($tmp) and $tmp =~ /\A-?[0-9]+\z/;
                    }
                  )
                  or Hydrogen::croak(
                    "Type check failed for set: expected %s, got value %s",
                    "Int", $shv_final_unchecked );
                $shv_final_unchecked;
            };
        }
    );
}

1;

=head1 EXPORT

No functions are exported by this module by default. To import them all
(this is usually a bad idea), use:

    use Hydrogen::Counter -all;

To import a particular function, use:

    use Hydrogen::Counter 'reset';

To rename functions:

    use Hydrogen::Counter 'reset' => { -as => 'myfunc' };

See L<Exporter::Tiny::Manual::Importing> for more hints on importing.

=head1 BUGS

Please report any bugs to
L<http://github.com/tobyink/p5-hydrogen/issues>.

=head1 SEE ALSO

L<Hydrogen>,
L<Hydrogen::Curry::Counter>,
L<Sub::HandlesVia::HandlerLibrary::Counter>.

=head1 AUTHOR

Toby Inkster E<lt>tobyink@cpan.orgE<gt>.

=head1 COPYRIGHT AND LICENCE

This software is copyright (c) 2022 by Toby Inkster.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 DISCLAIMER OF WARRANTIES

THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.


