package Chart::Plotly::Trace::Surface::Contours::X;
use Moose;
use MooseX::ExtraArgs;
use Moose::Util::TypeConstraints qw(enum union);
if ( !defined Moose::Util::TypeConstraints::find_type_constraint('PDL') ) {
    Moose::Util::TypeConstraints::type('PDL');
}

use Chart::Plotly::Trace::Surface::Contours::X::Project;

our $VERSION = '0.015';    # VERSION

sub TO_JSON {
    my $self       = shift;
    my $extra_args = $self->extra_args // {};
    my $meta       = $self->meta;
    my %hash       = %$self;
    for my $name ( sort keys %hash ) {
        my $attr = $meta->get_attribute($name);
        if ( defined $attr ) {
            my $value = $hash{$name};
            my $type  = $attr->type_constraint;
            if ( $type && $type->equals('Bool') ) {
                $hash{$name} = $value ? \1 : \0;
            }
        }
    }
    %hash = ( %hash, %$extra_args );
    delete $hash{'extra_args'};
    if ( $self->can('type') && ( !defined $hash{'type'} ) ) {
        $hash{type} = $self->type();
    }
    return \%hash;
}

has color => ( is            => "rw",
               documentation => "Sets the color of the contour lines.", );

has highlight => (
             is            => "rw",
             isa           => "Bool",
             documentation => "Determines whether or not contour lines about the x dimension are highlighted on hover.",
);

has highlightcolor => ( is            => "rw",
                        documentation => "Sets the color of the highlighted contour lines.", );

has highlightwidth => ( is            => "rw",
                        isa           => "Num",
                        documentation => "Sets the width of the highlighted contour lines.",
);

has project => ( is  => "rw",
                 isa => "Maybe[HashRef]|Chart::Plotly::Trace::Surface::Contours::X::Project", );

has show => ( is            => "rw",
              isa           => "Bool",
              documentation => "Determines whether or not contour lines about the x dimension are drawn.",
);

has usecolormap => (
     is  => "rw",
     isa => "Bool",
     documentation =>
       "An alternate to *color*. Determines whether or not the contour lines are colored using the trace *colorscale*.",
);

has width => ( is            => "rw",
               isa           => "Num",
               documentation => "Sets the width of the contour lines.",
);

__PACKAGE__->meta->make_immutable();
1;

__END__

=pod

=encoding utf-8

=head1 NAME

Chart::Plotly::Trace::Surface::Contours::X

=head1 VERSION

version 0.015

=head1 SYNOPSIS

 use Chart::Plotly qw(show_plot);
 use Chart::Plotly::Trace::Surface;
 use English qw(-no_match_vars);
 
 my $surface = Chart::Plotly::Trace::Surface->new(
     x => [ 0 .. 10 ],
     y => [ 0 .. 10 ],
     z => [
         map {
             my $y = $ARG;
             [ map { $ARG - $y * $y } ( 0 .. 10 ) ]
         } ( 0 .. 10 )
     ]
 );
 
 show_plot( [$surface] );

=head1 DESCRIPTION

This attribute is part of the possible options for the trace surface.

This file has been autogenerated from the official plotly.js source.

If you like Plotly, please support them: L<https://plot.ly/> 
Open source announcement: L<https://plot.ly/javascript/open-source-announcement/>

Full reference: L<https://plot.ly/javascript/reference/#surface>

=head1 NAME 

Chart::Plotly::Trace::Surface::Contours::X

=head1 DISCLAIMER

This is an unofficial Plotly Perl module. Currently I'm not affiliated in any way with Plotly. 
But I think plotly.js is a great library and I want to use it with perl.

=head1 METHODS

=head2 TO_JSON

Serialize the trace to JSON. This method should be called only by L<JSON> serializer.

=head1 ATTRIBUTES

=over

=item * color

Sets the color of the contour lines.

=item * highlight

Determines whether or not contour lines about the x dimension are highlighted on hover.

=item * highlightcolor

Sets the color of the highlighted contour lines.

=item * highlightwidth

Sets the width of the highlighted contour lines.

=item * project

=item * show

Determines whether or not contour lines about the x dimension are drawn.

=item * usecolormap

An alternate to *color*. Determines whether or not the contour lines are colored using the trace *colorscale*.

=item * width

Sets the width of the contour lines.

=back

=head1 AUTHOR

Pablo Rodríguez González <pablo.rodriguez.gonzalez@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2017 by Pablo Rodríguez González.

This is free software, licensed under:

  The MIT (X11) License

=cut
