#! /usr/bin/perl -w

use strict;
use warnings;
use Test::More;
use Time::Zone::Olson();
use English qw( -no_match_vars );

# sourced from https://metacpan.org/release/DOLMEN/DateTime-TimeZone-HPUX-1.04/source/inc/DefaultMap.pm

my %guessed_hpux_olson_map = (
    'Africa/Johannesburg'  => [ 'SAST-2' ],
    'America/Adak'  => [ 'AST10ADT' ],
    'America/Anchorage'  => [ 'YST9YDT' ],
    'America/Cayenne'  => [ 'GFT3' ],
    'America/Chicago'  => [ 'CST6CDT' ],
    'America/Chihuahua'  => [ 'MSM7MDM' ],
    'America/Chihuahua'  => [ 'MST7MDT#Mexico' ],
    'America/Denver'  => [ 'MST7MDT' ],
    'America/Edmonton'  => [ 'MST7MDT#Canada' ],
    'America/Goose_Bay'  => [ 'AST4ADT#Canada' ],
    'America/Guadeloupe'  => [ 'AST4' ],
    'America/Halifax'  => [ 'AST4ADT' ],
    'America/Indianapolis'  => [ 'CST6CDT#Indiana', 'EST5CDT', 'EST5EDT#Indiana', 'EST5EST', 'EST6CDT' ],
    'America/Los_Angeles'  => [ 'PST8PDT' ],
    'America/Mexico_City'  => [ 'CSM6CDM', 'CST6CDT#Mexico', 'MXST6MXDT', 'MXST6MXDT#Mexico' ],
    'America/Miquelon'  => [ 'PMST3PMDT' ],
    'America/Montreal'  => [ 'EST5EDT#Canada' ],
    'America/New_York'  => [ 'EST5EDT' ],
    'America/St_Johns'  => [ 'NST3:30NDT', 'NST3:30NDT#Canada' ],
    'America/Tijuana'  => [ 'PSM8PDM', 'PST8PDT#Mexico' ],
    'America/Vancouver'  => [ 'PST8PDT#Canada' ],
    'America/Winnipeg'  => [ 'CST6CDT#Canada' ],
    'Asia/Irkutsk'  => [ 'WST-8WSTDST' ],
    'Asia/Kamchatka'  => [ 'WST-12WSTDST' ],
    'Asia/Krasnoyarsk'  => [ 'WST-7WSTDST' ],
    'Asia/Magadan'  => [ 'WST-11WSTDST' ],
    'Asia/Novosibirsk'  => [ 'WST-6WSTDST' ],
    'Asia/Singapore'  => [ 'PST-8PDT' ],
    'Asia/Vladivostok'  => [ 'WST-10WSTDST' ],
    'Asia/Yakutsk'  => [ 'WST-9WSTDST' ],
    'Asia/Yekaterinburg'  => [ 'WST-5WSTDST' ],
    'Australia/Adelaide'  => [ 'CST-9:30CDT' ],
    'Australia/Hobart'  => [ 'EST-10EDT#Tasmania' ],
    'Australia/Perth'  => [ 'WST-8WDT' ],
    'Australia/Sydney'  => [ 'EST-10EDT', 'EST-10EDT#NSW' ],
    'Australia/Melbourne'  => [ 'EST-10EDT#VIC' ],
    'Europe/Berlin'  => [ 'MEZ-1MESZ' ],
    'Europe/Helsinki'  => [ 'EET-2EETDST' ],
    'Europe/Lisbon'  => [ 'PWT0PST' ],
    'Europe/London'  => [ 'GMT0BST', 'WET0WETDST' ],
    'Europe/Minsk'  => [ 'WST-2WSTDST' ],
    'Europe/Moscow'  => [ 'WST-3WSTDST' ],
    'Europe/Paris'  => [ 'MET-1METDST' ],
    'Europe/Samara'  => [ 'WST-4WSTDST' ],
    'Indian/Mayotte'  => [ 'EAT-3' ],
    'Indian/Reunion'  => [ 'RET-4' ],
    'Pacific/Auckland'  => [ 'NZST-12NZDT' ],
    'Pacific/Gambier'  => [ 'GAMT-9' ],
    'Pacific/Marquesas'  => [ 'MART-9:30' ],
    'Pacific/Noumea'  => [ 'NCT-11' ],
    'Pacific/Tahiti'  => [ 'TAHT10' ],
);

sub _determine_week_number {
	my ($week_day, $day, $month, $year) = @_;
	$year += 1900;
	$month += 1;
	my $week_number = 5; # last week
	if ($week_day == 0) {
		$week_day = 7;
	}
	my $day_number = $day - $week_day;
	if ($day_number < 1) {
		$week_number = 1;
	} else {
		$week_number = 1 + (int($day_number / 7));
		if ($week_number == 4) {
			$week_number = 5;
		}
	}
#	warn "Weekday $week_day and day of month $day/$month gives week $week_number for $year with day number $day_number";
	return $week_number;
}

if ($^O ne 'hpux') {
	my $timezone = Time::Zone::Olson->new( timezone => 'America/New_York' );
				my $definition = $timezone->tz_definition();
	warn $definition;
	warn `cat ./t/data/tztab`;
	my ($seconds, $minute, $hour, $day, $month, $year, $week_day, $yday, $isdst);
	my $tztab = {};
	my $offset;
	if (1) {
	my $dst_start_year;
	my ($previous_dst_low_day, $previous_dst_high_day);
	my ($previous_dst_abbr, $previous_dst_offset);
	my ($previous_dst_seconds, $previous_dst_minute, $previous_dst_hour, $previous_dst_day, $previous_dst_month, $previous_dst_year, $previous_dst_week_day, $previous_dst_week_number);
	my ($dst_seconds, $dst_minute, $dst_hour, $dst_day, $dst_month, $dst_year, $dst_week_day, $dst_yday, $dst_isdst);
	my ($dst_abbr, $dst_offset);
	foreach my $time ($timezone->transition_times()) {
		($seconds, $minute, $hour, $day, $month, $year, $week_day, $yday, $isdst) = $timezone->local_time($time);
		if ($isdst) {
			($dst_seconds, $dst_minute, $dst_hour, $dst_day, $dst_month, $dst_year, $dst_week_day, $dst_yday, $dst_isdst) = ($seconds, $minute, $hour, $day, $month, $year, $week_day, $yday, $isdst);
			my $dst_week_number = _determine_week_number($dst_week_day, $dst_day, $dst_month, $dst_year);
			$dst_offset = $timezone->local_offset($time);
			$dst_offset /= 60;
			$dst_month += 1;
			$dst_abbr = $timezone->local_abbr($time);
			$dst_offset *= -1;
			$dst_year += 1900;
			if (defined $previous_dst_year) {
				if (($previous_dst_seconds == $dst_seconds) && ($previous_dst_minute == $dst_minute) && ($previous_dst_hour == $dst_hour) && ($previous_dst_week_number == $dst_week_number) && ($previous_dst_week_day == $dst_week_day) && ($previous_dst_month == $dst_month)) {
				} else {
					if (defined $dst_start_year) {
						if ($dst_start_year == $previous_dst_year) {
							warn "$previous_dst_minute $previous_dst_hour $previous_dst_high_day $previous_dst_month $previous_dst_year $previous_dst_week_day $previous_dst_abbr$previous_dst_offset";
						} else {
							warn "$previous_dst_minute $previous_dst_hour $previous_dst_low_day-$previous_dst_high_day $previous_dst_month $dst_start_year-$previous_dst_year $previous_dst_week_day $previous_dst_abbr$previous_dst_offset";
						}
					} else {
						warn "$previous_dst_minute $previous_dst_hour $previous_dst_low_day-$previous_dst_high_day $previous_dst_month $previous_dst_year $previous_dst_week_day $previous_dst_abbr$previous_dst_offset";
					}
					$dst_start_year = $dst_year;
					$previous_dst_low_day = undef;
					$previous_dst_high_day = undef;
				}
			} else {
				if (defined $previous_dst_year) {
					$dst_start_year = $previous_dst_year;
				} else {
					$dst_start_year = $dst_year;
				}
			}
			if ((defined $previous_dst_low_day) && ($previous_dst_low_day < $dst_day)) {
			} else {
				$previous_dst_low_day = $dst_day;
			}
			if ((defined $previous_dst_high_day) && ($previous_dst_high_day > $dst_day)) {
			} else {
				$previous_dst_high_day = $dst_day;
			}
			$previous_dst_year = $dst_year;
			($previous_dst_seconds, $previous_dst_minute, $previous_dst_hour, $previous_dst_day, $previous_dst_month, $previous_dst_week_day) = ($dst_seconds, $dst_minute, $dst_hour, $dst_day, $dst_month, $dst_week_day);
			$previous_dst_abbr = $dst_abbr;
			$previous_dst_offset = $dst_offset;
			$previous_dst_week_number = $dst_week_number;
# warn "$dst_week_day on $dst_day / $dst_month / $dst_year for week number $dst_week_number";
		}
	}
					if (defined $dst_start_year) {
						warn "$dst_minute $dst_hour $dst_month $dst_start_year-$dst_year $dst_week_day $dst_abbr$dst_offset";
					} else {
						warn "$dst_minute $dst_hour $dst_month $dst_year $dst_week_day $dst_abbr$dst_offset";
					}
	} else {
	foreach my $time ($timezone->transition_times()) {
		($seconds, $minute, $hour, $day, $month, $year, $week_day, $yday, $isdst) = $timezone->local_time($time);
			$offset = $timezone->local_offset($time);
			$offset /= 60;
		my $abbr = $timezone->local_abbr($time);
		$offset *= -1;
		$year += 1900;
		$tztab->{$offset}->{$abbr}->{$month}->{$week_day}->{$hour}->{$minute} ||= {};
		my $data = $tztab->{$offset}->{$abbr}->{$month}->{$week_day}->{$hour}->{$minute};
		$data->{low_year} ||= $year;
		$data->{high_year} = $year;
		if (defined $data->{offset}) {
			if ($data->{offset} != $offset) {
				die "Whoops";
			}
		} else {
			$data->{offset} = $offset;
		}
		if ((defined $data->{low_day}) && ($data->{low_day} < $day)) {
		} else {
			$data->{low_day} = $day;
		}
		if ((defined $data->{high_day}) && ($data->{high_day} > $day)) {
		} else {
			$data->{high_day} = $day;
		}
	}
	use Data::Dumper;
	print Dumper($tztab);
	foreach my $offset (sort { $a <=> $b } keys %{$tztab}) {
		foreach my $abbr (sort { $a cmp $b } keys %{$tztab->{$offset}}) {
			foreach my $month (sort { $a <=> $b } keys %{$tztab->{$offset}->{$abbr}}) {
			}
		}
	}
	}
}
if (0) {
	my $timezone = Time::Zone::Olson->new( timezone => 'America/New_York' );
	foreach my $area ($timezone->areas()) {
		foreach my $location ($timezone->locations($area)) {
			$timezone->timezone("$area/$location");
			if (defined $guessed_hpux_olson_map{"$area/$location"}) {
				my $definition = $timezone->tz_definition();
				if ($definition =~ /^([^,]+),/smx) {
					my ($name) = ($1);
					my $matched = 0;
					foreach my $hpux_name (@{$guessed_hpux_olson_map{"$area/$location"}}) {
						if ($name eq $hpux_name) {
							$matched = 1;
						}
					}
					if ($matched) {
#						warn "MATCHED:$name";
					} else {
						warn "MISSED:$name for $area/$location for $definition";
					}
				}
			}
		}
	}
}
#die "Here";

my $now = time;
my $timezone = Time::Zone::Olson->new( timezone => 'America/New_York' );
my @test_localtime = $timezone->local_time($now);
use Data::Dumper;
print STDERR Dumper($timezone->tz_definition());
$ENV{TZDIR} = './t/data';
$^O = 'hpux';
$timezone = Time::Zone::Olson->new( timezone => 'America/New_York' );
use Data::Dumper;
print STDERR Dumper($timezone);
@test_localtime = $timezone->local_time($now);

Test::More::done_testing();
