package Firefox::Marionette::Extension::HarExportTrigger;

use strict;
use warnings;

our $VERSION = '0.93';

sub as_string {
    return <<'_BASE64_';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=
_BASE64_
}

1;    # Magic true value required at end of module
__END__

=head1 NAME

Firefox::Marionette::Extension::HarExportTrigger - Contains the HAR Export Trigger extension

=head1 VERSION

Version 0.93

=head1 SYNOPSIS

    use Firefox::Marionette();
    use v5.10;

    my $firefox = Firefox::Marionette->new(har => 1, debug => 1);
    $firefox->go("https://fastapi.metacpan.org/v1/download_url/Firefox::Marionette");
    my $har = Archive::Har->new();
    $har->hashref($firefox->har());
    say $har->creator()->name();

=head1 DESCRIPTION

This module contains the L<HAR Export Trigger|https://addons.mozilla.org/en-US/firefox/addon/har-export-trigger/> extension.  This module should not be used directly.  It is required when the 'har' parameter is supplied to the L<new|Firefox::Marionette#new> method in L<Firefox::Marionette|Firefox::Marionette>.

=head1 SUBROUTINES/METHODS

=head2 as_string
 
Returns a base64 encoded copy of the L<HAR Export Trigger|https://addons.mozilla.org/en-US/firefox/addon/har-export-trigger/> extension.

=head1 DIAGNOSTICS

None.

=head1 CONFIGURATION AND ENVIRONMENT

Firefox::Marionette::Extension::HarExportTrigger requires no configuration files or environment variables.

=head1 DEPENDENCIES

None.

=head1 INCOMPATIBILITIES

None reported.

=head1 BUGS AND LIMITATIONS

No bugs have been reported.

Please report any bugs or feature requests to
C<bug-firefox-marionette@rt.cpan.org>, or through the web interface at
L<http://rt.cpan.org>.

=head1 AUTHOR

David Dick  C<< <ddick@cpan.org> >>

=head1 ACKNOWLEDGEMENTS
 
Thanks to L<Jan Odvarko|http://www.softwareishard.com/blog/about/> for creating the L<HAR Export Trigger|https://github.com/firefox-devtools/har-export-trigger> extension for Firefox, which this module contains.

=head1 LICENSE AND COPYRIGHT

Copyright (c) 2019, David Dick C<< <ddick@cpan.org> >>. All rights reserved.

This module is free software; you can redistribute it and/or
modify it under the same terms as Perl itself. See L<perlartistic/perlartistic>.

This module also contains software written by L<Jan Odvarko|http://www.softwareishard.com/blog/about/> that is licensed under the L<Mozilla Public License 2.0|https://www.mozilla.org/en-US/MPL/2.0/>.

=head1 DISCLAIMER OF WARRANTY

BECAUSE THIS SOFTWARE IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
FOR THE SOFTWARE, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT WHEN
OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
PROVIDE THE SOFTWARE "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE
ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE SOFTWARE IS WITH
YOU. SHOULD THE SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL
NECESSARY SERVICING, REPAIR, OR CORRECTION.

IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
REDISTRIBUTE THE SOFTWARE AS PERMITTED BY THE ABOVE LICENCE, BE
LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL,
OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE
THE SOFTWARE (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING
RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A
FAILURE OF THE SOFTWARE TO OPERATE WITH ANY OTHER SOFTWARE), EVEN IF
SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF
SUCH DAMAGES.
