package Sah::SchemaR::ean13;

our $DATE = '2020-03-04'; # DATE
our $VERSION = '0.006'; # VERSION

our $rschema = ["str",[{description=>"\nNondigits [^0-9] will be removed during coercion.\n\nChecksum digit must be valid.\n\n",examples=>[{valid=>1,validated_value=>5901234123457,value=>"5-901234-123457"},{summary=>"Invalid checkdigit",valid=>0,value=>"123-4567890-123"},{summary=>"Less than 13 digits",valid=>0,value=>1234567890},{summary=>"More than 13 digits",valid=>0,value=>12345678901234}],match=>"\\A[0-9]{13}\\z",summary=>"EAN-13 number","x.perl.coerce_rules"=>["From_str::to_ean13"]}],["str"]];

1;
# ABSTRACT: EAN-13 number

__END__

=pod

=encoding UTF-8

=head1 NAME

Sah::SchemaR::ean13 - EAN-13 number

=head1 VERSION

This document describes version 0.006 of Sah::SchemaR::ean13 (from Perl distribution Sah-Schemas-EAN), released on 2020-03-04.

=head1 DESCRIPTION

This module is automatically generated by Dist::Zilla::Plugin::Sah::Schemas during distribution build.

A Sah::SchemaR::* module is useful if a client wants to quickly lookup the base type of a schema without having to do any extra resolving. With Sah::Schema::*, one might need to do several lookups if a schema is based on another schema, and so on. Compare for example L<Sah::Schema::poseven> vs L<Sah::SchemaR::poseven>, where in Sah::SchemaR::poseven one can immediately get that the base type is C<int>. Currently L<Perinci::Sub::Complete> uses Sah::SchemaR::* instead of Sah::Schema::* for reduced startup overhead when doing tab completion.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Sah-Schemas-EAN>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Sah-Schemas-EAN>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Sah-Schemas-EAN>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020, 2019 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
