package Astro::Coord::ECI::VSOP87D::Jupiter;

use 5.008;

use strict;
use warnings;

use base qw{ Astro::Coord::ECI::VSOP87D::_Superior };

our $VERSION = '0.002';

sub __model_definition {
    my ( undef, $key ) = @_;
    return {
      body => "Jupiter",
      default_model_cutoff => {
        Meeus => {
                   B0   => 26,
                   B1   => 22,
                   B2   => 14,
                   B3   => 9,
                   B4   => 6,
                   B5   => 1,
                   L0   => 64,
                   L1   => 61,
                   L2   => 57,
                   L3   => 39,
                   L4   => 19,
                   L5   => 5,
                   name => "Meeus",
                   R0   => 46,
                   R1   => 43,
                   R2   => 36,
                   R3   => 28,
                   R4   => 15,
                   R5   => 7,
                 },
        none  => {
                   B0   => 249,
                   B1   => 141,
                   B2   => 81,
                   B3   => 42,
                   B4   => 12,
                   B5   => 5,
                   L0   => 760,
                   L1   => 369,
                   L2   => 191,
                   L3   => 109,
                   L4   => 45,
                   L5   => 10,
                   name => "none",
                   R0   => 745,
                   R1   => 381,
                   R2   => 190,
                   R3   => 98,
                   R4   => 46,
                   R5   => 9,
                 },
      },
      diameter => 139822,
      model => [
        [
          {
            series => "L0",
            terms  => [
                        [0.59954691495, 0, 0],
                        [0.09695898711, 5.06191793105, 529.6909650946],
                        [0.00573610145, 1.44406205976, 7.1135470008],
                        [0.0030638918, 5.41734729976, 1059.3819301892],
                        [0.0009717828, 4.14264708819, 632.7837393132],
                        [0.00072903096, 3.64042909255, 522.5774180938],
                        [0.00064263986, 3.41145185203, 103.0927742186],
                        [0.00039806051, 2.29376744855, 419.4846438752],
                        [0.0003885778, 1.2723172486, 316.3918696566],
                        [0.00027964622, 1.78454589485, 536.8045120954],
                        [0.00013589738, 5.7748103159, 1589.0728952838],
                        [8.246362e-05, 3.58227961655, 206.1855484372],
                        [8.768686e-05, 3.63000324417, 949.1756089698],
                        [7.368057e-05, 5.08101125612, 735.8765135318],
                        [6.263171e-05, 0.02497643742, 213.299095438],
                        [6.11405e-05, 4.51319531666, 1162.4747044078],
                        [4.905419e-05, 1.32084631684, 110.2063212194],
                        [5.305283e-05, 1.30671236848, 14.2270940016],
                        [5.305457e-05, 4.18625053495, 1052.2683831884],
                        [4.647249e-05, 4.69958109497, 3.9321532631],
                        [3.045009e-05, 4.31675960318, 426.598190876],
                        [2.610001e-05, 1.5666759485, 846.0828347512],
                        [2.028191e-05, 1.06376547379, 3.1813937377],
                        [1.764768e-05, 2.14148077766, 1066.49547719],
                        [1.722983e-05, 3.88036008872, 1265.5674786264],
                        [1.920959e-05, 0.97168928755, 639.897286314],
                        [1.633217e-05, 3.58201089758, 515.463871093],
                        [1.431997e-05, 4.29683690269, 625.6701923124],
                        [9.73278e-06, 4.09764957065, 95.9792272178],
                        [8.84439e-06, 2.43701426123, 412.3710968744],
                        [7.32875e-06, 6.08534113239, 838.9692877504],
                        [7.31072e-06, 3.80591233956, 1581.959348283],
                        [6.91928e-06, 6.13368222939, 2118.7638603784],
                        [7.0919e-06, 1.29272573658, 742.9900605326],
                        [6.14464e-06, 4.10853496756, 1478.8665740644],
                        [4.95224e-06, 3.75567461379, 323.5054166574],
                        [5.81902e-06, 4.53967717552, 309.2783226558],
                        [3.75657e-06, 4.70299124833, 1368.660252845],
                        [3.89864e-06, 4.89716105852, 1692.1656695024],
                        [3.41006e-06, 5.71452525783, 533.6231183577],
                        [3.30458e-06, 4.74049819491, 0.0481841098],
                        [4.40854e-06, 2.95818460943, 454.9093665273],
                        [4.17266e-06, 1.03554430161, 2.4476805548],
                        [2.4417e-06, 5.220208789, 728.762966531],
                        [2.6154e-06, 1.87652461032, 0.9632078465],
                        [2.56568e-06, 3.72410724159, 199.0720014364],
                        [2.61009e-06, 0.82047246448, 380.12776796],
                        [2.20382e-06, 1.65115015995, 543.9180590962],
                        [2.01996e-06, 1.80684574186, 1375.7737998458],
                        [2.07327e-06, 1.85461666594, 525.7588118315],
                        [1.97046e-06, 5.29252149016, 1155.361157407],
                        [2.35141e-06, 1.22693908124, 909.8187330546],
                        [1.74809e-06, 5.90973505276, 956.2891559706],
                        [1.49368e-06, 4.37745104275, 1685.0521225016],
                        [1.75184e-06, 3.22634903433, 1898.3512179396],
                        [1.75191e-06, 3.72966554761, 942.062061969],
                        [1.57909e-06, 4.36483921766, 1795.258443721],
                        [1.37871e-06, 1.31797920785, 1169.5882514086],
                        [1.17495e-06, 2.5002214089, 1596.1864422846],
                        [1.50502e-06, 3.90625022622, 74.7815985673],
                        [1.16757e-06, 3.38920921041, 0.5212648618],
                        [1.05895e-06, 4.55439798236, 526.5095713569],
                        [1.30531e-06, 4.16867945489, 1045.1548361876],
                        [1.41445e-06, 3.13568357861, 491.5579294568],
                        [9.9511e-07, 1.42117395747, 532.8723588323],
                        [9.6137e-07, 1.18156870005, 117.3198682202],
                        [9.1758e-07, 0.85756633461, 1272.6810256272],
                        [8.7695e-07, 1.21738140813, 453.424893819],
                        [6.8507e-07, 2.35242959478, 2.9207613068],
                        [6.6098e-07, 5.34386149468, 1471.7530270636],
                        [7.7401e-07, 4.42676337124, 39.3568759152],
                        [7.2006e-07, 4.23834923691, 2111.6503133776],
                        [6.3406e-07, 4.97665525033, 0.7507595254],
                        [5.9427e-07, 4.11130498612, 2001.4439921582],
                        [6.2481e-07, 0.51211384012, 220.4126424388],
                        [6.6532e-07, 2.98864358135, 2214.7430875962],
                        [6.0194e-07, 4.12628179571, 4.192785694],
                        [5.6012e-07, 1.15493222602, 21.3406410024],
                        [5.2854e-07, 0.91207215543, 10.2949407385],
                        [7.0297e-07, 5.14180555282, 835.0371344873],
                        [5.1916e-07, 4.1004818002, 1258.4539316256],
                        [4.6442e-07, 4.66531163524, 5.6290742925],
                        [5.819e-07, 5.86646380344, 5753.3848848968],
                        [4.0103e-07, 4.68801114087, 0.1600586944],
                        [4.6654e-07, 4.79394835282, 305.3461693927],
                        [3.9298e-07, 4.25448423697, 853.196381752],
                        [4.6042e-07, 5.1098351515, 4.665866446],
                        [5.4459e-07, 1.57072704127, 983.1158589136],
                        [3.892e-07, 6.0759290558, 518.6452648307],
                        [3.845e-07, 2.43836870888, 433.7117378768],
                        [4.68e-07, 3.54640538283, 5.4166259714],
                        [4.183e-07, 4.67982493646, 302.164775655],
                        [3.592e-07, 2.45088036239, 430.5303441391],
                        [3.7888e-07, 0.21127448431, 2648.454825473],
                        [3.919e-07, 1.71835571629, 11.0457002639],
                        [3.7567e-07, 6.19481310233, 831.8557407496],
                        [3.5828e-07, 4.61459907698, 2008.557539159],
                        [4.3402e-07, 0.14992289081, 528.2064923863],
                        [3.1598e-07, 5.14073450755, 1788.1448967202],
                        [2.9849e-07, 5.34441117167, 2221.856634597],
                        [3.2811e-07, 5.28907118836, 88.865680217],
                        [2.7686e-07, 1.85227036207, 0.2124483211],
                        [2.582e-07, 3.85920882494, 2317.8358618148],
                        [2.4705e-07, 2.63495214991, 114.1384744825],
                        [3.3844e-07, 1.00563073268, 9683.5945811164],
                        [2.4266e-07, 3.82355417268, 1574.8458012822],
                        [2.7111e-07, 2.80845435102, 18.1592472647],
                        [2.6837e-07, 1.77586123775, 532.1386456494],
                        [2.6064e-07, 2.74361318804, 2531.1349572528],
                        [3.0765e-07, 0.42330537728, 1.4844727083],
                        [3.0476e-07, 3.66677894407, 508.3503240922],
                        [2.3282e-07, 3.24372142416, 984.6003316219],
                        [1.9445e-07, 0.52370214471, 14.977853527],
                        [1.9332e-07, 4.86314494382, 1361.5467058442],
                        [2.291e-07, 3.84914895064, 2428.0421830342],
                        [2.1617e-07, 6.01696940024, 1063.3140834523],
                        [2.0155e-07, 5.59582008789, 527.2432845398],
                        [2.3732e-07, 2.52766031921, 494.2662424425],
                        [2.0189e-07, 1.01560227681, 628.8515860501],
                        [1.5994e-07, 5.09003530653, 529.7391492044],
                        [1.6134e-07, 5.27095037302, 142.4496501338],
                        [2.0697e-07, 4.03443281612, 355.7487455718],
                        [2.1479e-07, 1.28668134295, 35.4247226521],
                        [1.4964e-07, 4.8603968439, 2104.5367663768],
                        [1.7242e-07, 1.59187913206, 1439.5096981492],
                        [1.5994e-07, 1.89222417794, 529.6427809848],
                        [1.7958e-07, 4.30178016003, 6.1503391543],
                        [1.3279e-07, 2.18943981644, 1055.4497769261],
                        [1.4148e-07, 2.71597731671, 0.2606324309],
                        [1.4689e-07, 0.87944553412, 99.1606209555],
                        [1.4202e-07, 2.41335693735, 530.6541729411],
                        [1.532e-07, 6.07703092728, 149.5631971346],
                        [1.5832e-07, 4.11682440678, 636.7158925763],
                        [1.2398e-07, 2.61042299578, 405.2575498736],
                        [1.6199e-07, 2.77035044582, 760.25553592],
                        [1.3665e-07, 3.5603967831, 217.2312487011],
                        [1.5261e-07, 2.81824770887, 621.7380390493],
                        [1.4681e-07, 6.26423732742, 569.0478410098],
                        [1.2529e-07, 1.39077179081, 7.065362891],
                        [1.1677e-07, 3.60447374272, 2634.2277314714],
                        [1.1603e-07, 4.60461756191, 7.1617311106],
                        [1.2152e-07, 0.24540531919, 1485.9801210652],
                        [1.1347e-07, 2.00818458261, 1073.6090241908],
                        [1.1242e-07, 2.4800094787, 423.4167971383],
                        [1.0942e-07, 5.03602448252, 458.8415197904],
                        [1.1117e-07, 4.04973271023, 519.3960243561],
                        [1.2256e-07, 4.30153222783, 604.4725636619],
                        [1.3149e-07, 2.72189077702, 1364.7280995819],
                        [1.0604e-07, 3.11518747072, 1.2720243872],
                        [9.874e-08, 1.70200068743, 1699.2792165032],
                        [1.0851e-07, 5.08554552028, 2324.9494088156],
                        [1.0692e-07, 2.51401681528, 2847.5268269094],
                        [1.264e-07, 4.75572797691, 528.7277572481],
                        [1.0084e-07, 4.05599810206, 38.1330356378],
                        [1.1536e-07, 2.35034215745, 643.8294395771],
                        [1.0247e-07, 3.63479911496, 2744.4340526908],
                        [1.0105e-07, 3.65845333837, 107.0249274817],
                        [1.0121e-07, 1.31482648275, 1905.4647649404],
                        [9.341e-08, 5.92176693887, 1148.2476104062],
                        [8.796e-08, 2.77421822809, 6.592282139],
                        [8.42e-08, 4.52537756809, 1677.9385755008],
                        [1.0128e-07, 2.09034472544, 511.5317178299],
                        [8.272e-08, 2.98682673354, 540.7366653585],
                        [9.753e-08, 1.22438911827, 32.2433289144],
                        [1.063e-07, 2.07777800288, 92.0470739547],
                        [7.85e-08, 0.98996894618, 408.4389436113],
                        [8.811e-08, 3.46911754939, 1021.2488945514],
                        [7.946e-08, 2.8668292607, 2125.8774073792],
                        [8.575e-08, 5.29590411702, 415.5524906121],
                        [7.841e-08, 6.08025056721, 70.8494453042],
                        [7.706e-08, 1.69832954219, 8.0767548473],
                        [7.265e-08, 4.65503563919, 629.6023455755],
                        [7.164e-08, 4.93400217968, 1056.2005364515],
                        [7.247e-08, 4.6160767756, 2420.9286360334],
                        [7.753e-08, 2.12871653382, 33.9402499438],
                        [6.645e-08, 0.45647460873, 635.9651330509],
                        [9.377e-08, 4.03158388202, 2810.9214616052],
                        [8.263e-08, 1.23558676139, 1802.3719907218],
                        [6.341e-08, 0.0727800158, 202.2533951741],
                        [6.383e-08, 3.54310669809, 1891.2376709388],
                        [7.902e-08, 2.32510002614, 230.5645708254],
                        [6.214e-08, 4.54560345237, 2.7083129857],
                        [7.347e-08, 1.24457237337, 24.3790223882],
                        [7.451e-08, 3.02719199239, 330.6189636582],
                        [6.22e-08, 1.77687561489, 1062.5633239269],
                        [5.674e-08, 5.14132196367, 746.9222137957],
                        [5.855e-08, 5.42130172896, 28.3111756513],
                        [5.629e-08, 3.24348217277, 529.1697002328],
                        [7.652e-08, 0.52813391052, 672.1406152284],
                        [5.456e-08, 3.34716871364, 2950.619601128],
                        [7.127e-08, 1.43497795005, 6.2197751235],
                        [5.388e-08, 4.9017509558, 69.1525242748],
                        [5.618e-08, 4.97903783721, 2641.3412784722],
                        [5.844e-08, 2.95364118152, 490.3340891794],
                        [4.943e-08, 5.37597740579, 721.6494195302],
                        [5.062e-08, 4.84282906467, 31.019488637],
                        [5.163e-08, 5.07410777073, 67.6680515665],
                        [4.739e-08, 6.10248862834, 106.2741679563],
                        [4.879e-08, 0.07095292379, 78.7137518304],
                        [4.854e-08, 5.63875661096, 1.6969210294],
                        [5.629e-08, 3.73871604865, 530.2122299564],
                        [4.471e-08, 4.49152882547, 505.3119427064],
                        [4.313e-08, 4.79369370451, 535.107591066],
                        [4.28e-08, 0.5478382371, 1.4362885985],
                        [4.453e-08, 0.50551854591, 524.0618908021],
                        [4.936e-08, 4.82992988255, 422.6660376129],
                        [4.701e-08, 3.41634869046, 3060.8259223474],
                        [4.261e-08, 2.67044686458, 561.934294009],
                        [4.156e-08, 4.00660658688, 99.9113804809],
                        [4.561e-08, 2.29650164054, 3163.918696566],
                        [4.414e-08, 5.67224020329, 1464.6394800628],
                        [5.345e-08, 0.3151385183, 1289.9465010146],
                        [5.269e-08, 3.89116469022, 191.9584544356],
                        [3.855e-08, 4.28942301453, 1994.3304451574],
                        [4.21e-08, 5.32763589447, 2538.2485042536],
                        [3.949e-08, 4.56507101172, 1382.8873468466],
                        [3.885e-08, 1.5677878681, 647.0108333148],
                        [4.227e-08, 5.5169759903, 5223.6939198022],
                        [4.129e-08, 2.81119457666, 416.3032501375],
                        [3.663e-08, 4.35187510477, 2737.32050569],
                        [3.566e-08, 5.48243943375, 750.1036075334],
                        [4.33e-08, 0.8494175664, 531.1754378029],
                        [4.093e-08, 0.19980340452, 525.0250986486],
                        [4.022e-08, 1.92293311337, 1512.8068240082],
                        [3.4e-08, 6.00302355875, 1.2238402774],
                        [3.496e-08, 0.31252921473, 597.3590166611],
                        [3.299e-08, 4.27596694481, 526.7702037878],
                        [3.226e-08, 2.90455264496, 963.4027029714],
                        [3.15e-08, 3.81061764181, 280.9671470045],
                        [4.129e-08, 4.74946631331, 0.8937718773],
                        [3.84e-08, 1.91064405186, 378.6432952517],
                        [3.057e-08, 1.65589659685, 528.9402055692],
                        [3.011e-08, 1.59276337369, 224.3447957019],
                        [3.196e-08, 5.86588452873, 4.1446015842],
                        [3.628e-08, 0.07930225897, 558.0021407459],
                        [2.932e-08, 0.41424445089, 7.8643065262],
                        [3.316e-08, 2.70211697795, 532.6117264014],
                        [2.925e-08, 4.47580363425, 533.8837507886],
                        [3.69e-08, 0.39897023849, 685.4739373527],
                        [3.223e-08, 2.45833032883, 960.2213092337],
                        [3.059e-08, 5.32616140812, 530.44172462],
                        [3.383e-08, 4.42170370028, 312.4597163935],
                        [3.32e-08, 2.71417812514, 495.7507151508],
                        [2.697e-08, 5.23146633437, 739.8086667949],
                        [3.59e-08, 2.30999595873, 908.3342603463],
                        [3.677e-08, 5.07337955976, 73.297125859],
                        [2.618e-08, 3.09118499149, 3267.0114707846],
                        [2.796e-08, 2.98942316119, 483.2205421786],
                        [3.398e-08, 3.29598270278, 911.3032057629],
                        [3.352e-08, 1.44391979336, 593.426863398],
                        [2.563e-08, 3.35080110279, 2207.6295405954],
                        [2.553e-08, 0.36892288645, 1048.3362299253],
                        [2.62e-08, 3.8276987434, 520.129737539],
                        [3.356e-08, 1.08315053878, 46.470422916],
                        [3.035e-08, 5.52230028113, 618.5566453116],
                        [3.397e-08, 3.83084746522, 210.1177017003],
                        [2.497e-08, 0.47917884538, 945.2434557067],
                        [2.341e-08, 5.87941292649, 2751.5475996916],
                        [2.656e-08, 0.49713061045, 1057.8974574809],
                        [2.581e-08, 0.03759881914, 1.6445314027],
                        [2.9e-08, 2.50019054587, 525.4981794006],
                        [3.153e-08, 2.30900986177, 457.617679513],
                        [2.201e-08, 3.94367109739, 31.492569389],
                        [2.381e-08, 6.19252134885, 327.4375699205],
                        [2.458e-08, 0.65614291954, 9153.9036160218],
                        [2.111e-08, 5.61905648764, 16.4623262353],
                        [2.13e-08, 3.75880734109, 724.8308132679],
                        [2.406e-08, 2.29315649755, 195.1398481733],
                        [2.166e-08, 5.43262641046, 534.3568315406],
                        [2.057e-08, 1.49875151278, 551.031606097],
                        [2.676e-08, 5.06374981112, 456.3938392356],
                        [2.078e-08, 5.28920097886, 76.2660712756],
                        [2.261e-08, 5.38117230692, 1781.0313497194],
                        [2.356e-08, 0.67392574097, 227.5261894396],
                        [2.24e-08, 3.18006978517, 3377.217792004],
                        [2.183e-08, 3.0838425095, 524.2743391232],
                        [2.119e-08, 2.70107659927, 387.2413149608],
                        [2.056e-08, 4.82779196994, 2957.7331481288],
                        [2.116e-08, 6.20263841494, 209.3669421749],
                        [2.712e-08, 3.18157754631, 1474.6737883704],
                        [2.127e-08, 1.24424012514, 539.9859058331],
                        [2.424e-08, 3.57595925853, 953.1077622329],
                        [1.947e-08, 1.94468082546, 529.5309064002],
                        [1.896e-08, 4.014062428, 2310.722314814],
                        [1.935e-08, 4.1005149395, 3053.7123753466],
                        [2.056e-08, 6.2707414855, 245.5424243524],
                        [2.108e-08, 3.22886474225, 252.6559713532],
                        [2.596e-08, 2.77467278614, 177.8743727859],
                        [1.919e-08, 3.14834694111, 381.6122406683],
                        [2.217e-08, 1.92368906925, 535.9107402181],
                        [1.947e-08, 5.03751780002, 529.851023789],
                        [2.025e-08, 4.82814272957, 17.2654753874],
                        [1.945e-08, 2.10611582568, 3480.3105662226],
                        [1.899e-08, 0.05104263891, 560.7104537316],
                        [2.221e-08, 0.5836509063, 3178.1457905676],
                        [2.271e-08, 1.67360565619, 731.9443602687],
                        [1.706e-08, 5.40277333462, 20.4468691251],
                        [2.295e-08, 4.20863103004, 1038.0412891868],
                        [2.218e-08, 3.65982280555, 282.4516197128],
                        [2.181e-08, 4.87369503022, 535.3200393871],
                        [1.745e-08, 1.34021867874, 25.1297819136],
                        [1.601e-08, 3.9273001584, 17.5261078183],
                        [1.651e-08, 0.63598292839, 17.4084877393],
                        [1.826e-08, 0.31592311031, 124.433415221],
                        [2.041e-08, 0.15617294873, 598.8434893694],
                        [1.494e-08, 3.8141802513, 319.5732633943],
                        [1.551e-08, 5.25201528605, 437.6438911399],
                        [1.852e-08, 2.36130812462, 37.8724032069],
                        [1.466e-08, 1.72926380881, 59.8037450403],
                        [1.417e-08, 5.82273267086, 81.7521332162],
                        [1.43e-08, 1.1752880626, 440.8252848776],
                        [1.906e-08, 4.06896022692, 1819.6374661092],
                        [1.397e-08, 0.26383366743, 50.4025761791],
                        [1.756e-08, 2.32977483716, 938.1299087059],
                        [1.487e-08, 2.2486674654, 10.0343083076],
                        [1.368e-08, 3.56691602771, 1514.2912967165],
                        [1.4e-08, 4.84502200703, 295.0512286542],
                        [1.344e-08, 2.20177702122, 529.9034134157],
                        [1.464e-08, 1.42648716568, 1158.5425511447],
                        [1.341e-08, 1.15693423225, 2435.155730035],
                        [1.786e-08, 5.44716330146, 2854.6403739102],
                        [1.677e-08, 6.22875777048, 833.552661779],
                        [1.471e-08, 4.80574535807, 696.5196376166],
                        [1.436e-08, 1.4581095733, 537.7677199419],
                        [1.657e-08, 0.02890651793, 138.5174968707],
                        [1.3e-08, 3.14074420421, 547.8502123593],
                        [1.343e-08, 6.14827138025, 988.532484885],
                        [1.344e-08, 4.78042160426, 529.4785167735],
                        [1.234e-08, 2.83294330979, 3583.4033404412],
                        [1.651e-08, 2.12056447005, 1061.829610744],
                        [1.479e-08, 0.24646493075, 1593.0050485469],
                        [1.413e-08, 3.07444632745, 6283.0758499914],
                        [1.246e-08, 5.94882321661, 1056.9342496344],
                        [1.225e-08, 1.95642397635, 1969.2006632438],
                        [1.388e-08, 2.87749576073, 1023.9572075371],
                        [1.263e-08, 3.46181945031, 40.8413486235],
                        [1.325e-08, 4.15429781246, 916.9322800554],
                        [1.477e-08, 5.26691818477, 810.6581120991],
                        [1.165e-08, 4.65528125418, 944.9828232758],
                        [1.137e-08, 2.48561382158, 2.0057375701],
                        [1.118e-08, 3.80747957482, 7.0016724162],
                        [1.138e-08, 5.11611532241, 885.4397106664],
                        [1.131e-08, 1.54599459004, 775.233389447],
                        [1.477e-08, 4.69742954455, 630.3360587584],
                        [1.252e-08, 1.34316620527, 739.0579072695],
                        [1.273e-08, 5.19070939905, 2097.423219376],
                        [1.446e-08, 5.54999644374, 43.2890291783],
                        [1.344e-08, 4.75897665313, 1166.4068576709],
                        [1.101e-08, 4.56997613488, 3274.1250177854],
                        [1.376e-08, 3.60998729004, 415.2918581812],
                        [1.437e-08, 6.22410093972, 155.7829722581],
                        [1.167e-08, 4.09497264272, 203.0041546995],
                        [1.237e-08, 4.41132627005, 292.0128472684],
                        [1.077e-08, 2.57045229823, 25.2727942655],
                        [1.341e-08, 0.49262296655, 635.231419868],
                        [1.209e-08, 3.36289125536, 521.6142102473],
                        [1.03e-08, 1.81822316284, 465.9550667912],
                        [1.002e-08, 3.21720955284, 2524.021410252],
                        [1.338e-08, 1.26054917773, 902.7051860538],
                        [1.037e-08, 3.87858871885, 3370.1042450032],
                        [1.224e-08, 0.09219976028, 824.7421937488],
                        [1.255e-08, 3.04675952762, 447.7958195265],
                        [9.91e-09, 4.16587903812, 632.831923423],
                        [9.75e-09, 3.80216680539, 2627.1141844706],
                        [1.061e-08, 5.60184374277, 732.6951197941],
                        [1.049e-08, 2.94931080683, 3693.6096616606],
                        [9.84e-09, 0.98260254313, 632.7355552034],
                        [1.05e-08, 2.20935815967, 7.2254215854],
                        [9.96e-09, 5.41921062583, 1059.430114299],
                        [9.61e-09, 0.87315283361, 544.6688186216],
                        [1.175e-08, 3.09093466406, 1894.4190646765],
                        [1.049e-08, 5.81616384906, 26.826702943],
                        [1.161e-08, 0.01274801567, 850.0149880143],
                        [1.109e-08, 3.63294273717, 306.830642101],
                        [1.077e-08, 0.95716576092, 608.404716925],
                        [1.288e-08, 4.23019288942, 1215.1649024473],
                        [1.06e-08, 3.85856787901, 631.8205314667],
                        [1.251e-08, 6.15889818604, 462.0229135281],
                        [1.165e-08, 3.50653563773, 8.5980197091],
                        [9.33e-09, 4.62559759882, 1049.0869894507],
                        [1.035e-08, 1.30805283339, 633.7469471597],
                        [1.238e-08, 2.21195391602, 25558.2121764796],
                        [1.24e-08, 2.27960685992, 6.9010986797],
                        [9.42e-09, 4.14526324371, 945.9942152321],
                        [9.27e-09, 6.10893117637, 514.7131115676],
                        [9.14e-09, 6.17656044376, 952.3570027075],
                        [8.93e-09, 4.27448748055, 0.6331394464],
                        [1.045e-08, 1.64682770236, 565.1156877467],
                        [9.03e-09, 1.9425015664, 3796.7024358792],
                        [1.162e-08, 5.51229668479, 2.9689454166],
                        [9.01e-09, 3.03568112112, 460.5384408198],
                        [9.03e-09, 2.24012822393, 523.5406259403],
                        [1.06e-08, 5.28027224466, 3171.0322435668],
                        [1.064e-08, 0.99330150801, 320.3240229197],
                        [9.7e-09, 4.56607888439, 429.0458714308],
                        [1.071e-08, 4.33203090957, 610.6923387854],
                        [8.65e-09, 0.2183142923, 1098.7388061044],
                        [8.65e-09, 2.82123742108, 1060.3451380357],
                        [8.82e-09, 4.80076824948, 384.0599212231],
                        [9.59e-09, 5.45468005818, 451.9404211107],
                        [1.042e-08, 5.7927032515, 303.8616966844],
                        [7.84e-09, 1.85150700827, 313.2104759189],
                        [1.083e-08, 1.40526460812, 72.0732855816],
                        [7.82e-09, 3.03559242565, 5.8415226136],
                        [8.54e-09, 1.22236205478, 611.4430983108],
                        [9.96e-09, 2.22139794743, 1059.3337460794],
                        [7.19e-09, 4.92550252164, 421.93232443],
                        [9.53e-09, 3.98347050083, 836.5216071956],
                        [8.22e-09, 4.49679856387, 10213.285546211],
                        [7.07e-09, 2.16473400319, 2228.9701815978],
                        [7.15e-09, 4.62515255534, 385.5443939314],
                        [7.37e-09, 4.63776694324, 1134.1635287565],
                        [7.3e-09, 1.87179326186, 153.4953503977],
                        [7.09e-09, 2.9313211591, 417.0369633204],
                        [9.26e-09, 1.77006317007, 2332.0629558164],
                        [8.64e-09, 3.0324627597, 1041.2226829245],
                        [7.08e-09, 6.01601101389, 395.105621487],
                        [9.35e-09, 6.01864676296, 173.9422195228],
                        [6.95e-09, 1.39408383356, 432.0148168474],
                        [6.87e-09, 3.06548397586, 529.9515975255],
                        [6.77e-09, 3.5835752721, 244.318584075],
                        [8.5e-09, 5.46114025921, 41.0537969446],
                        [8.17e-09, 4.65315342412, 535.8413042489],
                        [6.52e-09, 0.44173759183, 1201.831580323],
                        [7.11e-09, 0.9628328931, 373.0142209592],
                        [6.65e-09, 1.03244633471, 623.2225117576],
                        [6.43e-09, 5.05335060049, 522.6256022036],
                        [6.39e-09, 4.22718483639, 25.8634950965],
                        [7.18e-09, 5.0757690071, 1058.4187223427],
                        [6.64e-09, 2.43728454444, 1585.1407420207],
                        [8.33e-09, 1.49468440213, 563.6312150384],
                        [7.6e-09, 4.34849823663, 100.6450936638],
                        [6.33e-09, 4.3179671864, 3590.516887442],
                        [6.29e-09, 6.23431126402, 679.2541622292],
                        [6.17e-09, 2.68075016456, 3899.7952100978],
                        [6.46e-09, 2.88581188015, 13.4933808187],
                        [7.68e-09, 3.1849807612, 1151.4290041439],
                        [7.31e-09, 5.86653168561, 501.3797894433],
                        [6.52e-09, 0.8286577178, 2015.6710861598],
                        [7.96e-09, 5.36663489938, 420.9691165835],
                        [6.47e-09, 4.74965662438, 567.8240007324],
                        [8.45e-09, 1.69406147722, 1744.8558675419],
                        [8.02e-09, 5.79824707751, 981.6313862053],
                        [7.64e-09, 5.05232933368, 827.9235874865],
                        [6.04e-09, 5.11265182908, 1159.2933106701],
                        [6.82e-09, 3.68248136835, 2281.2304965106],
                        [7.4e-09, 0.74512356954, 1261.6353253633],
                        [6.66e-09, 2.06624389616, 27.0873353739],
                        [6.52e-09, 4.92932795958, 2413.8150890326],
                        [5.59e-09, 0.17558868481, 63.7358983034],
                        [5.77e-09, 3.82752312276, 1550.939859646],
                        [7.27e-09, 1.05835550856, 490.0734567485],
                        [5.74e-09, 3.61492119092, 3686.4961146598],
                        [7.32e-09, 5.93179840659, 42.5382696529],
                        [6.06e-09, 2.714118843, 1173.5204046717],
                        [6.33e-09, 4.21720828607, 166.828672522],
                        [6.87e-09, 3.91671464962, 529.4303326637],
                        [5.7e-09, 2.73551750122, 4010.0015313172],
                        [5.52e-09, 2.36967119362, 1603.2999892854],
                        [6e-09, 1.82659364395, 522.529233984],
                        [5.58e-09, 5.09099246601, 1354.4331588434],
                        [5.19e-09, 6.11952999304, 366.7944458357],
                        [7.19e-09, 0.85722557905, 362.8622925726],
                        [5.18e-09, 2.03954064144, 418.5214360287],
                        [5.15e-09, 3.51750445111, 528.4189407074],
                        [5.15e-09, 3.47930063838, 103.1409583284],
                        [5.5e-09, 5.7767683773, 420.4478517217],
                        [7.02e-09, 3.67952126446, 1279.794572628],
                        [5.5e-09, 0.61451088395, 104.0559820651],
                        [4.95e-09, 2.41738205536, 179.3588454942],
                        [5.13e-09, 0.29823688044, 103.0445901088],
                        [5.37e-09, 5.47946238724, 771.3012361839],
                        [5.07e-09, 3.08777345288, 1357.6145525811],
                        [4.95e-09, 4.9536265916, 536.8526962052],
                        [6.81e-09, 4.56294416261, 112.6540017742],
                        [5e-09, 3.15631977489, 1070.4276304531],
                        [4.84e-09, 0.79038835602, 28.4541880032],
                        [5.29e-09, 5.46978501034, 419.4364597654],
                        [5.97e-09, 4.98058295172, 1251.3403846248],
                        [4.92e-09, 3.96066546484, 1269.4996318895],
                        [4.82e-09, 3.6016766249, 2943.5060541272],
                        [6.3e-09, 6.16496640092, 105.5404547734],
                        [4.8e-09, 0.86786400621, 35.212274331],
                        [5.16e-09, 5.97528782923, 3067.9394693482],
                        [5.86e-09, 5.48467997697, 56.6223513026],
                        [5.02e-09, 1.43671788959, 469.8872200543],
                        [4.73e-09, 2.28007170041, 2042.4977891028],
                        [5.65e-09, 1.90952569252, 107.2855599126],
                        [4.52e-09, 3.13938145287, 934.9485149682],
                        [6.05e-09, 1.65413715574, 761.7400086283],
                        [4.43e-09, 5.46282223686, 135.336103133],
                        [5.8e-09, 2.06327501551, 493.0424021651],
                        [5.4e-09, 1.7377799597, 536.7563279856],
                        [4.32e-09, 0.27167052107, 93.531546663],
                        [5.15e-09, 3.46469417437, 530.9629894818],
                        [4.4e-09, 5.28884782489, 497.4476361802],
                        [4.87e-09, 5.78767525063, 12036.4607348882],
                        [4.52e-09, 2.57855172248, 1254.5217783625],
                        [4.27e-09, 3.21032629463, 2840.4132799086],
                        [4.14e-09, 1.54298025443, 115.6229471908],
                        [4.24e-09, 0.12699448931, 1268.7488723641],
                        [4.11e-09, 3.12424023238, 536.2832472336],
                        [4.52e-09, 1.00194596383, 113.3877149571],
                        [4.19e-09, 0.81834479225, 1165.6560981455],
                        [4.9e-09, 4.72785081986, 277.0349937414],
                        [4.34e-09, 0.36146539146, 1304.9243545416],
                        [4.01e-09, 5.70326543719, 1127.0499817557],
                        [4.61e-09, 3.2646289482, 102.1295663721],
                        [5.33e-09, 2.54951615753, 141.2258098564],
                        [4.13e-09, 4.38801694479, 6151.533888305],
                        [4.15e-09, 1.68861617902, 391.1734682239],
                        [3.85e-09, 1.69092319074, 4113.0943055358],
                        [4.5e-09, 5.49339192735, 602.9880909536],
                        [4.99e-09, 3.80738617353, 81.0013736908],
                        [4.54e-09, 0.10952919733, 600.5404103988],
                        [3.77e-09, 6.25375060718, 913.7508863177],
                        [4.53e-09, 3.86104865567, 758.7710632117],
                        [4.01e-09, 4.44475618337, 990.2294059144],
                        [4.07e-09, 5.13442416563, 3487.4241132234],
                        [4.35e-09, 3.7610335849, 523.0986829556],
                        [4.25e-09, 3.22287851959, 2655.5683724738],
                        [3.65e-09, 5.16456645463, 4694.0029547076],
                        [4.54e-09, 1.6332519795, 976.0023119128],
                        [4.06e-09, 2.72102389267, 1438.0252254409],
                        [3.49e-09, 3.59598366422, 1058.8606653274],
                        [3.54e-09, 0.6213633142, 498.6714764576],
                        [3.83e-09, 5.09229089574, 539.2521926502],
                        [3.8e-09, 3.92653231573, 561.1835344836],
                        [3.39e-09, 4.12175871949, 3906.9087570986],
                        [4.58e-09, 3.42556794767, 121.2520214833],
                        [4.27e-09, 3.6128526491, 860.3099287528],
                        [4.24e-09, 4.72757252331, 1366.2125722902],
                        [3.28e-09, 4.55286002816, 1696.0978227655],
                        [3.24e-09, 4.2368500521, 642.3449668688],
                        [3.95e-09, 3.26282558955, 484.444382456],
                        [3.3e-09, 6.05223507989, 215.7467759928],
                        [3.18e-09, 2.0207280007, 2964.8466951296],
                        [4.17e-09, 0.20173093597, 842.9014410135],
                        [4.08e-09, 0.45800247268, 1578.0271950199],
                        [3.42e-09, 6.15347077985, 1371.8416465827],
                        [3.1e-09, 1.97259286255, 754.0357607965],
                        [3.4e-09, 2.77813018312, 3.523118349],
                        [3.33e-09, 2.91352254678, 576.1613880106],
                        [3.24e-09, 0.32544817254, 586.3133163972],
                        [3.02e-09, 2.08708848849, 526.9826521089],
                        [3.63e-09, 4.7056711323, 2730.2069586892],
                        [3e-09, 0.94464473068, 1432.3961511484],
                        [3.52e-09, 5.75013621801, 806.725958836],
                        [2.96e-09, 3.97807312133, 2043.9822618111],
                        [2.95e-09, 2.35257797599, 4216.1870797544],
                        [3.09e-09, 2.49768755925, 4326.3934009738],
                        [3.06e-09, 3.35876843257, 2424.1100297711],
                        [3e-09, 4.94288858368, 1379.7059531089],
                        [3.36e-09, 4.49193455535, 1585.8915015461],
                        [4.02e-09, 2.04684001796, 842.1506814881],
                        [3.12e-09, 4.59043534747, 188.9200730498],
                        [3.46e-09, 5.19792097706, 523.4711899711],
                        [3.8e-09, 1.67961600066, 36.6485629295],
                        [3.38e-09, 1.32014513725, 148.0787244263],
                        [3.91e-09, 4.82224015188, 1012.9115072732],
                        [2.85e-09, 3.43655052437, 1053.9653042178],
                        [3.32e-09, 2.02575636311, 1091.6252591036],
                        [2.82e-09, 5.7886532189, 1064.0477966352],
                        [2.82e-09, 0.39153852422, 207.6700211455],
                        [2.8e-09, 3.80196391678, 298.2326223919],
                        [3.87e-09, 6.2681930999, 1141.1340634054],
                        [3.49e-09, 4.09121908199, 1059.903195051],
                        [3.2e-09, 0.39871942, 2122.6960136415],
                        [3.27e-09, 4.76503823073, 134.5853436076],
                        [2.83e-09, 3.90409016441, 127.4717966068],
                        [3.01e-09, 4.30291951219, 299.1263942692],
                        [3.22e-09, 2.4825105268, 1065.6017053127],
                        [2.97e-09, 2.40814103509, 1591.5205758386],
                        [2.86e-09, 5.85849626574, 172.2452984934],
                        [2.85e-09, 4.55845472479, 1446.62324515],
                        [2.7e-09, 4.08342186112, 1578.7779545453],
                        [3.62e-09, 1.06148806683, 181.806526049],
                        [3.35e-09, 4.51094500655, 2349.3284312038],
                        [3.47e-09, 0.62281394535, 1542.6024723678],
                        [2.75e-09, 3.38473403113, 4002.8879843164],
                        [2.55e-09, 1.52357936497, 1688.2335162393],
                        [2.76e-09, 4.32192160071, 1912.5783119412],
                        [2.53e-09, 2.40482338279, 97.6761482472],
                        [2.48e-09, 4.45058246237, 1688.9842757647],
                        [3e-09, 3.07435583442, 1902.2833712027],
                        [2.57e-09, 4.79180478086, 1670.8250285],
                        [3.19e-09, 1.34244222683, 1288.4620283063],
                        [2.45e-09, 4.01852686769, 1567.7322542814],
                        [2.78e-09, 0.25406312148, 874.3940104025],
                        [3.24e-09, 5.57824969423, 1670.0742689746],
                        [3e-09, 4.67161812947, 1329.3033769298],
                        [2.41e-09, 0.01789818312, 1586.625214729],
                        [2.95e-09, 5.86996114913, 2804.2377977311],
                        [3.17e-09, 3.17967272487, 1020.025054274],
                        [2.38e-09, 4.97765946754, 351.8165923087],
                        [3.02e-09, 1.20236375616, 232.0490435337],
                        [3.01e-09, 5.53432687957, 2274.5468326365],
                        [2.86e-09, 2.41008592059, 2545.3620512544],
                        [2.94e-09, 2.01783542485, 313.9441891018],
                        [2.92e-09, 2.12690999284, 1592.2542890215],
                        [2.5e-09, 2.31712163679, 632.2624744514],
                        [2.38e-09, 5.06557054569, 3803.81598288],
                        [2.26e-09, 0.05916712753, 1518.2234499796],
                        [2.35e-09, 0.16574304942, 137.0330241624],
                        [2.98e-09, 2.99720233431, 1467.8208738005],
                        [2.86e-09, 5.08357076653, 774.0095491696],
                        [2.46e-09, 2.81685822336, 633.305004175],
                        [2.69e-09, 4.93023426152, 151.0476698429],
                        [2.28e-09, 6.13118739321, 3281.2385647862],
                        [2.28e-09, 1.22066024988, 700.4517908797],
                        [2.39e-09, 0.71695698501, 1276.6131788903],
                        [2.89e-09, 6.08263862565, 3384.3313390048],
                        [2.18e-09, 2.90308501961, 85.8272988312],
                        [2.83e-09, 6.28058228271, 71.8126531507],
                        [2.71e-09, 6.01605074549, 170.7608257851],
                        [2.21e-09, 0.99914179141, 1053.7528558967],
                        [2.18e-09, 1.50681393471, 1087.6931058405],
                        [2.23e-09, 3.39126063354, 3259.8979237838],
                        [2.29e-09, 1.19373202707, 1060.8664028975],
                        [2.64e-09, 3.93467945263, 1363.2436268736],
                        [2.28e-09, 5.04188376116, 1064.7985561606],
                        [2.95e-09, 2.1525308639, 6386.16862421],
                        [2.14e-09, 3.85961180377, 4223.3006267552],
                        [2.18e-09, 0.79681703388, 1909.3969182035],
                        [2.12e-09, 4.11706418218, 269.9214467406],
                        [2.64e-09, 5.81676406517, 77.962992305],
                        [2.56e-09, 5.65978708108, 799.6124118352],
                        [2.42e-09, 6.25078283449, 1621.3162241982],
                        [2.35e-09, 2.20668997852, 1570.9136480191],
                        [2.12e-09, 2.88214546012, 1674.0064222377],
                        [2.06e-09, 1.59586787037, 4429.4861751924],
                        [2.08e-09, 2.31366614282, 878.3261636656],
                        [2.13e-09, 0.30373338388, 8624.2126509272],
                        [2.23e-09, 4.88419887133, 1035.002907801],
                        [2.79e-09, 3.65173543621, 84.9335269539],
                        [2.1e-09, 4.08825553401, 203.7378678824],
                        [2.14e-09, 4.63498396475, 812.1425848074],
                        [2.58e-09, 1.7350168845, 1887.3055176757],
                        [2.1e-09, 4.5179808271, 1262.3860848887],
                        [2.52e-09, 5.69246905091, 104.5772469269],
                        [2.05e-09, 4.62946016431, 1056.4611688824],
                        [2.63e-09, 3.04951219565, 1493.093668066],
                        [2.22e-09, 5.54424082649, 5216.5803728014],
                        [2.44e-09, 0.91026645686, 3707.8367556622],
                        [2.04e-09, 0.90117975859, 1408.0171287602],
                        [2.25e-09, 1.23997048012, 3340.6124266998],
                        [2.58e-09, 2.35906183505, 2861.753920911],
                        [2.67e-09, 3.27705002283, 5120.6011455836],
                        [2.14e-09, 0.66988779149, 9146.790069021],
                        [2.35e-09, 4.93761209111, 1443.4418514123],
                        [1.94e-09, 1.60798828275, 102.5715093568],
                        [2.15e-09, 0.97603524747, 479.2883889155],
                        [2.05e-09, 5.23642605904, 4649.8988176312],
                        [2.57e-09, 4.70227260707, 9050.8108418032],
                        [2.28e-09, 6.23410921116, 64.9597385808],
                        [1.8e-09, 4.21309134581, 143.9341228421],
                        [1.8e-09, 4.82870451226, 1063.5747158832],
                        [1.8e-09, 5.06126965624, 52.6901980395],
                        [2.26e-09, 0.55334952097, 554.0699874828],
                        [2.09e-09, 5.67975843693, 48.7580447764],
                        [1.86e-09, 3.66368928017, 108.7218485111],
                        [1.9e-09, 2.00852986549, 1058.6311706638],
                        [1.83e-09, 3.1735846422, 140.9651774255],
                        [1.98e-09, 5.49816579454, 4333.5069479746],
                        [2.4e-09, 6.06602357868, 1821.1219388175],
                        [1.72e-09, 3.04802064781, 54.3347294422],
                        [1.7e-09, 4.66520291204, 1372.5924061081],
                        [1.73e-09, 4.72884056307, 77204.3274945334],
                        [1.74e-09, 0.85370421252, 1587.5884225755],
                        [2.15e-09, 0.68219980704, 1054.7160637432],
                        [1.7e-09, 1.52204803308, 5591.9608796002],
                        [2e-09, 1.60275092073, 6681.2248533996],
                        [1.93e-09, 2.1300347928, 103.6140390804],
                        [2.31e-09, 4.69962389031, 1966.2317178272],
                        [1.79e-09, 5.57395905447, 1457.525933062],
                        [2.05e-09, 3.65507571128, 906.849787638],
                        [1.81e-09, 4.52272934666, 24498.8302462904],
                        [2.23e-09, 0.11650319998, 67.8804998876],
                        [1.72e-09, 5.68083885227, 1884.124123938],
                        [2.19e-09, 0.60964963735, 2729.4561991638],
                        [1.64e-09, 1.06675279755, 594.6507036754],
                        [1.76e-09, 2.36848603898, 977.4867846211],
                        [1.7e-09, 2.430366848, 4532.578949411],
                        [1.91e-09, 3.64255924842, 1440.9941708575],
                        [2.07e-09, 0.49276008455, 71.6002048296],
                        [1.57e-09, 4.26888100582, 5069.3834615064],
                        [1.57e-09, 5.14847227422, 451.7279727896],
                        [1.58e-09, 5.00063628575, 650.9429865779],
                        [1.59e-09, 5.37530499642, 20426.571092422],
                        [2.18e-09, 0.27875408082, 175.1660598002],
                        [1.55e-09, 0.83696849428, 1474.9344208013],
                        [1.54e-09, 2.62839957291, 683.1863154923],
                        [1.71e-09, 1.79511736017, 1123.1178284926],
                        [1.88e-09, 5.24747110812, 25565.3257234804],
                        [1.68e-09, 4.14907553818, 946.727928415],
                        [2.03e-09, 2.8369971553, 1489.9122743283],
                        [1.73e-09, 4.34546063838, 3046.5988283458],
                        [1.9e-09, 5.67865607835, 1060.1326897146],
                        [2.01e-09, 2.3852418292, 419.532827985],
                        [1.52e-09, 5.8908868579, 208.633228992],
                        [2.06e-09, 4.46933127349, 2654.6746005965],
                        [1.56e-09, 2.37819796438, 2758.6611466924],
                        [2.03e-09, 0.70565514297, 498.1983957056],
                        [2.05e-09, 3.05468636546, 1062.302691496],
                        [1.74e-09, 3.50824761708, 2004.364753465],
                        [1.48e-09, 4.73961194393, 1799.1905969841],
                        [1.88e-09, 3.62315953725, 3156.8051495652],
                        [1.83e-09, 2.35011338194, 25551.0986294788],
                        [1.62e-09, 1.58053710589, 628.5909536192],
                        [1.62e-09, 3.99983876824, 1482.7987273275],
                        [1.81e-09, 2.85489861839, 1055.1891444952],
                        [1.51e-09, 3.43198157222, 629.8629780064],
                        [1.57e-09, 3.1519582649, 1025.4416802454],
                        [1.94e-09, 5.13049187783, 1818.1529934009],
                        [1.93e-09, 1.92287052164, 1140.38330388],
                        [1.37e-09, 4.2233522197, 1049.8207026336],
                        [1.67e-09, 2.85163087563, 5746.271337896],
                        [1.67e-09, 5.73970282991, 5760.4984318976],
                        [1.38e-09, 2.23519776527, 1176.7017984094],
                        [1.51e-09, 4.89507270899, 532.3992780803],
                        [1.47e-09, 2.65931838448, 987.3086446076],
                        [1.35e-09, 0.1283641777, 991.7138786227],
                        [1.66e-09, 3.12682515439, 580.0935412737],
                        [1.18e-09, 5.988105763, 531.387886124],
                        [1.35e-09, 5.26601313643, 1065.0110044817],
                        [1.38e-09, 3.18511244397, 707.5653378805],
                        [1.22e-09, 1.34377059565, 446.3113468182],
                        [1.2e-09, 2.29717714347, 1059.2218714948],
                        [1.21e-09, 0.58145552537, 5621.8429232104],
                        [1.03e-09, 4.75645235023, 1226.2106027112],
                        [1.04e-09, 6.08481630139, 528.2546764961],
                        [1.19e-09, 1.06475523307, 527.9940440652],
                        [1.04e-09, 0.89730746841, 531.1272536931],
                        [1.2e-09, 5.39001411803, 1059.5419888836],
                        [1.04e-09, 0.44849170648, 1128.534454464],
                        [1.17e-09, 5.42449214711, 986.0848043302],
                        [1.01e-09, 5.09893554462, 530.5847369719],
                        [1.02e-09, 0.26948040239, 450.9772132642],
                        [1.07e-09, 1.58724086516, 1069.6768709277],
                        [8.6e-10, 2.28711702506, 2498.8916283384],
                        [1.01e-09, 1.88318822518, 528.7971932173],
                        [8.6e-10, 1.37568728263, 970.5162499722],
                        [8.3e-10, 0.06930748288, 530.914805372],
                        [8.5e-10, 3.22094000094, 1553.6481726317],
                        [8.3e-10, 0.62963097974, 528.4671248172],
                        [8.3e-10, 4.16314675511, 849.2642284889],
                        [7.9e-10, 3.4668810234, 1077.5411774539],
                        [9.7e-10, 0.87886975916, 9690.7081281172],
                        [9.7e-10, 4.27398311206, 9676.4810341156],
                        [1.01e-09, 0.29639798579, 857.1285350151],
                        [8.3e-10, 2.55427333923, 1059.5943785103],
                        [7.8e-10, 0.0646149621, 521.8266585684],
                        [7.8e-10, 0.76677000862, 525.5463635104],
                        [9.6e-10, 0.33631035749, 1090.4014188262],
                        [9.8e-10, 1.42815294497, 757.2171545342],
                        [7.7e-10, 0.85066773729, 537.5552716208],
                        [8.4e-10, 5.04765104413, 1160.027023853],
                        [7.6e-10, 3.62264327413, 782.3469364478],
                        [8.5e-10, 1.86831145784, 25028.521211385],
                        [7.9e-10, 2.9060220289, 2114.8317071153],
                      ],
          },
          {
            series => "L1",
            terms  => [
                        [529.93480757497, 0, 0],
                        [0.00489741194, 4.22066689928, 529.6909650946],
                        [0.00228918538, 6.02647464016, 7.1135470008],
                        [0.0002765538, 4.57265956824, 1059.3819301892],
                        [0.00020720943, 5.45938936295, 522.5774180938],
                        [0.00012105732, 0.16985765041, 536.8045120954],
                        [6.068051e-05, 4.42419502005, 103.0927742186],
                        [5.433924e-05, 3.98478382565, 419.4846438752],
                        [4.237795e-05, 5.89009351271, 14.2270940016],
                        [2.211854e-05, 5.26771446618, 206.1855484372],
                        [1.295769e-05, 5.55132765087, 3.1813937377],
                        [1.745919e-05, 4.92669378486, 1589.0728952838],
                        [1.163411e-05, 0.51450895328, 3.9321532631],
                        [1.007216e-05, 0.46478398551, 735.8765135318],
                        [1.173129e-05, 5.8564730435, 1052.2683831884],
                        [8.47678e-06, 5.7580585045, 110.2063212194],
                        [8.27329e-06, 4.80312015734, 213.299095438],
                        [1.003574e-05, 3.15040301822, 426.598190876],
                        [1.098735e-05, 5.30704981594, 515.463871093],
                        [8.16397e-06, 0.58643054886, 1066.49547719],
                        [7.25447e-06, 5.51827471473, 639.897286314],
                        [5.67845e-06, 5.98867049451, 625.6701923124],
                        [4.74181e-06, 4.13245269168, 412.3710968744],
                        [4.1293e-06, 5.73652891261, 95.9792272178],
                        [3.35817e-06, 3.73248749046, 1162.4747044078],
                        [3.45249e-06, 4.2415956541, 632.7837393132],
                        [2.34066e-06, 6.24302226646, 309.2783226558],
                        [1.94784e-06, 2.21879010911, 323.5054166574],
                        [2.3434e-06, 4.03469970332, 949.1756089698],
                        [1.83938e-06, 6.27963588822, 543.9180590962],
                        [1.98525e-06, 1.50458442825, 838.9692877504],
                        [1.86899e-06, 6.08620565908, 742.9900605326],
                        [1.7138e-06, 5.41655983845, 199.0720014364],
                        [1.30771e-06, 0.62643377351, 728.762966531],
                        [1.07575e-06, 4.49282760117, 956.2891559706],
                        [1.15393e-06, 0.68019050174, 846.0828347512],
                        [1.15047e-06, 5.28641699144, 2118.7638603784],
                        [6.6824e-07, 5.73365126533, 21.3406410024],
                        [6.9618e-07, 5.97263450278, 532.8723588323],
                        [6.485e-07, 6.08803490288, 1581.959348283],
                        [7.9686e-07, 5.82412400273, 1045.1548361876],
                        [5.7939e-07, 0.99453087342, 1596.1864422846],
                        [6.5635e-07, 0.1292419143, 526.5095713569],
                        [5.8509e-07, 0.58626971028, 1155.361157407],
                        [5.66e-07, 1.41198438841, 533.6231183577],
                        [7.1643e-07, 5.34162650321, 942.062061969],
                        [5.7368e-07, 5.96851304799, 1169.5882514086],
                        [5.4935e-07, 5.42806383723, 10.2949407385],
                        [5.2016e-07, 0.22981299129, 1368.660252845],
                        [5.2309e-07, 5.72661448388, 117.3198682202],
                        [5.0418e-07, 6.08075147811, 525.7588118315],
                        [4.7418e-07, 3.62611843241, 1478.8665740644],
                        [3.9888e-07, 4.161580136, 1692.1656695024],
                        [4.6678e-07, 0.51144073175, 1265.5674786264],
                        [3.2827e-07, 5.03596689455, 220.4126424388],
                        [3.3558e-07, 0.09913904872, 302.164775655],
                        [2.9379e-07, 3.35927241533, 4.665866446],
                        [2.9307e-07, 0.75907909735, 88.865680217],
                        [3.2449e-07, 5.37492530697, 508.3503240922],
                        [2.9483e-07, 5.42208897099, 1272.6810256272],
                        [2.1802e-07, 6.1505405407, 1685.0521225016],
                        [2.5195e-07, 1.60723063387, 831.8557407496],
                        [2.1133e-07, 5.863468242, 1258.4539316256],
                        [1.9747e-07, 2.17205957814, 316.3918696566],
                        [1.7871e-07, 0.82841413516, 433.7117378768],
                        [1.7703e-07, 5.95527049039, 5.4166259714],
                        [1.723e-07, 2.76395560958, 853.196381752],
                        [1.7453e-07, 0.70749901224, 1471.7530270636],
                        [1.7508e-07, 0.49799925173, 1375.7737998458],
                        [1.4368e-07, 0.9145983114, 18.1592472647],
                        [1.4107e-07, 0.63031082833, 2.9207613068],
                        [1.1559e-07, 4.30379009964, 405.2575498736],
                        [1.1728e-07, 1.76426582357, 380.12776796],
                        [1.1054e-07, 5.56735602213, 1574.8458012822],
                        [1.0425e-07, 0.3135503439, 1361.5467058442],
                        [9.804e-08, 5.90363777277, 519.3960243561],
                        [9.805e-08, 0.38648727979, 1073.6090241908],
                        [9.285e-08, 3.2184228753, 1795.258443721],
                        [8.864e-08, 0.53776257958, 1788.1448967202],
                        [8.37e-08, 5.88484552222, 2001.4439921582],
                        [8.148e-08, 5.1016231141, 1485.9801210652],
                        [7.658e-08, 5.64890060131, 2648.454825473],
                        [6.69e-08, 2.4109345942, 4.192785694],
                        [5.84e-08, 4.22347896053, 2008.557539159],
                        [7.256e-08, 6.19384525651, 11.0457002639],
                        [6.266e-08, 1.36137786945, 1148.2476104062],
                        [5.141e-08, 5.23083932012, 628.8515860501],
                        [5.14e-08, 2.92955981951, 518.6452648307],
                        [4.765e-08, 0.16838181862, 629.6023455755],
                        [4.603e-08, 0.78529559911, 721.6494195302],
                        [4.575e-08, 6.24794935732, 1677.9385755008],
                        [4.537e-08, 4.95096707833, 635.9651330509],
                        [4.518e-08, 2.06523915453, 453.424893819],
                        [4.414e-08, 0.15381186059, 1699.2792165032],
                        [5.593e-08, 5.57489981207, 191.9584544356],
                        [5.403e-08, 1.46004886198, 330.6189636582],
                        [4.285e-08, 0.23949868127, 2104.5367663768],
                        [4.223e-08, 1.44087555881, 2125.8774073792],
                        [4.101e-08, 6.19274358942, 636.7158925763],
                        [4.432e-08, 4.35811524051, 423.4167971383],
                        [4.132e-08, 0.50170694173, 1056.2005364515],
                        [4.398e-08, 4.14280286969, 511.5317178299],
                        [5.406e-08, 4.40429493698, 2221.856634597],
                        [4.467e-08, 0.08534650684, 1062.5633239269],
                        [3.569e-08, 5.6654047701, 2317.8358618148],
                        [4.007e-08, 2.54845549248, 74.7815985673],
                        [3.515e-08, 0.25495124831, 1055.4497769261],
                        [3.687e-08, 2.93378008847, 32.2433289144],
                        [2.883e-08, 5.72793010505, 99.9113804809],
                        [2.969e-08, 5.50054720569, 107.0249274817],
                        [2.72e-08, 1.25222590925, 540.7366653585],
                        [2.808e-08, 3.30714813896, 0.7507595254],
                        [2.768e-08, 1.61339487804, 1063.3140834523],
                        [2.666e-08, 4.28662288102, 106.2741679563],
                        [2.704e-08, 3.03615556153, 422.6660376129],
                        [3.29e-08, 5.8908168215, 1802.3719907218],
                        [2.578e-08, 3.60390367979, 750.1036075334],
                        [2.661e-08, 0.35249312659, 1898.3512179396],
                        [2.486e-08, 5.28950877719, 1891.2376709388],
                        [2.936e-08, 1.0905202945, 1464.6394800628],
                        [3.19e-08, 4.60740643547, 416.3032501375],
                        [2.39e-08, 6.01779736611, 551.031606097],
                        [2.214e-08, 5.2445092318, 621.7380390493],
                        [2.319e-08, 5.8292030013, 305.3461693927],
                        [2.089e-08, 5.99310370434, 1994.3304451574],
                        [2.042e-08, 0.75008788531, 142.4496501338],
                        [2.121e-08, 0.01537599023, 2420.9286360334],
                        [2.114e-08, 6.25308371567, 647.0108333148],
                        [2.02e-08, 4.17560390841, 569.0478410098],
                        [2.109e-08, 5.18682321403, 227.5261894396],
                        [2.283e-08, 5.80043809222, 539.9859058331],
                        [1.977e-08, 3.99197009651, 24.3790223882],
                        [1.96e-08, 1.35288793079, 963.4027029714],
                        [1.903e-08, 2.78349628184, 2428.0421830342],
                        [1.915e-08, 4.22134509685, 2324.9494088156],
                        [1.971e-08, 5.88715684267, 217.2312487011],
                        [1.917e-08, 3.03728154374, 1382.8873468466],
                        [2.026e-08, 3.08606488714, 408.4389436113],
                        [1.834e-08, 5.61474110217, 430.5303441391],
                        [1.838e-08, 1.25467410218, 81.7521332162],
                        [2.46e-08, 4.63268678998, 1905.4647649404],
                        [1.82e-08, 5.9749792612, 114.1384744825],
                        [2.043e-08, 4.34047514845, 70.8494453042],
                        [1.959e-08, 4.03116026306, 92.0470739547],
                        [1.768e-08, 0.33097462499, 35.4247226521],
                        [2.334e-08, 5.8704263847, 1038.0412891868],
                        [1.835e-08, 4.81326127892, 124.433415221],
                        [2.269e-08, 1.02549350754, 618.5566453116],
                        [1.919e-08, 5.01297395549, 99.1606209555],
                        [1.923e-08, 0.28688549585, 31.019488637],
                        [1.878e-08, 5.69299116574, 210.1177017003],
                        [1.679e-08, 0.25635730278, 295.0512286542],
                        [1.656e-08, 5.46039280732, 2634.2277314714],
                        [1.675e-08, 6.15609073315, 643.8294395771],
                        [1.953e-08, 5.09846435548, 17.4084877393],
                        [1.539e-08, 2.75316078346, 415.5524906121],
                        [1.467e-08, 0.54812675158, 458.8415197904],
                        [1.482e-08, 3.76736278426, 534.3568315406],
                        [1.446e-08, 3.15802770791, 25.1297819136],
                        [1.667e-08, 0.26406950755, 835.0371344873],
                        [1.472e-08, 0.83054329617, 28.3111756513],
                        [1.655e-08, 0.88908548504, 1781.0313497194],
                        [1.294e-08, 5.76241191046, 440.8252848776],
                        [1.348e-08, 2.49823510924, 984.6003316219],
                        [1.352e-08, 5.10869562455, 149.5631971346],
                        [1.344e-08, 0.01942249067, 2214.7430875962],
                        [1.188e-08, 2.24279457878, 31.492569389],
                        [1.166e-08, 0.80686346228, 739.8086667949],
                        [1.322e-08, 4.25691184168, 2538.2485042536],
                        [1.094e-08, 6.02985819406, 2737.32050569],
                        [1.112e-08, 4.3820436067, 561.934294009],
                        [1.346e-08, 3.2057584887, 525.0250986486],
                        [1.056e-08, 5.76507115032, 2310.722314814],
                        [1.159e-08, 0.4618956497, 67.6680515665],
                        [1.027e-08, 0.20709586018, 7.8643065262],
                        [1.143e-08, 5.56626418636, 46.470422916],
                        [1.012e-08, 0.54293005597, 532.1386456494],
                        [9.78e-09, 5.13939194101, 2207.6295405954],
                        [9.93e-09, 2.03698185233, 319.5732633943],
                        [1.035e-08, 2.90231353535, 611.4430983108],
                        [1.021e-08, 4.75651217048, 527.2432845398],
                        [1.308e-08, 1.78809336431, 824.7421937488],
                        [9.64e-09, 2.82269601958, 2111.6503133776],
                        [8.96e-09, 2.54505998806, 2744.4340526908],
                        [8.9e-09, 5.41036782817, 28.4541880032],
                        [9.06e-09, 0.76565238554, 1439.5096981492],
                        [9.85e-09, 0.8868762377, 5760.4984318976],
                        [9.83e-09, 1.42102343372, 5746.271337896],
                        [8.92e-09, 5.87250060663, 203.0041546995],
                        [9.42e-09, 2.31049430734, 9690.7081281172],
                        [9.41e-09, 2.84331157527, 9676.4810341156],
                        [8.67e-09, 0.81020362547, 524.2743391232],
                        [8.29e-09, 2.35178495412, 312.4597163935],
                        [9.12e-09, 2.80494184378, 6.2197751235],
                        [8.09e-09, 1.05148218513, 529.6427809848],
                        [7.79e-09, 4.80009242059, 945.2434557067],
                        [8.78e-09, 5.76532521399, 1.6445314027],
                        [9.53e-09, 4.30945738629, 209.3669421749],
                        [7.72e-09, 5.25607113566, 2950.619601128],
                        [7.45e-09, 0.03810558502, 535.107591066],
                        [7.44e-09, 0.58381523987, 25.2727942655],
                        [7.34e-09, 0.208004851, 1049.0869894507],
                        [7.47e-09, 2.71772840871, 38.1330356378],
                        [7.28e-09, 5.97210358938, 945.9942152321],
                        [7.69e-09, 4.51394016967, 952.3570027075],
                        [7.1e-09, 0.38016353553, 69.1525242748],
                        [7.6e-09, 3.07033779824, 39.3568759152],
                        [8.02e-09, 1.14191463412, 532.6117264014],
                        [7.04e-09, 1.2544730812, 547.8502123593],
                        [7.21e-09, 0.73855379162, 2228.9701815978],
                        [7.94e-09, 4.25051539085, 2641.3412784722],
                        [7.95e-09, 3.2058836382, 604.4725636619],
                        [8.18e-09, 1.05229815343, 909.8187330546],
                        [7.24e-09, 5.68281830264, 953.1077622329],
                        [8.36e-09, 0.60410469174, 2097.423219376],
                        [6.69e-09, 5.75757140051, 2015.6710861598],
                        [6.82e-09, 1.19994890339, 387.2413149608],
                        [6.4e-09, 3.91546675664, 528.7277572481],
                        [8.09e-09, 4.24929331276, 529.7391492044],
                        [8.19e-09, 4.91540072376, 2751.5475996916],
                        [6.92e-09, 2.51162384766, 916.9322800554],
                        [7.84e-09, 4.23651511312, 195.1398481733],
                        [7.62e-09, 1.12201139619, 732.6951197941],
                        [6.17e-09, 5.80920925081, 739.0579072695],
                        [7.27e-09, 4.24401822698, 760.25553592],
                        [5.91e-09, 3.26075006572, 202.2533951741],
                        [5.52e-09, 5.83533550039, 526.7702037878],
                        [6.4e-09, 1.38530872949, 530.6541729411],
                        [5.77e-09, 6.09100925678, 2531.1349572528],
                        [6.2e-09, 3.01917904435, 902.7051860538],
                        [7.22e-09, 5.18171159557, 1.4844727083],
                        [5.4e-09, 3.7880923082, 2957.7331481288],
                        [5.23e-09, 3.63882376, 437.6438911399],
                        [5.27e-09, 5.80796427555, 3053.7123753466],
                        [4.88e-09, 4.99103190309, 483.2205421786],
                        [5.57e-09, 4.11381202161, 2854.6403739102],
                        [4.92e-09, 0.76371083106, 1603.2999892854],
                        [4.87e-09, 5.55383951779, 2627.1141844706],
                        [4.87e-09, 5.86510858429, 724.8308132679],
                        [4.53e-09, 0.61375011101, 1159.2933106701],
                        [4.5e-09, 2.28121042355, 3060.8259223474],
                        [5.15e-09, 4.7812605928, 447.7958195265],
                        [4.49e-09, 4.70231576312, 934.9485149682],
                        [4.5e-09, 1.91049508739, 597.3590166611],
                        [4.38e-09, 6.01178917646, 3178.1457905676],
                        [4.94e-09, 0.53844942275, 1354.4331588434],
                        [5.01e-09, 5.51752195462, 2435.155730035],
                        [4.32e-09, 3.64903264921, 313.2104759189],
                        [4.35e-09, 3.02449828967, 533.8837507886],
                        [4.26e-09, 5.07945534339, 2524.021410252],
                        [4.91e-09, 3.592863642, 230.5645708254],
                        [5.47e-09, 0.34432090949, 1251.3403846248],
                        [5.03e-09, 1.57454509207, 454.9093665273],
                        [4.86e-09, 4.39351469958, 462.0229135281],
                        [5.24e-09, 2.03003740296, 1279.794572628],
                        [3.88e-09, 5.58318013074, 731.9443602687],
                        [4.49e-09, 1.11025492739, 56.6223513026],
                        [3.98e-09, 5.19943284273, 3267.0114707846],
                        [4.16e-09, 1.70821917336, 245.5424243524],
                        [3.79e-09, 1.80234948769, 2655.5683724738],
                        [3.55e-09, 1.65214516751, 78.7137518304],
                        [4.04e-09, 1.72647262603, 1141.1340634054],
                        [3.35e-09, 6.01254286794, 960.2213092337],
                        [3.31e-09, 1.74086938716, 490.3340891794],
                        [4.01e-09, 0.30034336462, 2332.0629558164],
                        [3.36e-09, 2.64385574909, 1021.2488945514],
                        [3.89e-09, 0.31259289221, 2413.8150890326],
                        [3.14e-09, 5.73833529708, 1158.5425511447],
                        [3.13e-09, 4.74363791106, 938.1299087059],
                        [3.33e-09, 0.80112437148, 1585.1407420207],
                        [3.23e-09, 3.5265624528, 3274.1250177854],
                        [3.95e-09, 1.73181407631, 1593.0050485469],
                        [3.02e-09, 4.64184749164, 1261.6353253633],
                        [3.25e-09, 0.54991590409, 43.2890291783],
                        [2.93e-09, 0.97977818746, 1585.8915015461],
                        [3.41e-09, 2.80833606944, 1514.2912967165],
                        [3.04e-09, 6.12522825214, 1262.3860848887],
                        [2.86e-09, 2.89800423081, 530.2122299564],
                        [3.87e-09, 0.46648572639, 1592.2542890215],
                        [2.85e-09, 4.56394598052, 1268.7488723641],
                        [3.1e-09, 4.69102289591, 76.2660712756],
                        [2.78e-09, 5.49867187248, 280.9671470045],
                        [3.58e-09, 5.45926487831, 113.3877149571],
                        [2.83e-09, 1.0923050635, 1061.829610744],
                        [3.26e-09, 0.60265259639, 827.9235874865],
                        [2.84e-09, 5.36580034539, 1165.6560981455],
                        [2.81e-09, 5.5463546105, 3370.1042450032],
                        [2.69e-09, 3.92616563946, 42.5382696529],
                        [2.75e-09, 2.58465453365, 373.0142209592],
                        [3.57e-09, 1.39391983207, 1493.093668066],
                        [2.58e-09, 5.9667069414, 1269.4996318895],
                        [2.59e-09, 2.56026216784, 9146.790069021],
                        [2.81e-09, 2.74823090198, 4694.0029547076],
                        [2.81e-09, 3.0132465594, 320.3240229197],
                        [2.72e-09, 4.1850495892, 8624.2126509272],
                        [2.45e-09, 1.24462798353, 252.6559713532],
                        [2.44e-09, 2.0289276469, 3377.217792004],
                        [3.24e-09, 1.84851618413, 1289.9465010146],
                        [2.21e-09, 6.22167997496, 3281.2385647862],
                        [2.38e-09, 3.93371505401, 3171.0322435668],
                        [2.26e-09, 5.94296271326, 224.3447957019],
                        [2.13e-09, 3.6826423475, 1048.3362299253],
                        [2.16e-09, 5.82941334164, 1567.7322542814],
                        [2.95e-09, 4.70194747095, 3067.9394693482],
                        [2.06e-09, 4.98184230959, 1357.6145525811],
                        [2.02e-09, 1.32439444045, 4326.3934009738],
                        [2.27e-09, 0.78540105705, 59.8037450403],
                        [2.37e-09, 5.56926897693, 2943.5060541272],
                        [2.07e-09, 0.07907015398, 5223.6939198022],
                        [1.99e-09, 3.30501818656, 4120.2078525366],
                        [1.94e-09, 5.95526916809, 84.9335269539],
                        [2.66e-09, 1.58032565718, 983.1158589136],
                        [1.98e-09, 4.31078641704, 4017.115078318],
                        [1.98e-09, 0.30166351366, 1166.4068576709],
                        [1.88e-09, 0.90738705875, 135.336103133],
                        [1.86e-09, 0.69289672485, 92.7978334801],
                        [1.82e-09, 1.18931462257, 1512.8068240082],
                        [1.91e-09, 1.04146023518, 1884.124123938],
                        [1.74e-09, 6.13734594396, 3597.6304344428],
                        [1.89e-09, 0.35191512844, 1372.5924061081],
                        [1.72e-09, 4.35250972697, 1578.0271950199],
                        [1.73e-09, 2.30241719278, 1176.7017984094],
                        [2.2e-09, 1.06991056825, 2200.5159935946],
                        [1.86e-09, 4.90511103807, 3583.4033404412],
                        [1.89e-09, 0.24160744024, 1670.8250285],
                        [2.06e-09, 0.01485146863, 2730.2069586892],
                        [1.74e-09, 1.83997277029, 746.9222137957],
                        [2.25e-09, 3.1310809966, 630.3360587584],
                        [2.06e-09, 5.22730929781, 3995.7744373156],
                        [1.69e-09, 2.57956682688, 9161.0171630226],
                        [1.65e-09, 1.51795928301, 4010.0015313172],
                        [1.81e-09, 2.05055200822, 842.9014410135],
                        [1.81e-09, 5.96554625357, 1578.7779545453],
                        [1.66e-09, 1.551148631, 1070.4276304531],
                        [1.57e-09, 5.8783995888, 3914.0223040994],
                        [1.6e-09, 0.43729819176, 2545.3620512544],
                        [1.68e-09, 5.73975661792, 2847.5268269094],
                        [1.57e-09, 2.25764581068, 850.0149880143],
                        [1.87e-09, 0.64918748618, 842.1506814881],
                        [1.8e-09, 1.88055488803, 685.4739373527],
                        [1.53e-09, 4.15259684562, 4333.5069479746],
                        [1.54e-09, 3.65536637158, 77734.018459628],
                        [1.51e-09, 3.17795437121, 3590.516887442],
                        [1.55e-09, 3.8762354799, 327.4375699205],
                        [1.71e-09, 3.33647878498, 1912.5783119412],
                        [1.88e-09, 4.53005359421, 1041.2226829245],
                        [1.34e-09, 4.09921613445, 530.44172462],
                        [1.23e-09, 4.79543460218, 1098.7388061044],
                        [1.61e-09, 2.02006564218, 860.3099287528],
                        [1.43e-09, 2.40197278329, 529.1697002328],
                        [1.15e-09, 1.55831212007, 9153.9036160218],
                        [1.06e-09, 5.94313244357, 1057.8974574809],
                        [1.19e-09, 5.10578428676, 1056.9342496344],
                        [1e-09, 5.74974781049, 501.2367770914],
                        [9.4e-10, 1.40134175492, 1059.3337460794],
                        [9.8e-10, 3.79115318281, 497.4476361802],
                        [9e-10, 4.09610113044, 1064.0477966352],
                        [1.02e-09, 1.10442899544, 1969.2006632438],
                        [8.7e-10, 0.58218477838, 1173.5204046717],
                        [1.09e-09, 3.83745968299, 525.4981794006],
                        [9.4e-10, 4.59915291355, 1059.430114299],
                        [1.18e-09, 6.11701561559, 1069.6768709277],
                        [1.07e-09, 5.40509332689, 679.2541622292],
                        [8.9e-10, 5.90037690244, 757.2171545342],
                        [7.8e-10, 6.06217863109, 970.5162499722],
                        [8e-10, 5.45470236239, 3163.918696566],
                        [7.2e-10, 5.65789862232, 1151.4290041439],
                        [8e-10, 0.045397201, 1080.7225711916],
                        [7.5e-10, 4.26526686574, 1058.4187223427],
                      ],
          },
          {
            series => "L2",
            terms  => [
                        [0.00047233598, 4.32148323554, 7.1135470008],
                        [0.00030629053, 2.93021440216, 529.6909650946],
                        [0.0003896555, 0, 0],
                        [3.189317e-05, 1.05504615595, 522.5774180938],
                        [2.723358e-05, 3.41411526638, 1059.3819301892],
                        [2.729292e-05, 4.84545481351, 536.8045120954],
                        [1.721069e-05, 4.18734385158, 14.2270940016],
                        [3.83258e-06, 5.76790714387, 419.4846438752],
                        [3.67498e-06, 6.05509120409, 103.0927742186],
                        [3.77524e-06, 0.76048964872, 515.463871093],
                        [3.37386e-06, 3.78644384244, 3.1813937377],
                        [3.082e-06, 0.69356654052, 206.1855484372],
                        [2.18408e-06, 3.81389191353, 1589.0728952838],
                        [1.98883e-06, 5.33996443444, 1066.49547719],
                        [1.97445e-06, 2.48356402053, 3.9321532631],
                        [1.4623e-06, 3.81373196838, 639.897286314],
                        [1.55862e-06, 1.40642426467, 1052.2683831884],
                        [1.2957e-06, 5.83738872525, 412.3710968744],
                        [1.41932e-06, 1.63435169016, 426.598190876],
                        [1.17327e-06, 1.41435462588, 625.6701923124],
                        [9.6733e-07, 4.03383427887, 110.2063212194],
                        [9.0823e-07, 1.10630629042, 95.9792272178],
                        [7.8769e-07, 4.63726131329, 543.9180590962],
                        [7.2392e-07, 2.21716670026, 735.8765135318],
                        [8.7292e-07, 2.52235174825, 632.7837393132],
                        [5.691e-07, 3.12292059854, 213.299095438],
                        [4.8622e-07, 1.67283791618, 309.2783226558],
                        [5.8475e-07, 0.83216317444, 199.0720014364],
                        [4.015e-07, 4.0248544474, 21.3406410024],
                        [3.9784e-07, 0.62416945827, 323.5054166574],
                        [3.5718e-07, 2.32581247002, 728.762966531],
                        [2.562e-07, 2.51240623862, 1162.4747044078],
                        [2.9255e-07, 3.60838327799, 10.2949407385],
                        [2.3591e-07, 3.00532139306, 956.2891559706],
                        [2.7814e-07, 3.23992013743, 838.9692877504],
                        [2.5993e-07, 4.5011829829, 742.9900605326],
                        [2.5194e-07, 1.21868110687, 1045.1548361876],
                        [1.9458e-07, 4.29028644674, 532.8723588323],
                        [1.766e-07, 0.8095394156, 508.3503240922],
                        [1.5355e-07, 5.81037986941, 1596.1864422846],
                        [1.7058e-07, 4.20001977723, 2118.7638603784],
                        [1.704e-07, 1.8340214664, 526.5095713569],
                        [1.4661e-07, 3.99989622586, 117.3198682202],
                        [1.3639e-07, 1.80336677963, 302.164775655],
                        [1.323e-07, 2.51856643603, 88.865680217],
                        [1.2756e-07, 4.36856232414, 1169.5882514086],
                        [1.5292e-07, 0.68174165476, 942.062061969],
                        [1.0986e-07, 4.43586634639, 525.7588118315],
                        [1.392e-07, 5.95169568482, 316.3918696566],
                        [9.437e-08, 2.17684563456, 1155.361157407],
                        [8.812e-08, 3.29452783338, 220.4126424388],
                        [7.823e-08, 5.75672228354, 846.0828347512],
                        [7.549e-08, 2.70955516779, 533.6231183577],
                        [9.681e-08, 1.71563161051, 1581.959348283],
                        [8.69e-08, 3.31924493607, 831.8557407496],
                        [6.285e-08, 0.49939863541, 949.1756089698],
                        [6.685e-08, 2.17560093281, 1265.5674786264],
                        [5.381e-08, 6.00510875948, 405.2575498736],
                        [4.676e-08, 1.40846192799, 1258.4539316256],
                        [4.421e-08, 3.02360159274, 1692.1656695024],
                        [4.403e-08, 5.4773726616, 433.7117378768],
                        [4.286e-08, 5.07139951645, 1073.6090241908],
                        [4.201e-08, 5.28560721767, 18.1592472647],
                        [3.933e-08, 1.26665387164, 853.196381752],
                        [5.351e-08, 3.65320121089, 1272.6810256272],
                        [4.392e-08, 2.27325303667, 1368.660252845],
                        [3.482e-08, 1.53983001273, 519.3960243561],
                        [2.745e-08, 2.09685315627, 1478.8665740644],
                        [2.737e-08, 1.06017230524, 1574.8458012822],
                        [2.897e-08, 2.05128453665, 1361.5467058442],
                        [3.075e-08, 0.99085727534, 191.9584544356],
                        [2.462e-08, 2.37173605635, 1471.7530270636],
                        [2.203e-08, 2.47960567714, 721.6494195302],
                        [2.096e-08, 3.71482580504, 1485.9801210652],
                        [1.984e-08, 1.88475229557, 1685.0521225016],
                        [2.274e-08, 3.03360234351, 1148.2476104062],
                        [2.041e-08, 6.17114556019, 330.6189636582],
                        [1.451e-08, 4.72055072637, 32.2433289144],
                        [1.454e-08, 5.14703918585, 1375.7737998458],
                        [1.447e-08, 3.18833439444, 635.9651330509],
                        [1.403e-08, 4.26712075104, 551.031606097],
                        [1.42e-08, 1.99288040133, 629.6023455755],
                        [1.269e-08, 0.03300387779, 2125.8774073792],
                        [1.276e-08, 2.26356919237, 1788.1448967202],
                        [1.189e-08, 1.70223550488, 1677.9385755008],
                        [1.182e-08, 2.18142313946, 1795.258443721],
                        [1.366e-08, 1.27629917215, 1038.0412891868],
                        [1.306e-08, 4.76302079847, 1062.5633239269],
                        [1.109e-08, 2.97787130235, 81.7521332162],
                        [1.027e-08, 1.99236027398, 295.0512286542],
                        [1.349e-08, 4.01621534182, 539.9859058331],
                        [1.025e-08, 3.75336759986, 28.4541880032],
                        [9.77e-09, 3.01355125761, 124.433415221],
                        [1.29e-08, 4.62594234857, 2648.454825473],
                        [1.065e-08, 5.06153058155, 1699.2792165032],
                        [9.65e-09, 1.17716405513, 99.9113804809],
                        [1.021e-08, 1.9071210266, 750.1036075334],
                        [9.23e-09, 3.53450109212, 227.5261894396],
                        [1.059e-08, 0.13532061468, 416.3032501375],
                        [8.36e-09, 2.07492422755, 1056.2005364515],
                        [8.89e-09, 1.75177808106, 1898.3512179396],
                        [7.72e-09, 2.89217715561, 2008.557539159],
                        [1.014e-08, 2.80847772922, 1464.6394800628],
                        [8.2e-09, 1.99735697577, 2111.6503133776],
                        [7.87e-09, 4.91912237671, 1055.4497769261],
                        [7.43e-09, 2.6520965069, 106.2741679563],
                        [7.05e-09, 0.08006443278, 963.4027029714],
                        [7.24e-09, 3.29664246938, 628.8515860501],
                        [7.91e-09, 1.6465520211, 2001.4439921582],
                        [8.22e-09, 2.74067639972, 618.5566453116],
                        [7.61e-09, 1.26393500358, 1382.8873468466],
                        [6.5e-09, 1.19590511216, 422.6660376129],
                        [6.77e-09, 1.88476058357, 2104.5367663768],
                        [6.81e-09, 5.47481665606, 5760.4984318976],
                        [6.81e-09, 3.11621209674, 5746.271337896],
                        [6.44e-09, 4.68385640894, 611.4430983108],
                        [7.52e-09, 3.03497138894, 2221.856634597],
                        [6.41e-09, 1.86274530783, 636.7158925763],
                        [6.14e-09, 3.0767735667, 380.12776796],
                        [6.35e-09, 4.53916684689, 9676.4810341156],
                        [6.35e-09, 0.61458805483, 9690.7081281172],
                        [8.22e-09, 6.25170365084, 423.4167971383],
                        [7.62e-09, 4.32362906505, 1802.3719907218],
                        [5.82e-09, 0.84137872868, 1891.2376709388],
                        [5.58e-09, 3.96171840325, 440.8252848776],
                        [6.24e-09, 2.83657771014, 1905.4647649404],
                        [7.11e-09, 3.43538032357, 824.7421937488],
                        [5.17e-09, 1.10660016329, 107.0249274817],
                        [5.35e-09, 1.55761050176, 1994.3304451574],
                        [5.01e-09, 4.44389802599, 647.0108333148],
                        [4.14e-09, 5.37130370397, 2228.9701815978],
                        [5.33e-09, 2.54756313371, 1781.0313497194],
                        [3.93e-09, 1.26351262287, 210.1177017003],
                        [4.33e-09, 2.90103969634, 1063.3140834523],
                        [3.84e-09, 1.36194621083, 203.0041546995],
                        [4.4e-09, 1.46934545869, 2214.7430875962],
                        [4.24e-09, 4.98974282486, 3178.1457905676],
                        [3.38e-09, 2.72210106345, 2324.9494088156],
                        [3.32e-09, 0.37505564414, 2655.5683724738],
                        [3.18e-09, 6.11024720065, 934.9485149682],
                        [4.05e-09, 3.51005860013, 2751.5475996916],
                        [3.88e-09, 5.00609647265, 2015.6710861598],
                        [4.24e-09, 4.29668654117, 5753.3848848968],
                        [3.28e-09, 2.35571531981, 1251.3403846248],
                        [3.16e-09, 0.16949503062, 1279.794572628],
                        [3.45e-09, 2.89328206121, 2957.7331481288],
                        [3.03e-09, 1.63964826684, 2428.0421830342],
                        [3.28e-09, 3.36132375845, 1141.1340634054],
                        [2.94e-09, 2.48947693371, 2641.3412784722],
                        [3.5e-09, 1.50537240918, 2317.8358618148],
                        [2.87e-09, 1.69638214958, 2420.9286360334],
                        [2.72e-09, 0.27466529753, 319.5732633943],
                        [3.03e-09, 2.43034117616, 70.8494453042],
                        [2.51e-09, 0.43544711316, 3259.8979237838],
                        [2.24e-09, 4.49752269293, 5223.6939198022],
                        [2.72e-09, 2.98590404673, 1457.525933062],
                        [2.28e-09, 5.47896916415, 1603.2999892854],
                        [2.88e-09, 2.30146999217, 2854.6403739102],
                        [2.07e-09, 5.94297320087, 9153.9036160218],
                        [2.43e-09, 1.58604251447, 2744.4340526908],
                        [2.28e-09, 1.28182702946, 2310.722314814],
                        [2.24e-09, 1.28623905132, 3060.8259223474],
                        [2.22e-09, 0.63265553397, 3163.918696566],
                        [2.42e-09, 2.52382905368, 3274.1250177854],
                        [1.88e-09, 6.00513627145, 92.0470739547],
                        [2.39e-09, 1.93897157244, 2413.8150890326],
                        [2.14e-09, 1.14529237568, 2531.1349572528],
                        [2e-09, 3.42280996072, 99.1606209555],
                        [1.79e-09, 0.53892926207, 2207.6295405954],
                        [1.77e-09, 5.56545270243, 2332.0629558164],
                        [1.72e-09, 1.38604067808, 945.9942152321],
                        [2.03e-09, 0.41899069603, 2840.4132799086],
                        [2.31e-09, 2.2635333046, 2097.423219376],
                        [2.28e-09, 3.82701076821, 113.3877149571],
                        [1.65e-09, 4.08776703733, 6283.0758499914],
                        [2.02e-09, 3.30429764992, 3067.9394693482],
                        [2.24e-09, 3.69285208525, 2435.155730035],
                        [2.14e-09, 2.55756944911, 2538.2485042536],
                        [2.03e-09, 2.24205059922, 67.6680515665],
                        [1.52e-09, 5.48122906518, 10213.285546211],
                        [1.91e-09, 2.68685722531, 1773.9178027186],
                        [1.89e-09, 2.95184620359, 732.6951197941],
                        [1.49e-09, 1.98737542735, 1049.0869894507],
                        [1.63e-09, 1.24084734609, 3053.7123753466],
                        [1.71e-09, 2.34210749987, 1354.4331588434],
                        [1.12e-09, 5.7740728579, 547.8502123593],
                        [1.24e-09, 0.14001204498, 860.3099287528],
                        [8.6e-10, 1.26924601636, 511.5317178299],
                        [1.14e-09, 5.1598283807, 1592.2542890215],
                        [9.1e-10, 1.48896790758, 1567.7322542814],
                        [8.6e-10, 4.34444949905, 1069.6768709277],
                      ],
          },
          {
            series => "L3",
            terms  => [
                        [6.501665e-05, 2.59862880482, 7.1135470008],
                        [1.356524e-05, 1.34635886411, 529.6909650946],
                        [4.70716e-06, 2.47503977883, 14.2270940016],
                        [4.1696e-06, 3.24451243214, 536.8045120954],
                        [3.52851e-06, 2.97360159003, 522.5774180938],
                        [1.5488e-06, 2.07565585817, 1059.3819301892],
                        [8.6771e-07, 2.51431584316, 515.463871093],
                        [3.3538e-07, 3.82633794497, 1066.49547719],
                        [4.4378e-07, 0, 0],
                        [2.2644e-07, 2.98231326774, 543.9180590962],
                        [2.3737e-07, 1.27667172313, 412.3710968744],
                        [2.8457e-07, 2.44754756058, 206.1855484372],
                        [1.9798e-07, 2.10099934005, 639.897286314],
                        [1.974e-07, 1.40255938973, 419.4846438752],
                        [1.8768e-07, 1.593684035, 103.0927742186],
                        [1.7033e-07, 2.30214681202, 21.3406410024],
                        [1.6774e-07, 2.59821460673, 1589.0728952838],
                        [1.6214e-07, 3.14521117299, 625.6701923124],
                        [1.6055e-07, 3.36030126297, 1052.2683831884],
                        [1.3392e-07, 2.75973892202, 95.9792272178],
                        [1.3234e-07, 2.5386224434, 199.0720014364],
                        [1.2611e-07, 6.265781104, 426.598190876],
                        [8.637e-08, 2.26563256289, 110.2063212194],
                        [6.725e-08, 3.42566433316, 309.2783226558],
                        [8.701e-08, 1.76334960737, 10.2949407385],
                        [6.527e-08, 4.03869562907, 728.762966531],
                        [5.368e-08, 5.25196153539, 323.5054166574],
                        [5.675e-08, 2.52096417685, 508.3503240922],
                        [5.399e-08, 2.91184687105, 1045.1548361876],
                        [3.996e-08, 4.30290261177, 88.865680217],
                        [3.857e-08, 3.52381361552, 302.164775655],
                        [3.774e-08, 4.09125315146, 735.8765135318],
                        [3.269e-08, 1.43175991274, 956.2891559706],
                        [2.783e-08, 4.3581750767, 1596.1864422846],
                        [2.661e-08, 1.25276590759, 213.299095438],
                        [2.553e-08, 2.23785673285, 117.3198682202],
                        [2.371e-08, 2.89662409244, 742.9900605326],
                        [2.656e-08, 5.01505839848, 838.9692877504],
                        [1.948e-08, 2.77248294666, 1169.5882514086],
                        [2.279e-08, 2.3558187123, 942.062061969],
                        [1.474e-08, 1.61011468581, 220.4126424388],
                        [1.457e-08, 3.09381959396, 2118.7638603784],
                        [1.937e-08, 5.01388256693, 831.8557407496],
                        [1.585e-08, 1.40097680805, 405.2575498736],
                        [1.257e-08, 3.97811260358, 1155.361157407],
                        [1.227e-08, 3.45959919972, 1073.6090241908],
                        [9.86e-09, 3.39209446167, 532.8723588323],
                        [9.42e-09, 2.70200385825, 191.9584544356],
                        [8.28e-09, 1.48348768286, 632.7837393132],
                        [7.97e-09, 1.1070668885, 1162.4747044078],
                        [8.22e-09, 3.30295824153, 1258.4539316256],
                        [7.1e-09, 5.8979877198, 853.196381752],
                        [7.66e-09, 3.66351539483, 1581.959348283],
                        [7.22e-09, 3.74673245797, 433.7117378768],
                        [6.63e-09, 2.93063953915, 1574.8458012822],
                        [6.58e-09, 3.52797311863, 525.7588118315],
                        [6.09e-09, 4.14881313523, 721.6494195302],
                        [5.98e-09, 4.69454609357, 81.7521332162],
                        [6.68e-09, 1.96442971289, 1272.6810256272],
                        [5.15e-09, 1.57251270902, 949.1756089698],
                        [6.58e-09, 2.02329201466, 526.5095713569],
                        [5.17e-09, 4.35827478516, 1368.660252845],
                        [5.1e-09, 4.95846155301, 1148.2476104062],
                        [5.07e-09, 4.31396370095, 330.6189636582],
                        [5.67e-09, 2.27813343743, 551.031606097],
                        [4.8e-09, 3.86758235988, 1361.5467058442],
                        [3.83e-09, 0.24287136454, 611.4430983108],
                        [4.34e-09, 2.9546175554, 1038.0412891868],
                        [3.77e-09, 1.42957648215, 124.433415221],
                        [3.91e-09, 4.07770324592, 1471.7530270636],
                        [3.85e-09, 4.702951798, 519.3960243561],
                        [4.28e-09, 2.22472522305, 539.9859058331],
                        [3.43e-09, 4.83463725823, 2125.8774073792],
                        [3.94e-09, 4.52891996323, 1464.6394800628],
                        [3.05e-09, 2.02797683648, 1485.9801210652],
                        [2.83e-09, 0.97461612169, 1905.4647649404],
                        [2.76e-09, 3.83552772064, 1062.5633239269],
                        [3.51e-09, 2.06334334462, 533.6231183577],
                        [3.04e-09, 3.93228052293, 1685.0521225016],
                        [3.22e-09, 3.54763044791, 846.0828347512],
                        [3.45e-09, 4.18332148409, 1788.1448967202],
                        [2.53e-09, 3.12703531516, 1994.3304451574],
                        [2.57e-09, 1.05361498985, 1478.8665740644],
                        [2.32e-09, 1.69999081817, 1692.1656695024],
                        [2.25e-09, 2.5162414978, 1891.2376709388],
                        [2.17e-09, 4.58512911216, 963.4027029714],
                        [2.77e-09, 3.63353707701, 1677.9385755008],
                        [2.42e-09, 2.90163762388, 2310.722314814],
                        [2.11e-09, 3.96419403991, 295.0512286542],
                        [1.99e-09, 5.1704650075, 618.5566453116],
                        [2.56e-09, 4.19052619061, 1781.0313497194],
                        [1.92e-09, 0.81556540966, 2221.856634597],
                        [1.87e-09, 3.49895198981, 2648.454825473],
                        [2.08e-09, 4.11838429822, 2097.423219376],
                        [1.83e-09, 3.30680692414, 1699.2792165032],
                        [2.31e-09, 2.54516792766, 1375.7737998458],
                        [1.89e-09, 5.74277274755, 2627.1141844706],
                        [2.14e-09, 5.48031974537, 1354.4331588434],
                        [2.2e-09, 3.8747198941, 2104.5367663768],
                        [1.71e-09, 6.10827209399, 1382.8873468466],
                        [1.84e-09, 5.98415847544, 750.1036075334],
                        [1.71e-09, 5.25744961028, 824.7421937488],
                        [1.51e-09, 4.30799091626, 2001.4439921582],
                        [1.4e-09, 4.2708946607, 1265.5674786264],
                        [9.7e-10, 4.67188056608, 647.0108333148],
                        [8.8e-10, 2.43775210355, 440.8252848776],
                        [7.5e-10, 3.93105183253, 1055.4497769261],
                        [7.9e-10, 1.8853315322, 934.9485149682],
                        [7.7e-10, 3.80503143236, 1603.2999892854],
                      ],
          },
          {
            series => "L4",
            terms  => [
                        [6.69483e-06, 0.8528242109, 7.1135470008],
                        [9.9961e-07, 0.74258947751, 14.2270940016],
                        [1.14019e-06, 3.14159265359, 0],
                        [5.0024e-07, 1.65346208248, 536.8045120954],
                        [4.3585e-07, 5.82026386621, 529.6909650946],
                        [3.1813e-07, 4.8582998665, 522.5774180938],
                        [1.4742e-07, 4.29061635784, 515.463871093],
                        [8.899e-08, 0.71478520741, 1059.3819301892],
                        [4.957e-08, 1.29502259434, 543.9180590962],
                        [4.484e-08, 2.31715516627, 1066.49547719],
                        [4.251e-08, 0.48326797501, 21.3406410024],
                        [3.1e-08, 3.00245542678, 412.3710968744],
                        [2.055e-08, 0.39858940218, 639.897286314],
                        [1.762e-08, 4.90536207307, 625.6701923124],
                        [1.902e-08, 4.25925620271, 199.0720014364],
                        [1.695e-08, 4.26147580803, 206.1855484372],
                        [1.375e-08, 5.25546955667, 1052.2683831884],
                        [1.203e-08, 4.71614633845, 95.9792272178],
                        [1.086e-08, 1.28604571172, 1589.0728952838],
                        [9.82e-09, 4.77990073662, 1045.1548361876],
                        [9.35e-09, 6.05847062188, 88.865680217],
                        [9.16e-09, 5.77537499431, 728.762966531],
                        [8.9e-09, 4.55299189579, 426.598190876],
                        [7.84e-09, 3.4016156795, 419.4846438752],
                        [7.68e-09, 3.54672049322, 103.0927742186],
                        [6.7e-09, 0.522233077, 110.2063212194],
                        [4.15e-09, 5.22809480633, 302.164775655],
                        [3.93e-09, 6.24184621807, 956.2891559706],
                        [3.81e-09, 5.2546696604, 309.2783226558],
                        [4.21e-09, 0.59561318533, 117.3198682202],
                        [3.46e-09, 4.78348312106, 508.3503240922],
                        [3.19e-09, 3.47979828725, 323.5054166574],
                        [3.31e-09, 2.95893485883, 1596.1864422846],
                        [2.95e-09, 4.32713459459, 942.062061969],
                        [3.19e-09, 0.47990052824, 831.8557407496],
                        [2.51e-09, 1.79898001222, 1073.6090241908],
                        [2.12e-09, 0.43917684084, 220.4126424388],
                        [1.88e-09, 1.12654974776, 1169.5882514086],
                        [1.88e-09, 2.16135407548, 1361.5467058442],
                        [1.8e-09, 3.43266428069, 1148.2476104062],
                        [1.64e-09, 1.92864127211, 2118.7638603784],
                        [1.57e-09, 3.02963907392, 1272.6810256272],
                        [9.3e-10, 5.60436000012, 1581.959348283],
                        [8.5e-10, 5.023172562, 1155.361157407],
                        [7.5e-10, 3.13198879608, 632.7837393132],
                      ],
          },
          {
            series => "L5",
            terms  => [
                        [4.9577e-07, 5.25658966184, 7.1135470008],
                        [1.5761e-07, 5.25126837478, 14.2270940016],
                        [4.343e-08, 0.01461869263, 536.8045120954],
                        [1.526e-08, 1.09739911439, 522.5774180938],
                        [7.28e-09, 5.85949047619, 543.9180590962],
                        [6.94e-09, 0.87382487754, 515.463871093],
                        [8.45e-09, 3.14159265359, 0],
                        [4.56e-09, 0.81521692852, 1066.49547719],
                        [2.93e-09, 5.62909357048, 1059.3819301892],
                        [9e-10, 0.2117811971, 529.6909650946],
                      ],
          },
        ],
        [
          {
            series => "B0",
            terms  => [
                        [0.02268615703, 3.55852606718, 529.6909650946],
                        [0.00109971634, 3.90809347389, 1059.3819301892],
                        [0.00110090358, 0, 0],
                        [8.101427e-05, 3.60509573368, 522.5774180938],
                        [6.043996e-05, 4.25883108794, 1589.0728952838],
                        [6.437782e-05, 0.30627121409, 536.8045120954],
                        [1.10688e-05, 2.98534421928, 1162.4747044078],
                        [9.41651e-06, 2.93619072405, 1052.2683831884],
                        [8.94088e-06, 1.75447429921, 7.1135470008],
                        [7.6728e-06, 2.1547359406, 632.7837393132],
                        [9.44328e-06, 1.67522288396, 426.598190876],
                        [6.8422e-06, 3.67808770098, 213.299095438],
                        [6.29223e-06, 0.64343282328, 1066.49547719],
                        [8.35861e-06, 5.17881973234, 103.0927742186],
                        [5.3167e-06, 2.70305954352, 110.2063212194],
                        [5.58524e-06, 0.01354830508, 846.0828347512],
                        [4.64449e-06, 1.17337249185, 949.1756089698],
                        [4.31072e-06, 2.60825000494, 419.4846438752],
                        [3.51433e-06, 4.61062990714, 2118.7638603784],
                        [1.23148e-06, 3.34968181384, 1692.1656695024],
                        [1.15038e-06, 5.04892295442, 316.3918696566],
                        [1.3216e-06, 4.7781699067, 742.9900605326],
                        [1.03402e-06, 2.31878999565, 1478.8665740644],
                        [1.16379e-06, 1.38688232033, 323.5054166574],
                        [1.0242e-06, 3.15293785436, 1581.959348283],
                        [1.03762e-06, 3.7010383811, 515.463871093],
                        [7.865e-07, 3.98318653238, 1265.5674786264],
                        [6.9935e-07, 2.56006216424, 956.2891559706],
                        [5.5597e-07, 0.37500753017, 1375.7737998458],
                        [5.1986e-07, 0.99007119033, 1596.1864422846],
                        [5.5194e-07, 0.40176412035, 525.7588118315],
                        [6.3456e-07, 4.50073574333, 735.8765135318],
                        [4.9691e-07, 0.18649893085, 543.9180590962],
                        [4.8831e-07, 3.57260550671, 533.6231183577],
                        [2.8353e-07, 1.53532744749, 625.6701923124],
                        [2.9209e-07, 5.43145863011, 206.1855484372],
                        [2.3255e-07, 5.95197992848, 838.9692877504],
                        [2.2841e-07, 6.19262787685, 532.8723588323],
                        [2.3202e-07, 4.06473368575, 526.5095713569],
                        [2.4436e-07, 6.10947656959, 1169.5882514086],
                        [2.1116e-07, 4.96322972735, 2648.454825473],
                        [1.7879e-07, 3.08704395969, 1795.258443721],
                        [1.6234e-07, 4.83515727869, 1368.660252845],
                        [2.1314e-07, 2.69476951059, 1045.1548361876],
                        [1.574e-07, 1.15130330106, 942.062061969],
                        [1.7325e-07, 1.61550009206, 14.2270940016],
                        [1.3396e-07, 2.30539585502, 853.196381752],
                        [1.1904e-07, 3.09811974536, 2111.6503133776],
                        [1.1734e-07, 2.83006431723, 2008.557539159],
                        [1.1291e-07, 0.98957560201, 433.7117378768],
                        [1.183e-07, 4.76527836803, 309.2783226558],
                        [1.0702e-07, 3.70181397065, 2221.856634597],
                        [1.0815e-07, 5.81958878617, 1272.6810256272],
                        [1.3505e-07, 3.2812697576, 1155.361157407],
                        [1.0179e-07, 2.58691128827, 117.3198682202],
                        [1.0632e-07, 5.23487936086, 95.9792272178],
                        [8.771e-08, 0.40456546655, 220.4126424388],
                        [7.439e-08, 2.94638292086, 412.3710968744],
                        [6.151e-08, 2.69100382247, 380.12776796],
                        [5.028e-08, 0.72750312028, 1055.4497769261],
                        [4.939e-08, 0.73756716762, 1905.4647649404],
                        [5.421e-08, 4.08612438558, 1685.0521225016],
                        [5.936e-08, 4.32059910537, 1063.3140834523],
                        [4.737e-08, 4.0930301685, 527.2432845398],
                        [4.01e-08, 0.51530008355, 1073.6090241908],
                        [4.709e-08, 1.84067645204, 984.6003316219],
                        [3.974e-08, 1.33608029246, 2125.8774073792],
                        [3.762e-08, 3.58647039394, 529.7391492044],
                        [4.731e-08, 6.16377350841, 532.1386456494],
                        [4.666e-08, 5.88762905802, 639.897286314],
                        [3.763e-08, 0.38865925413, 529.6427809848],
                        [3.409e-08, 4.05398247269, 1898.3512179396],
                        [3.457e-08, 3.43865563497, 1485.9801210652],
                        [4.229e-08, 2.23767157901, 74.7815985673],
                        [3.091e-08, 0.16470256025, 1699.2792165032],
                        [2.975e-08, 0.72268908074, 530.6541729411],
                        [3.162e-08, 1.2504841642, 330.6189636582],
                        [2.727e-08, 4.37679213321, 149.5631971346],
                        [2.837e-08, 0.05987107395, 1439.5096981492],
                        [2.983e-08, 3.2525120722, 528.7277572481],
                        [2.232e-08, 0.26149880534, 1062.5633239269],
                        [2.464e-08, 1.1691330442, 453.424893819],
                        [2.596e-08, 3.30510149086, 2324.9494088156],
                        [1.988e-08, 2.85269577619, 1574.8458012822],
                        [2.527e-08, 5.9445820295, 909.8187330546],
                        [2.269e-08, 1.30379329597, 3.9321532631],
                        [1.742e-08, 4.49909767044, 1258.4539316256],
                        [1.714e-08, 4.12945878208, 2001.4439921582],
                        [2.029e-08, 3.97938086639, 1056.2005364515],
                        [1.667e-08, 0.36037092553, 10213.285546211],
                        [1.579e-08, 6.11640144795, 1802.3719907218],
                        [1.393e-08, 3.69324470827, 2214.7430875962],
                        [1.604e-08, 1.98841031703, 38.1330356378],
                        [1.325e-08, 1.74025919863, 529.1697002328],
                        [1.451e-08, 2.39804501178, 2428.0421830342],
                        [1.594e-08, 2.07556780757, 1021.2488945514],
                        [1.32e-08, 1.33770977126, 618.5566453116],
                        [1.346e-08, 3.2759149254, 2641.3412784722],
                        [1.23e-08, 0.1955272822, 305.3461693927],
                        [1.223e-08, 2.86681556337, 1382.8873468466],
                        [1.324e-08, 2.23549334986, 530.2122299564],
                        [1.056e-08, 3.80579750957, 76.2660712756],
                        [1.05e-08, 4.68011652614, 1788.1448967202],
                        [1.226e-08, 5.34003255221, 3178.1457905676],
                        [1.009e-08, 3.19608028376, 2538.2485042536],
                        [1.266e-08, 3.04704446731, 604.4725636619],
                        [9.54e-09, 3.86932544808, 728.762966531],
                        [1.124e-08, 1.5956036748, 3.1813937377],
                        [9.78e-09, 0.25223689838, 983.1158589136],
                        [9.48e-09, 0.21552742733, 750.1036075334],
                        [9.46e-09, 3.9392774812, 508.3503240922],
                        [9.2e-09, 1.14672086939, 963.4027029714],
                        [8.17e-09, 5.93809619876, 831.8557407496],
                        [7.7e-09, 2.96062737592, 526.7702037878],
                        [1.017e-08, 5.55711112145, 199.0720014364],
                        [7.61e-09, 1.38163787157, 532.6117264014],
                        [7.26e-09, 3.98337964395, 2317.8358618148],
                        [8.62e-09, 0.87975657414, 490.3340891794],
                        [8.68e-09, 3.44331872364, 569.0478410098],
                        [7.11e-09, 4.11107052823, 2751.5475996916],
                        [7.08e-09, 0.33555577415, 528.9402055692],
                        [7.08e-09, 4.00539820601, 530.44172462],
                        [6.56e-09, 4.39568451439, 519.3960243561],
                        [8.01e-09, 4.03984430862, 1364.7280995819],
                        [6.79e-09, 1.18645749024, 525.4981794006],
                        [6.45e-09, 5.10510349996, 1361.5467058442],
                        [6.68e-09, 3.15607509055, 533.8837507886],
                        [6.63e-09, 0.73722024843, 5223.6939198022],
                        [6.63e-09, 1.57092786811, 6283.0758499914],
                        [5.43e-09, 0.26376529935, 227.5261894396],
                        [5.25e-09, 6.22318693939, 539.9859058331],
                        [5.13e-09, 4.98337900151, 302.164775655],
                        [5.44e-09, 2.22227019273, 2744.4340526908],
                        [5.32e-09, 2.62425372687, 99.1606209555],
                        [6.02e-09, 1.56074089013, 454.9093665273],
                        [5.18e-09, 0.26343805959, 551.031606097],
                        [5.16e-09, 1.09376390349, 934.9485149682],
                        [6.59e-09, 0.62560671589, 1512.8068240082],
                        [5.24e-09, 0.64710955846, 524.0618908021],
                        [5.16e-09, 3.69478866795, 535.3200393871],
                        [4.91e-09, 3.63039940597, 2531.1349572528],
                        [5.7e-09, 0.61976758791, 540.7366653585],
                        [4.96e-09, 2.19398015038, 1514.2912967165],
                        [5.32e-09, 0.20040217534, 525.0250986486],
                        [4.93e-09, 0.39160693598, 224.3447957019],
                        [4.49e-09, 0.62392433691, 529.5309064002],
                        [4.49e-09, 3.71676131146, 529.851023789],
                        [4.5e-09, 5.02467015031, 1048.3362299253],
                        [4.28e-09, 5.4480466029, 11.0457002639],
                        [4.99e-09, 4.13924061941, 534.3568315406],
                        [5.28e-09, 1.76471074936, 524.2743391232],
                        [4.54e-09, 4.53321742354, 1056.9342496344],
                        [5.2e-09, 2.57406093768, 535.107591066],
                        [3.98e-09, 1.40345870113, 960.2213092337],
                        [4.57e-09, 4.17708652827, 2104.5367663768],
                        [5.05e-09, 5.36536256321, 1057.8974574809],
                        [5.35e-09, 4.80455380313, 1593.0050485469],
                        [4.15e-09, 0.96548127237, 2435.155730035],
                        [5.19e-09, 0.54543519483, 1061.829610744],
                        [3.59e-09, 4.02704454075, 1059.430114299],
                        [3.56e-09, 2.66818105522, 835.0371344873],
                        [4.43e-09, 5.27513700376, 1.4844727083],
                        [3.58e-09, 5.94423960514, 440.8252848776],
                        [4.71e-09, 6.05791940453, 1471.7530270636],
                        [3.86e-09, 2.15984900214, 9153.9036160218],
                        [4.24e-09, 2.7092967003, 1038.0412891868],
                        [3.59e-09, 0.82922836987, 1059.3337460794],
                        [3.1e-09, 0.88102053266, 529.9034134157],
                        [3.1e-09, 3.45966511571, 529.4785167735],
                        [3e-09, 3.70331799503, 2634.2277314714],
                        [2.92e-09, 2.63594456361, 415.5524906121],
                        [2.79e-09, 1.60669121578, 643.8294395771],
                        [2.91e-09, 5.8313407182, 1148.2476104062],
                        [3.7e-09, 5.71572992274, 531.1754378029],
                        [2.68e-09, 5.39275891813, 1891.2376709388],
                        [2.75e-09, 3.34108666036, 518.6452648307],
                        [2.69e-09, 1.06051406954, 1585.1407420207],
                        [3.06e-09, 2.5028901737, 511.5317178299],
                        [2.95e-09, 1.84394223501, 547.8502123593],
                        [2.54e-09, 2.98312992496, 1134.1635287565],
                        [2.89e-09, 1.86070918711, 21.3406410024],
                        [2.65e-09, 4.93075479744, 679.2541622292],
                        [2.5e-09, 0.42860925124, 1969.2006632438],
                        [3.08e-09, 2.67237933272, 2957.7331481288],
                        [3.13e-09, 4.88085697819, 528.2064923863],
                        [2.22e-09, 4.78828764413, 514.7131115676],
                        [2.21e-09, 4.32763468981, 1677.9385755008],
                        [2.17e-09, 3.46278526461, 2950.619601128],
                        [2.16e-09, 0.5220766798, 2228.9701815978],
                        [2.14e-09, 5.83569926578, 544.6688186216],
                        [2.83e-09, 2.8870971609, 35.4247226521],
                        [2.72e-09, 1.65708415457, 3060.8259223474],
                        [2.34e-09, 1.68821537711, 2655.5683724738],
                        [2.05e-09, 3.3618688829, 2847.5268269094],
                        [2.64e-09, 3.62722625694, 2420.9286360334],
                        [1.91e-09, 4.26821147044, 430.5303441391],
                        [1.79e-09, 3.91470663005, 3340.6124266998],
                        [1.8e-09, 0.04531671003, 387.2413149608],
                        [2.41e-09, 4.03927631611, 494.2662424425],
                        [1.76e-09, 4.26298906325, 672.1406152284],
                        [1.87e-09, 2.72587420586, 299.1263942692],
                        [2.34e-09, 1.3447482745, 173.9422195228],
                        [1.71e-09, 0.85473611718, 1603.2999892854],
                        [2.24e-09, 0.33130232434, 565.1156877467],
                        [2e-09, 1.27632489123, 39.3568759152],
                        [1.7e-09, 4.96479470273, 1464.6394800628],
                        [2.11e-09, 1.00937080256, 523.5406259403],
                        [2.1e-09, 3.75793720248, 2854.6403739102],
                        [1.62e-09, 5.87784787295, 3480.3105662226],
                        [1.63e-09, 4.62850343495, 2015.6710861598],
                        [1.91e-09, 3.3315928375, 535.8413042489],
                        [1.51e-09, 1.17096741034, 1060.3451380357],
                        [1.6e-09, 1.81852636004, 312.4597163935],
                        [1.58e-09, 2.59595816107, 529.4303326637],
                        [1.58e-09, 1.7447274873, 529.9515975255],
                        [1.73e-09, 3.62399350412, 230.5645708254],
                        [1.42e-09, 0.70435921398, 522.529233984],
                        [1.44e-09, 5.3576312243, 107.0249274817],
                        [1.44e-09, 6.13954848857, 1158.5425511447],
                        [1.78e-09, 0.27566275049, 3906.9087570986],
                        [1.26e-09, 5.14832919826, 2207.6295405954],
                        [1.26e-09, 3.41994798109, 2.4476805548],
                        [1.27e-09, 0.39825164051, 70.8494453042],
                        [1.23e-09, 4.77865550523, 2524.021410252],
                        [1.23e-09, 0.46184813516, 647.0108333148],
                        [1.44e-09, 3.60261852727, 1058.4187223427],
                        [1.58e-09, 3.76231915252, 92.0470739547],
                        [1.19e-09, 4.08266911415, 1585.8915015461],
                        [1.25e-09, 2.35496721797, 3163.918696566],
                        [1.22e-09, 3.21027426317, 3377.217792004],
                        [1.21e-09, 3.39770381916, 18.1592472647],
                        [1.31e-09, 1.67926417552, 1289.9465010146],
                        [1.15e-09, 2.35735471566, 1550.939859646],
                        [1.26e-09, 2.40833814513, 106.2741679563],
                        [1.31e-09, 1.37610474529, 1023.9572075371],
                        [1.21e-09, 1.60252617273, 10.2949407385],
                        [1.21e-09, 0.61420823557, 1592.2542890215],
                        [1.35e-09, 3.60177675518, 124.433415221],
                        [1.37e-09, 2.41724947062, 3274.1250177854],
                        [1.29e-09, 0.09702914345, 2332.0629558164],
                        [9.3e-10, 4.88949890397, 1098.7388061044],
                        [1.06e-09, 5.18592950792, 2281.2304965106],
                        [1.14e-09, 2.96523316419, 1166.4068576709],
                        [9.2e-10, 1.65166124027, 860.3099287528],
                        [1.02e-09, 3.64093193142, 3171.0322435668],
                        [1.03e-09, 1.63066232967, 1894.4190646765],
                        [8e-10, 0.38766601876, 4694.0029547076],
                        [7.4e-10, 3.86865238736, 3067.9394693482],
                        [9.5e-10, 1.66362447044, 1151.4290041439],
                      ],
          },
          {
            series => "B1",
            terms  => [
                        [0.00177351787, 5.70166488486, 529.6909650946],
                        [3.230171e-05, 5.7794161934, 1059.3819301892],
                        [3.081364e-05, 5.47464296527, 522.5774180938],
                        [2.211914e-05, 4.73477480209, 536.8045120954],
                        [1.694232e-05, 3.14159265359, 0],
                        [3.46445e-06, 4.74595174109, 1052.2683831884],
                        [2.34264e-06, 5.18856099929, 1066.49547719],
                        [1.96154e-06, 6.18554286642, 7.1135470008],
                        [1.50468e-06, 3.92721226087, 1589.0728952838],
                        [1.14128e-06, 3.4389727183, 632.7837393132],
                        [9.6667e-07, 2.9142630409, 949.1756089698],
                        [7.6599e-07, 2.50522188662, 103.0927742186],
                        [8.1671e-07, 5.07666097497, 1162.4747044078],
                        [7.6572e-07, 0.61288981445, 419.4846438752],
                        [7.3875e-07, 5.49958292155, 515.463871093],
                        [4.9915e-07, 3.94799616572, 735.8765135318],
                        [6.0544e-07, 5.44740084359, 213.299095438],
                        [3.6561e-07, 4.69828392839, 543.9180590962],
                        [4.6032e-07, 0.53850360901, 110.2063212194],
                        [4.5123e-07, 1.89516645239, 846.0828347512],
                        [3.6019e-07, 6.10952578764, 316.3918696566],
                        [3.1975e-07, 4.92452714629, 1581.959348283],
                        [2.1015e-07, 5.6295773141, 1596.1864422846],
                        [2.3156e-07, 5.84829490183, 323.5054166574],
                        [2.4719e-07, 3.94107395247, 2118.7638603784],
                        [1.7274e-07, 5.65310656429, 533.6231183577],
                        [1.6521e-07, 5.89840100621, 526.5095713569],
                        [1.6698e-07, 5.66663034948, 1265.5674786264],
                        [1.5815e-07, 4.43314786393, 1045.1548361876],
                        [1.3398e-07, 4.30179033605, 532.8723588323],
                        [1.1744e-07, 1.80990486955, 956.2891559706],
                        [1.1925e-07, 4.30094564154, 525.7588118315],
                        [9.514e-08, 2.02589667166, 206.1855484372],
                        [1.0542e-07, 6.15533910933, 14.2270940016],
                        [8.414e-08, 3.9291045034, 1478.8665740644],
                        [8.099e-08, 4.20152809071, 1169.5882514086],
                        [7.712e-08, 2.99160389601, 942.062061969],
                        [8.825e-08, 1.55897920307, 426.598190876],
                        [8.884e-08, 4.87430124264, 1155.361157407],
                        [7.793e-08, 3.84684930196, 625.6701923124],
                        [5.646e-08, 3.40915964493, 639.897286314],
                        [4.615e-08, 0.83374662294, 117.3198682202],
                        [4.02e-08, 5.50502127885, 433.7117378768],
                        [3.704e-08, 0.90226777963, 95.9792272178],
                        [3.859e-08, 0.69640284662, 853.196381752],
                        [3.091e-08, 5.09115860882, 1073.6090241908],
                        [3.36e-08, 5.10133284081, 1692.1656695024],
                        [2.892e-08, 4.9041891666, 220.4126424388],
                        [2.772e-08, 5.09066125724, 2111.6503133776],
                        [2.425e-08, 3.74438653232, 742.9900605326],
                        [2.558e-08, 5.46955948791, 1795.258443721],
                        [2.466e-08, 4.2227835543, 2648.454825473],
                        [1.968e-08, 0.57192251841, 309.2783226558],
                        [1.794e-08, 4.60765219417, 1272.6810256272],
                        [1.822e-08, 1.98842964323, 1375.7737998458],
                        [1.703e-08, 6.12660562937, 2125.8774073792],
                        [2.011e-08, 5.00936865256, 412.3710968744],
                        [1.645e-08, 0.08830372958, 1063.3140834523],
                        [1.875e-08, 5.81006158403, 330.6189636582],
                        [1.741e-08, 4.58650290431, 1574.8458012822],
                        [1.529e-08, 5.81660291389, 1258.4539316256],
                        [1.916e-08, 0.85150399517, 1368.660252845],
                        [1.614e-08, 4.36839107221, 728.762966531],
                        [1.51e-08, 2.79374165455, 1485.9801210652],
                        [1.333e-08, 4.84260898693, 1062.5633239269],
                        [1.359e-08, 5.16511980864, 838.9692877504],
                        [1.165e-08, 5.66275740881, 508.3503240922],
                        [1.092e-08, 4.68797557406, 1699.2792165032],
                        [1.438e-08, 5.78105679279, 1056.2005364515],
                        [1.083e-08, 3.99886917926, 1471.7530270636],
                        [1.002e-08, 4.79949608524, 1055.4497769261],
                        [7.49e-09, 6.1440086203, 519.3960243561],
                        [6.57e-09, 5.63765568876, 1898.3512179396],
                        [7.02e-09, 5.04126574492, 1685.0521225016],
                        [6.07e-09, 3.15707515246, 618.5566453116],
                        [5.87e-09, 1.37658820775, 199.0720014364],
                        [5.52e-09, 4.8065772945, 551.031606097],
                        [4.94e-09, 4.43417307482, 539.9859058331],
                        [5.17e-09, 0.05161181997, 3.1813937377],
                        [4.69e-09, 3.81715950042, 2008.557539159],
                        [4.15e-09, 1.34693184108, 1382.8873468466],
                        [3.82e-09, 4.86764073919, 227.5261894396],
                        [4.73e-09, 1.72405831407, 532.1386456494],
                        [4.58e-09, 4.44604993015, 1038.0412891868],
                        [3.76e-09, 2.23190744786, 529.6427809848],
                        [4.51e-09, 3.75869883836, 984.6003316219],
                        [3.76e-09, 5.42971857629, 529.7391492044],
                        [3.89e-09, 1.92698506631, 525.0250986486],
                        [3.64e-09, 3.35456685746, 2221.856634597],
                        [4.76e-09, 5.93625415892, 527.2432845398],
                        [3.83e-09, 6.12255867339, 149.5631971346],
                        [3.01e-09, 4.09378934049, 440.8252848776],
                        [3.1e-09, 5.58150418981, 2428.0421830342],
                        [2.82e-09, 4.85996662231, 1788.1448967202],
                        [2.98e-09, 5.09589374634, 528.7277572481],
                        [3.4e-09, 4.5653707022, 750.1036075334],
                        [2.72e-09, 2.3534696034, 534.3568315406],
                        [3.6e-09, 3.91050161665, 74.7815985673],
                        [2.99e-09, 1.43093538841, 909.8187330546],
                        [2.97e-09, 2.56584512211, 530.6541729411],
                        [2.35e-09, 4.81644489422, 535.107591066],
                        [3.06e-09, 0.68420442848, 380.12776796],
                        [2.36e-09, 4.63162956792, 526.7702037878],
                        [2.7e-09, 0.18549916939, 21.3406410024],
                        [2.88e-09, 4.26655874393, 1802.3719907218],
                        [1.96e-09, 5.35950443033, 2214.7430875962],
                        [1.9e-09, 4.5461519326, 2104.5367663768],
                        [1.93e-09, 4.35426216497, 511.5317178299],
                        [1.78e-09, 4.51895208036, 3178.1457905676],
                        [1.94e-09, 0.57050756837, 1361.5467058442],
                        [2e-09, 1.48040474749, 302.164775655],
                        [1.68e-09, 5.40141749419, 524.2743391232],
                        [1.52e-09, 0.68077486546, 1905.4647649404],
                        [1.49e-09, 1.06678990744, 831.8557407496],
                        [1.82e-09, 3.62401009613, 38.1330356378],
                        [1.76e-09, 5.64331384323, 963.4027029714],
                        [1.84e-09, 4.48850356629, 604.4725636619],
                        [1.33e-09, 5.45026366125, 2641.3412784722],
                        [1.43e-09, 2.21577268292, 1439.5096981492],
                        [1.3e-09, 4.88155705493, 2531.1349572528],
                        [1.29e-09, 6.15206333598, 547.8502123593],
                        [1.33e-09, 5.43193972385, 1603.2999892854],
                        [1.33e-09, 3.49297492409, 529.1697002328],
                        [1.32e-09, 3.98820790955, 530.2122299564],
                        [1.18e-09, 5.38352943814, 1891.2376709388],
                        [1.33e-09, 5.65694269884, 76.2660712756],
                        [1.45e-09, 2.94976686191, 454.9093665273],
                        [1.15e-09, 3.29206553804, 3.9321532631],
                        [1.02e-09, 4.48856749557, 2001.4439921582],
                        [1.06e-09, 6.08434275898, 10.2949407385],
                        [9.3e-10, 5.8473777184, 2324.9494088156],
                        [1.01e-09, 0.15815934254, 2655.5683724738],
                        [1.15e-09, 3.59221021604, 2015.6710861598],
                        [1.03e-09, 4.70399583323, 305.3461693927],
                        [8.4e-10, 0.44180206332, 1593.0050485469],
                        [9.2e-10, 2.44863388631, 490.3340891794],
                        [8.7e-10, 6.23817512863, 6283.0758499914],
                        [9.5e-10, 3.30154605532, 2317.8358618148],
                        [7.2e-10, 1.90578907085, 528.9402055692],
                        [7.2e-10, 5.57619428876, 530.44172462],
                        [7.8e-10, 5.97323507836, 1585.8915015461],
                      ],
          },
          {
            series => "B2",
            terms  => [
                        [8.094051e-05, 1.46322843658, 529.6909650946],
                        [7.42415e-06, 0.95691639003, 522.5774180938],
                        [8.13244e-06, 3.14159265359, 0],
                        [3.98951e-06, 2.89888666447, 536.8045120954],
                        [3.42226e-06, 1.44683789727, 1059.3819301892],
                        [7.3948e-07, 0.40724675866, 1052.2683831884],
                        [4.6151e-07, 3.48036895772, 1066.49547719],
                        [2.9314e-07, 0.99088831805, 515.463871093],
                        [2.9717e-07, 1.92504171329, 1589.0728952838],
                        [2.2753e-07, 4.27124052435, 7.1135470008],
                        [1.3916e-07, 2.92242387338, 543.9180590962],
                        [1.2067e-07, 5.22168932482, 632.7837393132],
                        [1.0703e-07, 4.88024222475, 949.1756089698],
                        [6.078e-08, 6.21089108431, 1045.1548361876],
                        [5.935e-08, 0.52977760072, 1581.959348283],
                        [5.037e-08, 1.43444929374, 526.5095713569],
                        [4.564e-08, 0.91811732585, 1162.4747044078],
                        [4.547e-08, 4.01953745202, 1596.1864422846],
                        [5.098e-08, 6.03169795231, 735.8765135318],
                        [3.593e-08, 4.54080164408, 110.2063212194],
                        [3.443e-08, 1.38618954572, 533.6231183577],
                        [3.277e-08, 4.39650286553, 14.2270940016],
                        [3.407e-08, 0.42275631534, 419.4846438752],
                        [2.904e-08, 2.06041641723, 316.3918696566],
                        [2.541e-08, 3.98323842017, 323.5054166574],
                        [3.113e-08, 2.48079280193, 2118.7638603784],
                        [3.061e-08, 2.39880866911, 532.8723588323],
                        [2.155e-08, 4.7799063714, 942.062061969],
                        [2.143e-08, 3.88727338786, 426.598190876],
                        [2.252e-08, 0.3719643412, 1155.361157407],
                        [2.019e-08, 3.89985000464, 846.0828347512],
                        [1.857e-08, 1.19658907851, 103.0927742186],
                        [1.683e-08, 1.42264195434, 1265.5674786264],
                        [2.313e-08, 0.87671613055, 213.299095438],
                        [1.443e-08, 2.38565505909, 1169.5882514086],
                        [1.823e-08, 5.80106463776, 625.6701923124],
                        [1.728e-08, 2.24114678267, 525.7588118315],
                        [1.198e-08, 0.03252059731, 956.2891559706],
                        [1.138e-08, 3.46420904745, 1073.6090241908],
                        [1.086e-08, 5.352791467, 117.3198682202],
                        [8.4e-09, 2.89946334223, 95.9792272178],
                        [7.46e-09, 5.53017890231, 1478.8665740644],
                        [9.44e-09, 4.055870535, 206.1855484372],
                        [7.58e-09, 3.74770617289, 433.7117378768],
                        [6.73e-09, 1.26396626349, 508.3503240922],
                        [8.89e-09, 6.07878453176, 728.762966531],
                        [6e-09, 1.82954494089, 639.897286314],
                        [5.89e-09, 1.23625943417, 1258.4539316256],
                        [6.19e-09, 0.67923057477, 838.9692877504],
                        [5.66e-09, 5.36336098734, 742.9900605326],
                        [6.48e-09, 5.32990375008, 853.196381752],
                        [5.53e-09, 3.15511946637, 220.4126424388],
                        [4.32e-09, 1.03719283016, 1692.1656695024],
                        [4.35e-09, 1.65056479007, 519.3960243561],
                        [4.3e-09, 1.41830384501, 412.3710968744],
                        [4.31e-09, 2.20986254651, 1368.660252845],
                        [4.15e-09, 4.35372561905, 330.6189636582],
                        [4.38e-09, 0.1655227729, 1574.8458012822],
                        [3.12e-09, 4.50639455819, 2125.8774073792],
                        [2.8e-09, 3.01441283033, 551.031606097],
                        [3.09e-09, 0.67399908949, 2111.6503133776],
                        [3.01e-09, 3.06868080871, 1062.5633239269],
                        [2.36e-09, 1.946968422, 1485.9801210652],
                        [2.35e-09, 3.41850395941, 199.0720014364],
                        [2.46e-09, 2.61803442505, 309.2783226558],
                        [2.38e-09, 2.56643737684, 539.9859058331],
                        [2.48e-09, 2.96997778167, 2648.454825473],
                        [2.09e-09, 5.82481690851, 1471.7530270636],
                        [2.05e-09, 1.20202002469, 1056.2005364515],
                        [1.88e-09, 0.97113663101, 1685.0521225016],
                        [1.37e-09, 2.91203499563, 1699.2792165032],
                        [1.31e-09, 1.79274504072, 1063.3140834523],
                        [1.61e-09, 1.05926568614, 1795.258443721],
                        [1.12e-09, 2.62660288825, 440.8252848776],
                        [1.1e-09, 3.56263668146, 227.5261894396],
                        [1.14e-09, 6.13907482464, 1038.0412891868],
                        [1.03e-09, 4.6428710104, 3.1813937377],
                        [1.23e-09, 4.81268110532, 21.3406410024],
                        [1.02e-09, 4.2760382797, 1375.7737998458],
                        [8.9e-10, 1.22926014128, 1898.3512179396],
                        [8e-10, 0.62129648755, 831.8557407496],
                      ],
          },
          {
            series => "B3",
            terms  => [
                        [2.51624e-06, 3.38087923084, 529.6909650946],
                        [1.21738e-06, 2.733118372, 522.5774180938],
                        [4.8694e-07, 1.03689996685, 536.8045120954],
                        [1.0988e-07, 2.31463561347, 1052.2683831884],
                        [8.067e-08, 2.76729757621, 515.463871093],
                        [6.205e-08, 1.7811582737, 1066.49547719],
                        [7.287e-08, 4.25268318975, 1059.3819301892],
                        [3.627e-08, 1.13028917221, 543.9180590962],
                        [2.798e-08, 3.14159265359, 0],
                        [1.898e-08, 2.28934054087, 7.1135470008],
                        [1.643e-08, 1.77507208483, 1045.1548361876],
                        [9.45e-09, 0.45261136388, 632.7837393132],
                        [7.58e-09, 0.30577920142, 949.1756089698],
                        [7.31e-09, 2.63748223583, 14.2270940016],
                        [8.76e-09, 0.32927768725, 1589.0728952838],
                        [6.78e-09, 2.36909615348, 1581.959348283],
                        [6.23e-09, 2.480562136, 1596.1864422846],
                        [7.36e-09, 1.52532370632, 735.8765135318],
                        [4.99e-09, 3.67985494258, 419.4846438752],
                        [4.54e-09, 0.26977404624, 942.062061969],
                        [4.53e-09, 3.18232334886, 526.5095713569],
                        [4.09e-09, 2.88147337106, 110.2063212194],
                        [3.47e-09, 5.7624428587, 103.0927742186],
                        [3.1e-09, 2.98017326384, 508.3503240922],
                        [3.21e-09, 4.40642025933, 532.8723588323],
                        [3e-09, 1.66936571536, 625.6701923124],
                        [2.95e-09, 1.75924202728, 1073.6090241908],
                        [2.82e-09, 3.11087801399, 533.6231183577],
                        [2.63e-09, 0.55255030187, 426.598190876],
                        [2.08e-09, 2.17540496886, 1155.361157407],
                        [1.83e-09, 4.34670868038, 525.7588118315],
                        [1.8e-09, 6.07777744541, 639.897286314],
                        [1.59e-09, 2.60843864402, 1162.4747044078],
                        [1.17e-09, 4.70141431381, 95.9792272178],
                        [1.07e-09, 5.48942805114, 433.7117378768],
                        [1.05e-09, 3.75192101775, 316.3918696566],
                        [1.3e-09, 1.37897716939, 323.5054166574],
                        [9.4e-10, 3.05797832024, 1265.5674786264],
                        [1.14e-09, 3.75170981478, 117.3198682202],
                        [9.5e-10, 0.54905691533, 1169.5882514086],
                        [8.8e-10, 3.26874502411, 213.299095438],
                        [9.8e-10, 2.00704668688, 1574.8458012822],
                      ],
          },
          {
            series => "B4",
            terms  => [
                        [1.505e-07, 4.52956999637, 522.5774180938],
                        [5.37e-08, 4.47427159142, 529.6909650946],
                        [4.456e-08, 5.43908581047, 536.8045120954],
                        [3.422e-08, 0, 0],
                        [1.833e-08, 4.51807036227, 515.463871093],
                        [1.322e-08, 4.20117611581, 1052.2683831884],
                        [7.55e-09, 5.59451554966, 543.9180590962],
                        [5.12e-09, 0.05803177475, 1066.49547719],
                        [2.82e-09, 3.66807771223, 1059.3819301892],
                        [1.47e-09, 3.56490986181, 1045.1548361876],
                        [1.42e-09, 5.69936472988, 7.1135470008],
                        [1.12e-09, 1.16718383135, 14.2270940016],
                      ],
          },
          {
            series => "B5",
            terms  => [
                        [1.445e-08, 0.09198554072, 522.5774180938],
                        [3.68e-09, 0.00874408003, 515.463871093],
                        [3.04e-09, 3.27902945138, 536.8045120954],
                        [1.29e-09, 0.33959775247, 529.6909650946],
                        [9.5e-10, 1.29305954542, 543.9180590962],
                      ],
          },
        ],
        [
          {
            series => "R0",
            terms  => [
                        [5.20887429471, 0, 0],
                        [0.2520932702, 3.49108640015, 529.6909650946],
                        [0.00610599902, 3.84115365602, 1059.3819301892],
                        [0.00282029465, 2.57419879933, 632.7837393132],
                        [0.00187647391, 2.07590380082, 522.5774180938],
                        [0.00086792941, 0.71001090609, 419.4846438752],
                        [0.00072062869, 0.21465694745, 536.8045120954],
                        [0.00065517227, 5.97995850843, 316.3918696566],
                        [0.0002913462, 1.6775924371, 103.0927742186],
                        [0.00030135275, 2.16132058449, 949.1756089698],
                        [0.00023453209, 3.54023147303, 735.8765135318],
                        [0.0002228371, 4.19362773546, 1589.0728952838],
                        [0.0002394734, 0.27457854894, 7.1135470008],
                        [0.000130326, 2.96043055741, 1162.4747044078],
                        [9.703346e-05, 1.90669572402, 206.1855484372],
                        [0.00012749004, 2.71550102862, 1052.2683831884],
                        [9.161431e-05, 4.41352618935, 213.299095438],
                        [7.894539e-05, 2.47907551404, 426.598190876],
                        [7.057978e-05, 2.18184753111, 1265.5674786264],
                        [6.137755e-05, 6.26417542514, 846.0828347512],
                        [5.477093e-05, 5.65729325169, 639.897286314],
                        [3.502519e-05, 0.56531297394, 1066.49547719],
                        [4.13689e-05, 2.72219979684, 625.6701923124],
                        [4.170012e-05, 2.01605033912, 515.463871093],
                        [2.499966e-05, 4.55182055941, 838.9692877504],
                        [2.616955e-05, 2.00993967129, 1581.959348283],
                        [1.911876e-05, 0.85621927419, 412.3710968744],
                        [2.127644e-05, 6.1275146175, 742.9900605326],
                        [1.610549e-05, 3.08867789275, 1368.660252845],
                        [1.479484e-05, 2.68026191372, 1478.8665740644],
                        [1.230708e-05, 1.89042979701, 323.5054166574],
                        [1.21681e-05, 1.80171561024, 110.2063212194],
                        [9.61072e-06, 4.54876989805, 2118.7638603784],
                        [8.85708e-06, 4.14785948471, 533.6231183577],
                        [7.767e-06, 3.6769695469, 728.762966531],
                        [9.98579e-06, 2.8720894011, 309.2783226558],
                        [1.014959e-05, 1.38673237666, 454.9093665273],
                        [7.27162e-06, 3.98824686402, 1155.361157407],
                        [6.55289e-06, 2.79065604219, 1685.0521225016],
                        [8.21465e-06, 1.59342534396, 1898.3512179396],
                        [6.20798e-06, 4.82284338962, 956.2891559706],
                        [6.53981e-06, 3.38150775269, 1692.1656695024],
                        [8.12036e-06, 5.94091899141, 909.8187330546],
                        [5.6212e-06, 0.08095987241, 543.9180590962],
                        [5.42221e-06, 0.28360266386, 525.7588118315],
                        [4.57859e-06, 0.1272269451, 1375.7737998458],
                        [6.14784e-06, 2.27624915604, 942.062061969],
                        [4.35805e-06, 2.60272129748, 95.9792272178],
                        [4.96066e-06, 5.53005947761, 380.12776796],
                        [4.69965e-06, 2.81896276101, 1795.258443721],
                        [4.45003e-06, 0.14623567024, 14.2270940016],
                        [2.90869e-06, 3.89339143564, 1471.7530270636],
                        [2.76627e-06, 2.52238450687, 2001.4439921582],
                        [2.75084e-06, 2.98863518924, 526.5095713569],
                        [2.93875e-06, 2.04938438861, 199.0720014364],
                        [2.90985e-06, 6.03131226226, 1169.5882514086],
                        [3.38342e-06, 2.79873192583, 1045.1548361876],
                        [2.57482e-06, 6.13395478303, 532.8723588323],
                        [3.19013e-06, 1.34803130803, 2214.7430875962],
                        [3.09352e-06, 5.36855804945, 1272.6810256272],
                        [3.45804e-06, 1.56404293688, 491.5579294568],
                        [3.03364e-06, 1.15407454372, 5753.3848848968],
                        [1.92325e-06, 0.91996333387, 1596.1864422846],
                        [2.15398e-06, 2.63572815848, 2111.6503133776],
                        [2.00738e-06, 2.37259566683, 1258.4539316256],
                        [2.39036e-06, 3.57397189838, 835.0371344873],
                        [1.97073e-06, 5.92859096863, 453.424893819],
                        [1.3944e-06, 3.63960322318, 1788.1448967202],
                        [1.91373e-06, 6.2825131187, 983.1158589136],
                        [1.76551e-06, 2.57669991654, 9683.5945811164],
                        [1.23567e-06, 2.26158186345, 2317.8358618148],
                        [1.28176e-06, 4.6658590767, 831.8557407496],
                        [1.1243e-06, 0.85604150812, 433.7117378768],
                        [1.28817e-06, 1.10567106595, 2531.1349572528],
                        [9.939e-07, 4.50312054049, 518.6452648307],
                        [9.387e-07, 2.7255387999, 853.196381752],
                        [1.06481e-06, 5.8146222229, 220.4126424388],
                        [1.20188e-06, 2.95156363556, 3.9321532631],
                        [1.04002e-06, 2.22221906187, 74.7815985673],
                        [8.1655e-07, 3.23481337678, 1361.5467058442],
                        [1.12513e-06, 4.86216964016, 528.2064923863],
                        [7.9539e-07, 0.8854224683, 430.5303441391],
                        [8.5801e-07, 2.11458386763, 1574.8458012822],
                        [8.5685e-07, 2.33823884827, 2428.0421830342],
                        [6.8311e-07, 3.35727048905, 2104.5367663768],
                        [6.957e-07, 3.04164697156, 302.164775655],
                        [6.9775e-07, 3.22402404312, 305.3461693927],
                        [6.957e-07, 0.20494979941, 532.1386456494],
                        [5.6991e-07, 2.00204191909, 2634.2277314714],
                        [7.7062e-07, 2.09816000231, 508.3503240922],
                        [5.6716e-07, 3.91743976711, 2221.856634597],
                        [5.8325e-07, 5.72360355252, 628.8515860501],
                        [5.2485e-07, 4.02485010492, 527.2432845398],
                        [6.3645e-07, 1.09973563964, 1364.7280995819],
                        [5.3607e-07, 0.87425992614, 2847.5268269094],
                        [5.9598e-07, 0.95822471775, 494.2662424425],
                        [5.796e-07, 3.45779497978, 2008.557539159],
                        [4.1512e-07, 3.51955526735, 529.7391492044],
                        [4.4666e-07, 1.62313786651, 984.6003316219],
                        [4.4883e-07, 4.90091959557, 2648.454825473],
                        [5.3206e-07, 1.19800364308, 760.25553592],
                        [4.4393e-07, 4.42623747662, 1063.3140834523],
                        [3.7566e-07, 2.93021095213, 1677.9385755008],
                        [4.1516e-07, 0.32174409278, 529.6427809848],
                        [4.2855e-07, 0.03093594081, 1439.5096981492],
                        [4.5963e-07, 2.54342106514, 636.7158925763],
                        [4.0181e-07, 4.39381642864, 1148.2476104062],
                        [3.877e-07, 4.31675565025, 149.5631971346],
                        [4.0348e-07, 2.10140891053, 2744.4340526908],
                        [4.8851e-07, 5.60297777544, 2810.9214616052],
                        [3.7085e-07, 5.07828164301, 1905.4647649404],
                        [4.3875e-07, 1.24536971083, 621.7380390493],
                        [3.4005e-07, 3.09360167248, 2420.9286360334],
                        [3.6782e-07, 0.84232174637, 530.6541729411],
                        [3.1139e-07, 5.35811251334, 1485.9801210652],
                        [3.9295e-07, 4.70800489067, 569.0478410098],
                        [3.97e-07, 2.46163878814, 355.7487455718],
                        [3.1527e-07, 6.19284070863, 3.1813937377],
                        [2.8399e-07, 2.48456666067, 519.3960243561],
                        [3.2432e-07, 2.73281750275, 604.4725636619],
                        [2.7119e-07, 3.92341697086, 2324.9494088156],
                        [2.6753e-07, 1.74975198417, 2950.619601128],
                        [2.8986e-07, 1.83535862643, 1891.2376709388],
                        [2.6493e-07, 0.60380196895, 1055.4497769261],
                        [3.3525e-07, 0.76068430639, 643.8294395771],
                        [2.6568e-07, 1.03594610835, 405.2575498736],
                        [2.5534e-07, 3.46320665375, 458.8415197904],
                        [2.4421e-07, 0.8818183693, 423.4167971383],
                        [3.2949e-07, 3.18597137308, 528.7277572481],
                        [2.2456e-07, 0.43129919683, 1073.6090241908],
                        [2.1599e-07, 1.41820425091, 540.7366653585],
                        [2.5673e-07, 0.5235819476, 511.5317178299],
                        [2.1115e-07, 3.08023522766, 629.6023455755],
                        [2.2713e-07, 0.65234613144, 3163.918696566],
                        [1.9189e-07, 5.16589014963, 635.9651330509],
                        [2.6042e-07, 1.33629471285, 330.6189636582],
                        [1.8263e-07, 3.59973446951, 746.9222137957],
                        [1.821e-07, 2.66819439927, 1994.3304451574],
                        [1.9724e-07, 4.13552133321, 1464.6394800628],
                        [1.948e-07, 1.85656428109, 3060.8259223474],
                        [2.3927e-07, 4.99826361784, 1289.9465010146],
                        [2.1886e-07, 5.91718683551, 1802.3719907218],
                        [1.7482e-07, 2.82161612542, 2737.32050569],
                        [1.6608e-07, 5.67394889755, 408.4389436113],
                        [2.2892e-07, 5.26731352093, 672.1406152284],
                        [1.8349e-07, 1.89869734949, 1021.2488945514],
                        [1.9123e-07, 3.65882402977, 415.5524906121],
                        [1.5735e-07, 3.34772676006, 1056.2005364515],
                        [1.6373e-07, 0.18094878053, 1699.2792165032],
                        [1.8899e-07, 3.69120638874, 88.865680217],
                        [1.8655e-07, 1.97327300097, 38.1330356378],
                        [1.5542e-07, 3.8220488101, 721.6494195302],
                        [1.678e-07, 1.90976657921, 217.2312487011],
                        [1.5313e-07, 1.05907174619, 114.1384744825],
                        [1.519e-07, 1.32317039042, 117.3198682202],
                        [1.508e-07, 3.74469077216, 2641.3412784722],
                        [1.9836e-07, 2.73184571324, 39.3568759152],
                        [1.4708e-07, 1.67270454473, 529.1697002328],
                        [1.4036e-07, 3.54305270022, 142.4496501338],
                        [1.2931e-07, 1.48829749349, 3267.0114707846],
                        [1.4924e-07, 1.3254608594, 490.3340891794],
                        [1.4753e-07, 4.64530618027, 6283.0758499914],
                        [1.4672e-07, 0.80451954754, 5223.6939198022],
                        [1.2085e-07, 3.67072510553, 750.1036075334],
                        [1.1954e-07, 2.97127390765, 505.3119427064],
                        [1.465e-07, 2.1679293025, 530.2122299564],
                        [1.1869e-07, 1.66551754962, 2207.6295405954],
                        [1.2273e-07, 0.20690014405, 1062.5633239269],
                        [1.146e-07, 1.11906683214, 561.934294009],
                        [1.1083e-07, 3.22049096074, 535.107591066],
                        [1.1567e-07, 5.22625628971, 524.0618908021],
                        [1.1161e-07, 3.82945634036, 76.2660712756],
                        [1.0918e-07, 1.27796962818, 2125.8774073792],
                        [1.2685e-07, 3.96848605476, 2538.2485042536],
                        [1.123e-07, 3.23092119889, 422.6660376129],
                        [1.2645e-07, 0.7367042858, 908.3342603463],
                        [1.133e-07, 5.56127247007, 531.1754378029],
                        [9.509e-08, 5.00507284204, 597.3590166611],
                        [1.0291e-07, 3.84159025239, 1781.0313497194],
                        [1.0762e-07, 4.91380719453, 525.0250986486],
                        [1.1786e-07, 5.11863653538, 685.4739373527],
                        [1.198e-07, 1.72470898635, 911.3032057629],
                        [8.937e-08, 2.40338241992, 2310.722314814],
                        [9.253e-08, 2.57670338148, 3053.7123753466],
                        [9.488e-08, 2.95089828501, 1382.8873468466],
                        [9.889e-08, 0.43758517388, 3480.3105662226],
                        [8.781e-08, 3.66562388594, 739.8086667949],
                        [8.664e-08, 2.70398612383, 526.7702037878],
                        [9.505e-08, 1.61249870019, 3377.217792004],
                        [1.154e-07, 1.59520481029, 1474.6737883704],
                        [9.533e-08, 0.35468711552, 1512.8068240082],
                        [9.98e-08, 4.80984684596, 558.0021407459],
                        [9.014e-08, 1.21458362718, 416.3032501375],
                        [7.969e-08, 0.08480602718, 528.9402055692],
                        [8.668e-08, 5.29060005706, 945.2434557067],
                        [7.851e-08, 1.46751861875, 963.4027029714],
                        [8.611e-08, 1.13232641062, 532.6117264014],
                        [7.838e-08, 6.26933498027, 647.0108333148],
                        [7.581e-08, 2.90608705954, 533.8837507886],
                        [8.583e-08, 6.06634530166, 10213.285546211],
                        [1.0198e-07, 2.48743123636, 1819.6374661092],
                        [8.536e-08, 2.2270070179, 9153.9036160218],
                        [9.759e-08, 6.15593336218, 593.426863398],
                        [7.968e-08, 3.75535355212, 530.44172462],
                        [7.142e-08, 3.58836120327, 2957.7331481288],
                        [7.122e-08, 0.11970048938, 224.3447957019],
                        [8.731e-08, 0.7530291397, 960.2213092337],
                        [7.063e-08, 2.1679303769, 724.8308132679],
                        [7.263e-08, 2.29499675875, 520.129737539],
                        [6.418e-08, 1.25058991868, 3583.4033404412],
                        [8.27e-08, 1.24806288317, 495.7507151508],
                        [6.483e-08, 4.7456777264, 202.2533951741],
                        [7.197e-08, 3.84169279666, 618.5566453116],
                        [8.146e-08, 0.73147060302, 230.5645708254],
                        [6.165e-08, 5.50124418381, 11.0457002639],
                        [7.946e-08, 2.07754951174, 953.1077622329],
                        [7.675e-08, 0.92400307662, 525.4981794006],
                        [6.21e-08, 1.45641362115, 483.2205421786],
                        [7.359e-08, 0.31355650764, 378.6432952517],
                        [6.707e-08, 2.92071167098, 1038.0412891868],
                        [7.143e-08, 0.18218134889, 731.9443602687],
                        [7.309e-08, 6.27084533477, 21.3406410024],
                        [6.135e-08, 2.67651237303, 312.4597163935],
                        [5.558e-08, 3.83419160288, 534.3568315406],
                        [5.344e-08, 5.25294750019, 1048.3362299253],
                        [7.504e-08, 0.74281415471, 457.617679513],
                        [5.335e-08, 6.23059924424, 551.031606097],
                        [5.613e-08, 1.51210605952, 524.2743391232],
                        [5.284e-08, 2.18579185671, 280.9671470045],
                        [5.475e-08, 5.95864753605, 539.9859058331],
                        [5.056e-08, 0.37387972537, 529.5309064002],
                        [6.202e-08, 5.53813122743, 2.4476805548],
                        [5.49e-08, 5.97692444199, 227.5261894396],
                        [6.266e-08, 0.76632858238, 938.1299087059],
                        [5.75e-08, 2.13496323512, 191.9584544356],
                        [5.218e-08, 4.69335266854, 560.7104537316],
                        [5.48e-08, 5.21157595558, 1057.8974574809],
                        [5.738e-08, 0.34249718209, 535.9107402181],
                        [4.816e-08, 1.51326236835, 2524.021410252],
                        [5.056e-08, 3.46671669992, 529.851023789],
                        [4.71e-08, 2.2781383055, 3370.1042450032],
                        [5.228e-08, 3.61776977584, 2097.423219376],
                        [4.878e-08, 1.39829798223, 3693.6096616606],
                        [5.727e-08, 4.80120381106, 598.8434893694],
                        [5.707e-08, 3.94177950323, 2854.6403739102],
                        [4.988e-08, 4.87244187719, 1.4844727083],
                        [5.424e-08, 3.53268613904, 456.3938392356],
                        [4.288e-08, 4.84438067847, 70.8494453042],
                        [5.944e-08, 3.79180483544, 25558.2121764796],
                        [4.195e-08, 2.09136830994, 2627.1141844706],
                        [4.582e-08, 5.61707254513, 2435.155730035],
                        [4.268e-08, 6.20250525415, 775.233389447],
                        [4.521e-08, 0.20049967962, 92.0470739547],
                        [5.405e-08, 4.66492781581, 833.552661779],
                        [5.607e-08, 3.30226645638, 535.3200393871],
                        [4.171e-08, 3.14873010832, 944.9828232758],
                        [4.108e-08, 5.84489743779, 440.8252848776],
                        [4.367e-08, 4.68363584557, 327.4375699205],
                        [4.033e-08, 3.30883782817, 3274.1250177854],
                        [4.292e-08, 0.20604269202, 3796.7024358792],
                        [4.27e-08, 0.98941708997, 387.2413149608],
                        [4.259e-08, 3.21120589971, 696.5196376166],
                        [4.673e-08, 1.96606729969, 107.0249274817],
                        [4.031e-08, 4.62854606236, 2751.5475996916],
                        [5.115e-08, 2.66416451377, 1215.1649024473],
                        [4.181e-08, 4.74527698816, 988.532484885],
                        [4.374e-08, 1.50010561403, 1894.4190646765],
                        [3.803e-08, 3.59911687954, 437.6438911399],
                        [3.761e-08, 3.96903199782, 732.6951197941],
                        [3.62e-08, 1.57847427805, 381.6122406683],
                        [3.49e-08, 0.63097592112, 529.9034134157],
                        [4.019e-08, 2.5766416572, 916.9322800554],
                        [4.133e-08, 4.78417930217, 824.7421937488],
                        [4.411e-08, 3.13179382423, 630.3360587584],
                        [4.099e-08, 3.63702212253, 810.6581120991],
                        [3.704e-08, 6.17243801274, 537.7677199419],
                        [4.124e-08, 2.14248285449, 210.1177017003],
                        [3.49e-08, 3.20962050417, 529.4785167735],
                        [3.281e-08, 1.53106243317, 547.8502123593],
                        [3.554e-08, 6.03787799174, 739.0579072695],
                        [4.101e-08, 6.00406226999, 902.7051860538],
                        [3.267e-08, 3.49354065789, 1166.4068576709],
                        [3.286e-08, 2.5596687053, 945.9942152321],
                        [4.041e-08, 4.78735413707, 850.0149880143],
                        [4.304e-08, 0.11406117717, 1744.8558675419],
                        [4.043e-08, 5.204170936, 635.231419868],
                        [3.115e-08, 4.61986265585, 952.3570027075],
                        [3.016e-08, 0.95126220905, 3899.7952100978],
                        [3.017e-08, 2.59699501992, 632.831923423],
                        [3.219e-08, 1.83594791142, 18.1592472647],
                        [3.203e-08, 6.12597544496, 10.2949407385],
                        [3.22e-08, 6.1421342314, 1158.5425511447],
                        [3e-08, 5.69509924353, 632.7355552034],
                        [3.226e-08, 5.59910267099, 608.404716925],
                        [3.118e-08, 5.64998934505, 99.1606209555],
                        [3.745e-08, 2.08111521615, 282.4516197128],
                        [2.837e-08, 4.6017559422, 245.5424243524],
                        [3.093e-08, 6.02049413961, 633.7469471597],
                        [3.12e-08, 2.29047945342, 631.8205314667],
                        [2.662e-08, 3.69016679729, 885.4397106664],
                        [3.15e-08, 1.79784999553, 521.6142102473],
                        [2.822e-08, 3.14927418161, 295.0512286542],
                        [2.615e-08, 0.20732170653, 35.4247226521],
                        [2.971e-08, 1.28795094653, 1023.9572075371],
                        [2.571e-08, 2.01817133502, 1514.2912967165],
                        [2.592e-08, 0.487902212, 195.1398481733],
                        [3.263e-08, 2.38820607343, 836.5216071956],
                        [2.501e-08, 0.21653750027, 465.9550667912],
                        [2.451e-08, 5.58559489768, 544.6688186216],
                        [2.535e-08, 1.44414086617, 460.5384408198],
                        [2.666e-08, 3.30350145485, 2413.8150890326],
                        [2.412e-08, 4.3675658031, 1056.9342496344],
                        [2.452e-08, 4.53818816565, 514.7131115676],
                        [3.239e-08, 1.17022488774, 177.8743727859],
                        [3.218e-08, 0.60551913257, 1061.829610744],
                        [2.408e-08, 0.6542352381, 523.5406259403],
                        [2.299e-08, 2.1524775256, 319.5732633943],
                        [2.791e-08, 2.71505085086, 610.6923387854],
                        [2.729e-08, 1.77685979153, 252.6559713532],
                        [2.666e-08, 3.77750458842, 3171.0322435668],
                        [2.303e-08, 0.36676453766, 1969.2006632438],
                        [2.664e-08, 0.09674841214, 565.1156877467],
                        [2.312e-08, 2.07210502831, 3686.4961146598],
                        [2.68e-08, 4.9444588805, 1593.0050485469],
                        [2.193e-08, 0.55645982205, 2228.9701815978],
                        [2.526e-08, 1.07528597373, 12036.4607348882],
                        [2.778e-08, 1.48379350517, 447.7958195265],
                        [2.235e-08, 5.95475282699, 6151.533888305],
                        [2.759e-08, 4.6397615348, 462.0229135281],
                        [2.175e-08, 4.5358857024, 501.3797894433],
                        [2.323e-08, 5.93670041006, 611.4430983108],
                        [2.384e-08, 2.81746622971, 3340.6124266998],
                        [2.087e-08, 3.10716079675, 1049.0869894507],
                        [1.994e-08, 2.02500860064, 1058.8606653274],
                        [2.199e-08, 2.20937490997, 1269.4996318895],
                        [2.705e-08, 1.97665276677, 415.2918581812],
                        [2.787e-08, 1.31053438756, 1041.2226829245],
                        [2.003e-08, 4.66904374443, 679.2541622292],
                        [1.962e-08, 1.82999730674, 2943.5060541272],
                        [2.289e-08, 2.96480800939, 69.1525242748],
                        [2.192e-08, 4.47837196209, 209.3669421749],
                        [2.02e-08, 0.0462136449, 4113.0943055358],
                        [2.082e-08, 1.1120305917, 4010.0015313172],
                        [1.991e-08, 3.20108648275, 3590.516887442],
                        [1.9e-08, 3.32227077969, 421.93232443],
                        [2.193e-08, 2.82218305362, 292.0128472684],
                        [2.288e-08, 1.94695631885, 1279.794572628],
                        [1.843e-08, 5.23293634337, 14.977853527],
                        [1.932e-08, 5.4668425203, 2281.2304965106],
                        [2.177e-08, 2.93031976617, 429.0458714308],
                        [2.125e-08, 0.06224847826, 24.3790223882],
                        [2.464e-08, 5.3958107843, 1261.6353253633],
                        [1.938e-08, 3.79908004671, 1059.430114299],
                        [2.029e-08, 3.95461157815, 771.3012361839],
                        [1.841e-08, 4.74905354737, 78.7137518304],
                        [1.922e-08, 2.21862085389, 99.9113804809],
                        [1.836e-08, 5.75449805175, 623.2225117576],
                        [2.145e-08, 3.87052575546, 451.9404211107],
                        [1.782e-08, 0.40860352236, 754.0357607965],
                        [1.784e-08, 1.49468287576, 529.9515975255],
                        [1.842e-08, 3.49726261337, 1354.4331588434],
                        [1.748e-08, 3.48730020953, 522.6256022036],
                        [1.816e-08, 1.2433471121, 417.0369633204],
                        [1.752e-08, 1.15500390019, 1060.3451380357],
                        [1.729e-08, 2.69831073799, 642.3449668688],
                        [1.985e-08, 1.99916658759, 934.9485149682],
                        [1.828e-08, 5.44095029767, 1201.831580323],
                        [2.158e-08, 3.4567274859, 827.9235874865],
                        [1.959e-08, 1.06033047373, 33.9402499438],
                        [1.751e-08, 3.13572498964, 384.0599212231],
                        [1.781e-08, 5.02895146997, 1098.7388061044],
                        [2.074e-08, 3.18582065441, 1366.2125722902],
                        [1.757e-08, 5.02778552877, 586.3133163972],
                        [2.045e-08, 3.08816627459, 535.8413042489],
                        [2.273e-08, 5.17998505813, 3178.1457905676],
                        [1.617e-08, 3.16674916201, 67.6680515665],
                        [1.627e-08, 6.10603469594, 432.0148168474],
                        [1.93e-08, 1.63968957659, 5.4166259714],
                        [1.741e-08, 0.99408274736, 1254.5217783625],
                        [1.607e-08, 5.65498642076, 1165.6560981455],
                        [1.676e-08, 3.06138410273, 1134.1635287565],
                        [1.821e-08, 3.0518355509, 567.8240007324],
                        [1.677e-08, 3.0917508493, 1251.3403846248],
                        [1.994e-08, 2.52023134712, 1059.903195051],
                        [2.204e-08, 6.1537669851, 563.6312150384],
                        [1.692e-08, 4.19142612803, 106.2741679563],
                        [1.906e-08, 5.58417395051, 32.2433289144],
                        [2.206e-08, 1.75883974012, 1151.4290041439],
                        [1.552e-08, 3.04262360186, 385.5443939314],
                        [1.508e-08, 0.42002830727, 313.2104759189],
                        [1.494e-08, 1.43672345922, 2840.4132799086],
                        [1.678e-08, 2.17255433434, 306.830642101],
                        [1.511e-08, 4.44377608685, 395.105621487],
                        [1.958e-08, 0.05215107058, 761.7400086283],
                        [1.76e-08, 1.27045286501, 1173.5204046717],
                        [1.463e-08, 6.07810373103, 0.9632078465],
                        [1.498e-08, 2.79408561759, 277.0349937414],
                        [1.636e-08, 0.2619935149, 522.529233984],
                        [1.507e-08, 0.48961801593, 4216.1870797544],
                        [1.53e-08, 3.4295382755, 1159.2933106701],
                        [1.744e-08, 2.39637837261, 203.0041546995],
                        [1.569e-08, 2.55719070621, 4.192785694],
                        [1.576e-08, 3.45039607104, 1058.4187223427],
                        [1.466e-08, 2.24427539934, 1550.939859646],
                        [1.784e-08, 2.34591354953, 529.4303326637],
                        [1.939e-08, 4.7368542861, 3067.9394693482],
                        [1.938e-08, 0.60126164334, 1059.3337460794],
                        [1.523e-08, 2.98744673443, 2730.2069586892],
                        [1.834e-08, 3.78099298791, 420.9691165835],
                        [1.372e-08, 3.53997115825, 5.6290742925],
                        [1.361e-08, 0.45533257707, 418.5214360287],
                        [1.833e-08, 5.12743628215, 1578.0271950199],
                        [1.839e-08, 4.2461604421, 981.6313862053],
                        [1.567e-08, 3.32429870195, 532.3992780803],
                        [1.34e-08, 1.9466828227, 528.4189407074],
                        [1.422e-08, 1.83191577465, 4002.8879843164],
                        [1.745e-08, 5.76913240451, 490.0734567485],
                        [1.437e-08, 4.19470227783, 420.4478517217],
                        [1.419e-08, 0.7484900533, 632.2624744514],
                        [1.447e-08, 5.65611888743, 373.0142209592],
                        [1.578e-08, 3.90273683089, 602.9880909536],
                        [1.385e-08, 3.88479835656, 419.4364597654],
                        [1.352e-08, 0.81697905853, 1585.1407420207],
                        [1.399e-08, 1.24785452243, 633.305004175],
                        [1.297e-08, 5.57914023189, 1276.6131788903],
                        [1.491e-08, 1.66541781223, 2655.5683724738],
                        [1.252e-08, 0.72155670765, 173.9422195228],
                        [1.658e-08, 5.6092466285, 362.8622925726],
                        [1.606e-08, 3.95301396173, 2274.5468326365],
                        [1.213e-08, 4.55264289565, 366.7944458357],
                        [1.521e-08, 0.55773831071, 1592.2542890215],
                        [1.22e-08, 3.6302978804, 497.4476361802],
                        [1.215e-08, 4.42854185903, 531.387886124],
                        [1.549e-08, 5.73765962068, 320.3240229197],
                        [1.48e-08, 4.29779032931, 303.8616966844],
                        [1.507e-08, 2.27998567874, 758.7710632117],
                        [1.212e-08, 3.38335836048, 536.8526962052],
                        [1.245e-08, 4.21639959154, 4.665866446],
                        [1.507e-08, 3.52136655355, 774.0095491696],
                        [1.481e-08, 3.06156044618, 1585.8915015461],
                        [1.462e-08, 2.30628702634, 1363.2436268736],
                        [1.18e-08, 3.52708055024, 1064.7985561606],
                        [1.193e-08, 5.88284733845, 1060.8664028975],
                        [1.398e-08, 4.99456521692, 842.9014410135],
                        [1.406e-08, 1.53799746944, 1020.025054274],
                        [1.367e-08, 4.10254739443, 799.6124118352],
                        [1.336e-08, 1.8938727238, 530.9629894818],
                        [1.238e-08, 3.62226383331, 3487.4241132234],
                        [1.306e-08, 3.39985119727, 539.2521926502],
                        [1.156e-08, 0.77127511567, 1603.2999892854],
                        [1.482e-08, 0.48451915093, 493.0424021651],
                        [1.247e-08, 5.64344659992, 479.2883889155],
                        [1.195e-08, 2.39909893341, 561.1835344836],
                        [1.106e-08, 0.89453807282, 2.9207613068],
                        [1.227e-08, 2.76231244946, 299.1263942692],
                        [1.128e-08, 4.72319873338, 124.433415221],
                        [1.086e-08, 5.66180289525, 1053.7528558967],
                        [1.329e-08, 0.1666409453, 536.7563279856],
                        [1.082e-08, 4.5140735935, 528.2546764961],
                        [1.105e-08, 1.93890691771, 244.318584075],
                        [1.446e-08, 0.65096230619, 1091.6252591036],
                        [1.071e-08, 4.67974963103, 521.8266585684],
                        [1.413e-08, 4.72936311016, 1141.1340634054],
                        [1.086e-08, 2.88721124443, 1262.3860848887],
                        [1.254e-08, 5.74156595137, 527.9940440652],
                        [1.082e-08, 5.60975006771, 531.1272536931],
                        [1.148e-08, 3.27410230525, 1035.002907801],
                        [1.224e-08, 3.6880753715, 81.7521332162],
                        [1.072e-08, 0.48068438564, 1058.6311706638],
                        [1.036e-08, 1.68789163831, 1070.4276304531],
                        [1.052e-08, 4.72763208332, 913.7508863177],
                        [1.166e-08, 4.97812626679, 450.9772132642],
                        [1.042e-08, 2.90894542321, 3906.9087570986],
                        [9.97e-09, 1.65967703856, 3259.8979237838],
                        [1.113e-08, 3.06502453809, 1482.7987273275],
                        [9.91e-09, 0.91568114148, 576.1613880106],
                        [9.87e-09, 0.91349590742, 2332.0629558164],
                        [1.003e-08, 6.17381204883, 391.1734682239],
                        [1.087e-08, 3.19260020877, 151.0476698429],
                        [9.87e-09, 2.48065918834, 1912.5783119412],
                        [9.75e-09, 1.55458771092, 536.2832472336],
                        [1.193e-08, 2.19383228, 523.0986829556],
                        [9.79e-09, 3.2869362066, 1379.7059531089],
                        [9.63e-09, 2.29845109892, 1467.8208738005],
                        [1.279e-08, 4.73978455573, 600.5404103988],
                        [1.269e-08, 1.77171706595, 5120.6011455836],
                        [9.38e-09, 3.13636271584, 1372.5924061081],
                        [9.56e-09, 0.94045126791, 429.7795846137],
                        [1.13e-08, 4.87259620358, 874.3940104025],
                        [1.044e-08, 3.52819283674, 530.5847369719],
                        [1.244e-08, 0.80634178279, 419.532827985],
                        [9.14e-09, 4.34324212455, 1127.0499817557],
                        [1.095e-08, 3.17513475763, 6681.2248533996],
                        [9.26e-09, 5.53099018797, 537.5552716208],
                        [1.025e-08, 6.08315999637, 469.8872200543],
                        [9.28e-09, 2.64064849636, 31.019488637],
                        [8.87e-09, 5.53922649066, 498.6714764576],
                        [1.153e-08, 5.20213407651, 554.0699874828],
                        [9.76e-09, 4.2604788549, 806.725958836],
                        [8.71e-09, 5.7975111015, 594.6507036754],
                        [1.044e-08, 0.31244551729, 528.7971932173],
                        [9.11e-09, 0.94039205468, 337.732510659],
                        [1.197e-08, 3.12884590029, 1966.2317178272],
                        [9.3e-09, 2.88178471518, 1056.4611688824],
                        [1.052e-08, 1.69484089706, 484.444382456],
                        [8.62e-09, 0.67309397482, 20426.571092422],
                        [1.152e-08, 1.16751621652, 1489.9122743283],
                        [8.47e-09, 3.25831322825, 1063.5747158832],
                        [8.84e-09, 0.71487680084, 2042.4977891028],
                        [8.88e-09, 5.38714907441, 5621.8429232104],
                        [1.137e-08, 4.02029739425, 1670.0742689746],
                        [8.44e-09, 3.3184679859, 812.1425848074],
                        [8.6e-09, 4.78175008217, 530.914805372],
                        [8.35e-09, 3.63117401608, 451.7279727896],
                        [9.31e-09, 2.27352189963, 100.6450936638],
                        [9.39e-09, 3.51238251326, 523.4711899711],
                        [8.6e-09, 5.34207357904, 528.4671248172],
                        [8.75e-09, 0.8777553711, 4326.3934009738],
                        [9.61e-09, 5.69327275886, 498.1983957056],
                        [9.66e-09, 6.25512226434, 700.4517908797],
                        [8.42e-09, 3.20535945596, 1670.8250285],
                        [8.08e-09, 1.09148925587, 683.1863154923],
                        [8.1e-09, 5.47935192896, 525.5463635104],
                        [8.55e-09, 6.06969867736, 446.3113468182],
                        [9.89e-09, 1.55623875216, 1493.093668066],
                        [8.37e-09, 1.49510080792, 1025.4416802454],
                        [9.74e-09, 3.67667471757, 25565.3257234804],
                        [7.88e-09, 0.51622458293, 526.9826521089],
                        [8.2e-09, 1.86002542644, 629.8629780064],
                        [8.13e-09, 0.45441968195, 4694.0029547076],
                        [9.53e-09, 0.58786779132, 627.3671133418],
                        [9.08e-09, 2.82093327912, 3046.5988283458],
                        [9.12e-09, 2.69124310451, 946.727928415],
                        [8.2e-09, 4.14947931572, 1884.124123938],
                        [9.48e-09, 0.77931728039, 25551.0986294788],
                        [8.44e-09, 0.00976249584, 628.5909536192],
                        [9.1e-09, 0.99542530366, 5760.4984318976],
                        [8.44e-09, 0.2263096449, 1123.1178284926],
                        [9.24e-09, 4.41952345708, 5746.271337896],
                        [9.67e-09, 3.20618313117, 9050.8108418032],
                        [8e-09, 0.10663079153, 4532.578949411],
                        [7.48e-09, 3.01376405927, 5481.7545583808],
                        [7.52e-09, 5.8236047289, 701.936263588],
                        [7.71e-09, 0.12101982692, 635.70450062],
                        [7.25e-09, 2.81220410314, 3597.6304344428],
                        [9.44e-09, 0.40327408174, 1140.38330388],
                        [7.26e-09, 5.28930472464, 1304.9243545416],
                        [9.94e-09, 5.163913701, 10316.3783204296],
                        [8.9e-09, 4.10819809692, 1060.1326897146],
                        [9.62e-09, 1.48376004549, 1062.302691496],
                        [8.83e-09, 5.26813169286, 1542.6024723678],
                        [9.16e-09, 6.02908368648, 7.8643065262],
                        [7.25e-09, 2.1877377301, 1176.7017984094],
                        [8.08e-09, 5.81725174908, 1087.6931058405],
                        [7.57e-09, 0.7744041433, 977.4867846211],
                        [8.38e-09, 3.81585420192, 986.0848043302],
                        [8.88e-09, 1.89634795578, 707.5653378805],
                        [8.54e-09, 5.47701506544, 2818.035008606],
                        [7.96e-09, 1.08794807212, 987.3086446076],
                        [8.56e-09, 2.58042139486, 2803.8079146044],
                        [7.08e-09, 1.09492310353, 248.7238180901],
                        [8.11e-09, 3.23726191865, 121.2520214833],
                        [7.27e-09, 1.56150632966, 4319.279853973],
                        [6.87e-09, 2.65457835371, 1567.7322542814],
                        [6.75e-09, 1.78690909614, 103.1409583284],
                        [8.53e-09, 4.74476428852, 951.6232895246],
                        [8.32e-09, 5.1436278981, 1054.7160637432],
                        [8.46e-09, 1.47557828604, 898.7730327907],
                        [7.01e-09, 1.72139817505, 5230.807466803],
                        [8.63e-09, 3.98700238575, 686.958410061],
                        [7.03e-09, 2.89202252444, 63.7358983034],
                        [6.73e-09, 6.1161858051, 738.3241940866],
                        [8.06e-09, 4.64475158248, 533.8355666788],
                        [6.7e-09, 2.67625974048, 1012.9115072732],
                        [6.68e-09, 4.93815253692, 5172.476235725],
                        [8.18e-09, 1.41973280302, 580.0935412737],
                        [6.52e-09, 3.41422919445, 650.9429865779],
                        [6.43e-09, 2.46566726278, 1049.8207026336],
                        [8.59e-09, 2.50530106631, 782.3469364478],
                        [6.62e-09, 4.13533996643, 733.428832977],
                        [8.12e-09, 1.30325352179, 1055.1891444952],
                        [6.38e-09, 4.21760246824, 1064.0477966352],
                        [6.37e-09, 6.13121700151, 4752.9915918498],
                        [6.36e-09, 0.83411828974, 711.4974911436],
                        [6.42e-09, 1.86741704507, 1053.9653042178],
                        [7.95e-09, 4.54081089118, 1457.525933062],
                        [7.83e-09, 4.37652961667, 105.5404547734],
                        [6.4e-09, 5.44039474349, 632.0329797878],
                        [6.51e-09, 5.02431301146, 528.0464336919],
                        [6.86e-09, 0.27079898498, 11.7794134468],
                        [6.44e-09, 5.36935176134, 835.7878940127],
                        [6.39e-09, 1.86699974431, 6172.869528772],
                        [6.3e-09, 2.86895754523, 633.5344988386],
                        [8.26e-09, 1.46026926041, 2199.7652340692],
                        [6.87e-09, 3.81221717134, 73.297125859],
                        [6.97e-09, 4.18082589322, 1.6969210294],
                        [7.88e-09, 0.21278801649, 313.9441891018],
                        [6.86e-09, 2.51807576494, 638.4128136057],
                        [8.47e-09, 5.56263749391, 4429.4861751924],
                        [6.73e-09, 4.87494072856, 103.0445901088],
                        [6.63e-09, 4.80713895807, 991.7138786227],
                        [6.14e-09, 3.87231597482, 767.3690829208],
                        [6.66e-09, 5.71697262323, 661.0949149645],
                        [6.81e-09, 2.33844767741, 501.2367770914],
                        [5.97e-09, 3.03921014345, 6.9534883064],
                        [7.77e-09, 3.08786050361, 441.576044403],
                        [5.88e-09, 0.08236113246, 4164.311989613],
                        [6.93e-09, 4.66190836234, 3384.3313390048],
                        [8.1e-09, 1.9770108449, 860.3099287528],
                        [6.02e-09, 5.56403449542, 1587.5884225755],
                        [6.22e-09, 6.11554348965, 7.065362891],
                        [5.92e-09, 3.29013906024, 10103.0792249916],
                        [6.92e-09, 6.10931942233, 12.7426212933],
                        [5.97e-09, 6.13204711801, 7.2736056952],
                        [5.94e-09, 2.58839673551, 849.2642284889],
                        [7.28e-09, 2.73732195088, 6.1503391543],
                        [6.02e-09, 5.28816527514, 949.12742486],
                        [5.68e-09, 1.75508433865, 1077.5411774539],
                        [5.75e-09, 4.50676079721, 1230.1427559743],
                        [5.88e-09, 0.65827893998, 4642.7852706304],
                        [5.61e-09, 3.8756591436, 135.336103133],
                        [5.58e-09, 3.36094471852, 24498.8302462904],
                        [5.57e-09, 3.45629457197, 19896.8801273274],
                        [5.58e-09, 1.17103892689, 3576.2897934404],
                        [5.74e-09, 5.1923507414, 104.0559820651],
                        [5.6e-09, 3.57141429379, 5333.9002410216],
                        [5.55e-09, 0.18349908409, 512.4254897072],
                        [5.71e-09, 0.8307014882, 1570.9136480191],
                        [6.32e-09, 3.67893818442, 1065.0110044817],
                        [7.44e-09, 2.33083237537, 620.253566341],
                        [5.4e-09, 5.15775909675, 1751.539531416],
                        [5.92e-09, 3.07238123875, 1446.62324515],
                        [5.37e-09, 1.52803865425, 8094.5216858326],
                        [5.5e-09, 5.50701003577, 1432.3961511484],
                        [5.46e-09, 2.34388967045, 949.2237930796],
                        [5.34e-09, 3.04076654796, 7.1617311106],
                        [6.19e-09, 6.07865159203, 46.470422916],
                        [5.62e-09, 0.96641974928, 1438.0252254409],
                        [5.31e-09, 1.0669554739, 100.1720129118],
                        [5.99e-09, 3.59295739143, 1144.3154571431],
                        [5.26e-09, 3.51641923371, 0.7507595254],
                        [5.64e-09, 0.72677136494, 1059.2218714948],
                        [5.37e-09, 5.72603965787, 513.2286388593],
                        [6.3e-09, 2.311831439, 2729.4561991638],
                        [5.3e-09, 4.99510636441, 9264.1099372412],
                        [6.49e-09, 0.95666735852, 920.8644333185],
                        [5.47e-09, 1.18801926149, 11506.7697697936],
                        [5.16e-09, 3.28562070858, 734.9133056853],
                        [5.67e-09, 5.13926871155, 288.0806940053],
                        [5.38e-09, 0.2815963768, 153.4953503977],
                        [7.18e-09, 0.48326672359, 842.1506814881],
                        [5.26e-09, 4.39778401928, 546.1532913299],
                        [6.95e-09, 2.44235086902, 657.1627617014],
                        [6.97e-09, 4.99042365686, 12.5301729722],
                        [5.19e-09, 6.27847163164, 59.8037450403],
                        [5.04e-09, 2.58550284, 5378.6617841622],
                        [4.96e-09, 2.43659402827, 990.2294059144],
                        [6.17e-09, 5.732849857, 745.4377410874],
                        [5.19e-09, 3.1015709777, 9161.0171630226],
                        [6.54e-09, 1.31181453784, 878.3261636656],
                        [6.19e-09, 3.71554817226, 2090.3096723752],
                        [5e-09, 4.28937439066, 5216.5803728014],
                        [6.21e-09, 3.98893673383, 409.9234163196],
                        [6.85e-09, 1.95310431695, 3156.8051495652],
                        [5.52e-09, 2.81774132958, 344.7030453079],
                        [5.51e-09, 1.91969778405, 113.3877149571],
                        [6.82e-09, 0.87321578326, 6069.7767545534],
                        [6.51e-09, 5.09951064975, 531.3354964973],
                        [5.37e-09, 3.67357440226, 605.9570363702],
                        [5.25e-09, 0.74584814988, 736.8397213783],
                        [5.05e-09, 3.12494814307, 1475.6851803267],
                        [6.22e-09, 3.00013939606, 2349.3284312038],
                        [6.44e-09, 3.00156986335, 298.2326223919],
                        [5.64e-09, 3.81960833949, 1059.5419888836],
                        [4.68e-09, 3.50348554992, 4841.8572720668],
                        [4.91e-09, 1.28535573072, 247.2393453818],
                        [4.58e-09, 0.45056377876, 1065.6017053127],
                        [5.43e-09, 2.3970430832, 9690.7081281172],
                        [4.59e-09, 5.29870259698, 1474.9344208013],
                        [4.83e-09, 3.63649121244, 131.4039498699],
                        [6.32e-09, 2.75028345792, 334.5511169213],
                        [4.83e-09, 0.42979609421, 735.828329422],
                        [5.4e-09, 0.54791737146, 51646.1153180538],
                        [5.31e-09, 0.30026207053, 912.7876784712],
                        [4.49e-09, 3.02583472996, 5901.239202256],
                        [5.44e-09, 2.98747240952, 4223.3006267552],
                        [5.57e-09, 5.83542572008, 9676.4810341156],
                        [5.01e-09, 0.03408180117, 1080.7225711916],
                        [5.17e-09, 4.40400852026, 2545.3620512544],
                        [4.81e-09, 3.63292807076, 5584.8473325994],
                        [5.57e-09, 6.1144397819, 976.0023119128],
                        [4.81e-09, 3.41035583659, 3803.81598288],
                        [6.22e-09, 2.29597570837, 9999.986450773],
                        [4.54e-09, 2.88584538455, 1987.2168981566],
                        [4.39e-09, 4.83198101064, 50.4025761791],
                        [4.75e-09, 2.69994471394, 491.8185618877],
                        [6.18e-09, 0.72471290082, 1291.4309737229],
                        [5.03e-09, 0.13449993622, 2015.6710861598],
                        [5.51e-09, 2.13418546604, 1440.9941708575],
                        [5.95e-09, 3.78181802545, 6386.16862421],
                        [4.34e-09, 2.64411689486, 748.406686504],
                        [5.92e-09, 0.32587740408, 737.3609862401],
                        [4.9e-09, 2.379888288, 2225.7887878601],
                        [4.39e-09, 1.33582802018, 995.6460318858],
                        [5.43e-09, 2.05067702505, 906.849787638],
                        [4.66e-09, 2.43707405011, 3362.9906980024],
                        [4.81e-09, 2.32223226419, 1357.6145525811],
                        [5.66e-09, 0.59740900184, 350.3321196004],
                        [4.29e-09, 2.46287580628, 3914.0223040994],
                        [4.29e-09, 1.01299906509, 4333.5069479746],
                        [4.25e-09, 1.67255823369, 148.0787244263],
                        [4.12e-09, 3.29630633921, 7.3259953219],
                        [5.08e-09, 1.16158524676, 9.5612275556],
                        [5.24e-09, 5.0256292612, 1090.4014188262],
                        [4.09e-09, 5.80053072411, 9146.790069021],
                        [4.97e-09, 0.01579913593, 1069.6768709277],
                        [5.48e-09, 6.03429743373, 9367.2027114598],
                        [4.33e-09, 5.9368835084, 1688.2335162393],
                        [4.24e-09, 4.1815011153, 550.1378342197],
                        [4.01e-09, 0.11519846139, 970.5162499722],
                        [5.03e-09, 5.28212300854, 668.2084619653],
                        [5.55e-09, 1.00328633255, 141.2258098564],
                        [4.04e-09, 2.48633976473, 519.656656787],
                        [4.41e-09, 6.06185501734, 25.1297819136],
                        [4.12e-09, 5.87495245826, 6.9010986797],
                        [4.78e-09, 0.71264950607, 1094.8066528413],
                        [4.46e-09, 2.71248183031, 31.492569389],
                        [4.04e-09, 5.49462012486, 447.9388318784],
                        [3.91e-09, 1.261056127, 8.0767548473],
                        [4.63e-09, 1.93535321271, 6275.9623029906],
                        [5.07e-09, 3.61089992782, 546.956440482],
                        [4.02e-09, 5.86200127054, 927.8349679674],
                        [4.81e-09, 6.21043578332, 683.9894646444],
                        [4.83e-09, 5.02142924458, 857.1285350151],
                        [4.44e-09, 0.84873092377, 1371.8416465827],
                        [3.91e-09, 2.81753436573, 5798.1464280374],
                        [3.95e-09, 0.22367886581, 51116.4243529592],
                        [3.78e-09, 6.03765733432, 1268.7488723641],
                        [4.71e-09, 6.24506463249, 946.4672959841],
                        [4.05e-09, 0.57785207581, 107.2855599126],
                        [3.71e-09, 6.15750793727, 509.2440959695],
                        [3.7e-09, 4.90330687618, 1436.5407527326],
                        [4.48e-09, 4.76565111029, 284.1485407422],
                        [4.74e-09, 0.71146352197, 2108.4689196399],
                        [5.09e-09, 5.53328407404, 1128.534454464],
                      ],
          },
          {
            series => "R1",
            terms  => [
                        [0.01271801596, 2.64937511122, 529.6909650946],
                        [0.00061661771, 3.00076251018, 1059.3819301892],
                        [0.00053443592, 3.89717644226, 522.5774180938],
                        [0.00031185167, 4.88276663526, 536.8045120954],
                        [0.00041390257, 0, 0],
                        [0.0001184719, 2.41329588176, 419.4846438752],
                        [9.16636e-05, 4.75979408587, 7.1135470008],
                        [3.175763e-05, 2.79297987071, 103.0927742186],
                        [3.203446e-05, 5.21083285476, 735.8765135318],
                        [3.403605e-05, 3.34688537997, 1589.0728952838],
                        [2.600003e-05, 3.63435101622, 206.1855484372],
                        [2.412207e-05, 1.46947308304, 426.598190876],
                        [2.806064e-05, 3.7422369358, 515.463871093],
                        [2.676575e-05, 4.33052878699, 1052.2683831884],
                        [2.100507e-05, 3.92762682306, 639.897286314],
                        [1.646182e-05, 5.30953510947, 1066.49547719],
                        [1.641257e-05, 4.41628669824, 625.6701923124],
                        [1.049866e-05, 3.16113622955, 213.299095438],
                        [1.024802e-05, 2.55432643018, 412.3710968744],
                        [7.40996e-06, 2.17094630558, 1162.4747044078],
                        [8.06404e-06, 2.6775080138, 632.7837393132],
                        [6.76928e-06, 6.2495347979, 838.9692877504],
                        [4.68895e-06, 4.70973463481, 543.9180590962],
                        [4.44683e-06, 0.40281181402, 323.5054166574],
                        [5.67076e-06, 4.57655414712, 742.9900605326],
                        [4.15894e-06, 5.36836018215, 728.762966531],
                        [4.84689e-06, 2.46882793186, 949.1756089698],
                        [3.37555e-06, 3.1678195112, 956.2891559706],
                        [4.01738e-06, 4.60528841541, 309.2783226558],
                        [3.47378e-06, 4.68148808722, 14.2270940016],
                        [2.60753e-06, 5.34290306101, 846.0828347512],
                        [2.20084e-06, 4.84210964963, 1368.660252845],
                        [2.03217e-06, 5.59995425432, 1155.361157407],
                        [2.46603e-06, 3.92313823537, 942.062061969],
                        [1.83504e-06, 4.26526769703, 95.9792272178],
                        [1.80134e-06, 4.40165491159, 532.8723588323],
                        [1.97134e-06, 3.70551461394, 2118.7638603784],
                        [1.96005e-06, 3.75877587139, 199.0720014364],
                        [2.0019e-06, 4.43888814441, 1045.1548361876],
                        [1.70225e-06, 4.84647488867, 526.5095713569],
                        [1.46335e-06, 6.12958365535, 533.6231183577],
                        [1.33483e-06, 1.32245735855, 110.2063212194],
                        [1.32076e-06, 4.51187950811, 525.7588118315],
                        [1.23851e-06, 2.04290370696, 1478.8665740644],
                        [1.21861e-06, 4.40581788491, 1169.5882514086],
                        [1.15313e-06, 4.46741278152, 1581.959348283],
                        [9.8527e-07, 5.72833991647, 1596.1864422846],
                        [9.1608e-07, 4.52965592121, 1685.0521225016],
                        [1.10638e-06, 3.62504147403, 1272.6810256272],
                        [8.0536e-07, 4.11311699583, 1258.4539316256],
                        [7.9552e-07, 2.71898473954, 1692.1656695024],
                        [1.00164e-06, 5.24693885858, 1265.5674786264],
                        [7.7854e-07, 5.56722651753, 1471.7530270636],
                        [8.5766e-07, 0.07906707372, 831.8557407496],
                        [8.2132e-07, 3.80763015979, 508.3503240922],
                        [5.5319e-07, 0.35180851191, 316.3918696566],
                        [5.2338e-07, 5.53074272117, 433.7117378768],
                        [5.5769e-07, 4.75141241141, 302.164775655],
                        [5.0597e-07, 4.8560316177, 1375.7737998458],
                        [4.3554e-07, 4.94441642712, 1361.5467058442],
                        [4.2172e-07, 1.22404278447, 853.196381752],
                        [3.7695e-07, 4.26767539209, 2001.4439921582],
                        [4.9395e-07, 4.01422828967, 220.4126424388],
                        [3.8263e-07, 5.33025236797, 1788.1448967202],
                        [3.5611e-07, 1.76205571128, 1795.258443721],
                        [3.6296e-07, 3.84995284393, 1574.8458012822],
                        [2.9332e-07, 5.16619257786, 3.9321532631],
                        [2.518e-07, 4.33777727362, 519.3960243561],
                        [2.4778e-07, 2.7290789741, 405.2575498736],
                        [2.7025e-07, 6.09669947903, 1148.2476104062],
                        [2.2604e-07, 0.19173890105, 380.12776796],
                        [2.0499e-07, 4.32881495378, 3.1813937377],
                        [1.9925e-07, 4.62967500111, 1677.9385755008],
                        [1.9528e-07, 5.10596326232, 1073.6090241908],
                        [1.8427e-07, 3.765221783, 1485.9801210652],
                        [1.8869e-07, 5.05259402407, 2104.5367663768],
                        [1.7031e-07, 4.01843356903, 2317.8358618148],
                        [1.6671e-07, 5.42931676507, 88.865680217],
                        [1.5337e-07, 2.92700926091, 2008.557539159],
                        [1.4499e-07, 3.63339836845, 628.8515860501],
                        [1.4575e-07, 5.50832843322, 721.6494195302],
                        [1.3728e-07, 4.87623389735, 629.6023455755],
                        [1.8481e-07, 6.03032762264, 330.6189636582],
                        [1.3499e-07, 1.38539534821, 518.6452648307],
                        [1.574e-07, 2.93038271684, 1905.4647649404],
                        [1.2459e-07, 1.58587053146, 2111.6503133776],
                        [1.2272e-07, 3.37671053917, 635.9651330509],
                        [1.1836e-07, 4.08486322993, 2648.454825473],
                        [1.1166e-07, 4.62623267608, 636.7158925763],
                        [1.4348e-07, 2.74177797727, 2221.856634597],
                        [1.1221e-07, 3.55311861205, 1891.2376709388],
                        [1.3121e-07, 5.83845065644, 1464.6394800628],
                        [1.1351e-07, 2.5760688623, 511.5317178299],
                        [1.0487e-07, 0.49850799841, 453.424893819],
                        [9.728e-08, 4.38837468002, 1994.3304451574],
                        [1.0131e-07, 2.76432756215, 423.4167971383],
                        [8.62e-08, 5.16374493158, 1056.2005364515],
                        [8.952e-08, 4.79407952752, 2420.9286360334],
                        [8.126e-08, 3.72977106954, 2634.2277314714],
                        [8.078e-08, 1.29246272894, 2428.0421830342],
                        [8.867e-08, 1.85684753622, 750.1036075334],
                        [8.912e-08, 4.80973516711, 1062.5633239269],
                        [8.552e-08, 4.53818617984, 21.3406410024],
                        [9.468e-08, 4.33472161983, 1802.3719907218],
                        [6.904e-08, 5.96616555709, 540.7366653585],
                        [7.293e-08, 4.97763580465, 1699.2792165032],
                        [7.083e-08, 4.99096728816, 1055.4497769261],
                        [7.226e-08, 4.97823884383, 1898.3512179396],
                        [6.464e-08, 1.39173466879, 422.6660376129],
                        [6.214e-08, 4.46490158256, 551.031606097],
                        [6.794e-08, 2.90878831415, 2324.9494088156],
                        [6.173e-08, 3.65617162985, 621.7380390493],
                        [6.243e-08, 6.13691919694, 2125.8774073792],
                        [5.936e-08, 2.5831223512, 569.0478410098],
                        [6.504e-08, 4.56908431757, 1038.0412891868],
                        [7.305e-08, 3.02062127734, 416.3032501375],
                        [6.598e-08, 5.55348005731, 1781.0313497194],
                        [5.133e-08, 6.2164691798, 963.4027029714],
                        [5.876e-08, 4.23153077453, 539.9859058331],
                        [5.119e-08, 0.06942832171, 1063.3140834523],
                        [5.46e-08, 4.91084384602, 835.0371344873],
                        [4.989e-08, 1.3515369468, 1382.8873468466],
                        [5.224e-08, 0.18468411116, 117.3198682202],
                        [6.187e-08, 3.87193497099, 191.9584544356],
                        [4.681e-08, 4.61057119508, 643.8294395771],
                        [4.627e-08, 3.34644534691, 2207.6295405954],
                        [4.526e-08, 4.07729737127, 2310.722314814],
                        [4.718e-08, 4.55578336947, 2737.32050569],
                        [4.471e-08, 1.47603161897, 408.4389436113],
                        [4.073e-08, 1.1301490318, 415.5524906121],
                        [5.476e-08, 5.63198569698, 618.5566453116],
                        [4.034e-08, 4.09631702747, 430.5303441391],
                        [4.304e-08, 4.60536378943, 647.0108333148],
                        [3.765e-08, 3.42751259825, 2950.619601128],
                        [4.559e-08, 4.23723998745, 227.5261894396],
                        [3.695e-08, 1.03127824978, 2744.4340526908],
                        [3.667e-08, 4.12268925541, 440.8252848776],
                        [3.677e-08, 2.19480200527, 534.3568315406],
                        [3.818e-08, 1.14800596289, 74.7815985673],
                        [4.221e-08, 2.37721579949, 2538.2485042536],
                        [3.488e-08, 5.33792561596, 458.8415197904],
                        [3.437e-08, 4.26164443643, 10.2949407385],
                        [4.394e-08, 0.18808423412, 824.7421937488],
                        [3.339e-08, 4.85708402591, 295.0512286542],
                        [3.329e-08, 5.50043586719, 739.8086667949],
                        [3.623e-08, 4.64011531952, 2214.7430875962],
                        [3.185e-08, 2.69708590442, 561.934294009],
                        [3.421e-08, 3.38512615384, 149.5631971346],
                        [3.442e-08, 4.34217280083, 305.3461693927],
                        [3.58e-08, 5.29481665335, 2097.423219376],
                        [3.401e-08, 2.74761862893, 2641.3412784722],
                        [2.901e-08, 0.91012525424, 984.6003316219],
                        [3.566e-08, 1.63400343968, 525.0250986486],
                        [2.869e-08, 1.31799241974, 611.4430983108],
                        [2.635e-08, 5.25517910535, 532.1386456494],
                        [2.683e-08, 4.24641945773, 3053.7123753466],
                        [2.614e-08, 3.17862099921, 527.2432845398],
                        [2.251e-08, 4.2159824736, 739.0579072695],
                        [2.268e-08, 5.5224811056, 524.2743391232],
                        [2.372e-08, 4.19741177512, 217.2312487011],
                        [2.623e-08, 5.82647427958, 732.6951197941],
                        [2.666e-08, 3.92538056951, 210.1177017003],
                        [2.036e-08, 4.84043420813, 1049.0869894507],
                        [2.441e-08, 2.63840901843, 760.25553592],
                        [2.095e-08, 5.76269812349, 529.6427809848],
                        [2.021e-08, 3.81308146017, 2627.1141844706],
                        [2.089e-08, 4.18463193132, 945.9942152321],
                        [2.305e-08, 1.6122066569, 604.4725636619],
                        [1.969e-08, 5.37427735384, 142.4496501338],
                        [1.923e-08, 4.75088270631, 535.107591066],
                        [1.955e-08, 5.49000238006, 1439.5096981492],
                        [1.877e-08, 3.26978877187, 3267.0114707846],
                        [2.286e-08, 2.93885172004, 76.2660712756],
                        [2.074e-08, 5.85386852879, 532.6117264014],
                        [2.121e-08, 3.92430797099, 2435.155730035],
                        [1.807e-08, 3.17208959472, 2524.021410252],
                        [1.712e-08, 4.02986641257, 731.9443602687],
                        [2.119e-08, 0.41049593984, 1279.794572628],
                        [1.66e-08, 2.34370903423, 528.7277572481],
                        [1.655e-08, 0.78809717175, 3060.8259223474],
                        [1.729e-08, 4.26127896267, 724.8308132679],
                        [2.06e-08, 5.04785330873, 2413.8150890326],
                        [2.095e-08, 2.67732367556, 529.7391492044],
                        [1.933e-08, 2.49162437046, 2957.7331481288],
                        [1.898e-08, 2.71948262975, 952.3570027075],
                        [1.634e-08, 2.98113068812, 945.2434557067],
                        [1.582e-08, 5.84373095005, 547.8502123593],
                        [1.662e-08, 0.27359627181, 454.9093665273],
                        [1.595e-08, 1.18530167095, 38.1330356378],
                        [1.55e-08, 0.64264572959, 312.4597163935],
                        [1.525e-08, 4.08789824989, 1158.5425511447],
                        [1.542e-08, 1.12520322326, 1021.2488945514],
                        [1.539e-08, 0.37324921979, 319.5732633943],
                        [1.628e-08, 5.24285773388, 1354.4331588434],
                        [1.897e-08, 3.79973291113, 953.1077622329],
                        [1.44e-08, 4.37872256685, 3178.1457905676],
                        [1.439e-08, 4.26513521887, 526.7702037878],
                        [1.557e-08, 5.43779802371, 81.7521332162],
                        [1.656e-08, 6.0966708974, 530.6541729411],
                        [1.548e-08, 3.48799710267, 934.9485149682],
                        [1.772e-08, 5.82549274759, 909.8187330546],
                        [1.615e-08, 1.45018725033, 902.7051860538],
                        [1.387e-08, 2.52840497309, 530.44172462],
                        [1.574e-08, 1.89565809136, 437.6438911399],
                        [1.459e-08, 3.32546061506, 1041.2226829245],
                        [1.377e-08, 0.10015418633, 490.3340891794],
                        [1.46e-08, 4.00706825185, 3370.1042450032],
                        [1.605e-08, 4.27993020192, 2531.1349572528],
                        [1.707e-08, 6.28253681644, 18.1592472647],
                        [1.802e-08, 2.23019296374, 2854.6403739102],
                        [1.39e-08, 3.76737324192, 1165.6560981455],
                        [1.498e-08, 0.17285954362, 1141.1340634054],
                        [1.401e-08, 4.81225317549, 1251.3403846248],
                        [1.244e-08, 2.83383980283, 124.433415221],
                        [1.32e-08, 5.80675430384, 387.2413149608],
                        [1.329e-08, 0.88314574243, 916.9322800554],
                        [1.558e-08, 6.17808619637, 983.1158589136],
                        [1.243e-08, 0.29239666059, 597.3590166611],
                        [1.541e-08, 3.51095241498, 2751.5475996916],
                        [1.482e-08, 0.83066678204, 529.1697002328],
                        [1.149e-08, 3.91142023857, 99.9113804809],
                        [1.114e-08, 3.5333963729, 483.2205421786],
                        [1.195e-08, 4.16301075999, 203.0041546995],
                        [1.1e-08, 1.74769285223, 497.4476361802],
                        [1.458e-08, 5.19315120878, 1592.2542890215],
                        [1.123e-08, 1.45270581179, 533.8837507886],
                        [1.078e-08, 5.2399179294, 1159.2933106701],
                        [1.083e-08, 3.57026506855, 2943.5060541272],
                        [1.072e-08, 0.07132659992, 1070.4276304531],
                        [1.037e-08, 5.48955598976, 1585.8915015461],
                        [1.343e-08, 0.29600445633, 860.3099287528],
                        [1.361e-08, 3.46603373194, 107.0249274817],
                        [1.061e-08, 2.44580706826, 1048.3362299253],
                        [1.002e-08, 5.5521611741, 337.732510659],
                        [9.81e-09, 3.15500987023, 70.8494453042],
                        [1.007e-08, 4.11504050436, 501.2367770914],
                        [9.65e-09, 5.63719524421, 1603.2999892854],
                        [1.083e-08, 4.8837390981, 1166.4068576709],
                        [9.53e-09, 2.83352026342, 3583.4033404412],
                        [1.06e-08, 3.18542176646, 447.7958195265],
                        [1.136e-08, 2.2656859095, 525.4981794006],
                        [1.191e-08, 2.25249961404, 106.2741679563],
                        [8.84e-09, 4.69777781327, 960.2213092337],
                        [1.165e-08, 1.56030440737, 630.3360587584],
                        [9.47e-09, 0.50856414717, 842.9014410135],
                        [1.011e-08, 0.30814674949, 1593.0050485469],
                        [9.24e-09, 2.31939900786, 327.4375699205],
                        [8.96e-09, 0.22222521202, 746.9222137957],
                        [1.078e-08, 4.78329116086, 2730.2069586892],
                        [9.38e-09, 5.42471506763, 1585.1407420207],
                        [9.23e-09, 4.44469169065, 9676.4810341156],
                        [8.94e-09, 0.2694082187, 2655.5683724738],
                        [1.131e-08, 5.46382510304, 224.3447957019],
                        [8.08e-09, 0.48295590141, 3377.217792004],
                        [8.09e-09, 4.14122746067, 114.1384744825],
                        [8.64e-09, 1.83217006136, 4.665866446],
                        [1.106e-08, 2.60444312553, 209.3669421749],
                        [7.9e-09, 0.11493626208, 460.5384408198],
                        [7.99e-09, 1.6042649759, 5223.6939198022],
                        [9.33e-09, 0.30976125598, 685.4739373527],
                        [1.053e-08, 5.23433104008, 842.1506814881],
                        [8.46e-09, 3.0287839349, 5746.271337896],
                        [7.99e-09, 2.08457026425, 77734.018459628],
                        [8.2e-09, 0.99821486743, 373.0142209592],
                        [8.92e-09, 5.36446426391, 827.9235874865],
                        [8.21e-09, 3.53889274951, 498.6714764576],
                        [7.41e-09, 1.32379374647, 530.2122299564],
                        [7.9e-09, 2.88034567513, 938.1299087059],
                        [8.42e-09, 3.39449778904, 484.444382456],
                        [7.85e-09, 0.57841470897, 850.0149880143],
                        [7.59e-09, 3.82014112009, 6283.0758499914],
                        [9.54e-09, 2.94534072982, 462.0229135281],
                        [7.67e-09, 3.33725133157, 99.1606209555],
                        [8.1e-09, 4.69425300466, 2228.9701815978],
                        [7e-09, 1.72050221502, 775.233389447],
                        [7.64e-09, 4.91747674296, 1670.8250285],
                        [7.24e-09, 6.08692841992, 2281.2304965106],
                        [7.11e-09, 4.82250918143, 11.7794134468],
                        [6.92e-09, 2.63705354662, 6.592282139],
                        [7.71e-09, 3.87410612014, 9690.7081281172],
                        [9.06e-09, 2.47189948442, 3274.1250177854],
                        [7.81e-09, 1.25357484582, 202.2533951741],
                        [7.57e-09, 3.78079814332, 2818.035008606],
                        [7.56e-09, 4.28312053897, 2803.8079146044],
                        [6.63e-09, 5.27704405712, 4532.578949411],
                        [7.59e-09, 5.4535868657, 9683.5945811164],
                        [6.98e-09, 5.43712520216, 565.1156877467],
                        [7.09e-09, 3.71117647887, 3686.4961146598],
                        [6.77e-09, 4.27891183416, 25028.521211385],
                        [6.43e-09, 1.40239510103, 9161.0171630226],
                        [6.56e-09, 0.60909845504, 835.7878940127],
                        [6.35e-09, 5.75373871128, 429.7795846137],
                        [7.02e-09, 6.10412979847, 4635.6717236296],
                        [6.27e-09, 3.03666956129, 2840.4132799086],
                        [8.02e-09, 4.18688054701, 5753.3848848968],
                        [8.38e-09, 4.51386507097, 1069.6768709277],
                        [6.33e-09, 4.37183361444, 5.4166259714],
                        [6.52e-09, 5.79409889124, 1061.829610744],
                        [6.38e-09, 2.18896270346, 313.2104759189],
                        [8.27e-09, 5.94231186039, 1457.525933062],
                        [6.78e-09, 2.45013730979, 5760.4984318976],
                        [8.14e-09, 4.8957879117, 1567.7322542814],
                        [6.24e-09, 0.61631100566, 1176.7017984094],
                        [6e-09, 3.20918322285, 1098.7388061044],
                        [7.17e-09, 1.8234906449, 3171.0322435668],
                        [6.51e-09, 4.14419317491, 2847.5268269094],
                        [6.29e-09, 1.75272560843, 92.0470739547],
                        [6.26e-09, 3.53146082217, 3067.9394693482],
                        [6.67e-09, 4.22974611158, 4539.6924964118],
                        [5.65e-09, 0.99416346033, 1894.4190646765],
                        [7.52e-09, 0.4606370015, 635.231419868],
                        [6.22e-09, 1.98136818407, 25565.3257234804],
                        [6.14e-09, 2.48275371627, 25551.0986294788],
                        [5.6e-09, 1.40733893388, 446.3113468182],
                        [5.58e-09, 4.37217796469, 1057.8974574809],
                        [6.28e-09, 4.65037810102, 6275.9623029906],
                        [6.59e-09, 2.41470950463, 195.1398481733],
                        [6.16e-09, 2.08837621877, 10.0343083076],
                        [6.92e-09, 3.1322902553, 7.6348118626],
                        [6.85e-09, 4.18539472904, 46.470422916],
                        [6.24e-09, 0.02693303471, 1493.093668066],
                        [5.94e-09, 2.13375704438, 121.2520214833],
                        [5.08e-09, 2.1358430071, 1.6969210294],
                        [6.74e-09, 1.47570122611, 4694.0029547076],
                        [5.59e-09, 4.48852017557, 531.1754378029],
                        [6.4e-09, 3.10239233469, 11.0457002639],
                        [4.96e-09, 1.29000001439, 927.8349679674],
                        [5.87e-09, 3.30651435298, 600.5404103988],
                        [5.82e-09, 0.4454094886, 113.3877149571],
                        [4.92e-09, 4.83275232, 9492.1463150048],
                        [5.49e-09, 4.34579166146, 3046.5988283458],
                        [5.76e-09, 1.22846846364, 1514.2912967165],
                        [5.93e-09, 5.86079640612, 524.0618908021],
                        [5.1e-09, 2.6255703127, 529.851023789],
                        [4.89e-09, 6.26855707323, 3693.6096616606],
                        [4.8e-09, 0.30754294369, 528.9402055692],
                        [5.82e-09, 3.51934668795, 1056.9342496344],
                        [4.93e-09, 5.52699906925, 512.2824773553],
                        [4.81e-09, 2.99681040149, 9153.9036160218],
                        [5.62e-09, 3.73437025868, 2015.6710861598],
                        [4.58e-09, 3.86646994292, 11.3063326948],
                        [4.57e-09, 1.80238019931, 3281.2385647862],
                        [4.53e-09, 6.17995938655, 1059.3337460794],
                        [5.51e-09, 0.13794958618, 1912.5783119412],
                        [4.46e-09, 5.53828660924, 2332.0629558164],
                        [4.44e-09, 5.06219342598, 7.8643065262],
                        [4.61e-09, 0.16951411708, 26087.9031415742],
                        [4.39e-09, 4.14986379679, 1151.4290041439],
                        [6.14e-09, 5.42289673768, 2090.3096723752],
                        [4.88e-09, 3.71681959056, 447.9388318784],
                        [5.92e-09, 2.91424148255, 8624.2126509272],
                        [4.33e-09, 2.55336268329, 1064.0477966352],
                        [4.49e-09, 5.24955106938, 10213.285546211],
                        [5.1e-09, 5.81591864532, 529.5309064002],
                        [4.35e-09, 5.34355963629, 560.7104537316],
                        [4.49e-09, 0.72330388784, 2758.6611466924],
                        [4.3e-09, 0.94519103478, 6.3627874754],
                        [5.63e-09, 6.19175228344, 1884.124123938],
                        [4.43e-09, 3.39246520261, 1152.1797636693],
                        [4.3e-09, 1.28652623263, 505.3119427064],
                        [4.22e-09, 5.12631540623, 944.9828232758],
                        [4.64e-09, 2.90444584145, 398.1440028728],
                        [4.1e-09, 1.24248975309, 5069.3834615064],
                        [4.11e-09, 2.95117124177, 4326.3934009738],
                        [4.18e-09, 5.15499986314, 1173.5204046717],
                        [4.12e-09, 2.9812544633, 554.0699874828],
                        [4.03e-09, 0.34381388674, 32.2433289144],
                        [4.02e-09, 5.88926765351, 1570.9136480191],
                        [5.05e-09, 1.49028912471, 3782.4753418776],
                        [4.47e-09, 0.03952029309, 245.5424243524],
                        [4.53e-09, 3.09458004153, 1059.430114299],
                        [4.11e-09, 3.21727542472, 1475.6851803267],
                        [4.26e-09, 3.12237794195, 12566.1516999828],
                        [4.34e-09, 3.59362426939, 3259.8979237838],
                        [3.98e-09, 4.91510709622, 4120.2078525366],
                        [3.99e-09, 4.67075122011, 234.6397364404],
                        [3.86e-09, 4.81320787761, 970.5162499722],
                        [4.27e-09, 3.21176085113, 977.4867846211],
                        [4.11e-09, 4.31566962034, 757.2171545342],
                        [3.92e-09, 1.86527946688, 885.4397106664],
                        [4.16e-09, 3.81408093105, 3156.8051495652],
                      ],
          },
          {
            series => "R2",
            terms  => [
                        [0.00079644833, 1.35865896596, 529.6909650946],
                        [8.251618e-05, 5.77773935444, 522.5774180938],
                        [7.029864e-05, 3.27476965833, 536.8045120954],
                        [5.314006e-05, 1.83835109712, 1059.3819301892],
                        [1.860833e-05, 2.97682139367, 7.1135470008],
                        [8.36267e-06, 4.19889881718, 419.4846438752],
                        [9.64466e-06, 5.48031822015, 515.463871093],
                        [4.06453e-06, 3.78250730354, 1066.49547719],
                        [4.2657e-06, 2.22753101795, 639.897286314],
                        [3.77316e-06, 2.24248352873, 1589.0728952838],
                        [4.9792e-06, 3.14159265359, 0],
                        [3.39043e-06, 6.12690864038, 625.6701923124],
                        [3.62943e-06, 5.36761847267, 206.1855484372],
                        [3.42048e-06, 6.09922969324, 1052.2683831884],
                        [2.7992e-06, 4.26162555827, 412.3710968744],
                        [3.32578e-06, 0.00328961161, 426.598190876],
                        [2.29777e-06, 0.70530766213, 735.8765135318],
                        [2.00783e-06, 3.06850623368, 543.9180590962],
                        [1.99807e-06, 4.42884165317, 103.0927742186],
                        [2.5729e-06, 0.96295364983, 632.7837393132],
                        [1.38606e-06, 2.93235671606, 14.2270940016],
                        [1.13535e-06, 0.78713911289, 728.762966531],
                        [8.6025e-07, 5.14434751994, 323.5054166574],
                        [9.4565e-07, 1.70498041073, 838.9692877504],
                        [8.3469e-07, 0.05834873484, 309.2783226558],
                        [7.5198e-07, 1.60495195911, 956.2891559706],
                        [7.0451e-07, 1.50988357484, 213.299095438],
                        [8.0328e-07, 2.98122361797, 742.9900605326],
                        [5.6203e-07, 0.95534810533, 1162.4747044078],
                        [6.1649e-07, 6.10137889854, 1045.1548361876],
                        [6.6572e-07, 5.47307178077, 199.0720014364],
                        [5.0057e-07, 2.72063162317, 532.8723588323],
                        [5.1904e-07, 5.58435625607, 942.062061969],
                        [3.9833e-07, 5.94566506227, 95.9792272178],
                        [4.4548e-07, 5.52445621411, 508.3503240922],
                        [4.4282e-07, 0.27118152557, 526.5095713569],
                        [2.9944e-07, 0.93641735919, 1155.361157407],
                        [2.8412e-07, 2.87835720211, 525.7588118315],
                        [2.633e-07, 4.26891877269, 1596.1864422846],
                        [2.7039e-07, 2.80607741398, 1169.5882514086],
                        [2.7477e-07, 2.64841266238, 2118.7638603784],
                        [2.2705e-07, 0.17830004133, 302.164775655],
                        [2.9347e-07, 1.7858969235, 831.8557407496],
                        [1.9991e-07, 0.04328951895, 949.1756089698],
                        [1.9906e-07, 1.16072627347, 533.6231183577],
                        [2.1714e-07, 1.88820231818, 1272.6810256272],
                        [1.7581e-07, 4.14974757919, 846.0828347512],
                        [1.7085e-07, 5.89188996975, 1258.4539316256],
                        [2.1407e-07, 4.35468497204, 316.3918696566],
                        [2.1295e-07, 0.54429472455, 1265.5674786264],
                        [1.9859e-07, 0.064538258, 1581.959348283],
                        [1.7025e-07, 0.53383755278, 1368.660252845],
                        [1.2804e-07, 3.90044242142, 433.7117378768],
                        [1.3072e-07, 0.79468040717, 110.2063212194],
                        [1.1945e-07, 0.40671403646, 1361.5467058442],
                        [1.1695e-07, 4.44394618065, 405.2575498736],
                        [1.1979e-07, 2.22872778682, 220.4126424388],
                        [9.633e-08, 6.01002272123, 853.196381752],
                        [1.0163e-07, 0.99504635158, 1471.7530270636],
                        [8.977e-08, 1.60328709409, 1692.1656695024],
                        [8.701e-08, 3.52167876799, 1073.6090241908],
                        [8.314e-08, 5.60169732564, 1574.8458012822],
                        [8.958e-08, 6.26708748901, 519.3960243561],
                        [7.828e-08, 0.65241611799, 1478.8665740644],
                        [7.833e-08, 0.17920601344, 1685.0521225016],
                        [7.451e-08, 0.88421084942, 88.865680217],
                        [7.32e-08, 0.89341249264, 721.6494195302],
                        [9.135e-08, 1.51210840939, 1148.2476104062],
                        [6.11e-08, 2.50080005128, 3.1813937377],
                        [7.037e-08, 4.44127496638, 330.6189636582],
                        [5.163e-08, 2.79219166952, 21.3406410024],
                        [5.079e-08, 2.97991736844, 1375.7737998458],
                        [4.93e-08, 0.04683167622, 1677.9385755008],
                        [4.664e-08, 2.28007273876, 1485.9801210652],
                        [4.692e-08, 0.86220230505, 3.9321532631],
                        [5.307e-08, 0.85008578245, 1788.1448967202],
                        [4.239e-08, 0.40758287124, 629.6023455755],
                        [4.23e-08, 1.61046658091, 635.9651330509],
                        [3.627e-08, 2.71151441113, 551.031606097],
                        [3.314e-08, 0.55067236587, 1795.258443721],
                        [4.409e-08, 1.2812775105, 1464.6394800628],
                        [3.27e-08, 1.18744032691, 1905.4647649404],
                        [3.226e-08, 6.18716071251, 1038.0412891868],
                        [3.103e-08, 6.22971614425, 2001.4439921582],
                        [3.41e-08, 2.44624067925, 539.9859058331],
                        [3.174e-08, 5.54870592599, 191.9584544356],
                        [2.59e-08, 3.24430559059, 1062.5633239269],
                        [2.614e-08, 0.55149554149, 2104.5367663768],
                        [2.174e-08, 5.32613824409, 1891.2376709388],
                        [2.659e-08, 4.8245997422, 416.3032501375],
                        [2.187e-08, 1.71707514653, 628.8515860501],
                        [2.263e-08, 6.19233486371, 1994.3304451574],
                        [2.328e-08, 4.28236795066, 963.4027029714],
                        [2.579e-08, 0.03256542251, 1898.3512179396],
                        [2.077e-08, 3.32602157426, 1699.2792165032],
                        [2.529e-08, 2.39697505835, 227.5261894396],
                        [2.468e-08, 0.06551346218, 750.1036075334],
                        [1.989e-08, 0.29206371261, 636.7158925763],
                        [1.927e-08, 0.32286661566, 295.0512286542],
                        [1.904e-08, 3.43534792123, 647.0108333148],
                        [1.94e-08, 0.29170673525, 2111.6503133776],
                        [1.88e-08, 3.14403615586, 611.4430983108],
                        [2.324e-08, 1.94960720763, 824.7421937488],
                        [1.854e-08, 4.71794950485, 2125.8774073792],
                        [2.547e-08, 1.2390835309, 2221.856634597],
                        [1.814e-08, 1.60250861074, 2008.557539159],
                        [1.611e-08, 5.83466560322, 422.6660376129],
                        [1.667e-08, 2.32455940876, 440.8252848776],
                        [1.622e-08, 0.36650974375, 1056.2005364515],
                        [1.624e-08, 2.42139677881, 10.2949407385],
                        [1.622e-08, 3.51892791175, 1055.4497769261],
                        [1.606e-08, 5.76205763975, 117.3198682202],
                        [1.646e-08, 5.88662636573, 2317.8358618148],
                        [2.026e-08, 4.61781314145, 423.4167971383],
                        [2.098e-08, 1.04559231028, 1781.0313497194],
                        [1.868e-08, 1.12487729469, 618.5566453116],
                        [1.885e-08, 2.78775930564, 1802.3719907218],
                        [1.445e-08, 0.08308050305, 1382.8873468466],
                        [1.797e-08, 3.00776822706, 2648.454825473],
                        [1.422e-08, 0.17649746278, 2420.9286360334],
                        [1.129e-08, 1.5903029132, 380.12776796],
                        [1.126e-08, 4.199896736, 547.8502123593],
                        [1.186e-08, 5.98943062173, 2310.722314814],
                        [1.108e-08, 4.22655117757, 934.9485149682],
                        [1.259e-08, 1.19687222266, 1063.3140834523],
                        [1.072e-08, 3.86169004168, 1603.2999892854],
                        [9.46e-09, 5.59968097387, 99.9113804809],
                        [9.37e-09, 1.0308327676, 81.7521332162],
                        [9.38e-09, 6.18136092771, 945.9942152321],
                        [9.08e-09, 2.54355964041, 6283.0758499914],
                        [8.74e-09, 5.21903196047, 2207.6295405954],
                        [8.74e-09, 6.01240284465, 511.5317178299],
                        [1.188e-08, 0.75698357968, 2097.423219376],
                        [7.89e-09, 3.91035208173, 10213.285546211],
                        [1e-08, 1.34667100304, 732.6951197941],
                        [9.52e-09, 1.5535577742, 2324.9494088156],
                        [8.11e-09, 5.00475553271, 319.5732633943],
                        [7.63e-09, 3.9852755963, 337.732510659],
                        [8.8e-09, 1.14789972199, 952.3570027075],
                        [7.8e-09, 4.6946331693, 5746.271337896],
                        [9.1e-09, 0.08774541571, 2737.32050569],
                        [7.73e-09, 0.77131695762, 5760.4984318976],
                        [7.64e-09, 6.11686539353, 9676.4810341156],
                        [7.58e-09, 2.1935071986, 9690.7081281172],
                        [6.71e-09, 1.19532387143, 124.433415221],
                        [6.61e-09, 5.99578306627, 501.2367770914],
                        [7.29e-09, 0.65312263578, 2538.2485042536],
                        [8.25e-09, 2.70770030205, 3370.1042450032],
                        [6.7e-09, 5.44169923277, 107.0249274817],
                        [7.39e-09, 1.14609907817, 2641.3412784722],
                        [8.66e-09, 3.02831268213, 3046.5988283458],
                        [7.18e-09, 4.83684196454, 860.3099287528],
                        [8.13e-09, 6.01229270247, 2214.7430875962],
                        [7.46e-09, 1.12371143332, 739.8086667949],
                        [7.41e-09, 5.9317166201, 2634.2277314714],
                        [6.67e-09, 0.89885058003, 106.2741679563],
                        [5.73e-09, 2.42701822581, 739.0579072695],
                        [7.34e-09, 0.72837704619, 1354.4331588434],
                        [6.62e-09, 2.2176897639, 2015.6710861598],
                        [7.82e-09, 2.52401202862, 3679.382567659],
                        [7.79e-09, 2.38608991574, 3267.0114707846],
                        [5.53e-09, 1.85211127676, 453.424893819],
                        [7.01e-09, 4.23431087374, 9683.5945811164],
                        [5.71e-09, 2.98435419019, 1262.3860848887],
                        [6.21e-09, 1.2446288744, 3803.81598288],
                        [5.63e-09, 5.99845316446, 1049.0869894507],
                        [5.38e-09, 4.92334194042, 447.7958195265],
                        [5.34e-09, 0.99911551571, 462.0229135281],
                        [5.41e-09, 6.19275150397, 1987.2168981566],
                        [5.11e-09, 3.2855327837, 4.665866446],
                        [5.39e-09, 5.33214565622, 2751.5475996916],
                        [6.51e-09, 5.12199308959, 3156.8051495652],
                        [4.83e-09, 3.03782387056, 3281.2385647862],
                        [4.76e-09, 2.17592053936, 149.5631971346],
                        [5.1e-09, 5.35664230912, 9.5612275556],
                        [4.9e-09, 1.57324553106, 1251.3403846248],
                        [4.67e-09, 5.9234342384, 203.0041546995],
                        [5.28e-09, 5.81786945766, 2627.1141844706],
                        [4.47e-09, 3.51498961805, 18.1592472647],
                        [4.29e-09, 0.16627197188, 74.7815985673],
                        [4.97e-09, 0.30985248432, 2428.0421830342],
                        [5.16e-09, 3.89424540015, 2516.9078632512],
                        [5.19e-09, 2.43126348834, 3686.4961146598],
                        [4.04e-09, 2.77840802846, 7.1617311106],
                        [5.33e-09, 4.77083438961, 3473.1970192218],
                        [5.15e-09, 3.54549816613, 3178.1457905676],
                        [5.33e-09, 5.61415688189, 2524.021410252],
                        [4.58e-09, 4.91616403047, 3067.9394693482],
                        [4e-09, 3.13887720912, 540.7366653585],
                        [3.78e-09, 0.8612245094, 525.0250986486],
                      ],
          },
          {
            series => "R3",
            terms  => [
                        [3.519257e-05, 6.05800633846, 529.6909650946],
                        [1.073239e-05, 1.6732134576, 536.8045120954],
                        [9.15666e-06, 1.41329676116, 522.5774180938],
                        [3.41593e-06, 0.52296542656, 1059.3819301892],
                        [2.54893e-06, 1.19625473533, 7.1135470008],
                        [2.21512e-06, 0.95225226237, 515.463871093],
                        [6.9078e-07, 2.26885282314, 1066.49547719],
                        [8.9729e-07, 3.14159265359, 0],
                        [5.7827e-07, 1.41389745339, 543.9180590962],
                        [5.7653e-07, 0.52580117593, 639.897286314],
                        [5.1079e-07, 5.98016364677, 412.3710968744],
                        [4.6935e-07, 1.57864237959, 625.6701923124],
                        [4.2824e-07, 6.11689609099, 419.4846438752],
                        [3.7477e-07, 1.1826276233, 14.2270940016],
                        [3.3816e-07, 1.66671706951, 1052.2683831884],
                        [3.1195e-07, 1.04290245896, 1589.0728952838],
                        [3.0023e-07, 4.63236245032, 426.598190876],
                        [3.3531e-07, 0.84784977903, 206.1855484372],
                        [2.0804e-07, 2.50071243814, 728.762966531],
                        [1.4466e-07, 0.96040197071, 508.3503240922],
                        [1.2969e-07, 1.5023378855, 1045.1548361876],
                        [1.1654e-07, 3.55513510121, 323.5054166574],
                        [1.2319e-07, 2.60952614503, 735.8765135318],
                        [1.5023e-07, 0.89136998434, 199.0720014364],
                        [1.116e-07, 1.79041437555, 309.2783226558],
                        [1.0554e-07, 6.27845112678, 956.2891559706],
                        [9.812e-08, 6.26016859519, 103.0927742186],
                        [9.301e-08, 3.45126812476, 838.9692877504],
                        [6.672e-08, 1.87004905364, 302.164775655],
                        [7.442e-08, 1.28047007623, 742.9900605326],
                        [7.178e-08, 0.92022189637, 942.062061969],
                        [5.577e-08, 1.37980792905, 95.9792272178],
                        [6.834e-08, 3.45228722967, 831.8557407496],
                        [4.632e-08, 2.82934545414, 1596.1864422846],
                        [3.969e-08, 1.21290005054, 1169.5882514086],
                        [3.869e-08, 5.99495313698, 213.299095438],
                        [3.551e-08, 6.10714791535, 405.2575498736],
                        [2.943e-08, 2.32831075458, 1155.361157407],
                        [2.442e-08, 1.86965213405, 532.8723588323],
                        [2.41e-08, 0.42627205128, 220.4126424388],
                        [2.289e-08, 1.94941487274, 1073.6090241908],
                        [2.274e-08, 0.09211517505, 632.7837393132],
                        [2.189e-08, 1.58907745204, 2118.7638603784],
                        [2.387e-08, 5.97080671477, 1162.4747044078],
                        [2.104e-08, 1.06751462671, 21.3406410024],
                        [2.128e-08, 1.51119399925, 1258.4539316256],
                        [2.491e-08, 0.35125020737, 1272.6810256272],
                        [2.006e-08, 5.9448738836, 110.2063212194],
                        [1.98e-08, 2.54989377864, 88.865680217],
                        [2.04e-08, 2.16463966964, 433.7117378768],
                        [1.955e-08, 2.70341589777, 721.6494195302],
                        [1.67e-08, 4.46255717328, 853.196381752],
                        [1.91e-08, 2.25964760758, 1361.5467058442],
                        [1.71e-08, 1.98372066321, 525.7588118315],
                        [1.52e-08, 0.11641358425, 949.1756089698],
                        [2.003e-08, 3.16520599208, 1148.2476104062],
                        [1.71e-08, 2.70850417287, 330.6189636582],
                        [1.629e-08, 0.47376028854, 526.5095713569],
                        [1.229e-08, 3.01987279595, 963.4027029714],
                        [1.671e-08, 0.44352103086, 533.6231183577],
                        [1.207e-08, 1.15774089269, 1574.8458012822],
                        [1.146e-08, 2.54505851138, 846.0828347512],
                        [1.355e-08, 1.17462112647, 1038.0412891868],
                        [1.001e-08, 2.70272799283, 519.3960243561],
                        [1.372e-08, 0.67467128629, 551.031606097],
                        [9.83e-09, 4.17198081351, 2627.1141844706],
                        [1.084e-08, 1.07011164067, 227.5261894396],
                        [8.92e-09, 2.92543286761, 1368.660252845],
                        [8.23e-09, 4.86559196955, 611.4430983108],
                        [1.136e-08, 1.78981738432, 1581.959348283],
                        [8.97e-09, 4.9107363027, 1670.8250285],
                        [9.08e-09, 3.6880404733, 824.7421937488],
                        [7.89e-09, 3.2338089325, 2125.8774073792],
                        [7.71e-09, 2.39070707004, 2317.8358618148],
                        [8.91e-09, 0.59692950778, 539.9859058331],
                        [8.76e-09, 4.52127091462, 750.1036075334],
                        [8.02e-09, 0.20759322884, 1141.1340634054],
                        [8.5e-09, 0.94145487094, 191.9584544356],
                        [7.62e-09, 2.25149516048, 2538.2485042536],
                        [6.94e-09, 0.67080348659, 440.8252848776],
                        [7.41e-09, 5.79934203525, 1485.9801210652],
                        [6.43e-09, 2.48127580335, 1265.5674786264],
                        [5.75e-09, 6.13756590872, 1279.794572628],
                        [6.36e-09, 5.51001645505, 2413.8150890326],
                        [6.36e-09, 4.40777238491, 1382.8873468466],
                        [5.55e-09, 2.18233983981, 1062.5633239269],
                        [5.64e-09, 1.92775967119, 2634.2277314714],
                        [5.31e-09, 2.04824376019, 295.0512286542],
                        [5.41e-09, 2.32424368689, 1471.7530270636],
                        [6.97e-09, 2.27179476322, 1699.2792165032],
                        [5.46e-09, 1.9577490573, 1677.9385755008],
                        [4.65e-09, 4.35550844067, 1692.1656695024],
                        [5.08e-09, 2.50298248836, 2207.6295405954],
                        [4.96e-09, 5.77087043616, 1478.8665740644],
                        [4.4e-09, 5.98661963879, 934.9485149682],
                        [4.24e-09, 2.80194129521, 81.7521332162],
                        [4.06e-09, 3.93940190897, 316.3918696566],
                        [5.06e-09, 0.18719982992, 10.2949407385],
                      ],
          },
          {
            series => "R4",
            terms  => [
                        [1.28628e-06, 0.08419309557, 536.8045120954],
                        [1.13458e-06, 4.24858855779, 529.6909650946],
                        [8.265e-07, 3.29754909408, 522.5774180938],
                        [3.7883e-07, 2.73326611144, 515.463871093],
                        [2.6694e-07, 5.69142588558, 7.1135470008],
                        [1.765e-07, 5.40012536918, 1059.3819301892],
                        [1.2612e-07, 6.01560416057, 543.9180590962],
                        [9.287e-08, 0.76813946494, 1066.49547719],
                        [8.107e-08, 5.68228065707, 14.2270940016],
                        [6.271e-08, 5.12286932534, 639.897286314],
                        [6.978e-08, 1.42751292055, 412.3710968744],
                        [5.377e-08, 3.33501947275, 625.6701923124],
                        [2.911e-08, 3.40334805052, 1052.2683831884],
                        [2.593e-08, 4.16090412984, 728.762966531],
                        [2.562e-08, 2.89802035072, 426.598190876],
                        [2.268e-08, 6.22195938856, 1589.0728952838],
                        [2.114e-08, 3.11758855774, 1045.1548361876],
                        [1.673e-08, 2.81399290364, 206.1855484372],
                        [1.805e-08, 2.60030006919, 199.0720014364],
                        [1.823e-08, 1.89432426038, 419.4846438752],
                        [1.522e-08, 1.33432648232, 1596.1864422846],
                        [1.697e-08, 0, 0],
                        [1.039e-08, 4.41904942302, 956.2891559706],
                        [1.161e-08, 5.16181311538, 831.8557407496],
                        [9.16e-09, 3.17245716108, 508.3503240922],
                        [8.7e-09, 5.793878135, 1169.5882514086],
                        [9.16e-09, 1.87129662931, 1148.2476104062],
                        [9.55e-09, 0.66801367802, 1361.5467058442],
                        [7.88e-09, 1.47515450553, 1272.6810256272],
                        [9.66e-09, 5.47457968043, 220.4126424388],
                        [7.88e-09, 2.42252866885, 117.3198682202],
                        [7.12e-09, 0.4965589703, 1073.6090241908],
                        [6.56e-09, 3.53022740783, 302.164775655],
                        [6.81e-09, 2.8450717434, 191.9584544356],
                        [7.71e-09, 2.19893222018, 942.062061969],
                        [7.65e-09, 5.311472577, 551.031606097],
                        [6.67e-09, 3.72432305249, 88.865680217],
                        [5.34e-09, 1.83172084748, 647.0108333148],
                        [5.53e-09, 0.85896003802, 330.6189636582],
                        [5.43e-09, 5.26057584439, 21.3406410024],
                        [5.84e-09, 3.82243061802, 618.5566453116],
                        [5.12e-09, 4.44485521707, 110.2063212194],
                        [6.12e-09, 1.59320941864, 3.1813937377],
                        [6.31e-09, 1.83863158533, 10.2949407385],
                        [4.91e-09, 1.52912023181, 405.2575498736],
                        [5.21e-09, 0.24011424451, 433.7117378768],
                      ],
          },
          {
            series => "R5",
            terms  => [
                        [1.1188e-07, 4.75249399945, 536.8045120954],
                        [4.255e-08, 5.9151622917, 522.5774180938],
                        [2.079e-08, 5.56781555864, 515.463871093],
                        [1.908e-08, 4.29659647286, 543.9180590962],
                        [1.875e-08, 3.69357495838, 7.1135470008],
                        [1.59e-08, 5.49312796166, 1066.49547719],
                        [1.612e-08, 4.13222808529, 1059.3819301892],
                        [1.24e-08, 3.77981722506, 14.2270940016],
                        [1.033e-08, 4.50671820436, 529.6909650946],
                      ],
          },
        ],
      ],
      name => "VSOP87D",
      order => 5,
      sidereal_period => 374335702.07,
      tropical_period => 374163474.102,
    }->{$key};
}

1;

__END__

=head1 NAME

Astro::Coord::ECI::VSOP87D::Jupiter - VSOP87D model of the position of Jupiter

=head1 SYNOPSIS

 use Astro::Coord::ECI::VSOP87D::Jupiter;
 use Astro::Coord::ECI::Utils qw{ deg2rad };
 use POSIX qw{ strftime };
 use Time::Local qw{ localtime };
 
 my $station = Astro::Coord::ECI->new(
     name => 'White House',
 )->geodetic(
     deg2rad( 38.899 ),  # radians
     deg2rad( -77.038 ), # radians
     16.68/1000,         # Kilometers
 );
 my $venus = Astro::Coord::ECI::VSOP87D::Jupiter->new(
     station => $station,
 );
 my $today = timelocal( 0, 0, 0, ( localtime )[ 3 .. 5 ] );
 foreach my $item ( $venus->almanac( $today, $today + 86400 ) ) {
     local $\ = "\n";
     print strftime( '%d-%b-%Y %H:%M:%S', localtime $item->[0] ),
         $item->[3];
 }

=head1 DESCRIPTION

This Perl class computes the position of Jupiter using the VSOP87D
model. It is a subclass of
L<Astro::Coord::ECI::VSOP87D::_Superior|Astro::Coord::ECI::VSOP87D::_Superior>.

=head1 METHODS

This class supports no additional public methods.

=head2 ATTRIBUTES

This class has no additional attributes.

=head1 SEE ALSO

L<Astro::Coord::ECI|Astro::Coord::ECI>

L<Astro::Coord::ECI::VSOP87D|Astro::Coord::ECI::VSOP87D>

=head1 SUPPORT

Support is by the author. Please file bug reports at
L<http://rt.cpan.org>, or in electronic mail to the author.

=head1 AUTHOR

Thomas R. Wyant, III F<wyant at cpan dot org>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2018-2019 by Thomas R. Wyant, III

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl 5.10.0. For more details, see the full text
of the licenses in the directory LICENSES.

This program is distributed in the hope that it will be useful, but
without any warranty; without even the implied warranty of
merchantability or fitness for a particular purpose.

=cut

# ex: set filetype=perl textwidth=72 :
