package Sah::SchemaR::simple_uint_seq;

our $DATE = '2021-07-16'; # DATE
our $VERSION = '0.002'; # VERSION

our $rschema = ["str",[{description=>"\nTODO: infinite sequence, e.g. '1,2,3,...'.\n\n",examples=>[{data=>"",valid=>0},{data=>"1-2",summary=>"A range m-n is not valid in simple integer sequence",valid=>0},{data=>"1,",summary=>"Dangling comma is currently not allowed",valid=>0},{data=>"1,,2",summary=>"Multiple commas are currently not allowed",valid=>0},{data=>1.2,summary=>"Float",valid=>0},{data=>1,valid=>1},{data=>"1,2",valid=>1},{data=>"1 , 2",valid=>1},{data=>"1 , 2,3",valid=>1},{data=>"1,2,-3,4",summary=>"Negative",valid=>0}],match=>qr(\A(?:[0-9]+)(?:\s*,\s*(?:[0-9]+))*\z),summary=>"Simple unsigned integer sequence, e.g. 1,3,12"}],["str"]];

1;
# ABSTRACT: Simple unsigned integer sequence, e.g. 1,3,12

__END__

=pod

=encoding UTF-8

=head1 NAME

Sah::SchemaR::simple_uint_seq - Simple unsigned integer sequence, e.g. 1,3,12

=head1 VERSION

This document describes version 0.002 of Sah::SchemaR::simple_uint_seq (from Perl distribution Sah-Schemas-IntRange), released on 2021-07-16.

=head1 DESCRIPTION

This module is automatically generated by Dist::Zilla::Plugin::Sah::Schemas during distribution build.

A Sah::SchemaR::* module is useful if a client wants to quickly lookup the base type of a schema without having to do any extra resolving. With Sah::Schema::*, one might need to do several lookups if a schema is based on another schema, and so on. Compare for example L<Sah::Schema::poseven> vs L<Sah::SchemaR::poseven>, where in Sah::SchemaR::poseven one can immediately get that the base type is C<int>. Currently L<Perinci::Sub::Complete> uses Sah::SchemaR::* instead of Sah::Schema::* for reduced startup overhead when doing tab completion.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Sah-Schemas-IntRange>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Sah-Schemas-IntRange>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Sah-Schemas-IntRange>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2021 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
