## no critic qw(RequirePodSections)    # -*- cperl -*-
# This file is auto-generated by the Perl TeX::Hyphen::Pattern Suite hyphen
# pattern catalog generator. This code generator comes with the
# TeX::Hyphen::Pattern module distribution in the tools/ directory
#
# Do not edit this file directly.

package TeX::Hyphen::Pattern::Be v1.1.6;
use strict;
use warnings;
use 5.014000;
use utf8;

use Moose;

my $pattern_file = q{};
while (<DATA>) {
    $pattern_file .= $_;
}

sub pattern_data {
    return $pattern_file;
}

sub version {
    return $TeX::Hyphen::Pattern::Be::VERSION;
}

1;
## no critic qw(RequirePodAtEnd RequireASCII ProhibitFlagComments)

=encoding utf8

=for stopwords CTAN Ipenburg Be

=head1 NAME

TeX::Hyphen::Pattern::Be - class for hyphenation in locale Be

=head1 SUBROUTINES/METHODS

=over 4

=item $pattern-E<gt>pattern_data();

Returns the pattern data.

=item $pattern-E<gt>version();

Returns the version of the pattern package.

=back

=head1 COPYRIGHT

=begin text

title: Hyphenation patterns for Belarusian
copyright: Copyright (C) 2016 Maksim Salau
notice: This file is part of the hyph-utf8 package.
    See http://www.hyphenation.org/tex for more information.
source: https://github.com/hyphenation/hyph-be
language:
    name: Belarusian
    tag: be
version: 1.01 (October 2016)
authors:
  -
    name: Maksim Salau
    contact: maksim.salau (at) gmail.com
hyphenmins:
    typesetting:
        left: 2
        right: 2
licence:
    name: MIT
    url: https://opensource.org/licenses/MIT
    text: >
            Permission is hereby granted, free of charge, to any person
            obtaining a copy of this software and associated documentation
            files (the "Software"), to deal in the Software without
            restriction, including without limitation the rights to use,
            copy, modify, merge, publish, distribute, sublicense, and/or sell
            copies of the Software, and to permit persons to whom the
            Software is furnished to do so, subject to the following
            conditions:

            The above copyright notice and this permission notice shall be
            included in all copies or substantial portions of the Software.

            THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
            EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
            OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
            NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
            HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
            WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
            FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
            OTHER DEALINGS IN THE SOFTWARE.
changes:
    - Version 1.01 <2016/10/03> Added YAML header
    - Version 1.00 <2016/09/29> Initial version
texlive:
    encoding: t2a
    babelname: belarusian
    message: Belarusian hyphenation patterns
    description:
        Belarusian hyphenation patterns in T2A and UTF-8 encodings
==========================================

Many thanks to Aleś Bułojčyk <alex73mail@gmail.com> and
Sviatlana Liasovich <xelj.gjkz@bk.ru> for their work on
Belarusian hyphenation dictionary for OpenOffice.
http://extensions.services.openoffice.org/en/project/dict-be-official

Створана адпаведна правілаў, зацверджаных законам
ад 23 лiпеня 2008 г. No 420-З
Аб Правiлах беларускай арфаграфii i пунктуацыi
http://academy.edu.by/files/zak_420-3.pdf

РАЗДЗЕЛ I. АРФАГРАФIЯ
ГЛАВА 8 ПРАВIЛЫ ПЕРАНОСУ
§ 41. Правiлы пераносу простых, складаных, складанаскарочаных слоў,
      умоўных графiчных скарачэнняў i iншых знакаў

Based on rules approved by the law No 420-3 dated 23 July 2008
About Belarusian orthography and punctuation

=end text

=cut

__DATA__
\patterns{
%
% Калі ў слове ёсць злучок, перанос магчымы пасля злучка,
% а кожная частка пераносіцца нібыта з'яўляецца асобным словам.
%
% A word that has a dash can hyphenated after the dash,
% both parts of the word are hyphenated as if they are separate words.
%
8-1
%
% З аднаго радка на другi слова пераносiцца па складах.
% Words are hyphenated by syllables.
%
% во-ля, тра-ва, за-яц, га-ла-ва, ка-ва-лак,
% стра-ка-ты, пра-ве-рыць, пе-ра-кi-нуць.
%
а1
е1
ё1
і1
о1
у1
ы1
э1
ю1
я1
%
%   2. Калi ў сярэдзiне слова памiж галоснымi маецца спалучэнне зычных, то
% пераносiцца на наступны радок або ўсё гэта спалучэнне, або любая яго частка.
% If there are several consonants between vowels, all of them may be hyphenated
% or any part of it as well.
%
% ся-стра, сяс-тра, сяст-ра
% во-стры, вос-тры, вост-ры
% пту-шка, птуш-ка
% кро-пля, кроп-ля
% ма-ста-цтва, мас-тац-тва, мас-тацт-ва;
% ра-змова, раз-мова
% за-става, зас-тава
% ра-скрыць, рас-крыць, раск-рыць
% бя-скрыўдна, бяс-крыўдна, бяск-рыўдна
% дзя-цi-нства, дзя-цiн-ства, дзя-цiнс-тва, дзя-цiнст-ва
% двац-цаць, два-ццаць
% калос-се, кало-ссе
% сол-лю, со-ллю
% памяц-цю, памя-ццю
% мыц-ца, мы-цца
% паа-бапал, па-абапал
% насен-не, насе-нне
%
б5б
б3в
б3г
б3ґ
б3д
б3ж
б3з
б3к
б3л
б3м
б3н
б3п
б3р
б3с
б3т
б3ф
б3х
б3ц
б3ч
б3ш
в3б
в5в
в3г
в3ґ
в3д
в3ж
в3з
в3к
в3л
в3м
в3н
в3п
в3р
в3с
в3т
в3ф
в3х
в3ц
в3ч
в3ш
г3б
г3в
г5г
г3ґ
г3д
г3ж
г3з
г3к
г3л
г3м
г3н
г3п
г3р
г3с
г3т
г3ф
г3х
г3ц
г3ч
г3ш
ґ3б
ґ3в
ґ3г
ґ5ґ
ґ3д
ґ3ж
ґ3з
ґ3к
ґ3л
ґ3м
ґ3н
ґ3п
ґ3р
ґ3с
ґ3т
ґ3ф
ґ3х
ґ3ц
ґ3ч
ґ3ш
д3б
д3в
д3г
д3ґ
д5д
% дж % special case
% дз % special case
д3к
д3л
д3м
д3н
д3п
д3р
д3с
д3т
д3ф
д3х
д3ц
д3ч
д3ш
ж3б
ж3в
ж3г
ж3ґ
ж3д
ж5ж
ж3з
ж3к
ж3л
ж3м
ж3н
ж3п
ж3р
ж3с
ж3т
ж3ф
ж3х
ж3ц
ж3ч
ж3ш
з3б
з3в
з3г
з3ґ
з3д
з3ж
з5з
з3к
з3л
з3м
з3н
з3п
з3р
з3с
з3т
з3ф
з3х
з3ц
з3ч
з3ш
к3б
к3в
к3г
к3ґ
к3д
к3ж
к3з
к5к
к3л
к3м
к3н
к3п
к3р
к3с
к3т
к3ф
к3х
к3ц
к3ч
к3ш
л3б
л3в
л3г
л3ґ
л3д
л3ж
л3з
л3к
л5л
л3м
л3н
л3п
л3р
л3с
л3т
л3ф
л3х
л3ц
л3ч
л3ш
м3б
м3в
м3г
м3ґ
м3д
м3ж
м3з
м3к
м3л
м5м
м3н
м3п
м3р
м3с
м3т
м3ф
м3х
м3ц
м3ч
м3ш
н3б
н3в
н3г
н3ґ
н3д
н3ж
н3з
н3к
н3л
н3м
н5н
н3п
н3р
н3с
н3т
н3ф
н3х
н3ц
н3ч
н3ш
п3б
п3в
п3г
п3ґ
п3д
п3ж
п3з
п3к
п3л
п3м
п3н
п5п
п3р
п3с
п3т
п3ф
п3х
п3ц
п3ч
п3ш
р3б
р3в
р3г
р3ґ
р3д
р3ж
р3з
р3к
р3л
р3м
р3н
р3п
р5р
р3с
р3т
р3ф
р3х
р3ц
р3ч
р3ш
с3б
с3в
с3г
с3ґ
с3д
с3ж
с3з
с3к
с3л
с3м
с3н
с3п
с3р
с5с
с3т
с3ф
с3х
с3ц
с3ч
с3ш
т3б
т3в
т3г
т3ґ
т3д
т3ж
т3з
т3к
т3л
т3м
т3н
т3п
т3р
т3с
т5т
т3ф
т3х
т3ц
т3ч
т3ш
ф3б
ф3в
ф3г
ф3ґ
ф3д
ф3ж
ф3з
ф3к
ф3л
ф3м
ф3н
ф3п
ф3р
ф3с
ф3т
ф5ф
ф3х
ф3ц
ф3ч
ф3ш
х3б
х3в
х3г
х3ґ
х3д
х3ж
х3з
х3к
х3л
х3м
х3н
х3п
х3р
х3с
х3т
х3ф
х5х
х3ц
х3ч
х3ш
ц3б
ц3в
ц3г
ц3ґ
ц3д
ц3ж
ц3з
ц3к
ц3л
ц3м
ц3н
ц3п
ц3р
ц3с
ц3т
ц3ф
ц3х
ц5ц
ц3ч
ц3ш
ч3б
ч3в
ч3г
ч3ґ
ч3д
ч3ж
ч3з
ч3к
ч3л
ч3м
ч3н
ч3п
ч3р
ч3с
ч3т
ч3ф
ч3х
ч3ц
ч5ч
ч3ш
ш3б
ш3в
ш3г
ш3ґ
ш3д
ш3ж
ш3з
ш3к
ш3л
ш3м
ш3н
ш3п
ш3р
ш3с
ш3т
ш3ф
ш3х
ш3ц
ш3ч
ш5ш
%
% Пры пераносе нельга пакiдаць або пераносiць на наступны радок адну лiтару,
% нават калi яна адпавядае складу.
% A single letter can't be left of hyphenated, even if it forms a syllable.
%
% аса-ка, лi-нiя, ра-дыё, еха-лi, па-коi
%
.а8 8а. -а8 8а-
.е8 8е. -е8 8е-
.ё8 8ё. -ё8 8ё-
.і8 8і. -і8 8і-
.о8 8о. -о8 8о-
.у8 8у. -у8 8у-
.ы8 8ы. -ы8 8ы-
.э8 8э. -э8 8э-
.ю8 8ю. -ю8 8ю-
.я8 8я. -я8 8я-
%
% Пры пераносе нельга разбiваць пераносам спалучэннi лiтар дж i дз,
% калi яны абазначаюць адзiн гук [дж], [дз’]:
% Combinations дж and дз shouldn't be split if they form a single sound.
%
% ура-джай, са-джаць, ра-дзi-ма, ха-дзiць
%
д2ж
д2з
% Пры пераносе нельга аддзяляць ад папярэдняй галоснай лiтары й i ў.
% й and ў should not be separated from a preceding vowel.
%
% сой-ка, бой-кi, май-стар, дай-сцi, зай-мацца, праў-да, слоў-нiк, маў-чаць,
% заў-тра, праў-нук
%
% ** й ды ў ужываюцца выключна пасля галосных,
% таму можна забарону пераносу зрабіть агульнай для усіх літар.
% ** since й and ў can appear only after a vowel
% we can use a more general rule.
%
6й1
6ў1
% Пры пераносе нельга  аддзяляць мяккi знак i апостраф ад папярэдняй зычнай.
% ь and ' should not be separated from a preceding consonant.
%
% буль-ба, прось-ба, вазь-му, бур’-ян, сем’-яў, мыш’-як
%
% ** Зычная з мяккім знакам ці апострафам з'яўляюцца часткай папярэдняга складу.
% ** A consonant and following ь or ' are part of a previous syllable.
%
6б'1
6в'1
6г'1
6ґ'1
6д'1
6ж'1
6з'1
6к'1
6л'1
6м'1
6н'1
6п'1
6р'1
6с'1
6т'1
6ф'1
6х'1
6ц'1
6ч'1
6ш'1
6бь1
6вь1
6гь1
6ґь1
% дь % impossible
% жь % impossible
6зь1
6кь1
6ль1
6мь1
6нь1
6пь1
% рь % impossible
6сь1
% ть % impossible
6фь1
6хь1
6ць1
% чь % impossible
% шь % impossible
%
% Зычныя літары не утвараюць склад, таму не пераносяцца,
% калі стаяць у пачатку ці канцы слова.
% Since consonants do not form syllables, it is not allowed to separate
% consonants in the beginning or ending of a word.
%
.б8 8б. -б8 8б-
.в8 8в. -в8 8в-
.г8 8г. -г8 8г-
.ґ8 8ґ. -ґ8 8ґ-
.д8 8д. -д8 8д-
.ж8 8ж. -ж8 8ж-
.з8 8з. -з8 8з-
.к8 8к. -к8 8к-
.л8 8л. -л8 8л-
.м8 8м. -м8 8м-
.н8 8н. -н8 8н-
.п8 8п. -п8 8п-
.р8 8р. -р8 8р-
.с8 8с. -с8 8с-
.т8 8т. -т8 8т-
.ф8 8ф. -ф8 8ф-
.х8 8х. -х8 8х-
.ц8 8ц. -ц8 8ц-
.ч8 8ч. -ч8 8ч-
.ш8 8ш. -ш8 8ш-
.й8 8й. -й8 8й-
.ў8 8ў. -ў8 8ў-
.бб8 8бб. -бб8 8бб-
.бв8 8бв. -бв8 8бв-
.бг8 8бг. -бг8 8бг-
.бґ8 8бґ. -бґ8 8бґ-
.бд8 8бд. -бд8 8бд-
.бж8 8бж. -бж8 8бж-
.бз8 8бз. -бз8 8бз-
.бк8 8бк. -бк8 8бк-
.бл8 8бл. -бл8 8бл-
.бм8 8бм. -бм8 8бм-
.бн8 8бн. -бн8 8бн-
.бп8 8бп. -бп8 8бп-
.бр8 8бр. -бр8 8бр-
.бс8 8бс. -бс8 8бс-
.бт8 8бт. -бт8 8бт-
.бф8 8бф. -бф8 8бф-
.бх8 8бх. -бх8 8бх-
.бц8 8бц. -бц8 8бц-
.бч8 8бч. -бч8 8бч-
.бш8 8бш. -бш8 8бш-
.бь8 8бь. -бь8 8бь-
.б'8 -б'8
.вб8 8вб. -вб8 8вб-
.вв8 8вв. -вв8 8вв-
.вг8 8вг. -вг8 8вг-
.вґ8 8вґ. -вґ8 8вґ-
.вд8 8вд. -вд8 8вд-
.вж8 8вж. -вж8 8вж-
.вз8 8вз. -вз8 8вз-
.вк8 8вк. -вк8 8вк-
.вл8 8вл. -вл8 8вл-
.вм8 8вм. -вм8 8вм-
.вн8 8вн. -вн8 8вн-
.вп8 8вп. -вп8 8вп-
.вр8 8вр. -вр8 8вр-
.вс8 8вс. -вс8 8вс-
.вт8 8вт. -вт8 8вт-
.вф8 8вф. -вф8 8вф-
.вх8 8вх. -вх8 8вх-
.вц8 8вц. -вц8 8вц-
.вч8 8вч. -вч8 8вч-
.вш8 8вш. -вш8 8вш-
.вь8 8вь. -вь8 8вь-
.в'8 -в'8
.гб8 8гб. -гб8 8гб-
.гв8 8гв. -гв8 8гв-
.гг8 8гг. -гг8 8гг-
.гґ8 8гґ. -гґ8 8гґ-
.гд8 8гд. -гд8 8гд-
.гж8 8гж. -гж8 8гж-
.гз8 8гз. -гз8 8гз-
.гк8 8гк. -гк8 8гк-
.гл8 8гл. -гл8 8гл-
.гм8 8гм. -гм8 8гм-
.гн8 8гн. -гн8 8гн-
.гп8 8гп. -гп8 8гп-
.гр8 8гр. -гр8 8гр-
.гс8 8гс. -гс8 8гс-
.гт8 8гт. -гт8 8гт-
.гф8 8гф. -гф8 8гф-
.гх8 8гх. -гх8 8гх-
.гц8 8гц. -гц8 8гц-
.гч8 8гч. -гч8 8гч-
.гш8 8гш. -гш8 8гш-
.гь8 8гь. -гь8 8гь-
.г'8 -г'8
.ґб8 8ґб. -ґб8 8ґб-
.ґв8 8ґв. -ґв8 8ґв-
.ґг8 8ґг. -ґг8 8ґг-
.ґґ8 8ґґ. -ґґ8 8ґґ-
.ґд8 8ґд. -ґд8 8ґд-
.ґж8 8ґж. -ґж8 8ґж-
.ґз8 8ґз. -ґз8 8ґз-
.ґк8 8ґк. -ґк8 8ґк-
.ґл8 8ґл. -ґл8 8ґл-
.ґм8 8ґм. -ґм8 8ґм-
.ґн8 8ґн. -ґн8 8ґн-
.ґп8 8ґп. -ґп8 8ґп-
.ґр8 8ґр. -ґр8 8ґр-
.ґс8 8ґс. -ґс8 8ґс-
.ґт8 8ґт. -ґт8 8ґт-
.ґф8 8ґф. -ґф8 8ґф-
.ґх8 8ґх. -ґх8 8ґх-
.ґц8 8ґц. -ґц8 8ґц-
.ґч8 8ґч. -ґч8 8ґч-
.ґш8 8ґш. -ґш8 8ґш-
.ґь8 8ґь. -ґь8 8ґь-
.ґ'8 -ґ'8
.дб8 8дб. -дб8 8дб-
.дв8 8дв. -дв8 8дв-
.дг8 8дг. -дг8 8дг-
.дґ8 8дґ. -дґ8 8дґ-
.дд8 8дд. -дд8 8дд-
.дж8 8дж. -дж8 8дж-
.дз8 8дз. -дз8 8дз-
.дк8 8дк. -дк8 8дк-
.дл8 8дл. -дл8 8дл-
.дм8 8дм. -дм8 8дм-
.дн8 8дн. -дн8 8дн-
.дп8 8дп. -дп8 8дп-
.др8 8др. -др8 8др-
.дс8 8дс. -дс8 8дс-
.дт8 8дт. -дт8 8дт-
.дф8 8дф. -дф8 8дф-
.дх8 8дх. -дх8 8дх-
.дц8 8дц. -дц8 8дц-
.дч8 8дч. -дч8 8дч-
.дш8 8дш. -дш8 8дш-
% дь
.д'8 -д'8
.жб8 8жб. -жб8 8жб-
.жв8 8жв. -жв8 8жв-
.жг8 8жг. -жг8 8жг-
.жґ8 8жґ. -жґ8 8жґ-
.жд8 8жд. -жд8 8жд-
.жж8 8жж. -жж8 8жж-
.жз8 8жз. -жз8 8жз-
.жк8 8жк. -жк8 8жк-
.жл8 8жл. -жл8 8жл-
.жм8 8жм. -жм8 8жм-
.жн8 8жн. -жн8 8жн-
.жп8 8жп. -жп8 8жп-
.жр8 8жр. -жр8 8жр-
.жс8 8жс. -жс8 8жс-
.жт8 8жт. -жт8 8жт-
.жф8 8жф. -жф8 8жф-
.жх8 8жх. -жх8 8жх-
.жц8 8жц. -жц8 8жц-
.жч8 8жч. -жч8 8жч-
.жш8 8жш. -жш8 8жш-
% жь
.ж'8 -ж'8
.зб8 8зб. -зб8 8зб-
.зв8 8зв. -зв8 8зв-
.зг8 8зг. -зг8 8зг-
.зґ8 8зґ. -зґ8 8зґ-
.зд8 8зд. -зд8 8зд-
.зж8 8зж. -зж8 8зж-
.зз8 8зз. -зз8 8зз-
.зк8 8зк. -зк8 8зк-
.зл8 8зл. -зл8 8зл-
.зм8 8зм. -зм8 8зм-
.зн8 8зн. -зн8 8зн-
.зп8 8зп. -зп8 8зп-
.зр8 8зр. -зр8 8зр-
.зс8 8зс. -зс8 8зс-
.зт8 8зт. -зт8 8зт-
.зф8 8зф. -зф8 8зф-
.зх8 8зх. -зх8 8зх-
.зц8 8зц. -зц8 8зц-
.зч8 8зч. -зч8 8зч-
.зш8 8зш. -зш8 8зш-
.зь8 8зь. -зь8 8зь-
.з'8 -з'8
.кб8 8кб. -кб8 8кб-
.кв8 8кв. -кв8 8кв-
.кг8 8кг. -кг8 8кг-
.кґ8 8кґ. -кґ8 8кґ-
.кд8 8кд. -кд8 8кд-
.кж8 8кж. -кж8 8кж-
.кз8 8кз. -кз8 8кз-
.кк8 8кк. -кк8 8кк-
.кл8 8кл. -кл8 8кл-
.км8 8км. -км8 8км-
.кн8 8кн. -кн8 8кн-
.кп8 8кп. -кп8 8кп-
.кр8 8кр. -кр8 8кр-
.кс8 8кс. -кс8 8кс-
.кт8 8кт. -кт8 8кт-
.кф8 8кф. -кф8 8кф-
.кх8 8кх. -кх8 8кх-
.кц8 8кц. -кц8 8кц-
.кч8 8кч. -кч8 8кч-
.кш8 8кш. -кш8 8кш-
.кь8 8кь. -кь8 8кь-
.к'8 -к'8
.лб8 8лб. -лб8 8лб-
.лв8 8лв. -лв8 8лв-
.лг8 8лг. -лг8 8лг-
.лґ8 8лґ. -лґ8 8лґ-
.лд8 8лд. -лд8 8лд-
.лж8 8лж. -лж8 8лж-
.лз8 8лз. -лз8 8лз-
.лк8 8лк. -лк8 8лк-
.лл8 8лл. -лл8 8лл-
.лм8 8лм. -лм8 8лм-
.лн8 8лн. -лн8 8лн-
.лп8 8лп. -лп8 8лп-
.лр8 8лр. -лр8 8лр-
.лс8 8лс. -лс8 8лс-
.лт8 8лт. -лт8 8лт-
.лф8 8лф. -лф8 8лф-
.лх8 8лх. -лх8 8лх-
.лц8 8лц. -лц8 8лц-
.лч8 8лч. -лч8 8лч-
.лш8 8лш. -лш8 8лш-
.ль8 8ль. -ль8 8ль-
.л'8 -л'8
.мб8 8мб. -мб8 8мб-
.мв8 8мв. -мв8 8мв-
.мг8 8мг. -мг8 8мг-
.мґ8 8мґ. -мґ8 8мґ-
.мд8 8мд. -мд8 8мд-
.мж8 8мж. -мж8 8мж-
.мз8 8мз. -мз8 8мз-
.мк8 8мк. -мк8 8мк-
.мл8 8мл. -мл8 8мл-
.мм8 8мм. -мм8 8мм-
.мн8 8мн. -мн8 8мн-
.мп8 8мп. -мп8 8мп-
.мр8 8мр. -мр8 8мр-
.мс8 8мс. -мс8 8мс-
.мт8 8мт. -мт8 8мт-
.мф8 8мф. -мф8 8мф-
.мх8 8мх. -мх8 8мх-
.мц8 8мц. -мц8 8мц-
.мч8 8мч. -мч8 8мч-
.мш8 8мш. -мш8 8мш-
.мь8 8мь. -мь8 8мь-
.м'8 -м'8
.нб8 8нб. -нб8 8нб-
.нв8 8нв. -нв8 8нв-
.нг8 8нг. -нг8 8нг-
.нґ8 8нґ. -нґ8 8нґ-
.нд8 8нд. -нд8 8нд-
.нж8 8нж. -нж8 8нж-
.нз8 8нз. -нз8 8нз-
.нк8 8нк. -нк8 8нк-
.нл8 8нл. -нл8 8нл-
.нм8 8нм. -нм8 8нм-
.нн8 8нн. -нн8 8нн-
.нп8 8нп. -нп8 8нп-
.нр8 8нр. -нр8 8нр-
.нс8 8нс. -нс8 8нс-
.нт8 8нт. -нт8 8нт-
.нф8 8нф. -нф8 8нф-
.нх8 8нх. -нх8 8нх-
.нц8 8нц. -нц8 8нц-
.нч8 8нч. -нч8 8нч-
.нш8 8нш. -нш8 8нш-
.нь8 8нь. -нь8 8нь-
.н'8 -н'8
.пб8 8пб. -пб8 8пб-
.пв8 8пв. -пв8 8пв-
.пг8 8пг. -пг8 8пг-
.пґ8 8пґ. -пґ8 8пґ-
.пд8 8пд. -пд8 8пд-
.пж8 8пж. -пж8 8пж-
.пз8 8пз. -пз8 8пз-
.пк8 8пк. -пк8 8пк-
.пл8 8пл. -пл8 8пл-
.пм8 8пм. -пм8 8пм-
.пн8 8пн. -пн8 8пн-
.пп8 8пп. -пп8 8пп-
.пр8 8пр. -пр8 8пр-
.пс8 8пс. -пс8 8пс-
.пт8 8пт. -пт8 8пт-
.пф8 8пф. -пф8 8пф-
.пх8 8пх. -пх8 8пх-
.пц8 8пц. -пц8 8пц-
.пч8 8пч. -пч8 8пч-
.пш8 8пш. -пш8 8пш-
.пь8 8пь. -пь8 8пь-
.п'8 -п'8
.рб8 8рб. -рб8 8рб-
.рв8 8рв. -рв8 8рв-
.рг8 8рг. -рг8 8рг-
.рґ8 8рґ. -рґ8 8рґ-
.рд8 8рд. -рд8 8рд-
.рж8 8рж. -рж8 8рж-
.рз8 8рз. -рз8 8рз-
.рк8 8рк. -рк8 8рк-
.рл8 8рл. -рл8 8рл-
.рм8 8рм. -рм8 8рм-
.рн8 8рн. -рн8 8рн-
.рп8 8рп. -рп8 8рп-
.рр8 8рр. -рр8 8рр-
.рс8 8рс. -рс8 8рс-
.рт8 8рт. -рт8 8рт-
.рф8 8рф. -рф8 8рф-
.рх8 8рх. -рх8 8рх-
.рц8 8рц. -рц8 8рц-
.рч8 8рч. -рч8 8рч-
.рш8 8рш. -рш8 8рш-
% рь
.р'8 -р'8
.сб8 8сб. -сб8 8сб-
.св8 8св. -св8 8св-
.сг8 8сг. -сг8 8сг-
.сґ8 8сґ. -сґ8 8сґ-
.сд8 8сд. -сд8 8сд-
.сж8 8сж. -сж8 8сж-
.сз8 8сз. -сз8 8сз-
.ск8 8ск. -ск8 8ск-
.сл8 8сл. -сл8 8сл-
.см8 8см. -см8 8см-
.сн8 8сн. -сн8 8сн-
.сп8 8сп. -сп8 8сп-
.ср8 8ср. -ср8 8ср-
.сс8 8сс. -сс8 8сс-
.ст8 8ст. -ст8 8ст-
.сф8 8сф. -сф8 8сф-
.сх8 8сх. -сх8 8сх-
.сц8 8сц. -сц8 8сц-
.сч8 8сч. -сч8 8сч-
.сш8 8сш. -сш8 8сш-
.сь8 8сь. -сь8 8сь-
.с'8 -с'8
.тб8 8тб. -тб8 8тб-
.тв8 8тв. -тв8 8тв-
.тг8 8тг. -тг8 8тг-
.тґ8 8тґ. -тґ8 8тґ-
.тд8 8тд. -тд8 8тд-
.тж8 8тж. -тж8 8тж-
.тз8 8тз. -тз8 8тз-
.тк8 8тк. -тк8 8тк-
.тл8 8тл. -тл8 8тл-
.тм8 8тм. -тм8 8тм-
.тн8 8тн. -тн8 8тн-
.тп8 8тп. -тп8 8тп-
.тр8 8тр. -тр8 8тр-
.тс8 8тс. -тс8 8тс-
.тт8 8тт. -тт8 8тт-
.тф8 8тф. -тф8 8тф-
.тх8 8тх. -тх8 8тх-
.тц8 8тц. -тц8 8тц-
.тч8 8тч. -тч8 8тч-
.тш8 8тш. -тш8 8тш-
% ть
.т'8 -т'8
.фб8 8фб. -фб8 8фб-
.фв8 8фв. -фв8 8фв-
.фг8 8фг. -фг8 8фг-
.фґ8 8фґ. -фґ8 8фґ-
.фд8 8фд. -фд8 8фд-
.фж8 8фж. -фж8 8фж-
.фз8 8фз. -фз8 8фз-
.фк8 8фк. -фк8 8фк-
.фл8 8фл. -фл8 8фл-
.фм8 8фм. -фм8 8фм-
.фн8 8фн. -фн8 8фн-
.фп8 8фп. -фп8 8фп-
.фр8 8фр. -фр8 8фр-
.фс8 8фс. -фс8 8фс-
.фт8 8фт. -фт8 8фт-
.фф8 8фф. -фф8 8фф-
.фх8 8фх. -фх8 8фх-
.фц8 8фц. -фц8 8фц-
.фч8 8фч. -фч8 8фч-
.фш8 8фш. -фш8 8фш-
.фь8 8фь. -фь8 8фь-
.ф'8 -ф'8
.хб8 8хб. -хб8 8хб-
.хв8 8хв. -хв8 8хв-
.хг8 8хг. -хг8 8хг-
.хґ8 8хґ. -хґ8 8хґ-
.хд8 8хд. -хд8 8хд-
.хж8 8хж. -хж8 8хж-
.хз8 8хз. -хз8 8хз-
.хк8 8хк. -хк8 8хк-
.хл8 8хл. -хл8 8хл-
.хм8 8хм. -хм8 8хм-
.хн8 8хн. -хн8 8хн-
.хп8 8хп. -хп8 8хп-
.хр8 8хр. -хр8 8хр-
.хс8 8хс. -хс8 8хс-
.хт8 8хт. -хт8 8хт-
.хф8 8хф. -хф8 8хф-
.хх8 8хх. -хх8 8хх-
.хц8 8хц. -хц8 8хц-
.хч8 8хч. -хч8 8хч-
.хш8 8хш. -хш8 8хш-
.хь8 8хь. -хь8 8хь-
.х'8 -х'8
.цб8 8цб. -цб8 8цб-
.цв8 8цв. -цв8 8цв-
.цг8 8цг. -цг8 8цг-
.цґ8 8цґ. -цґ8 8цґ-
.цд8 8цд. -цд8 8цд-
.цж8 8цж. -цж8 8цж-
.цз8 8цз. -цз8 8цз-
.цк8 8цк. -цк8 8цк-
.цл8 8цл. -цл8 8цл-
.цм8 8цм. -цм8 8цм-
.цн8 8цн. -цн8 8цн-
.цп8 8цп. -цп8 8цп-
.цр8 8цр. -цр8 8цр-
.цс8 8цс. -цс8 8цс-
.цт8 8цт. -цт8 8цт-
.цф8 8цф. -цф8 8цф-
.цх8 8цх. -цх8 8цх-
.цц8 8цц. -цц8 8цц-
.цч8 8цч. -цч8 8цч-
.цш8 8цш. -цш8 8цш-
.ць8 8ць. -ць8 8ць-
.ц'8 -ц'8
.чб8 8чб. -чб8 8чб-
.чв8 8чв. -чв8 8чв-
.чг8 8чг. -чг8 8чг-
.чґ8 8чґ. -чґ8 8чґ-
.чд8 8чд. -чд8 8чд-
.чж8 8чж. -чж8 8чж-
.чз8 8чз. -чз8 8чз-
.чк8 8чк. -чк8 8чк-
.чл8 8чл. -чл8 8чл-
.чм8 8чм. -чм8 8чм-
.чн8 8чн. -чн8 8чн-
.чп8 8чп. -чп8 8чп-
.чр8 8чр. -чр8 8чр-
.чс8 8чс. -чс8 8чс-
.чт8 8чт. -чт8 8чт-
.чф8 8чф. -чф8 8чф-
.чх8 8чх. -чх8 8чх-
.чц8 8чц. -чц8 8чц-
.чч8 8чч. -чч8 8чч-
.чш8 8чш. -чш8 8чш-
% чь
.ч'8 -ч'8
.шб8 8шб. -шб8 8шб-
.шв8 8шв. -шв8 8шв-
.шг8 8шг. -шг8 8шг-
.шґ8 8шґ. -шґ8 8шґ-
.шд8 8шд. -шд8 8шд-
.шж8 8шж. -шж8 8шж-
.шз8 8шз. -шз8 8шз-
.шк8 8шк. -шк8 8шк-
.шл8 8шл. -шл8 8шл-
.шм8 8шм. -шм8 8шм-
.шн8 8шн. -шн8 8шн-
.шп8 8шп. -шп8 8шп-
.шр8 8шр. -шр8 8шр-
.шс8 8шс. -шс8 8шс-
.шт8 8шт. -шт8 8шт-
.шф8 8шф. -шф8 8шф-
.шх8 8шх. -шх8 8шх-
.шц8 8шц. -шц8 8шц-
.шч8 8шч. -шч8 8шч-
.шш8 8шш. -шш8 8шш-
% шь
.ш'8 -ш'8
%
% Часткі слоў якія нельга пераносіць бо яны не з'яўляюцца складам.
% Спіс атрыман праверкай слоўніку hunspell праграммай 3-letter-rules.py
%
% Parts of a word that can't be hyphenated since they don't form a syllable.
% The list is generated by 3-letter-rules.py from the hunspell dictionary.
%
8сць. 8сць-
8дзь. 8дзь-
8нкт. 8нкт-
8ндр. 8ндр-
8стр. 8стр-
8бль. 8бль-
8кль. 8кль-
8нск. 8нск-
8рць. 8рць-
8ршч. 8ршч-
8мль. 8мль-
8нгр. 8нгр-
8рст. 8рст-
8бск. 8бск-
8рдж. 8рдж-
8ждж. 8ждж-
8ркт. 8ркт-
8рзь. 8рзь-
8рск. 8рск-
8кст. 8кст-
8нтр. 8нтр-
8стл. 8стл-
8ндз. 8ндз-
8нгв. 8нгв-
8ркс. 8ркс-
8сль. 8сль-
8снь. 8снь-
8ртр. 8ртр-
8ктр. 8ктр-
.сп'8 -сп'8
8нкс. 8нкс-
8мбр. 8мбр-
8фць. 8фць-
8лмс. 8лмс-
8мсь. 8мсь-
8рнь. 8рнь-
8рль. 8рль-
%
% Стылістычна лепш не аддзяляць прыстаўку не- ад слова. Інакш, гэта можа
% паўплываць на разуменне тексту.
%
% It is better not to separate prefix не- from a word.
% Alternatively this can affect understanding.
%
.не8 -не8
.ня8 -ня8
%
% Перанос пасля некаторых прыставак толькі для слоў пачынаючыхся з зычных.
% Калі пасля ідзе галосная, вельмі верагодна што гэта не прыстаўка,
% а частка кораня.
%
% Hyphenation after several prefixes only for following consonants.
% If following letter is a vowel, it's very likely that the prefix
% is actually a part of the root.
%
% ад-
.ад3б6 -ад3б6
.ад3в6 -ад3в6
.ад3г6 -ад3г6
.ад3ґ6 -ад3ґ6
.ад3д6 -ад3д6
% .адж
% .адз
.ад3к6 -ад3к6
.ад3л6 -ад3л6
.ад3м6 -ад3м6
.ад3н6 -ад3н6
.ад3п6 -ад3п6
.ад3р6 -ад3р6
.ад3с6 -ад3с6
.ад3т6 -ад3т6
.ад3ф6 -ад3ф6
.ад3х6 -ад3х6
.ад3ц6 -ад3ц6
.ад3ч6 -ад3ч6
.ад3ш6 -ад3ш6
% над-
.на2д3б6 -на2д3б6
.на2д3в6 -на2д3в6
.на2д3г6 -на2д3г6
.на2д3ґ6 -на2д3ґ6
.на2д3д6 -на2д3д6
% .на2дж
% .на2дз
.на2д3к6 -на2д3к6
.на2д3л6 -на2д3л6
.на2д3м6 -на2д3м6
.на2д3н6 -на2д3н6
.на2д3п6 -на2д3п6
.на2д3р6 -на2д3р6
.на2д3с6 -на2д3с6
.на2д3т6 -на2д3т6
.на2д3ф6 -на2д3ф6
.на2д3х6 -на2д3х6
.на2д3ц6 -на2д3ц6
.на2д3ч6 -на2д3ч6
.на2д3ш6 -на2д3ш6
% пад-
.па2д3б6 -па2д3б6
.па2д3в6 -па2д3в6
.па2д3г6 -па2д3г6
.па2д3ґ6 -па2д3ґ6
.па2д3д6 -па2д3д6
% .па2дж
% .па2дз
.па2д3к6 -па2д3к6
.па2д3л6 -па2д3л6
.па2д3м6 -па2д3м6
.па2д3н6 -па2д3н6
.па2д3п6 -па2д3п6
.па2д3р6 -па2д3р6
.па2д3с6 -па2д3с6
.па2д3т6 -па2д3т6
.па2д3ф6 -па2д3ф6
.па2д3х6 -па2д3х6
.па2д3ц6 -па2д3ц6
.па2д3ч6 -па2д3ч6
.па2д3ш6 -па2д3ш6
% перад-
.пера2д3б6 -пера2д3б6
.пера2д3в6 -пера2д3в6
.пера2д3г6 -пера2д3г6
.пера2д3ґ6 -пера2д3ґ6
.пера2д3д6 -пера2д3д6
% .пера2дж
% .пера2дз
.пера2д3к6 -пера2д3к6
.пера2д3л6 -пера2д3л6
.пера2д3м6 -пера2д3м6
.пера2д3н6 -пера2д3н6
.пера2д3п6 -пера2д3п6
.пера2д3р6 -пера2д3р6
.пера2д3с6 -пера2д3с6
.пера2д3т6 -пера2д3т6
.пера2д3ф6 -пера2д3ф6
.пера2д3х6 -пера2д3х6
.пера2д3ц6 -пера2д3ц6
.пера2д3ч6 -пера2д3ч6
.пера2д3ш6 -пера2д3ш6
% аб-
.аб3б6 -аб3б6
.аб3в6 -аб3в6
.аб3г6 -аб3г6
.аб3ґ6 -аб3ґ6
.аб3д6 -аб3д6
.аб3ж6 -аб3ж6
.аб3з6 -аб3з6
.аб3к6 -аб3к6
.аб3л6 -аб3л6
.аб3м6 -аб3м6
.аб3н6 -аб3н6
.аб3п6 -аб3п6
.аб3р6 -аб3р6
.аб3с6 -аб3с6
.аб3т6 -аб3т6
.аб3ф6 -аб3ф6
.аб3х6 -аб3х6
.аб3ц6 -аб3ц6
.аб3ч6 -аб3ч6
.аб3ш6 -аб3ш6
% раз-
.ра2з3б6 -ра2з3б6
.ра2з3в6 -ра2з3в6
.ра2з3г6 -ра2з3г6
.ра2з3ґ6 -ра2з3ґ6
.ра2з3д6 -ра2з3д6
.ра2з3ж6 -ра2з3ж6
.ра2з3з6 -ра2з3з6
.ра2з3к6 -ра2з3к6
.ра2з3л6 -ра2з3л6
.ра2з3м6 -ра2з3м6
.ра2з3н6 -ра2з3н6
.ра2з3п6 -ра2з3п6
.ра2з3р6 -ра2з3р6
.ра2з3с6 -ра2з3с6
.ра2з3т6 -ра2з3т6
.ра2з3ф6 -ра2з3ф6
.ра2з3х6 -ра2з3х6
.ра2з3ц6 -ра2з3ц6
.ра2з3ч6 -ра2з3ч6
.ра2з3ш6 -ра2з3ш6
% уз-
.уз3б6 -уз3б6
.уз3в6 -уз3в6
.уз3г6 -уз3г6
.уз3ґ6 -уз3ґ6
.уз3д6 -уз3д6
.уз3ж6 -уз3ж6
.уз3з6 -уз3з6
.уз3к6 -уз3к6
.уз3л6 -уз3л6
.уз3м6 -уз3м6
.уз3н6 -уз3н6
.уз3п6 -уз3п6
.уз3р6 -уз3р6
.уз3с6 -уз3с6
.уз3т6 -уз3т6
.уз3ф6 -уз3ф6
.уз3х6 -уз3х6
.уз3ц6 -уз3ц6
.уз3ч6 -уз3ч6
.уз3ш6 -уз3ш6
% ўз-
.ўз3б6 -ўз3б6
.ўз3в6 -ўз3в6
.ўз3г6 -ўз3г6
.ўз3ґ6 -ўз3ґ6
.ўз3д6 -ўз3д6
.ўз3ж6 -ўз3ж6
.ўз3з6 -ўз3з6
.ўз3к6 -ўз3к6
.ўз3л6 -ўз3л6
.ўз3м6 -ўз3м6
.ўз3н6 -ўз3н6
.ўз3п6 -ўз3п6
.ўз3р6 -ўз3р6
.ўз3с6 -ўз3с6
.ўз3т6 -ўз3т6
.ўз3ф6 -ўз3ф6
.ўз3х6 -ўз3х6
.ўз3ц6 -ўз3ц6
.ўз3ч6 -ўз3ч6
.ўз3ш6 -ўз3ш6
% праз-
.пра2з3б6 -пра2з3б6
.пра2з3в6 -пра2з3в6
.пра2з3г6 -пра2з3г6
.пра2з3ґ6 -пра2з3ґ6
.пра2з3д6 -пра2з3д6
.пра2з3ж6 -пра2з3ж6
.пра2з3з6 -пра2з3з6
.пра2з3к6 -пра2з3к6
.пра2з3л6 -пра2з3л6
.пра2з3м6 -пра2з3м6
.пра2з3н6 -пра2з3н6
.пра2з3п6 -пра2з3п6
.пра2з3р6 -пра2з3р6
.пра2з3с6 -пра2з3с6
.пра2з3т6 -пра2з3т6
.пра2з3ф6 -пра2з3ф6
.пра2з3х6 -пра2з3х6
.пра2з3ц6 -пра2з3ц6
.пра2з3ч6 -пра2з3ч6
.пра2з3ш6 -пра2з3ш6
% ус-
.ус3б6 -ус3б6
.ус3в6 -ус3в6
.ус3г6 -ус3г6
.ус3ґ6 -ус3ґ6
.ус3д6 -ус3д6
.ус3ж6 -ус3ж6
.ус3з6 -ус3з6
.ус3к6 -ус3к6
.ус3л6 -ус3л6
.ус3м6 -ус3м6
.ус3н6 -ус3н6
.ус3п6 -ус3п6
.ус3р6 -ус3р6
.ус3с6 -ус3с6
.ус3т6 -ус3т6
.ус3ф6 -ус3ф6
.ус3х6 -ус3х6
.ус3ц6 -ус3ц6
.ус3ч6 -ус3ч6
.ус3ш6 -ус3ш6
% ўс-
.ўс3б6 -ўс3б6
.ўс3в6 -ўс3в6
.ўс3г6 -ўс3г6
.ўс3ґ6 -ўс3ґ6
.ўс3д6 -ўс3д6
.ўс3ж6 -ўс3ж6
.ўс3з6 -ўс3з6
.ўс3к6 -ўс3к6
.ўс3л6 -ўс3л6
.ўс3м6 -ўс3м6
.ўс3н6 -ўс3н6
.ўс3п6 -ўс3п6
.ўс3р6 -ўс3р6
.ўс3с6 -ўс3с6
.ўс3т6 -ўс3т6
.ўс3ф6 -ўс3ф6
.ўс3х6 -ўс3х6
.ўс3ц6 -ўс3ц6
.ўс3ч6 -ўс3ч6
.ўс3ш6 -ўс3ш6
% рас-
.ра2с3б6 -ра2с3б6
.ра2с3в6 -ра2с3в6
.ра2с3г6 -ра2с3г6
.ра2с3ґ6 -ра2с3ґ6
.ра2с3д6 -ра2с3д6
.ра2с3ж6 -ра2с3ж6
.ра2с3з6 -ра2с3з6
.ра2с3к6 -ра2с3к6
.ра2с3л6 -ра2с3л6
.ра2с3м6 -ра2с3м6
.ра2с3н6 -ра2с3н6
.ра2с3п6 -ра2с3п6
.ра2с3р6 -ра2с3р6
.ра2с3с6 -ра2с3с6
.ра2с3т6 -ра2с3т6
.ра2с3ф6 -ра2с3ф6
.ра2с3х6 -ра2с3х6
.ра2с3ц6 -ра2с3ц6
.ра2с3ч6 -ра2с3ч6
.ра2с3ш6 -ра2с3ш6
% роз-
.ро2з3б6 -ро2з3б6
.ро2з3в6 -ро2з3в6
.ро2з3г6 -ро2з3г6
.ро2з3ґ6 -ро2з3ґ6
.ро2з3д6 -ро2з3д6
.ро2з3ж6 -ро2з3ж6
.ро2з3з6 -ро2з3з6
.ро2з3к6 -ро2з3к6
.ро2з3л6 -ро2з3л6
.ро2з3м6 -ро2з3м6
.ро2з3н6 -ро2з3н6
.ро2з3п6 -ро2з3п6
.ро2з3р6 -ро2з3р6
.ро2з3с6 -ро2з3с6
.ро2з3т6 -ро2з3т6
.ро2з3ф6 -ро2з3ф6
.ро2з3х6 -ро2з3х6
.ро2з3ц6 -ро2з3ц6
.ро2з3ч6 -ро2з3ч6
.ро2з3ш6 -ро2з3ш6
% бяз-
.бя2з3б6 -бя2з3б6
.бя2з3в6 -бя2з3в6
.бя2з3г6 -бя2з3г6
.бя2з3ґ6 -бя2з3ґ6
.бя2з3д6 -бя2з3д6
.бя2з3ж6 -бя2з3ж6
.бя2з3з6 -бя2з3з6
.бя2з3к6 -бя2з3к6
.бя2з3л6 -бя2з3л6
.бя2з3м6 -бя2з3м6
.бя2з3н6 -бя2з3н6
.бя2з3п6 -бя2з3п6
.бя2з3р6 -бя2з3р6
.бя2з3с6 -бя2з3с6
.бя2з3т6 -бя2з3т6
.бя2з3ф6 -бя2з3ф6
.бя2з3х6 -бя2з3х6
.бя2з3ц6 -бя2з3ц6
.бя2з3ч6 -бя2з3ч6
.бя2з3ш6 -бя2з3ш6
% без-
.бе2з3б6 -бе2з3б6
.бе2з3в6 -бе2з3в6
.бе2з3г6 -бе2з3г6
.бе2з3ґ6 -бе2з3ґ6
.бе2з3д6 -бе2з3д6
.бе2з3ж6 -бе2з3ж6
.бе2з3з6 -бе2з3з6
.бе2з3к6 -бе2з3к6
.бе2з3л6 -бе2з3л6
.бе2з3м6 -бе2з3м6
.бе2з3н6 -бе2з3н6
.бе2з3п6 -бе2з3п6
.бе2з3р6 -бе2з3р6
.бе2з3с6 -бе2з3с6
.бе2з3т6 -бе2з3т6
.бе2з3ф6 -бе2з3ф6
.бе2з3х6 -бе2з3х6
.бе2з3ц6 -бе2з3ц6
.бе2з3ч6 -бе2з3ч6
.бе2з3ш6 -бе2з3ш6
% бяс-
.бя2с3б6 -бя2с3б6
.бя2с3в6 -бя2с3в6
.бя2с3г6 -бя2с3г6
.бя2с3ґ6 -бя2с3ґ6
.бя2с3д6 -бя2с3д6
.бя2с3ж6 -бя2с3ж6
.бя2с3з6 -бя2с3з6
.бя2с3к6 -бя2с3к6
.бя2с3л6 -бя2с3л6
.бя2с3м6 -бя2с3м6
.бя2с3н6 -бя2с3н6
.бя2с3п6 -бя2с3п6
.бя2с3р6 -бя2с3р6
.бя2с3с6 -бя2с3с6
.бя2с3т6 -бя2с3т6
.бя2с3ф6 -бя2с3ф6
.бя2с3х6 -бя2с3х6
.бя2с3ц6 -бя2с3ц6
.бя2с3ч6 -бя2с3ч6
.бя2с3ш6 -бя2с3ш6
% бес-
.бе2с3б6 -бе2с3б6
.бе2с3в6 -бе2с3в6
.бе2с3г6 -бе2с3г6
.бе2с3ґ6 -бе2с3ґ6
.бе2с3д6 -бе2с3д6
.бе2с3ж6 -бе2с3ж6
.бе2с3з6 -бе2с3з6
.бе2с3к6 -бе2с3к6
.бе2с3л6 -бе2с3л6
.бе2с3м6 -бе2с3м6
.бе2с3н6 -бе2с3н6
.бе2с3п6 -бе2с3п6
.бе2с3р6 -бе2с3р6
.бе2с3с6 -бе2с3с6
.бе2с3т6 -бе2с3т6
.бе2с3ф6 -бе2с3ф6
.бе2с3х6 -бе2с3х6
.бе2с3ц6 -бе2с3ц6
.бе2с3ч6 -бе2с3ч6
.бе2с3ш6 -бе2с3ш6
% рос-
.ро2с3б6 -ро2с3б6
.ро2с3в6 -ро2с3в6
.ро2с3г6 -ро2с3г6
.ро2с3ґ6 -ро2с3ґ6
.ро2с3д6 -ро2с3д6
.ро2с3ж6 -ро2с3ж6
.ро2с3з6 -ро2с3з6
.ро2с3к6 -ро2с3к6
.ро2с3л6 -ро2с3л6
.ро2с3м6 -ро2с3м6
.ро2с3н6 -ро2с3н6
.ро2с3п6 -ро2с3п6
.ро2с3р6 -ро2с3р6
.ро2с3с6 -ро2с3с6
.ро2с3т6 -ро2с3т6
.ро2с3ф6 -ро2с3ф6
.ро2с3х6 -ро2с3х6
.ро2с3ц6 -ро2с3ц6
.ро2с3ч6 -ро2с3ч6
.ро2с3ш6 -ро2с3ш6
% цераз-
.цера2з3б6 -цера2з3б6
.цера2з3в6 -цера2з3в6
.цера2з3г6 -цера2з3г6
.цера2з3ґ6 -цера2з3ґ6
.цера2з3д6 -цера2з3д6
.цера2з3ж6 -цера2з3ж6
.цера2з3з6 -цера2з3з6
.цера2з3к6 -цера2з3к6
.цера2з3л6 -цера2з3л6
.цера2з3м6 -цера2з3м6
.цера2з3н6 -цера2з3н6
.цера2з3п6 -цера2з3п6
.цера2з3р6 -цера2з3р6
.цера2з3с6 -цера2з3с6
.цера2з3т6 -цера2з3т6
.цера2з3ф6 -цера2з3ф6
.цера2з3х6 -цера2з3х6
.цера2з3ц6 -цера2з3ц6
.цера2з3ч6 -цера2з3ч6
.цера2з3ш6 -цера2з3ш6
% церас-
.цера2с3б6 -цера2с3б6
.цера2с3в6 -цера2с3в6
.цера2с3г6 -цера2с3г6
.цера2с3ґ6 -цера2с3ґ6
.цера2с3д6 -цера2с3д6
.цера2с3ж6 -цера2с3ж6
.цера2с3з6 -цера2с3з6
.цера2с3к6 -цера2с3к6
.цера2с3л6 -цера2с3л6
.цера2с3м6 -цера2с3м6
.цера2с3н6 -цера2с3н6
.цера2с3п6 -цера2с3п6
.цера2с3р6 -цера2с3р6
.цера2с3с6 -цера2с3с6
.цера2с3т6 -цера2с3т6
.цера2с3ф6 -цера2с3ф6
.цера2с3х6 -цера2с3х6
.цера2с3ц6 -цера2с3ц6
.цера2с3ч6 -цера2с3ч6
.цера2с3ш6 -цера2с3ш6
%
% Спалучэннi дж i дз можна разбiваць пераносам, калi д адносiцца да прыстаўкi,
% а з, ж – да кораня:
% дж and дз can be split if д belongs to a prefix
% and ж or з to the root of a word.
%
% пад-жары, ад-жаць, пад-земны, ад-значыць
%
.ад7жал -ад7жал
.ад7жат -ад7жат
.ад7жац -ад7жац
.ад7жаў -ад7жаў
.ад7жар -ад7жар
.ад7жлукц -ад7жлукц
.ад7жлукч -ад7жлукч
.ад7жыв -ад7жыв
.ад7жыл -ад7жыл
.ад7жын -ад7жын
.ад7жыт -ад7жыт
.ад7жыць -ад7жыць
.ад7жыў -ад7жыў
.ад7зав -ад7зав
.ад7зван -ад7зван
.ад7звон -ад7звон
.ад7знак -ад7знак
.ад7знач -ад7знач
.ад7знац -ад7знац
.ад7зыва -ад7зыва
.ад7зыўн -ад7зыўн
.на8д7звычай -на8д7звычай
.на8д7земн -на8д7земн
.па8д7жар -па8д7жар
.па8д7жыв -па8д7жыв
.па8д7жыць -па8д7жыць
.па8д7жыў -па8д7жыў
.па8д7жыл -па8д7жыл
.па8д7зав -па8д7зав
.па8д7загалова -па8д7загалова
.па8д7загалоў -па8д7загалоў
.па8д7закус -па8д7закус
.па8д7закуш -па8д7закуш
.па8д7зараб -па8д7зараб
.па8д7зароб -па8д7зароб
.па8д7земн -па8д7земн
.па8д7зяме -па8д7зяме
.па8д7зор -па8д7зор
.па8д7зыва -па8д7зыва
%
% Перанос у словах, якія ўяўляюць сабой
% выключэнні з вышэй апісаных правілаў
%
% Exception from the rules specified above
%
тэ8мбр. тэ8мбр-
.дву8х3 -дву8х3
.тро8х3 -тро8х3
.чатыро8х3 -чатыро8х3
слова7ў8твар
віда1з8мян
віда1з8мен
за1п8люшч
вё8рст
раз5г8ляд
раз5г8лед
зло7ў8жыв
.вы1к8люч -вы1к8люч
.шма8т1 -шма8т1
крова3ў8твар
за3ц8вярдз
.па3г8лядз -па3г8лядз
на5д8вор
}

