use strict;
use warnings;
use Module::Build;
Module::Build->new(
    module_name => 'TeX::Hyphen::Pattern',
    license     => 'perl',
    dist_author => 'Roland van Ipenburg <roland@rolandvanipenburg.com>',
    requires    => {
        'perl'              => '5.14.0',
        'Moose'             => 0,
        'Encode'            => 0,
        'File::Temp'        => 0,
        'Log::Log4perl'     => 0,
        'Module::Pluggable' => 0,
        'Readonly'          => 1.03,
        'Set::Scalar'       => 0,
        'Test::More'        => 0.81,
        'Test::NoWarnings'  => 0,
    },
    build_requires => {},
    test_requires  => {
        'Test::More'       => 0.86,
        'Test::NoWarnings' => 0,
        'Test::Warn'       => 0,
    },
    script_files =>
      [ qw(tools/build_catalog.pl tools/build_catalog_from_ctan.pl), ],
    meta_merge => {
        resources => {
            repository =>
              'https://bitbucket.org/rolandvanipenburg/tex-hyphen-pattern'
        }
    },
    sign => 1,
)->create_build_script;
