package App::BPOMUtils::Table::FoodCategoryRBA;

use 5.010001;
use strict 'subs', 'vars';
use utf8;
use warnings;
use Log::ger;

use Exporter 'import';
use Perinci::Sub::Gen::AccessTable qw(gen_read_table_func);

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2023-09-03'; # DATE
our $DIST = 'App-BPOMUtils-Table-FoodCategory'; # DIST
our $VERSION = '0.019'; # VERSION

our @EXPORT_OK = qw(
                       bpom_list_food_categories_rba
               );

our %SPEC;

# BEGIN FRAGMENT id=meta-idn_bpom_kategori_pangan_rba varname=meta_idn_bpom_kategori_pangan_rba
# note: This fragment's content is generated by a script. Do not edit manually!
# src-file: /home/u1/repos/gudangdata/bin/../table/idn_bpom_kategori_pangan_rba/meta.yaml
# src-revision: ae4f15ffbc08eccefd92e3d5c8ea11820203d06c (Mon Feb 13 16:58:48 2023 +0700)
# generate-date: Mon Feb 13 10:39:53 2023 UTC
# generated-by: update-fragments-in-perl-module
our $meta_idn_bpom_kategori_pangan_rba = {
  "fields" => {
    code    => {
                 filterable_regex => "Yes",
                 pos => 0,
                 schema => ["str*", { match => "^[0-9ABC]+\$" }],
                 sortable => "Yes",
                 summary => "Code",
                 unique => "Yes",
               },
    name    => {
                 filterable_regex => "Yes",
                 pos => 1,
                 schema => "str*",
                 sortable => "Yes",
                 summary => "Name",
                 unique => "Yes",
               },
    status  => {
                 filterable_regex => "Yes",
                 pos => 3,
                 schema => ["str*"],
                 sortable => "Yes",
                 summary => "Status",
                 unique => "No",
               },
    summary => {
                 filterable_regex => "Yes",
                 pos => 2,
                 schema => ["str*"],
                 sortable => "Yes",
                 summary => "Summary",
                 unique => "No",
               },
  },
  "pk" => "code",
  "summary" => "Food categories in BPOM processed food division (RBA version)",
  "summary.alt.lang.id_ID" => "Kategori pangan di BPOM pangan olahan (versi RBA)",
};
# END FRAGMENT id=meta-idn_bpom_kategori_pangan_rba

# BEGIN FRAGMENT id=data-idn_bpom_kategori_pangan_rba varname=data_idn_bpom_kategori_pangan_rba
# note: This fragment's content is generated by a script. Do not edit manually!
# src-file: /home/u1/repos/gudangdata/bin/../table/idn_bpom_kategori_pangan_rba/data.csv
# src-revision: ae4f15ffbc08eccefd92e3d5c8ea11820203d06c (Mon Feb 13 16:58:48 2023 +0700)
# generate-date: Mon Feb 13 10:39:53 2023 UTC
# generated-by: update-fragments-in-perl-module
our $data_idn_bpom_kategori_pangan_rba = [
  [
    "010101000001",
    "Susu Lemak Penuh (Full Cream)",
    "Susu Lemak Penuh (full cream) adalah produk susu cair yang diperoleh dari susu segar yang tidak dikurangi lemaknya, dipasteurisasi atau disterilisasi atau diproses secara UHT (Ultra High Temperature). Nama jenis produk ini dapat diikuti dengan prosesnya, contohnya susu lemak penuh (full cream) pasteurisasi, susu pasteurisasi. Karakteristik dasar: \x{2022} Kadar lemak susu tidak kurang dari 3%; \x{2022} Total padatan susu bukan-lemak tidak kurang dari 7,8%; \x{2022} Kadar protein tidak kurang dari 2,7%.",
    "Aktif",
  ],
  [
    "010101000002",
    "Susu Skim",
    "Susu skim adalah produk susu cair yang sebagian besar lemaknya telah dihilangkan, dan dipasteurisasi atau disterilisasi atau diproses secara UHT (Ultra High Temperature). Karakteristik dasar: \x{2022} Kadar lemak susu tidak lebih dari 0,5%; \x{2022} Kadar protein tidak kurang dari 2,7%.",
    "Aktif",
  ],
  [
    "010101000003",
    "Susu Skim Sebagian",
    "Susu skim sebagian adalah produk susu cair yang sebagian lemaknya telah dihilangkan, dan dipasteurisasi atau disterilisasi atau diproses secara UHT (Ultra High Temperature). Karakteristik dasar: \x{2022} Kadar lemak susu 0,6% sampai kurang dari 2,9%; \x{2022} Kadar protein tidak kurang dari 2,7%. ",
    "Aktif",
  ],
  [
    "010102000001",
    "Susu Lemak Penuh Rekombinasi (Recombined Full Cream Milk)",
    "Susu Lemak Penuh Rekombinasi (Recombined Full Cream Milk) adalah produk susu yang tidak dikurangi lemaknya yang dihasilkan dari penggabungan lemak susu dan padatan susu bukan-lemak dengan atau tanpa penambahan air untuk mendapatkan komposisi susu yang sesuai, dan dipasteurisasi atau disterilisasi atau diproses secara UHT (Ultra High Temperature). Karakteristik dasar: \x{2022} Kadar lemak susu tidak kurang dari 3%; \x{2022} Total padatan susu bukan-lemak tidak kurang dari 7,8%; \x{2022} Kadar protein tidak kurang dari 2,7%.",
    "Aktif",
  ],
  [
    "010102000002",
    "Susu Lemak Penuh Rekonstitusi (Reconstituted Full Cream Milk)",
    "Susu Lemak Penuh Rekonstitusi (Reconstituted Full Cream Milk) adalah produk susu yang tidak dikurangi lemaknya yang dihasilkan dari penambahan air pada susu bubuk kering atau produk susu evaporasi untuk mengembalikan rasio air terhadap padatan yang sesuai, dan dipasteurisasi atau disterilisasi atau diproses secara UHT (Ultra High Temperature). Karakteristik dasar: \x{2022} Kadar lemak susu tidak kurang dari 3%; \x{2022} Total padatan susu bukan-lemak tidak kurang dari 7,8%; \x{2022} Kadar protein tidak kurang dari 2,7%.",
    "Aktif",
  ],
  [
    "010102000003",
    "Susu Skim Rekonstitusi",
    "Susu skim rekonstitusi adalah produk susu cair hasil penambahan air pada susu bubuk skim atau susu skim evaporasi, dan dipasteurisasi atau disterilisasi atau diproses secara UHT (Ultra High Temperature). Karakteristik dasar: \x{2022} Kadar lemak susu tidak lebih dari 0,5%; \x{2022} Kadar protein tidak kurang dari 2,7%. ",
    "Aktif",
  ],
  [
    "010102000004",
    "Susu Skim Sebagian Rekonstitusi",
    "Susu skim sebagian rekonstitusi adalah produk susu cair hasil penambahan air pada susu bubuk skim sebagian atau susu skim sebagian evaporasi untuk mendapatkan komposisi susu skim sebagian yang sesuai, dan dipasteurisasi atau disterilisasi atau diproses secara UHT (Ultra High Temperature). Karakteristik dasar: \x{2022} Kadar lemak susu 0,6% sampai kurang dari 2,9%; \x{2022} Kadar protein tidak kurang dari 2,7%. ",
    "Aktif",
  ],
  [
    "010102000005",
    "Susu Skim Sebagian Rekombinasi",
    "Susu skim sebagian rekombinasi adalah produk susu cair yang dihasilkan dari penggabungan lemak susu dan padatan susu bukan-lemak dengan atau tanpa penambahan air untuk mendapatkan komposisi susu skim sebagian yang sesuai, dan dipasteurisasi atau disterilisasi atau diproses secara UHT (Ultra High Temperature). Karakteristik dasar: \x{2022} Kadar lemak susu 0,6% sampai kurang dari 2,9%; \x{2022} Kadar protein tidak kurang dari 2,7%",
    "Aktif",
  ],
  [
    "010102000006",
    "Susu Lemak Nabati/Susu Minyak Nabati (Filled Milk)",
    "Susu lemak nabati/susu minyak nabati (filled milk) adalah produk susu cair yang diperoleh dengan cara menggantikan sebagian atau seluruh lemak susu dengan minyak atau lemak nabati, atau campurannya dalam jumlah yang setara. Produk ini mempunyai komposisi umum, penampakan, dan penggunaan yang mirip dengan susu segar. Karakteristik dasar: \x{2022} Kadar lemak total tidak kurang dari 3%; \x{2022} Total padatan susu bukan-lemak tidak kurang dari 7,8%; \x{2022} Kadar protein tidak kurang dari 2,7%",
    "Aktif",
  ],
  [
    "010102000007",
    "Minuman Susu",
    "Minuman susu adalah minuman berbahan dasar susu segar, susu rekonstitusi atau susu rekombinasi, dapat ditambahkan bahan pangan lain dan disterilisasi atau dipasteurisasi. Karakteristik dasar: \x{2022} Kadar lemak susu 1,2% sampai kurang dari 2%; \x{2022} Total padatan susu bukan-lemak tidak kurang dari 4,4%; \x{2022} Kadar protein tidak kurang dari 1%",
    "Aktif",
  ],
  [
    "010102000008",
    "Minuman Mengandung Susu",
    "Minuman mengandung susu adalah minuman yang dibuat dengan menggunakan susu segar, susu rekonstitusi atau susu rekombinasi, dapat ditambahkan bahan pangan lain dan disterilisasi atau dipasteurisasi. Karakteristik dasar: \x{2022} Kadar lemak susu tidak kurang dari 0,3%; \x{2022} Total padatan susu bukan-lemak tidak kurang dari 0,78%; \x{2022} Kadar protein tidak kurang dari 0,27%",
    "Aktif",
  ],
  [
    "010102000009",
    "Minuman Susu Fermentasi",
    "Minuman susu fermentasi adalah minuman berbahan dasar susu fermentasi, dapat ditambahkan bahan pangan lain dengan atau tanpa proses pemanasan. Penamaan jenis produk berdasarkan bahan dasar yang digunakan, misalnya minuman yogurt, minuman kefir, minuman kumys. Karakteristik Dasar: \x{2022} Total padatan susu bukan-lemak tidak kurang dari 2,6%; \x{2022} Kadar protein susu tidak kurang dari 0,92% ",
    "Aktif",
  ],
  [
    "010102000010",
    "Lassi (Plain)",
    "Lassi adalah minuman yang diperoleh dari susu yang difermentasi dengan bakteri asam laktat sampai terbentuk curd (gumpalan protein susu) kemudian dikocok.",
    "Aktif",
  ],
  [
    "010103000001",
    "Buttermilk Cair",
    "Buttermilk cair adalah cairan yang hampir bebas lemak susu yang diperoleh dari proses pembuatan mentega (yaitu mengocok susu dan krim fermentasi atau tidak difermentasi). Buttermilk cair juga diproduksi dengan fermentasi susu skim cair, baik dengan pengasaman spontan melalui aktivitas bakteri asam laktat atau bakteri pembentuk aroma, atau dengan inokulasi susu yang dipanaskan dengan kultur bakteri murni (buttermilk terfermentasi). Buttermilk cair dapat dipasteurisasi atau disterilisasi. ",
    "Aktif",
  ],
  [
    "010104000001",
    "Susu (Rasa) Lemak Penuh (Full Cream Milk)",
    "Susu (rasa) Lemak Penuh (Full Cream Milk) adalah minuman berbahan dasar susu segar, susu rekonstitusi atau susu rekombinasi yang tidak dikurangi lemaknya, dengan penambahan bahan/ekstrak alami yang menimbulkan rasa, dengan atau tanpa penambahan perisa, dapat ditambahkan gula, bahan pangan lain dan disterilisasi atau dipasteurisasi. Contoh susu cokelat, susu stroberi. Karakteristik dasar : \x{2022} Kadar lemak susu tidak kurang dari 2%; \x{2022} Total padatan susu bukan-lemak tidak kurang dari 5,2%; \x{2022} Kadar protein tidak kurang dari 2%; \x{2022} Kadar bahan/ekstrak alami tidak kurang dari 0,5%",
    "Aktif",
  ],
  [
    "010104000002",
    "Susu Berperisa/Susu Rasa",
    "Susu berperisa/susu rasa adalah minuman berbahan dasar susu segar, susu rekonstitusi atau susu rekombinasi dengan penambahan perisa, dapat ditambahkan gula, bahan pangan lain dan disterilisasi atau dipasteurisasi. Contoh susu rasa cokelat/susu berperisa cokelat, susu rasa stroberi/susu berperisa stroberi. Karakteristik dasar : \x{2022} Kadar lemak susu tidak kurang dari 2%; \x{2022} Total padatan susu bukan-lemak tidak kurang dari 5,2%; \x{2022} Kadar protein tidak kurang dari 2%.",
    "Aktif",
  ],
  [
    "010104000003",
    "Minuman Susu Berperisa/Rasa",
    "Minuman susu adalah minuman berbahan dasar susu segar, susu rekonstitusi atau susu rekombinasi dengan bahan tambahan pangan perisa atau rasa, dapat ditambahkan gula, bahan pangan lain dan disterilisasi atau dipasteurisasi. Karakteristik dasar: \x{2022} Kadar lemak susu 1,2% sampai kurang dari 2%; \x{2022} Total padatan susu bukan-lemak tidak kurang dari 4,4%; \x{2022} Kadar protein tidak kurang dari 1%",
    "Aktif",
  ],
  [
    "010104000004",
    "Minuman Mengandung Susu Berperisa/Rasa",
    "Minuman mengandung susu adalah minuman yang dibuat dengan menggunakan susu segar, susu rekonstitusi atau susu rekombinasi dengan bahan tambahan pangan perisa atau rasa, dapat ditambahkan gula, bahan pangan lain dan disterilisasi atau dipasteurisasi. Karakteristik dasar : \x{2022} Kadar lemak susu tidak kurang dari 0,26%; \x{2022} Kadar protein tidak kurang dari 0,23%. \x{2022} Total padatan susu bukan-lemak tidak kurang dari 0,66%",
    "Aktif",
  ],
  [
    "010104000005",
    "Minuman Susu Fermentasi Berperisa/Rasa",
    "Minuman susu fermentasi adalah minuman berbahan dasar susu fermentasi dengan penambahan perisa atau rasa, dapat ditambahkan gula, bahan pangan lain dengan atau tanpa proses pemanasan. Penamaan jenis produk berdasarkan bahan dasar yang digunakan, misalnya minuman yogurt, minuman kefir, minuman kumys. Karakteristik dasar: \x{2022} Total padatan susu bukan-lemak tidak kurang dari 2,6%; \x{2022} Kadar protein susu tidak kurang dari 0,92%",
    "Aktif",
  ],
  [
    "010104000006",
    "Lassi (Rasa/Berperisa)",
    "Lassi adalah minuman yang diperoleh dari susu yang difermentasi dengan bakteri asam laktat sampai terbentuk curd (gumpalan protein susu) kemudian dikocok dan dicampur dengan gula dan/atau pemanis",
    "Aktif",
  ],
  [
    "010104000007",
    "Minuman Berbasis Whey",
    "Minuman berbasis whey adalah minuman berbahan dasar whey, dapat ditambahkan gula, bahan pangan lain dan disterilisasi atau dipasteurisasi. Contoh minuman berbasis whey rasa cokelat",
    "Aktif",
  ],
  [
    "010104000008",
    "Susu Bubuk (Rasa)",
    "Susu bubuk (rasa) adalah susu bubuk yang ditambah dengan bahan pangan berupa bubuk kakao, ekstrak stroberi, ekstrak vanilla dan atau bahan lain yang sesuai, dapat ditambah gula dan atau perisa. Nama jenis produk ini susu bubuk cokelat, susu bubuk stroberi, susu bubuk vanilla, susu bubuk madu, dan lain-lain. Karakteristik dasar: \x{2022} Kadar air tidak lebih dari 5%; \x{2022} Kadar lemak susu tidak kurang dari 26%; \x{2022} Kadar protein tidak kurang dari 11%; \x{2022} Kadar gula dihitung sebagai sakarosa tidak lebih dari 55%",
    "Aktif",
  ],
  [
    "010104000009",
    "Susu Bubuk Skim (Rasa)",
    "Susu bubuk skim (rasa) adalah susu bubuk skim yang ditambah dengan bahan pangan berupa bubuk kakao, ekstrak stroberi, ekstrak vanilla dan atau bahan lain yang sesuai, dapat ditambah gula dan atau perisa. Nama jenis produk ini susu bubuk skim cokelat, susu bubuk skim stroberi, susu bubuk skim vanilla, susu bubuk skim madu, dan lain-lain. Karakteristik dasar: \x{2022} Kadar lemak susu tidak lebih dari 1,5%; \x{2022} Kadar air tidak lebih dari 5%; \x{2022} Kadar protein tidak kurang dari 11%; \x{2022} Kadar gula dihitung sebagai sakarosa tidak lebih dari 55%",
    "Aktif",
  ],
  [
    "010104000010",
    "Susu Bubuk Skim Sebagian (Rasa)",
    "Susu bubuk skim sebagian (rasa) adalah susu bubuk skim sebagian yang ditambah dengan bahan pangan berupa bubuk kakao, ekstrak stroberi, ekstrak vanilla dan atau bahan lain yang sesuai, dapat ditambah gula dan atau perisa. Nama jenis produk ini susu bubuk skim sebagian cokelat, susu bubuk skim sebagian stroberi, susu bubuk skim sebagian vanilla, susu bubuk skim sebagian madu, dan lain-lain. Karakteristik dasar: \x{2022} Kadar lemak susu lebih dari 1,5% dan kurang dari 26%; \x{2022} Kadar air tidak lebih dari 5%; \x{2022} Kadar protein tidak kurang 11%; \x{2022} Kadar gula dihitung sebagai sakarosa tidak lebih dari 55%",
    "Aktif",
  ],
  [
    "010104000011",
    "Susu Bubuk Rasa/Berperisa",
    "Susu bubuk rasa/berperisa adalah susu bubuk yang ditambah dengan bahan tambahan pangan perisa atau rasa, dan dapat ditambah gula. Nama jenis produk ini susu bubuk rasa cokelat, susu bubuk rasa stroberi, susu bubuk rasa vanilla, susu bubuk rasa madu, dan lain-lain  Karakteristik dasar: \x{2022} Kadar air tidak lebih dari 5%; \x{2022} Kadar protein tidak kurang dari 11%; \x{2022} Kadar gula dihitung sebagai sakarosa tidak lebih dari 55%",
    "Aktif",
  ],
  [
    "010104000012",
    "Susu Bubuk Skim Rasa/Berperisa",
    "Susu bubuk skim rasa/berperisa adalah susu bubuk skim yang ditambah dengan bahan tambahan pangan perisa atau rasa, dan dapat ditambah gula. Nama jenis produk ini susu bubuk skim rasa cokelat, susu bubuk skim rasa stroberi, susu bubuk skim rasa vanilla, susu bubuk skim rasa madu, dan lain-lain. Karakteristik dasar: \x{2022} Kadar air tidak lebih dari 5%; \x{2022} Kadar protein tidak kurang dari 11%; \x{2022} Kadar gula dihitung sebagai sakarosa tidak lebih dari 55%.",
    "Aktif",
  ],
  [
    "010104000013",
    "Susu Bubuk Skim Sebagian Rasa/Berperisa",
    "Susu bubuk skim sebagian rasa/berperisa adalah susu bubuk skim sebagian yang ditambah dengan bahan tambahan pangan perisa atau rasa, dan dapat ditambah gula. Nama jenis produk ini susu bubuk skim sebagian rasa cokelat, susu bubuk skim sebagian rasa stroberi, susu bubuk skim sebagian rasa vanilla, susu bubuk skim sebagian rasa madu, dan lain-lain. Karakteristik dasar: \x{2022} Kadar air tidak lebih dari 5%; \x{2022} Kadar protein tidak kurang dari 11%; \x{2022} Kadar gula dihitung sebagai sakarosa tidak lebih dari 55%. ",
    "Aktif",
  ],
  [
    "010104000014",
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa",
    "Campuran susu dan krim bubuk berperisa atau (dengan) rasa adalah produk susu berbentuk bubuk, dibuat dari susu bubuk dengan penambahan gula dan perisa dalam bentuk kakao bubuk atau kopi bubuk dan lain-lain",
    "Aktif",
  ],
  [
    "010104000015",
    "Minuman Mengandung Susu Bubuk Berperisa atau dengan (Rasa)",
    "Minuman mengandung susu bubuk berperisa atau dengan (rasa) adalah minuman yang dibuat dengan menggunakan susu, susu rekonstitusi atau susu rekombinasi dengan tambahan perisa atau rasa, dapat ditambahkan gula. Karakteristik dasar: \x{2022} Kadar air tidak lebih dari 5%; \x{2022} Kadar protein tidak kurang dari 1,1%",
    "Aktif",
  ],
  [
    "010200000001",
    "Dadih",
    "Dadih adalah produk susu yang diperoleh dari proses fermentasi spontan bakteri asam laktat pada susu kerbau",
    "Aktif",
  ],
  [
    "010201010001",
    "Susu Diasamkan (Tanpa Pemanasan Setelah Proses Fermentasi)",
    "Susu diasamkan adalah produk susu yang diperoleh dari susu segar atau susu pasteurisasi atau susu rekonstitusi atau susu rekombinasi yang diasamkan, dengan atau tanpa penambahan mikroba, vitamin dan bahan pangan lain. Jenis asam yang dapat digunakan sesuai dengan ketentuan. Karakteristik dasar: Total padatan susu bukan-lemak tidak kurang dari 6,6%",
    "Aktif",
  ],
  [
    "010201010002",
    "Susu Asidofilus (Acidophilus Milk) (Tanpa Pemanasan Setelah Proses Fermentasi)",
    "Susu asidofilus adalah produk susu yang diperoleh dari fermentasi susu dengan menggunakan bakteri asam laktat Lactobacillus acidophilus, dapat ditambahkan bakteri lain yang sesuai. Karakteristik dasar: \x{2022} Total padatan susu bukan-lemak tidak kurang dari 6,6%; \x{2022} Kadar asam laktat tidak kurang dari 0,5%",
    "Aktif",
  ],
  [
    "010201010003",
    "Yogurt (Tanpa Pemanasan Setelah Proses Fermentasi)",
    "Yogurt adalah produk susu yang diperoleh dari fermentasi susu dengan menggunakan bakteri asam laktat Lactobacillus bulgaricus dan Streptococcus thermophilus, dapat ditambahkan bakteri lain yang sesuai. Karakteristik dasar: \x{2022} Total padatan susu bukan-lemak tidak kurang dari 6,6%; \x{2022} Kadar protein susu tidak kurang dari 2,3%; \x{2022} Kadar asam laktat tidak kurang dari 0,5%",
    "Aktif",
  ],
  [
    "010201010004",
    "Yogurt Kultur Lain (Alternate Culture Yogurt) (Tanpa Pemanasan Setelah Proses Fermentasi)",
    "Yogurt kultur lain adalah produk susu yang diperoleh dari fermentasi susu dengan menggunakan bakteri asam laktat Streptococcus thermophilus dan spesies Lactobacillus, dapat ditambahkan bakteri lain yang sesuai. Penamaan produk mengikuti ketentuan Standar Codex untuk Susu Fermentasi. Karakteristik dasar: \x{2022} Total padatan susu bukan-lemak tidak kurang dari 6,6%; \x{2022} Kadar protein susu tidak kurang dari 2,3%; \x{2022} Kadar asam laktat tidak kurang dari 0,5%",
    "Aktif",
  ],
  [
    "010201010005",
    "Kefir (Tanpa Pemanasan Setelah Proses Fermentasi)",
    "Kefir adalah produk susu yang diperoleh dari fermentasi susu dengan menggunakan kultur starter yang dibuat dari biji kefir, Lactobacillus kefiri, spesies dari genus Leuconostoc, Lactococcus dan Acetobacter yang tumbuh saling sinergi. Biji kefir mengandung khamir yang mampu memfermentasi laktosa (Kluyveromyces marxianus) dan khamir yang tidak mampu memfermentasi laktosa (Saccharomyces unisporus, Saccharomyces cerevisiae dan Saccharomyces exiguus), dapat ditambahkan bakteri lain yang sesuai. Karakteristik dasar: \x{2022} Total padatan susu bukan-lemak tidak kurang dari 6,6%; \x{2022} Kadar protein susu tidak kurang dari 2,3%; \x{2022} Kadar asam laktat tidak kurang dari 0,6%",
    "Aktif",
  ],
  [
    "010201010006",
    "Kumys (Tanpa Pemanasan Setelah Proses Fermentasi)",
    "Kumys adalah produk susu yang diperoleh dari fermentasi susu dengan menggunakan bakteri Lactobacillus delbrueckii subsp. bulgaricus dan Kluyveromyces marxianus, dapat ditambahkan bakteri lain yang sesuai. Karakteristik dasar: \x{2022} Total padatan susu bukan-lemak tidak kurang dari 6,6%; \x{2022} Kadar protein susu tidak kurang dari 2,3%; \x{2022} Kadar asam laktat tidak kurang dari 0,7%; \x{2022} Kadar etanol tidak kurang dari 0,5%. ",
    "Aktif",
  ],
  [
    "010201010007",
    "Susu Fermentasi atau Susu Berkultur (Cultured Milk) (Tanpa Pemanasan Setelah Proses Fermentasi)",
    "Susu fermentasi atau susu berkultur (cultured milk) adalah produk susu yang dihasilkan dari fermentasi susu segar dengan atau tanpa pasteurisasi, susu rekonstitusi atau susu rekombinasi yang diperoleh dari fermentasi dengan bakteri asam laktat yang sesuai. Karakteristik dasar: \x{2022} Total padatan susu bukan-lemak tidak kurang dari 6,6%; \x{2022} Kadar protein susu tidak kurang dari 2,3% \x{2022} Kadar asam laktat tidak kurang dari 0,5%",
    "Aktif",
  ],
  [
    "010201020001",
    "Susu Diasamkan (Dengan Pemanasan Setelah Proses Fermentasi)",
    "Susu diasamkan adalah produk susu yang diperoleh dari susu segar atau susu pasteurisasi atau susu rekonstitusi atau susu rekombinasi yang diasamkan, dengan atau tanpa penambahan mikroba, vitamin dan bahan pangan lain. Jenis asam yang dapat digunakan sesuai dengan ketentuan. Karakteristik dasar: Total padatan susu bukan-lemak tidak kurang dari 6,6%. ",
    "Aktif",
  ],
  [
    "010201020002",
    "Susu Asidofilus (Acidophilus Milk) (Dengan Pemanasan Setelah Proses Fermentasi)",
    "Susu asidofilus adalah produk susu yang diperoleh dari fermentasi susu dengan menggunakan bakteri asam laktat Lactobacillus acidophilus, dapat ditambahkan bakteri lain yang sesuai. Karakteristik dasar: \x{2022} Total padatan susu bukan-lemak tidak kurang dari 6,6%; \x{2022} Kadar asam laktat tidak kurang dari 0,5%",
    "Aktif",
  ],
  [
    "010201020003",
    "Yogurt (Dengan Pemanasan Setelah Proses Fermentasi)",
    "Yogurt adalah produk susu yang diperoleh dari fermentasi susu dengan menggunakan bakteri asam laktat Lactobacillus bulgaricus dan Streptococcus thermophilus, dapat ditambahkan bakteri lain yang sesuai. Karakteristik dasar: \x{2022} Total padatan susu bukan-lemak tidak kurang dari 6,6%; \x{2022} Kadar protein susu tidak kurang dari 2,3% \x{2022} Kadar asam laktat tidak kurang dari 0,5%",
    "Aktif",
  ],
  [
    "010201020004",
    "Yogurt Kultur Lain (Alternate Culture Yogurt) (Dengan Pemanasan Setelah Proses Fermentasi)",
    "Yogurt kultur lain adalah produk susu yang diperoleh dari fermentasi susu dengan menggunakan bakteri asam laktat Streptococcus thermophilus dan spesies Lactobacillus, dapat ditambahkan bakteri lain yang sesuai. Penamaan produk mengikuti ketentuan Standar Codex untuk Susu Fermentasi. Karakteristik dasar: \x{2022} Total padatan susu bukan-lemak tidak kurang dari 6,6%. \x{2022} Kadar protein susu tidak kurang dari 2,3%; \x{2022} Kadar asam laktat tidak kurang dari 0,5%",
    "Aktif",
  ],
  [
    "010201020005",
    "Kefir (Dengan Pemanasan Setelah Proses Fermentasi)",
    "Kefir adalah produk susu yang diperoleh dari fermentasi susu dengan menggunakan kultur starter yang dibuat dari biji kefir, Lactobacillus kefiri, spesies dari genus Leuconostoc, Lactococcus dan Acetobacter yang tumbuh saling sinergi. Biji kefir mengandung khamir yang mampu memfermentasi laktosa (Kluyveromyces marxianus) dan khamir yang tidak mampu memfermentasi laktosa (Saccharomyces unisporus, Saccharomyces cerevisiae dan Saccharomyces exiguus), dapat ditambahkan bakteri lain yang sesuai. Karakteristik dasar: \x{2022} Total padatan susu bukan-lemak tidak kurang dari 6,6%; \x{2022} Kadar protein susu tidak kurang dari 2,3%; \x{2022} Kadar asam laktat tidak kurang dari 0,6%",
    "Aktif",
  ],
  [
    "010201020006",
    "Kumys (Dengan Pemanasan Setelah Proses Fermentasi)",
    "Kumys adalah produk susu yang diperoleh dari fermentasi susu dengan menggunakan bakteri Lactobacillus delbrueckii subsp. bulgaricus dan Kluyveromyces marxianus, dapat ditambahkan bakteri lain yang sesuai. Karakteristik dasar: \x{2022} Total padatan susu bukan-lemak tidak kurang dari 6,6%; \x{2022} Kadar protein susu tidak kurang dari 2,3%; \x{2022} Kadar asam laktat tidak kurang dari 0,7%; \x{2022} Kadar etanol tidak kurang dari 0,5%. ",
    "Aktif",
  ],
  [
    "010201020007",
    "Susu Fermentasi atau Susu Berkultur (Cultured Milk) (Dengan Pemanasan Setelah Proses Fermentasi)",
    "Susu fermentasi atau susu berkultur (cultured milk) adalah produk susu yang dihasilkan dari fermentasi susu segar dengan atau tanpa pasteurisasi, susu rekonstitusi atau susu rekombinasi yang diperoleh dari fermentasi dengan bakteri asam laktat yang sesuai. Karakteristik dasar: \x{2022} Total padatan susu bukan-lemak tidak kurang dari 6,6%; \x{2022} Kadar protein susu tidak kurang dari 2,3%; \x{2022} Kadar asam laktat tidak kurang dari 0,5%.",
    "Aktif",
  ],
  [
    "010202000001",
    "Susu yang digumpalkan dengan rennet (Plain)",
    "Susu yang digumpalkan dengan rennet (Plain2) adalah susu yang digumpalkan dengan enzim penggumpal susu termasuk renin/rennet. Produk susu rennet berperisa termasuk kategori 01.7. Karakteristik dasar: Total padatan susu bukan-lemak tidak kurang dari 7,8%",
    "Aktif",
  ],
  [
    "010301000001",
    "Susu Evaporasi",
    "Susu evaporasi adalah produk susu cair yang diperoleh dengan cara menghilangkan sebagian air dari susu segar atau susu rekonstitusi atau susu rekombinasi, dengan menggunakan proses evaporasi atau proses lain sehingga diperoleh tingkat kepekatan tertentu. Karakteristik dasar: \x{2022} Kadar lemak susu tidak kurang dari 7,5%; \x{2022} Total padatan susu tidak kurang dari 25%; \x{2022} Kadar protein tidak kurang dari 5,5%",
    "Aktif",
  ],
  [
    "010301000002",
    "Susu Skim Evaporasi",
    "Susu skim evaporasi adalah produk susu cair yang diperoleh dengan cara menghilangkan sebagian air dari susu skim atau susu skim hasil rekonstitusi, dengan menggunakan proses evaporasi atau proses lain sehingga diperoleh tingkat kepekatan tertentu. Karakteristik dasar: \x{2022} Kadar lemak susu tidak lebih dari 1%; \x{2022} Total padatan susu tidak kurang dari 20%; \x{2022} Kadar protein tidak kurang dari 6%.",
    "Aktif",
  ],
  [
    "010301000003",
    "Susu Skim Sebagian Evaporasi",
    "Susu skim sebagian evaporasi adalah produk susu cair yang diperoleh dengan cara menghilangkan sebagian air dari susu skim sebagian atau susu skim sebagian hasil rekonstitusi, dengan menggunakan proses evaporasi atau proses lain sehingga diperoleh tingkat kepekatan tertentu. Karakteristik dasar: \x{2022} Kadar lemak susu lebih dari 1% dan kurang dari 7,5%; \x{2022} Total padatan susu tidak kurang dari 20%; \x{2022} Kadar protein antara 4% sampai 6%",
    "Aktif",
  ],
  [
    "010301000004",
    "Susu Kental Manis",
    "Susu kental manis adalah produk susu berbentuk cairan kental yang diperoleh dengan menghilangkan sebagian air dari campuran susu dan gula atau susu rekonstitusi dan gula, atau dengan proses lain sehingga mencapai tingkat kepekatan tertentu, dengan atau tanpa penambahan bahan lain. Gula yang ditambahkan harus dapat mencegah kerusakan produk. Karakteristik dasar: \x{2022} Kadar lemak susu tidak kurang dari 8%; \x{2022} Kadar protein tidak kurang dari 6,5%.",
    "Aktif",
  ],
  [
    "010301000005",
    "Susu Skim Kental Manis",
    "Susu skim kental manis adalah produk susu yang berbentuk cairan kental, yang diperoleh dengan menghilangkan sebagian air dari susu skim yang telah ditambahkan gula hingga mencapai kepekatan tertentu; atau merupakan hasil rekonstitusi susu skim bubuk dengan penambahan gula, dengan atau tanpa penambahan bahan lain. Gula yang ditambahkan harus dapat mencegah kerusakan produk. Karakteristik dasar: \x{2022} Kadar lemak susu tidak lebih dari 1%. \x{2022} Kadar protein susu tidak kurang dari 7%",
    "Aktif",
  ],
  [
    "010301000006",
    "Krim Kental Manis",
    "Krim kental manis adalah produk susu yang berbentuk cairan kental yang diperoleh dengan merekonstitusi krim dengan penambahan gula hingga mencapai kepekatan tertentu. Gula yang ditambahkan harus dapat mencegah kerusakan produk. Karakteristik dasar: \x{2022} Kadar lemak susu tidak kurang dari 45%; \x{2022} Total padatan tidak kurang dari 65%.",
    "Aktif",
  ],
  [
    "010301000007",
    "Khoa",
    "Khoa adalah produk susu yang diperoleh dari susu sapi atau kerbau yang dikentalkan dengan proses perebusan",
    "Aktif",
  ],
  [
    "010302000001",
    "Susu Lemak Nabati Evaporasi/ Susu Minyak Nabati Evaporasi",
    "Susu lemak nabati evaporasi / susu minyak nabati evaporasi adalah produk susu berbentuk cair yang diperoleh dengan cara menghilangkan sebagian air dari susu segar, susu rekombinasi, atau susu rekonstitusi yang lemaknya sebagian atau seluruhnya diganti dengan lemak nabati hingga diperoleh tingkat kepekatan tertentu. Karakteristik dasar: \x{2022} Kadar lemak tidak kurang dari 6%; \x{2022} Total padatan tidak kurang dari 23,5%",
    "Aktif",
  ],
  [
    "010302000002",
    "Susu Kental Manis Lemak Nabati/ Susu Kental Manis Minyak Nabati",
    "Susu kental manis lemak nabati / susu kental manis minyak nabati adalah produk susu berbentuk cairan kental yang diperoleh dari susu segar, susu rekombinasi, atau susu rekonstitusi yang lemaknya sebagian atau seluruhnya diganti dengan lemak nabati, dengan penambahan gula hingga mencapai kepekatan tertentu dengan atau tanpa penambahan bahan lain. Gula yang ditambahkan harus dapat mencegah kerusakan produk. Karakteristik dasar: \x{2022} Kadar lemak total tidak kurang dari 8%; \x{2022} Kadar protein total tidak kurang dari 2%",
    "Aktif",
  ],
  [
    "010302000003",
    "Krimer Kental Manis",
    "Krimer kental manis adalah produk susu yang berbentuk cairan kental, yang diperoleh dari susu yang telah ditambahkan gula dan lemak nabati yang kemudian sebagian air dihilangkan hingga mencapai kepekatan tertentu, atau merupakan hasil rekonstitusi susu bubuk dengan penambahan gula dan lemak nabati/minyak nabati dan bahan lain. Gula yang ditambahkan harus dapat mencegah kerusakan produk. Karakteristik dasar: \x{2022} Kadar protein tidak kurang dari 1%; \x{2022} Kadar lemak total tidak kurang dari 8%",
    "Aktif",
  ],
  [
    "010302000004",
    "Krimer Minuman ",
    "Krimer minuman adalah produk pengganti susu atau krim yang merupakan produk emulsi lemak dalam air, yang dibuat dari minyak nabati yang dihidrogenasi. Produk dapat berupa cairan atau bubuk dan digunakan untuk minuman seperti kopi dan teh. Karakteristik dasar: \x{2022} Produk cair: mengandung lemak tidak kurang dari 3,25% dan total padatan tidak lebih dari 8,25%; \x{2022} Produk bubuk: mengandung lemak tidak kurang dari 26% dan kadar air tidak lebih dari 5%",
    "Aktif",
  ],
  [
    "010400000001",
    "Krim",
    "Krim adalah produk susu kaya lemak susu yang diperoleh dengan proses pemisahan yang memisahkan lemak susu dari komponen susu lainnya. Karakteristik dasar: Kadar lemak susu tidak kurang dari 35%",
    "Aktif",
  ],
  [
    "010401000001",
    "Krim Pasteurisasi (Plain)",
    "Krim pasteurisasi (plain2) adalah krim yang telah mengalami proses pemanasan untuk membunuh cemaran mikroba patogen. Karakteristik dasar: Kadar lemak susu tidak kurang dari 10%",
    "Aktif",
  ],
  [
    "010401000002",
    "Half and Half",
    "Half and half adalah produk susu yang terdiri dari campuran susu dan tidak kurang dari 10,5% krim, dengan kadar lemak susu tidak kurang dari 18%. Produk ini dipasteurisasi atau ultra pasteurisasi dan dapat dihomogenisasi, dengan atau tanpa penambahan gula. Karakteristik dasar: Kadar lemak susu tidak kurang dari 18% dan tidak lebih dari 34%",
    "Aktif",
  ],
  [
    "010402000001",
    "Krim sterilisasi",
    "Krim sterilisasi adalah krim yang telah mengalami proses sterilisasi untuk membunuh cemaran mikroba patogen. Karakteristik dasar: Kadar lemak susu tidak kurang dari 10%",
    "Aktif",
  ],
  [
    "010402000002",
    "Whipping cream",
    "Whipping cream adalah produk krim, krim rekonstitusi dan/atau krim kombinasi yang khusus digunakan untuk tujuan whipping. Karakteristik dasar: Kadar lemak susu tidak kurang dari 10%",
    "Aktif",
  ],
  [
    "010402000003",
    "Whipped Cream",
    "Whipped cream adalah produk krim, krim rekonstitusi dan/atau krim kombinasi yang disertai udara atau gas inert tanpa mempengaruhi lemak dalam emulsi susu skim. Karakteristik dasar: Kadar lemak susu tidak kurang dari 10%",
    "Aktif",
  ],
  [
    "010403000001",
    "Krim yang Digumpalkan Dengan Enzim",
    "Krim yang digumpalkan dengan enzim adalah krim yang digumpalkan dengan enzim rennet.",
    "Aktif",
  ],
  [
    "010403000002",
    "Krim Asam",
    "Krim asam adalah produk susu yang diperoleh dari proses pengasaman krim yang telah dipasteurisasi, dengan menggunakan bakteri asam laktat. Karakteristik dasar: Kadar lemak susu tidak kurang dari 10%",
    "Aktif",
  ],
  [
    "010403000003",
    "Krim yang Diasamkan",
    "Krim yang diasamkan adalah produk susu yang diperoleh dari proses pengasaman krim yang telah dipasteurisasi, dengan menggunakan asam yang sesuai, dengan atau tanpa penggunaan bakteri asam laktat. Karakteristik dasar: Kadar lemak susu tidak kurang dari 18%",
    "Aktif",
  ],
  [
    "010404000001",
    "Krim Nabati",
    "Krim nabati adalah produk pengganti krim yang merupakan emulsi lemak nabati dalam air. Karakteristik dasar: Kadar lemak tidak kurang dari 10%",
    "Aktif",
  ],
  [
    "010501000001",
    "Susu Bubuk Lemak Penuh (Full Cream)",
    "Susu bubuk lemak penuh (full cream) adalah produk susu berbentuk bubuk yang tidak dikurangi lemaknya, yang diperoleh dari susu cair; atau susu hasil pencampuran susu cair dengan susu kental atau krim bubuk; atau susu hasil pencampuran susu cair dengan susu kental atau susu bubuk, yang telah dipasteurisasi dan melalui proses pengeringan. Nama jenis untuk produk ini susu bubuk full cream. Karakteristik dasar: \x{2022} Kadar lemak susu tidak kurang dari 26%; \x{2022} Kadar air tidak lebih dari 5%; \x{2022} Kadar protein tidak kurang 32% dari padatan susu bukanlemak. ",
    "Aktif",
  ],
  [
    "010501000002",
    "Susu Bubuk Lemak Penuh (Full Cream) Instan",
    "Susu bubuk lemak penuh (full cream) instan adalah susu bubuk yang tidak dikurangi lemaknya, yang mengalami proses instanisasi. Nama jenis untuk produk ini susu bubuk full cream instan. Karakteristik dasar: \x{2022} Kadar lemak susu tidak kurang dari 26%; \x{2022} Kadar air tidak lebih dari 5%; \x{2022} Kadar protein tidak kurang 32% dari padatan susu bukanlemak.",
    "Aktif",
  ],
  [
    "010501000003",
    "Susu Bubuk Skim Sebagian",
    "Susu bubuk skim sebagian adalah produk susu berbentuk bubuk yang diperoleh dengan proses pengeringan susu yang sebelumnya telah dipisahkan sebagian lemak susunya dengan alat pemisah krim (cream separator) atau susu hasil pencampuran susu cair dengan susu kental atau susu skim bubuk. Karakteristik dasar: \x{2022} Kadar lemak susu lebih dari 1,5% dan kurang dari 26%; \x{2022} Kadar air tidak lebih dari 5%; \x{2022} Kadar protein tidak kurang 32% dari padatan susu bukanlemak. ",
    "Aktif",
  ],
  [
    "010501000004",
    "Susu Bubuk Skim",
    "Susu bubuk skim adalah produk susu berbentuk bubuk yang diperoleh dengan proses pengeringan susu skim pasteurisasi. Karakteristik dasar: \x{2022} Kadar lemak susu tidak lebih dari 1,5%; \x{2022} Kadar air tidak lebih dari 5% \x{2022} Kadar protein tidak kurang 32% dari padatan susu bukan lemak.",
    "Aktif",
  ],
  [
    "010501000005",
    "Campuran Susu dan Krim Bubuk (Plain)",
    "Campuran susu dan krim bubuk (plain2) adalah produk susu berbentuk bubuk yang diperoleh dengan proses pengeringan susu yang telah dipasteurisasi; atau susu hasil pencampuran susu cair dengan susu kental atau krim bubuk; atau susu hasil pencampuran susu cair dengan susu kental atau susu bubuk; atau rekombinasi susu bubuk dan krim bubuk. Karakteristik dasar: \x{2022} Kadar lemak susu tidak kurang dari 26%; \x{2022} Kadar air tidak lebih dari 5%",
    "Aktif",
  ],
  [
    "010501000006",
    "Krim Bubuk",
    "Krim bubuk adalah produk susu berbentuk bubuk yang diperoleh dengan menghilangkan sebagian besar air dari krim susu melalui proses pengeringan. Karakteristik dasar: \x{2022} Kadar lemak susu tidak kurang dari 42%; \x{2022} Kadar air tidak lebih dari 5%; \x{2022} Kadar protein tidak kurang 32% dari padatan susu bukan lemak. ",
    "Aktif",
  ],
  [
    "010501000007",
    "Bubuk Buttermilk",
    "Bubuk buttermilk adalah produk susu yang diperoleh dari krim yang telah dipisahkan lemaknya, kemudian dikeringkan. ",
    "Aktif",
  ],
  [
    "010501000008",
    "Minuman Mengandung Susu Bubuk (Plain)",
    "Minuman mengandung susu bubuk (plain2) adalah minuman yang dibuat dengan menggunakan susu, susu rekonstitusi atau susu rekombinasi, dapat ditambahkan gula. Karakteristik dasar: \x{2022} Kadar lemak susu tidak kurang dari 2,6%; \x{2022} Kadar air tidak lebih dari 5%; \x{2022} Kadar protein tidak kurang 3,2% dari padatan susu bukan lemak.",
    "Aktif",
  ],
  [
    "010502000001",
    "Susu Bubuk Lemak Nabati/Susu Bubuk Minyak Nabati",
    "Susu bubuk lemak nabati/susu bubuk minyak nabati adalah produk susu berbentuk bubuk yang sebagian lemaknya telah dihilangkan dan digantikan dengan minyak nabati/lemak nabati dalam jumlah yang setara.",
    "Aktif",
  ],
  [
    "010600000001",
    "Keju",
    "Keju adalah produk segar atau hasil pemeraman berbentuk padat atau semi padat yang diperoleh dengan cara menggumpalkan susu, krim, susu skim, susu skim sebagian, susu rekombinasi, susu rekonstitusi, whey krim atau buttermilk, atau campurannya, dengan rennet atau enzim penggumpal (asal hewan, tanaman atau mikroba) atau asam dengan persyaratan kadar lemak susu dan kadar air yang tergantung dari jenisnya dengan atau tanpa penambahan bahan pangan lain. Termasuk keju lunak, keju agak keras (semi-hard) dan keju keras (hard) serta sangat keras (very hard). Keju lunak mengandung air lebih dari 67% dihitung berdasarkan padatan tanpa lemak (PTL). Keju agak keras mengandung 54% hingga 69% PTL, keju keras mengandung 49% hingga 56% PTL, dan keju sangat keras mengandung kurang dari 51% PTL",
    "Aktif",
  ],
  [
    "010600000002",
    "Analog Keju",
    "Analog keju adalah produk keju yang sebagian atau seluruh lemak susunya digantikan dengan lemak lain.",
    "Aktif",
  ],
  [
    "010601000001",
    "Keju Cottage (Cottage Cheese)",
    "Keju cottage (cottage cheese) adalah keju lunak tanpa pemeraman yang dibuat dari susu segar atau susu segar yang dihilangkan lemaknya atau susu rekombinasi  Karakteristik dasar: Padatan susu bukan-lemak tidak kurang dari 18%",
    "Aktif",
  ],
  [
    "010601000002",
    "Keju Cottage yang Ditambah Krim (Creamed Cottage Cheese)",
    "Keju cottage yang ditambah krim (creamed cottage cheese) adalah keju cottage yang ditambah krim (creamed cottage cheese) adalah keju lunak tanpa pemeraman yang dibuat dari susu segar atau susu segar yang dihilangkan lemaknya atau susu rekombinasi dan ditambahkan krim. ",
    "Aktif",
  ],
  [
    "010601000003",
    "Keju Krim (Cream Cheese)",
    "Keju krim (cream cheese) adalah keju lunak tanpa pemeraman yang dibuat dari krim atau susu yang ditambah dengan krim dengan penambahan kultur bakteri asam laktat dan enzim penggumpal (rennet, atau enzim penggumpal lainnya). Karakteristik dasar: \x{2022} Lemak susu dari total padatan tidak kurang dari 25%; \x{2022} Kadar air terhadap bahan tanpa lemak tidak kurang dari 67%; \x{2022} Total padatan tidak kurang dari 22%",
    "Aktif",
  ],
  [
    "010601000004",
    "Keju Mozzarella",
    "Keju mozzarella adalah keju tanpa pemeraman bertekstur lunak atau semi keras/keras yang dibuat dari susu dan/atau produk susu dengan atau tanpa penggunaan starter Lactobacillus bulgaricus dan/atau Streptococcus thermophilus dan/atau bakteri asam laktat lainnya yang sesuai, dengan atau tanpa bakteri penghasil rasa, digumpalkan dengan penggunaan rennet atau enzim koagulasi lainnya, melalui proses pasta filata atau teknik pemrosesan lain yang sesuai, dengan/atau tanpa penambahan bahan pangan lain. Proses pasta filata adalah proses yang terdiri dari memanaskan dadih dengan nilai pH yang sesuai (4,5-5,8), diaduk dan direntangkan sampai dadih halus dan bebas dari gumpalan, dalam keadaan hangat dadih dipotong dan dicetak, kemudian dikencangkan dengan pendinginan Karakteristik dasar: Lemak susu dihitung terhadap bahan kering tidak kurang dari 20% (dengan kelembaban tinggi), tidak kurang dari 18% (dengan kelembaban rendah). ",
    "Aktif",
  ],
  [
    "010601000005",
    "Keju Bocconcini",
    "Keju bocconcini adalah keju lunak, segar, yang tidak mudah putus (stretch curd), plastis, dengan rasa sedikit ringan dan aroma segar",
    "Aktif",
  ],
  [
    "010601000006",
    "Keju Tanpa Pemeraman (Keju Mentah)",
    "Keju tanpa pemeraman (keju mentah) adalah keju yang tidak diperam (dimatangkan) yang siap santap",
    "Aktif",
  ],
  [
    "010602010001",
    "Keju Cheddar",
    "Keju cheddar adalah keju keras yang dibuat dari susu sapi dengan pemeraman pada suhu tidak kurang dari 35\\xBAC dan waktu tidak kurang dari 60 hari. Keju cheddar dapat juga diproses pada suhu dan lama pemeraman yang berbeda, tergantung dari teknologi yang dipakai. Karakteristik dasar: Lemak susu dihitung terhadap bahan kering tidak kurang dari 22%.",
    "Aktif",
  ],
  [
    "010602010002",
    "Keju Edam",
    "Keju edam adalah keju semi keras khas Belanda. Keju edam juga dibuat di berbagai negara. Tekstur keju ini elastis, liat, lebih lembut dari keju gouda. Lubang gasnya (gas holes) sedikit. Karakteristik dasar: Lemak susu dihitung terhadap bahan kering tidak kurang dari 30%",
    "Aktif",
  ],
  [
    "010602010003",
    "Keju Camembert",
    "Keju camembert adalah keju lunak yang diperam dengan kapang Penicillium candidum, dan/atau Penicillium camembertii dan Penicillium caseicolum. Karakteristik dasar: Lemak susu dihitung terhadap bahan kering tidak kurang dari 30%",
    "Aktif",
  ],
  [
    "010602010004",
    "Keju Bath",
    "Keju bath adalah keju lunak khas Inggris. Keju ini dibuat dari susu sapi yang tidak dipasteurisasi",
    "Aktif",
  ],
  [
    "010602010005",
    "Keju Bondard",
    "Keju bondard adalah keju khas Perancis. Keju ini dibuat dari susu sapi yang tidak dipasteurisasi. ",
    "Aktif",
  ],
  [
    "010602010006",
    "Keju Bougon",
    "Keju bougon adalah keju lunak khas Perancis. Keju ini dibuat dari susu kambing",
    "Aktif",
  ],
  [
    "010602010007",
    "Keju Bouquet des moines",
    "Keju bouquet des moines adalah keju khas Belgia. Dibuat dari susu sapi",
    "Aktif",
  ],
  [
    "010602010008",
    "Keju Biru (Blue Cheese)",
    "Keju biru (blue cheese) adalah keju keras yang dibuat dengan starter Lactobacillus lactis subsp. lactis biovar diacetylactis dan cremoris, diperam dengan Penicillium roqueforti tidak kurang dari 60 hari, ditandai dengan adanya kapang hijau kebiruan di seluruh bagian keju. Keju biru dapat juga diproses pada suhu dan lama pemeraman yang berbeda, tergantung dari teknologi yang dipakai.",
    "Aktif",
  ],
  [
    "010602010009",
    "Keju Bata (Brick Cheese)",
    "Keju bata (brick cheese) adalah keju keras yang diperoleh dari susu dan ingredien lainnya, jika dibuat dari susu segar maka pemeraman dilakukan pada suhu tidak kurang dari 1,7\\xBAC dan waktu tidak kurang dari 60 hari. Keju bata dapat juga diproses pada suhu dan lama pemeraman yang berbeda, tergantung dari teknologi yang dipakai.",
    "Aktif",
  ],
  [
    "010602010010",
    "Keju Gouda",
    "Keju gouda adalah keju khas Belanda, yang dibuat dengan starter bakteri asam laktat yang sesuai, tergolong keju agak keras (semi hard) dengan kulit keras dan dilapis lilin atau bahan lainnya. Karakteristik dasar: Lemak susu dihitung terhadap bahan kering tidak kurang dari 30%",
    "Aktif",
  ],
  [
    "010602010011",
    "Keju Havarti",
    "Keju havarti adalah keju khas Denmark yang tergolong keju agak keras (semi hard), dengan atau tanpa kulit hasil pengentalan bakteri asam laktat, rennet atau penggumpal lainnya dan difermentasi dengan bakteri asam laktat dan kapang dengan penambahan garam. Karakteristik dasar: Lemak susu dihitung terhadap bahan kering tidak kurang dari 30%",
    "Aktif",
  ],
  [
    "010602010012",
    "Keju Brie",
    "Keju brie adalah keju yang dihasilkan dengan starter Lactobacillus lactis subsp. lactis dan cremoris, dan diperam dengan Penicillium caseicolum atau kapang, kamir, bakteri lain yang sesuai. Karakteristik dasar: Lemak susu dihitung terhadap bahan kering tidak kurang dari 40%",
    "Aktif",
  ],
  [
    "010602010013",
    "Keju Parmesan",
    "Keju parmesan adalah keju khas Italia (Parma) yang diperoleh dari susu yang dipanaskan dan digumpalkan sebelum semua krim dipisahkan. Gumpalan dipotong dan dipanaskan pada suhu 52\\xBAC, dimasak sampai suhu 55\\xBAC, dibentuk lalu diperam dalam air garam. Keju parmesan dapat juga diproses pada suhu dan lama pemeraman yang berbeda, tergantung dari teknologi yang dipakai.",
    "Aktif",
  ],
  [
    "010602010014",
    "Keju Swiss",
    "Keju swiss adalah keju dengan kulit keras dan berlubang-lubang di bagian dalamnya karena gas yang terbentuk selama pemeraman. ",
    "Aktif",
  ],
  [
    "010602010015",
    "Keju Peram Lainnya",
    "Keju peram lainnya adalah keju peram yang tidak termasuk keju peram di atas, misalnya keju feta.",
    "Aktif",
  ],
  [
    "010602020001",
    "Kulit Keju Peram",
    "Kulit keju peram adalah kulit keju yang telah mengalami proses pemeraman dan perendaman dalam larutan garam. Kulit keju adalah bagian terluar dari keju yang dapat saja memiliki komposisi yang sama dari bagian dalam keju, namun dapat kering setelah proses pemeraman dan perendaman dalam larutan garam. Beberapa jenis keju menggunakan pelapis lilin untuk kulit yang mungkin ditambah pewarna yang diizinkan untuk melindungi keju",
    "Aktif",
  ],
  [
    "010602030001",
    "Keju Bubuk (Untuk Rekonstitusi Contohnya Dalam Pembuatan Saus Keju)",
    "Keju bubuk adalah hasil pengeringan dari aneka jenis keju olahan. Keju bubuk direkonstitusi dengan air atau susu untuk pembuatan saus, atau digunakan sebagai ingredien (misalnya untuk makaroni dan keju), termasuk keju yang diproses dengan pengering semprot",
    "Aktif",
  ],
  [
    "010603000001",
    "Keju Whey",
    "Keju whey adalah produk padat atau semipadat yang diperoleh dari pemekatan whey dengan atau tanpa penambahan susu, krim susu atau komponen susu lainnya dan dibentuk. Termasuk didalamnya adalah keju whey berkrim, keju whey, dan keju whey berskim",
    "Aktif",
  ],
  [
    "010604000001",
    "Keju Olahan",
    "Produk diperoleh dengan melelehkan dan mengemulsi keju. Termasuk produk yang dibuat dengan pemanasan dan mengemulsi campuran keju, lemak susu, protein susu, susu bubuk, dan air dalam jumlah berbeda. Produk dapat mengandung bahan pangan lain seperti perisa, bumbu, buah, sayur, dan/atau daging. Produk dapat berbentuk oles, lembaran, dan potongan. Istilah \x{201C}olahan\x{201D} tidak berarti memotong, memarut keju, atau lainnya. Keju dengan perlakuan fisik tersebut termasuk dalam kategori pangan 01.6.2 Keju Peram. Contoh produk meliputi keju cheddar olahan, keju gouda olahan",
    "Aktif",
  ],
  [
    "010604010001",
    "Keju Olahan Plain",
    "Keju olahan plain adalah produk olahan keju tanpa penambahan perisa, bumbu, buah, sayur atau daging. Contoh meliputi American cheese, requeson",
    "Aktif",
  ],
  [
    "010604020001",
    "Keju Olahan Berperisa, Keju Olahan dengan Tambahan Buah, Sayur dan atau Daging",
    "Keju olahan berperisa adalah produk olahan keju yang ditambahkan perisa, bumbu, buah, sayur dan/atau daging. Contoh meliputi neufchatel cheese spread dengan sayur, pepper jack cheese, cheddar cheese spread dengan wine, dan cheese balls (keju olahan salut kacang, herba atau bumbu).",
    "Aktif",
  ],
  [
    "010605000001",
    "Analog Keju (Keju lemak nabati)",
    "Keju analog adalah produk serupa keju yang sebagian atau seluruh lemak susunya digantikan dengan lemak lain. Termasuk didalamnya adalah keju analog, campuran keju analog dan bubuk keju analog",
    "Aktif",
  ],
  [
    "010606000001",
    "Keju Protein Whey",
    "Keju protein whey adalah keju yang dibuat dari protein yang diekstrak dari whey. Produk ini pada prinsipnya dibuat dari koagulasi protein whey. Contohnya adalah keju ricotta. Tidak sama dengan keju whey (kategori pangan 01.6.3)",
    "Aktif",
  ],
  [
    "010700000001",
    "Es Krim Susu (Dairy Ice Cream)",
    "Es krim susu (Dairy Ice Cream) adalah produk beku yang diperoleh dari susu atau produk susu atau campurannya, tanpa penambahan lemak selain lemak susu, dengan atau tanpa penambahan bahan pangan lain. Karakteristik dasar: \x{2022} Kadar protein susu tidak kurang dari 2,7%; \x{2022} Kadar lemak susu tidak kurang dari 5%; \x{2022} Total padatan tidak kurang dari 31%. ",
    "Aktif",
  ],
  [
    "010700000002",
    "Es Krim",
    "Es krim adalah produk beku yang diperoleh dari susu atau produk susu atau campurannya yang sebagian lemak susu diganti dengan lemak nabati, dengan atau tanpa penambahan bahan pangan lain. Karakteristik dasar: \x{2022} Kadar lemak total tidak kurang dari 5%; \x{2022} Total padatan susu tidak kurang dari 5%; \x{2022} Total padatan tidak kurang dari 31%",
    "Aktif",
  ],
  [
    "010700000003",
    "Es Susu",
    "Es susu adalah produk beku yang dibuat dari campuran susu dan/atau produk susu dengan air, dengan atau tanpa penambahan bahan pangan lain. Karakteristik dasar: Kadar protein susu tidak kurang dari 1%",
    "Aktif",
  ],
  [
    "010700000004",
    "Premiks Es Krim",
    "Premiks es krim adalah produk berbentuk bubuk atau cair dengan bahan dasar susu atau produk susu atau campurannya dengan atau tanpa penambahan bahan pangan lain yang dapat ditambahkan air sebelum diolah lebih lanjut menjadi es krim. Karakteristik dasar: Bentuk Bubuk \x{2022} Kadar lemak total tidak kurang dari 15%; \x{2022} Total padatan susu tidak kurang dari 15%; \x{2022} Kadar air tidak lebih dari 5%.  Bentuk Cair \x{2022} Kadar lemak total tidak kurang dari 5%; \x{2022} Total padatan susu tidak kurang dari 5%; \x{2022} Total padatan tidak kurang dari 31%",
    "Aktif",
  ],
  [
    "010700000005",
    "Premiks Es Susu",
    "Premiks es susu adalah produk berbentuk bubuk atau cair dengan bahan dasar susu atau produk susu atau campurannya dengan atau tanpa penambahan bahan pangan lain yang dapat ditambahkan air sebelum diolah lebih lanjut menjadi es susu. Karakteristik dasar: Bentuk Bubuk Kadar protein susu tidak kurang dari 3%. Bentuk Cair Kadar protein susu tidak kurang dari 1%.",
    "Aktif",
  ],
  [
    "010700000006",
    "Yogurt Berperisa/Rasa",
    "Yogurt berperisa/rasa adalah produk susu yang diperoleh dari fermentasi susu dengan menggunakan bakteri asam laktat Lactobacillus bulgaricus dan Streptococcus thermophilus, dapat ditambahkan bakteri lain yang sesuai, dengan penambahan perisa/rasa. Karakteristik dasar: \x{2022} Total padatan susu bukan-lemak tidak kurang dari 4,6%; \x{2022} Kadar protein susu tidak kurang dari 1,6%; \x{2022} Kadar asam laktat tidak kurang dari 0,5%",
    "Aktif",
  ],
  [
    "010700000007",
    "Yogurt Kultur Lain (Alternate Culture Yogurt)",
    "Yogurt kultur lain adalah produk susu yang diperoleh dari fermentasi susu dengan menggunakan bakteri asam laktat Streptococcus thermophilus dan spesies Lactobacillus, dapat ditambahkan bakteri lain yang sesuai. Penamaan produk mengikuti ketentuan Standar Codex untuk Susu Fermentasi, dengan penambahan perisa/rasa. Karakteristik dasar: \x{2022} Total padatan susu bukan-lemak tidak kurang dari 4,6%; \x{2022} Kadar protein susu tidak kurang dari 1,6%; \x{2022} Kadar asam laktat tidak kurang dari 0,5%",
    "Aktif",
  ],
  [
    "010700000008",
    "Kefir",
    "Kefir adalah produk susu yang diperoleh dari fermentasi susu dengan menggunakan kultur starter yang dibuat dari biji kefir, Lactobacillus kefiri, spesies dari genus Leuconostoc, Lactococcus dan Acetobacter yang tumbuh saling sinergi. Biji kefir mengandung khamir yang mampu memfermentasi laktosa (Kluyveromyces marxianus) dan khamir yang tidak mampu memfermentasi laktosa (Saccharomyces unisporus, Saccharomyces cerevisiaem, dan Saccharomyces exiguus), dapat ditambahkan bakteri lain yang sesuai, dengan penambahan perisa/rasa. Karakteristik dasar: \x{2022} Total padatan susu bukan-lemak tidak kurang dari 4,6%; \x{2022} Kadar protein susu tidak kurang dari 1,6%; \x{2022} Kadar asam laktat tidak kurang dari 0,6%",
    "Aktif",
  ],
  [
    "010700000009",
    "Susu Fermentasi atau Susu Berkultur Berperisa/Rasa",
    "Susu fermentasi atau susu berkultur berperisa/rasa adalah produk susu yang dihasilkan dari fermentasi susu segar dengan atau tanpa pasteurisasi, susu rekonstitusi atau susu rekombinasi yang diperoleh dari fermentasi dengan mikroba yang sesuai, dengan penambahan perisa/rasa. Karakteristik dasar: \x{2022} Total padatan susu bukan-lemak tidak kurang dari 4,6%; \x{2022} Kadar protein susu tidak kurang dari 1,6%; \x{2022} Kadar asam laktat tidak kurang dari 0,5%.",
    "Aktif",
  ],
  [
    "010700000010",
    "Junket",
    "Junket adalah makanan pencuci mulut seperti custard manis yang dibuat dari susu berperisa yang digumpalkan dengan rennet.",
    "Aktif",
  ],
  [
    "010700000011",
    "Dulce de leche",
    "Dulce de leche adalah susu yang telah dimasak dengan gula dan bahan pangan lain seperti kelapa atau cokelat.",
    "Aktif",
  ],
  [
    "010700000012",
    "Puding Butterscotch/Puding Susu",
    "Puding butterscotch/puding susu adalah makanan pencuci mulut berbentuk padat lunak yang terbuat dari susu segar atau produk susu atau campurannya yang ditambah dengan pati atau bahan pembentuk gel dengan atau tanpa penambahan bahan pangan lain. Karakteristik dasar: \x{2022} Total kadar lemak susu tidak kurang dari 1.5%; \x{2022} Kadar padatan susu bukan-lemak tidak kurang dari 3.9%; \x{2022} Kadar protein susu tidak kurang dari 1.4%",
    "Aktif",
  ],
  [
    "010700000013",
    "Bubuk Puding Butterscotch/Puding Susu",
    "Bubuk puding butterscotch/puding susu adalah makanan pencuci mulut berbentuk bubuk yang terbuat dari susu segar atau produk susu atau campurannya yang ditambah dengan pati atau bahan pembentuk gel dengan atau tanpa penambahan bahan pangan lain dan harus ditambahkan air sebelum diolah lebih lanjut menjadi puding. Karakteristik dasar: Kandungan padatan susu dan atau turunannya tidak kurang dari 5%.",
    "Aktif",
  ],
  [
    "010700000014",
    "Kembang Gula / Permen Susu",
    "Kandungan susu tidak kurang dari 5%.",
    "Aktif",
  ],
  [
    "010700000015",
    "Makanan pencuci mulut berbasis susu",
    "Makanan pencuci mulut berbasis susu adalah makanan pencuci mulut berbentuk semi padat terbuat dari susu segar atau produk susu atau campurannya yang ditambah dengan pati atau bahan pembentuk gel dengan atau tanpa penambahan bahan pangan lain. Karakteristik dasar: Kandungan susu dan atau produk susu tidak kurang dari 30%",
    "Aktif",
  ],
  [
    "010801000001",
    "Whey",
    "Whey adalah cairan yang dipisahkan dari susu setelah penggumpalan susu, krim, susu skim atau buttermilk dengan rennet atau enzim lainnya dalam pembuatan keju, kasein dan produk lain yang sejenis",
    "Aktif",
  ],
  [
    "010801000002",
    "Whey Asam",
    "Whey asam adalah cairan yang dipisahkan setelah penggumpalan susu dengan asam, khususnya dalam pembuatan keju mentah (tanpa pemeraman). ",
    "Aktif",
  ],
  [
    "010802000001",
    "Bubuk Whey",
    "Bubuk whey adalah produk whey yang diperoleh dari pengeringan (baik oleh pengering semprot atau drum) whey atau whey asam yang sebagian besar lemaknya telah diambil. ",
    "Aktif",
  ],
  [
    "010802000002",
    "Bubuk Whey yang Telah Didemineralisasi",
    "Bubuk whey yang telah didemineralisasi adalah produk whey yang diperoleh dari pengeringan (baik pengering semprot atau drum) whey atau whey asam yang sebagian besar lemaknya telah diambil dan telah dilakukan pengurangan pada kandungan mineralnya sesuai dengan kebutuhan.",
    "Aktif",
  ],
  [
    "010802000003",
    "Bubuk Whey Permeate",
    "Bubuk whey permeate adalah produk whey yang diperoleh dari pengeringan whey yang telah dipisahkan proteinnya.",
    "Aktif",
  ],
  [
    "020101000001",
    "Lemak Susu Anhidrat (AMF), Minyak Mentega (butter oil)",
    "Lemak susu anhidrat (AMF), minyak mentega (butter oil) adalah produk lemak dan minyak yang diperoleh secara khusus dari susu, krim, atau mentega melalui proses pengolahan untuk menghilangkan air dan padatan bukan-lemak sampai hampir sempurna. Karakteristik dasar : \x{2022} Lemak susu anhidrat : Kadar lemak susu tidak kurang dari 99,8%; \x{2022} Minyak mentega anhidrat : Kadar lemak susu tidak kurang dari 99,8%; \x{2022} Minyak mentega : Kadar lemak susu tidak kurang dari 99,3%",
    "Aktif",
  ],
  [
    "020101000002",
    "Ghee",
    "Ghee adalah produk khusus dari susu, krim atau mentega yang diperoleh melalui proses pengolahan untuk menghilangkan air dan padatan bukan-lemak sampai hampir sempurna, serta mempunyai aroma dan tekstur yang khas. Karakteristik dasar : \x{2022} Kadar air tidak lebih dari 0,1%; \x{2022} Kadar asam lemak bebas (sebagai asam oleat) tidak lebih dari 0,4%",
    "Aktif",
  ],
  [
    "020102000001",
    "Lemak dan Minyak Nabati",
    "Lemak dan minyak nabati adalah lemak dan minyak yang diperoleh dari tanaman. Produk lemak dan minyak ini dapat berasal dari sumber tunggal atau campuran, dan dipasarkan dengan istilah minyak makan, minyak masak atau minyak sayur, minyak goreng, minyak meja atau minyak salad, minyak nabati dan lemak nabati. Karakteristik dasar : \x{2022} Lemak dan Minyak yang telah dimurnikan/rafinasi (refined oil) a. Kadar air tidak lebih dari 0,15%; b. Kadar asam lemak bebas tidak lebih dari 0,3%; \x{2022} Minyak mentah (crude oil a. Kadar air tidak lebih dari 0,5%; b. Kadar asam lemak bebas tidak lebih dari 5%.",
    "Aktif",
  ],
  [
    "020102000002",
    "Virgin Oil ",
    "Virgin oil adalah produk minyak yang diperoleh secara mekanis (contohnya dengan pengepresan atau dikempa) tanpa pemanasan atau dengan pemanasan api kecil pada suhu kurang dari 60\xB0C dan tanpa penggunaan bahan kimia. Minyak dapat dimurnikan dengan pencucian menggunakan air, pengendapan, penyaringan dan atau sentrifugasi. Virgin oil dapat berasal dari berbagai bahan (zaitun, kelapa, wijen, dan lain-lain), contoh Virgin Coconut Oil (VCO). Karakteristik dasar : \x{2022} Bilangan peroksida tidak lebih dari 10 mek O2/kg; \x{2022} Lihat tabel komposisi asam lemak minyak nabati sesuai asalnya",
    "Aktif",
  ],
  [
    "020102000003",
    "Extra Virgin Olive Oil",
    "Extra virgin olive oil adalah virgin olive oil dengan kadar asam lemak bebas sebagai asam oleat tidak lebih dari 0,8 gram per 100 gram.",
    "Aktif",
  ],
  [
    "020102000004",
    "Virgin Olive Oil",
    "Virgin olive oil adalah virgin olive oil dengan kadar asam lemak bebas sebagai asam oleat tidak lebih dari 2 gram per 100 gram. ",
    "Aktif",
  ],
  [
    "020102000005",
    "Ordinary Virgin Olive Oil",
    "Ordinary virgin olive oil adalah virgin olive oil dengan kadar asam lemak bebas sebagai asam oleat tidak lebih dari 3,3 gram per 100 gram.",
    "Aktif",
  ],
  [
    "020102000006",
    "Cold Pressed Oils",
    "Cold pressed oils adalah produk minyak yang diperoleh secara mekanis tanpa pemanasan. Minyak dapat dimurnikan dengan pencucian menggunakan air, pengendapan, penyaringan dan atau sentrifugasi. Contoh : minyak zaitun, minyak biji kapas, minyak kacang tanah, minyak kelapa, dan minyak inti sawit. ",
    "Aktif",
  ],
  [
    "020102000007",
    "Minyak Goreng (Frying oil) ",
    "Minyak Goreng (Frying oil) adalah bahan pangan dengan komposisi utama trigliserida berasal dari bahan nabati kecuali kelapa sawit, dengan atau tanpa perubahan kimiawi, termasuk hidrogenasi, pendinginan dan telah melalui proses rafinasi/pemurnian yang digunakan untuk menggoreng. Karakteristik dasar : \x{2022} Kadar air tidak lebih dari 0,15%; \x{2022} Bilangan asam tidak lebih dari 0,6%; \x{2022} Bilangan peroksida tidak lebih dari 10 mek O2/kg; \x{2022} Kadar asam lemak linolenat tidak lebih dari 2% \x{2022} Kadar asam lemak trans 0%",
    "Aktif",
  ],
  [
    "020102000008",
    "Minyak Goreng Padat (Frying Fat)",
    "Minyak goreng padat adalah minyak goreng yang dalam suhu ruang berbentuk padat atau semi padat atau semi liquid yang berasal dari minyak sawit dan atau dicampur dengan minyak nabati lainnya, dengan atau tanpa perubahan kimiawi, hidrogenasi penuh, pendinginan dan telah melalui proses pemurnian. Karakteristik dasar : \x{2022} Kadar air tidak lebih dari 0,1%; \x{2022} Kadar asam lemak bebas sebagai asam palmitat tidak lebih dari 0.3%; \x{2022} Bilangan peroksida tidak lebih dari 10 mek O2/kg; \x{2022} Kadar asam lemak trans 0%",
    "Aktif",
  ],
  [
    "020102000009",
    "Minyak Masak atau Minyak Sayur (Cooking Oil)",
    "Minyak masak atau minyak sayur (cooking oil) adalah minyak yang digunakan untuk memasak (seperti menumis atau shallow frying/stir-fry/pan frying), diperoleh dari proses rafinasi/ pemurnian minyak nabati, dapat berasal dari sumber tunggal atau campuran. Karakteristik dasar : \x{2022} Kadar air tidak lebih dari 0,15%; \x{2022} Kadar asam lemak bebas tidak lebih dari 0,3%; \x{2022} Bilangan peroksida tidak lebih dari 10 mek O2/k",
    "Aktif",
  ],
  [
    "020102000010",
    "Minyak Salad (Salad Oil)",
    "Minyak salad adalah minyak yang diperoleh dari proses rafinasi/pemurnian (refining/purifying) minyak nabati, digunakan untuk pembuatan mayonais, salad dressing dan saus. Karakteristik dasar : \x{2022} Cair pada temperatur ruang; \x{2022} Kadar air tidak lebih dari 0,15%; \x{2022} Kadar asam lemak bebas tidak lebih dari 0,2%",
    "Aktif",
  ],
  [
    "020102000011",
    "Serbuk Lemak Nabati (Fat Powder)",
    "Serbuk lemak adalah produk lemak nabati yang berbentuk serbuk dengan atau tanpa penambahan bahan pengisi. Contoh : Serbuk Lemak Kelapa Sawit, Serbuk Lemak Kelapa Virgin, dan Serbuk Lemak Kelapa. ",
    "Aktif",
  ],
  [
    "020102000012",
    "Vanaspati atau Minyak Samin (Vegetable Ghee)",
    "Vanaspati atau minyak samin (vegetable ghee) adalah produk semi padat/padat yang diperoleh dari proses rafinasi/pemurnian minyak dan atau lemak nabati.  Karakteristik dasar: \x{2022} Kadar lemak nabati tidak kurang dari 97%; \x{2022} Tidak mengandung lemak atau minyak hewani; \x{2022} Titik leleh/lebur 30oC hingga 48\xB0C; \x{2022} Kadar air tidak lebih dari 0,25%; \x{2022} Kadar bahan tak tersabunkan tidak lebih dari 12,5 g/kg; \x{2022} Kadar asam lemak bebas (sebagai asam oleat) tidak lebih dari 0,5%.",
    "Aktif",
  ],
  [
    "020102000013",
    "Lemak Reroti (Shortening)",
    "Lemak reroti (shortening) adalah produk hasil olahan lemak/minyak nabati dengan atau tanpa penambahan lemak hewani dan atau lemak susu yang berbentuk semi padat/padat.  Karakteristik dasar : \x{2022} Kadar air tidak lebih dari 0,15%; \x{2022} Kadar asam lemak bebas (dihitung sebagai asam lemak dominan dari minyak nabati yang digunakan) tidak lebih dari 0,3%, yaitu : a. Jika berasal dari minyak sawit, asam lemak bebas dihitung sebagai asam palmitat; b. Jika berasal dari minyak kelapa atau minyak inti sawit, asam lemak bebas dihitung sebagai asam laurat; c. Jika berasal dari minyak nabati lainnya, asam lemak bebas dihitung sebagai asam oleat.",
    "Aktif",
  ],
  [
    "020102000014",
    "Pengganti Minyak Mentega (Butter Oil Substitute)",
    "Pengganti minyak mentega (butter oil substitute) adalah minyak nabati dengan atau tanpa penambahan lemak hewani dan atau lemak susu yang digunakan sebagai pengganti minyak mentega dengan sifat fisik dan rasa seperti mentega.  Karakteristik dasar : \x{2022} Kadar air tidak lebih dari 0,15%; \x{2022} Kadar asam lemak bebas (dihitung sebagai asam lemak dominan dari minyak nabati yang digunakan) tidak lebih dari 0,3%, yaitu : a. Jika berasal dari minyak sawit, asam lemak bebas dihitung sebagai asam palmitate; b. Jika berasal dari minyak kelapa atau minyak inti sawit, asam lemak bebas dihitung sebagai asam laurat; c. Jika berasal dari minyak nabati lainnya, asam lemak bebas dihitung sebagai asam oleat.",
    "Aktif",
  ],
  [
    "020102000015",
    "Minyak Inti Kelapa Sawit Mentah (Crude Palm Kernel Oil/CPKO)",
    "Minyak inti kelapa sawit mentah (CPKO) adalah minyak yang diperoleh dari proses pengempaan atau dengan ekstraksi pelarut dari minyak biji buah kelapa sawit.  Karakteristik dasar : \x{2022} Bilangan penyabunan 230 mg KOH/g hingga 254 mg KOH/g; \x{2022} Bilangan iod 14 Wijs hingga 21 Wijs;",
    "Aktif",
  ],
  [
    "020102000016",
    "Minyak Inti Kelapa Sawit (Refined Bleached Deodorized Palm Kernel Oil/RBDPKO)",
    "Minyak inti kelapa sawit (refined bleached deodorized palm kernel oil/RBDPKO) adalah minyak yang diperoleh dari proses rafinasi/pemurnian minyak inti kelapa sawit mentah.  Karakteristik dasar : \x{2022} Bilangan penyabunan 230 mg KOH/g hingga 254 mg KOH/g; \x{2022} Bilangan iod 14 Wijs hingga 21 Wijs; \x{2022} Bilangan peroksida tidak lebih dari 10 mek O2/kg; \x{2022} Komposisi asam lemak minyak inti kelapa sawit lihat pada table komposisi asam lemak.",
    "Aktif",
  ],
  [
    "020102000017",
    "Minyak Kelapa Sawit Mentah (Crude Palm Oil/CPO) atau Pretreated Palm Oil",
    "Minyak kelapa sawit mentah (crude palm oil/CPO) atau pretreated palm oil adalah minyak yang diperoleh dari proses pengempaan dari daging buah/sabut buah (mesocarp) tanaman kelapa sawit (Elaeis guineensis Jacq.)  Karakteristik dasar : \x{2022} Bilangan penyabunan 190 mg KOH/g hingga 209 mg KOH/g; \x{2022} Bilangan iod 50 Wijs hingga 55 Wijs; \x{2022} Titik leleh 33\xB0C hingga 39\xB0C.",
    "Aktif",
  ],
  [
    "020102000018",
    "Minyak Kelapa Sawit (Refined Bleached Deodorized Palm Oil/RBDPO)",
    "Minyak kelapa sawit adalah minyak yang diperoleh dari proses penghilangan gum (degumming), pemucatan (bleaching), dan deodorisasi minyak kelapa sawit mentah.  Karakteristik dasar: \x{2022} Kadar air dan kotoran tidak lebih dari 0.1%; \x{2022} Bilangan iod 50 - 55 g I2/100 g; \x{2022} Bilangan peroksida tidak lebih dari 10 mek O2/kg; \x{2022} Kadar asam lemak bebas dihitung sebagai asam palmitat tidak lebih dari 0.1%.",
    "Aktif",
  ],
  [
    "020102000019",
    "Minyak Olein Kelapa Sawit Mentah (Crude Palm Olein)",
    "Minyak olein kelapa sawit mentah adalah fraksi cair berwarna merah kekuningan yang diperoleh dari fraksinasi minyak kelapa sawit mentah (Crude Palm Oil/CPO).  Karakteristik dasar : \x{2022} Titik leleh/lebur tidak lebih dari 30\xB0C; \x{2022} Bilangan iod tidak kurang dari 56 Wijs.",
    "Aktif",
  ],
  [
    "020102000020",
    "Minyak Stearin Kelapa Sawit Mentah (Crude Palm Stearin)",
    "Minyak stearin kelapa sawit mentah adalah fraksi padat berwarna kuning kemerahan yang diperoleh dari fraksinasi minyak kelapa sawit mentah (Crude Palm Oil/CPO).  Karakteristik dasar : \x{2022} Titik leleh/lebur tidak kurang dari 44\xB0C; \x{2022} Bilangan iod tidak lebih dari 48 Wijs.",
    "Aktif",
  ],
  [
    "020102000021",
    "Minyak Olein Kelapa Sawit (Refined Bleached Deodorized Palm Olein)",
    "Minyak olein kelapa sawit adalah fraksi cair minyak kelapa sawit dari hasil proses penghilangan gum (degumming), pemucatan (bleaching), dan deodorisasi minyak olein kelapa sawit mentah (Crude Palm Olein/CPOL) atau fraksinasi minyak kelapa sawit yang sudah dimurnikan (RBD Palm Oil/RBDPO). Karakteristik dasar : \x{2022} Kadar air dan kotoran tidak lebih dari 0.1%; \x{2022} Bilangan iod tidak kurang dari 56 g I2/100 g; \x{2022} Bilangan peroksida tidak lebih dari 10 mek O2/kg; \x{2022} Kadar asam lemak bebas dihitung sebagai asam palmitat tidak lebih dari 0.1%; \x{2022} Komposisi asam lemak minyak olein kelapa sawit lihat pada tabel komposisi asam lemak.",
    "Aktif",
  ],
  [
    "020102000022",
    "Stearin Kelapa Sawit (Refined Bleached Deodorized Palm Stearin/RBDPS)",
    "Stearin kelapa sawit adalah fraksi padat minyak kelapa sawit dari hasil proses penghilangan gum (degumming), pemucatan (bleaching), dan deodorisasi minyak stearin kelapa sawit mentah (Crude Palm Stearin/CPS) atau fraksinasi minyak kelapa sawit yang sudah dimurnikan (RBD Palm Oil/RBDPO). Karakteristik dasar : \x{2022} Kadar air dan kotoran tidak lebih dari 0.15%; \x{2022} Bilangan iod tidak lebih dari 48 g I2/100 g; \x{2022} Bilangan peroksida tidak lebih dari 10 mek O2/kg; \x{2022} Kadar asam lemak bebas dihitung sebagai asam palmitat tidak lebih dari 0.2%.",
    "Aktif",
  ],
  [
    "020102000023",
    "Minyak Goreng Sawit",
    "Minyak goreng sawit adalah bahan pangan dengan komposisi utama trigliserida berasal dari minyak kelapa sawit (Refined Bleached Deodorized Palm Olein/RBDPO), yang telah melalui proses fraksinasi, dengan atau tanpa penambahan bahan pangan lain, mengandung vitamin A dan/atau provitamin A. Karakteristik dasar : \x{2022} Kadar air tidak lebih dari 0,1%; \x{2022} Asam lemak bebas (dihitung sebagai asam palmitat) tidak lebih dari 0,3%; \x{2022} Bilangan peroksida tidak lebih dari 10 mek O2/kg; \x{2022} Vitamin A (total) tidak kurang dari 45 IU/g (pengambilan contoh di pabrik)",
    "Aktif",
  ],
  [
    "020102000024",
    "Minyak Kelapa Mentah atau Unrefined Coconut Oil/Crude Coconut Oil",
    "Minyak kelapa mentah adalah minyak hasil ekstraksi atau pengempaan dari daging buah kelapa (Cocos nucifera). Karakteristik dasar : \x{2022} Bilangan penyabunan 248 mg KOH/g hingga 265 mg KOH/g; \x{2022} Bilangan iod 7 Wijs hingga 13 Wijs.",
    "Aktif",
  ],
  [
    "020102000025",
    "Minyak Kelapa (Refined Bleached Deodorized Coconut Oil )",
    "Minyak kelapa adalah minyak yang diperoleh dari hasil proses rafinasi/pemurnian dari minyak kelapa mentah (crude coconut oil). Karakteristik dasar : \x{2022} Bilangan penyabunan 248 mg KOH/g hingga 265 mg KOH/g; \x{2022} Bilangan iod 7 Wijs hingga 13 Wijs; \x{2022} Bilangan peroksida tidak lebih dari 10 mek O2/kg; \x{2022} Komposisi asam lemak minyak kelapa lihat pada tabel komposisi asam lemak.",
    "Aktif",
  ],
  [
    "020102000026",
    "Minyak Kacang Tanah (Refined Bleached Deodorized Peanut Oil/Refined Bleached Deodorized Groundnut Oil)",
    "Minyak kacang tanah adalah minyak makan yang diperoleh dari biji kacang tanah (Arachis hypogea L.) dan telah mengalami proses rafinasi/pemurnian. Karakteristik dasar : \x{2022} Bilangan penyabunan 248 mg KOH/g hingga 265 mg KOH/g; \x{2022} Bilangan iod 83 Wijs hingga 107 Wijs; \x{2022} Komposisi asam lemak minyak kacang tanah lihat pada tabel komposisi asam lemak.",
    "Aktif",
  ],
  [
    "020102000027",
    "Minyak Jagung (Refined Bleached Deodorized Corn Oil)",
    "Minyak jagung adalah minyak makan yang diperoleh dari biji jagung (Zea mays L.) dan telah mengalami proses rafinasi/pemurnian. Karakteristik dasar : \x{2022} Bilangan penyabunan187 mg KOH/g hingga 195 mg KOH/g; \x{2022} Bilangan iod 107 Wijs hingga 135 Wijs; \x{2022} Bilangan peroksida tidak lebih dari 10 mek O2/kg; \x{2022} Komposisi asam lemak minyak jagung lihat pada tabel komposisi asam lemak.",
    "Aktif",
  ],
  [
    "020102000028",
    "Minyak Kemiri (Refined Bleached Deodorized Candlenut/Lumbang Oil)",
    "Minyak kemiri adalah minyak yang diperoleh dari biji kemiri (Aleurites mollucana Wild) dan telah mengalami proses rafinasi/pemurnian. Karakteristik dasar : \x{2022} Bilangan penyabunan 184 mg KOH/g hingga 202 mg KOH/g; \x{2022} Bilangan iod 136 Wijs hingga 167 Wijs.",
    "Aktif",
  ],
  [
    "020102000029",
    "Minyak Kedelai (Refined Bleached Deodorized Soybean Oil)",
    "Minyak kedelai adalah minyak makan yang diperoleh dari biji kedelai (Glycine max (L) Merr.) dan telah mengalami proses rafinasi/pemurnian. Karakteristik dasar : \x{2022} Bilangan penyabunan 189 mg KOH/g hingga 195 mg KOH/g; \x{2022} Bilangan iod 124 Wijs hingga 139 Wijs; \x{2022} Bilangan peroksida tidak lebih dari 10 mek O2/kg; \x{2022} Asam lemak bebas dihitung sebagai asam oleat tidak lebih dari 0.15%; \x{2022} Komposisi asam lemak minyak kedelai lihat pada tabel komposisi asam lemak.",
    "Aktif",
  ],
  [
    "020102000030",
    "Minyak Wijen (Sesame Oil)",
    "Minyak wijen adalah minyak yang diperoleh dari biji wijen (Sesamum indicum L) dengan atau tanpa mengalami proses sangrai (roasted). Karakteristik dasar : \x{2022} Bilangan penyabunan 187 mg KOH/g hingga 195 mg KOH/g; \x{2022} Bilangan iod 104 Wijs hingga 120 Wijs; \x{2022} Komposisi asam lemak minyak wijen lihat pada tabel komposisi asam lemak.",
    "Aktif",
  ],
  [
    "020102000031",
    "Minyak Zaitun (Refined Bleached Deodorized Olive Oil)",
    "Minyak zaitun adalah minyak yang diperoleh dari buah Zaitun (Olea europaea) dan telah mengalami proses rafinasi/pemurnian. Karakteristik dasar : \x{2022} Bilangan penyabunan 184 mg KOH/g hingga 196 mg KOH/g; \x{2022} Bilangan iod 74 Wijs hingga 94 Wijs.",
    "Aktif",
  ],
  [
    "020102000032",
    "Minyak Safflower (Refined Bleached Deodorized Safflower Oil)",
    "Minyak safflower adalah minyak makan yang diperoleh dari biji Carthamus tintorius dan telah mengalami proses rafinasi/pemurnian.  Karakteristik dasar : \x{2022} Bilangan penyabunan 186 mg KOH/g hingga 198 mg KOH/g; \x{2022} Bilangan iod 135 Wijs hingga 150 Wijs; \x{2022} Komposisi asam lemak minyak safflower lihat pada tabel komposisi asam lemak.",
    "Aktif",
  ],
  [
    "020102000033",
    "Minyak Biji Bunga Matahari (Refined Bleached Deodorized Sunflower Oil)",
    "Minyak biji bunga matahari adalah minyak makan yang diperoleh dari biji bunga matahari (Helianthus annuus L.) dan telah mengalami proses rafinasi/pemurnian. Karakteristik dasar : \x{2022} Bilangan penyabunan 188 mg KOH/g hingga 194 mg KOH/g; \x{2022} Bilangan iod 118 Wijs hingga 141 Wijs; \x{2022} Komposisi asam lemak minyak biji bunga matahari lihat pada tabel komposisi asam lemak.",
    "Aktif",
  ],
  [
    "020102000034",
    "Minyak Dedak atau Minyak Bekatul atau Minyak Katul (Refined Bleached Deodorized Rice Bran Oil)",
    "Minyak dedak atau minyak bekatul atau minyak katul adalah minyak dari katul beras pecah kulit tanaman padi (Oryza sativa) dan telah mengalami proses rafinasi/pemurnian. Karakteristik dasar : \x{2022} Bilangan penyabunan 181 mg KOH/g hingga 189 mg KOH/g; \x{2022} Bilangan iod 92 Wijs hingga 108 Wijs; \x{2022} Komposisi asam lemak minyak dedak lihat pada tabel komposisi asam lemak.",
    "Aktif",
  ],
  [
    "020102000035",
    "Minyak Biji Kapas (Refined Bleached Deodorized Cottonseed Oil)",
    "Minyak biji kapas adalah minyak yang diperoleh dari biji kapas (Gossypium sp.) dan telah mengalami proses rafinasi/pemurnian. Karakteristik dasar : \x{2022} Bilangan penyabunan 189 mg KOH/g hingga 198 mg KOH/g; \x{2022} Bilangan iod 96 Wijs hingga 115 Wijs; \x{2022} Komposisi asam lemak minyak biji kapas lihat pada tabel komposisi asam lemak.",
    "Aktif",
  ],
  [
    "020102000036",
    "Rapeseed oil (turnip rape oil/colza oil/ravison oil/sarson oil/toria oil)",
    "Rapeseed oil adalah minyak yang dihasilkan dari biji Brassica napus L., Brassica rapa L., Brassica juncea L. dan Brassica tournefortii Gouan. Karakteristik dasar : \x{2022} Bilangan penyabunan 168 mg KOH/g hingga 181 mg KOH/g; \x{2022} Bilangan iod 94 Wijs hingga 120 Wijs; \x{2022} Komposisi asam lemak minyak rapeseed lihat pada tabel komposisi asam lemak.",
    "Aktif",
  ],
  [
    "020102000037",
    "Rapeseed oil - low erucic acid (low erucic acid turnip rape oil/low erucic acid colza oil/canola oil)",
    "Rapeseed oil\x{2013}low erucic acid adalah minyak yang dihasilkan dari minyak rendah asam erusat biji Brassica napus L., Brassica rapa L. and Brassica juncea L. Karakteristik dasar : \x{2022} Kadar asam erusat tidak lebih dari 2%; \x{2022} Bilangan penyabunan 182 mg KOH/g hingga 193 mg KOH/g; \x{2022} Bilangan iod 105 Wijs hingga 126 Wijs; \x{2022} Komposisi asam lemak minyak rapeseed-low erucic acid lihat pada tabel komposisi asam lemak.",
    "Aktif",
  ],
  [
    "020102000038",
    "Mustardseed Oil (Refined Bleached Deodorized Mustardseed Oil)",
    "Mustardseed oil adalah minyak yang diperoleh dari biji Brassica juncea atau Brassica nigra dan telah mengalami proses rafinasi/pemurnian. Karakteristik dasar : \x{2022} Bilangan penyabunan 170 mg KOH/g hingga 184 mg KOH/g; \x{2022} Bilangan iod 92 Wijs hingga 125 Wijs; \x{2022} Komposisi asam lemak minyak biji mustard lihat pada tabel komposisi asam lemak.",
    "Aktif",
  ],
  [
    "020102000039",
    "Minyak Biji Rami/Flaxseed Oil/Flax Oil/Linseed Oil",
    "Minyak biji rami/flaxseed oil/linseed oil merupakan minyak yang diperoleh dari biji tanaman Linum usitatissimum. Karakteristik dasar : Bilangan asam (acid value) untuk produk minyak sebagai berikut: \x{2022} Lemak dan minyak yang dimurnikan (refined fats and oils), acid value tidak lebih dari 0,6 mg KOH/g lemak atau minyak; \x{2022} Lemak dan minyak cold pressed (cold pressed fats and oils), acid value tidak lebih dari 4,0 mg KOH/g lemak atau minyak; Bilangan peroksida (peroxide value) untuk produk minyak sebagai berikut : \x{2022} Lemak dan minyak lainnya (Other fats and oils), bilangan peroksida tidak lebih dari 10 mek O2/kg minyak.",
    "Aktif",
  ],
  [
    "020103000001",
    "Lemak Hewani",
    "Lemak hewani adalah lemak yang diperoleh dari hewan yang sehat pada saat disembelih dan aman untuk dikonsumsi manusia.",
    "Aktif",
  ],
  [
    "020103000002",
    "Lemak Babi atau Lard",
    "Lemak babi atau lard adalah lemak yang diperoleh dari pelelehan (rendered) jaringan lemak babi (Sus scorfa) yang bersih dan segar, yang diperoleh dari babi yang sehat pada saat sticking (penusukan) dan aman untuk dikonsumsi manusia. Karakteristik dasar: \x{2022} Bilangan penyabunan 192 mg KOH/g hingga 203 mg KOH/g; \x{2022} Bilangan iod 55 Wijs hingga 65 Wijs; \x{2022} Bilangan peroksida tidak lebih dari 10 mek O2/kg; \x{2022} Komposisi asam lemak lard lihat pada tabel komposisi asam lemak.",
    "Aktif",
  ],
  [
    "020103000003",
    "Rendered Pork Fat",
    "Rendered pork fat adalah lemak yang diperoleh dari pelelehan (rendered) jaringan dan tulang babi (Sus scorfa) yang bersih dan segar, yang diperoleh dari babi yang sehat pada saat sticking (penusukan) dan aman untuk dikonsumsi manusia. Karakteristik dasar : \x{2022} Bilangan penyabunan 192 mg KOH/g hingga 203 mg KOH/g; \x{2022} Bilangan iod 60 Wijs hingga 72 Wijs; \x{2022} Komposisi asam lemak rendered pork fat lihat pada tabel komposisi asam lemak.",
    "Aktif",
  ],
  [
    "020103000004",
    "Lemak Sapi Utama (Prime Beef Fat (Premier Jus atau Oleo Stock))",
    "Lemak sapi utama atau prime beef fat (premier jus atau oleo stock) adalah lemak yang diperoleh dari pelelehan pada suhu rendah (50\xB0C-55\xB0C), lemak ini disayat dari jantung, caul, ginjal, mesentary yang diperoleh dari sapi yang sehat pada saat disembelih dan aman untuk dikonsumsi manusia. Karakteristik dasar : \x{2022} Berat jenis 0,893 hingga 0,904 (40\xB0C/air pada 20\xB0C); \x{2022} Indeks bias 1,448 hingga 1,460 (pada suhu 40\xB0C); \x{2022} Bilangan penyabunan 190 mg KOH/g hingga 200 mg KOH/g; \x{2022} Bilangan iod 36 Wijs hingga 47 Wijs; \x{2022} Bilangan asam tidak lebih dari 2,0 mg KOH/g; \x{2022} Bilangan peroksida tidak lebih dari 10 mek O2/kg; \x{2022} Kadar bahan tak tersabunkan tidak lebih dari 10 g/kg. \x{2022} Komposisi asam lemak premier jus atau oleo stock lihat pada tabel komposisi asam lemak.",
    "Aktif",
  ],
  [
    "020103000005",
    "Lemak Sapi (Edible Beef Fat)",
    "Lemak sapi adalah lemak yang diperoleh dari pelelehan jaringan lemak sapi, bagian perut dan sekitar ginjal dan jantung serta bagian jaringan lemak lain yang utuh dari sapi yang sehat pada saat disembelih dan aman untuk dikonsumsi manusia.  Karakteristik dasar : \x{2022} Berat jenis 0,893 hingga 0,904 (40\xB0C/air pada 20\xB0C); \x{2022} Indeks bias 1,448 hingga 1,460 (pada suhu 40\xB0C); \x{2022} Bilangan penyabunan 190 mg KOH/g hingga 202 mg KOH/g; \x{2022} Bilangan iod 32 Wijs hingga 50 Wijs; \x{2022} Bilangan asam tidak lebih dari 2,5 mg KOH/g; \x{2022} Bilangan peroksida tidak lebih dari 10 mek O2/kg; \x{2022} Kadar bahan tak tersabunkan tidak lebih dari 12 g/kg.",
    "Aktif",
  ],
  [
    "020103000006",
    "Dripping atau Edible Tallow",
    "Dripping atau edible tallow adalah lemak yang diperoleh dari pelelehan jaringan lemak sapi, domba atau kambing atau campurannya yang sehat pada saat disembelih dan aman untuk dikonsumsi manusia. Karakteristik dasar : \x{2022} Bilangan penyabunan 190 mg KOH/g hingga 202 mg KOH/g; \x{2022} Bilangan iod 40 Wijs hingga 53 Wijs; \x{2022} Komposisi asam lemak Dripping atau edible tallow lihat pada tabel komposisi asam lemak.",
    "Aktif",
  ],
  [
    "020103000007",
    "Secunda Beef Fat",
    "Secunda beef fat adalah lemak yang memiliki bau dan rasa khas lemak sapi yang diperoleh dari pelelehan pada suhu 60\\xB0C-65\\xB0C dan penyaringan/pemisahan.",
    "Aktif",
  ],
  [
    "020103000008",
    "Suet",
    "Suet adalah lemak yang diperoleh dari pelelehan jaringan lemak bagian ginjal, atau daging daerah pinggang atau caul dari sapi, kambing atau domba atau campurannya yang sehat pada saat disembelih dan aman untuk dikonsumsi manusia. Karakteristik dasar : \x{2022} Berat jenis 0,893 hingga 0,904 (40\xB0C/air pada 20\xB0C); \x{2022} Indeks bias 1,448 hingga 1,460 (pada suhu 40\xB0C); \x{2022} Bilangan penyabunan 190 mg KOH/g hingga 200 mg KOH/g; \x{2022} Bilangan iod 32 Wijs hingga 47 Wijs; \x{2022} Bilangan asam tidak lebih dari 2 mg KOH/g; \x{2022} Bilangan peroksida tidak lebih dari 20 mek O2/kg; \x{2022} Kadar bahan tak tersabunkan tidak lebih dari 10 g/kg.",
    "Aktif",
  ],
  [
    "020103000009",
    "Minyak Ikan",
    "Minyak ikan adalah minyak yang diperoleh dari ikan segar yang sesuai seperti ikan herring, sarden/tuna, sprat dan teri.",
    "Aktif",
  ],
  [
    "020103000010",
    "Serbuk Lemak Hewani (Fat Powder)",
    "Serbuk lemak hewani adalah produk lemak hewani yang berbentuk serbuk dengan atau tanpa penambahan bahan pengisi. Contoh: Serbuk Minyak Ikan.",
    "Aktif",
  ],
  [
    "020201000001",
    "Mentega dan Konsentrat Mentega",
    "Mentega dan konsentrat mentega adalah produk lemak berbentuk emulsi air dalam minyak.",
    "Aktif",
  ],
  [
    "020201000002",
    "Mentega (butter)",
    "Mentega adalah produk emulsi lemak berbentuk padat atau semi padat yang dibuat dari susu atau krim susu atau campurannya, dengan atau tanpa penambahan bahan pangan lain seperti garam. Karakteristik dasar : \x{2022} Kadar lemak susu tidak kurang dari 80%; \x{2022} Kadar air tidak lebih dari 16%.",
    "Aktif",
  ],
  [
    "020201000003",
    "Mentega Rekombinasi",
    "Mentega rekombinasi adalah produk emulsi lemak yang dibuat dari lemak susu anhidrat (AMF), air dan padatan susu atau susu skim, dengan atau tanpa penambahan bahan makanan lain seperti garam. Karakteristik dasar : \x{2022} Kadar lemak susu tidak kurang dari 80%; \x{2022} Kadar air tidak lebih dari 16%.",
    "Aktif",
  ],
  [
    "020202000001",
    "Margarin dan Produk Sejenis",
    "Margarin dan produk sejenis adalah produk lemak yang dapat dioles atau cairan emulsi air dalam minyak yang komponen utamanya minyak dan lemak makan bukan dari susu.",
    "Aktif",
  ],
  [
    "020202000002",
    "Margarin",
    "Margarin adalah produk emulsi lemak berbentuk padat atau semi padat atau cair, yang dibuat dari minyak atau lemak nabati dan air, dengan atau tanpa penambahan bahan pangan lain seperti garam. Contoh : margarin meja, margarin dapur, margarin industri. Karakteristik dasar : \x{2022} Kandungan lemak tidak kurang dari 80%; \x{2022} Kadar air tidak lebih dari 18%; \x{2022} Untuk margarin meja harus ditambahkan vitamin A berkisar 2500 IU/100 g hingga 3500 IU/100 g dan vitamin D berkisar 250 IU/100 g hingga 350 IU/100 g.",
    "Aktif",
  ],
  [
    "020202000003",
    "Campuran Margarin dan Mentega (Blends of butter and margarine)",
    "Campuran margarin dan mentega adalah produk emulsi lemak berbentuk padat atau semi padat atau cair yang dibuat dari campuran minyak atau lemak nabati dan lemak susu anhidrat (AMF) atau minyak mentega (butter oil) dan air, dengan atau tanpa penambahan bahan pangan lain seperti garam. Karakteristik dasar : \x{2022} Kadar lemak tidak kurang dari 80%; \x{2022} Kadar air tidak lebih dari 18%; \x{2022} Untuk margarin meja harus ditambahkan vitamin A berkisar 2500 IU/100g hingga 3500 IU/100g dan vitamin D berkisar 250 IU/100g hingga 350 IU/100g.",
    "Aktif",
  ],
  [
    "020202000004",
    "Margarin Krim, Margarin Oles (Fat Spread), Margarine Compound, Bread Compound dan Bakery Compound",
    "Margarin krim, fat spread (margarin oles), margarine compound, bread compound dan bakery compound adalah produk emulsi lemak berbentuk padat atau semi padat dibuat dari minyak atau lemak dan air dengan atau tanpa penambahan bahan makanan lain seperti garam. Karakteristik dasar : Kadar lemak tidak lebih dari 80%.",
    "Aktif",
  ],
  [
    "020202000005",
    "Minarin atau Halvarine",
    "Minarin atau halvarine adalah produk emulsi lemak berbentuk padat atau semi padat dibuat dari minyak atau lemak dan air dengan atau tanpa penambahan bahan makanan lain seperti garam. Karakteristik dasar : \x{2022} Kadar lemak 39 \x{2013} 41%; \x{2022} Minarin meja harus ditambahkan vitamin A berkisar 2500 IU/100g hingga 3500 IU/100g dan vitamin D berkisar 250 IU/100g hingga 350 IU/100g.",
    "Aktif",
  ],
  [
    "020202000006",
    "Lemak Oles Loyang (Pan Release)",
    "Lemak oles loyang adalah produk emulsi lemak dan atau minyak yang bersifat dapat dioles atau disemprot pada loyang, berbentuk emulsi air dalam minyak dan atau lemak, dapat digunakan untuk melepaskan roti dan kue dari loyang.",
    "Aktif",
  ],
  [
    "020300000001",
    "Non-Dairy Toppings, Fillings, Frostings",
    "Non-dairy toppings, fillings, frostings adalah produk emulsi lemak berbentuk semi padat atau cair yang terbuat dari minyak nabati yang digunakan untuk topping, filling, dan frosting pada produk makanan dan minuman. Karakteristik dasar : Kadar lemak tidak lebih dari 40%.",
    "Aktif",
  ],
  [
    "020300000002",
    "Non-Dairy Whipped Cream",
    "Non-dairy whipped cream adalah produk emulsi lemak yang terbuat dari minyak tumbuhan berbentuk semi padat/semi cair, yang siap dipakai atau dapat mengembang setelah dikocok. Karakteristik dasar : Kadar lemak tidak lebih dari 40%.",
    "Aktif",
  ],
  [
    "020400000001",
    "Melorin atau Non-Dairy Ice Cream",
    "Melorin atau non-dairy ice cream adalah produk sejenis es krim yang dibuat dari minyak atau lemak makan nabati. Karakteristik dasar : Kadar lemak tidak kurang dari 5%.",
    "Aktif",
  ],
  [
    "020400000002",
    "Non-Dairy Mousse",
    "Non-dairy mousse adalah produk mousse yang dibuat dari minyak atau lemak nabati. Karakteristik dasar : Kadar lemak tidak kurang dari 9%.",
    "Aktif",
  ],
  [
    "030000000001",
    "Es Batu Untuk Konsumsi ",
    "minum, tanpa bahan pangan lain, dikemas, serta aman untuk dikonsumsi. Es batu dapat dalam bentuk kubus, tabung, keping, pelat, serut, atau bentuk lain",
    "Aktif",
  ],
  [
    "030000000002",
    "Water Ices",
    "Water ices adalah pangan beku yang dibuat dari campuran air dan gula, dengan atau tanpa bahan pangan lain.",
    "Aktif",
  ],
  [
    "030000000003",
    "Es Mambo",
    "Es mambo adalah produk beku yang dibuat dari campuran air dan gula, dengan atau tanpa bahan pangan lain, dikemas, berbentuk kecil panjang atau bentuk lain.",
    "Aktif",
  ],
  [
    "030000000004",
    "Es Stik (Ice Stick) atau Es Loli",
    "Es stik (ice stick) atau es loli adalah produk beku yang dibuat dari bahan utama air dan gula, dengan atau tanpa bahan pangan lain dan dilengkapi dengan gagang (stik).",
    "Aktif",
  ],
  [
    "030000000005",
    "Es Buah (Fruit Ice)",
    "Es buah (fruit ice) adalah produk beku yang dibuat dari campuran air, sari buah/bubur buah/puree buah/potongan buah, gula, dengan atau tanpa bahan pangan lain.",
    "Aktif",
  ],
  [
    "030000000006",
    "Es Puter",
    "Es puter adalah produk beku yang dibuat dari pati dan/atau tepung, air, gula, santan, dengan atau tanpa bahan pangan lain yang proses pembekuannya sambil diaduk atau diputar sehingga teksturnya menyerupai es krim.",
    "Aktif",
  ],
  [
    "030000000007",
    "Es Lilin",
    "Es lilin adalah produk beku yang dibuat dari campuran air, santan, gula, dengan atau tanpa bahan pangan lain yang dicetak dan dikemas.",
    "Aktif",
  ],
  [
    "030000000008",
    "Es Kue",
    "Es kue adalah produk beku yang dibuat dari pati kacang hijau atau pati lain yang dimasak dengan gula, dengan atau tanpa bahan pangan lain, dicetak dan dikemas.",
    "Aktif",
  ],
  [
    "030000000009",
    "Sorbet",
    "Produk beku yang dibuat dari campuran air, sari buah/sayur dan/atau bubur buah/sayur (puree buah/sayur), gula, dengan atau tanpa bahan pangan lain, melalui proses pembekuan sambil diaduk atau diputar sehingga memiliki tekstur seperti es krim.",
    "Aktif",
  ],
  [
    "030000000010",
    "Sherbet",
    "Produk beku yang dibuat dari campuran air, sari buah/sayur dan/atau bubur buah/sayur (puree buah/sayur), gula, dan susu atau produk susu, dengan atau tanpa bahan pangan lain, melalui proses pembekuan sambil diaduk atau diputar sehingga memiliki tekstur seperti es krim.",
    "Aktif",
  ],
  [
    "030000000011",
    "Es Mengandung Susu ",
    "Es mengandung susu adalah produk beku yang dibuat dari campuran air, susu dan/atau produk susu, dengan atau tanpa penambahan bahan pangan lain. Karakteristik dasar: Kadar protein susu 0,3% sampai kurang dari 1%.",
    "Aktif",
  ],
  [
    "030000000012",
    "Es Rasa Susu",
    "Es rasa susu adalah produk beku yang dibuat dari campuran air, susu dan/atau produk susu, dengan atau tanpa penambahan bahan pangan lain. Karakteristik dasar: Kadar protein susu kurang dari 0,3%.",
    "Aktif",
  ],
  [
    "030000000013",
    "Premiks Es Bentuk Bubuk ",
    "Premiks es bentuk bubuk adalah produk berbentuk bubuk yang digunakan untuk membuat produk es kategori 03.0.",
    "Aktif",
  ],
  [
    "030000000014",
    "Premiks Es Bentuk Cair ",
    "Premiks es bentuk cair adalah produk berbentuk cair yang digunakan untuk membuat produk es kategori 03.0.",
    "Aktif",
  ],
  [
    "030000000015",
    "Sediaan Cair Yang Akan Dikonsumsi Dalam Keadaan Beku",
    "Sediaan cair yang akan dikonsumsi dalam keadaan beku adalah sediaan cair dari produk es kategori 03.0 yang akan dikonsumsi dalam keadaan beku.",
    "Aktif",
  ],
  [
    "040102010001",
    "Buah Beku dengan Penambahan Bahan Pangan Lain",
    "Untuk memfasilitasi pendaftaran pangan olahan selain PSAT",
    "Aktif",
  ],
  ["040102020001", "Buah Kering", "", "Aktif"],
  ["040102020002", "Buah Kering Campur", "", "Aktif"],
  ["040102020003", "Kopra", "", "Nonaktif"],
  [
    "040102020004",
    "Kelapa Parut Kering",
    "Buah asin adalah produk buah yang diperoleh dari proses penggaraman buah atau perendaman buah dalam larutan garam.",
    "Aktif",
  ],
  [
    "040102020005",
    "Santan Bubuk",
    "Asinan buah adalah produk buah yang diperoleh dari satu jenis atau lebih buah segar dan/atau manisan buah, dengan atau tanpa bahan pangan yang diberi kuah yang dibuat dari gula, cuka dan bahan pangan lain.",
    "Aktif",
  ],
  [
    "040102020006",
    "Tepung Buah",
    "Rujak adalah produk buah yang diperoleh dari satu jenis atau lebih buah segar, dengan atau tanpa bahan pangan lain, yang diberi kuah kental yang terbuat dari gula merah dan/atau bahan pangan lain.",
    "Aktif",
  ],
  [
    "040102030001",
    "Buah Asin",
    "Buah dalam kemasan adalah produk buah yang diperoleh dari satu jenis atau lebih buah yang bersih, baik yang berbentuk utuh atau potongan, dengan medium yang sesuai (seperti air, campuran air dan jus buah, atau jus buah), dengan atau tanpa penambahan gula yang dikemas secara kedap (hermetis) dan diproses (pasteurisasi/ sterilisasi). Nama jenis untuk kategori ini mengacu pada jenis buah yang digunakan. Karakteristik dasar: Bobot tuntas tidak kurang dari 40%.",
    "Aktif",
  ],
  [
    "040102030002",
    "Asinan Buah",
    "Koktil buah dalam kemasan adalah produk buah yang diperoleh dari dua jenis atau lebih buah yang bersih, baik yang berbentuk utuh atau potongan, dengan medium yang sesuai (seperti air, campuran air dan jus buah, atau jus buah), dengan atau tanpa penambahan gula, yang dikemas secara kedap (hermetis) dan diproses dengan pasteurisasi/sterilisasi. Karakteristik dasar: Bobot tuntas tidak kurang dari 40%.",
    "Aktif",
  ],
  [
    "040102030003",
    "Rujak",
    "Jem buah atau selai buah adalah produk buah yang kental dan dapat dioles, dibuat dari pendidihan satu jenis atau lebih buah utuh, potongan buah, bubur atau puree buah dengan tambahan gula dan/atau pemanis lain, dengan atau tanpa penambahan pektin. Termasuk dalam kategori ini preserve dan conserve. Karakteristik dasar: Kandungan buah tidak kurang dari 35%.",
    "Aktif",
  ],
  [
    "040102040001",
    "Buah Dalam Kemasan",
    "Jeli buah adalah produk buah berbentuk jel yang dapat dioles yang diperoleh dari pendidihan satu jenis buah atau lebih sari buah atau ekstrak air dari buah, dengan tambahan gula dan/atau pemanis lain, dengan atau tanpa penambahan pektin.",
    "Aktif",
  ],
  [
    "040102040002",
    "Koktil Buah Dalam Kemasan",
    "Marmalad adalah produk bubur buah kental dan dapat dioles yang diperoleh dari pendidihan buah utuh, bubur buah atau puree buah dengan gula untuk mengentalkan. Dapat ditambahkan pektin, irisan buah dan irisan kulit buah. Termasuk dalam kategori ini marmalad sitrus dan jeli marmalad.",
    "Aktif",
  ],
  [
    "040102050001",
    "Jem Buah atau Selai Buah",
    "Chutney mangga (mango chutney) adalah produk buah yang diperoleh dari buah mangga yang bersih, yang telah dikupas, dipotong, dirajang, diiris atau dihancurkan dengan penambahan bahan lain dan dipanaskan sebelum atau sesudah penutupan pengemas. Bahan lain terdiri dari gula, madu, buah lain dan sayur, garam, dan kondimen (seperti cuka, bawang putih, bawang bombay, jahe, dan lain-lain). Karakteristik dasar: \x{2022} Kandungan buah mangga tidak kurang dari 40%; \x{2022} Total padatan terlarut 50%; \x{2022} Produk harus memiliki flavor chutney mangga.",
    "Aktif",
  ],
  [
    "040102050002",
    "Jeli Buah",
    "Produk buah oles adalah produk yang diperoleh dari pencampuran hasil olahan buah dengan bahan pangan lain, dan diolah menjadi produk yang dapat dioles, Nama jenis produk ini misal olesan berbasis kelapa.",
    "Aktif",
  ],
  [
    "040102050003",
    "Marmalad",
    "Buah bersalut adalah buah yang diperoleh dengan memperlakukan buah (antara lain dicelupkan, direndam, disemprot) dalam larutan gula dan dikeringkan.",
    "Aktif",
  ],
  [
    "040102060001",
    " Chutney Mangga (Mango Chutney)",
    "Chutney mangga (mango chutney) adalah produk buah yang diperoleh dari buah mangga yang bersih, yang telah dikupas, dipotong, dirajang, diiris atau dihancurkan dengan penambahan bahan lain dan dipanaskan sebelum atau sesudah penutupan pengemas. Bahan lain terdiri dari gula, madu, buah lain dan sayur, garam, dan kondimen (seperti cuka, bawang putih, bawang bombay, jahe, dan lain-lain). Karakteristik dasar: \x{2022} Kandungan buah mangga tidak kurang dari 40%; \x{2022} Total padatan terlarut 50%; \x{2022} Produk harus memiliki flavor chutney mangga.",
    "Aktif",
  ],
  [
    "040102060002",
    " Produk Buah Oles",
    "Produk buah oles adalah produk yang diperoleh dari pencampuran hasil olahan buah dengan bahan pangan lain, dan diolah menjadi produk yang dapat dioles, Nama jenis produk ini misal olesan berbasis kelapa.",
    "Aktif",
  ],
  [
    "040102070001",
    "Buah Bersalut",
    "Kulit buah bergula adalah kulit buah yang diperoleh dengan memperlakukan (antara lain dicelupkan, direndam, disemprot) kulit buah dalam larutan gula dan dikeringkan.",
    "Aktif",
  ],
  [
    "040102070002",
    "Buah Bergula",
    "Bubur buah (fruit pulp) adalah produk buah yang diperoleh dari buah segar yang dihancurkan tanpa mengekstrak jusnya. Karakteristik dasar: Total padatan tidak kurang dari 12%.",
    "Aktif",
  ],
  [
    "040102070003",
    "Buah Berkristal",
    "Puree buah adalah produk buah yang diperoleh dari buah segar atau buah yang didinginkan atau dibekukan dengan kematangan yang cukup yang dihancurkan tanpa mengekstrak sari buahnya.",
    "Aktif",
  ],
  [
    "040102070004",
    "Kulit Buah Bergula",
    "Pasta buah adalah produk buah yang dibuat dari puree buah yang telah mengalami pemekatan. Karakteristik dasar: Total padatan tidak kurang dari 25%.",
    "Aktif",
  ],
  [
    "040102080001",
    "Bubur Buah (Fruit Pulp)",
    "Saus buah adalah produk buah yang diperoleh dari pendidihan bubur buah dengan atau tanpa penambahan gula dan dapat mengandung potongan buah. Saus buah dapat digunakan sebagai topping untuk produk roti dan es krim sundaes.",
    "Aktif",
  ],
  [
    "040102080002",
    "Puree Buah",
    "Topping buah adalah produk buah yang diperoleh dari pendidihan bubur buah, lebih encer dari pada saus buah dan dapat digunakan sebagai topping panekuk.",
    "Aktif",
  ],
  [
    "040102080003",
    "Pasta Buah",
    "Santan adalah produk emulsi yang diperoleh dari ekstraksi daging buah kelapa (Cocos nucifera) yang cukup tua dan segar; atau rekonstitusi krim kelapa bubuk dengan air; atau dispersi endosperm kelapa kering halus dengan air; atau kombinasi ekstraksi daging buah kelapa yang cukup tua dan segar dengan dispersi endosperm kelapa kering halus dengan air. Bahan baku santan dapat terdiri dari krim kelapa bubuk, endosperm kelapa (Cocos nucifera), dan air. Karakteristik dasar: \x{2022} Santan encer : kadar lemak kelapa tidak kurang dari 5%; total padatan 6,6-12,6% \x{2022} Santan : kadar lemak kelapa tidak kurang dari 10%; total padatan 12,7-25,3% \x{2022} Krim kelapa : kadar lemak kelapa tidak kurang dari 20%; total padatan 25,4-37,3% \x{2022} Konsentrat krim kelapa : kadar lemak kelapa tidak kurang dari 29%, total padatan tidak kurang dari 37,4%",
    "Aktif",
  ],
  [
    "040102080004",
    "Saus Buah",
    "Nata merupakan selulosa mikrobia yang dihasilkan oleh bakteri asam cuka (Acetobacter xilynum) dari hasil fermentasi air kelapa, santan kelapa dan/atau bahan lainnya.",
    "Aktif",
  ],
  [
    "040102080005",
    "Topping Buah",
    "Konsentrat asam jawa/tamarin adalah produk tamarin yang diperoleh dari ekstrak bersih buah tamarin dengan total padatan terlarut tidak kurang dari 65%.",
    "Aktif",
  ],
  [
    "040102080006",
    "Santan",
    "Bubuk asam jawa/tamarin adalah produk tamarin yang diperoleh dari pasta tamarin yang dicampur dengan pati.",
    "Aktif",
  ],
  [
    "040102080007",
    "Nata",
    "Bars buah adalah produk buah yang diperoleh dari hancuran buahbuahan (mangga, nanas atau jambu) yang dicampur dengan gula, lalu dikeringkan sampai berbentuk lembaran.",
    "Aktif",
  ],
  [
    "040102080008",
    "Konsentrat Asam Jawa/Tamarin",
    "Manisan buah adalah produk buah yang diperoleh dari potongan buah atau buah utuh segar yang sehat dengan penambahan gula. Selain itu dapat ditambahkan bahan pangan lain. Manisan buah dapat dikeringkan ataupun tidak. Karakteristik dasar: \x{2022} Kadar air tidak lebih dari 44%; \x{2022} Kadar gula (sebagai sakarosa) tidak kurang dari 25%.",
    "Aktif",
  ],
  [
    "040102080009",
    "Bubuk Asam Jawa/Tamarin",
    "Nata dalam kemasan adalah produk nata bertekstur kenyal yang dikemas dalam medium air dengan atau tanpa penambahan gula dengan atau tanpa penambahan bahan pangan lain, kemudian dilakukan proses pasteurisasi atau sterilisasi. Termasuk dalam kategori ini nata de coco dalam sirup. Karakteristik dasar: Bobot tuntas tidak kurang dari 50%.",
    "Aktif",
  ],
  [
    "040102080010",
    "Bars Buah",
    "Jeli agar adalah produk gel buah yang diperoleh dari ekstrak atau sari rumput laut dengan atau tanpa penambahan bahan pangan lain.",
    "Aktif",
  ],
  [
    "040102090001",
    "Manisan Buah",
    "Bubuk agar (agar-agar tepung/tepung agar-agar) adalah polisakarida berupa tepung yang diperoleh dari ekstraksi rumput laut alga merah Agarophyte, bersifat koloid bila dilarutkan dalam air mendidih dan menjedal bila didinginkan (reversible).",
    "Aktif",
  ],
  [
    "040102090002",
    "Nata Dalam Kemasan",
    "Agar-agar kertas adalah produk olahan hasil perikanan dengan bahan baku rumput laut kering Gracilaria spp. atau Gelidium spp. yang mengalami perebusan, penyaringan, penjendalan, pemotongan, pengepresan, dan pengeringan.",
    "Aktif",
  ],
  [
    "040102090003",
    "Jeli Agar",
    "Tepung gelatin adalah tepung pembentuk gel yang dibuat dari gelatin.",
    "Aktif",
  ],
  [
    "040102090004",
    "Bubuk Agar (Agar-Agar Tepung/Tepung Agar-Agar)",
    "Tepung karagenan (bubuk karagenan) adalah produk bubuk pembentuk gel yang dibuat dari karagenan.",
    "Aktif",
  ],
  [
    "040102090005",
    "Agar-Agar Kertas",
    "Jeli agar bubuk adalah produk bubuk pembentuk gel yang dibuat dari rumput laut dengan campuran bahan pembentuk gel lainnya.",
    "Aktif",
  ],
  [
    "040102090006",
    "Tepung Gelatin (Bubuk Gelatin)",
    "Puding rasa/berperisa adalah produk gel siap konsumsi yang dibuat dari bahan pembentuk gel selain tepung atau pati, dan dapat ditambahkan bahan pangan lain.",
    "Aktif",
  ],
  [
    "040102090007",
    "Tepung Karagenan (Bubuk Karagenan)",
    "Bubuk puding rasa/berperisa adalah produk bubuk yang dibuat dari bahan pembentuk gel selain tepung atau pati, dapat ditambahkan bahan pangan lain, dan digunakan untuk membuat puding rasa atau berperisa.",
    "Aktif",
  ],
  [
    "040102090008",
    "Jeli Agar Bubuk",
    "Mitsumame adalah produk makanan pencuci mulut yang berbentuk jeli agar serupa gelatin dengan potongan buah dan sirup.",
    "Aktif",
  ],
  [
    "040102090009",
    "Puding Rasa/Berperisa",
    "Sale pisang adalah produk buah semi basah yang diperoleh dari buah pisang segar dengan cara pengeringan dan atau pengasapan dan dikemas secara kedap (hermetis).",
    "Aktif",
  ],
  [
    "040102090010",
    "Bubuk Puding Rasa/Berperisa",
    "Cincau hijau adalah produk gel buah tradisional yang diperoleh dari ekstrak atau sari daun tanaman jenis Premna oblongifolia, Cyclea barbata, Melastoma polyanthum dan Stephania harmandifolia. Gel cincau hijau terbentuk dalam kondisi dingin dan tidak membutuhkan komponen pati. Cincau hijau dikonsumsi sebagai makanan atau minuman pencuci mulut.",
    "Aktif",
  ],
  [
    "040102090011",
    "Mitsumame",
    "Cincau hitam adalah produk gel buah tradisional yang diperoleh dari ekstrak tanaman janggelan (Mesona palustris, Mesona sinensis). Gel cincau hitam terbentuk melalui proses panas dan membutuhkan komponen pati. Cincau hitam dikonsumsi sebagai makanan atau minuman pencuci mulut.",
    "Aktif",
  ],
  [
    "040102090012",
    "Sale Pisang",
    "Siwalan adalah daging buah tanaman palma Borassus flabellifer. Buah dapat diolah menjadi daging buah siwalan dalam kaleng dengan medium sirup atau air yang mengandung gula dan mengikuti kaidah proses pengalengan.",
    "Aktif",
  ],
  [
    "040102090013",
    "Cincau Hijau",
    "Pikel buah adalah produk buah yang diperoleh dari buah yang dikupas, dan dibersihkan, dalam bentuk utuh, diiris, atau potongan, diberi larutan dan difermentasi dengan bakteri asam laktat.",
    "Aktif",
  ],
  [
    "040102090014",
    "Cincau Hitam",
    "Tempoyak/pakasam adalah produk buah yang diperoleh dari daging buah durian yang melalui proses fermentasi asam laktat secara alami.",
    "Aktif",
  ],
  [
    "040102090015",
    "Siwalan",
    "Keripik3 buah adalah produk buah yang diperoleh dari buah yang digoreng secara vakum atau freeze drying atau proses lain, dengan atau tanpa penambahan bahan lain.",
    "Aktif",
  ],
  [
    "040102090016",
    "Makanan Pencuci Mulut (Dessert) Berbasis Buah Termasuk Makanan Pencuci Mulut Berbasis Air Berflavor Buah",
    "-",
    "Aktif",
  ],
  [
    "040102100001",
    "Pikel Buah",
    "Keripik3 buah simulasi adalah produk buah yang diperoleh dari buah yang dibuat tepung dan digoreng, dengan atau tanpa penambahan bahan lain.",
    "Aktif",
  ],
  [
    "040102100002",
    "Tempoyak/Pakasam",
    "Dodol atau lempok buah adalah produk buah yang diperoleh dari daging buah matang yang dihancurkan dan dimasak dengan atau tanpa penambahan gula. Karakteristik dasar: \x{2022} Kadar air tidak lebih dari 20%; \x{2022} Kadar gula (sebagai sukrosa) tidak kurang dari 35%; \x{2022} Kadar serat kasar tidak lebih 2,5%.",
    "Aktif",
  ],
  ["040102110001", "Produk Buah Untuk Isi Pastri", "", "Aktif"],
  [
    "040102120001",
    "Keripik3 Buah",
    "Wajit buah adalah produk buah yang diperoleh dari campuran buah, tepung ketan, kelapa parut dan gula.",
    "Aktif",
  ],
  [
    "040102120002",
    "Keripik3 Buah Simulasi",
    "Geplak adalah produk buah yang diperoleh dari campuran kelapa parut dan gula yang dikeringkan. Karakteristik dasar: \x{2022} Kadar air tidak lebih dari 14%; \x{2022} Kadar gula (sebagai sakarosa) tidak kurang dari 68%; \x{2022} Kadar serat kasar tidak lebih dari 2,5%.",
    "Aktif",
  ],
  [
    "040102120003",
    "Dodol atau Lempok Buah",
    "Kentang goreng beku atau frozen french fries adalah produk sayur beku yang diperoleh dari kentang (Solanum tuberosum L.) yang bersih, tua dan sehat. Kentang telah mengalami pemilihan, pencucian, pengupasan dan pengirisan menjadi berbentuk batang dan diberi perlakuan untuk mempertahankan warna dan digoreng dalam minyak atau lemak makan. Proses pengolahan awal dan penggorengan harus mempertahankan warna dan flavor. Dapat ditambahkan gula, garam dan rempahrempah. Karakteristik dasar: \x{2022} Ketebalan irisan: - Shoestring : 5 hingga 8 mm - Medium : 8 hingga 12 mm - Thick cut : 12 hingga 16 mm - Extra large : lebih dari 16 mm \x{2022} Kadar air produk untuk jenis shoestring, medium dan thick cut tidak lebih dari 76%, kadar air untuk extra large tidak lebih dari 78% \x{2022} Warna dan ukuran seragam \x{2022} Bebas dari kerusakan karena penggorengan, misalnya gosong.",
    "Aktif",
  ],
  [
    "040102120004",
    "Wajit Buah",
    "Perkedel kentang beku adalah produk kentang beku yang diperoleh dari kentang (Solanum tuberosum L.), yang telah mengalami pengolahan (pengukusan/perebusan/penggorengan) dan penghancuran dengan atau tanpa penambahan bahan pangan lain dan dibekukan secara cepat.",
    "Aktif",
  ],
  [
    "040102120005",
    "Geplak",
    "Nori adalah produk hasil perikanan yang dibuat dari rumput laut jenis Pyropia yang mengalami perlakukan pengeringan, dan setelah dikeringkan produk akan dipanggang dan/atau diberi penambahan bumbu. Bentuk produk akhir meliputi: serpihan, lembaran, lembar gulungan, gumpalan bulat. Jenis produk antara lain: nori kering, nori panggang, nori bumbu.",
    "Aktif",
  ],
  ["040202010001", "Sayur Beku", "", "Aktif"],
  [
    "040202010002",
    "Kentang Goreng Beku (Frozen French Fries)",
    "Tepung daun kelor adalah produk tepung daun kelor yang diperoleh dari proses pengeringan daun kelor yang sehat, masak dan bermutu baik.",
    "Aktif",
  ],
  [
    "040202010003",
    "Perkedel Kentang Beku",
    "Jamur dalam minyak zaitun atau jamur dalam minyak nabati lain adalah produk jamur yang diperoleh dari jamur segar, ataupun dari jamur yang telah diasinkan, baik bentuk utuh maupun irisan, dimasukkan dalam minyak zaitun atau minyak nabati lain, dikemas secara kedap (hermetis), disterilisasi dengan pemanasan untuk mencegah kerusakan. Karakteristik dasar: Kadar garam tidak lebih dari 1%.",
    "Aktif",
  ],
  ["040202020001", "Sayur Kering", "", "Aktif"],
  ["040202020002", "Rumput Laut Kering", "", "Nonaktif"],
  [
    "040202020003",
    "Nori",
    "Acar adalah produk acar yang diperoleh dari sayur yang dibersihkan, dicuci, diblansir, dan diawetkan dalam larutan cuka dengan atau tanpa penambahan garam, rempah-rempah, gula, minyak makan, asam asetat, asam laktat, asam sitrat atau asam askorbat, dapat dipanaskan atau dipasteurisasi. Contohnya adalah acar jamur, acar timun, acar bawang putih, acar jahe, acar cabe, dan acar lobak.",
    "Aktif",
  ],
  ["040202020004", "Sayur Asin Kering", "", "Nonaktif"],
  [
    "040202020005",
    "Kacang Kering dan Polong Kacang Kering",
    "",
    "Nonaktif",
  ],
  ["040202020006", "Biji Bunga Matahari", "", "Nonaktif"],
  ["040202020007", "Biji Wijen", "", "Nonaktif"],
  [
    "040202020008",
    "Kuaci",
    "Wortel dalam kemasan adalah produk wortel yang diperoleh dari wortel (Daucus carota Linn.) yang bersih, sehat, daun dan bagian atas yang hijau telah dihilangkan, dikupas, dan dimasukkan ke dalam air atau medium yang sesuai, diproses dengan pemanasan sebelum atau setelah penutupan pengemas untuk mencegah pembusukan. Medium yang digunakan adalah air, bumbu dan bahan lain yang sesuai dengan produk. Jika ditambahkan mentega atau minyak dan lemak nabati atau lemak hewani maka kadarnya tidak kurang dari 3% berat produk akhir.",
    "Aktif",
  ],
  [
    "040202020009",
    "Emping Melinjo",
    "Jamur dalam kemasan adalah produk jamur yang diperoleh dari jamur sehat yang dapat dimakan yang dibersihkan dalam keadaan utuh atau diiris, serpihan, dan akar, diblansir, dimasukkan ke dalam medium dengan penambahan bumbu yang sesuai, diproses dengan pemanasan sebelum dan sesudah penutupan pengemas untuk mencegah pembusukan. Medium yang digunakan dapat berupa air, larutan garam, jus jamur, mentega, saus krim, vinegar, dan minyak.",
    "Aktif",
  ],
  [
    "040202020010",
    "Emping Jengkol",
    "Buncis dalam kemasan adalah produk buncis yang diperoleh dari polong buncis segar (Phaseolus vulgaris) tanpa batang dan tangkainya, yang dimasukkan ke dalam medium, dan disterilkan dengan pemanasan. Medium yang digunakan adalah air atau medium lainnya. Dapat ditambahkan gula, bumbu dan bahan lain yang sesuai dengan produk. Jika ditambahkan mentega, maka kadarnya tidak kurang dari 3% dari produk akhir.",
    "Aktif",
  ],
  [
    "040202020011",
    "Mete Gelondong",
    "Asparagus dalam kemasan adalah produk asparagus yang diperoleh dari batang tanaman asparagus (Asparagus officinales L) dengan atau tanpa dikupas yang dimasukkan ke dalam air atau medium cair lain yang cocok, dikemas secara kedap (hermetis) dan diproses dengan panas untuk mencegah kerusakan. Karakteristik dasar: \x{2022} Batang panjang (long shoots) : terdiri dari tunas dan batangnya dengan panjang antara 15 cm hingga 18 cm; \x{2022} Batang atau potongan (shoots or spears) : terdiri dari tunas dan batangnya dengan panjang antara 10,5 cm hingga 15 cm; \x{2022} Pucuk tunas (tips or points) : terdiri dari pucuk dan batangnya dengan panjang antara 4 cm hingga 10,5 cm; \x{2022} Untuk jenis batang panjang, batang dan pucuk tunas : tidak kurang dari 75% batang dengan panjang lebih kurang 1 cm dari panjang yang dominan dan tidak lebih dari 95% potongan dengan panjang lebih kurang 2 cm dari panjang yang dominan; \x{2022} Potongan (cuts) dan heads atau potongan batang (cut spears) : terdiri dari batang yang dipotong dengan atau tanpa heads dengan panjang antara 2 cm hingga 6 cm. Paling tidak 20% potongan dengan heads, kecuali jika batang dipotong dengan panjang 3 cm atau kurang maka 10% potongan harus berpucuk; \x{2022} Potongan (cuts) : terdiri dari batang yang dipotong dengan panjang tidak kurang dari 6 cm. Potongan dengan pucuk bisa terdapat dalam produk; \x{2022} Untuk jenis potongan dan heads atau potongan batang atau potongan: tidak kurang dari 75% batang dengan panjang lebih kurang 1 cm dari panjang yang dominan dan tidak kurang dari 90% potongan dengan panjang lebih kurang 2 cm dari panjang yang dominan; \x{2022} Jenis putih : putih, krem, krem kekuningan; tidak lebih dari 20% potongan memiliki pucuk berwarna biru, hijau atau hijau kekuningan; \x{2022} Pucuk putih dan biru; Pucuk putih dan hijau : batang panjang, batang dan pucuk: pucuk berwarna putih, krem atau putih kekuningan, yang boleh memiliki pucuk biru, hijau, hijau terang dan hijau kekuningan tidak lebih dari 25%; \x{2022} Jenis hijau : berwarna hijau, hijau terang, hijau kekuningan; maksimum 20% potongan memiliki warna putih, krem atau putih kekuningan pada bagian bawah batang; \x{2022} Jenis campuran : campuran putih, krem, putih kekuningan, biru, hijau, hijau terang atau hijau kekuningan.",
    "Aktif",
  ],
  ["040202020012", "Kentang Kering Serpih (Flakes)", "", "Aktif"],
  [
    "040202020013",
    "Tepung Tomat/Bubur Tomat Kering/Pasta Tomat Kering",
    "",
    "Aktif",
  ],
  ["040202020014", "Tepung Bit", "", "Aktif"],
  ["040202020015", "Tepung Daun Kelor", "", "Aktif"],
  [
    "040202030001",
    "Jamur Dalam Minyak Zaitun atau Jamur Dalam Minyak Nabati Lain",
    "",
    "Aktif",
  ],
  [
    "040202030002",
    "Sayur Asin",
    "Sayur asin adalah produk sayur yang diperoleh dari sayur yang diberi garam.",
    "Aktif",
  ],
  [
    "040202030003",
    "Jamur Asin",
    "Jamur asin adalah produk jamur yang diperoleh dari satu jenis jamur segar, berbentuk utuh atau irisan, yang dibersihkan, dicuci, diblansir dan diawetkan dalam air garam.",
    "Aktif",
  ],
  ["040202030004", "Acar (Sweet Pickle)", "", "Aktif"],
  [
    "040202030005",
    "Asinan Jahe",
    "Asinan jahe adalah produk jahe (Zingiber officinale atau Zingiber officinale var Rubrum) yang diperoleh dari proses pengawetan jahe dengan penambahan garam dan larutan cuka atau larutan asam sitrat, atau asam lain yang sesuai. Dapat ditambahkan gula atau bahan pangan lain.",
    "Aktif",
  ],
  ["040202040001", "Sayur Dalam Kemasan", "", "Aktif"],
  ["040202040002", "Tomat Dalam Kemasan", "", "Aktif"],
  [
    "040202040003",
    "Jagung Manis Dalam Kemasan",
    "Jagung manis dalam kemasan adalah produk jagung yang diperoleh dari pipilan jagung manis (Zea mays L.) yang bersih, dimasukkan ke dalam medium yang sesuai dan diproses dengan pemanasan sebelum atau sesudah kemasan ditutup untuk mencegah pembusukan. Medium yang digunakan dapat berupa larutan yang mengandung pati jagung, gula, bumbu dan bahan lain yang sesuai.",
    "Aktif",
  ],
  [
    "040202040004",
    "Wortel Dalam Kemasan",
    "Wortel dalam kemasan adalah produk wortel yang diperoleh dari wortel (Daucus carota Linn.) yang bersih, sehat, daun dan bagian atas yang hijau telah dihilangkan, dikupas, dan dimasukkan ke dalam air atau medium yang sesuai, diproses dengan pemanasan sebelum atau setelah penutupan pengemas untuk mencegah pembusukan. Medium yang digunakan adalah air, bumbu dan bahan lain yang sesuai dengan produk. Jika ditambahkan mentega atau minyak dan lemak nabati atau lemak hewani maka kadarnya tidak kurang dari 3% berat produk akhir.",
    "Aktif",
  ],
  [
    "040202040005",
    "Jamur Dalam Kemasan",
    "Jamur dalam kemasan adalah produk jamur yang diperoleh dari jamur sehat yang dapat dimakan yang dibersihkan dalam keadaan utuh atau diiris, serpihan, dan akar, diblansir, dimasukkan ke dalam medium dengan penambahan bumbu yang sesuai, diproses dengan pemanasan sebelum dan sesudah penutupan pengemas untuk mencegah pembusukan. Medium yang digunakan dapat berupa air, larutan garam, jus jamur, mentega, saus krim, vinegar, dan minyak.",
    "Aktif",
  ],
  [
    "040202040006",
    "Buncis Dalam Kemasan",
    "Buncis dalam kemasan adalah produk buncis yang diperoleh dari polong buncis segar (Phaseolus vulgaris) tanpa batang dan tangkainya, yang dimasukkan ke dalam medium, dan disterilkan dengan pemanasan. Medium yang digunakan adalah air atau medium lainnya. Dapat ditambahkan gula, bumbu dan bahan lain yang sesuai dengan produk. Jika ditambahkan mentega, maka kadarnya tidak kurang dari 3% dari produk akhir.",
    "Aktif",
  ],
  [
    "040202040007",
    "Asparagus Dalam Kemasan",
    "Asparagus dalam kemasan adalah produk asparagus yang diperoleh dari batang tanaman asparagus (Asparagus officinales L) dengan atau tanpa dikupas yang dimasukkan ke dalam air atau medium cair lain yang cocok, dikemas secara kedap (hermetis) dan diproses dengan panas untuk mencegah kerusakan. Karakteristik dasar: \x{2022} Batang panjang (long shoots) : terdiri dari tunas dan batangnya dengan panjang antara 15 cm hingga 18 cm; \x{2022} Batang atau potongan (shoots or spears) : terdiri dari tunas dan batangnya dengan panjang antara 10,5 cm hingga 15 cm; \x{2022} Pucuk tunas (tips or points) : terdiri dari pucuk dan batangnya dengan panjang antara 4 cm hingga 10,5 cm; \x{2022} Untuk jenis batang panjang, batang dan pucuk tunas : tidak kurang dari 75% batang dengan panjang lebih kurang 1 cm dari panjang yang dominan dan tidak lebih dari 95% potongan dengan panjang lebih kurang 2 cm dari panjang yang dominan; \x{2022} Potongan (cuts) dan heads atau potongan batang (cut spears) : terdiri dari batang yang dipotong dengan atau tanpa heads dengan panjang antara 2 cm hingga 6 cm. Paling tidak 20% potongan dengan heads, kecuali jika batang dipotong dengan panjang 3 cm atau kurang maka 10% potongan harus berpucuk; \x{2022} Potongan (cuts) : terdiri dari batang yang dipotong dengan panjang tidak kurang dari 6 cm. Potongan dengan pucuk bisa terdapat dalam produk; \x{2022} Untuk jenis potongan dan heads atau potongan batang atau potongan: tidak kurang dari 75% batang dengan panjang lebih kurang 1 cm dari panjang yang dominan dan tidak kurang dari 90% potongan dengan panjang lebih kurang 2 cm dari panjang yang dominan; \x{2022} Jenis putih : putih, krem, krem kekuningan; tidak lebih dari 20% potongan memiliki pucuk berwarna biru, hijau atau hijau kekuningan; \x{2022} Pucuk putih dan biru; Pucuk putih dan hijau : batang panjang, batang dan pucuk: pucuk berwarna putih, krem atau putih kekuningan, yang boleh memiliki pucuk biru, hijau, hijau terang dan hijau kekuningan tidak lebih dari 25%; \x{2022} Jenis hijau : berwarna hijau, hijau terang, hijau kekuningan; maksimum 20% potongan memiliki warna putih, krem atau putih kekuningan pada bagian bawah batang; \x{2022} Jenis campuran : campuran putih, krem, putih kekuningan, biru, hijau, hijau terang atau hijau kekuningan.",
    "Aktif",
  ],
  [
    "040202040008",
    "Rebung Bambu Dalam Kemasan",
    "Rebung bambu dalam kemasan adalah produk rebung bambu yang diperoleh dari irisan rebung bambu (Bambusa, Dendroclamus,  Gigantochola dan Phyllostachys) yang dimasukkan ke dalam air atau medium yang sesuai, dikemas secara kedap (hermetis) dan disterilisasi dengan pemanasan. Medium yang digunakan adalah air, atau larutan garam.  Karakteristik dasar: \x{2022} Produk memiliki warna, bau, tekstur dan bentuk khas rebung; \x{2022} Bobot tuntas tidak kurang dari 50%.",
    "Aktif",
  ],
  [
    "040202040009",
    "Kacang Kapri (Green Peas) dalam Kemasan",
    "Kacang kapri (green peas) dalam kemasan adalah produk kacang kapri yang diperoleh dari kacang kapri (Pisum sativum L.) tetapi tidak meliputi subsp. Macrocarpum, yang telah dikupas, bersih, dimasukkan ke dalam medium yang sesuai, dikemas secara kedap (hermetis) dan disterilkan dengan pemanasan. Medium yang digunakan adalah air atau medium lain yang sesuai. Dapat ditambahkan gula, bumbu dan bahan lain yang sesuai dengan produk.",
    "Aktif",
  ],
  [
    "040202040010",
    "Akar/Umbi/Polong-polongan Dalam Kemasan",
    "Akar/umbi/polong-polongan dalam kemasan adalah produk akar/umbi/polong-polongan yang diperoleh dari akar/umbi/polong\2polongan sehat yang dapat dimakan yang dibersihkan dalam keadaan utuh atau diiris, serpihan, dan akar, diblansir, dimasukkan ke dalam medium dengan penambahan bumbu yang sesuai, diproses dengan pemanasan sebelum dan sesudah penutupan pengemas untuk mencegah pembusukan. Medium yang digunakan dapat berupa air, larutan garam, jus jamur, mentega, saus krim, vinegar dan minyak. Contohnya chestnut dalam kaleng, puree chestnut dalam kaleng, pink beans yang telah dimasak dalam kaleng. ",
    "Aktif",
  ],
  [
    "040202040011",
    "Manisan Rumput Laut dalam Kemasan",
    "Manisan rumput laut dalam kemasan adalah produk rumput laut jenis Euchema sp yang ditambahkan larutan gula serta dikemas secara kedap (hermetis) dan dipasteurisasi.   Karakteristik dasar: Bobot tuntas tidak kurang dari 17%",
    "Aktif",
  ],
  [
    "040202040012",
    "Lidah Buaya dalam Kemasan",
    "Lidah buaya dalam kemasan adalah produk pangan yang diperoleh dari daun lidah buaya (Aloe vera) dengan medium sirup atau air atau larutan garam dengan asidulan. Dikemas secara kedap (hermetis) dan dipasteurisasi atau disterilisasi.",
    "Aktif",
  ],
  [
    "040202050001",
    "Puree Tomat",
    "Puree tomat adalah produk tomat yang diperoleh dari proses penguapan air dari sari tomat yang diperoleh dari tomat bersih, sehat dan matang yang biji dan kulitnya telah dihilangkan. Produk dikemas dalam kemasan kedap (hermetis) dan diproses dengan pemanasan. ",
    "Aktif",
  ],
  [
    "040202050002",
    "Selai Kacang",
    "Selai kacang adalah produk kacang tanah atau kacang lainnya yang diperoleh dari penggilingan kacang kupas yang bersih dan bermutu baik, disangrai dan/atau digoreng dan/atau dipanggang, serta dihilangkan lembaganya. Dapat ditambahkan bahan pangan lain. Produk dapat digunakan sebagai olesan atau isian pangan lainnya. Nama jenis mengikuti sumber kacangnya seperti selai kacang (peanut butter), selai kacang mede (cashew butter), selai almond (almond butter), selai kacang tanah dan almond.  Karakteristik dasar: Kandungan total kacang tidak kurang dari 85%. ",
    "Aktif",
  ],
  [
    "040202050003",
    "Olesan Kacang",
    "Olesan kacang adalah produk olesan yang diperoleh dari penggilingan satu jenis kacang atau lebih yang dikupas, bersih dan bermutu baik, direbus dan/atau dikukus dan/atau disangrai dan/atau digoreng dan/atau dipanggang (oven). Dapat ditambahkan bahan pangan lain. Produk dapat digunakan sebagai olesan atau isian pangan lainnya. Nama jenis produk ini misal olesan kacang mede (cashew spread), olesan kacang merah, olesan (kacang) almond (almond spread), olesan (kacang) kenari, olesan kacang tanah dan mede.  Karakteristik dasar: Kandungan total kacang tidak kurang dari 40%. ",
    "Aktif",
  ],
  [
    "040202050004",
    "Olesan Mengandung Kacang",
    "Olesan mengandung kacang adalah produk olesan yang diperoleh dari pencampuran bahan pangan dan kacang. Produk dapat digunakan sebagai olesan atau isian pangan lainnya. Nama jenis produk ini misalnya olesan mengandung kacang mede, olesan mengandung kacang tanah, olesan mengandung almond, olesan mengandung kacang tanah dan kacang mede.   Karakteristik dasar: Kandungan total kacang tidak kurang dari 15%.",
    "Aktif",
  ],
  [
    "040202050005",
    "Selai Sayur",
    "Selai sayur adalah produk yang diperoleh dari proses penghancuran satu atau lebih jenis sayur yang bersih dan bermutu baik, dan diolah sehingga bisa dioles. Dapat ditambahkan bahan pangan lain. Contohnya selai labu (pumpkin butter).",
    "Aktif",
  ],
  [
    "040202060001",
    "Pasta Tomat",
    "Pasta tomat adalah produk tomat yang diperoleh dari proses pemekatan sari buah tomat atau bubur buah tomat dapat ditambahkan bahan pangan lain yang sesuai.  Karakteristik dasar : \x{2022} Produk harus bebas dari biji, kulit dan bahan-bahan lain yang  kasar dan keras; \x{2022} Total padatan terlarut tidak kurang dari 24%.",
    "Aktif",
  ],
  [
    "040202060002",
    "Pasta Umbi",
    "Pasta umbi adalah produk berbentuk pasta yang dibuat dari umbi yang direbus atau dikukus atau proses lain yang sesuai, kemudian dihancurkan, dapat ditambahkan bahan pangan lain yang sesuai. Nama produk untuk kategori ini misal pasta talas, pasta wortel, dan pasta ubi. ",
    "Aktif",
  ],
  [
    "040202060003",
    "Bubur (Pulp) Sayur",
    "Bubur sayur adalah produk sayur yang diperoleh dari sayur yang sudah dibersihkan, dihancurkan dan diolah lebih lanjut seperti pemanasan, pemekatan dan/atau pengeringan. ",
    "Aktif",
  ],
  [
    "040202060004",
    "Produk Jeli Tidak Siap Konsumsi",
    "Produk jeli tidak siap konsumsi adalah produk jeli berupa lembaran atau bentuk lainnya yang dibuat dari bahan hidrokoloid dan masih harus diolah untuk menjadi produk siap konsumsi. Contoh produk ini jeli dari iles iles.",
    "Aktif",
  ],
  [
    "040202070001",
    "Pikel (fermentasi)",
    "Pikel adalah produk sayur yang diperoleh dari sayur yang difermentasi dalam larutan garam, dengan atau tanpa penambahan gula dan rempah-rempah, dapat dilakukan pasteurisasi atau proses pemanasan. Contohnya pikel mentimun (Cucumis sativus L.), jahe, dan zaitun. Ada 3 jenis produk pikel zaitun, yaitu : \x{2022} Pikel Zaitun Hitam (Black Ripe Olives) dibuat dari zaitun yang masak dan sebelum disimpan dalam larutan garam diproses dengan basa dan dilanjutkan dengan aerasi untuk membuat kulit buah menjadi gelap \x{2022} Pikel Zaitun Hijau (Green Olives) dibuat dari zaitun yang sehat dan masak dan dipanen pada saat buah berwarna ungu muda atau pada tahap semburat kuning (straw-yellow), selama proses pencucian dihindari terjadinya proses penggelapan kulit buah (darkening) dan difermentasi dengan larutan garam encer \x{2022} Pikel Zaitun Ala Yunani (Greek-Style Olives) dibuat dari zaitun  yang sehat dan masak dan dipanen pada saat buah telah berwarna ungu atau hitam, tanpa diproses dengan basa sebelum fermentasi.",
    "Aktif",
  ],
  [
    "040202070002",
    "Sawi Asin",
    "Sawi asin adalah produk sayur yang diperoleh dari daun sawi yang difermentasi oleh bakteri asam laktat dalam larutan garam.",
    "Aktif",
  ],
  [
    "040202070003",
    "Sauerkraut",
    "Sauerkraut adalah produk sayur berupa irisan atau cincangan kubis dalam garam yang difermentasi oleh bakteri asam laktat. Produk dapat diawetkan dalam larutan garam atau cairan kubis hasil fermentasi, dikemas, dan dipanaskan.   Karakteristik dasar: \x{2022} Bau, rasa, warna dan tekstur khas sauerkraut; \x{2022} Bobot tuntas tidak kurang dari 60%.",
    "Aktif",
  ],
  [
    "040202070004",
    "Jamur Fermentasi",
    "Jamur fermentasi adalah produk sayur yang diperoleh dari jamur segar yang dapat dimakan, berbentuk utuh atau irisan yang dibersihkan, dicuci, dan difermentasi oleh bakteri asam laktat dalam larutan garam.  Karakteristik dasar: Kadar asam laktat sebagai hasil fermentasi 1%.",
    "Aktif",
  ],
  [
    "040202070005",
    "Kimchi ",
    "Kimchi adalah produk sayur yang diperoleh dari kubis cina yang difermentasi dan dicampur dengan sayur atau bahan lain.",
    "Aktif",
  ],
  [
    "040202070006",
    "Gochujang",
    "Gochujang adalah pangan fermentasi berbentuk pasta yang berwarna merah atau merah gelap yang dihasilkan melalui fermentasi terhadap campuran bahan hasil sakarifikasi dengan garam, bubuk cabe merah, dan bahan pangan lain, yang dikemas secara kedap (hermetis) dan diproses dengan pemanasan atau proses lain yang sesuai untuk mencegah kebusukan. Bahan hasil sakarifikasi dihasilkan melalui sakarifikasi pati dengan malt atau dengan menumbuhkan Aspergillus sp. (yang tidak patogen dan tidak menghasilkan toksin) pada biji-bijian.",
    "Aktif",
  ],
  [
    "040202080001",
    "Keripik Bayam",
    "Keripik bayam adalah produk keripik yang diperoleh dari daun bayam yang bersih dan bermutu baik, yang dilapis dengan adonan encer tepung berbumbu, kemudian digoreng. ",
    "Aktif",
  ],
  [
    "040202080002",
    "Keripik3 Jamur Kancing",
    "Keripik jamur kancing adalah produk keripik3 yang diperoleh dari jamur kancing genus Agaricus (A. bisforus, A.campesfris, A. biforqis) yang dikukus, diiris tipis sehingga berbentuk lempeng, diberi bumbu, kemudian digoreng dengan atau tanpa penambahan tepung.",
    "Aktif",
  ],
  [
    "040202080003",
    "Getuk Singkong",
    "Getuk singkong adalah produk singkong semi basah yang diperoleh dari singkong yang dikukus, dicampur dengan gula, digiling/dilumatkan kemudian dibentuk dengan atau tanpa penambahan bahan pangan lain. ",
    "Aktif",
  ],
  [
    "040202080004",
    "Vegetable Tsukudani",
    "Vegetable tsukudani adalah produk sayur yang diperoleh dari sayur yang direbus dalam saus kedelai.",
    "Aktif",
  ],
  [
    "040202080005",
    "Kerupuk 4Jengkol",
    "Kerupuk jengkol adalah produk yang diperoleh dari buah jengkol segar yang dicampur dengan adonan tepung, dikukus, dibentuk, dan dikeringkan.",
    "Aktif",
  ],
  [
    "040202080006",
    "Dodol Rumput Laut",
    "Dodol rumput laut adalah produk olahan dengan bahan baku rumput laut kering atau bahan baku setengah jadi, dicampur gula dengan atau tanpa santan, dengan atau tanpa tepung beras ketan dan bahan lainnya yang selanjutnya mengalami pemasakan, pencetakan, pemotongan, dan pengeringan. Termasuk jenang rumput laut, gelamai rumput laut, lempok rumput laut, dan produk rumput laut sejenis lainnya.",
    "Aktif",
  ],
  [
    "040202080007",
    "Sayur Olahan Yang Dibentuk (Meat Analog / Fish Analog / Seafood Analog)",
    "",
    "Aktif",
  ],
  [
    "050101000001",
    "Kakao Massa (Cocoa liquor)",
    "Kakao massa (Cocoa liquor) adalah produk kakao berupa pasta yang diperoleh dari kakao nib (keping biji kakao) melalui penggilingan tanpa menghilangkan kandungan lemaknya.",
    "Aktif",
  ],
  [
    "050101000002",
    "Keik Kakao/Bungkil Kakao",
    "Keik kakao/bungkil kakao adalah produk kakao yang diperoleh dari pemisahan sebagian lemak dari keping biji kakao atau kakao massa. ",
    "Aktif",
  ],
  [
    "050101000003",
    "Kakao Bubuk",
    "Kakao bubuk adalah produk yang dihasilkan dari pengurangan lemak yang terkandung pada kakao massa (cocoa liquor) dan pencetakan menjadi keik kakao. Keik kakao (cocoa cake) dihancurkan dan dihaluskan menjadi kakao bubuk.  Karakteristik dasar : \x{2022} Kadar air tidak lebih dari 5%; \x{2022} Kadar lemak tidak kurang dari 10%; \x{2022} Kehalusan : tidak kurang dari 99,5% (b/b) lolos ayakan 200  mesh; \x{2022} Kandungan kulit (shell) tidak lebih dari 1,75% (b/b) dihitung dari  alkali free nib (nib bebas alkali). ",
    "Aktif",
  ],
  [
    "050101000004",
    "Lemak Kakao (Cocoa Butter)",
    "Lemak kakao (cocoa butter) adalah lemak yang diperoleh dari biji kakao  Karakteristik dasar : \x{2022} Asam lemak bebas (sebagai asam oleat) tidak lebih dari 1,75%; \x{2022} Bahan yang tidak tersaponifikasi tidak lebih dari 0,7%, kecuali  lemak kakao dari pengepresan tidak lebih dari 0,35%; \x{2022} Kadar air tidak lebih dari 0,2%.",
    "Aktif",
  ],
  [
    "050101000005",
    "Debu Kakao (Cocoa Dust)",
    "Debu kakao (Cocoa Dust) adalah fraksi dari biji kakao yang didapatkan dari proses pengupasan dan pemisahan kulit biji kakao (winnowing).",
    "Aktif",
  ],
  [
    "050101000006",
    "Bubuk Minuman Kakao (Drinking Cocoa Mixes)",
    "Bubuk minuman kakao (drinking cocoa mixes) adalah produk minuman dalam bentuk bubuk yang dibuat dari kakao bubuk dengan penambahan bahan pangan lain.  Karakteristik dasar: Kandungan kakao (total cocoa solids) tidak kurang dari 10%  dihitung sebagai berat kering.",
    "Aktif",
  ],
  [
    "050101000007",
    "Bubuk Minuman Cokelat (Drinking Chocolate)",
    "Bubuk minuman cokelat (drinking chocolate) adalah produk minuman dalam bentuk bubuk yang dibuat dari kakao bubuk dengan/atau tanpa penambahan kakao massa, lemak kakao, dapat ditambahkan bahan pangan lain.  Karakteristik dasar: Kandungan kakao (total cocoa solids) tidak kurang dari 20%  dihitung sebagai berat kering. ",
    "Aktif",
  ],
  [
    "050101000008",
    "Kakao Instan",
    "Kakao instan adalah produk minuman dalam bentuk bubuk yang dibuat dari kakao bubuk yang diproses sedemikian rupa sehingga mudah larut air, dengan atau tanpa penambahan gula atau bahan pangan lain  Karakteristik dasar : Kandungan kakao (total cocoa solids) tidak kurang dari 10% dihitung sebagai berat kering.",
    "Aktif",
  ],
  [
    "050101000009",
    "Cokelat Instan",
    "Cokelat instan adalah produk minuman dalam bentuk bubuk yang dibuat dari kakao bubuk dengan/atau tanpa penambahan kakao massa, yang diproses sedemikian rupa sehingga mudah larut air, dengan atau tanpa penambahan gula atau bahan pangan lain  Karakteristik dasar : Kandungan kakao (total cocoa solids) tidak kurang dari 20% dihitung sebagai berat kering. ",
    "Aktif",
  ],
  [
    "050101000010",
    "Cokelat Bubuk",
    "Cokelat bubuk adalah produk yang dibuat dari campuran kakao bubuk dan gula  Karakteristik dasar: mengandung tidak kurang dari 32% kakao bubuk (29% dihitung terhadap basis kering)",
    "Aktif",
  ],
  [
    "050102000001",
    "Sirup Cokelat",
    "Sirup cokelat adalah produk yang terbuat dari campuran gula dengan atau tanpa bahan pemanis lainnya, satu atau lebih produk kakao, dengan atau tanpa penambahan air dengan atau tanpa penambahan bahan pangan lain.  Karakteristik dasar:  Kandungan kakao (total cocoa solids) tidak kurang dari 8%.",
    "Aktif",
  ],
  [
    "050103000001",
    "Cokelat Pasta (Berbasis Minyak)",
    "Cokelat pasta (berbasis minyak) adalah produk yang berbentuk pasta berbasis lemak yang dibuat dari campuran satu atau lebih produk kakao dengan atau tanpa bahan pangan lain. Produk tersebut dapat digunakan sebagai olesan atau isian, misalnya olesan kakao-kacang, olesan kakao-susu.  Karakteristik dasar : \x{2022} Kadar air tidak lebih dari 2%; \x{2022} Kadar lemak tidak kurang dari 25%.",
    "Aktif",
  ],
  [
    "050103000002",
    "Cokelat Pasta (Berbasis Air)",
    "Cokelat pasta (berbasis air) adalah produk yang berbentuk pasta, berbasis air, yang dibuat dari campuran satu atau lebih produk kakao dengan atau tanpa bahan pangan lain.",
    "Aktif",
  ],
  [
    "050104000001",
    "Cokelat Hitam (Dark Chocolate, Semisweet Chocolate, Bittersweet Chocolate)",
    "Cokelat hitam (dark chocolate, semisweet chocolate, bittersweet chocolate) adalah produk yang diperhitungkan dalam kondisi tanpa kandungan air, mengandung tidak kurang dari 35% padatan kakao, tidak kurang dari 18% lemak kakao, dan tidak kurang dari 14% padatan kakao tanpa lemak. ",
    "Aktif",
  ],
  [
    "050104000002",
    "Cokelat Hitam Manis (Sweet Chocolate)",
    "Cokelat hitam manis (sweet chocolate) adalah produk yang diperhitungkan dalam kondisi tanpa kandungan air, mengandung tidak kurang dari 30% padatan kakao, tidak kurang dari 18% lemak kakao, dan tidak kurang dari 12% padatan kakao tanpa lemak.",
    "Aktif",
  ],
  [
    "050104000003",
    "Cokelat Hitam Kovertur (Dark Chocolate Couverture)",
    "Cokelat hitam kovertur (dark chocolate couverture) adalah produk yang diperhitungkan dalam kondisi tanpa kandungan air, mengandung tidak kurang dari 35% padatan kakao, tidak kurang dari 31% lemak kakao, dan tidak kurang dari 2,5% padatan kakao tanpa lemak.",
    "Aktif",
  ],
  [
    "050104000004",
    "Cokelat Susu (Milk Chocolate)",
    "Cokelat susu (milk chocolate) adalah produk yang diperhitungkan dalam kondisi tanpa kandungan air, mengandung tidak kurang dari 25% padatan kakao, tidak kurang dari 2,5% padatan kakao tanpa lemak, dan tidak kurang dari 12% padatan susu.",
    "Aktif",
  ],
  [
    "050104000005",
    "Cokelat Susu Kovertur (Milk Chocolate Couverture)",
    "Cokelat susu kovertur (milk chocolate couverture) adalah produk yang diperhitungkan dalam kondisi tanpa kandungan air, mengandung tidak kurang dari 25% padatan kakao, tidak kurang dari 15% lemak kakao, tidak kurang dari 2,5% padatan kakao tanpa lemak, tidak kurang dari 12% padatan susu, dan tidak kurang dari 31% total lemak. ",
    "Aktif",
  ],
  [
    "050104000006",
    "Cokelat Putih (White Chocolate)",
    "Cokelat putih (white chocolate) adalah produk yang diperhitungkan dalam kondisi tanpa kandungan air, mengandung tidak kurang dari 20% lemak kakao, dan tidak kurang dari 14% padatan susu.",
    "Aktif",
  ],
  [
    "050104000007",
    "Cokelat Putih Kovertur (White Chocolate Couverture)",
    "Cokelat putih kovertur (white chocolate couverture) adalah produk yang diperhitungkan dalam kondisi tanpa kandungan air, mengandung tidak kurang dari 20% lemak kakao, tidak kurang dari 14% padatan susu dan tidak kurang dari 25% total lemak.",
    "Aktif",
  ],
  [
    "050104000008",
    "Meses/Cokelat Butir/Cokelat Vermicelli /Streusel",
    "Meses/cokelat butir/cokelat vermicelli/streusel adalah butiran atau kepingan dari salah satu atau campuran dari kakao massa, kakao bubuk termasuk kakao bubuk yang dikurangi lemaknya dengan atau tanpa penambahan lemak kakao, dan bahan pangan lain.   Karakteristik dasar: \x{2022} Kadar lemak kakao tidak kurang dari 12%; \x{2022} Padatan kakao tanpa lemak tidak kurang dari 14%; \x{2022} Total padatan kakao tidak kurang dari 32%.",
    "Aktif",
  ],
  [
    "050104000009",
    "Meses Susu/Cokelat Susu Butir/Cokelat Susu Vermicelli",
    "Meses susu/cokelat susu butir/cokelat susu vermicelli adalah butiran atau kepingan dari salah satu atau campuran dari kakao massa, kakao bubuk termasuk kakao bubuk yang dikurangi lemaknya dengan atau tanpa penambahan lemak kakao, susu, dan bahan pangan lain.   Karakteristik dasar: \x{2022} Padatan kakao tanpa lemak tidak kurang dari 2.5%; \x{2022} Total padatan kakao tidak kurang dari 20%; \x{2022} Padatan susu tidak kurang dari 12%. ",
    "Aktif",
  ],
  [
    "050104000010",
    "Bonbon Cokelat /Permen Isi Cokelat",
    "Bonbon coklat/permen coklat adalah produk permen yang bagian dalamnya lunak dan terbuat dari campuran cairan kental (liquor) kakao, susu dan sirup gula.   Karakteristik dasar: Kandungan susu tidak lebih dari 5%.",
    "Aktif",
  ],
  [
    "050104000011",
    "Praline",
    "Praline adalah produk cokelat dengan ukuran satu suapan penuh, dimana dapat berupa cokelat isi (filled chocolate), atau kombinasi dari berbagai tipe cokelat dengan bahan pangan lain.   Karakteristik dasar: Kandungan cokelat tidak kurang dari 25%.",
    "Aktif",
  ],
  [
    "050104000012",
    "Truffles",
    "Truffles adalah produk cokelat yang dibuat dari campuran cokelat hitam atau cokelat susu dengan lemak kakao, minyak nabati dan bahan pangan lain, umumnya berbentuk bulat, kerucut, atau lengkungan, dimana dapat berupa cokelat isi (filled chocolate).",
    "Aktif",
  ],
  [
    "050104000013",
    "Cokelat Isi (filled chocolate)",
    "Cokelat isi (filled chocolate) adalah produk yang dilapisi dengan satu atau lebih lapisan cokelat dan cokelat berperisa dimana bagian tengah dapat dibedakan dengan lapisan luarnya. Cokelat isi tidak termasuk produk tepung confectionery, pastri dan biskuit.   Karakteristik dasar: Jumlah komponen cokelat untuk pelapisan tidak kurang dari 25% dari berat total produk akhir.",
    "Aktif",
  ],
  [
    "050104000014",
    "Cokelat Berperisa",
    "Cokelat berperisa adalah produk cokelat yang ditambahkan senyawa perisa.",
    "Aktif",
  ],
  [
    "050104000015",
    "Cokelat Aerasi",
    "Cokelat aerasi adalah produk cokelat yang mengalami proses aerasi sehingga terbentuk rongga-rongga kecil di dalamnya.",
    "Aktif",
  ],
  [
    "050104000016",
    "Cokelat Laminasi",
    "Cokelat laminasi adalah produk cokelat yang berlapis-lapis dibuat dengan menggunakan roller dan dalam kondisi plastis dipotong potong menjadi batangan atau serpihan.",
    "Aktif",
  ],
  [
    "050104000017",
    "Cokelat Komposit",
    "Cokelat komposit adalah produk cokelat berperisa yang ditambah dengan bahan lain yang dapat dimakan tidak termasuk tepung, pati dan lemak kecuali jika telah ada di dalam ingredien yang digunakan.   Karakteristik dasar: Kandungan cokelat tidak kurang dari 60%.",
    "Aktif",
  ],
  [
    "050105000001",
    "Cokelat Paduan/Cokelat Compound",
    "Cokelat paduan/cokelat compound adalah produk cokelat dimana sebagian atau seluruh lemak kakaonya diganti dengan lemak  nabati.  \x{2022} Cokelat paduan/cokelat compound hitam pahit (bitter dark compound chocolate); padatan kakao tidak kurang dari 20.0%.  \x{2022} Cokelat paduan/cokelat compound hitam (dark compound chocolate); padatan kakao tidak kurang dari 13.0%.  \x{2022} Cokelat paduan/cokelat compound hitam manis (sweet dark compound chocolate); padatan kakao tidak kurang dari 7.0%. \x{2022} Cokelat paduan/cokelat compound susu (milk compound chocolate); padatan kakao tidak kurang dari 5.0% dan padatan susu tidak kurang dari 9.0%.  \x{2022} Cokelat paduan/cokelat compound susu manis (sweet milk compound chocolate); padatan kakao tidak kurang dari 5.0% dan padatan susu tidak kurang dari 5.0%.  Persentase diperhitungkan atas dasar berat kering dalam produk. ",
    "Aktif",
  ],
  [
    "050105000002",
    "Cokelat Paduan/Cokelat Compound Butir",
    "Cokelat paduan/cokelat compound butir adalah cokelat paduan/cokelat compound yang dibentuk menjadi butiran.",
    "Aktif",
  ],
  [
    "050105000003",
    "Minuman Cokelat Paduan",
    "Minuman cokelat paduan adalah produk yang dibuat dari kakao bubuk dan/atau padatan kakao dengan penambahan bahan pangan lain. Produk dapat berbentuk cair siap minum, konsentrat cair, serbuk/bubuk, blok/kubus, atau bentuk lain.  Karakteristik dasar : Kandungan kakao (total cocoa solid) tidak kurang dari 5% (dihitung dari basis berat kering).",
    "Aktif",
  ],
  [
    "050105000004",
    "Cokelat Imitasi",
    "Cokelat imitasi adalah produk serupa cokelat paduan/cokelat compound dimana karakteristik dasarnya tidak memenuhi karakteristik dasar cokelat paduan/cokelat compound.",
    "Aktif",
  ],
  [
    "050105000005",
    "Cocoa Butter Equivalent",
    "Cocoa butter equivalent adalah lemak yang memiliki seluruh sifat fisik dan kimia lemak kakao tetapi komponen gliserida penyusunnya diturunkan dari sumber selain biji kakao. Karakter flavor tidak harus sama dengan lemak kakao. Produk ini terbuat dari lemak bukan laurat.",
    "Aktif",
  ],
  [
    "050105000006",
    "Pengganti Lemak Kakao Laurat (Lauric Cocoa Butter Replacer/Substitute = CBS Lauric)",
    "Pengganti lemak kakao laurat (lauric cocoa butter replacer/substitute = CBS lauric) adalah lemak yang memiliki sifat mirip dengan lemak kakao, tetapi tidak sama dengan lemak kakao. Produk ini terutama berbasis minyak sawit dan minyak inti sawit.",
    "Aktif",
  ],
  [
    "050105000007",
    "Pengganti Lemak Kakao Non-Laurat (Non-lauric Cocoa Butter Replacer/Substitute = CBS Non-Lauric)",
    "Pengganti lemak kakao non-laurat (nonlauric cocoa butter replacer/substitute = CBS non-lauric) adalah lemak yang dengan kesetaraan fase lemak antara 20% sampai 25% lemak kakao. Teksturnya menyerupai lilin (waxy).",
    "Aktif",
  ],
  [
    "050105000008",
    "Carob Coatings",
    "Carob coatings adalah produk pengganti lemak cokelat yang berasal dari sejenis kacang (locus bean) dengan dominasi kandungan karbohidrat tetapi tidak mengandung kafein dan teobromin.",
    "Aktif",
  ],
  [
    "050105000009",
    "Coating Dari Lembaga Gandum Bebas Lemak (Deffated Wheat Germ Coating)",
    "Coating dari lembaga gandum bebas lemak (deffated wheat germ coating) adalah pengganti lemak cokelat dari lembaga gandum bebas lemak yang melalui proses penyangraian dan proses spesifik lainnya.",
    "Aktif",
  ],
  [
    "050201000001",
    "Kembang Gula Keras/Permen Keras/Hard Candy/Boiled Sweet",
    "Kembang gula keras/permen keras/hard candy/boiled sweet adalah produk berbentuk padat yang terbuat dari gula/ gula lain dengan atau tanpa penambahan pemanis lain, dengan atau tanpa penambahan bahan pangan lain. Produk ini bertekstur keras dan tidak menjadi lunak apabila dikunyah.  Karakteristik Dasar : Kadar air tidak lebih dari 3,5%",
    "Aktif",
  ],
  [
    "050201000002",
    "Pastiles",
    "Pastiles adalah produk confectionery yang mengikutsertakan gelatin selain gom arab dan sirup glukosa yang lebih banyak sehingga berpengaruh pada tekstur permen yang lebih lunak. Pastiles biasanya berlapis granula atau tepung gula.",
    "Aktif",
  ],
  [
    "050201000003",
    "Pressed Candy/Lozenges",
    "Pressed candy/lozenges adalah sejenis permen yang terbuat dari tepung gula yang dibentuk menjadi pasta dapat ditambahkan gom, larutan gelatin atau keduanya.",
    "Aktif",
  ],
  [
    "050201000004",
    "Kembang Gula Isi Susu/Permen Isi Susu",
    "Karakteristik dasar : Kandungan susu tidak lebih dari 5%.",
    "Aktif",
  ],
  [
    "050202000001",
    "Kembang Gula Lunak/Permen Lunak",
    "Kembang gula lunak/permen lunak adalah kembang gula/permen yang bertekstur relatif lunak apabila dikunyah. Dapat dilapisi dengan pelapis gula atau cokelat atau bahan lainnya.  Karakteristik dasar : \x{2022} Kadar air permen lunak tidak lebih dari 7,5%; \x{2022} Kadar air permen lunak jeli tidak lebih dari 20%.",
    "Aktif",
  ],
  [
    "050202000002",
    "Kembang Gula Karamel/Permen Karamel",
    "Kembang gula karamel/permen karamel adalah kembang gula/permen yang terbuat dengan tambahan susu lemak penuh dan sumber lemak lain dari lemak nabati atau hewani dan terjadi reaksi pencoklatan (reaksi maillard) pada produk. Dari teksturnya dibedakan menjadi tiga jenis yaitu lunak, medium dan keras tergantung dari suhu pendidihan. Karamel lunak biasanya digunakan untuk pelapisan confectionery batangan dan untuk pelapisan dengan ekstrusi.",
    "Aktif",
  ],
  [
    "050202000003",
    "Fudge",
    "Fudge adalah kembang gula karamel/permen karamel yang memiliki tekstur lebih berpasir akibat proses kristalisasi karena kandungan gula yang lebih tinggi dari kembang gula  karamel/permen karamel.",
    "Aktif",
  ],
  [
    "050202000004",
    "Butterstotch",
    "Butterscotch adalah kembang gula karamel/permen karamel yang hanya menggunakan butter sebagai sumber lemak diluar bahan dasar gula dan glukosa.",
    "Aktif",
  ],
  [
    "050202000005",
    "Licorice",
    "Licorice adalah kembang gula lunak/ permen lunak yang dibuat dari ekstrak tanaman licorice (leguminous weed), tepung terigu, gula, sirup glukosa, gelatin, serta air. Proses utama adalah pemanasan sampai tergelatinisasi sempurna dengan kadar air rendah, pencetakan dengan ekstruder dan pengeringan. ",
    "Aktif",
  ],
  [
    "050202000006",
    "Toffee",
    "Toffee adalah kembang gula/permen dengan tekstur yang keras dan agak keyal yang dibuat dari campuran gula, susu, mentega atau lemak lain, garam, lesitin dengan atau tanpa penambahan kacang. Kandungan lemak dari permen toffee lebih rendah dari permen karamel.",
    "Aktif",
  ],
  [
    "050202000007",
    "Krokant/Brittles",
    "Krokant/brittles adalah kembang gula/permen sejenis toffee menggunakan susu dalam formulasinya dan didominasi oleh rasa kacang (almond, hazelnut atau kacang tanah) yang ditambahkan pada adonan dalam bentuk hancuran agak kasar (chopped). ",
    "Aktif",
  ],
  [
    "050202000008",
    "Marshmallow",
    "Marshmallow adalah kembang gula/permen lunak dan beraerasi yang dibuat dari gelatin/pektin/agar/gom arab, albumin telur, gula, glukosa dan gula invert.",
    "Aktif",
  ],
  [
    "050202000009",
    "Kembang Gula Jeli Pati (Starch Jelly)",
    "Kembang gula jeli pati (starch jelly) adalah kembang gula jeli/permen jeli yang menggunakan pati (pati jagung, pati gandum atau pati lainnya) sebagai salah satu bahan selain bahan-bahan lain yang biasa digunakan untuk produk confectionery.  Karakteristik dasar : Kadar air tidak lebih dari 20%.",
    "Aktif",
  ],
  [
    "050202000010",
    "Kembang Gula Jeli Agar dan Gelatin",
    "Kembang gula jeli agar dan gelatin adalah kembang gula jeli/permen jeli yang dibuat dari bahan dasar agar, gelatin atau pektin sehingga merupakan produk gel yang kenyal. Jeli agar lebih keras dan menyerupai karet (rubbery) dari jeli gelatin tetapi tekstur jeli gelatin tergantung dari jumlah gelatin yang digunakan. Jeli pektin lebih lunak dan lebih mudah terdispersi di dalam mulut.  Karakteristik dasar : Kadar air tidak lebih dari 20%.",
    "Aktif",
  ],
  [
    "050202000011",
    "Gula Kapas (Cotton Candy)/Arumanis",
    "Gula kapas (cotton candy)/arumanis adalah kembang gula/permen yang terbuat dari 100% gula yang dilelehkan dan diputar dengan mesin pemutar (spin) dimana cairan gula dilewatkan pada lubang kecil yang berputar sehingga membentuk massa seperti kapas.",
    "Aktif",
  ],
  [
    "050202000012",
    "Gulali",
    "Gulali adalah produk yang terbuat dari gula dan air yang dipanaskan membentuk adonan pasta atau semi plastis dan dicetak menjadi berbagai macam bentuk.",
    "Aktif",
  ],
  [
    "050203000001",
    "Permen Enting-Enting atau Nut Brittles",
    "Permen enting-enting atau nut brittles adalah permen keras dengan kandungan lemak dan susu lebih rendah dari karamel yang terbuat dari gula, mentega dan hancuran kacang-kacangan.",
    "Aktif",
  ],
  [
    "050203000002",
    "Raw Marzipan, Base Almond Paste",
    "Raw marzipan, base almond paste adalah massa yang diproduksi dari almond yang diblansir, mengandung tidak lebih dari 17% air dan 35% gula, dan 10% dari keseluruhan massa adalah gula invert. Kadar minyak almond tidak kurang dari 28%, mengandung tidak lebih dari 12% komponen pahit dari almond. Tanpa penghilangan rasa pahit.",
    "Aktif",
  ],
  [
    "050203000003",
    "Marzipan, Almond Paste",
    "Marzipan, almond paste adalah campuran dari raw marzipan dengan komposisi tidak melebihi proporsi gula. Gula dapat digantikan dengan sirup glukosa hingga 3,5% dan/atau larutan sorbitol 70% hingga 5% dari total berat marzipan.",
    "Aktif",
  ],
  [
    "050300000001",
    "Kembang Gula Karet/Permen Karet",
    "Kembang gula karet/permen karet adalah produk yang terbuat dari bahan dasar gom alami atau sintetis, pemanis, dan bahan pangan lain.  Karakteristik dasar : \x{2022} Kadar air tidak lebih dari 5%; \x{2022} Gom tidak kurang dari 12%. ",
    "Aktif",
  ],
  [
    "050400000001",
    "Icing",
    "Icing adalah bahan pelapis kue atau kukis yang terbuat dari bahan dasar gula, dan bahan lain dan lapisan membentuk massa yang keras setelah beberapa saat setelah dilapiskan.",
    "Aktif",
  ],
  [
    "050400000002",
    "Frosting",
    "Frosting adalah bahan pelapis berbentuk krim untuk kue yang terbuat dari bahan dasar gula, susu, lemak dan bahan lain.",
    "Aktif",
  ],
  [
    "050400000003",
    "Saus Butterstotch",
    "Saus butterscotch adalah sejenis sirup untuk dekorasi puding, baking product dan es krim yang terbuat dari gula, gula merah, cokelat, sirup jagung, margarin.",
    "Aktif",
  ],
  [
    "050400000004",
    "Saus/Topping/Olesan Cokelat",
    "Saus/topping/olesan cokelat adalah produk yang terbuat dari campuran gula, air dan atau minyak/lemak, satu atau lebih produk kakao, dengan atau tanpa bahan pangan lain, yang digunakan sebagai topping atau dekorasi.",
    "Aktif",
  ],
  [
    "050400000005",
    "Saus/Topping/Olesan Manis",
    "Saus/topping/olesan manis adalah produk yang terbuat dari campuran gula, air dan atau minyak/lemak, dengan atau tanpa bahan pangan lain, yang digunakan sebagai topping atau dekorasi. ",
    "Aktif",
  ],
  [
    "050400000006",
    "Saus/Topping/Olesan (non buah)",
    "Saus/topping/olesan (non buah) adalah produk untuk dekorasi/topping makanan atau minuman yang dibuat dengan gula dan/atau pemanis lain, dan bahan pangan lain. Topping (non buah) tidak termasuk non-dairy topping dari kategori pangan 02.3, topping buah dari kategori pangan 04.1.2.8, dan sirup cokelat dari kategori 05.1.2. ",
    "Aktif",
  ],
  [
    "050400000007",
    "Taburan Berbasis Gula",
    "Taburan berbasis gula adalah produk pangan berbentuk butiran atau kepingan dibuat dari gula dan lemak dengan atau tanpa penambahan bahan pangan lain, digunakan sebagai dekorasi atau topping es krim, kue, atau pangan lain.",
    "Aktif",
  ],
  [
    "060100000001",
    "Nasi Instan",
    "Nasi instan adalah nasi yang diperoleh dari beras sosoh yang direndam dalam air dan dipanaskan hingga patinya tergelatinisasi sempurna lalu dikeringkan. Dapat ditambahkan bumbu dan bahan pangan lain.  Karakteristik dasar: Kadar air tidak lebih dari 14%. ",
    "Aktif",
  ],
  [
    "060100000002",
    "Emping Beras",
    "Emping beras adalah produk beras ketan yang diperoleh dari beras ketan sosoh yang direndam dalam air dan dipanaskan hingga patinya tergelatinisasi sempurna, lalu dipipihkan dan dikeringkan.  Karakteristik dasar: Kadar air tidak lebih dari 14%.",
    "Aktif",
  ],
  [
    "060100000003",
    "Bubur Instan",
    "Bubur instan adalah produk bubur yang dibuat dari serealia, kacang-kacangan, atau umbi-umbian, yang mengalami proses pemasakan dan pengeringan. Dapat ditambahkan bumbu dan bahan pangan lain.  Karakteristik dasar: Kadar air tidak lebih dari 14%.",
    "Aktif",
  ],
  [
    "060100000004",
    "Gandum Hancur (Crushed Wheat)",
    "Gandum hancur (crushed wheat) adalah biji tanaman gandum yang bersih dan telah mengalami penghancuran, tetapi tidak termasuk gandum durum dan gandum durum merah.  Karakteristik dasar: \x{2022} Kadar air tidak lebih dari 15%; \x{2022} Kehalusan : lebih dari 40% lolos ayakan 8 mesh dan kurang dari 50% lolos ayakan 20 mesh.",
    "Nonaktif",
  ],
  [
    "060100000005",
    "Jagung Pipil",
    "Jagung pipil adalah biji utuh tanaman jagung yang berasal dari tanaman Zea mays antara lain Zea mays indentata L.,atau Zea mays indurata L., serta hasil hibridanya.  Karakteristik dasar: Kadar air tidak lebih dari 15,5%.",
    "Nonaktif",
  ],
  [
    "060100000006",
    "Biji Oats",
    "Biji oats adalah biji tanaman Avena sativa dan Avena byzantina.  Karakteristik dasar: \x{2022} Bau dan warna normal; \x{2022} Kadar air tidak lebih dari 14%.",
    "Nonaktif",
  ],
  [
    "060100000007",
    "Jewawut (Pearl Millet)",
    "Jewawut (pearl millet) adalah biji dari tanaman Pennisetum americanum L. yang utuh atau dihilangkan kulitnya. Jika perlu, biji ini bisa dikeringkan.  Karakteristik dasar: Kadar air tidak lebih dari 13%",
    "Nonaktif",
  ],
  [
    "060100000008",
    "Sorgum",
    "Sorgum adalah biji tanaman Shorgum bicolor (L.) Moench. baik yang utuh ataupun yang telah dihilangkan kulitnya, dan dikeringkan.  Karakteristik dasar: \x{2022} Kadar air tidak lebih dari 14,5%; \x{2022} Untuk biji utuh kadar tanin tidak lebih dari 0,5%; \x{2022} Untuk biji terkupas kadar tanin tidak lebih dari 0,3%.",
    "Nonaktif",
  ],
  [
    "060100000009",
    "Gaplek",
    "Gaplek adalah produk umbi yang diperoleh dari umbi singkong yang dikeringkan baik dalam bentuk utuh, potongan maupun irisan tipis.  Karakteristik dasar: Kadar air tidak lebih dari 14%.",
    "Nonaktif",
  ],
  [
    "060201000001",
    "Tepung Beras",
    "Tepung beras adalah tepung yang diperoleh dari penggilingan atau penumbukan beras (Oryza sativa L) yang telah maupun belum disosoh.  Karakteristik dasar: \x{2022} Kadar air tidak lebih dari 13%; \x{2022} Kehalusan : tidak kurang dari 90% lolos ayakan 80 mesh.",
    "Aktif",
  ],
  [
    "060201000002",
    "Tepung Beras Ketan",
    "Tepung beras ketan adalah tepung yang diperoleh dari penggilingan atau penumbukan beras ketan. Pati beras ketan hampir seluruhnya terdiri dari amilopektin.  Karakteristik dasar: \x{2022} Kadar air tidak lebih dari 13%; \x{2022} Kehalusan: tidak kurang dari 90% lolos ayakan 80 mesh.",
    "Aktif",
  ],
  [
    "060201000003",
    "Tepung Jagung",
    "Tepung jagung adalah tepung yang diperoleh dari penggilingan atau penumbukan biji jagung (Zea mays Linn) dari berbagai varietas. Termasuk tepung jagung putih dan tepung jagung kuning.  Karakteristik dasar: \x{2022} Kadar air tidak lebih dari 14%;  \x{2022} Kehalusan: tidak kurang dari 99% lolos ayakan 60 mesh, tidak kurang dari 70% lolos ayakan 80 mesh.",
    "Aktif",
  ],
  [
    "060201000004",
    "Tepung Kacang Hijau Tanpa Kulit",
    "Tepung kacang hijau tanpa kulit adalah tepung yang diperoleh dari penggilingan atau penumbukan biji tanaman kacang hijau (Phaseolus radiatus L.) yang sudah dihilangkan kulitnya.  Karakteristik dasar: \x{2022} Kadar air tidak lebih dari 10%; \x{2022} Kehalusan: 100% tepung lolos ayakan 40 mesh, 95% lolos ayakan 60 mesh.",
    "Aktif",
  ],
  [
    "060201000005",
    "Tepung Kacang Hijau Utuh",
    "Tepung kacang hijau utuh adalah tepung yang diperoleh dari  penggilingan atau penumbukan biji tanaman kacang hijau (Phaseolus radiatus L.) yang belum dihilangkan kulitnya.  Karakteristik dasar: \x{2022} Kadar air tidak lebih dari 10%; \x{2022} Kehalusan: 100% lolos ayakan 40 mesh, 95% lolos ayakan 60 mesh.",
    "Aktif",
  ],
  [
    "060201000006",
    "Tepung Kacang Merah",
    "Tepung kacang merah adalah tepung yang diperoleh dari penggilingan atau penumbukan biji tanaman kacang merah yang sudah dihilangkan kulitnya.  Karakteristik dasar: \x{2022} Kadar air tidak lebih dari 10%; \x{2022} Kehalusan: 100% lolos ayakan 40 mesh, 95% lolos ayakan 60 mesh.",
    "Aktif",
  ],
  [
    "060201000007",
    "Tepung Kedelai (Soybean Flour)",
    "Tepung kedelai adalah tepung yang diperoleh dari penggilingan atau penumbukan kedelai (Glycine max L).  Karakteristik dasar: \x{2022} Kadar air tidak lebih dari 10%; \x{2022} Kadar protein tidak kurang dari 50%. ",
    "Aktif",
  ],
  [
    "060201000008",
    "Semolina Gandum Durum ",
    "Semolina gandum durum adalah semolina yang diperoleh dari penggilingan atau penumbukan biji gandum durum (Triticum durum Desf) yang bersih, bebas dari kulit ari dan lembaga.  Karakteristik dasar: \x{2022} Kadar air tidak lebih dari 14,5 %; \x{2022} Kadar protein tidak kurang dari 10,5%; \x{2022} Kehalusan : tidak lebih dari 79% lolos ayakan 45 mesh.",
    "Aktif",
  ],
  [
    "060201000009",
    "Tepung Gandum Durum",
    "Tepung gandum durum adalah tepung yang diperoleh dari penggilingan atau penumbukan biji gandum durum (Triticum durum Desf) yang bersih, bebas dari kulit ari dan lembaga.  Karakteristik dasar: \x{2022} Kadar protein tidak kurang dari 11%;  \x{2022} Kehalusan : tidak kurang dari 80% lolos ayakan 45 mesh.",
    "Aktif",
  ],
  [
    "060201000010",
    "Semolina Gandum Durum Utuh dan Tepung Gandum Durum Utuh",
    "Semolina gandum durum utuh dan tepung gandum durum utuh adalah tepung yang diperoleh dari penggilingan atau penumbukan biji gandum durum (Triticum durum Desf) yang bersih, tetapi masih mengandung kulit ari dan lembaga.  Karakteristik dasar: \x{2022} Kadar air tidak lebih dari 14,5%; \x{2022} Untuk semolina gandum durum utuh kadar abu tidak lebih dari  2,1%; \x{2022} Kadar protein tidak kurang dari 11,5%.",
    "Aktif",
  ],
  [
    "060201000011",
    "Tepung Jewawut (Pearl Millet Flour)",
    "Tepung jewawut (pearl millet flour) adalah tepung yang diperoleh dari penggilingan atau penumbukan endosperm biji pearl millet (Pennisetum americanum L.) yang telah dikupas dan dipisahkan dari lembaganya.  Karakteristik dasar: \x{2022} Kadar air tidak lebih dari 13%; \x{2022} Kehalusan: tepung halus 100% lolos ayakan 32 mesh dan tepung dengan kehalusan medium 100% lolos ayakan 16 mesh.",
    "Aktif",
  ],
  [
    "060201000012",
    "Tepung Sorgum",
    "Tepung sorgum adalah tepung yang diperoleh dari hasil penggilingan atau penumbukan endosperm biji Shorgum bicolor (L.) Moench yang telah dikupas dan dipisahkan dari lembaganya.  Karakteristik dasar: \x{2022} Kadar air tidak lebih dari 14,5%; \x{2022} Kadar tanin tidak lebih dari 0,3% bk; \x{2022} Kehalusan: tepung halus 100% lolos ayakan 32 mesh dan tepung dengan kehalusan medium 100% ayakan 16 mesh.",
    "Aktif",
  ],
  [
    "060201000013",
    "Tepung Terigu",
    "Tepung terigu adalah tepung yang dibuat dari hasil penggilingan atau penumbukan endosperma biji gandum Triticum aestivum L (club wheat) dan/atau Triticum compactum Host atau campuran keduanya dengan penambahan Fe, Zn, vitamin B1, vitamin B2, dan asam folat sebagai fortifikan.   Karakteristik dasar: \x{2022} Kadar air tidak lebih dari 14,5%; \x{2022} Kehalusan tepung: tidak kurang dari 95% lolos ayakan 70 mesh; \x{2022} Kandungan zat besi besi (Fe) tidak kurang dari 50 mg/kg, seng (Zn) tidak kurang dari 30 mg/kg, vitamin B1 tidak kurang dari 2,5 mg/kg, vitamin B2 tidak kurang dari 4 mg/kg, asam folat tidak kurang dari 2 mg/kg; \x{2022} Kadar protein tidak kurang dari 7%.",
    "Aktif",
  ],
  [
    "060201000014",
    "Tepung Terigu Self-Raising",
    "Tepung terigu self-raising adalah tepung terigu dengan bahan pengembang kue/leavening agent atau ingredien lain maupun kombinasinya.  Karakteristik dasar: \x{2022} Bila dibasahi dan dipanaskan, harus melepaskan tidak kurang dari 0,64% karbondioksida; \x{2022} Tidak boleh mengandung lebih dari 0,6% sulfat sebagai kalsium sulfat; \x{2022} Mengandung bahan pengembang kue tidak kurang dari 0,5%; \x{2022} Kadar air tidak lebih dari 14,5%; \x{2022} Kehalusan tepung: tidak kurang dari 95 lolos ayakan 70 mesh; \x{2022} Kandungan zat besi besi (Fe) tidak kurang dari 50 mg/kg, seng (Zn) tidak kurang dari 30 mg/kg, vitamin B1 tidak kurang dari 2,5 mg/kg, vitamin B2 tidak kurang dari 4 mg/kg, asam folat tidak kurang dari 2 mg/kg; \x{2022} Kadar protein tidak kurang dari 7%. ",
    "Aktif",
  ],
  [
    "060201000015",
    "Tepung Terigu Termodifikasi ",
    "Tepung terigu termodifikasi adalah tepung terigu yang telah mengalami proses modifikasi baik fisik dan/atau kimia dan digunakan sebagai tepung terigu.  Karakteristik dasar : \x{2022} Kadar air tidak lebih dari 14,5%; \x{2022} Kehalusan tepung tidak kurang dari 40% lolos ayakan 70 mesh; \x{2022} Kandungan zat besi (Fe) tidak kurang dari 50 mg/kg, seng (Zn) tidak kurang dari 30 mg/kg, vitamin B1 tidak kurang dari 2.5 mg/kg, vitamin B2 tidak kurang dari 4 mg/kg asam folat tidak kurang dari 2 mg/kg; \x{2022} Kadar protein tidak kurang dari 7%. ",
    "Aktif",
  ],
  [
    "060201000016",
    "Tepung Gluten Terigu (Wheat Gluten Powder)",
    "Tepung gluten terigu adalah tepung yang diperoleh dari tepung terigu yang telah mengalami pemisahan sebagian besar patinya.  Karakteristik dasar: \x{2022} Kadar air tidak lebih dari 10%; \x{2022} Kadar pati tidak lebih dari 44% (bk);  \x{2022} Kadar protein tidak kurang dari 60% (bk). ",
    "Aktif",
  ],
  [
    "060201000017",
    "Tepung Terigu dengan Penambahan Protein",
    "Tepung terigu dengan penambahan protein adalah tepung yang diperoleh dari tepung terigu dengan penambahan protein hingga kandungan nitrogen tidak kurang dari 2,7% (bk).",
    "Aktif",
  ],
  [
    "060201000018",
    "Tepung Terigu Utuh (Wholemeal Wheat Flour)",
    "Tepung terigu utuh (wholemeal wheat flour) adalah tepung yang bersih dan baik, diperoleh dari gandum utuh yang bersih dan baik yang telah digiling.  Karakteristik dasar: \x{2022} Kadar serat kasar tidak kurang dari 2% (bk); \x{2022} Kadar air tidak lebih dari 14,5%; \x{2022} Kehalusan tepung: tidak kurang dari 95 lolos ayakan 70 mesh; \x{2022} Kandungan zat besi besi (Fe) tidak kurang dari 50 mg/kg, seng (Zn) tidak kurang dari 30 mg/kg, vitamin B1 tidak kurang dari 2,5 mg/kg, vitamin B2 tidak kurang dari 4 mg/kg, asam folat tidak kurang dari 2 mg/kg; \x{2022} Kadar protein tidak kurang dari 7%. ",
    "Aktif",
  ],
  [
    "060201000019",
    "Tepung Kulit Ari (Fine Bran)",
    "Tepung kulit ari (fine bran) adalah tepung yang diperoleh dari penggilingan atau penumbukan kulit ari biji-bijian seperti beras, gandum, oats, dan lain-lain yang terpisah dari endospermanya dan dalam keadaan bersih dan baik, dengan tingkat kehalusan tertentu.",
    "Aktif",
  ],
  [
    "060201000020",
    "Tepung Singkong",
    "Tepung singkong adalah tepung yang diperoleh dari penggilingan atau penumbukan umbi singkong (Manihot sp.). Umbi singkong yang digunakan adalah yang aman dikonsumsi.  Karakteristik dasar: \x{2022} Kadar air tidak lebih dari 12%;  \x{2022} Kehalusan: tidak kurang dari 90% lolos ayakan 80 mesh.",
    "Aktif",
  ],
  [
    "060201000021",
    "Tepung Mokaf",
    "Tepung mokaf adalah tepung yang diperoleh dari ubi kayu (Manihot sp.) dengan proses fermentasi asam laktat.  Karakteristik dasar: \x{2022} Kadar air tidak lebih dari 13%;  \x{2022} Kehalusan: tidak kurang dari 90% lolos ayakan 100 mesh, dan 100% lolos ayakan 80 mesh.",
    "Aktif",
  ],
  [
    "060201000022",
    "Tepung Gaplek",
    "Tepung gaplek adalah tepung yang diperoleh dari penggilingan atau penumbukan gaplek (umbi singkong kering utuh atau dipotong\2potong). Umbi singkong yang digunakan adalah yang aman dikonsumsi.",
    "Aktif",
  ],
  [
    "060201000023",
    "Tepung Umbi Lainnya (Tepung Kentang, Tepung Ubi Jalar, Tepung Garut, Tepung Ganyong dan lain-lain.)",
    "Tepung umbi lainnya (tepung kentang, tepung ubi jalar, tepung garut, tepung ganyong dan lain-lain) adalah tepung yang diperoleh dari penggilingan atau penumbukan umbi. Umbi yang digunakan adalah yang aman dikonsumsi.",
    "Aktif",
  ],
  [
    "060201000024",
    "Tepung Aren",
    "Tepung aren adalah tepung yang diperoleh dari penggilingan atau penumbukan empulur pohon aren (Arenga pinnata Merr).  Karakteristik dasar: \x{2022} Kadar air tidak lebih dari 13%; \x{2022} Kehalusan: 95% lolos ayakan 80 mesh.",
    "Aktif",
  ],
  [
    "060201000025",
    "Kinako",
    "Kinako adalah tepung kedelai panggang.",
    "Aktif",
  ],
  [
    "060201000026",
    "Konjac Flour",
    "Tepung konjac adalah tepung glukomanan yang diperoleh hasil ekstraksi umbi iles-iles (Amorphophallus konjac). ",
    "Aktif",
  ],
  [
    "060201000027",
    "Maida",
    "Maida adalah tepung gandum hasil rafinasi dan pemutihan baik secara alami maupun kimiawi.",
    "Aktif",
  ],
  [
    "060201000028",
    "Tepung Iles-iles",
    "Tepung iles-iles adalah tepung yang diperoleh dari penggilingan atau penumbukan umbi tanaman Amorphophallus muelleri.",
    "Aktif",
  ],
  ["060201000029", "Tepung Kacang Lainnya", "", "Aktif"],
  [
    "060202000001",
    "Pati Garut",
    "Pati garut adalah pati yang diperoleh dari sari umbi garut (Maranta arundinaceace L).   Karakteristik dasar: \x{2022} Kadar air tidak lebih dari 16%; \x{2022} Kehalusan: tidak kurang dari 95% lolos ayakan 100 mesh.",
    "Aktif",
  ],
  [
    "060202000002",
    "Pati Jagung atau Maizena",
    "Pati jagung atau maizena adalah pati yang diperoleh dari biji jagung (Zea mays Linn) berbagai varietas.  Karakteristik dasar: Kadar air tidak lebih dari 10%.",
    "Aktif",
  ],
  [
    "060202000003",
    "Pati Sagu",
    "Pati sagu adalah pati yang diperoleh dari pengolahan empulur pohon sagu (Metroxylon sp) yang bersih dan baik.  Karakteristik dasar: Kadar air tidak lebih dari 13%.",
    "Aktif",
  ],
  [
    "060202000004",
    "Pati Kacang Hijau/Hunkwee",
    "Pati kacang hijau atau hunkwee adalah pati yang diperoleh dari kacang hijau (Phaseolusradiatus).  Karakteristik dasar: Kadar air tidak lebih dari 14%.",
    "Aktif",
  ],
  [
    "060202000005",
    "Tapioka/Pati Singkong/Pati Ubi Kayu",
    "Tapioka/pati singkong/pati ubi kayu adalah pati yang diperoleh dari singkong/ubi kayu (Manihot sp.)  Karakteristik dasar: Kadar air tidak lebih dari 14%. ",
    "Aktif",
  ],
  [
    "060202000006",
    "Dekstrin",
    "Dekstrin adalah produk pati yang diperoleh dari pati yang dihidrolisis dengan pemanasan kering, perlakuan asam atau enzimatik.  Karakteristik dasar: Kadar protein tidak lebih dari 1,0%.",
    "Aktif",
  ],
  [
    "060202000007",
    "Pati Termodifikasi",
    "Pati termodifikasi adalah pati yang diperoleh dari modifikasi molekuler pati baik secara fisik, kimia, enzimatis maupun genetis untuk memperoleh sifat fungsional pati yang unggul.",
    "Aktif",
  ],
  [
    "060202000008",
    "Pati Pragelatinisasi",
    "Pati pragelatinisasi adalah pati yang diperoleh dari bubur pati yang dimasak, dikeringkan dan digiling. Proses pengolahan ini membuat pati pragelatinisasi dapat mengembang di dalam air dingin.",
    "Aktif",
  ],
  [
    "060300000001",
    "Bulgur",
    "Bulgur adalah gandum pratanak yang masih mengandung lembaga dan kulit ari, yang dapat direkonstitusi dengan pemasakan atau perendaman dalam air.",
    "Aktif",
  ],
  [
    "060300000002",
    "Keping Jagung (Corn Flake)",
    "Keping jagung (corn flake) adalah produk jagung yang diperoleh dari  proses gelatinisasi pati jagung dengan berbagai teknik misalnya  ekstrusi, lalu dikeringkan.",
    "Aktif",
  ],
  [
    "060300000003",
    "Meal",
    "Meal adalah produk serealia yang diperoleh dari penggilingan  serealia. Produk ini dapat berupa campuran serealia.",
    "Aktif",
  ],
  [
    "060300000004",
    "Meal Lembaga Gandum (Wheat Germ Meal)",
    "Meal lembaga gandum (wheat germ meal) adalah produk meal yang  diperoleh dari lembaga atau embrio biji gandum, bersama dengan  kulit ari dan bagian lain.  Karakteristik dasar:  Kandungan lembaga tidak kurang dari 60%.",
    "Aktif",
  ],
  [
    "060300000005",
    "Oatmeal",
    "Oatmeal adalah produk meal yang diperoleh dari penggilingan atau  penumbukan biji oat dan telah dipisahkan dari kulitnya.  Karakteristik dasar:  Kandungan lemak tidak kurang dari 5%.",
    "Aktif",
  ],
  [
    "060300000006",
    "Whole Maize (Corn) Meal",
    "Whole maize (corn) meal adalah produk meal yang diperoleh dari  penggilingan atau penumbukan biji jagung (Zea mays L.) yang telah  tua, belum berkecambah, sampai tingkat kehalusan tertentu. Pada  persiapan penggilingan, partikel kasar dapat dipisahkan, digiling  ulang, dan dikombinasi kembali dengan bahan asalnya.  Karakteristik dasar:  \x{2022} Kadar air tidak lebih dari 15%;  \x{2022} Kehalusan: tidak kurang dari 95% lolos ayakan 10 mesh dan 45%  lolos ayakan 24 mesh dan tidak kurang dari 35% lolos ayakan 65 mesh.",
    "Aktif",
  ],
  [
    "060300000007",
    "Degermed Maize (Corn) Meal",
    "Degermed maize (corn) meal adalah produk meal yang diperoleh dari  penggilingan atau penumbukan biji jagung (Zea mays L.) yang telah  tua, bersih dari jamur, bersih dari biji gulma dan bersih dari  serealia lain, sampai tingkat kehalusan tertentu dan selanjutnya  dipisahkan lembaga dan kulit ari. Pada persiapan penggilingan,  partikel kasar dapat dipisahkan, digiling ulang, dan dikombinasi  kembali dengan bahan asalnya.  Karakteristik dasar:  \x{2022} Kadar air tidak lebih dari 15%;  \x{2022} Kehalusan: tidak kurang dari 95% lolos ayakan 0,85 mm dan  tidak kurang dari 45% lolos ayakan 24 mesh dan tidak kurang dari 25% lolos ayakan 65 mesh.",
    "Aktif",
  ],
  [
    "060300000008",
    "Nasi Jagung",
    "Nasi jagung adalah produk jagung yang diperoleh dari penggilingan  atau penumbukan kasar jagung pipil yang kemudian diolah lebih  lanjut seperti memasak nasi.",
    "Aktif",
  ],
  [
    "060300000009",
    "Sereal Siap Santap",
    "Sereal siap santap adalah produk siap santap yang berasal dari  serealia yang diperoleh dari satu atau campuran beberapa jenis  serealia dengan ditambahkan bahan lain seperti gula, malt, madu,  garam, dan bahan pangan lain. Produk biasa dikonsumsi untuk  sarapan dan/atau untuk tujuan lain. Bentuk produk dapat berupa  flake, keping, batang, dan bubur.  Karakteristik dasar:  Kandungan serealia tidak kurang dari 50%.",
    "Aktif",
  ],
  [
    "060300000010",
    "Sereal Siap Santap dengan Serealia Utuh (Whole Grain Ready To Eat Cereal)",
    "Sereal siap santap dengan serealia utuh (whole grain ready to eat  cereal) adalah produk sereal siap santap yang diperoleh dari serealia  sebagai bahan baku utama dimana sebagian atau keseluruhannya  adalah serealia utuh dan dapat dicampur beberapa serealia yang  belum dimasak, telah dimasak sebagian, atau dimasak sempurna  dengan ditambahkan bahan lain seperti: gula, malt, madu, garam,  dan bahan pangan lain, dimana produk akhirnya dapat berbentuk  flake, keping, batang, atau bubur.  Karakteristik dasar:  \x{2022} Kandungan serealia utuh tidak kurang dari 25%;  \x{2022} Kadar serat pangan tidak kurang dari 3g/100g.",
    "Aktif",
  ],
  [
    "060300000011",
    "Serbuk Minuman Sereal",
    "Serbuk minuman sereal/minuman serbuk serealia adalah produk  minuman serealia dalam bentuk bubuk yang diperoleh dari satu  atau lebih serealia dengan atau tanpa tambahan bahan pangan lain.  Karakteristik dasar:  Kandungan serealia tidak kurang dari 25%.",
    "Aktif",
  ],
  [
    "060300000012",
    "Tiwul",
    "Tiwul adalah produk yang diperoleh dari tepung gaplek kemudian  direndam dalam air dan dikukus.",
    "Aktif",
  ],
  [
    "060300000013",
    "Degermed Maize (Corn) Grits",
    "Degermed maize (corn) grits adalah produk jagung yang diperoleh  dari penggilingan atau penumbukan biji jagung (Zea mays L.) yang  telah tua, bersih dari jamur, bersih dari biji gulma dan bersih dari  serealia lain; sampai tingkat kehalusan tertentu dan selanjutnya  dipisahkan seluruh lembaga dan kulit ari.  Karakteristik dasar:  \x{2022} Kadar air tidak lebih dari 15%;  \x{2022} Kehalusan: tidak kurang dari 95% lolos ayakan 9 mesh dan tidak kurang dari 20% lolos ayakan 24 mesh.",
    "Aktif",
  ],
  [
    "060300000014",
    "Gari",
    "Gari dalah produk ubi kayu/singkong yang diperoleh dari  pengolahan ubi kayu/singkong (Manihot sp.). Proses pengolahan  meliputi pengupasan, pencucian, dan pemarutan, dilanjutkan  dengan fermentasi, pengepresan, fragmentasi, granulasi,  pengeringan bila perlu, pengayakan dan perlakuan panas yang  sesuai. Gari berbentuk tepung atau granula dengan ukuran yang bervariasi.  Karakteristik dasar:  Kadar air tidak lebih dari 12%.",
    "Aktif",
  ],
  [
    "060300000015",
    "Granola",
    "Granola adalah produk sereal yang merupakan campuran gandum,  kacang-kacangan, madu, buah kering dan dapat ditambahkan  dengan ingredient lainnya. Produk ini dapat dikonsumsi dengan  susu maupun yoghurt.",
    "Aktif",
  ],
  [
    "060401000001",
    "Mi Basah Mentah",
    "Mi basah mentah adalah produk pangan yang diperoleh dari tepung  terigu dengan atau tanpa penambahan bahan lain, berbentuk khas  mi yang diperoleh melalui proses sheeting, slitting, atau proses lain  yang sesuai (belum dipanaskan, direbus, dikukus, dimasak, dipragelatinisasi).  Karakteristik dasar:  \x{2022} Kadar air tidak kurang dari 20% dan tidak lebih dari 40%;  \x{2022} Kadar protein tidak kurang dari 5%.",
    "Aktif",
  ],
  [
    "060401000002",
    "Mi Basah Mentah lainnya",
    "Mi basah mentah lainnya adalah mi basah mentah yang dibuat dari  selain tepung terigu. Nama jenis untuk kategori ini misalnya mi  basah mentah jagung.",
    "Aktif",
  ],
  [
    "060401000003",
    "Kulit Pangsit/Risol/Lumpia  ",
    "Kulit pangsit adalah produk tepung yang diperoleh dari adonan  tepung dengan air dengan atau tanpa penambahan bahan pangan  lain. Produk ini berbentuk lembaran tipis, dan dapat digunakan  sebagai pembungkus pangsit, siomay, atau risol.  Karakteristik dasar:  Kadar air tidak kurang dari 20% dan tidak lebih dari 35%.",
    "Aktif",
  ],
  [
    "060401000004",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah",
    "Pangsit/pastel/lumpia/risol/samosa mentah adalah produk yang  dibuat dari adonan tepung dengan air dengan atau tanpa  penambahan bahan pangan lain, dan belum dimasak. Produk ini  dapat diisi dengan daging, ikan, sayuran, atau bahan pangan lain.  Termasuk dalam kategori ini adalah produk lain yang sejenis.",
    "Aktif",
  ],
  [
    "060402000001",
    "Kuetiaw Kering",
    "Kuetiaw kering adalah produk pangan kering yang diperoleh dari  tepung beras, berbentuk khas kuetiaw.",
    "Aktif",
  ],
  [
    "060402000002",
    "Pasta",
    "Pasta adalah produk yang dibuat dari semolina atau tepung  gandum durum atau campurannya sebagai bahan baku utama dan  dapat mengandung pangan sumber karbohidrat lain, tepung, telur,  garam, dan bahan pangan lain, yang diperoleh melalui ekstrusi,  dicetak dalam bantuk tertentu/spesifik dan dikeringkan. Untuk  produk pasta susu dalam pembuatan adonannya digunakan susu  sebagai pengganti air, baik sebagian maupun seluruhnya. Termasuk  makaroni, spaghetti, fettuccini, penne, farfale, fusilli, ravioli, lasagna,  cannelloni, rigatoni.  Karakteristik dasar:  \x{2022} Kadar air tidak lebih dari 12,5%;  \x{2022} Kadar protein tidak kurang dari 10%;  \x{2022} Untuk produk pasta susu, mengandung total padatan susu tidak kurang dari 3,8%.  \x{2022} Bentuk pasta spesifik sesuai penamaannya:  - Spaghetti : bentuk memanjang seperti mie.  - Fettuccini : bentuk panjang dan pipih seperti pita kaset, mirip kwetiaw.  - Penne : bentuk seperti mata pena.  - Makaroni : terdapat tiga jenis tipe yaitu tubular, orzo dan elbow.  - Farfalle : bentuk seperti kupu\x{2013}kupu dengan bagian tepi yang bergerigi.  - Fusilli : bentuk spiral.  - Ravioli : bentuk seperti pastel berbentuk segiempat.  - Lasagna, bentuk lembaran.  - Cannelloni : bentuk tabung.  - Rigatoni : berukuran panjang 5 cm dan berdiameter 3 cm serta memiliki permukaan yang bergaris.",
    "Aktif",
  ],
  [
    "060402000003",
    "Pasta Gandum Utuh",
    "Pasta gandum utuh adalah pasta yang diperoleh dari tepung  gandum utuh atau tepung gandum durum utuh, dan dapat  ditambahkan bahan pangan lain.  Karakteristik dasar:  \x{2022} Kadar air tidak lebih dari 12,5%;  \x{2022} Kadar protein tidak kurang dari 10%.",
    "Aktif",
  ],
  [
    "060402000004",
    "Produk Pasta Gandum dan Kedelai",
    "Produk pasta gandum dan kedelai adalah pasta yang diberi  tambahan tepung kedelai, dan dapat ditambahkan bahan pangan lain.  Karakteristik dasar:  \x{2022} Penambahan tepung kedelai tidak kurang dari 12,5%;  \x{2022} Kadar protein tidak kurang dari 13%.",
    "Aktif",
  ],
  [
    "060402000005",
    "Produk Pasta Sayur",
    "Produk pasta sayur adalah pasta yang diberi tambahan sayur  seperti tomat, artichoke (Cynara cardunculus), bit, wortel, atau  bayam, dan dapat ditambahkan bahan pangan lain.  Karakteristik dasar:  \x{2022} Penambahan sayur tidak kurang dari 3% (dihitung sebagai bahan segar);  \x{2022} Kadar protein tidak kurang dari 9%.",
    "Aktif",
  ],
  [
    "060402000006",
    "Pasta Lainnya",
    "Pasta lainnya adalah produk pasta yang dibuat dari selain gandum  sebagai bahan utama dan bahan pangan lain, yang diperoleh  melalui ekstrusi atau pencetakan adonan. Nama jenis untuk  kategori ini misalnya pasta jagung.  Karakteristik dasar:  Kadar air tidak lebih dari 12,5%",
    "Aktif",
  ],
  [
    "060402000007",
    "Produk Mi Gandum dan Kedelai",
    "Produk mi gandum dan kedelai adalah mi dari tepung gandum  dengan penambahan tepung kedelai.  Karakteristik dasar:  \x{2022} Penambahan tepung kedelai tidak kurang dari 12,5%;  \x{2022} Kadar protein tidak kurang dari 13%.",
    "Aktif",
  ],
  [
    "060402000008",
    "Produk Mi Sayur",
    "Produk mi sayur adalah mi yang diberi tambahan sayur seperti  tomat, artichoke, bit, wortel, bayam atau sayur lainnya. Sayur yang  ditambahkan dapat berupa sayuran segar, kering, tepung,  hancuran, ekstrak, atau konsentrat.  Karakteristik dasar:  Sayur yang ditambahkan tidak kurang dari 3% dihitung sebagai sayuran segar.",
    "Aktif",
  ],
  [
    "060403000001",
    "Sohun",
    "Sohun adalah produk berbentuk untaian kering yang diperoleh dari  pati kacang hijau (hunkwee).  Karakteristik dasar:  Kadar air tidak lebih dari 13%.",
    "Aktif",
  ],
  [
    "060403000002",
    "Sohun Lainnya",
    "Sohun lainnya adalah produk berbentuk mi kering yang diperoleh  dari pati sagu, pati aren, pati jagung (maizena), dan pati lainnya.  Karakteristik dasar:  Kadar air tidak lebih dari 13%.",
    "Aktif",
  ],
  [
    "060403000003",
    "Bihun",
    "Bihun adalah produk pangan kering yang diperoleh dari tepung  beras dengan atau tanpa bahan lain.  Karakteristik dasar:  Kadar air tidak lebih dari 13%.",
    "Aktif",
  ],
  [
    "060403000004",
    "Bihun Lainnya",
    "Bihun lainnya adalah bihun yang dibuat dari tepung selain dari  tepung beras dengan atau tanpa bahan lain. Nama jenis untuk  produk ini misalnya bihun jagung.  Karakteristik dasar:  Kadar air tidak lebih dari 13%.",
    "Aktif",
  ],
  [
    "060403000005",
    "Pasta Instan",
    "Pasta instan adalah produk pasta yang telah dimasak lalu  dikeringkan dan dapat ditambah bumbu.  Karakteristik dasar:  \x{2022} Kadar air tidak lebih dari 12,5%;  \x{2022} Kadar protein tidak kurang dari 10%.",
    "Aktif",
  ],
  [
    "060403000006",
    "Pasta Instan Lainnya ",
    "Pasta instan lainnya adalah produk pasta yang dibuat dari selain  gandum sebagai bahan utama dan bahan pangan lain, melalui  proses pemasakan (gelatinisasi pati) dan pengeringan. Nama jenis  untuk kategori ini misalnya makaroni jagung dan makaroni ubi jalar.  Karakteristik dasar:  Kadar air tidak lebih dari 12,5%.",
    "Aktif",
  ],
  [
    "060403000007",
    "Mi Kering ",
    "Mi kering adalah produk mi kering yang diperoleh dari tepung terigu  dengan atau tanpa penambahan bahan lain dan telah mengalami  pengeringan atau penggorengan. Produk mi kering gandum  mengandung tidak kurang dari 60% bahan dari gandum.  Karakteristik dasar :  \x{2022} Kadar air tidak lebih dari 11%;  \x{2022} Kadar protein tidak kurang dari 6%.",
    "Aktif",
  ],
  [
    "060403000008",
    "Bihun Instan",
    "Bihun instan adalah produk bihun kering yang matang setelah  dimasak atau diseduh menggunakan air mendidih atau air panas  dalam waktu singkat beserta bumbu dengan atau tanpa  pelengkapnya yang terdapat dalam kemasan.  Karakteristik dasar:  Kadar air tidak lebih dari 13%.",
    "Aktif",
  ],
  [
    "060403000009",
    "Kuetiaw Instan",
    "Kuetiaw instan adalah kuetiaw kering yang sebelumnya telah  mengalami proses pemasakan sehingga patinya tergelatinisasi.  Kuetiaw instan akan matang setelah dimasak atau diseduh dengan  air mendidih dalam waktu 4 menit.",
    "Aktif",
  ],
  [
    "060403000010",
    "Makaroni Instan",
    "Makaroni instan adalah makaroni kering yang sebelumnya telah  mengalami proses pemasakan sehingga patinya tergelatinisasi.  Makaroni instan akan matang setelah dimasak atau diseduh dengan  air mendidih dalam waktu 4 menit.",
    "Aktif",
  ],
  [
    "060403000011",
    "Mi Basah Matang",
    "Mi basah matang adalah produk makanan yang dibuat dari tepung  terigu dengan atau tanpa penambahan bahan pangan lain, yang  telah mengalami pengukusan atau perebusan.  Karakteristik dasar:  Kadar air tidak kurang dari 20% dan tidak lebih dari 60%.",
    "Aktif",
  ],
  [
    "060403000012",
    "Mi Basah Matang Lainnya",
    "Mi basah matang lainnya adalah mi basah matang yang dibuat  selain dari tepung terigu seperti tepung jagung, ubi jalar, iles-iles,  dan lainnya, dengan atau tanpa penambahan bahan pangan lain,  yang telah mengalami pengukusan atau perebusan.",
    "Aktif",
  ],
  [
    "060403000013",
    "Mi Instan",
    "Mi instan adalah produk yang dibuat dari bahan baku utama  tepung terigu dengan atau tanpa penambahan bahan pangan lain,  dikukus, dan digoreng atau dikeringkan, dan matang setelah  dimasak atau diseduh menggunakan air mendidih atau air panas  dalam waktu singkat beserta bumbu dan atau tanpa pelengkapnya  yang terdapat dalam kemasan.  Karakteristik dasar:  \x{2022} Kadar air tidak lebih dari 10% jika diolah dengan proses penggorengan;  \x{2022} Kadar air tidak lebih dari 14% jika diolah dengan proses pengeringan.",
    "Aktif",
  ],
  [
    "060403000014",
    "Mi Instan Lainnya",
    "Mi instan lainnya adalah produk yang diperoleh dari selain tepung  terigu seperti tepung jagung, dan lainnya, dengan atau tanpa  penambahan bahan pangan lain, dengan atau tanpa dikukus,  digoreng atau dikeringkan, dan matang setelah dimasak atau  diseduh dengan air mendidih atau air panas dalam waktu singkat  beserta bumbu dan atau tanpa pelengkap pangan yang terdapat  dalam kemasan.",
    "Aktif",
  ],
  [
    "060403000015",
    "Mi Kering",
    "Mi kering adalah produk mi kering yang diperoleh dari tepung  terigu dengan atau tanpa penambahan bahan lain dan telah  mengalami pengeringan atau penggorengan. Produk mi kering  gandum mengandung tidak kurang dari 60% bahan dari  gandum.  Karakteristik dasar :  \x{2022} Kadar air tidak lebih dari 11%;  \x{2022} Kadar protein tidak kurang dari 6%.",
    "Aktif",
  ],
  [
    "060403000016",
    "Mi Soa",
    "Mi soa adalah mi kering dengan diameter untaian yang kecil dibuat  dari tepung terigu dengan penambahan bahan pangan lain dan  berwarna putih.",
    "Aktif",
  ],
  [
    "060403000017",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Pramasak",
    "Pangsit/pastel/lumpia/risol/samosa pramasak adalah produk yang  dibuat dari adonan tepung dengan air dengan atau tanpa  penambahan bahan pangan lain, dan dimasak. Produk ini dapat  diisi dengan daging, ikan, sayuran, atau bahan pangan lain.  Termasuk dalam kategori ini adalah produk lain yang sejenis.",
    "Aktif",
  ],
  [
    "060403000018",
    "Kerupuk Mentah",
    "Kerupuk4 mentah adalah produk berbahan baku pati/tepung atau  campurannya, dengan atau tanpa penambahan bahan pangan lain, melalui proses pengadukan, pencetakan, pengukusan atau perebusan, pendinginan, pengirisan, dan pengeringan.  Karakteristik dasar:  Kadar air tidak lebih dari 14,5%",
    "Aktif",
  ],
  [
    "060403000019",
    "Tepung Olahan / Pati Olahan / Protein Olahan (Meat Analog / Fish Analog / Seafood Analog)",
    "",
    "Aktif",
  ],
  ["060403000020", "Cilok", "", "Aktif"],
  ["060403000021", "Cireng/Cireng Isi", "", "Aktif"],
  ["060403000022", "Nasi Siap Saji", "", "Aktif"],
  [
    "060500000001",
    "Tepung Custard Tanpa Telur (Eggless Custard)",
    "Tepung custard tanpa telur (eggless custard) adalah tepung yang  dibuat dari campuran tapioka, pati jagung atau pati sagu, dengan  maupun tanpa bahan lain.",
    "Aktif",
  ],
  [
    "060500000002",
    "Sagu/Pati Mutiara",
    "Sagu/pati mutiara adalah produk dengan tekstur kenyal terbuat  dari tepung sagu atau tepung serealia atau pati dengan campuran  bahan pangan lain.",
    "Aktif",
  ],
  [
    "060500000003",
    "Premiks Untuk Makanan Pencuci Mulut Berbasis Serealia dan Pati",
    "Premiks untuk makanan pencuci mulut berbasis serealia dan pati  adalah produk berbentuk bubuk dengan bahan dasar tepung  serealia atau pati atau campurannya dengan penambahan gula dan  bahan pangan lain. Dalam penyiapannya harus ditambahkan air  atau susu dan/atau krim sebelum diolah lebih lanjut menjadi  makanan pencuci mulut.",
    "Aktif",
  ],
  [
    "060600000001",
    "Tepung Pelapis",
    "Tepung pelapis adalah campuran tepung, serpihan atau hancuran  serealia atau biji-bijian, yang dapat dikombinasikan dengan bahan  lain (seperti telur, air, susu) dapat digunakan sebagai pelapis bahan  pangan hewani (daging sapi, daging unggas, daging ikan atau hasil  laut lainnya (udang, cumi, dan lainnya), dan bahan pangan nabati  (pisang, umbi-umbian, sayur-sayuran).  Karakteristik dasar :  Kadar air tidak lebih dari 12%.",
    "Aktif",
  ],
  [
    "060600000002",
    "Tepung Bumbu",
    "Tepung Bumbu adalah campuran tepung, serpihan atau hancuran  serealia atau biji-bijian, mengandung dua atau lebih herba atau  rempah, yang dapat dikombinasikan dengan bahan lain (seperti  telur, air, susu) dapat digunakan sebagai pelapis bahan pangan  hewani (daging sapi, daging unggas, daging ikan atau hasil laut lainnya (udang, cumi, dan lainnya), dan bahan pangan nabati (pisang, umbi-umbian, sayur-sayuran). Tidak termasuk adonan (contohnya untuk produk bakeri) dari kategori 07.1.4 dan premiks  untuk roti dari 07.1.6 atau premiks untuk kue dari 07.2.3.  Karakteristik dasar :  Kadar air tidak lebih dari 12%.",
    "Aktif",
  ],
  [
    "060600000003",
    "Tepung Bakwan",
    "Tepung bakwan adalah campuran tepung (dapat berupa tepung  gandum atau tepung tapioka) dengan bahan pangan lain.  Digunakan untuk membuat bakwan dengan penambahan bahan  pangan lain seperti telur, air, sayuran (wortel, tauge, kubis, dan lainnya).",
    "Aktif",
  ],
  [
    "060600000004",
    "Tepung Bakso",
    "Tepung bakso adalah campuran tepung (dapat berupa tepung  gandum atau pati tapioka) dengan atau penambahan bahan pangan  lain. Digunakan untuk membuat adonan bakso dengan  penambahan daging giling.",
    "Aktif",
  ],
  [
    "060700000001",
    "Dodol/Jenang/Gelamai",
    "Dodol/jenang/gelamai adalah produk pangan yang diperoleh dari  tepung beras ketan, santan kelapa dan gula dengan atau tanpa  penambahan bahan makanan lain dimasak hingga mencapai  tekstur yang diinginkan.  Karakteristik dasar :  Kadar air tidak lebih dari 20%.",
    "Aktif",
  ],
  [
    "060700000002",
    "Wajik/Wajit",
    "Wajik/wajit adalah produk pangan semi basah hasil pengolahan  beras ketan, gula dan santan kelapa.  Karakteristik dasar :  \x{2022} Kadar air tidak lebih dari 30%;  \x{2022} Kadar gula (dihitung sebagai sukrosa) tidak kurang dari 15%.",
    "Aktif",
  ],
  [
    "060700000003",
    "Kue Mochi",
    "Kue mochi adalah produk khas Jepang yang terbuat dari tepung  beras ketan, dibentuk, dan ditaburi dengan tepung maizena atau  wijen.",
    "Aktif",
  ],
  [
    "060700000004",
    "Kue Teuck/Tteok",
    "Kue teuck/tteok adalah kue khas Korea yang dibuat dari serealia  terutama beras atau beras ketan.",
    "Aktif",
  ],
  [
    "060700000005",
    "Nagasari/Kue Pisang",
    "Nagasari/kue pisang adalah produk pangan berbahan dasar tepung  beras yang dimasak dengan santan, gula pasir, daun pandan dan  bahan lainnya hingga membentuk adonan kental. Adonan kemudian  diisi dengan sepotong pisang, dibungkus dengan daun pisang atau  lainnya dan dikukus hingga matang.",
    "Aktif",
  ],
  [
    "060700000006",
    "Putu Ayu",
    "Putu ayu adalah produk pangan berbahan dasar tepung beras yang  dimasak dengan air, air daun suji, gula merah, dan bahan lainnya  hingga membentuk adonan kemudian disaring dengan saringan  kawat sehingga menjadi bentuk butiran dan dicampur kelapa parut  serta garam. Campuran tersebut kemudian dicetak dan dikukus  hingga matang.",
    "Aktif",
  ],
  [
    "060700000007",
    "Kue Mangkok",
    "Kue mangkok adalah produk pangan berbahan dasar tepung beras  yang dimasak dengan cara dikukus; berbentuk mangkok yang  terlebih dahulu difermentasi dengan ragi atau air soda atau tape.",
    "Aktif",
  ],
  [
    "060700000008",
    "Jongkong Kelapa Muda",
    "Jongkong kelapa muda adalah produk pangan berbahan dasar  tepung beras dalam bentuk adonan, dimasak, dibungkus bersama  daun pandan, gula merah, daging buah kelapa dan santan dengan  daun pisang atau lainnya dan dikukus hingga matang.",
    "Aktif",
  ],
  [
    "060700000009",
    "Talam Ebi",
    "Talam ebi adalah produk pangan berbahan dasar tepung beras yang  dimasak dengan santan, gula dan bahan lainnya; terdiri dari 2  lapisan, dicetak, dikukus dan diberi taburan ebi diatasnya.",
    "Aktif",
  ],
  [
    "060700000010",
    "Kue Lapis Beras",
    "Kue lapis beras adalah produk pangan berbahan dasar tepung beras  yang dimasak dengan tepung sagu, santan, gula pasir, dan bahan  lainnya. Selanjutnya dibagi menjadi beberapa bagian dan diberi  warna berbeda, dicetak didalam loyang, dikukus dengan beberapa  tahap pelapisan.",
    "Aktif",
  ],
  [
    "060700000011",
    "Juadah Kering/Mayang Papan",
    "Juadah kering/mayang papan adalah produk pangan berbahan  dasar tepung beras yang telah disanggrai dan digoreng hingga  matang. Pelapis juadah dibuat dari campuran air, gula merah/gula  palem, gula pasir, vanili, durian dan bahan lainnya yang dimasak  sampai kental. Juadah kemudian dimasukkan ke dalamnya, diaduk  cepat sampai gula menempel pada juadah.",
    "Aktif",
  ],
  [
    "060700000012",
    "Petah",
    "Petah adalah produk pangan berbahan dasar tepung beras yang  dimasak dengan air, campuran air daun suji dan air kapur sirih dan  bahan lainnya hingga matang dan kental. Adonan kemudian  dituang dalam loyang, dikukus hingga matang dan dipotong  menurut selera. Petah disajikan dengan saus yang dibuat dari  santan yang direbus sampai matang.",
    "Aktif",
  ],
  [
    "060700000013",
    "Amparan Tatak Pisang",
    "Amparan tatak pisang adalah produk pangan berbahan dasar  tepung beras yang dibuat dari pencampuran dengan santan, gula,  garam dan pisang yang telah dipotong-potong kemudian dikukus.  Pada lapisan atasnya dituang campuran tepung beras, santan  kental, gula, garam dan vanili dan dikukus kembali hingga matang.",
    "Aktif",
  ],
  [
    "060700000014",
    "Lampu-Lampu",
    "Lampu-lampu adalah produk pangan berbahan dasar tepung beras  yang dimasak dengan air daun suji dan daun pandan, santan kental  hingga menjadi adonan. Gula dan air dididihkan dan dimasukkan  dalam takir, dituangi dengan adonan dan dikukus sampai matang.",
    "Aktif",
  ],
  [
    "060700000015",
    "Pisang Hijau",
    "Pisang hijau adalah produk pangan berbahan dasar tepung beras  yang dimasak dengan santan, gula, air dengan atau tanpa  penambahan bahan pangan lain.",
    "Aktif",
  ],
  [
    "060700000016",
    "Temo Coe",
    "Temo coe adalah produk pangan berbahan dasar tepung ketan yang  dimasak dengan santan, gula dan wijen.",
    "Aktif",
  ],
  [
    "060700000017",
    "Lemper Ayam",
    "Lemper ayam adalah produk berbahan dasar beras ketan putih yang  dikukus kemudian dibentuk pipih, diisi dengan irisan halus daging  ayam, dan dibungkus dengan daun pisang atau lainnya. Dapat  disajikan langsung, dipanggang atau dikukus kembali.",
    "Aktif",
  ],
  [
    "060700000018",
    "Semar Mendem",
    "Semar mendem adalah produk berbahan dasar beras ketan putih  yang dikukus kemudian dibentuk pipih, diisi dengan irisan halus  daging ayam dan dibungkus dengan selembar dadar telur tipis.",
    "Aktif",
  ],
  [
    "060700000019",
    "Jadah Manten",
    "Jadah manten adalah produk berbahan dasar beras ketan putih  yang dikukus kemudian dibentuk pipih, diisi dengan irisan halus  daging ayam, dibentuk bulat telur,dibungkus dengan selembar  dadar telur tipis dan dipanggang diatas bara api sambil dioles  dengan santan kental.",
    "Aktif",
  ],
  [
    "060700000020",
    "Lepet Ketan",
    "Lepet ketan adalah produk pangan berbahan dasar beras ketan  putih yang direndam dalam air, ditiriskan dan dicampur dengan  kelapa parut, kacang tolo serta bahan lainnya. Campuran tersebut  kemudian dimasukkan dalam helai daun kelapa yang telah digulung  membentuk cerobong, ditutup rapat, diikat dengan tali dan dimasak  dalam air mendidih sampai matang. Setelah ditiriskan, tali pengikat  dapat dibuka.",
    "Aktif",
  ],
  [
    "060700000021",
    "Kue Ku",
    "Kue ku adalah produk pangan berbahan dasar tepung beras ketan  putih yang dimasak dengan santan, gula pasir dan bahan lainnya  hingga membentuk adonan, dibentuk menjadi kulit tipis yang di  dalamnya diisi dengan kacang hijau, kentang atau bahan pangan  lain kemudian dicetak dan dikukus hingga matang.",
    "Aktif",
  ],
  [
    "060700000022",
    "Legondo",
    "Legondo adalah produk pangan berbahan dasar beras ketan putih  yang dimasak dengan gula pasir, santan, pandan dan bahan pangan  lain hingga membentuk adonan. Adonan kemudian diisi dengan  potongan pisang, dibungkus dengan daun pisang, diikat dan  dikukus hingga matang.",
    "Aktif",
  ],
  [
    "060700000023",
    "Onde-Onde",
    "Onde-onde adalah produk pangan berbahan dasar tepung ketan  putih yang dimasak dengan gula, tepung sagu, santan dan bahan  lainnya hingga membentuk adonan. Adonan dibentuk bulat dengan  isian kacang hijau atau bahan lainya, ditaburi wijen pada kulitnya  dan digoreng hingga matang.",
    "Aktif",
  ],
  [
    "060700000024",
    "Seri Muka",
    "Seri muka adalah produk pangan berbahan dasar beras ketan putih  yang dikukus bersama dengan santan, gula pasir dan bahan  lainnya, dicetak kedalam loyang dan diatasnya ditambahkan  adonan putih telur, gula pasir, air daun suji dan santan kemudian  dikukus kembali.",
    "Aktif",
  ],
  [
    "060700000025",
    "Kekicak/Gegicak",
    "Kekicak/gegicak adalah produk pangan berbahan dasar tepung  ketan putih yang dimasak dengan air kapur sirih hingga  membentuk adonan licin, dibentuk bulatan kecil, dalam loyang,  bagian tengah dilubangi kemudian dikukus hingga matang. Kekicak  disajikan dengan taburan parutan kelapa muda dan saus gula  merah.",
    "Aktif",
  ],
  [
    "060700000026",
    "Lalampa",
    "Lalampa adalah produk pangan berbahan dasar beras ketan putih  yang dikukus bersama santan hingga matang kemudian dibungkus  dengan daun pisang atau lainnya dengan isian ikan tongkol  kemudian dipanggang hingga matang.",
    "Aktif",
  ],
  [
    "060700000027",
    "Katrisolo",
    "Katrisolo adalah produk pangan berbahan dasar beras ketan putih  yang dikukus dengan santan kental, daun pandan, garam dan  bahan lainnya. Setelah beras ketan putih dalam loyang cukup  panas, tuangkan kocokan tepung, gula, tepung beras dan dikukus  hingga matang. Dapat dipotong sesuai selera.",
    "Aktif",
  ],
  [
    "060700000028",
    "Lapek Bugis",
    "Lapek bugis adalah produk pangan berbahan dasar tepung beras  ketan hitam dan tepung ketan hitam yang dimasak dengan santan  sebagai adonan utama. Adonan isi dibuat dari kelapa parut, gula  pasir,vanili dan bahan lainnya yang dimasak sampai kelapa matang.  Adonan utama yang telah diiisi dengan adonan isi, diberi kuah  santan kelapa matang, dibungkus dengan daun pisang atau lainnya  dan dikukus.",
    "Aktif",
  ],
  [
    "060700000029",
    "Lamang",
    "Lamang adalah kue berbahan dasar beras dengan penambahan  santan, garam dengan atau tanpa bahan lain, dimasukkan kedalam  bambu yang berlapis daun pisang muda dan dibakar.",
    "Aktif",
  ],
  [
    "060700000030",
    "Ombus-ombus",
    "Ombus-ombus adalah produk pangan berbahan dasar tepung beras  putih yang dicampur dengan kelapa parut dan gula merah/gula  putih. Campuran tersebut kemudian dimasukkan dalam helai daun  pisang membentuk kerucut dan dikukus hingga matang.",
    "Aktif",
  ],
  [
    "060700000031",
    "Legomoro",
    "Legomoro adalah produk pangan berbahan dasar beras ketan putih  yang dimasak dengan santan dan bahan pangan lain hingga  membentuk adonan. Adonan kemudian diisi dengan daging cincang,  dibungkus dengan daun pisang, diikat dan dikukus hingga matang.",
    "Aktif",
  ],
  [
    "060700000032",
    "Kue Berbahan Dasar Beras Lainnya",
    "Kue berbahan dasar beras lainnya adalah kue yang berbahan dasar  beras dan beras ketan baik dalam bentuk utuh maupun tepung.  Contohnya : uli, buras, lontong, arem-arem, lupis, gendar, wingko, yangko, krasikan, timpan dan lainnya.",
    "Aktif",
  ],
  [
    "060801000001",
    "Sari Kedelai ",
    "Sari kedelai adalah produk emulsi yang diekstrak dari kedelai yang  telah direbus dan digiling dengan penambahan air.  Karakteristik Dasar:  Kadar protein (N x 5,71) tidak kurang dari 2% (b/v).",
    "Aktif",
  ],
  [
    "060801000002",
    "Serbuk Minuman Kedelai",
    "Serbuk minuman kedelai adalah produk berbentuk bubuk berbahan  baku kedelai dengan atau tanpa penambahan bahan pangan lain,  yang digunakan untuk minuman.  Karakteristik Dasar:  Kadar protein (N x 5,71) tidak kurang dari 0,8g/100g.",
    "Aktif",
  ],
  [
    "060801000003",
    "Konsentrat Sari Kedelai",
    "Produk konsentrat dari emulsi yang diekstrak dari kedelai yang  telah direbus dan digiling dengan penambahan air dan/atau  penambahan bahan pangan lain. Cara mengkonsumsinya adalah  cukup ditambahkan air.",
    "Aktif",
  ],
  [
    "060802000001",
    "Lapisan Tipis Cairan Kedelai",
    "Lapisan terbentuk pada permukaan cairan kedelai yang direbus,  lapisan diangkat kemudian dikeringkan. Dapat digoreng  menggunakan minyak banyak (deep frying) atau dilembutkan dalam  air sebelum digunakan pada sup atau produk pangan direbus  (poached). Dikenal sebagai fuzhu, yuba, atau kembang tahu.",
    "Aktif",
  ],
  [
    "060803000001",
    "Tahu",
    "Tahu adalah produk berupa padatan yang dibuat dari ekstrak  kedelai melalui proses penggumpalan protein dengan penambahan  koagulan. Tahu dapat memiliki tekstur yang beragam (seperti  lembut, semi keras dan keras). Dapat ditambahkan bahan pangan lain.  Karakteristik dasar:  Kadar protein tidak kurang dari 9%.",
    "Aktif",
  ],
  [
    "060804000001",
    "Tahu Semi-Kering",
    "Tahu yang telah dipres selama proses pencetakan sehingga sebagian  airnya telah dikeluarkan, namun tidak sepenuhnya kering  (sebagaimana pada kategori 06.8.5). Tahu semi-kering umumnya  memiliki kadar air 62% dan memiliki tekstur yang kenyal.",
    "Aktif",
  ],
  [
    "060804010001",
    "Tahu Semi-Kering yang Diolah Dengan Saus Kental",
    "Tahu semi kering yang dimasak (ditumis) dengan saus kental (misal  saus miso). Tahu semi kering ini menyerap saus, sehingga memiliki  tekstur seperti aslinya.",
    "Aktif",
  ],
  [
    "060804020001",
    "Tahu Semi-Kering yang Digoreng Dengan Minyak Banyak (DeepFried)",
    "Tahu semi kering yang digoreng dengan minyak banyak (deep fried).  Tahu ini dapat langsung dikonsumsi atau dimasak lagi (contohnya  dengan direndam dalam saus) setelah penggorengan. Termasuk  dalam kategori ini tahu Sumedang dan tahu yang digunakan untuk  pembuatan tahu isi.",
    "Aktif",
  ],
  [
    "060804030001",
    "Tahu Semi-Kering, Selain Dari Kategori 0608040001 dan 0608040002",
    "Tahu semi kering yang disiapkan selain dengan merendam dalam  saus kental (contohnya miso) atau dengan proses penggorengan  minyak banyak (deep frying). Termasuk dalam kategori ini produk  yang dipanggang dan produk yang dihancurkan yang dapat  dikombinasikan dengan ingredien lain (contohnya untuk membuat  patty atau loaf).",
    "Aktif",
  ],
  [
    "060805000001",
    "Tahu Kering",
    "Tahu yang sebagian besar kandungan airnya telah dikeluarkan.  Dapat direkonstitusi dengan air atau saus untuk dapat dikonsumsi,  atau dapat digunakan secara langsung dalam sebuah masakan.  Selain itu dapat pula digoreng deep fried atau direndam dalam saus.  Karakteristik dasar:  Kadar air tidak lebih dari 12%",
    "Aktif",
  ],
  [
    "060806000001",
    "Dou chi",
    "Dou chi adalah produk yang dibuat dari fermentasi dan  penggaraman kedelai hitam dengan rasa dan aroma yang khas.",
    "Aktif",
  ],
  [
    "060806000002",
    "Natto",
    "Natto adalah produk kedelai yang diperoleh dari fermentasi kedelai  yang memiliki penampakan berlendir, lengket dengan aroma khas.",
    "Aktif",
  ],
  [
    "060806000003",
    "Tempe",
    "Tempe adalah produk kedelai yang diperoleh dari fermentasi kedelai  dengan menggunakan kapang Rhizopus sp, produk ini berbentuk  padatan kompak dan berbau khas serta berwarna putih atau sedikit keabu-abuan.",
    "Aktif",
  ],
  [
    "060806000004",
    "Tauco",
    "Tauco adalah produk kedelai yang diperoleh dari hasil fermentasi  kacang kedelai dalam larutan garam, berbau khas dengan atau  tanpa penambahan bahan pangan lain.",
    "Aktif",
  ],
  [
    "060807000001",
    "Tahu Fermentasi",
    "Produk ini dibuat dari gumpalan protein kedelai (curd) dengan  proses fermentasi hingga terbentuk massa yang lembut, memiliki  rasa dan aroma khas, bisa berwarna merah, kekuningan atau hijau  abu-abu.",
    "Aktif",
  ],
  [
    "060808000001",
    "Produk Protein Kedelai",
    "Produk protein kedelai adalah produk yang diperoleh dari proses  pengurangan atau penghilangan komponen-komponen utama nonprotein  (air, minyak, pati dan karbohidrat lain) dari kacang kedelai  untuk mencapai kadar protein (N \\xD7 5,71):  (1) Tepung protein kedelai 50% hingga 65%;  (2) Konsentrat protein kedelai 65% hingga 90%;  (3) Isolat protein 90% atau lebih;  Kadar protein dihitung terhadap bobot kering tanpa vitamin dan  mineral yang ditambahkan.  Ingredien yang dapat digunakan adalah karbohidrat termasuk gula,  lemak dan minyak makan, produk protein lain, vitamin dan mineral,  garam, herba dan rempah.  Karakteristik dasar:  Kadar air tidak lebih dari 10% (bk).",
    "Aktif",
  ],
  [
    "060808000002",
    "Texturized Vegetable Protein (TVP)",
    "Texturized vegetable protein (TVP) adalah produk yang dibuat dari  tepung protein kedelai, konsentrat protein kedelai, atau isolat  protein kedelai melalui proses ekstrusi untuk menghasilkan tekstur  mirip seperti daging.",
    "Aktif",
  ],
  [
    "070101010001",
    "Roti Tawar",
    "Roti tawar adalah produk roti yang adonannya terbuat dari tepung  terigu, lemak, gula dan air yang mengalami fermentasi oleh ragi  (kamir) sebagai bahan pengembang.  Karakteristik dasar  Kadar gula total tidak lebih dari 5%.",
    "Aktif",
  ],
  [
    "070101010002",
    "Roti Tawar Dengan Penambahan Bahan Pangan Lain",
    "Roti tawar dengan penambahan bahan pangan lain adalah produk  roti yang adonannya terbuat dari tepung terigu, lemak, gula dan air  yang mengalami fermentasi oleh ragi (kamir) sebagai bahan  pengembang dengan penambahan bahan pangan lain.  Nama jenis untuk kategori ini misalnya roti tawar pandan (yang  ditambahkan ekstrak pandan dan berwarna hijau), roti tawar  cokelat (yang diberi bubuk cokelat), roti tawar dengan chocochips,  roti tawar dengan kismis.  Karakteristik dasar :  \x{2022} Kadar gula total tidak lebih dari 5%;  \x{2022} Bahan pangan lain yang ditambahkan tidak lebih dari 10%.",
    "Aktif",
  ],
  [
    "070101010003",
    "Roti Tawar Kupas",
    "Roti tawar kupas adalah roti tawar yang dikupas seluruh kulit  luarnya.",
    "Aktif",
  ],
  [
    "070101010004",
    "Roti Rye",
    "Roti rye adalah produk roti yang adonannya terbuat dari campuran  tepung rye dan tepung terigu, lemak dan air yang mengalami  fermentasi oleh ragi (kamir) sebagai bahan pengembang dan atau  bahan pengembang lain. Tepung rye tidak lebih dari 70% tepung  terigu.",
    "Aktif",
  ],
  [
    "070101010005",
    "Roti Pumpernickel",
    "Roti pumpernickel adalah produk roti yang yang adonannya terbuat  dari campuran tepung terigu, tepung cornmeal, tepung rye,  dan/atau tepung lain dengan penambahan rempah fennel atau biji  jinten (caraway), lemak dan air yang mengalami fermentasi oleh ragi  (kamir) dan atau bahan pengembang lain.",
    "Aktif",
  ],
  [
    "070101010006",
    "Roti Buah/Roti Kismis/Roti Chocochips",
    "Roti buah/roti kismis/roti chocochips adalah produk roti dengan  atau tanpa rempah, dengan penambahan buah kering, misalnya  kismis, dan chocochips. Mengandung buah kering atau kismis tidak  kurang dari 10% jumlah adonan.",
    "Aktif",
  ],
  [
    "070101010007",
    "Roti Gandum Utuh (Whole Wheat)",
    "Roti gandum utuh (whole wheat) adalah produk roti yang  adonannya terbuat dari tepung gandum utuh, lemak, gula, dan air  yang mengalami fermentasi oleh ragi (kamir) sebagai bahan  pengembang.  Karakteristik dasar :  \x{2022} Kadar gula total tidak lebih dari 5%;  \x{2022} Kadar tepung gandum utuh tidak kurang dari 10% dari total tepung.",
    "Aktif",
  ],
  [
    "070101010008",
    "Roti Campuran Tepung Terigu dan Kulit Gandum/Roti dengan Kulit Gandum (Fine Bran)",
    "Roti campuran tepung terigu dan kulit gandum/roti dengan kulit  gandum adalah produk roti yang adonannya terbuat dari campuran  tepung terigu, kulit gandum (fine bran), lemak, gula, dan air yang  mengalami fermentasi oleh ragi (kamir) sebagai bahan pengembang.  Karakteristik dasar :  \x{2022} Kadar gula total tidak lebih dari 5%;  \x{2022} Kulit gandum yang ditambahkan tidak kurang dari 2% dari total tepung.",
    "Aktif",
  ],
  [
    "070101010009",
    "Roti Perancis (Baguette/pain courant francais)",
    "Roti Perancis (Baguette/pain courant francais) adalah produk roti  berbentuk memanjang dengan tekstur keras yang adonannya  terbuat dari tepung terigu atau terigu yang dicampur dengan kulit  gandum, lemak, gula dan air yang mengalami fermentasi oleh ragi  (kamir) sebagai bahan pengembang.  Karakteristik dasar :  Kadar gula total tidak lebih dari 5%.",
    "Aktif",
  ],
  [
    "070101010010",
    "Roti Malt",
    "Roti malt adalah produk roti yang adonannya terbuat dari tepung  gandum, ekstrak malt, lemak, gula dan air yang mengalami  fermentasi oleh ragi (kamir) sebagai bahan pengembang.",
    "Aktif",
  ],
  [
    "070101010011",
    "Roti Kadet",
    "Roti kadet adalah produk roti yang dibuat untuk membuat roti lapis  (sandwich) atau untuk membuat roti isi (burger, hotdog, atau sosis).",
    "Aktif",
  ],
  [
    "070101010012",
    "Roti Kadet Gandum",
    "Roti kadet gandum adalah produk roti kadet yang dibuat dari  tepung gandum utuh atau campuran tepung terigu dan kulit  gandum (fine bran).",
    "Aktif",
  ],
  [
    "070101010013",
    "Roti Kadet Susu",
    "Roti kadet susu adalah produk roti yang adonannya terbuat dari  tepung terigu atau tepung terigu utuh, atau campurannya, padatan  susu bukan-lemak, lemak dan air yang mengalami fermentasi oleh  ragi (kamir) sebagai bahan pengembang dan atau bahan  pengembang lain.  Karakteristik dasar :  Mengandung padatan susu bukan-lemak tidak kurang dari 4% dari jumlah terigu.",
    "Aktif",
  ],
  [
    "070101010014",
    "Roti Wheat-Germ",
    "Roti wheat-germ adalah produk roti yang adonannya terbuat dari  tepung terigu atau tepung terigu utuh atau campurannya, lemak,  wheat germ (lembaga gandum), air dan yang mengalami fermentasi  oleh ragi (kamir) sebagai bahan pengembang dan atau bahan  pengembang lain.  Karakteristik dasar :  Kandungan wheatgerm tidak kurang dari 5% dari total tepung.",
    "Aktif",
  ],
  [
    "070101010015",
    "Roti Meal",
    "Roti meal adalah produk roti yang adonannya terbuat dari tepung  serealia (meal) atau campuran tepung meal atau tepung terigu yang mengandung tidak kurang dari 60% tepung meal, lemak dan air  yang mengalami fermentasi oleh ragi (kamir) sebagai bahan  pengembang dan atau bahan pengembang lain.",
    "Aktif",
  ],
  [
    "070101010016",
    "Roti Meal Utuh (Whole Meal)",
    "Roti meal utuh (whole meal) adalah produk roti yang adonannya  terbuat dari tepung serealia (meal) utuh, lemak dan air yang  mengalami fermentasi oleh ragi (kamir) sebagai bahan pengembang  dan atau bahan pengembang lain.",
    "Aktif",
  ],
  [
    "070101020001",
    "Roti Soda",
    "Roti soda adalah produk roti yang dibuat dengan bahan  pengembang selain ragi (kamir) yaitu senyawa pengembang kimia  seperti baking powder atau baking soda, juga disebut sebagai  quickbread.",
    "Aktif",
  ],
  [
    "070102000001",
    "Krekers",
    "Krekers adalah jenis biskuit yang dalam pembuatannya  memerlukan proses fermentasi atau tidak, serta melalui proses  laminasi sehingga menghasilkan bentuk pipih dan bila dipatahkan  penampangnya tampak berlapis-lapis.  Karakteristik dasar :  Kadar air tidak lebih dari 5%.",
    "Aktif",
  ],
  [
    "070102000002",
    "Krekers Krim",
    "Krekers krim adalah jenis krekers fermentasi yang pada proses  laminasinya menggunakan cracker dust di antara lapisanlapisannya.  Karakteristik dasar :  Kadar air tidak lebih dari 5%.",
    "Aktif",
  ],
  [
    "070102000003",
    "Water Biscuit",
    "Water biscuit adalah jenis krekers non-fermentasi yang pada proses  laminasinya tidak menggunakan cracker dust, lemak atau pengisi  apapun di antara lapisan-lapisannya.",
    "Aktif",
  ],
  [
    "070102000004",
    "Krekers Soda",
    "Krekers soda adalah produk bakeri tipis, renyah dan tidak manis  yang adonannya terbuat dari tepung terigu dan air yang dibuat  dengan bahan pengembang selain ragi (kamir) yaitu senyawa pengembang kimia seperti baking powder atau baking soda, dan  melalui proses laminasi berlapis-lapis lalu dipanggang sehingga ada  rongga di dalamnya.  Karakteristik dasar :  Kadar air tidak lebih dari 5%.",
    "Aktif",
  ],
  [
    "070103000001",
    "Shortened Bread",
    "Shortened bread atau quickbread adalah produk sejenis biskuit yang  adonannya terbuat dari tepung terigu, mentega/margarin, telur,  susu dan sedikit gula pasir, dibuat dengan baking powder atau  baking soda, berukuran kecil, ringan, berserpih (flaky) dengan crust  (kulit) berwarna emas.",
    "Aktif",
  ],
  [
    "070103000002",
    "Bagel",
    "Bagel adalah sejenis roti berbentuk cincin dengan tekstur liat dan  padat dengan rasa tawar yang adonannya dapat dibuat dari tepung  terigu atau rye. Bagel juga dapat ditambah antara lain kismis dan  buah kecil atau kacang, sayur, bawang, dan sebagainya.",
    "Aktif",
  ],
  [
    "070103000003",
    "Roti Pita",
    "Roti pita adalah roti berbentuk lingkaran atau oval dan relatif tipis  (pipih), lembut, dan bagian tengahnya berongga.",
    "Aktif",
  ],
  [
    "070103000004",
    "Muffin Inggris (English Muffin)",
    "Muffin Inggris (english muffin) adalah sejenis roti yang menggunakan  kamir sebagai bahan pengembang, dibentuk bulat dimasak diatas  pemanggang lalu dibelah dua. Permukaannya datar dengan warna  kecoklatan di bagian luar dan berpori di dalamnya.",
    "Aktif",
  ],
  [
    "070103000005",
    "Roti Canai/Roti Cane/Roti Kane/Roti Kanai/Roti Maryam",
    "Roti canai/roti cane/roti kane/roti kanai/roti maryam adalah roti  berbentuk lingkaran, tipis (pipih), lembut, dibuat dengan cara  diputar hingga tipis, atau bisa pula dengan menebarkan adonan  setipis mungkin di atas panggangan, dapat dilipat, dipanggang  dengan sedikit minyak atau margarin. Roti ini biasanya dikonsumsi  dengan kari atau dikonsumsi langsung dengan penambahan bahan  pangan lain seperti cokelat, stroberi, keju, dan lain-lain.",
    "Aktif",
  ],
  [
    "070103000006",
    "Roti Jala",
    "Roti jala adalah roti yang dibuat dengan cara menyemprotkan  adonan membentuk jala atau renda, dipanggang dengan sedikit  minyak atau margarin, dilipat, digulung, atau dibentuk lain. Roti ini  biasanya dikonsumsi dengan kari atau masakan lain.",
    "Aktif",
  ],
  [
    "070104000001",
    "Crouton",
    "Crouton adalah potongan roti tawar berbentuk kubus atau bentuk  lain,dapat dioles mentega atau bahan pangan lain, lalu dipanggang  hingga kering. Pada umumnya disajikan bersama sup.",
    "Aktif",
  ],
  [
    "070104000002",
    "Tepung Panir",
    "Tepung panir adalah produk yang diperoleh dari roti tawar yang  dikeringkan dengan oven lalu digiling. Umumnya digunakan untuk  menyalut bahan pangan lain untuk digoreng.",
    "Aktif",
  ],
  [
    "070104000003",
    "Tepung Roti/Bread Crumb",
    "Tepung roti/bread crumb adalah roti tawar yang dihancurkan  menjadi serpihan lalu dikeringkan, berukuran kasar (lebih kasar  dari tepung panir) untuk menyalut bahan pangan lain dengan  formulasi yang sesuai peruntukannya.",
    "Aktif",
  ],
  [
    "070104000004",
    "Roti Untuk Stuffing",
    "Roti untuk stuffing adalah semacam crouton yang digunakan untuk  mengisi karkas kalkun/karkas unggas atau karkas lain untuk  dipanggang.",
    "Aktif",
  ],
  [
    "070104000005",
    "Premiks Untuk Stuffing",
    "Premiks untuk stuffing adalah campuran tepung dan bahan pangan  lain untuk pembuatan roti untuk stuffing.",
    "Aktif",
  ],
  [
    "070104000006",
    "Adonan Shortened Bread",
    "Adonan shortened bread adalah adonan siap panggang untuk  membuat shortened bread seperti dimaksud dalam kategori 07.1.3.",
    "Aktif",
  ],
  [
    "070105000001",
    "Mantao",
    "Mantao adalah produk roti kukus tanpa isi.",
    "Aktif",
  ],
  [
    "070105000002",
    "Bakpao/Pao",
    "Bakpao/pao adalah produk roti kukus yang diisi dengan daging,  kacang, atau bahan pangan lain.",
    "Aktif",
  ],
  [
    "070105000003",
    "Apem",
    "Apem adalah roti kukus yang dibuat dari tepung beras dan gula  yang terlebih dahulu difermentasi dengan ragi atau tape.",
    "Aktif",
  ],
  [
    "070105000004",
    "Kue Mangkok",
    "Kue mangkok adalah produk bakeri kukus berbentuk mangkok  yang dibuat dari tepung terigu dengan penambahan bahan  pengembang.",
    "Aktif",
  ],
  [
    "070105000005",
    "Bun Kukus",
    "Bun kukus adalah roti oriental yang diperoleh dari dari tepung  terigu atau tepung beras yang diolah dengan pengukusan. Dengan  atau tanpa isi (misalnya daging, selai).",
    "Aktif",
  ],
  [
    "070106000001",
    "Premiks Untuk Roti Tawar dan Produk Bakeri Tawar",
    "Premiks untuk roti dan produk bakeri tawar adalah campuran  bahan kering yang bisa ditambahkan dengan ingredien basah  (seperti air, susu, minyak, mentega, telur) untuk membuat adonan  untuk produk bakeri dari kategori 07.1.1, 07.1.2, 07.1.3, 07.1.4 dan  07.1.5.",
    "Aktif",
  ],
  [
    "070201000001",
    "Keik (Cake)",
    "Keik (cake) adalah produk bakeri manis yang dibuat dari adonan yang terdiri dari tepung terigu, gula, telur, dan bahan pangan lain. Adonan umumnya dituang ke dalam cetakan untuk dipanggang atau dikukus. ",
    "Aktif",
  ],
  [
    "070201000002",
    "Keik Mentega (Butter Cake)",
    "Keik mentega (butter cake) adalah keik yang mengandung mentega atau lemak lainnya (margarin, shortening),berperisa, dengan tekstur dan volume yang baik. Keik mentega merupakan bentuk pengembangan dari pound cake. Keik mentega dapat juga ditambah dengan taburan gula, frosting (icing), kacang dan sebagainya. ",
    "Aktif",
  ],
  [
    "070201000003",
    "Keik Keju (Cheese Cake)",
    "Keik keju (cheese cake) adalah keik yang dibuat dengan keju, keju krim (cream cheese), keju cottage atau keju ricotta yang dicampur dengan telur, gula, dan bahan pangan lain. Kulitnya dapat dibuat dari gilingan krekers, kacang atau pastri.",
    "Aktif",
  ],
  [
    "070201000004",
    "Keik Pound (Pound Cake atau Quatre Quarts)",
    "Keik pound (pound cake atau quatre quarts) adalah keik yang dibuat dari 1 pound (lbs = 454 g) tepung terigu, 1 pound gula, 1 pound mentega dan 1 pound telur",
    "Aktif",
  ],
  [
    "070201000005",
    "Brownies",
    "Brownies adalah jenis keik yang dibuat dari adonan tepung terigu atau tepung lainnya, gula, telur, cokelat, dan bahan pangan lain. Adonan dipanggang atau dikukus.",
    "Aktif",
  ],
  [
    "070201000006",
    "Biskuit",
    "Biskuit adalah produk bakeri kering yang dibuat dengan cara  memanggang adonan yang terbuat dari tepung terigu dengan atau tanpa substitusinya, minyak/lemak, dengan atau tanpa penambahan bahan pangan lain.  Karakteristik dasar : \x{2022}Kadar air tidak lebih dari 5%",
    "Aktif",
  ],
  [
    "070201000007",
    "Biskuit Non Terigu",
    "Biskuit non terigu adalah produk bakeri kering yang dibuat dengan cara memanggang adonan yang terbuat dari non terigu, minyak/lemak, dengan atau tanpa penambahan bahan pangan lain. Nama jenis untuk produk ini, misalnya biskuit beras, biskuit jagung, dan lain-lain.  Karakteristik dasar : Kadar air tidak lebih dari 5%. ",
    "Aktif",
  ],
  [
    "070201000008",
    "Biskuit Marie",
    "Biskuit marie adalah sejenis biskuit manis dengan penambahan perisa khas marie, dibuat dari tepung terigu, air atau susu, dan dapat ditambahkan bahan pangan lain. Karakteristik dasar : Kadar air tidak lebih dari 5%.",
    "Aktif",
  ],
  [
    "070201000009",
    "Biskuit Marie Salut",
    "Biskuit marie salut adalah biskuit marie yang diberi salutan coklat atau bahan pangan lain di bagian luarnya",
    "Aktif",
  ],
  [
    "070201000010",
    "Biskuit Lapis/Biskuit Sandwich",
    "Biskuit lapis/biskuit sandwich adalah biskuit yang terdiri dari 2  lapis atau lebih dan diantara lapisan diberi isi. Jika produknya disalut, nama jenisnya adalah biskuit lapis salut. Contoh dari produk ini biskuit lapis salut cokelat. ",
    "Aktif",
  ],
  [
    "070201000011",
    "Biskuit Colek",
    "Biskuit colek adalah biskuit yang dilengkapi dengan krim cokelat atau krim lainnya yang dikonsumsi dengan cara dicolek.",
    "Aktif",
  ],
  [
    "070201000012",
    "Kukis",
    "Kukis adalah jenis biskuit yang terbuat dari adonan lunak, renyah dan bila dipatahkan penampangnya tampak bertekstur kurang padat.  Karakteristik dasar : Kadar air tidak lebih dari 5%",
    "Aktif",
  ],
  [
    "070201000013",
    "Kukis Lunak (Soft Cookies)",
    "Kukis lunak (Soft Cookies) adalah jenis kukis yang bertekstur lunak. Karakteristik dasar : Kadar air tidak lebih dari 14,5%. ",
    "Aktif",
  ],
  [
    "070201000014",
    "Kukis Gula",
    "Kukis gula adalah jenis biskuit manis yang terbuat dari adonan  lunak, renyah dan bila dipatahkan penampang potongannya  bertekstur kurang padat serta pada permukaan terdapat taburan gula. Karakteristik dasar : Kadar air tidak lebih dari 5%. ",
    "Aktif",
  ],
  [
    "070201000015",
    "Kukis Oatmeal",
    "Kukis oatmeal adalah jenis kukis dengan salah satu bahan  utamanya adalah oat.  Karakteristik dasar : Kadar air tidak lebih dari 5%.",
    "Aktif",
  ],
  [
    "070201000016",
    "Nastar",
    "Nastar adalah jenis kukis yang berbentuk bulat atau bentuk lainnya dan diisi dengan selai nanas atau bahan pangan lain. Karakteristik dasar : Kadar air berkisar lebih dari 5% dan tidak lebih dari 10%",
    "Aktif",
  ],
  [
    "070201000017",
    "Kastengel",
    "Kastengel adalah jenis kukis yang dibuat dengan enambahan keju, baik dalam adonannya atau ditaburkan. Karakteristik dasar : Kadar air tidak lebih dari 10%. ",
    "Aktif",
  ],
  [
    "070201000018",
    "Wafer",
    "Wafer adalah jenis biskuit yang dibuat dari adonan cair, berpori-pori kasar, renyah, dan bila dipatahkan penampangnya tampak berongga. Karakteristik dasar : Kadar air tidak lebih dari 5%.",
    "Aktif",
  ],
  [
    "070201000019",
    "Wafer Roll/Wafer Stick",
    "Wafer roll/wafer stick adalah sejenis biskuit manis yang ibuat dari adonan cair, berbentuk roll dengan atau tanpa isi, dan renyah.",
    "Aktif",
  ],
  [
    "070201000020",
    "Wafer Salut",
    "Wafer salut adalah sejenis wafer yang diberi salutan cokelat atau bahan pangan lain di bagian luarnya.",
    "Aktif",
  ],
  [
    "070201000021",
    "Pai",
    "Pai adalah jenis biskuit berserpih (flaky) yang dibuat dari donan dilapis dengan lemak padat atau emulsi lemak, sehinga mengembang selama pemanggangan dan bila dipatahkan penampangnya tampak berlapis-lapis. Yang termasuk pai adalah puff. Karakteristik dasar : Kadar air tidak lebih dari 5%. ",
    "Aktif",
  ],
  [
    "070201000022",
    "Pai Isi",
    "Pai isi adalah jenis pai yang diisi dengan selai, cokelat atau bahan pangan lain. Karakteristik dasar Kadar air berkisar lebih dari 5%. ",
    "Aktif",
  ],
  [
    "070201000023",
    "Bolu Kukus",
    "Bolu kukus adalah produk bakeri kukus berbentuk mangkok,  ataubentuk lainnya yang dibuat dari tepung terigu dengan penambahan bahan pengembang. ",
    "Aktif",
  ],
  [
    "070201000024",
    "Bika Ambon",
    "Bika ambon adalah sejenis kue yang dibuat dari pati sagu atau tapioka dan tepung terigu serta santan yang difermentasi dengan kamir atau bahan lain melalui proses pemanggangan. ",
    "Aktif",
  ],
  [
    "070201000025",
    "Egg Roll",
    "Egg roll adalah jenis kukis gulung dengan kadar telur tidak kurang dari 35%.",
    "Aktif",
  ],
  [
    "070201000026",
    "Biskuit Bar Sereal Isi",
    "Biskuit bar sereal isi adalah sejenis biskuit manis berbentuk bar yang diisi dengan hasil olahan buah, cokelat, kacang atau lainnya. ",
    "Aktif",
  ],
  [
    "070201000027",
    "Crepes",
    "Crepes adalah produk sejenis panekuk tipis, dapat digulung atau dilipat, terbuat dari terigu, renyah, diberi isi atau tidak.",
    "Aktif",
  ],
  [
    "070201000028",
    "Roti Bagelen",
    "Roti bagelen adalah roti yang dipanggang setelah dioles dengan lemak dan gula atau krim, dan dapat ditambahkan bahan pangan lain. Karakteristik dasar Kadar air tidak lebih dari 5%. ",
    "Aktif",
  ],
  [
    "070202000001",
    "Pastri",
    "Pastri adalah produk roti yang ringan dan berserpih (flaky) yang dibuat dari adonan dilapis dengan mentega atau lemak padat lainnya secara berulang-ulang sehingga mengembang selama pemanggangan di oven. ",
    "Aktif",
  ],
  [
    "070202000002",
    "Roti Manis",
    "Roti manis adalah produk roti yang memiliki rasa manis, adonannya terbuat dari tepung terigu, lemak, gula, dan garam yang mengalami fermentasi oleh ragi (kamir) sebagai bahan pengembang.",
    "Aktif",
  ],
  [
    "070202000003",
    "Roti Isi",
    "Roti isi adalah produk roti dengan kadar gula tidak kurang dari 15% dan diisi dengan bahan lain seperti keju, cokelat, selai, krim dan lain lain. ",
    "Aktif",
  ],
  [
    "070202000004",
    "Scone",
    "Scone adalah produk bakeri istimewa yang adonannya mengandung lebih banyak gula. ",
    "Aktif",
  ],
  [
    "070202000005",
    "Donat",
    "Donat adalah kue berbentuk cincin atau bentuk bulat lainnya yang adonannya difermentasi dengan ragi atau bahan pengembang lainnya kemudian digoreng",
    "Aktif",
  ],
  [
    "070202000006",
    "Muffin Amerika (American Muffin)",
    "Muffin Amerika (american muffin) atau muffin (di Indonesia) adalah sejenis quickbread berbentuk mangkok. ",
    "Aktif",
  ],
  [
    "070202000007",
    "Roti Buaya",
    "Roti buaya adalah produk roti khas Betawi yang berbentuk seperti buaya",
    "Aktif",
  ],
  [
    "070202000008",
    "Kue Tambang",
    "Kue tambang adalah kue berbentuk seperti untaian tali yang dibuat dari adonan terigu yang digoreng.",
    "Aktif",
  ],
  [
    "070202000009",
    "Wafel",
    "Wafel adalah kue yang dibuat dari adonan terigu yang dicetak diantara dua plat logam yang umumnya bermotif persegi.",
    "Aktif",
  ],
  [
    "070202000010",
    "Stroopwafel",
    "Stroopwafel adalah sejenis wafel yang terdiri dari dua lapisan tipis berisi sirup karamel.",
    "Aktif",
  ],
  [
    "070202000011",
    "Cone untuk Es Krim",
    "Cone untuk es krim adalah sejenis wafer yang berbentuk corong digunakan sebagai wadah es krim.",
    "Aktif",
  ],
  [
    "070202000012",
    "Panekuk",
    "Panekuk adalah kue berbentuk bundar tipis yang umumnya dibuat dari tepung terigu, gula, telur, susu, dan dipanaskan pada permukaan yang panas. ",
    "Aktif",
  ],
  [
    "070202000013",
    "Bakpia",
    "Produk bakeri yang adonannya dibuat dari tepung terigu, air,  lemak/minyak, dan isinya terbuat dari campuran gula dan kacang hijau yang dihaluskan, lalu dipanggang. Isi bakpia dapat diganti dengan cokelat, selai buah, atau bahan pangan lain.",
    "Aktif",
  ],
  [
    "070202000014",
    "Bolu Emprit",
    "Bolu emprit adalah kue kering tradisional yang terbuat dari adonan tapioka, gula pasir, kelapa parut dan pengembang yang dicetak dan dipanggang.",
    "Aktif",
  ],
  [
    "070203000001",
    "Premiks Untuk Produk Bakeri Istimewa",
    "Premiks untuk produk bakeri istimewa adalah campuran bahan kering yang dapat ditambahkan dengan ingredien basah (seperti air, susu, minyak, mentega, telur) untuk membuat adonan untuk pembuatan produk bakeri. ",
    "Aktif",
  ],
  ["080101000001", "Karkas Hewan Mamalia", "", "Nonaktif"],
  ["080101000002", "Karkas Sapi", "", "Nonaktif"],
  [
    "080101000003",
    "Karkas Paruh Sapi (Half Carcass)",
    "",
    "Nonaktif",
  ],
  ["080101000004", "Karkas Perempat Sapi", "", "Nonaktif"],
  [
    "080101000005",
    "Seperempat Karkas Bagian Belakang/Karkas Bagian Paha (Hind Quarter/Leg Quarter)",
    "",
    "Nonaktif",
  ],
  ["080101000006", "Forequarter", "", "Nonaktif"],
  ["080101000007", "Hindquarter", "", "Nonaktif"],
  ["080101000008", "Forequarter dan Hindquarter", "", "Nonaktif"],
  [
    "080101000009",
    "Tulang Iga Pendek (Short Ribs)",
    "",
    "Nonaktif",
  ],
  ["080101000010", "Tulang Iga Utama (Prime Rib)", "", "Nonaktif"],
  ["080101000011", "Karkas Kerbau", "", "Nonaktif"],
  ["080101000012", "Karkas Kambing/Domba", "", "Nonaktif"],
  [
    "080101000013",
    "Karkas Paruh Depan dan Karkas Paruh Belakang Kambing/Domba",
    "",
    "Nonaktif",
  ],
  [
    "080101000014",
    "Karkas Paruh Kiri dan Karkas Paruh Kanan Kambing/Domba",
    "",
    "Nonaktif",
  ],
  ["080101000015", "Karkas Perempat Kambing/Domba", "", "Nonaktif"],
  ["080101000016", "Leg kambing/Domba", "", "Nonaktif"],
  ["080101000017", "Shoulder Kambing/Domba", "", "Nonaktif"],
  ["080101000018", "Karkas Babi", "", "Nonaktif"],
  ["080101000019", "Bagian Mamalia Non Karkas", "", "Nonaktif"],
  ["080101000020", "Offal", "", "Nonaktif"],
  ["080101000021", "Jeroan", "", "Nonaktif"],
  ["080101000022", "Rack", "", "Nonaktif"],
  ["080101000023", "Breast", "", "Nonaktif"],
  ["080101000024", "Foreshank Domba", "", "Nonaktif"],
  ["080101000025", "Karkas Ayam", "", "Nonaktif"],
  ["080101000026", "Separuh Karkas (Half Poultry)", "", "Nonaktif"],
  [
    "080101000027",
    "Seperempat Karkas Bagian Depan/Karkas Bagian Dada (Front Quarter/Breast Quarter)",
    "",
    "Nonaktif",
  ],
  [
    "080101000028",
    "Seperempat Karkas Bagian Belakang/Karkas Bagian Paha (Hind Quarter/ Leg Quarter)",
    "",
    "Nonaktif",
  ],
  ["080101000029", "Punggung Utuh (Whole Back)", "", "Nonaktif"],
  ["080101000030", "Ekor (Brutu)", "", "Nonaktif"],
  ["080101000031", "Punggung (Back)", "", "Nonaktif"],
  [
    "080101000032",
    "Punggung Terkupas (Stripped Back)",
    "",
    "Nonaktif",
  ],
  ["080101000033", "Dada Utuh (Full Breast)", "", "Nonaktif"],
  ["080101000034", "Dada Depan (Wishbone)", "", "Nonaktif"],
  [
    "080101000035",
    "Dada Hasil Trimming (Trimmed Breast)",
    "",
    "Nonaktif",
  ],
  [
    "080101000036",
    "Separuh Dada Hasil Trimming (Half Trimmed Breast)",
    "",
    "Nonaktif",
  ],
  ["080101000037", "Sayap (Wing)", "", "Nonaktif"],
  ["080101000038", "Sayap Atas (Wing Drumette)", "", "Nonaktif"],
  [
    "080101000039",
    "Sayap Bawah (Winglet atau V-Wing)",
    "",
    "Nonaktif",
  ],
  ["080101000040", "Paha (Leg) Unggas", "", "Nonaktif"],
  ["080101000041", "Paha Atas (Thigh)", "", "Nonaktif"],
  ["080101000042", "Paha Bawah (Drumstick)", "", "Nonaktif"],
  ["080101000043", "Bagian Unggas Non Karkas", "", "Nonaktif"],
  ["080101000044", "Kepala", "", "Nonaktif"],
  ["080101000045", "Leher", "", "Nonaktif"],
  ["080101000046", "Kaki atau Cakar", "", "Nonaktif"],
  [
    "080101000047",
    "Jeroan Unggas (Poultry Giblets)",
    "",
    "Nonaktif",
  ],
  ["080101000048", "Daging", "", "Nonaktif"],
  ["080101000049", "Daging Dingin", "", "Nonaktif"],
  ["080101000050", "Daging Beku", "", "Nonaktif"],
  [
    "080101000051",
    "Steik (Steaks) Daging Sapi Beku",
    "",
    "Nonaktif",
  ],
  ["080101000052", "Daging Sapi/Kerbau", "", "Nonaktif"],
  ["080101000053", "Daging Kambing/Domba", "", "Nonaktif"],
  ["080101000054", "Daging Iga (Rib Meat)", "", "Nonaktif"],
  ["080101000055", "Jenis Potongan Bagian Daging", "", "Nonaktif"],
  ["080101000056", "Lamusir (Rib Eye)", "", "Nonaktif"],
  ["080101000057", "Lamusir (Cuberoll)", "", "Nonaktif"],
  ["080101000058", "Sandung Lamur (Brisket)", "", "Nonaktif"],
  ["080101000059", "Sengkel (Shin dan Shank)", "", "Nonaktif"],
  ["080101000060", "Sengkel (Shank/Foreshank)", "", "Nonaktif"],
  ["080101000061", "Samcan (Thin Flank)", "", "Nonaktif"],
  ["080101000062", "Flank", "", "Nonaktif"],
  ["080101000063", "Has Dalam (Tenderloin)", "", "Nonaktif"],
  ["080101000064", "Has Luar (Striploin/Sirloin)", "", "Nonaktif"],
  [
    "080101000065",
    "Has (Tenderloin) Kambing/Domba",
    "",
    "Nonaktif",
  ],
  ["080101000066", "Loin Kambing/Domba", "", "Nonaktif"],
  ["080101000067", "Penutup (Top side)", "", "Nonaktif"],
  ["080101000068", "Pendasar (Riverside)", "", "Nonaktif"],
  ["080101000069", "Gandik (Eye Round)", "", "Nonaktif"],
  ["080101000070", "Tanjung (Rump)", "", "Nonaktif"],
  ["080101000071", "Kelapa (Round)", "", "Nonaktif"],
  ["080101000072", "Kijen (Chuck Tender)", "", "Nonaktif"],
  ["080101000073", "Sampil Besar (Chuck)", "", "Nonaktif"],
  ["080101000074", "Sampil Kecil (Blade)", "", "Nonaktif"],
  [
    "080101000075",
    "Daging Tanpa Tulang yang Dijual dalam Bentuk Kemasan Besar (Bulk Pack)",
    "",
    "Nonaktif",
  ],
  ["080101000076", "Tetelan", "", "Nonaktif"],
  ["080101000077", "Potongan Daging Unggas", "", "Nonaktif"],
  ["080101000078", "Filet Dada (Breast Fillet)", "", "Nonaktif"],
  ["080101000079", "Lemak", "", "Nonaktif"],
  [
    "080102000001",
    "Patties",
    "Patties adalah produk yang terbuat dari hasil pencincangan daging  mamalia dan atau unggas dengan atau tanpa penambahan bahan pangan lain (seperti tepung, air, bumbu dan rempah). Campuran dicetak atau diisikan dalam selongsong plastik dan didinginkan atau dibekukan sebagian sebelum diiris membentuk bulat atau bentuk lainnya.",
    "Aktif",
  ],
  [
    "080102000002",
    "Sosis Mentah",
    "Sosis mentah adalah sosis yang dibuat dari hasil penghalusan  daging mamalia dan atau unggas, selain daging babidengan  penambahan garam dan rempah-rempah antara lain : sosis  breakfast mentah.  Sosis mentah adalah sosis yang dibuat dari hasil penghalusan  daging mamalia dan atau unggas, selain daging babidengan  penambahan garam dan rempah-rempah antara lain : sosis  breakfast mentah.  Klasifikasi : a. Sosis Daging  Merupakan sosis dengan kandungan daging tidak kurang dari  35%. b. Sosis Daging Kombinasi  Merupakan sosis dengan kandungan daging tidak kurang dari  15%. Karakteristik dasar : \x{2022} Kadar protein sosis daging tidak kurang dari 13% dan sosis  daging kombinasi tidak kurang dari 8%; \x{2022} Kadar lemak tidak lebih dari 20%. ",
    "Aktif",
  ],
  [
    "080102000003",
    "Sosis Mentah Daging Babi",
    "Sosis mentah daging babi adalah sosis yang dibuat dari hasil  penghalusan tetelan daging babi, dengan penambahan garam dan rempah-rempah.",
    "Aktif",
  ],
  [
    "080102000004",
    "Daging Cincang",
    "Daging cincang adalah daging mentah yang telah dikecilkan  ukurannya dengan dicincang atau dicacah. ",
    "Aktif",
  ],
  [
    "080102000005",
    "Daging Giling",
    "Daging giling adalah daging yang dikecilkan ukurannya dengan alat grinder/mincer.",
    "Aktif",
  ],
  [
    "080102000006",
    "Daging Murni Giling Tanpa Lemak",
    "Daging murni giling tanpa lemak adalah daging murni (lean meat) yang dikecilkan ukurannya dengan alat grinder/mincer. Daging cincang atau daging giling yang dinyatakan sebagai daging murni giling tanpa lemak tidak boleh mengandung total lemak lebih dari 7%. Misal Breakfast Sausage",
    "Aktif",
  ],
  [
    "080102000007",
    "Potongan Daging Unggas dan Daging Hewan Buruan yang Dilepaskan dari Tulangnya, Digiling Mekanik dan Dibentuk (Dengan atau Tanpa Pembaluran atau Pelapisan)",
    "",
    "Aktif",
  ],
  [
    "080102000008",
    "Mechanically Deboned Meat (MDM)",
    "Mechanically Deboned Meat (MDM) adalah daging yang dihasilkan dari pemisahan daging yang menempel pada tulang dengan perlakuan mekanis.",
    "Aktif",
  ],
  [
    "080102000009",
    "Desinewed Minced Meat (DMM)",
    "Desinewed Minced Meat (DMM) adalah daging yang dihasilkan dari pemisahan daging yang menempel pada tulang dengan perlakuan mekanis, menghasilkan produk yang lebih kasar dari MDM. ",
    "Aktif",
  ],
  [
    "080201010001",
    "Bacon",
    "Bacon (yang di-curing, di-curing kering, di-curing rendam, di-curing injeksi) adalah daging babi yang di-curing dari bagian iga (belly bacon). Bacon dapat diasap maupun tidak diasap.",
    "Nonaktif",
  ],
  [
    "080201010002",
    "Bacon Sapi",
    "Bacon sapi adalah produk olahan daging sapi yang dilakukan  curing, pengasapan yang berasal dari bagian sandung lamur  (brisket) sapi, dapat diasap maupun tidak diasap.",
    "Nonaktif",
  ],
  [
    "080201010003",
    "Daging Marinasi",
    "Daging marinasi adalah potongan daging yang berasal dari mamalia dan unggas dengan atau tanpa tulang yang dimarinasi dengan bumbu seperti garam dan rempah-rempah. Proses marinasi dilakukan dengan cara perendaman, pengadukan atau injeksi.  Contohnya : sayap ayam marinasi, steik sapi marinasi, sate ayam marinasi. ",
    "Nonaktif",
  ],
  [
    "080201010004",
    "Daging Sapi yang Dimarinasi",
    "Daging sapi yang dimarinasi adalah potongan daging sapi yang direndam/dimarinasi dengan bumbu seperti garam dan rempah\2rempah dengan cara perendaman, pengadukan atau injeksi. ",
    "Nonaktif",
  ],
  [
    "080201010005",
    "Daging Ayam yang Dimarinasi",
    "Daging ayam yang dimarinasi adalah potongan daging ayam dengan atau tanpa tulang yang direndam/dimarinasi dengan bumbu seperti garam dan rempah-rempah dengan cara perendaman, pengadukan atau injeksi. Termasuk yang ditusuk sate.",
    "Nonaktif",
  ],
  [
    "080201010006",
    "Daging Asap",
    "Daging asap adalah produk yang diperoleh dengan mengasapi daging dan/atau daging curing atau olahannya dengan sumber asap yang diizinkan (batangan kayu, serbuk gergaji, atau berupa pelet kayu dan lainnya, cairan asap natural) yang bebas dari cat atau bahan pengawet kayu.  Produk yang diasapkan juga dapat terbuat dari bagian selain  daging, misalnya lidah sapi.",
    "Aktif",
  ],
  [
    "080201010007",
    "Daging Sei",
    "Daging sei adalah produk olahan daging sapi tradisional khas  Kupang, Nusa Tenggara Timur yang diolah dengan cara dicuring dan dilanjutkan dengan pengasapan menggunakan bahan bakar  kayu kusambi (Scheiechera oleosa, Merr). ",
    "Aktif",
  ],
  [
    "080201020001",
    "Daging Paha Babi Curing Mentah",
    "Daging paha babi curing mentah adalah produk yang diproses dari  daging paha babi belakang, baik utuh maupun deboning, atau berupa potongan, di-curing, diasap maupun tanpa asap, tanpa pemasakan. Semua tulang dan tulang rawan, urat dan jaringan  ikat harus dibuang. Kulit dan lemak dapat dibuang atau tidak.  Daging harus di-curing dan dapat diasap, diberi bumbu dan/atau  perisa.",
    "Nonaktif",
  ],
  [
    "080201020002",
    "Dendeng Daging",
    "Dendeng daging adalah produk makanan yang berbentuk  lempengan terbuat dari irisan atau gilingan daging segar yang  berasal dari hewan sehat yang telah diberi bumbu dan dikeringkan.  Daging yang dapat diolah menjadi dendeng dapat berupa daging  sapi, daging kerbau, daging babi, daging rusa, daging ayam dan  lain-lain.  Karakteristik dasar :  \x{2022} Warna dan bau khas dendeng;  \x{2022} Kadar air tidak lebih dari 10%.",
    "Aktif",
  ],
  [
    "080201030001",
    "Daging Sapi yang Difermentasi Dalam Wadah Keramik (Potted Beef)",
    "Daging sapi yang difermentasi dalam keramik (potted beef) adalah  daging yang dicacah kasar, dimasukkan ke dalam wadah keramik  dan difermentasi.",
    "Aktif",
  ],
  [
    "080201030002",
    "Daging Cangkuk",
    "Daging cangkuk adalah produk olahan daging tradisional khas  Jambi berupa daging sapi atau kerbau yang difermentasi bersama  garam dan rebung, didalam suatu wadah bambu yang tertutup  rapat selama tujuh hari, sehingga terjadi fermentasi spontan.",
    "Aktif",
  ],
  [
    "080202000001",
    "Daging Paha Babi Curing Matang",
    "Daging paha babi curing matang adalah produk yang diolah dari  daging paha babi belakang-dibelah melintang dari sisa bagian sisi  pada suatu titik yang tidak lebih ke depan (arah anterior) dari ujung  tulang pinggang. Semua tulang dan tulang rawan, urat dan jaringan  ikat harus dibuang. Kulit dan lemak dapat dibuang atau tidak.  Daging harus di-curing dan dapat diasap, diberi bumbu dan atau  perisa.",
    "Aktif",
  ],
  [
    "080202000002",
    "Ham Sapi (Daging Paha Sapi Curing) Matang",
    "Ham sapi (daging paha sapi curing) matang adalah produk yang  diolah dari daging paha sapi belakang-dibelah melintang dari sisa  bagian sisi pada suatu titik yang tidak lebih ke depan (arah anterior)  dari ujung tulang pinggang. Semua tulang dan tulang rawan, urat  dan jaringan ikat harus dibuang. Kulit dan lemak dapat dibuang  atau tidak. Daging harus dicuring dan dapat diasap, diberi bumbu  dan atau perisa.",
    "Aktif",
  ],
  [
    "080202000003",
    "Bahu Babi Curing Matang",
    "Bahu babi curing matang adalah produk yang terbuat dari daging  kaki depan babi. Tidak mengandung tulang dan urat, dapat  mengandung kulit dan lemak. Daging dicuring dan diasap, serta  dapat dibumbui.",
    "Aktif",
  ],
  [
    "080202000004",
    "Bahu Sapi Curing Matang",
    "Bahu sapi curing matang adalah produk yang terbuat dari daging  kaki depan sapi. Tidak mengandung tulang dan urat, dapat  mengandung kulit dan lemak. Daging dicuring dan diasap, serta  dapat dibumbui.",
    "Aktif",
  ],
  [
    "080202000005",
    "Daging Olahan Berbumbu",
    "Daging olahan berbumbu adalah berbagai jenis olahan dengan  bahan utama berupa daging berbentuk utuh atau potongan yang  dimasak hingga matang, dengan maupun tanpa penambahan bahan  pangan dan bumbu-bumbu lainnya, dengan maupun tanpa  kuah/saus.  Contohnya adalah rendang daging, gulai ayam, gepuk daging sapi,  sate ayam, sate kambing, ayam bumbu sukabumi, ayam bumbu  gudeg, ayam bakakak, ayam goreng rica-rica, sambal goreng hati,  ayam betutu, pepes ayam, daging sie reuboh, ayam bolognes, daging  sapi saus lada hitam, daging ayam saus barbekyu dan lain lain.",
    "Aktif",
  ],
  [
    "080202000006",
    "Daging Kuah dalam Kemasan",
    "Daging kuah dalam kemasan adalah hasil olahan daging yang  berbentuk potongan atau irisan dengan atau tanpa penambahan  bahan makanan lain, bumbu, dikemas secara kedap (hermetis)  dalam kemasan kaleng, aluminium foil atau pengemas lain yang  sesuai dan disterilkan.  Daging kuah dalam kemasan dapat berupa daging sapi, daging babi,  daging ayam, dan lain-lain.",
    "Aktif",
  ],
  [
    "080202000007",
    "Daging dalam Kaleng",
    "Daging dalam kaleng adalah daging segar atau daging asap yang  dikemas dalam wadah bersih, yang ditutup secara kedap (hermetis),  dan diproses panas untuk menjamin keawetannya. Dapat  mengandung garam dan air/saus/minyak. Daging dalam kemasan  dapat berupa daging sapi, daging babi, daging ayam dan lain lain.  Karakteristik dasar :  Kandungan daging (meat content) tidak kurang dari 60%.",
    "Aktif",
  ],
  [
    "080202000008",
    "Abon Daging",
    "Abon daging adalah makanan kering berbentuk khas dibuat dari  daging, direbus, disayat-sayat, dibumbui, digoreng dan dapat juga  dipres.  Abon terbuat dari daging berbagai jenis hewan seperti sapi, ayam,  babi, dan lain-lain.  Karakteristik dasar :  \x{2022} Bau, rasa dan warna normal;  \x{2022} Kadar air tidak lebih dari 7%.",
    "Aktif",
  ],
  [
    "080202000009",
    "Kerupuk4  Kulit/Rambak",
    "Kerupuk4 kulit/rambak adalah makanan kering yang dibuat dari  kulit hewan melalui tahap pembuangan bulu, pengembangan kulit,  perebusan, pengeringan, dan dikukus untuk kerupuk4 kulit  mentah atau dilanjutkan dengan penggorengan untuk kerupuk4  kulit siap konsumsi.",
    "Aktif",
  ],
  [
    "080202000010",
    "Keripik3 Paru",
    "Keripik3 paru adalah makanan kering yang dibuat dari paru hewan  yang diolah dengan cara perebusan, diiris tipis sehingga berbentuk  lempeng, diberi bumbu kemudian digoreng dengan atau tanpa  penambahan tepung.  Keripik3 paru dapat dibuat dari paru beberapa jenis hewan seperti  sapi, kerbau, babi, dan lain-lain.",
    "Aktif",
  ],
  [
    "080202000011",
    "Kerupuk4 Berbasis Daging, Daging Unggas dan Daging Hewan Buruan",
    "Kerupuk4 berbasis daging, daging unggas dan daging hewan buruan  adalah makanan kering yang terbuat dari bagian yang diperoleh dari  hewan mamalia maupun unggas, yang kering dan renyah setelah  proses penggorengan, dengan atau tanpa penambahan tepung.  Contohnya adalah kerupuk4 usus, kerupuk4 ceker ayam, dan lainlain.",
    "Aktif",
  ],
  [
    "080202000012",
    "Usus Ayam Goreng",
    "Usus ayam goreng adalah usus ayam yang dipotong-potong,  dicampur bumbu, kemudian digoreng dengan atau tanpa tepung  pelapis",
    "Aktif",
  ],
  [
    "080202000013",
    "Foie Gras and Pates",
    "Foie gras and pates adalah pasta daging yang dapat dioles  Karakteristik dasar :  Kadar daging tidak kurang dari 70%.",
    "Aktif",
  ],
  [
    "080203000001",
    "Ayam Katsu (Chicken Katsu)",
    "Ayam katsu (chicken katsu) adalah dada ayam dengan atau tanpa  marinasi, dengan atau tanpa tepung pelapis (predust6), kemudian  dilapis batter5 dan bread crumb/tepung panir/tepung roti, digoreng  dan dibekukan.",
    "Aktif",
  ],
  [
    "080203000002",
    "Ayam Karage (Chicken Karage)",
    "Ayam karage (chicken karage) adalah dada ayam atau paha ayam  dengan atau tanpa marinasi, dengan atau tanpa tepung pelapis  (predust6), kemudian dilapis batter5 dan breader (tepung pelapis  seperti terigu dan maizena), digoreng dan dibekukan.",
    "Aktif",
  ],
  [
    "080203000003",
    "Ayam Goreng",
    "Ayam goreng adalah potongan ayam dengan atau tanpa marinasi,  dengan atau tanpa melalui proses pelapisan (breading), digoreng dan  dibekukan. Contohnya paha bawah (drumstick), popcorn chicken,  dan lain-lain.",
    "Aktif",
  ],
  [
    "080203000004",
    "Daging Marinasi",
    "Daging marinasi adalah potongan ayam atau daging yang  dimarinasi, dimasak dan dibekukan. Contohnya sayap ayam  marinasi, spicy wing, spicy chick, paha bawah (drumstick) marinasi,  dan lain-lain.",
    "Aktif",
  ],
  [
    "080203000005",
    "Chicken Strip Beku",
    "Chicken strip beku adalah daging ayam tanpa tulang yang dipotongpotong  memanjang, dimarinasi, di-coating dan digoreng sebelum  dibekukan.",
    "Aktif",
  ],
  [
    "080203000006",
    "Ayam Cordon Bleu (Chicken Cordon Bleu)",
    "Ayam cordon bleu (Chicken Cordon Bleu) adalah daging ayam tanpa  tulang yang utuh dari dada, dimarinasi dan diberi isi (filling) dengan  keju dan irisan daging ayam asap atau daging sapi asap. Produk ini  kemudian melalui proses pelapisan (breading) dan digoreng sebelum  dibekukan.",
    "Aktif",
  ],
  [
    "080203000007",
    "Kulit Ayam Goreng",
    "Kulit ayam goreng adalah kulit ayam yang dipotong-potong,  dicampur bumbu bumbu, kemudian digoreng dengan atau tanpa  tepung pelapis, dibekukan dan dikemas.",
    "Aktif",
  ],
  [
    "080203000008",
    "Potongan Daging dengan Saus dalam Kemasan yang Dibekukan",
    "Potongan daging dengan saus dalam kemasan yang dibekukan  adalah hasil olahan potongan daging, daging unggas maupun daging  hewan buruan yang ditambah saus dengan atau tanpa penambahan  rempah-rempah dan atau bumbu-bumbu, dimasak dengan  perlakuan panas, dikemas secara kedap atau hermetis dalam  kemasan kaleng, alumunium foil atau pengemas lain yang sesuai  dan dibekukan.  Contoh: potongan daging sapi dengan saus Bolognese, potongan  daging ayam dengan saus carbonara, potongan daging sapi dengan  saus blackpepper, potongan daging ayam dengan saus barbeque,  potongan daging dada asap dengan bumbu nasi goreng.  Karakteristik dasar:  Kadar daging tidak kurang dari 30%.",
    "Aktif",
  ],
  [
    "080203000009",
    "Daging Olahan Berbumbu Beku",
    "Daging olahan berbumbu beku adalah berbagai jenis  olahan/masakan khas dengan bahan utama daging, daging unggas  maupun daging hewan buruan, berbentuk potongan yang dimasak  dengan suhu tinggi hingga matang, dengan atau tanpa penambahan  bahan pangan dan bumbu-bumbu lainnya, dengan atau tanpa kuah  dikemas secara aseptik; kemudian dibekukan.  Contohnya adalah rendang daging, gulai ayam, gepuk daging sapi,  sate ayam, sate kambing, ayam bumbu sukabumi, ayam bumbu  gudeg, ayam bakakak, ayam goreng rica-rica, sambal goreng hati,  ayam betutu, pepes ayam, daging sie reuboh, ayam bolognes, daging  sapi saus lada hitam, daging ayam saus barbekyu, dan lain lain.",
    "Aktif",
  ],
  [
    "080301010001",
    "Sosis Asap",
    "Sosis asap adalah sosis yang mengalami pengasapan dalam ruang  asap (smoked house) untuk menghasilkan cita rasa asap yang khas.  Klasifikasi :  a. Sosis Asap  Merupakan sosis asap dengan kandungan daging tidak kurang  dari 35%.  b. Sosis Asap Kombinasi  Merupakan sosis asap kombinasi dengan kandungan daging tidak  kurang dari 15%.  Karakteristik dasar :  \x{2022} Kadar protein sosis asap tidak kurang dari 13% dan sosis asap  kombinasi tidak kurang dari 8%;  \x{2022} Kadar lemak tidak lebih dari 20%.",
    "Aktif",
  ],
  [
    "080301010002",
    "Sosis Daging",
    "Sosis daging adalah produk berbahan baku daging yang dihaluskan  dengan atau tanpa penambahan bahan pangan lain dan  dimasukkan ke dalam selongsong sosis.  Daging yang digunakan dapat berupa daging sapi, kerbau, kambing,  domba, ayam, babi atau daging hewan ternak lainnya yang layak  dimakan, dan atau hewan unggas, dengan menyebut jenis  dagingnya.  Klasifikasi dan karakteristik dasar mengacu pada Klasifikasi dan  Karakteristik dasar Sosis Mentah (Poin 08.1.2)",
    "Aktif",
  ],
  [
    "080301010003",
    "Kornet Daging Non Sterilisasi",
    "Kornet daging non sterilisasi adalah produk yang dibuat dari  potongan daging ternak atau unggas dan atau campurannya tanpa  tulang, segar atau beku, dapat dicampur dengan daging bagian  kepala dan atau jantung, dengan proses curing, dengan atau tanpa  penambahan bahan pangan lain, diproses tanpa sterilisasi dan  dikemas dalam wadah tertutup.  Klasifikasi  a. Kornet daging  merupakan kornet dengan kandungan daging tidak kurang dari  45 %.  b. Kornet daging kombinasi  merupakan kornet dengan kandungan daging tidak kurang dari  25 %.  c. Kornet unggas  merupakan kornet dengan kandungan daging tidak kurang dari  35 %.  d. Kornet unggas kombinasi  merupakan kornet dengan kandungan daging tidak kurang dari  20 %.  Karakteristik dasar :  \x{2022} Kadar protein kornet daging tidak kurang dari 17%.  \x{2022} Kadar protein kornet daging kombinasi tidak kurang dari 10%.  \x{2022} Kadar protein unggas tidak kurang dari 12%.  \x{2022} Kadar protein unggas kombinasi tidak kurang dari 8%.  \x{2022} Kadar lemak keduanya tidak lebih dari 12 %.",
    "Aktif",
  ],
  [
    "080301010004",
    "Urutan",
    "Urutan adalah sosis tradisional khas Bali yang terbuat dari daging  babi yang dihaluskan, yang difermentasi dengan bakteri alami pada  usus babi, dikemas dalam selongsong usus halus babi.",
    "Aktif",
  ],
  [
    "080301020001",
    "Sosis Cina (Termasuk Sosis Tradisional yang Dicuring atau Diasap) atau LupCheong",
    "Sosis cina (termasuk sosis tradisional yang di-curing atau diasap)  atau lupcheong adalah sosis dari daging babi, ayam atau kalkun.  Daging dipotong manual menjadi irisan tipis dan lemak dari bagian  punggung (backfat) dipotong. Daging dan lemak kemudian dicampur  merata dengan campuran bumbu (yang khas: kecap dan gula) dan  dibiarkan terendam dalam bumbu selama beberapa jam sebelum  diisi. Selongsong sosis yang digunakan umumnya usus halus babi.  Sosis kemudian dikeringkan.  Klasifikasi dan Karakteristik dasar mengacu pada Klasifikasi dan  Karakteristik dasar Sosis Mentah (Poin 08.1.2)",
    "Aktif",
  ],
  [
    "080301030001",
    "Salami",
    "Salami adalah daging giling kasar, difermentasi dengan starter  bakteri dengan atau tanpa penambahan bahan pangan lain. Dapat  diasap sebelum atau selama pengeringan, dapat terjadi  pertumbuhan kapang di permukaannya maupun tidak.",
    "Aktif",
  ],
  [
    "080301030002",
    "Chorizos",
    "Chorizos adalah sosis daging babi yang menggunakan rempahrempah.  Rempah yang digunakan dan bentuk olahannya dapat  bervariasi misalnya sosis babi yang kering, semi kering, pedas,  sedang, di-curing, berwarna merah hingga oranye pucat, dari daging  yang digiling halus maupun kasar.",
    "Aktif",
  ],
  [
    "080302000001",
    "Pate Daging",
    "Pate daging adalah daging direbus, digiling, dimasukkan hati segar  halus, digiling lagi, dimasukkan selongsong/kaleng/jar, dan  dipanaskan. Contohnya pate angsa.",
    "Aktif",
  ],
  [
    "080302000002",
    "Bakso Daging",
    "Bakso daging adalah produk olahan daging yang dibuat dari daging  hewan ternak yang dicampur pati dan bumbu-bumbu, dengan atau  tanpa penambahan bahan pangan lain, yang berbentuk bulat atau  bentuk lainnya dan dimatangkan.  Daging yang digunakan dapat berupa daging sapi, kerbau, kambing,  domba, ayam, babi atau daging hewan ternak lainnya yang layak  dimakan, dan atau hewan unggas, dengan menyebut jenis  dagingnya, serta dapat mengandung bagian bukan daging seperti  urat dan hati.  Klasifikasi bakso daging diklasifikasikan sebagai berikut:  a) Bakso daging;  merupakan bakso dengan kandungan daging tidak kurang dari  45 %  b) Bakso daging kombinasi;  merupakan bakso dengan kandungan daging tidak kurang dari  20 %  Karakteristik dasar :  \x{2022} Kadar protein bakso daging tidak kurang dari 11% dan bakso  daging kombinasi tidak kurang dari 8 %;  \x{2022} Kadar lemak tidak lebih dari 10%.",
    "Aktif",
  ],
  [
    "080302000003",
    "Daging Cincang Olahan Berbumbu",
    "Daging cincang olahan berbumbu adalah berbagai jenis olahan  dengan bahan utama berupa daging cincang atau daging giling yang  dimasak hingga matang, dengan atau tanpa penambahan bahan  pangan dan bumbu-bumbu lainnya, dengan atau tanpa kuah/saus,  dikemas secara aseptis dan disterilkan.  Contoh : daging ayam dengan saus Bolognese, daging ayam dengan  saus carbonara, daging sapi dengan saus blackpepper, daging ayam  dengan saus barbekyu, daging curing cacahan matang.  Karakteristik dasar :  Kandungan daging tidak kurang dari 30%.",
    "Aktif",
  ],
  [
    "080302000004",
    "Patties Daging Panggang Setengah Matang",
    "Patties daging panggang setengah matang adalah produk yang  terbuat dari hasil pencincangan daging mamalia maupun unggas,  dengan bahan pangan lain berupa tepung serealia, bahan pengikat,  air, bumbu, dan bawang. Daging dicampur dengan bahan lain, dan  campuran dicetak membentuk patties atau diisikan dalam  selongsong plastik dan didinginkan atau dibekukan sebagian  sebelum diiris membentuk patties. Patties kemudian dipanggang  setengah matang.",
    "Aktif",
  ],
  [
    "080302000005",
    "Brawn and Head Cheese",
    "Brawn and head cheese adalah produk yang dibuat dengan merebus  tulang-tulang, kulit, tulang rawan, daging dari bagian kepala,  telinga, kaki, serta tetelan lain yang banyak mengandung jaringan  ikat tetapi rendah lemak. Dapat mengandung daging matang, rusk,  dan lainnya, dapat dijernihkan dengan putih telur/plasma darah  untuk membentuk jelly yang jernih.",
    "Aktif",
  ],
  [
    "080302000006",
    "Kornet Daging Sterilisasi",
    "Kornet daging sterilisasi adalah produk yang dibuat dari potongan  daging ternak atau unggas dan atau campurannya tanpa tulang,  segar atau beku, dapat dicampur dengan daging bagian kepala dan  atau jantung, dengan proses curing, dengan atau tanpa  penambahan bahan pangan lain, dikemas dalam wadah tertutup,  kedap udara atau secara hermetis dan diproses dengan sterilisasi.  Klasifikasi dan karakteristik dasar mengacu pada Klasifikasi dan  Karakteristik dasar Kornet daging non sterilisasi (Poin 08.3.1.1)  Contoh: Kornet daging ayam",
    "Aktif",
  ],
  [
    "080302000007",
    "Daging Luncheon Matang",
    "Daging luncheon matang adalah produk yang terbuat dari daging  atau campuran dua jenis daging atau lebih yang telah dihaluskan,  dicuring dan dapat dimasak/dipanggang/telah diasap.  Contoh: Bacon Bits Luncheon Ham dan Beef Pastrami",
    "Aktif",
  ],
  [
    "080302000008",
    "Pasta Daging",
    "Pasta daging adalah daging yang dihaluskan menyerupai pasta  dengan tekstur sedang. Dapat mengandung bagian non daging  seperti rusk, air, atau bahan pengisi lain yang sesuai seperti  konsentrat kedelai/Na-kaseinat.",
    "Aktif",
  ],
  [
    "080302000009",
    "Salami Matang / Pepperoni Matang",
    "difermentasi dengan starter kultur, kemudian dimasak hingga  matang.  Salami matang dan produk sejenisnyaadalah daging giling yang  ditambah rempah-rempah dan memiliki rasa yang kuat, sudah  dimasak yang mempunyai karakter khas salami.",
    "Aktif",
  ],
  [
    "080302000010",
    "Sosis Daging",
    "Sosis daging adalah produk berbahan baku daging yang dihaluskan  dengan atau tanpa penambahan bahan pangan lain dan  dimasukkan ke dalam selongsong sosis dengan proses pemasakan  Daging yang digunakan dapat berupa daging sapi, kerbau, kambing,  domba, ayam, babi atau daging hewan ternak lainnya yang layak  dimakan, dan atau hewan unggas, dengan menyebut jenis  dagingnya.  Klasifikasi  a. Sosis Daging  Merupakan sosis dengan kandungan daging tidak kurang dari  35 %  b. Sosis Daging Kombinasi  Sosis daging kombinasi merupakan sosis dengan kandungan  daging tidak kurang dari 15 %  Karakteristik dasar :  \x{2022} Kadar protein sosis daging tidak kurang dari 13% dan sosis  daging kombinasi tidak kurang dari 8 %;  \x{2022} Kadar lemak tidak lebih dari 20%.",
    "Aktif",
  ],
  [
    "080302000011",
    "Sosis Daging Non Casing",
    "yang diemulsikan, dengan penambahan tepung atau pati dengan  atau tanpa penambahan bumbu dan bahan pangan lain yang  diizinkan dan dicetak berbentuk sosis.  Klasifikasi dan Karakteristik dasar mengacu pada Klasifikasi dan  Karakteristik dasar Sosis Mentah (Poin 08.1.2)",
    "Aktif",
  ],
  [
    "080302000012",
    "Sosis Daging Siap Makan",
    "Sosis daging siap makan adalah produk dari campuran daging  halus yang diemulsikan, dengan tambahan tepung atau pati dengan  atau tanpa penambahan bumbu dan bahan pangan lain dan  dimasukkan ke dalam kemasan yang kedap udaradan dilakukan  sterilisasi, dapat dimakan langsung tanpa dimasak.",
    "Aktif",
  ],
  [
    "080302000013",
    "Terrines (Campuran Cacahan Daging Matang)",
    "Terrines (campuran cacahan daging matang) adalah campuran  daging cacahan yang dimasak di dalam wadah (vessel) dari tanah  liat.",
    "Aktif",
  ],
  [
    "080302000014",
    "Rolade Daging",
    "Rolade daging adalah produk dari lumatan daging atau daging giling  dapat ditambah sayur, jamur diberi bumbu-bumbu, digulung  dengan telur dadar atau bahan lainnya. Dimasak dan dapat diiris.",
    "Aktif",
  ],
  [
    "080302000015",
    "Daging Halus Olahan Berbumbu",
    "Daging halus olahan berbumbu adalah berbagai jenis olahan  dengan bahan utama berupa daging, daging unggas maupun daging  hewan buruan, yang dihaluskan yang dimasak dengan suhu tinggi  hingga matang, dengan maupun tanpa penambahan bahan  makanan dan bumbu-bumbu lainnya. Contohnya adalah perkedel  daging, sambal goreng cincang.",
    "Aktif",
  ],
  [
    "080302000016",
    "Potongan Daging/Daging Cincang/Daging Giling dengan Saus dalam Kemasan",
    "Potongan daging/daging cincang/daging giling dengan saus dalam  kemasan adalah hasil olahan potongan daging, daging cincang atau  daging giling yang ditambah saus dengan atau tanpa penambahan  rempah-rempah dan dengan atau tanpa penambahan bumbubumbu,  dimasak dengan perlakuan panas, dikemas secara kedap  atau hermetis dalam kemasan kaleng, alumunium foil atau  pengemas lain yang sesuai dan disterilkan.  Contoh: saus Bolognese untuk spaghetti, saus carbonara, daging  sapi saus blackpepper, daging ayam saus barbeque.  Karakteristik dasar:  Kadar daging tidak kurang dari 30 %.",
    "Aktif",
  ],
  [
    "080302000017",
    "Dendeng Daging",
    "Dendeng daging adalah produk dari lumatan daging, diberi bumbu  dengan atau tanpa penambahan bahan pangan lain, dicetak dan  dimasak.  Daging yang dapat diolah menjadi dendeng dapat berupa daging  sapi, daging kerbau, daging babi, daging rusa, daging ayam.",
    "Aktif",
  ],
  [
    "080302000018",
    "Pepperoni",
    "Pepperoni adalah daging giling yang ditambah rempah-rempah dan  memiliki rasa yang kuat, sudah dimasak yang mempunyai karakter  khas Pepperoni.",
    "Aktif",
  ],
  [
    "080303000001",
    "Burger Daging",
    "Burger Daging adalah produk yang terbuat dari daging giling,  dengan penambahan air, bumbu, dengan atau tanpa penambahan  bahan pangan lain, kemudian dicetak, di-lapisi (breading), dimasak,  dan didinginkan.",
    "Aktif",
  ],
  [
    "080303000002",
    "Naget Ayam",
    "Naget ayam adalah produk olahan ayam yang dicetak, dimasak dan  dibekukan, dibuat dari campuran daging ayam giling yang diberi  bahan pelapis dengan atau tanpa penambahan bahan pangan lain  dengan atau tanpa isi di bagian tengahnya.  Klasifikasi  a. Naget daging ayam merupakan naget dengan kandungan daging  ayam tidak kurang dari 35 %.  b. Naget daging ayam kombinasi  Naget daging ayam kombinasi merupakan naget dengan  kandungan daging ayam tidak kurang dari 22,5 %.  Karakteristik dasar :  \x{2022} Kadar protein naget daging ayam tidak kurang dari 12% dan  naget daging ayam kombinasi tidak kurang dari 9 %.  \x{2022} Kadar lemak tidak lebih dari 20%.",
    "Aktif",
  ],
  [
    "080303000003",
    "Kornet Daging",
    "Kornet daging adalah produk yang dibuat dari potongan daging  ternak atau unggas dan atau campurannya tanpa tulang, segar atau  beku, dapat dicampur dengan daging bagian kepala dan atau  jantung, dengan proses curing, dengan atau tanpa penambahan  bahan pangan lain, diproses, dikemas dalam wadah tertutup dan  dibekukan.  Klasifikasi  a. Kornet daging  merupakan kornet dengan kandungan daging tidak kurang dari  45 %.  b. Kornet daging kombinasi  merupakan kornet dengan kandungan daging tidak kurang dari  25 %.  c. Kornet unggas  merupakan kornet dengan kandungan daging tidak kurang dari  35 %.  d. Kornet unggas kombinasi  merupakan kornet dengan kandungan daging tidak kurang dari  20 %.  Karakteristik dasar :  \x{2022} Kadar protein kornet daging tidak kurang dari 17%;  \x{2022} Kadar protein kornet daging kombinasi tidak kurang dari 10%;  \x{2022} Kadar protein unggas tidak kurang dari 12%;  \x{2022} Kadar protein unggas kombinasi tidak kurang dari 8%;  \x{2022} Kadar lemak keduanya tidak lebih dari 12 %;",
    "Aktif",
  ],
  [
    "080303000004",
    "Naget Daging",
    "Naget daging adalah produk olahan daging sapi yang dicetak dalam  berbagai bentuk, dimasak, dan dibekukan, dibuat dari campuran  dagingsapi giling yang diberi bahan pelapis dengan atau tanpa  penambahan bahan pangan lain; dengan atau tanpa isi di bagian  tengahnya.  Klasifikasi  a. Naget daging sapi  Naget daging sapi merupakan naget dengan kandungan daging  sapi tidak kurang dari 35 %  b. Naget daging sapi kombinasi  Naget daging sapi kombinasi merupakan naget dengan  kandungan daging sapi tidak kurang dari 15 %  Karakteristik dasar :  \x{2022} Kadar protein naget daging sapi tidak kurang dari 12% dan naget  daging sapi kombinasi tidak kurang dari 9 %;  \x{2022} Kadar lemak tidak lebih dari 20%.",
    "Aktif",
  ],
  [
    "080303000005",
    "Smoked Chicken Breast (Daging Dada Ayam Asap)",
    "Smoked Chicken Breast (Daging Dada Ayam Asap) adalah produk  yang terbuat dari hasil daging dada ayam, baik yang tidak  dihaluskan maupun dihaluskan, dengan bahan pangan lain berupa  berbagai bumbu dan melalui proses curing; diisikan ke dalam  selongsong plastik dan dimasak dengan pengasapan, didinginkan  sebelum diiris membentuk potongan, lembaran atau gelondongan  dan dibekukan",
    "Aktif",
  ],
  [
    "080303000006",
    "Siomay Daging",
    "Siomay daging adalah produk yang terbuat dari daging unggas atau  ruminansia yang dihaluskan, dicampur dengan atau tanpa hasil  perikanan yang dihaluskan atau potongan, bumbu-bumbu, dan  bahan pangan lain, dilapis dengan kulit yang terbuat dari adonan  terigu dan air dan dibentuk, dimasak, dikemas, dan dibekukan.  Karakteristik dasar :  Kandungan daging tidak kurang dari 30%.",
    "Aktif",
  ],
  [
    "080303000007",
    "Gyoza",
    "Gyoza adalah produk yang terbuat dari daging ayam, sapi, dan/atau  daging hewan ternak lainnya yang dihaluskan, dengan atau tanpa  hasil perikanan yang dihaluskan atau potongan, bumbu-bumbu,  dan bahan pangan lain, dilapis dengan kulit yang terbuat dari  adonan terigu dan air dan dibentuk, dimasak, dikemas, dan  dibekukan. Jenis gyoza diantaranya Gyoza Ayam, Gyoza Daging,  Gyoza Ayam dan Sayuran.  Karakteristik dasar :  Kandungan daging tidak kurang dari 15%.",
    "Aktif",
  ],
  [
    "080303000008",
    "Swikiau/Kuotieh Daging",
    "Swikiau/kuotieh daging adalah produk yang terbuat dari daging  yang dihaluskan, dicampur dengan hasil perikanan yang dihaluskan  atau potongan, sayuran, bumbu-bumbu, dan bahan pangan lain,  dilapis dengan kulit yang terbuat dari adonan terigu dan air dan  dibentuk, dimasak, dikemas, dan dibekukan.  Persyaratan meat content tidak kurang dari 30% (dengan kadar  daging >50%, kadar ikan <50%).",
    "Aktif",
  ],
  [
    "080303000009",
    "Ebi Katsu",
    "Ebi katsu adalah produk yang terbuat dari daging ayam yang  dihaluskan, dicampur dengan hasil perikanan yang dihaluskan atau  potongan, bumbu-bumbu, dan bahan pangan lain, dicetak, diberi  tepung pelapis, dimasak, dan dibekukan.",
    "Aktif",
  ],
  [
    "080303000010",
    "Keecho/Heecho",
    "Keecho/heecho adalah produk yang terbuat dari daging ayam yang  dihaluskan, dicampur dengan hasil perikanan yang dihaluskan atau  potongan, bumbu-bumbu, sayuran, dan bahan pangan lain, dilapis  dengan kulit tahu, dimasak, dikemas, dan dibekukan",
    "Aktif",
  ],
  [
    "080303000011",
    "Telur Bungkus Daging",
    "Telur bungkus daging adalah produk yang terbuat dari daging ayam  yang dihaluskan, dicampur maupun tidak dengan hasil perikanan  yang dihaluskan atau potongan, bumbu-bumbu, sayuran, dan  bahan pangan lain, dibentuk bulat seperti bakso dengan bagian  tengahnya berisi telur; dilapis dengan kulit tahu, dimasak, dikemas,  dan dibekukan.",
    "Aktif",
  ],
  [
    "080303000012",
    "Bakso Goreng",
    "Bakso goreng adalah produk yang terbuat dari daging yang  dihaluskan, dapat dicampur dengan hasil perikanan yang  dihaluskan atau potongan, bumbu-bumbu dan bahan pangan lain, lalu dibentuk bulat atau bentuk lainnya, digoreng, dibekukan,  dikemas dan disimpan beku.",
    "Aktif",
  ],
  ["080400000001", "Selongsong Sosis Kolagen", "", "Aktif"],
  [
    "080400000002",
    "Selongsong Sosis Dari Kolagen Ko-Ekstrusi",
    "",
    "Aktif",
  ],
  ["080400000003", "Selongsong Sosis Alami", "", "Aktif"],
  [
    "090101000001",
    "Ikan Segar",
    "Ikan segar adalah ikan mentah yang belum mengalami perlakuan  pengawetan kecuali pendinginan (chilling). Termasuk semua jenis  ikan dari jenis ikan bersirip (pisces) hasil penangkapan atau  budidaya.  ? contoh ikan pomatomidae: Pomatomus saltatrix (sea-bass tribe);  ? contoh ikan scombridae (scombroid): tuna, tongkol, cakalang,  kembung, tenggiri/makerel;  ? contoh ikan coryphaenedae: mahi-mahi (Coryphaena hipurus),  pompano dolphin (Coryphaena equiseli);  ? contoh ikan clupeidae: herring, layang, sardin, lemuru;  ? contoh ikan predator: tuna, cucut, marlin, meka, bawal;  ? contoh ikan hasil budidaya: nila, lele, gabus, patin, mas, gurame,  tawes, mujair, bandeng;  ? contoh ikan karang: kerapu, kakap, ekor kuning, kurisi;  ? contoh ikan pelagis besar: tuna, cucut, hiu, cakalang, meka,  marlin;  ? contoh ikan pelagis kecil: sardin, kembung, selar, teri, lemuru,  bawal, layur;  ? belut; sidat.",
    "Nonaktif",
  ],
  [
    "090101000002",
    "Sashimi Segar",
    "Sashimi segar adalah daging ikan segar dalam bentuk irisan tipis,  yang berasal dari loin, kubus, steak, dan bentuk lainnya yang tidak  mengalami pengolahan lebih lanjut, dipertahankan pada suhu  dingin (chilled) dan dikonsumsi dalam keadaan mentah dan segar.  Contoh produk diantaranya ikan tuna segar untuk sashimi, ikan  salmon segar untuk sashimi, gindara segar untuk sashimi, red  snaper segar untuk sashimi.",
    "Nonaktif",
  ],
  [
    "090101000003",
    "Tuna Loin Segar",
    "Tuna loin segar adalah daging ikan tuna yang diperoleh dari ikan  tuna segar yang dibelah menjadi empat bagian secara membujur,  dua bagian punggung (dorsal) dan dua bagian perut (belly), tanpa  kulit dan tulang, dan mengalami pendinginan dari jenis Tuna  Madidihang (Yellowfin Tuna/Thunnus albacores), Tuna Mata Besar  (Bigeye Tuna/Thunnus obesus), Tuna Sirip Biru (Bluefin  Tuna/Thunnus thynnus dan Thunnus maccoyii), Tuna Albakora  (Albacore/Thunnus alalunga).",
    "Nonaktif",
  ],
  [
    "090101000004",
    "Fillet Ikan Segar",
    "Fillet ikan segar adalah sayatan ikan yang dipisahkan dari karkas  ikan dengan pemotongan paralel terhadap tulang belakang dengan  atau tanpa kulit serta dilakukan pendinginan (chilling) dengan  bahan baku adalah semua jenis ikan dari kelompok pisces hasil  penangkapan atau budidaya.",
    "Nonaktif",
  ],
  [
    "090101000005",
    "Ikan Hidup untuk Konsumsi",
    "Ikan hidup untuk konsumsi adalah ikan dalam kondisi hidup yang  sehat dan tidak cacat. Ikan ini meliputi semua jenis ikan hasil  penangkapan atau budidaya.",
    "Nonaktif",
  ],
  [
    "090101000006",
    "Bandeng Segar Cabut Tulang dan Duri",
    "Bandeng segar cabut tulang dan duri adalah produk perikanan  dengan bahan baku bandeng (Chanos chanos) yang mengalami  proses pengolahan dengan pencabutan tulang dan duri, dan  pendinginan.",
    "Nonaktif",
  ],
  [
    "090102000001",
    "Keong Hidup",
    "Keong hidup adalah keong dalam kondisi hidup dan sehat dari jenis  keong (Babylonia spp.) termasuk keong macan (Babylonia spirata).",
    "Nonaktif",
  ],
  [
    "090102000002",
    "Kerang Hidup",
    "Kerang hidup adalah kerang yang hidup dan sehat. Jenis kerang  antara lain: simping (Common minolowpen); kerang mutiara/tapistapin  (Pinctida margaitifera); tiram (Crassostrea cucullata); kepah  (Meritrix meritrix); kerang tahu (Peryqlypta peticula); kerang mutiara  (Pinctada maxima); kerang bubul (Cudakia tigerina); kerang hijau  (Pena viridis); kerang bulu (Anadara broughtonia); kerang darah  (Anadara granosa); kerang kapak-kapak (Pina bicolor).",
    "Nonaktif",
  ],
  [
    "090102000003",
    "Kerang Segar",
    "Kerang segar adalah produk perikanan dengan bahan baku kerang  hidup yang mengalami perlakuan pendinginan.  Jenis kerang meliputi: simping (Common minolowpen); kerang  mutiara/tapis-tapin (Pinctida margaitifera); tiram (Crassostrea  cuculata); kepah (Meritrix meritrix); kerang tahu (Peryqlypta peticula);  kerang mutiara (Pinctada maxima); kerang bubul (Cudakia tigerina);  kerang hijau (Pena viridis); kerang bulu (Anadara broughtonia);  kerang darah (Anadara granosa); kerang kapak-kapak (Pina bicolor);  kerang bambu.",
    "Nonaktif",
  ],
  [
    "090102000004",
    "Tiram Hidup",
    "Tiram hidup adalah jenis Ostrea verginica, Ostrea gigas, Ostrea  lurida dalam kondisi hidup yang telah mengalami proses sortasi,  pemberokan (depurasi), penimbangan, pencucian, dan pengemasan.",
    "Nonaktif",
  ],
  [
    "090102000005",
    "Bulu Babi Segar",
    "Bulu babi segar adalah semua jenis bulu babi yang mengalami  perlakuan pendinginan.",
    "Nonaktif",
  ],
  [
    "090102000006",
    "Cumi-cumi Segar",
    "Cumi-cumi segar adalah cumi-cumi utuh hidup jenis Loligo spp.  yang mengalami perlakuan pendinginan.",
    "Nonaktif",
  ],
  [
    "090102000007",
    "Rajungan Segar",
    "Rajungan segar adalah semua jenis rajungan segar (sub ordo  Brachyura dari ordo Decapoda dan semua spesies dari famili  Lithodidae) hasil tangkapan dalam kondisi tidak bertelur dengan  ukuran lebar karapas (cangkang keras) diatas 15 (lima belas) cm  atau berat diatas 200 (dua ratus) gram per ekor.",
    "Nonaktif",
  ],
  [
    "090102000008",
    "Teripang Segar",
    "Teripang segar adalah semua jenis teripang yang mengalami  perlakuan pendinginan.",
    "Nonaktif",
  ],
  [
    "090102000009",
    "Udang Segar",
    "Udang segar adalah semua jenis udang yang baru  ditangkap/dipanen yang mengalami perlakuan pencucian, dengan pemotongan atau tanpa pemotongan kepala, sortasi dan  penimbangan, pengepakan, pengemasan, dan pelabelan.",
    "Nonaktif",
  ],
  [
    "090102000010",
    "Kepiting Hidup untuk Konsumsi",
    "Kepiting hidup untuk konsumsi adalah kepiting (Scylla serrata)  hidup yang sehat dan kelengkapan organ sesuai persyaratan, dalam  kondisi tidak bertelur dengan ukuran lebar karapas (cangkang  keras) diatas 15 (lima belas) cm atau berat di atas 200 (dua ratus)  gram per ekor yang berasal dari hasil budidaya.",
    "Nonaktif",
  ],
  [
    "090102000011",
    "Lobster dan Udang Kipas Hidup Untuk Konsumsi",
    "Lobster dan udang kipas hidup untuk konsumsi adalah lobster dan  udang kipas hidup yang sehat dan memiliki organ yang lengkap dari  jenis Lobster panulirus spp yang tidak dalam kondisi bertelur dengan  ukuran panjang karapas (cangkang keras) diatas 8 (delapan) cm  atau berat diatas 200 (dua ratus) gram per ekor, serta udang kipas  jenis Thenus spp.",
    "Nonaktif",
  ],
  [
    "090201000001",
    "Sidat Panggang Beku",
    "Sidat panggang beku adalah produk perikanan dengan bahan baku  sidat (Anguilla spp.) yang mengalami perlakuan menjadi filet,  pemanggangan, pengukusan, dan pemanggangan kembali dengan  atau tanpa penambahan bahan peningkat aroma dan rasa, dan  dibekukan.",
    "Nonaktif",
  ],
  [
    "090201000002",
    "Pempek Ikan Rebus Beku",
    "Pempek ikan rebus beku adalah produk perikanan dengan bahan  baku lumatan daging ikan segar dan/atau surimi dengan  penambahan tepung, air, garam, dengan atau tanpa bahan pangan  lain, yang mengalami perlakuan perebusan dan pembekuan.  Karakeristik dasar:  Kandungan lumatan daging ikan segar dan/atau surimi tidak kurang  dari 30%.",
    "Aktif",
  ],
  [
    "090201000003",
    "Bakso Ikan Beku",
    "Bakso ikan beku adalah produk ikan yang menggunakan lumatan  daging ikan atau surimi dicampur tepung, dan bahan pangan lain  bila diperlukan, yang mengalami pembentukan, perebusan, dan  pembekuan. Bahan baku ikan yang digunakan dapat berupa semua  jenis ikan dari kelas Pisces hasil penangkapan atau budidaya.  Karakteristik dasar:  Kandungan lumatan daging ikan atau surimi tidak kurang dari 40%.",
    "Aktif",
  ],
  [
    "090201000004",
    "Cumi-Cumi / Kerang / Ikan / ... Beku dengan Penambahan Bahan Pangan Lain",
    "Untuk memfasilitasi pendaftaran pangan olahan selain PSAH",
    "Aktif",
  ],
  [
    "090201000005",
    "Telur ikan beku dengan penambahan bahan pangan lain",
    "Untuk memfasilitasi pendaftaran pangan olahan selain PSAI",
    "Aktif",
  ],
  [
    "090202000004",
    "Stik, Filet,dan Lumatan Daging Ikan Berlapis Tepung Beku",
    "Stik, filet, dan lumatan daging ikan berlapis tepung beku adalah  produk perikanan dengan bahan baku stik, filet, dan lumatan daging  ikan yang dicelupkan dalam batter5 dan/atau pelapisan dengan  tepung roti atau tepung lain serta dibekukan. Nama jenis produk ini  diantaranya karaage ikan.",
    "Aktif",
  ],
  [
    "090202000005",
    "Udang Berlapis Tepung (Breaded) Beku",
    "Udang berlapis tepung (breaded) beku adalah produk olahan beku  dengan bahan baku udang segar atau beku dari genus Penaeus dan  lainnya, tanpa kulit dan kepala serta berlapis tepung roti.  Bentuk produk akhir antara lain:  \x{2022} Peeled tail on (PTO) yaitu produk udang berlapis tepung (breaded)  beku tanpa kepala dan kulit dikupas mulai dari ruas pertama  sampai dengan ruas kelima, sedangkan ruas terakhir dan ekor  disisakan.  \x{2022} Peeled deveined tail on (PDTO) yaitu produk udang berlapis  tepung (breaded) beku seperti peeled tail on tetapi usus dibuang.  \x{2022} PTO atau PDTO Stretchedyaitu produk udang berlapis tepung  (breaded) beku dalam bentuk peeled tail on atau peeled deveined  tail on kemudian diluruskan menggunakan alat stretcher. Contoh  produk adalah tempura.  \x{2022} Minced yaitu produk udang berlapis tepung (breaded) beku dari  lumatan daging udang yang dicetak dalam bentuk tertentu.  Contoh produk adalah ebi furai.  \x{2022} Peeled deveined (PD) yaitu produk udang berlapis tepung  (breaded) beku yang seluruh kulit dan ekor dikupas dan dibuang  kotoran perutnya.  \x{2022} Butterfly yaitu produk udang berlapis tepung (breaded) beku  seperti peeled devined tail on (PDTO) tetapi dibelah bagian  punggung sampai bagian perut bawah.",
    "Aktif",
  ],
  [
    "090202000006",
    "Naget Ikan/Udang/Cumi/Kerang Beku",
    "Naget ikan/udang/cumi/kerang beku adalah produk perikanan  dengan menggunakan lumatan daging ikan/udang/cumi/kerang  dan/atau surimi, dicampur tepung dan bahanpangan lain, dikukus,  dicetak, dibaluri dengan tepung pengikat (predust6), dimasukkan  dalam adonan batter5, kemudian dilapisi tepung roti/parutan kelapa  kering, dengan atau tanpa penggorengan, dan dibekukan.  Bahan baku yang digunakan meliputi ikan segar; udang segar; ikan  beku; udang beku; lumatan daging ikan; surimi dengan mutu sesuai  spesifikasi. Nama jenis produk ini diantaranya naget ikan, naget  udang, naget ikan dan udang, kroket udang.  Karakteristik dasar:  Lumatan daging ikan/udang/cumi/kerang dan atau surimi tidak  kurang dari 30%.",
    "Aktif",
  ],
  [
    "090204010001",
    "Ikan dan Produk Ikan Kukus atau Rebus",
    "Ikan dan produk ikan kukus atau rebus adalah ikan dan produk  ikan yang dimasak dengan cara pengukusan atau perebusan.",
    "Aktif",
  ],
  [
    "090204010002",
    "Ikan Pindang Air Garam",
    "Ikan pindang air garam adalah produk ikan dengan bahan baku ikan  yang mengalami perlakuan perebusan dengan air garam.",
    "Aktif",
  ],
  [
    "090204010003",
    "Ikan Pindang Garam",
    "Ikan pindang garam adalah produk ikan dengan bahan baku ikan  yang mengalami perlakuan pengukusan dan setiap lapisannya  ditaburi garam.",
    "Aktif",
  ],
  [
    "090204010004",
    "Bandeng Presto",
    "Bandeng presto adalah produk ikan dengan bahan baku ikan  bandeng (Chanos chanos) utuh yang mengalami perlakuan  perendaman dalam larutan garam atau bumbu dan pengukusan  dengan tekanan tinggi.",
    "Aktif",
  ],
  [
    "090204010005",
    "Kue Ikan/Kamaboko/Fish Cake (rebus atau kukus)",
    "Kue ikan/kamaboko/fish cake (rebus atau kukus) adalah produk  ikan dari surimi yang mengalami proses pencucian; pengadonan  dengan garam, tepung, bumbu, dengan atau tanpa bahan pangan  lain; pencetakan (forming); dan perebusan atau pengukusan sehingga  membentuk tekstur yang kenyal (gel). Jenis kamaboko: itatsuki  kamaboko, chikuwa kukus/rebus.  Karakteristik dasar:  Kandungan surimi tidak kurang dari 30%.",
    "Aktif",
  ],
  [
    "090204010006",
    "Bakwan Ikan (Rebus Atau Kukus)",
    "Bakwan ikan (rebus atau kukus) adalah produk ikan dari daging  ikan atau dari surimi yang mengalami proses pencucian; pengadonan  dengan garam, tepung, bumbu, dengan atau tanpa bahan pangan  lain; pencetakan (forming); dan perebusan atau pengukusan.  Karakteristik dasar:  Kandungan daging ikan atau surimi tidak kurang dari 10%.",
    "Aktif",
  ],
  [
    "090204010007",
    "Stik Kepiting Analog atau Imitation Crab Stick",
    "Stik kepiting analog atau imitation crab stick adalah produk berbahan  baku surimi dengan warna pada permukaan atas menyerupai warna  kepiting yang direbus, dan putih di bagian dalam, mempunyai  tekstur berfilamen seperti daging kepiting, beraroma dan rasa khas  kepiting.  Karakteristik dasar:  Kandungan surimi tidak kurang dari 30%.",
    "Aktif",
  ],
  [
    "090204010008",
    "Bakso Ikan",
    "Bakso ikan adalah produk ikan yang menggunakan lumatan daging  ikan atau surimi dicampur tepung dan bahan pangan lain bila  diperlukan, yang mengalami pembentukan dan perebusan. Bahan  baku ikan yang digunakan dapat berupa semua jenis ikan dari kelas  Pisces hasil penangkapan atau budidaya.  Karakteristik dasar:  Kandungan lumatan daging ikan atau surimi tidak kurang dari 40%.",
    "Aktif",
  ],
  [
    "090204010009",
    "Otak-Otak Ikan",
    "Otak-otak ikan adalah produk perikanan yang menggunakan  lumatan daging ikan dan/atau surimi dicampur tepung/pati dengan atau tanpa bahan pangan lain, yang mengalami pembentukan,  dengan atau tanpa dibungkus daun atau bahan lain yang sesuai,  dan pemasakan. Bahan baku yang digunakan ikan segar; ikan beku;  lumatan daging ikan; surimi dengan mutu sesuai spesifikasi.  Karakteristik dasar:  Kandungan daging ikan dan/atau surimi tidak kurang dari 30%.",
    "Aktif",
  ],
  [
    "090204010010",
    "Bandeng Isi",
    "Bandeng isi adalah produk perikanan dengan bahan baku ikan  bandeng (Chanos chanos) yang diolah dari lumatan daging berbumbu  dan diisikan kembali ke dalam selubung (selongsong) kulit bandeng  dengan atau tanpa pelapisan daging berbumbu. Nama lain: otak-otak  bandeng.",
    "Aktif",
  ],
  [
    "090204010011",
    "Dimsum Ikan",
    "Dimsum ikan adalah produk perikanan dengan menggunakan  lumatan daging ikan dan/atau surimi, cacahan dan/atau potongan  daging ikan, tepung dan bahan pangan lain, dibentuk dan dibungkus  dengan kulit pangsit atau bahan pangan lain yang dapat dimakan  yang mengalami perlakuan pengukusan. Termasuk dalam produk ini  adalah siomay ikan, pangsit ikan, pastel ikan, samosa ikan, gyoza,  dan produk sejenis lainnya.  Karakeristik dasar:  Kandungan lumatan daging ikan dan/atau surimi, cacahan  dan/atau potongan daging ikan tidak kurang dari 30%.",
    "Aktif",
  ],
  [
    "090204010012",
    "Pempek Ikan (Rebus)",
    "Pempek ikan (rebus) adalah produk perikanan dengan bahan baku  lumatan daging ikan segar dan/atau surimi dengan penambahan  tepung, air, garam, dengan atau tanpa bahan pangan lain, yang  mengalami perlakuan perebusan.  Karakeristik dasar:  Kandungan lumatan daging ikan segar dan/atau surimi tidak kurang  dari 30%.",
    "Aktif",
  ],
  [
    "090204010013",
    "Tekwan Ikan",
    "Tekwan ikan adalah produk perikanan dengan bahan baku lumatan  daging ikan segar dan/atau surimi dengan penambahan tepung, air,  garam, dengan atau tanpa bahan pangan lain, yang dicampur dan  dibentuk potongan kecil-kecil dan mengalami perlakuan perebusan.  Karakeristik dasar:  Kandungan lumatan daging ikan segar dan/atau surimi tidak kurang  dari 30%.",
    "Aktif",
  ],
  [
    "090204010014",
    "Pepes Ikan",
    "Pepes ikan adalah produk perikanan dengan bahan baku  ikan/teri/udang segar utuh yang telah mengalami penyiangan dan  pembersihan, pelumuran bumbu-bumbu, dan pengemasan serta  mengalami pengukusan, penirisan, dengan atau tanpa  pemanggangan.",
    "Aktif",
  ],
  [
    "090204010015",
    "Sosis Ikan",
    "Sosis ikan adalah produk perikanan dengan bahan baku lumatan  daging ikan atau surimi, dicampur tepung dan bahan pangan lain,  pengisian ke dalam selongsong sosis dan mengalami perebusan atau  pengukusan.  Karakteristik dasar:  Kandungan lumatan daging ikan atau surimi tidak kurang dari 50%.",
    "Aktif",
  ],
  [
    "090204010016",
    "Sosis Ikan Kombinasi",
    "Sosis ikan kombinasi adalah produk perikanan dengan bahan baku  lumatan daging ikan atau surimi, dicampur tepung dan bahan  pangan lain, pengisian ke dalam selongsong sosis dan mengalami  perebusan atau pengukusan.  Karakeristik dasar:  Kandungan lumatan daging ikan atau surimi tidak kurang dari 20%.",
    "Aktif",
  ],
  [
    "090204010017",
    "Rolade Ikan",
    "Rolade ikan adalah produk perikanan dengan bahan baku lumatan  daging ikan atau surimi dengan penambahan tepung, bumbu,  garam, dengan atau tanpa penambahan bahan pangan lain, dicetak,  ditambahkan pelapis lalu digulung dan dikukus.  Karakeristik dasar:  Kandungan lumatan daging ikan dan/atau surimi tidak kurang dari  30%.",
    "Aktif",
  ],
  [
    "090204010018",
    "Burger Ikan",
    "Burger ikan adalah produk perikanan yang dibuat dari daging ikan  yang telah dilumatkan dan ditambah dengan tepung, bumbu, garam,  dengan atau tanpa penambahan bahan pangan lain.  Karakeristik dasar:  Kandungan lumatan daging ikan tidak kurang dari 30%.",
    "Aktif",
  ],
  [
    "090204010019",
    "Tsukudani",
    "Tsukudani adalah produk perikanan yang diperoleh dengan cara  perebusan dalam kecap atau bahan pangan lain, kemudian  dikeringkan dengan dioven atau cara lain untuk mengurangi kadar  airnya.",
    "Aktif",
  ],
  [
    "090204010020",
    "Telur Ikan Masak",
    "Telur ikan masak adalah produk perikanan dengan bahan baku telur  ikan segar melalui proses perebusan atau pengukusan.",
    "Aktif",
  ],
  [
    "090204010021",
    "Olahan Ikan Berbumbu",
    "Olahan ikan berbumbu adalah berbagai jenis olahan ikan dengan  bahan utama berupa daging ikan berbentuk potongan atau hancuran  dengan bumbu, dengan atau tanpa penambahan bahan pangan lain,  dimasak, dan dikemas.  Karakteristik dasar:  Kandungan daging ikan tidak kurang dari 30%.",
    "Aktif",
  ],
  [
    "090204020001",
    "Kue Cumi/Sotong/Udang Kukus",
    "Kue cumi/sotong/udang kukus adalah produk olahan dari bahan  baku lumatan daging cumi/sotong/udang yang telah mengalami  pengukusan, dapat diberi potongan sayuran atau bahan pangan lain.",
    "Aktif",
  ],
  [
    "090204020002",
    "Dimsum Udang",
    "kupas utuh, lumatan, cacahan dan/atau potongan, tepung dan  bahan pangan lain, dibentuk dan dibungkus dengan kulit pangsit  atau bahan pangan lain yang dapat dimakan yang mengalami  perlakuan pengukusan. Termasuk dalam produk ini adalah siomay  udang, pangsit udang, pastel udang, gyoza, hakau, dan produk  sejenis lainnya.  Karakeristik dasar:  Kandungan udang kupas utuh, lumatan, cacahan dan/atau  potongan tidak kurang dari 30%",
    "Aktif",
  ],
  [
    "090204020003",
    "Bakso Moluska/Krustase/Ekinodermata",
    "Bakso moluska/krustase/ekinodermata adalah produk perikanan  yang menggunakan lumatan daging moluska/krustase/  ekinodermata dicampur tepung dan bahan pangan lain bila  diperlukan, yang mengalami pembentukan dan perebusan.  Contohnya meliputi bakso cumi, bakso udang.  Karakteristik dasar:  Kandungan lumatan daging moluska/krustase/ekinodermata tidak  kurang dari 30%.",
    "Aktif",
  ],
  [
    "090204020004",
    "Sosis Udang",
    "Sosis udang adalah produk perikanan dengan bahan baku lumatan  daging udang, dicampur tepung dan bahan pangan lain, pengisian ke  dalam selongsong sosis dan mengalami perebusan atau pengukusan.  Bahan baku yang digunakan adalah udang segar; udang beku; dan  lumatan daging udang sesuai dengan spesifikasi.  Karakeristik dasar:  Kandungan lumatan daging udang tidak kurang dari 50%.",
    "Aktif",
  ],
  [
    "090204020005",
    "Daging Rajungan Rebus Dingin",
    "Daging rajungan rebus dingin adalah produk perikanan dari  rajungan segar yang mengalami perlakuan pencucian, pengukusan,  pengupasan dan pendinginan. Bentuk produk akhir meliputi:  \x{2022} Jumbo (daging rajungan yang masih utuh dan merupakan  jaringan terbesar yang berhubungan dengan kaki renang).  \x{2022} Flower (daging rajungan yang terdiri dari 3 ruas dari 4 ruas dada  bagian depan).  \x{2022} Backfin (daging jumbo yang pecah atau rusak/broken jumbo).  \x{2022} Spesial (serpihan daging flower dan jumbo).  \x{2022} Clawmeat (daging rajungan yang berasal dari kaki-kaki rajungan).",
    "Aktif",
  ],
  [
    "090204030001",
    "Udang Popcorn",
    "Udang popcorn adalah makanan terbuat dari udang yang dikupas  kulitnya dalam bentuk potongan kecil, yang direndam atau dibalur  dengan bumbu halus kemudian dilapisi tepung dan digoreng.",
    "Aktif",
  ],
  [
    "090204030002",
    "Bakso Ikan/Moluska/Krustase/Ekinodermata (Kering)",
    "Bakso ikan/ moluska/ krustase/ ekinodermata (kering) adalah  produk perikanan yang menggunakan lumatan daging ikan/  moluska/ krustase/ ekinodermata atau surimi, dicampur tepung,  dan bahan pangan lainnya bila diperlukan, yang mengalami  pembentukan, perebusan, dan penggorengan atau proses  pengeringan lainnya. Bahan baku ikan yang digunakan adalah  semua jenis ikan dari kelas Pisces hasil penangkapan atau budidaya.  Contohnya meliputi bakso ikan kering, bakso cumi kering, bakso  udang kering.  Karakteristik dasar:  \x{2022} Kandungan lumatan daging ikan atau surimi tidak kurang dari  40% (untuk bakso ikan kering);  \x{2022} Kandungan lumatan daging moluska/ krustase/ ekinodermata  tidak kurang dari 30% (untuk bakso moluska/ krustase/  ekinodermata kering).",
    "Aktif",
  ],
  [
    "090204030003",
    "Kue Ikan/Kamaboko/Fish Cake (goreng atau panggang)",
    "Kue ikan/kamaboko/fish cake (goreng atau panggang) adalah produk  perikanan yang menggunakan daging ikan atau surimi yang  mengalami proses pencucian; pengadonan dengan garam, tepung,  dan bumbu; pencetakan (forming); dengan atau tanpa pengukusan,  kemudian digoreng atau dipanggang sehingga membentuk tekstur  yang kenyal (gel). Jenis kamaboko: kamaboko goreng, chikuwa  panggang.  Karakteristik dasar:  Kandungan surimi tidak kurang dari 30%.",
    "Aktif",
  ],
  [
    "090204030004",
    "Sambal Goreng Udang",
    "Sambal goreng udang adalah makanan yang dibuat dengan  mengolah udang, cabai, dengan atau tanpa penambahan bahan  pangan lain. Bau, rasa dan warna normal khas udang.  Karakteristik dasar:  Kandungan udang tidak kurang dari 50%.",
    "Aktif",
  ],
  [
    "090204030005",
    "Sambal Goreng Ikan",
    "Sambal goreng ikan adalah produk perikanan berupa makanan  kering yang dibuat dengan mengolah ikan yang dihaluskan dengan  cabai dan atau bumbu-bumbu dan digoreng. Contoh produk  diantaranya sambal goreng ikan roa.  Karakteristik dasar:  Kandungan ikan tidak kurang dari 30%.",
    "Aktif",
  ],
  [
    "090204030006",
    "Keripik3 Kulit Ikan Goreng",
    "Keripik3 kulit ikan goreng adalah produk perikanan yang dibuat dari  kulit ikan segar yang mengalami proses pencucian, blansir,  perendaman dalam larutan garam, penjemuran, dan penggorengan.",
    "Aktif",
  ],
  [
    "090204030007",
    "Abon Ikan",
    "Abon ikan adalah produk perikanan dengan bahan baku ikan segar  yang mengalami perlakuan perebusan atau pengukusan,  pencabikan, penambahan bumbu, dan pemasakan/penggorengan.  Karakeristik dasar:  Kandungan daging ikan tidak kurang dari 40%.",
    "Aktif",
  ],
  [
    "090204030008",
    "Pempek Ikan (Goreng atau Panggang)",
    "Pempek ikan (goreng atau panggang) adalah produk perikanan  dengan bahan baku lumatan daging ikan segar dan/atau surimi  dengan penambahan tepung, air, garam, dengan atau tanpa bahan  pangan lain, yang mengalami perlakuan perebusan dan  penggorengan atau pemanggangan.  Karakeristik dasar:  Kandungan lumatan daging ikan segar dan/atau surimi tidak kurang  dari 30%.",
    "Aktif",
  ],
  [
    "090204030009",
    "Ikan Renyah",
    "Ikan renyah adalah produk perikanan dengan bahan baku ikan yang  mengalami penambahan bumbu dengan dan atau tanpa tepung dan  digoreng hingga renyah. Bahan baku adalah semua jenis ikan utuh  segar. Contoh produk adalah ikan wader goreng, ikan bilis goreng.",
    "Aktif",
  ],
  [
    "090204030010",
    "Keripik3 Ikan",
    "Keripik3 ikan adalah produk perikanan dengan bahan baku ikan  hidup atau bagian ikan yang mengalami perlakuan penambahan  bumbu, dengan atau tanpa penambahan tepung dan digoreng.  Produk sejenis lainnya antara lain keripik3 ikan teri, keripik3 kulit  ikan, keripik3 lele, keripik3 patin, dan produk sejenis lainnya.",
    "Aktif",
  ],
  [
    "090204030011",
    "Keripik3 Belut",
    "Keripik3 belut adalah produk perikanan dengan bahan baku belut  (Monopterus albus) hidup yang mengalami perlakuan penambahan  bumbu, dengan atau tanpa penambahan tepung dan digoreng.",
    "Aktif",
  ],
  [
    "090204030012",
    "Tortila Ikan",
    "Tortila ikan adalah produk perikanan dengan bahan baku ikan,  dengan penambahan tepung, bumbu, pencetakan, dan digoreng.",
    "Aktif",
  ],
  [
    "090204030013",
    "Rendang Ikan Tuna",
    "Rendang ikan tuna adalah produk perikanan dengan bahan baku  ikan tuna yang dimasak dalam santan dan bumbu rendang dengan  atau tanpa penambahan bahan pangan lain. Bumbu rendang terdiri  dari campuran cabe merah, bawang merah, bawang putih, jahe,  lengkuas, ketumbar, kunyit, dan sereh yang dihaluskan. Daun jeruk,  daun kunyit dan asam kandis ditambahkan dalam bentuk utuh atau  dihaluskan.",
    "Aktif",
  ],
  [
    "090204030014",
    "Rendang Kerang",
    "Rendang kerang adalah produk perikanan dengan bahan baku  kerang lokan (Polymesoda expansa) yang dimasak dalam santan dan  bumbu rendang dengan atau tanpa penambahan bahan pangan lain.  Bumbu rendang terdiri dari campuran cabe merah, bawang merah,  bawang putih, jahe, lengkuas, ketumbar, kunyit, dan sereh yang dihaluskan. Daun jeruk, daun kunyit dan asam kandis ditambahkan  dalam bentuk utuh atau dihaluskan.",
    "Aktif",
  ],
  [
    "090205000001",
    "Ikan Asap",
    "Ikan asap adalah ikan segar yang mengalami perlakuan penyiangan,  pencucian dengan atau tanpa perendaman dalam larutan garam,  penirisan, dengan atau tanpa pemberian rempah dan pengasapan  panas yang dilakukan dalam ruang pengasapan dengan  menggunakan kayu, sabut, atau tempurung kelapa.",
    "Aktif",
  ],
  [
    "090205000002",
    "Ikan Kayu",
    "Ikan kayu adalah ikan yang mengalami kombinasi proses perebusan,  pengeringan dan pengasapan sehingga memiliki tekstur yang keras  dengan karakteristik sensori ikan asap. Bahan baku berupa ikan  segar dan ikan beku yang terdiri dari ikan cakalang (Katsuwonus  pelamis), ikan tongkol (Auxis sp), ikan tuna (Thunus sp.), ikan layang  (Decapterus sp.), ikan lemuru (Sardinella sp.) dan ikan lainnya yang  aman untuk dikonsumsi manusia.  Kriteria bentuk produk akhir:  \x{2022} Ikan cakalang dibelah 4 (empat)  \x{2022} Ikan tuna dibelah 4 (empat)  \x{2022} Ikan cakalang dibelah 2 (dua)  \x{2022} Ikan tuna dibelah 2 (dua)  \x{2022} Ikan tongkol dibelah 2 (dua)  \x{2022} Ikan tongkol utuh  \x{2022} Ikan lemuru utuh  \x{2022} Ikan layang utuh",
    "Aktif",
  ],
  [
    "090205000003",
    "Ikan Kering",
    "Ikan kering adalah produk perikanan dengan bahan baku ikan yang  telah mengalami perlakuan dengan atau tanpa perebusan, dan  pengeringan.",
    "Nonaktif",
  ],
  [
    "090205000004",
    "Ikan Asin Kering",
    "Ikan asin kering adalah produk perikanan dengan bahan baku ikan  yang telah mengalami perlakuan penggaraman dengan atau tanpa  perebusan, dan pengeringan. Bentuk produk akhir mencakup: utuh  (ikan asin kering utuh), belah dengan atau tanpa kepala, tanpa  tulang belakang (ikan asin kering bentuk belah), daging (potongan  daging ikan asin kering), dan bentuk lain selain bentuk di atas.  Karakteristik dasar:  Kadar garam minimum 12% dari berat ikan pada produk akhir.",
    "Nonaktif",
  ],
  [
    "090205000005",
    "Teri Asin Kering",
    "Teri asin kering adalah produk perikanan dengan bahan baku ikan  teri utuh segar yang mengalami perlakuan pencucian, penggaraman,  pencucian, pengeringan.  Karakteristik dasar:  Kadar air tidak lebih dari 20%.",
    "Nonaktif",
  ],
  [
    "090205000006",
    "Teri Nasi Setengah Kering",
    "Teri nasi setengah kering adalah produk olahan hasil perikanan  dengan bahan baku teri nasi (Stolephorus spp.) utuh segar yang  mengalami perlakuan perebusan dalam air garam dan pengeringan  setengah kering.  Karakteristik dasar:  Kadar air tidak kurang dari 20% dan tidak lebih dari 60%.",
    "Nonaktif",
  ],
  [
    "090205000007",
    "Kerupuk4 Ikan, Udang, Moluska (Mentah)",
    "Kerupuk4 ikan, udang dan moluska (mentah) adalah produk  tradisional berbahan baku ikan atau daging lumat (minced fish),  udang dan moluska (cumi-cumi, sotong dan kekerangan) segar dan  atau beku yang diolah dari campuran semua bahan melalui proses  pengadukan, pencetakan, pengukusan atau perebusan, pendinginan,  pengirisan, dan pengeringan.  Karakteristik dasar:  Kandungan ikan atau daging lumat (minced fish), udang dan  moluska tidak kurang dari 15%.",
    "Aktif",
  ],
  [
    "090205000008",
    "Kerupuk4 Kulit Ikan Mentah",
    "Kerupuk4 kulit ikan mentah adalah produk perikanan yang dibuat  dari kulit ikan segar yang mengalami proses pencucian, blansir,  perendaman dalam larutan garam, dan pengeringan.",
    "Aktif",
  ],
  [
    "090205000009",
    "Dendeng Ikan",
    "Dendeng ikan adalah produk perikanan dengan bahan baku ikan  segar yang mengalami perlakukan penambahan bumbu-bumbu  dengan rasa yang khas dan pengeringan.",
    "Aktif",
  ],
  [
    "090205000010",
    "Belut Kering",
    "Belut kering adalah produk olahan belut dengan perlakuan  penyiangan, pencucian, pengeringan dengan cara pengasapan dan  atau penjemuran.",
    "Nonaktif",
  ],
  [
    "090205000011",
    "Udang Kering Tanpa Kulit (Ebi)",
    "Udang kering tanpa kulit (ebi) adalah produk perikanan dengan bahan baku udang segar melalui proses penanganan, dengan pengupasan kulit dan pengolahan dengan pengeringan.",
    "Nonaktif",
  ],
  [
    "090205000012",
    "Ebi Bubuk",
    "Ebi bubuk adalah produk perikanan dengan bahan baku udang kering tanpa kulit yang digiling menjadi bentuk bubuk.",
    "Aktif",
  ],
  [
    "090205000013",
    "Cumi dan Sotong Kering",
    "Cumi dan sotong kering adalah produk perikanan dari bahan baku cumi-cumi (Loligo spp) dan sotong (Sephia spp) dengan karakteristik produk akhir yang kering, rasa asin atau tawar, dan aroma spesifik.",
    "Aktif",
  ],
  [
    "090205000014",
    "Ubur-Ubur Asin",
    "Ubur-ubur asin adalah produk perikanan dengan bahan baku ubur ubur segar dari jenis Aurelia sp dan Rhopilema sp. yang melalui proses penggaraman dan pengeringan.",
    "Nonaktif",
  ],
  [
    "090205000015",
    "Teripang Kering",
    "Teripang kering adalah produk perikanan dengan bahan baku teripang segar yang mengalami perlakuan penanganan dan pengeringan.",
    "Nonaktif",
  ],
  [
    "090205000016",
    "Daging Kerang Abalon Kering",
    "Daging kerang abalon kering adalah produk perikanan dengan bahan baku daging abalon (Haliotis spp) segar yang mengalami perlakuan penanganan dan pengeringan.",
    "Nonaktif",
  ],
  [
    "090205000017",
    "Sirip Hiu Kering",
    "Sirip hiu kering adalah produk perikanan yang diolah dari bahan baku sirip ikan hiu segar atau kering melalui proses perebusan, dengan atau tanpa penghilangan kulit dan daging, perapihan dan pengeringan. Bahan baku yang digunakan adalah sirip ikan hiu dari jenis hiu yang tidak dilarang untuk ditangkap dan diolah sesuai dengan peraturan perundangan yang berlaku. Bentuk produk akhir meliputi utuh dengan kulit dan daging serta tanpa kulit dan daging.",
    "Nonaktif",
  ],
  [
    "090205000018",
    "Telur Ikan Terbang Kering",
    "Telur ikan terbang kering adalah produk perikanan dengan bahan baku semua jenis telur ikan terbang segar melalui proses penanganan dan pengeringan.",
    "Nonaktif",
  ],
  [
    "090205000019",
    "Terasi Udang",
    "Terasi udang adalah produk perikanan dengan bahan baku rebon atau udang segar, atau kering atau campurannya yang difermentasi.  Bentuk produk akhir: terasi pasta (terasi yang berkarakteristik semi padat), terasi kering padat blok (terasi yang berkarakteristik kering berbentuk blok padat), terasi kering serbuk dan granula (terasi yang berkarakteristik kering berbentuk serbuk dan butiran/granula.",
    "Aktif",
  ],
  [
    "090205000020",
    "Pasta Ikan",
    "Pasta ikan adalah produk bentuk pasta yang diperoleh dari fermentasi ikan.",
    "Aktif",
  ],
  [
    "090205000021",
    "Ikan Asin Jambal Roti",
    "Ikan asin jambal roti adalah produk perikanan hasil fermentasi dari bahan baku ikan manyung (genus Arius sp., Perciformes sp.) sehingga produk akhir mempunyai tekstur masir (berlapis berbutirbutir) dan aroma yang spesifik. Bentuk produk akhir: belah dengan atau tanpa kepala, dengan atau tanpa tulang belakang potongan daging, serta bentuk lain selain bentuk di atas.",
    "Nonaktif",
  ],
  [
    "090205000022",
    "Ikan Peda",
    "Ikan peda adalah produk perikanan dari bahan baku ikan kembung (genus Rastrelliger) yang mengalami penggaraman dan fermentasi.",
    "Nonaktif",
  ],
  [
    "090205000023",
    "Bekasam/Bekasang",
    "Bekasam/bekasang adalah produk perikanan yang dibuat dari ikan atau jeroan ikan melalui proses fermentasi dengan penambahan karbohidrat. Dapat mengandung bumbu dan bahan lain untuk mendapatkan flavor yang diinginkan.",
    "Aktif",
  ],
  [
    "090205000024",
    "Rusip",
    "Rusip adalah produk perikanan yang dibuat dari ikan teri melalui proses fermentasi dengan atau tanpa penambahan karbohidrat. Dapat mengandung bumbu dan bahan pangan lain untuk mendapatkan flavor yang diinginkan. Rusip berfungsi sebagai kondimen ",
    "Aktif",
  ],
  [
    "090205000025",
    "Masin",
    "Masin adalah produk perikanan yang diperoleh dari hasil fermentasi udang kecil segar atau rebon dari spesies Acetes dengan atau penambahan nasi atau karbohidrat lain (gula) serta bumbu.",
    "Aktif",
  ],
  [
    "090205000026",
    "Tepung Ikan",
    "Tepung ikan adalah produk perikanan dengan bahan baku ikan utuh dan atau bagian-bagian ikan segar, yang dijadikan tepung melalui proses perebusan atau pengukusan, pengepresan, pengeringan dan penggilingan. Karakteristik dasar: Kadar air tidak lebih dari 4%.",
    "Aktif",
  ],
  [
    "090205000027",
    "Pasta Gonad Bulu Babi",
    "Pasta gonad bulu babi adalah produk perikanan berupa pasta yang diperoleh dari hasil fermentasi gonad atau telur bulu babi (baik jantan maupun betina) dengan penambahan garam 30% hingga 34%.",
    "Aktif",
  ],
  [
    "090205000028",
    "Rebon",
    "Rebon adalah produk perikanan dengan bahan baku udang (Acetes sp.) yang telah mengalami perlakuan dengan atau tanpa perebusan atau pengukusan, dan pengeringan.",
    "Nonaktif",
  ],
  [
    "090301000001",
    "Rollmops",
    "Rollmops adalah suatu jenis ikan herring atau ikan tembang (Clupea harengus) yang direndam dalam bumbu.",
    "Aktif",
  ],
  [
    "090301000002",
    "Gel Ikan (Sea Gel)",
    "Sea gel adalah dogfish (Squalideae) dalam jeli.",
    "Aktif",
  ],
  [
    "090301000003",
    "Aspic Ikan",
    "Aspic ikan adalah ikan dalam kaldu dan jeli.",
    "Aktif",
  ],
  [
    "090303000001",
    "Caviar",
    "Caviar adalah telur ikan sturgeon dari Famili Acipenseridae (4 genus Acipenser, Huso, Pseudoscaphirhynchus dan Scaphirhynchus serta hibrid dari jenis yang sama). Ukuran telur sama dan warna telur sesuai dengan jenis ikan yang digunakan. Warna beragam dari abu-abu terang sampai hitam atau dari kuning terang sampai kuning keabu-abuan. Produk dibuat dengan penambahan garam",
    "Nonaktif",
  ],
  [
    "090303000002",
    "Red Caviar",
    "Red caviar adalah telur ikan salmon yang diawetkan dengan penggaraman. Telur ikan ini berwarna oranye-pucat sampai dengan merah-gelap. Ukurannya lebih besar dari pada golden caviar.",
    "Nonaktif",
  ],
  [
    "090303000003",
    "Golden Caviar",
    "Golden caviar adalah telur dari \x{201C}whitefish\x{201D}. Telur ikan ini lembut, berwarna kuning-pucat sampai dengan keemasan.",
    "Nonaktif",
  ],
  [
    "090303000004",
    "Pengganti Kaviar (Caviar Substitute)",
    "Pengganti kaviar (caviar substitute) adalah telur ikan selain Sturgeon (misalnya cod, herring, salmon, lumpfish) yang diberi garam, rempahrempah, dan memiliki karakteristik serupa kaviar.",
    "Nonaktif",
  ],
  [
    "090303000005",
    "Telur Ikan Dengan Penambahan Bahan Pangan Lain",
    "Telur ikan dihasilkan dari pencucian, penggaraman atau penambahan bumbu, dan pemeraman. Nama jenis untuk produk ini antara lain telur ikan terbang.",
    "Aktif",
  ],
  [
    "090304000001",
    "Petis Udang",
    "Petis udang adalah produk perikanan dengan bahan baku air rebusan (ekstraksi) yang berasal dari udang, kepala udang dan atau kulit udang yang ditambahkan gula, garam dan mengalami pemekatan.",
    "Aktif",
  ],
  [
    "090400000001",
    "Sosis Ikan/Moluska/Krustase/Ekinodermata Siap Santap",
    "Sosis ikan/moluska/krustase/ekinodermata siap santap adalah produk dari lumatan daging ikan/moluska/krustase/ ekinodermataatau surimi, dengan tambahan tepung atau pati, dengan atau tanpa penambahan bumbu dan bahan pangan lain dan dimasukkan ke dalam selongsong sosis yang kedap udara dan dilakukan sterilisasi, dapat dimakan langsung tanpa dimasak. Karakteristik dasar: Kandungan lumatan daging ikan/moluska/krustase/ekinodermata atau surimi tidak kurang dari 30%.",
    "Aktif",
  ],
  [
    "090400000002",
    "Otak-Otak Ikan/Moluska/Krustase/Ekinodermata Siap Santap",
    "Otak-otak ikan/moluska/krustase/ekinodermata siap santap adalah produk perikanan yang menggunakan lumatan daging ikan/moluska/krustase/ekinodermata dicampur tepung/pati dengan atau tanpa bahan pangan lain, dikemas dengan bahan yang sesuai, dan dilakukan sterilisasi, dapat dimakan langsung tanpa dimasak. Karakteristik dasar: Kandungan daging ikan/moluska/krustase/ekinodermata tidak kurang dari 30%.",
    "Aktif",
  ],
  [
    "090400000003",
    "Tuna dalam Kemasan",
    "Tuna dalam kemasan adalah produk yang terdiri dari daging yang diolah dari jenis tuna (Thunnus spp.), tongkol (Euthynnus spp., Auxis spp.), cakalang (Katsuwonnus spp.), dan bonito (Sarda spp.) yang dikemas secara hermetis dan menerima perlakuan proses yang cukup untuk menjamin sterilitas komersial. Wujud produk akhir: \x{2022} Solid \x{2013} potongan daging tuna yang utuh dan memenuhi seluruh penampang kemasan. Proporsi lempengan (flake) atau chunk tidak lebih dari 18% dari bobot tuntas. \x{2022} Chunk \x{2013} potongan daging tuna dengan dimensi minimum 1,2 cm. Proporsi serpihan daging tuna dengan diameter kurang dari 1,2 cm tidak melebihi 30% dari bobot tuntas. \x{2022} Flake atau flakes \x{2013} serpihan daging tuna dengan dimensi kurang dari 1,2 cm. \x{2022} Grated atau shredded \x{2013} daging tuna yang lebih kecil dariserpihan. Karakteristik dasar: Bobot tuntas tidak kurang dari 60%.",
    "Aktif",
  ],
  [
    "090400000004",
    "Udang Dalam Kemasan",
    "Udang dalam kemasan adalah produk perikanan dengan bahan baku udang segar yang mengalami perlakuan, pemotongan kepala, pengupasan, pembuangan usus, perebusan, pengisian udang ke dalam kaleng, pengisian media, penutupan kaleng secara hermetis, dan sterilisasi. Jenis bahan baku: \x{2022} Udang Krosok (Metapenaeus lysianasa) \x{2022} Udang Putih/Jerbung (Penaeus marguiensis) \x{2022} Udang Api-api (Metapenaeus monocerus) \x{2022} Udang Belang (Penaeus indicus) \x{2022} Udang Kembung (Penaeus latisulcatus) \x{2022} Udang Bago (Penaeus semisulcatus) \x{2022} Udang Windu (Penaeus monodon) \x{2022} Udang Harimau (Parapennaeopsis sculptilis) \x{2022} Udang Cendana/Bacang (Metapenaeus brevecornis) \x{2022} Udang Vaname (Litopenaeus vanamea) Karakteristik dasar: Bobot tuntas tidak kurang dari 50%.",
    "Aktif",
  ],
  [
    "090400000005",
    "Kerang Dalam Kemasan",
    "Kerang dalam kemasan adalah produk perikanan dengan bahan baku kerang segar yang mengalami perlakuan perebusan, pemisahan daging, perendaman dalam larutan garam, memasukkan dalam kemasan, pengisian media, penutupan kemasan secara hermetis, sterilisasi. Bahan baku yang digunakan: kerang bulu (Anadara antiquata); kerang darah (Anadara granosa); simping (Placuna placenta); tapis-tapis (Pinctada margaritifera); tiram nakan (Plicatula plicata). Karakteristik dasar: Bobot tuntas tidak kurang dari 50%.",
    "Aktif",
  ],
  [
    "090400000006",
    "Daging Rajungan Sterilisasi dalam Kemasan",
    "Daging rajungan sterilisasi dalam kemasan adalah produk perikanan dengan bahan baku rajungan (Portunus pelagicus) yang dikemas dalam suatu wadah hermetis yang mengalami perlakuan pengolahan untuk menjamin sterilitas komersial. Karakteristik dasar: Bobot tuntas tidak kurang dari 90%.",
    "Aktif",
  ],
  [
    "090400000007",
    "Daging Rajungan Pasteurisasi Dalam Kemasan",
    "Daging rajungan pasteurisasi dalam kemasan adalah produk perikanan dengan bahan baku rajungan (Portunus pelagicus) yang terdiri dari satu bagian atau kombinasi dari bagian daging: badan, bahu, lengan dan capit yang telah dikupas kulitnya dari jenis rajungan Portunus pelagicus dan dikemas dalam suatu wadah hermetis yang mengalami perlakuan pasteurisasi. Wujud produk akhir: \x{2022} Jumbo: daging putih yang merupakan jaringan terbesar yang berhubungan dengan kaki renang, terdiri atas jumbo colosal (berat > 9 g) dan jumbo biasa (berat 5 - 9 g); \x{2022} Clawmeat: daging merah yang merupakan daging dari bagian kaki sampai capit rajungan; \x{2022} Backfin: daging putih yang merupakan jumbo kecil dan pecahan dari daging jumbo; \x{2022} Lump/flower: daging putih terdiri dari tiga ruas yang menyatu berbentuk seperti bunga yang berada di bagian dada; \x{2022} Spesial: daging putih yang berupa serpihan-serpihan yang berada disekitar badan; \x{2022} Cocktail: clawmeat yang masih ada kulit dan capitnya. Karakteristik dasar: Bobot tuntas tidak kurang dari 90%. -",
    "Aktif",
  ],
  [
    "090400000008",
    "Tiram Dalam Kemasan",
    "Tiram dalam kemasan adalah produk yang diperoleh dari satu atau campuran dari dua atau lebih bentuk tiram (utuh, potongan dan irisan) yang diberi medium air, cairan sari tiram yang diperoleh sebelum atau selama pengolahan, atau campuran keduanya dan ditambah garam, kemudian dikemas secara kedap (hermetis) dan disterilisasi dengan pemanasan. Karakteristik dasar: Bobot tuntas tidak kurang dari 50%.",
    "Aktif",
  ],
  [
    "090400000009",
    "Salmon Dalam Kemasan",
    "Salmon dalam kemasan adalah produk yang dihasilkan dari ikan Salmo salar, Oncorhynchus nerka, Oncorhynchus kisutch, Oncorhynchus tshawytscha, Oncorhynchus gorbuscha, Oncorhynchus keta, dan Oncorhynchus masou tanpa kepala, sirip dan ekor yang ditambah dengan media, dikemas secara kedap (hermetis) dan disterilisasi dengan pemanasan. Bentuk yang dikalengkan bisa reguler (stik irisan transversal dan diisikan secara vertikal); tanpa kulit dan tulang belakang dipisahkan; irisan kecil atau hancuran salmon (minced salmon). Karakteristik dasar: Bobot tuntas tidak kurang dari 50%.",
    "Aktif",
  ],
  [
    "090400000010",
    "Sarden Dan Makerel Dalam Kemasan Kaleng",
    "Sarden dan makerel dalam kemasan kaleng adalah sarden dan makerel dalam kemasan kaleng diolah dari ikan segar atau beku dari genus Sardinella spp., Clupea spp., Scomber spp., dan Decapterus spp. Produk dikemas dalam kaleng yang ditutup secara hermetis dan menerima perlakuan proses yang cukup untuk menjamin sterilitas komersial. Produk ini berlaku untuk jenis ikan sarden dan makerel dalam medium air atau minyak atau medium lain yang sesuai yang dikemas dalam kaleng.  Karakteristik dasar: Bobot tuntas tidak kurang dari 50%.",
    "Aktif",
  ],
  [
    "090400000011",
    "Bekicot Dalam Kemasan",
    "Bekicot dalam kemasan adalah produk dengan bahan baku bekicot (Achatina fulica) hidup yang mengalami perlakuan perendaman dalam garam, pencongkelan, perebusan daging, pengisian dan penimbangan, pengisian media, penutupan kemasan secara hermetis, dan sterilisasi. Karakteristik dasar: Bobot tuntas tidak kurang dari 50%.",
    "Aktif",
  ],
  [
    "090400000012",
    "Cumi-cumi Dalam Kemasan",
    "Cumi-cumi dalam kemasan adalah produk perikanan dengan bahan baku cumi (Loligo spp.) yang dikemas dalam suatu wadah hermetis yang mengalami perlakuan pengolahan untuk menjamin sterilitas komersial. Karakteristik dasar: Bobot tuntas tidak kurang dari 50%.",
    "Aktif",
  ],
  [
    "090400000013",
    "Sotong Dalam Kemasan",
    "Sotong dalam kemasan adalah produk perikanan dengan bahan baku sotong segar yang mengalami perlakuan perebusan, perendaman dalam air dingin, pengisian dan penimbangan, pengisian media, penutupan kaleng secara hermetis, dan sterilisasi. Karakteristik dasar: Bobot tuntas tidak kurang dari 50%.",
    "Aktif",
  ],
  [
    "090400000014",
    "Ikan Dalam Kemasan",
    "Ikan dalam kemasan adalah produk perikanan yang dikemas secara hermetis (misalnya plastik/laminat autoclavable/retortable) dalammedia air garam, minyak, atau media lain yang sesuai, dan menerima perlakuan proses yang cukup untuk menjamin sterilitas komersial. Kategori ini mencakup semua produk ikan dalam kemasan yang tidak termasuk kategori di atas. Karakteristik dasar: Bobot tuntas tidak kurang dari 50%.",
    "Aktif",
  ],
  [
    "090400000015",
    "Olahan Ikan Dalam Kemasan",
    "Olahan ikan dalam kemasan adalah berbagai jenis olahan ikan dengan bahan utama berupa daging ikan/ moluska/ krustase/ekinodermata yang berbentuk potongan atau hancuran, dengan atau tanpa penambahan bahan pangan lain, dikemas dalam kaleng atau kemasan lain secara hermetis (misalnya plastik/laminat autoclavable/retortable) dan diproses dengan perlakuan panas yang cukup untuk menjamin stabilitas dan keamanan produk, dengan bentuk akhir padat atau semi-padat. Jenis produk untuk kategori ini antara lain tuna dalam mayonais, tuna berbumbu, kornet tuna. Karakteristik dasar: Kandungan daging ikan tidak kurang dari 30%.",
    "Aktif",
  ],
  [
    100100000001,
    "Telur Segar",
    "Telur segar adalah telur dalam kerabang/cangkang yang berasal dari kelompok unggas, yang tidak mengalami pengolahan dan tidak busuk. Pada telur tersebut belum terjadi pertumbuhan embrio, belum dierami, kerabangnya bebas dari benda asing (kotoran, hewan, tanah) dan tidak retak atau pecah, kuning telur belum tercampur dengan putih telur.",
    "Nonaktif",
  ],
  [
    100201000001,
    "Telur Cair Utuh",
    "Telur cair utuh adalah telur utuh yang diperoleh dari telur segar yang dipisahkan dari kerabang/cangkangnya. Telur cair utuh dapat dikocok dan disaring serta dipasteurisasi atau diberi perlakuan lain untuk membunuh seluruh bakteri patogen. Karakteristik dasar: \x{2022} Total padatan tidak kurang dari 22% \x{2022} Kadar protein tidak kurang dari 10,5% \x{2022} Kadar lemak tidak kurang dari 9,8%",
    "Aktif",
  ],
  [
    100201000002,
    "Putih Telur Cair",
    "Putih telur cair adalah produk telur yang diperoleh dari bagian putih telur dan dipisahkan dari bagian kuning telurnya. Putih telur cair dapat dikocok dan disaring serta dipasteurisasi atau diberi perlakuan lain untuk membunuh bakteri patogen.  Karakteristik dasar: \x{2022} Total padatan tidak kurang dari 10.5% \x{2022} Kadar protein tidak kurang dari 10,0%",
    "Aktif",
  ],
  [
    100201000003,
    "Kuning Telur Cair",
    "Kuning telur cair adalah produk telur yang diperoleh dari bagian kuning telur dan dipisahkan dari bagian putih telurnya. Kuning telur cair dapat dikocok dan disaring serta dipasteurisasi atau diberi perlakuan lain untuk membunuh bakteri patogen. Karakteristik dasar: \x{2022} Total padatan tidak kurang dari 40% \x{2022} Kadar protein tidak kurang dari 15,0% \x{2022} Kadar lemak tidak kurang dari 25,0%",
    "Aktif",
  ],
  [
    100201000004,
    "Telur Cair Campuran /Premiks Telur Cair",
    "Telur cair campuran /premiks telur cair adalah produk dengan bahan utama telur cair (telur utuh, putih telur, kuning telur, atau campurannya) atau tepung telur (utuh, putih telur, atau kuningtelur) dan ditambah bahan pangan lain. Nama jenis produk antara lain telur cair utuh campuran, putih telur cair campuran, kuning telur cair campuran. Karakteristik dasar: Kandungan telur tidak kurang dari 50% dihitung sebagai telur",
    "Aktif",
  ],
  [
    100202000001,
    "Telur Beku Utuh",
    "Telur beku utuh adalah produk telur yang diperoleh dari proses pembekuan telur cair utuh. Karakteristik dasar: \x{2022} Total padatan tidak kurang dari 22% \x{2022} Kadar protein tidak kurang dari 10,5% \x{2022} Kadar lemak tidak kurang dari 9,8%",
    "Aktif",
  ],
  [
    100202000002,
    "Putih Telur Beku",
    "Putih telur beku adalah produk telur yang diperoleh dari proses pembekuan putih telur cair. Karakteristik dasar: \x{2022} Total padatan tidak kurang dari 10.5% \x{2022} Kadar protein tidak kurang dari 10,0%",
    "Aktif",
  ],
  [
    100202000003,
    "Kuning Telur Beku",
    "Kuning telur beku adalah produk telur yang diperoleh dari proses pembekuan kuning telur cair. Karakteristik dasar: \x{2022} Total padatan tidak kurang dari 40% \x{2022} Kadar protein tidak kurang dari 15,0% \x{2022} Kadar lemak tidak kurang dari 25,0%",
    "Aktif",
  ],
  [
    100202000004,
    "Telur Campuran Beku/Premiks Telur Beku",
    "Telur campuran beku/premiks telur beku adalah produk dengan bahan utama telur cair (telur utuh, putih telur, kuning telur, atau campurannya) atau tepung telur (utuh, putih telur, atau kuning telur) ditambah bahan pangan lain, kemudian dibekukan. Nama jenis produk antara lain telur utuh campuran beku, putih telur campuran beku, kuning telur campuran beku. Karakteristik dasar: Kandungan telur tidak kurang dari 50% dihitung sebagai telur cair atau tidak kurang dari 11,5% dihitung sebagai tepung telur.",
    "Aktif",
  ],
  [
    100203000001,
    "Tepung Telur Utuh",
    "Tepung telur utuh adalah produk telur yang diperoleh dari proses pengeringan telur utuh cair menjadi bentuk tepung atau granula. Karakteristik dasar: \x{2022} Total padatan tidak kurang dari 95,0% \x{2022} Kadar protein tidak kurang dari 45,0% \x{2022} Kadar lemak tidak kurang dari 39,0%",
    "Aktif",
  ],
  [
    100203000002,
    "Tepung Putih Telur",
    "Tepung putih telur adalah produk telur yang diperoleh dari proses pengeringan putih telur cair menjadi bentuk tepung atau granula. Karakteristik dasar: \x{2022} Total padatan tidak kurang dari 92% \x{2022} Kadar protein tidak kurang dari 75,0%",
    "Aktif",
  ],
  [
    100203000003,
    "Tepung Kuning Telur",
    "Tepung kuning telur adalah produk telur yang diperoleh dari proses pengeringan kuning telur cair menjadi bentuk tepung atau granula. Karakteristik dasar: \x{2022} Total padatan tidak kurang dari 95% \x{2022} Kadar protein tidak kurang dari 33,0% \x{2022} Kadar lemak tidak kurang dari 55,0%",
    "Aktif",
  ],
  [
    100203000004,
    "Telur Matang/Setengah Matang",
    "Telur matang/setengah matang adalah telur utuh dalam kerabang yang dipanaskan sampai terkoagulasi sebagian (setengah matang) atau terkoagulasi seluruhnya (matang).",
    "Aktif",
  ],
  [
    100203000005,
    "Telur Pindang",
    "Telur pindang adalah produk telur yang diperoleh dari pengolahan telur secara tradisional dengan cara perebusan dalam air yang ditambahkan daun jambu biji/daun jati/daun teh, kulit bawang merah dan daun salam. Telur direbus dalam larutan yang ditambahkan garam untuk rasa gurih. Telur pindang dengan/atau tanpa kerabang berwarna coklat kehitaman/kemerahan.",
    "Aktif",
  ],
  [
    100203000006,
    "Tepung Telur Campuran/Premiks Tepung Telur",
    "Tepung telur campuran/premiks tepung telur adalah produk dengan bahan utama tepung telur (utuh, putih telur, atau kuning telur) dan bahan pangan lain. Nama jenis produk antara lain tepung telur utuh campuran, tepung putih telur campuran, tepung kuning telur campuran. Karakteristik dasar: Kandungan tepung telur tidak kurang dari 11,5%",
    "Aktif",
  ],
  [
    100203000007,
    "Rendang Telur",
    "Rendang telur adalah produk telur yang diperoleh dengan mencampurkan telur utuh atau telur dadar dengan bumbu rendangdan santan, dengan atau tanpa penambahan bahan pangan lain, dimasak sampai berminyak dan kering. Produk ini berwarna coklat kehitaman.",
    "Aktif",
  ],
  [
    100300000001,
    "Telur Asin Mentah",
    "Telur asin mentah adalah produk telur yang diperoleh dari telur itik/bebek yang telah diasinkan dengan proses tertentu, dan belum dimasak. Telur asin mentah dapat juga dibuat dari telur ayam atau telur entok.",
    "Nonaktif",
  ],
  [
    100300000002,
    "Telur Asin Matang",
    "Telur asin matang adalah produk telur yang diperoleh dari telur itik/bebek yang telah diasinkan dengan proses tertentu, dan dimasak. Telur asin matang dapat juga dibuat dari telur ayam atau telur entok.",
    "Aktif",
  ],
  [
    100300000003,
    "Telur Olahan Steril",
    "Telur olahan steril adalah produk telur dengan atau tanpa kerabang, dengan atau tanpa bumbu, dikemas secara kedap (hermetis), dan diawetkan melalui proses sterilisasi. Contoh produk meliputi telur gulai steril, telur pindang steril, telur balado steril, telur asin steril.",
    "Aktif",
  ],
  [
    100300000004,
    "Telur Hitam (Pidan/Pitan/Bitan)",
    "Telur hitam (Pidan/Pitan/Bitan) adalah produk telur yang diperoleh dari proses pengawetan telur dengan cara diperam dalam adonan yang mengandung garam dan/atau alkali dengan atau tanpa bahan lain (seperti abu kayu, air teh). Putih telur berbentuk seperti jeli berwarna coklat kehitaman, kuning telur berwarna abu-abu kehijauan. Telur ini beraroma seperti amonia dan berasa seperti kapur.",
    "Aktif",
  ],
  [
    100300000005,
    "Hulidan",
    "Hulidan adalah produk telur yang diperoleh dari proses pengawetan telur dengan cara pembungkusan telur dalam campuran tanah liatatau abu atau serbuk gergaji dan garam, yang menyebabkan kuning telur berwarna lebih gelap dan berbentuk semi-padat, dan telur berasa asin.",
    "Aktif",
  ],
  [
    100300000006,
    "Dsaudan",
    "Dsaudan adalah produk telur yang diperoleh dari proses pengawetan dengan cara pembungkusan dengan nasi dan garam, yang menyebabkan kulit telur melunak, membran menebal, dan isi telur mengalami koagulasi, mempunyai aroma dan rasa anggur (wine).",
    "Aktif",
  ],
  [
    100400000001,
    "Selai Kaya",
    "Selai kaya adalah produk olahan telur yang diperoleh dari pengolahan campuran telur, santan, gula, dengan atau tanpa penambahan bahan pangan lain.",
    "Aktif",
  ],
  [
    100400000002,
    "Custard",
    "Custard adalah produk telur yang diperoleh dari campuran telur, susu dan lemak/minyak nabati, dengan atau tanpa bahan pangan lain, konsistensinya kental, disajikan langsung maupun digunakan sebagai topping dan pengisi, dapat berasa manis maupun asin.",
    "Aktif",
  ],
  [
    100400000003,
    "Tepung Custard",
    "Tepung custard adalah produk tepung yang diperoleh dari custard yang dikeringkan.",
    "Aktif",
  ],
  [
    100400000004,
    "Martabak Telur",
    "Martabak telur adalah produk telur yang dibuat dari campuran telur ayam atau bebek dengan atau tanpa bahan pangan lain, yang dibungkus dalam lapisan adonan tepung kemudian digoreng.",
    "Aktif",
  ],
  [
    110101000001,
    "Gula Kristal Rafinasi",
    "Gula kristal rafinasi adalah gula kristal sukrosa yang diproduksi dari gula kristal mentah atau gula kristal yang dibuat dari umbi bit melalui proses klarifikasi dengan cara karbonatasi dan/atau fosfatasi.",
    "Aktif",
  ],
  [
    110101000002,
    "Dekstrosa Anhidrat",
    "Dekstrosa anhidrat adalah D-glukosa yang dimurnikan dan dikristalkan tanpa kristalisasi air, mengandung D-glukosa tidak kurang dari 99,5% dan kadar total padatan tidak kurang dari 98%.",
    "Aktif",
  ],
  [
    110101000003,
    "Dekstrosa Monohidrat",
    "Dekstrosa monohidrat adalah D-glukosa yang dimurnikan dan dikristalkan dengan kristalisasi satu molekul air, mengandung Dglukosa tidak kurang dari 99,5% dan kadar total padatan tidak kurang dari 90%.",
    "Aktif",
  ],
  [
    110101000004,
    "Fruktosa",
    "Fruktosa adalah D-fruktosa yang dimurnikan dan dikristalkan, mengandung D-fruktosa tidak kurang dari 95% dan glukosa tidak lebih dari 0,5%.",
    "Aktif",
  ],
  [
    110102000001,
    "Gula Serbuk (Icing Sugar) ",
    "Gula serbuk (icing sugar) adalah gula putih yang digiling sampai halus dengan atau tanpa penambahan antikempal.",
    "Aktif",
  ],
  [
    110102000002,
    "Dektrosa Serbuk (Icing Dextrose)",
    "Dektrosa serbuk (icing dextrose) adalah dekstrosa anhidrat atau dekstrosa monohidrat, atau campuran keduanya yang digiling sampai halus, dengan atau tanpa penambahan antikempal.",
    "Aktif",
  ],
  [
    110103000001,
    "Gula Putih Lembab atau Soft White Sugar",
    "Gula putih lembab atau soft white sugar adalah gula kristal halus yang dimurnikan, lembab, dan berwarna putih.",
    "Aktif",
  ],
  [
    110103000002,
    "Gula Merah Lembab atau Soft Brown Sugar ",
    "Gula merah lembab atau soft brown sugar adalah gula kristal halus yang telah dimurnikan dan berwarna coklat muda hingga coklat.",
    "Aktif",
  ],
  [
    110103000003,
    "Gula Tebu Mentah",
    "Gula tebu mentah adalah sukrosa yang peroleh dari proses pemurnian sebagian dari sari tebu dan dikristalkan.",
    "Aktif",
  ],
  [
    110103000004,
    "Glukosa",
    "Glukosa adalah padatan yang diperoleh dari proses hidrolisis pati. Mengandung gula pereduksi tidak kurang dari 70% yang dihitung sebagai dekstrosa anhidrat.",
    "Aktif",
  ],
  [
    110103010001,
    "Sirup Glukosa Kering ",
    "Sirup glukosa kering adalah produk yang dibuat dari sirup glukosa yang dihilangkan sebagian airnya sehingga kandungan total padatannya tidak kurang dari 93%.",
    "Aktif",
  ],
  [
    110103020001,
    "Sirup glukosa ",
    "Sirup glukosa adalah cairan gula kental yang murni dari sakarida yang mempunyai nutrisi dibuat dari pati dan/atau inulin.",
    "Aktif",
  ],
  [
    110104000001,
    "Laktosa",
    "Laktosa adalah gula alami yang terdapat dalam susu dan umumnya diperoleh dari whey, dapat berbentuk anhidrat atau monohidrat atau campuran keduanya. Karakteristik dasar: Kandungan laktosa tidak kurang dari 99%.",
    "Aktif",
  ],
  [
    110105000001,
    "Gula Kristal Putih atau Gula Pasir",
    "Gula kristal putih atau gula pasir adalah gula kristal yang dibuat dari tebu atau bit melalui proses sulfitasi/karbonatasi/fosfatasi atau proses lainnya sehingga langsung dapat dikonsumsi.",
    "Aktif",
  ],
  [
    110200000001,
    "Gula Palma Cetak",
    "Gula palma cetak adalah gula yang dihasilkan dari pengolahan nira pohon palma yaitu aren (Arenga pinata Merr), kelapa (Cocos nucifera), siwalan (Barassus flabellifer L) atau jenis palma lainnya, dan berbentuk sesuai cetakannya. Contoh nama jenis gula merah aren atau gula merah kelapa. Karakteristik dasar: Kadar air tidak lebih dari 10%.",
    "Aktif",
  ],
  [
    110200000002,
    "Gula Palma Serbuk (Gula Semut)",
    "Gula palma (gula semut) adalah gula yang dihasilkan dari pengolahan nira pohon palma yaitu aren (Arenga pinata Merr),kelapa (Cocos nucifera), siwalan (Barassus flabellifer L) atau jenis palma lainnya, dan berbentuk serbuk/granula. Contoh nama jenis gula semut atau gula palma serbuk. Karakteristik dasar: Kadar air tidak lebih dari 3%.",
    "Aktif",
  ],
  [
    110200000003,
    "Gula Merah Tebu/Saka",
    "Gula merah tebu adalah gula merah yang berasal dari pengolahan air tebu melalui pemasakan dan berwarna kecoklatan bentuknya sesuai cetakan.",
    "Aktif",
  ],
  [
    110300000001,
    "Tetes Tebu atau Molases",
    "Tetes tebu atau molases adalah hasil ikutan pabrik gula berupa cairan kental berwarna coklat kehitaman, berbau khas, memiliki rasa sepat manis sebagai produk dari proses pemisahan terakhir gula kristal dari masakan tebu (Saccharum officinarum L) tanpa penambahan air dan bahan lainnya.",
    "Aktif",
  ],
  [
    110300000002,
    "Gula Invert",
    "Gula invert adalah campuran glukosa dan fruktosa dalam konsentrasi ekimolar yang sama dan merupakan hasil hidrolisis sukrosa.",
    "Aktif",
  ],
  [
    110300000003,
    "Sirup Fruktosa (High Fructose Syrup/HFS)",
    "Sirup fruktosa (high fructose syrup/HFS) adalah cairan kental jernih dengan kadar fruktosa tinggi, umumnya diperoleh dengan proses enzimatik pati. Karakteristik dasar: \x{2022} HFS 42 mengandung fruktosa 42%; \x{2022} HFS 55 mengandung fruktosa 55%; \x{2022} HFS 42 dan HFS 55 mengandung dekstrosa tidak kurang dari 50% dan tidak lebih dari 53%.",
    "Aktif",
  ],
  [
    110300000004,
    "Sirup Fruktosa-Glukosa (High Fructose Glucose Syrup)",
    "Sirup fruktosa-glukosa atau high fructose glucose syrup adalah sirup dengan penampakan cerah, jernih, kental dan tidak berwarna yang dihasilkan dari proses hidrolisis pati yang terkendali dan selanjutnya dilakukan isomerisasi. Karakteristik dasar: Mengandung tidak kurang dari 40% fruktosa, 50% dekstrosa anhidrat, dan 5% oligosakarida.",
    "Aktif",
  ],
  [
    110300000005,
    "Sirup Jagung",
    "Sirup jagung adalah cairan gula kental yang dibuat dari hidrolisis pati jagung.",
    "Aktif",
  ],
  [
    110300000006,
    "Sirup Tebu (Cane Syrup)",
    "Sirup tebu (cane syrup) adalah produk cair yang diperoleh dengan proses pemekatan dan pemanasan sari tebu (Saccharum officinarum L.) atau dari pelarutan pekatan gula tebu yang terbuat dari sari tebu.",
    "Aktif",
  ],
  [
    110300000007,
    "Gula Sukrosa Cair ",
    "Gula sukrosa cair adalah produk gula berupa cairan jernih mengandung sukrosa yang diperoleh melalui proses pemekatan cairan dari tebu atau umbi bit, atau proses pelarutan gula pasir dalam air. Gula pasir (kristal sukrosa) dapat berupa gula kristal mentah, gula kristal putih, atau gula kristal rafinasi. Karakteristik dasar: Kadar sukrosa minimal 65% \\xBA Brix",
    "Aktif",
  ],
  [
    110400000001,
    "Sirup Maple (Maple Syrup)",
    "Sirup maple (maple syrup) adalah produk cairan yang diperoleh dengan proses pemekatan cairan eksudat (sap) pohon maple (Acer) atau larutan gula maple (maple concrete) yang dibuat dari cairansap.",
    "Aktif",
  ],
  [
    110400000002,
    "Sirup Sorgum (Shorgum Syrup)",
    "Sirup sorgum atau shorgum syrup adalah produk cair yang diperoleh dengan proses pemekatan dan pemanasan sari sorgum (Shorgum vulgare).",
    "Aktif",
  ],
  [
    110400000003,
    "Sirup/Sirup Meja (Table Syrup)",
    "Sirup meja (table syrup) adalah larutan 65% gula (sakarosa, gula invert dan fruktosa), umumnya digunakan sebagai topping atau pelengkap sajian.",
    "Aktif",
  ],
  [
    110400000004,
    "Gula Hias ",
    "Gula hias adalah gula untuk hiasan kue (contohnya kristal gula berwarna untuk kukis).",
    "Aktif",
  ],
  [
    110400000005,
    "Sirup Agave",
    "Sirup Agave adalah sirup yang diperoleh dari tanaman Agave.",
    "Aktif",
  ],
  [110400000006, "Gula Merah Cair", "", "Aktif"],
  [
    110500000001,
    "Madu",
    "Madu adalah cairan alami yang umumnya mempunyai rasa manis yang dihasilkan oleh lebah madu (Apis sp.) dari sari bunga tanaman (floral nektar) atau bagian lain dari tanaman (ekstra floral). Karakteristik dasar: \x{2022} Kadar hidroksimetil furfural tidak lebih dari 50 mg/kg; \x{2022} Aktivitas enzim diastase madu hutan dan madu lebah tanpa sengat tidak kurang dari 1 DN, madu budidaya tidak kurang dari 3 DN.",
    "Aktif",
  ],
  [
    110500000002,
    "Madu Serbuk",
    "Madu serbuk adalah produk yang diperoleh dari proses pengeringan madu dengan atau tanpa penambahan bahan pangan lain.",
    "Aktif",
  ],
  [110600000001, "Sediaan Pemanis Alami", "", "Aktif"],
  [110600000002, "Sediaan Pemanis Alami dan Buatan", "", "Aktif"],
  [110600000003, "Sediaan Pemanis Buatan", "", "Aktif"],
  [
    120101000001,
    "Garam Konsumsi Beriodium",
    "Garam konsumsi beriodium adalah produk pangan yang berbentuk padat dengan komponen utamanya natrium klorida (NaCl) dengan penambahan/fortifikasi kalium iodat (KIO3). Jumlah iodiumdihitung sebagai KIO3 tidak kurang dari 30 mg/kg. Sumber iodium lain yang dapat ditambahkan selain kalium iodat adalah kalium iodida, natrium iodida atau natrium iodat. Contoh nya adalah garam meja. Karakteristik dasar : \x{2022} Kadar natrium klorida tidak kurang dari 94 %; \x{2022} Kadar air tidak lebih dari 7%; \x{2022} Bagian yang tidak larut dalam air tidak lebih dari 0,5%.",
    "Aktif",
  ],
  [
    120101000002,
    "Garam Konsumsi Cair Beriodium",
    "Garam konsumsi cair beriodium adalah produk pangan berbentuk cair yang komponen utamanya natrium (NaCl) dan air (H2O) dengan penambahan kalium iodat (KIO3). Jumlah iodium dihitung sebagai KIO3 tidak kurang dari 30 mg/kg. Karakteristik dasar : Kadar NaCl 23% - 25%.",
    "Aktif",
  ],
  [
    120101000003,
    "Garam Gurih",
    "Garam gurih adalah garam konsumsi, dengan komponen utama natrium klorida (NaCl) dan telah ditambahkan senyawa iodium serta penguat rasa mononatrium L-glutamat (MSG). Karakteristik dasar : \x{2022} Kadar NaCl tidak kurang dari 87%; \x{2022} Penyedap rasa dihitung sebagai mononatrium L-glutamat (MSG) 9-12%; \x{2022} Iodium, dihitung sebagai kalium iodat (KIO3) 30-80 mg/kg.",
    "Aktif",
  ],
  [
    120101000004,
    "Garam Industri Aneka Pangan",
    "Garam industri aneka pangan adalah garam beriodium yang digunakan sebagai bahan baku untuk industri aneka pangan. Karakteristik dasar : \x{2022} Kadar NaCl tidak kurang dari 97% (basis kering); \x{2022} Kadar iodium dihitung sebagai KIO3 tidak kurang dari 30 mg/kg.",
    "Aktif",
  ],
  [
    120101000005,
    "Garam Diet",
    "Garam diet adalah garam beriodium yang mengandung natrium klorida (NaCl) yang disesuaikan dengan keperluan. Karakteristik dasar : \x{2022} Kadar natrium klorida (NaCl) adbk (atas dasar bahan kering) tidak lebih dari 60%; \x{2022} Kadar klorida (KCl) adbk tidak lebih dari 40%; \x{2022} Kadar iodium sebagai KIO3 tidak kurang dari 30 mg/kg.",
    "Aktif",
  ],
  [
    120101000006,
    "Garam Kurang Natrium",
    "Karakteristik dasar : \x{2022} Kadar natrium klorida (NaCl) tidak lebih dari 25g/100g; \x{2022} Kadar iodium sebagai KIO3 tidak kurang dari 30 mg/kg. \x{2022} Komponen lain yang dapat digunakan adalah garam kalium; garam kalsium; garam magnesium; garam amonium; atau campurannya.",
    "Aktif",
  ],
  [
    120101000007,
    "Garam Bahan Baku Untuk Garam Konsumsi Beriodium",
    "Garam bahan baku untuk garam konsumsi beriodium adalah garam yang komponen utamanya natrium klorida (NaCl) yang digunakan sebagai bahan baku untuk garam konsumsi beriodium. Karakteristik dasar : \x{2022} Natrium klorida (NaCl), adbk Kualitas K1 lebih dari 94 % \x{2022} Natrium klorida (NaCl), adbb Kualitas K1 lebih dari 87 % \x{2022} Natrium klorida (NaCl), adbk Kualitas K2 lebih dari 90 % \x{2022} Natrium klorida (NaCl), adbb Kualitas K2 lebih dari 83 % \x{2022} Natrium klorida (NaCl), adbk Kualitas K3 lebih dari 85 % \x{2022} Natrium klorida (NaCl), adbb Kualitas K3 lebih dari 75 %",
    "Aktif",
  ],
  [
    120101000008,
    "Garam Campuran",
    "Garam campuran adalah campuran garam dengan bahan pangan lain. Produk garam campuran dapat mengandung monosodium glutamat (MSG). Nama jenis produk diantaranya garam campur gula, garam campur MSG. Karakteristik dasar : \x{2022} Kadar NaCl tidak kurang dari 50%; \x{2022} Kadar iodium dihitung sebagai KIO3 tidak kurang dari 15,95 mg/kg.",
    "Aktif",
  ],
  [
    120101000009,
    "Garam Berbumbu",
    "Garam berbumbu adalah campuran garam dengan rempah, dengan atau bahan pangan lain. Karakteristik dasar : \x{2022} Kadar NaCl tidak kurang dari 50%; \x{2022} Kadar iodium dihitung sebagai KIO3 tidak kurang dari 15,95 mg/kg.",
    "Aktif",
  ],
  [
    120102000001,
    "Pengganti Garam ",
    "Pengganti garam adalah produk bahan makanan dengan kandungan natrium yang dikurangi dan digunakan untuk menggantikan garam. Pengganti garam meliputi: (a) kalium sulfat,garam kalium, kalsium atau amonium dari adipat, glutamat, karbonat, suksinat, laktat, tartrat, sitrat, asetat, hidroklorat atau asam ortofosforik; dan/atau  (b) garam magnesium adipat, glutamat, karbonat, sitrat, suksinat, asetat, tartrat, laktat, hidroklorat atau asam ortofosforik; dan/atau (c) garam kolin dari asetat, karbonat, laktat, tartrat, sitrat atau asam hidroklorida, campuran dengan garam pengganti bebas kolin sesuai daftar (a), (b), dan (d); dan/atau, (d) asam adipat, glutamat, sitrat, laktat, atau malat. Karakteristik dasar : \x{2022} Kandungan natrium tidak lebih dari 0,12g/100g produk pengganti garam; \x{2022} Kadar iodium dalam KIO3 minimal 30 mg/kg.",
    "Aktif",
  ],
  [
    120201000001,
    "Rempah Bubuk",
    "Rempah bubuk adalah rempah yang dihaluskan baik tunggal maupun campuran untuk memberikan rasa dan aroma yang khas bagi makanan tertentu. Karakteristik dasar : Kadar air tidak lebih dari 12%.",
    "Nonaktif",
  ],
  [
    120201000002,
    "Adas, Adas Pedas, Fennel, Jinten Manis",
    "Adas, adas pedas, fennel, jinten manis adalah produk rempah yang diperoleh dari buah kering dan masak dari tanaman Foeniculum vulgare atau Foeniculum officinale. Karakteristik dasar: \x{2022} Kadar air tidak lebih dari 12%; \x{2022} Kadar minyak atsiri tidak kurang dari 4% v/b.",
    "Nonaktif",
  ],
  [
    120201000003,
    "Adas Bubuk",
    "Adas bubuk adalah produk bubuk yang diperoleh dengan cara menggiling buah masak dan kering dari tanaman Foeniculum vulgare. Karakteristik dasar: \x{2022} Kadar air tidak lebih dari 12%; \x{2022} Kadar minyak atsiri tidak kurang dari 4% v/b.",
    "Nonaktif",
  ],
  [
    120201000004,
    "Akar Chicory",
    "Akar chicory adalah produk herba yang diperoleh dari akar tanaman Cichorium intybus L.",
    "Nonaktif",
  ],
  [
    120201000005,
    "Andaliman",
    "Andaliman adalah produk rempah yang diperoleh dari kulit luar buah beberapa jenis tumbuhan anggota marga Zanthoxylum (suku jeruk-jerukan, Rutaceae).",
    "Nonaktif",
  ],
  [
    120201000006,
    "Asam Gelugur",
    "Asam gelugur adalah produk rempah yang diperoleh dari buah kering dan masak dari tanaman Garcinia atroviridis Griffith et anders, sekerabat dengan manggis dan asam kandis. Karakteristik dasar: Kadar air tidak lebih dari 12%.",
    "Nonaktif",
  ],
  [
    120201000007,
    "Asam Sunti",
    "Asam sunti adalah produk rempah yang diperoleh dari buah masak tanaman Averrhoa bilimbi yang dikeringkan.",
    "Nonaktif",
  ],
  [
    120201000008,
    "Asam Jawa",
    "Asam jawa adalah produk rempah yang diperoleh dari buah tanaman Tamarindus indica atau T. officinalis.",
    "Nonaktif",
  ],
  [
    120201000009,
    "Asam Kandis",
    "Asam kandis adalah produk rempah yang diperoleh dari buah tanaman Garcinia xanthochymus.",
    "Nonaktif",
  ],
  [
    120201000010,
    "Allspice/Pimento",
    "Allspice adalah produk rempah berbentuk utuh atau serbuk yang diperoleh dari buah Pimmento dioica (L) Merr yang belum matang dan dikeringkan. Karakteristik dasar: \x{2022} Kadar air tidak lebih dari 12%; \x{2022} Kadar minyak atsiri tidak kurang dari 2,4% v/b.",
    "Nonaktif",
  ],
  [
    120201000011,
    "Basil",
    "Basil adalah herba yang diperoleh dari daun tanaman Occimum basilicum yang telah dikeringkan.",
    "Nonaktif",
  ],
  [
    120201000012,
    "Ruku-Ruku",
    "Ruku-ruku adalah herba yang diperoleh dari daun tanaman Hyptis suaveolens L. Poir yang telah dikeringkan.",
    "Nonaktif",
  ],
  [
    120201000013,
    "Kemangi",
    "Kemangi adalah herba yang diperoleh dari daun dan batang muda tanaman Occimum sanctum L. yang telah dikeringkan.",
    "Nonaktif",
  ],
  [
    120201000014,
    "Basilla",
    "Basilla adalah herba berbentuk utuh atau bubuk yang diperoleh dari daun Deimun basilicum yang dikeringkan. Karakteristik dasar: \x{2022} Kadar air tidak lebih dari 9%; \x{2022} Kadar minyak atsiri tidak kurang dari 0,3% v/b.",
    "Nonaktif",
  ],
  [
    120201000015,
    "Bay Leaves",
    "Bay leaves adalah herba berbentuk utuh atau bubuk yang diperoleh dari daun Lurus nobilis L yang dikeringkan. Karakteristik dasar : \x{2022} Kadar air tidak lebih dari 7%; \x{2022} Kadar minyak atsiri tidak kurang dari 1% v/b.",
    "Nonaktif",
  ],
  [
    120201000016,
    "Bawang Putih",
    "Bawang putih adalah umbi dari tanaman Allium sativum. Bisa dalam bentuk segar, pasta, kering, irisan kering, bubuk dengan atau tanpa campuran dengan garam.",
    "Nonaktif",
  ],
  [
    120201000017,
    "Bawang Merah (Shallot)",
    "Bawang merah (shallot) adalah umbi dari tanaman Allium cepa L. atau Allium ascalonicum. Bisa dalam bentuk segar, kering, bubuk, atau irisan yang digoreng.",
    "Nonaktif",
  ],
  [
    120201000018,
    "Bawang Batak/Lokio",
    "Bawang Batak/lokio adalah daun dan umbi tanaman Allium chinense.",
    "Nonaktif",
  ],
  [
    120201000019,
    "Bawang Daun",
    "Bawang daun adalah daun tanaman onion (Allium cepa) yang belum terbentuk umbinya (green onion) atau umbi baru terbentuk sedikitM(spring onion) dan tanaman Allium porrum (leek). Bisa dalam bentuk segar, bubuk, atau irisan.",
    "Nonaktif",
  ],
  [
    120201000020,
    "Biji Seledri",
    "Biji seledri adalah biji kering dari tanaman Apium graveolens. Karakteristik dasar : Kadar minyak atsiri tidak kurang dari 2% v/b.",
    "Nonaktif",
  ],
  [
    120201000021,
    "Daun Seledri",
    "Daun seledri adalah produk herba yang diperoleh dari tanaman Apium graveolens L.",
    "Nonaktif",
  ],
  [
    120201000022,
    "Biji Sawi/Biji Mustard",
    "Biji sawi/biji mustard adalah biji kering dari beberapa spesies tanaman Brassica. Karakteristik dasar : \x{2022} Kadar minyak atsiri tidak kurang dari 2,5% v/b; \x{2022} Harus bebas dari Argemone moxicana.",
    "Nonaktif",
  ],
  [
    120201000023,
    "Biji Sawi Bubuk atau Biji Mustard Bubuk",
    "Biji sawi atau biji mustard bubuk adalah produk bubuk yang diperoleh dari beberapa biji-bijian kering spesies Brassica. Karakteristik dasar : \x{2022} Kadar air tidak lebih dari 7%; \x{2022} Kadar minyak atsiri tidak kurang dari 2,5% v/b.",
    "Nonaktif",
  ],
  [
    120201000024,
    "Cabe Jawa",
    "Cabe Jawa adalah produk rempah yang diperoleh dari buah tanaman Piper retrofractum Vahl.",
    "Nonaktif",
  ],
  [
    120201000025,
    "Cabe Segar",
    "Cabe segar adalah produk rempah yang diperoleh dari buah tanaman Capsicum annum. Diantaranya meliputi cabe merah, cabe hijau (green chili), cabe jalapeno (jalapeno chili), cabe rawit (cayenne pepper), cabe rawit hijau (green cayenne pepper), cabe rawit merah (red cayenne pepper).",
    "Nonaktif",
  ],
  [
    120201000026,
    "Bubur Cabe",
    "Bubur cabe adalah produk bubur yang diperoleh dari proses penggilingan buah cabe (Capsicum annum atau C. fructessen) segar atau buah kering yang baik dengan penambahan air bersih. Dapat mengandung garam dan vinegar. Karakteristik dasar: Kandungan cabe tidak kurang dari 15%.",
    "Nonaktif",
  ],
  [
    120201000027,
    "Cabe Bubuk",
    "Cabe bubuk adalah produk bubuk yang diperoleh dari proses penggilingan buah cabe (Capsicum annum atau C. fructessen) kering yang baik. Karakteristik dasar: Kadar air tidak lebih dari 12%.",
    "Nonaktif",
  ],
  [
    120201000028,
    "Kucai/Chives",
    "Kucai/Chives adalah produk yang diperoleh dari daun tanaman Allium schoenoprasum.",
    "Nonaktif",
  ],
  [
    120201000029,
    "Cengkeh",
    "Cengkeh adalah produk yang diperoleh dari bunga yang belum mekar dari tanaman cengkeh Syzygium obtusifolium atau Eugenia caryophyllus famili Myrtaceae, yang telah dikeringkan. Karakteristik dasar : Minyak atsiri tidak kurang dari 15% v/b.",
    "Nonaktif",
  ],
  [
    120201000030,
    "Cengkeh Bubuk",
    "Cengkeh bubuk adalah produk bubuk yang diperoleh dari bunga yang belum mekar dari tanaman cengkeh Syzygium obtusifolium atau Eugenia caryopyllus famili Myrtaceae, yang telah dikeringkan dan digiling. Karakteristik dasar: \x{2022} Kadar air tidak lebih dari 12%; \x{2022} Minyak atsiri tidak kurang dari 15% v/b.",
    "Nonaktif",
  ],
  [
    120201000031,
    "Biji Dill (Dill Seed), Adas Manis, Adas Sowa, Adas Cina, Ender",
    "Biji dill (dill seed), adas manis, adas sowa, adas cina, ender adalah produk yang diperoleh dari buah tanaman Anethum graveolens yang telah dikeringkan. Karakteristik dasar: \x{2022} Kadar air tidak lebih dari 12%; \x{2022} Kadar minyak atsiri tidak kurang dari 2,5% v/b.",
    "Nonaktif",
  ],
  [
    120201000032,
    "Dill Weed",
    "Dill weed adalah produk yang diperoleh dari daun dill (Anethum graveolens). Daun dill memiliki rasa sedikit pahit.",
    "Nonaktif",
  ],
  [
    120201000033,
    "Daun Jeruk Purut (Kaffir lime)",
    "Daun jeruk purut adalah produk herba yang diperoleh dari daun tanaman Citrus hystrix. ",
    "Nonaktif",
  ],
  [
    120201000034,
    "Daun Pandan",
    "Daun pandan adalah produk herba yang diperoleh dari tanaman Pandanus amaryllifolius Roxb.",
    "Nonaktif",
  ],
  [
    120201000035,
    "Daun Peterseli",
    "Daun peterseli adalah produk herba yang diperoleh dari tanaman Petroselinum crispum.",
    "Nonaktif",
  ],
  [
    120201000036,
    "Daun Salam",
    "Daun salam adalah produk herba yang diperoleh dari tanaman Euginia polyantha Wight.",
    "Nonaktif",
  ],
  [
    120201000037,
    "Daun Sembung",
    "Daun sembung adalah produk herba yang diperoleh dari tanaman Blumea balsamifera (L) Dc.",
    "Nonaktif",
  ],
  [
    120201000038,
    "Daun Suji",
    "Daun suji adalah produk herba yang diperoleh dari tanaman Pleomele angustifolia N.E. Brown.",
    "Nonaktif",
  ],
  [
    120201000039,
    "Fenugreek, Kelabat, Kelabet, Klabat",
    "Fenugreek, kelabat, kelabet, klabat adalah produk yang diperoleh dari biji matang dan kering dari tanaman Trigonella foenumgraecum.",
    "Nonaktif",
  ],
  [
    120201000040,
    "Fenugreek Bubuk, Kelabat Bubuk, Kelabet Bubuk, Klabat Bubuk",
    "Fenugreek bubuk, kelabat bubuk, kelabet bubuk, klabat bubuk adalah produk bubuk yang diperoleh dengan cara menggiling biji matang dan kering dari tanaman Trigonella foenum-graecum. Karakteristik dasar : Kadar air tidak lebih dari 10%",
    "Nonaktif",
  ],
  [
    120201000041,
    "Fuli Kering (Bunga Pala)",
    "Fuli kering adalah arillus yang berwarna merah yang terdapat diantara daging dan biji buah tanaman Myristica fragrans Hout yang telah dibersihkan kotorannya dan dikeringkan. Karakteristik dasar: \x{2022} Kadar air tidak lebih dari 10%; \x{2022} Minyak atsiri tidak kurang dari 7%.",
    "Nonaktif",
  ],
  [
    120201000042,
    "Fuli Bubuk",
    "Fuli bubuk adalah produk bubuk yang diperoleh dari arillus biji tanaman Myristica fragrans Hout yang telah dikeringkan dan digiling. Karakteristik dasar: \x{2022} Kadar air tidak lebih dari 10%; \x{2022} Minyak atsiri tidak kurang dari 7% v/b.",
    "Nonaktif",
  ],
  [
    120201000043,
    "Jahe Segar",
    "Jahe segar adalah rimpang dari tanaman jahe (Zingiber officinale) yang sudah tua, berbentuk utuh dan segar serta dibersihkan. Karakteristik dasar : \x{2022} Tidak ada rimpang bertunas; \x{2022} Minyak atsiri tidak kurang dari 1%.",
    "Nonaktif",
  ],
  [
    120201000044,
    "Jahe Kering",
    "Jahe kering adalah produk rempah-rempah yang diperoleh dari rimpang dari tanaman jahe (Zingiber officinale) yang telah dibersihkan berbentuk utuh atau irisan dan dikeringkan. Karakteristik dasar : \x{2022} Bau dan rasa khas; \x{2022} Kadar air tidak lebih dari 12%.",
    "Nonaktif",
  ],
  [
    120201000045,
    "Bubur Jahe",
    "Bubur jahe adalah produk bubur yang diperoleh dari proses penggilingan rimpang dari tanaman jahe (Zingiber officinale) segar atau kering yang baik dengan penambahan air bersih. Dapat mengandung garam dan vinegar.",
    "Nonaktif",
  ],
  [
    120201000046,
    "Jahe Bubuk",
    "Jahe bubuk adalah produk bubuk yang diperoleh dari rimpang bersih tanaman Zingiber officinale yang telah dikeringkan. Karakteristik dasar: \x{2022} Kadar air tidak lebih dari 13%; \x{2022} Kadar minyak atsiri tidak kurang dari 1% v/b.",
    "Nonaktif",
  ],
  [
    120201000047,
    "Jintan/Caraway",
    "Jintan/caraway adalah biji kering yang diperoleh dari tanaman Carum carvi. Karakteristik dasar : \x{2022} Kadar air tidak lebih dari 10%; \x{2022} Kadar minyak atsiri tidak kurang dari 3% v/b.",
    "Nonaktif",
  ],
  [
    120201000048,
    "Jintan Bubuk",
    "Jintan bubuk adalah produk rempah-rempah yang diperoleh dari biji tanaman Carum carvi yang bersih, kering dan telah digiling. Karakteristik dasar : \x{2022} Kadar air tidak lebih dari 10%; \x{2022} Kadar minyak atsiri tidak kurang dari 3% v/b.",
    "Nonaktif",
  ],
  [
    120201000049,
    "Jintan Manis",
    "Jintan manis adalah produk rempah-rempah yang diperoleh dari buah matang tanaman Pimpinella anisum yang telah dikeringkan. Karakteristik dasar : \x{2022} Kadar air tidak lebih dari 7%; \x{2022} Kadar minyak atsiri tidak kurang dari 1% v/b.",
    "Nonaktif",
  ],
  [
    120201000050,
    "Jintan Hitam",
    "Jintan hitam adalah produk rempah-rempah yang diperoleh dari biji tanaman Nigella sativa yang bersih dan dikeringkan. Karakteristik dasar : \x{2022} Kadar air tidak lebih dari 12%; \x{2022} Kadar minyak atsiri tidak lebih dari 0,5% v/b.",
    "Nonaktif",
  ],
  [
    120201000051,
    "Jintan Hitam Bubuk",
    "Jintan hitam bubuk adalah produk bubuk yang diperoleh dengan menggilling biji kering yang bersih dari tanaman Nigella sativa. Karakteristik dasar: \x{2022} Kadar air tidak lebih dari 12%; \x{2022} Kadar minyak atsiri tidak kurang dari 0,5% v/b.",
    "Nonaktif",
  ],
  [
    120201000052,
    "Jintan Putih, Cumin",
    "Jintan putih, cumin adalah produk rempah-rempah yang diperoleh dari buah kering tanaman Cuminum cyminum. Karakteristik dasar : \x{2022} Kadar air tidak lebih dari 12%; \x{2022} Kadar minyak atsiri tidak kurang dari 2% v/b. ",
    "Nonaktif",
  ],
  [
    120201000053,
    "Jintan Putih Bubuk",
    "Jintan putih bubuk adalah produk bubuk yang diperoleh dari proses penggilingan biji kering tanaman Cuminum cyminum. Karakteristik dasar: \x{2022} Kadar air tidak lebih dari 12%; \x{2022} Kadar minyak atsiri tidak kurang dari 2% v/b.",
    "Nonaktif",
  ],
  [
    120201000054,
    "Kapulaga",
    "Kapulaga adalah rempah yang diperoleh dari buah kering yang masak dari tanaman Elettaria cardamomum. Karakteristik dasar : Kadar minyak atsiri tidak kurang dari 3% v/b.",
    "Nonaktif",
  ],
  [
    120201000055,
    "Biji Kapulaga",
    "Biji kapulaga adalah rempah yang diperoleh dari biji kering yang diperoleh dengan pemisahan dari kapsul tanaman Elettaria cardamomum. Karakteristik dasar : Kadar minyak atsiri tidak kurang dari 3% v/b. ",
    "Nonaktif",
  ],
  [
    120201000056,
    "Kapulaga Lokal",
    "Kapulaga lokal adalah produk rempah yang diperoleh dari buah tanaman kapulaga lokal (Amomum cardamomum L.) yang sudah tua, telah dibuang tangkai buahnya, dibersihkan dan dikeringkan. Karakteristik dasar : \x{2022} Kadar air tidak lebih dari 12%; \x{2022} Kadar minyak atsiri tidak kurang dari 3% v/b.",
    "Nonaktif",
  ],
  [
    120201000057,
    "Kapulaga (Cardamom) Amomum",
    "Kapulaga (cardamom) amomum adalah rempah yang diperoleh dari buah tanaman Amomum subulatum yang telah matang dan dikeringkan. Karakteristik dasar : \x{2022} Kadar minyak atsiri tidak kurang dari 1%; \x{2022} Bebas dari biji Argemone moxicana.",
    "Nonaktif",
  ],
  [
    120201000058,
    "Biji Kapulaga (Cardamom) Amomum",
    "Biji kapulaga (cardamom) amomum adalah rempah yang diperoleh dari biji buah Amomum subulatum yang telah dipisahkan dari kapsulnya. Karakteristik dasar : Kadar minyak atsiri tidak kurang dari 1%.",
    "Nonaktif",
  ],
  [
    120201000059,
    "Kapulaga Bubuk",
    "Kapulaga bubuk adalah produk bubuk yang diperoleh dari penggilingan biji kering bersih Elettaria cardamomum yang telah dipisahkan dari kapsulnya. Karakteristik dasar : \x{2022} Kadar air tidak lebih dari 14%; \x{2022} Kadar minyak atsiri tidak kurang dari 3% v/b.",
    "Nonaktif",
  ],
  [
    120201000060,
    "Kapulaga (Cardamom) Amomum Bubuk",
    "Kapulaga (cardamom) amomum bubuk adalah produk bubuk yang diperoleh dari penggilingan biji Amomum subulatum yang telah dipisahkan dari kapsulnya dan dikeringkan. Karakteristik dasar: \x{2022} Kadar air tidak lebih dari 14%; \x{2022} Kadar minyak atsiri tidak kurang dari 1% v/b.",
    "Nonaktif",
  ],
  [
    120201000061,
    "Kayu Manis",
    "Kayu manis adalah produk kering yang diperoleh dari kulit kayu bagian dalam tanaman Cinnamomum zeylanicum atau C. cassia atau C. burmanii atau C. sintok BI atau Cassiavera. Karakteristik dasar : Minyak atsiri tidak kurang dari 0,5% v/b. ",
    "Nonaktif",
  ],
  [
    120201000062,
    "Kayu Manis Bubuk",
    "Kayu manis bubuk adalah produk bubuk yang diperoleh dari proses penggilingan kulit kayu bagian dalam tanaman Cinnamomum zeylanicum atau C. cassia atau C. burmanii atau C. sintok BI atau Cassia vera yang telah dikeringkan.  Karakteristik dasar : \x{2022} Kadar air tidak lebih dari 12%; \x{2022} Kadar minyak atsiri tidak kurang dari 0,5%. ",
    "Nonaktif",
  ],
  [
    120201000063,
    "Kemiri",
    "Kemiri adalah rempah yang diperoleh dari daging biji kemiri (Alleurites mellucana (L) Wild) yang telah dipisahkan dari tempurungnya. Karakteristik dasar: \x{2022} Kadar minyak tidak kurang dari 60%; \x{2022} Kadar air tidak lebih dari 5%.",
    "Nonaktif",
  ],
  [
    120201000064,
    "Kencur",
    "Kencur adalah rimpang tanaman Kaempferia galanga L.",
    "Nonaktif",
  ],
  [
    120201000065,
    "Kencur Bubuk",
    "Kencur bubuk adalah produk bubuk yang diperoleh dari rimpang tanaman kencur yang telah dikeringkan.",
    "Nonaktif",
  ],
  [
    120201000066,
    "Ketumbar",
    "Ketumbar adalah buah tanaman Coriandrum sativum Linn masak yang kering.  Karakteristik dasar : Kadar minyak atsiri tidak kurang dari 1% v/b.",
    "Nonaktif",
  ],
  [
    120201000067,
    "Daun Ketumbar",
    "Daun ketumbar adalah herba yang diperoleh dari daun tanaman Coriandrum sativum Linn.",
    "Nonaktif",
  ],
  [
    120201000068,
    "Ketumbar Bubuk",
    "Ketumbar bubuk adalah produk bubuk yang diperoleh dari proses penggilingan buah kering tanaman Coriandrum sativum Linn. yang dibersihkan. Karakteristik dasar : \x{2022} Kadar air tidak lebih dari 12%; \x{2022} Kadar minyak atsiri tidak kurang dari 1% v/b.",
    "Nonaktif",
  ],
  [
    120201000069,
    "Lempuyang",
    "Lempuyang adalah produk yang diperoleh dari rimpang tanaman Zingiber zerumbet.",
    "Nonaktif",
  ],
  [
    120201000070,
    "Picung",
    "Picung adalah produk buah tanaman Pangium edule.",
    "Nonaktif",
  ],
  [
    120201000071,
    "Kluwek",
    "Kluwek adalah produk buah tanaman Pangium edule yang telah mengalami pengolahan dan pematangan. ",
    "Nonaktif",
  ],
  [
    120201000072,
    "Kunyit",
    "Kunyit adalah rimpang Curcuma domestica, Val atau Curcuma longa.  Karakteristik dasar : Kadar minyak atsiri tidak kurang dari 4% v/b.",
    "Nonaktif",
  ],
  [
    120201000073,
    "Kunyit Bubuk",
    "Kunyit bubuk adalah produk bubuk yang diperoleh dari proses penggilingan rimpang kering Curcuma longa atau Curcuma domestica, Val. Karakteristik dasar: \x{2022} Kadar air tidak lebih dari 13%; \x{2022} Kadar minyak atsiri tidak kurang dari 4% v/b.",
    "Nonaktif",
  ],
  [
    120201000074,
    "Lada Hitam",
    "Lada hitam adalah rempah yang diperoleh dari buah tanaman Piper nigrum Linn yang dipetik setelah sebagian besar buah lada matang dan telah dikeringkan. Karakteristik dasar: \x{2022} Kadar air tidak lebih dari 13,5%; \x{2022} Minyak atsiri tidak kurang dari 1%.",
    "Nonaktif",
  ],
  [
    120201000075,
    "Lada Hitam Bubuk",
    "Lada hitam bubuk adalah produk rempah yang diperoleh dari proses penggilingan lada hitam. Karakteristik dasar : \x{2022} Kadar air tidak lebih dari 14%; \x{2022} Kadar minyak atsiri tidak kurang dari 1%. ",
    "Nonaktif",
  ],
  [
    120201000076,
    "Lada Putih",
    "Lada putih adalah rempah buah tanaman Piper nigrum Linn yang dipetik setelah sebagian besar buah lada matang penuh, kemudian dihilangkan kulit luarnya, dikeringkan dan dibersihkan. Karakteristik dasar : \x{2022} Warna putih kekuningan hingga kecoklatan; \x{2022} Kadar air tidak lebih dari 14%.",
    "Nonaktif",
  ],
  [
    120201000077,
    "Lada Putih Bubuk",
    "Lada putih bubuk adalah produk rempah yang diperoleh dari lada putih yang telah digiling. Karakteristik dasar : Bau, rasa dan warna normal.",
    "Nonaktif",
  ],
  [
    120201000078,
    "Lada Bubuk Campuran",
    "Lada bubuk campuran adalah produk rempah yang diperoleh dari campuran lada bubuk hitam dan lada bubuk putih. Karakteristik dasar : \x{2022} Kadar air tidak lebih dari 14%; \x{2022} Kadar minyak atsiri tidak kurang dari 0,7% v/b. ",
    "Nonaktif",
  ],
  [
    120201000079,
    "Lengkuas/Laos",
    "Lengkuas/laos adalah rimpang tanaman Alpinia galanga, Linn Sw. ",
    "Nonaktif",
  ],
  [
    120201000080,
    "Lengkuas/Laos Bubuk",
    "Lengkuas/laos bubuk adalah produk bubuk yang diperoleh dari rimpang bersih tanaman lengkuas yang telah dikeringkan.",
    "Nonaktif",
  ],
  [
    120201000081,
    "Kecombrang/Sambuang/Kincung/Honje",
    "Kecombrang/Sambuang/Kincung/Honje adalah bunga tanaman Etlingera elatior (jack) R.M Sm. ",
    "Nonaktif",
  ],
  [
    120201000082,
    "Marjoram",
    "Marjoram adalah produk berbentuk utuh atau bubuk yang diperoleh dari daun Marjoram hortensis Moench yang dikeringkan, dengan atau tanpa pucuk bunga. Karakteristik dasar : \x{2022} Kadar air tidak lebih dari 10%; \x{2022} Kadar minyak atsiri tidak kurang dari 0,7% v/b.",
    "Nonaktif",
  ],
  [
    120201000083,
    "Mesoyi",
    "Mesoyi adalah produk herba yang diperoleh dari biji tanaman Cinnamomum sintoc atau Masoya aromatica.",
    "Nonaktif",
  ],
  [
    120201000084,
    "Mint",
    "Mint adalah produk herba yang diperoleh dari tanaman Mentha arvensis atau Mentha piperita.",
    "Nonaktif",
  ],
  [
    120201000085,
    "Onion/Bawang Bombay",
    "Onion/bawang bombay adalah umbi dari tanaman bawang Bombay Allium sp.",
    "Nonaktif",
  ],
  [
    120201000086,
    "Oregano",
    "Oregano adalah produk herba berbentuk utuh atau bubuk yang diperoleh dari daun Origantum vulgare sp. yang telah dikeringkan. Karakteristik dasar : \x{2022} Kadar air tidak lebih dari 10%; \x{2022} Kadar minyak atsiri tidak kurang dari 2,5% v/b.",
    "Nonaktif",
  ],
  [
    120201000087,
    "Pala",
    "Pala adalah biji kering tanaman Myristica fragrans dan dikupas kulit batoknya, berbentuk bulat atau lonjong dengan panjang 20 mm hingga 40 mm. Karakteristik dasar : \x{2022} Kadar air tidak lebih dari 10%; \x{2022} Minyak atsiri tidak kurang dari 7% v/b.",
    "Nonaktif",
  ],
  [
    120201000088,
    "Pala Untuk Destilasi",
    "Pala untuk destilasi adalah produk rempah biji yang berasal dari buah tanaman Myristica fragrans yang dipetik pada waktu muda (berumur 2 hingga 5 bulan). Karakteristik dasar: \x{2022} Kadar air tidak lebih dari 14%; \x{2022} Kadar minyak atsiri tidak kurang dari 8%.",
    "Nonaktif",
  ],
  [
    120201000089,
    "Pala Bubuk",
    "Pala bubuk adalah produk bubuk yang diperoleh dari biji kering tanaman Myristica fragrans. Karakteristik dasar: \x{2022} Kadar air tidak lebih dari 8%; \x{2022} Kadar minyak atsiri tidak kurang dari 7%. ",
    "Nonaktif",
  ],
  [
    120201000090,
    "Parsley",
    "Parsley adalah daun dari tanaman Petroselinum hortense yang telah dikeringkan. Daun berwarna hijau terang.",
    "Nonaktif",
  ],
  [
    120201000091,
    "Paprika Bubuk",
    "Paprika bubuk adalah produk rempah yang diperoleh dari buah matang tanaman Capsicum annuum yang telah dibersihkan, dikeringkan dan digiling. Karakteristik dasar : Kadar air tidak lebih dari 14%.",
    "Nonaktif",
  ],
  [
    120201000092,
    "Sweet Paprika Bubuk",
    "Sweet paprika bubuk adalah produk rempah yang diperoleh dari campuran buah matang tanaman Capsicum annuum dan Capsicum longum yang telah dibersihkan, dikeringkan dan digiling. ",
    "Nonaktif",
  ],
  [
    120201000093,
    "Rosemari",
    "Rosemari adalah produk berbentuk utuh atau bubuk yang diperoleh dari daun Rosemarinus officinalis L yang dikeringkan. Karakteristik dasar : \x{2022} Kadar air tidak lebih dari 9%; \x{2022} Kadar minyak atsiri tidak kurang dari 1,2% v/b.",
    "Nonaktif",
  ],
  [
    120201000094,
    "Sereh",
    "Sereh adalah produk herba yang diperoleh dari batang tanaman Cymbopogon citrates (DC) Stapt.",
    "Nonaktif",
  ],
  [
    120201000095,
    "Pekak/Bunga Lawang/Star Anise",
    "Pekak/bunga lawang/star anise adalah buah dari tanaman Illicium verum yang telah dikeringkan. Karakteristik dasar : Penampakan khas dan bebas dari biji Illicium anisatum.",
    "Nonaktif",
  ],
  [
    120201000096,
    "Temu Kunci",
    "Temu kunci adalah rimpang dari tanaman Boesenbergia pandurata (Roxb.) Schlet atau Gastrochillus panduratum yang telah dibersihkan.",
    "Nonaktif",
  ],
  [
    120201000097,
    "Thymi/Thyme",
    "Thymi/thyme adalah herba yang diperoleh dari daun pucuk kering thymi dari tanaman Thymus serpyllum L. atau Thymus vulgaris atau Thymus zugis L. baik dalam bentuk utuh atau bubuk. Karakteristik dasar : \x{2022} Kadar air tidak lebih dari 9%; \x{2022} Kadar minyak atsiri tidak kurang dari 0,9% v/b.",
    "Nonaktif",
  ],
  [
    120201000098,
    "Wasabi",
    "Wasabi adalah produk yang diperoleh dari rimpang tanaman Wasabia japonica. ",
    "Nonaktif",
  ],
  [
    120201000099,
    "Wijen",
    "Wijen adalah produk yang diperoleh dari biji tanaman Sesamum indicum L. syn./Sesamum orientalis L.",
    "Nonaktif",
  ],
  [120201000100, "Herba dan Rempah Olahan", "", "Aktif"],
  [
    120202000001,
    "Bubuk Ngohyang",
    "Bubuk ngohyang adalah campuran dari lima macam rempah antara lain bunga lawang, kayu manis, lada hitam, jintan dan cengkeh.",
    "Aktif",
  ],
  [
    120202000002,
    "Bumbu Siap Pakai",
    "Bumbu siap pakai adalah produk bumbu yang diperoleh dari campuran rempah dengan atau tanpa penambahan minyak untuk membuat masakan tertentu. Produk dapat ditambahkan bahan pangan lain. Produk dapat dikemas dalam kemasan plastik atau botol plastik atau botol kaca atau kemasan lainnya dan dapat diawetkan dengan pemanasan. Bumbu siap pakai dapat berbentuk basah (pasta) atau kering (bubuk atau blok).  Penamaan jenis produk yang berbentuk basah (pasta) hasil proses pemanasan misalnya bumbu instan soto, bumbu instan nasi goreng. Penamaan jenis produk yang berbentuk kering (bubuk atau blok) atau pasta hasil proses tanpa pemanasan misalnya bumbu soto, bumbu nasi goreng.",
    "Aktif",
  ],
  [
    120202000003,
    "Bumbu Ekstrak Daging Sapi",
    "Bumbu ekstrak daging sapi adalah produk bumbu yang mengandung ekstrak daging sapi, dengan penambahan bahan pangan lain dalam bentuk bubuk atau blok/kubus. Karakteristik dasar : \x{2022} Kadar air tidak lebih dari 4%; \x{2022} Kadar protein tidak kurang dari 7%.",
    "Aktif",
  ],
  [
    120202000004,
    "Bumbu Rasa Sapi",
    "Bumbu rasa sapi adalah produk bumbu yang mengandung perisa daging sapi, dengan penambahan bahan pangan lain dan dalam bentuk bubuk atau blok/kubus. ",
    "Aktif",
  ],
  [
    120202000005,
    "Bumbu Ekstrak Daging Ayam",
    "Bumbu ekstrak daging ayam adalah produk bumbu yang mengandung ekstrak daging ayam baik dalam bentuk bubuk atau blok/kubus. Karakteristik dasar : \x{2022} Kadar air tidak lebih dari 4%; \x{2022} Kadar protein tidak kurang dari 6%.",
    "Aktif",
  ],
  [
    120202000006,
    "Bumbu Ekstrak Udang",
    "Bumbu ekstrak udang adalah produk bumbu yang mengandung udang baik dalam bentuk bubuk atau blok/kubus. Karakteristik dasar : \x{2022} Kadar air tidak lebih dari 4%; \x{2022} Kadar udang tidak kurang dari 15%.",
    "Aktif",
  ],
  [
    120202000007,
    "Bumbu Ekstrak Cumi",
    "Bumbu ekstrak cumi adalah produk bumbu yang mengandung cumi dalam bentuk bubuk atau blok/kubus. Karakteristik dasar : \x{2022} Kadar air tidak lebih dari 4%; \x{2022} Kadar cumi tidak kurang dari 15%. ",
    "Aktif",
  ],
  [
    120202000008,
    "Bumbu Pasta Ekstrak Daging (Misalnya Bumbu Pasta Ekstrak Daging Sapi dan Daging Ayam)",
    "Karakteristik dasar : Kadar air tidak lebih dari 12,5%. ",
    "Aktif",
  ],
  [
    120202000009,
    "Bumbu Rasa Ikan",
    "Bumbu rasa ikan adalah produk bumbu yang mengandung perisa ikan baik dalam bentuk bubuk atau blok/kubus. ",
    "Aktif",
  ],
  [
    120202000010,
    "Bumbu Rasa Udang",
    "Bumbu rasa udang adalah produk bumbu yang mengandung perisa udang baik dalam bentuk bubuk atau blok/kubus.",
    "Aktif",
  ],
  [
    120202000011,
    "Bumbu Rasa Ayam",
    "Bumbu rasa ayam adalah produk bumbu yang mengandung perisa ayam baik dalam bentuk bubuk atau blok/kubus. ",
    "Aktif",
  ],
  [
    120202000012,
    "Bubuk/Blok/Kubus/Pasta Ekstrak Ayam/Sapi/Udang/Keju",
    "Bubuk/blok/kubus/pasta ekstrak ayam/sapi/udang/keju adalah produk yang mengandung ayam/sapi/udang/keju baik dalam bentuk bubuk/blok/kubus/pasta dengan atau tanpa penambahan bahan pangan lain. Produk ini tanpa penambahan rempah.",
    "Aktif",
  ],
  [
    120202000013,
    "Ragi Kering (Tidak Aktif)",
    "Ragi kering (tidak aktif) adalah produk yang dibuat dengan cara membiakkan kamir jenis Saccharomyces cerevisiae, Saccharomyces fragilis, dan Candida utilis dalam media serealia atau bahan lain yang sesuai, dalam keadaan bersih, kering, tidak aktif serta berfungsi sebagai bumbu dan kondimen. Karakteristik dasar : Kadar air tidak lebih dari 7%.",
    "Aktif",
  ],
  [
    120202000014,
    "Bawang hitam (Black Garlic)",
    "Bawang hitam adalah produk yang diperoleh dari bawang putih segar (Allium sativum L.) yang dipanaskan pada suhu umumnya 60-90\\xB0C dan kelembaban tinggi dalam waktu kurang lebih 1 bulan sehingga dihasilkan siung bawang dengan warna gelap/hitam, rasa manis, dan tekstur yang kenyal. Karakteristik Dasar: Kadar air tidak lebih dari 50%",
    "Aktif",
  ],
  [
    120300000001,
    "Cuka Fermentasi (Vinegar)",
    "Cuka fermentasi (vinegar) adalah produk cair yang mengandung asam asetat, yang diperoleh melalui proses fermentasi bahan-bahan yang mengandung karbohidrat atau alkohol. Contoh : cuka apel, cuka anggur. Karakteristik dasar : Total asam tidak kurang dari 4 g/100 ml.",
    "Aktif",
  ],
  [
    120300000002,
    "Cuka Hasil Pengenceran Asam Asetat Glasial",
    "Cuka hasil pengenceran asam asetat glasial adalah produk cair yang diperoleh dari pengenceran asam asetat glasial (untuk makanan dan farmasi) dengan air minum. Contoh : Cuka makan. Karakteristik dasar : \x{2022} Bentuk cairan encer, jernih, tidak berwarna, bau khas asam asetat; \x{2022} Cuka dapur : kadar asam asetat tidak kurang dari 12,5 % v/b; \x{2022} Cuka meja : kadar asam asetat tidak kurang dari 4% dan tidak lebih dari 12,5 % v/b.",
    "Aktif",
  ],
  [
    120300000003,
    "Arak Masak",
    "Arak masak adalah produk yang diperoleh dari hasil fermentasi beras, dapat diikuti dengan proses penyulingan, berwarna bening hingga bening kecoklatan dengan aroma ragi yang tajam, ditambahkan garam dan/atau rempah-rempah dan/atau bahan pangan lain yang menimbulkan rasa, digunakan sebagai penambah rasa pada hidangan oriental. Pada label wajib dicantumkan kadar alkohol dan keterangan \"hanya untuk memasak\".",
    "Aktif",
  ],
  [
    120400000001,
    "Mustard/Saus Mustard",
    "Mustard/saus mustard adalah produk kondimen yang disiapkan dari biji mustard yang ditumbuk, umumnya dari biji mustard yang telah ditumbuk dan dihilangkan minyaknya, yang dicampur/diolah dengan menambahkan air, vinegar/cuka, garam, dan rempah-rempah menjadi saus/pasta yang berwarna kuning cerah sampai kecoklatan. Contoh : mustard Dijon dan mustard pedas (hot mustard) yang diperoleh dari biji dan kulit mustard. ",
    "Aktif",
  ],
  [
    120501000001,
    "Sari Pati Ayam",
    "Sari pati ayam adalah ekstrak karkas ayam pedaging dengan atau tanpa penambahan garam, sari simplisia, dalam bentuk siap dikonsumsi Karakteristik dasar: \x{2022} Bentuk cairan jernih; \x{2022} Kadar protein tidak kurang dari 7,7%.",
    "Aktif",
  ],
  [
    120501000002,
    "Kaldu dan Konsome",
    "Kaldu dan konsome adalah produk yang diperoleh dari daging sapi, daging unggas, atau daging lainnya dengan cara memasak bahan kaya protein atau sarinya dan atau hidrolisatnya dengan air dengan atau tanpa penambahan bumbu dan atau bahan penyedap, lemak yang dapat dimakan, natrium klorida, rempah-rempah dan sari-sari alami atau destilatnya atau bahan makanan lain untuk meningkatkan rasa, atau dengan rekonstitusi dari campuran komponen kering yang sesuai dengan petunjuk penggunaan. Karakteristik dasar : Nitrogen total untuk kaldu daging: kaldu daging unggas tidak kurang dari 100 mg/l, untuk konsome daging sapi tidak kurang dari 160 mg/l, untuk kaldu daging lainnya tidak kurang dari 350 mg/l; nitrogen amino tidak kurang dari 210 mg/l untuk kaldu daging lainnya; natrium klorida tidak lebih dari 12,5 g/l; lemak tidak kurang dari 3 g/l untuk kaldu daging berlemak.",
    "Aktif",
  ],
  [
    120502000001,
    "Sup Instan",
    "Sup instan adalah produk pangan olahan kering instan yang dapat dibuat dari daging, ikan, sayuran, serealia atau campurannya, yang siap dikonsumsi setelah diseduh dengan air mendidih. Dapat ditambahkan bahan pangan lain. Karakteristik dasar : \x{2022} Bau dan rasa khas; \x{2022} Kadar air tidak lebih dari 7%. ",
    "Aktif",
  ],
  [
    120502000002,
    "Sup Pasta Instan (Misalnya Sup Makaroni Instan)",
    "Karakteristik dasar : Kadar air tidak lebih dari 12,5%. ",
    "Aktif",
  ],
  [
    120502000003,
    "Sup Krim Instan",
    "Sup krim instan adalah produk pangan olahan kering instan yang dibuat dari tepung nabati dan atau hewani, yang siap dikonsumsi setelah diseduh dengan air mendidih menjadi larutan kental. Dapat ditambahkan bahan pangan lain. Karakteristik dasar : Kadar air tidak lebih dari 8%.",
    "Aktif",
  ],
  [
    120502000004,
    "Sup Krim Pasta Instan (Misalnya Sup Krim Makaroni Instan)",
    "Karakteristik dasar : Kadar air tidak lebih dari 12,5%. ",
    "Aktif",
  ],
  [
    120601000001,
    "Mayonais, Mayonnaise",
    "Mayonais adalah saus kondimen yang diperoleh dengan cara mengemulsikan minyak nabati dalam fase air yang mengandung vinegar atau asam cuka atau pengasam lainnya dengan penambahan telur dalam bentuk segar, cair, bubuk, atau beku untuk menghasilkan emulsi, dengan atau tanpa penambahan bahan pangan lain. Bahan pangan lain yang dapat digunakan antara lain gula, garam, kondimen, rempah-rempah dan herba, buah dan sayuran termasuk jus buah dan jus sayuran, biji sawi/mustard, produk-produk susu, air. Karakteristik dasar : Kadar lemak total tidak kurang dari 65%.",
    "Aktif",
  ],
  [
    120601000002,
    "Salad Dressing (Misalnya Thousand Island, Blue Cheese, Burger Dressing, Saus Siram Caesar)",
    "Salad dressing (misalnya thousand island, blue cheese, burger dressing, saus siram caesar) adalah saus kondimen yang merupakan produk emulsi semi solid yang dibuat dari minyak nabati dengan penambahan vinegar atau asam cuka atau pengasam lainnya, telur dalam bentuk segar, cair, bubuk, atau beku, dan pati dengan atau tanpa penambahan bahan pangan lain. Bahan pangan lain yang dapat digunakan antara lain garam, gula, rempah, kecuali safron atau kunyit. Karakteristik dasar : Kadar lemak total tidak kurang dari 20%.",
    "Aktif",
  ],
  [
    120601000003,
    "Saus Tar Tar (Tar Tar Sauce)",
    "Saus tar tar adalah saus yang berasal dari mayonais yang ditambahkan bawang bombay dan acar mentimun, dengan atau tanpa penambahan mentimun segar. Karakteristik dasar : Kadar lemak total tidak kurang dari 50%.",
    "Aktif",
  ],
  [
    120601000004,
    "French Dressing (Italian Dressing, Greek Dressing, Ranch Style Dressing)",
    "French dressing (italian dressing, greek dressing, ranch style dressing) adalah saus kondimen yang merupakan produk cairan yang dapat dipisahkan atau emulsi cairan yang dibuat dari minyak makan dan satu atau lebih pengasam. Ingredien yang dapat digunakan adalah vinegar atau vinegar encer atau vinegar, jus lemon dan atau jus jeruk nipis, garam, pemanis nutritif rempah atau perisa alami, pasta tomat, puree tomat, saus tomat, sherrywine, telur. Karakteristik dasar : Kadar lemak total tidak kurang dari 35%.",
    "Aktif",
  ],
  [
    120601000005,
    "Sandwich Spread",
    "Sandwich spread adalah produk oles sandwich yang dibuat dari mayonais sebagai bahan dasar, paprika, dan acar mentimun.",
    "Aktif",
  ],
  [
    120602000001,
    "Sambal",
    "Sambal adalah produk siap konsumsi yang dibuat dari bahan utama cabe (Capsicum sp) dengan penambahan bahan pangan lain, berbentuk semi padat, dan telah mengalami proses pemasakan atau pengawetan lain. Meliputi semua jenis sambal antara lain sambal terasi, sambal bajak, sambal petai, sambal cabai hijau, tidak termasuk cabe bubuk, cabe giling, saus cabe dan sambal yang digunakan sebagai bumbu masak.",
    "Aktif",
  ],
  [
    120602000002,
    "Saus Cabe",
    "Saus cabe adalah produk saus siap konsumsi yang dibuat dari cabe (Capsicum sp) atau turunannya, berbentuk cairan kental homogen, yang telah mengalami proses pemanasan.",
    "Aktif",
  ],
  [
    120602000003,
    "Bumbu Kacang",
    "Bumbu kacang adalah bumbu yang terbuat dari kacang tanah yang telah digoreng atau disangrai dan dihaluskan dengan penambahan garam, gula atau bahan pangan lain dan rempah-rempah tertentu yang sesuai, dan langsung digunakan tanpa ditambah air terlebih dahulu. Nama jenis untuk produk ini antara lain bumbu gado-gado, bumbu pecel, bumbu sate, bumbu siomay, dan bumbu batagor. ",
    "Aktif",
  ],
  [
    120602000004,
    "Saus Keju (Cheese Sauce)",
    "Saus keju adalah produk saus yang diperoleh dari keju dengan penambahan garam, mustard dan bumbu.",
    "Aktif",
  ],
  [
    120602000005,
    "Saus Lobak",
    "Saus lobak adalah produk saus yang diperoleh dari lobak yang diiris atau dihancurkan, dicampur dengan jus orange, air jeruk nipis, cilantro, minyak, garam dan lada.",
    "Aktif",
  ],
  [
    120602000006,
    "Saus Panggang/Saus Barbekue (BBQ Sauce)",
    "Saus panggang/saus barbekue (BBQ sauce) adalah produk saus yang diperoleh dari campuran vinegar, gula, garam, saus Worchester dan rempah-rempah seperti bawang putih, onion, paprika dan lada hitam dengan atau tanpa saus tomat atau pasta tomat, bahan pangan lain.",
    "Aktif",
  ],
  [
    120602000007,
    "Saus Pizza",
    "Saus pizza adalah produk saus yang diperoleh dari pasta tomat, saus tomat yang diberi garam dan rempah-rempah seperti biji anis, lada, bubuk bawang putih, oregano dan parsley. Karakteristik dasar : \x{2022} Total nitrogen tidak kurang dari 2,75%; \x{2022} Garam tidak kurang dari 10%.",
    "Aktif",
  ],
  [
    120602000008,
    "Saus Spagheti (Spaghetti Sauce)",
    "Saus spagheti (spaghetti sauce) adalah produk saus yang diperoleh campuran rempah-rempah seperti bawang putih, bawang bombay, lada hitam, daun basil, oregano, thymi, gula, garam, vinegar dengan atau tanpa saus tomat atau pasta tomat, dan bahan pangan lain.",
    "Aktif",
  ],
  [
    120602000009,
    "Saus Tiram",
    "Saus tiram adalah produk cairan kental berwarna coklat sampai coklat kehitam-hitaman, diperoleh dari hasil olahan daging tiram (Crassostrea calculata sp.) dengan penambahan bahan pangan lain.",
    "Aktif",
  ],
  [
    120602000010,
    "Saus Perendam/Saus Marinasi (Marinated Sauce)",
    "Saus perendam/saus marinasi adalah produk saus yang digunakan untuk merendam ikan, daging, ayam, atau bahan pangan lain untuk memberi rasa dan aroma tertentu sebelum diolah lebih lanjut.",
    "Aktif",
  ],
  [
    120602000011,
    "Saus Tomat",
    "Saus tomat adalah produk saus yang diperoleh dari buah segar, bubur tomat, pasta tomat, puree tomat atau padatan tomat, yang dicampur dengan gula, bahan pengasam, garam dan dengan atau tanpa penambahan bahan pangan lain. Karakteristik dasar : Bau, rasa dan warna khas.",
    "Aktif",
  ],
  [
    120602000012,
    "Saus Asam Manis",
    "Saus asam manis adalah produk saus yang terbuat dari tomat dan atau buah lain, gula dan bahan pengasam, dengan atau tanpa penambahan bahan pangan lain. Produk ini mempunyai rasa asam dan manis. ",
    "Aktif",
  ],
  [
    120602000013,
    "Kecap Inggris, Saus Worchester",
    "Kecap Inggris, saus Worchester adalah produk saus yang terdiri dari air, vinegar, garam dan rempah atau bahan pangan lain. Digunakan untuk memberi flavor dan saus barbekue serta saus asam manis.",
    "Aktif",
  ],
  [
    120602000014,
    "Saus Teriyaki",
    "Saus teriyaki adalah produk saus yang diperoleh dari campuran kecap dengan bahan pangan yang sesuai.",
    "Aktif",
  ],
  [
    120602000015,
    "Saus Topping/Saus Siram",
    "Saus topping/saus siram adalah produk saus yang diperoleh dari campuran rempah-rempah dengan atau tanpa penambahan saus tomat atau pasta tomat dan dengan atau tanpa penambahan bahan pangan lain untuk digunakan sebagai topping atau siram pada masakan dengan atau tanpa dimasak terlebih dahulu. Misalnya: saus jamur, saus wijen sangrai, dan saus lainnya",
    "Aktif",
  ],
  [
    120602000016,
    "Saus Salsa",
    "Saus salsa adalah saus yang mengandung cacahan tomat dan cabe, serta dapat ditambahkan bahan pangan lain.",
    "Aktif",
  ],
  [
    120602000017,
    "Saus Putih (Berbasis Krim)",
    "Saus putih (berbasis krim) adalah saus yang mengandung bahan utama susu atau krim dengan sedikit penambahan lemak dan tepung dengan atau tanpa bumbu atau rempah. ",
    "Aktif",
  ],
  [
    120603000001,
    "Campuran Untuk Saus, Gravies, dan Dressing",
    "Produk konsentrat, biasanya berbentuk bubuk, untuk nantinya dicampurkan dengan air, susu, minyak ataupun cairan lain untuk menghasilkan produk siap saji berupa saus, gravies dan dressing. Termasuk di dalamnya konsentrat dari saus teremulsi ataupun saus non emulsi. Termasuk dalam kategori ini antara lain bumbu kacang yang harus ditambah air sebelum digunakan.",
    "Aktif",
  ],
  [
    120604000001,
    "Kecap Ikan",
    "Kecap ikan adalah produk cair yang diperoleh dari hasil fermentasi ikan atau hidrolisis dengan atau tanpa penambahan pangan lain.",
    "Aktif",
  ],
  [
    120604000002,
    "Saus Tiram Bening",
    "Saus tiram bening adalah produk cairan bening, diperoleh dari hasil olahan daging tiram (Crassostrea calculata sp.) dengan penambahan bahan pangan lain.",
    "Aktif",
  ],
  [
    120700000001,
    "Olesan/Saus",
    "Olesan/saus adalah produk berupa emulsi atau non emulsi yang tidak termasuk kategori 12.6, mempunyai rasa savoury (gurih manis), pedas, asam, atau rasa lain dan digunakan untuk olesan atau cocolan/dip. ",
    "Aktif",
  ],
  [
    120800000001,
    "Ragi Roti Kering",
    "Ragi roti kering adalah produk yang dibuat dengan cara membiakkan kamir jenis Saccharomyces cereviceae dalam media serealia atau bahan lain yang sesuai, dalam keadaan bersih, kering dan mempunyai kemampuan meragikan adonan tepung terigu dengan atau tanpa campuran tepung lain pada pembuatan roti dan kue. Ragi roti kering berbentuk serbuk atau butiran, berwarna kekuningan sampai kecoklatan. Karakteristik dasar: Kadar air tidak lebih dari 5%.",
    "Aktif",
  ],
  [
    120800000002,
    "Ragi Roti Semi Kering",
    "Ragi roti semi kering adalah produk yang dibuat dengan cara membiakkankamir jenis Saccharomyces cereviceae dalam media serealia atau bahanlain yang sesuai, dalam keadaan bersih, semi kering dan mempunyai kemampuan meragikan adonan tepung terigu dengan atau tanpa campuran tepung lain pada pembuatan roti dan kue. Ragi roti semi kering berbentuk serbuk atau butiran, berwarna kekuningan sampai kecoklatan. Karakteristik dasar : Kadar air lebih dari 5% sampai dengan 20%. ",
    "Aktif",
  ],
  [
    120800000003,
    "Ragi Roti Cair (cream yeast)",
    "Ragi roti cair adalah produk yang dibuat dengan cara membiakkan kamir jenis Saccharomyces cereviceae dalam media serealia atau bahan lain yang sesuai, dalam keadaan bersih, berbentuk cairan kental dan mempunyai kemampuan meragikan adonan tepung terigu dengan atau tanpa campuran tepung lain pada pembuatan roti dan kue. Ragi roti cair berwarna kekuningan sampai kecoklatan. Karakteristik dasar : Kadar air lebih dari 70% sampai dengan 80%. ",
    "Aktif",
  ],
  [
    120800000004,
    "Ragi Roti Padat (Compressed Yeast)",
    "Ragi roti padat (compressed yeast) adalah produk yang dibuat dengan cara membiakkan kamir jenis Saccharomyces cereviceae dalam media serealia atau bahan lain yang sesuai, dalam keadaan bersih, berbentuk padat dan mempunyai kemampuan meragikan adonan tepung terigu dengan atau tanpa campuran tepung lain pada pembuatan roti dan kue. Ragi roti padat berwarna kekuningan sampai kecoklatan.  Karakteristik dasar : Kadar air 63% - 70%. ",
    "Aktif",
  ],
  [
    120800000005,
    "Ragi Tape",
    "Ragi tape adalah produk yang dibuat dari tepung beras yang telah dicampur dengan beberapa rempah-rempah untuk menstimulir pertumbuhan kapang dan kamir yang telah dikeringkan dan berperan dalam pembuatan tape. ",
    "Aktif",
  ],
  [
    120800000006,
    "Ragi Tempe",
    "Ragi tempe adalah produk yang dibuat dari bahan sumber karbohidrat (pati) yang mengandung kapang Rhizopus oligosporus yang telah dikeringkan dan digunakan dalam pembuatan tempe.",
    "Aktif",
  ],
  [
    120800000007,
    "Koji atau Ragi Tauco atau Ragi Kecap",
    "Koji atau ragi tauco atau ragi kecap adalah produk yang dibuat dari serealia yang ditumbuhi Aspergillus oryzae, yang telah dikeringkan dan digunakan untuk pembuatan kecap/tauco/miso.",
    "Aktif",
  ],
  [
    120800000008,
    "Ragi Untuk Minuman Beralkohol",
    "Ragi untuk minuman beralkohol adalah produk yang dibuat dari bahan sumber karbohidrat (pati) yang mengandung kamir yang telah dikeringkan dan digunakan dalam pembuatan minuman beralkohol.",
    "Aktif",
  ],
  [
    120901000001,
    "Miso",
    "Miso adalah produk yang dibuat dari kedelai, beras/barley/koji, garam, air, dengan atau tanpa penambahan bahan pangan lain, dengan proses fermentasi, dan menghasilkan tekstur pasta yang halus, serta rasa, warna, aroma khas miso. Dapat digunakan untuk soup base, kondimen, maupun penyedap rasa.",
    "Aktif",
  ],
  [
    120901000002,
    "Tauco",
    "Tauco adalah produk kedelai yang diperoleh dari kacang kedelai hasil fermentasi kacang kedelai dalam larutan garam, berbau khas dengan atau tanpa penambahan bahan pangan lain.",
    "Aktif",
  ],
  [
    120902010001,
    "Kecap Kedelai Asin (Salty Soy Sauce)",
    "Kecap kedelai asin (salty soy sauce) adalah produk berbentuk cair yang diperoleh dari hasil fermentasi kacang kedelai (Glycine max L.) atau bungkil kedelai dengan atau tanpa penambahan bahan pangan lain. Karakteristik dasar : \x{2022} Bau dan rasa khas; \x{2022} Kadar protein (N x 5,71) tidak kurang dari 4,0%.",
    "Aktif",
  ],
  [
    120902020001,
    "Kecap Kedelai Asin Non Fermentasi/Hidrolisat",
    "Kecap kedelai asin non fermentasi/hidrolisat adalah produk cair yang diperoleh dari hasil pengolahan dan atau cara kimia (hidrolisis) kacang kedelai (Glycine max L.) dengan atau tanpa penambahan bahan pangan lain. Karakteristik dasar: Kadar protein (N x 5,71) tidak kurang dari 4,0%.",
    "Aktif",
  ],
  [
    120902020002,
    "Saus Protein Nabati Terhidrolisis",
    "Saus protein nabati terhidolisis adalah produk saus yang diperoleh dari protein nabati terhidrolisis. Karakteristik dasar : \x{2022} Total nitrogen tidak kurang dari 2,75%; \x{2022} Kadar garam tidak kurang dari 10%.",
    "Aktif",
  ],
  [
    120902030001,
    "Saus Kedelai Lainnya",
    "Saus kedelai lainnya adalah saus yang bukan emulsi, dibuat dengan saus kedelai fermentasi atau tanpa fermentasi, dengan atau tanpa penambahan gula, dengan atau tanpa proses karamelisasi, dengan atau tanpa penambahan bahan pangan lain.",
    "Aktif",
  ],
  [
    120902030002,
    "Kecap Kedelai Manis (Sweet Soy Sauce)",
    "Kecap kedelai manis adalah produk berbentuk cair yang diperoleh dari hasil fermentasi kacang kedelai (Glycine max L.) atau bungkil kedelai ditambah gula dan/atau pemanis dengan atau tanpa penambahan bahan pangan lain.",
    "Aktif",
  ],
  [
    120902030003,
    "Kecap yang Dikeringkan/Bubuk Kecap (Fermented Soy Sauce Powder)",
    "Kecap yang dikeringkan/bubuk kecap (fermented soy sauce powder) adalah produk kering yang diperoleh dari pengeringan hasil fermentasi kedelai. Dapat mengandung bahan pangan lain. Karakteristik dasar : \x{2022} Kadar air tidak lebih dari 7%; \x{2022} Kadar NaCl tidak kurang dari 32% dan tidak lebih dari 36%.",
    "Aktif",
  ],
  [
    120902030004,
    "Kecap Pedas",
    "Kecap pedas adalah produk campuran kecap manis dengan cabe dengan atau tanpa penambahan bahan pangan lain.",
    "Aktif",
  ],
  [
    120902030005,
    "Kecap Bumbu",
    "Kecap bumbu adalah produk campuran kecap dan rempah-rempah dengan atau tanpa penambahan bahan pangan lain.",
    "Aktif",
  ],
  [
    120902030006,
    "Saus Campuran Protein Nabati Terhidrolisis",
    "Saus campuran protein nabati terhidrolisis adalah produk saus yang diperoleh dari campuran protein nabati terhidrolisis dengan cairan bening yang diperoleh dari fermentasi kacang kedelai (Glycine max) dan serealia atau tepung. Karakteristik dasar : \x{2022} Total nitrogen tidak kurang dari 0,3%; \x{2022} Kadar garam tidak kurang dari 3%.",
    "Aktif",
  ],
  [
    121000000001,
    "Produk Protein Gandum",
    "Produk protein gandum adalah produk yang diperoleh dengan cara pengurangan atau penghilangan komponen-komponen utama non-protein (air, minyak, pati dan karbohidrat lain) dari gandum atau tepung gandum. Ingredien yang dapat digunakan adalah karbohidrat termasuk gula, lemak dan minyak makan, produk protein lain, vitamin dan mineral, garam, herba dan rempah. Karakteristik dasar : Kadar protein (N x 5,83) tidak kurang dari 40% (bk) tanpa vitamin, mineral dan asam amino. ",
    "Aktif",
  ],
  [
    121000000002,
    "Hydrolised Vegetable Protein (HVP)",
    "Hydrolised vegetable protein (HVP) adalah produk protein mengandung asam amino yang diperoleh dari hidrolisis protein kedelai atau lainnya, dapat berbentuk cair atau bubuk.",
    "Aktif",
  ],
  [
    121000000003,
    "Produk Olahan Gluten",
    "Definisi :  Produk olahan gluten adalah produk protein yang diperoleh dari ekstraksi/isolasi protein gandum, rye, barley, dan triticale atau lainnya, dapat berbentuk cair atau padat.",
    "Aktif",
  ],
  [
    130101000001,
    "Formula Bayi (Padat)",
    "Formula Bayi adalah formula sebagai pengganti Air Susu Ibu (ASI) untuk bayi sampai umur 6 (enam) bulan yang secara khusus diformulasikan untuk menjadi satu-satunya sumber gizi dalam bulan-bulan pertama kehidupannya sampai bayi diperkenalkan dengan Makanan Pendamping Air Susu Ibu (MP-ASI).",
    "Aktif",
  ],
  [
    130101000002,
    "Formula Bayi (Cair)",
    "Formula Bayi adalah formula sebagai pengganti Air Susu Ibu (ASI) untuk bayi sampai umur 6 (enam) bulan yang secara khusus diformulasikan untuk menjadi satu-satunya sumber gizi dalam bulan-bulan pertama kehidupannya sampai bayi diperkenalkan dengan Makanan Pendamping Air Susu Ibu (MP-ASI).",
    "Aktif",
  ],
  [
    130102000001,
    "Formula Lanjutan",
    "Formula Lanjutan adalah adalah formula yang diperoleh dari susu sapi atau susu hewan lain dan/atau bahan yang berasal dari hewan dan/atau yang berasal dari tumbuh-tumbuhan yang semuanya telah dibuktikan sesuai untuk bayi usia 6 (enam) sampai 12 (dua belas) bulan.",
    "Aktif",
  ],
  [
    130102000002,
    "Formula Lanjutan",
    "Formula Lanjutan adalah adalah formula yang diperoleh dari susu sapi atau susu hewan lain dan/atau bahan yang berasal dari hewan dan/atau yang berasal dari tumbuh-tumbuhan yang semuanya telah dibuktikan sesuai untuk bayi usia 6 (enam) sampai 12 (dua belas) bulan.",
    "Aktif",
  ],
  [
    130102000003,
    "Formula Pertumbuhan ",
    "Formula Pertumbuhan adalah formula yang diperoleh dari susu sapi atau susu hewan lain dan/atau bahan yang berasal dari hewan dan/atau yang berasal dari tumbuh-tumbuhan yang semuanya telah dibuktikan sesuai untuk anak usia lebih dari 12 (dua belas) bulan sampai dengan 36 (tiga puluh enam) bulan.",
    "Aktif",
  ],
  [
    130102000004,
    "Formula Pertumbuhan ",
    "Formula Pertumbuhan adalah formula yang diperoleh dari susu sapi atau susu hewan lain dan/atau bahan yang berasal dari hewan dan/atau yang berasal dari tumbuh-tumbuhan yang semuanya telah dibuktikan sesuai untuk anak usia lebih dari 12 (dua belas) bulan sampai dengan 36 (tiga puluh enam) bulan.",
    "Aktif",
  ],
  [
    130103000001,
    "PKMK untuk Pasien Kelainan Metabolik (Inborn Errors of Metabolism)",
    "PKMK untuk Pasien Kelainan Metabolik (inborn errors of metabolism) adalah pangan yang diformulasikan secara khusus bagi pasien dengan penyakit kelainan genetik yang  menyebabkan gangguan metabolik (inborn errors of metabolism).",
    "Aktif",
  ],
  [
    130103000002,
    "PKMK untuk Pasien Kelainan Metabolik Isovaleric Acidemia",
    "PKMK untuk Pasien Kelainan Metabolik Isovaleric Acidemia adalah pangan yang diformulasikan secara khusus bagi pasien dengan penyakit kelainan genetik dimana tubuh  mempunyai keterbatasan dalam melakukan metabolisme asam amino leusin.",
    "Aktif",
  ],
  [
    130103000003,
    "PKMK untuk Pasien Kelainan Metabolik Tyrosinemia ",
    "PKMK untuk Pasien Kelainan Metabolik Tyrosinemia adalah pangan yang diformulasikan secara khusus bagi pasien dengan penyakit kelainan genetik dimana tubuh mempunyai keterbatasan dalam melakukan metabolisme asam amino fenilalanin dan tirosin.",
    "Aktif",
  ],
  [
    130103000004,
    "PKMK untuk Pasien Kelainan Metabolik Phenylketonuria (PKU) ",
    "PKMK untuk Pasien Kelainan Metabolik Phenylketonuria (PKU) adalah pangan yang diformulasikan secara khusus bagi pasien dengan penyakit kelainan genetik dimana tubuh  mempunyai keterbatasan dalam metabolisme asam amino fenilalanin.",
    "Aktif",
  ],
  [
    130103000005,
    "PKMK untuk Pasien Kelainan Metabolik Maple Syrup Urine Disease (MSUD)",
    "PKMK untuk Pasien Kelainan Metabolik Maple Syrup Urine Disease (MSUD) hanya dapat digunakan untuk pasien dengan penyakit kelainan genetik dimana tubuh mempunyai keterbatasan dalam melakukan metabolisme asam amino leusin, isoleusin, dan valin.",
    "Aktif",
  ],
  [
    130103000006,
    "PKMK untuk Dukungan Nutrisi bagi Anak Berisiko Gagal Tumbuh, Gizi Kurang atau Gizi Buruk (0-12 Bulan)",
    "PKMK untuk dukungan nutrisi bagi anak berisiko gagal tumbuh, gizi kurang atau gizi buruk adalah pangan yang diformulasikan secara khusus bagi anak berisiko atau  penderita gagal tumbuh, gizi kurang atau gizi buruk, dapat digunakan sebagai makanan pengganti ataupun makanan tambahan, dengan memperhitungkan kebutuhan dan asupan gizi per hari.",
    "Aktif",
  ],
  [
    130103000007,
    "PKMK untuk Dukungan Nutrisi bagi Anak Berisiko Gagal Tumbuh, Gizi Kurang atau Gizi Buruk (di Atas 1 tahun)",
    "PKMK untuk dukungan nutrisi bagi anak berisiko gagal tumbuh, gizi kurang atau gizi buruk adalah pangan yang diformulasikan secara khusus bagi anak berisiko atau  penderita gagal tumbuh, gizi kurang atau gizi buruk, dapat digunakan sebagai makanan pengganti ataupun makanan tambahan, dengan memperhitungkan kebutuhan dan asupan gizi per hari.",
    "Aktif",
  ],
  [
    130103000008,
    "PKMK untuk Bayi Prematur",
    "PKMK untuk Bayi Prematur diformulasi secara khusus dan disajikan sebagai tata laksana diet pasien bayi sehingga secara tunggal dapat memenuhi kebutuhan gizi pada bayi  sangat prematur dan/atau bayi berat lahir sangat rendah.  Bayi sangat prematur yang dimaksud dalam Peraturan ini adalah bayi yang lahir dengan usia kehamilan Ibu kurang dari 32 minggu.  Bayi berat lahir sangat rendah yang dimaksud dalam Peraturan ini adalah bayi berat lahir kurang dari 1500 g.",
    "Aktif",
  ],
  [
    130103000009,
    "PKMK untuk Pelengkap Gizi Air Susu Ibu (Human Milk Fortifier/HMF)",
    "Pelengkap Gizi ASI (HMF) untuk Bayi Prematur adalah pangan yang diformulasi bagi bayi secara khusus yang ditambahkan pada air susu ibu yang bertujuan sebagai pelengkap  kebutuhan zat gizi bagi bayi sangat prematur dan/atau bayi berat lahir sangat rendah.   Bayi sangat prematur yang dimaksud dalam Peraturan ini adalah bayi yang lahir dengan usia kehamilan Ibu kurang dari 32 minggu.  Bayi berat lahir sangat rendah yang dimaksud dalam Peraturan ini adalah bayi berat lahir kurang dari 1500 g.",
    "Aktif",
  ],
  [
    130103000010,
    "PKMK untuk Pasien Alergi Protein Susu Sapi (bagi bayi usia 0-6bulan)",
    "PKMK untuk pasien alergi protein susu sapi diformulasi secara khusus sebagai tata laksana diet sehingga dapat memenuhi kebutuhan gizi pada pada bayi/anak alergi protein  susu sapi.     PKMK untuk pasien alergi protein susu sapi terdiri dari:  a. Formula berbasis protein susu sapi terhidrolisis ekstensif; atau  b. Formula berbasis asam amino.",
    "Aktif",
  ],
  [
    130103000011,
    "PKMK untuk Pasien Alergi Protein Susu Sapi (bagi bayi 6 \x{2013} 12 bulan)",
    "PKMK untuk pasien alergi protein susu sapi diformulasi secara khusus sebagai tata laksana diet sehingga dapat memenuhi kebutuhan gizi pada pada bayi/anak alergi protein  susu sapi.     PKMK untuk pasien alergi protein susu sapi terdiri dari:  a. Formula berbasis protein susu sapi terhidrolisis ekstensif; atau  b. Formula berbasis asam amino.",
    "Aktif",
  ],
  [
    130103000012,
    "PKMK untuk Pasien Alergi Protein Susu Sapi (bagi anak usia 1-3 tahun)",
    "PKMK untuk pasien alergi protein susu sapi diformulasi secara khusus sebagai tata laksana diet sehingga dapat memenuhi kebutuhan gizi pada pada bayi/anak alergi protein  susu sapi.     PKMK untuk pasien alergi protein susu sapi terdiri dari:  a. Formula berbasis protein susu sapi terhidrolisis ekstensif; atau  b. Formula berbasis asam amino.",
    "Aktif",
  ],
  [
    130103000013,
    "PKMK untuk Diet Ketogenik Anak",
    "PKMK Diet Ketogenik adalah pangan yang diformulasikan secara khusus bagi pasien yang membutuhkan sumber energi utama yang berasal dari lemak.    PKMK Diet Ketogenik digunakan sebagai tatalaksana :  a. Epilepsi intraktabel.  b. Kelainan metabolik bawaan tertentu, antara lain :  ? defisiensi piruvat dehidrogenase, yaitu kelainan metabolisme bawaan yang disebabkan defisiensi enzim pyruvate dehydrogenase complex (PDHC) yang  menyebabkan kegagalan konversi piruvat menjadi asetil-koA, sehingga terjadi penumpukan laktat yang selanjutnya menyebabkan berbagai manifestasi klinis.  Defisiensi PDHC menghambat pembentukan energi dari oksidasi karbohidrat, sehingga konsumsi karbohidrat akan memperberat asidemia laktat.  ? defisiensi glukosa transporter tipe 1 (GLUT 1), yaitu kelainan metabolisme bawaan yang disebabkan defek/gangguan pada protein GLUT1, yang berperan memfasilitasi transpor glukosa melewati sawar darah otak. Defek/gangguan ini menyebabkan kadar glukosa otak rendah dan menyebabkan berbagai manifestasi klinis, antara lain kejang.  c. Kelainan medis lain dimana diperlukan diet ketogenik.",
    "Aktif",
  ],
  [
    130103000014,
    "PKMK untuk Bayi Intoleransi Laktosa",
    "PKMK untuk Bayi Intoleransi Laktosa adalah pangan yang diformulasikan secara khusus bagi bayi yang mengalami intoleransi laktosa.",
    "Aktif",
  ],
  [130103000015, "PKMK untuk Pasien Malabsorpsi", "", "Aktif"],
  [
    130103000016,
    "PKMK untuk Pasien Inflammatory Bowel Diseases",
    "",
    "Aktif",
  ],
  [130103000017, "PKMK untuk Pasien Malabsorpsi", "", "Nonaktif"],
  [
    130200000001,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi",
    "MP-ASI Pokok adalah makanan bergizi yang diberikan disamping Air Susu Ibu yang diberikan pada waktu makan kepada bayi berusia 6 (enam) bulan keatas sampai anak usia  24 (dua puluh empat) bulan atau di luar rentang usia tersebut berdasarkan indikasi medis, untuk mencapai kecukupan gizi.",
    "Aktif",
  ],
  [
    130200000002,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok - Siap Masak",
    "MP-ASI Pokok adalah makanan bergizi yang diberikan disamping Air Susu Ibu yang diberikan pada waktu makan kepada bayi berusia 6 (enam) bulan keatas sampai anak usia  24 (dua puluh empat) bulan atau di luar rentang usia tersebut berdasarkan indikasi medis, untuk mencapai kecukupan gizi.",
    "Aktif",
  ],
  [
    130200000003,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Kudapan",
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Kudapan adalah makanan bergizi yang diberikan disamping Air Susu Ibu dan MP-ASI pokok yang diberikan diantara dua waktu makan kepada bayi berusia 6 (enam) bulan keatas sampai anak usia 24 (dua puluh empat) bulan atau di luar rentang usia tersebut berdasarkan indikasi medis, untuk mencapai kecukupan gizi.",
    "Aktif",
  ],
  [
    130200000004,
    "Makanan Selingan Untuk Anak",
    "Makanan selingan untuk anak adalah makanan yang diberikan untuk anak usia 1 (satu) sampai usia 3 (tiga) tahun di antara waktu makan.",
    "Aktif",
  ],
  [
    130200000005,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi (Bubuk Instan)",
    "MP-ASI Pokok adalah makanan bergizi yang diberikan disamping Air Susu Ibu yang diberikan pada waktu makan kepada bayi berusia 6 (enam) bulan keatas sampai anak usia 24 (dua puluh empat) bulan atau di luar rentang usia tersebut berdasarkan indikasi medis, untuk mencapai kecukupan gizi. ",
    "Aktif",
  ],
  [
    130300000001,
    "PKMK untuk Penyandang Diabetes",
    "PKMK untuk Penyandang Diabetes adalah pangan yang  diformulasikan secara khusus bagi penyandang diabetes, dapat digunakan sebagai makanan pengganti ataupun makanan tambahan, dengan memperhitungkan kebutuhan dan asupan gizi per hari penyandang diabetes.",
    "Aktif",
  ],
  [
    130300000002,
    "PKMK untuk Pasien Penyakit Ginjal Kronik Pradialisis)",
    "PKMK untuk Pasien Penyakit Ginjal Kronik adalah pangan yang diformulasikan secara khusus bagi pasien penyakit ginjal kronik, dapat digunakan sebagai makanan pengganti  ataupun makanan tambahan, dengan memperhitungkan kebutuhan dan asupan gizi per hari pasien penyakit ginjal kronik.",
    "Aktif",
  ],
  [
    130300000003,
    "PKMK untuk Pasien Penyakit Ginjal Kronik (dengan Terapi Dialisis)",
    "PKMK untuk Pasien Penyakit Ginjal Kronik adalah pangan yang diformulasikan secara khusus bagi pasien penyakit ginjal kronik, dapat digunakan sebagai makanan pengganti  ataupun makanan tambahan, dengan memperhitungkan kebutuhan dan asupan gizi per hari pasien penyakit ginjal kronik.",
    "Aktif",
  ],
  [
    130300000004,
    "PKMK untuk Pasien Penyakit Hati Kronik",
    "PKMK untuk Pasien Penyakit Hati Kronik adalah pangan yang diformulasikan secara khusus bagi pasien penyakit hati kronik, antara lain sirosis, kanker hati baik dengan ensefalopati hepatik ataupun tidak, dan dapat digunakan sebagai makanan pengganti ataupun makanan tambahan, dengan memperhitungkan kebutuhan dan asupan gizi per hari pasien penyakit ginjal kronik.",
    "Aktif",
  ],
  [
    130300000005,
    "PKMK untuk Pasien Penyakit Hati Kronik dengan Ensefalopati Hepatik (EH)",
    "PKMK untuk Pasien Penyakit Hati Kronik adalah pangan yang diformulasikan secara khusus bagi pasien penyakit hati kronik, antara lain sirosis, kanker hati baik dengan ensefalopati hepatik, dan dapat digunakan sebagai makanan pengganti ataupun makanan tambahan, dengan memperhitungkan kebutuhan dan asupan gizi per hari pasien penyakit ginjal kronik.",
    "Aktif",
  ],
  [
    130300000006,
    "PKMK untuk Dukungan Nutrisi bagi Pasien Dewasa Malnutrisi",
    "PKMK Dukungan Nutrisi Bagi Pasien Dewasa Malnutrisi adalah pangan yang diformulasikan secara khusus bagi pasien dewasa malnutrisi, dapat digunakan sebagai makanan pengganti ataupun makanan tambahan, dengan memperhitungkan kebutuhan dan asupan gizi per hari.    PKMK Dukungan Nutrisi Bagi Pasien Dewasa Malnutrisi digunakan sebagai tatalaksana :  a. Malnutrisi gizi kurang.  b. Malnutrisi gizi buruk.  c. Kondisi medis lain yang berisiko malnutrisi misalnya diare, mual, muntah, kurang nafsu makan, atau karena kondisi pasca operasi, penyakit kanker, dan gangguan pencernaan.",
    "Aktif",
  ],
  [
    130300000007,
    "PKMK untuk Diet Ketogenik",
    "PKMK Diet Ketogenik adalah pangan yang diformulasikan secara khusus bagi pasien yang membutuhkan sumber energi utama yang berasal dari lemak.    PKMK Diet Ketogenik digunakan sebagai tatalaksana :  a. Epilepsi intraktabel.  b. Kelainan metabolik bawaan tertentu, antara lain :  ? defisiensi piruvat dehidrogenase, yaitu kelainan metabolisme bawaan yang disebabkan defisiensi enzim pyruvate dehydrogenase complex (PDHC) yang  menyebabkan kegagalan konversi piruvat menjadi asetil-koA, sehingga terjadi penumpukan laktat yang selanjutnya menyebabkan berbagai manifestasi klinis.  Defisiensi PDHC menghambat pembentukan energi dari oksidasi karbohidrat, sehingga konsumsi karbohidrat akan memperberat asidemia laktat.  ? defisiensi glukosa transporter tipe 1 (GLUT 1), yaitu kelainan metabolisme bawaan yang disebabkan defek/gangguan pada protein GLUT1, yang berperan memfasilitasi transpor glukosa melewati sawar darah otak. Defek/gangguan ini menyebabkan kadar glukosa otak rendah dan menyebabkan berbagai manifestasi klinis, antara lain kejang.  c. Kelainan medis lain dimana diperlukan diet ketogenik.",
    "Aktif",
  ],
  [
    130300000008,
    "PKMK untuk Pasien Kelainan Metabolik (Inborn Errors of Metabolism)",
    "PKMK untuk Pasien Kelainan Metabolik (inborn errors of metabolism) adalah pangan yang diformulasikan secara khusus bagi pasien dengan penyakit kelainan genetik yang  menyebabkan gangguan metabolik (inborn errors of metabolism).",
    "Aktif",
  ],
  [
    130300000009,
    "PKMK untuk Anak (Program Pemerintah)",
    "PKMK untuk Anak Program Pemerintah adalah Pangan Olahan yang diformulasikan khusus sebagai pelaksanaan program pemerintah terkait gizi dan kesehatan anak.",
    "Aktif",
  ],
  [
    130300000010,
    "PKMK untuk Dewasa (Program Pemerintah)",
    "PKMK untuk Dewasa Program Pemerintah adalah Pangan Olahan yang diformulasikan khusus sebagai pelaksanaan program pemerintah terkait gizi dan kesehatan target masyarakat tertentu.",
    "Aktif",
  ],
  [
    130500000001,
    "Minuman Khusus Ibu Hamil  ",
    "Minuman Khusus Ibu Hamil adalah produk berbentuk bubuk maupun cair, khusus untuk ibu hamil mengandung energi, protein, lemak, karbohidrat, vitamin dan mineral yang diperhitungkan berdasarkan tambahan kecukupan gizi yang dianjurkan untuk kelompok tersebut, dengan atau tanpa penambahan komponen bioaktif dan atau bahan tambahan pangan yang diizinkan.",
    "Aktif",
  ],
  [
    130500000002,
    "Minuman Khusus Ibu Menyusui ",
    "Minuman Khusus Ibu Menyusui adalah produk berbentuk bubuk maupun cair, khusus untuk ibu menyusui mengandung energi, protein, lemak, karbohidrat, vitamin dan mineral yang diperhitungkan berdasarkan tambahan kecukupan gizi yang dianjurkan untuk kelompok tersebut, dengan atau tanpa penambahan komponen bioaktif dan atau bahan tambahan pangan yang diizinkan.",
    "Aktif",
  ],
  [
    130500000003,
    "Minuman Olahraga",
    "Minuman Olahraga adalah minuman khusus yang diperuntukkan bagi orang yang melakukan olahraga endurance dengan mempertimbangkan kandungan cairan, elektrolit, dan  energi digunakan untuk secara cepat menggantikan cairan tubuh, elektrolit dan energi sehingga dapat meningkatkan, mempertahankan dan memulihkan tenaga pada olahraga endurance.   Olahraga endurance adalah olahraga yang bersifat berat dengan durasi lama (=1jam) dengan pengeluaran keringat yang banyak misalnya olahraga dengan kecepatan yaitu  maraton, balap sepeda jarak jauh, triatlon, dan duatlon, atau olahraga permainan dalam waktu lama seperti tenis, bulutangkis, bola voli, sepak bola, renang jarak jauh dan lain-lain.",
    "Aktif",
  ],
  [
    130500000004,
    "Pangan Tambahan Untuk Olahragawan Berbasis Karbohidrat",
    "Pangan Tambahan untuk Olahragawan merupakan produk yang disajikan dalam bentuk makanan yang terbuat dari bahan-bahan yang telah terbukti secara ilmiah aman dan memenuhi kecukupan gizi untuk membantu olahragawan mencapai performa yang optimal.   Pangan Tambahan untuk Olahragawan Berbasis Karbohidrat digunakan untuk:  a. sebelum, selama, dan setelah latihan berkelanjutan berat.  b. pembentukkan energi dalam bentuk karbohidrat.",
    "Aktif",
  ],
  [
    130500000005,
    "Pangan Tambahan Untuk Olahragawan Berbasis Protein",
    "Pangan Tambahan untuk Olahragawan merupakan produk yang disajikan dalam bentuk makanan yang terbuat dari bahan-bahan yang telah terbukti secara ilmiah aman dan memenuhi kecukupan gizi untuk membantu olahragawan mencapai performa yang optimal.   Pangan Tambahan untuk Olahragawan Berbasis Protein digunakan untuk:  a. memberikan diet rendah massal (low-bulk) yang mungkin diperlukan selama pelatihan.  b. produk dapat membantu dalam melengkapi diet dengan sumber energi tinggi yang mungkin diperlukan selama pelatihan.  c. penggunaan seperti yang diarahkan dapat membantu dalam pengembangan otot massal.  d. produk berguna sebelum, selama, atau setelah latihan berat berkelanjutan.",
    "Aktif",
  ],
  [
    130500000006,
    "Pangan Tambahan Untuk Olahragawan Tinggi Energi Protein",
    "Pangan Tambahan untuk Olahragawan merupakan produk yang disajikan dalam bentuk makanan yang terbuat dari bahan-bahan yang telah terbukti secara ilmiah aman dan memenuhi kecukupan gizi untuk membantu olahragawan mencapai performa yang optimal.   Pangan Tambahan untuk Olahragawan Tinggi Energi Protein digunakan hanya untuk olahraga dengan kinerja otot yang besar, antara lain: binaraga, angkat besi, sprint (lari 100m, dayung, renang), olahraga tarung dan lain-lain.",
    "Aktif",
  ],
  [
    130500000007,
    "Pangan Diet Khusus untuk Kontrol Berat Badan",
    "Pangan Diet Khusus untuk Kontrol Berat Badan merupakan pangan yang diformulasikan secara khusus untuk mengendalikan/mengontrol berat badan pada orang dengan  berat badan berlebih tanpa penyakit penyerta.     Kriteria berat badan berlebih:  ? IMT =23 kg/m2; atau  ? lingkar pinggang laki-laki = 90 cm dan perempuan = 80 cm.    Penyakit penyerta berupa : diabetes, hipertensi, dislipidemia, penyakit kardiovaskular, gangguan fungsi hati, gangguan fungsi ginjal, dll.",
    "Aktif",
  ],
  [
    140101010001,
    "Air Mineral Alami",
    "Definisi :  Air mineral alami adalah air minum yang diperoleh langsung dari air sumber alami atau di bor dari sumur dalam dengan proses terkendali yang menghindari pencemar atau pengaruh luar atas sifat kimia, fisika, dan mikrobiologi air mineral alami.  Klasifikasi air mineral alami yaitu:  a. Air mineral alami berkarbonasi alami: Air mineral alami yang secara alami mengandung karbondioksida pada suhu dan tekanan normal.  b. Air mineral alami tanpa karbonasi: Air mineral alami yang tidak mengandung karbondioksida bebas setelah dikemas.  c. Air mineral alami dekarbonasi: Air mineral alami yang mengandung karbondioksida lebih rendah dari sumbernya setelah dikemas.  d. Air mineral alami fortifikasi dengan karbon dioksida dari sumbernya: Air mineral alami dengan penambahan karbondioksida yang berasal dari sumbernya dan kandungan karbondioksida setelah dikemas lebih tinggi dari sumbernya.  e. Air mineral alami dikarbonasi: Air mineral alami yang ditambahkan karbondioksida dari sumber lain.",
    "Aktif",
  ],
  [
    140101020001,
    "Air Mineral",
    "Definisi :  Air mineral adalah air minum dalam kemasan yang mengandung mineral dalam jumlah tertentu tanpa menambahkan mineral, dengan atau tanpa penambahan oksigen (O2) atau karbondioksida (CO2).",
    "Aktif",
  ],
  [
    140101020002,
    "Air Demineral",
    "Definisi :  Air demineral adalah air minum dalam kemasan yang diperoleh melalui proses pemurnian secara destilasi, deionisasi, reverse osmosis, dan atau proses setara lainnya dan dapat ditambahkan oksigen (O2) atau karbondioksida (CO2).",
    "Aktif",
  ],
  [
    140101020003,
    "Air Minum Embun",
    "Definisi :  Air minum embun adalah air minum yang diperoleh dari proses pengembunan uap air dari udara lembab menjadi tetesan air embun yang diolah lebih lanjut menjadi air minum embun yang dikemas.",
    "Aktif",
  ],
  [
    140101020004,
    "Air Minum Embun/Mineral/Demineral Beroksigen",
    "Definisi :  Air yang dikemas di dalam botol atau bentuk kemasan lainnya dan ditambahkan gas oksigen.  Karakteristik dasar :  \x{2022} Kadar O2 terlarut di pabrik tidak kurang dari 40 mg/L  \x{2022} Kadar O2 terlarut di pasaran tidak kurang dari 20 mg/L",
    "Aktif",
  ],
  [
    140101020005,
    "Air Minum Embun/Mineral/Demineral Berkarbonat",
    "Definisi :  Air yang dikemas di dalam botol atau bentuk kemasan lainnya dan ditambahkan gas karbondioksida.  Karakteristik dasar :  Kadar CO2 tidak lebih dari 5.890 mg/L",
    "Aktif",
  ],
  [
    140101020006,
    "Air Soda",
    "Definisi :  Air soda adalah air minum yang mengandung gas karbondioksida, tidak berwarna, tidak berbau.  Karakteristik dasar :  Kadar CO2 tidak kurang dari 5.890 mg/L",
    "Aktif",
  ],
  [
    140101020007,
    "Air Minum pH Tinggi",
    "Definisi :  Air minum pH tinggi adalah air minum yang mengandung mineral dalam jumlah tertentu tanpa menambahkan mineral, dengan atau tanpa penambahan oksigen (O2) atau karbondioksida (CO2), dan memiliki pH tinggi.  Karakteristik dasar :  \x{2022} pH antara 8,6 \x{2013} 9,5  \x{2022} memenuhi persyaratan mutu air mineral (selain pH)",
    "Aktif",
  ],
  [
    140101020008,
    "Air Minum Olahan dengan Penambahan Garam Mineral",
    "",
    "Aktif",
  ],
  [
    140102010001,
    "Sari Buah",
    "Definisi :  Sari buah adalah cairan yang diperoleh dari bagian buah yang dapat dimakan yang dicuci, dihancurkan, dijernihkan (jika dibutuhkan), dengan atau tanpa pasteurisasi dan dikemas untuk dapat dikonsumsi langsung.   Karakteristik dasar :  \x{2022} Kadar etanol tidak lebih dari 0,5%, kecuali sari buah yang ditetapkan kadar etanolnya sendiri;  \x{2022} Dapat ditambahkan konsentrat ke dalam sari buah dari jenis buah yang sama;  \x{2022} Dapat ditambahkan gula, tidak lebih dari 50 g/kg.",
    "Aktif",
  ],
  [
    140102010002,
    "Sari Buah Campuran",
    "Definisi :  Sari buah campuran adalah produk buah yang diperoleh dari dua  atau lebih jenis buah segar yang masak atau daging buah yang  diawetkan secara fisik, tidak difermentasi tetapi dapat terfermentasi,  berisi hancuran buah, keruh atau jernih, ditujukan untuk  dikonsumsi langsung. Sari buah diperoleh dengan proses mekanik  atau dapat diperoleh dari rekonstitusi sari buah konsentrat.  Sari buah dapat dipekatkan dan direkonstitusi dengan air untuk  mempertahankan komposisi esensial dan faktor mutu dari sari  buah.",
    "Aktif",
  ],
  [
    140102010003,
    "Sari Buah dan Sari Sayur",
    "Definisi :  Sari buah dan sari sayur adalah produk yang terdiri dari campuran sari buah dan sari sayur. Kandungan sari buah lebih banyak daripada sari sayur.",
    "Aktif",
  ],
  [
    140102010004,
    "Sari Jeruk Nipis (Lime Juice)",
    "Definisi :  Sari jeruk nipis adalah produk sari buah yang diperoleh dari jeruk nipis masak spesies Citrus aurantifolia atau varietas turunannya.  Karakteristik dasar:  \x{2022} Total padatan tidak kurang dari 8 % (b/v);  \x{2022} Total asam (sebagai asam sitrat anhidrat) tidak kurang dari 6% (b/v);  \x{2022} Dengan level brix untuk sari buah rekonstitusi dan puree rekonstitusi tidak kurang dari 8,0\xB0Brix (20\xB0C).",
    "Aktif",
  ],
  [
    140102010005,
    "Sari Buah Apel",
    "Definisi :  Sari jeruk nipis adalah produk sari buah yang diperoleh dari jeruk nipis masak spesies Citrus aurantifolia atau varietas turunannya.  Karakteristik dasar:  \x{2022} Total padatan tidak kurang dari 8 % (b/v);  \x{2022} Total asam (sebagai asam sitrat anhidrat) tidak kurang dari 6% (b/v);  \x{2022} Dengan level brix untuk sari buah rekonstitusi dan puree rekonstitusi tidak kurang dari 8,0\xB0Brix (20\xB0C).",
    "Aktif",
  ],
  [
    140102010006,
    "Sari Buah Jeruk Bali",
    "Definisi :  Sari buah jeruk Bali adalah produk sari buah yang diperoleh dari jeruk Bali masak spesies Citrus grandis dan varietasnya.   Karakteristik dasar :  \x{2022} Total padatan tidak kurang dari 9,5% (b/v)  \x{2022} Total asam (sebagai asam sitrat anhidrat) 1 g hingga 2 g   \x{2022} Total padatan terlarut tidak kurang dari 7 g untuk setiap gram asam yang dihitung sebagai asam sitrat anhidrat",
    "Aktif",
  ],
  [
    140102010007,
    "Sari Buah Jeruk Orange, Valencia",
    "Definisi :  Sari buah jeruk orange, Valencia adalah produk sari buah yang diperoleh dari endokarp buah jeruk (Citrus sinensis L Osbeck) yang masak tanpa fermentasi, diawetkan secara fisik. Sari jeruk juga dapat diperoleh dengan rekonstitusi konsentrat sari buah jeruk.  Karakteristik dasar :  \x{2022} Total padatan tidak kurang dari 10%  \x{2022} Jika sari buah diperoleh dari padatan sari buah yang diencerkan dengan air, maka total padatan tidak kurang dari 11%  \x{2022} Kadar etanol tidak lebih dari 0,3%",
    "Aktif",
  ],
  [
    140102010008,
    "Sari Buah Jeruk Siam, Tangerine, Jeruk Pontianak",
    "Definisi :  Sari buah jeruk siam, tangerine adalah produk sari buah yang diperoleh dari endokarp buah jeruk tangerine (Citrus reticulata Blanco) yang masak, tanpa fermentasi, diawetkan secara fisik. Sari jeruk juga dapat diperoleh dengan rekonstitusi konsentrat sari buah jeruk.  Karakteristik dasar :  \x{2022} Total padatan tidak kurang dari 10%  \x{2022} Jika sari buah diperoleh dari padatan sari buah yang diencerkan dengan air, maka total padatan tidak kurang dari 11%  \x{2022} Kadar etanol tidak lebih dari 0,3%",
    "Aktif",
  ],
  [
    140102010009,
    "Sari Buah Jeruk Garut",
    "Definisi :  Sari buah jeruk Garut adalah produk sari buah yang diperoleh dari endokarp buah jeruk Garut (Citrus nobilis) yang masak, tanpa fermentasi, diawetkan secara fisik. Sari jeruk juga dapat diperoleh dengan rekonstitusi konsentrat sari buah jeruk.  Karakteristik dasar :  \x{2022} Total padatan tidak kurang dari 10%  \x{2022} Jika sari buah diperoleh dari padatan sari buah yang diencerkan dengan air, maka total padatan tidak kurang dari 11%  \x{2022} Kadar etanol tidak lebih dari 0,3%",
    "Aktif",
  ],
  [
    140102010010,
    "Sari Buah Jeruk Medan",
    "Definisi :  Sari buah jeruk Medan adalah produk sari buah yang diperoleh dari endokarp buah jeruk Medan (Citrus sinensis (L)) yang masak, tanpa fermentasi, diawetkan secara fisik. Sari jeruk juga dapat diperoleh dengan rekonstitusi konsentrat sari buah jeruk.   Karakteristik dasar :  \x{2022} Total padatan tidak kurang dari 10%  \x{2022} Jika sari buah diperoleh dari padatan sari buah yang diencerkan dengan air, maka total padatan tidak kurang dari 11%  \x{2022} Kadar etanol tidak lebih dari 0,3%",
    "Aktif",
  ],
  [
    140102010011,
    "Sari Buah Nanas",
    "Definisi :  Sari buah nanas adalah produk sari buah yang diperoleh dari buah nanas (Ananas comocsus L Merril, Ananas sativus L Lindii) yang masak, tanpa fermentasi, diawetkan secara fisik. Sari nanas juga dapat diperoleh dengan rekonstitusi konsentrat sari nanas.  Karakteristik dasar :  \x{2022} Total padatan tidak kurang dari 10%  \x{2022} Jika sari buah diperoleh dari padatan sari buah yang diencerkan dengan air, total padatan tidak kurang dari 13,5%.",
    "Aktif",
  ],
  [
    140102010012,
    "Sari Buah Lemon",
    "Definisi :  Sari buah lemon adalah produk sari buah yang diperoleh dari endokarp buah lemon (Lemon burf) yang masak, tanpa fermentasi, diawetkan secara fisik. Sari buah lemon juga dapat diperoleh dengan rekonstitusi konsentrat sari lemon.  Karakteristik dasar :  \x{2022} Total padatan tidak kurang dari 6%  \x{2022} Total asam tertitrasi (sebagai asam sitrat anhidrat) tidak kurang dari 4,5%",
    "Aktif",
  ],
  [
    140102010013,
    "Sari Buah Markisa",
    "Definisi :  Sari buah markisa adalah produk sari buah yang diperoleh dari buah markisa masak dari spesies Passiflora sp.  Karakteristik dasar :  \x{2022} Total padatan tidak kurang dari 12% (b/v)  \x{2022} Total asam (sebagai asam sitrat anhidrat) 1,5% hingga 4,5% (b/v)",
    "Aktif",
  ],
  [
    140102010014,
    "Sari Buah Anggur",
    "Definisi :  Sari buah anggur adalah sari buah yang diperoleh dari buah anggur (Vitis sp.) matang atau dari pengenceran konsentrat sari buah anggur, tanpa fermentasi, dan diawetkan.  Karakteristik dasar :  \x{2022} pH tidak lebih dari 4  \x{2022} Total padatan terlarut tidak kurang dari 15%",
    "Aktif",
  ],
  [
    140102010015,
    "Sari Buah Prune (Prune Juice)",
    "Definisi :  Sari buah prune adalah produk sari buah yang diperoleh dari ekstrak air buah prune (Prunus domestica L. Subsp. domestica) kering. Jumlah padatan terlarut dari buah prune dapat dicapai dengan pemekatan, pengenceran dari ekstrak buah atau rekonstitusi konsentrat.  Karakteristik dasar :  Total padatan terlarut tidak kurang dari 18,5%",
    "Aktif",
  ],
  [
    140102010016,
    "Sari Buah Blackcurrant",
    "Definisi :  Sari buah blackcurrant adalah produk sari buah cair yang keruh atau jernih yang diperoleh dari buah blackcurrant (Ribes nigrum L.) yang masak tanpa fermentasi, diawetkan secara fisika. Sari blackcurrant juga dapat diperoleh dengan rekonstitusi konsentrat sari blackcurrant.  Karakteristik dasar :  \x{2022} Total padatan terlarut tidak kurang dari 11% yang diukur dengan refraktometer pada 20\xB0C, dibaca sebagai \xB0Brix dalam skala sukrosa internasional tanpa koreksi keasaman  \x{2022} Kadar etanol tidak lebih dari 0,3%",
    "Aktif",
  ],
  [
    140102010017,
    "Sari Buah Mangga",
    "Definisi :  Sari buah mangga adalah produk sari buah yang diperoleh dari buah mangga (Mangifera indica L.).  Karakteristik dasar :  Level brix untuk sari buah rekonstitusi dan puree rekonstitusi tidak kurang dari 13,0.",
    "Aktif",
  ],
  [
    140102010018,
    "Sari Buah Sirsak",
    "Definisi :  Sari buah sirsak adalah produk sari buah yang diperoleh dari buah sirsak (Annona muricata L.).  Karakteristik dasar :  Level brix untuk sari buah rekonstitusi dan puree rekonstitusi tidak kurang dari 12,0.",
    "Aktif",
  ],
  [
    140102010019,
    "Sari Buah Belimbing",
    "Definisi :  Sari buah belimbing adalah produk sari buah yang diperoleh dari buah belimbing (Averrhoa carambola L.).  Karakteristik dasar :  Level brix untuk sari buah rekonstitusi dan puree rekonstitusi tidak kurang dari 7,5.",
    "Aktif",
  ],
  [
    140102010020,
    "Sari Buah Plum",
    "Definisi :  Sari buah plum adalah produk sari buah yang diperoleh dari buah plum (Prunus domestica L. Subsp. Domestica.).  Karakteristik dasar :  Level brix untuk sari buah rekonstitusi dan puree rekonstitusi tidak kurang dari 12,0.",
    "Aktif",
  ],
  [
    140102010021,
    "Sari Buah Peach",
    "Definisi :  Sari buah peach adalah produk sari buah yang diperoleh dari buah peach (Prumus persica (L) Batch var. nucipersica).  Karakteristik dasar :  Level brix untuk sari buah rekonstitusi dan puree rekonstitusi tidak kurang dari 10,5.",
    "Aktif",
  ],
  [
    140102010022,
    "Sari Buah Jambu Biji",
    "Definisi :  Sari buah jambu biji adalah produk sari buah yang diperoleh dari buah jambu biji (Psidium guajava L.).  Karakteristik dasar :  Level brix untuk sari buah rekonstitusi dan puree rekonstitusi tidak kurang dari 7,5 untuk jambu biji merah dan 9,0 untuk jambu biji putih.",
    "Aktif",
  ],
  [
    140102010023,
    "Sari Buah Delima",
    "Definisi :  Sari buah delima adalah produk sari buah yang diperoleh dari buah delima (Punica sp.).  Karakteristik dasar :  Level brix untuk sari buah rekonstitusi dan puree rekonstitusi tidak kurang dari 12,0.",
    "Aktif",
  ],
  [
    140102010024,
    "Sari Buah Pir",
    "Definisi :  Sari buah pir adalah produk sari buah yang diperoleh dari buah pir (Pyrus communis.).  Karakteristik dasar :  Level brix untuk sari buah rekonstitusi dan puree rekonstitusi tidak kurang dari 12,0.",
    "Aktif",
  ],
  [
    140102010025,
    "Sari Buah Redcurrant",
    "Definisi :  Sari buah redcurrant adalah produk sari buah yang diperoleh dari buah redcurrant (Ribes rubrum).  Karakteristik dasar :  Level brix untuk sari buah rekonstitusi dan puree rekonstitusi tidak kurang dari 10,0.",
    "Aktif",
  ],
  [
    140102010026,
    "Sari Buah Blackberry",
    "Definisi :  Sari buah blackberry adalah produk sari buah yang diperoleh dari buah blackberry (Rubus fruitcosus L.).   Karakteristik dasar :  Level brix untuk sari buah rekonstitusi dan puree rekonstitusi tidak kurang dari 9,0.",
    "Aktif",
  ],
  [
    140102010027,
    "Sari Buah Raspberry",
    "Definisi :  Sari buah raspberry adalah produk sari buah yang diperoleh dari buah raspberry (Rubus occidentalis L.).  Karakteristik dasar :  Level brix untuk sari buah rekonstitusi dan puree rekonstitusi tidak kurang dari 11,0.",
    "Aktif",
  ],
  [
    140102010028,
    "Sari Buah Stroberi",
    "Definisi :  Sari buah stroberi adalah produk sari buah yang diperoleh dari buah stroberi (Fragaria rosaceae).  Karakteristik dasar :  Level brix untuk sari buah rekonstitusi dan puree rekonstitusi tidak kurang dari 7,0.",
    "Aktif",
  ],
  [
    140102010029,
    "Sari Buah Blueberry",
    "Definisi :  Sari buah blueberry adalah produk sari buah yang diperoleh dari buah blueberry (Vaccinium myrtillus L. atau Vaccinium corymbosum L. atau Vaccinium angustifolium L.).  Karakteristik dasar :  Level brix untuk sari buah rekonstitusi dan puree rekonstitusi tidak kurang dari 10,0.",
    "Aktif",
  ],
  [
    140102010030,
    "Sari Buah Manggis",
    "Definisi :  Sari buah manggis adalah produk sari buah yang diperoleh dari buah manggis (Garcinia mangostana L).",
    "Aktif",
  ],
  [
    140102010031,
    "Sari Buah Terong Belanda",
    "Definisi :  Sari buah terong belanda adalah produk sari buah yang diperoleh dari buah terong belanda (Solanum betaceum).",
    "Aktif",
  ],
  [
    140102010032,
    "Sari Buah Leci",
    "Definisi :  Sari buah leci adalah produk sari buah yang diperoleh dari buah leci (Litchi chinensis Sonn.).  Karakteristik dasar:  Level brix untuk sari buah rekonstitusi dan puree rekonstitusi tidak kurang dari 11,0.",
    "Aktif",
  ],
  [
    140102010033,
    "Sari Buah Kiwi",
    "Definisi :  Sari buah kiwi adalah produk sari buah yang diperoleh dari buah kiwi (Actinidia deliciosa).",
    "Aktif",
  ],
  [
    140102010034,
    "Sari Buah Naga",
    "Definisi :  Sari buah naga adalah produk sari buah yang diperoleh dari buah naga (Hylocereus undatus).",
    "Aktif",
  ],
  [
    140102010035,
    "Sari Sayur",
    "Definisi :  Sari sayur adalah produk yang diperoleh dari tanaman sayur termasuk akar, umbi (seperti wortel, bawang putih dan kentang), batang dan tunas (seperti asparagus), daun dan bunga (seperti bayam, bunga kol) dan biji polong (seperti buncis).     Karakteristik dasar :  Mineral tidak larut dalam HCl 10% tidak lebih dari 100 mg/kg.",
    "Aktif",
  ],
  [
    140102010036,
    "Sari Tomat",
    "Definisi :  Sari tomat adalah produk sari sayur yang diperoleh dari bagian yang dapat dimakan dari buah tomat (Lycopersicum esculentum L.) merah atau kemerahan, yang diawetkan secara fisik (tidak termasuk iradiasi), tidak difermentasi tetapi dapat terfermentasi, ditujukan untuk dapat dikonsumsi langsung. Sari tomat bebas dari kulit, biji dan bagian berupa partikel besar lain dari tomat.  Karakteristik dasar :  Total padatan terlarut tomat tidak kurang dari 4,5% yang diukur dengan refraktometer pada 20\\xB0C.",
    "Aktif",
  ],
  [
    140102010037,
    "Sari Wortel",
    "Definisi :  Sari wortel adalah produk sari sayur yang diperoleh dari bagian yang dapat dimakan dari buah wortel (Daucus carota L.), yang diawetkan secara fisik (tidak termasuk iradiasi), tidak difermentasi tetapi dapat terfermentasi, ditujukan untuk dapat dikonsumsi langsung.",
    "Aktif",
  ],
  [
    140102010038,
    "Sari Sayur Campuran",
    "Definisi :  Sari sayur campuran adalah produk sayur yang diperoleh dari dua atau lebih jenis sayur segar atau sayur yang diawetkan secara fisik, tidak difermentasi tetapi dapat terfermentasi, berisi hancuran sayur, berwarna keruh atau jernih, ditujukan untuk dikonsumsi langsung. Sari sayur diperoleh dengan proses mekanik.  Sari sayur campuran dapat dipekatkan dan direkonstitusi dengan air yang untuk mempertahankan komposisi esensial dan faktor mutu dari sari sayur.",
    "Aktif",
  ],
  [
    140102010039,
    "Sari Sayur dan Sari Buah",
    "Definisi :  Sari sayur dan sari buah adalah produk yang terdiri dari campuran sari sayur dan sari buah. Kandungan sari sayur lebih banyak daripada sari buah.",
    "Aktif",
  ],
  [
    140102030001,
    "Konsentrat Sari Buah Jeruk Orange, Valencia",
    "Definisi :  Konsentrat sari buah jeruk orange, valencia adalah produk yang belum difermentasi, dapat difermentasi setelah direkonstitusi, diawetkan secara fisik (tidak termasuk iradiasi), diperoleh melalui proses konsentrasi, yaitu penghilangan air hingga produk mempunyai total padatan tidak kurang dari 20% yang diukur dengan refraktometer pada suhu 20\xB0C.     Karakteristik dasar :  Sari buah jeruk yang diperoleh setelah rekonstitusi konsentrat :  \x{2022} Memiliki karakteristik dasar yang sama dengan karakteristik  dasar sari buah jeruk, kecuali total padatan sari jeruk tidak  kurang dari 11% (diluar gula yang ditambahkan) yang diukur  dengan refraktometer pada 20\xB0C, dibaca sebagai \xB0Brix dalam  skala sukrosa internasional tanpa koreksi keasaman;  \x{2022} Penambahan gula tidak lebih dari 50 g/kg pada total padatan  terlarut 11%.",
    "Aktif",
  ],
  [
    140102030002,
    "Konsentrat Sari Buah Jeruk Siam, Tangerine",
    "Definisi :  Konsentrat sari buah jeruk siam, tangerine adalah produk buah yang belum difermentasi, dapat difermentasi setelah direkonstitusi, diawetkan secara fisik (tidak termasuk iradiasi), diperoleh melalui proses konsentrasi, yaitu penghilangan air hingga produk mempunyai total padatan tidak kurang dari dari 20% yang diukur dengan refraktometer pada suhu 20\\xB0C.",
    "Aktif",
  ],
  [
    140102030003,
    "Konsentrat Sari Buah Apel",
    "Definisi :  Konsentrat sari buah apel adalah produk buah yang belum difermentasi, dapat difermentasi setelah direkonstitusi, diawetkan secara fisik (tidak termasuk iradiasi), diperoleh melalui proses konsentrasi yaitu penghilangan air hingga produk mempunyai total padatan tidak kurang dari 20% yang diukur dengan refraktometer pada suhu 20\\xB0C.",
    "Aktif",
  ],
  [
    140102030004,
    "Konsentrat Sari Buah Anggur",
    "Definisi :  Konsentrat sari buah anggur adalah produk buah yang belum difermentasi, dapat difermentasi setelah direkonstitusi, diawetkan secara fisik (tidak termasuk iradiasi), diperoleh melalui proses konsentrasi yaitu penghilangan air hingga produk mempunyai total padatan tidak kurang dari 20% yang diukur dengan refraktometer pada suhu 20C.",
    "Aktif",
  ],
  [
    140102030005,
    "Konsentrat Sari Buah Anggur Manis",
    "Definisi :  Konsentrat sari buah anggur manis adalah produk konsentrat yang belum difermentasi, dapat difermentasi setelah direkonstitusi, diawetkan secara fisik (tidak termasuk iradiasi), diperoleh melalui proses konsentrasi yaitu penghilangan air hingga produk mempunyai total padatan tidak kurang dari 30% yang diukur dengan refraktometer pada suhu 20\\xB0C",
    "Aktif",
  ],
  [
    140102030006,
    "Konsentrat Sari Buah Blackcurrant",
    "Definisi :  Konsentrat sari buah blackcurrant adalah produk buah yang belum difermentasi, dapat difermentasi setelah direkonstitusi, diawetkan secara fisik (tidak termasuk iradiasi), diperoleh melalui proses konsentrasi yaitu penghilangan air hingga produk mempunyai total padatan tidak kurang dari 20% yang diukur dengan refraktometer pada suhu 20\\xB0C.",
    "Aktif",
  ],
  [
    140102030007,
    "Konsentrat Sari Buah Nanas",
    "Definisi :  Konsentrat sari buah nanas adalah produk buah yang belum difermentasi, dapat difermentasi setelah direkonstitusi, diawetkan secara fisik (tidak termasuk radiasi ionisasi), diperoleh melalui proses konsentrasi yaitu penghilangan air hingga produk mempunyai total padatan tidak kurang dari 40% yang diukur dengan refraktometer pada suhu 20\\xB0C.",
    "Aktif",
  ],
  [
    140102030008,
    "Konsentrat Minuman Sari Buah",
    "Definisi :  Konsentrat minuman sari buah adalah sari buah atau campuran dua atau lebih sari buah yang dijadikan konsentrat dengan mengurangi kadar airnya, dengan penambahan gula dan bahan pangan lain. Konsentrat minuman sari buah dapat dikonsumsi setelah diencerkan. Setelah diencerkan mengandung tidak kurang dari 35% sari buah.",
    "Aktif",
  ],
  [
    140102030009,
    "Konsentrat Minuman Buah",
    "Definisi :  Konsentrat minuman buah adalah sari buah atau campuran dua atau lebih sari buah yang dijadikan konsentrat dengan mengurangi kadar airnya, dengan penambahan gula dan bahan pangan lain.  Konsentrat minuman buah dapat dikonsumsi setelah diencerkan.  Setelah diencerkan mengandung tidak kurang dari 10% sari buah.",
    "Aktif",
  ],
  [
    140102030010,
    "Konsentrat Sari Buah dan Sari Sayur",
    "Definisi :  Konsentrat sari buah dan sari sayur adalah konsentrat yang berasal dari campuran sari buah atau puree buah dan sari sayur.",
    "Aktif",
  ],
  [
    140102040001,
    "Konsentrat Sari Tomat",
    "Definisi :  Konsentrat sari tomat adalah produk yang diperoleh dari cairan tomat matang (Lycopersicum esculentum P. Will). Cairan tersebut dipisahkan dari kulit, biji dan bagian yang tidak diperlukan pada produk akhir. Garam dan bumbu-bumbu yang sesuai lainnya dapat ditambahkan, kecuali gula atau pemanis lainnya dan sari buah jeruk sebagai pengatur keasaman. Produk mengandung kadar 8% atau lebih buah tomat berupa padatan terlarut tetapi tidak dikeringkan menjadi suatu bubuk kering atau bentuk kepingan.  Karakteristik dasar :  Kandungan tomat :  \x{2022} Pasta tomat tidak kurang dari 24%  \x{2022} Puree tomat 8% hingga 24%",
    "Aktif",
  ],
  [
    140103010001,
    "Nektar Buah",
    "Definisi :  Nektar buah adalah produk buah tanpa fermentasi tetapi dapat difermentasi, mengandung hancuran buah atau tidak, ditujukan untuk dikonsumsi langsung, diperoleh dengan mencampur sari buah dan atau hancuran bagian buah yang dapat dimakan dan atau hasil saringan hancuran buah dari buah masak, dengan atau tanpa pemekatan, dengan air, gula atau madu, dan diawetkan secara fisik. Pada buah yang mengandung gula tinggi, penambahan gula dapat diabaikan.  Karakteristik dasar :  Kandungan buah tidak kurang dari 20%.",
    "Aktif",
  ],
  [
    140103010002,
    "Nektar Buah Kecil",
    "Definisi :  Nektar buah kecil adalah hancuran buah yang dibuat dari buah  berries species atau turunan spesies: bilberries (Vaccinium myrtillus  L.); blackberries (Rubus procerus P.J. Muell., etc.); blackcurrants  (Ribes nigrum L.); cloudberries (Rubus chamaemorus L.); cranberries  (Vaccinium oxycoccus L., V. macrocarpon Ait.); redcurrants dan  whitecurrants (kultivar dari Ribes rubrum L., R. pallidum, Otto, and  Dietr., R. sylvestre (Lam.) Mert. and W.D.J. Kock, etc.); elderberries  (Sambucus nigra); gooseberries (Ribes uva-crispa L. dan hibridanya);  raspberries (Rubus idaeus L.); rose hips (Cynorrhoda of Rosa spp.);  rowanberries (Sorbus aucuparia L.); sea buckthorn (Hippophaea  rhamnoides L.); strawberi (kultivar dan hibrida dari Fragaria spp.);  whortleberries (Vaccinium vitis idaea L.).  Produk hancuran buah tersebut, dapat dipasteurisasi atau tidak,  dan ditujukan untuk dikonsumsi langsung, diperoleh dengan  mencampur hasil saringan hancuran buah yang dapat dimakan  atau hasil gilingan dan dihomogenisasi, produk berasal dari buah  berri yang bersih, masak, dipekatkan, dengan air dan gula atau  madu, diawetkan secara fisik.     Karakteristik dasar :  \x{2022} Kandungan buah tunggal tidak kurang dari : sea buckthorn 25%;  blackcurrants 30%; rowanberries 30%; redcurrants 30%;  whitecurrants 30%; gooseberries 30%; blackberries 30%;  cloudberries 30%; cranberries 30%; whortleberries 30%;  raspberries 40%; strawberi 40%; bilberries 40%; rose hips 40%;  elderberries 50% atau yang setara itu yang diperoleh dari bahan  konsentrat di dalam nektar hancuran buah  \x{2022} Total padatan terlarut tidak lebih dari 20% yang diukur dengan  refraktometer pada suhu 20\xB0C  \x{2022} Kandungan etanol tidak lebih dari 0,3%",
    "Aktif",
  ],
  [
    140103010003,
    "Nektar Buah Campuran",
    "Definisi :  Nektar buah campuran adalah produk buah yang dapat  dipasteurisasi atau tidak, dan produk hancuran buah ditujukan  untuk dikonsumsi langsung, diperoleh dengan mencampur hasil  saringan hancuran buah yang dapat dimakan atau hasil gilingan  dan dihomogenisasi, produk berasal dari dua atau lebih jenis buah  yang masak, dengan atau tanpa pemekatan atau tidak, dengan air  dan gula atau madu, diawetkan secara fisik. Pada buah yang  mengandung gula tinggi, penambahan gula dapat diabaikan.  Karakteristik dasar :  \x{2022} Kandungan buah tunggal tidak kurang dari 50% atau dalam  jumlah yang setara dengan itu yang diperoleh dari bahan  konsentrat, kecuali untuk produk atau buah dengan tingkat  keasaman tinggi  \x{2022} Mengandung hancuran buah (pulpy) tinggi, atau jika  mengandung perisa tinggi, maka kandungannya dapat berkurang;  \x{2022} Kandungan buah tidak kurang dari 25%  \x{2022} Total padatan terlarut tidak lebih dari 20% yang diukur dengan  refraktometer pada suhu 20\xB0C  \x{2022} Kandungan etanol tidak lebih dari 0,3%",
    "Aktif",
  ],
  [
    140103010004,
    "Nektar Aprikot, Nektar Peach atau Nektar Pear/Pir",
    "Definisi :  Nektar aprikot, nektar peach atau nektar pir/pear adalah produk buah yang dapat dipasteurisasi atau tidak, dan produk hancuran buah ditujukan untuk dikonsumsi langsung, diperoleh dengan mencampur hasil saringan hancuran buah yang dapat dimakan atau hasil gilingan dan dihomogenisasi, produk berasal dari buah aprikot, peach atau pir/pear yang bersih, masak, dipekatkan, dengan air dan gula atau madu, diawetkan secara fisik.  Karakteristik dasar :  \x{2022} Kandungan buah untuk nektar peach dan pir/pear tidak kurang dari 40%, dan untuk nektar aprikot tidak kurang dari 35%, buah tunggal atau yang setara dengan itu yang diperoleh dari bahan konsentrat  \x{2022} Total padatan terlarut tidak lebih dari 20% yang diukur dengan refraktometer pada suhu 20 \xB0C  \x{2022} Kandungan etanol tidak lebih dari 0,3%",
    "Aktif",
  ],
  [
    140103010005,
    "Nektar Blackcurrant",
    "Definisi :  Nektar blackcurrant adalah produk buah yang dapat dipasteurisasi atau tidak, dan produk hancuran buah ditujukan untuk dikonsumsi langsung, diperoleh dengan mencampur hasil saringan hancuran buah yang dapat dimakan atau hasil gilingan dan dihomogenisasi, produk berasal dari buah blackcurrant yang bersih, masak, dipekatkan, dengan air dan gula atau madu, diawetkan secara fisik. Produk dapat keruh atau jernih.  Karakteristik dasar :  \x{2022} Kandungan buah blackcurrant tidak kurang dari 30% atau yang setara dengan itu yang diperoleh dari bahan konsentrat blackcurrant  \x{2022} Total padatan terlarut tidak lebih dari 20% yang diukur dengan refraktometer pada suhu 20\xB0C  \x{2022} Kadar etanol tidak lebih dari 0,2%",
    "Aktif",
  ],
  [
    140103010006,
    "Nektar Buah Citrus",
    "Definisi :  Nektar buah citrus adalah nektar hancuran buah yang dibuat dari buah spesies citrus Orange (Citrus sinensis L. Osbeck); Mandarine, tangerine, (Citrus reticulata) dan Grapefruit (Citrus paradisi Mcfayden) dan lain-lain. Dapat dipasteurisasi atau tidak, dan ditujukan untuk dikonsumsi langsung, diperoleh dengan mencampur hasil saringan hancuran endokarp buah atau hasil gilingan dan dihomogenisasi, produk berasal dari buah citrus masak, dipekatkan, dengan air dan gula atau madu, diawetkan secara fisik.  Karakteristik dasar :  \x{2022} Kandungan buah tunggal tidak kurang dari 50% atau yang setara dengan itu yang diperoleh dari bahan konsentrat  \x{2022} Penambahan 10% buah mandarin (C. reticulata) termasuk ke dalam kandungan total buah citrus  \x{2022} Total padatan terlarut tidak lebih dari 12% yang diukur dengan  refraktometer pada suhu 20 \xB0C  \x{2022} Kadar etanol tidak lebih dari 0,3%",
    "Aktif",
  ],
  [
    140103010007,
    "Nektar Jambu Biji",
    "Definisi :  Nektar jambu biji adalah produk buah yang dapat dipasteurisasi atau tidak, dan ditujukan untuk dikonsumsi langsung, diperoleh dengan mencampur hasil saringan hancuran endokarp buah atau hasil gilingan dan dihomogenisasi, produk berasal dari buah jambu biji (Psidium guajava), segar dan masak, dipekatkan atau tidak, dengan air dan gula atau madu, diawetkan secara fisik.  Karakteristik dasar :  \x{2022} Kandungan buah tunggal tidak kurang dari 25% atau yang setara dengan itu yang diperoleh dari bahan konsentrat  \x{2022} Total padatan terlarut tidak lebih dari 20% yang diukur dengan refraktometer pada suhu 20 \xB0C  \x{2022} Kadar etanol tidak lebih dari 0,3%.",
    "Aktif",
  ],
  [
    140103010008,
    "Nektar Mangga",
    "Definisi :  Nektar mangga adalah bubur buah yang mengandung hancuran buah (pulpy atau pur\xE9e) yang dapat dipasteurisasi atau tidak, dan ditujukan untuk dikonsumsi langsung, diperoleh dengan mencampur hasil saringan hancuran endokarp buah atau hasil gilingan dan dihomogenisasi, produk berasal dari buah mangga (Mangifera indica L), segar dan masak, dipekatkan atau tidak, dengan air dan gula atau madu, diawetkan secara fisik.  Karakteristik dasar :  \x{2022} Kandungan pur\xE9e buah mangga (%v/v) tidak kurang dari 25% atau yang setara dengan itu yang diperoleh dari bahan konsentrat  \x{2022} Total padatan terlarut tidak lebih dari 20% yang diukur dengan refraktometer pada suhu 20 \xB0C; minimum Brix Level untuk Sari Buah Rekonstitusi 13,5\xB0Brix  \x{2022} Kadar etanol tidak lebih dari 0,3%",
    "Aktif",
  ],
  [
    140103010009,
    "Nektar Sirsak",
    "Definisi :  Nektar Sirsak adalah bubur buah yang mengandung hancuran buah (pulpy atau pur\xE9e) yang dapat dipasteurisasi atau tidak, dan ditujukan untuk dikonsumsi langsung, diperoleh dengan mencampur hasil saringan hancuran endokarp buah atau hasil gilingan dan dihomogenisasi, produk berasal dari buah Sirsak (Annona muricata L.), masak, dipekatkan atau tidak, dengan air dan gula atau madu, diawetkan secara fisik.  Karakteristik dasar :  \x{2022} Kandungan pur\xE9e buah sirsak (%v/v) tidak kurang dari 25% atau yang setara dengan itu yang diperoleh dari bahan konsentrat  \x{2022} Total padatan terlarut tidak lebih dari 20% yang diukur dengan refraktometer pada suhu 20 \xB0C; Minimum Brix Level untuk Sari Buah Rekonstitusi 14,5\xB0Brix  \x{2022} Kadar etanol tidak lebih dari 0,3%.",
    "Aktif",
  ],
  [
    140103020001,
    "Nektar Sayur",
    "Definisi :  Nektar sayur adalah produk bubur sayur yang berupa hancuran sayur (pulpy) homogen dapat dipasteurisasi atau tidak, dan dikemas untuk siap dijual. Dapat berasal dari satu jenis sayur atau campuran dari beberapa jenis sayur.",
    "Aktif",
  ],
  [
    140103030001,
    "Konsentrat Nektar Buah",
    "Konsentrat nektar buah diperoleh dari penguapan atau pembekuan dari nektar buah atau bahan pembuatnya. Konsentrat nektar buah terdapat dalam bentuk tepung, cairan, sirup dan beku untuk tujuan persiapan dari nektar buah siap minum dengan penambahan air. Contohnya adalah konsentrat nektar pir/pear dan konsentrat nektar-persik.",
    "Aktif",
  ],
  [
    140103040001,
    "Konsentrat Nektar Sayur",
    "Konsentrat nektar sayur adalah konsentrat yang diperoleh dari penguapan atau pembekuan dari nektar sayur atau bahan pembuatnya. Konsentrat nektar sayur terdapat dalam bentuk tepung, cairan, sirup dan beku untuk tujuan persiapan dari nektar sayur siap minum dengan penambahan air.",
    "Aktif",
  ],
  [
    140104010001,
    "Minuman Sari Buah Berkarbonat",
    "Definisi :  Minuman sari buah berkarbonat adalah minuman yang diperoleh dengan mencampur air minum; sari buah atau campuran sari buah yang tidak difermentasi, dengan bagian lain dari satu jenis buah atau lebih, yang ditambahkan karbondioksida. Total sari buah tidak kurang dari 35% (b/v).  Karakteristik dasar:  Kadar CO2 tidak lebih dari 5.890 mg/L",
    "Aktif",
  ],
  [
    140104010002,
    "Minuman Buah Berkarbonat",
    "Definisi :  Minuman buah berkarbonat adalah minuman yang terdiri dari satu atau lebih jenis buah, yang ditambahkan karbondioksida. Total sari buah 10% sampai 35% (b/v).  Karakteristik Dasar:  Kadar CO2 tidak lebih dari 5.890 mg/L",
    "Aktif",
  ],
  [
    140104010003,
    "Minuman Berperisa Berkarbonat",
    "Definisi :  Minuman berperisa berkarbonat adalah produk minuman yang diperoleh dari pencampuran air minum dengan bahan perisa dan gula yang mengandung karbondioksida dengan atau tanpa penambahan bahan pangan lain.  Karakteristik Dasar:  Kadar CO2 tidak lebih dari 5.890 mg/L",
    "Aktif",
  ],
  [
    140104010004,
    "Minuman Rasa Susu",
    "Definisi :  Minuman rasa susu adalah produk minuman yang diperoleh dari pencampuran air minum dengan susu untuk memberikan rasa, dengan atau tanpa penambahan bahan pangan lain.  Karakteristik dasar:  \x{2022} Kadar lemak susu kurang dari 0.3%;  \x{2022} Kadar CO2 tidak lebih dari 5.890 mg/L.",
    "Aktif",
  ],
  [
    140104010005,
    "Ginger Ale",
    "Definisi :  Ginger ale adalah minuman berkarbonat yang dibuat dari perisa ginger ale (konsentrat perisa dengan jahe sebagai komponen utama, dengan atau tanpa bahan pemberi aroma dan penyengat, minyak citrus, sari buah dan pewarna karamel), asam organik, air minum, dan sirup gula, dengan atau tanpa pewarna karamel.  Karakteristik dasar :  Kandungan jahe tidak lebih dari 14 Brix",
    "Aktif",
  ],
  [
    140104010006,
    "Sarsaparilla",
    "Definisi :  Sarsaparilla adalah minuman berkarbonat yang diperoleh dari perisa sarsaparila (konsentrat perisa yang mengandung pengganti sassafras/sassafras substitute dan metil salisilat sebagai komponen utama, dengan atau tanpa bahan pemberi aroma dan penyengat, dan atau tanpa pewarna karamel); asam organik; air minum dan sirup gula dengan atau tanpa pewarna karamel.  Karakteristik dasar :  Kandungan tidak lebih dari 14oBrix",
    "Aktif",
  ],
  [
    140104010007,
    "Root Beer",
    "Definisi :  Root beer adalah minuman berkarbonat yang diperoleh dari perisa root beer (konsentrat perisa yang mengandung pengganti sassafras/sassafras substitute dan metil salisilat sebagai komponen utama, mengandung komponen perisa lainnya dan atau tanpa pewarna karamel); asam organik; air minum dan sirup gula dengan atau tanpa pewarna karamel.  Karakteristik dasar :  Kandungan tidak lebih dari 14 Brix",
    "Aktif",
  ],
  [
    140104010008,
    "Birch Beer",
    "Definisi :  Birch beer adalah minuman berkarbonat yang diperoleh dari perisa birch beer (konsentrat perisa seperti root beer, tetapi dengan metil salisilat sebagai komponen utama), asam organik, air minum, dan sirup gula dengan atau tanpa pewarna karamel.  Karakteristik dasar :  Kandungan tidak lebih dari 14 Brix",
    "Aktif",
  ],
  [
    140104010009,
    "Soda Krim (Cream soda)",
    "Definisi :  Soda krim (cream soda) adalah minuman berkarbonat yang diperoleh dari perisa cream soda water (konsentrat perisa vanila atau vanilin atau kombinasi keduanya sebagai komponen utama, dengan bahan pemberi aroma lain, dan atau tanpa pewarna karamel); asam organik; air minum; dan sirup gula dengan atau tanpa pewarna karamel.  Karakteristik dasar:  Kandungan tidak lebih dari 14 Brix",
    "Aktif",
  ],
  [
    140104010010,
    "Minuman Citrus",
    "Definisi :  Minuman citrus adalah minuman yang diperoleh dari sari buah citrus (konsentrasi 10 - 15%), atau perisa buah, asam organik, sirup gula dan pewarna.  Karakteristik dasar :  Kandungan tidak lebih dari 14 Brix",
    "Aktif",
  ],
  [
    140104010011,
    "Minuman Citrus Comminutes",
    "Definisi :  Minuman citrus comminutes adalah minuman ringan yang diperoleh dari proses yang melibatkan kelompok buah citrus utuh.  Karakteristik dasar :  \x{2022} Kandungan buah dalam minuman 7% hingga 10% tergantung jenisnya sebelum diencerkan, dan 1,5% hingga 2% untuk minuman yang dikonsumsi tanpa pengenceran;  \x{2022} Dapat ditambahkan gula tidak lebih dari 100 g/kg.",
    "Aktif",
  ],
  [
    140104010012,
    "Minuman Kola",
    "Definisi :  Minuman kola adalah minuman yang diperoleh dari bahan dasar sirup gula, kafein, ekstrak buah kola (cola nut extract), asam fosfat, dan pewarna karamel.  Karakteristik dasar :  Kandungan gula tidak lebih dari 14 derajat Brix.",
    "Aktif",
  ],
  [
    140104010013,
    "Limun",
    "Definisi :  Limun adalah produk minuman ringan yang mengandung gula, karbondioksida.",
    "Aktif",
  ],
  [
    140104020001,
    "Punches/Ades",
    "Definisi :  Punches/ades adalah produk minuman yang diperoleh dari campuran sari buah dengan atau tanpa penambahan perisa.",
    "Aktif",
  ],
  [
    140104020002,
    "Crush",
    "Definisi :  Crush adalah minuman ringan yang mengandung sari buah, bukan untuk minuman citrus comminutes, ditujukan untuk dikonsumsi tanpa diencerkan, termasuk cordial yang dikonsumsi tanpa pengenceran.  Karakteristik dasar :  Kandungan buah tidak kurang dari 3% dan tidak lebih dari 5% tergantung jenisnya.",
    "Aktif",
  ],
  [
    140104020003,
    "Minuman Sari Buah",
    "Definisi :  Minuman sari buah adalah minuman yang diperoleh dengan mencampur air minum; sari buah atau campuran sari buah yang tidak difermentasi, dengan bagian lain dari satu jenis buah atau lebih, dengan atau tanpa penambahan gula. Total sari buah tidak kurang dari 35% (b/v).",
    "Aktif",
  ],
  [
    140104020004,
    "Minuman Buah",
    "Definisi :  Minuman buah adalah minuman yang terdiri dari satu atau lebih jenis buah, dengan total sari buah 10% sampai 35% (b/v).",
    "Aktif",
  ],
  [
    140104020005,
    "Minuman Rasa Buah",
    "Definisi :  Minuman berperisa/rasa buah adalah minuman yang terdiri dari satu atau lebih jenis buah, dengan total sari buah kurang dari 10% (b/v).",
    "Aktif",
  ],
  [
    140104020006,
    "Minuman Berperisa",
    "Definisi :  Minuman berperisa adalah produk minuman yang diperoleh dari pencampuran air minum dengan bahan perisa dan gula dengan atau tanpa penambahan bahan pangan lain melalui proses pemanasan.",
    "Aktif",
  ],
  [
    140104020007,
    "Minuman Jeli",
    "Definisi :  Minuman jeli adalah minuman yang menggunakan bahan baku berupa hidrokoloid sebagai komponen utama. Produk akhir berupa cairan semi liquid (gel) diperoleh dari proses pencampuran air, hidrokoloid dengan atau tanpa penambahan bahan pangan lain.  Karakteristik dasar :  \x{2022} Memiliki tekstur/konsistensi gel semi liquid ;  \x{2022} Kandungan hidrokoloid tidak kurang dari 0,1%.",
    "Aktif",
  ],
  [
    140104020008,
    "Minuman Teh",
    "Definisi :  Minuman teh adalah minuman hasil seduhan daun teh dan/atau ekstrak teh dalam air dengan atau tanpa penambahan gula dan/atau bahan pangan lain, dan dikemas secara kedap (hermetis).",
    "Aktif",
  ],
  [
    140104020009,
    "Minuman Kopi",
    "Definisi :  Minuman kopi adalah minuman yang dibuat dari kopi bubuk, kopi instan, dan/atau ekstrak kopi, air minum, dengan atau tanpa penambahan gula dan bahan pangan lain.  Karakteristik dasar :  Kadar kopi tidak kurang dari 4% (dihitung dari basis berat kering).",
    "Aktif",
  ],
  [
    140104020010,
    "Kapucino",
    "Definisi :  Kapucino adalah minuman yang dibuat dari espresso dan susu, yang merupakan minuman khas Italia.",
    "Aktif",
  ],
  [
    140104020011,
    "Minuman Rasa Susu",
    "Definisi : Minuman rasa susu adalah produk minuman yang diperoleh dari pencampuran air minum dengan susu untuk memberikan rasa, dengan atau tanpa penambahan bahan pangan lain.  Karakteristik dasar: \x{2022} Kadar lemak susu kurang dari 0.3%; \x{2022} Kadar CO2 tidak lebih dari 5.890 mg/L.",
    "Aktif",
  ],
  [
    140104020012,
    "Minuman Citrus Comminutes",
    "Definisi : Minuman citrus comminutes adalah minuman ringan yang diperoleh dari proses yang melibatkan kelompok buah citrus utuh.  Karakteristik dasar : \x{2022} Kandungan buah dalam minuman 7% hingga 10% tergantung jenisnya sebelum diencerkan, dan 1,5% hingga 2% untuk minuman yang dikonsumsi tanpa pengenceran; \x{2022} Dapat ditambahkan gula tidak lebih dari 100 g/kg.",
    "Aktif",
  ],
  [140104020013, "Minuman Teh Fermentasi", "", "Aktif"],
  [
    140104030001,
    "Konsentrat Lemonade Beku",
    "Definisi: Konsentrat lemonade beku adalah produk beku disiapkan dari satu atau dua sari buah jeruk lemon dengan satu atau lebih pemanis nutritif.  Karakteristik dasar : \x{2022} Total padatan terlarut (dihitung sebagai nilai sukrosa) tidak kurang dari 48% yang diukur dengan refraktometer; \x{2022} Saat produk diencerkan mengikuti aturan label untuk membuat lemonade, keasaman lemonade (sebagai asam sitrat anhidrat) tidak kurang dari 0,77 % b/v, dan total padatan terlarut tidak kurang dari 10,5%; \x{2022} Bahan sari buah lemon : sari buah lemon atau sari buah lemon beku atau campurannya; konsentrat sari buah lemon atau konsentrat sari buah lemon beku atau campurannya; \x{2022} Sari buah lemon tidak diencerkan dan diperoleh dari buah masak dan dari jenis asam.",
    "Aktif",
  ],
  [
    140104030002,
    "Konsentrat Minuman Rasa/Berperisa Berkarbonat atau Tidak Berkarbonat (Serbuk/ Cair/ Pasta)",
    "Definisi : Konsentrat minuman rasa/berperisa adalah produk minuman dalam bentuk konsentrat (cair atau padat) yang diperoleh dari campuran bahan pangan, dengan atau tanpa perisa, dan dalam penggunaannya diencerkan dengan air. Termasuk dalam nama jenis ini diantaranya minuman serbuk rasa, minuman serbuk berperisa.",
    "Aktif",
  ],
  [
    140104030003,
    "Squash",
    "Definisi : Squash adalah minuman yang diperoleh dari campuran sirup atau gula dan sari buah dengan atau tanpa bagian yang dapat dimakan dari satu jenis buah atau lebih dan dalam penggunaannya diencerkan dengan air.  Karakteristik dasar : \x{2022} Kadar gula sebagai sakarosa 25% hingga 55%; \x{2022} Total padatan terlarut tidak kurang dari 30%; \x{2022} Kandungan sari buah tidak kurang dari 10%",
    "Aktif",
  ],
  [
    140104030004,
    "Squash Berperisa/Rasa",
    "Definisi : Squash berperisa/rasa adalah produk yang diperoleh dari proses pencampuran sirup atau gula dan perisa dengan atau tanpa bagian yang dapat dimakan dari satu jenis buah-buahan atau lebih dan dalam penggunaannya harus diencerkan terlebih dahulu.  Karakteristik dasar : Kadar gula sebagai sakarosa 25% hingga 55%.",
    "Aktif",
  ],
  [
    140104030005,
    "Sirup Buah",
    "Definisi : Sirup buah adalah produk yang diperoleh dengan mencampur sirup dan sari buah dengan atau tanpa bagian yang dapat dimakan dari satu jenis buah atau lebih.  Karakteristik dasar : \x{2022} Kadar gula sebagai sakarosa tidak kurang dari 65%; \x{2022} Kandungan sari buah atau bagian buah lain tidak kurang dari 25%.",
    "Aktif",
  ],
  [
    140104030006,
    "Sirup Berperisa",
    "Definisi : Sirup berperisa adalah produk minuman berupa larutan yang berperisa dengan kadar gula tidak kurang dari 65%. Dapat ditambahkan bahan pangan lain. Dalam penggunaannya diencerkan dengan air.",
    "Aktif",
  ],
  [
    140104030007,
    "Sirup Encer Berperisa",
    "Definisi : Sirup encer berperisa adalah produk minuman berupa larutan gula minimal 55 % dan tidak lebih dari 65% yang berperisa. Dapat ditambahkan bahan pangan lain. Dalam penggunaannya diencerkan dengan air.",
    "Aktif",
  ],
  [
    140104030008,
    "Sirup Teh",
    "Definisi: Sirup teh adalah produk minuman yang mengandung gula dan ekstrak teh (Camellia sinensis) dengan atau tanpa penambahan bahan pangan lain. Dalam penggunaannya diencerkan dengan air.  Karakteristik dasar : \x{2022} Kadar gula tidak kurang dari 40%; \x{2022} Total padatan terlarut tidak kurang dari 40,12%; \x{2022} Total tanin tidak kurang dari 0,12%.",
    "Aktif",
  ],
  [
    140104030009,
    "Sirup Kopi",
    "Definisi : Sirup kopi adalah produk minuman yang mengandung gula dan ekstrak kopi dengan atau tanpa penambahan bahan pangan lain.  Karakteristik dasar : \x{2022} Kadar gula minimal 45%; \x{2022} Total padatan terlarut tidak kurang dari 65%.",
    "Aktif",
  ],
  [
    140104030010,
    "Pengganti Sirup Berperisa",
    "Produk minuman berupa larutan kental yang berperisa dengan tingkat kemanisan setara minimal 65% sukrosa dan dalam penggunaannya diencerkan dengan air",
    "Aktif",
  ],
  [
    140104030011,
    "Pengganti Squash Berperisa",
    "Produk minuman berupa larutan kental yang berperisa dengan tingkat kemanisan setara minimal 25% dan tidak lebih dari 55% sukrosa dengan atau tanpa bagian yang dapat dimakan dari satu jenis buah-buahan atau lebih dan dalam penggunaannya harus diencerkan terlebih dahulu",
    "Aktif",
  ],
  [
    140104030012,
    "Pengganti Sirup Encer Berperisa",
    "Produk minuman berupa larutan kental yang berperisa dengan tingkat kemanisan setara minimal 55% dan tidak lebih dari 65% sukrosa dan dalam penggunaannya diencerkan dengan air",
    "Aktif",
  ],
  [
    140105000001,
    "Teh Hitam",
    "Definisi : Teh hitam adalah teh kering hasil pengolahan pucuk dan daun muda termasuk tangkainya dari tanaman teh (Camellia sinensis L.) melalui proses fermentasi.",
    "Aktif",
  ],
  [
    140105000002,
    "Teh Hijau",
    "Definisi : Teh hijau adalah pucuk dan daun muda tanaman teh Camellia sinensis yang telah diolah tanpa melalui proses fermentasi.",
    "Aktif",
  ],
  [
    140105000003,
    "Teh Putih",
    "Definisi : Teh putih adalah produk teh yang dibuat dari daun teh yang memiliki buluh-buluh putih kecil pada daun mudanya.",
    "Aktif",
  ],
  [
    140105000004,
    "Teh Wangi",
    "Definisi : Teh wangi adalah teh yang telah mengalami pengolahan lebih lanjut, ditambah dengan bunga melati (Jasminum sambac), bunga melati gambir (Jasminum officinale), bunga culan (Aglaia odorata), atau bagian tanaman lain dalam bentuk bahan alaminya atau ekstraknya.  Karakteristik dasar : Kadar air tidak lebih dari 8%.",
    "Aktif",
  ],
  [
    140105000005,
    "Teh Olong atau Teh Semi Fermentasi",
    "Definisi : Teh olong atau teh semi fermentasi adalah teh yang difermentasi dengan cepat, sesudah dan sebelum penggulungan. Warna daunnya setengah coklat.",
    "Aktif",
  ],
  [
    140105000006,
    "Teh Hijau Bubuk",
    "Definisi : Teh hijau bubuk adalah bubuk kering yang dihasilkan dari pengolahan pucuk dan daun muda tanaman Camellia sinensis tanpa proses fermentasi.  Karakteristik dasar : Kadar air tidak lebih dari 8%.",
    "Aktif",
  ],
  [
    140105000007,
    "Teh Kering",
    "Definisi : Teh kering adalah berbagai jenis teh kering (teh hitam, teh hijau, teh olong, teh wangi melati dan teh beraroma) yang dikemas dengan berat tertentu dan siap seduh.  Karakteristik dasar : Kadar air tidak lebih dari 8%.",
    "Aktif",
  ],
  [
    140105000008,
    "Teh Hitam Celup",
    "Definisi : Teh hitam celup adalah teh kering hasil pengolahan pucuk daun muda dan daun muda dari tanaman teh (Camellia sinensis L.) yang telah melalui proses oksidasi enzimatis dan dikemas dalam kantong dengan atau tanpa tali maupun perekat untuk dicelup dengan atau tanpa bahan pangan lain.  Karakteristik dasar : Kadar air tidak lebih dari 10%.",
    "Aktif",
  ],
  [
    140105000009,
    "Teh Wangi Celup",
    "Definisi : Teh wangi celup adalah teh wangi yang dikemas dalam kantong khusus untuk dicelup dengan atau tanpa bahan pangan lain.",
    "Aktif",
  ],
  [
    140105000010,
    "Teh Hijau Celup",
    "Definisi : Teh hijau celup adalah teh kering hasil pengolahan pucuk daun muda dan daun muda dari tanaman teh (Camellia sinensis L.) tanpa melalui proses oksidasi enzimatis dan dikemas dalam kantong dengan atau tanpa tali maupun perekat untuk dicelup dengan atau tanpa bahan pangan lain.",
    "Aktif",
  ],
  [
    140105000011,
    "Teh Instan",
    "Definisi : Teh instan adalah teh berbentuk serbuk yang mudah larut dalam air diperoleh melalui proses ekstraksi teh (Camellia sinensis L.), penyaringan, pemekatan dan pengeringan dengan atau tanpa penambahan bahan pangan lain, dan dikemas secara kedap.",
    "Aktif",
  ],
  [
    140105000012,
    "Teh Instan Dekafein",
    "Definisi : Teh instan dekafein adalah teh instan yang sebagian besar kafeinnya telah dihilangkan.  Karakteristik dasar : Mengandung tidak lebih dari 4 g/kg kafein anhidrat dihitung terhadap bobot kering.",
    "Aktif",
  ],
  [
    140105000013,
    "Konsentrat Minuman Teh",
    "Definisi : Produk yang dibuat dari ekstrak teh pekat atau ekstrak teh yang dipekatkan dengan atau tanpa penambahan bahan pangan lain. Cara mengonsumsinya adalah cukup ditambahkan air.",
    "Aktif",
  ],
  [
    140105000014,
    "Minuman Serbuk Teh",
    "Definisi : Minuman serbuk teh adalah produk minuman berbentuk serbuk yang dibuat dari teh bubuk, teh instan, dan/atau ekstrak teh, dengan atau tanpa penambahan bahan pangan lain.",
    "Aktif",
  ],
  [
    140105000015,
    "Biji Kopi",
    "Definisi : Biji kopi adalah biji dari tanaman Coffea sp dalam bentuk utuh dan sudah disangrai.  Karakteristik dasar : Kadar air tidak lebih dari 12%.",
    "Aktif",
  ],
  [
    140105000016,
    "Kopi Bubuk",
    "Definisi : Kopi bubuk adalah biji kopi yang disangrai kemudian digiling, kandungan kafein anhidrat tidak lebih dari 2.5%.  Karakteristik dasar : Kadar air tidak lebih dari 7%.",
    "Aktif",
  ],
  [
    140105000017,
    "Kopi Instan",
    "Definisi : Kopi instan adalah produk kering mudah larut dalam air, kandungan kafein tidak kurang dari 2% dan tidak lebih dari 8%, diperoleh seluruhnya dengan cara mengekstrak dengan air dari biji kopi (Coffea sp) yang telah disangrai.",
    "Aktif",
  ],
  [
    140105000018,
    "Kopi Campur",
    "Definisi : Kopi campur adalah produk kopi giling dicampur dengan gandum, jagung atau wijen, margarin atau gula.  Karakteristik dasar : Kadar kopi tidak kurang dari 50%.",
    "Aktif",
  ],
  [
    140105000019,
    "Minuman Berkafein Formulasi (Formulated Caffeinated Beverages)",
    "Definisi : Minuman berkafein formulasi (formulated caffeinated beverages) adalah minuman berperisa tidak beralkohol berbasis air atau dalam bentuk serbuk yang mengandung kafein, dapat mengandung karbohidrat, asam amino, vitamin dan zat lain, termasuk bahan pangan lain.  Karakteristik dasar : Kadar kafein 145 mg/l hingga 320 mg/l.",
    "Aktif",
  ],
  [
    140105000020,
    "Konsentrat Minuman Kopi",
    "Definisi : Konsentrat minuman kopi adalah produk kopi yang diperoleh melalui proses penyeduhan kopi bubuk, kopi instan, dan/atau ekstrak kopi, dilanjutkan dengan pemekatan, dengan atau tanpa penambahan bahan pangan lain. Cara mengonsumsinya adalah diencerkan dengan penambahan air. Produk ini dapat disimpan dan didistribusikan dalam bentuk beku atau tidak beku.",
    "Aktif",
  ],
  [
    140105000021,
    "Kopi Celup",
    "Definisi : Kopi celup adalah kopi bubuk hasil dari biji kopi yang disangrai kemudian digiling, dengan atau tanpa penambahan bahan lain dalam kadar tertentu yang tidak membahayakan kesehatan, dan dikemas dalam kantong khusus untuk dicelup.  Karakteristik dasar : Mutu I: mengandung sari kopi 20-36% b/b, sedangkan mutu II : mengandung sari kopi tidak lebih dari 60% b/b.",
    "Aktif",
  ],
  [
    140105000022,
    "Kopi Dekafein",
    "Definisi : Kopi dekafein adalah kopi yang sebagian besar kafeinnya telah dihilangkan.  Karakteristik dasar : Mengandung tidak lebih dari 1 g/kg kafein anhidrat dihitung terhadap bobot kering.",
    "Aktif",
  ],
  [
    140105000023,
    "Kopi Instan Dekafein",
    "Definisi : Kopi instan dekafein adalah kopi instan yang sebagian besar kafeinnya telah dihilangkan.  Karakteristik dasar : Mengandung tidak lebih dari 3 g/kg kafein anhidrat dihitung terhadap bobot kering.",
    "Aktif",
  ],
  [
    140105000024,
    "Minuman Serbuk Kopi Susu",
    "Definisi : Minuman serbuk kopi susu adalah produk berbentuk bubuk, yang terdiri dari campuran kopi bubuk dan atau kopi instan, susu, dengan atau tanpa penambahan bahan pangan lain dan dikemas secara kedap.  Karakteristik dasar : \x{2022} Kadar kafein tidak kurang dari 1500 mg/kg \x{2022} Kadar protein (N x 6,38) tidak kurang dari 2,0 % (b/b)",
    "Aktif",
  ],
  [
    140105000025,
    "Minuman Serbuk Kopi Krimer",
    "Definisi : Minuman serbuk kopi krimer adalah produk berbentuk bubuk, yang terdiri dari campuran kopi bubuk dan atau kopi instan, krimer, dengan atau tanpa penambahan bahan pangan lain dan dikemas secara kedap.  Karakteristik dasar : \x{2022} Kadar kafein tidak kurang dari 1500 mg/kg; \x{2022} Kadar lemak tidak kurang dari 6,0 % (b/b).",
    "Aktif",
  ],
  [
    140105000026,
    "Minuman Serbuk Kopi",
    "Definisi : Minuman serbuk kopi adalah produk berbentuk bubuk yang terdiri dari campuran kopi dengan atau tanpa penambahan bahan pangan lain.  Karakteristik dasar : \x{2022} Kadar kafein tidak kurang dari 1500 mg/kg; \x{2022} Kandungan kopi tidak kurang dari 4% (dihitung dari basis berat kering).",
    "Aktif",
  ],
  [
    140105000027,
    "Minuman Botanikal/Minuman Rempah (Bentuk Padat atau Cair)",
    "Definisi : Minuman botanikal/minuman rempah adalah produk minuman yang dibuat dari bagian tanaman (contoh daun, bunga, biji, akar, rimpang, batang) atau ekstraknya atau cairan yang berasal dari tanaman (contoh nira, air kelapa), dengan atau tanpa penambahan bahan pangan lain. Produk dapat berbentuk padat atau cair. Nama jenis produk disesuaikan dengan bahan baku yang digunakan, misalnya minuman chrysanthemum, minuman rosela, serbuk minuman jahe, serbuk bandrek, serbuk bajigur, nira kelapa.  Karakteristik dasar : Jika mengandung kinina, kadar kinina tidak lebih dari 40 mg/kg",
    "Aktif",
  ],
  [
    140105000028,
    "Serbuk Sekoteng",
    "Definisi : Serbuk sekoteng adalah produk minuman berbentuk serbuk atau granula yang diperoleh dari campuran gula dan rempah dengan penambahan bahan pangan lain (biji delima, buah kolang-kaling, kacang hijau, kacang tanah, roti tawar).",
    "Aktif",
  ],
  [
    140105000029,
    "Minuman Sari Kacang Hijau",
    "Definisi : Minuman sari kacang hijau adalah minuman yang diperoleh dari sari kacang hijau dengan penambahan air, gula dan bahan pangan lain, melalui pemanasan dan dikemas secara kedap (hermetis).",
    "Aktif",
  ],
  [
    140105000030,
    "Serealia Celup",
    "Definisi : Serealia celup adalah produk berbentuk serbuk yang diperoleh dari biji-bijian/serealia dengan atau tanpa penambahan bahan pangan lain, dan dikemas dalam kantong dengan atau tanpa tali maupun perekat untuk dicelup.",
    "Aktif",
  ],
  [140105000031, "Minuman Serealia", "", "Aktif"],
  [
    140201000001,
    "Bir",
    "Definisi : Bir adalah minuman mengandung etanol sebagai hasil proses fermentasi khamir (yeast) terhadap bahan baku utama malt, hops (Humulus lupulus) dan air yang memberikan aroma, rasa, dan sifat khas bir dapat ditambahkan bahan pangan lain seperti: beras, jagung, gula, tapioka, barley, barley yang disangrai. Malt merupakan hasil proses pengecambahan/germinasi barley (Hordeum vulgare), gandum (Triticum sp.), atau rye (Secale cereale).  Karakteristik dasar : Kadar etanol 0,5% hingga 8%.",
    "Aktif",
  ],
  [
    140201000002,
    "Bir Hitam (Stout)",
    "Definisi : Bir hitam (stout) adalah minuman hasil fermentasi kamir yang mengapung dari malt dan biji barley (Hordeum vulgare) yang disangrai dan ditambahkan hops (Lupuli glandulae) dengan aroma hops yang kuat, berwarna hitam kecoklatan, dengan atau tanpa bahan pangan lain.  Karakteristik dasar : Kadar etanol 2% hingga 8%.",
    "Aktif",
  ],
  [
    140202000001,
    "Cider atau Anggur Apel",
    "Definisi : Cider atau anggur apel adalah minuman hasil fermentasi lumatan buah apel dan atau produk yang berasal dari buah apel (sari buah apel, konsentrat apel).  Karakteristik dasar : Kadar etanol tidak lebih dari 8,5%.",
    "Aktif",
  ],
  [
    140202000002,
    "Perry",
    "Definisi : Perry adalah minuman yang dibuat melalui fermentasi sari buah pir/pear atau campuran sari buah pir/pear dan apel dimana jumlah sari buah apel tidak lebih dari 25% v/v dari total jumlah sari buah.  Karakteristik dasar : Kadar etanol tidak lebih dari 8,5%.",
    "Aktif",
  ],
  [
    140203000001,
    "Anggur (Grape Wine)",
    "Definisi : Anggur (Grape wine) adalah minuman beralkohol hasil peragian sari buah anggur Vitis sp.  Karakteristik dasar : Kadar etanol 7%-24% v/v",
    "Aktif",
  ],
  [
    140203010001,
    "Still Grape Wine",
    "Definisi: Still grape wine (putih/white, merah/red, merah jambu/ros\xE9 atau blush, dry atau sweet) adalah anggur dengan kandungan karbondioksida tidak lebih dari 0,4 g/100 ml pada suhu 20\xB0C.  Karakteristik dasar : \x{2022} Kadar etanol 7%-24% v/v; \x{2022} Kadar karbondioksida tidak lebih dari 0,4 g/100 ml pada suhu 20\xB0C.",
    "Aktif",
  ],
  [
    140203020001,
    "Anggur Sparkling dan Semi Sparkling",
    "Definisi : Anggur sparkling dan semi sparkling adalah anggur yang menghasilkan karbondioksida selama fermentasinya, baik fermentasi dalam botol atau tangki tertutup. Termasuk di dalamnya anggur berkarbonasi dimana karbondioksidanya sebagian atau seluruhnya ditambahkan dari luar. Contohnya termasuk spumante dan anggur cold duck.  Karakteristik dasar : \x{2022} Kadar etanol 7%-24% v/v; \x{2022} Kadar karbondioksida tidak kurang dari 0,3 g/100 ml pada suhu 20\xB0C.",
    "Aktif",
  ],
  [
    140203030001,
    "Anggur Fortifikasi, Anggur Liqueur dan Anggur Manis",
    "Definisi : Anggur fortifikasi, anggur liqueur dan anggur manis adalah anggur buah yang dihasilkan dari fermentasi sari buah anggur yang tinggi kandungan gulanya, atau dengan mencampurkan konsentrat sari buah anggur dengan anggur buah atau campuran dari sari buah anggur yang difermentasi dan alkohol. Contohnya termasuk grape dessert wine.  Karakteristik dasar : Kadar etanol tidak kurang dari 7% dan tidak lebih dari 24% v/v.",
    "Aktif",
  ],
  [
    140204000001,
    "Anggur Buah",
    "Definisi : Anggur buah adalah minuman hasil fermentasi buah-buahan (selain buah anggur, apel, pir) dan hasil pertanian lainnya dengan atau tanpa bahan pangan lain. Buah-buahan dan hasil pertanian lainnya dapat dicampur dengan anggur dan atau apel dan atau pir.  Karakteristik dasar : Kadar etanol tidak kurang dari 7% dan tidak lebih dari 24% v/v.",
    "Aktif",
  ],
  [
    140204000002,
    "Anggur Beras",
    "Definisi : Anggur beras adalah minuman beralkohol hasil fermentasi beras yang telah dimasak, dengan atau tanpa penambahan bahan pangan lain.  Karakteristik dasar : Kadar etanol tidak kurang dari 7% dan tidak lebih dari 24% v/v.",
    "Aktif",
  ],
  [
    140204000003,
    "Anggur Beras Ketan",
    "Definisi : Anggur beras ketan adalah minuman beralkohol hasil fermentasi beras ketan yang telah dimasak, dengan atau tanpa penambahan bahan pangan lain.  Karakteristik dasar : Kadar etanol tidak kurang dari 7% dan tidak lebih dari 24% v/v.",
    "Aktif",
  ],
  [
    140204000004,
    "Anggur Brem Bali",
    "Definisi : Anggur brem bali adalah minuman hasil fermentasi beras ketan. Merupakan produk khas daerah Bali.  Karakteristik dasar : Kadar etanol tidak kurang dari 7% dan tidak lebih dari 24% v/v.",
    "Aktif",
  ],
  [
    140204000005,
    "Anggur Sayur (Vegetable Wine)",
    "Definisi : Anggur sayur (vegetable wine) adalah minuman beralkohol yang diperoleh dari fermentasi sari sayur dan bagian lain dari sayur.  Karakteristik dasar : Kadar etanol tidak kurang dari 7% dan tidak lebih dari 24% v/v.",
    "Aktif",
  ],
  [
    140204000006,
    "Tuak",
    "Definisi : Tuak adalah minuman beralkohol yang diperoleh dari hasil fermentasi nira kelapa atau aren.  Karakteristik dasar : Kadar etanol tidak kurang dari 7% dan tidak lebih dari 24% v/v.",
    "Aktif",
  ],
  [
    140204000007,
    "Anggur Tonikum Kinina",
    "Definisi : Anggur tonikum kinina adalah minuman beralkohol yang terbuat dari anggur yang ditambah dengan kinina atau senyawa dari kinina.  Karakteristik dasar : \x{2022} Kadar etanol tidak kurang dari 7% dan tidak lebih dari 24% v/v ; \x{2022} Kadar kinina (sebagai kinina hidroklorida) 0,6 g/l hingga 2,5 g/l.",
    "Aktif",
  ],
  [
    140204000008,
    "Sake",
    "Definisi: Sake adalah minuman beralkohol khas Jepang yang terbuat dari hasil fermentasi beras, dengan atau tanpa penambahan bahan pangan lain.  Karakteristik dasar : Kadar etanol tidak kurang dari 7% dan tidak lebih dari 24% v/v.",
    "Aktif",
  ],
  [
    140205000001,
    "Mead, Anggur Madu",
    "Definisi : Mead, anggur madu adalah minuman beralkohol yang diperoleh dari fermentasi campuran madu dengan air, atau dengan sari buah atau campuran madu, air dan sari buah dengan atau tanpa penambahan herbal atau rempah.  Karakteristik dasar : Kadar etanol tidak kurang dari 7% dan tidak lebih dari 24% v/v.",
    "Aktif",
  ],
  [
    140206000001,
    "Minuman Spirit",
    "Definisi : Minuman spirit adalah minuman beralkohol dari penyulingan cairan beralkohol hasil fermentasi biji-bijian, buah atau gula tebu.  Karakteristik dasar : Kadar etanol lebih dari 15% v/v.",
    "Aktif",
  ],
  [
    140206000002,
    "Brandy",
    "Definisi : Brandy adalah hasil penyulingan dari fermentasi buah anggur yang dimatangkan dalam tong kayu selama tidak kurang dari 1 tahun dengan ukuran tong kayu tidak lebih dari 1000 L.  Karakteristik dasar : \x{2022} Kadar etanol tidak kurang dari 36% v/v; \x{2022} Dapat mengandung gula, glukosa, fruktosa, jus anggur maupun anggur.",
    "Aktif",
  ],
  [
    140206000003,
    "Brandy Buah",
    "Definisi : Brandy buah adalah spirit yang diperoleh dari penyulingan cairan beralkohol (liqueur) hasil fermentasi buah selain buah anggur.  Karakteristik dasar : Kadar etanol tidak kurang dari 36% v/v.",
    "Aktif",
  ],
  [
    140206000004,
    "Cognac",
    "Definisi : Cognac adalah brandy yang dibuat dari penyulingan hasil fermentasi buah anggur yang tumbuh di daerah tertentu di Perancis.  Karakteristik dasar : Kandungan etanol tidak kurang dari 40% v/v.",
    "Aktif",
  ],
  [
    140206000005,
    "Rum",
    "Definisi : Rum adalah minuman beralkohol hasil destilasi dari fermentasi sari tebu, sirup tebu, molase tebu atau produk tebu lainnya.  Karakteristik dasar : Kadar etanol tidak kurang dari 37,5% v/v.",
    "Aktif",
  ],
  [
    140206000006,
    "Whisky",
    "Definisi : Whisky adalah minuman beralkohol dari spirit hasil peragian lumatan serealia atau biji-bijian atau hasil olahannya, dan dimatangkan dalam tong kayu selama tidak kurang dari 2 tahun.  Karakteristik dasar: Kadar etanol tidak kurang dari 40% v/v.",
    "Aktif",
  ],
  [
    140206000007,
    "Gin",
    "Definisi : Gin adalah hasil penyulingan fermentasi dari biji-bijian, kentang, molases, atau bahan pertanian lainnya, penyulingan ulang dari spirit hasil penyulingan atau pencampuran beberapa spirit asli dan penambahan aroma Juniper berries (Juniperus communis L. dan atau Juniperus oxicedrus L.) dengan atau tanpa penambahan gula. Umumnya gin tidak berwarna meskipun kadang-kadang berwarna emas atau coklat muda.  Karakteristik dasar : Kadar etanol tidak kurang dari 37,5%.",
    "Aktif",
  ],
  [
    140206000008,
    "Vodka",
    "Definisi : Vodka adalah hasil penyulingan produk fermentasi biji-bijian, kentang, molases, atau bahan pertanian lainnya dan setelah penyulingan ditambahkan arang atau karbon aktif atau absorben lainnya.  Karakteristik dasar: Kadar etanol tidak kurang dari 37,5%.",
    "Aktif",
  ],
  [
    140206000009,
    "Tequila",
    "Definisi : Tequila adalah minuman beralkohol yang berasal dari Meksiko, yang dihasilkan dari varietas tanaman Agave tequilana Weber blue, yang hanya ditanam di wilayah yang telah ditentukan dalam the Declaration for the Protection of the Appellation of Origin of Tequila dan memenuhi spesifikasi bahan baku, proses produksi, sifat fisiko kimia serta telah memenuhi persyaratan Regulasi Teknis Meksiko (Mexican Technical Regulation).  Jenis Tequila : 1. \x{201C}100%\x{201D} agave; spesifikasi : tidak boleh ditambahkan gula dari sumber lain 2. \x{201C}Tequila\x{201D}, spesifikasi : dapat ditambahkan gula dari sumber lain, sebelum fermentasi hingga kadar gula pereduksi tidak lebih dari 49%  Karakteristik dasar: Kadar etanol 35% - 55%.",
    "Aktif",
  ],
  [
    140206000010,
    "Arak",
    "Definisi : Arak adalah minuman beralkohol yang diperoleh dari penyulingan cairan beralkohol hasil fermentasi bahan pangan misalnya beras, shorgum, molases, nira, dan atau buah buahan.  Karakteristik dasar : \x{2022} Bau dan rasa khas; \x{2022} Kadar etanol tidak kurang dari 30% v/v.",
    "Aktif",
  ],
  [
    140206000011,
    "Genever",
    "Definisi : Genever adalah hasil penyulingan fermentasi dari biji-bijian, kentang, molases, atau bahan pertanian lainnya, penyulingan ulang dari spirit hasil penyulingan atau pencampuran beberapa spirit asli dan penambahan aroma Juniper berries (Juniperus communis L. dan atau Juniperus oxicedrus L.) dengan atau tanpa penambahan gula.  Karakteristik dasar: Kadar etanol tidak kurang dari 30% v/v.",
    "Aktif",
  ],
  [
    140206000012,
    "Liqueur",
    "Definisi : Liqueur adalah minuman beralkohol yang diperoleh dengan mencampur atau menyuling spirit dengan atau bersama buah, bunga, daun atau sayur lain atau sarinya, tunggal atau campuran atau dengan ekstrak yang berasal dari penyulingan, seduhan, perkolasi atau maserasi bahan tersebut di atas dengan atau tanpa penambahan gula.  Karakteristik dasar : \x{2022} Kadar etanol tidak kurang dari 15 % v/v; \x{2022} Kadar gula tidak kurang dari 2,5 % b/b dihitung terhadap berat produk akhir.",
    "Aktif",
  ],
  [
    140206000013,
    "Soju",
    "Definisi : Soju adalah minuman beralkohol hasil destilasi dari fermentasi beras, gandum, barley, kentang, ubi, tapioka, atau pati lainnya.  Karakteristik dasar : Kadar etanol 20-35 % v/v.",
    "Aktif",
  ],
  [
    140207000001,
    "Minuman Ringan Beralkohol",
    "Definisi : Minuman ringan beralkohol adalah minuman ringan berkarbonasi yang diberi aroma.  Karakteristik dasar : Kadar etanol tidak lebih dari 1%.",
    "Aktif",
  ],
  [
    140207000002,
    "Shandy",
    "Definisi : Shandy adalah produk minuman yang mengandung etanol tidak lebih dari 1% dibuat dari konsentrat shandy, dengan atau tanpa dicampur bir, ditambah gula, air berkarbondioksida. Umumnya shandy diperoleh dari campuran bir dan minuman tidak beralkohol.  Karakteristik dasar : Kadar etanol tidak lebih dari 1%.",
    "Aktif",
  ],
  [
    140207000003,
    "Anggur Rendah Alkohol",
    "Definisi : Anggur rendah alkohol adalah anggur yang dikurangi kadar etanolnya dengan cara selain pengenceran dengan air.  Karakteristik dasar : Kadar etanol : reduced alcohol wine 1,2% hingga 6,5% v/v dan low alcohol wine tidak lebih dari 1,2 % v/v.",
    "Aktif",
  ],
  [
    140207000004,
    "Koktail Anggur (Wine Cocktail)",
    "Definisi : Koktail anggur (wine cocktail) adalah anggur atau anggur fortifikasi yang ditambah dengan salah satu atau campuran dari vegetable bitters, bahan aroma, buah, sari buah atau bahan aroma buah, herbal kering dan atau aromanya.  Karakteristik dasar : Kadar etanol 7% hingga 24%.",
    "Aktif",
  ],
  [
    140207000005,
    "Meat Wine",
    "Definisi : Meat wine adalah anggur yang ditambah dengan sari daging atau sari daging sapi.  Karakteristik dasar : \x{2022} Kadar protein tidak kurang dari 20 g/l; \x{2022} Kadar etanol 7% hingga 24%.",
    "Aktif",
  ],
  [
    140207000006,
    "Anggur Mengandung bahan pangan lain (antara lain : Ginseng/kolesom/temulawak)",
    "Definisi : Anggur mengandung bahan pangan lain adalah anggur ditambah dengan sari atau bahan pangan lain.  Karakteristik dasar : Kadar etanol 7% hingga 24%;",
    "Aktif",
  ],
  [140207000007, "Minuman Beralkohol Golongan A", "", "Aktif"],
  [140207000008, "Minuman Beralkohol Golongan B", "", "Aktif"],
  [140207000009, "Minuman Beralkohol Golongan C", "", "Aktif"],
  [
    150100000001,
    "Keripik Kentang",
    "Definisi : Keripik kentang adalah makanan ringan yang dibuat dari umbi kentang (Solanum tuberosum) berbentuk irisan tipis dari kentang utuh atau irisan dari kentang yang sudah dipotong dan diolah dengan proses penggorengan atau pemanggangan atau proses lain yang sesuai sehingga diperoleh produk bertekstur renyah siap konsumsi dengan atau tanpa penambahan bahan pangan lain.  Karakteristik dasar : \x{2022} Tekstur renyah; \x{2022} Kadar air tidak lebih dari 3%. (dusty), tidak lebih dari 7% (salut).",
    "Aktif",
  ],
  [
    150100000002,
    "Keripik Gadung",
    "Definisi : Keripik gadung adalah makanan kering yang dibuat dari gadung (Dioscorea hispida) berbentuk irisan tipis yang digoreng dengan atau tanpa penambahan bahan pangan lain.  Karakteristik dasar : \x{2022} Tekstur renyah; \x{2022} Kadar air tidak lebih dari 6%.",
    "Aktif",
  ],
  [
    150100000003,
    "Krekers Beras (Senbei)",
    "Definisi : Kreker beras (senbei) adalah makanan ringan yang terbuat dari beras atau tepung beras dengan campuran bahan atau pati lain dan bahan pangan lain.  Karakteristik dasar : Kadar air tidak lebih dari 3%.",
    "Aktif",
  ],
  [
    150100000004,
    "Keripik Singkong ",
    "Definisi : Keripik singkong adalah makanan ringan yang dibuat dari umbi singkong (Manihot sp.) berbentuk irisan tipis dari singkong utuh atau irisan singkong yang sudah dipotong dan diolah dengan proses penggorengan atau pemanggangan atau proses lain yang sesuai, sehingga diperoleh produk bertekstur renyah siap konsumsi dengan atau tanpa penambahan bahan pangan lain.  Karakteristik dasar : \x{2022} Tekstur renyah; \x{2022} Kadar air maksimal 6% (dusty), 7% (salut)",
    "Aktif",
  ],
  [
    150100000005,
    "Dakak-dakak",
    "Definisi : Dakak-dakak adalah makanan ringan khas Sumatera Barat yang dibuat dari irisan singkong dengan campuran bumbu kunyit, bawang putih dan irisan daun seledri dan diproses dengan cara digoreng.",
    "Aktif",
  ],
  [
    150100000006,
    "Lanting/Karak Kaliang",
    "Definisi : Lanting/karak kaliang adalah makanan ringan yang dibuat dari singkong dengan campuran bahan pangan lain, biasanya berbentuk angka delapan atau nol dan diproses dengan cara digoreng.",
    "Aktif",
  ],
  [
    150100000007,
    "Keripik Ubi Jalar  ",
    "Definisi : Keripik ubi jalar adalah makanan kering yang dibuat dari ubi jalar (Ipomea batatas) berbentuk irisan tipis yang digoreng dengan atau tanpa penambahan bahan pangan lain.  Karakteristik dasar : \x{2022} Tekstur renyah; \x{2022} Kadar air tidak lebih dari 5%.",
    "Aktif",
  ],
  [
    150100000008,
    "Keripik Tempe ",
    "Definisi : Keripik tempe adalah makanan ringan yang dibuat dari tempe kedelai (Glycine max) berbentuk lempengan/irisan tipis dengan proses penggorengan atau pengeringan sehingga diperoleh produk bertekstur renyah dengan atau tanpa penambahan bahan pangan lain.  Karakteristik dasar : \x{2022} Tekstur renyah; \x{2022} Kadar air tidak lebih dari 4%.",
    "Aktif",
  ],
  [
    150100000009,
    "Keripik Oncom ",
    "Definisi : Keripik oncom adalah makanan khas dari Bandung yang umumnya terbuat dari oncom merah, yang merupakan hasil fermentasi bungkil kacang kedelai. Keripik oncom terbuat dari oncom yang diiris tipis-tipis, kemudian dilapisi dengan campuran tepung dan bahan pangan lain. Potongan oncom yang telah tertutupi oleh adonan tepung kemudian digoreng hingga renyah. Dapat juga menggunakan oncom hitam.",
    "Aktif",
  ],
  [
    150100000010,
    "Keripik Tahu/Keripik Produk Tahu/Keripik Kembang Tahu",
    "Definisi : Keripik tahu/keripik produk tahu/keripik kembang tahu adalah makanan kering yang dibuat dari tahu atau produk olahan tahu dengan proses penggorengan atau pengeringan sehingga diperoleh produk bertekstur renyah dengan atau tanpa penambahan bahan pangan lain.  Karakteristik dasar : Kadar air tidak lebih dari 10%.",
    "Aktif",
  ],
  [
    150100000011,
    "Keripik Talas",
    "Definisi : Keripik talas adalah makanan ringan yang dibuat dari umbi talas (Colocasia esculenta L) berbentuk irisan tipis yang digoreng dengan atau tanpa penambahan bahan pangan lain.  Karakteristik dasar : \x{2022} Tekstur renyah; \x{2022} Kadar air tidak lebih dari 5%.",
    "Aktif",
  ],
  [
    150100000012,
    "Makanan Ringan Simulasi",
    "Definisi : Makanan ringan simulasi adalah makanan ringan yang terbuat dari tepung dan/atau pati (serealia, umbi, kacang-kacangan) dengan pencampuran bahan lain, dibentuk atau dipotong, dijemur/dikeringkan atau langsung digoreng/dioven. Produk ini tidak termasuk keripik kentang, keripik singkong atau keripik umbi-umbian lainnya.",
    "Aktif",
  ],
  [
    150100000013,
    "Kecimpring ",
    "Definisi : Kecimpring adalah makanan ringan yang terbuat dari singkong (ubi kayu), bumbu. Pembuatan meliputi pemarutan singkong untuk dicampur dengan bumbu. Kemudian adonan dipres hingga tipis, dilanjutkan dengan pengukusan dan penjemuran. Setelah kering, cetakan (pelat pres) dilepas, dipotong dan digoreng.",
    "Aktif",
  ],
  [
    150100000014,
    "Opak",
    "Definisi : Opak adalah makanan ringan yang terbuat dari tepung beras atau singkong atau umbi-umbi lainnya yang diparut dengan penambahan bahan lain, dibentuk dan dipanggang.  Karakterstik dasar : Kadar air tidak lebih dari 3%",
    "Aktif",
  ],
  [
    150100000015,
    "Simping",
    "Definisi : Simping adalah makanan ringan khas Jawa Barat dengan rasa asin dan citarasa khas. Simping terbuat dari bahan tapioka, garam dan kencur halus yang dicampur menjadi adonan, kemudian dimasak pada cetakan khusus (dipres diantara dua pelat tebal) dan proses pemasakan melibatkan pembakaran kedua pelat tersebut pada api secara langsung.",
    "Aktif",
  ],
  [
    150100000016,
    "Slondok",
    "Definisi : Slondok adalah makanan ringan terbuat dari tepung singkong atau tapioka dengan campuran bahan dan pati lain.",
    "Aktif",
  ],
  [
    150100000017,
    "Pilus",
    "Definisi : Pilus adalah makanan ringan terbuat dari tepung singkong/tapioka dengan campuran bahan atau pati lain dan bumbu rempah; yang diproses dengan atau tanpa menggunakan mesin ekstrusi kemudian dipotong menjadi ukuran kecil dan digoreng atau dipanggang.  Karakteristik dasar : Kadar air tidak lebih dari 2% (tanpa coating), 3% (dengan coating)",
    "Aktif",
  ],
  [
    150100000018,
    "Jagung Berondong",
    "Definisi : Jagung berondong adalah makanan ringan terbuat dari jagung (Zea mays) varietas popping corn, diolah dengan pemanasan hingga menyebabkan peletupan dan pengembangan dengan atau tanpa penambahan bahan pangan lain.",
    "Aktif",
  ],
  [
    150100000019,
    "Jagung Marning",
    "Definisi : Jagung marning adalah makanan ringan yang dibuat dari biji jagung (Zea mays) tua, direbus, dikeringkan dan digoreng dengan atau tanpa penambahan bahan pangan lain.",
    "Aktif",
  ],
  [
    150100000020,
    "Jipang Jagung ",
    "Definisi : Jipang jagung adalah makanan ringan dibuat dari jagung (Zea mays) yang diolah sampai mengembang dengan proses penggorengan atau pemanggangan atau puffing/ekstrusi atau terlebih dahulu dikukus, dikeringkan dan digoreng sampai mengembang, dicampur dengan gula, kemudian dicetak, dengan atau tanpa penambahan bahan pangan lain.  Karakteristik dasar : Kadar air tidak lebih dari 7%.",
    "Aktif",
  ],
  [
    150100000021,
    "Jipang Beras",
    "Definisi : Jipang beras adalah produk makanan ringan yang dibuat dari beras (Oryza sativa L.) dan/atau beras ketan (Oryza sativa var. glutinosa) yang diolah dengan proses penggorengan atau pemanggangan atau puffing/ekstrusi atau terlebih dahulu dikukus, dikeringkan dan digoreng sampai mengembang, dicampur dengan gula, kemudian dicetak, dengan atau tanpa penambahan bahan pangan lain.   Karakteristik dasar : Kadar air tidak lebih dari 8%.",
    "Aktif",
  ],
  [
    150100000022,
    "Jipang Melinjo ",
    "Definisi : Jipang melinjo adalah makanan ringan dibuat dari melinjo (Gnetum gnemon) yang diolah dengan proses penggorengan atau pemanggangan atau puffing/ekstrusi atau terlebih dahulu dikukus, dikeringkan dan digoreng sampai mengembang, dicampur dengan gula, kemudian dicetak, dengan atau tanpa penambahan bahan pangan lain.  Karakteristik dasar : Kadar air tidak lebih dari 8%.",
    "Aktif",
  ],
  [
    150100000023,
    "Kerupuk Beras ",
    "Definisi : Kerupuk beras adalah makanan ringan terbuat dari bahan tepung beras atau tepung beras ketan yang dengan atau tanpa penambahan bahan pangan lain, dibentuk, direbus/dikukus, dicetak lempengan tipis, dikeringkan dan digoreng.",
    "Aktif",
  ],
  [
    150100000024,
    "Kerupuk Karak ",
    "Definisi : Kerupuk karak adalah makanan ringan terbuat dari hasil pemasakan nasi, ditumbuk yang kemudian dikeringkan kembali untuk digoreng.",
    "Aktif",
  ],
  [
    150100000025,
    "Kerupuk Intip ",
    "Definisi : Kerupuk intip adalah makanan ringan terbuat dari bagian/lapisan yang diperoleh dari hasil pemasakan nasi yang menempel pada bagian dasar wadah, dikeringkan kembali untuk digoreng dengan atau tanpa penambahan bahan pangan lain.",
    "Aktif",
  ],
  [
    150100000026,
    "Rengginang/Batiah",
    "Definisi : Rengginang/batiah adalah makanan ringan terbuat dari beras ketan yang telah dimasak menjadi nasi ketan terlebih dahulu, dengan atau tanpa penambahan bahan pangan lain, dibentuk, dijemur hingga kering dan digoreng.",
    "Aktif",
  ],
  [
    150100000027,
    "Patilo / Rengginang Singkong",
    "Definisi : Patilo/rengginang singkong adalah makanan ringan sejenis rengginang yang terbuat dari singkong, dengan atau tanpa penambahan bahan pangan lain, dibentuk, dijemur hingga kering dan digoreng.",
    "Aktif",
  ],
  [
    150100000028,
    "Rempeyek ",
    "Definisi : Rempeyek adalah makanan ringan berbentuk tipis dan renyah, terbuat dari tepung beras dengan atau tanpa campuran tepung lain, dicampur dengan bahan pangan lain seperti kacang tanah, kacang kedelai, kacang hijau, ikan atau bahan pangan lain kemudian digoreng. Nama jenis untuk produk ini misalnya rempeyek kacang, rempeyek kacang kedelai.",
    "Aktif",
  ],
  [
    150100000029,
    "Makanan Ringan Ekstrudat",
    "Definisi : Makanan ringan siap makan yang dibuat dari bahan pangan sumber karbohidrat dan/atau protein melalui proses ekstrusi dengan atau tanpa penambahan bahan pangan lain, dengan atau tanpa melalui proses lainnya seperti penggorengan/ pemanggangan.  Karakteristik dasar : Kadar air tidak lebih dari 4%.",
    "Aktif",
  ],
  [
    150100000030,
    "Emping Melinjo Goreng",
    "Definisi : Emping melinjo goreng adalah produk keripik3 yang diperoleh dari emping melinjo yang digoreng dengan atau tanpa penambahan bahan lain.",
    "Aktif",
  ],
  [
    150100000031,
    "Makanan Ringan Berbentuk Batang/Bar",
    "Definisi : Makanan ringan terbuat dari campuran bahan sumber karbohidrat dan/atau protein, dengan atau tanpa penambahan gula, lemak, dan bahan pangan lain seperti cokelat, buah kering, serealia, dan dibentuk batang (bar).",
    "Aktif",
  ],
  [
    150100000032,
    "Krekers Rasa",
    "Definisi : Krekers rasa adalah jenis krekers dari terigu dan/atau non terigu yang dalam pembuatannya memerlukan proses fermentasi atau tidak, serta melalui proses laminasi sehingga menghasilkan bentuk pipih dan bila dipatahkan penampangnya tampak berlapis-lapis, diberi bahan sebagai sumber rasa misalnya gula, keju, abon, cokelat. Nama jenis untuk kategori ini disesuaikan dengan bahan sumber rasanya, misalnya krekers abon, krekers cokelat, krekers manis, krekers gurih.  Karakteristik dasar : Kadar air tidak lebih dari 5%",
    "Aktif",
  ],
  [
    150100000033,
    "Krekers Sandwich ",
    "Definisi : Krekers sandwich adalah jenis krekers dari terigu dan/atau non terigu dengan menggunakan krim filling (rasa keju, rasa coklat, rasa buah, dan lain-lain) sedikitnya terdiri dari 2 (dua) keping krekers.",
    "Aktif",
  ],
  [
    150100000034,
    "Malkist ",
    "Definisi : Malkist adalah jenis krekers dari terigu dan/atau non terigu fermentasi yang pada proses laminasinya menggunakan cracker dust di antara lapisan-lapisannya yang permukaannya disalut atau ditaburi gula.  Karakteristik dasar : Kadar air tidak lebih dari 5%.",
    "Aktif",
  ],
  [150100000035, "Keripik Lainnya", "", "Aktif"],
  [
    150200000001,
    "Kacang Garing/Kacang Kulit",
    "Definisi : Kacang garing/kacang kulit adalah kacang tanah atau kacang lainnya yang masih dalam kulitnya, direndam, direbus dengan atau tanpa penambahan bahan pangan lain, ditiriskan kemudian dipanggang/dioven.  Karakteristik dasar : Kadar air tidak lebih dari 3%",
    "Aktif",
  ],
  [
    150200000002,
    "Kacang Sangrai ",
    "Definisi : Kacang sangrai adalah kacang tanah yang masih dalam kulitnya dan disangrai.  Karakteristik dasar : Kadar air tidak lebih dari 3%",
    "Aktif",
  ],
  [
    150200000003,
    "Kacang Goreng",
    "Definisi : Kacang goreng adalah kacang tanah dengan atau tanpa kulit ari, yang telah digoreng, dengan atau tanpa penambahan bahan pangan lain.",
    "Aktif",
  ],
  [
    150200000004,
    "Kacang Goreng Lainnya ",
    "Definisi : Kacang goreng lainnya adalah kacang selain kacang tanah dengan atau tanpa kulit ari, yang telah digoreng, dengan atau tanpa penambahan bahan pangan lain. Nama jenis untuk produk ini misalnya kacang kedelai goreng, kacang koro goreng, kacang kapri goreng, kacang bogor goreng.",
    "Aktif",
  ],
  [
    150200000005,
    "Kacang Bawang / Kacang Tojin",
    "Definisi : Kacang bawang/kacang tojin adalah kacang tanah yang dihilangkan kulit arinya, direndam dengan bawang putih dan garam, dengan atau tanpa penambahan bahan pangan lain, ditiriskan kemudian digoreng.",
    "Aktif",
  ],
  [
    150200000006,
    "Kacang Panggang ",
    "Definisi : Kacang panggang adalah kacang tanah yang telah dihilangkan kulit arinya, kemudian dipanggang/dioven. Dengan atau tanpa pelapisan bumbu. Nama jenis untuk produk ini misalnya kacang Bali.",
    "Aktif",
  ],
  [
    150200000007,
    "Kacang Panggang Lainnya ",
    "Definisi : Kacang panggang lainnya adalah kacang selain kacang tanah yang telah dihilangkan kulit arinya, kemudian dipanggang/dioven. Dengan atau tanpa pelapisan bumbu. Nama jenis untuk produk ini misalnya kacang mede panggang, kacang koro panggang.",
    "Aktif",
  ],
  [
    150200000008,
    "Kacang Atom/Sukro ",
    "Definisi : Kacang atom/sukro adalah makanan ringan yang terbuat dari kacang tanah dan disalut dengan adonan tepung dan/atau pati, dan digoreng atau dipanggang. Dapat ditambahkan bumbu atau bahan pangan lain.  Karakteristik dasar : Kadar air tidak lebih dari 3%.",
    "Aktif",
  ],
  [
    150200000009,
    "Kacang Atom Lainnya",
    "Definisi : Kacang atom lainnya adalah makanan ringan yang terbuat dari kacang selain kacang tanah dan disalut dengan adonan tepung dan/atau pati, dan digoreng atau dipanggang. Dapat ditambahkan bumbu atau bahan pangan lain. Nama jenis untuk produk ini misalnya kacang atom kedelai.  Karakteristik dasar : Kadar air tidak lebih dari 3%.",
    "Aktif",
  ],
  [
    150200000010,
    "Kacang Telur ",
    "Definisi : Kacang telur adalah makanan ringan yang terbuat dari kacang tanah (Arachis hypogea L) dan disalut dengan adonan tepung dan/atau pati dan telur yang telah dibumbui dan digoreng.",
    "Aktif",
  ],
  [
    150200000011,
    "Kacang Goyang ",
    "Definisi : Kacang goyang adalah kacang tanah (Arachis hypogea L) yang telah dihilangkan kulit arinya, disalut dengan adonan bergula, kemudian diproses dengan penggoyangan secara panas.  Karakteristik dasar : Kadar air tidak lebih dari 5%.",
    "Aktif",
  ],
  [
    150200000012,
    "Jipang/Kipang Kacang ",
    "Definisi : Jipang/kipang kacang adalah makanan ringan, dibuat dari kacang tanah (Arachis hypogea L) atau kacang lainnya, disangrai, dihilangkan kulit arinya, dicampur dengan gula, dengan atau tanpa penambahan bahan pangan lain.  Karakteristik dasar : Kadar air tidak lebih dari 7%.",
    "Aktif",
  ],
  [
    150200000013,
    "Kacang Bersalut",
    "Definisi : Kacang bersalut adalah makanan ringan, dibuat dari kacang yang dilapisi dengan tepung/pati, gula atau bahan lainnya. Kacang bersalut termasuk di dalamnya kacang atom/sukro, kacang telur, kacang goyang, dan lain-lain.",
    "Aktif",
  ],
  [
    150300000001,
    "Kerupuk Hasil Perikanan",
    "Definisi : Kerupuk hasil perikanan adalah makanan ringan, dibuat dari adonan campuran pati dan/atau tepung, hasil perikanan, dengan atau tanpa bahan pangan lain, dikukus, dipotong/dibentuk, dikeringkan lalu digoreng atau proses lainnya. Nama jenis untuk produk ini misalnya kerupuk ikan tengiri, kerupuk Palembang, kemplang, kerupuk udang, kerupuk cumi, kerupuk kupang, getas  Karakteristik dasar : Kadar air tidak lebih dari 3%.",
    "Aktif",
  ],
  [
    150300000002,
    "Rempeyek Ikan",
    "Definisi : Rempeyek ikan adalah makanan ringan dibuat dari tepung beras dengan atau tanpa campuran pati lain, dicampur dengan bahan lain seperti teri, udang atau bahan pangan lain kemudian digoreng.",
    "Aktif",
  ],
  [
    150300000003,
    "Sumpia Udang",
    "Definisi : Sumpia udang adalah makanan ringan yang berbentuk seperti lumpia dengan ukuran kecil yang dibuat dari adonan tepung terigu dan/atau tepung lainnya, diisi udang dengan atau tanpa bahan pangan lain dan digoreng.",
    "Aktif",
  ],
  [
    160000000001,
    "Makanan Siap Saji Berbasis Nasi (Terkemas)",
    "Definisi: Makanan cepat saji berbasis nasi, misalnya nasi goreng, nasi uduk, nasi kuning, nasi opor ayam, nasi rendang ayam, ketupat sayur, pecel lele, lontong sate ayam, bubur ayam.",
    "Aktif",
  ],
  [
    160000000002,
    "Makanan Siap Saji Berbasis Mi/Bihun (Terkemas)",
    "Definisi: Makanan cepat saji berbasis mi/bihun, kecuali mi instan dengan bahan pelengkap/garnish yang kering. Misalnya mi/bihun goreng dengan ayam, mi/bihun ayam jamur, mi rendang, ramen ayam.",
    "Aktif",
  ],
  [
    160000000003,
    "Makanan Siap Saji Berbasis Kentang (Terkemas)",
    "Definisi: Makanan cepat saji berbasis kentang, misalnya steak.",
    "Aktif",
  ],
  [
    160000000004,
    "Makanan Siap Saji Berbasis Pasta (Terkemas)",
    "Definisi: Makanan cepat saji berbasis pasta, misalnya makaroni dan keju, lasagna, spaghetti marinara.",
    "Aktif",
  ],
  [
    160000000005,
    "Makanan Siap Saji Berbasis Umbi (Terkemas)",
    "Definisi: Makanan cepat saji berbasis umbi, seperti tiwul dengan lauk.",
    "Aktif",
  ],
  [
    160000000006,
    "Makanan Siap Saji Berbasis Roti (Terkemas)",
    "Definisi: Makanan cepat saji berbasis roti, seperti burger, pizza, hotdog, kebab, panini, tortilla, roti canai dan kare.",
    "Aktif",
  ],
  [
    160000000007,
    "Makanan Siap Saji Berbasis Kuah (Terkemas)",
    "Definisi: Makanan cepat saji berkuah, misalnya soto bersantan, soto tanpa santan, sop, rawon, sambal tumpang, dan brongkos.",
    "Aktif",
  ],
  [
    160000000008,
    "Makanan Siap Saji Berbasis Sayuran (Terkemas)",
    "Definisi: Makanan cepat saji berbasis sayuran, misalnya pecel, lotek, cap cay, gado-gado, karedok, rujak cingur, sayur nangka, dan gudeg.",
    "Aktif",
  ],
];
# END FRAGMENT id=data-idn_bpom_kategori_pangan_rba

my $res = gen_read_table_func(
    name => 'bpom_list_food_categories_rba',
    summary => 'List food categories in BPOM processed food division (RBA version)',
    table_data => $data_idn_bpom_kategori_pangan_rba,
    table_spec => $meta_idn_bpom_kategori_pangan_rba,
    description => <<'_',
_
    extra_props => {
        examples => [
            {
                summary => 'Print active categories codes matching "cokelat"',
                src_plang => "bash",
                src => "[[prog]] --status-is Aktif 'cokelat hitam'",
                test => 0,
            },
            {
                summary => 'Print active records matching "cokelat hitam" in a formatted text table',
                src_plang => "bash",
                src => "[[prog]] --status-is Aktif 'cokelat hitam' -l --format text-pretty",
                test => 0,
            },
            {
                summary => 'Print all category records with code 14.1.4.2',
                src_plang => "bash",
                src => "[[prog]] --code-matches '^14010402' -l --format text-pretty",
                test => 0,
            },
            {
                summary => 'How many categories are active vs inactive?',
                src_plang => "bash",
                src => "echo -n 'Aktif: '; [[prog]] --status-is Aktif | wc -l; echo -n 'Tidak Aktif: '; [[prog]] --status-isnt Aktif | wc -l",
                test => 0,
            },
        ],
    },
    hooks => {
        before_return => sub {
            my %args = @_;

            if ($args{_func_args}{detail}) {
                # format text in summary
                for my $row (@{ $args{_func_res}[2] }) {
                    next unless $row->{summary};
                    for ($row->{summary}) {
                        s/\.  /.\n\n/g;
                        s/ \x{2022}/\n\n\x{2022}/g;
                    }
                }

                # XXX adjust other properties e.g. table.field_formats etc
                $args{_func_res}[3]{'table.fields'} = ['status'];

                # since 'summary' field is usually long text, we prefer to show it using Text::ANSITable
                $ENV{FORMAT_PRETTY_TABLE_BACKEND} //= 'Text::ANSITable';
            }

            1;
        },
    },
);
die "Can't generate function: $res->[0] - $res->[1]" unless $res->[0] == 200;

# ABSTRACT: List food categories in BPOM processed food division (RBA version)

__END__

=pod

=encoding UTF-8

=head1 NAME

App::BPOMUtils::Table::FoodCategoryRBA - List food categories in BPOM processed food division (RBA version)

=head1 VERSION

This document describes version 0.019 of App::BPOMUtils::Table::FoodCategoryRBA (from Perl distribution App-BPOMUtils-Table-FoodCategory), released on 2023-09-03.

=head1 FUNCTIONS


=head2 bpom_list_food_categories_rba

Usage:

 bpom_list_food_categories_rba(%args) -> [$status_code, $reason, $payload, \%result_meta]

List food categories in BPOM processed food division (RBA version).

This function is not exported by default, but exportable.

Arguments ('*' denotes required arguments):

=over 4

=item * B<code> => I<str>

Only return records where the 'code' field equals specified value.

=item * B<code.contains> => I<str>

Only return records where the 'code' field contains specified text.

=item * B<code.in> => I<array[str]>

Only return records where the 'code' field is in the specified values.

=item * B<code.is> => I<str>

Only return records where the 'code' field equals specified value.

=item * B<code.isnt> => I<str>

Only return records where the 'code' field does not equal specified value.

=item * B<code.matches> => I<str>

Only return records where the 'code' field matches specified regular expression pattern.

=item * B<code.max> => I<str>

Only return records where the 'code' field is less than or equal to specified value.

=item * B<code.min> => I<str>

Only return records where the 'code' field is greater than or equal to specified value.

=item * B<code.not_contains> => I<str>

Only return records where the 'code' field does not contain specified text.

=item * B<code.not_in> => I<array[str]>

Only return records where the 'code' field is not in the specified values.

=item * B<code.not_matches> => I<str>

Only return records where the 'code' field does not match specified regular expression.

=item * B<code.xmax> => I<str>

Only return records where the 'code' field is less than specified value.

=item * B<code.xmin> => I<str>

Only return records where the 'code' field is greater than specified value.

=item * B<detail> => I<bool> (default: 0)

Return array of full records instead of just ID fields.

By default, only the key (ID) field is returned per result entry.

=item * B<exclude_fields> => I<array[str]>

Select fields to return.

=item * B<fields> => I<array[str]>

Select fields to return.

=item * B<name> => I<str>

Only return records where the 'name' field equals specified value.

=item * B<name.contains> => I<str>

Only return records where the 'name' field contains specified text.

=item * B<name.in> => I<array[str]>

Only return records where the 'name' field is in the specified values.

=item * B<name.is> => I<str>

Only return records where the 'name' field equals specified value.

=item * B<name.isnt> => I<str>

Only return records where the 'name' field does not equal specified value.

=item * B<name.matches> => I<str>

Only return records where the 'name' field matches specified regular expression pattern.

=item * B<name.max> => I<str>

Only return records where the 'name' field is less than or equal to specified value.

=item * B<name.min> => I<str>

Only return records where the 'name' field is greater than or equal to specified value.

=item * B<name.not_contains> => I<str>

Only return records where the 'name' field does not contain specified text.

=item * B<name.not_in> => I<array[str]>

Only return records where the 'name' field is not in the specified values.

=item * B<name.not_matches> => I<str>

Only return records where the 'name' field does not match specified regular expression.

=item * B<name.xmax> => I<str>

Only return records where the 'name' field is less than specified value.

=item * B<name.xmin> => I<str>

Only return records where the 'name' field is greater than specified value.

=item * B<queries> => I<array[str]>

Search.

This will search all searchable fields with one or more specified queries. Each
query can be in the form of C<-FOO> (dash prefix notation) to require that the
fields do not contain specified string, or C</FOO/> to use regular expression.
All queries must match if the C<query_boolean> option is set to C<and>; only one
query should match if the C<query_boolean> option is set to C<or>.

=item * B<query_boolean> => I<str> (default: "and")

Whether records must match all search queries ('and') or just one ('or').

If set to C<and>, all queries must match; if set to C<or>, only one query should
match. See the C<queries> option for more details on searching.

=item * B<random> => I<bool> (default: 0)

Return records in random order.

=item * B<result_limit> => I<int>

Only return a certain number of records.

=item * B<result_start> => I<int> (default: 1)

Only return starting from the n'th record.

=item * B<sort> => I<array[str]>

Order records according to certain field(s).

A list of field names separated by comma. Each field can be prefixed with '-' to
specify descending order instead of the default ascending.

=item * B<status> => I<str>

Only return records where the 'status' field equals specified value.

=item * B<status.contains> => I<str>

Only return records where the 'status' field contains specified text.

=item * B<status.in> => I<array[str]>

Only return records where the 'status' field is in the specified values.

=item * B<status.is> => I<str>

Only return records where the 'status' field equals specified value.

=item * B<status.isnt> => I<str>

Only return records where the 'status' field does not equal specified value.

=item * B<status.matches> => I<str>

Only return records where the 'status' field matches specified regular expression pattern.

=item * B<status.max> => I<str>

Only return records where the 'status' field is less than or equal to specified value.

=item * B<status.min> => I<str>

Only return records where the 'status' field is greater than or equal to specified value.

=item * B<status.not_contains> => I<str>

Only return records where the 'status' field does not contain specified text.

=item * B<status.not_in> => I<array[str]>

Only return records where the 'status' field is not in the specified values.

=item * B<status.not_matches> => I<str>

Only return records where the 'status' field does not match specified regular expression.

=item * B<status.xmax> => I<str>

Only return records where the 'status' field is less than specified value.

=item * B<status.xmin> => I<str>

Only return records where the 'status' field is greater than specified value.

=item * B<summary> => I<str>

Only return records where the 'summary' field equals specified value.

=item * B<summary.contains> => I<str>

Only return records where the 'summary' field contains specified text.

=item * B<summary.in> => I<array[str]>

Only return records where the 'summary' field is in the specified values.

=item * B<summary.is> => I<str>

Only return records where the 'summary' field equals specified value.

=item * B<summary.isnt> => I<str>

Only return records where the 'summary' field does not equal specified value.

=item * B<summary.matches> => I<str>

Only return records where the 'summary' field matches specified regular expression pattern.

=item * B<summary.max> => I<str>

Only return records where the 'summary' field is less than or equal to specified value.

=item * B<summary.min> => I<str>

Only return records where the 'summary' field is greater than or equal to specified value.

=item * B<summary.not_contains> => I<str>

Only return records where the 'summary' field does not contain specified text.

=item * B<summary.not_in> => I<array[str]>

Only return records where the 'summary' field is not in the specified values.

=item * B<summary.not_matches> => I<str>

Only return records where the 'summary' field does not match specified regular expression.

=item * B<summary.xmax> => I<str>

Only return records where the 'summary' field is less than specified value.

=item * B<summary.xmin> => I<str>

Only return records where the 'summary' field is greater than specified value.

=item * B<with_field_names> => I<bool>

Return field names in each record (as hashE<sol>associative array).

When enabled, function will return each record as hash/associative array
(field name => value pairs). Otherwise, function will return each record
as list/array (field value, field value, ...).


=back

Returns an enveloped result (an array).

First element ($status_code) is an integer containing HTTP-like status code
(200 means OK, 4xx caller error, 5xx function error). Second element
($reason) is a string containing error message, or something like "OK" if status is
200. Third element ($payload) is the actual result, but usually not present when enveloped result is an error response ($status_code is not 2xx). Fourth
element (%result_meta) is called result metadata and is optional, a hash
that contains extra information, much like how HTTP response headers provide additional metadata.

Return value:  (any)

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/App-BPOMUtils-Table-FoodCategory>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-App-BPOMUtils-Table-FoodCategory>.

=head1 SEE ALSO

L<App::BPOMUtils::Table::FoodCategory>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2023 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=App-BPOMUtils-Table-FoodCategory>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
