package Tk::TabbedForm::CListItem;

=head1 NAME

Tk::TabbedForm::CListItem - ListEntry widget for Tk::TabbedForm.

=cut

use strict;
use warnings;
use Tk;
use base qw(Tk::Derived Tk::TabbedForm::CTextItem);
Construct Tk::Widget 'CListItem';

require Tk::ListEntry;

=head1 SYNOPSIS

 require Tk::TabbedForm::CListItem;
 my $bool = $window->CListItem(@options)->pack;

=head1 DESCRIPTION

Inherits L<Tk::TabbedForm::CTextItem>. Provides a list entry for L<Tk::TabbedForm>. 

You should never create an instance directly like above. This should
be handled by L<Tk::TabbedForm>.

=head1 B<CONFIG VARIABLES>

=over 4

=item Switch: B<-values>

The list of possible values.

=back

=cut

sub Populate {
	my ($self,$args) = @_;

	my $values = delete $args->{'-values'};
	warn "You need to set the -values option" unless defined $values;
	$self->{VALUES} = $values;

	$self->SUPER::Populate($args);

	$self->ConfigSpecs(
		DEFAULT => ['SELF'],
	);
}

sub createHandler {
	my ($self, $var) = @_;
	my $values = $self->{VALUES};
	my $e = $self->ListEntry(
		-textvariable => $var,
		-values => $values,
	)->pack(-side => 'left', -padx => 2, -expand => 1, -fill => 'x');
	$self->Advertise(Entry => $e);
}

sub validate {
	my $self = shift;
	my $flag = $self->Subwidget('Entry')->validate;
	$self->validUpdate($flag);
	return $flag
}

=head1 LICENSE

Same as Perl.

=head1 AUTHOR

Hans Jeuken (hanje at cpan dot org)

=head1 BUGS

Unknown. If you find any, please contact the author.

=head1 SEE ALSO

=over 4

=item L<Tk::ListEntry>

=item L<Tk::TabbedForm>

=item L<Tk::TabbedForm::CBaseClass>

=item L<Tk::TabbedForm::CTextItem>


=back

=cut



1;

__END__
