package Tk::TabbedForm::CFileItem;

=head1 NAME

Tk::TabbedForm::CFileItem - File select entry widget for Tk::TabbedForm.

=cut

use strict;
use warnings;
use base qw(Tk::Derived Tk::TabbedForm::CTextItem);
Construct Tk::Widget 'CFileItem';

=head1 SYNOPSIS

 require Tk::TabbedForm::CFileItem;
 my $bool = $window->CFileItem(@options)->pack;

=head1 DESCRIPTION

Inherits L<Tk::TabbedForm::CTextItem>. Provides a file entry with dialog for L<Tk::TabbedForm>.

You should never create an instance directly like above. This should
be handled by L<Tk::TabbedForm>.

=head1 B<CONFIG VARIABLES>

=over 4

=item Switch: B<-image>

Image to be used for the dialog button.

=back

=cut

sub Populate {
	my ($self,$args) = @_;
	$self->SUPER::Populate($args);
	$self->ConfigSpecs(
		-image => [$self->Subwidget('Select')],
		-background => ['SELF', 'DESCENDANTS'],
		DEFAULT => ['SELF'],
	);
}

sub createHandler {
	my ($self, $var) = @_;
	$self->SUPER::createHandler($var);
	my $b = $self->Button(
		-command => sub {
			my $file = $self->getOpenFile(
# 				-initialdir => $initdir,
# 				-popover => 'mainwindow',
			);
			if (defined $file) {
				my $var = $self->cget('-variable');
				$$var = $file
			}
		}
	)->pack(-side => 'left', -padx => 2, -pady => 2);
	$self->Advertise(Select => $b);
}

=head1 LICENSE

Same as Perl.

=head1 AUTHOR

Hans Jeuken (hanje at cpan dot org)

=head1 BUGS

Unknown. If you find any, please contact the author.

=head1 SEE ALSO

=over 4

=item L<Tk::TabbedForm>

=item L<Tk::TabbedForm::CBaseClass>

=item L<Tk::TabbedForm::CTextItem>

=back



=cut


1;

__END__
