package Tk::TabbedForm::CBooleanItem;

=head1 NAME

Tk::TabbedForm::CBooleanItem - Checkbutton widget for Tk::TabbedForm.

=cut

use strict;
use warnings;
use Tk;
use base qw(Tk::Derived Tk::TabbedForm::CBaseClass);
Construct Tk::Widget 'CBooleanItem';

=head1 SYNOPSIS

 require Tk::TabbedForm::CBaseooleanItem;
 my $bool = $window->CBooleanItem(@options)->pack;

=head1 DESCRIPTION

Inherits L<Tk::TabbedForm::CBaseClass>. Provides a Checkbutton field for L<Tk::TabbedForm>.

You should never create an instance directly like above. This should
be handled by L<Tk::TabbedForm>.

=head1 B<CONFIG VARIABLES>

All options, except I<-variable>, of L<Tk::Checkbutton> are available.

=cut

sub Populate {
	my ($self,$args) = @_;

	$self->SUPER::Populate($args);

	$self->ConfigSpecs(
		DEFAULT => [$self->Subwidget('Check')],
	);
}

sub createHandler {
	my ($self, $var) = @_;
	my $c = $self->Checkbutton(
		-variable => $var,
	)->pack(-side => 'left', -padx => 2);
	$self->Advertise(Check => $c);
}

=head1 LICENSE

Same as Perl.

=head1 AUTHOR

Hans Jeuken (hanje at cpan dot org)

=head1 BUGS

Unknown. If you find any, please contact the author.

=head1 SEE ALSO

=over 4

=item L<Tk::Checkbutton>

=item L<Tk::TabbedForm>

=item L<Tk::TabbedForm::CBaseClass>

=back

=cut

1;

__END__
