BEGIN {
  use strict; use warnings;
  unless(eval q{ use 5.010; 1}) {
    print "Perl 5.010 or better required\n";
    exit;
  }
}
# This file was automatically generated by Dist::Zilla::Plugin::Author::Plicease::MakeMaker v2.68.
use strict;
use warnings;
use 5.010;
use ExtUtils::MakeMaker;
use File::ShareDir::Install;

$File::ShareDir::Install::INCLUDE_DOTFILES = 1;
$File::ShareDir::Install::INCLUDE_DOTDIRS  = 1;
install_share dist => "share";

my %WriteMakefileArgs = (
  "ABSTRACT"           => "Simple asynchronous FTP client and server",
  "AUTHOR"             => "Graham Ollis <plicease\@cpan.org>",
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker"     => 0,
    "File::ShareDir::Install" => "0.06"
  },
  "DISTNAME"  => "AnyEvent-FTP",
  "EXE_FILES" => [
    "bin/aeftpd"
  ],
  "LICENSE"          => "perl",
  "MIN_PERL_VERSION" => "5.010",
  "NAME"             => "AnyEvent::FTP",
  "PM"               => {
    "lib/AnyEvent/FTP.pm"                                   => "\$(INST_LIB)/AnyEvent/FTP.pm",
    "lib/AnyEvent/FTP/Client.pm"                            => "\$(INST_LIB)/AnyEvent/FTP/Client.pm",
    "lib/AnyEvent/FTP/Client/Response.pm"                   => "\$(INST_LIB)/AnyEvent/FTP/Client/Response.pm",
    "lib/AnyEvent/FTP/Client/Role/FetchTransfer.pm"         => "\$(INST_LIB)/AnyEvent/FTP/Client/Role/FetchTransfer.pm",
    "lib/AnyEvent/FTP/Client/Role/ListTransfer.pm"          => "\$(INST_LIB)/AnyEvent/FTP/Client/Role/ListTransfer.pm",
    "lib/AnyEvent/FTP/Client/Role/RequestBuffer.pm"         => "\$(INST_LIB)/AnyEvent/FTP/Client/Role/RequestBuffer.pm",
    "lib/AnyEvent/FTP/Client/Role/ResponseBuffer.pm"        => "\$(INST_LIB)/AnyEvent/FTP/Client/Role/ResponseBuffer.pm",
    "lib/AnyEvent/FTP/Client/Role/StoreTransfer.pm"         => "\$(INST_LIB)/AnyEvent/FTP/Client/Role/StoreTransfer.pm",
    "lib/AnyEvent/FTP/Client/Site.pm"                       => "\$(INST_LIB)/AnyEvent/FTP/Client/Site.pm",
    "lib/AnyEvent/FTP/Client/Site/Base.pm"                  => "\$(INST_LIB)/AnyEvent/FTP/Client/Site/Base.pm",
    "lib/AnyEvent/FTP/Client/Site/Microsoft.pm"             => "\$(INST_LIB)/AnyEvent/FTP/Client/Site/Microsoft.pm",
    "lib/AnyEvent/FTP/Client/Site/NetFtpServer.pm"          => "\$(INST_LIB)/AnyEvent/FTP/Client/Site/NetFtpServer.pm",
    "lib/AnyEvent/FTP/Client/Site/Proftpd.pm"               => "\$(INST_LIB)/AnyEvent/FTP/Client/Site/Proftpd.pm",
    "lib/AnyEvent/FTP/Client/Transfer.pm"                   => "\$(INST_LIB)/AnyEvent/FTP/Client/Transfer.pm",
    "lib/AnyEvent/FTP/Client/Transfer/Active.pm"            => "\$(INST_LIB)/AnyEvent/FTP/Client/Transfer/Active.pm",
    "lib/AnyEvent/FTP/Client/Transfer/Passive.pm"           => "\$(INST_LIB)/AnyEvent/FTP/Client/Transfer/Passive.pm",
    "lib/AnyEvent/FTP/Request.pm"                           => "\$(INST_LIB)/AnyEvent/FTP/Request.pm",
    "lib/AnyEvent/FTP/Response.pm"                          => "\$(INST_LIB)/AnyEvent/FTP/Response.pm",
    "lib/AnyEvent/FTP/Role/Event.pm"                        => "\$(INST_LIB)/AnyEvent/FTP/Role/Event.pm",
    "lib/AnyEvent/FTP/Server.pm"                            => "\$(INST_LIB)/AnyEvent/FTP/Server.pm",
    "lib/AnyEvent/FTP/Server/Connection.pm"                 => "\$(INST_LIB)/AnyEvent/FTP/Server/Connection.pm",
    "lib/AnyEvent/FTP/Server/Context.pm"                    => "\$(INST_LIB)/AnyEvent/FTP/Server/Context.pm",
    "lib/AnyEvent/FTP/Server/Context/FS.pm"                 => "\$(INST_LIB)/AnyEvent/FTP/Server/Context/FS.pm",
    "lib/AnyEvent/FTP/Server/Context/FSRO.pm"               => "\$(INST_LIB)/AnyEvent/FTP/Server/Context/FSRO.pm",
    "lib/AnyEvent/FTP/Server/Context/FSRW.pm"               => "\$(INST_LIB)/AnyEvent/FTP/Server/Context/FSRW.pm",
    "lib/AnyEvent/FTP/Server/Context/Memory.pm"             => "\$(INST_LIB)/AnyEvent/FTP/Server/Context/Memory.pm",
    "lib/AnyEvent/FTP/Server/OS/UNIX.pm"                    => "\$(INST_LIB)/AnyEvent/FTP/Server/OS/UNIX.pm",
    "lib/AnyEvent/FTP/Server/Role/Auth.pm"                  => "\$(INST_LIB)/AnyEvent/FTP/Server/Role/Auth.pm",
    "lib/AnyEvent/FTP/Server/Role/Context.pm"               => "\$(INST_LIB)/AnyEvent/FTP/Server/Role/Context.pm",
    "lib/AnyEvent/FTP/Server/Role/Help.pm"                  => "\$(INST_LIB)/AnyEvent/FTP/Server/Role/Help.pm",
    "lib/AnyEvent/FTP/Server/Role/Old.pm"                   => "\$(INST_LIB)/AnyEvent/FTP/Server/Role/Old.pm",
    "lib/AnyEvent/FTP/Server/Role/ResponseEncoder.pm"       => "\$(INST_LIB)/AnyEvent/FTP/Server/Role/ResponseEncoder.pm",
    "lib/AnyEvent/FTP/Server/Role/TransferPrep.pm"          => "\$(INST_LIB)/AnyEvent/FTP/Server/Role/TransferPrep.pm",
    "lib/AnyEvent/FTP/Server/Role/Type.pm"                  => "\$(INST_LIB)/AnyEvent/FTP/Server/Role/Type.pm",
    "lib/AnyEvent/FTP/Server/UnambiguousResponseEncoder.pm" => "\$(INST_LIB)/AnyEvent/FTP/Server/UnambiguousResponseEncoder.pm",
    "lib/Test/AnyEventFTPServer.pm"                         => "\$(INST_LIB)/Test/AnyEventFTPServer.pm"
  },
  "PREREQ_PM" => {
    "AnyEvent"             => 0,
    "Capture::Tiny"        => 0,
    "File::ShareDir::Dist" => 0,
    "File::Which"          => 0,
    "File::chdir"          => 0,
    "Moo"                  => "2.0",
    "Path::Class"          => "0.26",
    "PerlIO::eol"          => 0,
    "Test2::API"           => "1.302015",
    "URI"                  => 0
  },
  "TEST_REQUIRES" => {
    "EV"        => 0,
    "Test2::V0" => "0.000121"
  },
  "VERSION" => "0.18",
  "test"    => {
    "TESTS" => "t/*.t"
  }
);

my %FallbackPrereqs = (
  "AnyEvent"             => 0,
  "Capture::Tiny"        => 0,
  "EV"                   => 0,
  "File::ShareDir::Dist" => 0,
  "File::Which"          => 0,
  "File::chdir"          => 0,
  "Moo"                  => "2.0",
  "Path::Class"          => "0.26",
  "PerlIO::eol"          => 0,
  "Test2::API"           => "1.302015",
  "Test2::V0"            => "0.000121",
  "URI"                  => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);

{
  package
    MY;
  use File::ShareDir::Install qw(postamble);
}