BEGIN {
  use strict; use warnings;
  my %missing = map {
    eval qq{ require $_ };
    $@ ? ($_=>1) : ()
  } qw( base strict warnings );
  if(%missing)
  {
    print "Your Perl is missing core modules: @{[ sort keys %missing ]}\n";
    print "Ideally if you are using the system Perl you can install the appropriate\n";
    print "package which includes the core Perl modules.  On at least some versions\n";
    print "of Fedora, CentOS and RHEL, this is the `perl-core` package.\n";
    print "\n";
    print " % dnf install perl-core\n";
    print "   ~ or ~\n";
    print " % yum install perl-core\n";
    print "\n";
    print "If you really want to install dual-life modules from CPAN, then you can\n";
    print "use cpanm:\n";
    print "\n";
    print " % cpanm @{[ sort keys %missing ]}\n";
    print "\n";
    print "Note that some core modules are not available from CPAN.\n";
    exit;
  }
}
BEGIN {
  use strict; use warnings;
  unless(eval q{ use 5.008001; 1}) {
    print "Perl 5.008001 or better required\n";
    exit;
  }
}
# This file was automatically generated by Dist::Zilla::Plugin::Author::Plicease::MakeMaker v2.59.
use strict;
use warnings;
use 5.008001;
use ExtUtils::MakeMaker;

my %WriteMakefileArgs = (
  "ABSTRACT"       => "Find or download wasmtime for use by other Perl modules",
  "AUTHOR"         => "Graham Ollis <plicease\@cpan.org>",
  "BUILD_REQUIRES" => {
    "Alien::Build"        => "0.32",
    "Alien::Build::MM"    => "0.32",
    "ExtUtils::MakeMaker" => "6.52"
  },
  "CONFIGURE_REQUIRES" => {
    "Alien::Build"                      => "1.19",
    "Alien::Build::MM"                  => "0.32",
    "Alien::Build::Plugin::Build::Copy" => 0,
    "ExtUtils::MakeMaker"               => "6.52",
    "Path::Tiny"                        => 0
  },
  "DISTNAME"         => "Alien-wasmtime",
  "LICENSE"          => "perl",
  "MIN_PERL_VERSION" => "5.008001",
  "NAME"             => "Alien::wasmtime",
  "PM"               => {
    "lib/Alien/wasmtime.pm" => "\$(INST_LIB)/Alien/wasmtime.pm"
  },
  "PREREQ_PM" => {
    "Alien::Base" => 0
  },
  "TEST_REQUIRES" => {
    "FFI::Platypus"     => "1.00",
    "File::Which"       => 0,
    "Test2::V0"         => "0.000060",
    "Test::Alien"       => "1.90",
    "Test::Alien::Diag" => 0
  },
  "VERSION" => "0.16",
  "test"    => {
    "TESTS" => "t/*.t"
  }
);

my %FallbackPrereqs = (
  "Alien::Base"         => 0,
  "Alien::Build"        => "0.32",
  "Alien::Build::MM"    => "0.32",
  "ExtUtils::MakeMaker" => "6.52",
  "FFI::Platypus"       => "1.00",
  "File::Which"         => 0,
  "Test2::V0"           => "0.000060",
  "Test::Alien"         => "1.90",
  "Test::Alien::Diag"   => 0
);

# BEGIN code inserted by Dist::Zilla::Plugin::AlienBuild
use Alien::Build::MM;
my $abmm = Alien::Build::MM->new;
%WriteMakefileArgs = $abmm->mm_args(%WriteMakefileArgs);

# END code inserted by Dist::Zilla::Plugin::AlienBuild

unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);

# BEGIN code inserted by Dist::Zilla::Plugin::AlienBuild
{ package
    MY;

  sub postamble {
    $abmm->mm_postamble(@_);
  }

  sub install {
    $abmm->can('mm_install')
      ? $abmm->mm_install(@_)
      : shift->SUPER::install(@_);
  }
}

# END code inserted by Dist::Zilla::Plugin::AlienBuild