#!/usr/bin/perl -w

#  You may distribute under the terms of either the GNU General Public License
#  or the Artistic License (the same terms as Perl itself)
#
#  (C) Paul Evans, 2007 -- leonerd@leonerd.org.uk

use strict;

my $h = "/usr/include/sys/systeminfo.h";
open( STDIN, "<", $h ) or die "Cannot read '$h' - $!";

if( @ARGV ) {
   open( STDOUT, ">", $ARGV[0] ) or die "Cannot write '$ARGV[0]' - $!";
}

print "package Solaris::SysInfo::Constants;\n";
print "# This file was automatically generated by make-constants.pl\n";
print "# on ".(scalar localtime)."\n";
print "\n";

my @names;

while( <STDIN> ) {
   next unless m/^#define\s+(SI_[^\s]+)\s+(\d+)/;
   print "use constant $1 => $2;\n";
   push @names, $1;
}

print "\n";

print "our \@NAMES = qw( " . join( " ", @names ) . " );\n";

print "\n";
print "1;\n";
