use lib 'inc';
use Devel::AssertOS qw[Linux];
# This Makefile.PL for Linux-NFS-BigDir was generated by
# Dist::Zilla::Plugin::MakeMaker::Awesome 0.38.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use 5.014004;
use ExtUtils::MakeMaker;

use Inline 0.80 C => <<'...';
#include <sys/syscall.h>
int _get_syscall_num() {
      return SYS_getdents;
}
...

use File::Spec;
open(my $out, '>>', File::Spec->catfile('lib', 'Linux', 'NFS', 'BigDir', 'Syscalls.pm')) or die "Cannot update Syscalls.pm: $!";
my $getdents_num = _get_syscall_num();
print $out <<BLOCK;
sub SYS_getdents {
    return $getdents_num;
}

1;
BLOCK
 close($out);

my %WriteMakefileArgs = (
  "ABSTRACT" => "use Linux getdents syscall to read large directories over NFS",
  "AUTHOR" => "Alceu Rodrigues de Freitas Junior <arfreitas\@cpan.org>",
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0
  },
  "DISTNAME" => "Linux-NFS-BigDir",
  "LICENSE" => "gpl",
  "MIN_PERL_VERSION" => "5.014004",
  "NAME" => "Linux::NFS::BigDir",
  "PREREQ_PM" => {
    "Exporter" => 0,
    "Fcntl" => 0,
    "Inline" => "0.80",
    "Inline::C" => "0.77",
    "constant" => 0
  },
  "TEST_REQUIRES" => {
    "Capture::Tiny" => "0.36",
    "Cwd" => 0,
    "ExtUtils::MakeMaker" => 0,
    "File::Spec" => 0,
    "File::Temp" => 0,
    "File::Which" => "1.21",
    "Test::More" => 0,
    "Test::TempDir::Tiny" => "0.016"
  },
  "VERSION" => "0.003",
  "test" => {
    "TESTS" => "t/*.t"
  }
);

my %FallbackPrereqs = (
  "Capture::Tiny" => "0.36",
  "Cwd" => 0,
  "Exporter" => 0,
  "ExtUtils::MakeMaker" => 0,
  "Fcntl" => 0,
  "File::Spec" => 0,
  "File::Temp" => 0,
  "File::Which" => "1.21",
  "Inline" => "0.80",
  "Inline::C" => "0.77",
  "Test::More" => 0,
  "Test::TempDir::Tiny" => "0.016",
  "constant" => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);
